/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.dflib.jjava.jupyter.kernel.BaseKernel;
import org.dflib.jjava.jupyter.kernel.JupyterIO;
import org.dflib.jjava.jupyter.kernel.comm.CommManager;
import org.dflib.jjava.jupyter.kernel.display.Renderer;
import org.dflib.jjava.jupyter.kernel.history.HistoryManager;
import org.dflib.jjava.jupyter.kernel.magic.CellMagic;
import org.dflib.jjava.jupyter.kernel.magic.LineMagic;
import org.dflib.jjava.jupyter.kernel.magic.MagicParser;
import org.dflib.jjava.jupyter.kernel.magic.MagicTranspiler;
import org.dflib.jjava.jupyter.kernel.magic.MagicsRegistry;
import org.dflib.jjava.jupyter.kernel.util.StringStyler;
import org.dflib.jjava.jupyter.kernel.util.TextColor;

public abstract class BaseKernelBuilder<B extends BaseKernelBuilder<B, K>, K extends BaseKernel> {
    protected String name;
    protected String version;
    protected Charset jupyterIOEncoding;
    protected MagicParser magicParser;
    protected MagicTranspiler magicTranspiler;
    protected HistoryManager historyManager;
    protected Boolean extensionsEnabled;
    protected final MagicsRegistry magicsRegistry = new MagicsRegistry();

    protected BaseKernelBuilder() {
    }

    public B name(String name) {
        this.name = name;
        return (B)this;
    }

    public B version(String version) {
        this.version = version;
        return (B)this;
    }

    public B jupyterIOEncoding(Charset jupyterIOEncoding) {
        this.jupyterIOEncoding = jupyterIOEncoding;
        return (B)this;
    }

    public B historyManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
        return (B)this;
    }

    public B lineMagic(String name, LineMagic<?, ?> magic) {
        this.magicsRegistry.registerLineMagic(name, magic);
        return (B)this;
    }

    public B cellMagic(String name, CellMagic<?, ?> magic) {
        this.magicsRegistry.registerCellMagic(name, magic);
        return (B)this;
    }

    public B magicParser(MagicParser magicParser) {
        this.magicParser = magicParser;
        return (B)this;
    }

    public B magicTranspiler(MagicTranspiler magicTranspiler) {
        this.magicTranspiler = magicTranspiler;
        return (B)this;
    }

    public B extensionsEnabled(boolean extensionsEnabled) {
        this.extensionsEnabled = extensionsEnabled;
        return (B)this;
    }

    public abstract K build();

    protected String buildName() {
        return this.name != null ? this.name : "";
    }

    protected String buildVersion() {
        return this.version != null ? this.version : "";
    }

    protected Charset buildJupyterIOEncoding() {
        return this.jupyterIOEncoding != null ? this.jupyterIOEncoding : StandardCharsets.UTF_8;
    }

    protected JupyterIO buildJupyterIO(Charset encoding) {
        return new JupyterIO(encoding);
    }

    protected CommManager buildCommManager() {
        return new CommManager();
    }

    protected Renderer buildRenderer() {
        return new Renderer();
    }

    protected boolean buildExtensionsEnabled() {
        return this.extensionsEnabled != null ? this.extensionsEnabled : true;
    }

    protected MagicsRegistry buildMagicsRegistry() {
        return this.magicsRegistry;
    }

    protected MagicTranspiler buildMagicTranspiler() {
        return this.magicTranspiler != null ? this.magicTranspiler : new MagicTranspiler();
    }

    protected StringStyler buildErrorStyler() {
        return new StringStyler.Builder().addPrimaryStyle(TextColor.BOLD_RESET_FG).addSecondaryStyle(TextColor.BOLD_RED_FG).addHighlightStyle(TextColor.BOLD_RESET_FG).addHighlightStyle(TextColor.RED_BG).withLinePrefix(String.valueOf((Object)TextColor.BOLD_RESET_FG) + "|   ").build();
    }

    protected HistoryManager buildHistoryManager() {
        return this.historyManager;
    }
}

