/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.magic;

import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dflib.jjava.jupyter.kernel.BaseNotebookStatics;
import org.dflib.jjava.jupyter.kernel.magic.ParsedCellMagic;
import org.dflib.jjava.jupyter.kernel.magic.ParsedLineMagic;

public class MagicTranspiler {
    private static final Pattern UNESCAPED_QUOTE = Pattern.compile("(?<!\\\\)\"");
    private static final String CELL_CALL_TEMPLATE = BaseNotebookStatics.class.getName() + ".cellMagic(%s,java.util.List.of(%s),%s);{};";
    private static final String LINE_CALL_TEMPLATE = BaseNotebookStatics.class.getName() + ".lineMagic(%s,java.util.List.of(%s));{};";
    private static final String DECODE_TEMPLATE = "new String(java.util.Base64.getDecoder().decode(\"%s\"))";

    public String transpileCell(ParsedCellMagic magic) {
        return String.format(CELL_CALL_TEMPLATE, this.argWithEscapingToJava(magic.magicCall.name), magic.magicCall.args.stream().map(this::argWithEscapingToJava).collect(Collectors.joining(",")), this.argWithEscapingToJava(magic.magicCall.body));
    }

    public String transpileLine(ParsedLineMagic magic) {
        boolean inString = false;
        Matcher m = UNESCAPED_QUOTE.matcher(magic.linePrefix);
        while (m.find()) {
            inString = !inString;
        }
        if (inString) {
            return magic.raw;
        }
        return String.format(LINE_CALL_TEMPLATE, this.argWithEscapingToJava(magic.magicCall.name), magic.magicCall.args.stream().map(this::argWithEscapingToJava).collect(Collectors.joining(",")));
    }

    private String argWithEscapingToJava(String arg) {
        String encoded = Base64.getEncoder().encodeToString(arg.getBytes());
        return String.format(DECODE_TEMPLATE, encoded);
    }
}

