/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.magic;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dflib.jjava.jupyter.kernel.BaseKernel;
import org.dflib.jjava.jupyter.kernel.magic.CellMagic;
import org.dflib.jjava.jupyter.kernel.magic.LineMagic;
import org.dflib.jjava.jupyter.kernel.magic.UndefinedMagicException;

public class MagicsRegistry {
    private final Map<String, LineMagic<?, ?>> lineMagics = new ConcurrentHashMap();
    private final Map<String, CellMagic<?, ?>> cellMagics = new ConcurrentHashMap();

    public MagicsRegistry registerLineMagic(String name, LineMagic<?, ?> magic) {
        this.lineMagics.put(name, magic);
        return this;
    }

    public MagicsRegistry registerCellMagic(String name, CellMagic<?, ?> magic) {
        this.cellMagics.put(name, magic);
        return this;
    }

    public <T, K extends BaseKernel> T evalLineMagic(K kernel, String name, List<String> args) throws Exception {
        LineMagic<?, ?> magic = this.lineMagics.get(name);
        if (magic == null) {
            throw new UndefinedMagicException(name, true);
        }
        return (T)magic.eval(kernel, args);
    }

    public <T, K extends BaseKernel> T evalCellMagic(K kernel, String name, List<String> args, String body) throws Exception {
        CellMagic<?, ?> magic = this.cellMagics.get(name);
        if (magic == null) {
            throw new UndefinedMagicException(name, false);
        }
        return (T)magic.eval(kernel, args, body);
    }

    public Set<String> getCellMagicNames() {
        return this.cellMagics.keySet();
    }

    public Set<String> getLineMagicNames() {
        return this.lineMagics.keySet();
    }
}

