/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import jdk.jshell.JShell;
import org.dflib.jjava.jupyter.kernel.BaseKernelBuilder;
import org.dflib.jjava.jupyter.kernel.LanguageInfo;
import org.dflib.jjava.jupyter.kernel.magic.MagicParser;
import org.dflib.jjava.jupyter.kernel.magic.MagicTranspiler;
import org.dflib.jjava.kernel.JavaKernel;
import org.dflib.jjava.kernel.execution.CodeEvaluator;
import org.dflib.jjava.kernel.execution.JJavaExecutionControlProvider;

public abstract class JavaKernelBuilder<B extends JavaKernelBuilder<B, K>, K extends JavaKernel>
extends BaseKernelBuilder<B, K> {
    protected final String jShellExecControlID = UUID.randomUUID().toString();
    protected JJavaExecutionControlProvider jShellExecControlProvider;
    protected String timeout;
    protected final List<String> startupSnippets = new ArrayList<String>();
    protected final List<String> compilerOpts = new ArrayList<String>();

    protected JavaKernelBuilder() {
    }

    public B jShellExecControlProvider(JJavaExecutionControlProvider jShellExecControlProvider) {
        this.jShellExecControlProvider = jShellExecControlProvider;
        return (B)this;
    }

    public B startupSnippets(Iterable<String> code) {
        code.forEach(this.startupSnippets::add);
        return (B)this;
    }

    public B compilerOpts(Iterable<String> opts) {
        opts.forEach(this.compilerOpts::add);
        return (B)this;
    }

    public B timeout(String timeout) {
        this.timeout = timeout;
        return (B)this;
    }

    @Override
    public abstract K build();

    protected JShell buildJShell(JJavaExecutionControlProvider jShellExecControlProvider) {
        HashMap<String, String> execControlParams = new HashMap<String, String>();
        execControlParams.put("registration-id", this.jShellExecControlID);
        if (this.timeout != null) {
            execControlParams.put("timeout", this.timeout);
        }
        return JShell.builder().out(System.out).err(System.err).in(System.in).executionEngine(jShellExecControlProvider, execControlParams).compilerOptions(this.compilerOpts.toArray(new String[0])).build();
    }

    protected CodeEvaluator buildCodeEvaluator(JShell jShell, JJavaExecutionControlProvider jShellExecControlProvider) {
        return new CodeEvaluator(jShell, jShellExecControlProvider, this.jShellExecControlID, this.startupSnippets);
    }

    protected MagicParser buildMagicParser(MagicTranspiler transpiler) {
        return this.magicParser != null ? this.magicParser : new MagicParser("(?<=(?:^|=))\\s*%", "%%", transpiler);
    }

    protected LanguageInfo buildLanguageInfo() {
        return new LanguageInfo.Builder("Java").version(Runtime.version().toString()).mimetype("text/x-java-source").fileExtension(".jshell").pygments("java").codemirror("java").build();
    }

    protected JJavaExecutionControlProvider buildJShellExecControlProvider(String name) {
        return this.jShellExecControlProvider != null ? this.jShellExecControlProvider : new JJavaExecutionControlProvider(name);
    }
}

