/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.execution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import org.dflib.jjava.kernel.execution.CompilationException;
import org.dflib.jjava.kernel.execution.EvaluationInterruptedException;
import org.dflib.jjava.kernel.execution.EvaluationTimeoutException;
import org.dflib.jjava.kernel.execution.IncompleteSourceException;
import org.dflib.jjava.kernel.execution.JJavaExecutionControl;
import org.dflib.jjava.kernel.execution.JJavaExecutionControlProvider;

public class CodeEvaluator {
    private static final Pattern WHITESPACE_PREFIX = Pattern.compile("(?:^|\r?\n)(?<ws>\\s*).*$");
    private static final Pattern LAST_LINE = Pattern.compile("(?:^|\r?\n)(?<last>.*)$");
    private static final String NO_MAGIC_RETURN = "\"__NO_MAGIC_RETURN\"";
    private static final Method SNIPPET_CLASS_NAME_METHOD;
    private static final String INDENTATION = "  ";
    private final JShell shell;
    private final JJavaExecutionControlProvider execControlProvider;
    private final String execControlID;
    private final SourceCodeAnalysis sourceAnalyzer;
    private final List<String> startupSnippets;
    private volatile boolean initialized;

    public CodeEvaluator(JShell shell, JJavaExecutionControlProvider execControlProvider, String execControlID, List<String> startupSnippets) {
        this.shell = shell;
        this.execControlProvider = execControlProvider;
        this.execControlID = execControlID;
        this.sourceAnalyzer = shell.sourceCodeAnalysis();
        this.startupSnippets = startupSnippets;
    }

    private SourceCodeAnalysis.CompletionInfo analyzeCompletion(String source) {
        return this.sourceAnalyzer.analyzeCompletion(source);
    }

    protected Object evalSingle(String code) {
        JJavaExecutionControl executionControl = this.execControlProvider.getRegisteredControlByID(this.execControlID);
        List<SnippetEvent> events = this.shell.eval(code);
        Object result = null;
        block11: for (SnippetEvent event : events) {
            if (event.status() == Snippet.Status.OVERWRITTEN) {
                this.dropSnippet(event.snippet());
                continue;
            }
            String key = event.value();
            if (key == null) continue;
            Snippet.SubKind subKind = event.snippet().subKind();
            Object value = subKind.isExecutable() ? executionControl.takeResult(key) : event.value();
            switch (subKind) {
                case VAR_VALUE_SUBKIND: 
                case OTHER_EXPRESSION_SUBKIND: 
                case TEMP_VAR_EXPRESSION_SUBKIND: {
                    result = NO_MAGIC_RETURN.equals(value) ? null : value;
                    continue block11;
                }
            }
            result = null;
        }
        for (SnippetEvent event : events) {
            if (event.causeSnippet() != null) continue;
            JShellException e = event.exception();
            if (e != null) {
                if (e instanceof EvalException) {
                    EvalException ee = (EvalException)e;
                    switch (ee.getExceptionClassName()) {
                        case "Execution Timeout": {
                            throw new EvaluationTimeoutException(executionControl.getTimeoutDuration(), executionControl.getTimeoutUnit(), code.trim());
                        }
                        case "Execution Interrupted": {
                            throw new EvaluationInterruptedException(code.trim());
                        }
                    }
                    throw new RuntimeException(ee.getExceptionClassName() + ", " + e.getMessage(), e);
                }
                throw new RuntimeException(e);
            }
            if (event.status().isDefined()) continue;
            throw new CompilationException(event);
        }
        return result;
    }

    public Object eval(String code) {
        this.initIfNeeded();
        return this.doEval(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (!this.initialized) {
            CodeEvaluator codeEvaluator = this;
            synchronized (codeEvaluator) {
                if (!this.initialized) {
                    for (String s : this.startupSnippets) {
                        this.doEval(s);
                    }
                    this.startupSnippets.clear();
                    this.initialized = true;
                }
            }
        }
    }

    private Object doEval(String code) {
        Object lastEvalResult = null;
        SourceCodeAnalysis.CompletionInfo info = this.sourceAnalyzer.analyzeCompletion(code);
        while (info.completeness().isComplete()) {
            lastEvalResult = this.evalSingle(info.source());
            info = this.analyzeCompletion(info.remaining());
        }
        if (info.completeness() != SourceCodeAnalysis.Completeness.EMPTY) {
            throw new IncompleteSourceException(info.remaining().trim());
        }
        return lastEvalResult;
    }

    private void dropSnippet(Snippet snippet) {
        JJavaExecutionControl execControl = this.execControlProvider.getRegisteredControlByID(this.execControlID);
        this.shell.drop(snippet);
        String className = this.snippetClassName(snippet);
        if (this.shell.snippets().map(this::snippetClassName).noneMatch(className::equals)) {
            execControl.unloadClass(className);
        }
    }

    private String snippetClassName(Snippet snippet) {
        try {
            return SNIPPET_CLASS_NAME_METHOD.invoke((Object)snippet, new Object[0]).toString();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String computeIndentation(String partialStatement) {
        Matcher m = WHITESPACE_PREFIX.matcher(partialStatement);
        String currentIndentation = m.find() ? m.group("ws") : "";
        m = LAST_LINE.matcher(partialStatement);
        if (!m.find()) {
            throw new Error("Pattern broken. Every string should have a last line.");
        }
        String lastLine = m.group("last");
        int newlyOpenedBraces = -1;
        int newlyOpenedParens = -1;
        block6: for (int i = 0; i < lastLine.length(); ++i) {
            switch (lastLine.charAt(i)) {
                case '}': {
                    if (newlyOpenedBraces == -1) continue block6;
                    --newlyOpenedBraces;
                    continue block6;
                }
                case ')': {
                    if (newlyOpenedParens == -1) continue block6;
                    --newlyOpenedParens;
                    continue block6;
                }
                case '{': {
                    if (newlyOpenedBraces == -1) {
                        ++newlyOpenedBraces;
                    }
                    ++newlyOpenedBraces;
                    continue block6;
                }
                case '(': {
                    if (newlyOpenedParens == -1) {
                        ++newlyOpenedParens;
                    }
                    ++newlyOpenedParens;
                }
            }
        }
        return newlyOpenedBraces > 0 || newlyOpenedParens > 0 ? currentIndentation + INDENTATION : currentIndentation;
    }

    public String isComplete(String code) {
        SourceCodeAnalysis.CompletionInfo info = this.sourceAnalyzer.analyzeCompletion(code);
        while (info.completeness().isComplete()) {
            info = this.analyzeCompletion(info.remaining());
        }
        switch (info.completeness()) {
            case UNKNOWN: {
                return "invalid";
            }
            case COMPLETE: 
            case COMPLETE_WITH_SEMI: 
            case EMPTY: {
                return "complete";
            }
            case CONSIDERED_INCOMPLETE: 
            case DEFINITELY_INCOMPLETE: {
                return this.computeIndentation(info.remaining());
            }
        }
        return "unknown";
    }

    public void interrupt() {
        JJavaExecutionControl execControl = this.execControlProvider.getRegisteredControlByID(this.execControlID);
        if (execControl != null) {
            execControl.interrupt();
        }
    }

    public ClassLoader getClassLoader() {
        JJavaExecutionControl execControl = this.execControlProvider.getRegisteredControlByID(this.execControlID);
        return execControl != null ? execControl.getClassLoader() : null;
    }

    static {
        try {
            SNIPPET_CLASS_NAME_METHOD = Snippet.class.getDeclaredMethod("classFullName", new Class[0]);
            SNIPPET_CLASS_NAME_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to access jdk.jshell.Snippet.classFullName() method.", e);
        }
    }
}

