/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.execution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.jshell.execution.DirectExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.SPIResolutionException;
import org.dflib.jjava.kernel.execution.JJavaLoaderDelegate;

public class JJavaExecutionControl
extends DirectExecutionControl {
    public static final String EXECUTION_TIMEOUT_NAME = "Execution Timeout";
    public static final String EXECUTION_INTERRUPTED_NAME = "Execution Interrupted";
    private static final AtomicInteger EXECUTOR_THREAD_ID = new AtomicInteger(0);
    private final ExecutorService executor;
    private final long timeoutDuration;
    private final TimeUnit timeoutUnit;
    private final Map<String, Future<Object>> running;
    private final Map<String, Object> results;
    private final JJavaLoaderDelegate loaderDelegate;

    public JJavaExecutionControl(JJavaLoaderDelegate loaderDelegate, long timeoutDuration, TimeUnit timeoutUnit) {
        super(loaderDelegate);
        this.loaderDelegate = loaderDelegate;
        this.running = new ConcurrentHashMap<String, Future<Object>>();
        this.results = new ConcurrentHashMap<String, Object>();
        this.timeoutDuration = timeoutDuration;
        this.timeoutUnit = timeoutDuration > 0L ? Objects.requireNonNull(timeoutUnit) : TimeUnit.MILLISECONDS;
        this.executor = Executors.newCachedThreadPool(r -> new Thread(r, "JJava-executor-" + EXECUTOR_THREAD_ID.getAndIncrement()));
    }

    public ClassLoader getClassLoader() {
        return this.loaderDelegate.getClassLoader();
    }

    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    @Override
    protected String invoke(Method doitMethod) throws Exception {
        String id = UUID.randomUUID().toString();
        Object value = this.execute(id, doitMethod);
        this.results.put(id, value);
        return id;
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    public Object takeResult(String key) {
        Object result = this.results.remove(key);
        if (result == null) {
            throw new IllegalStateException("No result with key: " + key);
        }
        return result;
    }

    public void unloadClass(String className) {
        this.loaderDelegate.unloadClass(className);
    }

    public void interrupt() {
        this.running.forEach((id, f) -> f.cancel(true));
    }

    public String toString() {
        return "JJavaExecutionControl{timeoutTime=" + this.timeoutDuration + ", timeoutUnit=" + String.valueOf((Object)this.timeoutUnit) + "}";
    }

    private Object execute(String key, Method doitMethod) throws Exception {
        Future<Object> runningTask = this.executor.submit(() -> doitMethod.invoke(null, new Object[0]));
        this.running.put(key, runningTask);
        try {
            Object object = this.timeoutDuration > 0L ? runningTask.get(this.timeoutDuration, this.timeoutUnit) : runningTask.get();
            return object;
        }
        catch (CancellationException e) {
            if (this.executor.isShutdown()) {
                throw new ExecutionControl.StoppedException();
            }
            throw new ExecutionControl.UserException("Execution interrupted.", EXECUTION_INTERRUPTED_NAME, e.getStackTrace());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            if (cause == null) {
                throw new ExecutionControl.UserException("null", "Unknown Invocation Exception", e.getStackTrace());
            }
            if (cause instanceof SPIResolutionException) {
                throw new ExecutionControl.ResolutionException(((SPIResolutionException)cause).id(), cause.getStackTrace());
            }
            throw new ExecutionControl.UserException(String.valueOf(cause.getMessage()), cause.getClass().getName(), cause.getStackTrace());
        }
        catch (TimeoutException e) {
            throw new ExecutionControl.UserException(String.format("Execution timed out after configured timeout of %d %s.", this.timeoutDuration, this.timeoutUnit.toString().toLowerCase()), EXECUTION_TIMEOUT_NAME, e.getStackTrace());
        }
        finally {
            this.running.remove(key, runningTask);
        }
    }
}

