/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.Context;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.ContextOverrides;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.Runtime;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.Runtimes;
import org.dflib.jjava.shaded.org.apache.maven.model.Dependency;
import org.dflib.jjava.shaded.org.apache.maven.model.Model;
import org.dflib.jjava.shaded.org.apache.maven.model.building.DefaultModelBuilder;
import org.dflib.jjava.shaded.org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.dflib.jjava.shaded.org.eclipse.aether.RepositorySystemSession;
import org.dflib.jjava.shaded.org.eclipse.aether.artifact.Artifact;
import org.dflib.jjava.shaded.org.eclipse.aether.artifact.DefaultArtifact;
import org.dflib.jjava.shaded.org.eclipse.aether.collection.CollectRequest;
import org.dflib.jjava.shaded.org.eclipse.aether.graph.DependencyNode;
import org.dflib.jjava.shaded.org.eclipse.aether.repository.RemoteRepository;
import org.dflib.jjava.shaded.org.eclipse.aether.resolution.DependencyRequest;
import org.dflib.jjava.shaded.org.eclipse.aether.resolution.DependencyResolutionException;
import org.dflib.jjava.shaded.org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public class MavenDependencyResolver {
    private static final String MAVEN_CENTRAL_URL = "https://repo1.maven.org/maven2/";
    private static final String DEFAULT_RESOLVER_NAME = "default";
    @Deprecated(since="1.0", forRemoval=true)
    private static final Pattern IVY_MRID_PATTERN = Pattern.compile("^(?<organization>[-\\w/._+=]*)#(?<name>[-\\w/._+=]+)(?:#(?<branch>[-\\w/._+=]+))?;(?<revision>[-\\w/._+=,\\[\\]{}():@]+)$");
    private final List<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
    private final Runtime runtime = Runtimes.INSTANCE.getRuntime();

    private static RemoteRepository mavenRepo(String id, String url) {
        return new RemoteRepository.Builder(id, DEFAULT_RESOLVER_NAME, url).build();
    }

    private static Artifact parseArtifact(String coordinates) {
        Matcher ivyMatcher = IVY_MRID_PATTERN.matcher(coordinates);
        return ivyMatcher.matches() ? MavenDependencyResolver.parseIvyArtifact(ivyMatcher, coordinates) : new DefaultArtifact(coordinates);
    }

    @Deprecated(since="1.0", forRemoval=true)
    private static Artifact parseIvyArtifact(Matcher matcher, String coordinates) {
        System.err.println("Detected Ivy artifact syntax in the '%maven' magic arguments: '" + coordinates + "'. Support for it is deprecated and will be removed in the future versions of JJava. Use Maven colon-separated syntax instead");
        String organization = matcher.group("organization");
        String name = matcher.group("name");
        String revision = matcher.group("revision");
        return new DefaultArtifact(organization, name, "jar", revision);
    }

    public MavenDependencyResolver() {
        this.repositories.add(MavenDependencyResolver.mavenRepo("central", MAVEN_CENTRAL_URL));
    }

    public void addRemoteRepo(String name, String url) {
        if (DEFAULT_RESOLVER_NAME.equals(name)) {
            throw new IllegalArgumentException("Illegal repository name, cannot use 'default'.");
        }
        this.repositories.add(MavenDependencyResolver.mavenRepo(name, url));
    }

    public Map<String, List<String>> loadDependencies(List<String> repoUrls, List<String> deps) {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (String urlString : repoUrls) {
            try {
                URL url = new URL(urlString);
                repos.add(MavenDependencyResolver.mavenRepo("from-" + url.getHost(), url.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        LinkedHashMap<String, List<String>> resolved = new LinkedHashMap<String, List<String>>();
        deps.forEach(d -> resolved.put((String)d, this.resolveDependency((String)d, (List<RemoteRepository>)repos)));
        return resolved;
    }

    public Map<String, List<String>> loadPomDependencies(File pomFile) {
        Model model = this.pomToModel(pomFile);
        List<RemoteRepository> repos = model.getRepositories().stream().map(repo -> new RemoteRepository.Builder(repo.getId(), repo.getName(), repo.getUrl()).build()).collect(Collectors.toList());
        LinkedHashMap<String, List<String>> resolved = new LinkedHashMap<String, List<String>>();
        for (Dependency dep : model.getDependencies()) {
            String coordinates = dep.getManagementKey() + ":" + dep.getVersion();
            resolved.put(coordinates, this.resolveDependency(coordinates, repos));
        }
        return resolved;
    }

    private List<String> resolveDependency(String coordinates, List<RemoteRepository> repositories) {
        ContextOverrides overrides = ContextOverrides.create().withUserSettings(true).repositories(repositories.isEmpty() ? this.repositories : repositories).build();
        try (Context context = this.runtime.create(overrides);){
            DependencyNode rootNode = this.resolveDependency(context, coordinates);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            rootNode.accept(nlg);
            List<String> list = PathsHandler.split(nlg.getClassPath()).stream().map(File::new).map(File::getAbsolutePath).collect(Collectors.toList());
            return list;
        }
    }

    private DependencyNode resolveDependency(Context context, String coordinates) {
        Artifact artifact = MavenDependencyResolver.parseArtifact(coordinates);
        org.dflib.jjava.shaded.org.eclipse.aether.graph.Dependency dependency = new org.dflib.jjava.shaded.org.eclipse.aether.graph.Dependency(artifact, "runtime");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        collectRequest.setRepositories(context.remoteRepositories());
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        RepositorySystemSession session = context.repositorySystemSession();
        try {
            return context.repositorySystem().resolveDependencies(session, dependencyRequest).getRoot();
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException("Error resolving dependency: " + coordinates, e);
        }
    }

    private Model pomToModel(File pomFile) {
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        try {
            return modelBuilder.buildRawModel(pomFile, 30, true).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process POM file: " + String.valueOf(pomFile), e);
        }
    }
}

