/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.maven.magics;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dflib.jjava.jupyter.kernel.magic.CellMagic;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;
import org.dflib.jjava.kernel.JavaKernel;
import org.dflib.jjava.maven.MavenDependencyResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LoadFromPomCellMagic
implements CellMagic<List<String>, JavaKernel> {
    private final MavenDependencyResolver mavenResolver;

    public LoadFromPomCellMagic(MavenDependencyResolver mavenResolver) {
        this.mavenResolver = mavenResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> eval(JavaKernel kernel, List<String> args, String body) throws Exception {
        String rawPom = this.solidifyPartialPOM(body);
        File tempPomPath = File.createTempFile("jjava-maven-", ".pom").getAbsoluteFile();
        try {
            Files.write(tempPomPath.toPath(), rawPom.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            List<String> deps = this.mavenResolver.loadPomDependencies(tempPomPath).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            kernel.addToClasspath(PathsHandler.joinStringPaths(deps));
            List<String> list = deps;
            return list;
        }
        finally {
            tempPomPath.delete();
        }
    }

    private String solidifyPartialPOM(String rawIn) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        SequenceInputStream inStream = new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream("<jjava>".getBytes(StandardCharsets.UTF_8)), new ByteArrayInputStream(rawIn.getBytes(StandardCharsets.UTF_8)), new ByteArrayInputStream("</jjava>".getBytes(StandardCharsets.UTF_8)))));
        Document doc = builder.parse(inStream);
        NodeList rootChildren = doc.getDocumentElement().getChildNodes();
        if (rootChildren.getLength() == 1 && "project".equalsIgnoreCase(rootChildren.item(0).getNodeName())) {
            return this.writeDOM(new DOMSource(rootChildren.item(0)));
        }
        Document fixed = builder.newDocument();
        Node project = fixed.appendChild(fixed.createElement("project"));
        Node dependencies = project.appendChild(fixed.createElement("dependencies"));
        Node repositories = project.appendChild(fixed.createElement("repositories"));
        boolean setModelVersion = false;
        boolean setGroupId = false;
        boolean setArtifactId = false;
        boolean setVersion = false;
        block20: for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node child = rootChildren.item(i);
            switch (child.getNodeName()) {
                case "modelVersion": {
                    setModelVersion = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "groupId": {
                    setGroupId = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "artifactId": {
                    setArtifactId = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "version": {
                    setVersion = true;
                    this.appendChildInNewDoc(child, fixed, project);
                    continue block20;
                }
                case "dependency": {
                    this.appendChildInNewDoc(child, fixed, dependencies);
                    continue block20;
                }
                case "repository": {
                    this.appendChildInNewDoc(child, fixed, repositories);
                    continue block20;
                }
                case "dependencies": {
                    NodeList dependencyChildren = child.getChildNodes();
                    for (int j = 0; j < dependencyChildren.getLength(); ++j) {
                        this.appendChildInNewDoc(dependencyChildren.item(j), fixed, dependencies);
                    }
                    continue block20;
                }
                case "repositories": {
                    NodeList repositoryChildren = child.getChildNodes();
                    for (int j = 0; j < repositoryChildren.getLength(); ++j) {
                        this.appendChildInNewDoc(repositoryChildren.item(j), fixed, repositories);
                    }
                    continue block20;
                }
                default: {
                    this.appendChildInNewDoc(child, fixed, project);
                }
            }
        }
        if (!setModelVersion) {
            Node modelVersion = project.appendChild(fixed.createElement("modelVersion"));
            modelVersion.setTextContent("4.0.0");
        }
        if (!setGroupId) {
            Node groupId = project.appendChild(fixed.createElement("groupId"));
            groupId.setTextContent("jjava.notebook");
        }
        if (!setArtifactId) {
            Node artifactId = project.appendChild(fixed.createElement("artifactId"));
            artifactId.setTextContent("cell");
        }
        if (!setVersion) {
            Node version = project.appendChild(fixed.createElement("version"));
            version.setTextContent("1");
        }
        return this.writeDOM(new DOMSource(fixed));
    }

    private void appendChildInNewDoc(Node oldNode, Document doc, Node newParent) {
        Node newNode = oldNode.cloneNode(true);
        doc.adoptNode(newNode);
        newParent.appendChild(newNode);
    }

    private String writeDOM(Source src) throws TransformerException {
        Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
        idTransformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult dest = new StreamResult(out);
        idTransformer.transform(src, dest);
        return out.toString(StandardCharsets.UTF_8);
    }
}

