/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.maven.magics;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dflib.jjava.jupyter.kernel.magic.LineMagic;
import org.dflib.jjava.jupyter.kernel.magic.MagicsArgs;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;
import org.dflib.jjava.kernel.JavaKernel;
import org.dflib.jjava.maven.MavenDependencyResolver;

public class LoadFromPomLineMagic
implements LineMagic<List<String>, JavaKernel> {
    private final MavenDependencyResolver mavenResolver;

    public LoadFromPomLineMagic(MavenDependencyResolver mavenResolver) {
        this.mavenResolver = mavenResolver;
    }

    @Override
    public List<String> eval(JavaKernel kernel, List<String> args) {
        if (args.isEmpty()) {
            throw new IllegalArgumentException("Loading from POM requires at least the path to the POM file");
        }
        MagicsArgs argsSchema = MagicsArgs.builder().required("pomPath").onlyKnownKeywords().onlyKnownFlags().build();
        Map<String, List<String>> argsParsed = argsSchema.parse(args);
        File pomFile = new File(argsParsed.get("pomPath").get(0));
        List<String> deps = this.mavenResolver.loadPomDependencies(pomFile).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        kernel.addToClasspath(PathsHandler.joinStringPaths(deps));
        return deps;
    }
}

