/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.ContextOverrides;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.HTTPProxy;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.MavenSystemHome;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.MavenUserHome;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import org.dflib.jjava.shaded.org.eclipse.aether.RepositorySystem;
import org.dflib.jjava.shaded.org.eclipse.aether.RepositorySystemSession;
import org.dflib.jjava.shaded.org.eclipse.aether.repository.RemoteRepository;

public final class Context
implements Closeable {
    private final RuntimeSupport runtime;
    private final ContextOverrides contextOverrides;
    private final Path basedir;
    private final MavenUserHome mavenUserHome;
    private final MavenSystemHome mavenSystemHome;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;
    private final HTTPProxy httpProxy;
    private final Runnable managedCloser;

    public Context(RuntimeSupport runtime, ContextOverrides contextOverrides, Path basedir, MavenUserHome mavenUserHome, MavenSystemHome mavenSystemHome, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories, HTTPProxy httpProxy, Runnable managedCloser) {
        this.runtime = Objects.requireNonNull(runtime);
        this.contextOverrides = Objects.requireNonNull(contextOverrides);
        this.basedir = Objects.requireNonNull(basedir);
        this.mavenUserHome = Objects.requireNonNull(mavenUserHome);
        this.mavenSystemHome = mavenSystemHome;
        this.repositorySystemSession = Objects.requireNonNull(repositorySystemSession);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories);
        this.httpProxy = httpProxy;
        this.managedCloser = managedCloser;
    }

    public ContextOverrides contextOverrides() {
        return this.contextOverrides;
    }

    public Path basedir() {
        return this.basedir;
    }

    public MavenUserHome mavenUserHome() {
        return this.mavenUserHome;
    }

    public MavenSystemHome mavenSystemHome() {
        return this.mavenSystemHome;
    }

    public RepositorySystemSession repositorySystemSession() {
        return this.repositorySystemSession;
    }

    public RepositorySystem repositorySystem() {
        return this.repositorySystem;
    }

    public List<RemoteRepository> remoteRepositories() {
        return this.remoteRepositories;
    }

    public HTTPProxy httpProxy() {
        return this.httpProxy;
    }

    public Context customize(ContextOverrides overrides) {
        return this.runtime.customizeContext(overrides, this, false);
    }

    @Override
    public void close() {
        if (this.managedCloser != null) {
            this.managedCloser.run();
        }
    }
}

