/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.dflib.jjava.shaded.eu.maveniverse.maven.mima.context.Runtime;

public final class Runtimes {
    public static final Runtimes INSTANCE = new Runtimes();
    private final TreeSet<Runtime> runtimes = new TreeSet<Runtime>(Comparator.comparing(Runtime::priority));

    private Runtimes() {
    }

    public synchronized Runtime getRuntime() {
        Runtime result = null;
        if (!this.runtimes.isEmpty()) {
            result = this.runtimes.first();
        }
        if (result == null) {
            ServiceLoader<Runtime> loader = ServiceLoader.load(Runtime.class);
            loader.iterator().forEachRemaining(this::registerRuntime);
            if (this.runtimes.isEmpty()) {
                throw new IllegalStateException("No Runtime implementation found on classpath");
            }
            result = this.runtimes.first();
        }
        return result;
    }

    public synchronized Collection<Runtime> getRuntimes() {
        TreeSet<Runtime> result = new TreeSet<Runtime>(Comparator.comparing(Runtime::priority));
        result.addAll(this.runtimes);
        return Collections.unmodifiableSet(result);
    }

    public synchronized void registerRuntime(Runtime mimaRuntime) {
        Objects.requireNonNull(mimaRuntime);
        if (this.runtimes.stream().map(Runtime::name).noneMatch(n -> n.equals(mimaRuntime.name()))) {
            this.runtimes.add(mimaRuntime);
        }
    }

    public synchronized void resetRuntimes() {
        this.runtimes.clear();
    }
}

