/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.aether.spi.connector;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dflib.jjava.shaded.org.eclipse.aether.RequestTrace;
import org.dflib.jjava.shaded.org.eclipse.aether.artifact.Artifact;
import org.dflib.jjava.shaded.org.eclipse.aether.repository.RemoteRepository;
import org.dflib.jjava.shaded.org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.dflib.jjava.shaded.org.eclipse.aether.transfer.ArtifactTransferException;
import org.dflib.jjava.shaded.org.eclipse.aether.transfer.TransferListener;

public final class ArtifactDownload
extends ArtifactTransfer {
    private boolean existenceCheck;
    private String checksumPolicy = "";
    private String context = "";
    private Collection<String> contexts;
    private List<RemoteRepository> repositories = Collections.emptyList();

    public ArtifactDownload() {
    }

    public ArtifactDownload(Artifact artifact, String context, File file, String checksumPolicy) {
        this.setArtifact(artifact);
        this.setRequestContext(context);
        this.setFile(file);
        this.setChecksumPolicy(checksumPolicy);
    }

    @Override
    public ArtifactDownload setArtifact(Artifact artifact) {
        super.setArtifact(artifact);
        return this;
    }

    @Override
    public ArtifactDownload setFile(File file) {
        super.setFile(file);
        return this;
    }

    public boolean isExistenceCheck() {
        return this.existenceCheck;
    }

    public ArtifactDownload setExistenceCheck(boolean existenceCheck) {
        this.existenceCheck = existenceCheck;
        return this;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public ArtifactDownload setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy != null ? checksumPolicy : "";
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public ArtifactDownload setRequestContext(String context) {
        this.context = context != null ? context : "";
        return this;
    }

    public Collection<String> getSupportedContexts() {
        return this.contexts != null ? this.contexts : Collections.singleton(this.context);
    }

    public ArtifactDownload setSupportedContexts(Collection<String> contexts) {
        this.contexts = contexts == null || contexts.isEmpty() ? Collections.singleton(this.context) : contexts;
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactDownload setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    @Override
    public ArtifactDownload setException(ArtifactTransferException exception) {
        super.setException(exception);
        return this;
    }

    @Override
    public ArtifactDownload setListener(TransferListener listener) {
        super.setListener(listener);
        return this;
    }

    @Override
    public ArtifactDownload setTrace(RequestTrace trace) {
        super.setTrace(trace);
        return this;
    }

    public String toString() {
        return this.getArtifact() + " - " + (this.isExistenceCheck() ? "?" : "") + this.getFile();
    }
}

