/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.aether.spi.connector.layout;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.dflib.jjava.shaded.org.eclipse.aether.artifact.Artifact;
import org.dflib.jjava.shaded.org.eclipse.aether.metadata.Metadata;
import org.dflib.jjava.shaded.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

public interface RepositoryLayout {
    public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories();

    public boolean hasChecksums(Artifact var1);

    public URI getLocation(Artifact var1, boolean var2);

    public URI getLocation(Metadata var1, boolean var2);

    public List<ChecksumLocation> getChecksumLocations(Artifact var1, boolean var2, URI var3);

    public List<ChecksumLocation> getChecksumLocations(Metadata var1, boolean var2, URI var3);

    public static final class ChecksumLocation {
        private final URI location;
        private final ChecksumAlgorithmFactory checksumAlgorithmFactory;

        public ChecksumLocation(URI location, ChecksumAlgorithmFactory checksumAlgorithmFactory) {
            ChecksumLocation.verify(location, checksumAlgorithmFactory);
            this.location = location;
            this.checksumAlgorithmFactory = checksumAlgorithmFactory;
        }

        public static ChecksumLocation forLocation(URI location, ChecksumAlgorithmFactory checksumAlgorithmFactory) {
            ChecksumLocation.verify(location, checksumAlgorithmFactory);
            if (location.getRawQuery() != null) {
                throw new IllegalArgumentException("resource location must not have query parameters: " + location);
            }
            if (location.getRawFragment() != null) {
                throw new IllegalArgumentException("resource location must not have a fragment: " + location);
            }
            return new ChecksumLocation(URI.create(location + "." + checksumAlgorithmFactory.getFileExtension()), checksumAlgorithmFactory);
        }

        private static void verify(URI location, ChecksumAlgorithmFactory checksumAlgorithmFactory) {
            Objects.requireNonNull(location, "checksum location cannot be null");
            if (location.isAbsolute()) {
                throw new IllegalArgumentException("checksum location must be relative");
            }
            Objects.requireNonNull(checksumAlgorithmFactory, "checksum algorithm factory cannot be null");
        }

        public ChecksumAlgorithmFactory getChecksumAlgorithmFactory() {
            return this.checksumAlgorithmFactory;
        }

        public URI getLocation() {
            return this.location;
        }

        public String toString() {
            return this.location + " (" + this.checksumAlgorithmFactory.getName() + ")";
        }
    }
}

