/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.sisu.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.dflib.jjava.shaded.org.eclipse.sisu.PostConstruct;
import org.dflib.jjava.shaded.org.eclipse.sisu.PreDestroy;
import org.dflib.jjava.shaded.org.eclipse.sisu.bean.BeanLifecycle;

final class LifecycleBuilder {
    private static final boolean HAS_JSR250_ANNOTATIONS;
    private final List<Method> startMethods = new ArrayList<Method>();
    private final List<Method> stopMethods = new ArrayList<Method>();
    private final List<Class<?>> hierarchy = new ArrayList();

    LifecycleBuilder() {
    }

    public synchronized BeanLifecycle build(Class<?> clazz) {
        try {
            BeanLifecycle beanLifecycle;
            for (Class<?> c = clazz; null != c && c != Object.class; c = c.getSuperclass()) {
                this.addLifecycleMethods(c);
            }
            if (this.startMethods.isEmpty() && this.stopMethods.isEmpty()) {
                beanLifecycle = BeanLifecycle.NO_OP;
                return beanLifecycle;
            }
            beanLifecycle = new BeanLifecycle(this.startMethods, this.stopMethods);
            return beanLifecycle;
        }
        finally {
            this.startMethods.clear();
            this.stopMethods.clear();
            this.hierarchy.clear();
        }
    }

    private void addLifecycleMethods(Class<?> clazz) {
        boolean foundStartMethod = false;
        boolean foundStopMethod = false;
        for (Method m : clazz.getDeclaredMethods()) {
            if (!LifecycleBuilder.isCandidateMethod(m)) continue;
            if (this.isAnnotationPresent(m, PostConstruct.class)) {
                foundStartMethod = true;
                if (!this.isOverridden(m)) {
                    this.startMethods.add(m);
                }
            } else if (this.isAnnotationPresent(m, PreDestroy.class)) {
                foundStopMethod = true;
                if (!this.isOverridden(m)) {
                    this.stopMethods.add(m);
                }
            }
            if (foundStartMethod && foundStopMethod) break;
        }
        this.hierarchy.add(clazz);
    }

    private boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        boolean result = method.isAnnotationPresent(annotationClass);
        if (!result && HAS_JSR250_ANNOTATIONS) {
            if (PostConstruct.class.equals(annotationClass)) {
                result = method.isAnnotationPresent(javax.annotation.PostConstruct.class);
            } else if (PreDestroy.class.equals(annotationClass)) {
                result = method.isAnnotationPresent(javax.annotation.PreDestroy.class);
            }
        }
        return result;
    }

    private boolean isOverridden(Method method) {
        String name = method.getName();
        block0: for (int i = this.hierarchy.size() - 1; i >= 0; --i) {
            for (Method m : this.hierarchy.get(i).getDeclaredMethods()) {
                if (!name.equals(m.getName()) || !LifecycleBuilder.isCandidateMethod(m)) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && (Modifier.isPrivate(modifiers) || !LifecycleBuilder.samePackage(method, m))) continue block0;
                return true;
            }
        }
        return false;
    }

    private static boolean isCandidateMethod(Method method) {
        int modifiers;
        if (!(method.getReturnType() != Void.TYPE || Modifier.isStatic(modifiers = method.getModifiers()) || Modifier.isAbstract(modifiers) || method.isSynthetic())) {
            return method.getParameterTypes().length == 0;
        }
        return false;
    }

    private static boolean samePackage(Method lhs, Method rhs) {
        return lhs.getDeclaringClass().getPackage().equals(rhs.getDeclaringClass().getPackage());
    }

    static {
        boolean hasJsr250Annotations;
        try {
            hasJsr250Annotations = javax.annotation.PostConstruct.class.isAnnotation() && javax.annotation.PreDestroy.class.isAnnotation();
        }
        catch (LinkageError e) {
            hasJsr250Annotations = false;
        }
        HAS_JSR250_ANNOTATIONS = hasJsr250Annotations;
    }
}

