/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.sisu.inject;

import org.dflib.jjava.shaded.com.google.inject.Binding;
import org.dflib.jjava.shaded.com.google.inject.Singleton;
import org.dflib.jjava.shaded.javax.inject.Inject;
import org.dflib.jjava.shaded.org.eclipse.sisu.Priority;
import org.dflib.jjava.shaded.org.eclipse.sisu.inject.QualifyingStrategy;
import org.dflib.jjava.shaded.org.eclipse.sisu.inject.RankingFunction;
import org.dflib.jjava.shaded.org.eclipse.sisu.inject.Sources;

@Singleton
public final class DefaultRankingFunction
implements RankingFunction {
    private final int primaryRank;

    public DefaultRankingFunction(int primaryRank) {
        if (primaryRank < 0) {
            throw new IllegalArgumentException("Primary rank must be zero or more");
        }
        this.primaryRank = primaryRank;
    }

    @Inject
    public DefaultRankingFunction() {
        this(0);
    }

    @Override
    public int maxRank() {
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> int rank(Binding<T> binding) {
        Priority priority = Sources.getAnnotation(binding, Priority.class);
        if (null != priority) {
            return priority.value();
        }
        if (QualifyingStrategy.DEFAULT_QUALIFIER.equals(QualifyingStrategy.qualify(binding.getKey()))) {
            return this.primaryRank;
        }
        return this.primaryRank + Integer.MIN_VALUE;
    }
}

