/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.sisu.wire;

import org.dflib.jjava.shaded.com.google.inject.Binding;
import org.dflib.jjava.shaded.com.google.inject.Key;
import org.dflib.jjava.shaded.com.google.inject.TypeLiteral;
import org.dflib.jjava.shaded.com.google.inject.spi.DefaultBindingTargetVisitor;
import org.dflib.jjava.shaded.com.google.inject.spi.InjectionPoint;
import org.dflib.jjava.shaded.com.google.inject.spi.LinkedKeyBinding;
import org.dflib.jjava.shaded.com.google.inject.spi.UntargettedBinding;
import org.dflib.jjava.shaded.org.eclipse.sisu.inject.Logs;
import org.dflib.jjava.shaded.org.eclipse.sisu.inject.TypeArguments;

final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    public Boolean visit(UntargettedBinding<?> binding) {
        return DependencyVerifier.verifyImplementation(binding.getKey().getTypeLiteral());
    }

    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return DependencyVerifier.verifyImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private static Boolean verifyImplementation(TypeLiteral<?> type) {
        if (TypeArguments.isConcrete(type) && !type.toString().startsWith("java")) {
            try {
                InjectionPoint.forInstanceMethodsAndFields(type);
                InjectionPoint.forConstructorOf(type);
            }
            catch (RuntimeException e) {
                Logs.debug("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
            catch (LinkageError e) {
                Logs.debug("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

