/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.io.coder;

import java.nio.ByteBuffer;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.io.coder.IDecoder;
import org.dflib.jjava.shaded.zmq.util.Errno;
import org.dflib.jjava.shaded.zmq.util.ValueReference;

public abstract class DecoderBase
implements IDecoder {
    private ByteBuffer readPos = null;
    private boolean zeroCopy;
    private int toRead = 0;
    private final int bufsize;
    private final ByteBuffer buf;
    private IDecoder.Step next = null;
    private final Errno errno;

    public DecoderBase(Errno errno, int bufsize) {
        this.bufsize = bufsize;
        assert (bufsize > 0);
        this.buf = ByteBuffer.allocateDirect(bufsize);
        this.errno = errno;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.toRead >= this.bufsize) {
            this.zeroCopy = true;
            return this.readPos.duplicate();
        }
        this.zeroCopy = false;
        this.buf.clear();
        return this.buf;
    }

    @Override
    public IDecoder.Step.Result decode(ByteBuffer data, int size, ValueReference<Integer> processed) {
        processed.set(0);
        if (this.zeroCopy) {
            assert (size <= this.toRead);
            this.readPos.position(this.readPos.position() + size);
            this.toRead -= size;
            processed.set(size);
            while (this.readPos.remaining() == 0) {
                IDecoder.Step.Result result = this.next.apply();
                if (result == IDecoder.Step.Result.MORE_DATA) continue;
                return result;
            }
            return IDecoder.Step.Result.MORE_DATA;
        }
        while (processed.get() < size) {
            int toCopy = Math.min(this.toRead, size - processed.get());
            int limit = data.limit();
            data.limit(data.position() + toCopy);
            this.readPos.put(data);
            data.limit(limit);
            this.toRead -= toCopy;
            processed.set(processed.get() + toCopy);
            while (this.readPos.remaining() == 0) {
                IDecoder.Step.Result result = this.next.apply();
                if (result == IDecoder.Step.Result.MORE_DATA) continue;
                return result;
            }
        }
        return IDecoder.Step.Result.MORE_DATA;
    }

    protected void nextStep(Msg msg, IDecoder.Step next) {
        this.nextStep(msg.buf(), next);
    }

    @Deprecated
    protected void nextStep(byte[] buf, int toRead, IDecoder.Step next) {
        this.readPos = ByteBuffer.wrap(buf);
        this.readPos.limit(toRead);
        this.toRead = toRead;
        this.next = next;
    }

    protected void nextStep(ByteBuffer buf, IDecoder.Step next) {
        this.readPos = buf;
        this.toRead = buf.remaining();
        this.next = next;
    }

    protected void errno(int err) {
        this.errno.set(err);
    }

    public int errno() {
        return this.errno.get();
    }

    @Override
    public void destroy() {
    }
}

