/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.io.coder.v1;

import java.nio.ByteBuffer;
import org.dflib.jjava.shaded.zmq.io.coder.Decoder;
import org.dflib.jjava.shaded.zmq.io.coder.IDecoder;
import org.dflib.jjava.shaded.zmq.msg.MsgAllocator;
import org.dflib.jjava.shaded.zmq.util.Errno;
import org.dflib.jjava.shaded.zmq.util.Wire;

public class V1Decoder
extends Decoder {
    private final ByteBuffer tmpbuf = ByteBuffer.allocate(8);

    public V1Decoder(Errno errno, int bufsize, long maxmsgsize, MsgAllocator allocator) {
        super(errno, bufsize, maxmsgsize, allocator);
        this.tmpbuf.limit(1);
        this.nextStep(this.tmpbuf, this.oneByteSizeReady);
    }

    @Override
    protected IDecoder.Step.Result oneByteSizeReady() {
        int size = this.tmpbuf.get(0) & 0xFF;
        if (size != 255) {
            if (size == 0) {
                this.errno(156384820);
                return IDecoder.Step.Result.ERROR;
            }
            this.tmpbuf.position(0);
            this.tmpbuf.limit(1);
            IDecoder.Step.Result rc = this.sizeReady(size - 1);
            if (rc != IDecoder.Step.Result.ERROR) {
                this.nextStep(this.tmpbuf, this.flagsReady);
            }
            return rc;
        }
        this.tmpbuf.position(0);
        this.tmpbuf.limit(8);
        this.nextStep(this.tmpbuf, this.eightByteSizeReady);
        return IDecoder.Step.Result.MORE_DATA;
    }

    @Override
    protected IDecoder.Step.Result eightByteSizeReady() {
        this.tmpbuf.position(0);
        this.tmpbuf.limit(8);
        long payloadLength = Wire.getUInt64(this.tmpbuf, 0);
        if (payloadLength <= 0L) {
            this.errno(156384820);
            return IDecoder.Step.Result.ERROR;
        }
        this.tmpbuf.limit(1);
        IDecoder.Step.Result rc = this.sizeReady(payloadLength - 1L);
        if (rc != IDecoder.Step.Result.ERROR) {
            this.nextStep(this.tmpbuf, this.flagsReady);
        }
        return rc;
    }

    @Override
    protected IDecoder.Step.Result flagsReady() {
        int first = this.tmpbuf.get(0) & 0xFF;
        if ((first & 1) > 0) {
            this.inProgress.setFlags(1);
        }
        this.nextStep(this.inProgress, this.messageReady);
        return IDecoder.Step.Result.MORE_DATA;
    }

    @Override
    protected IDecoder.Step.Result messageReady() {
        this.tmpbuf.position(0);
        this.tmpbuf.limit(1);
        this.nextStep(this.tmpbuf, this.oneByteSizeReady);
        return IDecoder.Step.Result.DECODED;
    }
}

