/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.zmq.socket.clientserver;

import org.dflib.jjava.shaded.zmq.Ctx;
import org.dflib.jjava.shaded.zmq.Msg;
import org.dflib.jjava.shaded.zmq.SocketBase;
import org.dflib.jjava.shaded.zmq.pipe.Pipe;
import org.dflib.jjava.shaded.zmq.socket.FQ;
import org.dflib.jjava.shaded.zmq.socket.LB;
import org.dflib.jjava.shaded.zmq.util.Blob;

public class Client
extends SocketBase {
    private final FQ fq;
    private final LB lb;

    public Client(Ctx parent, int tid, int sid) {
        super(parent, tid, sid, true);
        this.options.type = 13;
        this.options.canSendHelloMsg = true;
        this.options.canReceiveHiccupMsg = true;
        this.fq = new FQ();
        this.lb = new LB();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        this.fq.attach(pipe);
        this.lb.attach(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (msg.hasMore()) {
            this.errno.set(22);
            return false;
        }
        return this.lb.sendpipe(msg, this.errno, null);
    }

    @Override
    protected Msg xrecv() {
        Msg msg = this.fq.recvPipe(this.errno, null);
        while (msg != null && msg.hasMore()) {
            msg = this.fq.recvPipe(this.errno, null);
            while (msg != null && msg.hasMore()) {
                this.fq.recvPipe(this.errno, null);
            }
            if (msg == null) continue;
            this.fq.recvPipe(this.errno, null);
        }
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return this.fq.hasIn();
    }

    @Override
    protected boolean xhasOut() {
        return this.lb.hasOut();
    }

    @Override
    protected Blob getCredential() {
        return this.fq.getCredential();
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.lb.activated(pipe);
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.fq.terminated(pipe);
        this.lb.terminated(pipe);
    }
}

