/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.distro;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.dflib.jjava.distro.Opts;
import org.dflib.jjava.jupyter.kernel.util.PathsHandler;

final class Env {
    public static final String JJAVA_COMPILER_OPTS = "JJAVA_COMPILER_OPTS";
    public static final String JJAVA_TIMEOUT = "JJAVA_TIMEOUT";
    public static final String JJAVA_CLASSPATH = "JJAVA_CLASSPATH";
    public static final String JJAVA_STARTUP_SCRIPTS_PATH = "JJAVA_STARTUP_SCRIPTS_PATH";
    public static final String JJAVA_STARTUP_SCRIPT = "JJAVA_STARTUP_SCRIPT";
    public static final String JJAVA_LOAD_EXTENSIONS = "JJAVA_LOAD_EXTENSIONS";
    public static final String JJAVA_JVM_OPTS = "JJAVA_JVM_OPTS";

    Env() {
    }

    public static String timeout() {
        return System.getenv(JJAVA_TIMEOUT);
    }

    public static boolean extensionsEnabled() {
        String envValue = System.getenv(JJAVA_LOAD_EXTENSIONS);
        if (envValue == null) {
            return true;
        }
        String envValueTrimmed = envValue.trim();
        return !envValueTrimmed.isEmpty() && !envValueTrimmed.equals("0") && !envValueTrimmed.equalsIgnoreCase("false");
    }

    public static List<String> compilerOpts() {
        String optsString = System.getenv(JJAVA_COMPILER_OPTS);
        return optsString != null ? Opts.splitOpts(optsString) : List.of();
    }

    public static String extraClasspath() {
        return System.getenv(JJAVA_CLASSPATH);
    }

    public static List<String> startupSnippets() {
        String code;
        ArrayList<String> snippets = new ArrayList<String>();
        String scriptPaths = System.getenv(JJAVA_STARTUP_SCRIPTS_PATH);
        if (scriptPaths != null && !scriptPaths.isBlank()) {
            Env.appendSnippestFromScriptPaths(snippets, scriptPaths);
        }
        if ((code = System.getenv(JJAVA_STARTUP_SCRIPT)) != null) {
            snippets.add(code);
        }
        return snippets;
    }

    private static void appendSnippestFromScriptPaths(List<String> startupScripts, String scriptPaths) {
        for (Path path : PathsHandler.splitAndResolveGlobs(scriptPaths)) {
            if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path)) continue;
            try {
                startupScripts.add(Files.readString(path));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error while loading startup script for '%s': %s", path, e.getMessage()), e);
            }
        }
    }
}

