/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.jupyter.kernel.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dflib.jjava.jupyter.kernel.magic.MagicTranspiler;
import org.dflib.jjava.jupyter.kernel.magic.ParsedCellMagic;
import org.dflib.jjava.jupyter.kernel.magic.ParsedLineMagic;

public class MagicsResolver {
    private final Pattern lineMagicPattern;
    private final Pattern cellMagicPattern;
    private final MagicTranspiler magicTranspiler;

    public MagicsResolver(String lineMagicStart, String cellMagicStart, MagicTranspiler magicTranspiler) {
        this.lineMagicPattern = Pattern.compile(lineMagicStart + "(?<args>\\w.*?)$", 8);
        this.cellMagicPattern = Pattern.compile("^(?<argsLine>" + cellMagicStart + "(?<args>\\w.*?))\\R(?<body>(?sU).+?)$");
        this.magicTranspiler = magicTranspiler;
    }

    public String resolve(String cellSource) {
        ParsedCellMagic parsedCell = this.parseCellMagic(cellSource);
        return parsedCell != null ? this.magicTranspiler.transpileCell(parsedCell) : this.resolveLineMagics(cellSource);
    }

    String resolveLineMagics(String cellSource) {
        StringBuffer out = new StringBuffer();
        Matcher m = this.lineMagicPattern.matcher(cellSource);
        while (m.find()) {
            ParsedLineMagic parsed = this.parseLineMagic(cellSource, m);
            String transformed = this.magicTranspiler.transpileLine(parsed);
            m.appendReplacement(out, Matcher.quoteReplacement(transformed));
        }
        m.appendTail(out);
        return out.toString();
    }

    ParsedCellMagic parseCellMagic(String cellSource) {
        Matcher m = this.cellMagicPattern.matcher(cellSource);
        if (!m.matches()) {
            return null;
        }
        List<String> split = MagicsResolver.split(m.group("args"));
        String bodyAfterMagic = m.group("body");
        return new ParsedCellMagic(split.get(0), split.subList(1, split.size()), bodyAfterMagic);
    }

    private ParsedLineMagic parseLineMagic(String cellSource, Matcher matchedLine) {
        List<String> split = MagicsResolver.split(matchedLine.group("args"));
        String rawLinePrefix = cellSource.substring(0, matchedLine.start());
        String linePrefix = rawLinePrefix.substring(rawLinePrefix.lastIndexOf(10) + 1);
        return new ParsedLineMagic(split.get(0), split.subList(1, split.size()), linePrefix, matchedLine.group());
    }

    static List<String> split(String args) {
        args = args.trim();
        ArrayList<String> split = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean escape = false;
        block5: for (char c : args.toCharArray()) {
            switch (c) {
                case '\t': 
                case ' ': {
                    if (inQuotes) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    split.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
                case '\\': {
                    if (escape) {
                        current.append("\\");
                        escape = false;
                        continue block5;
                    }
                    escape = true;
                    continue block5;
                }
                case '\"': {
                    if (escape) {
                        current.append('\"');
                        escape = false;
                        continue block5;
                    }
                    if (inQuotes) {
                        split.add(current.toString());
                        current.setLength(0);
                        inQuotes = false;
                        continue block5;
                    }
                    inQuotes = true;
                    continue block5;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            split.add(current.toString());
        }
        return split;
    }
}

