/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.execution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.EvalException;
import jdk.jshell.JShell;
import jdk.jshell.JShellException;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;
import org.dflib.jjava.jupyter.telemetry.TelemetryCollector;
import org.dflib.jjava.kernel.execution.CompilationException;
import org.dflib.jjava.kernel.execution.EvaluationInterruptedException;
import org.dflib.jjava.kernel.execution.EvaluationTimeoutException;
import org.dflib.jjava.kernel.execution.IncompleteSourceException;
import org.dflib.jjava.kernel.execution.JJavaExecutionControl;
import org.dflib.jjava.kernel.execution.JJavaLoaderDelegate;

public class CodeEvaluator {
    private static final Pattern WHITESPACE_PREFIX = Pattern.compile("(?:^|\r?\n)(?<ws>\\s*).*$");
    private static final Pattern LAST_LINE = Pattern.compile("(?:^|\r?\n)(?<last>.*)$");
    private static final String NO_MAGIC_RETURN = "\"__NO_MAGIC_RETURN\"";
    private static final String INDENTATION = "  ";
    private static final Method SNIPPET_CLASS_NAME_METHOD;
    private final String name;
    private final long timeoutDuration;
    private final TimeUnit timeoutUnit;
    private final JJavaLoaderDelegate loaderDelegate;
    private final JJavaExecutionControl execControl;

    public CodeEvaluator(String name, long timeoutDuration, TimeUnit timeoutUnit) {
        this.name = name;
        this.timeoutDuration = timeoutDuration;
        this.timeoutUnit = timeoutUnit;
        this.loaderDelegate = new JJavaLoaderDelegate();
        this.execControl = new JJavaExecutionControl(this.loaderDelegate, timeoutDuration, timeoutUnit);
    }

    public void startThreadTelemetryCollection(TelemetryCollector<?> collector) {
        this.execControl.startThreadTelemetryCollection(collector);
    }

    public void stopThreadTelemetryCollection() {
        this.execControl.stopThreadTelemetryCollection();
    }

    public ExecutionControlProvider getExecControlProvider() {
        return new SimpleExecControlProvider(this.name, this.execControl);
    }

    public Object eval(JShell shell, String code) {
        SourceCodeAnalysis sca = shell.sourceCodeAnalysis();
        Object lastResult = null;
        SourceCodeAnalysis.CompletionInfo info = sca.analyzeCompletion(code);
        while (info.completeness().isComplete()) {
            lastResult = this.evalSingle(shell, info.source());
            info = sca.analyzeCompletion(info.remaining());
        }
        if (info.completeness() != SourceCodeAnalysis.Completeness.EMPTY) {
            throw new IncompleteSourceException(info.remaining().trim());
        }
        return lastResult;
    }

    protected Object evalSingle(JShell shell, String code) {
        List<SnippetEvent> events = shell.eval(code);
        String result = null;
        block11: for (SnippetEvent event : events) {
            if (event.status() == Snippet.Status.OVERWRITTEN) {
                this.dropSnippet(shell, event.snippet());
                continue;
            }
            String key = event.value();
            if (key == null) continue;
            Snippet.SubKind subKind = event.snippet().subKind();
            String value = subKind.isExecutable() ? this.execControl.takeResult(key) : event.value();
            switch (subKind) {
                case VAR_VALUE_SUBKIND: 
                case OTHER_EXPRESSION_SUBKIND: 
                case TEMP_VAR_EXPRESSION_SUBKIND: {
                    result = NO_MAGIC_RETURN.equals(value) ? null : value;
                    continue block11;
                }
            }
            result = null;
        }
        for (SnippetEvent event : events) {
            if (event.causeSnippet() != null) continue;
            JShellException e = event.exception();
            if (e != null) {
                if (e instanceof EvalException) {
                    EvalException ee = (EvalException)e;
                    switch (ee.getExceptionClassName()) {
                        case "Execution Timeout": {
                            throw new EvaluationTimeoutException(this.timeoutDuration, this.timeoutUnit, code.trim());
                        }
                        case "Execution Interrupted": {
                            throw new EvaluationInterruptedException(code.trim());
                        }
                    }
                    throw new RuntimeException(ee.getExceptionClassName() + ", " + e.getMessage(), e);
                }
                throw new RuntimeException(e);
            }
            if (event.status() == Snippet.Status.RECOVERABLE_NOT_DEFINED || event.status().isDefined()) continue;
            throw new CompilationException(event);
        }
        return result;
    }

    private void dropSnippet(JShell shell, Snippet snippet) {
        shell.drop(snippet);
        String className = this.snippetClassName(snippet);
        if (shell.snippets().map(this::snippetClassName).noneMatch(className::equals)) {
            this.execControl.unloadClass(className);
        }
    }

    private String snippetClassName(Snippet snippet) {
        try {
            return SNIPPET_CLASS_NAME_METHOD.invoke((Object)snippet, new Object[0]).toString();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String computeIndentation(String partialStatement) {
        Matcher m = WHITESPACE_PREFIX.matcher(partialStatement);
        String currentIndentation = m.find() ? m.group("ws") : "";
        m = LAST_LINE.matcher(partialStatement);
        if (!m.find()) {
            throw new Error("Pattern broken. Every string should have a last line.");
        }
        String lastLine = m.group("last");
        int newlyOpenedBraces = -1;
        int newlyOpenedParens = -1;
        block6: for (int i = 0; i < lastLine.length(); ++i) {
            switch (lastLine.charAt(i)) {
                case '}': {
                    if (newlyOpenedBraces == -1) continue block6;
                    --newlyOpenedBraces;
                    continue block6;
                }
                case ')': {
                    if (newlyOpenedParens == -1) continue block6;
                    --newlyOpenedParens;
                    continue block6;
                }
                case '{': {
                    if (newlyOpenedBraces == -1) {
                        ++newlyOpenedBraces;
                    }
                    ++newlyOpenedBraces;
                    continue block6;
                }
                case '(': {
                    if (newlyOpenedParens == -1) {
                        ++newlyOpenedParens;
                    }
                    ++newlyOpenedParens;
                }
            }
        }
        return newlyOpenedBraces > 0 || newlyOpenedParens > 0 ? currentIndentation + INDENTATION : currentIndentation;
    }

    public String isComplete(SourceCodeAnalysis sourceAnalyzer, String code) {
        SourceCodeAnalysis.CompletionInfo info = sourceAnalyzer.analyzeCompletion(code);
        while (info.completeness().isComplete()) {
            info = sourceAnalyzer.analyzeCompletion(info.remaining());
        }
        switch (info.completeness()) {
            case UNKNOWN: {
                return "invalid";
            }
            case COMPLETE: 
            case COMPLETE_WITH_SEMI: 
            case EMPTY: {
                return "complete";
            }
            case CONSIDERED_INCOMPLETE: 
            case DEFINITELY_INCOMPLETE: {
                return this.computeIndentation(info.remaining());
            }
        }
        return "unknown";
    }

    public void interrupt() {
        this.execControl.interrupt();
    }

    public ClassLoader getClassLoader() {
        return this.loaderDelegate.getClassLoader();
    }

    static {
        try {
            SNIPPET_CLASS_NAME_METHOD = Snippet.class.getDeclaredMethod("classFullName", new Class[0]);
            SNIPPET_CLASS_NAME_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to access jdk.jshell.Snippet.classFullName() method.", e);
        }
    }

    static final class SimpleExecControlProvider
    implements ExecutionControlProvider {
        private final String name;
        private final ExecutionControl control;

        public SimpleExecControlProvider(String name, ExecutionControl control) {
            this.name = name;
            this.control = control;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public ExecutionControl generate(ExecutionEnv env, Map<String, String> parameters) {
            return this.control;
        }
    }
}

