/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.kernel.magics;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.UUID;
import org.dflib.jjava.jupyter.kernel.BaseKernel;
import org.dflib.jjava.jupyter.kernel.display.DisplayData;
import org.dflib.jjava.jupyter.kernel.magic.CellMagic;
import org.dflib.jjava.jupyter.kernel.magic.LineMagic;
import org.dflib.jjava.jupyter.telemetry.TelemetryCollector;
import org.dflib.jjava.jupyter.telemetry.WallAndCpuTimeCollector;
import org.dflib.jjava.jupyter.telemetry.WallTimeCollector;
import org.dflib.jjava.kernel.JavaKernel;

public class TimeMagic
implements LineMagic<DisplayData, JavaKernel>,
CellMagic<DisplayData, JavaKernel> {
    private static final double NANONS_IN_SEC = 1.0E9;

    @Override
    public DisplayData eval(JavaKernel kernel, List<String> args) throws Exception {
        return args.isEmpty() ? null : this.timeAndRunCode(kernel, String.join((CharSequence)" ", args));
    }

    @Override
    public DisplayData eval(JavaKernel kernel, List<String> args, String body) throws Exception {
        return this.timeAndRunCode(kernel, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayData timeAndRunCode(JavaKernel kernel, String code) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        TelemetryCollector<WallAndCpuTimeCollector.Measure> collector = WallAndCpuTimeCollector.canMeasureCpuTimes(threadMXBean) ? new TMWallAndCpuTimeCollector(kernel, threadMXBean) : new TMWallTimeCollector(kernel);
        kernel.getEvaluator().startThreadTelemetryCollection(collector);
        try {
            DisplayData displayData = kernel.evalBuilder(code).resolveMagics().renderResults().eval();
            return displayData;
        }
        finally {
            kernel.getEvaluator().stopThreadTelemetryCollection();
        }
    }

    private static void displayCpuTime(BaseKernel kernel, long userTimeNanos, long sysTimeNanos, long totalTimeNanos) {
        String cpuTimes = String.format("CPU times: user %.3f s, sys %.3f s, total %.3f s", (double)userTimeNanos / 1.0E9, (double)sysTimeNanos / 1.0E9, (double)totalTimeNanos / 1.0E9);
        kernel.display(new DisplayData(cpuTimes).setDisplayId(UUID.randomUUID().toString()));
    }

    private static void displayWallTime(BaseKernel kernel, long wallTimeNanos) {
        String wallTime = String.format("Wall time: %.3f s", (double)wallTimeNanos / 1.0E9);
        kernel.display(new DisplayData(wallTime).setDisplayId(UUID.randomUUID().toString()));
    }

    static class TMWallAndCpuTimeCollector
    extends WallAndCpuTimeCollector {
        private final BaseKernel kernel;

        public TMWallAndCpuTimeCollector(BaseKernel kernel, ThreadMXBean threadMXBean) {
            super(threadMXBean);
            this.kernel = kernel;
        }

        @Override
        protected void onStop(long wallTimeNanos, long userTimeNanos, long totalTimeNanos) {
            if (userTimeNanos != -1L && totalTimeNanos != -1L) {
                TimeMagic.displayCpuTime(this.kernel, userTimeNanos, totalTimeNanos - userTimeNanos, totalTimeNanos);
            }
            TimeMagic.displayWallTime(this.kernel, wallTimeNanos);
        }
    }

    static class TMWallTimeCollector
    extends WallTimeCollector {
        private final BaseKernel kernel;

        public TMWallTimeCollector(BaseKernel kernel) {
            this.kernel = kernel;
        }

        @Override
        protected void onStop(long wallTimeNanos) {
            TimeMagic.displayWallTime(this.kernel, wallTimeNanos);
        }
    }
}

