/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.com.neilalexander.jnacl;

import java.util.Formatter;
import org.dflib.jjava.shaded.com.neilalexander.jnacl.crypto.curve25519xsalsa20poly1305;

public class NaCl {
    static final int crypto_secretbox_KEYBYTES = 32;
    static final int crypto_secretbox_NONCEBYTES = 24;
    static final int crypto_secretbox_ZEROBYTES = 32;
    static final int crypto_secretbox_BOXZEROBYTES = 16;
    static final int crypto_secretbox_BEFORENMBYTES = 32;
    private byte[] precomputed = new byte[32];

    public NaCl(byte[] privatekey, byte[] publickey) throws Exception {
        if (privatekey.length < 32) {
            throw new Exception("Private key too short");
        }
        if (publickey.length < 32) {
            throw new Exception("Public key too short");
        }
        curve25519xsalsa20poly1305.crypto_box_beforenm(this.precomputed, publickey, privatekey);
    }

    public NaCl(String privatekey, String publickey) throws Exception {
        this(NaCl.getBinary(privatekey), NaCl.getBinary(publickey));
    }

    public byte[] encrypt(byte[] input, byte[] nonce) {
        return this.encrypt(input, input.length, nonce);
    }

    public byte[] encrypt(byte[] input, int inputlength, byte[] nonce) {
        byte[] paddedinput = new byte[inputlength + 32];
        byte[] output = new byte[inputlength + 32];
        System.arraycopy(input, 0, paddedinput, 32, inputlength);
        curve25519xsalsa20poly1305.crypto_box_afternm(output, paddedinput, paddedinput.length, nonce, this.precomputed);
        return output;
    }

    public byte[] decrypt(byte[] input, byte[] nonce) {
        return this.decrypt(input, input.length, nonce);
    }

    public byte[] decrypt(byte[] input, int inputlength, byte[] nonce) {
        byte[] paddedoutput = new byte[inputlength];
        byte[] output = new byte[inputlength - 32];
        curve25519xsalsa20poly1305.crypto_box_open_afternm(paddedoutput, input, inputlength, nonce, this.precomputed);
        System.arraycopy(paddedoutput, 32, output, 0, paddedoutput.length - 32);
        return output;
    }

    public static byte[] getBinary(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String asHex(byte[] buf) {
        Formatter formatter = new Formatter();
        for (byte b : buf) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static String asHex(int[] buf) {
        Formatter formatter = new Formatter();
        for (int b : buf) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }
}

