/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.eclipse.sisu.wire;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dflib.jjava.shaded.com.google.inject.Injector;
import org.dflib.jjava.shaded.com.google.inject.Singleton;
import org.dflib.jjava.shaded.com.google.inject.TypeLiteral;
import org.dflib.jjava.shaded.com.google.inject.spi.TypeConverter;
import org.dflib.jjava.shaded.com.google.inject.spi.TypeConverterBinding;
import org.dflib.jjava.shaded.javax.inject.Inject;

@Singleton
final class TypeConverterCache {
    private final Map<TypeLiteral<?>, TypeConverter> converterMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final Injector injector;

    @Inject
    TypeConverterCache(Injector injector) {
        this.injector = injector;
    }

    public TypeConverter getTypeConverter(TypeLiteral<?> type) {
        TypeConverter converter = this.converterMap.get(type);
        if (null == converter) {
            for (TypeConverterBinding b : this.injector.getTypeConverterBindings()) {
                if (!b.getTypeMatcher().matches(type)) continue;
                converter = b.getTypeConverter();
                this.converterMap.put(type, converter);
                break;
            }
        }
        return converter;
    }
}

