/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.dflib.jjava.shaded.org.zeromq.SocketType;
import org.dflib.jjava.shaded.org.zeromq.ZActor;
import org.dflib.jjava.shaded.org.zeromq.ZAgent;
import org.dflib.jjava.shaded.org.zeromq.ZCertStore;
import org.dflib.jjava.shaded.org.zeromq.ZContext;
import org.dflib.jjava.shaded.org.zeromq.ZFrame;
import org.dflib.jjava.shaded.org.zeromq.ZMQ;
import org.dflib.jjava.shaded.org.zeromq.ZMQException;
import org.dflib.jjava.shaded.org.zeromq.ZMsg;
import org.dflib.jjava.shaded.org.zeromq.ZPoller;
import org.dflib.jjava.shaded.org.zeromq.ZStar;
import org.dflib.jjava.shaded.org.zeromq.util.ZMetadata;
import org.dflib.jjava.shaded.zmq.io.mechanism.Mechanisms;
import org.dflib.jjava.shaded.zmq.util.Objects;

public class ZAuth
implements Closeable {
    private static final String ZAP_VERSION = "1.0";
    public static final String CURVE_ALLOW_ANY = "*";
    private static final String VERBOSE = "VERBOSE";
    private static final String REPLIES = "REPLIES";
    private static final String ALLOW = "ALLOW";
    private static final String DENY = "DENY";
    private static final String TERMINATE = "TERMINATE";
    private final ZAgent agent;
    private final ZStar.Exit exit;
    private final ZAgent replies;
    private boolean repliesEnabled;

    public ZAuth(ZContext ctx) {
        this(ctx, "ZAuth");
    }

    public ZAuth(ZContext ctx, ZCertStore.Fingerprinter fingerprinter) {
        this(ctx, "ZAuth", ZAuth.curveVariant(fingerprinter));
    }

    public ZAuth(ZContext ctx, String actorName) {
        this(ctx, actorName, ZAuth.makeSimpleAuths());
    }

    private static Map<String, Auth> makeSimpleAuths() {
        HashMap<String, Auth> auths = new HashMap<String, Auth>();
        auths.put(ZMQ.Socket.Mechanism.PLAIN.name(), new SimplePlainAuth());
        auths.put(ZMQ.Socket.Mechanism.CURVE.name(), new SimpleCurveAuth());
        auths.put(ZMQ.Socket.Mechanism.NULL.name(), new SimpleNullAuth());
        return auths;
    }

    private static Map<String, Auth> curveVariant(ZCertStore.Fingerprinter fingerprinter) {
        Map<String, Auth> auths = ZAuth.makeSimpleAuths();
        auths.put(ZMQ.Socket.Mechanism.CURVE.name(), new SimpleCurveAuth(fingerprinter));
        return auths;
    }

    public ZAuth(ZContext ctx, String actorName, Map<String, Auth> auths) {
        Objects.requireNonNull(ctx, "ZAuth works only with a provided ZContext");
        Objects.requireNonNull(actorName, "Actor name shall be defined");
        Objects.requireNonNull(auths, "Authenticators shall be supplied as non-null map");
        AuthActor actor = new AuthActor(actorName, auths);
        ZActor zactor = new ZActor(ctx, (ZActor.Actor)actor, UUID.randomUUID().toString(), new Object[0]);
        this.agent = zactor.agent();
        this.exit = zactor.exit();
        this.agent.recv().destroy();
        this.replies = actor.createAgent(ctx);
    }

    public ZAuth setVerbose(boolean verbose) {
        return this.verbose(verbose);
    }

    public ZAuth verbose(boolean verbose) {
        return this.send(VERBOSE, String.format("%b", verbose));
    }

    public ZAuth allow(String address) {
        Objects.requireNonNull(address, "Address has to be supplied for allowance");
        return this.send(ALLOW, address);
    }

    public ZAuth deny(String address) {
        Objects.requireNonNull(address, "Address has to be supplied for denial");
        return this.send(DENY, address);
    }

    public ZAuth configurePlain(String domain, String filename) {
        Objects.requireNonNull(domain, "Domain has to be supplied");
        Objects.requireNonNull(filename, "File name has to be supplied");
        return this.send(ZMQ.Socket.Mechanism.PLAIN.name(), domain, filename);
    }

    public ZAuth configureCurve(String location) {
        Objects.requireNonNull(location, "Location has to be supplied");
        return this.send(ZMQ.Socket.Mechanism.CURVE.name(), location);
    }

    public ZAuth replies(boolean enable) {
        this.repliesEnabled = enable;
        return this.send(REPLIES, String.format("%b", enable));
    }

    public ZapReply nextReply() {
        return this.nextReply(true);
    }

    public ZapReply nextReply(boolean wait) {
        if (!this.repliesEnabled) {
            System.out.println("ZAuth: replies are disabled. Please use replies(true);");
            return null;
        }
        return ZapReply.recv(this.replies, wait);
    }

    public ZapReply nextReply(int timeout) {
        if (!this.repliesEnabled) {
            System.out.println("ZAuth: replies are disabled. Please use replies(true);");
            return null;
        }
        return ZapReply.recv(this.replies, timeout);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        this.send(TERMINATE, new String[0]);
        this.exit.awaitSilent();
        this.agent.close();
        this.replies.close();
    }

    protected ZAuth send(String command, String ... datas) {
        ZMsg msg = new ZMsg();
        msg.add(command);
        for (String data : datas) {
            msg.add(data);
        }
        this.agent.send(msg);
        msg.destroy();
        this.agent.recv();
        return this;
    }

    public static class SimplePlainAuth
    implements Auth {
        private final Properties passwords = new Properties();
        private File passwordsFile;
        private long passwordsModified;

        @Override
        public boolean configure(ZMsg msg, boolean verbose) {
            assert (msg.size() == 2);
            String domain = msg.popString();
            String filename = msg.popString();
            this.passwordsFile = new File(filename);
            if (verbose) {
                System.out.printf("ZAuth: activated plain-mechanism with password-file: %s%n", this.passwordsFile.getAbsolutePath());
            }
            this.loadPasswords(true);
            return true;
        }

        @Override
        public boolean authorize(ZapRequest request, boolean verbose) {
            this.loadPasswords(false);
            String password = this.passwords.getProperty(request.username);
            if (password != null && password.equals(request.password)) {
                if (verbose) {
                    System.out.printf("ZAuth: Allowed (PLAIN) username=%s\n", request.username);
                }
                request.userId = request.username;
                return true;
            }
            if (verbose) {
                System.out.printf("ZAuth: Denied (PLAIN) username=%s\n", request.username);
            }
            return false;
        }

        private void loadPasswords(boolean initial) {
            if (!initial) {
                long lastModified = this.passwordsFile.lastModified();
                long age = System.currentTimeMillis() - lastModified;
                if (lastModified > this.passwordsModified && age > 1000L) {
                    this.passwords.clear();
                } else {
                    return;
                }
            }
            this.passwordsModified = this.passwordsFile.lastModified();
            try (BufferedReader br = new BufferedReader(new FileReader(this.passwordsFile));){
                this.passwords.load(br);
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public static class SimpleCurveAuth
    implements Auth {
        private final ZCertStore.Fingerprinter fingerprinter;
        private ZCertStore certStore = null;
        private boolean allowAny;

        public SimpleCurveAuth() {
            this(new ZCertStore.Hasher());
        }

        public SimpleCurveAuth(ZCertStore.Fingerprinter fingerprinter) {
            this.fingerprinter = fingerprinter;
        }

        @Override
        public boolean configure(ZMsg configuration, boolean verbose) {
            String location = configuration.popString();
            this.allowAny = location.equals(ZAuth.CURVE_ALLOW_ANY);
            if (this.allowAny) {
                if (verbose) {
                    System.out.println("ZAuth: Allowing all clients");
                }
            } else {
                if (verbose) {
                    System.out.printf("ZAuth: Using %s as certificates directory%n", location);
                }
                this.certStore = new ZCertStore(location, this.fingerprinter);
            }
            return true;
        }

        @Override
        public boolean authorize(ZapRequest request, boolean verbose) {
            if (this.allowAny) {
                if (verbose) {
                    System.out.println("ZAuth: allowed (CURVE allow any client)");
                }
                return true;
            }
            if (this.certStore != null) {
                if (this.certStore.containsPublicKey(request.clientKey)) {
                    if (verbose) {
                        System.out.printf("ZAuth: Allowed (CURVE) client_key=%s\n", request.clientKey);
                    }
                    request.userId = request.clientKey;
                    request.metadata = this.certStore.getMetadata(request.clientKey);
                    return true;
                }
                if (verbose) {
                    System.out.printf("ZAuth: Denied (CURVE) client_key=%s\n", request.clientKey);
                }
                return false;
            }
            return false;
        }
    }

    public static class SimpleNullAuth
    implements Auth {
        @Override
        public boolean configure(ZMsg configuration, boolean verbose) {
            return true;
        }

        @Override
        public boolean authorize(ZapRequest request, boolean verbose) {
            return true;
        }
    }

    private static class AuthActor
    extends ZActor.SimpleActor {
        private static final String OK = "OK";
        private final String actorName;
        private final Properties whitelist = new Properties();
        private final Properties blacklist = new Properties();
        private final Map<String, Auth> auths = new HashMap<String, Auth>();
        private final String repliesAddress;
        private boolean repliesEnabled;
        private ZMQ.Socket replies;
        private boolean verbose;

        private AuthActor(String actorName, Map<String, Auth> auths) {
            assert (auths != null);
            assert (actorName != null);
            this.actorName = actorName;
            this.auths.putAll(auths);
            this.repliesAddress = "inproc://zauth-replies-" + UUID.randomUUID();
        }

        private ZAgent createAgent(ZContext ctx) {
            ZMQ.Socket pipe = ctx.createSocket(SocketType.PAIR);
            boolean rc = pipe.connect(this.repliesAddress);
            assert (rc);
            return new ZAgent.SimpleAgent(pipe, this.repliesAddress);
        }

        @Override
        public String premiere(ZMQ.Socket pipe) {
            return this.actorName;
        }

        @Override
        public List<ZMQ.Socket> createSockets(ZContext ctx, Object ... args) {
            this.replies = ctx.createSocket(SocketType.PAIR);
            assert (this.replies != null);
            ZMQ.Socket handler = ctx.createSocket(SocketType.REP);
            assert (handler != null);
            return Arrays.asList(handler, this.replies);
        }

        @Override
        public void start(ZMQ.Socket pipe, List<ZMQ.Socket> sockets, ZPoller poller) {
            block6: {
                try {
                    boolean rc = this.replies.bind(this.repliesAddress);
                    assert (rc);
                    ZMQ.Socket handler = sockets.get(0);
                    rc = handler.bind("inproc://zeromq.zap.01");
                    assert (rc);
                    rc = poller.register(handler, 1);
                    assert (rc);
                    rc = pipe.send(OK);
                    assert (rc);
                }
                catch (ZMQException e) {
                    System.out.println("ZAuth: Error");
                    e.printStackTrace();
                    boolean rc = pipe.send("ERROR");
                    if ($assertionsDisabled || rc) break block6;
                    throw new AssertionError();
                }
            }
        }

        @Override
        public boolean backstage(ZMQ.Socket pipe, ZPoller poller, int events) {
            boolean rc;
            ZMsg msg = ZMsg.recvMsg(pipe);
            String command = msg.popString();
            if (command == null) {
                System.out.printf("ZAuth: Closing auth: No command%n", new Object[0]);
                return false;
            }
            if (ZAuth.ALLOW.equals(command)) {
                String address = msg.popString();
                if (this.verbose) {
                    System.out.printf("ZAuth: Whitelisting IP address=%s\n", address);
                }
                this.whitelist.put(address, OK);
                rc = pipe.send(OK);
            } else if (ZAuth.DENY.equals(command)) {
                String address = msg.popString();
                if (this.verbose) {
                    System.out.printf("ZAuth: Blacklisting IP address=%s\n", address);
                }
                this.blacklist.put(address, OK);
                rc = pipe.send(OK);
            } else if (ZAuth.VERBOSE.equals(command)) {
                String verboseStr = msg.popString();
                this.verbose = Boolean.parseBoolean(verboseStr);
                rc = pipe.send(OK);
            } else if (ZAuth.REPLIES.equals(command)) {
                this.repliesEnabled = Boolean.parseBoolean(msg.popString());
                if (this.verbose) {
                    if (this.repliesEnabled) {
                        System.out.println("ZAuth: Enabled replies");
                    } else {
                        System.out.println("ZAuth: Disabled replies");
                    }
                }
                rc = pipe.send(OK);
            } else {
                if (ZAuth.TERMINATE.equals(command)) {
                    if (this.repliesEnabled) {
                        this.replies.send(this.repliesAddress);
                    }
                    if (this.verbose) {
                        System.out.println("ZAuth: Terminated");
                    }
                    pipe.send(OK);
                    return false;
                }
                Auth authenticator = this.auths.get(command);
                if (authenticator != null) {
                    rc = authenticator.configure(msg, this.verbose) ? pipe.send(OK) : pipe.send("ERROR");
                } else {
                    System.out.printf("ZAuth: Invalid command %s%n", command);
                    rc = true;
                }
            }
            msg.destroy();
            if (!rc) {
                System.out.printf("ZAuth: Command in error %s%n", command);
            }
            return rc;
        }

        @Override
        public boolean stage(ZMQ.Socket socket, ZMQ.Socket pipe, ZPoller poller, int events) {
            ZMQ.Socket reply;
            ZapRequest request = ZapRequest.recvRequest(socket, true);
            if (request == null) {
                return false;
            }
            boolean allowed = false;
            boolean denied = false;
            if (!this.whitelist.isEmpty()) {
                if (this.whitelist.containsKey(request.address)) {
                    allowed = true;
                    if (this.verbose) {
                        System.out.printf("ZAuth: Passed (whitelist) address = %s\n", request.address);
                    }
                } else {
                    denied = true;
                    if (this.verbose) {
                        System.out.printf("ZAuth: Denied (not in whitelist) address = %s\n", request.address);
                    }
                }
            } else if (!this.blacklist.isEmpty()) {
                if (this.blacklist.containsKey(request.address)) {
                    denied = true;
                    if (this.verbose) {
                        System.out.printf("ZAuth: Denied (blacklist) address = %s\n", request.address);
                    }
                } else {
                    allowed = true;
                    if (this.verbose) {
                        System.out.printf("ZAuth: Passed (not in blacklist) address = %s\n", request.address);
                    }
                }
            }
            if (!denied) {
                Auth auth = this.auths.get(request.mechanism);
                if (auth == null) {
                    System.out.printf("ZAuth E: Skipping unhandled mechanism %s%n", request.mechanism);
                    return false;
                }
                allowed = auth.authorize(request, this.verbose);
            }
            ZMQ.Socket socket2 = reply = this.repliesEnabled ? this.replies : null;
            if (allowed) {
                request.reply(200, OK, reply);
            } else {
                request.metadata = null;
                request.reply(400, "NO ACCESS", reply);
            }
            return true;
        }
    }

    public static class ZapReply {
        public final String version;
        public final String sequence;
        public final int statusCode;
        public final String statusText;
        public final String userId;
        public final ZMetadata metadata;
        public final String address;
        public final String identity;

        private ZapReply(String version, String sequence, int statusCode, String statusText, String userId, ZMetadata metadata) {
            this(version, sequence, statusCode, statusText, userId, metadata, null, null);
        }

        private ZapReply(String version, String sequence, int statusCode, String statusText, String userId, ZMetadata metadata, String address, String identity) {
            assert (ZAuth.ZAP_VERSION.equals(version));
            this.version = version;
            this.sequence = sequence;
            this.statusCode = statusCode;
            this.statusText = statusText;
            this.userId = userId;
            this.metadata = metadata;
            this.address = address;
            this.identity = identity;
        }

        private ZMsg msg() {
            ZMsg msg = new ZMsg();
            msg.add(this.version);
            msg.add(this.sequence);
            msg.add(Integer.toString(this.statusCode));
            msg.add(this.statusText);
            msg.add(this.userId == null ? "" : this.userId);
            msg.add(this.metadata == null ? new byte[]{} : this.metadata.bytes());
            return msg;
        }

        public String toString() {
            return "ZapReply [" + (this.version != null ? "version=" + this.version + ", " : "") + (this.sequence != null ? "sequence=" + this.sequence + ", " : "") + "statusCode=" + this.statusCode + ", " + (this.statusText != null ? "statusText=" + this.statusText + ", " : "") + (this.userId != null ? "userId=" + this.userId + ", " : "") + (this.metadata != null ? "metadata=" + this.metadata : "") + "]";
        }

        private static ZapReply recv(ZAgent agent, boolean wait) {
            return ZapReply.received(agent.recv(wait));
        }

        private static ZapReply recv(ZAgent agent, int timeout) {
            return ZapReply.received(agent.recv(timeout));
        }

        private static ZapReply received(ZMsg msg) {
            if (msg == null) {
                return null;
            }
            assert (msg.size() == 8);
            String version = msg.popString();
            String sequence = msg.popString();
            int statusCode = Integer.parseInt(msg.popString());
            String statusText = msg.popString();
            String userId = msg.popString();
            ZMetadata metadata = ZMetadata.read(msg.popString());
            String address = msg.popString();
            String identity = msg.popString();
            return new ZapReply(version, sequence, statusCode, statusText, userId, metadata, address, identity);
        }
    }

    public static class ZapRequest {
        private final ZMQ.Socket handler;
        public final String version;
        public final String sequence;
        public final String domain;
        public final String address;
        public final String identity;
        public final String mechanism;
        public final String username;
        public final String password;
        public final String clientKey;
        public final String principal;
        public String userId;
        public ZMetadata metadata;

        private ZapRequest(ZMQ.Socket handler, ZMsg request) {
            this.handler = handler;
            this.version = request.popString();
            this.sequence = request.popString();
            this.domain = request.popString();
            this.address = request.popString();
            this.identity = request.popString();
            this.mechanism = request.popString();
            assert (ZAuth.ZAP_VERSION.equals(this.version));
            if (ZMQ.Socket.Mechanism.PLAIN.name().equals(this.mechanism)) {
                this.username = request.popString();
                this.password = request.popString();
                this.clientKey = null;
                this.principal = null;
            } else if (ZMQ.Socket.Mechanism.CURVE.name().equals(this.mechanism)) {
                ZFrame frame = request.pop();
                byte[] clientPublicKey = frame.getData();
                this.username = null;
                this.password = null;
                this.clientKey = ZMQ.Curve.z85Encode(clientPublicKey);
                this.principal = null;
            } else if (Mechanisms.GSSAPI.name().equals(this.mechanism)) {
                this.username = null;
                this.password = null;
                this.clientKey = null;
                this.principal = request.popString();
            } else {
                this.username = null;
                this.password = null;
                this.clientKey = null;
                this.principal = null;
            }
        }

        private static ZapRequest recvRequest(ZMQ.Socket handler, boolean wait) {
            ZMsg request = ZMsg.recvMsg(handler, wait);
            if (request == null) {
                return null;
            }
            ZapRequest self = new ZapRequest(handler, request);
            assert (ZAuth.ZAP_VERSION.equals(self.version));
            request.destroy();
            return self;
        }

        private void reply(int statusCode, String statusText, ZMQ.Socket replies) {
            ZapReply reply = new ZapReply(ZAuth.ZAP_VERSION, this.sequence, statusCode, statusText, this.userId, this.metadata);
            ZMsg msg = reply.msg();
            boolean destroy = replies == null;
            msg.send(this.handler, destroy);
            if (replies != null) {
                msg.add(this.address);
                msg.add(this.identity);
                msg.send(replies);
            }
        }
    }

    public static interface Auth {
        public boolean configure(ZMsg var1, boolean var2);

        public boolean authorize(ZapRequest var1, boolean var2);
    }
}

