/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.shaded.org.zeromq.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dflib.jjava.shaded.org.zeromq.ZConfig;
import org.dflib.jjava.shaded.org.zeromq.ZMQ;
import org.dflib.jjava.shaded.zmq.io.Metadata;

public class ZMetadata {
    private final Metadata metadata;

    public ZMetadata() {
        this(new Metadata());
    }

    public ZMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Set<String> keySet() {
        return this.metadata.keySet();
    }

    public String get(String key) {
        return this.metadata.get(key);
    }

    public void set(String key, String value) {
        this.metadata.put(key, value);
    }

    public void remove(String key) {
        this.metadata.remove(key);
    }

    public byte[] bytes() {
        return this.metadata.bytes();
    }

    public String toString() {
        return this.metadata.toString();
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZMetadata zMetadata = (ZMetadata)o;
        return Objects.equals(this.metadata, zMetadata.metadata);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.metadata.entrySet();
    }

    public Collection<String> values() {
        return this.metadata.values();
    }

    public void set(Metadata zapProperties) {
        this.metadata.set(zapProperties);
    }

    public boolean isEmpty() {
        return this.metadata.isEmpty();
    }

    public boolean containsKey(String property) {
        return this.metadata.containsKey(property);
    }

    public void clear() {
        this.metadata.clear();
    }

    public int size() {
        return this.metadata.size();
    }

    public void write(OutputStream stream) throws IOException {
        this.metadata.write(stream);
    }

    public static ZMetadata read(String meta) {
        if (meta == null || meta.isEmpty()) {
            return null;
        }
        try {
            ByteBuffer buffer = ZMQ.CHARSET.newEncoder().encode(CharBuffer.wrap(meta));
            Metadata data = new Metadata();
            data.read(buffer, 0, null);
            return new ZMetadata(data);
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Not a parsable metadata string");
        }
    }

    public static ZMetadata read(ZConfig conf) {
        ZConfig meta = conf.getChild("metadata");
        if (meta == null) {
            return null;
        }
        ZMetadata metadata = new ZMetadata();
        for (Map.Entry<String, String> entry : meta.getValues().entrySet()) {
            metadata.set(entry.getKey(), entry.getValue());
        }
        return metadata;
    }
}

