/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jjava.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class KernelLauncher {
    private static final Logger LOGGER = Logger.getLogger("KernelLauncher");
    private static final String JUL_JUPYTER_LOG_FORMAT = "[%4$.1s %1$tF %1$tT.%1$tL %3$s] %5$s%n";
    private static final String JJAVA_JVM_OPTS = "JJAVA_JVM_OPTS";
    private final List<String> args;

    public KernelLauncher(List<String> args) {
        this.args = args;
    }

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", JUL_JUPYTER_LOG_FORMAT);
        KernelLauncher launcher = new KernelLauncher(Arrays.asList(args));
        int exitCode = launcher.launchKernel();
        System.exit(exitCode);
    }

    public int launchKernel() {
        List<String> command = this.buildCommand(this.args);
        LOGGER.info(() -> "Starting kernel: " + String.valueOf(command));
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process kernel = pb.start();
            this.addShutdownHook(kernel);
            return kernel.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook(Process kernel) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.fine("Terminating kernel...");
            kernel.destroy();
            try {
                kernel.waitFor();
                LOGGER.info("Kernel terminated.");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private List<String> buildCommand(List<String> args) {
        if (args.size() < 2) {
            throw new RuntimeException(this.buildErrorMessage(args));
        }
        String kernelPath = args.get(0);
        String connectionFile = args.get(1);
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        String jvmOptions = System.getenv(JJAVA_JVM_OPTS);
        if (jvmOptions != null && !jvmOptions.isBlank()) {
            String[] options = jvmOptions.split("\\s+");
            command.addAll(Arrays.asList(options));
        }
        command.add("--add-opens");
        command.add("jdk.jshell/jdk.jshell=ALL-UNNAMED");
        command.add("-jar");
        command.add(kernelPath);
        command.add(connectionFile);
        return command;
    }

    private String buildErrorMessage(List<String> args) {
        switch (args.size()) {
            case 0: {
                return "Missing arguments: <kernel_path> <connection_file>%n";
            }
            case 1: {
                return String.format("Missing arguments: %s <connection_file>%n", args.get(0));
            }
        }
        return String.format("Arguments provided: %s%n", String.join((CharSequence)", ", args));
    }
}

