from lupa._lupa import LuaRuntime

def SumString(table : list) -> str:
    """
    Connects all the strings in the list to a single string, optimal for the output of JLua.GetLuaString()

    :param table: A string list like generated by readlines() or GetLuaString()
    :return: The Connected string
    """
    sumstring = ""
    for string in table: sumstring += string
    return sumstring

def GetLuaString(obj) -> list:
    """
    The main converting function. Can convert the basic types, if the type(obj) is not one of the basic python types, the function tries to get the repr of the obj

    :param obj: Can be any python-object, but stick to convertion rules
    :return: Lua-String returned as a list like open().readlines()
    """
    luastring = [ ]
    # print(type(obj))
    if type(obj) == type(dict()):
        luastring.append("\n{\n")
        for index, entry in enumerate(obj):
            luastring.append(str(entry) + " = " + SumString(GetLuaString(obj[entry])) + ",\n")
        luastring.append("}")

        luastring = SumString(luastring).split("\n")
        luastring.remove("")
        for i in range(1, len(luastring) - 1): 
            luastring[i] = "    " + luastring[i] + "\n"
        luastring[0] = luastring[0] + "\n"

    elif type(obj) == type(list()):
        sumstring = "{ "
        for entry in obj: sumstring += SumString(GetLuaString(entry)) + ", "
        sumstring += "}"
        sumStringList = sumstring.split("\n")
        for i in range(0, len(sumStringList) - 1):
            sumStringList[i] += "\n"
            luastring.append(sumStringList[i])
        luastring.append(sumStringList[len(sumStringList) - 1])

    elif type(obj) == type(str()):
        luastring.append("\"" + obj + "\"")

    elif type(obj) == type(int()):
        luastring = [ str(obj) ]

    else:
        luastring.append("\"" + repr(obj) + "\"")

    return luastring

# Decoding
def DecodeToDict(luaString : str = "", useDecoded : bool = False, decoded = None) -> dict:
    """
    Decode a Lua-Table to a python-Dict

    :param luaString: The LuaCode to eval to a Lua-Table and edit the return dictionary
    :param useDecoded: True if a pre-evaluated Lua-table should be used
    :param decoded: The already decoded table, mostly used for the algorythm itself
    :return: Converted Python-dict
    """
    lua = LuaRuntime()
    if not useDecoded and (decoded != None):
        decoded = lua.eval(luaString)
    returnDict = { }
    for entry in decoded:
        try:
            attr = getattr(decoded, entry)
        except:
            attr = decoded[entry]

        if type(attr) == type(lua.eval("{ }")):
            attr = DecodeToDict(useDecoded=True, decoded=attr)
        # print(entry, attr)
        if type(entry) == type(int()): entry -= 1
        returnDict[entry] = attr
    return returnDict

class LuaCreatedClass(): 
    """
    Used by the DecodeToClass() function
    """
    pass  

def DecodeToClass(luaString : str = "", configClass = LuaCreatedClass(), useDecoded : bool = False, decoded = None):
    """
    Decode a Lua-Table to a python-Class
    AutoClass: JLua.LuaCreatedClass

    :param luaString: The LuaCode to eval to a Lua-Table and edit the return dictionary
    :param configClass: The class to set the in the table given args to
    :param useDecoded: True if a pre-evaluated Lua-table should be used
    :param decoded: The already decoded table, mostly used for the algorythm itself
    :return: Converted Python-class [ JLua.LuaCreatedClass ]
    """
    try:
        lua = LuaRuntime()
        if not useDecoded:
            decoded = lua.eval(luaString)
        for entry in decoded:
            # print(type(entry), entry)
            try:
                attr = getattr(decoded, entry)
            except TypeError:
                attr = entry
            if type(attr) == type(lua.eval("{ }")):
                if type(configClass) == type(LuaCreatedClass()):
                    attr = DecodeToClass(useDecoded=True, decoded=attr)
                else:
                    attr = DecodeToClass(configClass=getattr(configClass, entry), useDecoded=True, decoded=attr)
            setattr(configClass, entry, attr)
        return configClass
    except TypeError:
        raise TypeError("Not string type arg detected, class attributes can only be created of a string")