## [0.2.1](https://github.com/tainora/jobber-python-client/compare/v0.2.0...v0.2.1) (2025-11-23)


### Bug Fixes

* apply ruff auto-fixes and consistent formatting ([377ea7e](https://github.com/tainora/jobber-python-client/commit/377ea7ea6b0733fd82da9fd964a1d1d4daaf31e1))

# Changelog

All notable changes to this project will be documented in this file.

This changelog is automatically generated by [semantic-release](https://github.com/semantic-release/semantic-release) based on [Conventional Commits](https://www.conventionalcommits.org/).

## [0.2.0] - 2025-11-22

### Features

#### Webhook Support

- Add HMAC-SHA256 signature validation for Jobber webhook events
- Add webhook event parsing (JSON → Python dict)
- Add event type constants (QUOTE_APPROVED, INVOICE_PAID, VISIT_COMPLETE, etc.)
- Add Flask example webhook endpoint (`examples/webhook_handler.py`)
- Add 16 unit tests (100% pass rate)
- Enable real-time automation vs 5-minute polling latency

#### Photo Upload Integration

- Add S3 presigned URL generation for mobile photo uploads
- Add `attach_photos_to_visit()` helper (links photos via notes)
- Add Doppler S3 credentials integration
- Add complete photo upload workflow example (`examples/photo_upload_workflow.py`)
- Unblocks Work Completion phase autonomy (70% → 90%)

#### Schema Introspection

- Add GraphQL `__schema` query executor with disk caching
- Add `extract_field_descriptions()` for AI context
- Add `compare_schemas()` for change detection
- Add schema cache management (`~/.cache/jobber/schema.json`)
- Improves AI query accuracy via dynamic type validation

### Documentation

- Add ADR-0007: AI Agent Enhancements (MADR format)
- Add plan-0007: Implementation plan (Google Design Doc format)
- Add jobber-api-ai-readiness-report.md (8.5/10 readiness score)
- Add 3 example scripts (webhook_handler, photo_upload_workflow, schema_introspection)
- Add comprehensive docstrings and type hints

### Dependencies

- Add `boto3>=1.35.0` for S3 integration
- Update uv.lock with boto3 dependencies (botocore, s3transfer, jmespath)

### Quality Assurance

- ✅ All unit tests pass (42/42 tests: 26 auth + 16 webhooks)
- ✅ Type checking clean (mypy 0 errors)
- ⚠️  Linting: 2 errors fixed post-release (ruff formatting applied in v0.2.1)
- ✅ Code follows fail-fast error handling patterns

## [0.1.1] - 2025-11-22

### Fixed

- **Package metadata** - Correct author from "Terry Li" to "tainora" in pyproject.toml and package.json
- **Repository URLs** - Update all GitHub URLs from terryli to tainora account

## [0.1.0] - 2025-11-22

Initial development of Jobber Python client library with OAuth 2.0 PKCE authentication.

### Features

- OAuth 2.0 Authorization Code flow with PKCE
- Doppler secrets manager integration for token storage
- Automatic token refresh (proactive and reactive)
- GraphQL query builder and client
- Thread-safe TokenManager
- Comprehensive error handling
- Type-safe implementation with mypy
- OAuth PKCE skill extraction for reusability
- **Visual confirmation URLs** - Get web links (jobberWebUri) for instant verification of API operations in Jobber's web UI
- URL helper utilities - Format success messages with clickable terminal hyperlinks (ANSI OSC 8)
- **Unit tests** - 19 pytest tests for url_helpers module ensuring correctness SLO
- **Skill extraction** - Two validated workflow patterns extracted as atomic project-local skills:
  - `visual-confirmation-urls` skill (SKILL.md + 3 references + 5 examples + parameterized template)
  - `graphql-query-execution` skill (SKILL.md + 4 references + 4 examples + parameterized template)

### Fixed

- **OAuth token handling** - Default `expires_in` to 3600 seconds when Jobber omits field in OAuth response
- **GraphQL schema** - Correct mutation type `ClientCreate` → `ClientCreateInput` based on API error feedback
- **Example scripts** - Update `test_create_client_url.py` and `visual_confirmation_urls.py` with correct schemas

### Validated

- **End-to-end OAuth flow** - Browser authorization, PKCE code exchange, Doppler storage
- **GraphQL queries** - List existing clients with real Jobber data
- **GraphQL mutations** - Create clients with correct schemas
- **Visual confirmation URLs** - Clickable iTerm2 hyperlinks to actual Jobber resources
- **All example scripts** - Validated against live Jobber API:
  - `examples/basic_usage.py` - Account queries, pagination, throttle status
  - `examples/error_handling.py` - Exception hierarchy and recovery patterns
  - `examples/visual_confirmation_urls.py` - URL helpers and confirmation workflow

### Documentation

- Architecture Decision Record (ADR-0002): OAuth PKCE skill extraction
- Architecture Decision Record (ADR-0003): Visual confirmation URL pattern
- Architecture Decision Record (ADR-0004): URL helpers unit testing strategy
- Architecture Decision Record (ADR-0005): Skill extraction for visual URLs and GraphQL patterns
- **Architecture Decision Record (ADR-0006): Production readiness and API validation**
- Skill: oauth-pkce-doppler with templates and examples
- Skill: visual-confirmation-urls (API-agnostic URL confirmation pattern)
- Skill: graphql-query-execution (error handling, pagination, rate limiting)
- Reference documentation for PKCE, security, Doppler integration
- Visual confirmation URLs guide with use cases and best practices
- Hub-and-spoke documentation architecture
- **Production readiness plan** - Google Design Doc format with phases and SLOs
- **API limitations documented** - Jobber does not support client deletion via GraphQL API

---

**Note**: Once the first release is published, this file will be automatically updated by semantic-release with version numbers, dates, and commit details.
