<img src="https://i.esdrop.com/d/7o0dj05m8rnz/JNGCMedl18.png" width="45%">

[![PyPI version shields.io](https://img.shields.io/pypi/v/jupyterlab-visualpython)](https://pypi.python.org/pypi/jupyterlab-visualpython/)
![Python: 3.x](https://img.shields.io/badge/Python-3.x-yellowgreen)
[![License: GPLv3](https://img.shields.io/badge/License-GPLv3-brightgreen)](https://github.com/visualpython/visualpython/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/personalized-badge/visualpython?period=total&units=international_system&left_color=grey&right_color=orange&left_text=Downloads)](https://pepy.tech/project/visualpython)
[![Issues: ](https://img.shields.io/github/issues/visualpython/visualpython?color=%23FF6347)](https://github.com/visualpython/visualpython/issues)
[![lite-badge]][lite]

[lite-badge]: https://jupyterlite.rtfd.io/en/latest/_static/badge.svg
[lite]: https://visualpython.github.io/visualpython-lite/lab/index.html

## Introduction
Visual Python is a GUI-based Python code generator, developed on the **Jupyter Lab**, **Jupyter Notebook** and **Google Colab** as an extension. <br>
Visual Python is an open source project started for students who struggle with coding during Python classes for data science.

<br>

Try Visual Python if you would like to: <br>
* manage big data with minimal coding skills. <br>
* help students / business analysts / researchers to overcome learning barriers for Python. <br>
* save & reuse repeatedly used codes(snippets). <br>

<br>
<img src="https://raw.githubusercontent.com/visualpython/visualpython/main/visualpython/img/Visual%20Python_2.2.8.gif" width="95%">

## Getting Started with Jupyter Lab

### 1. Requirements

Visual Python is an extension to Jupyter Lab, so you must have Jupyter Lab installed already.<br>
- Python version 3.x
- Jupyter lab environment(<= 3.6.3)

### 2. How to Install

**1)  Install package from PyPI**
```
pip install jupyterlab-visualpython
```

**2)  Activate Visual Python on Jupyter Lab**

Click orange square button on the right side of the Jupyter Lab. 

## Getting Started with Jupyter Notebook

### 1. Requirements

Visual Python is an extension to Jupyter Notebook, so you must have Jupyter Notebook installed already.<br>
- Python version 3.x
- Jupyter notebook environment

### 2. How to Install

**1)  Install package from PyPI**
```
pip install visualpython
```

**2)  Enable the package**
```
visualpy install
```

**3)  Activate Visual Python on Jupyter Notebook**

Click orange square button on the right side of the Jupyter Notebook menu bar. 

### 3. Package Control Info
* Usage: visualpy **[option]** <br>
* Optional arguments:

```
help       - show help menu
install    - install packages
uninstall  - uninstall packages
upgrade    - version upgrade
version    - version check
```

## Getting Started with Google Colab
### 1. Requirements

Visual Python is an extension to Google Colab, so you must have Google Colab opened.<br>
- Google Colab

### 2. How to Install

**1)  Install package using Chrome Web Store**
- [Link to Visual Python for Colab](https://chrome.google.com/webstore/detail/visual-python-for-colab/ccmkpknjfagaldcgidgcipbpdipfopob)

**2)  Open Google Colab**
- [Link to Google Colab](https://colab.research.google.com/)

**3)  Activate Visual Python on Google Colab**


## Getting Started with Visual Python Desktop
### 1. Introduction
Visual Python Desktop is an installer to create an isolated jupyter environment and enable to use Visual Python easily.

It simplifies the process of configuring an independent Python environment, installing essential packages, and setting up a Jupyter environment, allowing users to focus on data analysis using python.

### 2. Requirements
- Operating System: Windows 10 or later (macOS and Linux support coming soon)
- Minimum 4GB RAM, recommended 8GB RAM or higher
- Minimum 10GB of disk space

### 3. How to Install
1) Download the Visual Python Desktop installer.
- [Link to Visual Python Desktop installer page](https://visualpython.ai/visualpython-desktop)

2) Run the installer and follow the provided instructions for the installation process.

3) Use the shortcut created in Start menu or on Desktop to execute Jupyter Notebook (Visual Python), Jupyter Lab (Visual Python), and Visual Python Prompt according to your needs.

## Contributing
If you are interested in contributing to the Visual Python, please see [`CONTRIBUTING.md`](CONTRIBUTING.md). <br>
All skills from programmers, non-programmers, designers are welcomed.

* Programming Guide: [Developer Documentation](https://bird-energy-733.notion.site/visualpython-docs-85c0274ff7564747bb8e8d77909fc8b7)
* GUI Design Guide: [Visual Python GUI Kit 1.0](https://www.figma.com/community/file/976035035360380841)

## License
GNU GPLv3 with Visual Python special exception (See LICENSE file).

## Mission & Vision
**Mission** <br>
To support technology and education so that anyone can leverage big data analytical skills to create a variety of social values.

**Vision** <br>
To create an environment where everyone can learn and use big data analytical skills easily.

## Support Visual Python
Love Visual Python? <br>
Your support will help us continue to actively develop and improve Visual Python.☕

[![donate_banner](https://user-images.githubusercontent.com/83636412/229679467-4fee93a2-d6d2-4229-a53c-80a5eb2b9240.png)](https://github.com/sponsors/visualpython?frequency=recurring)