"""Generated from gga_c_bmk.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t10 = 3 ** (0.1e1 / 0.3e1)
  t12 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t13 = t10 * t12
  t14 = 4 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = t13 * t15
  t17 = t3 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = t18 * t19
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t23 = t6 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t7, t22, 0.1e1 / t23)
  t27 = t16 * t20 * t25
  t29 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t27
  t30 = jnp.sqrt(t27)
  t33 = t27 ** 0.15e1
  t35 = t10 ** 2
  t36 = t12 ** 2
  t37 = t35 * t36
  t38 = t37 * t14
  t39 = t17 ** 2
  t40 = 0.1e1 / t39
  t41 = t19 ** 2
  t42 = t40 * t41
  t43 = t25 ** 2
  t45 = t38 * t42 * t43
  t47 = 0.23615790870000000000000000000000000000000000000000e0 * t30 + 0.55771035800000000000000000000000000000000000000000e-1 * t27 + 0.12733319050000000000000000000000000000000000000000e-1 * t33 + 0.76629987700000000000000000000000000000000000000000e-2 * t45
  t49 = 0.1e1 + 0.1e1 / t47
  t50 = jnp.log(t49)
  t51 = t29 * t50
  t53 = t21 * f.p.zeta_threshold
  t55 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t53, 0.2e1 * t19)
  t57 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t53, 0)
  t61 = 0.1e1 / (0.2e1 * t19 - 0.2e1)
  t62 = (t55 + t57 - 0.2e1) * t61
  t64 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t27
  t69 = 0.21947830050000000000000000000000000000000000000000e0 * t30 + 0.48171623250000000000000000000000000000000000000000e-1 * t27 + 0.13081894750000000000000000000000000000000000000000e-1 * t33 + 0.48591338250000000000000000000000000000000000000000e-2 * t45
  t71 = 0.1e1 + 0.1e1 / t69
  t72 = jnp.log(t71)
  t75 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t27
  t80 = 0.17489865900000000000000000000000000000000000000000e0 * t30 + 0.30591644850000000000000000000000000000000000000000e-1 * t27 + 0.37162376550000000000000000000000000000000000000000e-2 * t33 + 0.41939708850000000000000000000000000000000000000000e-2 * t45
  t82 = 0.1e1 + 0.1e1 / t80
  t83 = jnp.log(t82)
  t84 = t75 * t83
  t90 = -t51 + t62 * (-t64 * t72 + t51 - 0.58482233974552040708313425006184496242808878304904e0 * t84) + 0.58482233974552040708313425006184496242808878304904e0 * t62 * t84
  t93 = f.my_piecewise3(t8, 0, t9 * t90 / 0.2e1)
  t94 = params.c_ss[0]
  t95 = params.c_ss[1]
  t96 = t95 * s0
  t97 = r0 ** 2
  t98 = r0 ** (0.1e1 / 0.3e1)
  t99 = t98 ** 2
  t101 = 0.1e1 / t99 / t97
  t102 = s0 * t101
  t104 = 0.1e1 + 0.2e0 * t102
  t105 = 0.1e1 / t104
  t109 = params.c_ss[2]
  t110 = s0 ** 2
  t111 = t109 * t110
  t112 = t97 ** 2
  t113 = t112 * r0
  t116 = t104 ** 2
  t117 = 0.1e1 / t116
  t118 = 0.1e1 / t98 / t113 * t117
  t121 = params.c_ss[3]
  t122 = t110 * s0
  t123 = t121 * t122
  t124 = t112 ** 2
  t127 = 0.1e1 / t116 / t104
  t128 = 0.1e1 / t124 * t127
  t131 = params.c_ss[4]
  t132 = t110 ** 2
  t133 = t131 * t132
  t137 = t116 ** 2
  t138 = 0.1e1 / t137
  t139 = 0.1e1 / t99 / t124 / t97 * t138
  t142 = t94 + 0.2e0 * t96 * t101 * t105 + 0.4e-1 * t111 * t118 + 0.8e-2 * t123 * t128 + 0.16e-2 * t133 * t139
  t143 = t93 * t142
  t145 = 0.1e1 - t5
  t146 = t145 <= f.p.zeta_threshold
  t147 = r1 <= f.p.dens_threshold or t146
  t148 = f.my_piecewise3(t146, f.p.zeta_threshold, t145)
  t149 = t145 ** (0.1e1 / 0.3e1)
  t151 = f.my_piecewise3(t146, t22, 0.1e1 / t149)
  t153 = t16 * t20 * t151
  t155 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t153
  t156 = jnp.sqrt(t153)
  t159 = t153 ** 0.15e1
  t161 = t151 ** 2
  t163 = t38 * t42 * t161
  t165 = 0.23615790870000000000000000000000000000000000000000e0 * t156 + 0.55771035800000000000000000000000000000000000000000e-1 * t153 + 0.12733319050000000000000000000000000000000000000000e-1 * t159 + 0.76629987700000000000000000000000000000000000000000e-2 * t163
  t167 = 0.1e1 + 0.1e1 / t165
  t168 = jnp.log(t167)
  t169 = t155 * t168
  t171 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t153
  t176 = 0.21947830050000000000000000000000000000000000000000e0 * t156 + 0.48171623250000000000000000000000000000000000000000e-1 * t153 + 0.13081894750000000000000000000000000000000000000000e-1 * t159 + 0.48591338250000000000000000000000000000000000000000e-2 * t163
  t178 = 0.1e1 + 0.1e1 / t176
  t179 = jnp.log(t178)
  t182 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t153
  t187 = 0.17489865900000000000000000000000000000000000000000e0 * t156 + 0.30591644850000000000000000000000000000000000000000e-1 * t153 + 0.37162376550000000000000000000000000000000000000000e-2 * t159 + 0.41939708850000000000000000000000000000000000000000e-2 * t163
  t189 = 0.1e1 + 0.1e1 / t187
  t190 = jnp.log(t189)
  t191 = t182 * t190
  t197 = -t169 + t62 * (-t171 * t179 + t169 - 0.58482233974552040708313425006184496242808878304904e0 * t191) + 0.58482233974552040708313425006184496242808878304904e0 * t62 * t191
  t200 = f.my_piecewise3(t147, 0, t148 * t197 / 0.2e1)
  t201 = t95 * s2
  t202 = r1 ** 2
  t203 = r1 ** (0.1e1 / 0.3e1)
  t204 = t203 ** 2
  t206 = 0.1e1 / t204 / t202
  t207 = s2 * t206
  t209 = 0.1e1 + 0.2e0 * t207
  t210 = 0.1e1 / t209
  t214 = s2 ** 2
  t215 = t109 * t214
  t216 = t202 ** 2
  t217 = t216 * r1
  t220 = t209 ** 2
  t221 = 0.1e1 / t220
  t222 = 0.1e1 / t203 / t217 * t221
  t225 = t214 * s2
  t226 = t121 * t225
  t227 = t216 ** 2
  t230 = 0.1e1 / t220 / t209
  t231 = 0.1e1 / t227 * t230
  t234 = t214 ** 2
  t235 = t131 * t234
  t239 = t220 ** 2
  t240 = 0.1e1 / t239
  t241 = 0.1e1 / t204 / t227 / t202 * t240
  t244 = t94 + 0.2e0 * t201 * t206 * t210 + 0.4e-1 * t215 * t222 + 0.8e-2 * t226 * t231 + 0.16e-2 * t235 * t241
  t245 = t200 * t244
  t247 = t13 * t15 * t18
  t249 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t247
  t250 = jnp.sqrt(t247)
  t253 = t247 ** 0.15e1
  t256 = t37 * t14 * t40
  t258 = 0.23615790870000000000000000000000000000000000000000e0 * t250 + 0.55771035800000000000000000000000000000000000000000e-1 * t247 + 0.12733319050000000000000000000000000000000000000000e-1 * t253 + 0.76629987700000000000000000000000000000000000000000e-2 * t256
  t260 = 0.1e1 + 0.1e1 / t258
  t261 = jnp.log(t260)
  t262 = t249 * t261
  t263 = t2 ** 2
  t264 = t263 ** 2
  t265 = t3 ** 2
  t266 = t265 ** 2
  t267 = 0.1e1 / t266
  t268 = t264 * t267
  t269 = t23 * t6
  t270 = f.my_piecewise3(t7, t53, t269)
  t271 = t149 * t145
  t272 = f.my_piecewise3(t146, t53, t271)
  t274 = (t270 + t272 - 0.2e1) * t61
  t276 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t247
  t281 = 0.21947830050000000000000000000000000000000000000000e0 * t250 + 0.48171623250000000000000000000000000000000000000000e-1 * t247 + 0.13081894750000000000000000000000000000000000000000e-1 * t253 + 0.48591338250000000000000000000000000000000000000000e-2 * t256
  t283 = 0.1e1 + 0.1e1 / t281
  t284 = jnp.log(t283)
  t287 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t247
  t292 = 0.17489865900000000000000000000000000000000000000000e0 * t250 + 0.30591644850000000000000000000000000000000000000000e-1 * t247 + 0.37162376550000000000000000000000000000000000000000e-2 * t253 + 0.41939708850000000000000000000000000000000000000000e-2 * t256
  t294 = 0.1e1 + 0.1e1 / t292
  t295 = jnp.log(t294)
  t296 = t287 * t295
  t298 = -t276 * t284 + t262 - 0.58482233974552040708313425006184496242808878304904e0 * t296
  t299 = t274 * t298
  t303 = -t262 + t268 * t299 + 0.58482233974552040708313425006184496242808878304904e0 * t274 * t296 - t93 - t200
  t305 = params.c_ab[1]
  t306 = 0.30000000000000000000000000000000000000000000000000e-2 * t102
  t307 = 0.30000000000000000000000000000000000000000000000000e-2 * t207
  t308 = t306 + t307
  t309 = t305 * t308
  t310 = 0.1e1 + t306 + t307
  t311 = 0.1e1 / t310
  t313 = params.c_ab[2]
  t314 = t308 ** 2
  t315 = t313 * t314
  t316 = t310 ** 2
  t317 = 0.1e1 / t316
  t319 = params.c_ab[3]
  t320 = t314 * t308
  t321 = t319 * t320
  t323 = 0.1e1 / t316 / t310
  t325 = params.c_ab[4]
  t326 = t314 ** 2
  t327 = t325 * t326
  t328 = t316 ** 2
  t329 = 0.1e1 / t328
  t331 = t309 * t311 + t315 * t317 + t321 * t323 + t327 * t329 + params.c_ab[0]
  t332 = t303 * t331
  t334 = t2 / t265
  t335 = t4 - t334
  t336 = f.my_piecewise3(t7, 0, t335)
  t339 = 0.1e1 / t17 / t3
  t340 = t339 * t19
  t342 = t16 * t340 * t25
  t343 = 0.11073577833333333333333333333333333333333333333333e-2 * t342
  t344 = 0.1e1 / t269
  t347 = f.my_piecewise3(t7, 0, -t344 * t335 / 0.3e1)
  t349 = t16 * t20 * t347
  t352 = (-t343 + 0.33220733500000000000000000000000000000000000000000e-2 * t349) * t50
  t353 = t47 ** 2
  t355 = t29 / t353
  t356 = 0.1e1 / t30
  t357 = t342 / 0.3e1
  t358 = -t357 + t349
  t359 = t356 * t358
  t361 = 0.18590345266666666666666666666666666666666666666667e-1 * t342
  t363 = t27 ** 0.5e0
  t364 = t363 * t358
  t367 = 0.1e1 / t39 / t3
  t368 = t367 * t41
  t370 = t38 * t368 * t43
  t371 = 0.51086658466666666666666666666666666666666666666667e-2 * t370
  t374 = t38 * t42 * t25 * t347
  t377 = 0.1e1 / t49
  t379 = t355 * (0.11807895435000000000000000000000000000000000000000e0 * t359 - t361 + 0.55771035800000000000000000000000000000000000000000e-1 * t349 + 0.19099978575000000000000000000000000000000000000000e-1 * t364 - t371 + 0.15325997540000000000000000000000000000000000000000e-1 * t374) * t377
  t380 = 0.53236443333333333333333333333333333333333333333333e-3 * t342
  t384 = t69 ** 2
  t386 = t64 / t384
  t388 = 0.16057207750000000000000000000000000000000000000000e-1 * t342
  t391 = 0.32394225500000000000000000000000000000000000000000e-2 * t370
  t394 = 0.1e1 / t71
  t397 = 0.31311312500000000000000000000000000000000000000000e-3 * t342
  t400 = (-t397 + 0.93933937500000000000000000000000000000000000000000e-3 * t349) * t83
  t402 = t80 ** 2
  t403 = 0.1e1 / t402
  t404 = t75 * t403
  t406 = 0.10197214950000000000000000000000000000000000000000e-1 * t342
  t409 = 0.27959805900000000000000000000000000000000000000000e-2 * t370
  t411 = 0.87449329500000000000000000000000000000000000000000e-1 * t359 - t406 + 0.30591644850000000000000000000000000000000000000000e-1 * t349 + 0.55743564825000000000000000000000000000000000000000e-2 * t364 - t409 + 0.83879417700000000000000000000000000000000000000000e-2 * t374
  t412 = 0.1e1 / t82
  t420 = t62 * t75
  t429 = f.my_piecewise3(t8, 0, t336 * t90 / 0.2e1 + t9 * (-t352 + t379 + t62 * (-(-t380 + 0.15970933000000000000000000000000000000000000000000e-2 * t349) * t72 + t386 * (0.10973915025000000000000000000000000000000000000000e0 * t359 - t388 + 0.48171623250000000000000000000000000000000000000000e-1 * t349 + 0.19622842125000000000000000000000000000000000000000e-1 * t364 - t391 + 0.97182676500000000000000000000000000000000000000000e-2 * t374) * t394 + t352 - t379 - 0.58482233974552040708313425006184496242808878304904e0 * t400 + 0.58482233974552040708313425006184496242808878304904e0 * t404 * t411 * t412) + 0.58482233974552040708313425006184496242808878304904e0 * t62 * t400 - 0.58482233974552040708313425006184496242808878304904e0 * t420 * t403 * t411 * t412) / 0.2e1)
  t431 = t97 * r0
  t433 = 0.1e1 / t99 / t431
  t438 = t112 * t97
  t441 = 0.1e1 / t98 / t438 * t117
  t449 = 0.1e1 / t124 / r0 * t127
  t458 = 0.1e1 / t99 / t124 / t431 * t138
  t469 = 0.1e1 / t137 / t104
  t475 = -t335
  t476 = f.my_piecewise3(t146, 0, t475)
  t479 = t16 * t340 * t151
  t480 = 0.11073577833333333333333333333333333333333333333333e-2 * t479
  t481 = 0.1e1 / t271
  t484 = f.my_piecewise3(t146, 0, -t481 * t475 / 0.3e1)
  t486 = t16 * t20 * t484
  t489 = (-t480 + 0.33220733500000000000000000000000000000000000000000e-2 * t486) * t168
  t490 = t165 ** 2
  t492 = t155 / t490
  t493 = 0.1e1 / t156
  t494 = t479 / 0.3e1
  t495 = -t494 + t486
  t496 = t493 * t495
  t498 = 0.18590345266666666666666666666666666666666666666667e-1 * t479
  t500 = t153 ** 0.5e0
  t501 = t500 * t495
  t504 = t38 * t368 * t161
  t505 = 0.51086658466666666666666666666666666666666666666667e-2 * t504
  t508 = t38 * t42 * t151 * t484
  t511 = 0.1e1 / t167
  t513 = t492 * (0.11807895435000000000000000000000000000000000000000e0 * t496 - t498 + 0.55771035800000000000000000000000000000000000000000e-1 * t486 + 0.19099978575000000000000000000000000000000000000000e-1 * t501 - t505 + 0.15325997540000000000000000000000000000000000000000e-1 * t508) * t511
  t514 = 0.53236443333333333333333333333333333333333333333333e-3 * t479
  t518 = t176 ** 2
  t520 = t171 / t518
  t522 = 0.16057207750000000000000000000000000000000000000000e-1 * t479
  t525 = 0.32394225500000000000000000000000000000000000000000e-2 * t504
  t528 = 0.1e1 / t178
  t531 = 0.31311312500000000000000000000000000000000000000000e-3 * t479
  t534 = (-t531 + 0.93933937500000000000000000000000000000000000000000e-3 * t486) * t190
  t536 = t187 ** 2
  t537 = 0.1e1 / t536
  t538 = t182 * t537
  t540 = 0.10197214950000000000000000000000000000000000000000e-1 * t479
  t543 = 0.27959805900000000000000000000000000000000000000000e-2 * t504
  t545 = 0.87449329500000000000000000000000000000000000000000e-1 * t496 - t540 + 0.30591644850000000000000000000000000000000000000000e-1 * t486 + 0.55743564825000000000000000000000000000000000000000e-2 * t501 - t543 + 0.83879417700000000000000000000000000000000000000000e-2 * t508
  t546 = 0.1e1 / t189
  t554 = t62 * t182
  t563 = f.my_piecewise3(t147, 0, t476 * t197 / 0.2e1 + t148 * (-t489 + t513 + t62 * (-(-t514 + 0.15970933000000000000000000000000000000000000000000e-2 * t486) * t179 + t520 * (0.10973915025000000000000000000000000000000000000000e0 * t496 - t522 + 0.48171623250000000000000000000000000000000000000000e-1 * t486 + 0.19622842125000000000000000000000000000000000000000e-1 * t501 - t525 + 0.97182676500000000000000000000000000000000000000000e-2 * t508) * t528 + t489 - t513 - 0.58482233974552040708313425006184496242808878304904e0 * t534 + 0.58482233974552040708313425006184496242808878304904e0 * t538 * t545 * t546) + 0.58482233974552040708313425006184496242808878304904e0 * t62 * t534 - 0.58482233974552040708313425006184496242808878304904e0 * t554 * t537 * t545 * t546) / 0.2e1)
  t565 = t15 * t339
  t568 = 0.11073577833333333333333333333333333333333333333333e-2 * t13 * t565 * t261
  t569 = t258 ** 2
  t574 = t12 * t15
  t575 = t574 * t339
  t576 = 0.1e1 / t250 * t10 * t575
  t578 = t13 * t565
  t580 = t247 ** 0.5e0
  t582 = t580 * t10 * t575
  t585 = t37 * t14 * t367
  t590 = t249 / t569 * (-0.39359651450000000000000000000000000000000000000000e-1 * t576 - 0.18590345266666666666666666666666666666666666666667e-1 * t578 - 0.63666595250000000000000000000000000000000000000000e-2 * t582 - 0.51086658466666666666666666666666666666666666666667e-2 * t585) / t260
  t594 = 0.4e1 * t263 * t2 * t267 * t299
  t599 = 0.4e1 * t264 / t266 / t3 * t299
  t602 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t23 * t335)
  t605 = f.my_piecewise3(t146, 0, 0.4e1 / 0.3e1 * t149 * t475)
  t607 = (t602 + t605) * t61
  t613 = t281 ** 2
  t627 = t292 ** 2
  t628 = 0.1e1 / t627
  t634 = -0.29149776500000000000000000000000000000000000000000e-1 * t576 - 0.10197214950000000000000000000000000000000000000000e-1 * t578 - 0.18581188275000000000000000000000000000000000000000e-2 * t582 - 0.27959805900000000000000000000000000000000000000000e-2 * t585
  t635 = 0.1e1 / t294
  t641 = t268 * t274 * (0.53236443333333333333333333333333333333333333333333e-3 * t13 * t565 * t284 + t276 / t613 * (-0.36579716750000000000000000000000000000000000000000e-1 * t576 - 0.16057207750000000000000000000000000000000000000000e-1 * t578 - 0.65409473750000000000000000000000000000000000000000e-2 * t582 - 0.32394225500000000000000000000000000000000000000000e-2 * t585) / t283 - t568 - t590 + 0.18311555036753159941307229983139571945136646663793e-3 * t13 * t565 * t295 + 0.58482233974552040708313425006184496242808878304904e0 * t287 * t628 * t634 * t635)
  t648 = 0.18311555036753159941307229983139571945136646663793e-3 * t274 * t10 * t574 * t339 * t295
  t653 = 0.58482233974552040708313425006184496242808878304904e0 * t274 * t287 * t628 * t634 * t635
  t654 = t568 + t590 + t594 - t599 + t268 * t607 * t298 + t641 + 0.58482233974552040708313425006184496242808878304904e0 * t607 * t296 - t648 - t653 - t429 - t563
  t661 = t317 * s0 * t433
  t664 = t313 * t308
  t668 = t323 * s0 * t433
  t671 = t319 * t314
  t675 = t329 * s0 * t433
  t678 = t325 * t320
  t682 = 0.1e1 / t328 / t310
  vrho_0_ = t143 + t245 + t332 + t3 * (t429 * t142 + t93 * (-0.53333333333333333333333333333333333333333333333333e0 * t96 * t433 * t105 + 0.10666666666666666666666666666666666666666666666667e0 * t95 * t110 * t441 - 0.21333333333333333333333333333333333333333333333333e0 * t111 * t441 + 0.42666666666666666666666666666666666666666666666668e-1 * t109 * t122 * t449 - 0.64e-1 * t123 * t449 + 0.12800000000000000000000000000000000000000000000000e-1 * t121 * t132 * t458 - 0.17066666666666666666666666666666666666666666666667e-1 * t133 * t458 + 0.34133333333333333333333333333333333333333333333333e-2 * t131 * t132 * s0 / t98 / t124 / t438 * t469) + t563 * t244 + t654 * t331 + t303 * (-0.80000000000000000000000000000000000000000000000000e-2 * t305 * s0 * t433 * t311 + 0.80000000000000000000000000000000000000000000000000e-2 * t309 * t661 - 0.16000000000000000000000000000000000000000000000000e-1 * t664 * t661 + 0.16000000000000000000000000000000000000000000000000e-1 * t315 * t668 - 0.24000000000000000000000000000000000000000000000000e-1 * t671 * t668 + 0.24000000000000000000000000000000000000000000000000e-1 * t321 * t675 - 0.32000000000000000000000000000000000000000000000000e-1 * t678 * t675 + 0.32000000000000000000000000000000000000000000000000e-1 * t327 * t682 * s0 * t433))
  t691 = -t4 - t334
  t692 = f.my_piecewise3(t7, 0, t691)
  t696 = f.my_piecewise3(t7, 0, -t344 * t691 / 0.3e1)
  t698 = t16 * t20 * t696
  t701 = (-t343 + 0.33220733500000000000000000000000000000000000000000e-2 * t698) * t50
  t702 = -t357 + t698
  t703 = t356 * t702
  t706 = t363 * t702
  t710 = t38 * t42 * t25 * t696
  t714 = t355 * (0.11807895435000000000000000000000000000000000000000e0 * t703 - t361 + 0.55771035800000000000000000000000000000000000000000e-1 * t698 + 0.19099978575000000000000000000000000000000000000000e-1 * t706 - t371 + 0.15325997540000000000000000000000000000000000000000e-1 * t710) * t377
  t727 = (-t397 + 0.93933937500000000000000000000000000000000000000000e-3 * t698) * t83
  t733 = 0.87449329500000000000000000000000000000000000000000e-1 * t703 - t406 + 0.30591644850000000000000000000000000000000000000000e-1 * t698 + 0.55743564825000000000000000000000000000000000000000e-2 * t706 - t409 + 0.83879417700000000000000000000000000000000000000000e-2 * t710
  t749 = f.my_piecewise3(t8, 0, t692 * t90 / 0.2e1 + t9 * (-t701 + t714 + t62 * (-(-t380 + 0.15970933000000000000000000000000000000000000000000e-2 * t698) * t72 + t386 * (0.10973915025000000000000000000000000000000000000000e0 * t703 - t388 + 0.48171623250000000000000000000000000000000000000000e-1 * t698 + 0.19622842125000000000000000000000000000000000000000e-1 * t706 - t391 + 0.97182676500000000000000000000000000000000000000000e-2 * t710) * t394 + t701 - t714 - 0.58482233974552040708313425006184496242808878304904e0 * t727 + 0.58482233974552040708313425006184496242808878304904e0 * t404 * t733 * t412) + 0.58482233974552040708313425006184496242808878304904e0 * t62 * t727 - 0.58482233974552040708313425006184496242808878304904e0 * t420 * t403 * t733 * t412) / 0.2e1)
  t751 = -t691
  t752 = f.my_piecewise3(t146, 0, t751)
  t756 = f.my_piecewise3(t146, 0, -t481 * t751 / 0.3e1)
  t758 = t16 * t20 * t756
  t761 = (-t480 + 0.33220733500000000000000000000000000000000000000000e-2 * t758) * t168
  t762 = -t494 + t758
  t763 = t493 * t762
  t766 = t500 * t762
  t770 = t38 * t42 * t151 * t756
  t774 = t492 * (0.11807895435000000000000000000000000000000000000000e0 * t763 - t498 + 0.55771035800000000000000000000000000000000000000000e-1 * t758 + 0.19099978575000000000000000000000000000000000000000e-1 * t766 - t505 + 0.15325997540000000000000000000000000000000000000000e-1 * t770) * t511
  t787 = (-t531 + 0.93933937500000000000000000000000000000000000000000e-3 * t758) * t190
  t793 = 0.87449329500000000000000000000000000000000000000000e-1 * t763 - t540 + 0.30591644850000000000000000000000000000000000000000e-1 * t758 + 0.55743564825000000000000000000000000000000000000000e-2 * t766 - t543 + 0.83879417700000000000000000000000000000000000000000e-2 * t770
  t809 = f.my_piecewise3(t147, 0, t752 * t197 / 0.2e1 + t148 * (-t761 + t774 + t62 * (-(-t514 + 0.15970933000000000000000000000000000000000000000000e-2 * t758) * t179 + t520 * (0.10973915025000000000000000000000000000000000000000e0 * t763 - t522 + 0.48171623250000000000000000000000000000000000000000e-1 * t758 + 0.19622842125000000000000000000000000000000000000000e-1 * t766 - t525 + 0.97182676500000000000000000000000000000000000000000e-2 * t770) * t528 + t761 - t774 - 0.58482233974552040708313425006184496242808878304904e0 * t787 + 0.58482233974552040708313425006184496242808878304904e0 * t538 * t793 * t546) + 0.58482233974552040708313425006184496242808878304904e0 * t62 * t787 - 0.58482233974552040708313425006184496242808878304904e0 * t554 * t537 * t793 * t546) / 0.2e1)
  t811 = t202 * r1
  t813 = 0.1e1 / t204 / t811
  t818 = t216 * t202
  t821 = 0.1e1 / t203 / t818 * t221
  t829 = 0.1e1 / t227 / r1 * t230
  t838 = 0.1e1 / t204 / t227 / t811 * t240
  t849 = 0.1e1 / t239 / t209
  t857 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t23 * t691)
  t860 = f.my_piecewise3(t146, 0, 0.4e1 / 0.3e1 * t149 * t751)
  t862 = (t857 + t860) * t61
  t867 = t568 + t590 - t594 - t599 + t268 * t862 * t298 + t641 + 0.58482233974552040708313425006184496242808878304904e0 * t862 * t296 - t648 - t653 - t749 - t809
  t874 = t317 * s2 * t813
  t880 = t323 * s2 * t813
  t886 = t329 * s2 * t813
  vrho_1_ = t143 + t245 + t332 + t3 * (t749 * t142 + t809 * t244 + t200 * (-0.53333333333333333333333333333333333333333333333333e0 * t201 * t813 * t210 + 0.10666666666666666666666666666666666666666666666667e0 * t95 * t214 * t821 - 0.21333333333333333333333333333333333333333333333333e0 * t215 * t821 + 0.42666666666666666666666666666666666666666666666668e-1 * t109 * t225 * t829 - 0.64e-1 * t226 * t829 + 0.12800000000000000000000000000000000000000000000000e-1 * t121 * t234 * t838 - 0.17066666666666666666666666666666666666666666666667e-1 * t235 * t838 + 0.34133333333333333333333333333333333333333333333333e-2 * t131 * t234 * s2 / t203 / t227 / t818 * t849) + t867 * t331 + t303 * (-0.80000000000000000000000000000000000000000000000000e-2 * t305 * s2 * t813 * t311 + 0.80000000000000000000000000000000000000000000000000e-2 * t309 * t874 - 0.16000000000000000000000000000000000000000000000000e-1 * t664 * t874 + 0.16000000000000000000000000000000000000000000000000e-1 * t315 * t880 - 0.24000000000000000000000000000000000000000000000000e-1 * t671 * t880 + 0.24000000000000000000000000000000000000000000000000e-1 * t321 * t886 - 0.32000000000000000000000000000000000000000000000000e-1 * t678 * t886 + 0.32000000000000000000000000000000000000000000000000e-1 * t327 * t682 * s2 * t813))
  t928 = t317 * t101
  t933 = t323 * t101
  t938 = t329 * t101
  vsigma_0_ = t3 * (t93 * (0.2e0 * t95 * t101 * t105 - 0.4e-1 * t96 * t118 + 0.8e-1 * t109 * s0 * t118 - 0.16e-1 * t111 * t128 + 0.24e-1 * t121 * t110 * t128 - 0.48e-2 * t123 * t139 + 0.64e-2 * t131 * t122 * t139 - 0.128e-2 * t133 / t98 / t124 / t113 * t469) + t303 * (0.30000000000000000000000000000000000000000000000000e-2 * t305 * t101 * t311 - 0.30000000000000000000000000000000000000000000000000e-2 * t309 * t928 + 0.60000000000000000000000000000000000000000000000000e-2 * t664 * t928 - 0.60000000000000000000000000000000000000000000000000e-2 * t315 * t933 + 0.90000000000000000000000000000000000000000000000000e-2 * t671 * t933 - 0.90000000000000000000000000000000000000000000000000e-2 * t321 * t938 + 0.12000000000000000000000000000000000000000000000000e-1 * t678 * t938 - 0.12000000000000000000000000000000000000000000000000e-1 * t327 * t682 * t101))
  vsigma_1_ = 0.0e0
  t978 = t317 * t206
  t983 = t323 * t206
  t988 = t329 * t206
  vsigma_2_ = t3 * (t200 * (0.2e0 * t95 * t206 * t210 - 0.4e-1 * t201 * t222 + 0.8e-1 * t109 * s2 * t222 - 0.16e-1 * t215 * t231 + 0.24e-1 * t121 * t214 * t231 - 0.48e-2 * t226 * t241 + 0.64e-2 * t131 * t225 * t241 - 0.128e-2 * t235 / t203 / t227 / t217 * t849) + t303 * (0.30000000000000000000000000000000000000000000000000e-2 * t305 * t206 * t311 - 0.30000000000000000000000000000000000000000000000000e-2 * t309 * t978 + 0.60000000000000000000000000000000000000000000000000e-2 * t664 * t978 - 0.60000000000000000000000000000000000000000000000000e-2 * t315 * t983 + 0.90000000000000000000000000000000000000000000000000e-2 * t671 * t983 - 0.90000000000000000000000000000000000000000000000000e-2 * t321 * t988 + 0.12000000000000000000000000000000000000000000000000e-1 * t678 * t988 - 0.12000000000000000000000000000000000000000000000000e-1 * t327 * t682 * t206))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = 2 ** (0.1e1 / 0.3e1)
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t3, 0.1e1 / t17, 1)
  t21 = t12 * t14 * t15 * t19
  t23 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t21
  t24 = jnp.sqrt(t21)
  t27 = t21 ** 0.15e1
  t29 = t6 ** 2
  t30 = t8 ** 2
  t31 = t29 * t30
  t32 = t31 * t10
  t33 = t13 ** 2
  t34 = 0.1e1 / t33
  t35 = t15 ** 2
  t37 = t19 ** 2
  t39 = t32 * t34 * t35 * t37
  t41 = 0.23615790870000000000000000000000000000000000000000e0 * t24 + 0.55771035800000000000000000000000000000000000000000e-1 * t21 + 0.12733319050000000000000000000000000000000000000000e-1 * t27 + 0.76629987700000000000000000000000000000000000000000e-2 * t39
  t43 = 0.1e1 + 0.1e1 / t41
  t44 = jnp.log(t43)
  t45 = t23 * t44
  t47 = t17 * f.p.zeta_threshold
  t49 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t47, 0.2e1 * t15)
  t51 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t47, 0)
  t55 = 0.1e1 / (0.2e1 * t15 - 0.2e1)
  t56 = (t49 + t51 - 0.2e1) * t55
  t58 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t21
  t63 = 0.21947830050000000000000000000000000000000000000000e0 * t24 + 0.48171623250000000000000000000000000000000000000000e-1 * t21 + 0.13081894750000000000000000000000000000000000000000e-1 * t27 + 0.48591338250000000000000000000000000000000000000000e-2 * t39
  t65 = 0.1e1 + 0.1e1 / t63
  t66 = jnp.log(t65)
  t69 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t21
  t74 = 0.17489865900000000000000000000000000000000000000000e0 * t24 + 0.30591644850000000000000000000000000000000000000000e-1 * t21 + 0.37162376550000000000000000000000000000000000000000e-2 * t27 + 0.41939708850000000000000000000000000000000000000000e-2 * t39
  t76 = 0.1e1 + 0.1e1 / t74
  t77 = jnp.log(t76)
  t78 = t69 * t77
  t87 = f.my_piecewise3(t4, 0, t5 * (-t45 + t56 * (-t58 * t66 + t45 - 0.58482233974552040708313425006184496242808878304904e0 * t78) + 0.58482233974552040708313425006184496242808878304904e0 * t56 * t78) / 0.2e1)
  t89 = params.c_ss[1]
  t90 = t89 * s0
  t91 = r0 ** 2
  t93 = 0.1e1 / t33 / t91
  t94 = t35 * t93
  t96 = s0 * t35 * t93
  t98 = 0.1e1 + 0.2e0 * t96
  t99 = 0.1e1 / t98
  t103 = params.c_ss[2]
  t104 = s0 ** 2
  t105 = t103 * t104
  t106 = t91 ** 2
  t107 = t106 * r0
  t110 = t15 / t13 / t107
  t111 = t98 ** 2
  t112 = 0.1e1 / t111
  t113 = t110 * t112
  t116 = params.c_ss[3]
  t117 = t104 * s0
  t118 = t116 * t117
  t119 = t106 ** 2
  t120 = 0.1e1 / t119
  t122 = 0.1e1 / t111 / t98
  t123 = t120 * t122
  t126 = params.c_ss[4]
  t127 = t104 ** 2
  t128 = t126 * t127
  t132 = t35 / t33 / t119 / t91
  t133 = t111 ** 2
  t134 = 0.1e1 / t133
  t135 = t132 * t134
  t138 = params.c_ss[0] + 0.2e0 * t90 * t94 * t99 + 0.8e-1 * t105 * t113 + 0.32e-1 * t118 * t123 + 0.64e-2 * t128 * t135
  t142 = t9 * t11 * t14
  t144 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t142
  t145 = jnp.sqrt(t142)
  t148 = t142 ** 0.15e1
  t151 = t31 * t10 * t34
  t153 = 0.23615790870000000000000000000000000000000000000000e0 * t145 + 0.55771035800000000000000000000000000000000000000000e-1 * t142 + 0.12733319050000000000000000000000000000000000000000e-1 * t148 + 0.76629987700000000000000000000000000000000000000000e-2 * t151
  t155 = 0.1e1 + 0.1e1 / t153
  t156 = jnp.log(t155)
  t158 = f.my_piecewise3(t3, t47, 1)
  t161 = (0.2e1 * t158 - 0.2e1) * t55
  t163 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t142
  t168 = 0.17489865900000000000000000000000000000000000000000e0 * t145 + 0.30591644850000000000000000000000000000000000000000e-1 * t142 + 0.37162376550000000000000000000000000000000000000000e-2 * t148 + 0.41939708850000000000000000000000000000000000000000e-2 * t151
  t170 = 0.1e1 + 0.1e1 / t168
  t171 = jnp.log(t170)
  t176 = -t144 * t156 + 0.58482233974552040708313425006184496242808878304904e0 * t161 * t163 * t171 - 0.2e1 * t87
  t178 = params.c_ab[1]
  t179 = t178 * s0
  t181 = 0.1e1 + 0.6e-2 * t96
  t182 = 0.1e1 / t181
  t186 = params.c_ab[2]
  t187 = t186 * t104
  t188 = t181 ** 2
  t189 = 0.1e1 / t188
  t190 = t110 * t189
  t193 = params.c_ab[3]
  t194 = t193 * t117
  t196 = 0.1e1 / t188 / t181
  t197 = t120 * t196
  t200 = params.c_ab[4]
  t201 = t200 * t127
  t202 = t188 ** 2
  t203 = 0.1e1 / t202
  t204 = t132 * t203
  t207 = params.c_ab[0] + 0.6e-2 * t179 * t94 * t182 + 0.72e-4 * t187 * t190 + 0.864e-6 * t194 * t197 + 0.5184e-8 * t201 * t204
  t210 = 0.1e1 / t13 / r0
  t211 = t210 * t15
  t215 = 0.11073577833333333333333333333333333333333333333333e-2 * t12 * t211 * t19 * t44
  t216 = t41 ** 2
  t222 = t11 * t210
  t223 = t15 * t19
  t224 = t222 * t223
  t225 = 0.1e1 / t24 * t6 * t8 * t224
  t228 = t12 * t211 * t19
  t230 = t21 ** 0.5e0
  t233 = t230 * t6 * t8 * t224
  t236 = 0.1e1 / t33 / r0
  t239 = t32 * t236 * t35 * t37
  t244 = t23 / t216 * (-0.39359651450000000000000000000000000000000000000000e-1 * t225 - 0.18590345266666666666666666666666666666666666666667e-1 * t228 - 0.63666595250000000000000000000000000000000000000000e-2 * t233 - 0.51086658466666666666666666666666666666666666666667e-2 * t239) / t43
  t249 = t63 ** 2
  t264 = t74 ** 2
  t265 = 0.1e1 / t264
  t271 = -0.29149776500000000000000000000000000000000000000000e-1 * t225 - 0.10197214950000000000000000000000000000000000000000e-1 * t228 - 0.18581188275000000000000000000000000000000000000000e-2 * t233 - 0.27959805900000000000000000000000000000000000000000e-2 * t239
  t272 = 0.1e1 / t76
  t291 = f.my_piecewise3(t4, 0, t5 * (t215 + t244 + t56 * (0.53236443333333333333333333333333333333333333333333e-3 * t12 * t211 * t19 * t66 + t58 / t249 * (-0.36579716750000000000000000000000000000000000000000e-1 * t225 - 0.16057207750000000000000000000000000000000000000000e-1 * t228 - 0.65409473750000000000000000000000000000000000000000e-2 * t233 - 0.32394225500000000000000000000000000000000000000000e-2 * t239) / t65 - t215 - t244 + 0.18311555036753159941307229983139571945136646663793e-3 * t12 * t211 * t19 * t77 + 0.58482233974552040708313425006184496242808878304904e0 * t69 * t265 * t271 * t272) - 0.18311555036753159941307229983139571945136646663793e-3 * t56 * t9 * t222 * t223 * t77 - 0.58482233974552040708313425006184496242808878304904e0 * t56 * t69 * t265 * t271 * t272) / 0.2e1)
  t294 = t91 * r0
  t297 = t35 / t33 / t294
  t302 = t106 * t91
  t305 = t15 / t13 / t302
  t306 = t305 * t112
  t313 = 0.1e1 / t119 / r0
  t314 = t313 * t122
  t322 = 0.1e1 / t33 / t119 / t294
  t324 = t322 * t134 * t35
  t329 = t127 * s0
  t334 = t15 / t13 / t119 / t302
  t336 = 0.1e1 / t133 / t98
  t346 = t153 ** 2
  t351 = t8 * t11
  t352 = t351 * t210
  t353 = 0.1e1 / t145 * t6 * t352
  t355 = t9 * t222
  t357 = t142 ** 0.5e0
  t359 = t357 * t6 * t352
  t362 = t31 * t10 * t236
  t374 = t168 ** 2
  t393 = t305 * t189
  t399 = t313 * t196
  t406 = t322 * t203 * t35
  t413 = 0.1e1 / t202 / t181
  vrho_0_ = 0.2e1 * t87 * t138 + t176 * t207 + r0 * (0.2e1 * t291 * t138 + 0.2e1 * t87 * (-0.53333333333333333333333333333333333333333333333333e0 * t90 * t297 * t99 + 0.21333333333333333333333333333333333333333333333334e0 * t89 * t104 * t306 - 0.42666666666666666666666666666666666666666666666667e0 * t105 * t306 + 0.17066666666666666666666666666666666666666666666667e0 * t103 * t117 * t314 - 0.256e0 * t118 * t314 + 0.51200000000000000000000000000000000000000000000000e-1 * t116 * t127 * t324 - 0.68266666666666666666666666666666666666666666666667e-1 * t128 * t324 + 0.27306666666666666666666666666666666666666666666668e-1 * t126 * t329 * t334 * t336) + (0.11073577833333333333333333333333333333333333333333e-2 * t9 * t222 * t156 + t144 / t346 * (-0.39359651450000000000000000000000000000000000000000e-1 * t353 - 0.18590345266666666666666666666666666666666666666667e-1 * t355 - 0.63666595250000000000000000000000000000000000000000e-2 * t359 - 0.51086658466666666666666666666666666666666666666667e-2 * t362) / t155 - 0.18311555036753159941307229983139571945136646663793e-3 * t161 * t6 * t351 * t210 * t171 - 0.58482233974552040708313425006184496242808878304904e0 * t161 * t163 / t374 * (-0.29149776500000000000000000000000000000000000000000e-1 * t353 - 0.10197214950000000000000000000000000000000000000000e-1 * t355 - 0.18581188275000000000000000000000000000000000000000e-2 * t359 - 0.27959805900000000000000000000000000000000000000000e-2 * t362) / t170 - 0.2e1 * t291) * t207 + t176 * (-0.16000000000000000000000000000000000000000000000000e-1 * t179 * t297 * t182 + 0.19200000000000000000000000000000000000000000000000e-3 * t178 * t104 * t393 - 0.38400000000000000000000000000000000000000000000000e-3 * t187 * t393 + 0.46080000000000000000000000000000000000000000000000e-5 * t186 * t117 * t399 - 0.6912e-5 * t194 * t399 + 0.41472000000000000000000000000000000000000000000000e-7 * t193 * t127 * t406 - 0.55296000000000000000000000000000000000000000000000e-7 * t201 * t406 + 0.66355200000000000000000000000000000000000000000000e-9 * t200 * t329 * t334 * t413))
  t443 = t15 / t13 / t119 / t107
  vsigma_0_ = r0 * (0.2e1 * t87 * (0.2e0 * t89 * t35 * t93 * t99 - 0.8e-1 * t90 * t113 + 0.16e0 * t103 * s0 * t113 - 0.64e-1 * t105 * t123 + 0.96e-1 * t116 * t104 * t123 - 0.192e-1 * t118 * t135 + 0.256e-1 * t126 * t117 * t135 - 0.1024e-1 * t128 * t443 * t336) + t176 * (0.6e-2 * t178 * t35 * t93 * t182 - 0.72e-4 * t179 * t190 + 0.144e-3 * t186 * s0 * t190 - 0.1728e-5 * t187 * t197 + 0.2592e-5 * t193 * t104 * t197 - 0.15552e-7 * t194 * t204 + 0.20736e-7 * t200 * t117 * t204 - 0.248832e-9 * t201 * t443 * t413))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t13 / r0
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = t15 * t16
  t18 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t3, 0.1e1 / t18, 1)
  t21 = 0.1e1 / t13
  t24 = t12 * t21 * t16 * t20
  t25 = jnp.sqrt(t24)
  t28 = t24 ** 0.15e1
  t30 = t6 ** 2
  t31 = t8 ** 2
  t32 = t30 * t31
  t33 = t32 * t10
  t34 = t13 ** 2
  t35 = 0.1e1 / t34
  t36 = t16 ** 2
  t38 = t20 ** 2
  t40 = t33 * t35 * t36 * t38
  t42 = 0.37978500000000000000000000000000000000000000000000e1 * t25 + 0.89690000000000000000000000000000000000000000000000e0 * t24 + 0.20477500000000000000000000000000000000000000000000e0 * t28 + 0.12323500000000000000000000000000000000000000000000e0 * t40
  t45 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t42
  t46 = jnp.log(t45)
  t47 = t20 * t46
  t50 = 0.11073577833333333333333333333333333333333333333333e-2 * t12 * t17 * t47
  t52 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t24
  t53 = t42 ** 2
  t54 = 0.1e1 / t53
  t55 = t52 * t54
  t58 = 0.1e1 / t25 * t6 * t8
  t59 = t11 * t15
  t60 = t16 * t20
  t61 = t59 * t60
  t62 = t58 * t61
  t64 = t17 * t20
  t65 = t12 * t64
  t67 = t24 ** 0.5e0
  t69 = t67 * t6 * t8
  t70 = t69 * t61
  t73 = 0.1e1 / t34 / r0
  t76 = t33 * t73 * t36 * t38
  t78 = -0.63297500000000000000000000000000000000000000000000e0 * t62 - 0.29896666666666666666666666666666666666666666666667e0 * t65 - 0.10238750000000000000000000000000000000000000000000e0 * t70 - 0.82156666666666666666666666666666666666666666666667e-1 * t76
  t79 = 0.1e1 / t45
  t82 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * t78 * t79
  t84 = t18 * f.p.zeta_threshold
  t86 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t84, 0.2e1 * t16)
  t88 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t84, 0)
  t92 = 0.1e1 / (0.2e1 * t16 - 0.2e1)
  t93 = (t86 + t88 - 0.2e1) * t92
  t98 = 0.70594500000000000000000000000000000000000000000000e1 * t25 + 0.15494250000000000000000000000000000000000000000000e1 * t24 + 0.42077500000000000000000000000000000000000000000000e0 * t28 + 0.15629250000000000000000000000000000000000000000000e0 * t40
  t101 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t98
  t102 = jnp.log(t101)
  t103 = t20 * t102
  t108 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t24
  t109 = t98 ** 2
  t110 = 0.1e1 / t109
  t111 = t108 * t110
  t116 = -0.11765750000000000000000000000000000000000000000000e1 * t62 - 0.51647500000000000000000000000000000000000000000000e0 * t65 - 0.21038750000000000000000000000000000000000000000000e0 * t70 - 0.10419500000000000000000000000000000000000000000000e0 * t76
  t117 = 0.1e1 / t101
  t125 = 0.51785000000000000000000000000000000000000000000000e1 * t25 + 0.90577500000000000000000000000000000000000000000000e0 * t24 + 0.11003250000000000000000000000000000000000000000000e0 * t28 + 0.12417750000000000000000000000000000000000000000000e0 * t40
  t128 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t125
  t129 = jnp.log(t128)
  t130 = t20 * t129
  t135 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t24
  t136 = t125 ** 2
  t137 = 0.1e1 / t136
  t138 = t135 * t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t62 - 0.30192500000000000000000000000000000000000000000000e0 * t65 - 0.55016250000000000000000000000000000000000000000000e-1 * t70 - 0.82785000000000000000000000000000000000000000000000e-1 * t76
  t144 = 0.1e1 / t128
  t150 = t93 * t9
  t151 = t60 * t129
  t155 = t93 * t135
  t157 = t137 * t143 * t144
  t163 = f.my_piecewise3(t4, 0, t5 * (t50 + t82 + t93 * (0.53236443333333333333333333333333333333333333333332e-3 * t12 * t17 * t103 + 0.99999999999999999999999999999999999999999999999999e0 * t111 * t116 * t117 - t50 - t82 + 0.18311555036753159941307229983139571945136646663793e-3 * t12 * t17 * t130 + 0.58482233974552040708313425006184496242808878304903e0 * t138 * t143 * t144) - 0.18311555036753159941307229983139571945136646663793e-3 * t150 * t59 * t151 - 0.58482233974552040708313425006184496242808878304903e0 * t155 * t157) / 0.2e1)
  t165 = params.c_ss[1]
  t166 = t165 * s0
  t167 = r0 ** 2
  t169 = 0.1e1 / t34 / t167
  t170 = t36 * t169
  t172 = s0 * t36 * t169
  t174 = 0.1e1 + 0.2e0 * t172
  t175 = 0.1e1 / t174
  t179 = params.c_ss[2]
  t180 = s0 ** 2
  t181 = t179 * t180
  t182 = t167 ** 2
  t183 = t182 * r0
  t185 = 0.1e1 / t13 / t183
  t186 = t16 * t185
  t187 = t174 ** 2
  t188 = 0.1e1 / t187
  t189 = t186 * t188
  t192 = params.c_ss[3]
  t193 = t180 * s0
  t194 = t192 * t193
  t195 = t182 ** 2
  t196 = 0.1e1 / t195
  t198 = 0.1e1 / t187 / t174
  t199 = t196 * t198
  t202 = params.c_ss[4]
  t203 = t180 ** 2
  t204 = t202 * t203
  t205 = t195 * t167
  t208 = t36 / t34 / t205
  t209 = t187 ** 2
  t210 = 0.1e1 / t209
  t211 = t208 * t210
  t214 = params.c_ss[0] + 0.2e0 * t166 * t170 * t175 + 0.8e-1 * t181 * t189 + 0.32e-1 * t194 * t199 + 0.64e-2 * t204 * t211
  t218 = 0.62182e-1 * t52 * t46
  t221 = t135 * t129
  t230 = f.my_piecewise3(t4, 0, t5 * (-t218 + t93 * (-0.31090e-1 * t108 * t102 + t218 - 0.19751789702565206228825776161588751761046270558698e-1 * t221) + 0.19751789702565206228825776161588751761046270558698e-1 * t93 * t221) / 0.2e1)
  t231 = t167 * r0
  t233 = 0.1e1 / t34 / t231
  t234 = t36 * t233
  t238 = t165 * t180
  t239 = t182 * t167
  t241 = 0.1e1 / t13 / t239
  t242 = t16 * t241
  t243 = t242 * t188
  t248 = t179 * t193
  t250 = 0.1e1 / t195 / r0
  t251 = t250 * t198
  t256 = t192 * t203
  t259 = 0.1e1 / t34 / t195 / t231
  t261 = t259 * t210 * t36
  t266 = t203 * s0
  t267 = t202 * t266
  t271 = t16 / t13 / t195 / t239
  t273 = 0.1e1 / t209 / t174
  t274 = t271 * t273
  t277 = -0.53333333333333333333333333333333333333333333333333e0 * t166 * t234 * t175 + 0.21333333333333333333333333333333333333333333333334e0 * t238 * t243 - 0.42666666666666666666666666666666666666666666666667e0 * t181 * t243 + 0.17066666666666666666666666666666666666666666666667e0 * t248 * t251 - 0.256e0 * t194 * t251 + 0.51200000000000000000000000000000000000000000000000e-1 * t256 * t261 - 0.68266666666666666666666666666666666666666666666667e-1 * t204 * t261 + 0.27306666666666666666666666666666666666666666666668e-1 * t267 * t274
  t281 = t9 * t11 * t21
  t282 = jnp.sqrt(t281)
  t285 = t281 ** 0.15e1
  t288 = t32 * t10 * t35
  t290 = 0.37978500000000000000000000000000000000000000000000e1 * t282 + 0.89690000000000000000000000000000000000000000000000e0 * t281 + 0.20477500000000000000000000000000000000000000000000e0 * t285 + 0.12323500000000000000000000000000000000000000000000e0 * t288
  t293 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t290
  t294 = jnp.log(t293)
  t299 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t281
  t300 = t290 ** 2
  t301 = 0.1e1 / t300
  t302 = t299 * t301
  t304 = 0.1e1 / t282 * t6
  t305 = t8 * t11
  t306 = t305 * t15
  t307 = t304 * t306
  t309 = t9 * t59
  t311 = t281 ** 0.5e0
  t312 = t311 * t6
  t313 = t312 * t306
  t316 = t32 * t10 * t73
  t318 = -0.63297500000000000000000000000000000000000000000000e0 * t307 - 0.29896666666666666666666666666666666666666666666667e0 * t309 - 0.10238750000000000000000000000000000000000000000000e0 * t313 - 0.82156666666666666666666666666666666666666666666667e-1 * t316
  t319 = 0.1e1 / t293
  t320 = t318 * t319
  t323 = f.my_piecewise3(t3, t84, 1)
  t326 = (0.2e1 * t323 - 0.2e1) * t92
  t327 = t326 * t6
  t332 = 0.51785000000000000000000000000000000000000000000000e1 * t282 + 0.90577500000000000000000000000000000000000000000000e0 * t281 + 0.11003250000000000000000000000000000000000000000000e0 * t285 + 0.12417750000000000000000000000000000000000000000000e0 * t288
  t335 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t332
  t336 = jnp.log(t335)
  t342 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t281
  t343 = t326 * t342
  t344 = t332 ** 2
  t345 = 0.1e1 / t344
  t350 = -0.86308333333333333333333333333333333333333333333334e0 * t307 - 0.30192500000000000000000000000000000000000000000000e0 * t309 - 0.55016250000000000000000000000000000000000000000000e-1 * t313 - 0.82785000000000000000000000000000000000000000000000e-1 * t316
  t352 = 0.1e1 / t335
  t353 = t345 * t350 * t352
  t357 = 0.11073577833333333333333333333333333333333333333333e-2 * t9 * t59 * t294 + 0.10000000000000000000000000000000000000000000000000e1 * t302 * t320 - 0.18311555036753159941307229983139571945136646663793e-3 * t327 * t305 * t15 * t336 - 0.58482233974552040708313425006184496242808878304903e0 * t343 * t353 - 0.2e1 * t163
  t359 = params.c_ab[1]
  t360 = t359 * s0
  t362 = 0.1e1 + 0.6e-2 * t172
  t363 = 0.1e1 / t362
  t367 = params.c_ab[2]
  t368 = t367 * t180
  t369 = t362 ** 2
  t370 = 0.1e1 / t369
  t371 = t186 * t370
  t374 = params.c_ab[3]
  t375 = t374 * t193
  t377 = 0.1e1 / t369 / t362
  t378 = t196 * t377
  t381 = params.c_ab[4]
  t382 = t381 * t203
  t383 = t369 ** 2
  t384 = 0.1e1 / t383
  t385 = t208 * t384
  t388 = params.c_ab[0] + 0.6e-2 * t360 * t170 * t363 + 0.72e-4 * t368 * t371 + 0.864e-6 * t375 * t378 + 0.5184e-8 * t382 * t385
  t397 = -0.62182e-1 * t299 * t294 + 0.19751789702565206228825776161588751761046270558698e-1 * t326 * t342 * t336 - 0.2e1 * t230
  t401 = t359 * t180
  t402 = t242 * t370
  t407 = t367 * t193
  t408 = t250 * t377
  t413 = t374 * t203
  t415 = t259 * t384 * t36
  t420 = t381 * t266
  t422 = 0.1e1 / t383 / t362
  t423 = t271 * t422
  t426 = -0.16000000000000000000000000000000000000000000000000e-1 * t360 * t234 * t363 + 0.19200000000000000000000000000000000000000000000000e-3 * t401 * t402 - 0.38400000000000000000000000000000000000000000000000e-3 * t368 * t402 + 0.46080000000000000000000000000000000000000000000000e-5 * t407 * t408 - 0.6912e-5 * t375 * t408 + 0.41472000000000000000000000000000000000000000000000e-7 * t413 * t415 - 0.55296000000000000000000000000000000000000000000000e-7 * t382 * t415 + 0.66355200000000000000000000000000000000000000000000e-9 * t420 * t423
  t430 = 0.1e1 / t13 / t167
  t431 = t430 * t16
  t434 = 0.14764770444444444444444444444444444444444444444444e-2 * t12 * t431 * t47
  t439 = 0.35616666666666666666666666666666666666666666666666e-1 * t309 * t60 * t54 * t78 * t79
  t443 = t78 ** 2
  t446 = 0.20000000000000000000000000000000000000000000000000e1 * t52 / t53 / t42 * t443 * t79
  t451 = t10 * t169
  t453 = t451 * t36 * t38
  t454 = 0.1e1 / t25 / t24 * t30 * t31 * t453
  t456 = t11 * t430
  t457 = t456 * t60
  t458 = t58 * t457
  t461 = t12 * t431 * t20
  t463 = t24 ** (-0.5e0)
  t466 = t463 * t30 * t31 * t453
  t468 = t69 * t457
  t471 = t33 * t170 * t38
  t476 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * (-0.42198333333333333333333333333333333333333333333333e0 * t454 + 0.84396666666666666666666666666666666666666666666666e0 * t458 + 0.39862222222222222222222222222222222222222222222223e0 * t461 + 0.68258333333333333333333333333333333333333333333333e-1 * t466 + 0.13651666666666666666666666666666666666666666666667e0 * t468 + 0.13692777777777777777777777777777777777777777777778e0 * t471) * t79
  t477 = t53 ** 2
  t480 = t45 ** 2
  t484 = 0.16081824322151104821330931780901225435013347914188e2 * t52 / t477 * t443 / t480
  t496 = t116 ** 2
  t510 = t109 ** 2
  t513 = t101 ** 2
  t525 = 0.1e1 / t136 / t125
  t527 = t143 ** 2
  t537 = -0.57538888888888888888888888888888888888888888888889e0 * t454 + 0.11507777777777777777777777777777777777777777777778e1 * t458 + 0.40256666666666666666666666666666666666666666666667e0 * t461 + 0.36677500000000000000000000000000000000000000000000e-1 * t466 + 0.73355000000000000000000000000000000000000000000000e-1 * t468 + 0.13797500000000000000000000000000000000000000000000e0 * t471
  t541 = t136 ** 2
  t542 = 0.1e1 / t541
  t544 = t128 ** 2
  t545 = 0.1e1 / t544
  t549 = -0.70981924444444444444444444444444444444444444444442e-3 * t12 * t431 * t103 - 0.34246666666666666666666666666666666666666666666666e-1 * t309 * t60 * t110 * t116 * t117 - 0.20000000000000000000000000000000000000000000000000e1 * t108 / t109 / t98 * t496 * t117 + 0.99999999999999999999999999999999999999999999999999e0 * t111 * (-0.78438333333333333333333333333333333333333333333333e0 * t454 + 0.15687666666666666666666666666666666666666666666667e1 * t458 + 0.68863333333333333333333333333333333333333333333333e0 * t461 + 0.14025833333333333333333333333333333333333333333333e0 * t466 + 0.28051666666666666666666666666666666666666666666667e0 * t468 + 0.17365833333333333333333333333333333333333333333333e0 * t471) * t117 + 0.32164683177870697973624959794146027661627532968800e2 * t108 / t510 * t496 / t513 + t434 + t439 + t446 - t476 - t484 - 0.24415406715670879921742973310852762593515528885057e-3 * t12 * t431 * t130 - 0.10843580882781524214666447553230042011687479519034e-1 * t309 * t60 * t157 - 0.11696446794910408141662685001236899248561775660981e1 * t135 * t525 * t527 * t144 + 0.58482233974552040708313425006184496242808878304903e0 * t138 * t537 * t144 + 0.17315755899375863299672358916972966258900005419821e2 * t135 * t542 * t527 * t545
  t570 = -t434 - t439 - t446 + t476 + t484 + t93 * t549 + 0.24415406715670879921742973310852762593515528885057e-3 * t150 * t456 * t151 + 0.10843580882781524214666447553230042011687479519034e-1 * t93 * t12 * t64 * t157 + 0.11696446794910408141662685001236899248561775660981e1 * t155 * t525 * t527 * t144 - 0.58482233974552040708313425006184496242808878304903e0 * t155 * t137 * t537 * t144 - 0.17315755899375863299672358916972966258900005419821e2 * t155 * t542 * t527 * t545
  t573 = f.my_piecewise3(t4, 0, t5 * t570 / 0.2e1)
  t580 = t36 / t34 / t182
  t584 = t182 * t231
  t587 = t16 / t13 / t584
  t588 = t587 * t188
  t592 = 0.1e1 / t205
  t593 = t592 * t198
  t603 = 0.1e1 / t34 / t195 / t182
  t605 = t603 * t210 * t36
  t615 = 0.1e1 / t13 / t195 / t584
  t617 = t615 * t273 * t16
  t624 = t203 * t180
  t626 = t195 ** 2
  t628 = 0.1e1 / t626 / t167
  t630 = 0.1e1 / t209 / t187
  t634 = 0.19555555555555555555555555555555555555555555555555e1 * t166 * t580 * t175 - 0.19200000000000000000000000000000000000000000000001e1 * t238 * t588 + 0.45511111111111111111111111111111111111111111111114e0 * t165 * t193 * t593 + 0.27022222222222222222222222222222222222222222222222e1 * t181 * t588 - 0.24462222222222222222222222222222222222222222222223e1 * t248 * t593 + 0.27306666666666666666666666666666666666666666666667e0 * t179 * t203 * t605 + 0.2304e1 * t194 * t593 - 0.10069333333333333333333333333333333333333333333333e1 * t256 * t605 + 0.21845333333333333333333333333333333333333333333334e0 * t192 * t266 * t617 + 0.79644444444444444444444444444444444444444444444445e0 * t204 * t605 - 0.68266666666666666666666666666666666666666666666669e0 * t267 * t617 + 0.14563555555555555555555555555555555555555555555557e0 * t202 * t624 * t628 * t630
  t647 = t318 ** 2
  t655 = t31 * t10 * t169
  t656 = 0.1e1 / t282 / t281 * t30 * t655
  t658 = t305 * t430
  t659 = t304 * t658
  t661 = t9 * t456
  t663 = t281 ** (-0.5e0)
  t665 = t663 * t30 * t655
  t667 = t312 * t658
  t669 = t32 * t451
  t675 = t300 ** 2
  t678 = t293 ** 2
  t693 = t350 ** 2
  t709 = t344 ** 2
  t712 = t335 ** 2
  t718 = -0.14764770444444444444444444444444444444444444444444e-2 * t9 * t456 * t294 - 0.35616666666666666666666666666666666666666666666666e-1 * t12 * t15 * t301 * t320 - 0.20000000000000000000000000000000000000000000000000e1 * t299 / t300 / t290 * t647 * t319 + 0.10000000000000000000000000000000000000000000000000e1 * t302 * (-0.42198333333333333333333333333333333333333333333333e0 * t656 + 0.84396666666666666666666666666666666666666666666666e0 * t659 + 0.39862222222222222222222222222222222222222222222223e0 * t661 + 0.68258333333333333333333333333333333333333333333333e-1 * t665 + 0.13651666666666666666666666666666666666666666666667e0 * t667 + 0.13692777777777777777777777777777777777777777777778e0 * t669) * t319 + 0.16081824322151104821330931780901225435013347914188e2 * t299 / t675 * t647 / t678 + 0.24415406715670879921742973310852762593515528885057e-3 * t327 * t305 * t430 * t336 + 0.10843580882781524214666447553230042011687479519034e-1 * t326 * t9 * t59 * t353 + 0.11696446794910408141662685001236899248561775660981e1 * t343 / t344 / t332 * t693 * t352 - 0.58482233974552040708313425006184496242808878304903e0 * t343 * t345 * (-0.57538888888888888888888888888888888888888888888889e0 * t656 + 0.11507777777777777777777777777777777777777777777778e1 * t659 + 0.40256666666666666666666666666666666666666666666667e0 * t661 + 0.36677500000000000000000000000000000000000000000000e-1 * t665 + 0.73355000000000000000000000000000000000000000000000e-1 * t667 + 0.13797500000000000000000000000000000000000000000000e0 * t669) * t352 - 0.17315755899375863299672358916972966258900005419821e2 * t343 / t709 * t693 / t712 - 0.2e1 * t573
  t725 = t587 * t370
  t729 = t592 * t377
  t738 = t603 * t384 * t36
  t747 = t615 * t422 * t16
  t756 = 0.1e1 / t383 / t369
  t760 = 0.58666666666666666666666666666666666666666666666667e-1 * t360 * t580 * t363 - 0.17280000000000000000000000000000000000000000000000e-2 * t401 * t725 + 0.12288000000000000000000000000000000000000000000000e-4 * t359 * t193 * t729 + 0.24320000000000000000000000000000000000000000000000e-2 * t368 * t725 - 0.66048000000000000000000000000000000000000000000000e-4 * t407 * t729 + 0.22118400000000000000000000000000000000000000000000e-6 * t367 * t203 * t738 + 0.62208e-4 * t375 * t729 - 0.81561600000000000000000000000000000000000000000000e-6 * t413 * t738 + 0.53084160000000000000000000000000000000000000000000e-8 * t374 * t266 * t747 + 0.64512000000000000000000000000000000000000000000000e-6 * t382 * t738 - 0.16588800000000000000000000000000000000000000000000e-7 * t420 * t747 + 0.10616832000000000000000000000000000000000000000000e-9 * t381 * t624 * t628 * t756
  v2rho2_0_ = 0.4e1 * t163 * t214 + 0.4e1 * t230 * t277 + 0.2e1 * t357 * t388 + 0.2e1 * t397 * t426 + r0 * (0.4e1 * t163 * t277 + 0.2e1 * t573 * t214 + 0.2e1 * t230 * t634 + 0.2e1 * t357 * t426 + t718 * t388 + t397 * t760)
  t764 = t165 * t36
  t770 = t179 * s0
  t775 = t192 * t180
  t780 = t202 * t193
  t786 = t16 / t13 / t195 / t183
  t787 = t786 * t273
  t790 = 0.2e0 * t764 * t169 * t175 - 0.8e-1 * t166 * t189 + 0.16e0 * t770 * t189 - 0.64e-1 * t181 * t199 + 0.96e-1 * t775 * t199 - 0.192e-1 * t194 * t211 + 0.256e-1 * t780 * t211 - 0.1024e-1 * t204 * t787
  t793 = t359 * t36
  t799 = t367 * s0
  t804 = t374 * t180
  t809 = t381 * t193
  t812 = t786 * t422
  t815 = 0.6e-2 * t793 * t169 * t363 - 0.72e-4 * t360 * t371 + 0.144e-3 * t799 * t371 - 0.1728e-5 * t368 * t378 + 0.2592e-5 * t804 * t378 - 0.15552e-7 * t375 * t385 + 0.20736e-7 * t809 * t385 - 0.248832e-9 * t382 * t812
  t822 = t165 * t16
  t846 = 0.1e1 / t626 / r0
  t850 = -0.53333333333333333333333333333333333333333333333333e0 * t764 * t233 * t175 + 0.64000000000000000000000000000000000000000000000001e0 * t822 * t241 * t188 * s0 - 0.17066666666666666666666666666666666666666666666667e0 * t238 * t251 - 0.85333333333333333333333333333333333333333333333333e0 * t770 * t243 + 0.85333333333333333333333333333333333333333333333334e0 * t181 * t251 - 0.10240000000000000000000000000000000000000000000000e0 * t248 * t261 - 0.768e0 * t775 * t251 + 0.35840000000000000000000000000000000000000000000000e0 * t194 * t261 - 0.81920000000000000000000000000000000000000000000003e-1 * t256 * t274 - 0.27306666666666666666666666666666666666666666666667e0 * t780 * t261 + 0.24576000000000000000000000000000000000000000000000e0 * t204 * t274 - 0.54613333333333333333333333333333333333333333333335e-1 * t267 * t846 * t630
  t857 = t359 * t16
  t883 = -0.16000000000000000000000000000000000000000000000000e-1 * t793 * t233 * t363 + 0.57600000000000000000000000000000000000000000000000e-3 * t857 * t241 * t370 * s0 - 0.46080000000000000000000000000000000000000000000000e-5 * t401 * t408 - 0.76800000000000000000000000000000000000000000000000e-3 * t799 * t402 + 0.23040000000000000000000000000000000000000000000000e-4 * t368 * t408 - 0.82944000000000000000000000000000000000000000000000e-7 * t407 * t415 - 0.20736e-4 * t804 * t408 + 0.29030400000000000000000000000000000000000000000000e-6 * t375 * t415 - 0.19906560000000000000000000000000000000000000000000e-8 * t413 * t423 - 0.22118400000000000000000000000000000000000000000000e-6 * t809 * t415 + 0.59719680000000000000000000000000000000000000000000e-8 * t382 * t423 - 0.39813120000000000000000000000000000000000000000000e-10 * t420 * t846 * t756
  v2rhosigma_0_ = 0.2e1 * t230 * t790 + t397 * t815 + r0 * (0.2e1 * t163 * t790 + 0.2e1 * t230 * t850 + t357 * t815 + t397 * t883)
  t887 = t185 * t188
  t911 = 0.1e1 / t626
  t915 = -0.16e0 * t822 * t887 + 0.64e-1 * t166 * t199 + 0.16e0 * t179 * t16 * t887 - 0.256e0 * t770 * t199 + 0.384e-1 * t181 * t211 + 0.192e0 * t192 * s0 * t199 - 0.1152e0 * t775 * t211 + 0.3072e-1 * t194 * t787 + 0.768e-1 * t202 * t180 * t211 - 0.8192e-1 * t780 * t787 + 0.20480e-1 * t204 * t911 * t630
  t918 = t185 * t370
  t945 = -0.144e-3 * t857 * t918 + 0.1728e-5 * t360 * t378 + 0.144e-3 * t367 * t16 * t918 - 0.6912e-5 * t799 * t378 + 0.31104e-7 * t368 * t385 + 0.5184e-5 * t374 * s0 * t378 - 0.93312e-7 * t804 * t385 + 0.746496e-9 * t375 * t812 + 0.62208e-7 * t381 * t180 * t385 - 0.1990656e-8 * t809 * t812 + 0.14929920e-10 * t382 * t911 * t756
  v2sigma2_0_ = r0 * (0.2e1 * t230 * t915 + t397 * t945)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** 2
  t14 = r0 ** (0.1e1 / 0.3e1)
  t16 = 0.1e1 / t14 / t13
  t17 = 2 ** (0.1e1 / 0.3e1)
  t18 = t16 * t17
  t19 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t3, 0.1e1 / t19, 1)
  t22 = 0.1e1 / t14
  t25 = t12 * t22 * t17 * t21
  t26 = jnp.sqrt(t25)
  t29 = t25 ** 0.15e1
  t31 = t6 ** 2
  t32 = t8 ** 2
  t33 = t31 * t32
  t34 = t33 * t10
  t35 = t14 ** 2
  t36 = 0.1e1 / t35
  t37 = t17 ** 2
  t39 = t21 ** 2
  t41 = t34 * t36 * t37 * t39
  t43 = 0.37978500000000000000000000000000000000000000000000e1 * t26 + 0.89690000000000000000000000000000000000000000000000e0 * t25 + 0.20477500000000000000000000000000000000000000000000e0 * t29 + 0.12323500000000000000000000000000000000000000000000e0 * t41
  t46 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t43
  t47 = jnp.log(t46)
  t48 = t21 * t47
  t51 = 0.14764770444444444444444444444444444444444444444444e-2 * t12 * t18 * t48
  t53 = 0.1e1 / t14 / r0
  t54 = t11 * t53
  t55 = t9 * t54
  t56 = t17 * t21
  t57 = t43 ** 2
  t58 = 0.1e1 / t57
  t61 = 0.1e1 / t26 * t6 * t8
  t62 = t54 * t56
  t63 = t61 * t62
  t65 = t53 * t17
  t66 = t65 * t21
  t67 = t12 * t66
  t69 = t25 ** 0.5e0
  t71 = t69 * t6 * t8
  t72 = t71 * t62
  t75 = 0.1e1 / t35 / r0
  t78 = t34 * t75 * t37 * t39
  t80 = -0.63297500000000000000000000000000000000000000000000e0 * t63 - 0.29896666666666666666666666666666666666666666666667e0 * t67 - 0.10238750000000000000000000000000000000000000000000e0 * t72 - 0.82156666666666666666666666666666666666666666666667e-1 * t78
  t82 = 0.1e1 / t46
  t84 = t56 * t58 * t80 * t82
  t86 = 0.35616666666666666666666666666666666666666666666666e-1 * t55 * t84
  t88 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t25
  t90 = 0.1e1 / t57 / t43
  t91 = t88 * t90
  t92 = t80 ** 2
  t95 = 0.20000000000000000000000000000000000000000000000000e1 * t91 * t92 * t82
  t96 = t88 * t58
  t100 = 0.1e1 / t26 / t25 * t31 * t32
  t102 = 0.1e1 / t35 / t13
  t103 = t10 * t102
  t104 = t37 * t39
  t105 = t103 * t104
  t106 = t100 * t105
  t108 = t11 * t16
  t109 = t108 * t56
  t110 = t61 * t109
  t112 = t18 * t21
  t113 = t12 * t112
  t115 = t25 ** (-0.5e0)
  t117 = t115 * t31 * t32
  t118 = t117 * t105
  t120 = t71 * t109
  t122 = t102 * t37
  t124 = t34 * t122 * t39
  t126 = -0.42198333333333333333333333333333333333333333333333e0 * t106 + 0.84396666666666666666666666666666666666666666666666e0 * t110 + 0.39862222222222222222222222222222222222222222222223e0 * t113 + 0.68258333333333333333333333333333333333333333333333e-1 * t118 + 0.13651666666666666666666666666666666666666666666667e0 * t120 + 0.13692777777777777777777777777777777777777777777778e0 * t124
  t129 = 0.10000000000000000000000000000000000000000000000000e1 * t96 * t126 * t82
  t130 = t57 ** 2
  t131 = 0.1e1 / t130
  t132 = t88 * t131
  t133 = t46 ** 2
  t134 = 0.1e1 / t133
  t137 = 0.16081824322151104821330931780901225435013347914188e2 * t132 * t92 * t134
  t139 = t19 * f.p.zeta_threshold
  t141 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t139, 0.2e1 * t17)
  t143 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t139, 0)
  t147 = 0.1e1 / (0.2e1 * t17 - 0.2e1)
  t148 = (t141 + t143 - 0.2e1) * t147
  t153 = 0.70594500000000000000000000000000000000000000000000e1 * t26 + 0.15494250000000000000000000000000000000000000000000e1 * t25 + 0.42077500000000000000000000000000000000000000000000e0 * t29 + 0.15629250000000000000000000000000000000000000000000e0 * t41
  t156 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t153
  t157 = jnp.log(t156)
  t158 = t21 * t157
  t162 = t153 ** 2
  t163 = 0.1e1 / t162
  t168 = -0.11765750000000000000000000000000000000000000000000e1 * t63 - 0.51647500000000000000000000000000000000000000000000e0 * t67 - 0.21038750000000000000000000000000000000000000000000e0 * t72 - 0.10419500000000000000000000000000000000000000000000e0 * t78
  t170 = 0.1e1 / t156
  t172 = t56 * t163 * t168 * t170
  t176 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t25
  t178 = 0.1e1 / t162 / t153
  t179 = t176 * t178
  t180 = t168 ** 2
  t184 = t176 * t163
  t191 = -0.78438333333333333333333333333333333333333333333333e0 * t106 + 0.15687666666666666666666666666666666666666666666667e1 * t110 + 0.68863333333333333333333333333333333333333333333333e0 * t113 + 0.14025833333333333333333333333333333333333333333333e0 * t118 + 0.28051666666666666666666666666666666666666666666667e0 * t120 + 0.17365833333333333333333333333333333333333333333333e0 * t124
  t195 = t162 ** 2
  t196 = 0.1e1 / t195
  t197 = t176 * t196
  t198 = t156 ** 2
  t199 = 0.1e1 / t198
  t207 = 0.51785000000000000000000000000000000000000000000000e1 * t26 + 0.90577500000000000000000000000000000000000000000000e0 * t25 + 0.11003250000000000000000000000000000000000000000000e0 * t29 + 0.12417750000000000000000000000000000000000000000000e0 * t41
  t210 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t207
  t211 = jnp.log(t210)
  t212 = t21 * t211
  t216 = t207 ** 2
  t217 = 0.1e1 / t216
  t222 = -0.86308333333333333333333333333333333333333333333334e0 * t63 - 0.30192500000000000000000000000000000000000000000000e0 * t67 - 0.55016250000000000000000000000000000000000000000000e-1 * t72 - 0.82785000000000000000000000000000000000000000000000e-1 * t78
  t224 = 0.1e1 / t210
  t225 = t217 * t222 * t224
  t226 = t56 * t225
  t230 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t25
  t232 = 0.1e1 / t216 / t207
  t233 = t230 * t232
  t234 = t222 ** 2
  t238 = t230 * t217
  t245 = -0.57538888888888888888888888888888888888888888888889e0 * t106 + 0.11507777777777777777777777777777777777777777777778e1 * t110 + 0.40256666666666666666666666666666666666666666666667e0 * t113 + 0.36677500000000000000000000000000000000000000000000e-1 * t118 + 0.73355000000000000000000000000000000000000000000000e-1 * t120 + 0.13797500000000000000000000000000000000000000000000e0 * t124
  t246 = t245 * t224
  t249 = t216 ** 2
  t250 = 0.1e1 / t249
  t251 = t230 * t250
  t252 = t210 ** 2
  t253 = 0.1e1 / t252
  t257 = -0.70981924444444444444444444444444444444444444444442e-3 * t12 * t18 * t158 - 0.34246666666666666666666666666666666666666666666666e-1 * t55 * t172 - 0.20000000000000000000000000000000000000000000000000e1 * t179 * t180 * t170 + 0.99999999999999999999999999999999999999999999999999e0 * t184 * t191 * t170 + 0.32164683177870697973624959794146027661627532968800e2 * t197 * t180 * t199 + t51 + t86 + t95 - t129 - t137 - 0.24415406715670879921742973310852762593515528885057e-3 * t12 * t18 * t212 - 0.10843580882781524214666447553230042011687479519034e-1 * t55 * t226 - 0.11696446794910408141662685001236899248561775660981e1 * t233 * t234 * t224 + 0.58482233974552040708313425006184496242808878304903e0 * t238 * t246 + 0.17315755899375863299672358916972966258900005419821e2 * t251 * t234 * t253
  t259 = t148 * t9
  t260 = t56 * t211
  t264 = t148 * t12
  t268 = t148 * t230
  t270 = t232 * t234 * t224
  t274 = t217 * t245 * t224
  t278 = t250 * t234 * t253
  t281 = -t51 - t86 - t95 + t129 + t137 + t148 * t257 + 0.24415406715670879921742973310852762593515528885057e-3 * t259 * t108 * t260 + 0.10843580882781524214666447553230042011687479519034e-1 * t264 * t66 * t225 + 0.11696446794910408141662685001236899248561775660981e1 * t268 * t270 - 0.58482233974552040708313425006184496242808878304903e0 * t268 * t274 - 0.17315755899375863299672358916972966258900005419821e2 * t268 * t278
  t284 = f.my_piecewise3(t4, 0, t5 * t281 / 0.2e1)
  t286 = params.c_ss[1]
  t287 = t286 * s0
  t289 = s0 * t37 * t102
  t291 = 0.1e1 + 0.2e0 * t289
  t292 = 0.1e1 / t291
  t296 = params.c_ss[2]
  t297 = s0 ** 2
  t298 = t296 * t297
  t299 = t13 ** 2
  t300 = t299 * r0
  t303 = t17 / t14 / t300
  t304 = t291 ** 2
  t305 = 0.1e1 / t304
  t309 = params.c_ss[3]
  t310 = t297 * s0
  t311 = t309 * t310
  t312 = t299 ** 2
  t313 = 0.1e1 / t312
  t314 = t304 * t291
  t315 = 0.1e1 / t314
  t319 = params.c_ss[4]
  t320 = t297 ** 2
  t321 = t319 * t320
  t322 = t312 * t13
  t325 = t37 / t35 / t322
  t326 = t304 ** 2
  t327 = 0.1e1 / t326
  t331 = params.c_ss[0] + 0.2e0 * t287 * t122 * t292 + 0.8e-1 * t298 * t303 * t305 + 0.32e-1 * t311 * t313 * t315 + 0.64e-2 * t321 * t325 * t327
  t336 = 0.11073577833333333333333333333333333333333333333333e-2 * t12 * t65 * t48
  t337 = t80 * t82
  t339 = 0.10000000000000000000000000000000000000000000000000e1 * t96 * t337
  t343 = t168 * t170
  t349 = t222 * t224
  t362 = f.my_piecewise3(t4, 0, t5 * (t336 + t339 + t148 * (0.53236443333333333333333333333333333333333333333332e-3 * t12 * t65 * t158 + 0.99999999999999999999999999999999999999999999999999e0 * t184 * t343 - t336 - t339 + 0.18311555036753159941307229983139571945136646663793e-3 * t12 * t65 * t212 + 0.58482233974552040708313425006184496242808878304903e0 * t238 * t349) - 0.18311555036753159941307229983139571945136646663793e-3 * t259 * t54 * t260 - 0.58482233974552040708313425006184496242808878304903e0 * t268 * t225) / 0.2e1)
  t363 = t13 * r0
  t365 = 0.1e1 / t35 / t363
  t366 = t37 * t365
  t370 = t286 * t297
  t371 = t299 * t13
  t374 = t17 / t14 / t371
  t375 = t374 * t305
  t380 = t296 * t310
  t382 = 0.1e1 / t312 / r0
  t383 = t382 * t315
  t388 = t309 * t320
  t389 = t312 * t363
  t391 = 0.1e1 / t35 / t389
  t393 = t391 * t327 * t37
  t398 = t320 * s0
  t399 = t319 * t398
  t403 = t17 / t14 / t312 / t371
  t405 = 0.1e1 / t326 / t291
  t409 = -0.53333333333333333333333333333333333333333333333333e0 * t287 * t366 * t292 + 0.21333333333333333333333333333333333333333333333334e0 * t370 * t375 - 0.42666666666666666666666666666666666666666666666667e0 * t298 * t375 + 0.17066666666666666666666666666666666666666666666667e0 * t380 * t383 - 0.256e0 * t311 * t383 + 0.51200000000000000000000000000000000000000000000000e-1 * t388 * t393 - 0.68266666666666666666666666666666666666666666666667e-1 * t321 * t393 + 0.27306666666666666666666666666666666666666666666668e-1 * t399 * t403 * t405
  t413 = 0.62182e-1 * t88 * t47
  t416 = t230 * t211
  t425 = f.my_piecewise3(t4, 0, t5 * (-t413 + t148 * (-0.31090e-1 * t176 * t157 + t413 - 0.19751789702565206228825776161588751761046270558698e-1 * t416) + 0.19751789702565206228825776161588751761046270558698e-1 * t148 * t416) / 0.2e1)
  t428 = t37 / t35 / t299
  t432 = t299 * t363
  t435 = t17 / t14 / t432
  t436 = t435 * t305
  t439 = t286 * t310
  t440 = 0.1e1 / t322
  t441 = t440 * t315
  t448 = t296 * t320
  t451 = 0.1e1 / t35 / t312 / t299
  t453 = t451 * t327 * t37
  t460 = t309 * t398
  t463 = 0.1e1 / t14 / t312 / t432
  t465 = t463 * t405 * t17
  t472 = t320 * t297
  t473 = t319 * t472
  t474 = t312 ** 2
  t476 = 0.1e1 / t474 / t13
  t478 = 0.1e1 / t326 / t304
  t482 = 0.19555555555555555555555555555555555555555555555555e1 * t287 * t428 * t292 - 0.19200000000000000000000000000000000000000000000001e1 * t370 * t436 + 0.45511111111111111111111111111111111111111111111114e0 * t439 * t441 + 0.27022222222222222222222222222222222222222222222222e1 * t298 * t436 - 0.24462222222222222222222222222222222222222222222223e1 * t380 * t441 + 0.27306666666666666666666666666666666666666666666667e0 * t448 * t453 + 0.2304e1 * t311 * t441 - 0.10069333333333333333333333333333333333333333333333e1 * t388 * t453 + 0.21845333333333333333333333333333333333333333333334e0 * t460 * t465 + 0.79644444444444444444444444444444444444444444444445e0 * t321 * t453 - 0.68266666666666666666666666666666666666666666666669e0 * t399 * t465 + 0.14563555555555555555555555555555555555555555555557e0 * t473 * t476 * t478
  t486 = t9 * t11 * t22
  t487 = jnp.sqrt(t486)
  t490 = t486 ** 0.15e1
  t493 = t33 * t10 * t36
  t495 = 0.37978500000000000000000000000000000000000000000000e1 * t487 + 0.89690000000000000000000000000000000000000000000000e0 * t486 + 0.20477500000000000000000000000000000000000000000000e0 * t490 + 0.12323500000000000000000000000000000000000000000000e0 * t493
  t498 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t495
  t499 = jnp.log(t498)
  t503 = t495 ** 2
  t504 = 0.1e1 / t503
  t505 = t53 * t504
  t507 = 0.1e1 / t487 * t6
  t508 = t8 * t11
  t509 = t508 * t53
  t510 = t507 * t509
  t513 = t486 ** 0.5e0
  t514 = t513 * t6
  t515 = t514 * t509
  t518 = t33 * t10 * t75
  t520 = -0.63297500000000000000000000000000000000000000000000e0 * t510 - 0.29896666666666666666666666666666666666666666666667e0 * t55 - 0.10238750000000000000000000000000000000000000000000e0 * t515 - 0.82156666666666666666666666666666666666666666666667e-1 * t518
  t521 = 0.1e1 / t498
  t522 = t520 * t521
  t527 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t486
  t529 = 0.1e1 / t503 / t495
  t530 = t527 * t529
  t531 = t520 ** 2
  t532 = t531 * t521
  t535 = t527 * t504
  t538 = 0.1e1 / t487 / t486 * t31
  t539 = t32 * t10
  t540 = t539 * t102
  t541 = t538 * t540
  t543 = t508 * t16
  t544 = t507 * t543
  t546 = t9 * t108
  t548 = t486 ** (-0.5e0)
  t549 = t548 * t31
  t550 = t549 * t540
  t552 = t514 * t543
  t554 = t33 * t103
  t556 = -0.42198333333333333333333333333333333333333333333333e0 * t541 + 0.84396666666666666666666666666666666666666666666666e0 * t544 + 0.39862222222222222222222222222222222222222222222223e0 * t546 + 0.68258333333333333333333333333333333333333333333333e-1 * t550 + 0.13651666666666666666666666666666666666666666666667e0 * t552 + 0.13692777777777777777777777777777777777777777777778e0 * t554
  t557 = t556 * t521
  t560 = t503 ** 2
  t561 = 0.1e1 / t560
  t562 = t527 * t561
  t563 = t498 ** 2
  t564 = 0.1e1 / t563
  t565 = t531 * t564
  t568 = f.my_piecewise3(t3, t139, 1)
  t571 = (0.2e1 * t568 - 0.2e1) * t147
  t572 = t571 * t6
  t577 = 0.51785000000000000000000000000000000000000000000000e1 * t487 + 0.90577500000000000000000000000000000000000000000000e0 * t486 + 0.11003250000000000000000000000000000000000000000000e0 * t490 + 0.12417750000000000000000000000000000000000000000000e0 * t493
  t580 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t577
  t581 = jnp.log(t580)
  t586 = t571 * t9
  t587 = t577 ** 2
  t588 = 0.1e1 / t587
  t593 = -0.86308333333333333333333333333333333333333333333334e0 * t510 - 0.30192500000000000000000000000000000000000000000000e0 * t55 - 0.55016250000000000000000000000000000000000000000000e-1 * t515 - 0.82785000000000000000000000000000000000000000000000e-1 * t518
  t595 = 0.1e1 / t580
  t596 = t588 * t593 * t595
  t601 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t486
  t602 = t571 * t601
  t604 = 0.1e1 / t587 / t577
  t605 = t593 ** 2
  t607 = t604 * t605 * t595
  t616 = -0.57538888888888888888888888888888888888888888888889e0 * t541 + 0.11507777777777777777777777777777777777777777777778e1 * t544 + 0.40256666666666666666666666666666666666666666666667e0 * t546 + 0.36677500000000000000000000000000000000000000000000e-1 * t550 + 0.73355000000000000000000000000000000000000000000000e-1 * t552 + 0.13797500000000000000000000000000000000000000000000e0 * t554
  t618 = t588 * t616 * t595
  t621 = t587 ** 2
  t622 = 0.1e1 / t621
  t624 = t580 ** 2
  t625 = 0.1e1 / t624
  t626 = t622 * t605 * t625
  t630 = -0.14764770444444444444444444444444444444444444444444e-2 * t9 * t108 * t499 - 0.35616666666666666666666666666666666666666666666666e-1 * t12 * t505 * t522 - 0.20000000000000000000000000000000000000000000000000e1 * t530 * t532 + 0.10000000000000000000000000000000000000000000000000e1 * t535 * t557 + 0.16081824322151104821330931780901225435013347914188e2 * t562 * t565 + 0.24415406715670879921742973310852762593515528885057e-3 * t572 * t508 * t16 * t581 + 0.10843580882781524214666447553230042011687479519034e-1 * t586 * t54 * t596 + 0.11696446794910408141662685001236899248561775660981e1 * t602 * t607 - 0.58482233974552040708313425006184496242808878304903e0 * t602 * t618 - 0.17315755899375863299672358916972966258900005419821e2 * t602 * t626 - 0.2e1 * t284
  t632 = params.c_ab[1]
  t633 = t632 * s0
  t635 = 0.1e1 + 0.6e-2 * t289
  t636 = 0.1e1 / t635
  t640 = params.c_ab[2]
  t641 = t640 * t297
  t642 = t635 ** 2
  t643 = 0.1e1 / t642
  t647 = params.c_ab[3]
  t648 = t647 * t310
  t649 = t642 * t635
  t650 = 0.1e1 / t649
  t654 = params.c_ab[4]
  t655 = t654 * t320
  t656 = t642 ** 2
  t657 = 0.1e1 / t656
  t661 = params.c_ab[0] + 0.6e-2 * t633 * t122 * t636 + 0.72e-4 * t641 * t303 * t643 + 0.864e-6 * t648 * t313 * t650 + 0.5184e-8 * t655 * t325 * t657
  t676 = 0.11073577833333333333333333333333333333333333333333e-2 * t9 * t54 * t499 + 0.10000000000000000000000000000000000000000000000000e1 * t535 * t522 - 0.18311555036753159941307229983139571945136646663793e-3 * t572 * t508 * t53 * t581 - 0.58482233974552040708313425006184496242808878304903e0 * t602 * t596 - 0.2e1 * t362
  t680 = t632 * t297
  t681 = t374 * t643
  t686 = t640 * t310
  t687 = t382 * t650
  t692 = t647 * t320
  t694 = t391 * t657 * t37
  t699 = t654 * t398
  t701 = 0.1e1 / t656 / t635
  t705 = -0.16000000000000000000000000000000000000000000000000e-1 * t633 * t366 * t636 + 0.19200000000000000000000000000000000000000000000000e-3 * t680 * t681 - 0.38400000000000000000000000000000000000000000000000e-3 * t641 * t681 + 0.46080000000000000000000000000000000000000000000000e-5 * t686 * t687 - 0.6912e-5 * t648 * t687 + 0.41472000000000000000000000000000000000000000000000e-7 * t692 * t694 - 0.55296000000000000000000000000000000000000000000000e-7 * t655 * t694 + 0.66355200000000000000000000000000000000000000000000e-9 * t699 * t403 * t701
  t714 = -0.62182e-1 * t527 * t499 + 0.19751789702565206228825776161588751761046270558698e-1 * t571 * t601 * t581 - 0.2e1 * t425
  t718 = t435 * t643
  t721 = t632 * t310
  t722 = t440 * t650
  t729 = t640 * t320
  t731 = t451 * t657 * t37
  t738 = t647 * t398
  t740 = t463 * t701 * t17
  t747 = t654 * t472
  t749 = 0.1e1 / t656 / t642
  t753 = 0.58666666666666666666666666666666666666666666666667e-1 * t633 * t428 * t636 - 0.17280000000000000000000000000000000000000000000000e-2 * t680 * t718 + 0.12288000000000000000000000000000000000000000000000e-4 * t721 * t722 + 0.24320000000000000000000000000000000000000000000000e-2 * t641 * t718 - 0.66048000000000000000000000000000000000000000000000e-4 * t686 * t722 + 0.22118400000000000000000000000000000000000000000000e-6 * t729 * t731 + 0.62208e-4 * t648 * t722 - 0.81561600000000000000000000000000000000000000000000e-6 * t692 * t731 + 0.53084160000000000000000000000000000000000000000000e-8 * t738 * t740 + 0.64512000000000000000000000000000000000000000000000e-6 * t655 * t731 - 0.16588800000000000000000000000000000000000000000000e-7 * t699 * t740 + 0.10616832000000000000000000000000000000000000000000e-9 * t747 * t476 * t749
  t760 = 0.1e1 / t299
  t762 = t760 * t39 * t21
  t763 = 0.1e1 / t26 / t41 * t7 * t762 / 0.4e1
  t765 = t10 * t365
  t766 = t765 * t104
  t767 = t100 * t766
  t770 = 0.1e1 / t14 / t363
  t771 = t11 * t770
  t772 = t771 * t56
  t773 = t61 * t772
  t775 = t770 * t17
  t777 = t12 * t775 * t21
  t779 = t25 ** (-0.15e1)
  t781 = t779 * t7 * t762
  t783 = t117 * t766
  t785 = t71 * t772
  t788 = t34 * t366 * t39
  t790 = -0.69046666666666666666666666666666666666666666666667e1 * t763 + 0.23015555555555555555555555555555555555555555555556e1 * t767 - 0.26851481481481481481481481481481481481481481481482e1 * t773 - 0.93932222222222222222222222222222222222222222222223e0 * t777 + 0.14671000000000000000000000000000000000000000000000e0 * t781 - 0.14671000000000000000000000000000000000000000000000e0 * t783 - 0.17116166666666666666666666666666666666666666666667e0 * t785 - 0.36793333333333333333333333333333333333333333333333e0 * t788
  t796 = 0.1e1 / t249 / t207
  t797 = t234 * t222
  t804 = 0.34451131037037037037037037037037037037037037037036e-2 * t12 * t775 * t48
  t812 = 0.10685000000000000000000000000000000000000000000000e0 * t55 * t56 * t90 * t92 * t82
  t814 = 0.71233333333333333333333333333333333333333333333333e-1 * t546 * t84
  t819 = 0.53424999999999999999999999999999999999999999999999e-1 * t55 * t56 * t58 * t126 * t82
  t824 = 0.85917146441092277507960503039464796886558811231548e0 * t55 * t56 * t131 * t92 * t134
  t826 = 0.1e1 / t249 / t216
  t829 = 0.1e1 / t252 / t210
  t839 = -0.58482233974552040708313425006184496242808878304903e0 * t268 * t217 * t790 * t224 + 0.10389453539625517979803415350183779755340003251893e3 * t268 * t796 * t797 * t253 + t804 - 0.56969282336565386484066937725323112718202900731800e-3 * t259 * t771 * t260 + t812 + t814 - t819 - t824 - 0.10253897021007794930818001372045340355835853271641e4 * t268 * t826 * t797 * t829 - 0.21687161765563048429332895106460084023374959038068e-1 * t264 * t112 * t225 + 0.16265371324172286321999671329845063017531219278551e-1 * t264 * t66 * t274
  t843 = t92 * t80
  t846 = 0.60000000000000000000000000000000000000000000000000e1 * t132 * t843 * t82
  t849 = 0.60000000000000000000000000000000000000000000000000e1 * t91 * t337 * t126
  t853 = 0.48245472966453314463992795342703676305040043742564e2 * t132 * t126 * t134 * t80
  t875 = 0.96490945932906628927985590685407352610080087485128e2 * t88 / t130 / t43 * t843 * t134
  t887 = 0.10000000000000000000000000000000000000000000000000e1 * t96 * (-0.50638000000000000000000000000000000000000000000000e1 * t763 + 0.16879333333333333333333333333333333333333333333333e1 * t767 - 0.19692555555555555555555555555555555555555555555555e1 * t773 - 0.93011851851851851851851851851851851851851851851854e0 * t777 + 0.27303333333333333333333333333333333333333333333333e0 * t781 - 0.27303333333333333333333333333333333333333333333333e0 * t783 - 0.31853888888888888888888888888888888888888888888890e0 * t785 - 0.36514074074074074074074074074074074074074074074075e0 * t788) * t82
  t895 = 0.51725014705706168413145063783413931475389495076352e3 * t88 / t130 / t57 * t843 / t133 / t46
  t932 = -0.60000000000000000000000000000000000000000000000000e1 * t179 * t343 * t191 + 0.96494049533612093920874879382438082984882598906400e2 * t197 * t191 * t199 * t168 - 0.35089340384731224424988055003710697745685326982943e1 * t233 * t349 * t245 + 0.51947267698127589899017076750918898776700016259463e2 * t251 * t245 * t253 * t222 + t849 - t853 - t812 - t814 + t819 + t824 + 0.32530742648344572643999342659690126035062438557102e-1 * t55 * t56 * t270 + 0.10274000000000000000000000000000000000000000000000e0 * t55 * t56 * t178 * t180 * t170 + 0.68493333333333333333333333333333333333333333333331e-1 * t546 * t172 - 0.51369999999999999999999999999999999999999999999999e-1 * t55 * t56 * t163 * t191 * t170 - 0.16522997748472177549051141846252814409778063686072e1 * t55 * t56 * t196 * t180 * t199 + 0.21687161765563048429332895106460084023374959038068e-1 * t546 * t226
  t945 = t180 * t168
  t989 = -0.16265371324172286321999671329845063017531219278551e-1 * t55 * t56 * t274 - 0.48159446095139119802213748237831062407565640073877e0 * t55 * t56 * t278 + 0.16562449037037037037037037037037037037037037037036e-2 * t12 * t775 * t158 + 0.56969282336565386484066937725323112718202900731800e-3 * t12 * t775 * t212 + 0.60000000000000000000000000000000000000000000000000e1 * t197 * t945 * t170 + 0.35089340384731224424988055003710697745685326982943e1 * t251 * t797 * t224 - 0.19298809906722418784174975876487616596976519781280e3 * t176 / t195 / t153 * t945 * t199 + 0.99999999999999999999999999999999999999999999999999e0 * t184 * (-0.94126000000000000000000000000000000000000000000000e1 * t763 + 0.31375333333333333333333333333333333333333333333334e1 * t767 - 0.36604555555555555555555555555555555555555555555556e1 * t773 - 0.16068111111111111111111111111111111111111111111111e1 * t777 + 0.56103333333333333333333333333333333333333333333332e0 * t781 - 0.56103333333333333333333333333333333333333333333332e0 * t783 - 0.65453888888888888888888888888888888888888888888890e0 * t785 - 0.46308888888888888888888888888888888888888888888888e0 * t788) * t170 + 0.20691336878655965245175271659148296983999699561788e4 * t176 / t195 / t162 * t945 / t198 / t156 + 0.10253897021007794930818001372045340355835853271641e4 * t230 * t826 * t797 * t829 - 0.10389453539625517979803415350183779755340003251893e3 * t230 * t796 * t797 * t253 + 0.58482233974552040708313425006184496242808878304903e0 * t238 * t790 * t224 - t846 + t875 - t887 - t895 - t804
  t992 = 0.48159446095139119802213748237831062407565640073877e0 * t264 * t66 * t278 + t846 - t849 + t853 - 0.51947267698127589899017076750918898776700016259463e2 * t268 * t250 * t245 * t253 * t222 - 0.35089340384731224424988055003710697745685326982943e1 * t268 * t250 * t797 * t224 + 0.35089340384731224424988055003710697745685326982943e1 * t268 * t232 * t222 * t246 - 0.32530742648344572643999342659690126035062438557102e-1 * t264 * t66 * t270 - t875 + t887 + t895 + t148 * (t932 + t989)
  t996 = f.my_piecewise3(t4, 0, t5 * (t839 + t992) / 0.2e1)
  t1005 = t37 / t35 / t300
  t1011 = t17 / t14 / t312
  t1012 = t1011 * t305
  t1015 = 0.1e1 / t389
  t1016 = t1015 * t315
  t1022 = 0.1e1 / t35 / t312 / t300
  t1024 = t1022 * t327 * t37
  t1035 = 0.1e1 / t14 / t474
  t1037 = t1035 * t405 * t17
  t1048 = 0.1e1 / t474 / t363
  t1049 = t1048 * t478
  t1058 = t320 * t310
  t1062 = 0.1e1 / t35 / t474 / t300
  t1069 = -0.91259259259259259259259259259259259259259259259257e1 * t287 * t1005 * t292 + 0.16165925925925925925925925925925925925925925925927e2 * t370 * t1012 - 0.86471111111111111111111111111111111111111111111117e1 * t439 * t1016 + 0.72817777777777777777777777777777777777777777777782e0 * t286 * t320 * t1024 - 0.19816296296296296296296296296296296296296296296296e2 * t298 * t1012 + 0.30226962962962962962962962962962962962962962962964e2 * t380 * t1016 - 0.73728000000000000000000000000000000000000000000002e1 * t448 * t1024 + 0.11650844444444444444444444444444444444444444444445e1 * t296 * t398 * t1037 - 0.23040e2 * t311 * t1016 + 0.16440888888888888888888888888888888888888888888889e2 * t388 * t1024 - 0.76458666666666666666666666666666666666666666666668e1 * t460 * t1037 + 0.11650844444444444444444444444444444444444444444445e1 * t309 * t472 * t1049 - 0.10088296296296296296296296296296296296296296296296e2 * t321 * t1024 + 0.13865718518518518518518518518518518518518518518519e2 * t399 * t1037 - 0.62623288888888888888888888888888888888888888888894e1 * t473 * t1049 + 0.46603377777777777777777777777777777777777777777782e0 * t319 * t1058 * t1062 / t326 / t314 * t37
  t1080 = t605 * t593
  t1097 = 0.1e1 / t487 / t493 * t7 * t760 / 0.4e1
  t1099 = t539 * t365
  t1100 = t538 * t1099
  t1102 = t508 * t770
  t1103 = t507 * t1102
  t1105 = t9 * t771
  t1107 = t486 ** (-0.15e1)
  t1109 = t1107 * t7 * t760
  t1111 = t549 * t1099
  t1113 = t514 * t1102
  t1115 = t33 * t765
  t1126 = t531 * t520
  t1147 = -0.32530742648344572643999342659690126035062438557102e-1 * t586 * t54 * t607 + 0.34451131037037037037037037037037037037037037037036e-2 * t9 * t771 * t499 - 0.10253897021007794930818001372045340355835853271641e4 * t602 / t621 / t587 * t1080 / t624 / t580 + 0.10389453539625517979803415350183779755340003251893e3 * t602 / t621 / t577 * t1080 * t625 - 0.58482233974552040708313425006184496242808878304903e0 * t602 * t588 * (-0.34523333333333333333333333333333333333333333333333e1 * t1097 + 0.23015555555555555555555555555555555555555555555556e1 * t1100 - 0.26851481481481481481481481481481481481481481481482e1 * t1103 - 0.93932222222222222222222222222222222222222222222223e0 * t1105 + 0.73355000000000000000000000000000000000000000000000e-1 * t1109 - 0.14671000000000000000000000000000000000000000000000e0 * t1111 - 0.17116166666666666666666666666666666666666666666667e0 * t1113 - 0.36793333333333333333333333333333333333333333333333e0 * t1115) * t595 + 0.48245472966453314463992795342703676305040043742564e2 * t562 * t556 * t564 * t520 + 0.60000000000000000000000000000000000000000000000000e1 * t562 * t1126 * t521 - 0.60000000000000000000000000000000000000000000000000e1 * t530 * t522 * t556 - 0.51947267698127589899017076750918898776700016259463e2 * t602 * t622 * t616 * t625 * t593 - 0.35089340384731224424988055003710697745685326982943e1 * t602 * t622 * t1080 * t595 + 0.35089340384731224424988055003710697745685326982943e1 * t602 * t604 * t593 * t595 * t616
  t1203 = -0.85917146441092277507960503039464796886558811231548e0 * t12 * t53 * t561 * t565 + 0.71233333333333333333333333333333333333333333333333e-1 * t12 * t16 * t504 * t522 - 0.53424999999999999999999999999999999999999999999999e-1 * t12 * t505 * t557 + 0.51725014705706168413145063783413931475389495076352e3 * t527 / t560 / t503 * t1126 / t563 / t498 + 0.10000000000000000000000000000000000000000000000000e1 * t535 * (-0.25319000000000000000000000000000000000000000000000e1 * t1097 + 0.16879333333333333333333333333333333333333333333333e1 * t1100 - 0.19692555555555555555555555555555555555555555555555e1 * t1103 - 0.93011851851851851851851851851851851851851851851854e0 * t1105 + 0.13651666666666666666666666666666666666666666666667e0 * t1109 - 0.27303333333333333333333333333333333333333333333333e0 * t1111 - 0.31853888888888888888888888888888888888888888888890e0 * t1113 - 0.36514074074074074074074074074074074074074074074075e0 * t1115) * t521 - 0.96490945932906628927985590685407352610080087485128e2 * t527 / t560 / t495 * t1126 * t564 + 0.10685000000000000000000000000000000000000000000000e0 * t12 * t53 * t529 * t532 - 0.56969282336565386484066937725323112718202900731800e-3 * t572 * t508 * t770 * t581 - 0.2e1 * t996 - 0.21687161765563048429332895106460084023374959038068e-1 * t586 * t108 * t596 + 0.16265371324172286321999671329845063017531219278551e-1 * t586 * t54 * t618 + 0.48159446095139119802213748237831062407565640073877e0 * t586 * t54 * t626
  t1213 = t1011 * t643
  t1216 = t1015 * t650
  t1221 = t1022 * t657 * t37
  t1232 = t1035 * t701 * t17
  t1242 = t1048 * t749
  t1258 = -0.27377777777777777777777777777777777777777777777778e0 * t633 * t1005 * t636 + 0.14549333333333333333333333333333333333333333333333e-1 * t680 * t1213 - 0.23347200000000000000000000000000000000000000000000e-3 * t721 * t1216 + 0.58982400000000000000000000000000000000000000000000e-6 * t632 * t320 * t1221 - 0.17834666666666666666666666666666666666666666666667e-1 * t641 * t1213 + 0.81612800000000000000000000000000000000000000000000e-3 * t686 * t1216 - 0.59719680000000000000000000000000000000000000000000e-5 * t729 * t1221 + 0.28311552000000000000000000000000000000000000000000e-7 * t640 * t398 * t1232 - 0.622080e-3 * t648 * t1216 + 0.13317120000000000000000000000000000000000000000000e-4 * t692 * t1221 - 0.18579456000000000000000000000000000000000000000000e-6 * t738 * t1232 + 0.84934656000000000000000000000000000000000000000000e-9 * t647 * t472 * t1242 - 0.81715200000000000000000000000000000000000000000000e-5 * t655 * t1221 + 0.33693696000000000000000000000000000000000000000000e-6 * t699 * t1232 - 0.45652377600000000000000000000000000000000000000000e-8 * t747 * t1242 + 0.10192158720000000000000000000000000000000000000000e-10 * t654 * t1058 * t1062 / t656 / t649 * t37
  v3rho3_0_ = 0.6e1 * t284 * t331 + 0.12e2 * t362 * t409 + 0.6e1 * t425 * t482 + 0.3e1 * t630 * t661 + 0.6e1 * t676 * t705 + 0.3e1 * t714 * t753 + r0 * (0.2e1 * t996 * t331 + 0.6e1 * t284 * t409 + 0.6e1 * t362 * t482 + 0.2e1 * t425 * t1069 + (t1147 + t1203) * t661 + 0.3e1 * t630 * t705 + 0.3e1 * t676 * t753 + t714 * t1258)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 * f.p.zeta_threshold
  t9 = 2 ** (0.1e1 / 0.3e1)
  t11 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t8, 0.2e1 * t9)
  t13 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t8, 0)
  t17 = 0.1e1 / (0.2e1 * t9 - 0.2e1)
  t18 = (t11 + t13 - 0.2e1) * t17
  t19 = 3 ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / jnp.pi
  t21 = t20 ** (0.1e1 / 0.3e1)
  t22 = t19 * t21
  t23 = 4 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t22 * t24
  t26 = t18 * t25
  t27 = r0 ** 2
  t28 = r0 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t28 / t27
  t31 = t30 * t9
  t33 = f.my_piecewise3(t3, 0.1e1 / t7, 1)
  t34 = t31 * t33
  t35 = 0.1e1 / t28
  t38 = t25 * t35 * t9 * t33
  t39 = jnp.sqrt(t38)
  t42 = t38 ** 0.15e1
  t44 = t19 ** 2
  t45 = t21 ** 2
  t46 = t44 * t45
  t47 = t46 * t23
  t48 = t28 ** 2
  t49 = 0.1e1 / t48
  t50 = t9 ** 2
  t52 = t33 ** 2
  t54 = t47 * t49 * t50 * t52
  t56 = 0.51785000000000000000000000000000000000000000000000e1 * t39 + 0.90577500000000000000000000000000000000000000000000e0 * t38 + 0.11003250000000000000000000000000000000000000000000e0 * t42 + 0.12417750000000000000000000000000000000000000000000e0 * t54
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t61 = 0.1e1 / t39 * t19 * t21
  t63 = 0.1e1 / t28 / r0
  t64 = t24 * t63
  t65 = t9 * t33
  t66 = t64 * t65
  t67 = t61 * t66
  t69 = t63 * t9
  t70 = t69 * t33
  t71 = t25 * t70
  t73 = t38 ** 0.5e0
  t75 = t73 * t19 * t21
  t76 = t75 * t66
  t79 = 0.1e1 / t48 / r0
  t82 = t47 * t79 * t50 * t52
  t84 = -0.86308333333333333333333333333333333333333333333334e0 * t67 - 0.30192500000000000000000000000000000000000000000000e0 * t71 - 0.55016250000000000000000000000000000000000000000000e-1 * t76 - 0.82785000000000000000000000000000000000000000000000e-1 * t82
  t88 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t56
  t89 = 0.1e1 / t88
  t90 = t58 * t84 * t89
  t97 = 0.1e1 / t39 / t38 * t44 * t45
  t99 = 0.1e1 / t48 / t27
  t100 = t23 * t99
  t101 = t50 * t52
  t102 = t100 * t101
  t103 = t97 * t102
  t105 = t24 * t30
  t106 = t105 * t65
  t107 = t61 * t106
  t109 = t25 * t34
  t111 = t38 ** (-0.5e0)
  t113 = t111 * t44 * t45
  t114 = t113 * t102
  t116 = t75 * t106
  t118 = t99 * t50
  t120 = t47 * t118 * t52
  t122 = -0.57538888888888888888888888888888888888888888888889e0 * t103 + 0.11507777777777777777777777777777777777777777777778e1 * t107 + 0.40256666666666666666666666666666666666666666666667e0 * t109 + 0.36677500000000000000000000000000000000000000000000e-1 * t114 + 0.73355000000000000000000000000000000000000000000000e-1 * t116 + 0.13797500000000000000000000000000000000000000000000e0 * t120
  t124 = t58 * t122 * t89
  t128 = t57 ** 2
  t129 = 0.1e1 / t128
  t130 = t84 ** 2
  t131 = t129 * t130
  t132 = t88 ** 2
  t133 = 0.1e1 / t132
  t134 = t131 * t133
  t138 = t18 * t22
  t139 = t27 * r0
  t141 = 0.1e1 / t28 / t139
  t142 = t24 * t141
  t143 = jnp.log(t88)
  t144 = t65 * t143
  t148 = t22 * t64
  t153 = 0.37978500000000000000000000000000000000000000000000e1 * t39 + 0.89690000000000000000000000000000000000000000000000e0 * t38 + 0.20477500000000000000000000000000000000000000000000e0 * t42 + 0.12323500000000000000000000000000000000000000000000e0 * t54
  t154 = t153 ** 2
  t155 = t154 * t153
  t156 = 0.1e1 / t155
  t161 = -0.63297500000000000000000000000000000000000000000000e0 * t67 - 0.29896666666666666666666666666666666666666666666667e0 * t71 - 0.10238750000000000000000000000000000000000000000000e0 * t76 - 0.82156666666666666666666666666666666666666666666667e-1 * t82
  t162 = t161 ** 2
  t166 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t153
  t167 = 0.1e1 / t166
  t169 = t65 * t156 * t162 * t167
  t171 = 0.10685000000000000000000000000000000000000000000000e0 * t148 * t169
  t172 = t141 * t9
  t173 = jnp.log(t166)
  t174 = t33 * t173
  t177 = 0.34451131037037037037037037037037037037037037037036e-2 * t25 * t172 * t174
  t178 = t22 * t105
  t179 = 0.1e1 / t154
  t182 = t65 * t179 * t161 * t167
  t184 = 0.71233333333333333333333333333333333333333333333333e-1 * t178 * t182
  t191 = -0.42198333333333333333333333333333333333333333333333e0 * t103 + 0.84396666666666666666666666666666666666666666666666e0 * t107 + 0.39862222222222222222222222222222222222222222222223e0 * t109 + 0.68258333333333333333333333333333333333333333333333e-1 * t114 + 0.13651666666666666666666666666666666666666666666667e0 * t116 + 0.13692777777777777777777777777777777777777777777778e0 * t120
  t194 = t65 * t179 * t191 * t167
  t196 = 0.53424999999999999999999999999999999999999999999999e-1 * t148 * t194
  t197 = t154 ** 2
  t198 = 0.1e1 / t197
  t200 = t166 ** 2
  t201 = 0.1e1 / t200
  t203 = t65 * t198 * t162 * t201
  t205 = 0.85917146441092277507960503039464796886558811231548e0 * t148 * t203
  t207 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t38
  t208 = t207 * t198
  t209 = t162 * t161
  t212 = 0.60000000000000000000000000000000000000000000000000e1 * t208 * t209 * t167
  t213 = t207 * t156
  t214 = t161 * t167
  t215 = t214 * t191
  t217 = 0.60000000000000000000000000000000000000000000000000e1 * t213 * t215
  t218 = -0.21687161765563048429332895106460084023374959038068e-1 * t26 * t34 * t90 + 0.16265371324172286321999671329845063017531219278551e-1 * t26 * t70 * t124 + 0.48159446095139119802213748237831062407565640073877e0 * t26 * t70 * t134 - 0.56969282336565386484066937725323112718202900731800e-3 * t138 * t142 * t144 + t171 + t177 + t184 - t196 - t205 + t212 - t217
  t220 = t191 * t201 * t161
  t222 = 0.48245472966453314463992795342703676305040043742564e2 * t208 * t220
  t224 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t38
  t225 = t18 * t224
  t227 = t133 * t84
  t231 = t130 * t84
  t233 = t129 * t231 * t89
  t236 = t57 * t56
  t237 = 0.1e1 / t236
  t238 = t237 * t84
  t239 = t89 * t122
  t244 = 0.1e1 / t128 / t57
  t247 = 0.1e1 / t132 / t88
  t248 = t244 * t231 * t247
  t254 = 0.1e1 / t39 / t54 * t20 / 0.4e1
  t255 = t27 ** 2
  t256 = 0.1e1 / t255
  t257 = t52 * t33
  t258 = t256 * t257
  t259 = t254 * t258
  t262 = 0.1e1 / t48 / t139
  t263 = t23 * t262
  t264 = t263 * t101
  t265 = t97 * t264
  t267 = t142 * t65
  t268 = t61 * t267
  t270 = t172 * t33
  t271 = t25 * t270
  t273 = t38 ** (-0.15e1)
  t274 = t273 * t20
  t275 = t274 * t258
  t277 = t113 * t264
  t279 = t75 * t267
  t281 = t262 * t50
  t283 = t47 * t281 * t52
  t285 = -0.69046666666666666666666666666666666666666666666667e1 * t259 + 0.23015555555555555555555555555555555555555555555556e1 * t265 - 0.26851481481481481481481481481481481481481481481482e1 * t268 - 0.93932222222222222222222222222222222222222222222223e0 * t271 + 0.14671000000000000000000000000000000000000000000000e0 * t275 - 0.14671000000000000000000000000000000000000000000000e0 * t277 - 0.17116166666666666666666666666666666666666666666667e0 * t279 - 0.36793333333333333333333333333333333333333333333333e0 * t283
  t287 = t58 * t285 * t89
  t291 = 0.1e1 / t128 / t56
  t293 = t291 * t231 * t133
  t297 = t237 * t130 * t89
  t302 = 0.1e1 / t197 / t153
  t303 = t207 * t302
  t306 = 0.96490945932906628927985590685407352610080087485128e2 * t303 * t209 * t201
  t307 = t207 * t179
  t316 = -0.50638000000000000000000000000000000000000000000000e1 * t259 + 0.16879333333333333333333333333333333333333333333333e1 * t265 - 0.19692555555555555555555555555555555555555555555555e1 * t268 - 0.93011851851851851851851851851851851851851851851854e0 * t271 + 0.27303333333333333333333333333333333333333333333333e0 * t275 - 0.27303333333333333333333333333333333333333333333333e0 * t277 - 0.31853888888888888888888888888888888888888888888890e0 * t279 - 0.36514074074074074074074074074074074074074074074075e0 * t283
  t319 = 0.10000000000000000000000000000000000000000000000000e1 * t307 * t316 * t167
  t321 = 0.1e1 / t197 / t154
  t322 = t207 * t321
  t324 = 0.1e1 / t200 / t166
  t327 = 0.51725014705706168413145063783413931475389495076352e3 * t322 * t209 * t324
  t332 = 0.70594500000000000000000000000000000000000000000000e1 * t39 + 0.15494250000000000000000000000000000000000000000000e1 * t38 + 0.42077500000000000000000000000000000000000000000000e0 * t42 + 0.15629250000000000000000000000000000000000000000000e0 * t54
  t335 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t332
  t336 = jnp.log(t335)
  t337 = t33 * t336
  t341 = t33 * t143
  t345 = t224 * t129
  t346 = t122 * t133
  t347 = t346 * t84
  t351 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t38
  t352 = t332 ** 2
  t353 = t352 * t332
  t354 = 0.1e1 / t353
  t355 = t351 * t354
  t360 = -0.11765750000000000000000000000000000000000000000000e1 * t67 - 0.51647500000000000000000000000000000000000000000000e0 * t71 - 0.21038750000000000000000000000000000000000000000000e0 * t76 - 0.10419500000000000000000000000000000000000000000000e0 * t82
  t361 = 0.1e1 / t335
  t362 = t360 * t361
  t369 = -0.78438333333333333333333333333333333333333333333333e0 * t103 + 0.15687666666666666666666666666666666666666666666667e1 * t107 + 0.68863333333333333333333333333333333333333333333333e0 * t109 + 0.14025833333333333333333333333333333333333333333333e0 * t114 + 0.28051666666666666666666666666666666666666666666667e0 * t116 + 0.17365833333333333333333333333333333333333333333333e0 * t120
  t370 = t362 * t369
  t373 = t352 ** 2
  t374 = 0.1e1 / t373
  t375 = t351 * t374
  t376 = t335 ** 2
  t377 = 0.1e1 / t376
  t379 = t369 * t377 * t360
  t382 = t224 * t237
  t383 = t84 * t89
  t384 = t383 * t122
  t388 = 0.1e1 / t373 / t332
  t389 = t351 * t388
  t390 = t360 ** 2
  t391 = t390 * t360
  t395 = 0.1e1 / t352
  t396 = t351 * t395
  t405 = -0.94126000000000000000000000000000000000000000000000e1 * t259 + 0.31375333333333333333333333333333333333333333333334e1 * t265 - 0.36604555555555555555555555555555555555555555555556e1 * t268 - 0.16068111111111111111111111111111111111111111111111e1 * t271 + 0.56103333333333333333333333333333333333333333333332e0 * t275 - 0.56103333333333333333333333333333333333333333333332e0 * t277 - 0.65453888888888888888888888888888888888888888888890e0 * t279 - 0.46308888888888888888888888888888888888888888888888e0 * t283
  t410 = 0.1e1 / t373 / t352
  t411 = t351 * t410
  t413 = 0.1e1 / t376 / t335
  t417 = t224 * t291
  t421 = 0.16562449037037037037037037037037037037037037037036e-2 * t25 * t172 * t337 + 0.56969282336565386484066937725323112718202900731800e-3 * t25 * t172 * t341 + 0.51947267698127589899017076750918898776700016259463e2 * t345 * t347 - 0.60000000000000000000000000000000000000000000000000e1 * t355 * t370 + 0.96494049533612093920874879382438082984882598906400e2 * t375 * t379 - 0.35089340384731224424988055003710697745685326982943e1 * t382 * t384 - t212 + t306 - t319 - t327 + t217 - t222 - 0.19298809906722418784174975876487616596976519781280e3 * t389 * t391 * t377 + 0.99999999999999999999999999999999999999999999999999e0 * t396 * t405 * t361 + 0.20691336878655965245175271659148296983999699561788e4 * t411 * t391 * t413 - 0.10389453539625517979803415350183779755340003251893e3 * t417 * t231 * t133
  t422 = t224 * t58
  t423 = t285 * t89
  t432 = t224 * t244
  t436 = t65 * t297
  t441 = t65 * t354 * t390 * t361
  t444 = t65 * t90
  t447 = t65 * t124
  t450 = t65 * t134
  t455 = t65 * t395 * t360 * t361
  t460 = t65 * t395 * t369 * t361
  t465 = t65 * t374 * t390 * t377
  t468 = 0.58482233974552040708313425006184496242808878304903e0 * t422 * t423 + 0.60000000000000000000000000000000000000000000000000e1 * t375 * t391 * t361 + 0.35089340384731224424988055003710697745685326982943e1 * t345 * t231 * t89 + 0.10253897021007794930818001372045340355835853271641e4 * t432 * t231 * t247 - t177 - t171 - t184 + t196 + t205 + 0.32530742648344572643999342659690126035062438557102e-1 * t148 * t436 + 0.10274000000000000000000000000000000000000000000000e0 * t148 * t441 + 0.21687161765563048429332895106460084023374959038068e-1 * t178 * t444 - 0.16265371324172286321999671329845063017531219278551e-1 * t148 * t447 - 0.48159446095139119802213748237831062407565640073877e0 * t148 * t450 + 0.68493333333333333333333333333333333333333333333331e-1 * t178 * t455 - 0.51369999999999999999999999999999999999999999999999e-1 * t148 * t460 - 0.16522997748472177549051141846252814409778063686072e1 * t148 * t465
  t471 = t222 - 0.51947267698127589899017076750918898776700016259463e2 * t225 * t129 * t122 * t227 - 0.35089340384731224424988055003710697745685326982943e1 * t225 * t233 + 0.35089340384731224424988055003710697745685326982943e1 * t225 * t238 * t239 - 0.10253897021007794930818001372045340355835853271641e4 * t225 * t248 - 0.58482233974552040708313425006184496242808878304903e0 * t225 * t287 + 0.10389453539625517979803415350183779755340003251893e3 * t225 * t293 - 0.32530742648344572643999342659690126035062438557102e-1 * t26 * t70 * t297 - t306 + t319 + t327 + t18 * (t421 + t468)
  t475 = f.my_piecewise3(t4, 0, t5 * (t218 + t471) / 0.2e1)
  t477 = params.c_ss[1]
  t478 = t477 * s0
  t480 = s0 * t50 * t99
  t482 = 0.1e1 + 0.2e0 * t480
  t483 = 0.1e1 / t482
  t487 = params.c_ss[2]
  t488 = s0 ** 2
  t489 = t487 * t488
  t490 = t255 * r0
  t492 = 0.1e1 / t28 / t490
  t493 = t9 * t492
  t494 = t482 ** 2
  t495 = 0.1e1 / t494
  t499 = params.c_ss[3]
  t500 = t488 * s0
  t501 = t499 * t500
  t502 = t255 ** 2
  t503 = 0.1e1 / t502
  t504 = t494 * t482
  t505 = 0.1e1 / t504
  t509 = params.c_ss[4]
  t510 = t488 ** 2
  t511 = t509 * t510
  t512 = t502 * t27
  t515 = t50 / t48 / t512
  t516 = t494 ** 2
  t517 = 0.1e1 / t516
  t521 = params.c_ss[0] + 0.2e0 * t478 * t118 * t483 + 0.8e-1 * t489 * t493 * t495 + 0.32e-1 * t501 * t503 * t505 + 0.64e-2 * t511 * t515 * t517
  t526 = 0.14764770444444444444444444444444444444444444444444e-2 * t25 * t31 * t174
  t528 = 0.35616666666666666666666666666666666666666666666666e-1 * t148 * t182
  t529 = t162 * t167
  t531 = 0.20000000000000000000000000000000000000000000000000e1 * t213 * t529
  t534 = 0.10000000000000000000000000000000000000000000000000e1 * t307 * t191 * t167
  t535 = t162 * t201
  t537 = 0.16081824322151104821330931780901225435013347914188e2 * t208 * t535
  t543 = t390 * t361
  t549 = t390 * t377
  t557 = t130 * t89
  t562 = t130 * t133
  t565 = -0.70981924444444444444444444444444444444444444444442e-3 * t25 * t31 * t337 - 0.34246666666666666666666666666666666666666666666666e-1 * t148 * t455 - 0.20000000000000000000000000000000000000000000000000e1 * t355 * t543 + 0.99999999999999999999999999999999999999999999999999e0 * t396 * t369 * t361 + 0.32164683177870697973624959794146027661627532968800e2 * t375 * t549 + t526 + t528 + t531 - t534 - t537 - 0.24415406715670879921742973310852762593515528885057e-3 * t25 * t31 * t341 - 0.10843580882781524214666447553230042011687479519034e-1 * t148 * t444 - 0.11696446794910408141662685001236899248561775660981e1 * t382 * t557 + 0.58482233974552040708313425006184496242808878304903e0 * t422 * t239 + 0.17315755899375863299672358916972966258900005419821e2 * t345 * t562
  t579 = -t526 - t528 - t531 + t534 + t537 + t18 * t565 + 0.24415406715670879921742973310852762593515528885057e-3 * t138 * t105 * t144 + 0.10843580882781524214666447553230042011687479519034e-1 * t26 * t70 * t90 + 0.11696446794910408141662685001236899248561775660981e1 * t225 * t297 - 0.58482233974552040708313425006184496242808878304903e0 * t225 * t124 - 0.17315755899375863299672358916972966258900005419821e2 * t225 * t134
  t582 = f.my_piecewise3(t4, 0, t5 * t579 / 0.2e1)
  t586 = t477 * t488
  t587 = t255 * t27
  t590 = t9 / t28 / t587
  t591 = t590 * t495
  t596 = t487 * t500
  t597 = t502 * r0
  t598 = 0.1e1 / t597
  t599 = t598 * t505
  t604 = t499 * t510
  t605 = t502 * t139
  t607 = 0.1e1 / t48 / t605
  t609 = t607 * t517 * t50
  t614 = t510 * s0
  t615 = t509 * t614
  t616 = t502 * t587
  t619 = t9 / t28 / t616
  t621 = 0.1e1 / t516 / t482
  t625 = -0.53333333333333333333333333333333333333333333333333e0 * t478 * t281 * t483 + 0.21333333333333333333333333333333333333333333333334e0 * t586 * t591 - 0.42666666666666666666666666666666666666666666666667e0 * t489 * t591 + 0.17066666666666666666666666666666666666666666666667e0 * t596 * t599 - 0.256e0 * t501 * t599 + 0.51200000000000000000000000000000000000000000000000e-1 * t604 * t609 - 0.68266666666666666666666666666666666666666666666667e-1 * t511 * t609 + 0.27306666666666666666666666666666666666666666666668e-1 * t615 * t619 * t621
  t630 = 0.11073577833333333333333333333333333333333333333333e-2 * t25 * t69 * t174
  t632 = 0.10000000000000000000000000000000000000000000000000e1 * t307 * t214
  t653 = f.my_piecewise3(t4, 0, t5 * (t630 + t632 + t18 * (0.53236443333333333333333333333333333333333333333332e-3 * t25 * t69 * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t396 * t362 - t630 - t632 + 0.18311555036753159941307229983139571945136646663793e-3 * t25 * t69 * t341 + 0.58482233974552040708313425006184496242808878304903e0 * t422 * t383) - 0.18311555036753159941307229983139571945136646663793e-3 * t138 * t64 * t144 - 0.58482233974552040708313425006184496242808878304903e0 * t225 * t90) / 0.2e1)
  t655 = 0.1e1 / t48 / t255
  t656 = t50 * t655
  t660 = t255 * t139
  t663 = t9 / t28 / t660
  t664 = t663 * t495
  t667 = t477 * t500
  t668 = 0.1e1 / t512
  t669 = t668 * t505
  t676 = t487 * t510
  t677 = t502 * t255
  t679 = 0.1e1 / t48 / t677
  t681 = t679 * t517 * t50
  t688 = t499 * t614
  t691 = 0.1e1 / t28 / t502 / t660
  t693 = t691 * t621 * t9
  t700 = t510 * t488
  t701 = t509 * t700
  t702 = t502 ** 2
  t704 = 0.1e1 / t702 / t27
  t706 = 0.1e1 / t516 / t494
  t710 = 0.19555555555555555555555555555555555555555555555555e1 * t478 * t656 * t483 - 0.19200000000000000000000000000000000000000000000001e1 * t586 * t664 + 0.45511111111111111111111111111111111111111111111114e0 * t667 * t669 + 0.27022222222222222222222222222222222222222222222222e1 * t489 * t664 - 0.24462222222222222222222222222222222222222222222223e1 * t596 * t669 + 0.27306666666666666666666666666666666666666666666667e0 * t676 * t681 + 0.2304e1 * t501 * t669 - 0.10069333333333333333333333333333333333333333333333e1 * t604 * t681 + 0.21845333333333333333333333333333333333333333333334e0 * t688 * t693 + 0.79644444444444444444444444444444444444444444444445e0 * t511 * t681 - 0.68266666666666666666666666666666666666666666666669e0 * t615 * t693 + 0.14563555555555555555555555555555555555555555555557e0 * t701 * t704 * t706
  t714 = 0.62182e-1 * t207 * t173
  t717 = t224 * t143
  t726 = f.my_piecewise3(t4, 0, t5 * (-t714 + t18 * (-0.31090e-1 * t351 * t336 + t714 - 0.19751789702565206228825776161588751761046270558698e-1 * t717) + 0.19751789702565206228825776161588751761046270558698e-1 * t18 * t717) / 0.2e1)
  t729 = t50 / t48 / t490
  t735 = t9 / t28 / t502
  t736 = t735 * t495
  t739 = 0.1e1 / t605
  t740 = t739 * t505
  t743 = t477 * t510
  t746 = 0.1e1 / t48 / t502 / t490
  t748 = t746 * t517 * t50
  t757 = t487 * t614
  t759 = 0.1e1 / t28 / t702
  t761 = t759 * t621 * t9
  t770 = t499 * t700
  t772 = 0.1e1 / t702 / t139
  t773 = t772 * t706
  t782 = t510 * t500
  t783 = t509 * t782
  t786 = 0.1e1 / t48 / t702 / t490
  t788 = 0.1e1 / t516 / t504
  t793 = -0.91259259259259259259259259259259259259259259259257e1 * t478 * t729 * t483 + 0.16165925925925925925925925925925925925925925925927e2 * t586 * t736 - 0.86471111111111111111111111111111111111111111111117e1 * t667 * t740 + 0.72817777777777777777777777777777777777777777777782e0 * t743 * t748 - 0.19816296296296296296296296296296296296296296296296e2 * t489 * t736 + 0.30226962962962962962962962962962962962962962962964e2 * t596 * t740 - 0.73728000000000000000000000000000000000000000000002e1 * t676 * t748 + 0.11650844444444444444444444444444444444444444444445e1 * t757 * t761 - 0.23040e2 * t501 * t740 + 0.16440888888888888888888888888888888888888888888889e2 * t604 * t748 - 0.76458666666666666666666666666666666666666666666668e1 * t688 * t761 + 0.11650844444444444444444444444444444444444444444445e1 * t770 * t773 - 0.10088296296296296296296296296296296296296296296296e2 * t511 * t748 + 0.13865718518518518518518518518518518518518518518519e2 * t615 * t761 - 0.62623288888888888888888888888888888888888888888894e1 * t701 * t773 + 0.46603377777777777777777777777777777777777777777782e0 * t783 * t786 * t788 * t50
  t796 = f.my_piecewise3(t3, t8, 1)
  t799 = (0.2e1 * t796 - 0.2e1) * t17
  t800 = t799 * t22
  t802 = t22 * t24 * t35
  t803 = jnp.sqrt(t802)
  t806 = t802 ** 0.15e1
  t809 = t46 * t23 * t49
  t811 = 0.51785000000000000000000000000000000000000000000000e1 * t803 + 0.90577500000000000000000000000000000000000000000000e0 * t802 + 0.11003250000000000000000000000000000000000000000000e0 * t806 + 0.12417750000000000000000000000000000000000000000000e0 * t809
  t812 = t811 ** 2
  t813 = t812 * t811
  t814 = 0.1e1 / t813
  t816 = 0.1e1 / t803 * t19
  t817 = t21 * t24
  t818 = t817 * t63
  t819 = t816 * t818
  t822 = t802 ** 0.5e0
  t823 = t822 * t19
  t824 = t823 * t818
  t827 = t46 * t23 * t79
  t829 = -0.86308333333333333333333333333333333333333333333334e0 * t819 - 0.30192500000000000000000000000000000000000000000000e0 * t148 - 0.55016250000000000000000000000000000000000000000000e-1 * t824 - 0.82785000000000000000000000000000000000000000000000e-1 * t827
  t830 = t829 ** 2
  t834 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t811
  t835 = 0.1e1 / t834
  t836 = t814 * t830 * t835
  t841 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t802
  t842 = t799 * t841
  t843 = t812 ** 2
  t845 = 0.1e1 / t843 / t812
  t846 = t830 * t829
  t848 = t834 ** 2
  t850 = 0.1e1 / t848 / t834
  t851 = t845 * t846 * t850
  t855 = 0.1e1 / t843 / t811
  t857 = 0.1e1 / t848
  t858 = t855 * t846 * t857
  t861 = 0.1e1 / t812
  t865 = 0.1e1 / t803 / t809 * t20 / 0.4e1
  t866 = t865 * t256
  t870 = 0.1e1 / t803 / t802 * t44
  t871 = t45 * t23
  t872 = t871 * t262
  t873 = t870 * t872
  t875 = t817 * t141
  t876 = t816 * t875
  t878 = t22 * t142
  t880 = t802 ** (-0.15e1)
  t881 = t880 * t20
  t882 = t881 * t256
  t884 = t802 ** (-0.5e0)
  t885 = t884 * t44
  t886 = t885 * t872
  t888 = t823 * t875
  t890 = t46 * t263
  t892 = -0.34523333333333333333333333333333333333333333333333e1 * t866 + 0.23015555555555555555555555555555555555555555555556e1 * t873 - 0.26851481481481481481481481481481481481481481481482e1 * t876 - 0.93932222222222222222222222222222222222222222222223e0 * t878 + 0.73355000000000000000000000000000000000000000000000e-1 * t882 - 0.14671000000000000000000000000000000000000000000000e0 * t886 - 0.17116166666666666666666666666666666666666666666667e0 * t888 - 0.36793333333333333333333333333333333333333333333333e0 * t890
  t894 = t861 * t892 * t835
  t898 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t802
  t903 = 0.37978500000000000000000000000000000000000000000000e1 * t803 + 0.89690000000000000000000000000000000000000000000000e0 * t802 + 0.20477500000000000000000000000000000000000000000000e0 * t806 + 0.12323500000000000000000000000000000000000000000000e0 * t809
  t904 = t903 ** 2
  t905 = t904 ** 2
  t906 = 0.1e1 / t905
  t907 = t898 * t906
  t908 = t871 * t99
  t909 = t870 * t908
  t911 = t817 * t30
  t912 = t816 * t911
  t915 = t885 * t908
  t917 = t823 * t911
  t919 = t46 * t100
  t921 = -0.42198333333333333333333333333333333333333333333333e0 * t909 + 0.84396666666666666666666666666666666666666666666666e0 * t912 + 0.39862222222222222222222222222222222222222222222223e0 * t178 + 0.68258333333333333333333333333333333333333333333333e-1 * t915 + 0.13651666666666666666666666666666666666666666666667e0 * t917 + 0.13692777777777777777777777777777777777777777777778e0 * t919
  t924 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t903
  t925 = t924 ** 2
  t926 = 0.1e1 / t925
  t927 = t921 * t926
  t932 = -0.63297500000000000000000000000000000000000000000000e0 * t819 - 0.29896666666666666666666666666666666666666666666667e0 * t148 - 0.10238750000000000000000000000000000000000000000000e0 * t824 - 0.82156666666666666666666666666666666666666666666667e-1 * t827
  t936 = t932 ** 2
  t937 = t936 * t932
  t938 = 0.1e1 / t924
  t939 = t937 * t938
  t942 = t904 * t903
  t943 = 0.1e1 / t942
  t944 = t898 * t943
  t945 = t932 * t938
  t949 = 0.1e1 / t843
  t956 = -0.57538888888888888888888888888888888888888888888889e0 * t909 + 0.11507777777777777777777777777777777777777777777778e1 * t912 + 0.40256666666666666666666666666666666666666666666667e0 * t178 + 0.36677500000000000000000000000000000000000000000000e-1 * t915 + 0.73355000000000000000000000000000000000000000000000e-1 * t917 + 0.13797500000000000000000000000000000000000000000000e0 * t919
  t958 = t857 * t829
  t963 = t949 * t846 * t835
  t967 = t835 * t956
  t971 = t63 * t906
  t972 = t936 * t926
  t976 = -0.32530742648344572643999342659690126035062438557102e-1 * t800 * t64 * t836 - 0.10253897021007794930818001372045340355835853271641e4 * t842 * t851 + 0.10389453539625517979803415350183779755340003251893e3 * t842 * t858 - 0.58482233974552040708313425006184496242808878304903e0 * t842 * t894 + 0.48245472966453314463992795342703676305040043742564e2 * t907 * t927 * t932 + 0.60000000000000000000000000000000000000000000000000e1 * t907 * t939 - 0.60000000000000000000000000000000000000000000000000e1 * t944 * t945 * t921 - 0.51947267698127589899017076750918898776700016259463e2 * t842 * t949 * t956 * t958 - 0.35089340384731224424988055003710697745685326982943e1 * t842 * t963 + 0.35089340384731224424988055003710697745685326982943e1 * t842 * t814 * t829 * t967 - 0.85917146441092277507960503039464796886558811231548e0 * t25 * t971 * t972
  t977 = 0.1e1 / t904
  t978 = t30 * t977
  t982 = t63 * t977
  t983 = t921 * t938
  t988 = 0.1e1 / t905 / t904
  t989 = t898 * t988
  t991 = 0.1e1 / t925 / t924
  t992 = t937 * t991
  t996 = 0.1e1 / t905 / t903
  t997 = t898 * t996
  t998 = t937 * t926
  t1001 = t898 * t977
  t1010 = -0.25319000000000000000000000000000000000000000000000e1 * t866 + 0.16879333333333333333333333333333333333333333333333e1 * t873 - 0.19692555555555555555555555555555555555555555555555e1 * t876 - 0.93011851851851851851851851851851851851851851851854e0 * t878 + 0.13651666666666666666666666666666666666666666666667e0 * t882 - 0.27303333333333333333333333333333333333333333333333e0 * t886 - 0.31853888888888888888888888888888888888888888888890e0 * t888 - 0.36514074074074074074074074074074074074074074074075e0 * t890
  t1011 = t1010 * t938
  t1015 = t936 * t938
  t1019 = t799 * t19
  t1020 = jnp.log(t834)
  t1026 = jnp.log(t924)
  t1031 = t861 * t829 * t835
  t1036 = t861 * t956 * t835
  t1040 = t949 * t830
  t1041 = t1040 * t857
  t1045 = 0.71233333333333333333333333333333333333333333333333e-1 * t25 * t978 * t945 - 0.53424999999999999999999999999999999999999999999999e-1 * t25 * t982 * t983 + 0.51725014705706168413145063783413931475389495076352e3 * t989 * t992 - 0.96490945932906628927985590685407352610080087485128e2 * t997 * t998 + 0.10000000000000000000000000000000000000000000000000e1 * t1001 * t1011 + 0.10685000000000000000000000000000000000000000000000e0 * t25 * t63 * t943 * t1015 - 0.56969282336565386484066937725323112718202900731800e-3 * t1019 * t817 * t141 * t1020 - 0.2e1 * t475 + 0.34451131037037037037037037037037037037037037037036e-2 * t22 * t142 * t1026 - 0.21687161765563048429332895106460084023374959038068e-1 * t800 * t105 * t1031 + 0.16265371324172286321999671329845063017531219278551e-1 * t800 * t64 * t1036 + 0.48159446095139119802213748237831062407565640073877e0 * t800 * t64 * t1041
  t1046 = t976 + t1045
  t1048 = params.c_ab[1]
  t1049 = t1048 * s0
  t1051 = 0.1e1 + 0.6e-2 * t480
  t1052 = 0.1e1 / t1051
  t1056 = params.c_ab[2]
  t1057 = t1056 * t488
  t1058 = t1051 ** 2
  t1059 = 0.1e1 / t1058
  t1063 = params.c_ab[3]
  t1064 = t1063 * t500
  t1065 = t1058 * t1051
  t1066 = 0.1e1 / t1065
  t1070 = params.c_ab[4]
  t1071 = t1070 * t510
  t1072 = t1058 ** 2
  t1073 = 0.1e1 / t1072
  t1077 = params.c_ab[0] + 0.6e-2 * t1049 * t118 * t1052 + 0.72e-4 * t1057 * t493 * t1059 + 0.864e-6 * t1064 * t503 * t1066 + 0.5184e-8 * t1071 * t515 * t1073
  t1106 = -0.14764770444444444444444444444444444444444444444444e-2 * t22 * t105 * t1026 - 0.35616666666666666666666666666666666666666666666666e-1 * t25 * t982 * t945 - 0.20000000000000000000000000000000000000000000000000e1 * t944 * t1015 + 0.10000000000000000000000000000000000000000000000000e1 * t1001 * t983 + 0.16081824322151104821330931780901225435013347914188e2 * t907 * t972 + 0.24415406715670879921742973310852762593515528885057e-3 * t1019 * t817 * t30 * t1020 + 0.10843580882781524214666447553230042011687479519034e-1 * t800 * t64 * t1031 + 0.11696446794910408141662685001236899248561775660981e1 * t842 * t836 - 0.58482233974552040708313425006184496242808878304903e0 * t842 * t1036 - 0.17315755899375863299672358916972966258900005419821e2 * t842 * t1041 - 0.2e1 * t582
  t1110 = t1048 * t488
  t1111 = t590 * t1059
  t1116 = t1056 * t500
  t1117 = t598 * t1066
  t1122 = t1063 * t510
  t1124 = t607 * t1073 * t50
  t1129 = t1070 * t614
  t1131 = 0.1e1 / t1072 / t1051
  t1135 = -0.16000000000000000000000000000000000000000000000000e-1 * t1049 * t281 * t1052 + 0.19200000000000000000000000000000000000000000000000e-3 * t1110 * t1111 - 0.38400000000000000000000000000000000000000000000000e-3 * t1057 * t1111 + 0.46080000000000000000000000000000000000000000000000e-5 * t1116 * t1117 - 0.6912e-5 * t1064 * t1117 + 0.41472000000000000000000000000000000000000000000000e-7 * t1122 * t1124 - 0.55296000000000000000000000000000000000000000000000e-7 * t1071 * t1124 + 0.66355200000000000000000000000000000000000000000000e-9 * t1129 * t619 * t1131
  t1150 = 0.11073577833333333333333333333333333333333333333333e-2 * t22 * t64 * t1026 + 0.10000000000000000000000000000000000000000000000000e1 * t1001 * t945 - 0.18311555036753159941307229983139571945136646663793e-3 * t1019 * t817 * t63 * t1020 - 0.58482233974552040708313425006184496242808878304903e0 * t842 * t1031 - 0.2e1 * t653
  t1154 = t663 * t1059
  t1157 = t1048 * t500
  t1158 = t668 * t1066
  t1165 = t1056 * t510
  t1167 = t679 * t1073 * t50
  t1174 = t1063 * t614
  t1176 = t691 * t1131 * t9
  t1183 = t1070 * t700
  t1185 = 0.1e1 / t1072 / t1058
  t1189 = 0.58666666666666666666666666666666666666666666666667e-1 * t1049 * t656 * t1052 - 0.17280000000000000000000000000000000000000000000000e-2 * t1110 * t1154 + 0.12288000000000000000000000000000000000000000000000e-4 * t1157 * t1158 + 0.24320000000000000000000000000000000000000000000000e-2 * t1057 * t1154 - 0.66048000000000000000000000000000000000000000000000e-4 * t1116 * t1158 + 0.22118400000000000000000000000000000000000000000000e-6 * t1165 * t1167 + 0.62208e-4 * t1064 * t1158 - 0.81561600000000000000000000000000000000000000000000e-6 * t1122 * t1167 + 0.53084160000000000000000000000000000000000000000000e-8 * t1174 * t1176 + 0.64512000000000000000000000000000000000000000000000e-6 * t1071 * t1167 - 0.16588800000000000000000000000000000000000000000000e-7 * t1129 * t1176 + 0.10616832000000000000000000000000000000000000000000e-9 * t1183 * t704 * t1185
  t1198 = -0.62182e-1 * t898 * t1026 + 0.19751789702565206228825776161588751761046270558698e-1 * t799 * t841 * t1020 - 0.2e1 * t726
  t1202 = t735 * t1059
  t1205 = t739 * t1066
  t1208 = t1048 * t510
  t1210 = t746 * t1073 * t50
  t1219 = t1056 * t614
  t1221 = t759 * t1131 * t9
  t1230 = t1063 * t700
  t1231 = t772 * t1185
  t1240 = t1070 * t782
  t1242 = 0.1e1 / t1072 / t1065
  t1247 = -0.27377777777777777777777777777777777777777777777778e0 * t1049 * t729 * t1052 + 0.14549333333333333333333333333333333333333333333333e-1 * t1110 * t1202 - 0.23347200000000000000000000000000000000000000000000e-3 * t1157 * t1205 + 0.58982400000000000000000000000000000000000000000000e-6 * t1208 * t1210 - 0.17834666666666666666666666666666666666666666666667e-1 * t1057 * t1202 + 0.81612800000000000000000000000000000000000000000000e-3 * t1116 * t1205 - 0.59719680000000000000000000000000000000000000000000e-5 * t1165 * t1210 + 0.28311552000000000000000000000000000000000000000000e-7 * t1219 * t1221 - 0.622080e-3 * t1064 * t1205 + 0.13317120000000000000000000000000000000000000000000e-4 * t1122 * t1210 - 0.18579456000000000000000000000000000000000000000000e-6 * t1174 * t1221 + 0.84934656000000000000000000000000000000000000000000e-9 * t1230 * t1231 - 0.81715200000000000000000000000000000000000000000000e-5 * t1071 * t1210 + 0.33693696000000000000000000000000000000000000000000e-6 * t1129 * t1221 - 0.45652377600000000000000000000000000000000000000000e-8 * t1183 * t1231 + 0.10192158720000000000000000000000000000000000000000e-10 * t1240 * t786 * t1242 * t50
  t1253 = t162 ** 2
  t1256 = 0.62070017646847402095774076540096717770467394091622e4 * t207 / t197 / t155 * t1253 * t324
  t1257 = t191 ** 2
  t1260 = 0.48245472966453314463992795342703676305040043742564e2 * t208 * t1257 * t201
  t1265 = 0.36845452142031360632963667101718523854302450326054e2 * t148 * t65 * t321 * t209 * t324
  t1267 = 0.14246666666666666666666666666666666666666666666666e0 * t178 * t194
  t1269 = 0.22911239050957940668789467477190612503082349661746e1 * t178 * t203
  t1274 = 0.71233333333333333333333333333333333333333333333332e-1 * t148 * t65 * t179 * t316 * t167
  t1279 = 0.68733717152873822006368402431571837509247048985239e1 * t148 * t65 * t302 * t209 * t201
  t1281 = 0.22161481481481481481481481481481481481481481481481e0 * t878 * t182
  t1283 = 0.28493333333333333333333333333333333333333333333334e0 * t178 * t169
  t1288 = 0.42740000000000000000000000000000000000000000000000e0 * t148 * t65 * t198 * t209 * t167
  t1290 = 0.1e1 / t28 / t255
  t1291 = t24 * t1290
  t1295 = -t1256 + t1260 - t1265 + t1267 + t1269 - t1274 + t1279 - t1281 - t1283 - t1288 + 0.18989760778855128828022312575107704239400966910600e-2 * t138 * t1291 * t144
  t1308 = t22 * t64 * t9
  t1312 = 0.34366858576436911003184201215785918754623524492620e1 * t1308 * t33 * t198 * t220
  t1316 = 0.42740000000000000000000000000000000000000000000000e0 * t1308 * t33 * t156 * t215
  t1323 = 0.36000000000000000000000000000000000000000000000000e2 * t208 * t529 * t191
  t1326 = 0.80000000000000000000000000000000000000000000000000e1 * t213 * t214 * t316
  t1329 = 0.57894567559743977356791354411244411566048052491077e3 * t303 * t535 * t191
  t1333 = 0.64327297288604419285323727123604901740053391656752e2 * t208 * t316 * t201 * t161
  t1337 = 0.31035008823423701047887038270048358885233697045812e4 * t322 * t191 * t324 * t162
  t1341 = -0.61523382126046769584908008232272042135015119629847e4 * t225 * t244 * t122 * t247 * t130 + 0.46785787179641632566650740004947596994247102643924e1 * t225 * t238 * t423 - 0.21053604230838734654992833002226418647411196189766e2 * t225 * t131 * t239 - t1312 + t1316 + 0.62336721237753107878820492101102678532040019511357e3 * t225 * t291 * t122 * t562 + t1323 - t1326 - t1329 + t1333 + t1337 + 0.38024868119570572868450088421334803819557955882337e2 * t26 * t70 * t248
  t1364 = t122 ** 2
  t1369 = t130 ** 2
  t1375 = 0.1e1 / t128 / t236
  t1380 = t128 ** 2
  t1381 = 0.1e1 / t1380
  t1383 = t132 ** 2
  t1384 = 0.1e1 / t1383
  t1389 = t20 / r0
  t1395 = t52 ** 2
  t1396 = t492 * t1395
  t1399 = t22 * t24 * t9
  t1400 = 0.1e1 / t39 / t1389 / t257 * t20 * t1396 * t1399 / 0.96e2
  t1402 = 0.1e1 / t490
  t1403 = t1402 * t257
  t1404 = t254 * t1403
  t1406 = t23 * t655
  t1407 = t1406 * t101
  t1408 = t97 * t1407
  t1410 = t1291 * t65
  t1411 = t61 * t1410
  t1413 = t1290 * t9
  t1415 = t25 * t1413 * t33
  t1417 = t38 ** (-0.25e1)
  t1420 = t1417 * t20 * t1396 * t1399
  t1422 = t274 * t1403
  t1424 = t113 * t1407
  t1426 = t75 * t1410
  t1429 = t47 * t656 * t52
  t1431 = -0.57538888888888888888888888888888888888888888888889e1 * t1400 + 0.55237333333333333333333333333333333333333333333334e2 * t1404 - 0.10229135802469135802469135802469135802469135802469e2 * t1408 + 0.89504938271604938271604938271604938271604938271607e1 * t1411 + 0.31310740740740740740740740740740740740740740740741e1 * t1415 + 0.73355000000000000000000000000000000000000000000000e-1 * t1420 - 0.11736800000000000000000000000000000000000000000000e1 * t1422 + 0.65204444444444444444444444444444444444444444444445e0 * t1424 + 0.57053888888888888888888888888888888888888888888890e0 * t1426 + 0.13490888888888888888888888888888888888888888888889e1 * t1429
  t1436 = 0.13012297059337829057599737063876050414024975422841e0 * t26 * t70 * t233 - 0.38527556876111295841770998590264849926052512059102e1 * t26 * t70 * t293 + 0.67471169937307261780146784775653594739388761451767e-1 * t26 * t270 * t90 + 0.86748647062252193717331580425840336093499836152272e-1 * t26 * t34 * t297 - 0.43374323531126096858665790212920168046749918076136e-1 * t26 * t34 * t124 - 0.12842518958703765280590332863421616642017504019700e1 * t26 * t34 * t134 + 0.21687161765563048429332895106460084023374959038068e-1 * t26 * t70 * t287 + 0.35089340384731224424988055003710697745685326982943e1 * t225 * t237 * t1364 * t89 - 0.62336721237753107878820492101102678532040019511358e3 * t225 * t244 * t1369 * t133 + 0.12304676425209353916981601646454408427003023925970e5 * t225 * t1375 * t1369 * t247 - 0.91080982599109921218848830805163797795664001346962e5 * t225 * t1381 * t1369 * t1384 - 0.58482233974552040708313425006184496242808878304903e0 * t225 * t58 * t1431 * t89
  t1443 = t369 ** 2
  t1450 = t373 ** 2
  t1453 = t390 ** 2
  t1454 = t376 ** 2
  t1502 = -0.35089340384731224424988055003710697745685326982943e1 * t382 * t1364 * t89 + 0.51947267698127589899017076750918898776700016259463e2 * t345 * t1364 * t133 - 0.60000000000000000000000000000000000000000000000000e1 * t355 * t1443 * t361 + 0.96494049533612093920874879382438082984882598906400e2 * t375 * t1443 * t377 + 0.19965908856856833623520686708731068173688999255505e6 * t351 / t1450 * t1453 / t1454 - 0.12304676425209353916981601646454408427003023925970e5 * t224 * t1375 * t1369 * t247 + 0.58482233974552040708313425006184496242808878304903e0 * t422 * t1431 * t89 - 0.24000000000000000000000000000000000000000000000000e2 * t389 * t1453 * t361 - 0.14035736153892489769995222001484279098274130793177e2 * t417 * t1369 * t89 + 0.11579285944033451270504985525892569958185911868768e4 * t411 * t1453 * t377 + 0.62336721237753107878820492101102678532040019511358e3 * t432 * t1369 * t133 - 0.24829604254387158294210325990977956380799639474146e5 * t351 / t373 / t353 * t1453 * t413 + 0.99999999999999999999999999999999999999999999999999e0 * t396 * (-0.78438333333333333333333333333333333333333333333333e1 * t1400 + 0.75300800000000000000000000000000000000000000000001e2 * t1404 - 0.13944592592592592592592592592592592592592592592593e2 * t1408 + 0.12201518518518518518518518518518518518518518518519e2 * t1411 + 0.53560370370370370370370370370370370370370370370370e1 * t1415 + 0.28051666666666666666666666666666666666666666666666e0 * t1420 - 0.44882666666666666666666666666666666666666666666666e1 * t1422 + 0.24934814814814814814814814814814814814814814814815e1 * t1424 + 0.21817962962962962962962962962962962962962962962963e1 * t1426 + 0.16979925925925925925925925925925925925925925925926e1 * t1429) * t361 + 0.91080982599109921218848830805163797795664001346962e5 * t224 * t1381 * t1369 * t1384 + t1256 - t1260 + t1265
  t1531 = -t1267 - t1269 + t1274 - t1279 + t1281 + t1283 + t1288 + 0.13218398198777742039240913477002251527822450948858e2 * t148 * t65 * t388 * t391 * t377 + 0.43374323531126096858665790212920168046749918076136e-1 * t178 * t447 - 0.21309037037037037037037037037037037037037037037036e0 * t878 * t455 + t1312 - t1316 - 0.19263778438055647920885499295132424963026256029551e1 * t1308 * t33 * t129 * t347 + 0.41096000000000000000000000000000000000000000000000e0 * t1308 * t33 * t354 * t370 - 0.66091990993888710196204567385011257639112254744288e1 * t1308 * t33 * t374 * t379 + 0.13012297059337829057599737063876050414024975422841e0 * t1308 * t33 * t237 * t384 + 0.36000000000000000000000000000000000000000000000000e2 * t375 * t543 * t369
  t1572 = 0.11483710345679012345679012345679012345679012345679e-1 * t25 * t1413 * t174
  t1573 = -0.62336721237753107878820492101102678532040019511357e3 * t417 * t346 * t130 + 0.69263023597503453198689435667891865035600021679284e2 * t345 * t285 * t133 * t84 + 0.61523382126046769584908008232272042135015119629847e4 * t432 * t122 * t247 * t130 - 0.80000000000000000000000000000000000000000000000000e1 * t355 * t362 * t405 - 0.11579285944033451270504985525892569958185911868768e4 * t389 * t549 * t369 + 0.12865873271148279189449983917658411064651013187520e3 * t375 * t405 * t377 * t360 + 0.12414802127193579147105162995488978190399819737073e5 * t411 * t369 * t413 * t390 - 0.46785787179641632566650740004947596994247102643924e1 * t382 * t383 * t285 + 0.21053604230838734654992833002226418647411196189766e2 * t345 * t557 * t122 - t1323 + t1326 + t1329 - t1333 - t1337 - 0.55208163456790123456790123456790123456790123456787e-2 * t25 * t1413 * t337 - 0.18989760778855128828022312575107704239400966910600e-2 * t25 * t1413 * t341 + t1572
  t1615 = 0.24000000000000000000000000000000000000000000000000e2 * t303 * t1253 * t167
  t1618 = 0.60000000000000000000000000000000000000000000000000e1 * t213 * t1257 * t167
  t1632 = 0.10000000000000000000000000000000000000000000000000e1 * t307 * (-0.42198333333333333333333333333333333333333333333333e1 * t1400 + 0.40510400000000000000000000000000000000000000000000e2 * t1404 - 0.75019259259259259259259259259259259259259259259258e1 * t1408 + 0.65641851851851851851851851851851851851851851851850e1 * t1411 + 0.31003950617283950617283950617283950617283950617285e1 * t1415 + 0.13651666666666666666666666666666666666666666666666e0 * t1420 - 0.21842666666666666666666666666666666666666666666666e1 * t1422 + 0.12134814814814814814814814814814814814814814814815e1 * t1424 + 0.10617962962962962962962962962962962962962962962963e1 * t1426 + 0.13388493827160493827160493827160493827160493827161e1 * t1429) * t167
  t1633 = t197 ** 2
  t1636 = t200 ** 2
  t1640 = 0.24954977986735470914321699422701391789612506067521e5 * t207 / t1633 * t1253 / t1636
  t1643 = 0.57894567559743977356791354411244411566048052491077e3 * t322 * t1253 * t201
  t1644 = -0.14172186339420759128595382735072640214240860886520e3 * t148 * t65 * t410 * t391 * t413 - 0.67471169937307261780146784775653594739388761451767e-1 * t878 * t444 - 0.38024868119570572868450088421334803819557955882337e2 * t148 * t65 * t248 + 0.13698666666666666666666666666666666666666666666666e0 * t178 * t460 + 0.44061327329259140130803044923340838426074836496192e1 * t178 * t465 - 0.68493333333333333333333333333333333333333333333332e-1 * t148 * t65 * t395 * t405 * t361 - 0.86748647062252193717331580425840336093499836152272e-1 * t178 * t436 - 0.13012297059337829057599737063876050414024975422841e0 * t148 * t65 * t233 - 0.27397333333333333333333333333333333333333333333333e0 * t178 * t441 - 0.41096000000000000000000000000000000000000000000000e0 * t148 * t65 * t374 * t391 * t361 + 0.12842518958703765280590332863421616642017504019700e1 * t178 * t450 - 0.21687161765563048429332895106460084023374959038068e-1 * t148 * t65 * t287 + 0.38527556876111295841770998590264849926052512059102e1 * t148 * t65 * t293 + t1615 + t1618 - t1632 - t1640 - t1643
  t1653 = t18 * t19 * t818
  t1670 = t18 * (t1502 + t1531 + t1573 + t1644) - 0.69263023597503453198689435667891865035600021679284e2 * t225 * t129 * t285 * t227 - t1572 - 0.13012297059337829057599737063876050414024975422841e0 * t1653 * t65 * t237 * t384 + 0.19263778438055647920885499295132424963026256029551e1 * t1653 * t65 * t129 * t347 + 0.14035736153892489769995222001484279098274130793177e2 * t225 * t291 * t1369 * t89 - 0.51947267698127589899017076750918898776700016259463e2 * t225 * t129 * t1364 * t133 - t1615 - t1618 + t1632 + t1640 + t1643
  t1675 = f.my_piecewise3(t4, 0, t5 * (t1295 + t1341 + t1436 + t1670) / 0.2e1)
  t1686 = t9 / t28 / t597
  t1687 = t1686 * t495
  t1691 = 0.1e1 / t48 / t616
  t1693 = t50 * t1691 * t517
  t1698 = t50 / t48 / t587
  t1702 = 0.1e1 / t677
  t1703 = t1702 * t505
  t1710 = 0.1e1 / t28 / t702 / r0
  t1712 = t1710 * t621 * t9
  t1718 = 0.1e1 / t48 / t702 / t587
  t1720 = t1718 * t788 * t50
  t1727 = t510 ** 2
  t1731 = 0.1e1 / t28 / t702 / t597
  t1732 = t516 ** 2
  t1755 = 0.1e1 / t702 / t255
  t1756 = t1755 * t706
  t1763 = 0.16513580246913580246913580246913580246913580246913e3 * t489 * t1687 + 0.13787338271604938271604938271604938271604938271605e3 * t511 * t1693 + 0.51713580246913580246913580246913580246913580246912e2 * t478 * t1698 * t483 + 0.253440e3 * t501 * t1703 - 0.26155614814814814814814814814814814814814814814815e3 * t604 * t1693 + 0.19503028148148148148148148148148148148148148148148e3 * t688 * t1712 + 0.37282702222222222222222222222222222222222222222224e1 * t499 * t782 * t1720 - 0.26951680000000000000000000000000000000000000000000e3 * t615 * t1712 - 0.30136850962962962962962962962962962962962962962965e2 * t783 * t1720 + 0.34797188740740740740740740740740740740740740740745e1 * t509 * t1727 * t1731 / t1732 * t9 - 0.14445037037037037037037037037037037037037037037037e3 * t586 * t1687 - 0.23787140740740740740740740740740740740740740740743e2 * t743 * t1693 + 0.31068918518518518518518518518518518518518518518521e1 * t477 * t614 * t1712 + 0.14912474074074074074074074074074074074074074074074e3 * t676 * t1693 - 0.50486992592592592592592592592592592592592592592595e2 * t757 * t1712 + 0.12960553086419753086419753086419753086419753086421e3 * t667 * t1703 - 0.37477135802469135802469135802469135802469135802470e3 * t596 * t1703 + 0.62137837037037037037037037037037037037037037037042e1 * t487 * t700 * t1756 - 0.62914560000000000000000000000000000000000000000004e2 * t770 * t1756 + 0.19293474765432098765432098765432098765432098765434e3 * t701 * t1756
  t1787 = t905 ** 2
  t1790 = t936 ** 2
  t1791 = t925 ** 2
  t1796 = t921 ** 2
  t1805 = 0.1e1 / t803 / t1389 * t20 * t492 * t25 / 0.48e2
  t1807 = t865 * t1402
  t1809 = t871 * t655
  t1810 = t870 * t1809
  t1812 = t817 * t1290
  t1813 = t816 * t1812
  t1815 = t22 * t1291
  t1817 = t802 ** (-0.25e1)
  t1820 = t1817 * t20 * t492 * t25
  t1822 = t881 * t1402
  t1824 = t885 * t1809
  t1826 = t823 * t1812
  t1828 = t46 * t1406
  t1840 = -0.2e1 * t1675 + 0.31035008823423701047887038270048358885233697045812e4 * t989 * t921 * t991 * t936 + 0.36000000000000000000000000000000000000000000000000e2 * t907 * t1015 * t921 - 0.11483710345679012345679012345679012345679012345679e-1 * t22 * t1291 * t1026 - 0.80000000000000000000000000000000000000000000000000e1 * t944 * t945 * t1010 - 0.57894567559743977356791354411244411566048052491077e3 * t997 * t927 * t936 + 0.64327297288604419285323727123604901740053391656752e2 * t907 * t1010 * t926 * t932 + 0.24954977986735470914321699422701391789612506067521e5 * t898 / t1787 * t1790 / t1791 + 0.48245472966453314463992795342703676305040043742564e2 * t907 * t1796 * t926 + 0.10000000000000000000000000000000000000000000000000e1 * t1001 * (-0.21099166666666666666666666666666666666666666666667e1 * t1805 + 0.20255200000000000000000000000000000000000000000000e2 * t1807 - 0.75019259259259259259259259259259259259259259259258e1 * t1810 + 0.65641851851851851851851851851851851851851851851850e1 * t1813 + 0.31003950617283950617283950617283950617283950617285e1 * t1815 + 0.68258333333333333333333333333333333333333333333335e-1 * t1820 - 0.10921333333333333333333333333333333333333333333333e1 * t1822 + 0.12134814814814814814814814814814814814814814814815e1 * t1824 + 0.10617962962962962962962962962962962962962962962963e1 * t1826 + 0.13388493827160493827160493827160493827160493827161e1 * t1828) * t938 - 0.62070017646847402095774076540096717770467394091622e4 * t898 / t905 / t942 * t1790 * t991
  t1844 = t799 * t25
  t1846 = t956 * t857
  t1852 = t829 * t835
  t1886 = 0.57894567559743977356791354411244411566048052491077e3 * t989 * t1790 * t926 + 0.19263778438055647920885499295132424963026256029551e1 * t1844 * t63 * t949 * t1846 * t829 - 0.13012297059337829057599737063876050414024975422841e0 * t1844 * t63 * t814 * t1852 * t956 - 0.43374323531126096858665790212920168046749918076136e-1 * t800 * t105 * t1036 - 0.12842518958703765280590332863421616642017504019700e1 * t800 * t105 * t1041 + 0.21687161765563048429332895106460084023374959038068e-1 * t800 * t64 * t894 + 0.67471169937307261780146784775653594739388761451767e-1 * t800 * t142 * t1031 - 0.38527556876111295841770998590264849926052512059102e1 * t800 * t64 * t858 - 0.60000000000000000000000000000000000000000000000000e1 * t944 * t1796 * t938 - 0.24000000000000000000000000000000000000000000000000e2 * t997 * t1790 * t938 + 0.18989760778855128828022312575107704239400966910600e-2 * t1019 * t817 * t1290 * t1020 + 0.22911239050957940668789467477190612503082349661746e1 * t25 * t30 * t906 * t972
  t1933 = 0.68733717152873822006368402431571837509247048985239e1 * t25 * t63 * t996 * t998 - 0.22161481481481481481481481481481481481481481481481e0 * t25 * t141 * t977 * t945 - 0.28493333333333333333333333333333333333333333333334e0 * t25 * t30 * t943 * t1015 - 0.69263023597503453198689435667891865035600021679284e2 * t842 * t949 * t892 * t958 - 0.61523382126046769584908008232272042135015119629847e4 * t842 * t845 * t830 * t850 * t956 + 0.62336721237753107878820492101102678532040019511357e3 * t842 * t855 * t830 * t1846 + 0.46785787179641632566650740004947596994247102643924e1 * t842 * t814 * t892 * t1852 - 0.36845452142031360632963667101718523854302450326054e2 * t25 * t63 * t988 * t992 + 0.14246666666666666666666666666666666666666666666666e0 * t25 * t978 * t983 - 0.71233333333333333333333333333333333333333333333332e-1 * t25 * t982 * t1011 - 0.21053604230838734654992833002226418647411196189766e2 * t842 * t1040 * t967 - 0.42740000000000000000000000000000000000000000000000e0 * t25 * t971 * t939
  t1949 = t843 ** 2
  t1951 = t830 ** 2
  t1953 = t848 ** 2
  t1968 = t956 ** 2
  t1999 = -0.58482233974552040708313425006184496242808878304903e0 * t842 * t861 * (-0.28769444444444444444444444444444444444444444444444e1 * t1805 + 0.27618666666666666666666666666666666666666666666667e2 * t1807 - 0.10229135802469135802469135802469135802469135802469e2 * t1810 + 0.89504938271604938271604938271604938271604938271607e1 * t1813 + 0.31310740740740740740740740740740740740740740740741e1 * t1815 + 0.36677500000000000000000000000000000000000000000000e-1 * t1820 - 0.58684000000000000000000000000000000000000000000000e0 * t1822 + 0.65204444444444444444444444444444444444444444444445e0 * t1824 + 0.57053888888888888888888888888888888888888888888890e0 * t1826 + 0.13490888888888888888888888888888888888888888888889e1 * t1828) * t835 - 0.91080982599109921218848830805163797795664001346962e5 * t842 / t1949 * t1951 / t1953 + 0.12304676425209353916981601646454408427003023925970e5 * t842 / t843 / t813 * t1951 * t850 - 0.62336721237753107878820492101102678532040019511358e3 * t842 * t845 * t1951 * t857 + 0.35089340384731224424988055003710697745685326982943e1 * t842 * t814 * t1968 * t835 - 0.51947267698127589899017076750918898776700016259463e2 * t842 * t949 * t1968 * t857 + 0.14035736153892489769995222001484279098274130793177e2 * t842 * t855 * t1951 * t835 + 0.38024868119570572868450088421334803819557955882337e2 * t800 * t64 * t851 + 0.86748647062252193717331580425840336093499836152272e-1 * t800 * t105 * t836 + 0.13012297059337829057599737063876050414024975422841e0 * t800 * t64 * t963 + 0.42740000000000000000000000000000000000000000000000e0 * t148 * t943 * t932 * t983 - 0.34366858576436911003184201215785918754623524492620e1 * t148 * t906 * t921 * t926 * t932
  t2009 = t1702 * t1066
  t2015 = t1755 * t1185
  t2024 = t1718 * t1242 * t50
  t2028 = t9 * t1710 * t1131
  t2034 = t1072 ** 2
  t2040 = t1686 * t1059
  t2044 = t1691 * t1073 * t50
  t2067 = 0.34993493333333333333333333333333333333333333333333e-2 * t1157 * t2009 - 0.10118826666666666666666666666666666666666666666667e-1 * t1116 * t2009 + 0.45298483200000000000000000000000000000000000000000e-8 * t1056 * t700 * t2015 - 0.45864714240000000000000000000000000000000000000000e-7 * t1230 * t2015 + 0.14064943104000000000000000000000000000000000000000e-6 * t1183 * t2015 + 0.81537269760000000000000000000000000000000000000000e-10 * t1063 * t782 * t2024 - 0.65492582400000000000000000000000000000000000000000e-5 * t1129 * t2028 - 0.65909293056000000000000000000000000000000000000000e-9 * t1240 * t2024 + 0.22830435532800000000000000000000000000000000000000e-11 * t1070 * t1727 * t1731 / t2034 * t9 - 0.13000533333333333333333333333333333333333333333333e0 * t1110 * t2040 - 0.19267584000000000000000000000000000000000000000000e-4 * t1208 * t2044 + 0.75497472000000000000000000000000000000000000000000e-7 * t1048 * t614 * t2028 + 0.12079104000000000000000000000000000000000000000000e-3 * t1165 * t2044 - 0.12268339200000000000000000000000000000000000000000e-5 * t1219 * t2028 + 0.6842880e-2 * t1064 * t2009 - 0.21186048000000000000000000000000000000000000000000e-3 * t1122 * t2044 + 0.47392358400000000000000000000000000000000000000000e-5 * t1174 * t2028 + 0.15514074074074074074074074074074074074074074074074e1 * t1049 * t1698 * t1052 + 0.14862222222222222222222222222222222222222222222222e0 * t1057 * t2040 + 0.11167744000000000000000000000000000000000000000000e-3 * t1071 * t2044
  v4rho4_0_ = 0.8e1 * t475 * t521 + 0.24e2 * t582 * t625 + 0.24e2 * t653 * t710 + 0.8e1 * t726 * t793 + 0.4e1 * t1046 * t1077 + 0.12e2 * t1106 * t1135 + 0.12e2 * t1150 * t1189 + 0.4e1 * t1198 * t1247 + r0 * (0.2e1 * t1675 * t521 + 0.8e1 * t475 * t625 + 0.12e2 * t582 * t710 + 0.8e1 * t653 * t793 + 0.2e1 * t726 * t1763 + (t1840 + t1886 + t1933 + t1999) * t1077 + 0.4e1 * t1046 * t1135 + 0.6e1 * t1106 * t1189 + 0.4e1 * t1150 * t1247 + t1198 * t2067)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = t3 ** 2
  t10 = 0.1e1 / t9
  t11 = t2 * t10
  t12 = t4 - t11
  t13 = f.my_piecewise3(t7, 0, t12)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t16 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = t3 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t22 * t23
  t25 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t29 = f.my_piecewise3(t7, t26, 0.1e1 / t27)
  t31 = t20 * t24 * t29
  t33 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t31
  t34 = jnp.sqrt(t31)
  t37 = t31 ** 0.15e1
  t39 = t14 ** 2
  t40 = t16 ** 2
  t41 = t39 * t40
  t42 = t41 * t18
  t43 = t21 ** 2
  t44 = 0.1e1 / t43
  t45 = t23 ** 2
  t46 = t44 * t45
  t47 = t29 ** 2
  t49 = t42 * t46 * t47
  t51 = 0.37978500000000000000000000000000000000000000000000e1 * t34 + 0.89690000000000000000000000000000000000000000000000e0 * t31 + 0.20477500000000000000000000000000000000000000000000e0 * t37 + 0.12323500000000000000000000000000000000000000000000e0 * t49
  t54 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t51
  t55 = jnp.log(t54)
  t57 = 0.62182e-1 * t33 * t55
  t59 = t25 * f.p.zeta_threshold
  t61 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t59, 0.2e1 * t23)
  t63 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t59, 0)
  t67 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t68 = (t61 + t63 - 0.2e1) * t67
  t70 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t31
  t75 = 0.70594500000000000000000000000000000000000000000000e1 * t34 + 0.15494250000000000000000000000000000000000000000000e1 * t31 + 0.42077500000000000000000000000000000000000000000000e0 * t37 + 0.15629250000000000000000000000000000000000000000000e0 * t49
  t78 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t75
  t79 = jnp.log(t78)
  t83 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t31
  t88 = 0.51785000000000000000000000000000000000000000000000e1 * t34 + 0.90577500000000000000000000000000000000000000000000e0 * t31 + 0.11003250000000000000000000000000000000000000000000e0 * t37 + 0.12417750000000000000000000000000000000000000000000e0 * t49
  t91 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t88
  t92 = jnp.log(t91)
  t93 = t83 * t92
  t99 = -t57 + t68 * (-0.31090e-1 * t70 * t79 + t57 - 0.19751789702565206228825776161588751761046270558698e-1 * t93) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t93
  t101 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t103 = 0.1e1 / t21 / t3
  t104 = t103 * t23
  t106 = t20 * t104 * t29
  t107 = 0.17808333333333333333333333333333333333333333333333e-1 * t106
  t108 = t27 * t6
  t109 = 0.1e1 / t108
  t112 = f.my_piecewise3(t7, 0, -t109 * t12 / 0.3e1)
  t114 = t20 * t24 * t112
  t116 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t114
  t118 = 0.62182e-1 * t116 * t55
  t119 = t51 ** 2
  t120 = 0.1e1 / t119
  t121 = t33 * t120
  t122 = 0.1e1 / t34
  t123 = t106 / 0.3e1
  t124 = -t123 + t114
  t125 = t122 * t124
  t127 = 0.29896666666666666666666666666666666666666666666667e0 * t106
  t129 = t31 ** 0.5e0
  t130 = t129 * t124
  t133 = 0.1e1 / t43 / t3
  t134 = t133 * t45
  t136 = t42 * t134 * t47
  t137 = 0.82156666666666666666666666666666666666666666666667e-1 * t136
  t138 = t29 * t112
  t140 = t42 * t46 * t138
  t142 = 0.18989250000000000000000000000000000000000000000000e1 * t125 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t114 + 0.30716250000000000000000000000000000000000000000000e0 * t130 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t140
  t143 = 0.1e1 / t54
  t144 = t142 * t143
  t146 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t144
  t147 = 0.17123333333333333333333333333333333333333333333333e-1 * t106
  t149 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t114
  t152 = t75 ** 2
  t153 = 0.1e1 / t152
  t154 = t70 * t153
  t156 = 0.51647500000000000000000000000000000000000000000000e0 * t106
  t159 = 0.10419500000000000000000000000000000000000000000000e0 * t136
  t161 = 0.35297250000000000000000000000000000000000000000000e1 * t125 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t114 + 0.63116250000000000000000000000000000000000000000000e0 * t130 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t140
  t162 = 0.1e1 / t78
  t163 = t161 * t162
  t166 = 0.92708333333333333333333333333333333333333333333333e-2 * t106
  t168 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t114
  t169 = t168 * t92
  t171 = t88 ** 2
  t172 = 0.1e1 / t171
  t173 = t83 * t172
  t175 = 0.30192500000000000000000000000000000000000000000000e0 * t106
  t178 = 0.82785000000000000000000000000000000000000000000000e-1 * t136
  t180 = 0.25892500000000000000000000000000000000000000000000e1 * t125 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t114 + 0.16504875000000000000000000000000000000000000000000e0 * t130 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t140
  t181 = 0.1e1 / t91
  t182 = t180 * t181
  t189 = t68 * t83
  t191 = t172 * t180 * t181
  t194 = -t118 + t146 + t68 * (-0.31090e-1 * t149 * t79 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t163 + t118 - t146 - 0.19751789702565206228825776161588751761046270558698e-1 * t169 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t182) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t169 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t191
  t198 = f.my_piecewise3(t8, 0, t101 * t194 / 0.2e1 + t13 * t99 / 0.2e1)
  t199 = params.c_ss[0]
  t200 = params.c_ss[1]
  t201 = t200 * s0
  t202 = r0 ** 2
  t203 = r0 ** (0.1e1 / 0.3e1)
  t204 = t203 ** 2
  t206 = 0.1e1 / t204 / t202
  t207 = s0 * t206
  t209 = 0.1e1 + 0.2e0 * t207
  t210 = 0.1e1 / t209
  t214 = params.c_ss[2]
  t215 = s0 ** 2
  t216 = t214 * t215
  t217 = t202 ** 2
  t221 = t209 ** 2
  t222 = 0.1e1 / t221
  t226 = params.c_ss[3]
  t227 = t215 * s0
  t228 = t226 * t227
  t229 = t217 ** 2
  t232 = 0.1e1 / t221 / t209
  t236 = params.c_ss[4]
  t237 = t215 ** 2
  t238 = t236 * t237
  t239 = t229 * t202
  t242 = t221 ** 2
  t243 = 0.1e1 / t242
  t247 = t199 + 0.2e0 * t201 * t206 * t210 + 0.4e-1 * t216 / t203 / t217 / r0 * t222 + 0.8e-2 * t228 / t229 * t232 + 0.16e-2 * t238 / t204 / t239 * t243
  t248 = t198 * t247
  t252 = f.my_piecewise3(t8, 0, t101 * t99 / 0.2e1)
  t253 = t202 * r0
  t255 = 0.1e1 / t204 / t253
  t259 = t200 * t215
  t260 = t217 * t202
  t263 = 0.1e1 / t203 / t260 * t222
  t268 = t214 * t227
  t271 = 0.1e1 / t229 / r0 * t232
  t276 = t226 * t237
  t280 = 0.1e1 / t204 / t229 / t253 * t243
  t285 = t237 * s0
  t286 = t236 * t285
  t291 = 0.1e1 / t242 / t209
  t295 = -0.53333333333333333333333333333333333333333333333333e0 * t201 * t255 * t210 + 0.10666666666666666666666666666666666666666666666667e0 * t259 * t263 - 0.21333333333333333333333333333333333333333333333333e0 * t216 * t263 + 0.42666666666666666666666666666666666666666666666668e-1 * t268 * t271 - 0.64e-1 * t228 * t271 + 0.12800000000000000000000000000000000000000000000000e-1 * t276 * t280 - 0.17066666666666666666666666666666666666666666666667e-1 * t238 * t280 + 0.34133333333333333333333333333333333333333333333333e-2 * t286 / t203 / t229 / t260 * t291
  t296 = t252 * t295
  t299 = 0.1e1 - t5
  t300 = t299 <= f.p.zeta_threshold
  t301 = r1 <= f.p.dens_threshold or t300
  t302 = -t12
  t303 = f.my_piecewise3(t300, 0, t302)
  t304 = t299 ** (0.1e1 / 0.3e1)
  t306 = f.my_piecewise3(t300, t26, 0.1e1 / t304)
  t308 = t20 * t24 * t306
  t310 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t308
  t311 = jnp.sqrt(t308)
  t314 = t308 ** 0.15e1
  t316 = t306 ** 2
  t318 = t42 * t46 * t316
  t320 = 0.37978500000000000000000000000000000000000000000000e1 * t311 + 0.89690000000000000000000000000000000000000000000000e0 * t308 + 0.20477500000000000000000000000000000000000000000000e0 * t314 + 0.12323500000000000000000000000000000000000000000000e0 * t318
  t323 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t320
  t324 = jnp.log(t323)
  t326 = 0.62182e-1 * t310 * t324
  t328 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t308
  t333 = 0.70594500000000000000000000000000000000000000000000e1 * t311 + 0.15494250000000000000000000000000000000000000000000e1 * t308 + 0.42077500000000000000000000000000000000000000000000e0 * t314 + 0.15629250000000000000000000000000000000000000000000e0 * t318
  t336 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t333
  t337 = jnp.log(t336)
  t341 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t308
  t346 = 0.51785000000000000000000000000000000000000000000000e1 * t311 + 0.90577500000000000000000000000000000000000000000000e0 * t308 + 0.11003250000000000000000000000000000000000000000000e0 * t314 + 0.12417750000000000000000000000000000000000000000000e0 * t318
  t349 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t346
  t350 = jnp.log(t349)
  t351 = t341 * t350
  t357 = -t326 + t68 * (-0.31090e-1 * t328 * t337 + t326 - 0.19751789702565206228825776161588751761046270558698e-1 * t351) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t351
  t359 = f.my_piecewise3(t300, f.p.zeta_threshold, t299)
  t361 = t20 * t104 * t306
  t362 = 0.17808333333333333333333333333333333333333333333333e-1 * t361
  t363 = t304 * t299
  t364 = 0.1e1 / t363
  t367 = f.my_piecewise3(t300, 0, -t364 * t302 / 0.3e1)
  t369 = t20 * t24 * t367
  t371 = -t362 + 0.53425000000000000000000000000000000000000000000000e-1 * t369
  t373 = 0.62182e-1 * t371 * t324
  t374 = t320 ** 2
  t375 = 0.1e1 / t374
  t376 = t310 * t375
  t377 = 0.1e1 / t311
  t378 = t361 / 0.3e1
  t379 = -t378 + t369
  t380 = t377 * t379
  t382 = 0.29896666666666666666666666666666666666666666666667e0 * t361
  t384 = t308 ** 0.5e0
  t385 = t384 * t379
  t388 = t42 * t134 * t316
  t389 = 0.82156666666666666666666666666666666666666666666667e-1 * t388
  t390 = t306 * t367
  t392 = t42 * t46 * t390
  t394 = 0.18989250000000000000000000000000000000000000000000e1 * t380 - t382 + 0.89690000000000000000000000000000000000000000000000e0 * t369 + 0.30716250000000000000000000000000000000000000000000e0 * t385 - t389 + 0.24647000000000000000000000000000000000000000000000e0 * t392
  t395 = 0.1e1 / t323
  t396 = t394 * t395
  t398 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t396
  t399 = 0.17123333333333333333333333333333333333333333333333e-1 * t361
  t401 = -t399 + 0.51370000000000000000000000000000000000000000000000e-1 * t369
  t404 = t333 ** 2
  t405 = 0.1e1 / t404
  t406 = t328 * t405
  t408 = 0.51647500000000000000000000000000000000000000000000e0 * t361
  t411 = 0.10419500000000000000000000000000000000000000000000e0 * t388
  t413 = 0.35297250000000000000000000000000000000000000000000e1 * t380 - t408 + 0.15494250000000000000000000000000000000000000000000e1 * t369 + 0.63116250000000000000000000000000000000000000000000e0 * t385 - t411 + 0.31258500000000000000000000000000000000000000000000e0 * t392
  t414 = 0.1e1 / t336
  t415 = t413 * t414
  t418 = 0.92708333333333333333333333333333333333333333333333e-2 * t361
  t420 = -t418 + 0.27812500000000000000000000000000000000000000000000e-1 * t369
  t421 = t420 * t350
  t423 = t346 ** 2
  t424 = 0.1e1 / t423
  t425 = t341 * t424
  t427 = 0.30192500000000000000000000000000000000000000000000e0 * t361
  t430 = 0.82785000000000000000000000000000000000000000000000e-1 * t388
  t432 = 0.25892500000000000000000000000000000000000000000000e1 * t380 - t427 + 0.90577500000000000000000000000000000000000000000000e0 * t369 + 0.16504875000000000000000000000000000000000000000000e0 * t385 - t430 + 0.24835500000000000000000000000000000000000000000000e0 * t392
  t433 = 0.1e1 / t349
  t434 = t432 * t433
  t441 = t68 * t341
  t443 = t424 * t432 * t433
  t446 = -t373 + t398 + t68 * (-0.31090e-1 * t401 * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t415 + t373 - t398 - 0.19751789702565206228825776161588751761046270558698e-1 * t421 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t434) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t421 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t443
  t450 = f.my_piecewise3(t301, 0, t303 * t357 / 0.2e1 + t359 * t446 / 0.2e1)
  t451 = t200 * s2
  t452 = r1 ** 2
  t453 = r1 ** (0.1e1 / 0.3e1)
  t454 = t453 ** 2
  t456 = 0.1e1 / t454 / t452
  t457 = s2 * t456
  t459 = 0.1e1 + 0.2e0 * t457
  t460 = 0.1e1 / t459
  t464 = s2 ** 2
  t465 = t214 * t464
  t466 = t452 ** 2
  t470 = t459 ** 2
  t471 = 0.1e1 / t470
  t475 = t464 * s2
  t476 = t226 * t475
  t477 = t466 ** 2
  t480 = 0.1e1 / t470 / t459
  t484 = t464 ** 2
  t485 = t236 * t484
  t486 = t477 * t452
  t489 = t470 ** 2
  t490 = 0.1e1 / t489
  t494 = t199 + 0.2e0 * t451 * t456 * t460 + 0.4e-1 * t465 / t453 / t466 / r1 * t471 + 0.8e-2 * t476 / t477 * t480 + 0.16e-2 * t485 / t454 / t486 * t490
  t495 = t450 * t494
  t497 = t19 * t103
  t499 = t17 * t19 * t22
  t500 = jnp.sqrt(t499)
  t503 = t499 ** 0.15e1
  t506 = t41 * t18 * t44
  t508 = 0.37978500000000000000000000000000000000000000000000e1 * t500 + 0.89690000000000000000000000000000000000000000000000e0 * t499 + 0.20477500000000000000000000000000000000000000000000e0 * t503 + 0.12323500000000000000000000000000000000000000000000e0 * t506
  t511 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t508
  t512 = jnp.log(t511)
  t515 = 0.11073577833333333333333333333333333333333333333333e-2 * t17 * t497 * t512
  t517 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t499
  t518 = t508 ** 2
  t519 = 0.1e1 / t518
  t520 = t517 * t519
  t522 = 0.1e1 / t500 * t14
  t523 = t16 * t19
  t524 = t523 * t103
  t525 = t522 * t524
  t527 = t17 * t497
  t529 = t499 ** 0.5e0
  t530 = t529 * t14
  t531 = t530 * t524
  t534 = t41 * t18 * t133
  t536 = -0.63297500000000000000000000000000000000000000000000e0 * t525 - 0.29896666666666666666666666666666666666666666666667e0 * t527 - 0.10238750000000000000000000000000000000000000000000e0 * t531 - 0.82156666666666666666666666666666666666666666666667e-1 * t534
  t537 = 0.1e1 / t511
  t538 = t536 * t537
  t540 = 0.10000000000000000000000000000000000000000000000000e1 * t520 * t538
  t541 = t2 ** 2
  t542 = t541 * t2
  t543 = t9 ** 2
  t544 = 0.1e1 / t543
  t545 = t542 * t544
  t546 = f.my_piecewise3(t7, t59, t108)
  t547 = f.my_piecewise3(t300, t59, t363)
  t549 = (t546 + t547 - 0.2e1) * t67
  t551 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t499
  t556 = 0.70594500000000000000000000000000000000000000000000e1 * t500 + 0.15494250000000000000000000000000000000000000000000e1 * t499 + 0.42077500000000000000000000000000000000000000000000e0 * t503 + 0.15629250000000000000000000000000000000000000000000e0 * t506
  t559 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t556
  t560 = jnp.log(t559)
  t564 = 0.62182e-1 * t517 * t512
  t566 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t499
  t571 = 0.51785000000000000000000000000000000000000000000000e1 * t500 + 0.90577500000000000000000000000000000000000000000000e0 * t499 + 0.11003250000000000000000000000000000000000000000000e0 * t503 + 0.12417750000000000000000000000000000000000000000000e0 * t506
  t574 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t571
  t575 = jnp.log(t574)
  t576 = t566 * t575
  t578 = -0.31090e-1 * t551 * t560 + t564 - 0.19751789702565206228825776161588751761046270558698e-1 * t576
  t579 = t549 * t578
  t581 = 0.4e1 * t545 * t579
  t582 = t541 ** 2
  t584 = 0.1e1 / t543 / t3
  t585 = t582 * t584
  t587 = 0.4e1 * t585 * t579
  t588 = t582 * t544
  t591 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t12)
  t594 = f.my_piecewise3(t300, 0, 0.4e1 / 0.3e1 * t304 * t302)
  t596 = (t591 + t594) * t67
  t597 = t596 * t578
  t602 = t556 ** 2
  t603 = 0.1e1 / t602
  t604 = t551 * t603
  t609 = -0.11765750000000000000000000000000000000000000000000e1 * t525 - 0.51647500000000000000000000000000000000000000000000e0 * t527 - 0.21038750000000000000000000000000000000000000000000e0 * t531 - 0.10419500000000000000000000000000000000000000000000e0 * t534
  t610 = 0.1e1 / t559
  t611 = t609 * t610
  t617 = t571 ** 2
  t618 = 0.1e1 / t617
  t619 = t566 * t618
  t624 = -0.86308333333333333333333333333333333333333333333334e0 * t525 - 0.30192500000000000000000000000000000000000000000000e0 * t527 - 0.55016250000000000000000000000000000000000000000000e-1 * t531 - 0.82785000000000000000000000000000000000000000000000e-1 * t534
  t625 = 0.1e1 / t574
  t626 = t624 * t625
  t629 = 0.53236443333333333333333333333333333333333333333332e-3 * t17 * t497 * t560 + 0.99999999999999999999999999999999999999999999999999e0 * t604 * t611 - t515 - t540 + 0.18311555036753159941307229983139571945136646663793e-3 * t17 * t497 * t575 + 0.58482233974552040708313425006184496242808878304903e0 * t619 * t626
  t630 = t549 * t629
  t631 = t588 * t630
  t634 = t549 * t14
  t636 = t523 * t103 * t575
  t638 = 0.18311555036753159941307229983139571945136646663793e-3 * t634 * t636
  t639 = t549 * t566
  t641 = t618 * t624 * t625
  t643 = 0.58482233974552040708313425006184496242808878304903e0 * t639 * t641
  t644 = t515 + t540 + t581 - t587 + t588 * t597 + t631 + 0.19751789702565206228825776161588751761046270558698e-1 * t596 * t576 - t638 - t643 - t198 - t450
  t646 = params.c_ab[1]
  t647 = t207 + t457
  t648 = t646 * t647
  t651 = 0.1e1 + 0.30000000000000000000000000000000000000000000000000e-2 * t207 + 0.30000000000000000000000000000000000000000000000000e-2 * t457
  t652 = 0.1e1 / t651
  t655 = params.c_ab[2]
  t656 = t647 ** 2
  t657 = t655 * t656
  t658 = t651 ** 2
  t659 = 0.1e1 / t658
  t662 = params.c_ab[3]
  t663 = t656 * t647
  t664 = t662 * t663
  t666 = 0.1e1 / t658 / t651
  t669 = params.c_ab[4]
  t670 = t656 ** 2
  t671 = t669 * t670
  t672 = t658 ** 2
  t673 = 0.1e1 / t672
  t676 = params.c_ab[0] + 0.30000000000000000000000000000000000000000000000000e-2 * t648 * t652 + 0.90000000000000000000000000000000000000000000000000e-5 * t657 * t659 + 0.27000000000000000000000000000000000000000000000000e-7 * t664 * t666 + 0.81000000000000000000000000000000000000000000000000e-10 * t671 * t673
  t677 = t644 * t676
  t684 = f.my_piecewise3(t301, 0, t359 * t357 / 0.2e1)
  t685 = -t564 + t588 * t579 + 0.19751789702565206228825776161588751761046270558698e-1 * t549 * t576 - t252 - t684
  t686 = t646 * s0
  t690 = t659 * s0
  t691 = t690 * t255
  t694 = t655 * t647
  t697 = t666 * s0
  t698 = t697 * t255
  t701 = t662 * t656
  t704 = t673 * s0
  t705 = t704 * t255
  t708 = t669 * t663
  t712 = 0.1e1 / t672 / t651
  t713 = t712 * s0
  t717 = -0.80000000000000000000000000000000000000000000000000e-2 * t686 * t255 * t652 + 0.24000000000000000000000000000000000000000000000000e-4 * t648 * t691 - 0.48000000000000000000000000000000000000000000000000e-4 * t694 * t691 + 0.14400000000000000000000000000000000000000000000000e-6 * t657 * t698 - 0.21600000000000000000000000000000000000000000000000e-6 * t701 * t698 + 0.64800000000000000000000000000000000000000000000000e-9 * t664 * t705 - 0.86400000000000000000000000000000000000000000000000e-9 * t708 * t705 + 0.25920000000000000000000000000000000000000000000000e-11 * t671 * t713 * t255
  t718 = t685 * t717
  t721 = 0.1e1 / t9 / t3
  t722 = t2 * t721
  t724 = -0.2e1 * t10 + 0.2e1 * t722
  t725 = f.my_piecewise3(t7, 0, t724)
  t730 = 0.1e1 / t21 / t9
  t731 = t730 * t23
  t733 = t20 * t731 * t29
  t734 = 0.23744444444444444444444444444444444444444444444444e-1 * t733
  t736 = t20 * t104 * t112
  t738 = t6 ** 2
  t740 = 0.1e1 / t27 / t738
  t741 = t12 ** 2
  t747 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t740 * t741 - t109 * t724 / 0.3e1)
  t749 = t20 * t24 * t747
  t753 = 0.62182e-1 * (t734 - 0.35616666666666666666666666666666666666666666666666e-1 * t736 + 0.53425000000000000000000000000000000000000000000000e-1 * t749) * t55
  t754 = t116 * t120
  t756 = 0.20000000000000000000000000000000000000000000000000e1 * t754 * t144
  t759 = t33 / t119 / t51
  t760 = t142 ** 2
  t763 = 0.20000000000000000000000000000000000000000000000000e1 * t759 * t760 * t143
  t765 = 0.1e1 / t34 / t31
  t766 = t124 ** 2
  t767 = t765 * t766
  t769 = 0.4e1 / 0.9e1 * t733
  t771 = t769 - 0.2e1 / 0.3e1 * t736 + t749
  t772 = t122 * t771
  t774 = 0.39862222222222222222222222222222222222222222222223e0 * t733
  t777 = t31 ** (-0.5e0)
  t778 = t777 * t766
  t780 = t129 * t771
  t783 = 0.1e1 / t43 / t9
  t784 = t783 * t45
  t786 = t42 * t784 * t47
  t787 = 0.13692777777777777777777777777777777777777777777778e0 * t786
  t789 = t42 * t134 * t138
  t791 = t112 ** 2
  t793 = t42 * t46 * t791
  t797 = t42 * t46 * t29 * t747
  t799 = -0.94946250000000000000000000000000000000000000000000e0 * t767 + 0.18989250000000000000000000000000000000000000000000e1 * t772 + t774 - 0.59793333333333333333333333333333333333333333333334e0 * t736 + 0.89690000000000000000000000000000000000000000000000e0 * t749 + 0.15358125000000000000000000000000000000000000000000e0 * t778 + 0.30716250000000000000000000000000000000000000000000e0 * t780 + t787 - 0.32862666666666666666666666666666666666666666666666e0 * t789 + 0.24647000000000000000000000000000000000000000000000e0 * t793 + 0.24647000000000000000000000000000000000000000000000e0 * t797
  t802 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t799 * t143
  t803 = t119 ** 2
  t805 = t33 / t803
  t806 = t54 ** 2
  t807 = 0.1e1 / t806
  t810 = 0.16081824322151104821330931780901225435013347914188e2 * t805 * t760 * t807
  t811 = 0.22831111111111111111111111111111111111111111111111e-1 * t733
  t817 = t149 * t153
  t822 = t70 / t152 / t75
  t823 = t161 ** 2
  t829 = 0.68863333333333333333333333333333333333333333333333e0 * t733
  t834 = 0.17365833333333333333333333333333333333333333333333e0 * t786
  t838 = -0.17648625000000000000000000000000000000000000000000e1 * t767 + 0.35297250000000000000000000000000000000000000000000e1 * t772 + t829 - 0.10329500000000000000000000000000000000000000000000e1 * t736 + 0.15494250000000000000000000000000000000000000000000e1 * t749 + 0.31558125000000000000000000000000000000000000000000e0 * t778 + 0.63116250000000000000000000000000000000000000000000e0 * t780 + t834 - 0.41678000000000000000000000000000000000000000000000e0 * t789 + 0.31258500000000000000000000000000000000000000000000e0 * t793 + 0.31258500000000000000000000000000000000000000000000e0 * t797
  t842 = t152 ** 2
  t844 = t70 / t842
  t845 = t78 ** 2
  t846 = 0.1e1 / t845
  t850 = 0.12361111111111111111111111111111111111111111111111e-1 * t733
  t854 = (t850 - 0.18541666666666666666666666666666666666666666666667e-1 * t736 + 0.27812500000000000000000000000000000000000000000000e-1 * t749) * t92
  t856 = t168 * t172
  t860 = 0.1e1 / t171 / t88
  t861 = t83 * t860
  t862 = t180 ** 2
  t868 = 0.40256666666666666666666666666666666666666666666667e0 * t733
  t873 = 0.13797500000000000000000000000000000000000000000000e0 * t786
  t877 = -0.12946250000000000000000000000000000000000000000000e1 * t767 + 0.25892500000000000000000000000000000000000000000000e1 * t772 + t868 - 0.60385000000000000000000000000000000000000000000000e0 * t736 + 0.90577500000000000000000000000000000000000000000000e0 * t749 + 0.82524375000000000000000000000000000000000000000000e-1 * t778 + 0.16504875000000000000000000000000000000000000000000e0 * t780 + t873 - 0.33114000000000000000000000000000000000000000000000e0 * t789 + 0.24835500000000000000000000000000000000000000000000e0 * t793 + 0.24835500000000000000000000000000000000000000000000e0 * t797
  t881 = t171 ** 2
  t882 = 0.1e1 / t881
  t883 = t83 * t882
  t884 = t91 ** 2
  t885 = 0.1e1 / t884
  t889 = -0.31090e-1 * (t811 - 0.34246666666666666666666666666666666666666666666666e-1 * t736 + 0.51370000000000000000000000000000000000000000000000e-1 * t749) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t817 * t163 - 0.20000000000000000000000000000000000000000000000000e1 * t822 * t823 * t162 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t838 * t162 + 0.32164683177870697973624959794146027661627532968800e2 * t844 * t823 * t846 + t753 - t756 + t763 - t802 - t810 - 0.19751789702565206228825776161588751761046270558698e-1 * t854 + 0.11696446794910408141662685001236899248561775660981e1 * t856 * t182 - 0.11696446794910408141662685001236899248561775660981e1 * t861 * t862 * t181 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t877 * t181 + 0.17315755899375863299672358916972966258900005419821e2 * t883 * t862 * t885
  t893 = t68 * t168
  t908 = -t753 + t756 - t763 + t802 + t810 + t68 * t889 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t854 - 0.11696446794910408141662685001236899248561775660981e1 * t893 * t191 + 0.11696446794910408141662685001236899248561775660981e1 * t189 * t860 * t862 * t181 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t172 * t877 * t181 - 0.17315755899375863299672358916972966258900005419821e2 * t189 * t882 * t862 * t885
  t912 = f.my_piecewise3(t8, 0, t725 * t99 / 0.2e1 + t13 * t194 + t101 * t908 / 0.2e1)
  t917 = 0.1e1 / t204 / t217
  t921 = t217 * t253
  t923 = 0.1e1 / t203 / t921
  t924 = t923 * t222
  t929 = 0.1e1 / t239 * t232
  t940 = 0.1e1 / t204 / t229 / t217 * t243
  t951 = 0.1e1 / t203 / t229 / t921 * t291
  t960 = t229 ** 2
  t968 = 0.19555555555555555555555555555555555555555555555555e1 * t201 * t917 * t210 - 0.96000000000000000000000000000000000000000000000002e0 * t259 * t924 + 0.11377777777777777777777777777777777777777777777778e0 * t200 * t227 * t929 + 0.13511111111111111111111111111111111111111111111111e1 * t216 * t924 - 0.61155555555555555555555555555555555555555555555557e0 * t268 * t929 + 0.68266666666666666666666666666666666666666666666669e-1 * t214 * t237 * t940 + 0.576e0 * t228 * t929 - 0.25173333333333333333333333333333333333333333333333e0 * t276 * t940 + 0.27306666666666666666666666666666666666666666666666e-1 * t226 * t285 * t951 + 0.19911111111111111111111111111111111111111111111112e0 * t238 * t940 - 0.85333333333333333333333333333333333333333333333333e-1 * t286 * t951 + 0.91022222222222222222222222222222222222222222222219e-2 * t236 * t237 * t215 / t960 / t202 / t242 / t221
  t970 = -t724
  t971 = f.my_piecewise3(t300, 0, t970)
  t976 = t20 * t731 * t306
  t977 = 0.23744444444444444444444444444444444444444444444444e-1 * t976
  t979 = t20 * t104 * t367
  t981 = t299 ** 2
  t983 = 0.1e1 / t304 / t981
  t984 = t302 ** 2
  t990 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t983 * t984 - t364 * t970 / 0.3e1)
  t992 = t20 * t24 * t990
  t996 = 0.62182e-1 * (t977 - 0.35616666666666666666666666666666666666666666666666e-1 * t979 + 0.53425000000000000000000000000000000000000000000000e-1 * t992) * t324
  t997 = t371 * t375
  t999 = 0.20000000000000000000000000000000000000000000000000e1 * t997 * t396
  t1002 = t310 / t374 / t320
  t1003 = t394 ** 2
  t1006 = 0.20000000000000000000000000000000000000000000000000e1 * t1002 * t1003 * t395
  t1008 = 0.1e1 / t311 / t308
  t1009 = t379 ** 2
  t1010 = t1008 * t1009
  t1012 = 0.4e1 / 0.9e1 * t976
  t1014 = t1012 - 0.2e1 / 0.3e1 * t979 + t992
  t1015 = t377 * t1014
  t1017 = 0.39862222222222222222222222222222222222222222222223e0 * t976
  t1020 = t308 ** (-0.5e0)
  t1021 = t1020 * t1009
  t1023 = t384 * t1014
  t1026 = t42 * t784 * t316
  t1027 = 0.13692777777777777777777777777777777777777777777778e0 * t1026
  t1029 = t42 * t134 * t390
  t1031 = t367 ** 2
  t1033 = t42 * t46 * t1031
  t1037 = t42 * t46 * t306 * t990
  t1039 = -0.94946250000000000000000000000000000000000000000000e0 * t1010 + 0.18989250000000000000000000000000000000000000000000e1 * t1015 + t1017 - 0.59793333333333333333333333333333333333333333333334e0 * t979 + 0.89690000000000000000000000000000000000000000000000e0 * t992 + 0.15358125000000000000000000000000000000000000000000e0 * t1021 + 0.30716250000000000000000000000000000000000000000000e0 * t1023 + t1027 - 0.32862666666666666666666666666666666666666666666666e0 * t1029 + 0.24647000000000000000000000000000000000000000000000e0 * t1033 + 0.24647000000000000000000000000000000000000000000000e0 * t1037
  t1042 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t1039 * t395
  t1043 = t374 ** 2
  t1045 = t310 / t1043
  t1046 = t323 ** 2
  t1047 = 0.1e1 / t1046
  t1050 = 0.16081824322151104821330931780901225435013347914188e2 * t1045 * t1003 * t1047
  t1051 = 0.22831111111111111111111111111111111111111111111111e-1 * t976
  t1057 = t401 * t405
  t1062 = t328 / t404 / t333
  t1063 = t413 ** 2
  t1069 = 0.68863333333333333333333333333333333333333333333333e0 * t976
  t1074 = 0.17365833333333333333333333333333333333333333333333e0 * t1026
  t1078 = -0.17648625000000000000000000000000000000000000000000e1 * t1010 + 0.35297250000000000000000000000000000000000000000000e1 * t1015 + t1069 - 0.10329500000000000000000000000000000000000000000000e1 * t979 + 0.15494250000000000000000000000000000000000000000000e1 * t992 + 0.31558125000000000000000000000000000000000000000000e0 * t1021 + 0.63116250000000000000000000000000000000000000000000e0 * t1023 + t1074 - 0.41678000000000000000000000000000000000000000000000e0 * t1029 + 0.31258500000000000000000000000000000000000000000000e0 * t1033 + 0.31258500000000000000000000000000000000000000000000e0 * t1037
  t1082 = t404 ** 2
  t1084 = t328 / t1082
  t1085 = t336 ** 2
  t1086 = 0.1e1 / t1085
  t1090 = 0.12361111111111111111111111111111111111111111111111e-1 * t976
  t1094 = (t1090 - 0.18541666666666666666666666666666666666666666666667e-1 * t979 + 0.27812500000000000000000000000000000000000000000000e-1 * t992) * t350
  t1096 = t420 * t424
  t1100 = 0.1e1 / t423 / t346
  t1101 = t341 * t1100
  t1102 = t432 ** 2
  t1108 = 0.40256666666666666666666666666666666666666666666667e0 * t976
  t1113 = 0.13797500000000000000000000000000000000000000000000e0 * t1026
  t1117 = -0.12946250000000000000000000000000000000000000000000e1 * t1010 + 0.25892500000000000000000000000000000000000000000000e1 * t1015 + t1108 - 0.60385000000000000000000000000000000000000000000000e0 * t979 + 0.90577500000000000000000000000000000000000000000000e0 * t992 + 0.82524375000000000000000000000000000000000000000000e-1 * t1021 + 0.16504875000000000000000000000000000000000000000000e0 * t1023 + t1113 - 0.33114000000000000000000000000000000000000000000000e0 * t1029 + 0.24835500000000000000000000000000000000000000000000e0 * t1033 + 0.24835500000000000000000000000000000000000000000000e0 * t1037
  t1121 = t423 ** 2
  t1122 = 0.1e1 / t1121
  t1123 = t341 * t1122
  t1124 = t349 ** 2
  t1125 = 0.1e1 / t1124
  t1129 = -0.31090e-1 * (t1051 - 0.34246666666666666666666666666666666666666666666666e-1 * t979 + 0.51370000000000000000000000000000000000000000000000e-1 * t992) * t337 + 0.20000000000000000000000000000000000000000000000000e1 * t1057 * t415 - 0.20000000000000000000000000000000000000000000000000e1 * t1062 * t1063 * t414 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t1078 * t414 + 0.32164683177870697973624959794146027661627532968800e2 * t1084 * t1063 * t1086 + t996 - t999 + t1006 - t1042 - t1050 - 0.19751789702565206228825776161588751761046270558698e-1 * t1094 + 0.11696446794910408141662685001236899248561775660981e1 * t1096 * t434 - 0.11696446794910408141662685001236899248561775660981e1 * t1101 * t1102 * t433 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1117 * t433 + 0.17315755899375863299672358916972966258900005419821e2 * t1123 * t1102 * t1125
  t1133 = t68 * t420
  t1148 = -t996 + t999 - t1006 + t1042 + t1050 + t68 * t1129 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1094 - 0.11696446794910408141662685001236899248561775660981e1 * t1133 * t443 + 0.11696446794910408141662685001236899248561775660981e1 * t441 * t1100 * t1102 * t433 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t424 * t1117 * t433 - 0.17315755899375863299672358916972966258900005419821e2 * t441 * t1122 * t1102 * t1125
  t1152 = f.my_piecewise3(t301, 0, t971 * t357 / 0.2e1 + t303 * t446 + t359 * t1148 / 0.2e1)
  t1157 = 0.10843580882781524214666447553230042011687479519034e-1 * t549 * t17 * t497 * t641
  t1161 = 0.24415406715670879921742973310852762593515528885057e-3 * t634 * t523 * t730 * t575
  t1163 = t596 * t14 * t636
  t1168 = 0.35616666666666666666666666666666666666666666666666e-1 * t20 * t103 * t519 * t538
  t1172 = t536 ** 2
  t1175 = 0.20000000000000000000000000000000000000000000000000e1 * t517 / t518 / t508 * t1172 * t537
  t1176 = t27 ** 2
  t1177 = 0.1e1 / t1176
  t1183 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1177 * t741 + 0.4e1 / 0.3e1 * t27 * t724)
  t1184 = t304 ** 2
  t1185 = 0.1e1 / t1184
  t1191 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t1185 * t984 + 0.4e1 / 0.3e1 * t304 * t970)
  t1193 = (t1183 + t1191) * t67
  t1200 = t40 * t18 * t783
  t1201 = 0.1e1 / t500 / t499 * t39 * t1200
  t1203 = t523 * t730
  t1204 = t522 * t1203
  t1206 = t19 * t730
  t1207 = t17 * t1206
  t1209 = t499 ** (-0.5e0)
  t1211 = t1209 * t39 * t1200
  t1213 = t530 * t1203
  t1216 = t41 * t18 * t783
  t1221 = 0.10000000000000000000000000000000000000000000000000e1 * t520 * (-0.42198333333333333333333333333333333333333333333333e0 * t1201 + 0.84396666666666666666666666666666666666666666666666e0 * t1204 + 0.39862222222222222222222222222222222222222222222223e0 * t1207 + 0.68258333333333333333333333333333333333333333333333e-1 * t1211 + 0.13651666666666666666666666666666666666666666666667e0 * t1213 + 0.13692777777777777777777777777777777777777777777778e0 * t1216) * t537
  t1222 = t518 ** 2
  t1225 = t511 ** 2
  t1229 = 0.16081824322151104821330931780901225435013347914188e2 * t517 / t1222 * t1172 / t1225
  t1231 = 0.8e1 * t585 * t630
  t1234 = 0.14764770444444444444444444444444444444444444444444e-2 * t17 * t1206 * t512
  t1239 = 0.20e2 * t582 / t543 / t9 * t579
  t1240 = t1157 + t1161 - 0.36623110073506319882614459966279143890273293327586e-3 * t1163 - t1168 - t1152 - t1175 + 0.19751789702565206228825776161588751761046270558698e-1 * t1193 * t576 + t1221 + t1229 - t1231 - t1234 + t1239
  t1243 = 0.12e2 * t541 * t544 * t579
  t1246 = 0.32e2 * t542 * t584 * t579
  t1257 = t609 ** 2
  t1271 = t602 ** 2
  t1274 = t559 ** 2
  t1287 = 0.1e1 / t617 / t571
  t1289 = t624 ** 2
  t1299 = -0.57538888888888888888888888888888888888888888888889e0 * t1201 + 0.11507777777777777777777777777777777777777777777778e1 * t1204 + 0.40256666666666666666666666666666666666666666666667e0 * t1207 + 0.36677500000000000000000000000000000000000000000000e-1 * t1211 + 0.73355000000000000000000000000000000000000000000000e-1 * t1213 + 0.13797500000000000000000000000000000000000000000000e0 * t1216
  t1303 = t617 ** 2
  t1304 = 0.1e1 / t1303
  t1306 = t574 ** 2
  t1307 = 0.1e1 / t1306
  t1311 = -0.70981924444444444444444444444444444444444444444442e-3 * t17 * t1206 * t560 - 0.34246666666666666666666666666666666666666666666666e-1 * t20 * t103 * t603 * t611 - 0.20000000000000000000000000000000000000000000000000e1 * t551 / t602 / t556 * t1257 * t610 + 0.99999999999999999999999999999999999999999999999999e0 * t604 * (-0.78438333333333333333333333333333333333333333333333e0 * t1201 + 0.15687666666666666666666666666666666666666666666667e1 * t1204 + 0.68863333333333333333333333333333333333333333333333e0 * t1207 + 0.14025833333333333333333333333333333333333333333333e0 * t1211 + 0.28051666666666666666666666666666666666666666666667e0 * t1213 + 0.17365833333333333333333333333333333333333333333333e0 * t1216) * t610 + 0.32164683177870697973624959794146027661627532968800e2 * t551 / t1271 * t1257 / t1274 + t1234 + t1168 + t1175 - t1221 - t1229 - 0.24415406715670879921742973310852762593515528885057e-3 * t17 * t1206 * t575 - 0.10843580882781524214666447553230042011687479519034e-1 * t20 * t103 * t618 * t626 - 0.11696446794910408141662685001236899248561775660981e1 * t566 * t1287 * t1289 * t625 + 0.58482233974552040708313425006184496242808878304903e0 * t619 * t1299 * t625 + 0.17315755899375863299672358916972966258900005419821e2 * t566 * t1304 * t1289 * t1307
  t1313 = t588 * t549 * t1311
  t1315 = t596 * t566 * t641
  t1320 = 0.58482233974552040708313425006184496242808878304903e0 * t639 * t618 * t1299 * t625
  t1324 = 0.17315755899375863299672358916972966258900005419821e2 * t639 * t1304 * t1289 * t1307
  t1328 = 0.11696446794910408141662685001236899248561775660981e1 * t639 * t1287 * t1289 * t625
  t1330 = t588 * t596 * t629
  t1332 = t545 * t597
  t1335 = 0.8e1 * t545 * t630
  t1336 = t585 * t597
  t1340 = t1243 - t1246 + t1313 - 0.11696446794910408141662685001236899248561775660981e1 * t1315 - t1320 - t1324 + t1328 + 0.2e1 * t1330 + 0.8e1 * t1332 + t1335 - 0.8e1 * t1336 - t912 + t588 * t1193 * t578
  t1349 = t923 * t659
  t1353 = t666 * t215 * t923
  t1356 = t690 * t917
  t1367 = t673 * t215 * t923
  t1370 = t697 * t917
  t1373 = t662 * t647
  t1381 = t712 * t215 * t923
  t1384 = t704 * t917
  t1387 = t669 * t656
  t1395 = 0.1e1 / t672 / t658
  t1403 = 0.29333333333333333333333333333333333333333333333333e-1 * t686 * t917 * t652 - 0.12800000000000000000000000000000000000000000000000e-3 * t646 * t215 * t1349 + 0.38400000000000000000000000000000000000000000000000e-6 * t648 * t1353 - 0.88000000000000000000000000000000000000000000000000e-4 * t648 * t1356 + 0.12800000000000000000000000000000000000000000000000e-3 * t655 * t215 * t1349 - 0.15360000000000000000000000000000000000000000000000e-5 * t694 * t1353 + 0.17600000000000000000000000000000000000000000000000e-3 * t694 * t1356 + 0.34560000000000000000000000000000000000000000000000e-8 * t657 * t1367 - 0.52800000000000000000000000000000000000000000000000e-6 * t657 * t1370 + 0.11520000000000000000000000000000000000000000000000e-5 * t1373 * t1353 - 0.10368000000000000000000000000000000000000000000000e-7 * t701 * t1367 + 0.79200000000000000000000000000000000000000000000000e-6 * t701 * t1370 + 0.20736000000000000000000000000000000000000000000000e-10 * t664 * t1381 - 0.23760000000000000000000000000000000000000000000000e-8 * t664 * t1384 + 0.69120000000000000000000000000000000000000000000000e-8 * t1387 * t1367 - 0.55296000000000000000000000000000000000000000000000e-10 * t708 * t1381 + 0.31680000000000000000000000000000000000000000000000e-8 * t708 * t1384 + 0.10368000000000000000000000000000000000000000000000e-12 * t671 * t1395 * t215 * t923 - 0.95040000000000000000000000000000000000000000000000e-11 * t671 * t713 * t917
  d11 = 0.2e1 * t248 + 0.2e1 * t296 + 0.2e1 * t495 + 0.2e1 * t677 + 0.2e1 * t718 + t3 * (t912 * t247 + 0.2e1 * t198 * t295 + t252 * t968 + t1152 * t494 + (t1240 + t1340) * t676 + 0.2e1 * t644 * t717 + t685 * t1403)
  t1407 = -t4 - t11
  t1408 = f.my_piecewise3(t7, 0, t1407)
  t1412 = f.my_piecewise3(t7, 0, -t109 * t1407 / 0.3e1)
  t1414 = t20 * t24 * t1412
  t1416 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t1414
  t1418 = 0.62182e-1 * t1416 * t55
  t1419 = -t123 + t1414
  t1420 = t122 * t1419
  t1423 = t129 * t1419
  t1425 = t29 * t1412
  t1427 = t42 * t46 * t1425
  t1429 = 0.18989250000000000000000000000000000000000000000000e1 * t1420 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t1414 + 0.30716250000000000000000000000000000000000000000000e0 * t1423 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t1427
  t1430 = t1429 * t143
  t1432 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1430
  t1434 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t1414
  t1441 = 0.35297250000000000000000000000000000000000000000000e1 * t1420 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t1414 + 0.63116250000000000000000000000000000000000000000000e0 * t1423 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t1427
  t1442 = t1441 * t162
  t1446 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t1414
  t1447 = t1446 * t92
  t1453 = 0.25892500000000000000000000000000000000000000000000e1 * t1420 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t1414 + 0.16504875000000000000000000000000000000000000000000e0 * t1423 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t1427
  t1454 = t1453 * t181
  t1462 = t172 * t1453 * t181
  t1465 = -t1418 + t1432 + t68 * (-0.31090e-1 * t1434 * t79 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t1442 + t1418 - t1432 - 0.19751789702565206228825776161588751761046270558698e-1 * t1447 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t1454) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1447 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t1462
  t1469 = f.my_piecewise3(t8, 0, t101 * t1465 / 0.2e1 + t1408 * t99 / 0.2e1)
  t1470 = t1469 * t247
  t1471 = -t1407
  t1472 = f.my_piecewise3(t300, 0, t1471)
  t1476 = f.my_piecewise3(t300, 0, -t364 * t1471 / 0.3e1)
  t1478 = t20 * t24 * t1476
  t1480 = -t362 + 0.53425000000000000000000000000000000000000000000000e-1 * t1478
  t1482 = 0.62182e-1 * t1480 * t324
  t1483 = -t378 + t1478
  t1484 = t377 * t1483
  t1487 = t384 * t1483
  t1489 = t306 * t1476
  t1491 = t42 * t46 * t1489
  t1493 = 0.18989250000000000000000000000000000000000000000000e1 * t1484 - t382 + 0.89690000000000000000000000000000000000000000000000e0 * t1478 + 0.30716250000000000000000000000000000000000000000000e0 * t1487 - t389 + 0.24647000000000000000000000000000000000000000000000e0 * t1491
  t1494 = t1493 * t395
  t1496 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t1494
  t1498 = -t399 + 0.51370000000000000000000000000000000000000000000000e-1 * t1478
  t1505 = 0.35297250000000000000000000000000000000000000000000e1 * t1484 - t408 + 0.15494250000000000000000000000000000000000000000000e1 * t1478 + 0.63116250000000000000000000000000000000000000000000e0 * t1487 - t411 + 0.31258500000000000000000000000000000000000000000000e0 * t1491
  t1506 = t1505 * t414
  t1510 = -t418 + 0.27812500000000000000000000000000000000000000000000e-1 * t1478
  t1511 = t1510 * t350
  t1517 = 0.25892500000000000000000000000000000000000000000000e1 * t1484 - t427 + 0.90577500000000000000000000000000000000000000000000e0 * t1478 + 0.16504875000000000000000000000000000000000000000000e0 * t1487 - t430 + 0.24835500000000000000000000000000000000000000000000e0 * t1491
  t1518 = t1517 * t433
  t1526 = t424 * t1517 * t433
  t1529 = -t1482 + t1496 + t68 * (-0.31090e-1 * t1498 * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t1506 + t1482 - t1496 - 0.19751789702565206228825776161588751761046270558698e-1 * t1511 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1518) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1511 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t1526
  t1533 = f.my_piecewise3(t301, 0, t1472 * t357 / 0.2e1 + t359 * t1529 / 0.2e1)
  t1534 = t1533 * t494
  t1535 = t452 * r1
  t1537 = 0.1e1 / t454 / t1535
  t1541 = t200 * t464
  t1542 = t466 * t452
  t1545 = 0.1e1 / t453 / t1542 * t471
  t1550 = t214 * t475
  t1553 = 0.1e1 / t477 / r1 * t480
  t1558 = t226 * t484
  t1562 = 0.1e1 / t454 / t477 / t1535 * t490
  t1567 = t484 * s2
  t1568 = t236 * t1567
  t1573 = 0.1e1 / t489 / t459
  t1577 = -0.53333333333333333333333333333333333333333333333333e0 * t451 * t1537 * t460 + 0.10666666666666666666666666666666666666666666666667e0 * t1541 * t1545 - 0.21333333333333333333333333333333333333333333333333e0 * t465 * t1545 + 0.42666666666666666666666666666666666666666666666668e-1 * t1550 * t1553 - 0.64e-1 * t476 * t1553 + 0.12800000000000000000000000000000000000000000000000e-1 * t1558 * t1562 - 0.17066666666666666666666666666666666666666666666667e-1 * t485 * t1562 + 0.34133333333333333333333333333333333333333333333333e-2 * t1568 / t453 / t477 / t1542 * t1573
  t1578 = t684 * t1577
  t1581 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t1407)
  t1584 = f.my_piecewise3(t300, 0, 0.4e1 / 0.3e1 * t304 * t1471)
  t1586 = (t1581 + t1584) * t67
  t1587 = t1586 * t578
  t1591 = t515 + t540 - t581 - t587 + t588 * t1587 + t631 + 0.19751789702565206228825776161588751761046270558698e-1 * t1586 * t576 - t638 - t643 - t1469 - t1533
  t1592 = t1591 * t676
  t1593 = t646 * s2
  t1597 = t659 * s2
  t1598 = t1597 * t1537
  t1603 = t666 * s2
  t1604 = t1603 * t1537
  t1609 = t673 * s2
  t1610 = t1609 * t1537
  t1615 = t712 * s2
  t1619 = -0.80000000000000000000000000000000000000000000000000e-2 * t1593 * t1537 * t652 + 0.24000000000000000000000000000000000000000000000000e-4 * t648 * t1598 - 0.48000000000000000000000000000000000000000000000000e-4 * t694 * t1598 + 0.14400000000000000000000000000000000000000000000000e-6 * t657 * t1604 - 0.21600000000000000000000000000000000000000000000000e-6 * t701 * t1604 + 0.64800000000000000000000000000000000000000000000000e-9 * t664 * t1610 - 0.86400000000000000000000000000000000000000000000000e-9 * t708 * t1610 + 0.25920000000000000000000000000000000000000000000000e-11 * t671 * t1615 * t1537
  t1620 = t685 * t1619
  t1621 = 0.2e1 * t722
  t1622 = f.my_piecewise3(t7, 0, t1621)
  t1628 = t20 * t104 * t1412
  t1637 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t740 * t1407 * t12 - 0.2e1 / 0.3e1 * t109 * t2 * t721)
  t1639 = t20 * t24 * t1637
  t1643 = 0.62182e-1 * (t734 - 0.17808333333333333333333333333333333333333333333333e-1 * t736 - 0.17808333333333333333333333333333333333333333333333e-1 * t1628 + 0.53425000000000000000000000000000000000000000000000e-1 * t1639) * t55
  t1644 = t1416 * t120
  t1646 = 0.10000000000000000000000000000000000000000000000000e1 * t1644 * t144
  t1648 = 0.10000000000000000000000000000000000000000000000000e1 * t754 * t1430
  t1651 = 0.20000000000000000000000000000000000000000000000000e1 * t759 * t1430 * t142
  t1653 = t765 * t1419 * t124
  t1657 = t769 - t736 / 0.3e1 - t1628 / 0.3e1 + t1639
  t1658 = t122 * t1657
  t1664 = t777 * t1419 * t124
  t1666 = t129 * t1657
  t1670 = t42 * t134 * t1425
  t1674 = t42 * t46 * t112 * t1412
  t1678 = t42 * t46 * t29 * t1637
  t1680 = -0.94946250000000000000000000000000000000000000000000e0 * t1653 + 0.18989250000000000000000000000000000000000000000000e1 * t1658 + t774 - 0.29896666666666666666666666666666666666666666666667e0 * t736 - 0.29896666666666666666666666666666666666666666666667e0 * t1628 + 0.89690000000000000000000000000000000000000000000000e0 * t1639 + 0.15358125000000000000000000000000000000000000000000e0 * t1664 + 0.30716250000000000000000000000000000000000000000000e0 * t1666 + t787 - 0.16431333333333333333333333333333333333333333333333e0 * t789 - 0.16431333333333333333333333333333333333333333333333e0 * t1670 + 0.24647000000000000000000000000000000000000000000000e0 * t1674 + 0.24647000000000000000000000000000000000000000000000e0 * t1678
  t1683 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1680 * t143
  t1687 = 0.16081824322151104821330931780901225435013347914188e2 * t805 * t1429 * t807 * t142
  t1694 = t1434 * t153
  t1713 = -0.17648625000000000000000000000000000000000000000000e1 * t1653 + 0.35297250000000000000000000000000000000000000000000e1 * t1658 + t829 - 0.51647500000000000000000000000000000000000000000000e0 * t736 - 0.51647500000000000000000000000000000000000000000000e0 * t1628 + 0.15494250000000000000000000000000000000000000000000e1 * t1639 + 0.31558125000000000000000000000000000000000000000000e0 * t1664 + 0.63116250000000000000000000000000000000000000000000e0 * t1666 + t834 - 0.20839000000000000000000000000000000000000000000000e0 * t789 - 0.20839000000000000000000000000000000000000000000000e0 * t1670 + 0.31258500000000000000000000000000000000000000000000e0 * t1674 + 0.31258500000000000000000000000000000000000000000000e0 * t1678
  t1725 = (t850 - 0.92708333333333333333333333333333333333333333333333e-2 * t736 - 0.92708333333333333333333333333333333333333333333333e-2 * t1628 + 0.27812500000000000000000000000000000000000000000000e-1 * t1639) * t92
  t1727 = t1446 * t172
  t1746 = -0.12946250000000000000000000000000000000000000000000e1 * t1653 + 0.25892500000000000000000000000000000000000000000000e1 * t1658 + t868 - 0.30192500000000000000000000000000000000000000000000e0 * t736 - 0.30192500000000000000000000000000000000000000000000e0 * t1628 + 0.90577500000000000000000000000000000000000000000000e0 * t1639 + 0.82524375000000000000000000000000000000000000000000e-1 * t1664 + 0.16504875000000000000000000000000000000000000000000e0 * t1666 + t873 - 0.16557000000000000000000000000000000000000000000000e0 * t789 - 0.16557000000000000000000000000000000000000000000000e0 * t1670 + 0.24835500000000000000000000000000000000000000000000e0 * t1674 + 0.24835500000000000000000000000000000000000000000000e0 * t1678
  t1754 = -0.31090e-1 * (t811 - 0.17123333333333333333333333333333333333333333333333e-1 * t736 - 0.17123333333333333333333333333333333333333333333333e-1 * t1628 + 0.51370000000000000000000000000000000000000000000000e-1 * t1639) * t79 + 0.99999999999999999999999999999999999999999999999999e0 * t1694 * t163 + 0.99999999999999999999999999999999999999999999999999e0 * t817 * t1442 - 0.20000000000000000000000000000000000000000000000000e1 * t822 * t1442 * t161 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t1713 * t162 + 0.32164683177870697973624959794146027661627532968800e2 * t844 * t1441 * t846 * t161 + t1643 - t1646 - t1648 + t1651 - t1683 - t1687 - 0.19751789702565206228825776161588751761046270558698e-1 * t1725 + 0.58482233974552040708313425006184496242808878304903e0 * t1727 * t182 + 0.58482233974552040708313425006184496242808878304903e0 * t856 * t1454 - 0.11696446794910408141662685001236899248561775660981e1 * t861 * t1454 * t180 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t1746 * t181 + 0.17315755899375863299672358916972966258900005419821e2 * t883 * t1453 * t885 * t180
  t1758 = t68 * t1446
  t1776 = -t1643 + t1646 + t1648 - t1651 + t1683 + t1687 + t68 * t1754 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1725 - 0.58482233974552040708313425006184496242808878304903e0 * t1758 * t191 - 0.58482233974552040708313425006184496242808878304903e0 * t893 * t1462 + 0.11696446794910408141662685001236899248561775660981e1 * t189 * t860 * t1453 * t182 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t172 * t1746 * t181 - 0.17315755899375863299672358916972966258900005419821e2 * t189 * t882 * t1453 * t885 * t180
  t1780 = f.my_piecewise3(t8, 0, t101 * t1776 / 0.2e1 + t13 * t1465 / 0.2e1 + t1408 * t194 / 0.2e1 + t1622 * t99 / 0.2e1)
  t1783 = f.my_piecewise3(t300, 0, -t1621)
  t1789 = t20 * t104 * t1476
  t1798 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t983 * t1471 * t302 + 0.2e1 / 0.3e1 * t364 * t2 * t721)
  t1800 = t20 * t24 * t1798
  t1804 = 0.62182e-1 * (t977 - 0.17808333333333333333333333333333333333333333333333e-1 * t979 - 0.17808333333333333333333333333333333333333333333333e-1 * t1789 + 0.53425000000000000000000000000000000000000000000000e-1 * t1800) * t324
  t1805 = t1480 * t375
  t1807 = 0.10000000000000000000000000000000000000000000000000e1 * t1805 * t396
  t1809 = 0.10000000000000000000000000000000000000000000000000e1 * t997 * t1494
  t1812 = 0.20000000000000000000000000000000000000000000000000e1 * t1002 * t1494 * t394
  t1814 = t1008 * t1483 * t379
  t1818 = t1012 - t979 / 0.3e1 - t1789 / 0.3e1 + t1800
  t1819 = t377 * t1818
  t1825 = t1020 * t1483 * t379
  t1827 = t384 * t1818
  t1831 = t42 * t134 * t1489
  t1835 = t42 * t46 * t367 * t1476
  t1839 = t42 * t46 * t306 * t1798
  t1841 = -0.94946250000000000000000000000000000000000000000000e0 * t1814 + 0.18989250000000000000000000000000000000000000000000e1 * t1819 + t1017 - 0.29896666666666666666666666666666666666666666666667e0 * t979 - 0.29896666666666666666666666666666666666666666666667e0 * t1789 + 0.89690000000000000000000000000000000000000000000000e0 * t1800 + 0.15358125000000000000000000000000000000000000000000e0 * t1825 + 0.30716250000000000000000000000000000000000000000000e0 * t1827 + t1027 - 0.16431333333333333333333333333333333333333333333333e0 * t1029 - 0.16431333333333333333333333333333333333333333333333e0 * t1831 + 0.24647000000000000000000000000000000000000000000000e0 * t1835 + 0.24647000000000000000000000000000000000000000000000e0 * t1839
  t1844 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t1841 * t395
  t1848 = 0.16081824322151104821330931780901225435013347914188e2 * t1045 * t1493 * t1047 * t394
  t1855 = t1498 * t405
  t1874 = -0.17648625000000000000000000000000000000000000000000e1 * t1814 + 0.35297250000000000000000000000000000000000000000000e1 * t1819 + t1069 - 0.51647500000000000000000000000000000000000000000000e0 * t979 - 0.51647500000000000000000000000000000000000000000000e0 * t1789 + 0.15494250000000000000000000000000000000000000000000e1 * t1800 + 0.31558125000000000000000000000000000000000000000000e0 * t1825 + 0.63116250000000000000000000000000000000000000000000e0 * t1827 + t1074 - 0.20839000000000000000000000000000000000000000000000e0 * t1029 - 0.20839000000000000000000000000000000000000000000000e0 * t1831 + 0.31258500000000000000000000000000000000000000000000e0 * t1835 + 0.31258500000000000000000000000000000000000000000000e0 * t1839
  t1886 = (t1090 - 0.92708333333333333333333333333333333333333333333333e-2 * t979 - 0.92708333333333333333333333333333333333333333333333e-2 * t1789 + 0.27812500000000000000000000000000000000000000000000e-1 * t1800) * t350
  t1888 = t1510 * t424
  t1907 = -0.12946250000000000000000000000000000000000000000000e1 * t1814 + 0.25892500000000000000000000000000000000000000000000e1 * t1819 + t1108 - 0.30192500000000000000000000000000000000000000000000e0 * t979 - 0.30192500000000000000000000000000000000000000000000e0 * t1789 + 0.90577500000000000000000000000000000000000000000000e0 * t1800 + 0.82524375000000000000000000000000000000000000000000e-1 * t1825 + 0.16504875000000000000000000000000000000000000000000e0 * t1827 + t1113 - 0.16557000000000000000000000000000000000000000000000e0 * t1029 - 0.16557000000000000000000000000000000000000000000000e0 * t1831 + 0.24835500000000000000000000000000000000000000000000e0 * t1835 + 0.24835500000000000000000000000000000000000000000000e0 * t1839
  t1915 = -0.31090e-1 * (t1051 - 0.17123333333333333333333333333333333333333333333333e-1 * t979 - 0.17123333333333333333333333333333333333333333333333e-1 * t1789 + 0.51370000000000000000000000000000000000000000000000e-1 * t1800) * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t1855 * t415 + 0.99999999999999999999999999999999999999999999999999e0 * t1057 * t1506 - 0.20000000000000000000000000000000000000000000000000e1 * t1062 * t1506 * t413 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t1874 * t414 + 0.32164683177870697973624959794146027661627532968800e2 * t1084 * t1505 * t1086 * t413 + t1804 - t1807 - t1809 + t1812 - t1844 - t1848 - 0.19751789702565206228825776161588751761046270558698e-1 * t1886 + 0.58482233974552040708313425006184496242808878304903e0 * t1888 * t434 + 0.58482233974552040708313425006184496242808878304903e0 * t1096 * t1518 - 0.11696446794910408141662685001236899248561775660981e1 * t1101 * t1518 * t432 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1907 * t433 + 0.17315755899375863299672358916972966258900005419821e2 * t1123 * t1517 * t1125 * t432
  t1919 = t68 * t1510
  t1937 = -t1804 + t1807 + t1809 - t1812 + t1844 + t1848 + t68 * t1915 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1886 - 0.58482233974552040708313425006184496242808878304903e0 * t1919 * t443 - 0.58482233974552040708313425006184496242808878304903e0 * t1133 * t1526 + 0.11696446794910408141662685001236899248561775660981e1 * t441 * t1100 * t1517 * t434 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t424 * t1907 * t433 - 0.17315755899375863299672358916972966258900005419821e2 * t441 * t1122 * t1517 * t1125 * t432
  t1941 = f.my_piecewise3(t301, 0, t1472 * t446 / 0.2e1 + t303 * t1529 / 0.2e1 + t1783 * t357 / 0.2e1 + t359 * t1937 / 0.2e1)
  t1951 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1177 * t1407 * t12 + 0.8e1 / 0.3e1 * t27 * t2 * t721)
  t1959 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t1185 * t1471 * t302 - 0.8e1 / 0.3e1 * t304 * t2 * t721)
  t1961 = (t1951 + t1959) * t67
  t1965 = t1157 + 0.19751789702565206228825776161588751761046270558698e-1 * t1961 * t576 + t1161 - 0.18311555036753159941307229983139571945136646663793e-3 * t1163 - t1168 - t1780 - t1175 + t1221 + t1229 - t1231 - t1941 - t1234 + t1239 - t1243
  t1969 = t588 * t1586 * t629
  t1971 = t1586 * t566 * t641
  t1976 = t585 * t1587
  t1978 = t545 * t1587
  t1981 = t1586 * t14 * t636
  t1983 = t1313 + t588 * t1961 * t578 + t1969 - 0.58482233974552040708313425006184496242808878304903e0 * t1971 - 0.58482233974552040708313425006184496242808878304903e0 * t1315 - t1320 - t1324 + t1328 + t1330 - 0.4e1 * t1332 - 0.4e1 * t1336 - 0.4e1 * t1976 + 0.4e1 * t1978 - 0.18311555036753159941307229983139571945136646663793e-3 * t1981
  t1994 = s2 * t1537 * s0 * t255
  t2025 = -0.12800000000000000000000000000000000000000000000000e-3 * t1593 * t1537 * t691 + 0.38400000000000000000000000000000000000000000000000e-6 * t648 * t666 * t1994 + 0.12800000000000000000000000000000000000000000000000e-3 * t655 * s0 * t255 * t1598 - 0.15360000000000000000000000000000000000000000000000e-5 * t694 * t666 * t1994 + 0.34560000000000000000000000000000000000000000000000e-8 * t657 * t673 * t1994 + 0.11520000000000000000000000000000000000000000000000e-5 * t1373 * t666 * t1994 - 0.10368000000000000000000000000000000000000000000000e-7 * t701 * t673 * t1994 + 0.20736000000000000000000000000000000000000000000000e-10 * t664 * t712 * t1994 + 0.69120000000000000000000000000000000000000000000000e-8 * t1387 * t673 * t1994 - 0.55296000000000000000000000000000000000000000000000e-10 * t708 * t712 * t1994 + 0.10368000000000000000000000000000000000000000000000e-12 * t671 * t1395 * t1994
  d12 = t248 + t296 + t495 + t677 + t718 + t1470 + t1534 + t1578 + t1592 + t1620 + t3 * (t1780 * t247 + t1469 * t295 + t1941 * t494 + t450 * t1577 + (t1965 + t1983) * t676 + t1591 * t717 + t644 * t1619 + t685 * t2025)
  t2035 = 0.2e1 * t10 + 0.2e1 * t722
  t2036 = f.my_piecewise3(t7, 0, t2035)
  t2041 = t1407 ** 2
  t2047 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t740 * t2041 - t109 * t2035 / 0.3e1)
  t2049 = t20 * t24 * t2047
  t2053 = 0.62182e-1 * (t734 - 0.35616666666666666666666666666666666666666666666666e-1 * t1628 + 0.53425000000000000000000000000000000000000000000000e-1 * t2049) * t55
  t2055 = 0.20000000000000000000000000000000000000000000000000e1 * t1644 * t1430
  t2056 = t1429 ** 2
  t2059 = 0.20000000000000000000000000000000000000000000000000e1 * t759 * t2056 * t143
  t2060 = t1419 ** 2
  t2061 = t765 * t2060
  t2064 = t769 - 0.2e1 / 0.3e1 * t1628 + t2049
  t2065 = t122 * t2064
  t2069 = t777 * t2060
  t2071 = t129 * t2064
  t2074 = t1412 ** 2
  t2076 = t42 * t46 * t2074
  t2080 = t42 * t46 * t29 * t2047
  t2082 = -0.94946250000000000000000000000000000000000000000000e0 * t2061 + 0.18989250000000000000000000000000000000000000000000e1 * t2065 + t774 - 0.59793333333333333333333333333333333333333333333334e0 * t1628 + 0.89690000000000000000000000000000000000000000000000e0 * t2049 + 0.15358125000000000000000000000000000000000000000000e0 * t2069 + 0.30716250000000000000000000000000000000000000000000e0 * t2071 + t787 - 0.32862666666666666666666666666666666666666666666666e0 * t1670 + 0.24647000000000000000000000000000000000000000000000e0 * t2076 + 0.24647000000000000000000000000000000000000000000000e0 * t2080
  t2085 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t2082 * t143
  t2088 = 0.16081824322151104821330931780901225435013347914188e2 * t805 * t2056 * t807
  t2096 = t1441 ** 2
  t2109 = -0.17648625000000000000000000000000000000000000000000e1 * t2061 + 0.35297250000000000000000000000000000000000000000000e1 * t2065 + t829 - 0.10329500000000000000000000000000000000000000000000e1 * t1628 + 0.15494250000000000000000000000000000000000000000000e1 * t2049 + 0.31558125000000000000000000000000000000000000000000e0 * t2069 + 0.63116250000000000000000000000000000000000000000000e0 * t2071 + t834 - 0.41678000000000000000000000000000000000000000000000e0 * t1670 + 0.31258500000000000000000000000000000000000000000000e0 * t2076 + 0.31258500000000000000000000000000000000000000000000e0 * t2080
  t2119 = (t850 - 0.18541666666666666666666666666666666666666666666667e-1 * t1628 + 0.27812500000000000000000000000000000000000000000000e-1 * t2049) * t92
  t2123 = t1453 ** 2
  t2136 = -0.12946250000000000000000000000000000000000000000000e1 * t2061 + 0.25892500000000000000000000000000000000000000000000e1 * t2065 + t868 - 0.60385000000000000000000000000000000000000000000000e0 * t1628 + 0.90577500000000000000000000000000000000000000000000e0 * t2049 + 0.82524375000000000000000000000000000000000000000000e-1 * t2069 + 0.16504875000000000000000000000000000000000000000000e0 * t2071 + t873 - 0.33114000000000000000000000000000000000000000000000e0 * t1670 + 0.24835500000000000000000000000000000000000000000000e0 * t2076 + 0.24835500000000000000000000000000000000000000000000e0 * t2080
  t2143 = -0.31090e-1 * (t811 - 0.34246666666666666666666666666666666666666666666666e-1 * t1628 + 0.51370000000000000000000000000000000000000000000000e-1 * t2049) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t1694 * t1442 - 0.20000000000000000000000000000000000000000000000000e1 * t822 * t2096 * t162 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t2109 * t162 + 0.32164683177870697973624959794146027661627532968800e2 * t844 * t2096 * t846 + t2053 - t2055 + t2059 - t2085 - t2088 - 0.19751789702565206228825776161588751761046270558698e-1 * t2119 + 0.11696446794910408141662685001236899248561775660981e1 * t1727 * t1454 - 0.11696446794910408141662685001236899248561775660981e1 * t861 * t2123 * t181 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t2136 * t181 + 0.17315755899375863299672358916972966258900005419821e2 * t883 * t2123 * t885
  t2161 = -t2053 + t2055 - t2059 + t2085 + t2088 + t68 * t2143 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t2119 - 0.11696446794910408141662685001236899248561775660981e1 * t1758 * t1462 + 0.11696446794910408141662685001236899248561775660981e1 * t189 * t860 * t2123 * t181 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t172 * t2136 * t181 - 0.17315755899375863299672358916972966258900005419821e2 * t189 * t882 * t2123 * t885
  t2165 = f.my_piecewise3(t8, 0, t2036 * t99 / 0.2e1 + t1408 * t1465 + t101 * t2161 / 0.2e1)
  t2167 = -t2035
  t2168 = f.my_piecewise3(t300, 0, t2167)
  t2173 = t1471 ** 2
  t2179 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t983 * t2173 - t364 * t2167 / 0.3e1)
  t2181 = t20 * t24 * t2179
  t2185 = 0.62182e-1 * (t977 - 0.35616666666666666666666666666666666666666666666666e-1 * t1789 + 0.53425000000000000000000000000000000000000000000000e-1 * t2181) * t324
  t2187 = 0.20000000000000000000000000000000000000000000000000e1 * t1805 * t1494
  t2188 = t1493 ** 2
  t2191 = 0.20000000000000000000000000000000000000000000000000e1 * t1002 * t2188 * t395
  t2192 = t1483 ** 2
  t2193 = t1008 * t2192
  t2196 = t1012 - 0.2e1 / 0.3e1 * t1789 + t2181
  t2197 = t377 * t2196
  t2201 = t1020 * t2192
  t2203 = t384 * t2196
  t2206 = t1476 ** 2
  t2208 = t42 * t46 * t2206
  t2212 = t42 * t46 * t306 * t2179
  t2214 = -0.94946250000000000000000000000000000000000000000000e0 * t2193 + 0.18989250000000000000000000000000000000000000000000e1 * t2197 + t1017 - 0.59793333333333333333333333333333333333333333333334e0 * t1789 + 0.89690000000000000000000000000000000000000000000000e0 * t2181 + 0.15358125000000000000000000000000000000000000000000e0 * t2201 + 0.30716250000000000000000000000000000000000000000000e0 * t2203 + t1027 - 0.32862666666666666666666666666666666666666666666666e0 * t1831 + 0.24647000000000000000000000000000000000000000000000e0 * t2208 + 0.24647000000000000000000000000000000000000000000000e0 * t2212
  t2217 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t2214 * t395
  t2220 = 0.16081824322151104821330931780901225435013347914188e2 * t1045 * t2188 * t1047
  t2228 = t1505 ** 2
  t2241 = -0.17648625000000000000000000000000000000000000000000e1 * t2193 + 0.35297250000000000000000000000000000000000000000000e1 * t2197 + t1069 - 0.10329500000000000000000000000000000000000000000000e1 * t1789 + 0.15494250000000000000000000000000000000000000000000e1 * t2181 + 0.31558125000000000000000000000000000000000000000000e0 * t2201 + 0.63116250000000000000000000000000000000000000000000e0 * t2203 + t1074 - 0.41678000000000000000000000000000000000000000000000e0 * t1831 + 0.31258500000000000000000000000000000000000000000000e0 * t2208 + 0.31258500000000000000000000000000000000000000000000e0 * t2212
  t2251 = (t1090 - 0.18541666666666666666666666666666666666666666666667e-1 * t1789 + 0.27812500000000000000000000000000000000000000000000e-1 * t2181) * t350
  t2255 = t1517 ** 2
  t2268 = -0.12946250000000000000000000000000000000000000000000e1 * t2193 + 0.25892500000000000000000000000000000000000000000000e1 * t2197 + t1108 - 0.60385000000000000000000000000000000000000000000000e0 * t1789 + 0.90577500000000000000000000000000000000000000000000e0 * t2181 + 0.82524375000000000000000000000000000000000000000000e-1 * t2201 + 0.16504875000000000000000000000000000000000000000000e0 * t2203 + t1113 - 0.33114000000000000000000000000000000000000000000000e0 * t1831 + 0.24835500000000000000000000000000000000000000000000e0 * t2208 + 0.24835500000000000000000000000000000000000000000000e0 * t2212
  t2275 = -0.31090e-1 * (t1051 - 0.34246666666666666666666666666666666666666666666666e-1 * t1789 + 0.51370000000000000000000000000000000000000000000000e-1 * t2181) * t337 + 0.20000000000000000000000000000000000000000000000000e1 * t1855 * t1506 - 0.20000000000000000000000000000000000000000000000000e1 * t1062 * t2228 * t414 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t2241 * t414 + 0.32164683177870697973624959794146027661627532968800e2 * t1084 * t2228 * t1086 + t2185 - t2187 + t2191 - t2217 - t2220 - 0.19751789702565206228825776161588751761046270558698e-1 * t2251 + 0.11696446794910408141662685001236899248561775660981e1 * t1888 * t1518 - 0.11696446794910408141662685001236899248561775660981e1 * t1101 * t2255 * t433 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t2268 * t433 + 0.17315755899375863299672358916972966258900005419821e2 * t1123 * t2255 * t1125
  t2293 = -t2185 + t2187 - t2191 + t2217 + t2220 + t68 * t2275 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t2251 - 0.11696446794910408141662685001236899248561775660981e1 * t1919 * t1526 + 0.11696446794910408141662685001236899248561775660981e1 * t441 * t1100 * t2255 * t433 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t424 * t2268 * t433 - 0.17315755899375863299672358916972966258900005419821e2 * t441 * t1122 * t2255 * t1125
  t2297 = f.my_piecewise3(t301, 0, t2168 * t357 / 0.2e1 + t1472 * t1529 + t359 * t2293 / 0.2e1)
  t2302 = 0.1e1 / t454 / t466
  t2306 = t466 * t1535
  t2308 = 0.1e1 / t453 / t2306
  t2309 = t2308 * t471
  t2314 = 0.1e1 / t486 * t480
  t2325 = 0.1e1 / t454 / t477 / t466 * t490
  t2336 = 0.1e1 / t453 / t477 / t2306 * t1573
  t2345 = t477 ** 2
  t2353 = 0.19555555555555555555555555555555555555555555555555e1 * t451 * t2302 * t460 - 0.96000000000000000000000000000000000000000000000002e0 * t1541 * t2309 + 0.11377777777777777777777777777777777777777777777778e0 * t200 * t475 * t2314 + 0.13511111111111111111111111111111111111111111111111e1 * t465 * t2309 - 0.61155555555555555555555555555555555555555555555557e0 * t1550 * t2314 + 0.68266666666666666666666666666666666666666666666669e-1 * t214 * t484 * t2325 + 0.576e0 * t476 * t2314 - 0.25173333333333333333333333333333333333333333333333e0 * t1558 * t2325 + 0.27306666666666666666666666666666666666666666666666e-1 * t226 * t1567 * t2336 + 0.19911111111111111111111111111111111111111111111112e0 * t485 * t2325 - 0.85333333333333333333333333333333333333333333333333e-1 * t1568 * t2336 + 0.91022222222222222222222222222222222222222222222219e-2 * t236 * t484 * t464 / t2345 / t452 / t489 / t470
  t2355 = -t2165 + t1157 + t1161 - t1168 - t2297 - t1175 + t1221 + t1229 - t1231 - t1234 + t1239 + t1243
  t2361 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1177 * t2041 + 0.4e1 / 0.3e1 * t27 * t2035)
  t2367 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t1185 * t2173 + 0.4e1 / 0.3e1 * t304 * t2167)
  t2369 = (t2361 + t2367) * t67
  t2379 = t1246 + t1313 + t588 * t2369 * t578 + 0.2e1 * t1969 + 0.19751789702565206228825776161588751761046270558698e-1 * t2369 * t576 - 0.11696446794910408141662685001236899248561775660981e1 * t1971 - t1320 - t1324 + t1328 - t1335 - 0.8e1 * t1976 - 0.8e1 * t1978 - 0.36623110073506319882614459966279143890273293327586e-3 * t1981
  t2388 = t2308 * t659
  t2392 = t666 * t464 * t2308
  t2395 = t1597 * t2302
  t2406 = t673 * t464 * t2308
  t2409 = t1603 * t2302
  t2419 = t712 * t464 * t2308
  t2422 = t1609 * t2302
  t2438 = 0.29333333333333333333333333333333333333333333333333e-1 * t1593 * t2302 * t652 - 0.12800000000000000000000000000000000000000000000000e-3 * t646 * t464 * t2388 + 0.38400000000000000000000000000000000000000000000000e-6 * t648 * t2392 - 0.88000000000000000000000000000000000000000000000000e-4 * t648 * t2395 + 0.12800000000000000000000000000000000000000000000000e-3 * t655 * t464 * t2388 - 0.15360000000000000000000000000000000000000000000000e-5 * t694 * t2392 + 0.17600000000000000000000000000000000000000000000000e-3 * t694 * t2395 + 0.34560000000000000000000000000000000000000000000000e-8 * t657 * t2406 - 0.52800000000000000000000000000000000000000000000000e-6 * t657 * t2409 + 0.11520000000000000000000000000000000000000000000000e-5 * t1373 * t2392 - 0.10368000000000000000000000000000000000000000000000e-7 * t701 * t2406 + 0.79200000000000000000000000000000000000000000000000e-6 * t701 * t2409 + 0.20736000000000000000000000000000000000000000000000e-10 * t664 * t2419 - 0.23760000000000000000000000000000000000000000000000e-8 * t664 * t2422 + 0.69120000000000000000000000000000000000000000000000e-8 * t1387 * t2406 - 0.55296000000000000000000000000000000000000000000000e-10 * t708 * t2419 + 0.31680000000000000000000000000000000000000000000000e-8 * t708 * t2422 + 0.10368000000000000000000000000000000000000000000000e-12 * t671 * t1395 * t464 * t2308 - 0.95040000000000000000000000000000000000000000000000e-11 * t671 * t1615 * t2302
  d22 = 0.2e1 * t1470 + 0.2e1 * t1534 + 0.2e1 * t1578 + 0.2e1 * t1592 + 0.2e1 * t1620 + t3 * (t2165 * t247 + t2297 * t494 + 0.2e1 * t1533 * t1577 + t684 * t2353 + (t2355 + t2379) * t676 + 0.2e1 * t1591 * t1619 + t685 * t2438)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = t3 ** 2
  t10 = 0.1e1 / t9
  t11 = t2 * t10
  t12 = t4 - t11
  t13 = f.my_piecewise3(t7, 0, t12)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t16 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = t3 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t22 * t23
  t25 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t29 = f.my_piecewise3(t7, t26, 0.1e1 / t27)
  t31 = t20 * t24 * t29
  t33 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t31
  t34 = jnp.sqrt(t31)
  t37 = t31 ** 0.15e1
  t39 = t14 ** 2
  t40 = t16 ** 2
  t41 = t39 * t40
  t42 = t41 * t18
  t43 = t21 ** 2
  t44 = 0.1e1 / t43
  t45 = t23 ** 2
  t46 = t44 * t45
  t47 = t29 ** 2
  t49 = t42 * t46 * t47
  t51 = 0.37978500000000000000000000000000000000000000000000e1 * t34 + 0.89690000000000000000000000000000000000000000000000e0 * t31 + 0.20477500000000000000000000000000000000000000000000e0 * t37 + 0.12323500000000000000000000000000000000000000000000e0 * t49
  t54 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t51
  t55 = jnp.log(t54)
  t57 = 0.62182e-1 * t33 * t55
  t59 = t25 * f.p.zeta_threshold
  t61 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t59, 0.2e1 * t23)
  t63 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t59, 0)
  t67 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t68 = (t61 + t63 - 0.2e1) * t67
  t70 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t31
  t75 = 0.70594500000000000000000000000000000000000000000000e1 * t34 + 0.15494250000000000000000000000000000000000000000000e1 * t31 + 0.42077500000000000000000000000000000000000000000000e0 * t37 + 0.15629250000000000000000000000000000000000000000000e0 * t49
  t78 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t75
  t79 = jnp.log(t78)
  t83 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t31
  t88 = 0.51785000000000000000000000000000000000000000000000e1 * t34 + 0.90577500000000000000000000000000000000000000000000e0 * t31 + 0.11003250000000000000000000000000000000000000000000e0 * t37 + 0.12417750000000000000000000000000000000000000000000e0 * t49
  t91 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t88
  t92 = jnp.log(t91)
  t93 = t83 * t92
  t99 = -t57 + t68 * (-0.31090e-1 * t70 * t79 + t57 - 0.19751789702565206228825776161588751761046270558698e-1 * t93) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t93
  t101 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t103 = 0.1e1 / t21 / t3
  t104 = t103 * t23
  t106 = t20 * t104 * t29
  t107 = 0.17808333333333333333333333333333333333333333333333e-1 * t106
  t108 = t27 * t6
  t109 = 0.1e1 / t108
  t112 = f.my_piecewise3(t7, 0, -t109 * t12 / 0.3e1)
  t114 = t20 * t24 * t112
  t116 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t114
  t118 = 0.62182e-1 * t116 * t55
  t119 = t51 ** 2
  t120 = 0.1e1 / t119
  t121 = t33 * t120
  t122 = 0.1e1 / t34
  t123 = t106 / 0.3e1
  t124 = -t123 + t114
  t125 = t122 * t124
  t127 = 0.29896666666666666666666666666666666666666666666667e0 * t106
  t129 = t31 ** 0.5e0
  t130 = t129 * t124
  t133 = 0.1e1 / t43 / t3
  t134 = t133 * t45
  t136 = t42 * t134 * t47
  t137 = 0.82156666666666666666666666666666666666666666666667e-1 * t136
  t138 = t29 * t112
  t140 = t42 * t46 * t138
  t142 = 0.18989250000000000000000000000000000000000000000000e1 * t125 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t114 + 0.30716250000000000000000000000000000000000000000000e0 * t130 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t140
  t143 = 0.1e1 / t54
  t144 = t142 * t143
  t146 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t144
  t147 = 0.17123333333333333333333333333333333333333333333333e-1 * t106
  t149 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t114
  t152 = t75 ** 2
  t153 = 0.1e1 / t152
  t154 = t70 * t153
  t156 = 0.51647500000000000000000000000000000000000000000000e0 * t106
  t159 = 0.10419500000000000000000000000000000000000000000000e0 * t136
  t161 = 0.35297250000000000000000000000000000000000000000000e1 * t125 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t114 + 0.63116250000000000000000000000000000000000000000000e0 * t130 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t140
  t162 = 0.1e1 / t78
  t163 = t161 * t162
  t166 = 0.92708333333333333333333333333333333333333333333333e-2 * t106
  t168 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t114
  t169 = t168 * t92
  t171 = t88 ** 2
  t172 = 0.1e1 / t171
  t173 = t83 * t172
  t175 = 0.30192500000000000000000000000000000000000000000000e0 * t106
  t178 = 0.82785000000000000000000000000000000000000000000000e-1 * t136
  t180 = 0.25892500000000000000000000000000000000000000000000e1 * t125 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t114 + 0.16504875000000000000000000000000000000000000000000e0 * t130 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t140
  t181 = 0.1e1 / t91
  t182 = t180 * t181
  t189 = t68 * t83
  t191 = t172 * t180 * t181
  t194 = -t118 + t146 + t68 * (-0.31090e-1 * t149 * t79 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t163 + t118 - t146 - 0.19751789702565206228825776161588751761046270558698e-1 * t169 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t182) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t169 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t191
  t198 = f.my_piecewise3(t8, 0, t101 * t194 / 0.2e1 + t13 * t99 / 0.2e1)
  t199 = params.c_ss[0]
  t200 = params.c_ss[1]
  t201 = t200 * s0
  t202 = r0 ** 2
  t203 = r0 ** (0.1e1 / 0.3e1)
  t204 = t203 ** 2
  t206 = 0.1e1 / t204 / t202
  t207 = s0 * t206
  t209 = 0.1e1 + 0.2e0 * t207
  t210 = 0.1e1 / t209
  t214 = params.c_ss[2]
  t215 = s0 ** 2
  t216 = t214 * t215
  t217 = t202 ** 2
  t221 = t209 ** 2
  t222 = 0.1e1 / t221
  t226 = params.c_ss[3]
  t227 = t215 * s0
  t228 = t226 * t227
  t229 = t217 ** 2
  t232 = 0.1e1 / t221 / t209
  t236 = params.c_ss[4]
  t237 = t215 ** 2
  t238 = t236 * t237
  t239 = t229 * t202
  t242 = t221 ** 2
  t243 = 0.1e1 / t242
  t247 = t199 + 0.2e0 * t201 * t206 * t210 + 0.4e-1 * t216 / t203 / t217 / r0 * t222 + 0.8e-2 * t228 / t229 * t232 + 0.16e-2 * t238 / t204 / t239 * t243
  t248 = t198 * t247
  t252 = f.my_piecewise3(t8, 0, t101 * t99 / 0.2e1)
  t253 = t202 * r0
  t255 = 0.1e1 / t204 / t253
  t259 = t200 * t215
  t260 = t217 * t202
  t263 = 0.1e1 / t203 / t260 * t222
  t268 = t214 * t227
  t271 = 0.1e1 / t229 / r0 * t232
  t276 = t226 * t237
  t280 = 0.1e1 / t204 / t229 / t253 * t243
  t285 = t237 * s0
  t286 = t236 * t285
  t291 = 0.1e1 / t242 / t209
  t295 = -0.53333333333333333333333333333333333333333333333333e0 * t201 * t255 * t210 + 0.10666666666666666666666666666666666666666666666667e0 * t259 * t263 - 0.21333333333333333333333333333333333333333333333333e0 * t216 * t263 + 0.42666666666666666666666666666666666666666666666668e-1 * t268 * t271 - 0.64e-1 * t228 * t271 + 0.12800000000000000000000000000000000000000000000000e-1 * t276 * t280 - 0.17066666666666666666666666666666666666666666666667e-1 * t238 * t280 + 0.34133333333333333333333333333333333333333333333333e-2 * t286 / t203 / t229 / t260 * t291
  t296 = t252 * t295
  t299 = 0.1e1 - t5
  t300 = t299 <= f.p.zeta_threshold
  t301 = r1 <= f.p.dens_threshold or t300
  t302 = -t12
  t303 = f.my_piecewise3(t300, 0, t302)
  t304 = t299 ** (0.1e1 / 0.3e1)
  t306 = f.my_piecewise3(t300, t26, 0.1e1 / t304)
  t308 = t20 * t24 * t306
  t310 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t308
  t311 = jnp.sqrt(t308)
  t314 = t308 ** 0.15e1
  t316 = t306 ** 2
  t318 = t42 * t46 * t316
  t320 = 0.37978500000000000000000000000000000000000000000000e1 * t311 + 0.89690000000000000000000000000000000000000000000000e0 * t308 + 0.20477500000000000000000000000000000000000000000000e0 * t314 + 0.12323500000000000000000000000000000000000000000000e0 * t318
  t323 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t320
  t324 = jnp.log(t323)
  t326 = 0.62182e-1 * t310 * t324
  t328 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t308
  t333 = 0.70594500000000000000000000000000000000000000000000e1 * t311 + 0.15494250000000000000000000000000000000000000000000e1 * t308 + 0.42077500000000000000000000000000000000000000000000e0 * t314 + 0.15629250000000000000000000000000000000000000000000e0 * t318
  t336 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t333
  t337 = jnp.log(t336)
  t341 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t308
  t346 = 0.51785000000000000000000000000000000000000000000000e1 * t311 + 0.90577500000000000000000000000000000000000000000000e0 * t308 + 0.11003250000000000000000000000000000000000000000000e0 * t314 + 0.12417750000000000000000000000000000000000000000000e0 * t318
  t349 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t346
  t350 = jnp.log(t349)
  t351 = t341 * t350
  t357 = -t326 + t68 * (-0.31090e-1 * t328 * t337 + t326 - 0.19751789702565206228825776161588751761046270558698e-1 * t351) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t351
  t359 = f.my_piecewise3(t300, f.p.zeta_threshold, t299)
  t361 = t20 * t104 * t306
  t362 = 0.17808333333333333333333333333333333333333333333333e-1 * t361
  t363 = t304 * t299
  t364 = 0.1e1 / t363
  t367 = f.my_piecewise3(t300, 0, -t364 * t302 / 0.3e1)
  t369 = t20 * t24 * t367
  t371 = -t362 + 0.53425000000000000000000000000000000000000000000000e-1 * t369
  t373 = 0.62182e-1 * t371 * t324
  t374 = t320 ** 2
  t375 = 0.1e1 / t374
  t376 = t310 * t375
  t377 = 0.1e1 / t311
  t378 = t361 / 0.3e1
  t379 = -t378 + t369
  t380 = t377 * t379
  t382 = 0.29896666666666666666666666666666666666666666666667e0 * t361
  t384 = t308 ** 0.5e0
  t385 = t384 * t379
  t388 = t42 * t134 * t316
  t389 = 0.82156666666666666666666666666666666666666666666667e-1 * t388
  t390 = t306 * t367
  t392 = t42 * t46 * t390
  t394 = 0.18989250000000000000000000000000000000000000000000e1 * t380 - t382 + 0.89690000000000000000000000000000000000000000000000e0 * t369 + 0.30716250000000000000000000000000000000000000000000e0 * t385 - t389 + 0.24647000000000000000000000000000000000000000000000e0 * t392
  t395 = 0.1e1 / t323
  t396 = t394 * t395
  t398 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t396
  t399 = 0.17123333333333333333333333333333333333333333333333e-1 * t361
  t401 = -t399 + 0.51370000000000000000000000000000000000000000000000e-1 * t369
  t404 = t333 ** 2
  t405 = 0.1e1 / t404
  t406 = t328 * t405
  t408 = 0.51647500000000000000000000000000000000000000000000e0 * t361
  t411 = 0.10419500000000000000000000000000000000000000000000e0 * t388
  t413 = 0.35297250000000000000000000000000000000000000000000e1 * t380 - t408 + 0.15494250000000000000000000000000000000000000000000e1 * t369 + 0.63116250000000000000000000000000000000000000000000e0 * t385 - t411 + 0.31258500000000000000000000000000000000000000000000e0 * t392
  t414 = 0.1e1 / t336
  t415 = t413 * t414
  t418 = 0.92708333333333333333333333333333333333333333333333e-2 * t361
  t420 = -t418 + 0.27812500000000000000000000000000000000000000000000e-1 * t369
  t421 = t420 * t350
  t423 = t346 ** 2
  t424 = 0.1e1 / t423
  t425 = t341 * t424
  t427 = 0.30192500000000000000000000000000000000000000000000e0 * t361
  t430 = 0.82785000000000000000000000000000000000000000000000e-1 * t388
  t432 = 0.25892500000000000000000000000000000000000000000000e1 * t380 - t427 + 0.90577500000000000000000000000000000000000000000000e0 * t369 + 0.16504875000000000000000000000000000000000000000000e0 * t385 - t430 + 0.24835500000000000000000000000000000000000000000000e0 * t392
  t433 = 0.1e1 / t349
  t434 = t432 * t433
  t441 = t68 * t341
  t443 = t424 * t432 * t433
  t446 = -t373 + t398 + t68 * (-0.31090e-1 * t401 * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t415 + t373 - t398 - 0.19751789702565206228825776161588751761046270558698e-1 * t421 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t434) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t421 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t443
  t450 = f.my_piecewise3(t301, 0, t303 * t357 / 0.2e1 + t359 * t446 / 0.2e1)
  t451 = t200 * s2
  t452 = r1 ** 2
  t453 = r1 ** (0.1e1 / 0.3e1)
  t454 = t453 ** 2
  t456 = 0.1e1 / t454 / t452
  t457 = s2 * t456
  t459 = 0.1e1 + 0.2e0 * t457
  t460 = 0.1e1 / t459
  t464 = s2 ** 2
  t465 = t214 * t464
  t466 = t452 ** 2
  t470 = t459 ** 2
  t471 = 0.1e1 / t470
  t475 = t464 * s2
  t476 = t226 * t475
  t477 = t466 ** 2
  t480 = 0.1e1 / t470 / t459
  t484 = t464 ** 2
  t485 = t236 * t484
  t486 = t477 * t452
  t489 = t470 ** 2
  t490 = 0.1e1 / t489
  t494 = t199 + 0.2e0 * t451 * t456 * t460 + 0.4e-1 * t465 / t453 / t466 / r1 * t471 + 0.8e-2 * t476 / t477 * t480 + 0.16e-2 * t485 / t454 / t486 * t490
  t495 = t450 * t494
  t497 = t19 * t103
  t499 = t17 * t19 * t22
  t500 = jnp.sqrt(t499)
  t503 = t499 ** 0.15e1
  t506 = t41 * t18 * t44
  t508 = 0.37978500000000000000000000000000000000000000000000e1 * t500 + 0.89690000000000000000000000000000000000000000000000e0 * t499 + 0.20477500000000000000000000000000000000000000000000e0 * t503 + 0.12323500000000000000000000000000000000000000000000e0 * t506
  t511 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t508
  t512 = jnp.log(t511)
  t515 = 0.11073577833333333333333333333333333333333333333333e-2 * t17 * t497 * t512
  t517 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t499
  t518 = t508 ** 2
  t519 = 0.1e1 / t518
  t520 = t517 * t519
  t522 = 0.1e1 / t500 * t14
  t523 = t16 * t19
  t524 = t523 * t103
  t525 = t522 * t524
  t527 = t17 * t497
  t529 = t499 ** 0.5e0
  t530 = t529 * t14
  t531 = t530 * t524
  t534 = t41 * t18 * t133
  t536 = -0.63297500000000000000000000000000000000000000000000e0 * t525 - 0.29896666666666666666666666666666666666666666666667e0 * t527 - 0.10238750000000000000000000000000000000000000000000e0 * t531 - 0.82156666666666666666666666666666666666666666666667e-1 * t534
  t537 = 0.1e1 / t511
  t538 = t536 * t537
  t540 = 0.10000000000000000000000000000000000000000000000000e1 * t520 * t538
  t541 = t2 ** 2
  t542 = t541 * t2
  t543 = t9 ** 2
  t544 = 0.1e1 / t543
  t545 = t542 * t544
  t546 = f.my_piecewise3(t7, t59, t108)
  t547 = f.my_piecewise3(t300, t59, t363)
  t549 = (t546 + t547 - 0.2e1) * t67
  t551 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t499
  t556 = 0.70594500000000000000000000000000000000000000000000e1 * t500 + 0.15494250000000000000000000000000000000000000000000e1 * t499 + 0.42077500000000000000000000000000000000000000000000e0 * t503 + 0.15629250000000000000000000000000000000000000000000e0 * t506
  t559 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t556
  t560 = jnp.log(t559)
  t564 = 0.62182e-1 * t517 * t512
  t566 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t499
  t571 = 0.51785000000000000000000000000000000000000000000000e1 * t500 + 0.90577500000000000000000000000000000000000000000000e0 * t499 + 0.11003250000000000000000000000000000000000000000000e0 * t503 + 0.12417750000000000000000000000000000000000000000000e0 * t506
  t574 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t571
  t575 = jnp.log(t574)
  t576 = t566 * t575
  t578 = -0.31090e-1 * t551 * t560 + t564 - 0.19751789702565206228825776161588751761046270558698e-1 * t576
  t579 = t549 * t578
  t581 = 0.4e1 * t545 * t579
  t582 = t541 ** 2
  t584 = 0.1e1 / t543 / t3
  t585 = t582 * t584
  t587 = 0.4e1 * t585 * t579
  t588 = t582 * t544
  t591 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t12)
  t594 = f.my_piecewise3(t300, 0, 0.4e1 / 0.3e1 * t304 * t302)
  t596 = (t591 + t594) * t67
  t597 = t596 * t578
  t602 = t556 ** 2
  t603 = 0.1e1 / t602
  t604 = t551 * t603
  t609 = -0.11765750000000000000000000000000000000000000000000e1 * t525 - 0.51647500000000000000000000000000000000000000000000e0 * t527 - 0.21038750000000000000000000000000000000000000000000e0 * t531 - 0.10419500000000000000000000000000000000000000000000e0 * t534
  t610 = 0.1e1 / t559
  t611 = t609 * t610
  t617 = t571 ** 2
  t618 = 0.1e1 / t617
  t619 = t566 * t618
  t624 = -0.86308333333333333333333333333333333333333333333334e0 * t525 - 0.30192500000000000000000000000000000000000000000000e0 * t527 - 0.55016250000000000000000000000000000000000000000000e-1 * t531 - 0.82785000000000000000000000000000000000000000000000e-1 * t534
  t625 = 0.1e1 / t574
  t626 = t624 * t625
  t629 = 0.53236443333333333333333333333333333333333333333332e-3 * t17 * t497 * t560 + 0.99999999999999999999999999999999999999999999999999e0 * t604 * t611 - t515 - t540 + 0.18311555036753159941307229983139571945136646663793e-3 * t17 * t497 * t575 + 0.58482233974552040708313425006184496242808878304903e0 * t619 * t626
  t630 = t549 * t629
  t631 = t588 * t630
  t634 = t549 * t14
  t636 = t523 * t103 * t575
  t638 = 0.18311555036753159941307229983139571945136646663793e-3 * t634 * t636
  t639 = t549 * t566
  t641 = t618 * t624 * t625
  t643 = 0.58482233974552040708313425006184496242808878304903e0 * t639 * t641
  t644 = t515 + t540 + t581 - t587 + t588 * t597 + t631 + 0.19751789702565206228825776161588751761046270558698e-1 * t596 * t576 - t638 - t643 - t198 - t450
  t646 = params.c_ab[1]
  t647 = t207 + t457
  t648 = t646 * t647
  t651 = 0.1e1 + 0.30000000000000000000000000000000000000000000000000e-2 * t207 + 0.30000000000000000000000000000000000000000000000000e-2 * t457
  t652 = 0.1e1 / t651
  t655 = params.c_ab[2]
  t656 = t647 ** 2
  t657 = t655 * t656
  t658 = t651 ** 2
  t659 = 0.1e1 / t658
  t662 = params.c_ab[3]
  t663 = t656 * t647
  t664 = t662 * t663
  t666 = 0.1e1 / t658 / t651
  t669 = params.c_ab[4]
  t670 = t656 ** 2
  t671 = t669 * t670
  t672 = t658 ** 2
  t673 = 0.1e1 / t672
  t676 = params.c_ab[0] + 0.30000000000000000000000000000000000000000000000000e-2 * t648 * t652 + 0.90000000000000000000000000000000000000000000000000e-5 * t657 * t659 + 0.27000000000000000000000000000000000000000000000000e-7 * t664 * t666 + 0.81000000000000000000000000000000000000000000000000e-10 * t671 * t673
  t677 = t644 * t676
  t684 = f.my_piecewise3(t301, 0, t359 * t357 / 0.2e1)
  t685 = -t564 + t588 * t579 + 0.19751789702565206228825776161588751761046270558698e-1 * t549 * t576 - t252 - t684
  t686 = t646 * s0
  t690 = t659 * s0
  t691 = t690 * t255
  t694 = t655 * t647
  t697 = t666 * s0
  t698 = t697 * t255
  t701 = t662 * t656
  t704 = t673 * s0
  t705 = t704 * t255
  t708 = t669 * t663
  t712 = 0.1e1 / t672 / t651
  t713 = t712 * s0
  t717 = -0.80000000000000000000000000000000000000000000000000e-2 * t686 * t255 * t652 + 0.24000000000000000000000000000000000000000000000000e-4 * t648 * t691 - 0.48000000000000000000000000000000000000000000000000e-4 * t694 * t691 + 0.14400000000000000000000000000000000000000000000000e-6 * t657 * t698 - 0.21600000000000000000000000000000000000000000000000e-6 * t701 * t698 + 0.64800000000000000000000000000000000000000000000000e-9 * t664 * t705 - 0.86400000000000000000000000000000000000000000000000e-9 * t708 * t705 + 0.25920000000000000000000000000000000000000000000000e-11 * t671 * t713 * t255
  t718 = t685 * t717
  t721 = 0.1e1 / t9 / t3
  t722 = t2 * t721
  t724 = -0.2e1 * t10 + 0.2e1 * t722
  t725 = f.my_piecewise3(t7, 0, t724)
  t730 = 0.1e1 / t21 / t9
  t731 = t730 * t23
  t733 = t20 * t731 * t29
  t734 = 0.23744444444444444444444444444444444444444444444444e-1 * t733
  t736 = t20 * t104 * t112
  t738 = t6 ** 2
  t740 = 0.1e1 / t27 / t738
  t741 = t12 ** 2
  t747 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t740 * t741 - t109 * t724 / 0.3e1)
  t749 = t20 * t24 * t747
  t753 = 0.62182e-1 * (t734 - 0.35616666666666666666666666666666666666666666666666e-1 * t736 + 0.53425000000000000000000000000000000000000000000000e-1 * t749) * t55
  t754 = t116 * t120
  t756 = 0.20000000000000000000000000000000000000000000000000e1 * t754 * t144
  t759 = t33 / t119 / t51
  t760 = t142 ** 2
  t763 = 0.20000000000000000000000000000000000000000000000000e1 * t759 * t760 * t143
  t765 = 0.1e1 / t34 / t31
  t766 = t124 ** 2
  t767 = t765 * t766
  t769 = 0.4e1 / 0.9e1 * t733
  t771 = t769 - 0.2e1 / 0.3e1 * t736 + t749
  t772 = t122 * t771
  t774 = 0.39862222222222222222222222222222222222222222222223e0 * t733
  t777 = t31 ** (-0.5e0)
  t778 = t777 * t766
  t780 = t129 * t771
  t783 = 0.1e1 / t43 / t9
  t784 = t783 * t45
  t786 = t42 * t784 * t47
  t787 = 0.13692777777777777777777777777777777777777777777778e0 * t786
  t789 = t42 * t134 * t138
  t791 = t112 ** 2
  t793 = t42 * t46 * t791
  t797 = t42 * t46 * t29 * t747
  t799 = -0.94946250000000000000000000000000000000000000000000e0 * t767 + 0.18989250000000000000000000000000000000000000000000e1 * t772 + t774 - 0.59793333333333333333333333333333333333333333333334e0 * t736 + 0.89690000000000000000000000000000000000000000000000e0 * t749 + 0.15358125000000000000000000000000000000000000000000e0 * t778 + 0.30716250000000000000000000000000000000000000000000e0 * t780 + t787 - 0.32862666666666666666666666666666666666666666666666e0 * t789 + 0.24647000000000000000000000000000000000000000000000e0 * t793 + 0.24647000000000000000000000000000000000000000000000e0 * t797
  t802 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t799 * t143
  t803 = t119 ** 2
  t805 = t33 / t803
  t806 = t54 ** 2
  t807 = 0.1e1 / t806
  t810 = 0.16081824322151104821330931780901225435013347914188e2 * t805 * t760 * t807
  t811 = 0.22831111111111111111111111111111111111111111111111e-1 * t733
  t817 = t149 * t153
  t822 = t70 / t152 / t75
  t823 = t161 ** 2
  t829 = 0.68863333333333333333333333333333333333333333333333e0 * t733
  t834 = 0.17365833333333333333333333333333333333333333333333e0 * t786
  t838 = -0.17648625000000000000000000000000000000000000000000e1 * t767 + 0.35297250000000000000000000000000000000000000000000e1 * t772 + t829 - 0.10329500000000000000000000000000000000000000000000e1 * t736 + 0.15494250000000000000000000000000000000000000000000e1 * t749 + 0.31558125000000000000000000000000000000000000000000e0 * t778 + 0.63116250000000000000000000000000000000000000000000e0 * t780 + t834 - 0.41678000000000000000000000000000000000000000000000e0 * t789 + 0.31258500000000000000000000000000000000000000000000e0 * t793 + 0.31258500000000000000000000000000000000000000000000e0 * t797
  t842 = t152 ** 2
  t844 = t70 / t842
  t845 = t78 ** 2
  t846 = 0.1e1 / t845
  t850 = 0.12361111111111111111111111111111111111111111111111e-1 * t733
  t854 = (t850 - 0.18541666666666666666666666666666666666666666666667e-1 * t736 + 0.27812500000000000000000000000000000000000000000000e-1 * t749) * t92
  t856 = t168 * t172
  t860 = 0.1e1 / t171 / t88
  t861 = t83 * t860
  t862 = t180 ** 2
  t868 = 0.40256666666666666666666666666666666666666666666667e0 * t733
  t873 = 0.13797500000000000000000000000000000000000000000000e0 * t786
  t877 = -0.12946250000000000000000000000000000000000000000000e1 * t767 + 0.25892500000000000000000000000000000000000000000000e1 * t772 + t868 - 0.60385000000000000000000000000000000000000000000000e0 * t736 + 0.90577500000000000000000000000000000000000000000000e0 * t749 + 0.82524375000000000000000000000000000000000000000000e-1 * t778 + 0.16504875000000000000000000000000000000000000000000e0 * t780 + t873 - 0.33114000000000000000000000000000000000000000000000e0 * t789 + 0.24835500000000000000000000000000000000000000000000e0 * t793 + 0.24835500000000000000000000000000000000000000000000e0 * t797
  t881 = t171 ** 2
  t882 = 0.1e1 / t881
  t883 = t83 * t882
  t884 = t91 ** 2
  t885 = 0.1e1 / t884
  t889 = -0.31090e-1 * (t811 - 0.34246666666666666666666666666666666666666666666666e-1 * t736 + 0.51370000000000000000000000000000000000000000000000e-1 * t749) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t817 * t163 - 0.20000000000000000000000000000000000000000000000000e1 * t822 * t823 * t162 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t838 * t162 + 0.32164683177870697973624959794146027661627532968800e2 * t844 * t823 * t846 + t753 - t756 + t763 - t802 - t810 - 0.19751789702565206228825776161588751761046270558698e-1 * t854 + 0.11696446794910408141662685001236899248561775660981e1 * t856 * t182 - 0.11696446794910408141662685001236899248561775660981e1 * t861 * t862 * t181 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t877 * t181 + 0.17315755899375863299672358916972966258900005419821e2 * t883 * t862 * t885
  t893 = t68 * t168
  t908 = -t753 + t756 - t763 + t802 + t810 + t68 * t889 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t854 - 0.11696446794910408141662685001236899248561775660981e1 * t893 * t191 + 0.11696446794910408141662685001236899248561775660981e1 * t189 * t860 * t862 * t181 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t172 * t877 * t181 - 0.17315755899375863299672358916972966258900005419821e2 * t189 * t882 * t862 * t885
  t912 = f.my_piecewise3(t8, 0, t725 * t99 / 0.2e1 + t13 * t194 + t101 * t908 / 0.2e1)
  t917 = 0.1e1 / t204 / t217
  t921 = t217 * t253
  t923 = 0.1e1 / t203 / t921
  t924 = t923 * t222
  t929 = 0.1e1 / t239 * t232
  t940 = 0.1e1 / t204 / t229 / t217 * t243
  t951 = 0.1e1 / t203 / t229 / t921 * t291
  t960 = t229 ** 2
  t968 = 0.19555555555555555555555555555555555555555555555555e1 * t201 * t917 * t210 - 0.96000000000000000000000000000000000000000000000002e0 * t259 * t924 + 0.11377777777777777777777777777777777777777777777778e0 * t200 * t227 * t929 + 0.13511111111111111111111111111111111111111111111111e1 * t216 * t924 - 0.61155555555555555555555555555555555555555555555557e0 * t268 * t929 + 0.68266666666666666666666666666666666666666666666669e-1 * t214 * t237 * t940 + 0.576e0 * t228 * t929 - 0.25173333333333333333333333333333333333333333333333e0 * t276 * t940 + 0.27306666666666666666666666666666666666666666666666e-1 * t226 * t285 * t951 + 0.19911111111111111111111111111111111111111111111112e0 * t238 * t940 - 0.85333333333333333333333333333333333333333333333333e-1 * t286 * t951 + 0.91022222222222222222222222222222222222222222222219e-2 * t236 * t237 * t215 / t960 / t202 / t242 / t221
  t970 = -t724
  t971 = f.my_piecewise3(t300, 0, t970)
  t976 = t20 * t731 * t306
  t977 = 0.23744444444444444444444444444444444444444444444444e-1 * t976
  t979 = t20 * t104 * t367
  t981 = t299 ** 2
  t983 = 0.1e1 / t304 / t981
  t984 = t302 ** 2
  t990 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t983 * t984 - t364 * t970 / 0.3e1)
  t992 = t20 * t24 * t990
  t996 = 0.62182e-1 * (t977 - 0.35616666666666666666666666666666666666666666666666e-1 * t979 + 0.53425000000000000000000000000000000000000000000000e-1 * t992) * t324
  t997 = t371 * t375
  t999 = 0.20000000000000000000000000000000000000000000000000e1 * t997 * t396
  t1002 = t310 / t374 / t320
  t1003 = t394 ** 2
  t1006 = 0.20000000000000000000000000000000000000000000000000e1 * t1002 * t1003 * t395
  t1008 = 0.1e1 / t311 / t308
  t1009 = t379 ** 2
  t1010 = t1008 * t1009
  t1012 = 0.4e1 / 0.9e1 * t976
  t1014 = t1012 - 0.2e1 / 0.3e1 * t979 + t992
  t1015 = t377 * t1014
  t1017 = 0.39862222222222222222222222222222222222222222222223e0 * t976
  t1020 = t308 ** (-0.5e0)
  t1021 = t1020 * t1009
  t1023 = t384 * t1014
  t1026 = t42 * t784 * t316
  t1027 = 0.13692777777777777777777777777777777777777777777778e0 * t1026
  t1029 = t42 * t134 * t390
  t1031 = t367 ** 2
  t1033 = t42 * t46 * t1031
  t1037 = t42 * t46 * t306 * t990
  t1039 = -0.94946250000000000000000000000000000000000000000000e0 * t1010 + 0.18989250000000000000000000000000000000000000000000e1 * t1015 + t1017 - 0.59793333333333333333333333333333333333333333333334e0 * t979 + 0.89690000000000000000000000000000000000000000000000e0 * t992 + 0.15358125000000000000000000000000000000000000000000e0 * t1021 + 0.30716250000000000000000000000000000000000000000000e0 * t1023 + t1027 - 0.32862666666666666666666666666666666666666666666666e0 * t1029 + 0.24647000000000000000000000000000000000000000000000e0 * t1033 + 0.24647000000000000000000000000000000000000000000000e0 * t1037
  t1042 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t1039 * t395
  t1043 = t374 ** 2
  t1045 = t310 / t1043
  t1046 = t323 ** 2
  t1047 = 0.1e1 / t1046
  t1050 = 0.16081824322151104821330931780901225435013347914188e2 * t1045 * t1003 * t1047
  t1051 = 0.22831111111111111111111111111111111111111111111111e-1 * t976
  t1057 = t401 * t405
  t1062 = t328 / t404 / t333
  t1063 = t413 ** 2
  t1069 = 0.68863333333333333333333333333333333333333333333333e0 * t976
  t1074 = 0.17365833333333333333333333333333333333333333333333e0 * t1026
  t1078 = -0.17648625000000000000000000000000000000000000000000e1 * t1010 + 0.35297250000000000000000000000000000000000000000000e1 * t1015 + t1069 - 0.10329500000000000000000000000000000000000000000000e1 * t979 + 0.15494250000000000000000000000000000000000000000000e1 * t992 + 0.31558125000000000000000000000000000000000000000000e0 * t1021 + 0.63116250000000000000000000000000000000000000000000e0 * t1023 + t1074 - 0.41678000000000000000000000000000000000000000000000e0 * t1029 + 0.31258500000000000000000000000000000000000000000000e0 * t1033 + 0.31258500000000000000000000000000000000000000000000e0 * t1037
  t1082 = t404 ** 2
  t1084 = t328 / t1082
  t1085 = t336 ** 2
  t1086 = 0.1e1 / t1085
  t1090 = 0.12361111111111111111111111111111111111111111111111e-1 * t976
  t1094 = (t1090 - 0.18541666666666666666666666666666666666666666666667e-1 * t979 + 0.27812500000000000000000000000000000000000000000000e-1 * t992) * t350
  t1096 = t420 * t424
  t1100 = 0.1e1 / t423 / t346
  t1101 = t341 * t1100
  t1102 = t432 ** 2
  t1108 = 0.40256666666666666666666666666666666666666666666667e0 * t976
  t1113 = 0.13797500000000000000000000000000000000000000000000e0 * t1026
  t1117 = -0.12946250000000000000000000000000000000000000000000e1 * t1010 + 0.25892500000000000000000000000000000000000000000000e1 * t1015 + t1108 - 0.60385000000000000000000000000000000000000000000000e0 * t979 + 0.90577500000000000000000000000000000000000000000000e0 * t992 + 0.82524375000000000000000000000000000000000000000000e-1 * t1021 + 0.16504875000000000000000000000000000000000000000000e0 * t1023 + t1113 - 0.33114000000000000000000000000000000000000000000000e0 * t1029 + 0.24835500000000000000000000000000000000000000000000e0 * t1033 + 0.24835500000000000000000000000000000000000000000000e0 * t1037
  t1121 = t423 ** 2
  t1122 = 0.1e1 / t1121
  t1123 = t341 * t1122
  t1124 = t349 ** 2
  t1125 = 0.1e1 / t1124
  t1129 = -0.31090e-1 * (t1051 - 0.34246666666666666666666666666666666666666666666666e-1 * t979 + 0.51370000000000000000000000000000000000000000000000e-1 * t992) * t337 + 0.20000000000000000000000000000000000000000000000000e1 * t1057 * t415 - 0.20000000000000000000000000000000000000000000000000e1 * t1062 * t1063 * t414 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t1078 * t414 + 0.32164683177870697973624959794146027661627532968800e2 * t1084 * t1063 * t1086 + t996 - t999 + t1006 - t1042 - t1050 - 0.19751789702565206228825776161588751761046270558698e-1 * t1094 + 0.11696446794910408141662685001236899248561775660981e1 * t1096 * t434 - 0.11696446794910408141662685001236899248561775660981e1 * t1101 * t1102 * t433 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1117 * t433 + 0.17315755899375863299672358916972966258900005419821e2 * t1123 * t1102 * t1125
  t1133 = t68 * t420
  t1148 = -t996 + t999 - t1006 + t1042 + t1050 + t68 * t1129 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1094 - 0.11696446794910408141662685001236899248561775660981e1 * t1133 * t443 + 0.11696446794910408141662685001236899248561775660981e1 * t441 * t1100 * t1102 * t433 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t424 * t1117 * t433 - 0.17315755899375863299672358916972966258900005419821e2 * t441 * t1122 * t1102 * t1125
  t1152 = f.my_piecewise3(t301, 0, t971 * t357 / 0.2e1 + t303 * t446 + t359 * t1148 / 0.2e1)
  t1158 = t40 * t18 * t783
  t1159 = 0.1e1 / t500 / t499 * t39 * t1158
  t1161 = t523 * t730
  t1162 = t522 * t1161
  t1164 = t19 * t730
  t1165 = t17 * t1164
  t1167 = t499 ** (-0.5e0)
  t1169 = t1167 * t39 * t1158
  t1171 = t530 * t1161
  t1174 = t41 * t18 * t783
  t1179 = 0.10000000000000000000000000000000000000000000000000e1 * t520 * (-0.42198333333333333333333333333333333333333333333333e0 * t1159 + 0.84396666666666666666666666666666666666666666666666e0 * t1162 + 0.39862222222222222222222222222222222222222222222223e0 * t1165 + 0.68258333333333333333333333333333333333333333333333e-1 * t1169 + 0.13651666666666666666666666666666666666666666666667e0 * t1171 + 0.13692777777777777777777777777777777777777777777778e0 * t1174) * t537
  t1180 = t518 ** 2
  t1183 = t536 ** 2
  t1184 = t511 ** 2
  t1188 = 0.16081824322151104821330931780901225435013347914188e2 * t517 / t1180 * t1183 / t1184
  t1189 = t27 ** 2
  t1190 = 0.1e1 / t1189
  t1196 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1190 * t741 + 0.4e1 / 0.3e1 * t27 * t724)
  t1197 = t304 ** 2
  t1198 = 0.1e1 / t1197
  t1204 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t1198 * t984 + 0.4e1 / 0.3e1 * t304 * t970)
  t1206 = (t1196 + t1204) * t67
  t1214 = 0.20000000000000000000000000000000000000000000000000e1 * t517 / t518 / t508 * t1183 * t537
  t1218 = 0.10843580882781524214666447553230042011687479519034e-1 * t549 * t17 * t497 * t641
  t1222 = 0.35616666666666666666666666666666666666666666666666e-1 * t20 * t103 * t519 * t538
  t1226 = 0.24415406715670879921742973310852762593515528885057e-3 * t634 * t523 * t730 * t575
  t1228 = t596 * t14 * t636
  t1232 = 0.14764770444444444444444444444444444444444444444444e-2 * t17 * t1164 * t512
  t1234 = 0.8e1 * t545 * t630
  t1239 = 0.20e2 * t582 / t543 / t9 * t579
  t1240 = t1179 + t1188 + 0.19751789702565206228825776161588751761046270558698e-1 * t1206 * t576 - t1214 + t1218 - t1152 - t1222 + t1226 - 0.36623110073506319882614459966279143890273293327586e-3 * t1228 - t1232 + t1234 + t1239
  t1243 = 0.12e2 * t541 * t544 * t579
  t1246 = 0.32e2 * t542 * t584 * t579
  t1257 = t609 ** 2
  t1271 = t602 ** 2
  t1274 = t559 ** 2
  t1287 = 0.1e1 / t617 / t571
  t1289 = t624 ** 2
  t1299 = -0.57538888888888888888888888888888888888888888888889e0 * t1159 + 0.11507777777777777777777777777777777777777777777778e1 * t1162 + 0.40256666666666666666666666666666666666666666666667e0 * t1165 + 0.36677500000000000000000000000000000000000000000000e-1 * t1169 + 0.73355000000000000000000000000000000000000000000000e-1 * t1171 + 0.13797500000000000000000000000000000000000000000000e0 * t1174
  t1303 = t617 ** 2
  t1304 = 0.1e1 / t1303
  t1306 = t574 ** 2
  t1307 = 0.1e1 / t1306
  t1311 = -0.70981924444444444444444444444444444444444444444442e-3 * t17 * t1164 * t560 - 0.34246666666666666666666666666666666666666666666666e-1 * t20 * t103 * t603 * t611 - 0.20000000000000000000000000000000000000000000000000e1 * t551 / t602 / t556 * t1257 * t610 + 0.99999999999999999999999999999999999999999999999999e0 * t604 * (-0.78438333333333333333333333333333333333333333333333e0 * t1159 + 0.15687666666666666666666666666666666666666666666667e1 * t1162 + 0.68863333333333333333333333333333333333333333333333e0 * t1165 + 0.14025833333333333333333333333333333333333333333333e0 * t1169 + 0.28051666666666666666666666666666666666666666666667e0 * t1171 + 0.17365833333333333333333333333333333333333333333333e0 * t1174) * t610 + 0.32164683177870697973624959794146027661627532968800e2 * t551 / t1271 * t1257 / t1274 + t1232 + t1222 + t1214 - t1179 - t1188 - 0.24415406715670879921742973310852762593515528885057e-3 * t17 * t1164 * t575 - 0.10843580882781524214666447553230042011687479519034e-1 * t20 * t103 * t618 * t626 - 0.11696446794910408141662685001236899248561775660981e1 * t566 * t1287 * t1289 * t625 + 0.58482233974552040708313425006184496242808878304903e0 * t619 * t1299 * t625 + 0.17315755899375863299672358916972966258900005419821e2 * t566 * t1304 * t1289 * t1307
  t1313 = t588 * t549 * t1311
  t1314 = t545 * t597
  t1316 = t585 * t597
  t1319 = 0.8e1 * t585 * t630
  t1323 = t588 * t596 * t629
  t1328 = 0.11696446794910408141662685001236899248561775660981e1 * t639 * t1287 * t1289 * t625
  t1332 = 0.17315755899375863299672358916972966258900005419821e2 * t639 * t1304 * t1289 * t1307
  t1336 = 0.58482233974552040708313425006184496242808878304903e0 * t639 * t618 * t1299 * t625
  t1338 = t596 * t566 * t641
  t1340 = t1243 - t1246 + t1313 + 0.8e1 * t1314 - 0.8e1 * t1316 - t1319 + t588 * t1206 * t578 + 0.2e1 * t1323 - t912 + t1328 - t1332 - t1336 - 0.11696446794910408141662685001236899248561775660981e1 * t1338
  t1349 = t923 * t659
  t1353 = t666 * t215 * t923
  t1356 = t690 * t917
  t1367 = t673 * t215 * t923
  t1370 = t697 * t917
  t1373 = t662 * t647
  t1381 = t712 * t215 * t923
  t1384 = t704 * t917
  t1387 = t669 * t656
  t1395 = 0.1e1 / t672 / t658
  t1403 = 0.29333333333333333333333333333333333333333333333333e-1 * t686 * t917 * t652 - 0.12800000000000000000000000000000000000000000000000e-3 * t646 * t215 * t1349 + 0.38400000000000000000000000000000000000000000000000e-6 * t648 * t1353 - 0.88000000000000000000000000000000000000000000000000e-4 * t648 * t1356 + 0.12800000000000000000000000000000000000000000000000e-3 * t655 * t215 * t1349 - 0.15360000000000000000000000000000000000000000000000e-5 * t694 * t1353 + 0.17600000000000000000000000000000000000000000000000e-3 * t694 * t1356 + 0.34560000000000000000000000000000000000000000000000e-8 * t657 * t1367 - 0.52800000000000000000000000000000000000000000000000e-6 * t657 * t1370 + 0.11520000000000000000000000000000000000000000000000e-5 * t1373 * t1353 - 0.10368000000000000000000000000000000000000000000000e-7 * t701 * t1367 + 0.79200000000000000000000000000000000000000000000000e-6 * t701 * t1370 + 0.20736000000000000000000000000000000000000000000000e-10 * t664 * t1381 - 0.23760000000000000000000000000000000000000000000000e-8 * t664 * t1384 + 0.69120000000000000000000000000000000000000000000000e-8 * t1387 * t1367 - 0.55296000000000000000000000000000000000000000000000e-10 * t708 * t1381 + 0.31680000000000000000000000000000000000000000000000e-8 * t708 * t1384 + 0.10368000000000000000000000000000000000000000000000e-12 * t671 * t1395 * t215 * t923 - 0.95040000000000000000000000000000000000000000000000e-11 * t671 * t713 * t917
  d11 = 0.2e1 * t248 + 0.2e1 * t296 + 0.2e1 * t495 + 0.2e1 * t677 + 0.2e1 * t718 + t3 * (t912 * t247 + 0.2e1 * t198 * t295 + t252 * t968 + t1152 * t494 + (t1240 + t1340) * t676 + 0.2e1 * t644 * t717 + t685 * t1403)
  t1407 = -t4 - t11
  t1408 = f.my_piecewise3(t7, 0, t1407)
  t1412 = f.my_piecewise3(t7, 0, -t109 * t1407 / 0.3e1)
  t1414 = t20 * t24 * t1412
  t1416 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t1414
  t1418 = 0.62182e-1 * t1416 * t55
  t1419 = -t123 + t1414
  t1420 = t122 * t1419
  t1423 = t129 * t1419
  t1425 = t29 * t1412
  t1427 = t42 * t46 * t1425
  t1429 = 0.18989250000000000000000000000000000000000000000000e1 * t1420 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t1414 + 0.30716250000000000000000000000000000000000000000000e0 * t1423 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t1427
  t1430 = t1429 * t143
  t1432 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1430
  t1434 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t1414
  t1441 = 0.35297250000000000000000000000000000000000000000000e1 * t1420 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t1414 + 0.63116250000000000000000000000000000000000000000000e0 * t1423 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t1427
  t1442 = t1441 * t162
  t1446 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t1414
  t1447 = t1446 * t92
  t1453 = 0.25892500000000000000000000000000000000000000000000e1 * t1420 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t1414 + 0.16504875000000000000000000000000000000000000000000e0 * t1423 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t1427
  t1454 = t1453 * t181
  t1462 = t172 * t1453 * t181
  t1465 = -t1418 + t1432 + t68 * (-0.31090e-1 * t1434 * t79 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t1442 + t1418 - t1432 - 0.19751789702565206228825776161588751761046270558698e-1 * t1447 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t1454) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1447 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t1462
  t1469 = f.my_piecewise3(t8, 0, t101 * t1465 / 0.2e1 + t1408 * t99 / 0.2e1)
  t1470 = t1469 * t247
  t1471 = -t1407
  t1472 = f.my_piecewise3(t300, 0, t1471)
  t1476 = f.my_piecewise3(t300, 0, -t364 * t1471 / 0.3e1)
  t1478 = t20 * t24 * t1476
  t1480 = -t362 + 0.53425000000000000000000000000000000000000000000000e-1 * t1478
  t1482 = 0.62182e-1 * t1480 * t324
  t1483 = -t378 + t1478
  t1484 = t377 * t1483
  t1487 = t384 * t1483
  t1489 = t306 * t1476
  t1491 = t42 * t46 * t1489
  t1493 = 0.18989250000000000000000000000000000000000000000000e1 * t1484 - t382 + 0.89690000000000000000000000000000000000000000000000e0 * t1478 + 0.30716250000000000000000000000000000000000000000000e0 * t1487 - t389 + 0.24647000000000000000000000000000000000000000000000e0 * t1491
  t1494 = t1493 * t395
  t1496 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t1494
  t1498 = -t399 + 0.51370000000000000000000000000000000000000000000000e-1 * t1478
  t1505 = 0.35297250000000000000000000000000000000000000000000e1 * t1484 - t408 + 0.15494250000000000000000000000000000000000000000000e1 * t1478 + 0.63116250000000000000000000000000000000000000000000e0 * t1487 - t411 + 0.31258500000000000000000000000000000000000000000000e0 * t1491
  t1506 = t1505 * t414
  t1510 = -t418 + 0.27812500000000000000000000000000000000000000000000e-1 * t1478
  t1511 = t1510 * t350
  t1517 = 0.25892500000000000000000000000000000000000000000000e1 * t1484 - t427 + 0.90577500000000000000000000000000000000000000000000e0 * t1478 + 0.16504875000000000000000000000000000000000000000000e0 * t1487 - t430 + 0.24835500000000000000000000000000000000000000000000e0 * t1491
  t1518 = t1517 * t433
  t1526 = t424 * t1517 * t433
  t1529 = -t1482 + t1496 + t68 * (-0.31090e-1 * t1498 * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t1506 + t1482 - t1496 - 0.19751789702565206228825776161588751761046270558698e-1 * t1511 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1518) + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1511 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t1526
  t1533 = f.my_piecewise3(t301, 0, t1472 * t357 / 0.2e1 + t359 * t1529 / 0.2e1)
  t1534 = t1533 * t494
  t1535 = t452 * r1
  t1537 = 0.1e1 / t454 / t1535
  t1541 = t200 * t464
  t1542 = t466 * t452
  t1545 = 0.1e1 / t453 / t1542 * t471
  t1550 = t214 * t475
  t1553 = 0.1e1 / t477 / r1 * t480
  t1558 = t226 * t484
  t1562 = 0.1e1 / t454 / t477 / t1535 * t490
  t1567 = t484 * s2
  t1568 = t236 * t1567
  t1573 = 0.1e1 / t489 / t459
  t1577 = -0.53333333333333333333333333333333333333333333333333e0 * t451 * t1537 * t460 + 0.10666666666666666666666666666666666666666666666667e0 * t1541 * t1545 - 0.21333333333333333333333333333333333333333333333333e0 * t465 * t1545 + 0.42666666666666666666666666666666666666666666666668e-1 * t1550 * t1553 - 0.64e-1 * t476 * t1553 + 0.12800000000000000000000000000000000000000000000000e-1 * t1558 * t1562 - 0.17066666666666666666666666666666666666666666666667e-1 * t485 * t1562 + 0.34133333333333333333333333333333333333333333333333e-2 * t1568 / t453 / t477 / t1542 * t1573
  t1578 = t684 * t1577
  t1581 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t1407)
  t1584 = f.my_piecewise3(t300, 0, 0.4e1 / 0.3e1 * t304 * t1471)
  t1586 = (t1581 + t1584) * t67
  t1587 = t1586 * t578
  t1591 = t515 + t540 - t581 - t587 + t588 * t1587 + t631 + 0.19751789702565206228825776161588751761046270558698e-1 * t1586 * t576 - t638 - t643 - t1469 - t1533
  t1592 = t1591 * t676
  t1593 = t646 * s2
  t1597 = t659 * s2
  t1598 = t1597 * t1537
  t1603 = t666 * s2
  t1604 = t1603 * t1537
  t1609 = t673 * s2
  t1610 = t1609 * t1537
  t1615 = t712 * s2
  t1619 = -0.80000000000000000000000000000000000000000000000000e-2 * t1593 * t1537 * t652 + 0.24000000000000000000000000000000000000000000000000e-4 * t648 * t1598 - 0.48000000000000000000000000000000000000000000000000e-4 * t694 * t1598 + 0.14400000000000000000000000000000000000000000000000e-6 * t657 * t1604 - 0.21600000000000000000000000000000000000000000000000e-6 * t701 * t1604 + 0.64800000000000000000000000000000000000000000000000e-9 * t664 * t1610 - 0.86400000000000000000000000000000000000000000000000e-9 * t708 * t1610 + 0.25920000000000000000000000000000000000000000000000e-11 * t671 * t1615 * t1537
  t1620 = t685 * t1619
  t1621 = 0.2e1 * t722
  t1622 = f.my_piecewise3(t7, 0, t1621)
  t1628 = t20 * t104 * t1412
  t1637 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t740 * t1407 * t12 - 0.2e1 / 0.3e1 * t109 * t2 * t721)
  t1639 = t20 * t24 * t1637
  t1643 = 0.62182e-1 * (t734 - 0.17808333333333333333333333333333333333333333333333e-1 * t736 - 0.17808333333333333333333333333333333333333333333333e-1 * t1628 + 0.53425000000000000000000000000000000000000000000000e-1 * t1639) * t55
  t1644 = t1416 * t120
  t1646 = 0.10000000000000000000000000000000000000000000000000e1 * t1644 * t144
  t1648 = 0.10000000000000000000000000000000000000000000000000e1 * t754 * t1430
  t1651 = 0.20000000000000000000000000000000000000000000000000e1 * t759 * t1430 * t142
  t1653 = t765 * t1419 * t124
  t1657 = t769 - t736 / 0.3e1 - t1628 / 0.3e1 + t1639
  t1658 = t122 * t1657
  t1664 = t777 * t1419 * t124
  t1666 = t129 * t1657
  t1670 = t42 * t134 * t1425
  t1674 = t42 * t46 * t112 * t1412
  t1678 = t42 * t46 * t29 * t1637
  t1680 = -0.94946250000000000000000000000000000000000000000000e0 * t1653 + 0.18989250000000000000000000000000000000000000000000e1 * t1658 + t774 - 0.29896666666666666666666666666666666666666666666667e0 * t736 - 0.29896666666666666666666666666666666666666666666667e0 * t1628 + 0.89690000000000000000000000000000000000000000000000e0 * t1639 + 0.15358125000000000000000000000000000000000000000000e0 * t1664 + 0.30716250000000000000000000000000000000000000000000e0 * t1666 + t787 - 0.16431333333333333333333333333333333333333333333333e0 * t789 - 0.16431333333333333333333333333333333333333333333333e0 * t1670 + 0.24647000000000000000000000000000000000000000000000e0 * t1674 + 0.24647000000000000000000000000000000000000000000000e0 * t1678
  t1683 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1680 * t143
  t1687 = 0.16081824322151104821330931780901225435013347914188e2 * t805 * t1429 * t807 * t142
  t1694 = t1434 * t153
  t1713 = -0.17648625000000000000000000000000000000000000000000e1 * t1653 + 0.35297250000000000000000000000000000000000000000000e1 * t1658 + t829 - 0.51647500000000000000000000000000000000000000000000e0 * t736 - 0.51647500000000000000000000000000000000000000000000e0 * t1628 + 0.15494250000000000000000000000000000000000000000000e1 * t1639 + 0.31558125000000000000000000000000000000000000000000e0 * t1664 + 0.63116250000000000000000000000000000000000000000000e0 * t1666 + t834 - 0.20839000000000000000000000000000000000000000000000e0 * t789 - 0.20839000000000000000000000000000000000000000000000e0 * t1670 + 0.31258500000000000000000000000000000000000000000000e0 * t1674 + 0.31258500000000000000000000000000000000000000000000e0 * t1678
  t1725 = (t850 - 0.92708333333333333333333333333333333333333333333333e-2 * t736 - 0.92708333333333333333333333333333333333333333333333e-2 * t1628 + 0.27812500000000000000000000000000000000000000000000e-1 * t1639) * t92
  t1727 = t1446 * t172
  t1746 = -0.12946250000000000000000000000000000000000000000000e1 * t1653 + 0.25892500000000000000000000000000000000000000000000e1 * t1658 + t868 - 0.30192500000000000000000000000000000000000000000000e0 * t736 - 0.30192500000000000000000000000000000000000000000000e0 * t1628 + 0.90577500000000000000000000000000000000000000000000e0 * t1639 + 0.82524375000000000000000000000000000000000000000000e-1 * t1664 + 0.16504875000000000000000000000000000000000000000000e0 * t1666 + t873 - 0.16557000000000000000000000000000000000000000000000e0 * t789 - 0.16557000000000000000000000000000000000000000000000e0 * t1670 + 0.24835500000000000000000000000000000000000000000000e0 * t1674 + 0.24835500000000000000000000000000000000000000000000e0 * t1678
  t1754 = -0.31090e-1 * (t811 - 0.17123333333333333333333333333333333333333333333333e-1 * t736 - 0.17123333333333333333333333333333333333333333333333e-1 * t1628 + 0.51370000000000000000000000000000000000000000000000e-1 * t1639) * t79 + 0.99999999999999999999999999999999999999999999999999e0 * t1694 * t163 + 0.99999999999999999999999999999999999999999999999999e0 * t817 * t1442 - 0.20000000000000000000000000000000000000000000000000e1 * t822 * t1442 * t161 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t1713 * t162 + 0.32164683177870697973624959794146027661627532968800e2 * t844 * t1441 * t846 * t161 + t1643 - t1646 - t1648 + t1651 - t1683 - t1687 - 0.19751789702565206228825776161588751761046270558698e-1 * t1725 + 0.58482233974552040708313425006184496242808878304903e0 * t1727 * t182 + 0.58482233974552040708313425006184496242808878304903e0 * t856 * t1454 - 0.11696446794910408141662685001236899248561775660981e1 * t861 * t1454 * t180 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t1746 * t181 + 0.17315755899375863299672358916972966258900005419821e2 * t883 * t1453 * t885 * t180
  t1758 = t68 * t1446
  t1776 = -t1643 + t1646 + t1648 - t1651 + t1683 + t1687 + t68 * t1754 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1725 - 0.58482233974552040708313425006184496242808878304903e0 * t1758 * t191 - 0.58482233974552040708313425006184496242808878304903e0 * t893 * t1462 + 0.11696446794910408141662685001236899248561775660981e1 * t189 * t860 * t1453 * t182 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t172 * t1746 * t181 - 0.17315755899375863299672358916972966258900005419821e2 * t189 * t882 * t1453 * t885 * t180
  t1780 = f.my_piecewise3(t8, 0, t101 * t1776 / 0.2e1 + t13 * t1465 / 0.2e1 + t1408 * t194 / 0.2e1 + t1622 * t99 / 0.2e1)
  t1783 = f.my_piecewise3(t300, 0, -t1621)
  t1789 = t20 * t104 * t1476
  t1798 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t983 * t1471 * t302 + 0.2e1 / 0.3e1 * t364 * t2 * t721)
  t1800 = t20 * t24 * t1798
  t1804 = 0.62182e-1 * (t977 - 0.17808333333333333333333333333333333333333333333333e-1 * t979 - 0.17808333333333333333333333333333333333333333333333e-1 * t1789 + 0.53425000000000000000000000000000000000000000000000e-1 * t1800) * t324
  t1805 = t1480 * t375
  t1807 = 0.10000000000000000000000000000000000000000000000000e1 * t1805 * t396
  t1809 = 0.10000000000000000000000000000000000000000000000000e1 * t997 * t1494
  t1812 = 0.20000000000000000000000000000000000000000000000000e1 * t1002 * t1494 * t394
  t1814 = t1008 * t1483 * t379
  t1818 = t1012 - t979 / 0.3e1 - t1789 / 0.3e1 + t1800
  t1819 = t377 * t1818
  t1825 = t1020 * t1483 * t379
  t1827 = t384 * t1818
  t1831 = t42 * t134 * t1489
  t1835 = t42 * t46 * t367 * t1476
  t1839 = t42 * t46 * t306 * t1798
  t1841 = -0.94946250000000000000000000000000000000000000000000e0 * t1814 + 0.18989250000000000000000000000000000000000000000000e1 * t1819 + t1017 - 0.29896666666666666666666666666666666666666666666667e0 * t979 - 0.29896666666666666666666666666666666666666666666667e0 * t1789 + 0.89690000000000000000000000000000000000000000000000e0 * t1800 + 0.15358125000000000000000000000000000000000000000000e0 * t1825 + 0.30716250000000000000000000000000000000000000000000e0 * t1827 + t1027 - 0.16431333333333333333333333333333333333333333333333e0 * t1029 - 0.16431333333333333333333333333333333333333333333333e0 * t1831 + 0.24647000000000000000000000000000000000000000000000e0 * t1835 + 0.24647000000000000000000000000000000000000000000000e0 * t1839
  t1844 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t1841 * t395
  t1848 = 0.16081824322151104821330931780901225435013347914188e2 * t1045 * t1493 * t1047 * t394
  t1855 = t1498 * t405
  t1874 = -0.17648625000000000000000000000000000000000000000000e1 * t1814 + 0.35297250000000000000000000000000000000000000000000e1 * t1819 + t1069 - 0.51647500000000000000000000000000000000000000000000e0 * t979 - 0.51647500000000000000000000000000000000000000000000e0 * t1789 + 0.15494250000000000000000000000000000000000000000000e1 * t1800 + 0.31558125000000000000000000000000000000000000000000e0 * t1825 + 0.63116250000000000000000000000000000000000000000000e0 * t1827 + t1074 - 0.20839000000000000000000000000000000000000000000000e0 * t1029 - 0.20839000000000000000000000000000000000000000000000e0 * t1831 + 0.31258500000000000000000000000000000000000000000000e0 * t1835 + 0.31258500000000000000000000000000000000000000000000e0 * t1839
  t1886 = (t1090 - 0.92708333333333333333333333333333333333333333333333e-2 * t979 - 0.92708333333333333333333333333333333333333333333333e-2 * t1789 + 0.27812500000000000000000000000000000000000000000000e-1 * t1800) * t350
  t1888 = t1510 * t424
  t1907 = -0.12946250000000000000000000000000000000000000000000e1 * t1814 + 0.25892500000000000000000000000000000000000000000000e1 * t1819 + t1108 - 0.30192500000000000000000000000000000000000000000000e0 * t979 - 0.30192500000000000000000000000000000000000000000000e0 * t1789 + 0.90577500000000000000000000000000000000000000000000e0 * t1800 + 0.82524375000000000000000000000000000000000000000000e-1 * t1825 + 0.16504875000000000000000000000000000000000000000000e0 * t1827 + t1113 - 0.16557000000000000000000000000000000000000000000000e0 * t1029 - 0.16557000000000000000000000000000000000000000000000e0 * t1831 + 0.24835500000000000000000000000000000000000000000000e0 * t1835 + 0.24835500000000000000000000000000000000000000000000e0 * t1839
  t1915 = -0.31090e-1 * (t1051 - 0.17123333333333333333333333333333333333333333333333e-1 * t979 - 0.17123333333333333333333333333333333333333333333333e-1 * t1789 + 0.51370000000000000000000000000000000000000000000000e-1 * t1800) * t337 + 0.99999999999999999999999999999999999999999999999999e0 * t1855 * t415 + 0.99999999999999999999999999999999999999999999999999e0 * t1057 * t1506 - 0.20000000000000000000000000000000000000000000000000e1 * t1062 * t1506 * t413 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t1874 * t414 + 0.32164683177870697973624959794146027661627532968800e2 * t1084 * t1505 * t1086 * t413 + t1804 - t1807 - t1809 + t1812 - t1844 - t1848 - 0.19751789702565206228825776161588751761046270558698e-1 * t1886 + 0.58482233974552040708313425006184496242808878304903e0 * t1888 * t434 + 0.58482233974552040708313425006184496242808878304903e0 * t1096 * t1518 - 0.11696446794910408141662685001236899248561775660981e1 * t1101 * t1518 * t432 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1907 * t433 + 0.17315755899375863299672358916972966258900005419821e2 * t1123 * t1517 * t1125 * t432
  t1919 = t68 * t1510
  t1937 = -t1804 + t1807 + t1809 - t1812 + t1844 + t1848 + t68 * t1915 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t1886 - 0.58482233974552040708313425006184496242808878304903e0 * t1919 * t443 - 0.58482233974552040708313425006184496242808878304903e0 * t1133 * t1526 + 0.11696446794910408141662685001236899248561775660981e1 * t441 * t1100 * t1517 * t434 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t424 * t1907 * t433 - 0.17315755899375863299672358916972966258900005419821e2 * t441 * t1122 * t1517 * t1125 * t432
  t1941 = f.my_piecewise3(t301, 0, t1472 * t446 / 0.2e1 + t303 * t1529 / 0.2e1 + t1783 * t357 / 0.2e1 + t359 * t1937 / 0.2e1)
  t1945 = t1586 * t566 * t641
  t1948 = t1586 * t14 * t636
  t1957 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1190 * t1407 * t12 + 0.8e1 / 0.3e1 * t27 * t2 * t721)
  t1965 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t1198 * t1471 * t302 - 0.8e1 / 0.3e1 * t304 * t2 * t721)
  t1967 = (t1957 + t1965) * t67
  t1971 = t1179 + t1188 - t1214 + t1218 - 0.58482233974552040708313425006184496242808878304903e0 * t1945 - 0.18311555036753159941307229983139571945136646663793e-3 * t1948 + 0.19751789702565206228825776161588751761046270558698e-1 * t1967 * t576 - t1222 + t1226 - 0.18311555036753159941307229983139571945136646663793e-3 * t1228 - t1232 - t1780 - t1941 + t1239
  t1974 = t588 * t1586 * t629
  t1977 = t545 * t1587
  t1979 = t585 * t1587
  t1983 = -t1243 + t1313 - 0.4e1 * t1314 + t1974 + t588 * t1967 * t578 + 0.4e1 * t1977 - 0.4e1 * t1979 - 0.4e1 * t1316 - t1319 + t1323 + t1328 - t1332 - t1336 - 0.58482233974552040708313425006184496242808878304903e0 * t1338
  t1994 = s2 * t1537 * s0 * t255
  t2025 = -0.12800000000000000000000000000000000000000000000000e-3 * t1593 * t1537 * t691 + 0.38400000000000000000000000000000000000000000000000e-6 * t648 * t666 * t1994 + 0.12800000000000000000000000000000000000000000000000e-3 * t655 * s0 * t255 * t1598 - 0.15360000000000000000000000000000000000000000000000e-5 * t694 * t666 * t1994 + 0.34560000000000000000000000000000000000000000000000e-8 * t657 * t673 * t1994 + 0.11520000000000000000000000000000000000000000000000e-5 * t1373 * t666 * t1994 - 0.10368000000000000000000000000000000000000000000000e-7 * t701 * t673 * t1994 + 0.20736000000000000000000000000000000000000000000000e-10 * t664 * t712 * t1994 + 0.69120000000000000000000000000000000000000000000000e-8 * t1387 * t673 * t1994 - 0.55296000000000000000000000000000000000000000000000e-10 * t708 * t712 * t1994 + 0.10368000000000000000000000000000000000000000000000e-12 * t671 * t1395 * t1994
  d12 = t248 + t296 + t495 + t677 + t718 + t1470 + t1534 + t1578 + t1592 + t1620 + t3 * (t1780 * t247 + t1469 * t295 + t1941 * t494 + t450 * t1577 + (t1971 + t1983) * t676 + t1591 * t717 + t644 * t1619 + t685 * t2025)
  t2035 = 0.2e1 * t10 + 0.2e1 * t722
  t2036 = f.my_piecewise3(t7, 0, t2035)
  t2041 = t1407 ** 2
  t2047 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t740 * t2041 - t109 * t2035 / 0.3e1)
  t2049 = t20 * t24 * t2047
  t2053 = 0.62182e-1 * (t734 - 0.35616666666666666666666666666666666666666666666666e-1 * t1628 + 0.53425000000000000000000000000000000000000000000000e-1 * t2049) * t55
  t2055 = 0.20000000000000000000000000000000000000000000000000e1 * t1644 * t1430
  t2056 = t1429 ** 2
  t2059 = 0.20000000000000000000000000000000000000000000000000e1 * t759 * t2056 * t143
  t2060 = t1419 ** 2
  t2061 = t765 * t2060
  t2064 = t769 - 0.2e1 / 0.3e1 * t1628 + t2049
  t2065 = t122 * t2064
  t2069 = t777 * t2060
  t2071 = t129 * t2064
  t2074 = t1412 ** 2
  t2076 = t42 * t46 * t2074
  t2080 = t42 * t46 * t29 * t2047
  t2082 = -0.94946250000000000000000000000000000000000000000000e0 * t2061 + 0.18989250000000000000000000000000000000000000000000e1 * t2065 + t774 - 0.59793333333333333333333333333333333333333333333334e0 * t1628 + 0.89690000000000000000000000000000000000000000000000e0 * t2049 + 0.15358125000000000000000000000000000000000000000000e0 * t2069 + 0.30716250000000000000000000000000000000000000000000e0 * t2071 + t787 - 0.32862666666666666666666666666666666666666666666666e0 * t1670 + 0.24647000000000000000000000000000000000000000000000e0 * t2076 + 0.24647000000000000000000000000000000000000000000000e0 * t2080
  t2085 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t2082 * t143
  t2088 = 0.16081824322151104821330931780901225435013347914188e2 * t805 * t2056 * t807
  t2096 = t1441 ** 2
  t2109 = -0.17648625000000000000000000000000000000000000000000e1 * t2061 + 0.35297250000000000000000000000000000000000000000000e1 * t2065 + t829 - 0.10329500000000000000000000000000000000000000000000e1 * t1628 + 0.15494250000000000000000000000000000000000000000000e1 * t2049 + 0.31558125000000000000000000000000000000000000000000e0 * t2069 + 0.63116250000000000000000000000000000000000000000000e0 * t2071 + t834 - 0.41678000000000000000000000000000000000000000000000e0 * t1670 + 0.31258500000000000000000000000000000000000000000000e0 * t2076 + 0.31258500000000000000000000000000000000000000000000e0 * t2080
  t2119 = (t850 - 0.18541666666666666666666666666666666666666666666667e-1 * t1628 + 0.27812500000000000000000000000000000000000000000000e-1 * t2049) * t92
  t2123 = t1453 ** 2
  t2136 = -0.12946250000000000000000000000000000000000000000000e1 * t2061 + 0.25892500000000000000000000000000000000000000000000e1 * t2065 + t868 - 0.60385000000000000000000000000000000000000000000000e0 * t1628 + 0.90577500000000000000000000000000000000000000000000e0 * t2049 + 0.82524375000000000000000000000000000000000000000000e-1 * t2069 + 0.16504875000000000000000000000000000000000000000000e0 * t2071 + t873 - 0.33114000000000000000000000000000000000000000000000e0 * t1670 + 0.24835500000000000000000000000000000000000000000000e0 * t2076 + 0.24835500000000000000000000000000000000000000000000e0 * t2080
  t2143 = -0.31090e-1 * (t811 - 0.34246666666666666666666666666666666666666666666666e-1 * t1628 + 0.51370000000000000000000000000000000000000000000000e-1 * t2049) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t1694 * t1442 - 0.20000000000000000000000000000000000000000000000000e1 * t822 * t2096 * t162 + 0.99999999999999999999999999999999999999999999999999e0 * t154 * t2109 * t162 + 0.32164683177870697973624959794146027661627532968800e2 * t844 * t2096 * t846 + t2053 - t2055 + t2059 - t2085 - t2088 - 0.19751789702565206228825776161588751761046270558698e-1 * t2119 + 0.11696446794910408141662685001236899248561775660981e1 * t1727 * t1454 - 0.11696446794910408141662685001236899248561775660981e1 * t861 * t2123 * t181 + 0.58482233974552040708313425006184496242808878304903e0 * t173 * t2136 * t181 + 0.17315755899375863299672358916972966258900005419821e2 * t883 * t2123 * t885
  t2161 = -t2053 + t2055 - t2059 + t2085 + t2088 + t68 * t2143 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t2119 - 0.11696446794910408141662685001236899248561775660981e1 * t1758 * t1462 + 0.11696446794910408141662685001236899248561775660981e1 * t189 * t860 * t2123 * t181 - 0.58482233974552040708313425006184496242808878304903e0 * t189 * t172 * t2136 * t181 - 0.17315755899375863299672358916972966258900005419821e2 * t189 * t882 * t2123 * t885
  t2165 = f.my_piecewise3(t8, 0, t2036 * t99 / 0.2e1 + t1408 * t1465 + t101 * t2161 / 0.2e1)
  t2167 = -t2035
  t2168 = f.my_piecewise3(t300, 0, t2167)
  t2173 = t1471 ** 2
  t2179 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t983 * t2173 - t364 * t2167 / 0.3e1)
  t2181 = t20 * t24 * t2179
  t2185 = 0.62182e-1 * (t977 - 0.35616666666666666666666666666666666666666666666666e-1 * t1789 + 0.53425000000000000000000000000000000000000000000000e-1 * t2181) * t324
  t2187 = 0.20000000000000000000000000000000000000000000000000e1 * t1805 * t1494
  t2188 = t1493 ** 2
  t2191 = 0.20000000000000000000000000000000000000000000000000e1 * t1002 * t2188 * t395
  t2192 = t1483 ** 2
  t2193 = t1008 * t2192
  t2196 = t1012 - 0.2e1 / 0.3e1 * t1789 + t2181
  t2197 = t377 * t2196
  t2201 = t1020 * t2192
  t2203 = t384 * t2196
  t2206 = t1476 ** 2
  t2208 = t42 * t46 * t2206
  t2212 = t42 * t46 * t306 * t2179
  t2214 = -0.94946250000000000000000000000000000000000000000000e0 * t2193 + 0.18989250000000000000000000000000000000000000000000e1 * t2197 + t1017 - 0.59793333333333333333333333333333333333333333333334e0 * t1789 + 0.89690000000000000000000000000000000000000000000000e0 * t2181 + 0.15358125000000000000000000000000000000000000000000e0 * t2201 + 0.30716250000000000000000000000000000000000000000000e0 * t2203 + t1027 - 0.32862666666666666666666666666666666666666666666666e0 * t1831 + 0.24647000000000000000000000000000000000000000000000e0 * t2208 + 0.24647000000000000000000000000000000000000000000000e0 * t2212
  t2217 = 0.10000000000000000000000000000000000000000000000000e1 * t376 * t2214 * t395
  t2220 = 0.16081824322151104821330931780901225435013347914188e2 * t1045 * t2188 * t1047
  t2228 = t1505 ** 2
  t2241 = -0.17648625000000000000000000000000000000000000000000e1 * t2193 + 0.35297250000000000000000000000000000000000000000000e1 * t2197 + t1069 - 0.10329500000000000000000000000000000000000000000000e1 * t1789 + 0.15494250000000000000000000000000000000000000000000e1 * t2181 + 0.31558125000000000000000000000000000000000000000000e0 * t2201 + 0.63116250000000000000000000000000000000000000000000e0 * t2203 + t1074 - 0.41678000000000000000000000000000000000000000000000e0 * t1831 + 0.31258500000000000000000000000000000000000000000000e0 * t2208 + 0.31258500000000000000000000000000000000000000000000e0 * t2212
  t2251 = (t1090 - 0.18541666666666666666666666666666666666666666666667e-1 * t1789 + 0.27812500000000000000000000000000000000000000000000e-1 * t2181) * t350
  t2255 = t1517 ** 2
  t2268 = -0.12946250000000000000000000000000000000000000000000e1 * t2193 + 0.25892500000000000000000000000000000000000000000000e1 * t2197 + t1108 - 0.60385000000000000000000000000000000000000000000000e0 * t1789 + 0.90577500000000000000000000000000000000000000000000e0 * t2181 + 0.82524375000000000000000000000000000000000000000000e-1 * t2201 + 0.16504875000000000000000000000000000000000000000000e0 * t2203 + t1113 - 0.33114000000000000000000000000000000000000000000000e0 * t1831 + 0.24835500000000000000000000000000000000000000000000e0 * t2208 + 0.24835500000000000000000000000000000000000000000000e0 * t2212
  t2275 = -0.31090e-1 * (t1051 - 0.34246666666666666666666666666666666666666666666666e-1 * t1789 + 0.51370000000000000000000000000000000000000000000000e-1 * t2181) * t337 + 0.20000000000000000000000000000000000000000000000000e1 * t1855 * t1506 - 0.20000000000000000000000000000000000000000000000000e1 * t1062 * t2228 * t414 + 0.99999999999999999999999999999999999999999999999999e0 * t406 * t2241 * t414 + 0.32164683177870697973624959794146027661627532968800e2 * t1084 * t2228 * t1086 + t2185 - t2187 + t2191 - t2217 - t2220 - 0.19751789702565206228825776161588751761046270558698e-1 * t2251 + 0.11696446794910408141662685001236899248561775660981e1 * t1888 * t1518 - 0.11696446794910408141662685001236899248561775660981e1 * t1101 * t2255 * t433 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t2268 * t433 + 0.17315755899375863299672358916972966258900005419821e2 * t1123 * t2255 * t1125
  t2293 = -t2185 + t2187 - t2191 + t2217 + t2220 + t68 * t2275 + 0.19751789702565206228825776161588751761046270558698e-1 * t68 * t2251 - 0.11696446794910408141662685001236899248561775660981e1 * t1919 * t1526 + 0.11696446794910408141662685001236899248561775660981e1 * t441 * t1100 * t2255 * t433 - 0.58482233974552040708313425006184496242808878304903e0 * t441 * t424 * t2268 * t433 - 0.17315755899375863299672358916972966258900005419821e2 * t441 * t1122 * t2255 * t1125
  t2297 = f.my_piecewise3(t301, 0, t2168 * t357 / 0.2e1 + t1472 * t1529 + t359 * t2293 / 0.2e1)
  t2302 = 0.1e1 / t454 / t466
  t2306 = t466 * t1535
  t2308 = 0.1e1 / t453 / t2306
  t2309 = t2308 * t471
  t2314 = 0.1e1 / t486 * t480
  t2325 = 0.1e1 / t454 / t477 / t466 * t490
  t2336 = 0.1e1 / t453 / t477 / t2306 * t1573
  t2345 = t477 ** 2
  t2353 = 0.19555555555555555555555555555555555555555555555555e1 * t451 * t2302 * t460 - 0.96000000000000000000000000000000000000000000000002e0 * t1541 * t2309 + 0.11377777777777777777777777777777777777777777777778e0 * t200 * t475 * t2314 + 0.13511111111111111111111111111111111111111111111111e1 * t465 * t2309 - 0.61155555555555555555555555555555555555555555555557e0 * t1550 * t2314 + 0.68266666666666666666666666666666666666666666666669e-1 * t214 * t484 * t2325 + 0.576e0 * t476 * t2314 - 0.25173333333333333333333333333333333333333333333333e0 * t1558 * t2325 + 0.27306666666666666666666666666666666666666666666666e-1 * t226 * t1567 * t2336 + 0.19911111111111111111111111111111111111111111111112e0 * t485 * t2325 - 0.85333333333333333333333333333333333333333333333333e-1 * t1568 * t2336 + 0.91022222222222222222222222222222222222222222222219e-2 * t236 * t484 * t464 / t2345 / t452 / t489 / t470
  t2362 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1190 * t2041 + 0.4e1 / 0.3e1 * t27 * t2035)
  t2368 = f.my_piecewise3(t300, 0, 0.4e1 / 0.9e1 * t1198 * t2173 + 0.4e1 / 0.3e1 * t304 * t2167)
  t2370 = (t2362 + t2368) * t67
  t2373 = t1179 + t1188 - t1214 - t2297 - t2165 + t1218 - 0.11696446794910408141662685001236899248561775660981e1 * t1945 - 0.36623110073506319882614459966279143890273293327586e-3 * t1948 - t1222 + t1226 + t588 * t2370 * t578 - t1232
  t2379 = 0.19751789702565206228825776161588751761046270558698e-1 * t2370 * t576 - t1234 + t1239 + t1243 + t1246 + t1313 + 0.2e1 * t1974 - 0.8e1 * t1977 - 0.8e1 * t1979 - t1319 + t1328 - t1332 - t1336
  t2388 = t2308 * t659
  t2392 = t666 * t464 * t2308
  t2395 = t1597 * t2302
  t2406 = t673 * t464 * t2308
  t2409 = t1603 * t2302
  t2419 = t712 * t464 * t2308
  t2422 = t1609 * t2302
  t2438 = 0.29333333333333333333333333333333333333333333333333e-1 * t1593 * t2302 * t652 - 0.12800000000000000000000000000000000000000000000000e-3 * t646 * t464 * t2388 + 0.38400000000000000000000000000000000000000000000000e-6 * t648 * t2392 - 0.88000000000000000000000000000000000000000000000000e-4 * t648 * t2395 + 0.12800000000000000000000000000000000000000000000000e-3 * t655 * t464 * t2388 - 0.15360000000000000000000000000000000000000000000000e-5 * t694 * t2392 + 0.17600000000000000000000000000000000000000000000000e-3 * t694 * t2395 + 0.34560000000000000000000000000000000000000000000000e-8 * t657 * t2406 - 0.52800000000000000000000000000000000000000000000000e-6 * t657 * t2409 + 0.11520000000000000000000000000000000000000000000000e-5 * t1373 * t2392 - 0.10368000000000000000000000000000000000000000000000e-7 * t701 * t2406 + 0.79200000000000000000000000000000000000000000000000e-6 * t701 * t2409 + 0.20736000000000000000000000000000000000000000000000e-10 * t664 * t2419 - 0.23760000000000000000000000000000000000000000000000e-8 * t664 * t2422 + 0.69120000000000000000000000000000000000000000000000e-8 * t1387 * t2406 - 0.55296000000000000000000000000000000000000000000000e-10 * t708 * t2419 + 0.31680000000000000000000000000000000000000000000000e-8 * t708 * t2422 + 0.10368000000000000000000000000000000000000000000000e-12 * t671 * t1395 * t464 * t2308 - 0.95040000000000000000000000000000000000000000000000e-11 * t671 * t1615 * t2302
  d22 = 0.2e1 * t1470 + 0.2e1 * t1534 + 0.2e1 * t1578 + 0.2e1 * t1592 + 0.2e1 * t1620 + t3 * (t2165 * t247 + t2297 * t494 + 0.2e1 * t1533 * t1577 + t684 * t2353 + (t2373 + t2379) * t676 + 0.2e1 * t1591 * t1619 + t685 * t2438)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

