"""Generated from gga_c_gapc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_par1 = np.array([np.nan, 0.0471985, 1.49676, 0.00179054, -0.0324091, 0.00999978, -0.00193483, 0.000179118, -6.15798e-06, 0.015545, 0.064535], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  gap_par_a = 30

  gap_t = lambda rs, z, xt: xt * f.n_total(rs) ** (1 / 6) / (4 * f.mphi(z) * (3 / jnp.pi) ** (1 / 6))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gap_H = lambda rs, t, par: (gap_par_a + par[9] * rs * jnp.log(rs) * t ** 2 / f.beta_Hu_Langreth(rs)) / (gap_par_a + t ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  gap_G = lambda rs, z, xt, par: +f.mphi(z) ** 3 * f.beta_Hu_Langreth(rs) * gap_t(rs, z, xt) ** 2 * gap_H(rs, gap_t(rs, z, xt), par) / (gap_c1(rs, z, par) - gap_c2(rs, z, par) * f_pw(rs, z))

  gap_eps = lambda rs, z, xt, par: +(f_pw(rs, z) + gap_c1(rs, z, par) * gap_G(rs, z, xt, par)) / (1 + gap_c2(rs, z, par) * gap_G(rs, z, xt, par) + gap_c3(rs, z, par) * gap_G(rs, z, xt, par) ** 2)

  f_gap = lambda rs, z, xt: +gap_eps(rs, 0, xt, gap_par0) + f.f_zeta(z) * (gap_eps(rs, 1, xt, gap_par1) - gap_eps(rs, 0, xt, gap_par0))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_gap(rs, z, xt)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_par1 = np.array([np.nan, 0.0471985, 1.49676, 0.00179054, -0.0324091, 0.00999978, -0.00193483, 0.000179118, -6.15798e-06, 0.015545, 0.064535], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  gap_par_a = 30

  gap_t = lambda rs, z, xt: xt * f.n_total(rs) ** (1 / 6) / (4 * f.mphi(z) * (3 / jnp.pi) ** (1 / 6))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gap_H = lambda rs, t, par: (gap_par_a + par[9] * rs * jnp.log(rs) * t ** 2 / f.beta_Hu_Langreth(rs)) / (gap_par_a + t ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  gap_G = lambda rs, z, xt, par: +f.mphi(z) ** 3 * f.beta_Hu_Langreth(rs) * gap_t(rs, z, xt) ** 2 * gap_H(rs, gap_t(rs, z, xt), par) / (gap_c1(rs, z, par) - gap_c2(rs, z, par) * f_pw(rs, z))

  gap_eps = lambda rs, z, xt, par: +(f_pw(rs, z) + gap_c1(rs, z, par) * gap_G(rs, z, xt, par)) / (1 + gap_c2(rs, z, par) * gap_G(rs, z, xt, par) + gap_c3(rs, z, par) * gap_G(rs, z, xt, par) ** 2)

  f_gap = lambda rs, z, xt: +gap_eps(rs, 0, xt, gap_par0) + f.f_zeta(z) * (gap_eps(rs, 1, xt, gap_par1) - gap_eps(rs, 0, xt, gap_par0))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_gap(rs, z, xt)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_par1 = np.array([np.nan, 0.0471985, 1.49676, 0.00179054, -0.0324091, 0.00999978, -0.00193483, 0.000179118, -6.15798e-06, 0.015545, 0.064535], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  gap_par_a = 30

  gap_t = lambda rs, z, xt: xt * f.n_total(rs) ** (1 / 6) / (4 * f.mphi(z) * (3 / jnp.pi) ** (1 / 6))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gap_H = lambda rs, t, par: (gap_par_a + par[9] * rs * jnp.log(rs) * t ** 2 / f.beta_Hu_Langreth(rs)) / (gap_par_a + t ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  gap_G = lambda rs, z, xt, par: +f.mphi(z) ** 3 * f.beta_Hu_Langreth(rs) * gap_t(rs, z, xt) ** 2 * gap_H(rs, gap_t(rs, z, xt), par) / (gap_c1(rs, z, par) - gap_c2(rs, z, par) * f_pw(rs, z))

  gap_eps = lambda rs, z, xt, par: +(f_pw(rs, z) + gap_c1(rs, z, par) * gap_G(rs, z, xt, par)) / (1 + gap_c2(rs, z, par) * gap_G(rs, z, xt, par) + gap_c3(rs, z, par) * gap_G(rs, z, xt, par) ** 2)

  f_gap = lambda rs, z, xt: +gap_eps(rs, 0, xt, gap_par0) + f.f_zeta(z) * (gap_eps(rs, 1, xt, gap_par1) - gap_eps(rs, 0, xt, gap_par0))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_gap(rs, z, xt)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t13 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t23 = 0.1e1 / t22
  t25 = t21 * t5 * t23
  t27 = 0.23615790870000000000000000000000000000000000000000e0 * t14 + 0.55771035800000000000000000000000000000000000000000e-1 * t11 + 0.12733319050000000000000000000000000000000000000000e-1 * t17 + 0.76629987700000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = 0.1e1 <= f.p.zeta_threshold
  t33 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = t33 * f.p.zeta_threshold
  t35 = f.my_piecewise3(t32, t34, 1)
  t38 = 2 ** (0.1e1 / 0.3e1)
  t41 = 0.1e1 / (0.2e1 * t38 - 0.2e1)
  t42 = (0.2e1 * t35 - 0.2e1) * t41
  t44 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t11
  t49 = 0.17489865900000000000000000000000000000000000000000e0 * t14 + 0.30591644850000000000000000000000000000000000000000e-1 * t11 + 0.37162376550000000000000000000000000000000000000000e-2 * t17 + 0.41939708850000000000000000000000000000000000000000e-2 * t25
  t51 = 0.1e1 + 0.1e1 / t49
  t52 = jnp.log(t51)
  t53 = t44 * t52
  t54 = t42 * t53
  t55 = 0.58482233974552040708313425006184496242808878304904e0 * t54
  t56 = jnp.pi * t6
  t58 = 0.1e1 / t22 / t7
  t59 = t56 * t58
  t60 = 0.1e1 / t7
  t61 = t2 * t60
  t64 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t14 + 0.12382500000000000000000000000000000000000000000000e-1 * t11
  t67 = 0.1e1 + t14 * t64 / 0.2e1
  t68 = t67 ** 2
  t69 = 0.1e1 / t68
  t72 = -t31 + t55
  t75 = t1 * t3 * t2
  t77 = 0.1e1 / t8 / t7
  t78 = t6 * t77
  t79 = t75 * t78
  t82 = t19 * t20 * t2
  t83 = t5 * t58
  t84 = t82 * t83
  t86 = jnp.pi ** 2
  t87 = 0.1e1 / t86
  t88 = t7 ** 2
  t89 = 0.1e1 / t88
  t90 = t87 * t89
  t93 = t1 * t3 * t87
  t95 = 0.1e1 / t8 / t88
  t96 = t6 * t95
  t97 = t93 * t96
  t99 = -0.18780000000000000000000000000000000000000000000000e-1 * t61 + 0.13173750000000000000000000000000000000000000000000e-2 * t79 - 0.23775000000000000000000000000000000000000000000000e-3 * t84 + 0.63900000000000000000000000000000000000000000000000e-4 * t90 - 0.54014062500000000000000000000000000000000000000000e-6 * t97
  t101 = 0.36798313500000000000000000000000000000000000000000e-2 * t61 * t69 - t72 * t99
  t102 = 0.1e1 / t20
  t103 = t1 * t102
  t104 = 4 ** (0.1e1 / 0.6e1)
  t105 = t103 * t104
  t106 = t14 * t11
  t107 = t22 * t106
  t108 = 0.1e1 / t67
  t112 = t72 ** 2
  t114 = 0.19711289000000000000000000000000000000000000000000e-2 * t105 * t107 * t108 - 0.2e1 * t112
  t115 = 0.1e1 / t114
  t116 = t101 * t115
  t117 = t33 ** 2
  t118 = f.my_piecewise3(t32, t117, 1)
  t119 = t116 * t118
  t120 = t59 * t119
  t122 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t11
  t124 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11
  t125 = 0.1e1 / t124
  t126 = t122 * t125
  t128 = s0 + 0.2e1 * s1 + s2
  t129 = t126 * t128
  t131 = 0.1e1 / t22 / t88
  t134 = jnp.log(t11 / 0.4e1)
  t135 = t6 * t131 * t134
  t136 = t118 ** 2
  t137 = 0.1e1 / t136
  t139 = 0.1e1 / t122
  t140 = t139 * t124
  t141 = t128 * t137 * t140
  t144 = 0.30e2 + 0.48579687500000000000000000000000000000000000000001e-3 * t135 * t141
  t145 = t128 * t95
  t147 = 0.1e1 / t3
  t151 = 0.30e2 + t145 * t137 * t19 * t147 / 0.48e2
  t152 = 0.1e1 / t151
  t153 = t144 * t152
  t154 = t103 * t6
  t155 = t22 * t101
  t159 = 0.2e1 * t31
  t161 = -t159 + 0.11696446794910408141662685001236899248561775660981e1 * t54
  t162 = jnp.sqrt(0.4e1)
  t163 = t161 * t162
  t164 = t106 * t108
  t167 = t6 * t22
  t171 = 0.30956250000000000000000000000000000000000000000000e-2 * t163 * t164 - 0.79593333333333333333333333333333333333333333333333e-1 * t103 * t167 * t99
  t172 = t171 * t115
  t174 = 0.79593333333333333333333333333333333333333333333333e-1 * t154 * t155 * t115 - t172 * t72
  t175 = 0.1e1 / t174
  t176 = t153 * t175
  t177 = t129 * t176
  t180 = -t31 + t55 + 0.49745833333333333333333333333333333333333333333332e-2 * t120 * t177
  t182 = t172 * t118 * t129
  t184 = t95 * t19 * t147
  t185 = t184 * t176
  t188 = t116 * t136
  t189 = t122 ** 2
  t190 = t124 ** 2
  t191 = 0.1e1 / t190
  t192 = t189 * t191
  t193 = t128 ** 2
  t194 = t192 * t193
  t195 = t188 * t194
  t196 = t88 ** 2
  t198 = 0.1e1 / t22 / t196
  t200 = t198 * t1 * t102
  t201 = t144 ** 2
  t202 = t151 ** 2
  t203 = 0.1e1 / t202
  t204 = t201 * t203
  t205 = t174 ** 2
  t206 = 0.1e1 / t205
  t207 = t204 * t206
  t208 = t200 * t207
  t211 = 0.1e1 + t182 * t185 / 0.48e2 - t195 * t208 / 0.768e3
  t212 = 0.1e1 / t211
  t213 = t180 * t212
  t214 = r0 - r1
  t215 = t214 * t60
  t216 = 0.1e1 + t215
  t217 = t216 <= f.p.zeta_threshold
  t218 = t216 ** (0.1e1 / 0.3e1)
  t220 = f.my_piecewise3(t217, t34, t218 * t216)
  t221 = 0.1e1 - t215
  t222 = t221 <= f.p.zeta_threshold
  t223 = t221 ** (0.1e1 / 0.3e1)
  t225 = f.my_piecewise3(t222, t34, t223 * t221)
  t227 = (t220 + t225 - 0.2e1) * t41
  t228 = 0.2e1 <= f.p.zeta_threshold
  t230 = f.my_piecewise3(t228, t34, 0.2e1 * t38)
  t231 = 0.0e0 <= f.p.zeta_threshold
  t232 = f.my_piecewise3(t231, t34, 0)
  t234 = (t230 + t232 - 0.2e1) * t41
  t236 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t11
  t241 = 0.21947830050000000000000000000000000000000000000000e0 * t14 + 0.48171623250000000000000000000000000000000000000000e-1 * t11 + 0.13081894750000000000000000000000000000000000000000e-1 * t17 + 0.48591338250000000000000000000000000000000000000000e-2 * t25
  t243 = 0.1e1 + 0.1e1 / t241
  t244 = jnp.log(t243)
  t248 = t234 * (-t236 * t244 + t31 - 0.58482233974552040708313425006184496242808878304904e0 * t53)
  t249 = t234 * t53
  t250 = 0.58482233974552040708313425006184496242808878304904e0 * t249
  t253 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t14 + 0.11799625000000000000000000000000000000000000000000e-1 * t11
  t256 = 0.1e1 + t14 * t253 / 0.2e1
  t257 = t256 ** 2
  t258 = 0.1e1 / t257
  t261 = -t31 + t248 + t250
  t267 = -0.24306825000000000000000000000000000000000000000000e-1 * t61 + 0.18749587500000000000000000000000000000000000000000e-2 * t79 - 0.36278062500000000000000000000000000000000000000000e-3 * t84 + 0.10075387500000000000000000000000000000000000000000e-3 * t90 - 0.86596593750000000000000000000000000000000000000000e-6 * t97
  t269 = 0.33415476033750000000000000000000000000000000000000e-2 * t61 * t258 - t261 * t267
  t270 = 0.1e1 / t256
  t274 = t261 ** 2
  t276 = 0.50765919958333333333333333333333333333333333333334e-3 * t105 * t107 * t270 - 0.2e1 * t274
  t277 = 0.1e1 / t276
  t278 = t269 * t277
  t279 = t38 ** 2
  t280 = f.my_piecewise3(t228, t117, t279)
  t281 = f.my_piecewise3(t231, t117, 0)
  t282 = t280 + t281
  t283 = t282 / 0.2e1
  t284 = t283 ** 2
  t285 = t284 * t283
  t286 = t278 * t285
  t287 = t59 * t286
  t289 = 0.4e1 * t282 ** 2
  t290 = 0.1e1 / t289
  t292 = t128 * t290 * t140
  t295 = 0.30e2 + 0.38862500000000000000000000000000000000000000000001e-2 * t135 * t292
  t296 = t290 * t295
  t298 = t290 * t19 * t147
  t301 = 0.30e2 + t145 * t298 / 0.3e1
  t302 = 0.1e1 / t301
  t303 = t22 * t269
  t309 = -t159 + 0.2e1 * t248 + 0.11696446794910408141662685001236899248561775660981e1 * t249
  t310 = t309 * t162
  t311 = t106 * t270
  t317 = 0.29499062500000000000000000000000000000000000000000e-2 * t310 * t311 - 0.21511666666666666666666666666666666666666666666667e-1 * t103 * t167 * t267
  t318 = t317 * t277
  t320 = 0.21511666666666666666666666666666666666666666666667e-1 * t154 * t303 * t277 - t318 * t261
  t321 = 0.1e1 / t320
  t322 = t302 * t321
  t323 = t296 * t322
  t324 = t129 * t323
  t327 = -t31 + t248 + t250 + 0.21511666666666666666666666666666666666666666666667e-1 * t287 * t324
  t328 = t318 * t285
  t329 = t328 * t129
  t331 = t95 * t290 * t19
  t333 = t147 * t295 * t322
  t334 = t331 * t333
  t337 = t284 ** 2
  t338 = t337 * t284
  t339 = t278 * t338
  t340 = t339 * t194
  t341 = t289 ** 2
  t342 = 0.1e1 / t341
  t344 = t198 * t342 * t1
  t345 = t295 ** 2
  t347 = t301 ** 2
  t348 = 0.1e1 / t347
  t349 = t320 ** 2
  t350 = 0.1e1 / t349
  t351 = t348 * t350
  t352 = t102 * t345 * t351
  t353 = t344 * t352
  t356 = 0.1e1 + t329 * t334 / 0.3e1 - t340 * t353 / 0.3e1
  t357 = 0.1e1 / t356
  t359 = t327 * t357 - t213
  t360 = t227 * t359
  t362 = t4 * t78 * t30
  t363 = 0.11073577833333333333333333333333333333333333333333e-2 * t362
  t364 = t27 ** 2
  t367 = 0.1e1 / t14
  t369 = t3 * t6
  t370 = t369 * t77
  t371 = t367 * t1 * t370
  t373 = t4 * t78
  t375 = t11 ** 0.5e0
  t377 = t375 * t1 * t370
  t379 = t21 * t83
  t384 = t13 / t364 * (-0.39359651450000000000000000000000000000000000000000e-1 * t371 - 0.18590345266666666666666666666666666666666666666667e-1 * t373 - 0.63666595250000000000000000000000000000000000000000e-2 * t377 - 0.51086658466666666666666666666666666666666666666667e-2 * t379) / t29
  t387 = t369 * t77 * t52
  t388 = t42 * t1 * t387
  t389 = 0.18311555036753159941307229983139571945136646663793e-3 * t388
  t391 = t49 ** 2
  t392 = 0.1e1 / t391
  t397 = -0.29149776500000000000000000000000000000000000000000e-1 * t371 - 0.10197214950000000000000000000000000000000000000000e-1 * t373 - 0.18581188275000000000000000000000000000000000000000e-2 * t377 - 0.27959805900000000000000000000000000000000000000000e-2 * t379
  t399 = 0.1e1 / t51
  t400 = t392 * t397 * t399
  t401 = t42 * t44 * t400
  t402 = 0.58482233974552040708313425006184496242808878304904e0 * t401
  t403 = t56 * t131
  t407 = t2 * t89
  t421 = -t367 * t64 * t1 * t370 / 0.12e2 + t14 * (-0.66066666666666666666666666666666666666666666666667e-2 * t371 - 0.41275000000000000000000000000000000000000000000000e-2 * t373) / 0.2e1
  t425 = t363 + t384 - t389 - t402
  t428 = t75 * t96
  t431 = t82 * t5 * t131
  t433 = t88 * t7
  t434 = 0.1e1 / t433
  t435 = t87 * t434
  t438 = 0.1e1 / t8 / t433
  t440 = t93 * t6 * t438
  t442 = 0.18780000000000000000000000000000000000000000000000e-1 * t407 - 0.17565000000000000000000000000000000000000000000000e-2 * t428 + 0.39625000000000000000000000000000000000000000000000e-3 * t431 - 0.12780000000000000000000000000000000000000000000000e-3 * t435 + 0.12603281250000000000000000000000000000000000000000e-5 * t440
  t444 = -0.36798313500000000000000000000000000000000000000000e-2 * t407 * t69 - 0.73596627000000000000000000000000000000000000000000e-2 * t61 / t68 / t67 * t421 - t425 * t99 - t72 * t442
  t445 = t444 * t115
  t450 = t114 ** 2
  t451 = 0.1e1 / t450
  t452 = t101 * t451
  t455 = t9 * t106
  t459 = t19 * t147
  t460 = t104 ** 2
  t461 = t460 ** 2
  t463 = t459 * t461 * t104
  t464 = t23 * t14
  t474 = 0.13140859333333333333333333333333333333333333333333e-2 * t105 * t455 * t108 - 0.98556445000000000000000000000000000000000000000000e-3 * t463 * t464 * t108 - 0.19711289000000000000000000000000000000000000000000e-2 * t105 * t107 * t69 * t421 - 0.4e1 * t72 * t425
  t476 = t153 * t175 * t474
  t480 = jnp.pi * t5
  t481 = t480 * t434
  t485 = t152 * t175
  t490 = t118 * t122
  t493 = t191 * t128
  t500 = 0.1e1 / t22 / t433
  t501 = t6 * t500
  t502 = t501 * t134
  t505 = t501 * t128
  t506 = t137 * t139
  t510 = 0.1e1 / t196
  t513 = t5 * t510 * t134 * t128
  t514 = 0.1e1 / t189
  t517 = t124 * t1 * t3
  t524 = -0.12954583333333333333333333333333333333333333333334e-2 * t502 * t141 - 0.16193229166666666666666666666666666666666666666667e-3 * t505 * t506 * t124 + 0.10804859389596418744895833333333333333333333333334e-5 * t513 * t137 * t514 * t517 - 0.28791561458333333333333333333333333333333333333335e-4 * t513 * t506 * t4
  t526 = t524 * t152 * t175
  t530 = t196 * t7
  t531 = 0.1e1 / t530
  t532 = t56 * t531
  t533 = 0.1e1 / t118
  t535 = t116 * t533 * t122
  t537 = t125 * t193
  t540 = t203 * t175 * t459
  t556 = 0.22147155666666666666666666666666666666666666666666e-2 * t362
  t557 = 0.2e1 * t384
  t567 = t3 * t77
  t582 = (0.30956250000000000000000000000000000000000000000000e-2 * (t556 + t557 - 0.36623110073506319882614459966279143890273293327587e-3 * t388 - 0.11696446794910408141662685001236899248561775660981e1 * t401) * t162 * t164 - 0.61912500000000000000000000000000000000000000000000e-2 * t161 * t104 * t14 * t108 * t1 * t567 - 0.30956250000000000000000000000000000000000000000000e-2 * t163 * t106 * t69 * t421 - 0.53062222222222222222222222222222222222222222222222e-1 * t103 * t10 * t99 - 0.79593333333333333333333333333333333333333333333333e-1 * t103 * t167 * t442) * t115
  t584 = t171 * t451
  t588 = 0.53062222222222222222222222222222222222222222222222e-1 * t154 * t9 * t101 * t115 + 0.79593333333333333333333333333333333333333333333333e-1 * t154 * t22 * t444 * t115 - 0.79593333333333333333333333333333333333333333333333e-1 * t154 * t155 * t451 * t474 - t582 * t72 + t584 * t72 * t474 - t172 * t425
  t590 = t153 * t206 * t588
  t594 = t363 + t384 - t389 - t402 - 0.82909722222222222222222222222222222222222222222220e-2 * t403 * t119 * t177 + 0.49745833333333333333333333333333333333333333333332e-2 * t59 * t445 * t118 * t177 - 0.49745833333333333333333333333333333333333333333332e-2 * t59 * t452 * t118 * t129 * t476 - 0.11064227911819424133055555555555555555555555555555e-4 * t481 * t119 * t4 * t125 * t128 * t144 * t485 + 0.29482697222222222222222222222222222222222222222222e-3 * t481 * t116 * t490 * t493 * t144 * t485 * t4 + 0.49745833333333333333333333333333333333333333333332e-2 * t120 * t129 * t526 + 0.24182002314814814814814814814814814814814814814814e-3 * t532 * t535 * t537 * t144 * t540 - 0.49745833333333333333333333333333333333333333333332e-2 * t120 * t129 * t590
  t595 = t594 * t212
  t596 = t211 ** 2
  t598 = t180 / t596
  t611 = t125 * t128
  t631 = t172 * t533
  t632 = t126 * t193
  t635 = 0.1e1 / t22 / t530
  t637 = t635 * t1 * t102
  t638 = t144 * t203
  t639 = t638 * t175
  t657 = t122 * t191
  t661 = 0.1e1 / t196 / t88
  t666 = t661 * t19 * t147 * t204 * t206 * t6
  t671 = t189 / t190 / t124
  t685 = t192 * t193 * t128
  t687 = t196 ** 2
  t688 = 0.1e1 / t687
  t693 = t201 / t202 / t151 * t206
  t704 = t582 * t118 * t129 * t185 / 0.48e2 - t584 * t118 * t129 * t184 * t476 / 0.48e2 - 0.34752370105806885416666666666666666666666666666667e-4 * t172 * t118 * t6 * t500 * t611 * t176 + 0.92604166666666666666666666666666666666666666666669e-3 * t172 * t490 * t191 * t128 * t500 * t144 * t485 * t6 - 0.7e1 / 0.144e3 * t182 * t438 * t19 * t147 * t176 + t182 * t184 * t526 / 0.48e2 + 0.7e1 / 0.2304e4 * t631 * t632 * t637 * t639 - t182 * t184 * t590 / 0.48e2 - t445 * t136 * t194 * t208 / 0.768e3 + t452 * t136 * t194 * t200 * t204 * t206 * t474 / 0.768e3 + 0.14480154210752868923611111111111111111111111111111e-5 * t188 * t657 * t193 * t666 - 0.38585069444444444444444444444444444444444444444445e-4 * t188 * t671 * t193 * t666 + 0.7e1 / 0.1152e4 * t195 * t637 * t207 - t195 * t200 * t638 * t206 * t524 / 0.384e3 - 0.7e1 / 0.18432e5 * t116 * t685 * t688 * jnp.pi * t693 + t195 * t200 * t204 / t205 / t174 * t588 / 0.384e3
  t705 = t598 * t704
  t706 = t214 * t89
  t707 = t60 - t706
  t710 = f.my_piecewise3(t217, 0, 0.4e1 / 0.3e1 * t218 * t707)
  t714 = f.my_piecewise3(t222, 0, -0.4e1 / 0.3e1 * t223 * t707)
  t721 = t241 ** 2
  t740 = t234 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t78 * t244 + t236 / t721 * (-0.36579716750000000000000000000000000000000000000000e-1 * t371 - 0.16057207750000000000000000000000000000000000000000e-1 * t373 - 0.65409473750000000000000000000000000000000000000000e-2 * t377 - 0.32394225500000000000000000000000000000000000000000e-2 * t379) / t243 - t363 - t384 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t78 * t52 + 0.58482233974552040708313425006184496242808878304904e0 * t44 * t392 * t397 * t399)
  t742 = t234 * t1 * t387
  t743 = 0.18311555036753159941307229983139571945136646663793e-3 * t742
  t745 = t234 * t44 * t400
  t746 = 0.58482233974552040708313425006184496242808878304904e0 * t745
  t763 = -t367 * t253 * t1 * t370 / 0.12e2 + t14 * (-0.14921166666666666666666666666666666666666666666667e-3 * t371 - 0.39332083333333333333333333333333333333333333333333e-2 * t373) / 0.2e1
  t767 = t363 + t384 + t740 - t743 - t746
  t774 = 0.24306825000000000000000000000000000000000000000000e-1 * t407 - 0.24999450000000000000000000000000000000000000000000e-2 * t428 + 0.60463437500000000000000000000000000000000000000000e-3 * t431 - 0.20150775000000000000000000000000000000000000000000e-3 * t435 + 0.20205871875000000000000000000000000000000000000000e-5 * t440
  t776 = -0.33415476033750000000000000000000000000000000000000e-2 * t407 * t258 - 0.66830952067500000000000000000000000000000000000000e-2 * t61 / t257 / t256 * t763 - t767 * t267 - t261 * t774
  t777 = t776 * t277
  t782 = t276 ** 2
  t783 = 0.1e1 / t782
  t784 = t269 * t783
  t785 = t285 * t122
  t788 = t611 * t290
  t789 = t295 * t302
  t802 = 0.33843946638888888888888888888888888888888888888889e-3 * t105 * t455 * t270 - 0.25382959979166666666666666666666666666666666666667e-3 * t463 * t464 * t270 - 0.50765919958333333333333333333333333333333333333334e-3 * t105 * t107 * t258 * t763 - 0.4e1 * t261 * t767
  t804 = t789 * t321 * t802
  t816 = t278 * t785
  t825 = t290 * t139
  t836 = -0.10363333333333333333333333333333333333333333333334e-1 * t502 * t292 - 0.12954166666666666666666666666666666666666666666667e-2 * t505 * t825 * t124 + 0.86436094927162885408333333333333333333333333333337e-5 * t513 * t290 * t514 * t517 - 0.23032508333333333333333333333333333333333333333334e-3 * t513 * t825 * t4
  t843 = t342 * t295
  t845 = t348 * t321
  t846 = t845 * t459
  t887 = (0.29499062500000000000000000000000000000000000000000e-2 * (t556 + t557 + 0.2e1 * t740 - 0.36623110073506319882614459966279143890273293327587e-3 * t742 - 0.11696446794910408141662685001236899248561775660981e1 * t745) * t162 * t311 - 0.58998125000000000000000000000000000000000000000000e-2 * t309 * t104 * t14 * t270 * t1 * t567 - 0.29499062500000000000000000000000000000000000000000e-2 * t310 * t106 * t258 * t763 - 0.14341111111111111111111111111111111111111111111111e-1 * t103 * t10 * t267 - 0.21511666666666666666666666666666666666666666666667e-1 * t103 * t167 * t774) * t277
  t889 = t317 * t783
  t893 = 0.14341111111111111111111111111111111111111111111111e-1 * t154 * t9 * t269 * t277 + 0.21511666666666666666666666666666666666666666666667e-1 * t154 * t22 * t776 * t277 - 0.21511666666666666666666666666666666666666666666667e-1 * t154 * t303 * t783 * t802 - t887 * t261 + t889 * t261 * t802 - t318 * t767
  t895 = t789 * t350 * t893
  t899 = t363 + t384 + t740 - t743 - t746 - 0.35852777777777777777777777777777777777777777777778e-1 * t403 * t286 * t324 + 0.21511666666666666666666666666666666666666666666667e-1 * t59 * t777 * t285 * t324 - 0.21511666666666666666666666666666666666666666666667e-1 * t59 * t784 * t785 * t788 * t804 - 0.47845209701935943474444444444444444444444444444446e-4 * t481 * t278 * t285 * t1 * t3 * t125 * t128 * t323 + 0.12749247777777777777777777777777777777777777777778e-2 * t481 * t816 * t493 * t296 * t322 * t4 + 0.21511666666666666666666666666666666666666666666667e-1 * t287 * t129 * t290 * t836 * t322 + 0.16731296296296296296296296296296296296296296296297e-1 * t532 * t816 * t537 * t843 * t846 - 0.21511666666666666666666666666666666666666666666667e-1 * t59 * t816 * t788 * t895
  t901 = t356 ** 2
  t903 = t327 / t901
  t909 = t126 * t145
  t917 = t789 * t321
  t941 = t635 * t342 * t1
  t942 = t102 * t295
  t943 = t942 * t845
  t957 = t192 * t193 * t198
  t960 = t342 * t1 * t102
  t961 = t345 * t348
  t967 = t193 * t661
  t974 = t342 * t19 * t147 * t961 * t350 * t6
  t984 = t339 * t957
  t993 = 0.1e1 / t341 / t289
  t999 = t345 / t347 / t301 * t350
  t1010 = t887 * t285 * t129 * t334 / 0.3e1 - t889 * t285 * t909 * t298 * t804 / 0.3e1 - 0.55603792169291016666666666666666666666666666666667e-3 * t318 * t285 * t6 * t500 * t788 * t917 + 0.14816666666666666666666666666666666666666666666667e-1 * t328 * t657 * t128 * t500 * t290 * t295 * t322 * t6 - 0.7e1 / 0.9e1 * t329 * t438 * t290 * t19 * t333 + t329 * t331 * t147 * t836 * t322 / 0.3e1 + 0.7e1 / 0.9e1 * t328 * t632 * t941 * t943 - t328 * t909 * t298 * t895 / 0.3e1 - t777 * t338 * t194 * t353 / 0.3e1 + t784 * t338 * t957 * t960 * t961 * t350 * t802 / 0.3e1 + 0.37069194779527344444444444444444444444444444444443e-3 * t339 * t657 * t967 * t974 - 0.98777777777777777777777777777777777777777777777780e-2 * t339 * t671 * t967 * t974 + 0.14e2 / 0.9e1 * t340 * t941 * t352 - 0.2e1 / 0.3e1 * t984 * t960 * t295 * t348 * t350 * t836 - 0.14e2 / 0.9e1 * t339 * t685 * t688 * t993 * jnp.pi * t999 + 0.2e1 / 0.3e1 * t984 * t960 * t961 / t349 / t320 * t893
  t1013 = t227 * (-t903 * t1010 + t899 * t357 - t595 + t705)
  vrho_0_ = t213 + t360 + t7 * (t595 - t705 + (t710 + t714) * t41 * t359 + t1013)
  t1016 = -t60 - t706
  t1019 = f.my_piecewise3(t217, 0, 0.4e1 / 0.3e1 * t218 * t1016)
  t1023 = f.my_piecewise3(t222, 0, -0.4e1 / 0.3e1 * t223 * t1016)
  vrho_1_ = t213 + t360 + t7 * (t595 - t705 + (t1019 + t1023) * t41 * t359 + t1013)
  t1032 = t490 * t125
  t1034 = t56 * t58 * t101 * t115 * t1032 * t176
  t1037 = 0.1e1 / t8 / t196
  t1041 = t533 * t128
  t1043 = t134 * t152 * t175
  t1045 = t480 * t1037 * t101 * t115 * t1041 * t1043
  t1047 = t56 * t510
  t1051 = t1047 * t535 * t611 * t144 * t540
  t1054 = (0.49745833333333333333333333333333333333333333333332e-2 * t1034 + 0.96665481510416666666666666666666666666666666666664e-5 * t1045 - 0.10363715277777777777777777777777777777777777777777e-3 * t1051) * t212
  t1056 = t172 * t1032 * t185
  t1060 = t459 * t6
  t1062 = t172 * t1041 * t531 * t1060 * t1043
  t1066 = t631 * t129 * t200 * t639
  t1068 = t192 * t128
  t1070 = t188 * t1068 * t208
  t1073 = t196 * t433
  t1075 = 0.1e1 / t8 / t1073
  t1080 = t6 * t134
  t1083 = t116 * t122 * t537 * t1075 * t103 * t144 * t203 * t206 * t1080
  t1086 = 0.1e1 / t1073
  t1089 = t116 * t194 * t1086 * jnp.pi * t693
  t1092 = t598 * (t1056 / 0.48e2 + 0.10120768229166666666666666666666666666666666666667e-4 * t1062 - t1066 / 0.768e3 - t1070 / 0.384e3 - 0.12650960286458333333333333333333333333333333333334e-5 * t1083 + t1089 / 0.6144e4)
  t1095 = t287 * t126 * t290 * t917
  t1103 = t134 * t302 * t321
  t1105 = t480 * t1037 * t269 * t277 * t285 * t128 * t342 * t1103
  t1110 = t1047 * t816 * t611 * t843 * t846
  t1117 = t328 * t126 * t95 * t298 * t917
  t1123 = t328 * t128 * t531 * t342 * t1060 * t1103
  t1126 = t329 * t344 * t943
  t1129 = t339 * t1068 * t353
  t1138 = t339 * t126 * t193 * t1075 * t993 * t1 * t942 * t351 * t1080
  t1143 = t340 * t1086 * t993 * jnp.pi * t999
  vsigma_0_ = t7 * (t1054 - t1092 + t227 * ((0.21511666666666666666666666666666666666666666666667e-1 * t1095 + 0.33439885833333333333333333333333333333333333333334e-3 * t1105 - 0.71705555555555555555555555555555555555555555555557e-2 * t1110) * t357 - t903 * (t1117 / 0.3e1 + 0.12954166666666666666666666666666666666666666666667e-2 * t1123 - t1126 / 0.3e1 - 0.2e1 / 0.3e1 * t1129 - 0.25908333333333333333333333333333333333333333333334e-2 * t1138 + 0.2e1 / 0.3e1 * t1143) - t1054 + t1092))
  t1154 = (0.99491666666666666666666666666666666666666666666664e-2 * t1034 + 0.19333096302083333333333333333333333333333333333333e-4 * t1045 - 0.20727430555555555555555555555555555555555555555555e-3 * t1051) * t212
  t1162 = t598 * (t1056 / 0.24e2 + 0.20241536458333333333333333333333333333333333333334e-4 * t1062 - t1066 / 0.384e3 - t1070 / 0.192e3 - 0.25301920572916666666666666666666666666666666666667e-5 * t1083 + t1089 / 0.3072e4)
  vsigma_1_ = t7 * (t1154 - t1162 + t227 * ((0.43023333333333333333333333333333333333333333333334e-1 * t1095 + 0.66879771666666666666666666666666666666666666666670e-3 * t1105 - 0.14341111111111111111111111111111111111111111111111e-1 * t1110) * t357 - t903 * (0.2e1 / 0.3e1 * t1117 + 0.25908333333333333333333333333333333333333333333334e-2 * t1123 - 0.2e1 / 0.3e1 * t1126 - 0.4e1 / 0.3e1 * t1129 - 0.51816666666666666666666666666666666666666666666667e-2 * t1138 + 0.4e1 / 0.3e1 * t1143) - t1154 + t1162))
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_par1 = np.array([np.nan, 0.0471985, 1.49676, 0.00179054, -0.0324091, 0.00999978, -0.00193483, 0.000179118, -6.15798e-06, 0.015545, 0.064535], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  gap_par_a = 30

  gap_t = lambda rs, z, xt: xt * f.n_total(rs) ** (1 / 6) / (4 * f.mphi(z) * (3 / jnp.pi) ** (1 / 6))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gap_H = lambda rs, t, par: (gap_par_a + par[9] * rs * jnp.log(rs) * t ** 2 / f.beta_Hu_Langreth(rs)) / (gap_par_a + t ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  gap_G = lambda rs, z, xt, par: +f.mphi(z) ** 3 * f.beta_Hu_Langreth(rs) * gap_t(rs, z, xt) ** 2 * gap_H(rs, gap_t(rs, z, xt), par) / (gap_c1(rs, z, par) - gap_c2(rs, z, par) * f_pw(rs, z))

  gap_eps = lambda rs, z, xt, par: +(f_pw(rs, z) + gap_c1(rs, z, par) * gap_G(rs, z, xt, par)) / (1 + gap_c2(rs, z, par) * gap_G(rs, z, xt, par) + gap_c3(rs, z, par) * gap_G(rs, z, xt, par) ** 2)

  f_gap = lambda rs, z, xt: +gap_eps(rs, 0, xt, gap_par0) + f.f_zeta(z) * (gap_eps(rs, 1, xt, gap_par1) - gap_eps(rs, 0, xt, gap_par0))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_gap(rs, z, xt)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t12 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t24 = t20 * t5 * t22
  t26 = 0.23615790870000000000000000000000000000000000000000e0 * t13 + 0.55771035800000000000000000000000000000000000000000e-1 * t10 + 0.12733319050000000000000000000000000000000000000000e-1 * t16 + 0.76629987700000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t33 = t32 * f.p.zeta_threshold
  t34 = f.my_piecewise3(t31, t33, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = (0.2e1 * t34 - 0.2e1) * t40
  t43 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489865900000000000000000000000000000000000000000e0 * t13 + 0.30591644850000000000000000000000000000000000000000e-1 * t10 + 0.37162376550000000000000000000000000000000000000000e-2 * t16 + 0.41939708850000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t52 = t43 * t51
  t53 = t41 * t52
  t54 = 0.58482233974552040708313425006184496242808878304904e0 * t53
  t55 = jnp.pi * t6
  t57 = 0.1e1 / t21 / r0
  t58 = t55 * t57
  t60 = t2 / r0
  t63 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t13 + 0.12382500000000000000000000000000000000000000000000e-1 * t10
  t66 = 0.1e1 + t13 * t63 / 0.2e1
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t71 = -t30 + t54
  t74 = t1 * t3 * t2
  t76 = 0.1e1 / t7 / r0
  t77 = t6 * t76
  t78 = t74 * t77
  t81 = t18 * t19 * t2
  t82 = t5 * t57
  t83 = t81 * t82
  t85 = jnp.pi ** 2
  t86 = 0.1e1 / t85
  t87 = r0 ** 2
  t88 = 0.1e1 / t87
  t89 = t86 * t88
  t92 = t1 * t3 * t86
  t94 = 0.1e1 / t7 / t87
  t95 = t6 * t94
  t96 = t92 * t95
  t98 = -0.18780000000000000000000000000000000000000000000000e-1 * t60 + 0.13173750000000000000000000000000000000000000000000e-2 * t78 - 0.23775000000000000000000000000000000000000000000000e-3 * t83 + 0.63900000000000000000000000000000000000000000000000e-4 * t89 - 0.54014062500000000000000000000000000000000000000000e-6 * t96
  t100 = 0.36798313500000000000000000000000000000000000000000e-2 * t60 * t68 - t71 * t98
  t101 = 0.1e1 / t19
  t102 = t1 * t101
  t103 = 4 ** (0.1e1 / 0.6e1)
  t104 = t102 * t103
  t105 = t13 * t10
  t106 = t21 * t105
  t107 = 0.1e1 / t66
  t111 = t71 ** 2
  t113 = 0.19711289000000000000000000000000000000000000000000e-2 * t104 * t106 * t107 - 0.2e1 * t111
  t114 = 0.1e1 / t113
  t115 = t100 * t114
  t116 = t32 ** 2
  t117 = f.my_piecewise3(t31, t116, 1)
  t118 = t115 * t117
  t119 = t58 * t118
  t121 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t10
  t123 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t124 = 0.1e1 / t123
  t125 = t121 * t124
  t126 = t125 * s0
  t128 = 0.1e1 / t21 / t87
  t131 = jnp.log(t10 / 0.4e1)
  t132 = t6 * t128 * t131
  t133 = t117 ** 2
  t134 = 0.1e1 / t133
  t136 = 0.1e1 / t121
  t137 = t136 * t123
  t138 = s0 * t134 * t137
  t141 = 0.30e2 + 0.48579687500000000000000000000000000000000000000001e-3 * t132 * t138
  t142 = s0 * t94
  t144 = 0.1e1 / t3
  t148 = 0.30e2 + t142 * t134 * t18 * t144 / 0.48e2
  t149 = 0.1e1 / t148
  t150 = t141 * t149
  t151 = t102 * t6
  t152 = t21 * t100
  t156 = 0.2e1 * t30
  t158 = -t156 + 0.11696446794910408141662685001236899248561775660981e1 * t53
  t159 = jnp.sqrt(0.4e1)
  t160 = t158 * t159
  t161 = t105 * t107
  t164 = t6 * t21
  t168 = 0.30956250000000000000000000000000000000000000000000e-2 * t160 * t161 - 0.79593333333333333333333333333333333333333333333333e-1 * t102 * t164 * t98
  t169 = t168 * t114
  t171 = 0.79593333333333333333333333333333333333333333333333e-1 * t151 * t152 * t114 - t169 * t71
  t172 = 0.1e1 / t171
  t173 = t150 * t172
  t174 = t126 * t173
  t177 = -t30 + t54 + 0.49745833333333333333333333333333333333333333333332e-2 * t119 * t174
  t179 = t169 * t117 * t126
  t181 = t94 * t18 * t144
  t182 = t181 * t173
  t185 = t115 * t133
  t186 = t121 ** 2
  t187 = t123 ** 2
  t188 = 0.1e1 / t187
  t189 = t186 * t188
  t190 = s0 ** 2
  t191 = t189 * t190
  t192 = t185 * t191
  t193 = t87 ** 2
  t195 = 0.1e1 / t21 / t193
  t197 = t195 * t1 * t101
  t198 = t141 ** 2
  t199 = t148 ** 2
  t200 = 0.1e1 / t199
  t201 = t198 * t200
  t202 = t171 ** 2
  t203 = 0.1e1 / t202
  t204 = t201 * t203
  t205 = t197 * t204
  t208 = 0.1e1 + t179 * t182 / 0.48e2 - t192 * t205 / 0.768e3
  t209 = 0.1e1 / t208
  t210 = t177 * t209
  t211 = 0.2e1 <= f.p.zeta_threshold
  t213 = f.my_piecewise3(t211, t33, 0.2e1 * t37)
  t214 = 0.0e0 <= f.p.zeta_threshold
  t215 = f.my_piecewise3(t214, t33, 0)
  t217 = (t213 + t215 - 0.2e1) * t40
  t219 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t10
  t224 = 0.21947830050000000000000000000000000000000000000000e0 * t13 + 0.48171623250000000000000000000000000000000000000000e-1 * t10 + 0.13081894750000000000000000000000000000000000000000e-1 * t16 + 0.48591338250000000000000000000000000000000000000000e-2 * t24
  t226 = 0.1e1 + 0.1e1 / t224
  t227 = jnp.log(t226)
  t231 = t217 * (-t219 * t227 + t30 - 0.58482233974552040708313425006184496242808878304904e0 * t52)
  t232 = t217 * t52
  t233 = 0.58482233974552040708313425006184496242808878304904e0 * t232
  t236 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t13 + 0.11799625000000000000000000000000000000000000000000e-1 * t10
  t239 = 0.1e1 + t13 * t236 / 0.2e1
  t240 = t239 ** 2
  t241 = 0.1e1 / t240
  t244 = -t30 + t231 + t233
  t250 = -0.24306825000000000000000000000000000000000000000000e-1 * t60 + 0.18749587500000000000000000000000000000000000000000e-2 * t78 - 0.36278062500000000000000000000000000000000000000000e-3 * t83 + 0.10075387500000000000000000000000000000000000000000e-3 * t89 - 0.86596593750000000000000000000000000000000000000000e-6 * t96
  t252 = 0.33415476033750000000000000000000000000000000000000e-2 * t60 * t241 - t244 * t250
  t253 = 0.1e1 / t239
  t257 = t244 ** 2
  t259 = 0.50765919958333333333333333333333333333333333333334e-3 * t104 * t106 * t253 - 0.2e1 * t257
  t260 = 0.1e1 / t259
  t261 = t252 * t260
  t262 = t37 ** 2
  t263 = f.my_piecewise3(t211, t116, t262)
  t264 = f.my_piecewise3(t214, t116, 0)
  t265 = t263 + t264
  t266 = t265 / 0.2e1
  t267 = t266 ** 2
  t268 = t267 * t266
  t269 = t261 * t268
  t270 = t58 * t269
  t272 = 0.4e1 * t265 ** 2
  t273 = 0.1e1 / t272
  t275 = s0 * t273 * t137
  t278 = 0.30e2 + 0.38862500000000000000000000000000000000000000000001e-2 * t132 * t275
  t279 = t273 * t278
  t281 = t273 * t18 * t144
  t284 = 0.30e2 + t142 * t281 / 0.3e1
  t285 = 0.1e1 / t284
  t286 = t21 * t252
  t292 = -t156 + 0.2e1 * t231 + 0.11696446794910408141662685001236899248561775660981e1 * t232
  t293 = t292 * t159
  t294 = t105 * t253
  t300 = 0.29499062500000000000000000000000000000000000000000e-2 * t293 * t294 - 0.21511666666666666666666666666666666666666666666667e-1 * t102 * t164 * t250
  t301 = t300 * t260
  t303 = 0.21511666666666666666666666666666666666666666666667e-1 * t151 * t286 * t260 - t301 * t244
  t304 = 0.1e1 / t303
  t305 = t285 * t304
  t306 = t279 * t305
  t307 = t126 * t306
  t310 = -t30 + t231 + t233 + 0.21511666666666666666666666666666666666666666666667e-1 * t270 * t307
  t311 = t301 * t268
  t312 = t311 * t126
  t314 = t94 * t273 * t18
  t316 = t144 * t278 * t305
  t317 = t314 * t316
  t320 = t267 ** 2
  t321 = t320 * t267
  t322 = t261 * t321
  t323 = t322 * t191
  t324 = t272 ** 2
  t325 = 0.1e1 / t324
  t327 = t195 * t325 * t1
  t328 = t278 ** 2
  t330 = t284 ** 2
  t331 = 0.1e1 / t330
  t332 = t303 ** 2
  t333 = 0.1e1 / t332
  t334 = t331 * t333
  t335 = t101 * t328 * t334
  t336 = t327 * t335
  t339 = 0.1e1 + t312 * t317 / 0.3e1 - t323 * t336 / 0.3e1
  t340 = 0.1e1 / t339
  t345 = t4 * t77 * t29
  t346 = 0.11073577833333333333333333333333333333333333333333e-2 * t345
  t347 = t26 ** 2
  t350 = 0.1e1 / t13
  t352 = t3 * t6
  t353 = t352 * t76
  t354 = t350 * t1 * t353
  t356 = t4 * t77
  t358 = t10 ** 0.5e0
  t360 = t358 * t1 * t353
  t362 = t20 * t82
  t367 = t12 / t347 * (-0.39359651450000000000000000000000000000000000000000e-1 * t354 - 0.18590345266666666666666666666666666666666666666667e-1 * t356 - 0.63666595250000000000000000000000000000000000000000e-2 * t360 - 0.51086658466666666666666666666666666666666666666667e-2 * t362) / t28
  t370 = t352 * t76 * t51
  t371 = t41 * t1 * t370
  t372 = 0.18311555036753159941307229983139571945136646663793e-3 * t371
  t374 = t48 ** 2
  t375 = 0.1e1 / t374
  t380 = -0.29149776500000000000000000000000000000000000000000e-1 * t354 - 0.10197214950000000000000000000000000000000000000000e-1 * t356 - 0.18581188275000000000000000000000000000000000000000e-2 * t360 - 0.27959805900000000000000000000000000000000000000000e-2 * t362
  t382 = 0.1e1 / t50
  t383 = t375 * t380 * t382
  t384 = t41 * t43 * t383
  t385 = 0.58482233974552040708313425006184496242808878304904e0 * t384
  t386 = t55 * t128
  t390 = t2 * t88
  t404 = -t350 * t63 * t1 * t353 / 0.12e2 + t13 * (-0.66066666666666666666666666666666666666666666666667e-2 * t354 - 0.41275000000000000000000000000000000000000000000000e-2 * t356) / 0.2e1
  t408 = t346 + t367 - t372 - t385
  t411 = t74 * t95
  t414 = t81 * t5 * t128
  t416 = t87 * r0
  t417 = 0.1e1 / t416
  t418 = t86 * t417
  t421 = 0.1e1 / t7 / t416
  t423 = t92 * t6 * t421
  t425 = 0.18780000000000000000000000000000000000000000000000e-1 * t390 - 0.17565000000000000000000000000000000000000000000000e-2 * t411 + 0.39625000000000000000000000000000000000000000000000e-3 * t414 - 0.12780000000000000000000000000000000000000000000000e-3 * t418 + 0.12603281250000000000000000000000000000000000000000e-5 * t423
  t427 = -0.36798313500000000000000000000000000000000000000000e-2 * t390 * t68 - 0.73596627000000000000000000000000000000000000000000e-2 * t60 / t67 / t66 * t404 - t408 * t98 - t71 * t425
  t428 = t427 * t114
  t433 = t113 ** 2
  t434 = 0.1e1 / t433
  t435 = t100 * t434
  t438 = t8 * t105
  t442 = t18 * t144
  t443 = t103 ** 2
  t444 = t443 ** 2
  t446 = t442 * t444 * t103
  t447 = t22 * t13
  t457 = 0.13140859333333333333333333333333333333333333333333e-2 * t104 * t438 * t107 - 0.98556445000000000000000000000000000000000000000000e-3 * t446 * t447 * t107 - 0.19711289000000000000000000000000000000000000000000e-2 * t104 * t106 * t68 * t404 - 0.4e1 * t71 * t408
  t459 = t150 * t172 * t457
  t463 = jnp.pi * t5
  t464 = t463 * t417
  t468 = t149 * t172
  t473 = t117 * t121
  t476 = t188 * s0
  t483 = 0.1e1 / t21 / t416
  t484 = t6 * t483
  t485 = t484 * t131
  t488 = t484 * s0
  t489 = t134 * t136
  t493 = 0.1e1 / t193
  t496 = t5 * t493 * t131 * s0
  t497 = 0.1e1 / t186
  t500 = t123 * t1 * t3
  t507 = -0.12954583333333333333333333333333333333333333333334e-2 * t485 * t138 - 0.16193229166666666666666666666666666666666666666667e-3 * t488 * t489 * t123 + 0.10804859389596418744895833333333333333333333333334e-5 * t496 * t134 * t497 * t500 - 0.28791561458333333333333333333333333333333333333335e-4 * t496 * t489 * t4
  t509 = t507 * t149 * t172
  t513 = t193 * r0
  t514 = 0.1e1 / t513
  t515 = t55 * t514
  t516 = 0.1e1 / t117
  t518 = t115 * t516 * t121
  t520 = t124 * t190
  t523 = t200 * t172 * t442
  t539 = 0.22147155666666666666666666666666666666666666666666e-2 * t345
  t540 = 0.2e1 * t367
  t550 = t3 * t76
  t565 = (0.30956250000000000000000000000000000000000000000000e-2 * (t539 + t540 - 0.36623110073506319882614459966279143890273293327587e-3 * t371 - 0.11696446794910408141662685001236899248561775660981e1 * t384) * t159 * t161 - 0.61912500000000000000000000000000000000000000000000e-2 * t158 * t103 * t13 * t107 * t1 * t550 - 0.30956250000000000000000000000000000000000000000000e-2 * t160 * t105 * t68 * t404 - 0.53062222222222222222222222222222222222222222222222e-1 * t102 * t9 * t98 - 0.79593333333333333333333333333333333333333333333333e-1 * t102 * t164 * t425) * t114
  t567 = t168 * t434
  t571 = 0.53062222222222222222222222222222222222222222222222e-1 * t151 * t8 * t100 * t114 + 0.79593333333333333333333333333333333333333333333333e-1 * t151 * t21 * t427 * t114 - 0.79593333333333333333333333333333333333333333333333e-1 * t151 * t152 * t434 * t457 - t565 * t71 + t567 * t71 * t457 - t169 * t408
  t573 = t150 * t203 * t571
  t577 = t346 + t367 - t372 - t385 - 0.82909722222222222222222222222222222222222222222220e-2 * t386 * t118 * t174 + 0.49745833333333333333333333333333333333333333333332e-2 * t58 * t428 * t117 * t174 - 0.49745833333333333333333333333333333333333333333332e-2 * t58 * t435 * t117 * t126 * t459 - 0.11064227911819424133055555555555555555555555555555e-4 * t464 * t118 * t4 * t124 * s0 * t141 * t468 + 0.29482697222222222222222222222222222222222222222222e-3 * t464 * t115 * t473 * t476 * t141 * t468 * t4 + 0.49745833333333333333333333333333333333333333333332e-2 * t119 * t126 * t509 + 0.24182002314814814814814814814814814814814814814814e-3 * t515 * t518 * t520 * t141 * t523 - 0.49745833333333333333333333333333333333333333333332e-2 * t119 * t126 * t573
  t578 = t577 * t209
  t579 = t208 ** 2
  t581 = t177 / t579
  t594 = t124 * s0
  t614 = t169 * t516
  t615 = t125 * t190
  t618 = 0.1e1 / t21 / t513
  t620 = t618 * t1 * t101
  t621 = t141 * t200
  t622 = t621 * t172
  t640 = t121 * t188
  t644 = 0.1e1 / t193 / t87
  t649 = t644 * t18 * t144 * t201 * t203 * t6
  t654 = t186 / t187 / t123
  t668 = t189 * t190 * s0
  t670 = t193 ** 2
  t671 = 0.1e1 / t670
  t676 = t198 / t199 / t148 * t203
  t687 = t565 * t117 * t126 * t182 / 0.48e2 - t567 * t117 * t126 * t181 * t459 / 0.48e2 - 0.34752370105806885416666666666666666666666666666667e-4 * t169 * t117 * t6 * t483 * t594 * t173 + 0.92604166666666666666666666666666666666666666666669e-3 * t169 * t473 * t188 * s0 * t483 * t141 * t468 * t6 - 0.7e1 / 0.144e3 * t179 * t421 * t18 * t144 * t173 + t179 * t181 * t509 / 0.48e2 + 0.7e1 / 0.2304e4 * t614 * t615 * t620 * t622 - t179 * t181 * t573 / 0.48e2 - t428 * t133 * t191 * t205 / 0.768e3 + t435 * t133 * t191 * t197 * t201 * t203 * t457 / 0.768e3 + 0.14480154210752868923611111111111111111111111111111e-5 * t185 * t640 * t190 * t649 - 0.38585069444444444444444444444444444444444444444445e-4 * t185 * t654 * t190 * t649 + 0.7e1 / 0.1152e4 * t192 * t620 * t204 - t192 * t197 * t621 * t203 * t507 / 0.384e3 - 0.7e1 / 0.18432e5 * t115 * t668 * t671 * jnp.pi * t676 + t192 * t197 * t201 / t202 / t171 * t571 / 0.384e3
  t688 = t581 * t687
  t692 = t224 ** 2
  t711 = t217 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t77 * t227 + t219 / t692 * (-0.36579716750000000000000000000000000000000000000000e-1 * t354 - 0.16057207750000000000000000000000000000000000000000e-1 * t356 - 0.65409473750000000000000000000000000000000000000000e-2 * t360 - 0.32394225500000000000000000000000000000000000000000e-2 * t362) / t226 - t346 - t367 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t77 * t51 + 0.58482233974552040708313425006184496242808878304904e0 * t43 * t375 * t380 * t382)
  t713 = t217 * t1 * t370
  t714 = 0.18311555036753159941307229983139571945136646663793e-3 * t713
  t716 = t217 * t43 * t383
  t717 = 0.58482233974552040708313425006184496242808878304904e0 * t716
  t734 = -t350 * t236 * t1 * t353 / 0.12e2 + t13 * (-0.14921166666666666666666666666666666666666666666667e-3 * t354 - 0.39332083333333333333333333333333333333333333333333e-2 * t356) / 0.2e1
  t738 = t346 + t367 + t711 - t714 - t717
  t745 = 0.24306825000000000000000000000000000000000000000000e-1 * t390 - 0.24999450000000000000000000000000000000000000000000e-2 * t411 + 0.60463437500000000000000000000000000000000000000000e-3 * t414 - 0.20150775000000000000000000000000000000000000000000e-3 * t418 + 0.20205871875000000000000000000000000000000000000000e-5 * t423
  t747 = -0.33415476033750000000000000000000000000000000000000e-2 * t390 * t241 - 0.66830952067500000000000000000000000000000000000000e-2 * t60 / t240 / t239 * t734 - t738 * t250 - t244 * t745
  t748 = t747 * t260
  t753 = t259 ** 2
  t754 = 0.1e1 / t753
  t755 = t252 * t754
  t756 = t268 * t121
  t759 = t594 * t273
  t760 = t278 * t285
  t773 = 0.33843946638888888888888888888888888888888888888889e-3 * t104 * t438 * t253 - 0.25382959979166666666666666666666666666666666666667e-3 * t446 * t447 * t253 - 0.50765919958333333333333333333333333333333333333334e-3 * t104 * t106 * t241 * t734 - 0.4e1 * t244 * t738
  t775 = t760 * t304 * t773
  t787 = t261 * t756
  t796 = t273 * t136
  t807 = -0.10363333333333333333333333333333333333333333333334e-1 * t485 * t275 - 0.12954166666666666666666666666666666666666666666667e-2 * t488 * t796 * t123 + 0.86436094927162885408333333333333333333333333333337e-5 * t496 * t273 * t497 * t500 - 0.23032508333333333333333333333333333333333333333334e-3 * t496 * t796 * t4
  t814 = t325 * t278
  t816 = t331 * t304
  t817 = t816 * t442
  t858 = (0.29499062500000000000000000000000000000000000000000e-2 * (t539 + t540 + 0.2e1 * t711 - 0.36623110073506319882614459966279143890273293327587e-3 * t713 - 0.11696446794910408141662685001236899248561775660981e1 * t716) * t159 * t294 - 0.58998125000000000000000000000000000000000000000000e-2 * t292 * t103 * t13 * t253 * t1 * t550 - 0.29499062500000000000000000000000000000000000000000e-2 * t293 * t105 * t241 * t734 - 0.14341111111111111111111111111111111111111111111111e-1 * t102 * t9 * t250 - 0.21511666666666666666666666666666666666666666666667e-1 * t102 * t164 * t745) * t260
  t860 = t300 * t754
  t864 = 0.14341111111111111111111111111111111111111111111111e-1 * t151 * t8 * t252 * t260 + 0.21511666666666666666666666666666666666666666666667e-1 * t151 * t21 * t747 * t260 - 0.21511666666666666666666666666666666666666666666667e-1 * t151 * t286 * t754 * t773 - t858 * t244 + t860 * t244 * t773 - t301 * t738
  t866 = t760 * t333 * t864
  t870 = t346 + t367 + t711 - t714 - t717 - 0.35852777777777777777777777777777777777777777777778e-1 * t386 * t269 * t307 + 0.21511666666666666666666666666666666666666666666667e-1 * t58 * t748 * t268 * t307 - 0.21511666666666666666666666666666666666666666666667e-1 * t58 * t755 * t756 * t759 * t775 - 0.47845209701935943474444444444444444444444444444446e-4 * t464 * t261 * t268 * t1 * t3 * t124 * s0 * t306 + 0.12749247777777777777777777777777777777777777777778e-2 * t464 * t787 * t476 * t279 * t305 * t4 + 0.21511666666666666666666666666666666666666666666667e-1 * t270 * t126 * t273 * t807 * t305 + 0.16731296296296296296296296296296296296296296296297e-1 * t515 * t787 * t520 * t814 * t817 - 0.21511666666666666666666666666666666666666666666667e-1 * t58 * t787 * t759 * t866
  t872 = t339 ** 2
  t874 = t310 / t872
  t880 = t125 * t142
  t888 = t760 * t304
  t912 = t618 * t325 * t1
  t913 = t101 * t278
  t914 = t913 * t816
  t928 = t189 * t190 * t195
  t931 = t325 * t1 * t101
  t932 = t328 * t331
  t938 = t190 * t644
  t945 = t325 * t18 * t144 * t932 * t333 * t6
  t955 = t322 * t928
  t964 = 0.1e1 / t324 / t272
  t970 = t328 / t330 / t284 * t333
  t981 = t858 * t268 * t126 * t317 / 0.3e1 - t860 * t268 * t880 * t281 * t775 / 0.3e1 - 0.55603792169291016666666666666666666666666666666667e-3 * t301 * t268 * t6 * t483 * t759 * t888 + 0.14816666666666666666666666666666666666666666666667e-1 * t311 * t640 * s0 * t483 * t273 * t278 * t305 * t6 - 0.7e1 / 0.9e1 * t312 * t421 * t273 * t18 * t316 + t312 * t314 * t144 * t807 * t305 / 0.3e1 + 0.7e1 / 0.9e1 * t311 * t615 * t912 * t914 - t311 * t880 * t281 * t866 / 0.3e1 - t748 * t321 * t191 * t336 / 0.3e1 + t755 * t321 * t928 * t931 * t932 * t333 * t773 / 0.3e1 + 0.37069194779527344444444444444444444444444444444443e-3 * t322 * t640 * t938 * t945 - 0.98777777777777777777777777777777777777777777777780e-2 * t322 * t654 * t938 * t945 + 0.14e2 / 0.9e1 * t323 * t912 * t335 - 0.2e1 / 0.3e1 * t955 * t931 * t278 * t331 * t333 * t807 - 0.14e2 / 0.9e1 * t322 * t668 * t671 * t964 * jnp.pi * t970 + 0.2e1 / 0.3e1 * t955 * t931 * t932 / t332 / t303 * t864
  vrho_0_ = t210 + t41 * (t310 * t340 - t210) + r0 * (t578 - t688 + t41 * (t870 * t340 - t874 * t981 - t578 + t688))
  t990 = t473 * t124
  t995 = 0.1e1 / t7 / t193
  t999 = t516 * s0
  t1001 = t131 * t149 * t172
  t1005 = t55 * t493
  t1012 = (0.49745833333333333333333333333333333333333333333332e-2 * t55 * t57 * t100 * t114 * t990 * t173 + 0.96665481510416666666666666666666666666666666666664e-5 * t463 * t995 * t100 * t114 * t999 * t1001 - 0.10363715277777777777777777777777777777777777777777e-3 * t1005 * t518 * t594 * t141 * t523) * t209
  t1018 = t442 * t6
  t1026 = t189 * s0
  t1031 = t193 * t416
  t1033 = 0.1e1 / t7 / t1031
  t1038 = t6 * t131
  t1044 = 0.1e1 / t1031
  t1050 = t581 * (t169 * t990 * t182 / 0.48e2 + 0.10120768229166666666666666666666666666666666666667e-4 * t169 * t999 * t514 * t1018 * t1001 - t614 * t126 * t197 * t622 / 0.768e3 - t185 * t1026 * t205 / 0.384e3 - 0.12650960286458333333333333333333333333333333333334e-5 * t115 * t121 * t520 * t1033 * t102 * t141 * t200 * t203 * t1038 + t115 * t191 * t1044 * jnp.pi * t676 / 0.6144e4)
  t1061 = t131 * t285 * t304
  vsigma_0_ = r0 * (t1012 - t1050 + t41 * ((0.21511666666666666666666666666666666666666666666667e-1 * t270 * t125 * t273 * t888 + 0.33439885833333333333333333333333333333333333333334e-3 * t463 * t995 * t252 * t260 * t268 * s0 * t325 * t1061 - 0.71705555555555555555555555555555555555555555555557e-2 * t1005 * t787 * t594 * t814 * t817) * t340 - t874 * (t311 * t125 * t94 * t281 * t888 / 0.3e1 + 0.12954166666666666666666666666666666666666666666667e-2 * t311 * s0 * t514 * t325 * t1018 * t1061 - t312 * t327 * t914 / 0.3e1 - 0.2e1 / 0.3e1 * t322 * t1026 * t336 - 0.25908333333333333333333333333333333333333333333334e-2 * t322 * t125 * t190 * t1033 * t964 * t1 * t913 * t334 * t1038 + 0.2e1 / 0.3e1 * t323 * t1044 * t964 * jnp.pi * t970) - t1012 + t1050))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res
