"""Generated from gga_c_pw91.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw91(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw91(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw91(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615790870000000000000000000000000000000000000000e0 * t14 + 0.55771035800000000000000000000000000000000000000000e-1 * t11 + 0.12733319050000000000000000000000000000000000000000e-1 * t17 + 0.76629987700000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21947830050000000000000000000000000000000000000000e0 * t14 + 0.48171623250000000000000000000000000000000000000000e-1 * t11 + 0.13081894750000000000000000000000000000000000000000e-1 * t17 + 0.48591338250000000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489865900000000000000000000000000000000000000000e0 * t14 + 0.30591644850000000000000000000000000000000000000000e-1 * t11 + 0.37162376550000000000000000000000000000000000000000e-2 * t17 + 0.41939708850000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482233974552040708313425006184496242808878304904e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t85 = t58 * t80
  t86 = 0.58482233974552040708313425006184496242808878304904e0 * t85
  t87 = jnp.pi ** 2
  t88 = 0.1e1 / t87
  t89 = t88 * t19
  t90 = t87 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = jnp.pi * t19
  t103 = 0.1e1 / t90
  t105 = s0 + 0.2e1 * s1 + s2
  t107 = 0.1e1 / t8 / t35
  t108 = t105 * t107
  t110 = 0.1e1 / t99
  t112 = 0.1e1 / t3
  t113 = t112 * t5
  t114 = t110 * t19 * t113
  t117 = jnp.pi * t103
  t122 = (-0.18e0 * t31 + 0.18e0 * t84 + 0.10526802115419367327496416501113209323705598094883e0 * t85) * t87
  t123 = 0.1e1 / t91
  t125 = 0.1e1 / t100
  t126 = t1 * t123 * t125
  t129 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * t122 * t126)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t132 = t105 ** 2
  t133 = t131 * t132
  t134 = t117 * t133
  t136 = 0.1e1 / t22 / t36
  t137 = t54 ** 2
  t138 = t136 * t137
  t139 = t99 ** 2
  t140 = 0.1e1 / t139
  t141 = 0.1e1 / t20
  t143 = t140 * t141 * t6
  t144 = t138 * t143
  t147 = t108 * t54 * t114 / 0.96e2 + 0.86472476387249114521841794569067296340023612750885e-3 * t134 * t144
  t149 = jnp.pi * t1
  t150 = t103 * t131
  t152 = t149 * t150 * t105
  t153 = t107 * t54
  t155 = t110 * t112 * t5
  t156 = t153 * t155
  t159 = t87 * t19
  t160 = t130 ** 2
  t161 = 0.1e1 / t160
  t162 = t123 * t161
  t164 = t159 * t162 * t132
  t167 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t152 * t156 + 0.76569489126843962091359322227627476098013824749896e-3 * t164 * t144
  t168 = 0.1e1 / t167
  t172 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * t147 * t168
  t173 = jnp.log(t172)
  t176 = 0.25507875555555555555555555555555555555555555555556e-1 * t89 * t91 * t100 * t173
  t177 = t2 * t90
  t180 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t11 + 0.18472500000000000000000000000000000000000000000000e-2 * t25
  t183 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t11 + 0.11800000000000000000000000000000000000000000000000e3 * t25
  t184 = 0.1e1 / t183
  t186 = t180 * t184 - 0.18535714285714285714285714285714285714285714285714e-2
  t187 = t186 * t98
  t189 = t177 * t187 * t105
  t190 = 9 ** (0.1e1 / 0.3e1)
  t191 = t190 ** 2
  t192 = t2 * t191
  t196 = t192 * t3 / t22 / t35
  t198 = t54 * t5
  t199 = t99 * t105 * t198
  t202 = jnp.exp(-0.25e2 / 0.18e2 * t196 * t199)
  t203 = t113 * t202
  t204 = t153 * t203
  t206 = t189 * t204 / 0.2e1
  t208 = 0.1e1 / t8 / t7
  t209 = t6 * t208
  t211 = t4 * t209 * t30
  t212 = 0.11073577833333333333333333333333333333333333333333e-2 * t211
  t213 = t27 ** 2
  t218 = t3 * t6
  t219 = t218 * t208
  t220 = 0.1e1 / t14 * t1 * t219
  t222 = t4 * t209
  t224 = t11 ** 0.5e0
  t226 = t224 * t1 * t219
  t231 = t21 * t5 / t22 / t7
  t236 = t13 / t213 * (-0.39359651450000000000000000000000000000000000000000e-1 * t220 - 0.18590345266666666666666666666666666666666666666667e-1 * t222 - 0.63666595250000000000000000000000000000000000000000e-2 * t226 - 0.51086658466666666666666666666666666666666666666667e-2 * t231) / t29
  t239 = t33 * t32 * t37 * t83
  t240 = 0.4e1 * t239
  t241 = t36 * t7
  t242 = 0.1e1 / t241
  t244 = t34 * t242 * t83
  t245 = 0.4e1 * t244
  t247 = t32 / t35
  t248 = t39 - t247
  t251 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t248)
  t252 = -t248
  t255 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t252)
  t257 = (t251 + t255) * t57
  t259 = t38 * t257 * t82
  t263 = t65 ** 2
  t277 = t76 ** 2
  t278 = 0.1e1 / t277
  t284 = -0.29149776500000000000000000000000000000000000000000e-1 * t220 - 0.10197214950000000000000000000000000000000000000000e-1 * t222 - 0.18581188275000000000000000000000000000000000000000e-2 * t226 - 0.27959805900000000000000000000000000000000000000000e-2 * t231
  t285 = 0.1e1 / t78
  t291 = t38 * t58 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t209 * t68 + t60 / t263 * (-0.36579716750000000000000000000000000000000000000000e-1 * t220 - 0.16057207750000000000000000000000000000000000000000e-1 * t222 - 0.65409473750000000000000000000000000000000000000000e-2 * t226 - 0.32394225500000000000000000000000000000000000000000e-2 * t231) / t67 - t212 - t236 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t209 * t79 + 0.58482233974552040708313425006184496242808878304904e0 * t71 * t278 * t284 * t285)
  t292 = t257 * t80
  t297 = t58 * t1 * t218 * t208 * t79
  t298 = 0.18311555036753159941307229983139571945136646663793e-3 * t297
  t302 = t58 * t71 * t278 * t284 * t285
  t303 = 0.58482233974552040708313425006184496242808878304904e0 * t302
  t304 = t89 * t91
  t305 = t99 * t173
  t306 = 0.1e1 / t45
  t309 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t306 * t248)
  t310 = 0.1e1 / t50
  t313 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t310 * t252)
  t315 = t309 / 0.2e1 + t313 / 0.2e1
  t319 = t35 * t7
  t321 = 0.1e1 / t8 / t319
  t325 = 0.7e1 / 0.288e3 * t105 * t321 * t54 * t114
  t327 = t108 * t54 * t125
  t328 = t19 * t112
  t335 = t117 * t161 * t132 * t136
  t337 = t137 * t140 * t141
  t338 = 0.19932440099999999999999999999999999999999999999999e-3 * t211
  t339 = 0.18e0 * t236
  t340 = 0.72e0 * t239
  t341 = 0.72e0 * t244
  t343 = 0.18e0 * t291
  t345 = 0.32960799066155687894353013969651229501245963994829e-4 * t297
  t346 = 0.10526802115419367327496416501113209323705598094883e0 * t302
  t351 = t122 * t1
  t352 = t123 * t140
  t356 = -0.72599219320266867760696246260269014374413107911013e2 * (t338 + t339 + t340 - t341 + 0.18e0 * t259 + t343 + 0.10526802115419367327496416501113209323705598094883e0 * t292 - t345 - t346) * t87 * t126 + 0.21779765796080060328208873878080704312323932373304e3 * t351 * t352 * t315
  t359 = t337 * t6 * t356 * t129
  t365 = 0.1e1 / t22 / t241 * t137 * t143
  t367 = 0.40353822314049586776859504132231404958677685950413e-2 * t134 * t365
  t369 = t117 * t133 * t136
  t371 = 0.1e1 / t139 / t98
  t372 = t137 * t371
  t373 = t141 * t6
  t374 = t373 * t315
  t383 = t102 * t103
  t384 = t167 ** 2
  t386 = t147 / t384
  t390 = t149 * t103 * t161 * t105 * t107
  t392 = t54 * t110 * t112
  t398 = t321 * t54
  t401 = 0.64566115702479338842975206611570247933884297520660e-1 * t152 * t398 * t155
  t402 = t153 * t125
  t412 = t159 * t123 / t160 / t130 * t132 * t136
  t416 = 0.35732428259193848975967683706226155512406451549951e-2 * t164 * t365
  t417 = t138 * t371
  t427 = 0.1e1 / t172
  t435 = t183 ** 2
  t447 = t177 * ((-0.19388333333333333333333333333333333333333333333333e1 * t222 - 0.12315000000000000000000000000000000000000000000000e-2 * t231) * t184 - t180 / t435 * (-0.72691666666666666666666666666666666666666666666667e3 * t222 - 0.78666666666666666666666666666666666666666666666667e2 * t231)) * t98 * t105 * t204 / 0.2e1
  t455 = 0.7e1 / 0.6e1 * t189 * t398 * t203
  t456 = t153 * t112
  t462 = 0.100e3 / 0.27e2 * t192 * t3 / t22 / t319 * t199
  t463 = t98 * t105
  t474 = t212 + t236 + t240 - t245 + t259 + t291 + 0.58482233974552040708313425006184496242808878304904e0 * t292 - t298 - t303 + 0.76523626666666666666666666666666666666666666666668e-1 * t304 * t305 * t315 + 0.25507875555555555555555555555555555555555555555556e-1 * t304 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (-t325 - t327 * t328 * t5 * t315 / 0.48e2 - 0.86472476387249114521841794569067296340023612750885e-3 * t335 * t359 - t367 - 0.34588990554899645808736717827626918536009445100354e-2 * t369 * t372 * t374) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t383 * t386 * (-0.27671192443919716646989374262101534828807556080283e-1 * t390 * t392 * t5 * t356 * t129 - t401 - 0.55342384887839433293978748524203069657615112160566e-1 * t152 * t402 * t113 * t315 - 0.15313897825368792418271864445525495219602764949979e-2 * t412 * t359 - t416 - 0.30627795650737584836543728891050990439205529899958e-2 * t164 * t417 * t374)) * t427 + t447 + t177 * t186 * t315 * t105 * t204 / 0.2e1 - t455 + t189 * t456 * t5 * (t462 - 0.25e2 / 0.9e1 * t196 * t463 * t198 * t315) * t202 / 0.2e1
  vrho_0_ = t7 * t474 + t176 + t206 - t31 + t84 + t86
  t476 = -t39 - t247
  t479 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t476)
  t480 = -t476
  t483 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t480)
  t485 = (t479 + t483) * t57
  t487 = t38 * t485 * t82
  t488 = t485 * t80
  t492 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t306 * t476)
  t495 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t310 * t480)
  t497 = t492 / 0.2e1 + t495 / 0.2e1
  t514 = -0.72599219320266867760696246260269014374413107911013e2 * (t338 + t339 - t340 - t341 + 0.18e0 * t487 + t343 + 0.10526802115419367327496416501113209323705598094883e0 * t488 - t345 - t346) * t87 * t126 + 0.21779765796080060328208873878080704312323932373304e3 * t351 * t352 * t497
  t517 = t337 * t6 * t514 * t129
  t520 = t373 * t497
  t567 = t212 + t236 - t240 - t245 + t487 + t291 + 0.58482233974552040708313425006184496242808878304904e0 * t488 - t298 - t303 + 0.76523626666666666666666666666666666666666666666668e-1 * t304 * t305 * t497 + 0.25507875555555555555555555555555555555555555555556e-1 * t304 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (-t325 - t327 * t328 * t5 * t497 / 0.48e2 - 0.86472476387249114521841794569067296340023612750885e-3 * t335 * t517 - t367 - 0.34588990554899645808736717827626918536009445100354e-2 * t369 * t372 * t520) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t383 * t386 * (-0.27671192443919716646989374262101534828807556080283e-1 * t390 * t392 * t5 * t514 * t129 - t401 - 0.55342384887839433293978748524203069657615112160566e-1 * t152 * t402 * t113 * t497 - 0.15313897825368792418271864445525495219602764949979e-2 * t412 * t517 - t416 - 0.30627795650737584836543728891050990439205529899958e-2 * t164 * t417 * t520)) * t427 + t447 + t177 * t186 * t497 * t105 * t204 / 0.2e1 - t455 + t189 * t456 * t5 * (t462 - 0.25e2 / 0.9e1 * t196 * t463 * t198 * t497) * t202 / 0.2e1
  vrho_1_ = t7 * t567 + t176 + t206 - t31 + t84 + t86
  t571 = t153 * t110 * t328 * t5
  t575 = t117 * t131 * t105 * t144
  t583 = t149 * t150 * t156
  t587 = t159 * t162 * t105 * t144
  t599 = t177 * t187 * t204
  t609 = t88 * t90 * t186 * t100 * t105 * t242 * t137 * t6 * t191 * t202
  vsigma_0_ = t7 * (0.25507875555555555555555555555555555555555555555556e-1 * t304 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t571 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t575) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t383 * t386 * (0.27671192443919716646989374262101534828807556080283e-1 * t583 + 0.15313897825368792418271864445525495219602764949979e-2 * t587)) * t427 + t599 / 0.2e1 - 0.25e2 / 0.36e2 * t609)
  vsigma_1_ = t7 * (0.25507875555555555555555555555555555555555555555556e-1 * t304 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t571 / 0.48e2 + 0.34588990554899645808736717827626918536009445100354e-2 * t575) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t383 * t386 * (0.55342384887839433293978748524203069657615112160566e-1 * t583 + 0.30627795650737584836543728891050990439205529899958e-2 * t587)) * t427 + t599 - 0.25e2 / 0.18e2 * t609)
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw91(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615790870000000000000000000000000000000000000000e0 * t13 + 0.55771035800000000000000000000000000000000000000000e-1 * t10 + 0.12733319050000000000000000000000000000000000000000e-1 * t16 + 0.76629987700000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489865900000000000000000000000000000000000000000e0 * t13 + 0.30591644850000000000000000000000000000000000000000e-1 * t10 + 0.37162376550000000000000000000000000000000000000000e-2 * t16 + 0.41939708850000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t53 = t41 * t43 * t51
  t55 = jnp.pi ** 2
  t56 = 0.1e1 / t55
  t57 = t56 * t18
  t58 = t55 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = jnp.pi * t18
  t66 = 0.1e1 / t58
  t67 = r0 ** 2
  t69 = 0.1e1 / t7 / t67
  t72 = 0.1e1 / t62
  t74 = 0.1e1 / t3
  t75 = t74 * t5
  t76 = t72 * t18 * t75
  t79 = jnp.pi * t66
  t84 = 0.1e1 / t59
  t90 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * (-0.18e0 * t30 + 0.10526802115419367327496416501113209323705598094883e0 * t53) * t55 * t1 * t84 / t63)
  t91 = t90 - 0.1e1
  t92 = 0.1e1 / t91
  t93 = s0 ** 2
  t95 = t79 * t92 * t93
  t96 = t67 ** 2
  t98 = 0.1e1 / t21 / t96
  t99 = t37 ** 2
  t101 = t62 ** 2
  t103 = 0.1e1 / t19
  t105 = 0.1e1 / t101 * t103 * t6
  t106 = t98 * t99 * t105
  t109 = s0 * t69 * t37 * t76 / 0.96e2 + 0.86472476387249114521841794569067296340023612750885e-3 * t95 * t106
  t111 = jnp.pi * t1
  t112 = t66 * t92
  t114 = t111 * t112 * s0
  t115 = t69 * t37
  t117 = t72 * t74 * t5
  t118 = t115 * t117
  t121 = t55 * t18
  t122 = t91 ** 2
  t123 = 0.1e1 / t122
  t124 = t84 * t123
  t126 = t121 * t124 * t93
  t129 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t114 * t118 + 0.76569489126843962091359322227627476098013824749896e-3 * t126 * t106
  t130 = 0.1e1 / t129
  t134 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * t109 * t130
  t135 = jnp.log(t134)
  t139 = t2 * t58
  t142 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t10 + 0.18472500000000000000000000000000000000000000000000e-2 * t24
  t145 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t10 + 0.11800000000000000000000000000000000000000000000000e3 * t24
  t146 = 0.1e1 / t145
  t148 = t142 * t146 - 0.18535714285714285714285714285714285714285714285714e-2
  t149 = t148 * t61
  t151 = t139 * t149 * s0
  t152 = 9 ** (0.1e1 / 0.3e1)
  t153 = t152 ** 2
  t164 = jnp.exp(-0.25e2 / 0.18e2 * t2 * t153 * t3 / t21 / t67 * t62 * s0 * t37 * t5)
  t165 = t75 * t164
  t166 = t115 * t165
  t170 = 0.1e1 / t7 / r0
  t171 = t6 * t170
  t173 = t4 * t171 * t29
  t175 = t26 ** 2
  t180 = t3 * t6
  t181 = t180 * t170
  t182 = 0.1e1 / t13 * t1 * t181
  t184 = t4 * t171
  t186 = t10 ** 0.5e0
  t188 = t186 * t1 * t181
  t193 = t20 * t5 / t21 / r0
  t198 = t12 / t175 * (-0.39359651450000000000000000000000000000000000000000e-1 * t182 - 0.18590345266666666666666666666666666666666666666667e-1 * t184 - 0.63666595250000000000000000000000000000000000000000e-2 * t188 - 0.51086658466666666666666666666666666666666666666667e-2 * t193) / t28
  t202 = t41 * t1 * t180 * t170 * t51
  t205 = t48 ** 2
  t215 = t41 * t43 / t205 * (-0.29149776500000000000000000000000000000000000000000e-1 * t182 - 0.10197214950000000000000000000000000000000000000000e-1 * t184 - 0.18581188275000000000000000000000000000000000000000e-2 * t188 - 0.27959805900000000000000000000000000000000000000000e-2 * t193) / t50
  t217 = t57 * t59
  t220 = 0.1e1 / t7 / t67 / r0
  t230 = 0.1e1 / t101 / t63
  t237 = 0.19932440099999999999999999999999999999999999999999e-3 * t173 + 0.18e0 * t198 - 0.32960799066155687894353013969651229501245963994829e-4 * t202 - 0.10526802115419367327496416501113209323705598094883e0 * t215
  t243 = t96 * r0
  t247 = 0.1e1 / t21 / t243 * t99 * t105
  t255 = t65 * t66
  t256 = t129 ** 2
  t258 = t109 / t256
  t271 = t220 * t37
  t275 = t55 ** 2
  t299 = 0.1e1 / t134
  t307 = t145 ** 2
  t323 = t56 * t58
  t324 = t148 * t63
  t331 = t6 * t153 * t164
  vrho_0_ = -t30 + 0.58482233974552040708313425006184496242808878304904e0 * t53 + 0.25507875555555555555555555555555555555555555555556e-1 * t57 * t59 * t63 * t135 + t151 * t166 / 0.2e1 + r0 * (0.11073577833333333333333333333333333333333333333333e-2 * t173 + t198 - 0.18311555036753159941307229983139571945136646663793e-3 * t202 - 0.58482233974552040708313425006184496242808878304904e0 * t215 + 0.25507875555555555555555555555555555555555555555556e-1 * t217 * t63 * (0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * (-0.7e1 / 0.288e3 * s0 * t220 * t37 * t76 + 0.62778342784044964327823135763173517724332468147298e-1 * jnp.pi * t123 * t93 * t98 * t99 * t230 * t103 * t6 * t237 * t1 * t90 - 0.40353822314049586776859504132231404958677685950413e-2 * t95 * t247) * t130 - 0.88547815820543093270365997638724911452184179456905e0 * t255 * t258 * (0.20089069690894388584903403444215525671786389807135e1 * t65 * t123 * s0 * t69 * t37 / t101 / t61 * t74 * t5 * t237 * t90 - 0.64566115702479338842975206611570247933884297520660e-1 * t114 * t271 * t117 + 0.33353310806163204188335786414909188873612291223475e0 * t275 / t58 / t55 / t122 / t91 * t93 * t98 * t99 * t230 * t103 * t6 * t237 * t90 - 0.35732428259193848975967683706226155512406451549951e-2 * t126 * t247)) * t299 + t139 * ((-0.19388333333333333333333333333333333333333333333333e1 * t184 - 0.12315000000000000000000000000000000000000000000000e-2 * t193) * t146 - t142 / t307 * (-0.72691666666666666666666666666666666666666666666667e3 * t184 - 0.78666666666666666666666666666666666666666666666667e2 * t193)) * t61 * s0 * t166 / 0.2e1 - 0.7e1 / 0.6e1 * t151 * t271 * t165 + 0.50e2 / 0.27e2 * t323 * t324 * t93 / t96 / t67 * t99 * t331)
  vsigma_0_ = r0 * (0.25507875555555555555555555555555555555555555555556e-1 * t217 * t63 * (0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * (t115 * t72 * t18 * t74 * t5 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t79 * t92 * s0 * t106) * t130 - 0.88547815820543093270365997638724911452184179456905e0 * t255 * t258 * (0.27671192443919716646989374262101534828807556080283e-1 * t111 * t112 * t118 + 0.15313897825368792418271864445525495219602764949979e-2 * t121 * t124 * s0 * t106)) * t299 + t139 * t149 * t166 / 0.2e1 - 0.25e2 / 0.36e2 * t323 * t324 * s0 / t243 * t99 * t331)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.pi ** 2
  t103 = 0.1e1 / t102
  t105 = t102 ** (0.1e1 / 0.3e1)
  t106 = t105 ** 2
  t107 = t103 * t19 * t106
  t108 = t63 ** 2
  t109 = f.my_piecewise3(t62, t108, 1)
  t110 = t109 ** 2
  t111 = t110 * t109
  t112 = jnp.pi * t19
  t113 = 0.1e1 / t105
  t114 = r0 ** 2
  t115 = t114 * r0
  t117 = 0.1e1 / t7 / t115
  t120 = 0.1e1 / t110
  t122 = 0.1e1 / t3
  t123 = t122 * t5
  t124 = t120 * t19 * t123
  t136 = 0.1e1 / t106
  t140 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-0.62182e-1 * t36 * t31 + 0.19751789702565206228825776161588751761046270558698e-1 * t72 * t88 * t82) / t111 * t102 * t1 * t136)
  t141 = t140 - 0.1e1
  t142 = t141 ** 2
  t143 = 0.1e1 / t142
  t144 = jnp.pi * t143
  t145 = s0 ** 2
  t146 = t114 ** 2
  t148 = 0.1e1 / t22 / t146
  t150 = t68 ** 2
  t151 = t145 * t148 * t150
  t152 = t144 * t151
  t153 = t110 ** 2
  t155 = 0.1e1 / t153 / t111
  t156 = 0.1e1 / t20
  t158 = t155 * t156 * t6
  t163 = 0.11073577833333333333333333333333333333333333333333e-2 * t33 + 0.10000000000000000000000000000000000000000000000000e1 * t60 - 0.18311555036753159941307229983139571945136646663793e-3 * t85 - 0.58482233974552040708313425006184496242808878304903e0 * t100
  t166 = t158 * t163 * t1 * t140
  t169 = jnp.pi * t113
  t170 = 0.1e1 / t141
  t172 = t169 * t170 * t145
  t173 = t146 * r0
  t175 = 0.1e1 / t22 / t173
  t177 = 0.1e1 / t153
  t179 = t177 * t156 * t6
  t180 = t175 * t150 * t179
  t183 = -0.7e1 / 0.288e3 * s0 * t117 * t68 * t124 + 0.11300101701128093579008164437371233190379844266515e-1 * t152 * t166 - 0.40353822314049586776859504132231404958677685950414e-2 * t172 * t180
  t185 = jnp.pi * t1
  t186 = t113 * t170
  t188 = t185 * t186 * s0
  t190 = 0.1e1 / t7 / t114
  t191 = t190 * t68
  t193 = t120 * t122 * t5
  t194 = t191 * t193
  t197 = t102 * t19
  t198 = t136 * t143
  t200 = t197 * t198 * t145
  t201 = t148 * t150
  t202 = t201 * t179
  t205 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t188 * t194 + 0.76569489126843962091359322227627476098013824749894e-3 * t200 * t202
  t206 = 0.1e1 / t205
  t210 = t112 * t113
  t212 = s0 * t190 * t68
  t217 = t212 * t124 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t172 * t202
  t218 = t205 ** 2
  t219 = 0.1e1 / t218
  t220 = t217 * t219
  t221 = t143 * s0
  t223 = t112 * t221 * t190
  t224 = t153 * t109
  t225 = 0.1e1 / t224
  t227 = t68 * t225 * t122
  t229 = t5 * t163 * t140
  t230 = t227 * t229
  t233 = t117 * t68
  t234 = t233 * t193
  t237 = t102 ** 2
  t240 = t237 / t105 / t102
  t242 = 0.1e1 / t142 / t141
  t243 = t242 * t145
  t245 = t240 * t243 * t148
  t247 = t150 * t155 * t156
  t250 = t247 * t6 * t163 * t140
  t255 = 0.36160325443609899452826126199587946209215501652845e0 * t223 * t230 - 0.64566115702479338842975206611570247933884297520660e-1 * t188 * t234 + 0.60035959451093767539004415546836539972502124202256e-1 * t245 * t250 - 0.35732428259193848975967683706226155512406451549951e-2 * t200 * t180
  t259 = 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t183 * t206 - 0.88547815820543093270365997638724911452184179456906e0 * t210 * t220 * t255
  t265 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t217 * t206
  t266 = 0.1e1 / t265
  t270 = t2 * t105
  t273 = -0.19388333333333333333333333333333333333333333333333e1 * t46 - 0.12315000000000000000000000000000000000000000000000e-2 * t55
  t276 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t13 + 0.11800000000000000000000000000000000000000000000000e3 * t25
  t277 = 0.1e1 / t276
  t281 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t13 + 0.18472500000000000000000000000000000000000000000000e-2 * t25
  t282 = t276 ** 2
  t283 = 0.1e1 / t282
  t284 = t281 * t283
  t287 = -0.72691666666666666666666666666666666666666666666667e3 * t46 - 0.78666666666666666666666666666666666666666666666667e2 * t55
  t289 = t273 * t277 - t284 * t287
  t290 = t289 * t109
  t292 = t270 * t290 * s0
  t294 = 9 ** (0.1e1 / 0.3e1)
  t295 = t294 ** 2
  t299 = 0.1e1 / t22 / t114
  t305 = jnp.exp(-0.25e2 / 0.18e2 * t2 * t5 * t295 * t3 * t299 * t110 * s0 * t68)
  t306 = t123 * t305
  t307 = t191 * t306
  t310 = t281 * t277 - 0.18535714285714285714285714285714285714285714285714e-2
  t311 = t310 * t109
  t313 = t270 * t311 * s0
  t314 = t233 * t306
  t317 = t103 * t105
  t318 = t310 * t111
  t320 = t317 * t318 * t145
  t321 = t146 * t114
  t322 = 0.1e1 / t321
  t325 = t6 * t295 * t305
  t326 = t322 * t150 * t325
  t329 = t6 * t190
  t332 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t329 * t31
  t337 = 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t6 * t9 * t38 * t59
  t341 = t57 ** 2
  t344 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t341 * t58
  t349 = t20 * t5 * t299
  t350 = 0.1e1 / t14 / t13 * t19 * t349
  t352 = t42 * t190
  t353 = t41 * t352
  t355 = t4 * t329
  t357 = t13 ** (-0.5e0)
  t359 = t357 * t19 * t349
  t361 = t49 * t352
  t364 = t21 * t5 * t299
  t369 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t350 + 0.84396666666666666666666666666666666666666666666666e0 * t353 + 0.39862222222222222222222222222222222222222222222223e0 * t355 + 0.68258333333333333333333333333333333333333333333333e-1 * t359 + 0.13651666666666666666666666666666666666666666666667e0 * t361 + 0.13692777777777777777777777777777777777777777777778e0 * t364) * t58
  t370 = t37 ** 2
  t373 = t30 ** 2
  t377 = 0.16081824322151104821330931780901225435013347914188e2 * t36 / t370 * t341 / t373
  t381 = 0.24415406715670879921742973310852762593515528885057e-3 * t73 * t42 * t190 * t82
  t385 = 0.10843580882781524214666447553230042011687479519034e-1 * t72 * t4 * t10 * t99
  t388 = t96 ** 2
  t392 = 0.11696446794910408141662685001236899248561775660981e1 * t89 / t90 / t78 * t388 * t98
  t403 = 0.58482233974552040708313425006184496242808878304903e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t350 + 0.11507777777777777777777777777777777777777777777778e1 * t353 + 0.40256666666666666666666666666666666666666666666667e0 * t355 + 0.36677500000000000000000000000000000000000000000000e-1 * t359 + 0.73355000000000000000000000000000000000000000000000e-1 * t361 + 0.13797500000000000000000000000000000000000000000000e0 * t364) * t98
  t404 = t90 ** 2
  t407 = t81 ** 2
  t411 = 0.17315755899375863299672358916972966258900005419821e2 * t89 / t404 * t388 / t407
  t413 = 0.1e1 / t7 / t146
  t418 = t102 * jnp.pi
  t419 = t418 * t242
  t421 = t153 ** 2
  t423 = 0.1e1 / t421 / t110
  t424 = t201 * t423
  t426 = t156 * t6
  t427 = t163 ** 2
  t428 = t426 * t427
  t429 = t140 ** 2
  t440 = -t332 - t337 - t344 + t369 + t377 + t381 + t385 + t392 - t403 - t411
  t446 = t418 * t143
  t457 = 0.1e1 / t22 / t321 * t150 * t179
  t465 = t183 * t219
  t471 = t217 / t218 / t205
  t472 = t255 ** 2
  t479 = 0.1e1 / t421 * t122 * t5
  t480 = t427 * t429
  t500 = t413 * t68
  t504 = t142 ** 2
  t509 = t423 * t156 * t6
  t541 = t259 ** 2
  t543 = t265 ** 2
  t544 = 0.1e1 / t543
  t558 = t287 ** 2
  t573 = t289 * t111
  t581 = t146 * t115
  t590 = 0.1e1 / t418 * t105 * t310 * t224
  t592 = t146 ** 2
  t598 = t294 * t3 * t305
  t602 = -t332 - t337 - t344 + t369 + t377 + t381 + t385 + t392 - t403 - t411 + 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * (0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * (0.35e2 / 0.432e3 * s0 * t413 * t68 * t124 + 0.29533628222694690839730625514972717420553976880296e0 * t419 * t145 * t424 * t428 * t19 * t429 * t136 - 0.10546761587719554007074286808213150977687854648747e0 * t144 * t145 * t175 * t150 * t166 + 0.11300101701128093579008164437371233190379844266515e-1 * t152 * t158 * t440 * t1 * t140 - 0.14766814111347345419865312757486358710276988440148e0 * t446 * t145 * t424 * t428 * t19 * t136 * t140 + 0.22867165977961432506887052341597796143250688705235e-1 * t172 * t457) * t206 - 0.17709563164108618654073199527744982290436835891381e1 * t210 * t465 * t255 + 0.17709563164108618654073199527744982290436835891381e1 * t210 * t471 * t472 - 0.88547815820543093270365997638724911452184179456906e0 * t210 * t220 * (0.28352283093786903206141400494373808723731817805082e2 * t419 * t212 * t479 * t480 * t136 - 0.16874818540351286411318858893141041564300567437994e1 * t112 * t221 * t117 * t230 + 0.36160325443609899452826126199587946209215501652845e0 * t223 * t227 * t5 * t440 * t140 - 0.14176141546893451603070700247186904361865908902541e2 * t446 * t212 * t479 * t427 * t136 * t140 + 0.21522038567493112947658402203856749311294765840220e0 * t188 * t500 * t193 + 0.23536244451380066489749908173089237613782685235180e1 * t102 / t504 * t151 * t509 * t480 * t1 - 0.56033562154354183036404121177047437307668649255439e0 * t240 * t243 * t175 * t250 + 0.60035959451093767539004415546836539972502124202256e-1 * t245 * t247 * t6 * t440 * t140 - 0.78454148171266888299166360576964125379275617450598e0 * t102 * t242 * t151 * t509 * t427 * t1 * t140 + 0.20248376013543181086381687433528154790363655878306e-1 * t200 * t457)) * t266 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * t541 * t544 + t270 * ((0.25851111111111111111111111111111111111111111111111e1 * t355 + 0.20525000000000000000000000000000000000000000000000e-2 * t364) * t277 - 0.2e1 * t273 * t283 * t287 + 0.2e1 * t281 / t282 / t276 * t558 - t284 * (0.96922222222222222222222222222222222222222222222222e3 * t355 + 0.13111111111111111111111111111111111111111111111111e3 * t364)) * t109 * s0 * t307 / 0.2e1 - 0.7e1 / 0.3e1 * t292 * t314 + 0.100e3 / 0.27e2 * t317 * t573 * t145 * t326 + 0.35e2 / 0.9e1 * t313 * t500 * t306 - 0.1250e4 / 0.81e2 * t320 / t581 * t150 * t325 + 0.40000e5 / 0.81e2 * t590 * t145 * s0 / t22 / t592 / r0 * t598
  v2rho2_0_ = 0.22147155666666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36623110073506319882614459966279143890273293327586e-3 * t85 - 0.11696446794910408141662685001236899248561775660981e1 * t100 + 0.51015751111111111111111111111111111111111111111112e-1 * t107 * t111 * t259 * t266 + t292 * t307 - 0.7e1 / 0.3e1 * t313 * t314 + 0.100e3 / 0.27e2 * t320 * t326 + r0 * t602
  t606 = t19 * t122 * t5
  t610 = t169 * t170 * s0
  t613 = t191 * t120 * t606 / 0.96e2 + 0.17294495277449822904368358913813459268004722550178e-2 * t610 * t202
  t618 = t185 * t186
  t622 = t197 * t198 * s0
  t625 = 0.27671192443919716646989374262101534828807556080283e-1 * t618 * t194 + 0.15313897825368792418271864445525495219602764949979e-2 * t622 * t202
  t629 = 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t613 * t206 - 0.88547815820543093270365997638724911452184179456906e0 * t210 * t220 * t625
  t630 = t111 * t629
  t634 = t270 * t311
  t641 = 0.1e1 / t173 * t150 * t325
  t659 = t613 * t219
  v2rhosigma_0_ = 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t630 * t266 + t634 * t307 / 0.2e1 - 0.25e2 / 0.36e2 * t317 * t318 * s0 * t641 + r0 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * (0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * (-0.7e1 / 0.288e3 * t233 * t120 * t606 + 0.22600203402256187158016328874742466380759688533030e-1 * t144 * s0 * t148 * t150 * t166 - 0.80707644628099173553719008264462809917355371900831e-2 * t610 * t180) * t206 - 0.88547815820543093270365997638724911452184179456906e0 * t210 * t659 * t255 - 0.88547815820543093270365997638724911452184179456906e0 * t210 * t465 * t625 + 0.17709563164108618654073199527744982290436835891381e1 * t210 * t471 * t625 * t255 - 0.88547815820543093270365997638724911452184179456906e0 * t210 * t220 * (0.36160325443609899452826126199587946209215501652845e0 * t112 * t143 * t190 * t68 * t225 * t122 * t229 - 0.64566115702479338842975206611570247933884297520660e-1 * t618 * t234 + 0.12007191890218753507800883109367307994500424840451e0 * t240 * t242 * s0 * t148 * t250 - 0.71464856518387697951935367412452311024812903099902e-2 * t622 * t180)) * t266 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t630 * t544 * t259 + t270 * t290 * t307 / 0.2e1 - 0.7e1 / 0.6e1 * t634 * t314 + 0.575e3 / 0.108e3 * t317 * t318 * t322 * t150 * t6 * t295 * s0 * t305 - 0.25e2 / 0.36e2 * t317 * t573 * s0 * t641 - 0.5000e4 / 0.27e2 * t590 * t145 / t22 / t592 * t598)
  t735 = t625 ** 2
  t748 = t629 ** 2
  v2sigma2_0_ = r0 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * (0.15313897825368792418271864445525495219602764949980e-2 * t197 * t136 * t170 * t148 * t150 * t177 * t426 * t206 - 0.17709563164108618654073199527744982290436835891381e1 * t210 * t659 * t625 + 0.17709563164108618654073199527744982290436835891381e1 * t210 * t471 * t735 - 0.40680366124061136884429391974536439485367439359448e-2 * t185 * t220 * t143 * t202) * t266 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * t748 * t544 - 0.25e2 / 0.18e2 * t317 * t318 * t641 + 0.625e3 / 0.9e1 * t590 * s0 / t22 / t581 * t598)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t12 * t28
  t32 = 0.1e1 / t13 / t10 * t18
  t33 = t19 * t5
  t34 = r0 ** 2
  t36 = 0.1e1 / t21 / t34
  t37 = t33 * t36
  t38 = t32 * t37
  t41 = 0.1e1 / t13 * t1
  t42 = t3 * t6
  t44 = 0.1e1 / t7 / t34
  t45 = t42 * t44
  t46 = t41 * t45
  t48 = t6 * t44
  t49 = t4 * t48
  t51 = t10 ** (-0.5e0)
  t52 = t51 * t18
  t53 = t52 * t37
  t55 = t10 ** 0.5e0
  t56 = t55 * t1
  t57 = t56 * t45
  t60 = t20 * t5 * t36
  t62 = -0.42198333333333333333333333333333333333333333333333e0 * t38 + 0.84396666666666666666666666666666666666666666666666e0 * t46 + 0.39862222222222222222222222222222222222222222222223e0 * t49 + 0.68258333333333333333333333333333333333333333333333e-1 * t53 + 0.13651666666666666666666666666666666666666666666667e0 * t57 + 0.13692777777777777777777777777777777777777777777778e0 * t60
  t65 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t26
  t66 = 0.1e1 / t65
  t67 = t62 * t66
  t68 = t29 * t67
  t70 = t27 ** 2
  t71 = 0.1e1 / t70
  t72 = t12 * t71
  t74 = 0.1e1 / t7 / r0
  t75 = t42 * t74
  t76 = t41 * t75
  t78 = t6 * t74
  t79 = t4 * t78
  t81 = t56 * t75
  t86 = t20 * t5 / t21 / r0
  t88 = -0.63297500000000000000000000000000000000000000000000e0 * t76 - 0.29896666666666666666666666666666666666666666666667e0 * t79 - 0.10238750000000000000000000000000000000000000000000e0 * t81 - 0.82156666666666666666666666666666666666666666666667e-1 * t86
  t89 = t88 ** 2
  t90 = t65 ** 2
  t91 = 0.1e1 / t90
  t92 = t89 * t91
  t93 = t72 * t92
  t96 = 0.1e1 / t27 / t26
  t97 = t12 * t96
  t98 = t89 * t66
  t99 = t97 * t98
  t101 = jnp.log(t65)
  t103 = t4 * t48 * t101
  t105 = jnp.pi ** 2
  t106 = 0.1e1 / t105
  t108 = t105 ** (0.1e1 / 0.3e1)
  t109 = t108 ** 2
  t110 = t106 * t18 * t109
  t111 = 0.1e1 <= f.p.zeta_threshold
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t113 = t112 ** 2
  t114 = f.my_piecewise3(t111, t113, 1)
  t115 = t114 ** 2
  t116 = t115 * t114
  t117 = jnp.pi * t18
  t118 = 0.1e1 / t108
  t119 = t34 ** 2
  t121 = 0.1e1 / t7 / t119
  t123 = 2 ** (0.1e1 / 0.3e1)
  t125 = 0.1e1 / t115
  t127 = 0.1e1 / t3
  t128 = t127 * t5
  t129 = t125 * t18 * t128
  t132 = t105 * jnp.pi
  t136 = f.my_piecewise3(t111, t112 * f.p.zeta_threshold, 1)
  t142 = (0.2e1 * t136 - 0.2e1) / (0.2e1 * t123 - 0.2e1)
  t144 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t149 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t152 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t149
  t153 = jnp.log(t152)
  t161 = 0.1e1 / t109
  t165 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-0.62182e-1 * t12 * t101 + 0.19751789702565206228825776161588751761046270558698e-1 * t142 * t144 * t153) / t116 * t105 * t1 * t161)
  t166 = t165 - 0.1e1
  t167 = t166 ** 2
  t169 = 0.1e1 / t167 / t166
  t170 = t132 * t169
  t171 = s0 ** 2
  t172 = t170 * t171
  t174 = 0.1e1 / t21 / t119
  t175 = t123 ** 2
  t176 = t174 * t175
  t177 = t115 ** 2
  t178 = t177 ** 2
  t180 = 0.1e1 / t178 / t115
  t181 = t176 * t180
  t182 = t172 * t181
  t183 = 0.1e1 / t19
  t184 = t183 * t6
  t188 = t88 * t66
  t191 = t142 * t1
  t196 = t142 * t144
  t197 = t149 ** 2
  t198 = 0.1e1 / t197
  t203 = -0.86308333333333333333333333333333333333333333333334e0 * t76 - 0.30192500000000000000000000000000000000000000000000e0 * t79 - 0.55016250000000000000000000000000000000000000000000e-1 * t81 - 0.82785000000000000000000000000000000000000000000000e-1 * t86
  t205 = 0.1e1 / t152
  t206 = t198 * t203 * t205
  t209 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t78 * t101 + 0.10000000000000000000000000000000000000000000000000e1 * t29 * t188 - 0.18311555036753159941307229983139571945136646663793e-3 * t191 * t42 * t74 * t153 - 0.58482233974552040708313425006184496242808878304903e0 * t196 * t206
  t210 = t209 ** 2
  t211 = t184 * t210
  t212 = t165 ** 2
  t213 = t18 * t212
  t214 = t213 * t161
  t215 = t211 * t214
  t218 = 0.1e1 / t167
  t219 = jnp.pi * t218
  t220 = t119 * r0
  t222 = 0.1e1 / t21 / t220
  t224 = t171 * t222 * t175
  t225 = t219 * t224
  t226 = t177 * t116
  t227 = 0.1e1 / t226
  t229 = t227 * t183 * t6
  t231 = t209 * t1 * t165
  t232 = t229 * t231
  t236 = t171 * t174 * t175
  t237 = t219 * t236
  t239 = t4 * t6
  t240 = t74 * t28
  t242 = t239 * t240 * t188
  t249 = t191 * t42 * t44 * t153
  t251 = t142 * t4
  t253 = t251 * t78 * t206
  t256 = 0.1e1 / t197 / t149
  t257 = t203 ** 2
  t259 = t256 * t257 * t205
  t260 = t196 * t259
  t268 = -0.57538888888888888888888888888888888888888888888889e0 * t38 + 0.11507777777777777777777777777777777777777777777778e1 * t46 + 0.40256666666666666666666666666666666666666666666667e0 * t49 + 0.36677500000000000000000000000000000000000000000000e-1 * t53 + 0.73355000000000000000000000000000000000000000000000e-1 * t57 + 0.13797500000000000000000000000000000000000000000000e0 * t60
  t270 = t198 * t268 * t205
  t271 = t196 * t270
  t273 = t197 ** 2
  t274 = 0.1e1 / t273
  t276 = t152 ** 2
  t277 = 0.1e1 / t276
  t278 = t274 * t257 * t277
  t279 = t196 * t278
  t281 = -0.14764770444444444444444444444444444444444444444444e-2 * t103 - 0.35616666666666666666666666666666666666666666666666e-1 * t242 - 0.20000000000000000000000000000000000000000000000000e1 * t99 + 0.10000000000000000000000000000000000000000000000000e1 * t68 + 0.16081824322151104821330931780901225435013347914188e2 * t93 + 0.24415406715670879921742973310852762593515528885057e-3 * t249 + 0.10843580882781524214666447553230042011687479519034e-1 * t253 + 0.11696446794910408141662685001236899248561775660981e1 * t260 - 0.58482233974552040708313425006184496242808878304903e0 * t271 - 0.17315755899375863299672358916972966258900005419821e2 * t279
  t284 = t229 * t281 * t1 * t165
  t287 = t132 * t218
  t288 = t287 * t171
  t289 = t288 * t181
  t291 = t18 * t161 * t165
  t292 = t211 * t291
  t296 = 0.1e1 / t166
  t298 = jnp.pi * t118 * t296 * t171
  t299 = t119 * t34
  t301 = 0.1e1 / t21 / t299
  t305 = 0.1e1 / t177 * t183 * t6
  t306 = t301 * t175 * t305
  t309 = 0.35e2 / 0.432e3 * s0 * t121 * t123 * t129 + 0.29533628222694690839730625514972717420553976880296e0 * t182 * t215 - 0.10546761587719554007074286808213150977687854648747e0 * t225 * t232 + 0.11300101701128093579008164437371233190379844266515e-1 * t237 * t284 - 0.14766814111347345419865312757486358710276988440148e0 * t289 * t292 + 0.22867165977961432506887052341597796143250688705235e-1 * t298 * t306
  t314 = jnp.pi * t1 * t118 * t296 * s0
  t315 = t44 * t123
  t317 = t125 * t127 * t5
  t324 = t105 * t18 * t161 * t218 * t171
  t325 = t176 * t305
  t328 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t314 * t315 * t317 + 0.76569489126843962091359322227627476098013824749894e-3 * t324 * t325
  t329 = 0.1e1 / t328
  t333 = t117 * t118
  t334 = t34 * r0
  t336 = 0.1e1 / t7 / t334
  t338 = s0 * t336 * t123
  t343 = t222 * t175
  t344 = t343 * t305
  t347 = -0.7e1 / 0.288e3 * t338 * t129 + 0.11300101701128093579008164437371233190379844266515e-1 * t237 * t232 - 0.40353822314049586776859504132231404958677685950414e-2 * t298 * t344
  t348 = t328 ** 2
  t349 = 0.1e1 / t348
  t350 = t347 * t349
  t351 = t218 * s0
  t353 = t117 * t351 * t44
  t354 = t177 * t114
  t357 = t123 / t354 * t127
  t360 = t357 * t5 * t209 * t165
  t363 = t336 * t123
  t367 = t105 ** 2
  t369 = 0.1e1 / t108 / t105
  t370 = t367 * t369
  t371 = t169 * t171
  t373 = t370 * t371 * t174
  t375 = t175 * t227 * t183
  t378 = t375 * t6 * t209 * t165
  t383 = 0.36160325443609899452826126199587946209215501652845e0 * t353 * t360 - 0.64566115702479338842975206611570247933884297520660e-1 * t314 * t363 * t317 + 0.60035959451093767539004415546836539972502124202256e-1 * t373 * t378 - 0.35732428259193848975967683706226155512406451549951e-2 * t324 * t344
  t388 = s0 * t44 * t123
  t393 = t388 * t129 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t298 * t325
  t395 = 0.1e1 / t348 / t328
  t396 = t393 * t395
  t397 = t383 ** 2
  t401 = t393 * t349
  t403 = 0.1e1 / t178
  t405 = t403 * t127 * t5
  t406 = t210 * t212
  t408 = t405 * t406 * t161
  t412 = t117 * t351 * t336
  t417 = t357 * t5 * t281 * t165
  t423 = t405 * t210 * t161 * t165
  t426 = t121 * t123
  t430 = t167 ** 2
  t431 = 0.1e1 / t430
  t432 = t105 * t431
  t435 = t180 * t183 * t6
  t437 = t435 * t406 * t1
  t441 = t370 * t371 * t222
  t446 = t375 * t6 * t281 * t165
  t449 = t105 * t169
  t453 = t435 * t210 * t1 * t165
  t458 = 0.28352283093786903206141400494373808723731817805082e2 * t170 * t388 * t408 - 0.16874818540351286411318858893141041564300567437994e1 * t412 * t360 + 0.36160325443609899452826126199587946209215501652845e0 * t353 * t417 - 0.14176141546893451603070700247186904361865908902541e2 * t287 * t388 * t423 + 0.21522038567493112947658402203856749311294765840220e0 * t314 * t426 * t317 + 0.23536244451380066489749908173089237613782685235180e1 * t432 * t236 * t437 - 0.56033562154354183036404121177047437307668649255439e0 * t441 * t378 + 0.60035959451093767539004415546836539972502124202256e-1 * t373 * t446 - 0.78454148171266888299166360576964125379275617450598e0 * t449 * t236 * t453 + 0.20248376013543181086381687433528154790363655878306e-1 * t324 * t306
  t463 = t116 * (0.88547815820543093270365997638724911452184179456906e0 * t117 * t118 * t309 * t329 - 0.17709563164108618654073199527744982290436835891381e1 * t333 * t350 * t383 + 0.17709563164108618654073199527744982290436835891381e1 * t333 * t396 * t397 - 0.88547815820543093270365997638724911452184179456906e0 * t333 * t401 * t458)
  t468 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t117 * t118 * t393 * t329
  t469 = 0.1e1 / t468
  t478 = 0.1e1 / t132 * t108
  t481 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t10 + 0.18472500000000000000000000000000000000000000000000e-2 * t24
  t484 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t10 + 0.11800000000000000000000000000000000000000000000000e3 * t24
  t485 = 0.1e1 / t484
  t487 = t481 * t485 - 0.18535714285714285714285714285714285714285714285714e-2
  t489 = t478 * t487 * t354
  t490 = t171 * s0
  t491 = t119 ** 2
  t496 = 9 ** (0.1e1 / 0.3e1)
  t499 = t496 ** 2
  t507 = jnp.exp(-0.25e2 / 0.18e2 * t2 * t5 * t499 * t3 * t36 * t115 * s0 * t123)
  t508 = t496 * t3 * t507
  t509 = t490 / t21 / t491 / r0 * t508
  t514 = t2 * t108
  t517 = 0.25851111111111111111111111111111111111111111111111e1 * t49 + 0.20525000000000000000000000000000000000000000000000e-2 * t60
  t521 = -0.19388333333333333333333333333333333333333333333333e1 * t79 - 0.12315000000000000000000000000000000000000000000000e-2 * t86
  t522 = t484 ** 2
  t523 = 0.1e1 / t522
  t524 = t521 * t523
  t527 = -0.72691666666666666666666666666666666666666666666667e3 * t79 - 0.78666666666666666666666666666666666666666666666667e2 * t86
  t531 = 0.1e1 / t522 / t484
  t532 = t481 * t531
  t533 = t527 ** 2
  t536 = t481 * t523
  t539 = 0.96922222222222222222222222222222222222222222222222e3 * t49 + 0.13111111111111111111111111111111111111111111111111e3 * t60
  t541 = t517 * t485 - 0.2e1 * t524 * t527 + 0.2e1 * t532 * t533 - t536 * t539
  t544 = t514 * t541 * t114 * s0
  t545 = t128 * t507
  t546 = t315 * t545
  t551 = t521 * t485 - t536 * t527
  t554 = t514 * t551 * t114 * s0
  t555 = t363 * t545
  t558 = t106 * t108
  t561 = t558 * t551 * t116 * t171
  t565 = t6 * t499 * t507
  t566 = 0.1e1 / t299 * t175 * t565
  t571 = t514 * t487 * t114 * s0
  t572 = t426 * t545
  t577 = t558 * t487 * t116 * t171
  t578 = t119 * t334
  t581 = 0.1e1 / t578 * t175 * t565
  t591 = 0.88547815820543093270365997638724911452184179456906e0 * t117 * t118 * t347 * t329 - 0.88547815820543093270365997638724911452184179456906e0 * t333 * t401 * t383
  t592 = t591 ** 2
  t594 = t468 ** 2
  t595 = 0.1e1 / t594
  t599 = t257 * t203
  t603 = 0.35089340384731224424988055003710697745685326982943e1 * t196 * t274 * t599 * t205
  t611 = 0.10253897021007794930818001372045340355835853271641e4 * t196 / t273 / t197 * t599 / t276 / t152
  t617 = 0.10389453539625517979803415350183779755340003251893e3 * t196 / t273 / t149 * t599 * t277
  t622 = 0.1e1 / t119
  t623 = 0.1e1 / t13 / t24 * t2 * t622 / 0.4e1
  t626 = 0.1e1 / t21 / t334
  t627 = t33 * t626
  t628 = t32 * t627
  t630 = t42 * t336
  t631 = t41 * t630
  t633 = t6 * t336
  t634 = t4 * t633
  t636 = t10 ** (-0.15e1)
  t638 = t636 * t2 * t622
  t640 = t52 * t627
  t642 = t56 * t630
  t645 = t20 * t5 * t626
  t651 = 0.58482233974552040708313425006184496242808878304903e0 * t196 * t198 * (-0.34523333333333333333333333333333333333333333333333e1 * t623 + 0.23015555555555555555555555555555555555555555555556e1 * t628 - 0.26851481481481481481481481481481481481481481481482e1 * t631 - 0.93932222222222222222222222222222222222222222222223e0 * t634 + 0.73355000000000000000000000000000000000000000000000e-1 * t638 - 0.14671000000000000000000000000000000000000000000000e0 * t640 - 0.17116166666666666666666666666666666666666666666667e0 * t642 - 0.36793333333333333333333333333333333333333333333333e0 * t645) * t205
  t656 = 0.51947267698127589899017076750918898776700016259463e2 * t196 * t274 * t268 * t277 * t203
  t661 = 0.35089340384731224424988055003710697745685326982943e1 * t196 * t256 * t203 * t205 * t268
  t665 = 0.71233333333333333333333333333333333333333333333333e-1 * t239 * t44 * t28 * t188
  t668 = 0.53424999999999999999999999999999999999999999999999e-1 * t239 * t240 * t67
  t672 = 0.85917146441092277507960503039464796886558811231548e0 * t239 * t74 * t71 * t92
  t676 = 0.10685000000000000000000000000000000000000000000000e0 * t239 * t74 * t96 * t98
  t680 = 0.56969282336565386484066937725323112718202900731800e-3 * t191 * t42 * t336 * t153
  t682 = 0.1e1 / t7 / t220
  t687 = t367 * jnp.pi
  t688 = t687 * t431
  t691 = 0.1e1 / t178 / t354
  t693 = t691 * t183 * t6
  t694 = t210 * t209
  t695 = t212 * t165
  t701 = t343 * t180
  t705 = t184 * t209
  t711 = t687 * t169
  t731 = 0.48245472966453314463992795342703676305040043742564e2 * t72 * t62 * t91 * t88
  t732 = t89 * t88
  t735 = 0.60000000000000000000000000000000000000000000000000e1 * t72 * t732 * t66
  t738 = 0.60000000000000000000000000000000000000000000000000e1 * t97 * t188 * t62
  t741 = 0.21687161765563048429332895106460084023374959038068e-1 * t251 * t48 * t206
  t744 = 0.16265371324172286321999671329845063017531219278551e-1 * t251 * t78 * t270
  t747 = 0.48159446095139119802213748237831062407565640073877e0 * t251 * t78 * t278
  t755 = 0.51725014705706168413145063783413931475389495076352e3 * t12 / t70 / t27 * t732 / t90 / t65
  t761 = 0.96490945932906628927985590685407352610080087485128e2 * t12 / t70 / t26 * t732 * t91
  t773 = 0.10000000000000000000000000000000000000000000000000e1 * t29 * (-0.25319000000000000000000000000000000000000000000000e1 * t623 + 0.16879333333333333333333333333333333333333333333333e1 * t628 - 0.19692555555555555555555555555555555555555555555555e1 * t631 - 0.93011851851851851851851851851851851851851851851854e0 * t634 + 0.13651666666666666666666666666666666666666666666667e0 * t638 - 0.27303333333333333333333333333333333333333333333333e0 * t640 - 0.31853888888888888888888888888888888888888888888890e0 * t642 - 0.36514074074074074074074074074074074074074074074075e0 * t645) * t66
  t774 = t731 + t735 - t738 - t741 + t744 + t747 + t755 - t761 + t773 - t611 + t617
  t777 = 0.34451131037037037037037037037037037037037037037036e-2 * t4 * t633 * t101
  t780 = 0.32530742648344572643999342659690126035062438557102e-1 * t251 * t78 * t259
  t781 = -t651 + t777 - t656 - t603 + t661 + t665 - t668 - t672 - t780 + t676 - t680
  t782 = t774 + t781
  t788 = t184 * t281
  t795 = t687 * t218
  t805 = 0.1e1 / t21 / t578 * t175 * t305
  t808 = -0.455e3 / 0.1296e4 * s0 * t682 * t123 * t129 + 0.34734717313134690805416039216483526584685190724888e2 * t688 * t236 * t693 * t694 * t695 * t369 - 0.41347079511772567175622875720961804388775567632413e1 * t172 * t701 * t215 + 0.88600884668084072519191876544918152261661930640888e0 * t182 * t705 * t213 * t161 * t281 - 0.34734717313134690805416039216483526584685190724887e2 * t711 * t236 * t693 * t694 * t212 * t369 + 0.89647473495616209060131437869811783310346764514349e0 * t219 * t171 * t301 * t175 * t232 - 0.15820142381579331010611430212319726466531781973121e0 * t225 * t284 + 0.20673539755886283587811437860480902194387783816207e1 * t288 * t701 * t292 + 0.11300101701128093579008164437371233190379844266515e-1 * t237 * t229 * t782 * t1 * t165 - 0.44300442334042036259595938272459076130830965320444e0 * t289 * t788 * t18 * t209 * t161 * t165 + 0.57891195521891151342360065360805877641141984541478e1 * t795 * t236 * t693 * t694 * t369 * t165 - 0.15244777318640955004591368227731864095500459136823e0 * t298 * t805
  t824 = t348 ** 2
  t837 = t176 * t691
  t839 = t184 * t694
  t878 = t315 / t178 / t116
  t880 = t128 * t694
  t890 = t315 * t403
  t909 = 0.10252277837406933531704852189044724493708733980189e2 * t367 * t169 * t171 * t837 * t839 * t291 - 0.23536244451380066489749908173089237613782685235180e1 * t449 * t171 * t181 * t788 * t231 + 0.70608733354140199469249724519267712841348055705540e1 * t432 * t171 * t181 * t705 * t212 * t1 * t281 + 0.12302733404888320238045822626853669392450480776228e3 * t367 / t430 / t166 * t171 * t837 * t839 * t695 * t18 * t161 - 0.92270500536662401785343669701402520443378605821706e2 * t367 * t431 * t171 * t837 * t839 * t214 + 0.47628527831201055580943503000490321711518351867124e1 * t370 * t371 * t301 * t378 + 0.18525182567005168429555220915457880845165435053272e3 * t795 * s0 * t878 * t880 * t369 * t1 * t165 - 0.32950742231932093085649871442324932659295759329252e2 * t432 * t224 * t437 - 0.42528424640680354809212100741560713085597726707623e2 * t287 * s0 * t890 * t128 * t281 * t209 * t161 * t165 - 0.19846598165650832244298980346061666106612272463557e3 * t170 * t338 * t408 + 0.85056849281360709618424201483121426171195453415246e2 * t170 * s0 * t890 * t128 * t209 * t212 * t161 * t281
  t948 = t682 * t123
  t954 = 0.11115109540203101057733132549274728507099261031963e4 * t688 * s0 * t878 * t880 * t695 * t369 * t1 - 0.11115109540203101057733132549274728507099261031963e4 * t711 * s0 * t878 * t880 * t212 * t369 * t1 + 0.84374092701756432056594294465705207821502837189970e1 * t117 * t351 * t121 * t360 - 0.84050343231531274554606181765571155961502973883158e0 * t441 * t446 + 0.10983580743977364361883290480774977553098586443084e2 * t449 * t224 * t453 + 0.60035959451093767539004415546836539972502124202256e-1 * t373 * t375 * t6 * t782 * t165 - 0.13498917342362120724254458289018769860242437252204e0 * t324 * t805 + 0.99232990828254161221494901730308330533061362317785e2 * t287 * t338 * t423 + 0.36160325443609899452826126199587946209215501652845e0 * t353 * t357 * t5 * t782 * t165 - 0.93262167125803489439853076216712580348943985307620e0 * t314 * t948 * t317 - 0.25312227810526929616978288339711562346450851156991e1 * t412 * t417
  t982 = -t603 - t611 + t617 - t651 - t656 + t661 + t665 - t668 - t672 + t676 - t680 + 0.25507875555555555555555555555555555555555555555556e-1 * t110 * t116 * (0.88547815820543093270365997638724911452184179456906e0 * t117 * t118 * t808 * t329 - 0.26564344746162927981109799291617473435655253837072e1 * t333 * t309 * t349 * t383 + 0.53128689492325855962219598583234946871310507674143e1 * t333 * t347 * t395 * t397 - 0.26564344746162927981109799291617473435655253837072e1 * t333 * t350 * t458 - 0.53128689492325855962219598583234946871310507674143e1 * t333 * t393 / t824 * t397 * t383 + 0.53128689492325855962219598583234946871310507674143e1 * t333 * t396 * t383 * t458 - 0.88547815820543093270365997638724911452184179456906e0 * t333 * t401 * (t909 + t954)) * t469 + 0.51015751111111111111111111111111111111111111111112e-1 * t110 * t116 * t592 * t591 / t594 / t468 + 0.40000e5 / 0.27e2 * t478 * t551 * t354 * t509 - 0.80000e5 / 0.9e1 * t489 * t490 / t21 / t491 / t34 * t508 - t741 + t744
  t1002 = t171 ** 2
  t1026 = t522 ** 2
  t1052 = t747 - t780 + t773 + t735 + t755 - t761 - 0.76523626666666666666666666666666666666666666666668e-1 * t110 * t463 * t595 * t591 + t777 + t731 - t738 - 0.455e3 / 0.27e2 * t571 * t948 * t545 - 0.7e1 / 0.2e1 * t544 * t555 + 0.35e2 / 0.3e1 * t554 * t572 + 0.29750e5 / 0.243e3 * t577 / t491 * t175 * t565 + 0.4000000e7 / 0.243e3 / t367 * t108 * t487 * t226 * t1002 / t7 / t491 / t220 * t19 * t5 * t123 * t507 + t514 * ((-0.60319259259259259259259259259259259259259259259259e1 * t634 - 0.54733333333333333333333333333333333333333333333333e-2 * t645) * t485 - 0.3e1 * t517 * t523 * t527 + 0.6e1 * t521 * t531 * t533 - 0.3e1 * t524 * t539 - 0.6e1 * t481 / t1026 * t533 * t527 + 0.6e1 * t532 * t527 * t539 - t536 * (-0.22615185185185185185185185185185185185185185185185e4 * t634 - 0.34962962962962962962962962962962962962962962962963e3 * t645)) * t114 * s0 * t546 / 0.2e1 + 0.50e2 / 0.9e1 * t558 * t541 * t116 * t171 * t566 - 0.1250e4 / 0.27e2 * t561 * t581
  v3rho3_0_ = 0.30000000000000000000000000000000000000000000000000e1 * t68 + 0.48245472966453314463992795342703676305040043742564e2 * t93 - 0.60000000000000000000000000000000000000000000000000e1 * t99 - 0.44294311333333333333333333333333333333333333333332e-2 * t103 + 0.76523626666666666666666666666666666666666666666668e-1 * t110 * t463 * t469 + 0.35089340384731224424988055003710697745685326982943e1 * t260 - 0.17544670192365612212494027501855348872842663491471e1 * t271 - 0.51947267698127589899017076750918898776700016259464e2 * t279 + 0.32530742648344572643999342659690126035062438557102e-1 * t253 + 0.40000e5 / 0.27e2 * t489 * t509 - 0.10685000000000000000000000000000000000000000000000e0 * t242 + 0.73246220147012639765228919932558287780546586655172e-3 * t249 + 0.3e1 / 0.2e1 * t544 * t546 - 0.7e1 * t554 * t555 + 0.100e3 / 0.9e1 * t561 * t566 + 0.35e2 / 0.3e1 * t571 * t572 - 0.1250e4 / 0.27e2 * t577 * t581 - 0.76523626666666666666666666666666666666666666666668e-1 * t110 * t116 * t592 * t595 + r0 * (t982 + t1052)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 / jnp.pi
  t2 = jnp.pi ** 2
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 3 ** (0.1e1 / 0.3e1)
  t6 = t1 ** (0.1e1 / 0.3e1)
  t7 = t5 * t6
  t8 = 4 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 ** (0.1e1 / 0.3e1)
  t13 = t7 * t9 / t10
  t15 = t5 ** 2
  t16 = t6 ** 2
  t17 = t15 * t16
  t18 = t10 ** 2
  t21 = t17 * t8 / t18
  t23 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t13 + 0.18472500000000000000000000000000000000000000000000e-2 * t21
  t26 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t13 + 0.11800000000000000000000000000000000000000000000000e3 * t21
  t27 = 0.1e1 / t26
  t29 = t23 * t27 - 0.18535714285714285714285714285714285714285714285714e-2
  t30 = 0.1e1 <= f.p.zeta_threshold
  t31 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = f.my_piecewise3(t30, t32, 1)
  t36 = t4 * t29 * t33 * s0
  t37 = r0 ** 2
  t38 = t37 ** 2
  t39 = t38 * r0
  t41 = 0.1e1 / t10 / t39
  t42 = 2 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 0.1e1 / t6
  t45 = t44 * t8
  t47 = 9 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t52 = 0.1e1 / t18 / t37
  t53 = t33 ** 2
  t59 = jnp.exp(-0.25e2 / 0.18e2 * t1 * t8 * t48 * t6 * t52 * t53 * s0 * t42)
  t60 = t45 * t59
  t61 = t43 * t60
  t64 = 0.1e1 / t2
  t65 = t64 * t3
  t67 = 0.1e1 / t10 / r0
  t68 = t9 * t67
  t69 = t7 * t68
  t74 = t17 * t8 / t18 / r0
  t76 = -0.19388333333333333333333333333333333333333333333333e1 * t69 - 0.12315000000000000000000000000000000000000000000000e-2 * t74
  t78 = t26 ** 2
  t79 = 0.1e1 / t78
  t80 = t23 * t79
  t83 = -0.72691666666666666666666666666666666666666666666667e3 * t69 - 0.78666666666666666666666666666666666666666666666667e2 * t74
  t85 = t76 * t27 - t80 * t83
  t86 = t53 * t33
  t88 = s0 ** 2
  t90 = t65 * t85 * t86 * t88
  t91 = t37 * r0
  t92 = t38 * t91
  t94 = t42 ** 2
  t97 = t9 * t48 * t59
  t98 = 0.1e1 / t92 * t94 * t97
  t102 = 0.1e1 / t10 / t37
  t103 = t9 * t102
  t104 = t7 * t103
  t107 = t17 * t8 * t52
  t109 = 0.25851111111111111111111111111111111111111111111111e1 * t104 + 0.20525000000000000000000000000000000000000000000000e-2 * t107
  t111 = t76 * t79
  t115 = 0.1e1 / t78 / t26
  t116 = t23 * t115
  t117 = t83 ** 2
  t122 = 0.96922222222222222222222222222222222222222222222222e3 * t104 + 0.13111111111111111111111111111111111111111111111111e3 * t107
  t124 = t109 * t27 - 0.2e1 * t111 * t83 + 0.2e1 * t116 * t117 - t80 * t122
  t127 = t4 * t124 * t33 * s0
  t129 = 0.1e1 / t10 / t91
  t130 = t129 * t42
  t131 = t130 * t60
  t136 = t4 * t85 * t33 * s0
  t138 = 0.1e1 / t10 / t38
  t139 = t138 * t42
  t140 = t139 * t60
  t145 = t65 * t29 * t86 * t88
  t146 = t38 ** 2
  t149 = 0.1e1 / t146 * t94 * t97
  t152 = t2 ** 2
  t154 = 0.1e1 / t152 * t3
  t155 = t53 ** 2
  t156 = t155 * t86
  t158 = t88 ** 2
  t160 = t154 * t29 * t156 * t158
  t166 = t8 * t42 * t59
  t167 = 0.1e1 / t10 / t146 / t39 * t16 * t166
  t170 = t9 * t129
  t171 = t7 * t170
  t174 = 0.1e1 / t18 / t91
  t176 = t17 * t8 * t174
  t178 = -0.60319259259259259259259259259259259259259259259259e1 * t171 - 0.54733333333333333333333333333333333333333333333333e-2 * t176
  t180 = t109 * t79
  t183 = t76 * t115
  t188 = t78 ** 2
  t189 = 0.1e1 / t188
  t190 = t23 * t189
  t191 = t117 * t83
  t194 = t83 * t122
  t199 = -0.22615185185185185185185185185185185185185185185185e4 * t171 - 0.34962962962962962962962962962962962962962962962963e3 * t176
  t201 = -0.3e1 * t111 * t122 + 0.6e1 * t116 * t194 + 0.6e1 * t183 * t117 + t178 * t27 - 0.3e1 * t180 * t83 - 0.6e1 * t190 * t191 - t80 * t199
  t204 = t4 * t201 * t33 * s0
  t205 = t102 * t42
  t206 = t205 * t60
  t211 = t65 * t124 * t86 * t88
  t212 = t38 * t37
  t215 = 0.1e1 / t212 * t94 * t97
  t218 = t2 * jnp.pi
  t220 = 0.1e1 / t218 * t3
  t221 = t155 * t33
  t223 = t220 * t85 * t221
  t224 = t88 * s0
  t225 = t146 * r0
  t230 = t47 * t6 * t59
  t231 = t224 / t18 / t225 * t230
  t235 = t220 * t29 * t221
  t240 = t224 / t18 / t146 / t37 * t230
  t244 = f.my_piecewise3(t30, t31 * f.p.zeta_threshold, 1)
  t250 = (0.2e1 * t244 - 0.2e1) / (0.2e1 * t42 - 0.2e1)
  t251 = t250 * t7
  t252 = jnp.sqrt(t13)
  t255 = t13 ** 0.15e1
  t258 = 0.51785000000000000000000000000000000000000000000000e1 * t252 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t255 + 0.12417750000000000000000000000000000000000000000000e0 * t21
  t259 = t258 ** 2
  t260 = 0.1e1 / t259
  t262 = 0.1e1 / t252 * t5
  t263 = t6 * t9
  t264 = t263 * t67
  t265 = t262 * t264
  t268 = t13 ** 0.5e0
  t269 = t268 * t5
  t270 = t269 * t264
  t273 = -0.86308333333333333333333333333333333333333333333334e0 * t265 - 0.30192500000000000000000000000000000000000000000000e0 * t69 - 0.55016250000000000000000000000000000000000000000000e-1 * t270 - 0.82785000000000000000000000000000000000000000000000e-1 * t74
  t277 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t258
  t278 = 0.1e1 / t277
  t279 = t260 * t273 * t278
  t281 = t251 * t103 * t279
  t285 = 0.1e1 / t252 / t13 * t15
  t286 = t16 * t8
  t287 = t286 * t52
  t288 = t285 * t287
  t290 = t263 * t102
  t291 = t262 * t290
  t294 = t13 ** (-0.5e0)
  t295 = t294 * t15
  t296 = t295 * t287
  t298 = t269 * t290
  t301 = -0.57538888888888888888888888888888888888888888888889e0 * t288 + 0.11507777777777777777777777777777777777777777777778e1 * t291 + 0.40256666666666666666666666666666666666666666666667e0 * t104 + 0.36677500000000000000000000000000000000000000000000e-1 * t296 + 0.73355000000000000000000000000000000000000000000000e-1 * t298 + 0.13797500000000000000000000000000000000000000000000e0 * t107
  t303 = t260 * t301 * t278
  t305 = t251 * t68 * t303
  t307 = t259 ** 2
  t308 = 0.1e1 / t307
  t309 = t273 ** 2
  t310 = t308 * t309
  t311 = t277 ** 2
  t312 = 0.1e1 / t311
  t313 = t310 * t312
  t315 = t251 * t68 * t313
  t317 = t259 * t258
  t318 = 0.1e1 / t317
  t320 = t318 * t309 * t278
  t322 = t251 * t68 * t320
  t325 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t326 = t250 * t325
  t328 = 0.1e1 / t307 / t259
  t329 = t309 * t273
  t332 = 0.1e1 / t311 / t277
  t333 = t328 * t329 * t332
  t334 = t326 * t333
  t337 = 0.1e1 / t307 / t258
  t339 = t337 * t329 * t312
  t340 = t326 * t339
  t345 = 0.1e1 / t252 / t21 * t1 / 0.4e1
  t346 = 0.1e1 / t38
  t347 = t345 * t346
  t349 = t286 * t174
  t350 = t285 * t349
  t352 = t263 * t129
  t353 = t262 * t352
  t356 = t13 ** (-0.15e1)
  t357 = t356 * t1
  t358 = t357 * t346
  t360 = t295 * t349
  t362 = t269 * t352
  t365 = -0.34523333333333333333333333333333333333333333333333e1 * t347 + 0.23015555555555555555555555555555555555555555555556e1 * t350 - 0.26851481481481481481481481481481481481481481481482e1 * t353 - 0.93932222222222222222222222222222222222222222222223e0 * t171 + 0.73355000000000000000000000000000000000000000000000e-1 * t358 - 0.14671000000000000000000000000000000000000000000000e0 * t360 - 0.17116166666666666666666666666666666666666666666667e0 * t362 - 0.36793333333333333333333333333333333333333333333333e0 * t176
  t367 = t260 * t365 * t278
  t368 = t326 * t367
  t371 = t308 * t329 * t278
  t372 = t326 * t371
  t374 = -0.1820e4 / 0.27e2 * t36 * t61 - 0.5000e4 / 0.27e2 * t90 * t98 - 0.14e2 * t127 * t131 + 0.140e3 / 0.3e1 * t136 * t140 + 0.119000e6 / 0.243e3 * t145 * t149 + 0.16000000e8 / 0.243e3 * t160 * t167 + 0.2e1 * t204 * t206 + 0.200e3 / 0.9e1 * t211 * t215 + 0.160000e6 / 0.27e2 * t223 * t231 - 0.320000e6 / 0.9e1 * t235 * t240 - 0.86748647062252193717331580425840336093499836152272e-1 * t281 + 0.65061485296689145287998685319380252070124877114204e-1 * t305 + 0.19263778438055647920885499295132424963026256029551e1 * t315 - 0.13012297059337829057599737063876050414024975422841e0 * t322 - 0.41015588084031179723272005488181361423343413086566e4 * t334 + 0.41557814158502071919213661400735119021360013007572e3 * t340 - 0.23392893589820816283325370002473798497123551321961e1 * t368 - 0.14035736153892489769995222001484279098274130793177e2 * t372
  t376 = t3 ** 2
  t377 = t64 * t15 * t376
  t378 = jnp.pi * t15
  t379 = 0.1e1 / t3
  t381 = s0 * t129 * t42
  t382 = 0.1e1 / t53
  t384 = t382 * t15 * t45
  t388 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t393 = 0.37978500000000000000000000000000000000000000000000e1 * t252 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t255 + 0.12323500000000000000000000000000000000000000000000e0 * t21
  t396 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t393
  t397 = jnp.log(t396)
  t400 = jnp.log(t277)
  t408 = 0.1e1 / t376
  t412 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-0.62182e-1 * t388 * t397 + 0.19751789702565206228825776161588751761046270558698e-1 * t250 * t325 * t400) / t86 * t2 * t5 * t408)
  t413 = t412 - 0.1e1
  t414 = t413 ** 2
  t415 = 0.1e1 / t414
  t416 = jnp.pi * t415
  t418 = 0.1e1 / t18 / t38
  t420 = t88 * t418 * t94
  t421 = t416 * t420
  t422 = 0.1e1 / t156
  t423 = 0.1e1 / t16
  t425 = t422 * t423 * t9
  t429 = t393 ** 2
  t430 = 0.1e1 / t429
  t431 = t388 * t430
  t436 = -0.63297500000000000000000000000000000000000000000000e0 * t265 - 0.29896666666666666666666666666666666666666666666667e0 * t69 - 0.10238750000000000000000000000000000000000000000000e0 * t270 - 0.82156666666666666666666666666666666666666666666667e-1 * t74
  t437 = 0.1e1 / t396
  t438 = t436 * t437
  t441 = t250 * t5
  t448 = 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t68 * t397 + 0.10000000000000000000000000000000000000000000000000e1 * t431 * t438 - 0.18311555036753159941307229983139571945136646663793e-3 * t441 * t263 * t67 * t400 - 0.58482233974552040708313425006184496242808878304903e0 * t326 * t279
  t450 = t448 * t5 * t412
  t451 = t425 * t450
  t455 = 0.1e1 / t413
  t457 = jnp.pi * t379 * t455 * t88
  t459 = 0.1e1 / t18 / t39
  t460 = t459 * t94
  t463 = 0.1e1 / t155 * t423 * t9
  t464 = t460 * t463
  t467 = -0.7e1 / 0.288e3 * t381 * t384 + 0.11300101701128093579008164437371233190379844266515e-1 * t421 * t451 - 0.40353822314049586776859504132231404958677685950414e-2 * t457 * t464
  t472 = jnp.pi * t5 * t379 * t455 * s0
  t474 = t382 * t44 * t8
  t481 = t2 * t15 * t408 * t415 * t88
  t482 = t418 * t94
  t483 = t482 * t463
  t486 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t472 * t205 * t474 + 0.76569489126843962091359322227627476098013824749894e-3 * t481 * t483
  t487 = 0.1e1 / t486
  t491 = t378 * t379
  t493 = s0 * t102 * t42
  t498 = t493 * t384 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t457 * t483
  t499 = t486 ** 2
  t500 = 0.1e1 / t499
  t501 = t498 * t500
  t502 = t415 * s0
  t504 = t378 * t502 * t102
  t507 = t42 / t221 * t44
  t510 = t507 * t8 * t448 * t412
  t517 = 0.1e1 / t3 / t2
  t518 = t152 * t517
  t520 = 0.1e1 / t414 / t413
  t521 = t520 * t88
  t523 = t518 * t521 * t418
  t525 = t94 * t422 * t423
  t528 = t525 * t9 * t448 * t412
  t533 = 0.36160325443609899452826126199587946209215501652845e0 * t504 * t510 - 0.64566115702479338842975206611570247933884297520660e-1 * t472 * t130 * t474 + 0.60035959451093767539004415546836539972502124202256e-1 * t523 * t528 - 0.35732428259193848975967683706226155512406451549951e-2 * t481 * t464
  t537 = 0.88547815820543093270365997638724911452184179456906e0 * t378 * t379 * t467 * t487 - 0.88547815820543093270365997638724911452184179456906e0 * t491 * t501 * t533
  t538 = t537 ** 2
  t545 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t378 * t379 * t498 * t487
  t546 = t545 ** 2
  t548 = 0.1e1 / t546 / t545
  t553 = t312 * t273
  t555 = t326 * t308 * t301 * t553
  t557 = t318 * t273
  t558 = t278 * t301
  t560 = t326 * t557 * t558
  t562 = t7 * t9
  t563 = t102 * t430
  t565 = t562 * t563 * t438
  t567 = t67 * t430
  t574 = -0.42198333333333333333333333333333333333333333333333e0 * t288 + 0.84396666666666666666666666666666666666666666666666e0 * t291 + 0.39862222222222222222222222222222222222222222222223e0 * t104 + 0.68258333333333333333333333333333333333333333333333e-1 * t296 + 0.13651666666666666666666666666666666666666666666667e0 * t298 + 0.13692777777777777777777777777777777777777777777778e0 * t107
  t575 = t574 * t437
  t577 = t562 * t567 * t575
  t579 = t429 ** 2
  t580 = 0.1e1 / t579
  t581 = t67 * t580
  t582 = t436 ** 2
  t583 = t396 ** 2
  t584 = 0.1e1 / t583
  t585 = t582 * t584
  t587 = t562 * t581 * t585
  t589 = t429 * t393
  t590 = 0.1e1 / t589
  t592 = t582 * t437
  t594 = t562 * t67 * t590 * t592
  t597 = 0.1e1 / t579 / t393
  t598 = t388 * t597
  t599 = t582 * t436
  t600 = t599 * t584
  t601 = t598 * t600
  t611 = -0.25319000000000000000000000000000000000000000000000e1 * t347 + 0.16879333333333333333333333333333333333333333333333e1 * t350 - 0.19692555555555555555555555555555555555555555555555e1 * t353 - 0.93011851851851851851851851851851851851851851851854e0 * t171 + 0.13651666666666666666666666666666666666666666666667e0 * t358 - 0.27303333333333333333333333333333333333333333333333e0 * t360 - 0.31853888888888888888888888888888888888888888888890e0 * t362 - 0.36514074074074074074074074074074074074074074074075e0 * t176
  t612 = t611 * t437
  t613 = t431 * t612
  t616 = 0.1e1 / t579 / t429
  t617 = t388 * t616
  t619 = 0.1e1 / t583 / t396
  t620 = t599 * t619
  t621 = t617 * t620
  t623 = t388 * t580
  t624 = t599 * t437
  t625 = t623 * t624
  t628 = s0 * t138 * t42
  t631 = t218 * t520
  t632 = t631 * t88
  t633 = t155 ** 2
  t635 = 0.1e1 / t633 / t53
  t636 = t482 * t635
  t637 = t632 * t636
  t638 = t423 * t9
  t639 = t448 ** 2
  t640 = t638 * t639
  t641 = t412 ** 2
  t642 = t15 * t641
  t643 = t642 * t408
  t644 = t640 * t643
  t648 = t88 * t459 * t94
  t649 = t416 * t648
  t658 = t388 * t590
  t678 = -0.14764770444444444444444444444444444444444444444444e-2 * t7 * t103 * t397 - 0.35616666666666666666666666666666666666666666666666e-1 * t562 * t567 * t438 - 0.20000000000000000000000000000000000000000000000000e1 * t658 * t592 + 0.10000000000000000000000000000000000000000000000000e1 * t431 * t575 + 0.16081824322151104821330931780901225435013347914188e2 * t623 * t585 + 0.24415406715670879921742973310852762593515528885057e-3 * t441 * t263 * t102 * t400 + 0.10843580882781524214666447553230042011687479519034e-1 * t251 * t68 * t279 + 0.11696446794910408141662685001236899248561775660981e1 * t326 * t320 - 0.58482233974552040708313425006184496242808878304903e0 * t326 * t303 - 0.17315755899375863299672358916972966258900005419821e2 * t326 * t313
  t679 = t678 * t5
  t681 = t425 * t679 * t412
  t684 = t218 * t415
  t685 = t684 * t88
  t686 = t685 * t636
  t687 = t15 * t408
  t688 = t687 * t412
  t689 = t640 * t688
  t693 = 0.1e1 / t18 / t212
  t694 = t693 * t94
  t695 = t694 * t463
  t698 = 0.35e2 / 0.432e3 * t628 * t384 + 0.29533628222694690839730625514972717420553976880296e0 * t637 * t644 - 0.10546761587719554007074286808213150977687854648747e0 * t649 * t451 + 0.11300101701128093579008164437371233190379844266515e-1 * t421 * t681 - 0.14766814111347345419865312757486358710276988440148e0 * t686 * t689 + 0.22867165977961432506887052341597796143250688705235e-1 * t457 * t695
  t703 = t467 * t500
  t708 = 0.1e1 / t499 / t486
  t709 = t498 * t708
  t710 = t533 ** 2
  t714 = t631 * t493
  t715 = 0.1e1 / t633
  t717 = t715 * t44 * t8
  t718 = t639 * t641
  t720 = t717 * t718 * t408
  t724 = t378 * t502 * t129
  t729 = t507 * t8 * t678 * t412
  t732 = t684 * t493
  t735 = t717 * t639 * t408 * t412
  t741 = t414 ** 2
  t742 = 0.1e1 / t741
  t743 = t2 * t742
  t744 = t743 * t420
  t746 = t635 * t423 * t9
  t748 = t746 * t718 * t5
  t752 = t518 * t521 * t459
  t757 = t525 * t9 * t678 * t412
  t760 = t2 * t520
  t761 = t760 * t420
  t764 = t746 * t639 * t5 * t412
  t769 = 0.28352283093786903206141400494373808723731817805082e2 * t714 * t720 - 0.16874818540351286411318858893141041564300567437994e1 * t724 * t510 + 0.36160325443609899452826126199587946209215501652845e0 * t504 * t729 - 0.14176141546893451603070700247186904361865908902541e2 * t732 * t735 + 0.21522038567493112947658402203856749311294765840220e0 * t472 * t139 * t474 + 0.23536244451380066489749908173089237613782685235180e1 * t744 * t748 - 0.56033562154354183036404121177047437307668649255439e0 * t752 * t528 + 0.60035959451093767539004415546836539972502124202256e-1 * t523 * t757 - 0.78454148171266888299166360576964125379275617450598e0 * t761 * t764 + 0.20248376013543181086381687433528154790363655878306e-1 * t481 * t695
  t773 = 0.88547815820543093270365997638724911452184179456906e0 * t378 * t379 * t698 * t487 - 0.17709563164108618654073199527744982290436835891381e1 * t491 * t703 * t533 + 0.17709563164108618654073199527744982290436835891381e1 * t491 * t709 * t710 - 0.88547815820543093270365997638724911452184179456906e0 * t491 * t501 * t769
  t774 = t86 * t773
  t775 = 0.1e1 / t546
  t776 = t775 * t537
  t782 = t441 * t263 * t129 * t400
  t785 = t658 * t438 * t574
  t788 = t7 * t170 * t397
  t790 = t574 * t584
  t792 = t623 * t790 * t436
  t801 = 0.1e1 / t252 * r0 * t41 * t562 / 0.48e2
  t803 = 0.1e1 / t39
  t804 = t345 * t803
  t806 = t286 * t418
  t807 = t285 * t806
  t809 = t263 * t138
  t810 = t262 * t809
  t812 = t9 * t138
  t813 = t7 * t812
  t815 = t13 ** (-0.25e1)
  t818 = t815 * t1 * t41 * t562
  t820 = t357 * t803
  t822 = t295 * t806
  t824 = t269 * t809
  t827 = t17 * t8 * t418
  t832 = 0.10000000000000000000000000000000000000000000000000e1 * t431 * (-0.21099166666666666666666666666666666666666666666667e1 * t801 + 0.20255200000000000000000000000000000000000000000000e2 * t804 - 0.75019259259259259259259259259259259259259259259258e1 * t807 + 0.65641851851851851851851851851851851851851851851850e1 * t810 + 0.31003950617283950617283950617283950617283950617285e1 * t813 + 0.68258333333333333333333333333333333333333333333335e-1 * t818 - 0.10921333333333333333333333333333333333333333333333e1 * t820 + 0.12134814814814814814814814814814814814814814814815e1 * t822 + 0.10617962962962962962962962962962962962962962962963e1 * t824 + 0.13388493827160493827160493827160493827160493827161e1 * t827) * t437
  t836 = t582 ** 2
  t839 = 0.62070017646847402095774076540096717770467394091622e4 * t388 / t579 / t589 * t836 * t619
  t842 = 0.57894567559743977356791354411244411566048052491077e3 * t617 * t836 * t584
  t843 = t574 ** 2
  t846 = 0.60000000000000000000000000000000000000000000000000e1 * t658 * t843 * t437
  t849 = 0.48245472966453314463992795342703676305040043742564e2 * t623 * t843 * t584
  t852 = 0.24000000000000000000000000000000000000000000000000e2 * t598 * t836 * t437
  t856 = 0.22911239050957940668789467477190612503082349661746e1 * t562 * t102 * t580 * t585
  t859 = 0.71233333333333333333333333333333333333333333333332e-1 * t562 * t567 * t612
  t863 = 0.36845452142031360632963667101718523854302450326054e2 * t562 * t67 * t616 * t620
  t867 = 0.18989760778855128828022312575107704239400966910600e-2 * t441 * t263 * t138 * t400
  t872 = 0.61523382126046769584908008232272042135015119629847e4 * t326 * t328 * t301 * t332 * t309
  t876 = 0.46785787179641632566650740004947596994247102643924e1 * t326 * t557 * t278 * t365
  t880 = 0.69263023597503453198689435667891865035600021679284e2 * t326 * t308 * t365 * t553
  t883 = 0.21053604230838734654992833002226418647411196189766e2 * t326 * t310 * t558
  t887 = 0.22161481481481481481481481481481481481481481481481e0 * t562 * t129 * t430 * t438
  t891 = 0.28493333333333333333333333333333333333333333333334e0 * t562 * t102 * t590 * t592
  t892 = t832 - t839 + t842 - t846 + t849 - t852 + t856 - t859 - t863 + t867 - t872 + t876 - t880 - t883 - t887 - t891
  t896 = 0.68733717152873822006368402431571837509247048985239e1 * t562 * t67 * t597 * t600
  t899 = 0.42740000000000000000000000000000000000000000000000e0 * t562 * t581 * t624
  t904 = 0.62336721237753107878820492101102678532040019511357e3 * t326 * t337 * t301 * t312 * t309
  t907 = 0.14246666666666666666666666666666666666666666666666e0 * t562 * t563 * t575
  t912 = t152 * jnp.pi
  t913 = t912 * t742
  t916 = 0.1e1 / t633 / t221
  t918 = t916 * t423 * t9
  t919 = t639 * t448
  t920 = t641 * t412
  t923 = t918 * t919 * t920 * t517
  t926 = t460 * t635
  t927 = t632 * t926
  t930 = t638 * t448
  t931 = t408 * t678
  t933 = t930 * t642 * t931
  t936 = t912 * t520
  t940 = t918 * t919 * t641 * t517
  t944 = t88 * t693 * t94
  t945 = t416 * t944
  t950 = t685 * t926
  t964 = 0.48245472966453314463992795342703676305040043742564e2 * t792 + 0.60000000000000000000000000000000000000000000000000e1 * t625 - 0.60000000000000000000000000000000000000000000000000e1 * t785 - 0.21687161765563048429332895106460084023374959038068e-1 * t281 + 0.16265371324172286321999671329845063017531219278551e-1 * t305 + 0.48159446095139119802213748237831062407565640073877e0 * t315 + 0.51725014705706168413145063783413931475389495076352e3 * t621 - 0.96490945932906628927985590685407352610080087485128e2 * t601 + 0.10000000000000000000000000000000000000000000000000e1 * t613 - 0.10253897021007794930818001372045340355835853271641e4 * t334 + 0.10389453539625517979803415350183779755340003251893e3 * t340
  t976 = -0.58482233974552040708313425006184496242808878304903e0 * t368 + 0.34451131037037037037037037037037037037037037037036e-2 * t788 - 0.51947267698127589899017076750918898776700016259463e2 * t555 - 0.35089340384731224424988055003710697745685326982943e1 * t372 + 0.35089340384731224424988055003710697745685326982943e1 * t560 + 0.71233333333333333333333333333333333333333333333333e-1 * t565 - 0.53424999999999999999999999999999999999999999999999e-1 * t577 - 0.85917146441092277507960503039464796886558811231548e0 * t587 - 0.32530742648344572643999342659690126035062438557102e-1 * t322 + 0.10685000000000000000000000000000000000000000000000e0 * t594 - 0.56969282336565386484066937725323112718202900731800e-3 * t782
  t977 = t964 + t976
  t980 = t425 * t977 * t5 * t412
  t983 = t638 * t678
  t986 = t15 * t448 * t408 * t412
  t987 = t983 * t986
  t990 = t912 * t415
  t994 = t918 * t919 * t517 * t412
  t998 = 0.1e1 / t18 / t92
  t1000 = t998 * t94 * t463
  t1003 = -0.455e3 / 0.1296e4 * s0 * t41 * t42 * t384 + 0.34734717313134690805416039216483526584685190724888e2 * t913 * t420 * t923 - 0.41347079511772567175622875720961804388775567632413e1 * t927 * t644 + 0.88600884668084072519191876544918152261661930640888e0 * t637 * t933 - 0.34734717313134690805416039216483526584685190724887e2 * t936 * t420 * t940 + 0.89647473495616209060131437869811783310346764514349e0 * t945 * t451 - 0.15820142381579331010611430212319726466531781973121e0 * t649 * t681 + 0.20673539755886283587811437860480902194387783816207e1 * t950 * t689 + 0.11300101701128093579008164437371233190379844266515e-1 * t421 * t980 - 0.44300442334042036259595938272459076130830965320444e0 * t686 * t987 + 0.57891195521891151342360065360805877641141984541478e1 * t990 * t420 * t994 - 0.15244777318640955004591368227731864095500459136823e0 * t457 * t1000
  t1008 = t698 * t500
  t1012 = t467 * t708
  t1019 = t499 ** 2
  t1020 = 0.1e1 / t1019
  t1021 = t498 * t1020
  t1022 = t710 * t533
  t1026 = t533 * t769
  t1031 = t152 * t520 * t88
  t1032 = t482 * t916
  t1033 = t1031 * t1032
  t1034 = t638 * t919
  t1035 = t1034 * t688
  t1038 = t760 * t88
  t1039 = t1038 * t636
  t1040 = t983 * t450
  t1043 = t743 * t88
  t1044 = t1043 * t636
  t1045 = t641 * t5
  t1047 = t930 * t1045 * t678
  t1051 = 0.1e1 / t741 / t413
  t1053 = t152 * t1051 * t88
  t1054 = t1053 * t1032
  t1055 = t920 * t15
  t1057 = t1034 * t1055 * t408
  t1061 = t152 * t742 * t88
  t1062 = t1061 * t1032
  t1063 = t1034 * t643
  t1067 = t518 * t521 * t693
  t1070 = t990 * s0
  t1072 = 0.1e1 / t633 / t86
  t1073 = t205 * t1072
  t1074 = t1070 * t1073
  t1075 = t45 * t919
  t1076 = t517 * t5
  t1078 = t1075 * t1076 * t412
  t1084 = t684 * s0
  t1085 = t205 * t715
  t1086 = t1084 * t1085
  t1087 = t45 * t678
  t1089 = t448 * t408 * t412
  t1090 = t1087 * t1089
  t1096 = t631 * s0
  t1097 = t1096 * t1085
  t1098 = t45 * t448
  t1099 = t641 * t408
  t1101 = t1098 * t1099 * t678
  t1104 = 0.10252277837406933531704852189044724493708733980189e2 * t1033 * t1035 - 0.23536244451380066489749908173089237613782685235180e1 * t1039 * t1040 + 0.70608733354140199469249724519267712841348055705540e1 * t1044 * t1047 + 0.12302733404888320238045822626853669392450480776228e3 * t1054 * t1057 - 0.92270500536662401785343669701402520443378605821706e2 * t1062 * t1063 + 0.47628527831201055580943503000490321711518351867124e1 * t1067 * t528 + 0.18525182567005168429555220915457880845165435053272e3 * t1074 * t1078 - 0.32950742231932093085649871442324932659295759329252e2 * t743 * t648 * t748 - 0.42528424640680354809212100741560713085597726707623e2 * t1086 * t1090 - 0.19846598165650832244298980346061666106612272463557e3 * t631 * t381 * t720 + 0.85056849281360709618424201483121426171195453415246e2 * t1097 * t1101
  t1105 = t913 * s0
  t1106 = t1105 * t1073
  t1107 = t920 * t517
  t1109 = t1075 * t1107 * t5
  t1112 = t936 * s0
  t1113 = t1112 * t1073
  t1114 = t641 * t517
  t1116 = t1075 * t1114 * t5
  t1120 = t378 * t502 * t138
  t1130 = t525 * t9 * t977 * t412
  t1137 = t507 * t8 * t977 * t412
  t1148 = 0.11115109540203101057733132549274728507099261031963e4 * t1106 * t1109 - 0.11115109540203101057733132549274728507099261031963e4 * t1113 * t1116 + 0.84374092701756432056594294465705207821502837189970e1 * t1120 * t510 - 0.84050343231531274554606181765571155961502973883158e0 * t752 * t757 + 0.10983580743977364361883290480774977553098586443084e2 * t760 * t648 * t764 + 0.60035959451093767539004415546836539972502124202256e-1 * t523 * t1130 - 0.13498917342362120724254458289018769860242437252204e0 * t481 * t1000 + 0.36160325443609899452826126199587946209215501652845e0 * t504 * t1137 - 0.93262167125803489439853076216712580348943985307620e0 * t472 * t43 * t474 - 0.25312227810526929616978288339711562346450851156991e1 * t724 * t729 + 0.99232990828254161221494901730308330533061362317785e2 * t684 * t381 * t735
  t1149 = t1104 + t1148
  t1154 = t86 * (0.88547815820543093270365997638724911452184179456906e0 * t378 * t379 * t1003 * t487 - 0.26564344746162927981109799291617473435655253837072e1 * t491 * t1008 * t533 + 0.53128689492325855962219598583234946871310507674143e1 * t491 * t1012 * t710 - 0.26564344746162927981109799291617473435655253837072e1 * t491 * t703 * t769 - 0.53128689492325855962219598583234946871310507674143e1 * t491 * t1021 * t1022 + 0.53128689492325855962219598583234946871310507674143e1 * t491 * t709 * t1026 - 0.88547815820543093270365997638724911452184179456906e0 * t491 * t501 * t1149)
  t1160 = 0.36000000000000000000000000000000000000000000000000e2 * t623 * t592 * t574
  t1163 = 0.38024868119570572868450088421334803819557955882337e2 * t251 * t68 * t333
  t1166 = 0.38527556876111295841770998590264849926052512059102e1 * t251 * t68 * t339
  t1169 = 0.21687161765563048429332895106460084023374959038068e-1 * t251 * t68 * t367
  t1172 = 0.13012297059337829057599737063876050414024975422841e0 * t251 * t68 * t371
  t1175 = 0.86748647062252193717331580425840336093499836152272e-1 * t251 * t103 * t320
  t1178 = 0.43374323531126096858665790212920168046749918076136e-1 * t251 * t103 * t303
  t1181 = 0.12842518958703765280590332863421616642017504019700e1 * t251 * t103 * t313
  t1184 = 0.67471169937307261780146784775653594739388761451767e-1 * t251 * t170 * t279
  t1198 = t896 - t899 + t904 + t907 - 0.10203150222222222222222222222222222222222222222222e0 * t377 * t1154 * t776 + t1160 + t1163 - t1166 + t1169 + t1172 + t1175 - t1178 - t1181 + t1184 + 0.92920000e8 / 0.729e3 * t235 * t224 / t18 / t146 / t91 * t230 + 0.80000e5 / 0.27e2 * t220 * t124 * t221 * t231 - 0.320000e6 / 0.9e1 * t223 * t240
  t1217 = t639 * t517
  t1223 = t633 ** 2
  t1226 = 0.1e1 / t1223 * t423 * t9
  t1227 = t639 ** 2
  t1236 = 0.1e1 / t18 / t146 * t94 * t463
  t1239 = t638 * t977
  t1243 = t678 ** 2
  t1244 = t638 * t1243
  t1260 = -0.64838138984518089503443273204102582958079022686455e3 * t913 * t648 * t923 + 0.20840830387880814483249623529890115950811114434932e3 * t913 * t88 * t1032 * t640 * t1107 * t678 - 0.20840830387880814483249623529890115950811114434932e3 * t936 * t88 * t1032 * t640 * t1114 * t678 + 0.34734717313134690805416039216483526584685190724886e2 * t990 * t88 * t1032 * t983 * t1217 * t412 - 0.75651400807312083321316795964025416866209666323725e2 * t684 * t420 * t1226 * t1227 * t5 * t412 + 0.11687662610958065503520048974594429139883685338231e1 * t457 * t1236 - 0.59067256445389381679461251029945434841107953760592e0 * t686 * t1239 * t986 - 0.44300442334042036259595938272459076130830965320444e0 * t686 * t1244 * t688 + 0.82694159023545134351245751441923608777551135264828e1 * t950 * t987 - 0.16538831804709026870249150288384721755510227052965e2 * t927 * t933 + 0.88600884668084072519191876544918152261661930640888e0 * t637 * t1244 * t643 + 0.11813451289077876335892250205989086968221590752118e1 * t637 * t930 * t642 * t408 * t977
  t1261 = t694 * t635
  t1278 = t832 - t839 + t842 - t846 + t849 - t852 + t856 - t859 - t863 + t867 - t872
  t1279 = t876 - t880 - t883 - t887 - t891 + t896 - t899 + t904 + t907 + t1160 + t1163 - t1166
  t1284 = 0.64327297288604419285323727123604901740053391656752e2 * t623 * t611 * t584 * t436
  t1288 = 0.31035008823423701047887038270048358885233697045812e4 * t617 * t574 * t619 * t582
  t1292 = 0.42740000000000000000000000000000000000000000000000e0 * t69 * t590 * t574 * t438
  t1297 = 0.34366858576436911003184201215785918754623524492620e1 * t69 * t580 * t574 * t584 * t436
  t1298 = t301 ** 2
  t1302 = 0.51947267698127589899017076750918898776700016259463e2 * t326 * t308 * t1298 * t312
  t1303 = t1169 + t1172 + t1175 - t1178 - t1181 + t1184 + t1284 + t1288 + t1292 - t1297 - t1302
  t1307 = 0.35089340384731224424988055003710697745685326982943e1 * t326 * t318 * t1298 * t278
  t1308 = t309 ** 2
  t1312 = 0.14035736153892489769995222001484279098274130793177e2 * t326 * t337 * t1308 * t278
  t1318 = 0.12304676425209353916981601646454408427003023925970e5 * t326 / t307 / t317 * t1308 * t332
  t1333 = 0.58482233974552040708313425006184496242808878304903e0 * t326 * t260 * (-0.28769444444444444444444444444444444444444444444444e1 * t801 + 0.27618666666666666666666666666666666666666666666667e2 * t804 - 0.10229135802469135802469135802469135802469135802469e2 * t807 + 0.89504938271604938271604938271604938271604938271607e1 * t810 + 0.31310740740740740740740740740740740740740740740741e1 * t813 + 0.36677500000000000000000000000000000000000000000000e-1 * t818 - 0.58684000000000000000000000000000000000000000000000e0 * t820 + 0.65204444444444444444444444444444444444444444444445e0 * t822 + 0.57053888888888888888888888888888888888888888888890e0 * t824 + 0.13490888888888888888888888888888888888888888888889e1 * t827) * t278
  t1334 = t307 ** 2
  t1337 = t311 ** 2
  t1341 = 0.91080982599109921218848830805163797795664001346962e5 * t326 / t1334 * t1308 / t1337
  t1345 = 0.62336721237753107878820492101102678532040019511358e3 * t326 * t328 * t1308 * t312
  t1346 = t579 ** 2
  t1349 = t583 ** 2
  t1353 = 0.24954977986735470914321699422701391789612506067521e5 * t388 / t1346 * t836 / t1349
  t1354 = t250 * t562
  t1360 = 0.19263778438055647920885499295132424963026256029551e1 * t1354 * t67 * t308 * t301 * t312 * t273
  t1366 = 0.13012297059337829057599737063876050414024975422841e0 * t1354 * t67 * t318 * t273 * t278 * t301
  t1369 = 0.80000000000000000000000000000000000000000000000000e1 * t658 * t438 * t611
  t1372 = 0.57894567559743977356791354411244411566048052491077e3 * t598 * t790 * t582
  t1375 = 0.11483710345679012345679012345679012345679012345679e-1 * t7 * t812 * t397
  t1376 = t1307 + t1312 + t1318 - t1333 - t1341 - t1345 + t1353 + t1360 - t1366 - t1369 - t1372 - t1375
  t1378 = t1278 + t1279 + t1303 + t1376
  t1384 = t218 * t1051
  t1386 = t641 ** 2
  t1387 = t1227 * t1386
  t1392 = t218 * t742
  t1394 = t1227 * t920
  t1403 = 0.1e1 / t10 / t212
  t1416 = 0.46860023446675576132372592483756711640612309983401e2 * t632 * t1261 * t644 + 0.10591196113023691664984351434963558361269353285322e4 * t631 * t420 * t1226 * t1227 * t641 * t5 + 0.17929494699123241812026287573962356662069352902870e1 * t945 * t681 - 0.21093523175439108014148573616426301955375709297495e0 * t649 * t980 - 0.10806356497419681583907212200683763826346503781076e3 * t990 * t648 * t994 + 0.11300101701128093579008164437371233190379844266515e-1 * t421 * t425 * t1378 * t5 * t412 + 0.18156336193754899997116031031366100047890319917695e4 * t1384 * t420 * t1226 * t1387 * t5 - 0.27234504290632349995674046547049150071835479876541e4 * t1392 * t420 * t1226 * t1394 * t5 + 0.64838138984518089503443273204102582958079022686455e3 * t936 * t648 * t940 + 0.455e3 / 0.243e3 * s0 * t1403 * t42 * t384 - 0.23430011723337788066186296241878355820306154991701e2 * t685 * t1261 * t689 - 0.79686643107214408053450166995388251831419346234977e1 * t416 * t88 * t998 * t94 * t451
  t1446 = t710 ** 2
  t1454 = t769 ** 2
  t1462 = t152 * t2
  t1465 = t1227 * t517
  t1511 = 0.84404455446174638416345185579697779148250454162822e4 * t1462 * t742 * t420 * t1226 * t1465 * t641 - 0.40192597831511732579211993133189418642024025791818e3 * t1462 * t520 * t420 * t1226 * t1465 * t412 + 0.24115558698907039547527195879913651185214415475092e5 * t1462 / t741 / t414 * t420 * t1226 * t1387 * t517 - 0.28938670438688447457032635055896381422257298570112e5 * t1462 * t1051 * t420 * t1226 * t1394 * t517 - 0.33749637080702572822637717786282083128601134875988e1 * t724 * t1137 + 0.36160325443609899452826126199587946209215501652845e0 * t504 * t507 * t8 * t1378 * t412 + 0.16874818540351286411318858893141041564300567437994e2 * t1120 * t729 - 0.66155327218836107480996601153538887022040908211856e3 * t684 * t628 * t735 - 0.11206712430870836607280824235409487461533729851088e1 * t752 * t1130 + 0.60035959451093767539004415546836539972502124202256e-1 * t523 * t525 * t9 * t1378 * t412 + 0.95257055662402111161887006000980643423036703734247e1 * t1067 * t757
  t1519 = t1243 * t641
  t1543 = 0.1e1 / t633 / t155 / t53 * t44 * t8
  t1544 = t1227 * t15
  t1568 = 0.37344174529523038830403187634634923680535193906486e3 * t743 * t944 * t748 - 0.48749475783237049632698925691296342296868305931983e2 * t378 * t502 * t41 * t510 + 0.85056849281360709618424201483121426171195453415246e2 * t714 * t717 * t1519 * t408 - 0.42528424640680354809212100741560713085597726707623e2 * t732 * t717 * t1243 * t408 * t412 + 0.13231065443767221496199320230707777404408181642371e4 * t631 * t628 * t720 - 0.42336469183289827183060891555991397076905201659666e2 * t518 * t521 * t998 * t528 - 0.12448058176507679610134395878211641226845064635495e3 * t760 * t944 * t764 + 0.33891827561675813327949924591883386756061930513026e5 * t714 * t1543 * t1544 * t641 - 0.24208448258339866662821374708488133397187093223591e4 * t732 * t1543 * t1544 * t412 + 0.58100275820015679990771299300371520153249023736616e5 * t1384 * t493 * t1543 * t1387 * t15 - 0.87150413730023519986156948950557280229873535604924e5 * t1392 * t493 * t1543 * t1394 * t15 - 0.23536244451380066489749908173089237613782685235180e1 * t761 * t746 * t1243 * t5 * t412
  t1574 = t1403 * t42
  t1580 = t412 * t678
  t1585 = t45 * t639
  t1607 = t130 * t715
  t1611 = t460 * t916
  t1615 = 0.70608733354140199469249724519267712841348055705540e1 * t744 * t746 * t1519 * t5 + 0.49739822467095194367921640648913376186103458830731e1 * t472 * t1574 * t474 + 0.10349169962477625888595084688247723559519201893356e1 * t481 * t1236 + 0.61513667024441601190229113134268346962252403881136e2 * t1033 * t640 * t687 * t1580 + 0.66690657241218606346398795295648371042595566191778e4 * t1106 * t1585 * t1107 * t679 - 0.66690657241218606346398795295648371042595566191778e4 * t1113 * t1087 * t1217 * t1045 + 0.11115109540203101057733132549274728507099261031963e4 * t1074 * t1585 * t1076 * t1580 + 0.73816400429329921428274935761122016354702884657367e3 * t1054 * t640 * t1055 * t931 - 0.55362300321997441071206201820841512266027163493024e3 * t1062 * t983 * t639 * t15 * t1099 + 0.39693196331301664488597960692123332213224544927114e3 * t1084 * t1607 * t1090 + 0.17223826766843648333264151677595137149430673086719e4 * t1061 * t1611 * t1063
  t1616 = t130 * t1072
  t1656 = -0.17290170395871490534251539521094022122154406049720e4 * t1070 * t1616 * t1078 - 0.22965102355791531111018868903460182865907564115625e4 * t1053 * t1611 * t1057 - 0.13180296892772837234259948576929973063718303731701e3 * t1043 * t926 * t1047 - 0.31381659268506755319666544230785650151710246980240e1 * t1039 * t1239 * t450 + 0.94144977805520265958999632692356950455130740940720e1 * t1044 * t930 * t1045 * t977 - 0.79386392662603328977195921384246664426449089854228e3 * t1096 * t1607 * t1101 - 0.10374102237522894320550923712656413273292643629832e5 * t1105 * t1616 * t1109 + 0.10374102237522894320550923712656413273292643629832e5 * t1112 * t1616 * t1116 + 0.11340913237514761282456560197749523489492727122033e3 * t1097 * t1098 * t1099 * t977 - 0.19137585296492942592515724086216819054922970096354e3 * t1031 * t1611 * t1035 + 0.43934322975909457447533161923099910212394345772336e2 * t1038 * t926 * t1040 - 0.56704566187573806412282800988747617447463635610164e2 * t1086 * t45 * t977 * t1089
  t1662 = 0.88547815820543093270365997638724911452184179456906e0 * t378 * t379 * (t1260 + t1416) * t487 - 0.35419126328217237308146399055489964580873671782763e1 * t491 * t1003 * t500 * t533 + 0.10625737898465171192443919716646989374262101534829e2 * t491 * t698 * t708 * t710 - 0.53128689492325855962219598583234946871310507674144e1 * t491 * t1008 * t769 - 0.21251475796930342384887839433293978748524203069657e2 * t491 * t467 * t1020 * t1022 + 0.21251475796930342384887839433293978748524203069657e2 * t491 * t1012 * t1026 - 0.35419126328217237308146399055489964580873671782763e1 * t491 * t703 * t1149 + 0.21251475796930342384887839433293978748524203069657e2 * t491 * t498 / t1019 / t486 * t1446 - 0.31877213695395513577331759149940968122786304604486e2 * t491 * t1021 * t710 * t769 + 0.53128689492325855962219598583234946871310507674143e1 * t491 * t709 * t1454 + 0.70838252656434474616292798110979929161747343565524e1 * t491 * t709 * t533 * t1149 - 0.88547815820543093270365997638724911452184179456906e0 * t491 * t501 * (t1511 + t1568 + t1615 + t1656)
  t1664 = 0.1e1 / t545
  t1668 = t538 ** 2
  t1670 = t546 ** 2
  t1675 = t773 ** 2
  t1684 = 0.25507875555555555555555555555555555555555555555556e-1 * t377 * t86 * t1662 * t1664 - 0.15304725333333333333333333333333333333333333333334e0 * t377 * t86 * t1668 / t1670 + t1284 + t1288 + t1292 - t1297 - 0.76523626666666666666666666666666666666666666666668e-1 * t377 * t86 * t1675 * t775 - t1302 + t1307 + t1312 + t1318 - t1333 - t1341 - t1345 + 0.30609450666666666666666666666666666666666666666668e0 * t377 * t774 * t548 * t538 + t1353
  t1699 = t146 ** 2
  t1732 = t117 ** 2
  t1738 = t122 ** 2
  t1748 = (0.20106419753086419753086419753086419753086419753086e2 * t813 + 0.20068888888888888888888888888888888888888888888889e-1 * t827) * t27 - 0.4e1 * t178 * t79 * t83 + 0.12e2 * t109 * t115 * t117 - 0.6e1 * t180 * t122 - 0.24e2 * t76 * t189 * t191 + 0.24e2 * t183 * t194 - 0.4e1 * t111 * t199 + 0.24e2 * t23 / t188 / t26 * t1732 - 0.36e2 * t190 * t117 * t122 + 0.6e1 * t116 * t1738 + 0.8e1 * t116 * t83 * t199 - t80 * (0.75383950617283950617283950617283950617283950617283e4 * t813 + 0.12819753086419753086419753086419753086419753086420e4 * t827)
  t1780 = t1360 - t1366 + 0.119000e6 / 0.243e3 * t90 * t149 + 0.16000000e8 / 0.243e3 * t154 * t85 * t156 * t158 * t167 + 0.400000000e9 / 0.6561e4 / t1462 * t3 * t29 * t633 * t33 * t158 * s0 / t1699 / r0 * t9 * t94 * t48 * t59 - t1369 - t1372 - t1375 + 0.70e2 / 0.3e1 * t127 * t140 + t4 * t1748 * t33 * s0 * t206 / 0.2e1 + 0.200e3 / 0.27e2 * t65 * t201 * t86 * t88 * t215 - 0.1820e4 / 0.27e2 * t136 * t61 - 0.14e2 / 0.3e1 * t204 * t131 - 0.2500e4 / 0.27e2 * t211 * t98 - 0.759500e6 / 0.729e3 * t145 / t225 * t94 * t97 - 0.376000000e9 / 0.729e3 * t160 / t10 / t146 / t212 * t16 * t166 + 0.7280e4 / 0.81e2 * t36 * t1574 * t60
  t1787 = 0.20406300444444444444444444444444444444444444444445e0 * t377 * t86 * t538 * t537 * t548 - 0.20778907079251035959606830700367559510680006503785e3 * t555 + 0.14035736153892489769995222001484279098274130793177e2 * t560 + 0.28493333333333333333333333333333333333333333333333e0 * t565 - 0.21370000000000000000000000000000000000000000000000e0 * t577 - 0.34366858576436911003184201215785918754623524492620e1 * t587 + 0.42740000000000000000000000000000000000000000000000e0 * t594 - 0.38596378373162651571194236274162941044032034994052e3 * t601 + 0.40000000000000000000000000000000000000000000000000e1 * t613 + 0.20690005882282467365258025513365572590155798030541e4 * t621 + 0.24000000000000000000000000000000000000000000000000e2 * t625 - 0.30609450666666666666666666666666666666666666666668e0 * t377 * t774 * t776 - 0.22787712934626154593626775090129245087281160292720e-2 * t782 - 0.24000000000000000000000000000000000000000000000000e2 * t785 + 0.13780452414814814814814814814814814814814814814815e-1 * t788 + 0.19298189186581325785597118137081470522016017497025e3 * t792 + r0 * (t892 + t1198 + t1684 + t1780) + 0.10203150222222222222222222222222222222222222222222e0 * t377 * t1154 * t1664
  v4rho4_0_ = t374 + t1787

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / jnp.pi
  t4 = t3 ** (0.1e1 / 0.3e1)
  t5 = t2 * t4
  t6 = 4 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** (0.1e1 / 0.3e1)
  t11 = t5 * t7 / t8
  t13 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t2 ** 2
  t20 = t4 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t6 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t11 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t28 = t27 ** 2
  t29 = t28 ** 2
  t33 = 0.1e1 / t14 * t2
  t34 = t4 * t7
  t36 = 0.1e1 / t8 / t1
  t37 = t34 * t36
  t38 = t33 * t37
  t40 = t7 * t36
  t41 = t5 * t40
  t43 = t11 ** 0.5e0
  t44 = t43 * t2
  t45 = t44 * t37
  t50 = t21 * t6 / t22 / t1
  t52 = -0.63297500000000000000000000000000000000000000000000e0 * t38 - 0.29896666666666666666666666666666666666666666666667e0 * t41 - 0.10238750000000000000000000000000000000000000000000e0 * t45 - 0.82156666666666666666666666666666666666666666666667e-1 * t50
  t53 = t52 ** 2
  t56 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t57 = t56 ** 2
  t61 = 0.16081824322151104821330931780901225435013347914188e2 * t13 / t29 * t53 / t57
  t65 = 0.1e1 / t56
  t68 = 0.20000000000000000000000000000000000000000000000000e1 * t13 / t28 / t27 * t53 * t65
  t69 = 0.1e1 / t28
  t70 = t13 * t69
  t75 = t1 ** 2
  t77 = 0.1e1 / t22 / t75
  t78 = t20 * t6 * t77
  t79 = 0.1e1 / t14 / t11 * t19 * t78
  t82 = 0.1e1 / t8 / t75
  t83 = t34 * t82
  t84 = t33 * t83
  t86 = t7 * t82
  t87 = t5 * t86
  t89 = t11 ** (-0.5e0)
  t91 = t89 * t19 * t78
  t93 = t44 * t83
  t96 = t21 * t6 * t77
  t101 = 0.10000000000000000000000000000000000000000000000000e1 * t70 * (-0.42198333333333333333333333333333333333333333333333e0 * t79 + 0.84396666666666666666666666666666666666666666666666e0 * t84 + 0.39862222222222222222222222222222222222222222222223e0 * t87 + 0.68258333333333333333333333333333333333333333333333e-1 * t91 + 0.13651666666666666666666666666666666666666666666667e0 * t93 + 0.13692777777777777777777777777777777777777777777778e0 * t96) * t65
  t102 = r0 - r1
  t103 = 0.1e1 / t1
  t104 = t102 * t103
  t105 = 0.1e1 + t104
  t106 = t105 <= f.p.zeta_threshold
  t107 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t108 = t107 * f.p.zeta_threshold
  t109 = t105 ** (0.1e1 / 0.3e1)
  t110 = t109 * t105
  t111 = f.my_piecewise3(t106, t108, t110)
  t112 = 0.1e1 - t104
  t113 = t112 <= f.p.zeta_threshold
  t114 = t112 ** (0.1e1 / 0.3e1)
  t115 = t114 * t112
  t116 = f.my_piecewise3(t113, t108, t115)
  t118 = 2 ** (0.1e1 / 0.3e1)
  t121 = 0.1e1 / (0.2e1 * t118 - 0.2e1)
  t122 = (t111 + t116 - 0.2e1) * t121
  t124 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t11
  t125 = t122 * t124
  t130 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t11 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t131 = t130 ** 2
  t133 = 0.1e1 / t131 / t130
  t138 = -0.86308333333333333333333333333333333333333333333334e0 * t38 - 0.30192500000000000000000000000000000000000000000000e0 * t41 - 0.55016250000000000000000000000000000000000000000000e-1 * t45 - 0.82785000000000000000000000000000000000000000000000e-1 * t50
  t139 = t138 ** 2
  t143 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t130
  t144 = 0.1e1 / t143
  t147 = 0.11696446794910408141662685001236899248561775660981e1 * t125 * t133 * t139 * t144
  t148 = t131 ** 2
  t149 = 0.1e1 / t148
  t151 = t143 ** 2
  t152 = 0.1e1 / t151
  t155 = 0.17315755899375863299672358916972966258900005419821e2 * t125 * t149 * t139 * t152
  t156 = 0.1e1 / t131
  t163 = -0.57538888888888888888888888888888888888888888888889e0 * t79 + 0.11507777777777777777777777777777777777777777777778e1 * t84 + 0.40256666666666666666666666666666666666666666666667e0 * t87 + 0.36677500000000000000000000000000000000000000000000e-1 * t91 + 0.73355000000000000000000000000000000000000000000000e-1 * t93 + 0.13797500000000000000000000000000000000000000000000e0 * t96
  t167 = 0.58482233974552040708313425006184496242808878304903e0 * t125 * t156 * t163 * t144
  t168 = 0.1e1 / t75
  t169 = t102 * t168
  t170 = t103 - t169
  t173 = f.my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t109 * t170)
  t174 = -t170
  t177 = f.my_piecewise3(t113, 0, 0.4e1 / 0.3e1 * t114 * t174)
  t179 = (t173 + t177) * t121
  t182 = t156 * t138 * t144
  t183 = t179 * t124 * t182
  t184 = 0.11696446794910408141662685001236899248561775660981e1 * t183
  t185 = jnp.pi ** 2
  t188 = t185 ** (0.1e1 / 0.3e1)
  t189 = t188 ** 2
  t190 = 0.1e1 / t185 * t19 * t189
  t191 = t107 ** 2
  t192 = t109 ** 2
  t193 = f.my_piecewise3(t106, t191, t192)
  t194 = t114 ** 2
  t195 = f.my_piecewise3(t113, t191, t194)
  t197 = t193 / 0.2e1 + t195 / 0.2e1
  t198 = t197 ** 2
  t199 = t198 * t197
  t200 = jnp.pi * t19
  t201 = 0.1e1 / t188
  t203 = s0 + 0.2e1 * s1 + s2
  t204 = t75 * t1
  t206 = 0.1e1 / t8 / t204
  t207 = t203 * t206
  t209 = 0.1e1 / t198
  t211 = 0.1e1 / t4
  t212 = t211 * t6
  t213 = t209 * t19 * t212
  t215 = 0.7e1 / 0.288e3 * t207 * t118 * t213
  t216 = t203 * t82
  t217 = 0.1e1 / t199
  t218 = t118 * t217
  t219 = t216 * t218
  t220 = t19 * t211
  t221 = 0.1e1 / t109
  t224 = f.my_piecewise3(t106, 0, 0.2e1 / 0.3e1 * t221 * t170)
  t225 = 0.1e1 / t114
  t228 = f.my_piecewise3(t113, 0, 0.2e1 / 0.3e1 * t225 * t174)
  t230 = t224 / 0.2e1 + t228 / 0.2e1
  t232 = t220 * t6 * t230
  t235 = jnp.pi * t201
  t236 = jnp.log(t56)
  t238 = 0.62182e-1 * t13 * t236
  t239 = t102 ** 2
  t240 = t239 ** 2
  t241 = t75 ** 2
  t242 = 0.1e1 / t241
  t243 = t240 * t242
  t245 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t11
  t250 = 0.70594500000000000000000000000000000000000000000000e1 * t14 + 0.15494250000000000000000000000000000000000000000000e1 * t11 + 0.42077500000000000000000000000000000000000000000000e0 * t17 + 0.15629250000000000000000000000000000000000000000000e0 * t25
  t253 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t250
  t254 = jnp.log(t253)
  t257 = jnp.log(t143)
  t258 = t124 * t257
  t260 = -0.31090e-1 * t245 * t254 + t238 - 0.19751789702565206228825776161588751761046270558698e-1 * t258
  t261 = t122 * t260
  t265 = -t238 + t243 * t261 + 0.19751789702565206228825776161588751761046270558698e-1 * t122 * t258
  t268 = 0.1e1 / t189
  t269 = t185 * t2 * t268
  t272 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * t265 * t217 * t269)
  t273 = t272 - 0.1e1
  t274 = t273 ** 2
  t275 = 0.1e1 / t274
  t276 = t203 ** 2
  t277 = t275 * t276
  t279 = 0.1e1 / t22 / t241
  t280 = t277 * t279
  t281 = t235 * t280
  t282 = t118 ** 2
  t283 = t198 ** 2
  t284 = 0.1e1 / t283
  t286 = 0.1e1 / t20
  t287 = t282 * t284 * t286
  t289 = t5 * t40 * t236
  t290 = 0.11073577833333333333333333333333333333333333333333e-2 * t289
  t291 = t52 * t65
  t292 = t70 * t291
  t293 = 0.10000000000000000000000000000000000000000000000000e1 * t292
  t294 = t239 * t102
  t295 = t294 * t242
  t296 = t295 * t261
  t297 = 0.4e1 * t296
  t298 = t241 * t1
  t299 = 0.1e1 / t298
  t300 = t240 * t299
  t301 = t300 * t261
  t302 = 0.4e1 * t301
  t303 = t179 * t260
  t304 = t243 * t303
  t308 = t250 ** 2
  t309 = 0.1e1 / t308
  t310 = t245 * t309
  t315 = -0.11765750000000000000000000000000000000000000000000e1 * t38 - 0.51647500000000000000000000000000000000000000000000e0 * t41 - 0.21038750000000000000000000000000000000000000000000e0 * t45 - 0.10419500000000000000000000000000000000000000000000e0 * t50
  t316 = 0.1e1 / t253
  t317 = t315 * t316
  t323 = t124 * t156
  t324 = t138 * t144
  t327 = 0.53236443333333333333333333333333333333333333333332e-3 * t5 * t40 * t254 + 0.99999999999999999999999999999999999999999999999999e0 * t310 * t317 - t290 - t293 + 0.18311555036753159941307229983139571945136646663793e-3 * t5 * t40 * t257 + 0.58482233974552040708313425006184496242808878304903e0 * t323 * t324
  t328 = t122 * t327
  t329 = t243 * t328
  t330 = t179 * t258
  t331 = 0.19751789702565206228825776161588751761046270558698e-1 * t330
  t332 = t122 * t2
  t334 = t34 * t36 * t257
  t335 = t332 * t334
  t336 = 0.18311555036753159941307229983139571945136646663793e-3 * t335
  t337 = t125 * t182
  t338 = 0.58482233974552040708313425006184496242808878304903e0 * t337
  t339 = t290 + t293 + t297 - t302 + t304 + t329 + t331 - t336 - t338
  t344 = t265 * t284 * t185
  t345 = t2 * t268
  t346 = t345 * t230
  t349 = -0.13067859477648036196925324326848422587394359423983e2 * t339 * t217 * t269 + 0.39203578432944108590775972980545267762183078271949e2 * t344 * t346
  t350 = t7 * t349
  t352 = t287 * t350 * t272
  t355 = 0.1e1 / t273
  t356 = t355 * t276
  t357 = t235 * t356
  t359 = 0.1e1 / t22 / t298
  t360 = t359 * t282
  t362 = t284 * t286 * t7
  t363 = t360 * t362
  t365 = 0.40353822314049586776859504132231404958677685950414e-2 * t357 * t363
  t367 = t235 * t356 * t279
  t369 = 0.1e1 / t283 / t197
  t370 = t282 * t369
  t371 = t286 * t7
  t372 = t371 * t230
  t373 = t370 * t372
  t376 = -t215 - t219 * t232 / 0.48e2 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t352 - t365 - 0.34588990554899645808736717827626918536009445100355e-2 * t367 * t373
  t378 = jnp.pi * t2
  t381 = t378 * t201 * t355 * t203
  t382 = t82 * t118
  t384 = t209 * t211 * t6
  t388 = t185 * t19
  t391 = t388 * t268 * t275 * t276
  t392 = t279 * t282
  t393 = t392 * t362
  t396 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t381 * t382 * t384 + 0.76569489126843962091359322227627476098013824749894e-3 * t391 * t393
  t397 = 0.1e1 / t396
  t401 = t200 * t201
  t407 = t216 * t118 * t213 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t357 * t393
  t408 = t396 ** 2
  t409 = 0.1e1 / t408
  t410 = t407 * t409
  t411 = t378 * t201
  t412 = t275 * t203
  t414 = t411 * t412 * t82
  t416 = t118 * t209 * t211
  t417 = t6 * t349
  t419 = t416 * t417 * t272
  t422 = t206 * t118
  t425 = 0.64566115702479338842975206611570247933884297520660e-1 * t381 * t422 * t384
  t426 = t382 * t217
  t427 = t212 * t230
  t431 = t388 * t268
  t433 = 0.1e1 / t274 / t273
  t434 = t433 * t276
  t435 = t434 * t279
  t436 = t431 * t435
  t440 = 0.35732428259193848975967683706226155512406451549951e-2 * t391 * t363
  t441 = t392 * t369
  t445 = -0.27671192443919716646989374262101534828807556080283e-1 * t414 * t419 - t425 - 0.55342384887839433293978748524203069657615112160566e-1 * t381 * t426 * t427 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t352 - t440 - 0.30627795650737584836543728891050990439205529899958e-2 * t391 * t441 * t372
  t449 = 0.88547815820543093270365997638724911452184179456906e0 * t200 * t201 * t376 * t397 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t410 * t445
  t450 = t449 ** 2
  t456 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t200 * t201 * t407 * t397
  t457 = t456 ** 2
  t458 = 0.1e1 / t457
  t462 = t3 * t188
  t465 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t11 + 0.18472500000000000000000000000000000000000000000000e-2 * t25
  t468 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t11 + 0.11800000000000000000000000000000000000000000000000e3 * t25
  t469 = 0.1e1 / t468
  t471 = t465 * t469 - 0.18535714285714285714285714285714285714285714285714e-2
  t474 = t462 * t471 * t197 * t203
  t475 = t382 * t211
  t477 = 9 ** (0.1e1 / 0.3e1)
  t478 = t477 ** 2
  t480 = t3 * t6 * t478 * t4
  t482 = 0.1e1 / t22 / t204
  t484 = t203 * t118
  t487 = 0.100e3 / 0.27e2 * t480 * t482 * t198 * t484
  t488 = t77 * t197
  t489 = t484 * t230
  t493 = t487 - 0.25e2 / 0.9e1 * t480 * t488 * t489
  t494 = t493 ** 2
  t500 = jnp.exp(-0.25e2 / 0.18e2 * t480 * t77 * t198 * t484)
  t505 = t422 * t211
  t507 = t6 * t493 * t500
  t509 = t474 * t505 * t507
  t514 = 0.1100e4 / 0.81e2 * t480 * t279 * t198 * t484
  t515 = t482 * t197
  t517 = t480 * t515 * t489
  t519 = t230 ** 2
  t524 = 0.1e1 / t110
  t525 = t170 ** 2
  t528 = 0.1e1 / t204
  t529 = t102 * t528
  t531 = -0.2e1 * t168 + 0.2e1 * t529
  t535 = f.my_piecewise3(t106, 0, -0.2e1 / 0.9e1 * t524 * t525 + 0.2e1 / 0.3e1 * t221 * t531)
  t536 = 0.1e1 / t115
  t537 = t174 ** 2
  t540 = -t531
  t544 = f.my_piecewise3(t113, 0, -0.2e1 / 0.9e1 * t536 * t537 + 0.2e1 / 0.3e1 * t225 * t540)
  t546 = t535 / 0.2e1 + t544 / 0.2e1
  t559 = -0.19388333333333333333333333333333333333333333333333e1 * t41 - 0.12315000000000000000000000000000000000000000000000e-2 * t50
  t561 = t468 ** 2
  t562 = 0.1e1 / t561
  t563 = t465 * t562
  t566 = -0.72691666666666666666666666666666666666666666666667e3 * t41 - 0.78666666666666666666666666666666666666666666666667e2 * t50
  t568 = t559 * t469 - t563 * t566
  t571 = t462 * t568 * t197 * t203
  t572 = t475 * t507
  t573 = t571 * t572
  t576 = t462 * t471 * t230 * t203
  t579 = 0.1e1 / t8 / t241
  t580 = t579 * t118
  t581 = t212 * t500
  t584 = 0.35e2 / 0.9e1 * t474 * t580 * t581
  t585 = t422 * t581
  t587 = 0.7e1 / 0.3e1 * t571 * t585
  t588 = t576 * t585
  t600 = t566 ** 2
  t611 = t382 * t581
  t613 = t462 * ((0.25851111111111111111111111111111111111111111111111e1 * t87 + 0.20525000000000000000000000000000000000000000000000e-2 * t96) * t469 - 0.2e1 * t559 * t562 * t566 + 0.2e1 * t465 / t561 / t468 * t600 - t563 * (0.96922222222222222222222222222222222222222222222222e3 * t87 + 0.13111111111111111111111111111111111111111111111111e3 * t96)) * t197 * t203 * t611 / 0.2e1
  t617 = t462 * t568 * t230 * t203 * t611
  t623 = t61 - t68 + t101 + t147 - t155 - t167 - t184 - 0.25507875555555555555555555555555555555555555555556e-1 * t190 * t199 * t450 * t458 + t474 * t475 * t6 * t494 * t500 / 0.2e1 - 0.7e1 / 0.3e1 * t509 + t474 * t475 * t6 * (-t514 + 0.400e3 / 0.27e2 * t517 - 0.25e2 / 0.9e1 * t480 * t77 * t519 * t484 - 0.25e2 / 0.9e1 * t480 * t488 * t484 * t546) * t500 / 0.2e1 + t573 + t576 * t572 + t584 - t587 - 0.7e1 / 0.3e1 * t588 + t613 + t617 + t462 * t471 * t546 * t203 * t611 / 0.2e1
  t627 = 0.35e2 / 0.432e3 * t203 * t579 * t118 * t213
  t628 = t207 * t218
  t629 = t628 * t232
  t631 = t118 * t284
  t632 = t216 * t631
  t641 = t235 * t435
  t642 = t349 ** 2
  t643 = t7 * t642
  t644 = t272 ** 2
  t646 = t287 * t643 * t644
  t650 = t235 * t277 * t359
  t651 = t650 * t352
  t655 = t276 * t279 * t282
  t656 = t235 * t275 * t655
  t658 = t369 * t286 * t7
  t659 = t349 * t272
  t664 = t241 * t75
  t668 = 0.20e2 * t240 / t664 * t261
  t671 = 0.12e2 * t239 * t242 * t261
  t674 = 0.32e2 * t294 * t299 * t261
  t677 = 0.14764770444444444444444444444444444444444444444444e-2 * t5 * t86 * t236
  t678 = 0.1e1 / t192
  t684 = f.my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t678 * t525 + 0.4e1 / 0.3e1 * t109 * t531)
  t685 = 0.1e1 / t194
  t691 = f.my_piecewise3(t113, 0, 0.4e1 / 0.9e1 * t685 * t537 + 0.4e1 / 0.3e1 * t114 * t540)
  t693 = (t684 + t691) * t121
  t695 = 0.19751789702565206228825776161588751761046270558698e-1 * t693 * t258
  t699 = t5 * t7
  t707 = t315 ** 2
  t721 = t308 ** 2
  t724 = t253 ** 2
  t732 = 0.35616666666666666666666666666666666666666666666666e-1 * t699 * t36 * t69 * t291
  t751 = -0.70981924444444444444444444444444444444444444444442e-3 * t5 * t86 * t254 - 0.34246666666666666666666666666666666666666666666666e-1 * t699 * t36 * t309 * t317 - 0.20000000000000000000000000000000000000000000000000e1 * t245 / t308 / t250 * t707 * t316 + 0.99999999999999999999999999999999999999999999999999e0 * t310 * (-0.78438333333333333333333333333333333333333333333333e0 * t79 + 0.15687666666666666666666666666666666666666666666667e1 * t84 + 0.68863333333333333333333333333333333333333333333333e0 * t87 + 0.14025833333333333333333333333333333333333333333333e0 * t91 + 0.28051666666666666666666666666666666666666666666667e0 * t93 + 0.17365833333333333333333333333333333333333333333333e0 * t96) * t316 + 0.32164683177870697973624959794146027661627532968800e2 * t245 / t721 * t707 / t724 + t677 + t732 + t68 - t101 - t61 - 0.24415406715670879921742973310852762593515528885057e-3 * t5 * t86 * t257 - 0.10843580882781524214666447553230042011687479519034e-1 * t699 * t36 * t156 * t324 - 0.11696446794910408141662685001236899248561775660981e1 * t124 * t133 * t139 * t144 + 0.58482233974552040708313425006184496242808878304903e0 * t323 * t163 * t144 + 0.17315755899375863299672358916972966258900005419821e2 * t124 * t149 * t139 * t152
  t753 = t243 * t122 * t751
  t754 = -t155 - t167 - t184 + t668 + t671 - t674 - t677 + t695 + t101 + t61 + t753
  t756 = t243 * t179 * t327
  t757 = 0.2e1 * t756
  t759 = t243 * t693 * t260
  t760 = t300 * t303
  t761 = 0.8e1 * t760
  t763 = 0.8e1 * t300 * t328
  t764 = t295 * t303
  t765 = 0.8e1 * t764
  t767 = 0.8e1 * t295 * t328
  t771 = 0.10843580882781524214666447553230042011687479519034e-1 * t122 * t5 * t40 * t182
  t773 = t179 * t2 * t334
  t774 = 0.36623110073506319882614459966279143890273293327586e-3 * t773
  t778 = 0.24415406715670879921742973310852762593515528885057e-3 * t332 * t34 * t82 * t257
  t779 = t757 + t759 - t761 - t763 + t765 + t767 - t68 + t771 - t774 + t147 - t732 + t778
  t785 = t339 * t284 * t185
  t789 = t265 * t369 * t185
  t796 = -0.13067859477648036196925324326848422587394359423983e2 * (t754 + t779) * t217 * t269 + 0.78407156865888217181551945961090535524366156543898e2 * t785 * t346 - 0.15681431373177643436310389192218107104873231308780e3 * t789 * t345 * t519 + 0.39203578432944108590775972980545267762183078271949e2 * t344 * t345 * t546
  t799 = t287 * t7 * t796 * t272
  t803 = t287 * t643 * t272
  t809 = 0.1e1 / t22 / t664 * t282 * t362
  t811 = 0.22867165977961432506887052341597796143250688705235e-1 * t357 * t809
  t813 = t235 * t356 * t359
  t814 = t813 * t373
  t817 = 0.1e1 / t283 / t198
  t818 = t282 * t817
  t819 = t371 * t519
  t823 = t371 * t546
  t827 = t627 + 0.7e1 / 0.72e2 * t629 + t632 * t220 * t6 * t519 / 0.16e2 - t219 * t220 * t6 * t546 / 0.48e2 + 0.17294495277449822904368358913813459268004722550178e-2 * t641 * t646 + 0.80707644628099173553719008264462809917355371900828e-2 * t651 + 0.69177981109799291617473435655253837072018890200710e-2 * t656 * t658 * t659 * t230 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t799 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t803 + t811 + 0.32283057851239669421487603305785123966942148760332e-1 * t814 + 0.17294495277449822904368358913813459268004722550178e-1 * t367 * t818 * t819 - 0.34588990554899645808736717827626918536009445100355e-2 * t367 * t370 * t823
  t832 = t376 * t409
  t838 = t407 / t408 / t396
  t839 = t445 ** 2
  t845 = t411 * t433 * t203 * t82
  t846 = t6 * t642
  t852 = t411 * t412 * t206
  t853 = t852 * t419
  t855 = t218 * t211
  t856 = t272 * t230
  t872 = 0.21522038567493112947658402203856749311294765840220e0 * t381 * t580 * t384
  t873 = t422 * t217
  t875 = t381 * t873 * t427
  t877 = t382 * t284
  t886 = t274 ** 2
  t890 = t431 / t886 * t276 * t279
  t894 = t431 * t434 * t359
  t895 = t894 * t352
  t897 = t370 * t286
  t907 = 0.20248376013543181086381687433528154790363655878306e-1 * t391 * t809
  t908 = t360 * t369
  t910 = t391 * t908 * t372
  t912 = t392 * t817
  t919 = 0.55342384887839433293978748524203069657615112160566e-1 * t845 * t416 * t846 * t644 + 0.12913223140495867768595041322314049586776859504132e0 * t853 + 0.11068476977567886658795749704840613931523022432113e0 * t414 * t855 * t417 * t856 - 0.27671192443919716646989374262101534828807556080283e-1 * t414 * t416 * t6 * t796 * t272 - 0.27671192443919716646989374262101534828807556080283e-1 * t414 * t416 * t846 * t272 + t872 + 0.25826446280991735537190082644628099173553719008264e0 * t875 + 0.16602715466351829988193624557260920897284533648170e0 * t381 * t877 * t212 * t519 - 0.55342384887839433293978748524203069657615112160566e-1 * t381 * t426 * t212 * t546 + 0.45941693476106377254815593336576485658808294849937e-2 * t890 * t646 + 0.14292971303677539590387073482490462204962580619980e-1 * t895 + 0.12251118260295033934617491556420396175682211959983e-1 * t436 * t897 * t350 * t856 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t799 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t803 + t907 + 0.28585942607355079180774146964980924409925161239960e-1 * t910 + 0.15313897825368792418271864445525495219602764949979e-1 * t391 * t912 * t819 - 0.30627795650737584836543728891050990439205529899958e-2 * t391 * t441 * t823
  t925 = 0.1e1 / t456
  t929 = jnp.log(t456)
  t930 = t197 * t929
  t934 = t198 * t929
  t938 = t198 * t449
  t939 = t925 * t230
  t943 = 0.25507875555555555555555555555555555555555555555556e-1 * t190 * t199 * (0.88547815820543093270365997638724911452184179456906e0 * t200 * t201 * t827 * t397 - 0.17709563164108618654073199527744982290436835891381e1 * t401 * t832 * t445 + 0.17709563164108618654073199527744982290436835891381e1 * t401 * t838 * t839 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t410 * t919) * t925 + 0.15304725333333333333333333333333333333333333333334e0 * t190 * t930 * t519 + 0.76523626666666666666666666666666666666666666666668e-1 * t190 * t934 * t546 + t771 + t695 + t757 + t759 - t761 - t763 + t765 + t767 + t668 + t671 - t674 + t753 - t677 - t732 - t774 + t778 + 0.15304725333333333333333333333333333333333333333334e0 * t190 * t938 * t939
  t946 = 0.2e1 * t329
  t949 = 0.20000000000000000000000000000000000000000000000000e1 * t292
  t950 = 0.36623110073506319882614459966279143890273293327586e-3 * t335
  t951 = t474 * t572
  t952 = t571 * t611
  t953 = t576 * t611
  t955 = 0.7e1 / 0.3e1 * t474 * t585
  t956 = 0.8e1 * t296
  t957 = 0.8e1 * t301
  t958 = 0.22147155666666666666666666666666666666666666666666e-2 * t289
  t959 = 0.11696446794910408141662685001236899248561775660981e1 * t337
  t961 = t190 * t934 * t230
  t965 = t190 * t199 * t449 * t925
  d11 = t1 * (t623 + t943) + t946 + 0.2e1 * t304 + 0.39503579405130412457651552323177503522092541117396e-1 * t330 + t949 - t950 + t951 + t952 + t953 - t955 + t956 - t957 + t958 - t959 + 0.15304725333333333333333333333333333333333333333334e0 * t961 + 0.51015751111111111111111111111111111111111111111112e-1 * t965
  t967 = -t103 - t169
  t970 = f.my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t109 * t967)
  t971 = -t967
  t974 = f.my_piecewise3(t113, 0, 0.4e1 / 0.3e1 * t114 * t971)
  t976 = (t970 + t974) * t121
  t977 = t976 * t260
  t978 = t243 * t977
  t986 = f.my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t678 * t967 * t170 + 0.8e1 / 0.3e1 * t109 * t102 * t528)
  t994 = f.my_piecewise3(t113, 0, 0.4e1 / 0.9e1 * t685 * t971 * t174 - 0.8e1 / 0.3e1 * t114 * t102 * t528)
  t996 = (t986 + t994) * t121
  t998 = 0.19751789702565206228825776161588751761046270558698e-1 * t996 * t258
  t1007 = f.my_piecewise3(t106, 0, 0.2e1 / 0.3e1 * t221 * t967)
  t1010 = f.my_piecewise3(t113, 0, 0.2e1 / 0.3e1 * t225 * t971)
  t1012 = t1007 / 0.2e1 + t1010 / 0.2e1
  t1013 = t484 * t1012
  t1017 = t487 - 0.25e2 / 0.9e1 * t480 * t488 * t1013
  t1023 = 0.58482233974552040708313425006184496242808878304903e0 * t183
  t1031 = f.my_piecewise3(t106, 0, -0.2e1 / 0.9e1 * t524 * t967 * t170 + 0.4e1 / 0.3e1 * t221 * t102 * t528)
  t1039 = f.my_piecewise3(t113, 0, -0.2e1 / 0.9e1 * t536 * t971 * t174 - 0.4e1 / 0.3e1 * t225 * t102 * t528)
  t1041 = t1031 / 0.2e1 + t1039 / 0.2e1
  t1046 = t6 * t1012
  t1047 = t220 * t1046
  t1048 = t628 * t1047
  t1050 = t1046 * t230
  t1060 = t976 * t258
  t1061 = 0.19751789702565206228825776161588751761046270558698e-1 * t1060
  t1062 = t290 + t293 - t297 - t302 + t978 + t329 + t1061 - t336 - t338
  t1066 = t345 * t1012
  t1069 = -0.13067859477648036196925324326848422587394359423983e2 * t1062 * t217 * t269 + 0.39203578432944108590775972980545267762183078271949e2 * t344 * t1066
  t1075 = t7 * t1069
  t1077 = t287 * t1075 * t272
  t1078 = t650 * t1077
  t1080 = t1069 * t272
  t1086 = t976 * t2 * t334
  t1087 = 0.18311555036753159941307229983139571945136646663793e-3 * t1086
  t1088 = 0.4e1 * t760
  t1089 = t61 - t68 + t101 + t147 + t998 - t155 - t167 - t1023 - t1087 + t771 + t756 - t1088 - t763
  t1090 = 0.4e1 * t764
  t1092 = t976 * t124 * t182
  t1093 = 0.58482233974552040708313425006184496242808878304903e0 * t1092
  t1094 = t300 * t977
  t1095 = 0.4e1 * t1094
  t1097 = t243 * t996 * t260
  t1099 = t243 * t976 * t327
  t1100 = t295 * t977
  t1101 = 0.4e1 * t1100
  t1102 = 0.18311555036753159941307229983139571945136646663793e-3 * t773
  t1103 = -t1090 + t668 - t671 + t753 - t677 - t732 - t1093 - t1095 + t1097 + t1099 + t1101 - t1102 + t778
  t1109 = t1062 * t284 * t185
  t1114 = t1012 * t230
  t1121 = -0.13067859477648036196925324326848422587394359423983e2 * (t1089 + t1103) * t217 * t269 + 0.39203578432944108590775972980545267762183078271949e2 * t1109 * t346 + 0.39203578432944108590775972980545267762183078271949e2 * t785 * t1066 - 0.15681431373177643436310389192218107104873231308780e3 * t789 * t345 * t1114 + 0.39203578432944108590775972980545267762183078271949e2 * t344 * t345 * t1041
  t1124 = t287 * t7 * t1121 * t272
  t1139 = t371 * t1012
  t1140 = t370 * t1139
  t1141 = t813 * t1140
  t1144 = t7 * t1012
  t1146 = t818 * t286 * t1144 * t230
  t1149 = t371 * t1041
  t1153 = t627 + 0.7e1 / 0.144e3 * t629 + 0.7e1 / 0.144e3 * t1048 + t632 * t220 * t1050 / 0.16e2 - t219 * t220 * t6 * t1041 / 0.48e2 + 0.17294495277449822904368358913813459268004722550178e-2 * t235 * t433 * t655 * t362 * t1069 * t644 * t349 + 0.40353822314049586776859504132231404958677685950414e-2 * t1078 + 0.34588990554899645808736717827626918536009445100355e-2 * t656 * t658 * t1080 * t230 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t1124 - 0.86472476387249114521841794569067296340023612750888e-3 * t656 * t362 * t1069 * t349 * t272 + 0.40353822314049586776859504132231404958677685950414e-2 * t651 + t811 + 0.16141528925619834710743801652892561983471074380166e-1 * t814 + 0.34588990554899645808736717827626918536009445100355e-2 * t656 * t658 * t1012 * t349 * t272 + 0.16141528925619834710743801652892561983471074380166e-1 * t1141 + 0.17294495277449822904368358913813459268004722550178e-1 * t367 * t1146 - 0.34588990554899645808736717827626918536009445100355e-2 * t367 * t370 * t1149
  t1164 = -t215 - t219 * t1047 / 0.48e2 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t1077 - t365 - 0.34588990554899645808736717827626918536009445100355e-2 * t367 * t1140
  t1165 = t1164 * t409
  t1169 = t6 * t1069
  t1171 = t416 * t1169 * t272
  t1174 = t212 * t1012
  t1183 = -0.27671192443919716646989374262101534828807556080283e-1 * t414 * t1171 - t425 - 0.55342384887839433293978748524203069657615112160566e-1 * t381 * t426 * t1174 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t1077 - t440 - 0.30627795650737584836543728891050990439205529899958e-2 * t391 * t441 * t1139
  t1191 = t644 * t349
  t1196 = t852 * t1171
  t1218 = t381 * t873 * t1174
  t1231 = 0.55342384887839433293978748524203069657615112160566e-1 * t845 * t416 * t1169 * t1191 + 0.64566115702479338842975206611570247933884297520660e-1 * t1196 + 0.55342384887839433293978748524203069657615112160566e-1 * t414 * t855 * t1169 * t856 - 0.27671192443919716646989374262101534828807556080283e-1 * t414 * t416 * t6 * t1121 * t272 - 0.27671192443919716646989374262101534828807556080283e-1 * t414 * t416 * t1169 * t659 + 0.64566115702479338842975206611570247933884297520660e-1 * t853 + t872 + 0.12913223140495867768595041322314049586776859504132e0 * t875 + 0.55342384887839433293978748524203069657615112160566e-1 * t414 * t855 * t1046 * t659 + 0.12913223140495867768595041322314049586776859504132e0 * t1218 + 0.16602715466351829988193624557260920897284533648170e0 * t411 * t355 * t203 * t82 * t631 * t211 * t1050 - 0.55342384887839433293978748524203069657615112160566e-1 * t381 * t426 * t212 * t1041
  t1236 = t894 * t1077
  t1255 = t391 * t908 * t1139
  t1263 = 0.45941693476106377254815593336576485658808294849937e-2 * t890 * t287 * t1075 * t1191 + 0.71464856518387697951935367412452311024812903099902e-2 * t1236 + 0.61255591301475169673087457782101980878411059799916e-2 * t436 * t897 * t1075 * t856 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t1124 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t287 * t1075 * t659 + 0.71464856518387697951935367412452311024812903099902e-2 * t895 + t907 + 0.14292971303677539590387073482490462204962580619980e-1 * t910 + 0.61255591301475169673087457782101980878411059799916e-2 * t436 * t897 * t1144 * t659 + 0.14292971303677539590387073482490462204962580619980e-1 * t1255 + 0.15313897825368792418271864445525495219602764949979e-1 * t431 * t280 * t1146 - 0.30627795650737584836543728891050990439205529899958e-2 * t391 * t441 * t1149
  t1274 = t61 - t68 + t101 + t147 + t998 + t462 * t471 * t197 * t203 * t82 * t118 * t211 * t6 * t1017 * t493 * t500 / 0.2e1 - t155 - t167 - t1023 + 0.76523626666666666666666666666666666666666666666668e-1 * t190 * t934 * t1041 + 0.25507875555555555555555555555555555555555555555556e-1 * t190 * t199 * (0.88547815820543093270365997638724911452184179456906e0 * t200 * t201 * t1153 * t397 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t1165 * t445 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t832 * t1183 + 0.17709563164108618654073199527744982290436835891381e1 * t401 * t838 * t1183 * t445 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t410 * (t1231 + t1263)) * t925 - 0.7e1 / 0.6e1 * t509
  t1277 = t6 * t1017 * t500
  t1278 = t475 * t1277
  t1283 = t480 * t515 * t1013
  t1301 = t462 * t471 * t1012 * t203
  t1304 = t571 * t1278
  t1307 = t474 * t505 * t1277
  t1312 = t462 * t568 * t1012 * t203 * t611
  t1319 = t1301 * t585
  t1321 = t573 / 0.2e1 + t576 * t1278 / 0.2e1 + t474 * t475 * t6 * (-t514 + 0.200e3 / 0.27e2 * t517 + 0.200e3 / 0.27e2 * t1283 - 0.25e2 / 0.9e1 * t480 * t77 * t230 * t1013 - 0.25e2 / 0.9e1 * t480 * t488 * t484 * t1041) * t500 / 0.2e1 + t1301 * t572 / 0.2e1 + t1304 / 0.2e1 - 0.7e1 / 0.6e1 * t1307 + t1312 / 0.2e1 + t462 * t471 * t1041 * t203 * t611 / 0.2e1 - 0.7e1 / 0.6e1 * t1319 - t1087 + t584 - t587
  t1332 = 0.88547815820543093270365997638724911452184179456906e0 * t200 * t201 * t1164 * t397 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t410 * t1183
  t1333 = t198 * t1332
  t1337 = t199 * t1332
  t1345 = t925 * t1012
  t1349 = -0.7e1 / 0.6e1 * t588 + t613 + t617 / 0.2e1 + t771 + 0.76523626666666666666666666666666666666666666666668e-1 * t190 * t1333 * t939 - 0.25507875555555555555555555555555555555555555555556e-1 * t190 * t1337 * t458 * t449 + 0.15304725333333333333333333333333333333333333333334e0 * t190 * t930 * t1114 + 0.76523626666666666666666666666666666666666666666668e-1 * t190 * t938 * t1345 + t756 - t1088 - t763 - t1090
  t1350 = t668 - t671 + t753 - t677 - t732 - t1093 - t1095 + t1097 + t1099 + t1101 - t1102 + t778
  t1357 = t190 * t1337 * t925
  t1361 = t474 * t1278
  t1364 = t1301 * t611
  t1367 = t190 * t934 * t1012
  t1369 = t951 / 0.2e1 + t1361 / 0.2e1 + t953 / 0.2e1 + t952 + t1364 / 0.2e1 - t955 - t959 + t331 + t304 + 0.76523626666666666666666666666666666666666666666668e-1 * t1367 + t1061
  d12 = t949 + t946 - t957 + t978 + t958 + t1 * (t1274 + t1321 + t1349 + t1350) + 0.25507875555555555555555555555555555555555555555556e-1 * t965 + 0.76523626666666666666666666666666666666666666666668e-1 * t961 + 0.25507875555555555555555555555555555555555555555556e-1 * t1357 - t950 + t1369
  t1371 = t1332 ** 2
  t1376 = t967 ** 2
  t1380 = 0.2e1 * t168 + 0.2e1 * t529
  t1384 = f.my_piecewise3(t106, 0, -0.2e1 / 0.9e1 * t524 * t1376 + 0.2e1 / 0.3e1 * t221 * t1380)
  t1385 = t971 ** 2
  t1388 = -t1380
  t1392 = f.my_piecewise3(t113, 0, -0.2e1 / 0.9e1 * t536 * t1385 + 0.2e1 / 0.3e1 * t225 * t1388)
  t1394 = t1384 / 0.2e1 + t1392 / 0.2e1
  t1398 = t1012 ** 2
  t1418 = t1017 ** 2
  t1429 = f.my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t678 * t1376 + 0.4e1 / 0.3e1 * t109 * t1380)
  t1435 = f.my_piecewise3(t113, 0, 0.4e1 / 0.9e1 * t685 * t1385 + 0.4e1 / 0.3e1 * t114 * t1388)
  t1437 = (t1429 + t1435) * t121
  t1439 = 0.19751789702565206228825776161588751761046270558698e-1 * t1437 * t258
  t1441 = t243 * t1437 * t260
  t1444 = 0.36623110073506319882614459966279143890273293327586e-3 * t1086
  t1445 = t61 - t68 + t101 - 0.25507875555555555555555555555555555555555555555556e-1 * t190 * t199 * t1371 * t458 + 0.76523626666666666666666666666666666666666666666668e-1 * t190 * t934 * t1394 + 0.15304725333333333333333333333333333333333333333334e0 * t190 * t930 * t1398 + t147 + t474 * t475 * t6 * (-t514 + 0.400e3 / 0.27e2 * t1283 - 0.25e2 / 0.9e1 * t480 * t77 * t1398 * t484 - 0.25e2 / 0.9e1 * t480 * t488 * t484 * t1394) * t500 / 0.2e1 + t1301 * t1278 + t474 * t475 * t6 * t1418 * t500 / 0.2e1 + t1439 + t1441 - t155 - t167 + t1304 - 0.7e1 / 0.3e1 * t1307 + t1312 - 0.7e1 / 0.3e1 * t1319 - t1444
  t1454 = 0.11696446794910408141662685001236899248561775660981e1 * t1092
  t1464 = t1069 ** 2
  t1465 = t7 * t1464
  t1467 = t287 * t1465 * t644
  t1475 = 0.8e1 * t1094
  t1476 = 0.8e1 * t1100
  t1477 = t101 + t61 + t1439 + t671 - t1475 - t763 - t68 + t753 - t1454 - t1476 - t767
  t1478 = 0.2e1 * t1099
  t1479 = t668 + t674 - t677 + t1441 + t1478 + t771 - t1444 + t147 - t732 - t167 - t155 + t778
  t1492 = -0.13067859477648036196925324326848422587394359423983e2 * (t1477 + t1479) * t217 * t269 + 0.78407156865888217181551945961090535524366156543898e2 * t1109 * t1066 - 0.15681431373177643436310389192218107104873231308780e3 * t789 * t345 * t1398 + 0.39203578432944108590775972980545267762183078271949e2 * t344 * t345 * t1394
  t1495 = t287 * t7 * t1492 * t272
  t1499 = t287 * t1465 * t272
  t1503 = t371 * t1398
  t1507 = t371 * t1394
  t1511 = t627 + 0.7e1 / 0.72e2 * t1048 + t632 * t220 * t6 * t1398 / 0.16e2 - t219 * t220 * t6 * t1394 / 0.48e2 + 0.17294495277449822904368358913813459268004722550178e-2 * t641 * t1467 + 0.80707644628099173553719008264462809917355371900828e-2 * t1078 + 0.69177981109799291617473435655253837072018890200710e-2 * t656 * t658 * t1080 * t1012 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t1495 - 0.86472476387249114521841794569067296340023612750888e-3 * t281 * t1499 + t811 + 0.32283057851239669421487603305785123966942148760332e-1 * t1141 + 0.17294495277449822904368358913813459268004722550178e-1 * t367 * t818 * t1503 - 0.34588990554899645808736717827626918536009445100355e-2 * t367 * t370 * t1507
  t1519 = t1183 ** 2
  t1523 = t6 * t1464
  t1529 = t272 * t1012
  t1570 = 0.55342384887839433293978748524203069657615112160566e-1 * t845 * t416 * t1523 * t644 + 0.12913223140495867768595041322314049586776859504132e0 * t1196 + 0.11068476977567886658795749704840613931523022432113e0 * t414 * t855 * t1169 * t1529 - 0.27671192443919716646989374262101534828807556080283e-1 * t414 * t416 * t6 * t1492 * t272 - 0.27671192443919716646989374262101534828807556080283e-1 * t414 * t416 * t1523 * t272 + t872 + 0.25826446280991735537190082644628099173553719008264e0 * t1218 + 0.16602715466351829988193624557260920897284533648170e0 * t381 * t877 * t212 * t1398 - 0.55342384887839433293978748524203069657615112160566e-1 * t381 * t426 * t212 * t1394 + 0.45941693476106377254815593336576485658808294849937e-2 * t890 * t1467 + 0.14292971303677539590387073482490462204962580619980e-1 * t1236 + 0.12251118260295033934617491556420396175682211959983e-1 * t436 * t897 * t1075 * t1529 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t1495 - 0.15313897825368792418271864445525495219602764949979e-2 * t436 * t1499 + t907 + 0.28585942607355079180774146964980924409925161239960e-1 * t1255 + 0.15313897825368792418271864445525495219602764949979e-1 * t391 * t912 * t1503 - 0.30627795650737584836543728891050990439205529899958e-2 * t391 * t441 * t1507
  t1579 = t584 - t587 + t613 + t462 * t471 * t1394 * t203 * t611 / 0.2e1 + t771 + 0.15304725333333333333333333333333333333333333333334e0 * t190 * t1333 * t1345 - t763 - t767 + t668 + t671 + t674 + t753 - t677 - t732 - t1454 + 0.25507875555555555555555555555555555555555555555556e-1 * t190 * t199 * (0.88547815820543093270365997638724911452184179456906e0 * t200 * t201 * t1511 * t397 - 0.17709563164108618654073199527744982290436835891381e1 * t401 * t1165 * t1183 + 0.17709563164108618654073199527744982290436835891381e1 * t401 * t838 * t1519 - 0.88547815820543093270365997638724911452184179456906e0 * t401 * t410 * t1570) * t925 - t1475 + t1478 - t1476 + t778
  d22 = 0.39503579405130412457651552323177503522092541117396e-1 * t1060 + t1 * (t1445 + t1579) + t949 + t946 - t957 + 0.2e1 * t978 + t958 - t956 + 0.51015751111111111111111111111111111111111111111112e-1 * t1357 - t959 + 0.15304725333333333333333333333333333333333333333334e0 * t1367 - t950 + t1361 + t952 + t1364 - t955
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = r0 + r1
  t9 = t8 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t14 = t4 * t6 / t9
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t9 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t31 = t11 * t30
  t33 = 0.1e1 / t15 * t1
  t34 = t3 * t6
  t35 = t34 * t11
  t36 = t33 * t35
  t38 = t6 * t11
  t39 = t4 * t38
  t41 = t14 ** 0.5e0
  t42 = t41 * t1
  t43 = t42 * t35
  t48 = t22 * t5 / t23 / t8
  t50 = -0.63297500000000000000000000000000000000000000000000e0 * t36 - 0.29896666666666666666666666666666666666666666666667e0 * t39 - 0.10238750000000000000000000000000000000000000000000e0 * t43 - 0.82156666666666666666666666666666666666666666666667e-1 * t48
  t53 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t54 = 0.1e1 / t53
  t55 = t50 * t54
  t57 = t7 * t31 * t55
  t59 = r0 - r1
  t60 = 0.1e1 / t8
  t61 = t59 * t60
  t62 = 0.1e1 + t61
  t63 = t62 <= f.p.zeta_threshold
  t64 = t62 ** (0.1e1 / 0.3e1)
  t65 = t8 ** 2
  t66 = 0.1e1 / t65
  t68 = -t59 * t66 + t60
  t71 = f.my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t64 * t68)
  t72 = 0.1e1 - t61
  t73 = t72 <= f.p.zeta_threshold
  t74 = t72 ** (0.1e1 / 0.3e1)
  t75 = -t68
  t78 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t74 * t75)
  t80 = 2 ** (0.1e1 / 0.3e1)
  t83 = 0.1e1 / (0.2e1 * t80 - 0.2e1)
  t84 = (t71 + t78) * t83
  t85 = t84 * t1
  t90 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t93 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t90
  t94 = jnp.log(t93)
  t96 = t34 * t11 * t94
  t97 = t85 * t96
  t99 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t100 = t99 * f.p.zeta_threshold
  t101 = t64 * t62
  t102 = f.my_piecewise3(t63, t100, t101)
  t103 = t74 * t72
  t104 = f.my_piecewise3(t73, t100, t103)
  t106 = (t102 + t104 - 0.2e1) * t83
  t107 = t106 * t1
  t109 = 0.1e1 / t9 / t65
  t111 = t34 * t109 * t94
  t112 = t107 * t111
  t114 = jnp.pi ** 2
  t115 = t114 ** (0.1e1 / 0.3e1)
  t116 = t2 * t115
  t119 = -0.19388333333333333333333333333333333333333333333333e1 * t39 - 0.12315000000000000000000000000000000000000000000000e-2 * t48
  t122 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t14 + 0.11800000000000000000000000000000000000000000000000e3 * t26
  t123 = 0.1e1 / t122
  t127 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t14 + 0.18472500000000000000000000000000000000000000000000e-2 * t26
  t128 = t122 ** 2
  t129 = 0.1e1 / t128
  t130 = t127 * t129
  t133 = -0.72691666666666666666666666666666666666666666666667e3 * t39 - 0.78666666666666666666666666666666666666666666666667e2 * t48
  t135 = t119 * t123 - t130 * t133
  t136 = t99 ** 2
  t137 = t64 ** 2
  t138 = f.my_piecewise3(t63, t136, t137)
  t139 = t74 ** 2
  t140 = f.my_piecewise3(t73, t136, t139)
  t142 = t138 / 0.2e1 + t140 / 0.2e1
  t145 = s0 + 0.2e1 * s1 + s2
  t147 = t116 * t135 * t142 * t145
  t148 = t109 * t80
  t149 = 0.1e1 / t3
  t150 = t148 * t149
  t152 = 9 ** (0.1e1 / 0.3e1)
  t153 = t152 ** 2
  t155 = t2 * t5 * t153 * t3
  t156 = t65 * t8
  t158 = 0.1e1 / t23 / t156
  t159 = t142 ** 2
  t161 = t145 * t80
  t166 = 0.1e1 / t23 / t65
  t167 = t166 * t142
  t168 = 0.1e1 / t64
  t171 = f.my_piecewise3(t63, 0, 0.2e1 / 0.3e1 * t168 * t68)
  t172 = 0.1e1 / t74
  t175 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t172 * t75)
  t177 = t171 / 0.2e1 + t175 / 0.2e1
  t178 = t161 * t177
  t182 = 0.100e3 / 0.27e2 * t155 * t158 * t159 * t161 - 0.25e2 / 0.9e1 * t155 * t167 * t178
  t188 = jnp.exp(-0.25e2 / 0.18e2 * t155 * t166 * t159 * t161)
  t189 = t5 * t182 * t188
  t190 = t150 * t189
  t194 = t127 * t123 - 0.18535714285714285714285714285714285714285714285714e-2
  t197 = t116 * t194 * t177 * t145
  t201 = 0.1e1 / t114 * t20
  t202 = t115 ** 2
  t203 = t201 * t202
  t204 = t159 * t142
  t205 = jnp.pi * t20
  t206 = 0.1e1 / t115
  t208 = 0.1e1 / t9 / t156
  t209 = t145 * t208
  t211 = 0.1e1 / t159
  t213 = t149 * t5
  t214 = t211 * t20 * t213
  t217 = t145 * t109
  t218 = 0.1e1 / t204
  t219 = t80 * t218
  t220 = t217 * t219
  t221 = t20 * t149
  t222 = t5 * t177
  t223 = t221 * t222
  t226 = jnp.pi * t206
  t228 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t229 = jnp.log(t53)
  t231 = 0.62182e-1 * t228 * t229
  t232 = t59 ** 2
  t233 = t232 ** 2
  t234 = t65 ** 2
  t235 = 0.1e1 / t234
  t236 = t233 * t235
  t238 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t243 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t246 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t243
  t247 = jnp.log(t246)
  t251 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t252 = t251 * t94
  t254 = -0.31090e-1 * t238 * t247 + t231 - 0.19751789702565206228825776161588751761046270558698e-1 * t252
  t255 = t106 * t254
  t259 = -t231 + t236 * t255 + 0.19751789702565206228825776161588751761046270558698e-1 * t106 * t252
  t262 = 0.1e1 / t202
  t263 = t114 * t1 * t262
  t266 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * t259 * t218 * t263)
  t267 = t266 - 0.1e1
  t268 = t267 ** 2
  t269 = 0.1e1 / t268
  t270 = t145 ** 2
  t271 = t269 * t270
  t273 = 0.1e1 / t23 / t234
  t274 = t271 * t273
  t275 = t226 * t274
  t276 = t80 ** 2
  t277 = t159 ** 2
  t278 = 0.1e1 / t277
  t280 = 0.1e1 / t21
  t281 = t276 * t278 * t280
  t284 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t38 * t229
  t285 = t228 * t30
  t287 = 0.10000000000000000000000000000000000000000000000000e1 * t285 * t55
  t288 = t232 * t59
  t289 = t288 * t235
  t292 = t234 * t8
  t293 = 0.1e1 / t292
  t294 = t233 * t293
  t297 = t84 * t254
  t302 = t243 ** 2
  t303 = 0.1e1 / t302
  t304 = t238 * t303
  t309 = -0.11765750000000000000000000000000000000000000000000e1 * t36 - 0.51647500000000000000000000000000000000000000000000e0 * t39 - 0.21038750000000000000000000000000000000000000000000e0 * t43 - 0.10419500000000000000000000000000000000000000000000e0 * t48
  t310 = 0.1e1 / t246
  t311 = t309 * t310
  t317 = t90 ** 2
  t318 = 0.1e1 / t317
  t319 = t251 * t318
  t324 = -0.86308333333333333333333333333333333333333333333334e0 * t36 - 0.30192500000000000000000000000000000000000000000000e0 * t39 - 0.55016250000000000000000000000000000000000000000000e-1 * t43 - 0.82785000000000000000000000000000000000000000000000e-1 * t48
  t325 = 0.1e1 / t93
  t326 = t324 * t325
  t329 = 0.53236443333333333333333333333333333333333333333332e-3 * t4 * t38 * t247 + 0.99999999999999999999999999999999999999999999999999e0 * t304 * t311 - t284 - t287 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t38 * t94 + 0.58482233974552040708313425006184496242808878304903e0 * t319 * t326
  t330 = t106 * t329
  t336 = t106 * t251
  t338 = t318 * t324 * t325
  t341 = t284 + t287 + 0.4e1 * t289 * t255 - 0.4e1 * t294 * t255 + t236 * t297 + t236 * t330 + 0.19751789702565206228825776161588751761046270558698e-1 * t84 * t252 - 0.18311555036753159941307229983139571945136646663793e-3 * t107 * t96 - 0.58482233974552040708313425006184496242808878304903e0 * t336 * t338
  t346 = t259 * t278 * t114
  t347 = t1 * t262
  t348 = t347 * t177
  t351 = -0.13067859477648036196925324326848422587394359423983e2 * t341 * t218 * t263 + 0.39203578432944108590775972980545267762183078271949e2 * t346 * t348
  t352 = t6 * t351
  t354 = t281 * t352 * t266
  t357 = 0.1e1 / t267
  t358 = t357 * t270
  t359 = t226 * t358
  t361 = 0.1e1 / t23 / t292
  t362 = t361 * t276
  t364 = t278 * t280 * t6
  t365 = t362 * t364
  t369 = t226 * t358 * t273
  t371 = 0.1e1 / t277 / t142
  t372 = t276 * t371
  t373 = t280 * t6
  t374 = t373 * t177
  t375 = t372 * t374
  t378 = -0.7e1 / 0.288e3 * t209 * t80 * t214 - t220 * t223 / 0.48e2 - 0.86472476387249114521841794569067296340023612750888e-3 * t275 * t354 - 0.40353822314049586776859504132231404958677685950414e-2 * t359 * t365 - 0.34588990554899645808736717827626918536009445100355e-2 * t369 * t375
  t380 = jnp.pi * t1
  t383 = t380 * t206 * t357 * t145
  t385 = t211 * t149 * t5
  t389 = t114 * t20
  t392 = t389 * t262 * t269 * t270
  t393 = t273 * t276
  t394 = t393 * t364
  t397 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t383 * t148 * t385 + 0.76569489126843962091359322227627476098013824749894e-3 * t392 * t394
  t398 = 0.1e1 / t397
  t402 = t205 * t206
  t408 = t217 * t80 * t214 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t359 * t394
  t409 = t397 ** 2
  t410 = 0.1e1 / t409
  t411 = t408 * t410
  t412 = t380 * t206
  t413 = t269 * t145
  t415 = t412 * t413 * t109
  t417 = t80 * t211 * t149
  t418 = t5 * t351
  t420 = t417 * t418 * t266
  t423 = t208 * t80
  t427 = t148 * t218
  t428 = t213 * t177
  t432 = t389 * t262
  t434 = 0.1e1 / t268 / t267
  t435 = t434 * t270
  t436 = t435 * t273
  t437 = t432 * t436
  t442 = t393 * t371
  t446 = -0.27671192443919716646989374262101534828807556080283e-1 * t415 * t420 - 0.64566115702479338842975206611570247933884297520660e-1 * t383 * t423 * t385 - 0.55342384887839433293978748524203069657615112160566e-1 * t383 * t427 * t428 - 0.15313897825368792418271864445525495219602764949979e-2 * t437 * t354 - 0.35732428259193848975967683706226155512406451549951e-2 * t392 * t365 - 0.30627795650737584836543728891050990439205529899958e-2 * t392 * t442 * t374
  t450 = 0.88547815820543093270365997638724911452184179456906e0 * t205 * t206 * t378 * t398 - 0.88547815820543093270365997638724911452184179456906e0 * t402 * t411 * t446
  t451 = t450 ** 2
  t457 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t205 * t206 * t408 * t398
  t458 = t457 ** 2
  t459 = 0.1e1 / t458
  t463 = t84 * t329
  t464 = t236 * t463
  t466 = t294 * t297
  t468 = t294 * t330
  t470 = t289 * t297
  t472 = 0.1e1 / t137
  t473 = t68 ** 2
  t476 = 0.1e1 / t156
  t479 = 0.2e1 * t59 * t476 - 0.2e1 * t66
  t483 = f.my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t472 * t473 + 0.4e1 / 0.3e1 * t64 * t479)
  t484 = 0.1e1 / t139
  t485 = t75 ** 2
  t488 = -t479
  t492 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t484 * t485 + 0.4e1 / 0.3e1 * t74 * t488)
  t494 = (t483 + t492) * t83
  t495 = t494 * t252
  t497 = t494 * t254
  t498 = t236 * t497
  t502 = t116 * t194 * t142 * t145
  t503 = t182 ** 2
  t505 = t5 * t503 * t188
  t506 = t150 * t505
  t509 = t423 * t149
  t510 = t509 * t189
  t517 = t158 * t142
  t521 = t177 ** 2
  t526 = 0.1e1 / t101
  t532 = f.my_piecewise3(t63, 0, -0.2e1 / 0.9e1 * t526 * t473 + 0.2e1 / 0.3e1 * t168 * t479)
  t533 = 0.1e1 / t103
  t539 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t533 * t485 + 0.2e1 / 0.3e1 * t172 * t488)
  t541 = t532 / 0.2e1 + t539 / 0.2e1
  t542 = t161 * t541
  t546 = -0.1100e4 / 0.81e2 * t155 * t273 * t159 * t161 + 0.400e3 / 0.27e2 * t155 * t517 * t178 - 0.25e2 / 0.9e1 * t155 * t166 * t521 * t161 - 0.25e2 / 0.9e1 * t155 * t167 * t542
  t548 = t5 * t546 * t188
  t549 = t150 * t548
  t554 = 0.1e1 / t15 / t14 * t20
  t555 = t21 * t5
  t556 = t555 * t166
  t557 = t554 * t556
  t559 = t34 * t109
  t560 = t33 * t559
  t562 = t6 * t109
  t563 = t4 * t562
  t565 = t14 ** (-0.5e0)
  t566 = t565 * t20
  t567 = t566 * t556
  t569 = t42 * t559
  t572 = t22 * t5 * t166
  t574 = -0.42198333333333333333333333333333333333333333333333e0 * t557 + 0.84396666666666666666666666666666666666666666666666e0 * t560 + 0.39862222222222222222222222222222222222222222222223e0 * t563 + 0.68258333333333333333333333333333333333333333333333e-1 * t567 + 0.13651666666666666666666666666666666666666666666667e0 * t569 + 0.13692777777777777777777777777777777777777777777778e0 * t572
  t575 = t574 * t54
  t576 = t285 * t575
  t578 = t234 * t65
  t579 = 0.1e1 / t578
  t580 = t233 * t579
  t581 = t580 * t255
  t583 = t232 * t235
  t584 = t583 * t255
  t586 = t288 * t293
  t587 = t586 * t255
  t590 = t4 * t562 * t229
  t592 = -0.10685000000000000000000000000000000000000000000000e0 * t57 - 0.10986933022051895964784337989883743167081987998276e-2 * t97 + 0.73246220147012639765228919932558287780546586655172e-3 * t112 + 0.3e1 * t147 * t190 + 0.3e1 * t197 * t190 - 0.76523626666666666666666666666666666666666666666668e-1 * t203 * t204 * t451 * t459 + 0.6e1 * t464 - 0.24e2 * t466 - 0.24e2 * t468 + 0.24e2 * t470 + 0.59255369107695618686477328484766255283138811676094e-1 * t495 + 0.3e1 * t498 + 0.3e1 / 0.2e1 * t502 * t506 - 0.7e1 * t502 * t510 + 0.3e1 / 0.2e1 * t502 * t549 + 0.30000000000000000000000000000000000000000000000000e1 * t576 + 0.60e2 * t581 + 0.36e2 * t584 - 0.96e2 * t587 - 0.44294311333333333333333333333333333333333333333332e-2 * t590
  t596 = t11 * t303
  t601 = 0.1e1 / t302 / t243
  t602 = t238 * t601
  t603 = t309 ** 2
  t604 = t603 * t310
  t613 = -0.78438333333333333333333333333333333333333333333333e0 * t557 + 0.15687666666666666666666666666666666666666666666667e1 * t560 + 0.68863333333333333333333333333333333333333333333333e0 * t563 + 0.14025833333333333333333333333333333333333333333333e0 * t567 + 0.28051666666666666666666666666666666666666666666667e0 * t569 + 0.17365833333333333333333333333333333333333333333333e0 * t572
  t614 = t613 * t310
  t617 = t302 ** 2
  t618 = 0.1e1 / t617
  t619 = t238 * t618
  t620 = t246 ** 2
  t621 = 0.1e1 / t620
  t622 = t603 * t621
  t625 = 0.14764770444444444444444444444444444444444444444444e-2 * t590
  t626 = 0.35616666666666666666666666666666666666666666666666e-1 * t57
  t628 = 0.1e1 / t29 / t28
  t629 = t228 * t628
  t630 = t50 ** 2
  t631 = t630 * t54
  t632 = t629 * t631
  t633 = 0.20000000000000000000000000000000000000000000000000e1 * t632
  t634 = 0.10000000000000000000000000000000000000000000000000e1 * t576
  t635 = t29 ** 2
  t636 = 0.1e1 / t635
  t637 = t228 * t636
  t638 = t53 ** 2
  t639 = 0.1e1 / t638
  t640 = t630 * t639
  t641 = t637 * t640
  t642 = 0.16081824322151104821330931780901225435013347914188e2 * t641
  t646 = t11 * t318
  t651 = 0.1e1 / t317 / t90
  t652 = t251 * t651
  t653 = t324 ** 2
  t654 = t653 * t325
  t663 = -0.57538888888888888888888888888888888888888888888889e0 * t557 + 0.11507777777777777777777777777777777777777777777778e1 * t560 + 0.40256666666666666666666666666666666666666666666667e0 * t563 + 0.36677500000000000000000000000000000000000000000000e-1 * t567 + 0.73355000000000000000000000000000000000000000000000e-1 * t569 + 0.13797500000000000000000000000000000000000000000000e0 * t572
  t664 = t663 * t325
  t667 = t317 ** 2
  t668 = 0.1e1 / t667
  t669 = t251 * t668
  t670 = t93 ** 2
  t671 = 0.1e1 / t670
  t672 = t653 * t671
  t675 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t562 * t247 - 0.34246666666666666666666666666666666666666666666666e-1 * t7 * t596 * t311 - 0.20000000000000000000000000000000000000000000000000e1 * t602 * t604 + 0.99999999999999999999999999999999999999999999999999e0 * t304 * t614 + 0.32164683177870697973624959794146027661627532968800e2 * t619 * t622 + t625 + t626 + t633 - t634 - t642 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t562 * t94 - 0.10843580882781524214666447553230042011687479519034e-1 * t7 * t646 * t326 - 0.11696446794910408141662685001236899248561775660981e1 * t652 * t654 + 0.58482233974552040708313425006184496242808878304903e0 * t319 * t664 + 0.17315755899375863299672358916972966258900005419821e2 * t669 * t672
  t676 = t106 * t675
  t677 = t236 * t676
  t680 = t318 * t663 * t325
  t681 = t336 * t680
  t684 = t651 * t653 * t325
  t685 = t336 * t684
  t688 = t668 * t653 * t671
  t689 = t336 * t688
  t691 = t84 * t251
  t692 = t691 * t338
  t696 = 0.3e1 * t236 * t84 * t675
  t707 = 0.1e1 / t9 / t234
  t708 = t707 * t80
  t718 = t159 * t450
  t719 = 0.1e1 / t457
  t735 = 0.24e2 * t294 * t463
  t738 = 0.12e2 * t289 * t497
  t739 = t59 * t235
  t741 = 0.24e2 * t739 * t255
  t744 = 0.144e3 * t232 * t293 * t255
  t746 = 0.1e1 / t9 / t292
  t751 = t268 ** 2
  t752 = 0.1e1 / t751
  t753 = t752 * t270
  t754 = t753 * t273
  t756 = t351 ** 2
  t757 = t756 * t351
  t758 = t6 * t757
  t759 = t266 ** 2
  t760 = t759 * t266
  t762 = t281 * t758 * t760
  t765 = t226 * t436
  t767 = t281 * t758 * t759
  t771 = t281 * t758 * t266
  t774 = t435 * t361
  t776 = t6 * t756
  t778 = t281 * t776 * t759
  t782 = 0.1e1 / t23 / t578
  t788 = t226 * t271 * t361
  t790 = t281 * t776 * t266
  t794 = 0.1e1 / t277 / t159
  t795 = t276 * t794
  t796 = t795 * t280
  t799 = t796 * t6 * t177 * t541
  t810 = -0.17315755899375863299672358916972966258900005419821e2 * t689 - 0.11696446794910408141662685001236899248561775660981e1 * t692 - 0.58482233974552040708313425006184496242808878304903e0 * t681 + 0.20e2 * t581 + 0.12e2 * t584 - 0.32e2 * t587 - t625 + t677 + t498 + 0.2e1 * t464 - 0.8e1 * t466
  t813 = t289 * t330
  t816 = t106 * t4
  t817 = t38 * t338
  t818 = t816 * t817
  t823 = -0.8e1 * t468 + 0.8e1 * t470 + 0.8e1 * t813 - t633 + 0.19751789702565206228825776161588751761046270558698e-1 * t495 + t634 + t642 + 0.10843580882781524214666447553230042011687479519034e-1 * t818 - 0.36623110073506319882614459966279143890273293327586e-3 * t97 + 0.11696446794910408141662685001236899248561775660981e1 * t685 - t626 + 0.24415406715670879921742973310852762593515528885057e-3 * t112
  t824 = t810 + t823
  t829 = t341 * t278 * t114
  t833 = t259 * t371 * t114
  t834 = t347 * t521
  t837 = t347 * t541
  t840 = -0.13067859477648036196925324326848422587394359423983e2 * t824 * t218 * t263 + 0.78407156865888217181551945961090535524366156543898e2 * t829 * t348 - 0.15681431373177643436310389192218107104873231308780e3 * t833 * t834 + 0.39203578432944108590775972980545267762183078271949e2 * t346 * t837
  t841 = t6 * t840
  t843 = t281 * t841 * t266
  t847 = 0.36e2 * t583 * t330
  t850 = t473 * t68
  t857 = 0.6e1 * t476 - 0.6e1 * t739
  t861 = f.my_piecewise3(t63, 0, -0.8e1 / 0.27e2 / t137 / t62 * t850 + 0.4e1 / 0.3e1 * t472 * t68 * t479 + 0.4e1 / 0.3e1 * t64 * t857)
  t864 = t485 * t75
  t870 = -t857
  t874 = f.my_piecewise3(t73, 0, -0.8e1 / 0.27e2 / t139 / t72 * t864 + 0.4e1 / 0.3e1 * t484 * t75 * t488 + 0.4e1 / 0.3e1 * t74 * t870)
  t876 = (t861 + t874) * t83
  t878 = t236 * t876 * t254
  t880 = 0.12e2 * t294 * t497
  t882 = 0.60e2 * t580 * t330
  t885 = 0.240e3 * t288 * t579 * t255
  t886 = t234 * t156
  t890 = 0.120e3 * t233 / t886 * t255
  t892 = 0.36e2 * t583 * t297
  t893 = t696 - t735 + t738 + t741 - t744 + t847 + t878 - t880 + t882 + t885 - t890 + t892
  t907 = 0.60000000000000000000000000000000000000000000000000e1 * t629 * t55 * t574
  t911 = 0.71233333333333333333333333333333333333333333333333e-1 * t7 * t109 * t30 * t55
  t914 = 0.53424999999999999999999999999999999999999999999999e-1 * t7 * t31 * t575
  t918 = 0.85917146441092277507960503039464796886558811231548e0 * t7 * t11 * t636 * t640
  t930 = 0.10685000000000000000000000000000000000000000000000e0 * t7 * t11 * t628 * t631
  t953 = 0.51947267698127589899017076750918898776700016259463e2 * t669 * t663 * t671 * t324 + 0.96494049533612093920874879382438082984882598906400e2 * t619 * t613 * t621 * t309 - 0.35089340384731224424988055003710697745685326982943e1 * t652 * t326 * t663 + t907 - t911 + t914 + t918 + 0.10274000000000000000000000000000000000000000000000e0 * t7 * t11 * t601 * t604 + 0.32530742648344572643999342659690126035062438557102e-1 * t7 * t11 * t651 * t654 - t930 + 0.21687161765563048429332895106460084023374959038068e-1 * t7 * t109 * t318 * t326 - 0.16265371324172286321999671329845063017531219278551e-1 * t7 * t646 * t664 - 0.48159446095139119802213748237831062407565640073877e0 * t7 * t11 * t668 * t672 + 0.68493333333333333333333333333333333333333333333331e-1 * t7 * t109 * t303 * t311 - 0.51369999999999999999999999999999999999999999999999e-1 * t7 * t596 * t614 - 0.16522997748472177549051141846252814409778063686072e1 * t7 * t11 * t618 * t622
  t957 = t630 * t50
  t962 = 0.51725014705706168413145063783413931475389495076352e3 * t228 / t635 / t29 * t957 / t638 / t53
  t963 = t653 * t324
  t970 = t6 * t208
  t976 = 0.34451131037037037037037037037037037037037037037036e-2 * t4 * t970 * t229
  t983 = 0.48245472966453314463992795342703676305040043742564e2 * t637 * t574 * t639 * t50
  t985 = 0.1e1 / t667 / t317
  t988 = 0.1e1 / t670 / t93
  t996 = 0.1e1 / t15 / t26 * t2 * t235 / 0.4e1
  t998 = t555 * t158
  t999 = t554 * t998
  t1001 = t34 * t208
  t1002 = t33 * t1001
  t1004 = t4 * t970
  t1006 = t14 ** (-0.15e1)
  t1008 = t1006 * t2 * t235
  t1010 = t566 * t998
  t1012 = t42 * t1001
  t1015 = t22 * t5 * t158
  t1032 = 0.10000000000000000000000000000000000000000000000000e1 * t285 * (-0.25319000000000000000000000000000000000000000000000e1 * t996 + 0.16879333333333333333333333333333333333333333333333e1 * t999 - 0.19692555555555555555555555555555555555555555555555e1 * t1002 - 0.93011851851851851851851851851851851851851851851854e0 * t1004 + 0.13651666666666666666666666666666666666666666666667e0 * t1008 - 0.27303333333333333333333333333333333333333333333333e0 * t1010 - 0.31853888888888888888888888888888888888888888888890e0 * t1012 - 0.36514074074074074074074074074074074074074074074075e0 * t1015) * t54
  t1041 = -0.34523333333333333333333333333333333333333333333333e1 * t996 + 0.23015555555555555555555555555555555555555555555556e1 * t999 - 0.26851481481481481481481481481481481481481481481482e1 * t1002 - 0.93932222222222222222222222222222222222222222222223e0 * t1004 + 0.73355000000000000000000000000000000000000000000000e-1 * t1008 - 0.14671000000000000000000000000000000000000000000000e0 * t1010 - 0.17116166666666666666666666666666666666666666666667e0 * t1012 - 0.36793333333333333333333333333333333333333333333333e0 * t1015
  t1045 = t603 * t309
  t1065 = 0.60000000000000000000000000000000000000000000000000e1 * t637 * t957 * t54
  t1071 = 0.96490945932906628927985590685407352610080087485128e2 * t228 / t635 / t28 * t957 * t639
  t1073 = 0.1e1 / t667 / t90
  t1078 = -t962 + 0.35089340384731224424988055003710697745685326982943e1 * t669 * t963 * t325 - 0.60000000000000000000000000000000000000000000000000e1 * t602 * t311 * t613 + 0.56969282336565386484066937725323112718202900731800e-3 * t4 * t970 * t94 - t976 + 0.16562449037037037037037037037037037037037037037036e-2 * t4 * t970 * t247 - t983 + 0.10253897021007794930818001372045340355835853271641e4 * t251 * t985 * t963 * t988 + 0.99999999999999999999999999999999999999999999999999e0 * t304 * (-0.47063000000000000000000000000000000000000000000000e1 * t996 + 0.31375333333333333333333333333333333333333333333334e1 * t999 - 0.36604555555555555555555555555555555555555555555556e1 * t1002 - 0.16068111111111111111111111111111111111111111111111e1 * t1004 + 0.28051666666666666666666666666666666666666666666666e0 * t1008 - 0.56103333333333333333333333333333333333333333333332e0 * t1010 - 0.65453888888888888888888888888888888888888888888890e0 * t1012 - 0.46308888888888888888888888888888888888888888888888e0 * t1015) * t310 - t1032 + 0.58482233974552040708313425006184496242808878304903e0 * t319 * t1041 * t325 + 0.60000000000000000000000000000000000000000000000000e1 * t619 * t1045 * t310 + 0.20691336878655965245175271659148296983999699561788e4 * t238 / t617 / t302 * t1045 / t620 / t246 - 0.19298809906722418784174975876487616596976519781280e3 * t238 / t617 / t243 * t1045 * t621 - t1065 + t1071 - 0.10389453539625517979803415350183779755340003251893e3 * t251 * t1073 * t963 * t671
  t1081 = t236 * t106 * (t953 + t1078)
  t1083 = 0.12e2 * t294 * t676
  t1087 = 0.56969282336565386484066937725323112718202900731800e-3 * t107 * t34 * t208 * t94
  t1089 = 0.24e2 * t289 * t463
  t1091 = 0.96e2 * t586 * t297
  t1093 = 0.60e2 * t580 * t297
  t1096 = 0.3e1 * t236 * t494 * t329
  t1100 = 0.10253897021007794930818001372045340355835853271641e4 * t336 * t985 * t963 * t988
  t1104 = 0.58482233974552040708313425006184496242808878304903e0 * t336 * t318 * t1041 * t325
  t1106 = 0.12e2 * t289 * t676
  t1107 = t1081 - t1083 - t1087 + t1089 - t907 - t1091 + t1093 + t1096 - t1100 - t1104 + t911 + t1106 - t914
  t1111 = 0.54934665110259479823921689949418715835409939991379e-3 * t494 * t1 * t96
  t1113 = 0.73246220147012639765228919932558287780546586655172e-3 * t85 * t111
  t1118 = 0.51947267698127589899017076750918898776700016259463e2 * t336 * t668 * t663 * t671 * t324
  t1122 = 0.35089340384731224424988055003710697745685326982943e1 * t336 * t651 * t324 * t664
  t1124 = 0.17544670192365612212494027501855348872842663491471e1 * t691 * t680
  t1126 = 0.51947267698127589899017076750918898776700016259464e2 * t691 * t688
  t1130 = 0.10389453539625517979803415350183779755340003251893e3 * t336 * t1073 * t963 * t671
  t1133 = 0.17544670192365612212494027501855348872842663491471e1 * t494 * t251 * t338
  t1137 = 0.35089340384731224424988055003710697745685326982943e1 * t336 * t668 * t963 * t325
  t1139 = 0.35089340384731224424988055003710697745685326982943e1 * t691 * t684
  t1140 = -t918 + t930 - t1111 + t1113 - t1118 + t1122 - t1124 - t1126 + t1130 - t1133 - t1137 + t1139
  t1143 = 0.32530742648344572643999342659690126035062438557102e-1 * t816 * t38 * t684
  t1146 = 0.32530742648344572643999342659690126035062438557102e-1 * t84 * t4 * t817
  t1149 = 0.16265371324172286321999671329845063017531219278551e-1 * t816 * t38 * t680
  t1152 = 0.48159446095139119802213748237831062407565640073877e0 * t816 * t38 * t688
  t1155 = 0.21687161765563048429332895106460084023374959038068e-1 * t816 * t562 * t338
  t1157 = 0.19751789702565206228825776161588751761046270558698e-1 * t876 * t252
  t1159 = 0.96e2 * t586 * t330
  t1160 = -t1143 + t1146 + t1149 + t1152 - t1155 + t962 + t1157 + t976 + t983 + t1032 + t1065 - t1071 - t1159
  t1178 = t521 * t177
  t1182 = t177 * t541
  t1186 = t62 ** 2
  t1197 = f.my_piecewise3(t63, 0, 0.8e1 / 0.27e2 / t64 / t1186 * t850 - 0.2e1 / 0.3e1 * t526 * t68 * t479 + 0.2e1 / 0.3e1 * t168 * t857)
  t1198 = t72 ** 2
  t1209 = f.my_piecewise3(t73, 0, 0.8e1 / 0.27e2 / t74 / t1198 * t864 - 0.2e1 / 0.3e1 * t533 * t75 * t488 + 0.2e1 / 0.3e1 * t172 * t870)
  t1211 = t1197 / 0.2e1 + t1209 / 0.2e1
  t1215 = -0.13067859477648036196925324326848422587394359423983e2 * (t893 + t1107 + t1140 + t1160) * t218 * t263 + 0.11761073529883232577232791894163580328654923481585e3 * t824 * t278 * t114 * t348 - 0.47044294119532930308931167576654321314619693926339e3 * t341 * t371 * t114 * t834 + 0.11761073529883232577232791894163580328654923481585e3 * t829 * t837 + 0.78407156865888217181551945961090535524366156543900e3 * t259 * t794 * t114 * t347 * t1178 - 0.47044294119532930308931167576654321314619693926340e3 * t833 * t347 * t1182 + 0.39203578432944108590775972980545267762183078271949e2 * t346 * t347 * t1211
  t1218 = t281 * t6 * t1215 * t266
  t1222 = t226 * t358 * t361
  t1223 = t373 * t521
  t1224 = t795 * t1223
  t1228 = 0.1e1 / t277 / t204
  t1230 = t373 * t1178
  t1238 = t373 * t541
  t1239 = t372 * t1238
  t1242 = t373 * t1211
  t1246 = -0.455e3 / 0.1296e4 * t145 * t746 * t80 * t214 - 0.51883485832349468713105076741440377804014167650534e-2 * t226 * t754 * t762 + 0.51883485832349468713105076741440377804014167650534e-2 * t765 * t767 - 0.86472476387249114521841794569067296340023612750888e-3 * t275 * t771 - 0.24212293388429752066115702479338842975206611570249e-1 * t226 * t774 * t778 - 0.68601497933884297520661157024793388429752066115704e-1 * t226 * t271 * t782 * t354 + 0.12106146694214876033057851239669421487603305785124e-1 * t788 * t790 + 0.51883485832349468713105076741440377804014167650534e-1 * t369 * t799 + 0.12106146694214876033057851239669421487603305785124e-1 * t788 * t843 - 0.86472476387249114521841794569067296340023612750888e-3 * t275 * t1218 - 0.24212293388429752066115702479338842975206611570249e0 * t1222 * t1224 - 0.10376697166469893742621015348288075560802833530107e0 * t369 * t276 * t1228 * t1230 - 0.27440599173553719008264462809917355371900826446282e0 * t226 * t358 * t782 * t375 + 0.48424586776859504132231404958677685950413223140498e-1 * t1222 * t1239 - 0.34588990554899645808736717827626918536009445100355e-2 * t369 * t372 * t1242
  t1247 = t226 * t269
  t1249 = t270 * t273 * t276
  t1250 = t1247 * t1249
  t1252 = t371 * t280 * t6
  t1260 = t351 * t266
  t1280 = t226 * t434 * t1249
  t1295 = t1252 * t1260 * t177
  t1301 = 0.1e1 / t23 / t886 * t276 * t364
  t1304 = t80 * t278
  t1305 = t217 * t1304
  t1306 = t222 * t541
  t1312 = t221 * t5 * t521
  t1321 = t145 * t707
  t1325 = t209 * t219
  t1327 = t221 * t5 * t541
  t1334 = 0.10376697166469893742621015348288075560802833530106e-1 * t1250 * t1252 * t840 * t266 * t177 - 0.51883485832349468713105076741440377804014167650533e-1 * t1250 * t794 * t280 * t6 * t1260 * t521 + 0.10376697166469893742621015348288075560802833530106e-1 * t1250 * t1252 * t756 * t266 * t177 + 0.10376697166469893742621015348288075560802833530106e-1 * t1250 * t1252 * t1260 * t541 - 0.25941742916174734356552538370720188902007083825267e-2 * t1250 * t364 * t840 * t351 * t266 - 0.20753394332939787485242030696576151121605667060213e-1 * t1280 * t1252 * t756 * t759 * t177 + 0.51883485832349468713105076741440377804014167650534e-2 * t1280 * t364 * t351 * t759 * t840 - 0.96849173553719008264462809917355371900826446280994e-1 * t1247 * t270 * t361 * t276 * t1295 - 0.15244777318640955004591368227731864095500459136823e0 * t359 * t1301 + 0.3e1 / 0.16e2 * t1305 * t221 * t1306 - 0.7e1 / 0.16e2 * t209 * t1304 * t1312 - t217 * t80 * t371 * t221 * t5 * t1178 / 0.4e1 - 0.35e2 / 0.72e2 * t1321 * t219 * t223 + 0.7e1 / 0.48e2 * t1325 * t1327 - t220 * t221 * t5 * t1211 / 0.48e2
  t1359 = t782 * t276
  t1360 = t1359 * t364
  t1369 = 0.35e2 / 0.432e3 * t1321 * t80 * t214 + 0.7e1 / 0.72e2 * t1325 * t223 + t1305 * t1312 / 0.16e2 - t220 * t1327 / 0.48e2 + 0.17294495277449822904368358913813459268004722550178e-2 * t765 * t778 + 0.80707644628099173553719008264462809917355371900828e-2 * t788 * t354 + 0.69177981109799291617473435655253837072018890200710e-2 * t1250 * t1295 - 0.86472476387249114521841794569067296340023612750888e-3 * t275 * t843 - 0.86472476387249114521841794569067296340023612750888e-3 * t275 * t790 + 0.22867165977961432506887052341597796143250688705235e-1 * t359 * t1360 + 0.32283057851239669421487603305785123966942148760332e-1 * t1222 * t375 + 0.17294495277449822904368358913813459268004722550178e-1 * t369 * t1224 - 0.34588990554899645808736717827626918536009445100355e-2 * t369 * t1239
  t1375 = 0.1e1 / t409 / t397
  t1377 = t446 ** 2
  t1381 = t378 * t410
  t1382 = t434 * t145
  t1384 = t412 * t1382 * t109
  t1385 = t5 * t756
  t1387 = t417 * t1385 * t759
  t1391 = t412 * t413 * t208
  t1394 = t219 * t149
  t1395 = t266 * t177
  t1397 = t1394 * t418 * t1395
  t1400 = t5 * t840
  t1402 = t417 * t1400 * t266
  t1406 = t417 * t1385 * t266
  t1412 = t423 * t218
  t1417 = t213 * t521
  t1421 = t213 * t541
  t1425 = t432 * t754
  t1428 = t432 * t774
  t1431 = t372 * t280
  t1433 = t1431 * t352 * t1395
  t1442 = t362 * t371
  t1453 = 0.55342384887839433293978748524203069657615112160566e-1 * t1384 * t1387 + 0.12913223140495867768595041322314049586776859504132e0 * t1391 * t420 + 0.11068476977567886658795749704840613931523022432113e0 * t415 * t1397 - 0.27671192443919716646989374262101534828807556080283e-1 * t415 * t1402 - 0.27671192443919716646989374262101534828807556080283e-1 * t415 * t1406 + 0.21522038567493112947658402203856749311294765840220e0 * t383 * t708 * t385 + 0.25826446280991735537190082644628099173553719008264e0 * t383 * t1412 * t428 + 0.16602715466351829988193624557260920897284533648170e0 * t383 * t148 * t278 * t1417 - 0.55342384887839433293978748524203069657615112160566e-1 * t383 * t427 * t1421 + 0.45941693476106377254815593336576485658808294849937e-2 * t1425 * t778 + 0.14292971303677539590387073482490462204962580619980e-1 * t1428 * t354 + 0.12251118260295033934617491556420396175682211959983e-1 * t437 * t1433 - 0.15313897825368792418271864445525495219602764949979e-2 * t437 * t843 - 0.15313897825368792418271864445525495219602764949979e-2 * t437 * t790 + 0.20248376013543181086381687433528154790363655878306e-1 * t392 * t1360 + 0.28585942607355079180774146964980924409925161239960e-1 * t392 * t1442 * t374 + 0.15313897825368792418271864445525495219602764949979e-1 * t392 * t393 * t794 * t1223 - 0.30627795650737584836543728891050990439205529899958e-2 * t392 * t442 * t1238
  t1457 = t409 ** 2
  t1464 = t408 * t1375
  t1514 = -0.18376677390442550901926237334630594263523317939975e-1 * t432 / t751 / t267 * t270 * t273 * t762 - 0.24298051216251817303658024920233785748436387053966e0 * t392 * t1359 * t371 * t374 + 0.42878913911032618771161220447471386614887741859940e-1 * t392 * t1442 * t1238 - 0.30627795650737584836543728891050990439205529899958e-2 * t392 * t442 * t1242 - 0.12913223140495867768595041322314049586776859504132e1 * t383 * t708 * t218 * t428 + 0.38739669421487603305785123966942148760330578512396e0 * t383 * t1412 * t1421 - 0.55342384887839433293978748524203069657615112160566e-1 * t383 * t427 * t213 * t1211 - 0.11621900826446280991735537190082644628099173553719e1 * t383 * t423 * t278 * t1417 - 0.66410861865407319952774498229043683589138134592680e0 * t383 * t148 * t371 * t213 * t1178 - 0.21439456955516309385580610223735693307443870929970e0 * t392 * t362 * t794 * t1223 - 0.91883386952212754509631186673152971317616589699874e-1 * t392 * t393 * t1228 * t1230
  t1517 = t746 * t80
  t1524 = t1304 * t149
  t1545 = t5 * t757
  t1554 = t266 * t541
  t1563 = -0.13498917342362120724254458289018769860242437252204e0 * t392 * t1301 - 0.93262167125803489439853076216712580348943985307620e0 * t383 * t1517 * t385 + 0.49808146399055489964580873671782762691853600944510e0 * t412 * t357 * t145 * t109 * t1524 * t1306 - 0.27671192443919716646989374262101534828807556080283e-1 * t415 * t417 * t5 * t1215 * t266 + 0.19369834710743801652892561983471074380165289256198e0 * t1391 * t1402 + 0.45941693476106377254815593336576485658808294849937e-1 * t432 * t274 * t799 + 0.21439456955516309385580610223735693307443870929970e-1 * t1428 * t843 - 0.15313897825368792418271864445525495219602764949979e-2 * t437 * t1218 - 0.16602715466351829988193624557260920897284533648170e0 * t412 * t752 * t145 * t109 * t417 * t1545 * t760 + 0.16602715466351829988193624557260920897284533648170e0 * t1384 * t417 * t1545 * t759 + 0.16602715466351829988193624557260920897284533648170e0 * t415 * t1394 * t418 * t1554 - 0.83013577331759149940968122786304604486422668240849e-1 * t415 * t417 * t1400 * t1260
  t1565 = t759 * t177
  t1598 = t759 * t840
  t1603 = -0.33205430932703659976387249114521841794569067296339e0 * t1384 * t1394 * t1385 * t1565 + 0.13782508042831913176444678000972945697642488454981e-1 * t1425 * t767 - 0.15313897825368792418271864445525495219602764949979e-2 * t437 * t771 - 0.12149025608125908651829012460116892874218193526983e0 * t432 * t435 * t782 * t354 + 0.21439456955516309385580610223735693307443870929970e-1 * t1428 * t790 - 0.64318370866548928156741830671207079922331612789911e-1 * t432 * t753 * t361 * t778 - 0.27671192443919716646989374262101534828807556080283e-1 * t415 * t417 * t1545 * t266 + 0.19369834710743801652892561983471074380165289256198e0 * t1391 * t1406 - 0.38739669421487603305785123966942148760330578512396e0 * t412 * t1382 * t208 * t1387 - 0.64566115702479338842975206611570247933884297520660e0 * t412 * t413 * t707 * t420 + 0.16602715466351829988193624557260920897284533648170e0 * t1384 * t417 * t418 * t1598
  t1606 = t266 * t521
  t1649 = -0.77479338842975206611570247933884297520661157024792e0 * t1391 * t1397 - 0.49808146399055489964580873671782762691853600944509e0 * t415 * t1524 * t418 * t1606 + 0.16602715466351829988193624557260920897284533648170e0 * t415 * t1394 * t1385 * t1395 - 0.91883386952212754509631186673152971317616589699873e-1 * t437 * t796 * t352 * t1606 + 0.18376677390442550901926237334630594263523317939975e-1 * t437 * t1431 * t776 * t1395 - 0.45941693476106377254815593336576485658808294849937e-2 * t437 * t281 * t841 * t1260 - 0.17151565564413047508464488178988554645955096743976e0 * t1428 * t1433 + 0.18376677390442550901926237334630594263523317939975e-1 * t437 * t1431 * t841 * t1395 + 0.18376677390442550901926237334630594263523317939975e-1 * t437 * t1431 * t352 * t1554 - 0.55130032171327652705778712003891782790569953819924e-1 * t1425 * t1431 * t776 * t1565 + 0.13782508042831913176444678000972945697642488454981e-1 * t1425 * t281 * t352 * t1598 + 0.16602715466351829988193624557260920897284533648170e0 * t415 * t1394 * t1400 * t1395
  t1699 = 0.25851111111111111111111111111111111111111111111111e1 * t563 + 0.20525000000000000000000000000000000000000000000000e-2 * t572
  t1701 = t119 * t129
  t1705 = 0.1e1 / t128 / t122
  t1706 = t127 * t1705
  t1707 = t133 ** 2
  t1712 = 0.96922222222222222222222222222222222222222222222222e3 * t563 + 0.13111111111111111111111111111111111111111111111111e3 * t572
  t1714 = t1699 * t123 - t130 * t1712 - 0.2e1 * t1701 * t133 + 0.2e1 * t1706 * t1707
  t1717 = t116 * t1714 * t142 * t145
  t1720 = t738 + t741 - t744 + 0.25507875555555555555555555555555555555555555555556e-1 * t203 * t204 * (0.88547815820543093270365997638724911452184179456906e0 * t205 * t206 * (t1246 + t1334) * t398 - 0.26564344746162927981109799291617473435655253837072e1 * t402 * t1369 * t410 * t446 + 0.53128689492325855962219598583234946871310507674143e1 * t402 * t378 * t1375 * t1377 - 0.26564344746162927981109799291617473435655253837072e1 * t402 * t1381 * t1453 - 0.53128689492325855962219598583234946871310507674143e1 * t402 * t408 / t1457 * t1377 * t446 + 0.53128689492325855962219598583234946871310507674143e1 * t402 * t1464 * t446 * t1453 - 0.88547815820543093270365997638724911452184179456906e0 * t402 * t411 * (t1514 + t1563 + t1603 + t1649)) * t719 + t847 + 0.3e1 / 0.2e1 * t147 * t549 + 0.3e1 / 0.2e1 * t197 * t549 + t502 * t150 * t5 * (0.15400e5 / 0.243e3 * t155 * t361 * t159 * t161 - 0.2200e4 / 0.27e2 * t155 * t273 * t142 * t178 + 0.200e3 / 0.9e1 * t155 * t158 * t521 * t161 + 0.200e3 / 0.9e1 * t155 * t517 * t542 - 0.25e2 / 0.3e1 * t155 * t166 * t177 * t542 - 0.25e2 / 0.9e1 * t155 * t167 * t161 * t1211) * t188 / 0.2e1 + 0.3e1 / 0.2e1 * t147 * t506 + 0.3e1 / 0.2e1 * t197 * t506 + 0.3e1 / 0.2e1 * t1717 * t190
  t1724 = t116 * t135 * t177 * t145
  t1729 = t116 * t194 * t541 * t145
  t1739 = jnp.log(t457)
  t1740 = t159 * t1739
  t1758 = 0.88547815820543093270365997638724911452184179456906e0 * t205 * t206 * t1369 * t398 - 0.17709563164108618654073199527744982290436835891381e1 * t402 * t1381 * t446 + 0.17709563164108618654073199527744982290436835891381e1 * t402 * t1464 * t1377 - 0.88547815820543093270365997638724911452184179456906e0 * t402 * t411 * t1453
  t1760 = t719 * t177
  t1773 = t142 * t1739
  t1788 = t1081 - t1083 + 0.22957088000000000000000000000000000000000000000001e0 * t203 * t159 * t1758 * t1760 - t1087 + t1089 + 0.15304725333333333333333333333333333333333333333334e0 * t201 * t202 * t1178 * t1739 - t907 - 0.76523626666666666666666666666666666666666666666668e-1 * t203 * t204 * t450 * t459 * t1758 + 0.45914176000000000000000000000000000000000000000002e0 * t203 * t1773 * t1182 + 0.3e1 / 0.2e1 * t116 * t194 * t142 * t145 * t109 * t80 * t149 * t5 * t182 * t188 * t546 - t1091
  t1792 = t1113 - t1118 + t1122 - t1124 - t1126 + t1130 - t1133 - t1137 + t1139 - t1143 + t1146
  t1808 = t128 ** 2
  t1825 = t213 * t188
  t1826 = t148 * t1825
  t1844 = t708 * t1825
  t1847 = t423 * t1825
  t1850 = t1149 + t1152 - t1155 + t962 - 0.7e1 * t147 * t510 + t116 * ((-0.60319259259259259259259259259259259259259259259259e1 * t1004 - 0.54733333333333333333333333333333333333333333333333e-2 * t1015) * t123 - 0.3e1 * t1699 * t129 * t133 + 0.6e1 * t119 * t1705 * t1707 - 0.3e1 * t1701 * t1712 - 0.6e1 * t127 / t1808 * t1707 * t133 + 0.6e1 * t1706 * t133 * t1712 - t130 * (-0.22615185185185185185185185185185185185185185185185e4 * t1004 - 0.34962962962962962962962962962962962962962962962963e3 * t1015)) * t142 * t145 * t1826 / 0.2e1 + 0.3e1 / 0.2e1 * t116 * t1714 * t177 * t145 * t1826 + 0.3e1 / 0.2e1 * t116 * t135 * t541 * t145 * t1826 + t116 * t194 * t1211 * t145 * t1826 / 0.2e1 + 0.35e2 / 0.3e1 * t147 * t1844 - 0.7e1 * t1724 * t1847
  t1860 = -0.7e1 / 0.2e1 * t1729 * t1847 - 0.455e3 / 0.27e2 * t502 * t1517 * t1825 + 0.35e2 / 0.3e1 * t197 * t1844 - 0.7e1 / 0.2e1 * t1717 * t1847 + t1157 + t976 + t983 + t1032 + t1065 - t1071 - t1159
  t1894 = 0.3e1 * t677 - 0.17544670192365612212494027501855348872842663491471e1 * t681 + 0.35089340384731224424988055003710697745685326982943e1 * t685 - 0.51947267698127589899017076750918898776700016259464e2 * t689 - 0.35089340384731224424988055003710697745685326982943e1 * t692 + t8 * (0.45914176000000000000000000000000000000000000000002e0 * t203 * t142 * t450 * t719 * t521 - 0.22957088000000000000000000000000000000000000000001e0 * t203 * t159 * t451 * t459 * t177 + 0.35e2 / 0.3e1 * t502 * t708 * t149 * t189 + 0.22957088000000000000000000000000000000000000000001e0 * t203 * t718 * t719 * t541 + t930 + t892 + t1860 - t890 + 0.51015751111111111111111111111111111111111111111112e-1 * t203 * t204 * t451 * t450 / t458 / t457 + t502 * t150 * t5 * t503 * t182 * t188 / 0.2e1 + t696 - t1111 - t1100 - t1104 + t1106 + t911 - t914 - t918 + 0.3e1 * t1724 * t190 + 0.3e1 / 0.2e1 * t1729 * t190 - 0.7e1 * t197 * t510 + t1096 + t1093 + t1850 - t735 + t1792 + t1720 + t878 - t880 + t882 + t885 - 0.7e1 / 0.2e1 * t502 * t509 * t505 - 0.7e1 / 0.2e1 * t502 * t509 * t548 + 0.76523626666666666666666666666666666666666666666668e-1 * t203 * t1740 * t1211 + t1788) + 0.48245472966453314463992795342703676305040043742564e2 * t641 - 0.60000000000000000000000000000000000000000000000000e1 * t632 + 0.76523626666666666666666666666666666666666666666668e-1 * t203 * t204 * t1758 * t719 + 0.45914176000000000000000000000000000000000000000002e0 * t203 * t1773 * t521 + 0.24e2 * t813 + 0.22957088000000000000000000000000000000000000000001e0 * t203 * t1740 * t541 + 0.32530742648344572643999342659690126035062438557102e-1 * t818 + 0.45914176000000000000000000000000000000000000000002e0 * t203 * t718 * t1760 + 0.3e1 * t1724 * t1826 + 0.35e2 / 0.3e1 * t502 * t1844 - 0.7e1 * t147 * t1847 - 0.7e1 * t197 * t1847 + 0.3e1 / 0.2e1 * t1717 * t1826 + 0.3e1 / 0.2e1 * t1729 * t1826
  d111 = t592 + t1894

  res = {'v3rho3': d111}
  return res
