"""Generated from gga_k_pw86.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_aa = 2.208

  params_bb = 9.27

  params_cc = 0.2

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  pw86_f = lambda x: pw86_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_kinetic(f, params, pw86_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_aa = 2.208

  params_bb = 9.27

  params_cc = 0.2

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  pw86_f = lambda x: pw86_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_kinetic(f, params, pw86_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_aa = 2.208

  params_bb = 9.27

  params_cc = 0.2

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  pw86_f = lambda x: pw86_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_kinetic(f, params, pw86_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * f.p.zeta_threshold
  t25 = t20 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = f.my_piecewise3(t21, t24, t26 * t20)
  t29 = t7 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t46 = t32 ** 2
  t49 = t46 / t34 / t33
  t50 = s0 ** 2
  t51 = t38 ** 2
  t54 = 0.1e1 / t39 / t51 / r0
  t58 = t33 ** 2
  t59 = 0.1e1 / t58
  t61 = t59 * t50 * s0
  t62 = t51 ** 2
  t63 = 0.1e1 / t62
  t67 = (0.1e1 + 0.92000000000000000000000000000000000000000000000000e-1 * t37 * s0 * t42 + 0.16093750000000000000000000000000000000000000000000e-1 * t49 * t50 * t54 + 0.86805555555555555555555555555555555555555555555556e-4 * t61 * t63) ** (0.1e1 / 0.15e2)
  t71 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t28 * t30 * t67)
  t72 = r1 <= f.p.dens_threshold
  t73 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t74 = 0.1e1 + t73
  t75 = t74 <= f.p.zeta_threshold
  t76 = t74 ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t79 = f.my_piecewise3(t75, t24, t77 * t74)
  t81 = r1 ** 2
  t82 = r1 ** (0.1e1 / 0.3e1)
  t83 = t82 ** 2
  t85 = 0.1e1 / t83 / t81
  t89 = s2 ** 2
  t90 = t81 ** 2
  t93 = 0.1e1 / t82 / t90 / r1
  t98 = t59 * t89 * s2
  t99 = t90 ** 2
  t100 = 0.1e1 / t99
  t104 = (0.1e1 + 0.92000000000000000000000000000000000000000000000000e-1 * t37 * s2 * t85 + 0.16093750000000000000000000000000000000000000000000e-1 * t49 * t89 * t93 + 0.86805555555555555555555555555555555555555555555556e-4 * t98 * t100) ** (0.1e1 / 0.15e2)
  t108 = f.my_piecewise3(t72, 0, 0.3e1 / 0.20e2 * t6 * t79 * t30 * t104)
  t109 = t7 ** 2
  t111 = t17 / t109
  t112 = t8 - t111
  t113 = f.my_piecewise5(t11, 0, t15, 0, t112)
  t116 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t113)
  t121 = 0.1e1 / t29
  t125 = t6 * t28 * t121 * t67 / 0.10e2
  t126 = t6 * t28
  t127 = t67 ** 2
  t128 = t127 ** 2
  t130 = t128 ** 2
  t133 = t30 / t130 / t128 / t127
  t155 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t116 * t30 * t67 + t125 + t126 * t133 * (-0.24533333333333333333333333333333333333333333333333e0 * t37 * s0 / t40 / t38 / r0 - 0.85833333333333333333333333333333333333333333333333e-1 * t49 * t50 / t39 / t51 / t38 - 0.69444444444444444444444444444444444444444444444445e-3 * t61 / t62 / r0) / 0.100e3)
  t157 = f.my_piecewise5(t15, 0, t11, 0, -t112)
  t160 = f.my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t157)
  t168 = t6 * t79 * t121 * t104 / 0.10e2
  t170 = f.my_piecewise3(t72, 0, 0.3e1 / 0.20e2 * t6 * t160 * t30 * t104 + t168)
  vrho_0_ = t71 + t108 + t7 * (t155 + t170)
  t173 = -t8 - t111
  t174 = f.my_piecewise5(t11, 0, t15, 0, t173)
  t177 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t174)
  t183 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t177 * t30 * t67 + t125)
  t185 = f.my_piecewise5(t15, 0, t11, 0, -t173)
  t188 = f.my_piecewise3(t75, 0, 0.5e1 / 0.3e1 * t77 * t185)
  t193 = t6 * t79
  t194 = t104 ** 2
  t195 = t194 ** 2
  t197 = t195 ** 2
  t200 = t30 / t197 / t195 / t194
  t222 = f.my_piecewise3(t72, 0, 0.3e1 / 0.20e2 * t6 * t188 * t30 * t104 + t168 + t193 * t200 * (-0.24533333333333333333333333333333333333333333333333e0 * t37 * s2 / t83 / t81 / r1 - 0.85833333333333333333333333333333333333333333333333e-1 * t49 * t89 / t82 / t90 / t81 - 0.69444444444444444444444444444444444444444444444445e-3 * t98 / t99 / r1) / 0.100e3)
  vrho_1_ = t71 + t108 + t7 * (t183 + t222)
  t237 = f.my_piecewise3(t1, 0, t126 * t133 * (0.92000000000000000000000000000000000000000000000000e-1 * t37 * t42 + 0.32187500000000000000000000000000000000000000000000e-1 * t49 * s0 * t54 + 0.26041666666666666666666666666666666666666666666667e-3 * t59 * t50 * t63) / 0.100e3)
  vsigma_0_ = t7 * t237
  vsigma_1_ = 0.0e0
  t250 = f.my_piecewise3(t72, 0, t193 * t200 * (0.92000000000000000000000000000000000000000000000000e-1 * t37 * t85 + 0.32187500000000000000000000000000000000000000000000e-1 * t49 * s2 * t93 + 0.26041666666666666666666666666666666666666666666667e-3 * t59 * t89 * t100) / 0.100e3)
  vsigma_2_ = t7 * t250
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_aa = 2.208

  params_bb = 9.27

  params_cc = 0.2

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  pw86_f = lambda x: pw86_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_kinetic(f, params, pw86_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = r0 ** 2
  t35 = 0.1e1 / t22 / t33
  t39 = t24 ** 2
  t42 = t39 / t26 / t25
  t43 = s0 ** 2
  t44 = t43 * t30
  t45 = t33 ** 2
  t48 = 0.1e1 / t21 / t45 / r0
  t52 = t25 ** 2
  t53 = 0.1e1 / t52
  t55 = t53 * t43 * s0
  t56 = t45 ** 2
  t57 = 0.1e1 / t56
  t61 = (0.1e1 + 0.92000000000000000000000000000000000000000000000000e-1 * t29 * t32 * t35 + 0.32187500000000000000000000000000000000000000000000e-1 * t42 * t44 * t48 + 0.34722222222222222222222222222222222222222222222222e-3 * t55 * t57) ** (0.1e1 / 0.15e2)
  t65 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t20 * t22 * t61)
  t71 = t7 * t20
  t72 = t61 ** 2
  t73 = t72 ** 2
  t75 = t73 ** 2
  t78 = t22 / t75 / t73 / t72
  t100 = f.my_piecewise3(t2, 0, t7 * t20 / t21 * t61 / 0.10e2 + t71 * t78 * (-0.24533333333333333333333333333333333333333333333333e0 * t29 * t32 / t22 / t33 / r0 - 0.17166666666666666666666666666666666666666666666667e0 * t42 * t44 / t21 / t45 / t33 - 0.27777777777777777777777777777777777777777777777778e-2 * t55 / t56 / r0) / 0.100e3)
  vrho_0_ = 0.2e1 * r0 * t100 + 0.2e1 * t65
  t117 = f.my_piecewise3(t2, 0, t71 * t78 * (0.92000000000000000000000000000000000000000000000000e-1 * t29 * t31 * t35 + 0.64375000000000000000000000000000000000000000000000e-1 * t42 * s0 * t30 * t48 + 0.10416666666666666666666666666666666666666666666667e-2 * t53 * t43 * t57) / 0.100e3)
  vsigma_0_ = 0.2e1 * r0 * t117
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = r0 ** 2
  t34 = t21 ** 2
  t36 = 0.1e1 / t34 / t33
  t40 = t24 ** 2
  t43 = t40 / t26 / t25
  t44 = s0 ** 2
  t45 = t44 * t30
  t46 = t33 ** 2
  t49 = 0.1e1 / t21 / t46 / r0
  t53 = t25 ** 2
  t54 = 0.1e1 / t53
  t56 = t54 * t44 * s0
  t57 = t46 ** 2
  t58 = 0.1e1 / t57
  t61 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t29 * t32 * t36 + 0.32187500000000000000000000000000000000000000000000e-1 * t43 * t45 * t49 + 0.34722222222222222222222222222222222222222222222222e-3 * t56 * t58
  t62 = t61 ** (0.1e1 / 0.15e2)
  t66 = t7 * t20
  t67 = t62 ** 2
  t68 = t67 ** 2
  t70 = t68 ** 2
  t71 = t70 * t68 * t67
  t72 = 0.1e1 / t71
  t73 = t34 * t72
  t74 = t33 * r0
  t76 = 0.1e1 / t34 / t74
  t82 = 0.1e1 / t21 / t46 / t33
  t87 = 0.1e1 / t57 / r0
  t90 = -0.24533333333333333333333333333333333333333333333333e0 * t29 * t32 * t76 - 0.17166666666666666666666666666666666666666666666667e0 * t43 * t45 * t82 - 0.27777777777777777777777777777777777777777777777778e-2 * t56 * t87
  t95 = f.my_piecewise3(t2, 0, t7 * t20 * t22 * t62 / 0.10e2 + t66 * t73 * t90 / 0.100e3)
  t103 = t22 * t72
  t109 = t34 / t71 / t61
  t110 = t90 ** 2
  t134 = f.my_piecewise3(t2, 0, -t7 * t20 / t21 / r0 * t62 / 0.30e2 + t66 * t103 * t90 / 0.75e2 - 0.7e1 / 0.750e3 * t66 * t109 * t110 + t66 * t73 * (0.89955555555555555555555555555555555555555555555554e0 * t29 * t32 / t34 / t46 + 0.10872222222222222222222222222222222222222222222222e1 * t43 * t45 / t21 / t46 / t74 + 0.25000000000000000000000000000000000000000000000000e-1 * t56 / t57 / t33) / 0.100e3)
  v2rho2_0_ = 0.2e1 * r0 * t134 + 0.4e1 * t95
  t140 = s0 * t30
  t144 = t54 * t44
  t147 = 0.91999999999999999999999999999999999999999999999998e-1 * t29 * t31 * t36 + 0.64375000000000000000000000000000000000000000000000e-1 * t43 * t140 * t49 + 0.10416666666666666666666666666666666666666666666667e-2 * t144 * t58
  t151 = f.my_piecewise3(t2, 0, t66 * t73 * t147 / 0.100e3)
  t172 = f.my_piecewise3(t2, 0, t66 * t103 * t147 / 0.150e3 - 0.7e1 / 0.750e3 * t66 * t109 * t147 * t90 + t66 * t73 * (-0.24533333333333333333333333333333333333333333333333e0 * t29 * t31 * t76 - 0.34333333333333333333333333333333333333333333333333e0 * t43 * t140 * t82 - 0.83333333333333333333333333333333333333333333333336e-2 * t144 * t87) / 0.100e3)
  v2rhosigma_0_ = 0.2e1 * r0 * t172 + 0.2e1 * t151
  t175 = t147 ** 2
  t190 = f.my_piecewise3(t2, 0, -0.7e1 / 0.750e3 * t66 * t109 * t175 + t66 * t73 * (0.64375000000000000000000000000000000000000000000000e-1 * t43 * t30 * t49 + 0.20833333333333333333333333333333333333333333333334e-2 * t54 * s0 * t58) / 0.100e3)
  v2sigma2_0_ = 0.2e1 * r0 * t190
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t21 / r0
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = t25 / t28
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t34 = r0 ** 2
  t35 = t21 ** 2
  t41 = t25 ** 2
  t44 = t41 / t27 / t26
  t45 = s0 ** 2
  t46 = t45 * t31
  t47 = t34 ** 2
  t48 = t47 * r0
  t54 = t26 ** 2
  t57 = 0.1e1 / t54 * t45 * s0
  t58 = t47 ** 2
  t62 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t30 * t33 / t35 / t34 + 0.32187500000000000000000000000000000000000000000000e-1 * t44 * t46 / t21 / t48 + 0.34722222222222222222222222222222222222222222222222e-3 * t57 / t58
  t63 = t62 ** (0.1e1 / 0.15e2)
  t67 = t7 * t20
  t68 = 0.1e1 / t21
  t69 = t63 ** 2
  t70 = t69 ** 2
  t72 = t70 ** 2
  t73 = t72 * t70 * t69
  t74 = 0.1e1 / t73
  t75 = t68 * t74
  t76 = t34 * r0
  t92 = -0.24533333333333333333333333333333333333333333333333e0 * t30 * t33 / t35 / t76 - 0.17166666666666666666666666666666666666666666666667e0 * t44 * t46 / t21 / t47 / t34 - 0.27777777777777777777777777777777777777777777777778e-2 * t57 / t58 / r0
  t97 = 0.1e1 / t73 / t62
  t98 = t35 * t97
  t99 = t92 ** 2
  t103 = t35 * t74
  t119 = 0.89955555555555555555555555555555555555555555555554e0 * t30 * t33 / t35 / t47 + 0.10872222222222222222222222222222222222222222222222e1 * t44 * t46 / t21 / t47 / t76 + 0.25000000000000000000000000000000000000000000000000e-1 * t57 / t58 / t34
  t124 = f.my_piecewise3(t2, 0, -t7 * t20 * t23 * t63 / 0.30e2 + t67 * t75 * t92 / 0.75e2 - 0.7e1 / 0.750e3 * t67 * t98 * t99 + t67 * t103 * t119 / 0.100e3)
  t143 = t62 ** 2
  t174 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 / t21 / t34 * t63 - t67 * t23 * t74 * t92 / 0.150e3 - 0.7e1 / 0.375e3 * t67 * t68 * t97 * t99 + t67 * t75 * t119 / 0.50e2 + 0.203e3 / 0.11250e5 * t67 * t35 / t73 / t143 * t99 * t92 - 0.7e1 / 0.250e3 * t67 * t98 * t92 * t119 + t67 * t103 * (-0.41979259259259259259259259259259259259259259259259e1 * t30 * t33 / t35 / t48 - 0.79729629629629629629629629629629629629629629629628e1 * t44 * t46 / t21 / t58 - 0.25000000000000000000000000000000000000000000000000e0 * t57 / t58 / t76) / 0.100e3)
  v3rho3_0_ = 0.2e1 * r0 * t174 + 0.6e1 * t124

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** 2
  t22 = r0 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t21
  t26 = 6 ** (0.1e1 / 0.3e1)
  t27 = jnp.pi ** 2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = t26 / t29
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = s0 * t33
  t35 = t22 ** 2
  t41 = t26 ** 2
  t44 = t41 / t28 / t27
  t45 = s0 ** 2
  t46 = t45 * t32
  t47 = t21 ** 2
  t48 = t47 * r0
  t54 = t27 ** 2
  t57 = 0.1e1 / t54 * t45 * s0
  t58 = t47 ** 2
  t62 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t31 * t34 / t35 / t21 + 0.32187500000000000000000000000000000000000000000000e-1 * t44 * t46 / t22 / t48 + 0.34722222222222222222222222222222222222222222222222e-3 * t57 / t58
  t63 = t62 ** (0.1e1 / 0.15e2)
  t67 = t7 * t20
  t69 = 0.1e1 / t22 / r0
  t70 = t63 ** 2
  t71 = t70 ** 2
  t73 = t71 ** 2
  t74 = t73 * t71 * t70
  t75 = 0.1e1 / t74
  t76 = t69 * t75
  t77 = t21 * r0
  t83 = t47 * t21
  t89 = t58 * r0
  t93 = -0.24533333333333333333333333333333333333333333333333e0 * t31 * t34 / t35 / t77 - 0.17166666666666666666666666666666666666666666666667e0 * t44 * t46 / t22 / t83 - 0.27777777777777777777777777777777777777777777777778e-2 * t57 / t89
  t97 = 0.1e1 / t22
  t99 = 0.1e1 / t74 / t62
  t100 = t97 * t99
  t101 = t93 ** 2
  t105 = t97 * t75
  t121 = 0.89955555555555555555555555555555555555555555555554e0 * t31 * t34 / t35 / t47 + 0.10872222222222222222222222222222222222222222222222e1 * t44 * t46 / t22 / t47 / t77 + 0.25000000000000000000000000000000000000000000000000e-1 * t57 / t58 / t21
  t125 = t62 ** 2
  t127 = 0.1e1 / t74 / t125
  t128 = t35 * t127
  t129 = t101 * t93
  t133 = t35 * t99
  t134 = t93 * t121
  t138 = t35 * t75
  t153 = -0.41979259259259259259259259259259259259259259259259e1 * t31 * t34 / t35 / t48 - 0.79729629629629629629629629629629629629629629629628e1 * t44 * t46 / t22 / t58 - 0.25000000000000000000000000000000000000000000000000e0 * t57 / t58 / t77
  t158 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 * t24 * t63 - t67 * t76 * t93 / 0.150e3 - 0.7e1 / 0.375e3 * t67 * t100 * t101 + t67 * t105 * t121 / 0.50e2 + 0.203e3 / 0.11250e5 * t67 * t128 * t129 - 0.7e1 / 0.250e3 * t67 * t133 * t134 + t67 * t138 * t153 / 0.100e3)
  t191 = t101 ** 2
  t199 = t121 ** 2
  t225 = -0.14e2 / 0.135e3 * t7 * t20 / t22 / t77 * t63 + 0.8e1 / 0.675e3 * t67 * t24 * t75 * t93 + 0.14e2 / 0.1125e4 * t67 * t69 * t99 * t101 - t67 * t76 * t121 / 0.75e2 + 0.812e3 / 0.16875e5 * t67 * t97 * t127 * t129 - 0.28e2 / 0.375e3 * t67 * t100 * t134 + 0.2e1 / 0.75e2 * t67 * t105 * t153 - 0.4466e4 / 0.84375e5 * t67 * t35 / t74 / t125 / t62 * t191 + 0.203e3 / 0.1875e4 * t67 * t128 * t101 * t121 - 0.7e1 / 0.250e3 * t67 * t133 * t199 - 0.14e2 / 0.375e3 * t67 * t133 * t93 * t153 + t67 * t138 * (0.23788246913580246913580246913580246913580246913580e2 * t31 * t34 / t35 / t83 + 0.66441358024691358024691358024691358024691358024690e2 * t44 * t46 / t22 / t89 + 0.27500000000000000000000000000000000000000000000000e1 * t57 / t58 / t47) / 0.100e3
  t226 = f.my_piecewise3(t2, 0, t225)
  v4rho4_0_ = 0.2e1 * r0 * t226 + 0.8e1 * t158

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t26 = t17 * t25
  t27 = t8 - t26
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t31 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t28)
  t32 = t7 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = t35 / t38
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t49 = t35 ** 2
  t52 = t49 / t37 / t36
  t53 = s0 ** 2
  t54 = t41 ** 2
  t61 = t36 ** 2
  t62 = 0.1e1 / t61
  t64 = t62 * t53 * s0
  t65 = t54 ** 2
  t69 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t40 * s0 / t43 / t41 + 0.16093750000000000000000000000000000000000000000000e-1 * t52 * t53 / t42 / t54 / r0 + 0.86805555555555555555555555555555555555555555555556e-4 * t64 / t65
  t70 = t69 ** (0.1e1 / 0.15e2)
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 ** 2
  t76 = t75 * f.p.zeta_threshold
  t78 = f.my_piecewise3(t21, t76, t23 * t20)
  t79 = 0.1e1 / t32
  t83 = t6 * t78 * t79 * t70 / 0.10e2
  t84 = t6 * t78
  t85 = t70 ** 2
  t86 = t85 ** 2
  t88 = t86 ** 2
  t89 = t88 * t86 * t85
  t90 = 0.1e1 / t89
  t91 = t33 * t90
  t92 = t41 * r0
  t108 = -0.24533333333333333333333333333333333333333333333333e0 * t40 * s0 / t43 / t92 - 0.85833333333333333333333333333333333333333333333333e-1 * t52 * t53 / t42 / t54 / t41 - 0.69444444444444444444444444444444444444444444444445e-3 * t64 / t65 / r0
  t109 = t91 * t108
  t113 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * t33 * t70 + t83 + t84 * t109 / 0.100e3)
  t115 = r1 <= f.p.dens_threshold
  t116 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t117 = 0.1e1 + t116
  t118 = t117 <= f.p.zeta_threshold
  t119 = t117 ** (0.1e1 / 0.3e1)
  t120 = t119 ** 2
  t122 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t125 = f.my_piecewise3(t118, 0, 0.5e1 / 0.3e1 * t120 * t122)
  t127 = r1 ** 2
  t128 = r1 ** (0.1e1 / 0.3e1)
  t129 = t128 ** 2
  t135 = s2 ** 2
  t136 = t127 ** 2
  t144 = t62 * t135 * s2
  t145 = t136 ** 2
  t149 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t40 * s2 / t129 / t127 + 0.16093750000000000000000000000000000000000000000000e-1 * t52 * t135 / t128 / t136 / r1 + 0.86805555555555555555555555555555555555555555555556e-4 * t144 / t145
  t150 = t149 ** (0.1e1 / 0.15e2)
  t155 = f.my_piecewise3(t118, t76, t120 * t117)
  t159 = t6 * t155 * t79 * t150 / 0.10e2
  t161 = f.my_piecewise3(t115, 0, 0.3e1 / 0.20e2 * t6 * t125 * t33 * t150 + t159)
  t163 = 0.1e1 / t22
  t164 = t28 ** 2
  t169 = t17 / t24 / t7
  t171 = -0.2e1 * t25 + 0.2e1 * t169
  t172 = f.my_piecewise5(t11, 0, t15, 0, t171)
  t176 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t163 * t164 + 0.5e1 / 0.3e1 * t23 * t172)
  t183 = t6 * t31 * t79 * t70
  t189 = 0.1e1 / t32 / t7
  t193 = t6 * t78 * t189 * t70 / 0.30e2
  t196 = t84 * t79 * t90 * t108
  t201 = t108 ** 2
  t225 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t176 * t33 * t70 + t183 / 0.5e1 + t6 * t31 * t109 / 0.50e2 - t193 + t196 / 0.75e2 - 0.7e1 / 0.750e3 * t84 * t33 / t89 / t69 * t201 + t84 * t91 * (0.89955555555555555555555555555555555555555555555554e0 * t40 * s0 / t43 / t54 + 0.54361111111111111111111111111111111111111111111111e0 * t52 * t53 / t42 / t54 / t92 + 0.62500000000000000000000000000000000000000000000000e-2 * t64 / t65 / t41) / 0.100e3)
  t226 = 0.1e1 / t119
  t227 = t122 ** 2
  t231 = f.my_piecewise5(t15, 0, t11, 0, -t171)
  t235 = f.my_piecewise3(t118, 0, 0.10e2 / 0.9e1 * t226 * t227 + 0.5e1 / 0.3e1 * t120 * t231)
  t242 = t6 * t125 * t79 * t150
  t247 = t6 * t155 * t189 * t150 / 0.30e2
  t249 = f.my_piecewise3(t115, 0, 0.3e1 / 0.20e2 * t6 * t235 * t33 * t150 + t242 / 0.5e1 - t247)
  d11 = 0.2e1 * t113 + 0.2e1 * t161 + t7 * (t225 + t249)
  t252 = -t8 - t26
  t253 = f.my_piecewise5(t11, 0, t15, 0, t252)
  t256 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t253)
  t262 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t256 * t33 * t70 + t83)
  t264 = f.my_piecewise5(t15, 0, t11, 0, -t252)
  t267 = f.my_piecewise3(t118, 0, 0.5e1 / 0.3e1 * t120 * t264)
  t272 = t6 * t155
  t273 = t150 ** 2
  t274 = t273 ** 2
  t276 = t274 ** 2
  t277 = t276 * t274 * t273
  t278 = 0.1e1 / t277
  t279 = t33 * t278
  t280 = t127 * r1
  t296 = -0.24533333333333333333333333333333333333333333333333e0 * t40 * s2 / t129 / t280 - 0.85833333333333333333333333333333333333333333333333e-1 * t52 * t135 / t128 / t136 / t127 - 0.69444444444444444444444444444444444444444444444445e-3 * t144 / t145 / r1
  t297 = t279 * t296
  t301 = f.my_piecewise3(t115, 0, 0.3e1 / 0.20e2 * t6 * t267 * t33 * t150 + t159 + t272 * t297 / 0.100e3)
  t305 = 0.2e1 * t169
  t306 = f.my_piecewise5(t11, 0, t15, 0, t305)
  t310 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t163 * t253 * t28 + 0.5e1 / 0.3e1 * t23 * t306)
  t317 = t6 * t256 * t79 * t70
  t325 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t310 * t33 * t70 + t317 / 0.10e2 + t6 * t256 * t109 / 0.100e3 + t183 / 0.10e2 - t193 + t196 / 0.150e3)
  t329 = f.my_piecewise5(t15, 0, t11, 0, -t305)
  t333 = f.my_piecewise3(t118, 0, 0.10e2 / 0.9e1 * t226 * t264 * t122 + 0.5e1 / 0.3e1 * t120 * t329)
  t340 = t6 * t267 * t79 * t150
  t348 = t272 * t79 * t278 * t296
  t351 = f.my_piecewise3(t115, 0, 0.3e1 / 0.20e2 * t6 * t333 * t33 * t150 + t340 / 0.10e2 + t242 / 0.10e2 - t247 + t6 * t125 * t297 / 0.100e3 + t348 / 0.150e3)
  d12 = t113 + t161 + t262 + t301 + t7 * (t325 + t351)
  t356 = t253 ** 2
  t360 = 0.2e1 * t25 + 0.2e1 * t169
  t361 = f.my_piecewise5(t11, 0, t15, 0, t360)
  t365 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t163 * t356 + 0.5e1 / 0.3e1 * t23 * t361)
  t372 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t365 * t33 * t70 + t317 / 0.5e1 - t193)
  t373 = t264 ** 2
  t377 = f.my_piecewise5(t15, 0, t11, 0, -t360)
  t381 = f.my_piecewise3(t118, 0, 0.10e2 / 0.9e1 * t226 * t373 + 0.5e1 / 0.3e1 * t120 * t377)
  t394 = t296 ** 2
  t418 = f.my_piecewise3(t115, 0, 0.3e1 / 0.20e2 * t6 * t381 * t33 * t150 + t340 / 0.5e1 + t6 * t267 * t297 / 0.50e2 - t247 + t348 / 0.75e2 - 0.7e1 / 0.750e3 * t272 * t33 / t277 / t149 * t394 + t272 * t279 * (0.89955555555555555555555555555555555555555555555554e0 * t40 * s2 / t129 / t136 + 0.54361111111111111111111111111111111111111111111111e0 * t52 * t135 / t128 / t136 / t280 + 0.62500000000000000000000000000000000000000000000000e-2 * t144 / t145 / t127) / 0.100e3)
  d22 = 0.2e1 * t262 + 0.2e1 * t301 + t7 * (t372 + t418)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t22
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t27 = -t17 * t25 + t8
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t29 = t28 ** 2
  t32 = t22 ** 2
  t34 = 0.1e1 / t24 / t7
  t37 = 0.2e1 * t17 * t34 - 0.2e1 * t25
  t38 = f.my_piecewise5(t11, 0, t15, 0, t37)
  t42 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t23 * t29 + 0.5e1 / 0.3e1 * t32 * t38)
  t43 = t7 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t46 = 6 ** (0.1e1 / 0.3e1)
  t47 = jnp.pi ** 2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = t48 ** 2
  t51 = t46 / t49
  t52 = r0 ** 2
  t53 = r0 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t60 = t46 ** 2
  t63 = t60 / t48 / t47
  t64 = s0 ** 2
  t65 = t52 ** 2
  t66 = t65 * r0
  t72 = t47 ** 2
  t73 = 0.1e1 / t72
  t75 = t73 * t64 * s0
  t76 = t65 ** 2
  t80 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t51 * s0 / t54 / t52 + 0.16093750000000000000000000000000000000000000000000e-1 * t63 * t64 / t53 / t66 + 0.86805555555555555555555555555555555555555555555556e-4 * t75 / t76
  t81 = t80 ** (0.1e1 / 0.15e2)
  t87 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t32 * t28)
  t88 = 0.1e1 / t43
  t93 = t6 * t87
  t94 = t81 ** 2
  t95 = t94 ** 2
  t97 = t95 ** 2
  t98 = t97 * t95 * t94
  t99 = 0.1e1 / t98
  t100 = t44 * t99
  t101 = t52 * r0
  t117 = -0.24533333333333333333333333333333333333333333333333e0 * t51 * s0 / t54 / t101 - 0.85833333333333333333333333333333333333333333333333e-1 * t63 * t64 / t53 / t65 / t52 - 0.69444444444444444444444444444444444444444444444445e-3 * t75 / t76 / r0
  t118 = t100 * t117
  t121 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t122 = t121 ** 2
  t123 = t122 * f.p.zeta_threshold
  t125 = f.my_piecewise3(t21, t123, t32 * t20)
  t127 = 0.1e1 / t43 / t7
  t132 = t6 * t125
  t133 = t88 * t99
  t134 = t133 * t117
  t138 = 0.1e1 / t98 / t80
  t139 = t44 * t138
  t140 = t117 ** 2
  t141 = t139 * t140
  t159 = 0.89955555555555555555555555555555555555555555555554e0 * t51 * s0 / t54 / t65 + 0.54361111111111111111111111111111111111111111111111e0 * t63 * t64 / t53 / t65 / t101 + 0.62500000000000000000000000000000000000000000000000e-2 * t75 / t76 / t52
  t160 = t100 * t159
  t164 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t42 * t44 * t81 + t6 * t87 * t88 * t81 / 0.5e1 + t93 * t118 / 0.50e2 - t6 * t125 * t127 * t81 / 0.30e2 + t132 * t134 / 0.75e2 - 0.7e1 / 0.750e3 * t132 * t141 + t132 * t160 / 0.100e3)
  t166 = r1 <= f.p.dens_threshold
  t167 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t168 = 0.1e1 + t167
  t169 = t168 <= f.p.zeta_threshold
  t170 = t168 ** (0.1e1 / 0.3e1)
  t171 = 0.1e1 / t170
  t173 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t174 = t173 ** 2
  t177 = t170 ** 2
  t179 = f.my_piecewise5(t15, 0, t11, 0, -t37)
  t183 = f.my_piecewise3(t169, 0, 0.10e2 / 0.9e1 * t171 * t174 + 0.5e1 / 0.3e1 * t177 * t179)
  t185 = r1 ** 2
  t186 = r1 ** (0.1e1 / 0.3e1)
  t187 = t186 ** 2
  t193 = s2 ** 2
  t194 = t185 ** 2
  t203 = t194 ** 2
  t208 = (0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t51 * s2 / t187 / t185 + 0.16093750000000000000000000000000000000000000000000e-1 * t63 * t193 / t186 / t194 / r1 + 0.86805555555555555555555555555555555555555555555556e-4 * t73 * t193 * s2 / t203) ** (0.1e1 / 0.15e2)
  t214 = f.my_piecewise3(t169, 0, 0.5e1 / 0.3e1 * t177 * t173)
  t220 = f.my_piecewise3(t169, t123, t177 * t168)
  t226 = f.my_piecewise3(t166, 0, 0.3e1 / 0.20e2 * t6 * t183 * t44 * t208 + t6 * t214 * t88 * t208 / 0.5e1 - t6 * t220 * t127 * t208 / 0.30e2)
  t234 = t80 ** 2
  t254 = t24 ** 2
  t258 = 0.6e1 * t34 - 0.6e1 * t17 / t254
  t259 = f.my_piecewise5(t11, 0, t15, 0, t258)
  t263 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 / t22 / t20 * t29 * t28 + 0.10e2 / 0.3e1 * t23 * t28 * t38 + 0.5e1 / 0.3e1 * t32 * t259)
  t284 = 0.1e1 / t43 / t24
  t314 = -0.7e1 / 0.250e3 * t93 * t141 - 0.7e1 / 0.375e3 * t132 * t88 * t138 * t140 + 0.203e3 / 0.11250e5 * t132 * t44 / t98 / t234 * t140 * t117 - 0.7e1 / 0.250e3 * t132 * t139 * t117 * t159 + 0.3e1 / 0.20e2 * t6 * t263 * t44 * t81 + 0.3e1 / 0.10e2 * t6 * t42 * t88 * t81 + 0.3e1 / 0.100e3 * t6 * t42 * t118 - t6 * t87 * t127 * t81 / 0.10e2 + t93 * t134 / 0.25e2 + 0.3e1 / 0.100e3 * t93 * t160 + 0.2e1 / 0.45e2 * t6 * t125 * t284 * t81 - t132 * t127 * t99 * t117 / 0.150e3 + t132 * t133 * t159 / 0.50e2 + t132 * t100 * (-0.41979259259259259259259259259259259259259259259259e1 * t51 * s0 / t54 / t66 - 0.39864814814814814814814814814814814814814814814815e1 * t63 * t64 / t53 / t76 - 0.62500000000000000000000000000000000000000000000000e-1 * t75 / t76 / t101) / 0.100e3
  t315 = f.my_piecewise3(t1, 0, t314)
  t325 = f.my_piecewise5(t15, 0, t11, 0, -t258)
  t329 = f.my_piecewise3(t169, 0, -0.10e2 / 0.27e2 / t170 / t168 * t174 * t173 + 0.10e2 / 0.3e1 * t171 * t173 * t179 + 0.5e1 / 0.3e1 * t177 * t325)
  t347 = f.my_piecewise3(t166, 0, 0.3e1 / 0.20e2 * t6 * t329 * t44 * t208 + 0.3e1 / 0.10e2 * t6 * t183 * t88 * t208 - t6 * t214 * t127 * t208 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t220 * t284 * t208)
  d111 = 0.3e1 * t164 + 0.3e1 * t226 + t7 * (t315 + t347)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t27 = -t17 * t25 + t8
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t31 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t28)
  t32 = t6 * t31
  t33 = t7 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = t35 / t38
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t49 = t35 ** 2
  t52 = t49 / t37 / t36
  t53 = s0 ** 2
  t54 = t41 ** 2
  t55 = t54 * r0
  t61 = t36 ** 2
  t62 = 0.1e1 / t61
  t64 = t62 * t53 * s0
  t65 = t54 ** 2
  t69 = 0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t40 * s0 / t43 / t41 + 0.16093750000000000000000000000000000000000000000000e-1 * t52 * t53 / t42 / t55 + 0.86805555555555555555555555555555555555555555555556e-4 * t64 / t65
  t70 = t69 ** (0.1e1 / 0.15e2)
  t71 = t70 ** 2
  t72 = t71 ** 2
  t74 = t72 ** 2
  t75 = t74 * t72 * t71
  t77 = 0.1e1 / t75 / t69
  t78 = t34 * t77
  t79 = t41 * r0
  t85 = t54 * t41
  t91 = t65 * r0
  t95 = -0.24533333333333333333333333333333333333333333333333e0 * t40 * s0 / t43 / t79 - 0.85833333333333333333333333333333333333333333333333e-1 * t52 * t53 / t42 / t85 - 0.69444444444444444444444444444444444444444444444445e-3 * t64 / t91
  t96 = t95 ** 2
  t97 = t78 * t96
  t100 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t101 = t100 ** 2
  t102 = t101 * f.p.zeta_threshold
  t104 = f.my_piecewise3(t21, t102, t23 * t20)
  t105 = t6 * t104
  t106 = 0.1e1 / t33
  t107 = t106 * t77
  t108 = t107 * t96
  t111 = t69 ** 2
  t113 = 0.1e1 / t75 / t111
  t114 = t34 * t113
  t115 = t96 * t95
  t116 = t114 * t115
  t134 = 0.89955555555555555555555555555555555555555555555554e0 * t40 * s0 / t43 / t54 + 0.54361111111111111111111111111111111111111111111111e0 * t52 * t53 / t42 / t54 / t79 + 0.62500000000000000000000000000000000000000000000000e-2 * t64 / t65 / t41
  t135 = t95 * t134
  t136 = t78 * t135
  t140 = 0.1e1 / t22 / t20
  t141 = t28 ** 2
  t145 = 0.1e1 / t22
  t146 = t145 * t28
  t147 = t24 * t7
  t148 = 0.1e1 / t147
  t151 = 0.2e1 * t17 * t148 - 0.2e1 * t25
  t152 = f.my_piecewise5(t11, 0, t15, 0, t151)
  t155 = t24 ** 2
  t156 = 0.1e1 / t155
  t159 = -0.6e1 * t17 * t156 + 0.6e1 * t148
  t160 = f.my_piecewise5(t11, 0, t15, 0, t159)
  t164 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t140 * t141 * t28 + 0.10e2 / 0.3e1 * t146 * t152 + 0.5e1 / 0.3e1 * t23 * t160)
  t174 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t145 * t141 + 0.5e1 / 0.3e1 * t23 * t152)
  t179 = t6 * t174
  t180 = 0.1e1 / t75
  t181 = t34 * t180
  t182 = t181 * t95
  t186 = 0.1e1 / t33 / t7
  t191 = t106 * t180
  t192 = t191 * t95
  t195 = t181 * t134
  t199 = 0.1e1 / t33 / t24
  t204 = t186 * t180
  t205 = t204 * t95
  t208 = t191 * t134
  t225 = -0.41979259259259259259259259259259259259259259259259e1 * t40 * s0 / t43 / t55 - 0.39864814814814814814814814814814814814814814814815e1 * t52 * t53 / t42 / t65 - 0.62500000000000000000000000000000000000000000000000e-1 * t64 / t65 / t79
  t226 = t181 * t225
  t229 = -0.7e1 / 0.250e3 * t32 * t97 - 0.7e1 / 0.375e3 * t105 * t108 + 0.203e3 / 0.11250e5 * t105 * t116 - 0.7e1 / 0.250e3 * t105 * t136 + 0.3e1 / 0.20e2 * t6 * t164 * t34 * t70 + 0.3e1 / 0.10e2 * t6 * t174 * t106 * t70 + 0.3e1 / 0.100e3 * t179 * t182 - t6 * t31 * t186 * t70 / 0.10e2 + t32 * t192 / 0.25e2 + 0.3e1 / 0.100e3 * t32 * t195 + 0.2e1 / 0.45e2 * t6 * t104 * t199 * t70 - t105 * t205 / 0.150e3 + t105 * t208 / 0.50e2 + t105 * t226 / 0.100e3
  t230 = f.my_piecewise3(t1, 0, t229)
  t232 = r1 <= f.p.dens_threshold
  t233 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t234 = 0.1e1 + t233
  t235 = t234 <= f.p.zeta_threshold
  t236 = t234 ** (0.1e1 / 0.3e1)
  t238 = 0.1e1 / t236 / t234
  t240 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t241 = t240 ** 2
  t245 = 0.1e1 / t236
  t246 = t245 * t240
  t248 = f.my_piecewise5(t15, 0, t11, 0, -t151)
  t251 = t236 ** 2
  t253 = f.my_piecewise5(t15, 0, t11, 0, -t159)
  t257 = f.my_piecewise3(t235, 0, -0.10e2 / 0.27e2 * t238 * t241 * t240 + 0.10e2 / 0.3e1 * t246 * t248 + 0.5e1 / 0.3e1 * t251 * t253)
  t259 = r1 ** 2
  t260 = r1 ** (0.1e1 / 0.3e1)
  t261 = t260 ** 2
  t267 = s2 ** 2
  t268 = t259 ** 2
  t277 = t268 ** 2
  t282 = (0.1e1 + 0.91999999999999999999999999999999999999999999999998e-1 * t40 * s2 / t261 / t259 + 0.16093750000000000000000000000000000000000000000000e-1 * t52 * t267 / t260 / t268 / r1 + 0.86805555555555555555555555555555555555555555555556e-4 * t62 * t267 * s2 / t277) ** (0.1e1 / 0.15e2)
  t291 = f.my_piecewise3(t235, 0, 0.10e2 / 0.9e1 * t245 * t241 + 0.5e1 / 0.3e1 * t251 * t248)
  t298 = f.my_piecewise3(t235, 0, 0.5e1 / 0.3e1 * t251 * t240)
  t304 = f.my_piecewise3(t235, t102, t251 * t234)
  t310 = f.my_piecewise3(t232, 0, 0.3e1 / 0.20e2 * t6 * t257 * t34 * t282 + 0.3e1 / 0.10e2 * t6 * t291 * t106 * t282 - t6 * t298 * t186 * t282 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t304 * t199 * t282)
  t312 = t20 ** 2
  t315 = t141 ** 2
  t321 = t152 ** 2
  t330 = -0.24e2 * t156 + 0.24e2 * t17 / t155 / t7
  t331 = f.my_piecewise5(t11, 0, t15, 0, t330)
  t335 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t22 / t312 * t315 - 0.20e2 / 0.9e1 * t140 * t141 * t152 + 0.10e2 / 0.3e1 * t145 * t321 + 0.40e2 / 0.9e1 * t146 * t160 + 0.5e1 / 0.3e1 * t23 * t331)
  t353 = 0.1e1 / t33 / t147
  t383 = 0.3e1 / 0.20e2 * t6 * t335 * t34 * t70 + 0.2e1 / 0.5e1 * t6 * t164 * t106 * t70 - t6 * t174 * t186 * t70 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t31 * t199 * t70 - 0.14e2 / 0.135e3 * t6 * t104 * t353 * t70 - 0.14e2 / 0.125e3 * t32 * t136 - 0.28e2 / 0.375e3 * t105 * t107 * t135 + 0.203e3 / 0.1875e4 * t105 * t114 * t96 * t134 - 0.14e2 / 0.375e3 * t105 * t78 * t95 * t225 - 0.28e2 / 0.375e3 * t32 * t108 + 0.406e3 / 0.5625e4 * t32 * t116 + 0.14e2 / 0.1125e4 * t105 * t186 * t77 * t96 + 0.812e3 / 0.16875e5 * t105 * t106 * t113 * t115
  t388 = t96 ** 2
  t392 = t134 ** 2
  t439 = -0.4466e4 / 0.84375e5 * t105 * t34 / t75 / t111 / t69 * t388 - 0.7e1 / 0.250e3 * t105 * t78 * t392 - 0.7e1 / 0.125e3 * t179 * t97 + t6 * t164 * t182 / 0.25e2 + 0.2e1 / 0.25e2 * t179 * t192 + 0.3e1 / 0.50e2 * t179 * t195 - 0.2e1 / 0.75e2 * t32 * t205 + 0.2e1 / 0.25e2 * t32 * t208 + t32 * t226 / 0.25e2 + 0.8e1 / 0.675e3 * t105 * t199 * t180 * t95 - t105 * t204 * t134 / 0.75e2 + 0.2e1 / 0.75e2 * t105 * t191 * t225 + t105 * t181 * (0.23788246913580246913580246913580246913580246913580e2 * t40 * s0 / t43 / t85 + 0.33220679012345679012345679012345679012345679012346e2 * t52 * t53 / t42 / t91 + 0.68750000000000000000000000000000000000000000000000e0 * t64 / t65 / t54) / 0.100e3
  t441 = f.my_piecewise3(t1, 0, t383 + t439)
  t442 = t234 ** 2
  t445 = t241 ** 2
  t451 = t248 ** 2
  t457 = f.my_piecewise5(t15, 0, t11, 0, -t330)
  t461 = f.my_piecewise3(t235, 0, 0.40e2 / 0.81e2 / t236 / t442 * t445 - 0.20e2 / 0.9e1 * t238 * t241 * t248 + 0.10e2 / 0.3e1 * t245 * t451 + 0.40e2 / 0.9e1 * t246 * t253 + 0.5e1 / 0.3e1 * t251 * t457)
  t483 = f.my_piecewise3(t232, 0, 0.3e1 / 0.20e2 * t6 * t461 * t34 * t282 + 0.2e1 / 0.5e1 * t6 * t257 * t106 * t282 - t6 * t291 * t186 * t282 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t298 * t199 * t282 - 0.14e2 / 0.135e3 * t6 * t304 * t353 * t282)
  d1111 = 0.4e1 * t230 + 0.4e1 * t310 + t7 * (t441 + t483)

  res = {'v4rho4': d1111}
  return res
