"""Generated from gga_k_thakkar.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  thakkar_f0 = lambda x: 1 + 0.0055 * x ** 2 / (1 + 0.0253 * x * jnp.arcsinh(x))

  thakkar_f1 = lambda x: -0.072 * x / (1 + 2 * 4 ** (1 / 3) * x)

  thakkar_f = lambda x: thakkar_f0(x) + thakkar_f1(x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, thakkar_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  thakkar_f0 = lambda x: 1 + 0.0055 * x ** 2 / (1 + 0.0253 * x * jnp.arcsinh(x))

  thakkar_f1 = lambda x: -0.072 * x / (1 + 2 * 4 ** (1 / 3) * x)

  thakkar_f = lambda x: thakkar_f0(x) + thakkar_f1(x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, thakkar_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  thakkar_f0 = lambda x: 1 + 0.0055 * x ** 2 / (1 + 0.0253 * x * jnp.arcsinh(x))

  thakkar_f1 = lambda x: -0.072 * x / (1 + 2 * 4 ** (1 / 3) * x)

  thakkar_f = lambda x: thakkar_f0(x) + thakkar_f1(x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, thakkar_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * f.p.zeta_threshold
  t25 = t20 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = f.my_piecewise3(t21, t24, t26 * t20)
  t29 = t7 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = t28 * t30
  t32 = r0 ** 2
  t33 = r0 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = 0.1e1 / t34 / t32
  t37 = s0 * t36
  t38 = jnp.sqrt(s0)
  t40 = 0.1e1 / t33 / r0
  t41 = t38 * t40
  t42 = jnp.arcsinh(t41)
  t45 = 0.1e1 + 0.253e-1 * t41 * t42
  t46 = 0.1e1 / t45
  t49 = 4 ** (0.1e1 / 0.3e1)
  t53 = 0.2e1 * t49 * t38 * t40 + 0.1e1
  t54 = 0.1e1 / t53
  t57 = 0.1e1 + 0.55e-2 * t37 * t46 - 0.72e-1 * t41 * t54
  t61 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * t57)
  t62 = r1 <= f.p.dens_threshold
  t63 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t64 = 0.1e1 + t63
  t65 = t64 <= f.p.zeta_threshold
  t66 = t64 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t69 = f.my_piecewise3(t65, t24, t67 * t64)
  t70 = t69 * t30
  t71 = r1 ** 2
  t72 = r1 ** (0.1e1 / 0.3e1)
  t73 = t72 ** 2
  t75 = 0.1e1 / t73 / t71
  t76 = s2 * t75
  t77 = jnp.sqrt(s2)
  t79 = 0.1e1 / t72 / r1
  t80 = t77 * t79
  t81 = jnp.arcsinh(t80)
  t84 = 0.1e1 + 0.253e-1 * t80 * t81
  t85 = 0.1e1 / t84
  t91 = 0.2e1 * t49 * t77 * t79 + 0.1e1
  t92 = 0.1e1 / t91
  t95 = 0.1e1 + 0.55e-2 * t76 * t85 - 0.72e-1 * t80 * t92
  t99 = f.my_piecewise3(t62, 0, 0.3e1 / 0.20e2 * t6 * t70 * t95)
  t100 = t7 ** 2
  t102 = t17 / t100
  t103 = t8 - t102
  t104 = f.my_piecewise5(t11, 0, t15, 0, t103)
  t107 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t104)
  t112 = 0.1e1 / t29
  t116 = t6 * t28 * t112 * t57 / 0.10e2
  t120 = s0 / t34 / t32 / r0
  t123 = t45 ** 2
  t124 = 0.1e1 / t123
  t127 = t38 / t33 / t32
  t131 = jnp.sqrt(0.1e1 + t37)
  t132 = 0.1e1 / t131
  t141 = t53 ** 2
  t142 = 0.1e1 / t141
  t151 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t107 * t30 * t57 + t116 + 0.3e1 / 0.20e2 * t6 * t31 * (-0.14666666666666666666666666666666666666666666666667e-1 * t120 * t46 - 0.55e-2 * t37 * t124 * (-0.33733333333333333333333333333333333333333333333333e-1 * t127 * t42 - 0.33733333333333333333333333333333333333333333333333e-1 * t120 * t132) + 0.96000000000000000000000000000000000000000000000000e-1 * t127 * t54 - 0.19200000000000000000000000000000000000000000000000e0 * t120 * t142 * t49))
  t153 = f.my_piecewise5(t15, 0, t11, 0, -t103)
  t156 = f.my_piecewise3(t65, 0, 0.5e1 / 0.3e1 * t67 * t153)
  t164 = t6 * t69 * t112 * t95 / 0.10e2
  t166 = f.my_piecewise3(t62, 0, 0.3e1 / 0.20e2 * t6 * t156 * t30 * t95 + t164)
  vrho_0_ = t61 + t99 + t7 * (t151 + t166)
  t169 = -t8 - t102
  t170 = f.my_piecewise5(t11, 0, t15, 0, t169)
  t173 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t170)
  t179 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t173 * t30 * t57 + t116)
  t181 = f.my_piecewise5(t15, 0, t11, 0, -t169)
  t184 = f.my_piecewise3(t65, 0, 0.5e1 / 0.3e1 * t67 * t181)
  t192 = s2 / t73 / t71 / r1
  t195 = t84 ** 2
  t196 = 0.1e1 / t195
  t199 = t77 / t72 / t71
  t203 = jnp.sqrt(0.1e1 + t76)
  t204 = 0.1e1 / t203
  t213 = t91 ** 2
  t214 = 0.1e1 / t213
  t223 = f.my_piecewise3(t62, 0, 0.3e1 / 0.20e2 * t6 * t184 * t30 * t95 + t164 + 0.3e1 / 0.20e2 * t6 * t70 * (-0.14666666666666666666666666666666666666666666666667e-1 * t192 * t85 - 0.55e-2 * t76 * t196 * (-0.33733333333333333333333333333333333333333333333333e-1 * t199 * t81 - 0.33733333333333333333333333333333333333333333333333e-1 * t192 * t204) + 0.96000000000000000000000000000000000000000000000000e-1 * t199 * t92 - 0.19200000000000000000000000000000000000000000000000e0 * t192 * t214 * t49))
  vrho_1_ = t61 + t99 + t7 * (t179 + t223)
  t229 = 0.1e1 / t38 * t40
  t247 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * (0.55e-2 * t36 * t46 - 0.55e-2 * t37 * t124 * (0.12650000000000000000000000000000000000000000000000e-1 * t229 * t42 + 0.12650000000000000000000000000000000000000000000000e-1 * t36 * t132) - 0.36000000000000000000000000000000000000000000000000e-1 * t229 * t54 + 0.72e-1 * t36 * t142 * t49))
  vsigma_0_ = t7 * t247
  vsigma_1_ = 0.0e0
  t251 = 0.1e1 / t77 * t79
  t269 = f.my_piecewise3(t62, 0, 0.3e1 / 0.20e2 * t6 * t70 * (0.55e-2 * t75 * t85 - 0.55e-2 * t76 * t196 * (0.12650000000000000000000000000000000000000000000000e-1 * t251 * t81 + 0.12650000000000000000000000000000000000000000000000e-1 * t75 * t204) - 0.36000000000000000000000000000000000000000000000000e-1 * t251 * t92 + 0.72e-1 * t75 * t214 * t49))
  vsigma_2_ = t7 * t269
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  thakkar_f0 = lambda x: 1 + 0.0055 * x ** 2 / (1 + 0.0253 * x * jnp.arcsinh(x))

  thakkar_f1 = lambda x: -0.072 * x / (1 + 2 * 4 ** (1 / 3) * x)

  thakkar_f = lambda x: thakkar_f0(x) + thakkar_f1(x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, thakkar_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = t20 * t22
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = s0 * t25
  t27 = r0 ** 2
  t29 = 0.1e1 / t22 / t27
  t30 = jnp.sqrt(s0)
  t31 = t30 * t24
  t33 = 0.1e1 / t21 / r0
  t35 = jnp.arcsinh(t31 * t33)
  t36 = t33 * t35
  t39 = 0.1e1 + 0.253e-1 * t31 * t36
  t40 = 0.1e1 / t39
  t44 = 4 ** (0.1e1 / 0.3e1)
  t49 = 0.2e1 * t44 * t30 * t24 * t33 + 0.1e1
  t50 = 0.1e1 / t49
  t51 = t33 * t50
  t54 = 0.1e1 + 0.55e-2 * t26 * t29 * t40 - 0.72e-1 * t31 * t51
  t58 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t23 * t54)
  t66 = 0.1e1 / t22 / t27 / r0
  t70 = t39 ** 2
  t72 = t29 / t70
  t74 = 0.1e1 / t21 / t27
  t80 = jnp.sqrt(t26 * t29 + 0.1e1)
  t81 = 0.1e1 / t80
  t92 = t49 ** 2
  t93 = 0.1e1 / t92
  t103 = f.my_piecewise3(t2, 0, t7 * t20 / t21 * t54 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t23 * (-0.14666666666666666666666666666666666666666666666667e-1 * t26 * t66 * t40 - 0.55e-2 * t26 * t72 * (-0.33733333333333333333333333333333333333333333333333e-1 * t31 * t74 * t35 - 0.33733333333333333333333333333333333333333333333333e-1 * t26 * t66 * t81) + 0.96000000000000000000000000000000000000000000000000e-1 * t31 * t74 * t50 - 0.19200000000000000000000000000000000000000000000000e0 * t26 * t66 * t93 * t44))
  vrho_0_ = 0.2e1 * r0 * t103 + 0.2e1 * t58
  t106 = t25 * t29
  t110 = 0.1e1 / t30 * t24
  t128 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t23 * (0.55e-2 * t106 * t40 - 0.55e-2 * t26 * t72 * (0.12650000000000000000000000000000000000000000000000e-1 * t110 * t36 + 0.12650000000000000000000000000000000000000000000000e-1 * t106 * t81) - 0.36000000000000000000000000000000000000000000000000e-1 * t110 * t51 + 0.72e-1 * t106 * t93 * t44))
  vsigma_0_ = 0.2e1 * r0 * t128
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = t20 / t21
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = s0 * t25
  t27 = r0 ** 2
  t28 = t21 ** 2
  t30 = 0.1e1 / t28 / t27
  t31 = jnp.sqrt(s0)
  t32 = t31 * t24
  t34 = 0.1e1 / t21 / r0
  t36 = jnp.arcsinh(t32 * t34)
  t37 = t34 * t36
  t40 = 0.1e1 + 0.253e-1 * t32 * t37
  t41 = 0.1e1 / t40
  t45 = 4 ** (0.1e1 / 0.3e1)
  t50 = 0.2e1 * t45 * t31 * t24 * t34 + 0.1e1
  t51 = 0.1e1 / t50
  t52 = t34 * t51
  t55 = 0.1e1 + 0.55e-2 * t26 * t30 * t41 - 0.72e-1 * t32 * t52
  t59 = t20 * t28
  t60 = t27 * r0
  t62 = 0.1e1 / t28 / t60
  t66 = t40 ** 2
  t67 = 0.1e1 / t66
  t68 = t30 * t67
  t70 = 0.1e1 / t21 / t27
  t71 = t70 * t36
  t74 = t26 * t30
  t75 = 0.1e1 + t74
  t76 = jnp.sqrt(t75)
  t77 = 0.1e1 / t76
  t81 = -0.33733333333333333333333333333333333333333333333333e-1 * t32 * t71 - 0.33733333333333333333333333333333333333333333333333e-1 * t26 * t62 * t77
  t85 = t70 * t51
  t88 = t50 ** 2
  t89 = 0.1e1 / t88
  t94 = -0.14666666666666666666666666666666666666666666666667e-1 * t26 * t62 * t41 - 0.55e-2 * t26 * t68 * t81 + 0.96000000000000000000000000000000000000000000000000e-1 * t32 * t85 - 0.19200000000000000000000000000000000000000000000000e0 * t26 * t62 * t89 * t45
  t99 = f.my_piecewise3(t2, 0, t7 * t23 * t55 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t59 * t94)
  t108 = t27 ** 2
  t110 = 0.1e1 / t28 / t108
  t114 = t62 * t67
  t119 = 0.1e1 / t66 / t40
  t120 = t30 * t119
  t121 = t81 ** 2
  t126 = 0.1e1 / t21 / t60
  t133 = s0 ** 2
  t139 = 0.1e1 / t76 / t75
  t154 = t31 * s0
  t155 = t108 * t27
  t159 = 0.1e1 / t88 / t50
  t160 = t45 ** 2
  t169 = f.my_piecewise3(t2, 0, -t7 * t20 * t34 * t55 / 0.30e2 + t7 * t23 * t94 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t59 * (0.53777777777777777777777777777777777777777777777779e-1 * t26 * t110 * t41 + 0.29333333333333333333333333333333333333333333333334e-1 * t26 * t114 * t81 + 0.110e-1 * t26 * t120 * t121 - 0.55e-2 * t26 * t68 * (0.78711111111111111111111111111111111111111111111110e-1 * t32 * t126 * t36 + 0.16866666666666666666666666666666666666666666666667e0 * t26 * t110 * t77 - 0.89955555555555555555555555555555555555555555555555e-1 * t133 * t24 / t21 / t108 / t60 * t139) - 0.22400000000000000000000000000000000000000000000000e0 * t32 * t126 * t51 + 0.96000000000000000000000000000000000000000000000000e0 * t26 * t110 * t89 * t45 - 0.20480000000000000000000000000000000000000000000000e1 * t154 / t155 * t159 * t160))
  v2rho2_0_ = 0.2e1 * r0 * t169 + 0.4e1 * t99
  t172 = t25 * t30
  t175 = 0.1e1 / t31
  t176 = t175 * t24
  t181 = 0.12650000000000000000000000000000000000000000000000e-1 * t176 * t37 + 0.12650000000000000000000000000000000000000000000000e-1 * t172 * t77
  t187 = t89 * t45
  t190 = 0.55e-2 * t172 * t41 - 0.55e-2 * t26 * t68 * t181 - 0.36000000000000000000000000000000000000000000000000e-1 * t176 * t52 + 0.72e-1 * t172 * t187
  t194 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t59 * t190)
  t198 = t25 * t62
  t229 = t108 * r0
  t240 = f.my_piecewise3(t2, 0, t7 * t23 * t190 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t59 * (-0.14666666666666666666666666666666666666666666666667e-1 * t198 * t41 - 0.55e-2 * t172 * t67 * t81 + 0.14666666666666666666666666666666666666666666666667e-1 * t26 * t114 * t181 + 0.110e-1 * t74 * t119 * t181 * t81 - 0.55e-2 * t26 * t68 * (-0.16866666666666666666666666666666666666666666666667e-1 * t176 * t71 - 0.50600000000000000000000000000000000000000000000000e-1 * t198 * t77 + 0.33733333333333333333333333333333333333333333333333e-1 * t24 / t21 / t155 * t139 * s0) + 0.48000000000000000000000000000000000000000000000000e-1 * t176 * t85 - 0.28800000000000000000000000000000000000000000000000e0 * t198 * t187 + 0.76800000000000000000000000000000000000000000000000e0 / t229 * t159 * t160 * t31))
  v2rhosigma_0_ = 0.2e1 * r0 * t240 + 0.2e1 * t194
  t246 = t181 ** 2
  t251 = 0.1e1 / t154 * t24
  t255 = 0.1e1 / s0 * t25
  t283 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t59 * (-0.110e-1 * t172 * t67 * t181 + 0.110e-1 * t26 * t120 * t246 - 0.55e-2 * t26 * t68 * (-0.63250000000000000000000000000000000000000000000000e-2 * t251 * t37 + 0.63250000000000000000000000000000000000000000000000e-2 * t255 * t30 * t77 - 0.12650000000000000000000000000000000000000000000000e-1 * t24 / t21 / t229 * t139) + 0.18000000000000000000000000000000000000000000000000e-1 * t251 * t52 + 0.36000000000000000000000000000000000000000000000000e-1 * t255 * t30 * t89 * t45 - 0.288e0 / t108 * t159 * t160 * t175))
  v2sigma2_0_ = 0.2e1 * r0 * t283
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t21 / r0
  t24 = t20 * t23
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = s0 * t26
  t28 = r0 ** 2
  t29 = t21 ** 2
  t31 = 0.1e1 / t29 / t28
  t32 = jnp.sqrt(s0)
  t33 = t32 * t25
  t35 = jnp.asinh(t33 * t23)
  t39 = 0.1e1 + 0.253e-1 * t33 * t23 * t35
  t40 = 0.1e1 / t39
  t44 = 4 ** (0.1e1 / 0.3e1)
  t49 = 0.2e1 * t44 * t32 * t25 * t23 + 0.1e1
  t50 = 0.1e1 / t49
  t54 = 0.1e1 + 0.55e-2 * t27 * t31 * t40 - 0.72e-1 * t33 * t23 * t50
  t59 = t20 / t21
  t60 = t28 * r0
  t62 = 0.1e1 / t29 / t60
  t66 = t39 ** 2
  t67 = 0.1e1 / t66
  t68 = t31 * t67
  t70 = 0.1e1 / t21 / t28
  t74 = t27 * t31
  t75 = 0.1e1 + t74
  t76 = jnp.sqrt(t75)
  t77 = 0.1e1 / t76
  t81 = -0.33733333333333333333333333333333333333333333333333e-1 * t33 * t70 * t35 - 0.33733333333333333333333333333333333333333333333333e-1 * t27 * t62 * t77
  t88 = t49 ** 2
  t89 = 0.1e1 / t88
  t94 = -0.14666666666666666666666666666666666666666666666667e-1 * t27 * t62 * t40 - 0.55e-2 * t27 * t68 * t81 + 0.96000000000000000000000000000000000000000000000000e-1 * t33 * t70 * t50 - 0.19200000000000000000000000000000000000000000000000e0 * t27 * t62 * t89 * t44
  t98 = t20 * t29
  t99 = t28 ** 2
  t101 = 0.1e1 / t29 / t99
  t105 = t62 * t67
  t110 = 0.1e1 / t66 / t39
  t112 = t81 ** 2
  t117 = 0.1e1 / t21 / t60
  t124 = s0 ** 2
  t125 = t124 * t25
  t126 = t99 * t60
  t130 = 0.1e1 / t76 / t75
  t134 = 0.78711111111111111111111111111111111111111111111110e-1 * t33 * t117 * t35 + 0.16866666666666666666666666666666666666666666666667e0 * t27 * t101 * t77 - 0.89955555555555555555555555555555555555555555555555e-1 * t125 / t21 / t126 * t130
  t145 = t32 * s0
  t151 = t44 ** 2
  t152 = 0.1e1 / t88 / t49 * t151
  t155 = 0.53777777777777777777777777777777777777777777777779e-1 * t27 * t101 * t40 + 0.29333333333333333333333333333333333333333333333334e-1 * t27 * t105 * t81 + 0.110e-1 * t27 * t31 * t110 * t112 - 0.55e-2 * t27 * t68 * t134 - 0.22400000000000000000000000000000000000000000000000e0 * t33 * t117 * t50 + 0.96000000000000000000000000000000000000000000000000e0 * t27 * t101 * t89 * t44 - 0.20480000000000000000000000000000000000000000000000e1 * t145 / t99 / t28 * t152
  t160 = f.my_piecewise3(t2, 0, -t7 * t24 * t54 / 0.30e2 + t7 * t59 * t94 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t98 * t155)
  t174 = 0.1e1 / t29 / t99 / r0
  t189 = t66 ** 2
  t201 = 0.1e1 / t21 / t99
  t208 = t99 ** 2
  t210 = 0.1e1 / t21 / t208
  t218 = t75 ** 2
  t239 = t88 ** 2
  t244 = -0.25096296296296296296296296296296296296296296296297e0 * t27 * t174 * t40 - 0.16133333333333333333333333333333333333333333333334e0 * t27 * t101 * t67 * t81 - 0.88000000000000000000000000000000000000000000000001e-1 * t27 * t62 * t110 * t112 + 0.44000000000000000000000000000000000000000000000001e-1 * t27 * t105 * t134 - 0.330e-1 * t27 * t31 / t189 * t112 * t81 + 0.330e-1 * t74 * t110 * t81 * t134 - 0.55e-2 * t27 * t68 * (-0.26237037037037037037037037037037037037037037037037e0 * t33 * t201 * t35 - 0.89205925925925925925925925925925925925925925925928e0 * t27 * t174 * t77 + 0.11094518518518518518518518518518518518518518518519e1 * t125 * t210 * t130 - 0.71964444444444444444444444444444444444444444444444e0 * t124 * s0 / t208 / t60 / t76 / t218) + 0.74666666666666666666666666666666666666666666666667e0 * t33 * t201 * t50 - 0.50773333333333333333333333333333333333333333333333e1 * t27 * t174 * t89 * t44 + 0.22528000000000000000000000000000000000000000000000e2 * t145 / t126 * t152 - 0.65536000000000000000000000000000000000000000000000e2 * t124 * t210 / t239 * t25
  t249 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 * t70 * t54 - t7 * t24 * t94 / 0.10e2 + 0.3e1 / 0.10e2 * t7 * t59 * t155 + 0.3e1 / 0.20e2 * t7 * t98 * t244)
  v3rho3_0_ = 0.2e1 * r0 * t249 + 0.6e1 * t160

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** 2
  t22 = r0 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t21
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = t22 ** 2
  t31 = 0.1e1 / t29 / t21
  t32 = jnp.sqrt(s0)
  t33 = t32 * t26
  t35 = 0.1e1 / t22 / r0
  t37 = jnp.asinh(t33 * t35)
  t41 = 0.1e1 + 0.253e-1 * t33 * t35 * t37
  t42 = 0.1e1 / t41
  t46 = 4 ** (0.1e1 / 0.3e1)
  t51 = 0.2e1 * t46 * t32 * t26 * t35 + 0.1e1
  t52 = 0.1e1 / t51
  t56 = 0.1e1 + 0.55e-2 * t28 * t31 * t42 - 0.72e-1 * t33 * t35 * t52
  t60 = t20 * t35
  t61 = t21 * r0
  t63 = 0.1e1 / t29 / t61
  t67 = t41 ** 2
  t68 = 0.1e1 / t67
  t69 = t31 * t68
  t73 = t28 * t31
  t74 = 0.1e1 + t73
  t75 = jnp.sqrt(t74)
  t76 = 0.1e1 / t75
  t80 = -0.33733333333333333333333333333333333333333333333333e-1 * t33 * t24 * t37 - 0.33733333333333333333333333333333333333333333333333e-1 * t28 * t63 * t76
  t87 = t51 ** 2
  t88 = 0.1e1 / t87
  t93 = -0.14666666666666666666666666666666666666666666666667e-1 * t28 * t63 * t42 - 0.55e-2 * t28 * t69 * t80 + 0.96000000000000000000000000000000000000000000000000e-1 * t33 * t24 * t52 - 0.19200000000000000000000000000000000000000000000000e0 * t28 * t63 * t88 * t46
  t98 = t20 / t22
  t99 = t21 ** 2
  t101 = 0.1e1 / t29 / t99
  t105 = t63 * t68
  t110 = 0.1e1 / t67 / t41
  t111 = t31 * t110
  t112 = t80 ** 2
  t117 = 0.1e1 / t22 / t61
  t124 = s0 ** 2
  t125 = t124 * t26
  t126 = t99 * t61
  t130 = 0.1e1 / t75 / t74
  t134 = 0.78711111111111111111111111111111111111111111111110e-1 * t33 * t117 * t37 + 0.16866666666666666666666666666666666666666666666667e0 * t28 * t101 * t76 - 0.89955555555555555555555555555555555555555555555555e-1 * t125 / t22 / t126 * t130
  t145 = t32 * s0
  t146 = t99 * t21
  t151 = t46 ** 2
  t152 = 0.1e1 / t87 / t51 * t151
  t155 = 0.53777777777777777777777777777777777777777777777779e-1 * t28 * t101 * t42 + 0.29333333333333333333333333333333333333333333333334e-1 * t28 * t105 * t80 + 0.110e-1 * t28 * t111 * t112 - 0.55e-2 * t28 * t69 * t134 - 0.22400000000000000000000000000000000000000000000000e0 * t33 * t117 * t52 + 0.96000000000000000000000000000000000000000000000000e0 * t28 * t101 * t88 * t46 - 0.20480000000000000000000000000000000000000000000000e1 * t145 / t146 * t152
  t159 = t20 * t29
  t160 = t99 * r0
  t162 = 0.1e1 / t29 / t160
  t166 = t101 * t68
  t177 = t67 ** 2
  t178 = 0.1e1 / t177
  t180 = t112 * t80
  t184 = t110 * t80
  t185 = t184 * t134
  t189 = 0.1e1 / t22 / t99
  t196 = t99 ** 2
  t198 = 0.1e1 / t22 / t196
  t202 = t124 * s0
  t206 = t74 ** 2
  t208 = 0.1e1 / t75 / t206
  t211 = -0.26237037037037037037037037037037037037037037037037e0 * t33 * t189 * t37 - 0.89205925925925925925925925925925925925925925925928e0 * t28 * t162 * t76 + 0.11094518518518518518518518518518518518518518518519e1 * t125 * t198 * t130 - 0.71964444444444444444444444444444444444444444444444e0 * t202 / t196 / t61 * t208
  t227 = t87 ** 2
  t229 = 0.1e1 / t227 * t26
  t232 = -0.25096296296296296296296296296296296296296296296297e0 * t28 * t162 * t42 - 0.16133333333333333333333333333333333333333333333334e0 * t28 * t166 * t80 - 0.88000000000000000000000000000000000000000000000001e-1 * t28 * t63 * t110 * t112 + 0.44000000000000000000000000000000000000000000000001e-1 * t28 * t105 * t134 - 0.330e-1 * t28 * t31 * t178 * t180 + 0.330e-1 * t73 * t185 - 0.55e-2 * t28 * t69 * t211 + 0.74666666666666666666666666666666666666666666666667e0 * t33 * t189 * t52 - 0.50773333333333333333333333333333333333333333333333e1 * t28 * t162 * t88 * t46 + 0.22528000000000000000000000000000000000000000000000e2 * t145 / t126 * t152 - 0.65536000000000000000000000000000000000000000000000e2 * t124 * t198 * t229
  t237 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t25 * t56 - t7 * t60 * t93 / 0.10e2 + 0.3e1 / 0.10e2 * t7 * t98 * t155 + 0.3e1 / 0.20e2 * t7 * t159 * t232)
  t253 = 0.1e1 / t22 / t160
  t258 = 0.1e1 / t29 / t146
  t282 = 0.1e1 / t22 / t196 / r0
  t291 = t124 ** 2
  t340 = t112 ** 2
  t348 = t134 ** 2
  t355 = -0.32355555555555555555555555555555555555555555555556e1 * t33 * t253 * t52 + 0.30762666666666666666666666666666666666666666666666e2 * t28 * t258 * t88 * t46 - 0.69905066666666666666666666666666666666666666666667e3 * t32 * t124 / t29 / t196 / t21 / t227 / t51 * t27 * t46 - 0.55e-2 * t28 * t69 * (0.11369382716049382716049382716049382716049382716049e1 * t33 * t253 * t37 + 0.54048296296296296296296296296296296296296296296297e1 * t28 * t258 * t76 - 0.11624256790123456790123456790123456790123456790124e2 * t125 * t282 * t130 + 0.16791703703703703703703703703703703703703703703704e2 * t202 / t196 / t99 * t208 - 0.47976296296296296296296296296296296296296296296296e1 * t291 / t29 / t196 / t146 / t75 / t206 / t74 * t27) + 0.58666666666666666666666666666666666666666666666668e-1 * t28 * t105 * t211 + 0.14221234567901234567901234567901234567901234567902e1 * t28 * t258 * t42 + 0.10038518518518518518518518518518518518518518518519e1 * t28 * t162 * t68 * t80 - 0.32266666666666666666666666666666666666666666666668e0 * t28 * t166 * t134 - 0.21185422222222222222222222222222222222222222222222e3 * t145 / t196 * t152 + 0.12670293333333333333333333333333333333333333333333e4 * t124 * t282 * t229 + 0.64533333333333333333333333333333333333333333333335e0 * t28 * t101 * t110 * t112 + 0.35200000000000000000000000000000000000000000000000e0 * t28 * t63 * t178 * t180 - 0.35200000000000000000000000000000000000000000000000e0 * t28 * t63 * t185 + 0.1320e0 * t28 * t31 / t177 / t41 * t340 - 0.1980e0 * t73 * t178 * t112 * t134 + 0.330e-1 * t28 * t111 * t348 + 0.440e-1 * t73 * t184 * t211
  t360 = f.my_piecewise3(t2, 0, -0.14e2 / 0.135e3 * t7 * t20 * t117 * t56 + 0.8e1 / 0.45e2 * t7 * t25 * t93 - t7 * t60 * t155 / 0.5e1 + 0.2e1 / 0.5e1 * t7 * t98 * t232 + 0.3e1 / 0.20e2 * t7 * t159 * t355)
  v4rho4_0_ = 0.2e1 * r0 * t360 + 0.8e1 * t237

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t26 = t17 * t25
  t27 = t8 - t26
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t31 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t28)
  t32 = t7 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t31 * t33
  t35 = r0 ** 2
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t40 = s0 / t37 / t35
  t41 = jnp.sqrt(s0)
  t43 = 0.1e1 / t36 / r0
  t44 = t41 * t43
  t45 = jnp.arcsinh(t44)
  t48 = 0.1e1 + 0.253e-1 * t44 * t45
  t49 = 0.1e1 / t48
  t52 = 4 ** (0.1e1 / 0.3e1)
  t56 = 0.2e1 * t52 * t41 * t43 + 0.1e1
  t57 = 0.1e1 / t56
  t60 = 0.1e1 + 0.55e-2 * t40 * t49 - 0.72e-1 * t44 * t57
  t64 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t66 = t65 * f.p.zeta_threshold
  t68 = f.my_piecewise3(t21, t66, t23 * t20)
  t69 = 0.1e1 / t32
  t70 = t68 * t69
  t73 = t6 * t70 * t60 / 0.10e2
  t74 = t68 * t33
  t75 = t35 * r0
  t78 = s0 / t37 / t75
  t81 = t48 ** 2
  t82 = 0.1e1 / t81
  t85 = t41 / t36 / t35
  t88 = 0.1e1 + t40
  t89 = jnp.sqrt(t88)
  t90 = 0.1e1 / t89
  t93 = -0.33733333333333333333333333333333333333333333333333e-1 * t85 * t45 - 0.33733333333333333333333333333333333333333333333333e-1 * t78 * t90
  t94 = t82 * t93
  t99 = t56 ** 2
  t101 = 0.1e1 / t99 * t52
  t104 = -0.14666666666666666666666666666666666666666666666667e-1 * t78 * t49 - 0.55e-2 * t40 * t94 + 0.96000000000000000000000000000000000000000000000000e-1 * t85 * t57 - 0.19200000000000000000000000000000000000000000000000e0 * t78 * t101
  t109 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t34 * t60 + t73 + 0.3e1 / 0.20e2 * t6 * t74 * t104)
  t111 = r1 <= f.p.dens_threshold
  t112 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t113 = 0.1e1 + t112
  t114 = t113 <= f.p.zeta_threshold
  t115 = t113 ** (0.1e1 / 0.3e1)
  t116 = t115 ** 2
  t118 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t121 = f.my_piecewise3(t114, 0, 0.5e1 / 0.3e1 * t116 * t118)
  t122 = t121 * t33
  t123 = r1 ** 2
  t124 = r1 ** (0.1e1 / 0.3e1)
  t125 = t124 ** 2
  t128 = s2 / t125 / t123
  t129 = jnp.sqrt(s2)
  t131 = 0.1e1 / t124 / r1
  t132 = t129 * t131
  t133 = jnp.arcsinh(t132)
  t136 = 0.1e1 + 0.253e-1 * t132 * t133
  t137 = 0.1e1 / t136
  t143 = 0.2e1 * t52 * t129 * t131 + 0.1e1
  t144 = 0.1e1 / t143
  t147 = 0.1e1 + 0.55e-2 * t128 * t137 - 0.72e-1 * t132 * t144
  t152 = f.my_piecewise3(t114, t66, t116 * t113)
  t153 = t152 * t69
  t156 = t6 * t153 * t147 / 0.10e2
  t158 = f.my_piecewise3(t111, 0, 0.3e1 / 0.20e2 * t6 * t122 * t147 + t156)
  t160 = 0.1e1 / t22
  t161 = t28 ** 2
  t166 = t17 / t24 / t7
  t168 = -0.2e1 * t25 + 0.2e1 * t166
  t169 = f.my_piecewise5(t11, 0, t15, 0, t168)
  t173 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t160 * t161 + 0.5e1 / 0.3e1 * t23 * t169)
  t180 = t6 * t31 * t69 * t60
  t186 = 0.1e1 / t32 / t7
  t190 = t6 * t68 * t186 * t60 / 0.30e2
  t192 = t6 * t70 * t104
  t194 = t35 ** 2
  t197 = s0 / t37 / t194
  t204 = t93 ** 2
  t210 = t41 / t36 / t75
  t215 = s0 ** 2
  t238 = t52 ** 2
  t247 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t173 * t33 * t60 + t180 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t34 * t104 - t190 + t192 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t74 * (0.53777777777777777777777777777777777777777777777779e-1 * t197 * t49 + 0.29333333333333333333333333333333333333333333333334e-1 * t78 * t94 + 0.110e-1 * t40 / t81 / t48 * t204 - 0.55e-2 * t40 * t82 * (0.78711111111111111111111111111111111111111111111110e-1 * t210 * t45 + 0.16866666666666666666666666666666666666666666666667e0 * t197 * t90 - 0.44977777777777777777777777777777777777777777777777e-1 * t215 / t36 / t194 / t75 / t89 / t88) - 0.22400000000000000000000000000000000000000000000000e0 * t210 * t57 + 0.96000000000000000000000000000000000000000000000000e0 * t197 * t101 - 0.10240000000000000000000000000000000000000000000000e1 * t41 * s0 / t194 / t35 / t99 / t56 * t238))
  t248 = 0.1e1 / t115
  t249 = t118 ** 2
  t253 = f.my_piecewise5(t15, 0, t11, 0, -t168)
  t257 = f.my_piecewise3(t114, 0, 0.10e2 / 0.9e1 * t248 * t249 + 0.5e1 / 0.3e1 * t116 * t253)
  t264 = t6 * t121 * t69 * t147
  t269 = t6 * t152 * t186 * t147 / 0.30e2
  t271 = f.my_piecewise3(t111, 0, 0.3e1 / 0.20e2 * t6 * t257 * t33 * t147 + t264 / 0.5e1 - t269)
  d11 = 0.2e1 * t109 + 0.2e1 * t158 + t7 * (t247 + t271)
  t274 = -t8 - t26
  t275 = f.my_piecewise5(t11, 0, t15, 0, t274)
  t278 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t275)
  t279 = t278 * t33
  t284 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t279 * t60 + t73)
  t286 = f.my_piecewise5(t15, 0, t11, 0, -t274)
  t289 = f.my_piecewise3(t114, 0, 0.5e1 / 0.3e1 * t116 * t286)
  t290 = t289 * t33
  t294 = t152 * t33
  t295 = t123 * r1
  t298 = s2 / t125 / t295
  t301 = t136 ** 2
  t302 = 0.1e1 / t301
  t305 = t129 / t124 / t123
  t308 = 0.1e1 + t128
  t309 = jnp.sqrt(t308)
  t310 = 0.1e1 / t309
  t313 = -0.33733333333333333333333333333333333333333333333333e-1 * t305 * t133 - 0.33733333333333333333333333333333333333333333333333e-1 * t298 * t310
  t314 = t302 * t313
  t319 = t143 ** 2
  t321 = 0.1e1 / t319 * t52
  t324 = -0.14666666666666666666666666666666666666666666666667e-1 * t298 * t137 - 0.55e-2 * t128 * t314 + 0.96000000000000000000000000000000000000000000000000e-1 * t305 * t144 - 0.19200000000000000000000000000000000000000000000000e0 * t298 * t321
  t329 = f.my_piecewise3(t111, 0, 0.3e1 / 0.20e2 * t6 * t290 * t147 + t156 + 0.3e1 / 0.20e2 * t6 * t294 * t324)
  t333 = 0.2e1 * t166
  t334 = f.my_piecewise5(t11, 0, t15, 0, t333)
  t338 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t160 * t275 * t28 + 0.5e1 / 0.3e1 * t23 * t334)
  t345 = t6 * t278 * t69 * t60
  t353 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t338 * t33 * t60 + t345 / 0.10e2 + 0.3e1 / 0.20e2 * t6 * t279 * t104 + t180 / 0.10e2 - t190 + t192 / 0.10e2)
  t357 = f.my_piecewise5(t15, 0, t11, 0, -t333)
  t361 = f.my_piecewise3(t114, 0, 0.10e2 / 0.9e1 * t248 * t286 * t118 + 0.5e1 / 0.3e1 * t116 * t357)
  t368 = t6 * t289 * t69 * t147
  t375 = t6 * t153 * t324
  t378 = f.my_piecewise3(t111, 0, 0.3e1 / 0.20e2 * t6 * t361 * t33 * t147 + t368 / 0.10e2 + t264 / 0.10e2 - t269 + 0.3e1 / 0.20e2 * t6 * t122 * t324 + t375 / 0.10e2)
  d12 = t109 + t158 + t284 + t329 + t7 * (t353 + t378)
  t383 = t275 ** 2
  t387 = 0.2e1 * t25 + 0.2e1 * t166
  t388 = f.my_piecewise5(t11, 0, t15, 0, t387)
  t392 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t160 * t383 + 0.5e1 / 0.3e1 * t23 * t388)
  t399 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t392 * t33 * t60 + t345 / 0.5e1 - t190)
  t400 = t286 ** 2
  t404 = f.my_piecewise5(t15, 0, t11, 0, -t387)
  t408 = f.my_piecewise3(t114, 0, 0.10e2 / 0.9e1 * t248 * t400 + 0.5e1 / 0.3e1 * t116 * t404)
  t418 = t123 ** 2
  t421 = s2 / t125 / t418
  t428 = t313 ** 2
  t434 = t129 / t124 / t295
  t439 = s2 ** 2
  t470 = f.my_piecewise3(t111, 0, 0.3e1 / 0.20e2 * t6 * t408 * t33 * t147 + t368 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t290 * t324 - t269 + t375 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t294 * (0.53777777777777777777777777777777777777777777777779e-1 * t421 * t137 + 0.29333333333333333333333333333333333333333333333334e-1 * t298 * t314 + 0.110e-1 * t128 / t301 / t136 * t428 - 0.55e-2 * t128 * t302 * (0.78711111111111111111111111111111111111111111111110e-1 * t434 * t133 + 0.16866666666666666666666666666666666666666666666667e0 * t421 * t310 - 0.44977777777777777777777777777777777777777777777777e-1 * t439 / t124 / t418 / t295 / t309 / t308) - 0.22400000000000000000000000000000000000000000000000e0 * t434 * t144 + 0.96000000000000000000000000000000000000000000000000e0 * t421 * t321 - 0.10240000000000000000000000000000000000000000000000e1 * t129 * s2 / t418 / t123 / t319 / t143 * t238))
  d22 = 0.2e1 * t284 + 0.2e1 * t329 + t7 * (t399 + t470)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t22
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t27 = -t17 * t25 + t8
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t29 = t28 ** 2
  t32 = t22 ** 2
  t34 = 0.1e1 / t24 / t7
  t37 = 0.2e1 * t17 * t34 - 0.2e1 * t25
  t38 = f.my_piecewise5(t11, 0, t15, 0, t37)
  t42 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t23 * t29 + 0.5e1 / 0.3e1 * t32 * t38)
  t43 = t7 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = t42 * t44
  t46 = r0 ** 2
  t47 = r0 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t51 = s0 / t48 / t46
  t52 = jnp.sqrt(s0)
  t54 = 0.1e1 / t47 / r0
  t55 = t52 * t54
  t56 = jnp.asinh(t55)
  t59 = 0.1e1 + 0.253e-1 * t55 * t56
  t60 = 0.1e1 / t59
  t63 = 4 ** (0.1e1 / 0.3e1)
  t67 = 0.2e1 * t63 * t52 * t54 + 0.1e1
  t68 = 0.1e1 / t67
  t71 = 0.1e1 + 0.55e-2 * t51 * t60 - 0.72e-1 * t55 * t68
  t77 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t32 * t28)
  t78 = 0.1e1 / t43
  t79 = t77 * t78
  t83 = t77 * t44
  t84 = t46 * r0
  t87 = s0 / t48 / t84
  t90 = t59 ** 2
  t91 = 0.1e1 / t90
  t94 = t52 / t47 / t46
  t97 = 0.1e1 + t51
  t98 = jnp.sqrt(t97)
  t99 = 0.1e1 / t98
  t102 = -0.33733333333333333333333333333333333333333333333333e-1 * t94 * t56 - 0.33733333333333333333333333333333333333333333333333e-1 * t87 * t99
  t103 = t91 * t102
  t108 = t67 ** 2
  t110 = 0.1e1 / t108 * t63
  t113 = -0.14666666666666666666666666666666666666666666666667e-1 * t87 * t60 - 0.55e-2 * t51 * t103 + 0.96000000000000000000000000000000000000000000000000e-1 * t94 * t68 - 0.19200000000000000000000000000000000000000000000000e0 * t87 * t110
  t117 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t118 = t117 ** 2
  t119 = t118 * f.p.zeta_threshold
  t121 = f.my_piecewise3(t21, t119, t32 * t20)
  t123 = 0.1e1 / t43 / t7
  t124 = t121 * t123
  t128 = t121 * t78
  t132 = t121 * t44
  t133 = t46 ** 2
  t136 = s0 / t48 / t133
  t142 = 0.1e1 / t90 / t59
  t143 = t102 ** 2
  t144 = t142 * t143
  t149 = t52 / t47 / t84
  t154 = s0 ** 2
  t155 = t133 * t84
  t160 = 0.1e1 / t98 / t97
  t163 = 0.78711111111111111111111111111111111111111111111110e-1 * t149 * t56 + 0.16866666666666666666666666666666666666666666666667e0 * t136 * t99 - 0.44977777777777777777777777777777777777777777777777e-1 * t154 / t47 / t155 * t160
  t164 = t91 * t163
  t171 = t52 * s0
  t177 = t63 ** 2
  t178 = 0.1e1 / t108 / t67 * t177
  t181 = 0.53777777777777777777777777777777777777777777777779e-1 * t136 * t60 + 0.29333333333333333333333333333333333333333333333334e-1 * t87 * t103 + 0.110e-1 * t51 * t144 - 0.55e-2 * t51 * t164 - 0.22400000000000000000000000000000000000000000000000e0 * t149 * t68 + 0.96000000000000000000000000000000000000000000000000e0 * t136 * t110 - 0.10240000000000000000000000000000000000000000000000e1 * t171 / t133 / t46 * t178
  t186 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t45 * t71 + t6 * t79 * t71 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t83 * t113 - t6 * t124 * t71 / 0.30e2 + t6 * t128 * t113 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t132 * t181)
  t188 = r1 <= f.p.dens_threshold
  t189 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t190 = 0.1e1 + t189
  t191 = t190 <= f.p.zeta_threshold
  t192 = t190 ** (0.1e1 / 0.3e1)
  t193 = 0.1e1 / t192
  t195 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t196 = t195 ** 2
  t199 = t192 ** 2
  t201 = f.my_piecewise5(t15, 0, t11, 0, -t37)
  t205 = f.my_piecewise3(t191, 0, 0.10e2 / 0.9e1 * t193 * t196 + 0.5e1 / 0.3e1 * t199 * t201)
  t207 = r1 ** 2
  t208 = r1 ** (0.1e1 / 0.3e1)
  t209 = t208 ** 2
  t213 = jnp.sqrt(s2)
  t215 = 0.1e1 / t208 / r1
  t216 = t213 * t215
  t217 = jnp.asinh(t216)
  t231 = 0.1e1 + 0.55e-2 * s2 / t209 / t207 / (0.1e1 + 0.253e-1 * t216 * t217) - 0.72e-1 * t216 / (0.2e1 * t63 * t213 * t215 + 0.1e1)
  t237 = f.my_piecewise3(t191, 0, 0.5e1 / 0.3e1 * t199 * t195)
  t243 = f.my_piecewise3(t191, t119, t199 * t190)
  t249 = f.my_piecewise3(t188, 0, 0.3e1 / 0.20e2 * t6 * t205 * t44 * t231 + t6 * t237 * t78 * t231 / 0.5e1 - t6 * t243 * t123 * t231 / 0.30e2)
  t259 = t24 ** 2
  t263 = 0.6e1 * t34 - 0.6e1 * t17 / t259
  t264 = f.my_piecewise5(t11, 0, t15, 0, t263)
  t268 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 / t22 / t20 * t29 * t28 + 0.10e2 / 0.3e1 * t23 * t28 * t38 + 0.5e1 / 0.3e1 * t32 * t264)
  t291 = 0.1e1 / t43 / t24
  t305 = s0 / t48 / t133 / r0
  t314 = t90 ** 2
  t326 = t52 / t47 / t133
  t331 = t133 ** 2
  t334 = t154 / t47 / t331
  t341 = t97 ** 2
  t358 = t108 ** 2
  t362 = -0.25096296296296296296296296296296296296296296296297e0 * t305 * t60 - 0.16133333333333333333333333333333333333333333333334e0 * t136 * t103 - 0.88000000000000000000000000000000000000000000000001e-1 * t87 * t144 + 0.44000000000000000000000000000000000000000000000001e-1 * t87 * t164 - 0.330e-1 * t51 / t314 * t143 * t102 + 0.330e-1 * t51 * t142 * t102 * t163 - 0.55e-2 * t51 * t91 * (-0.26237037037037037037037037037037037037037037037037e0 * t326 * t56 - 0.89205925925925925925925925925925925925925925925928e0 * t305 * t99 + 0.55472592592592592592592592592592592592592592592592e0 * t334 * t160 - 0.17991111111111111111111111111111111111111111111111e0 * t154 * s0 / t331 / t84 / t98 / t341) + 0.74666666666666666666666666666666666666666666666667e0 * t326 * t68 - 0.50773333333333333333333333333333333333333333333333e1 * t305 * t110 + 0.11264000000000000000000000000000000000000000000000e2 * t171 / t155 * t178 - 0.32768000000000000000000000000000000000000000000000e2 * t334 / t358
  t367 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t268 * t44 * t71 + 0.3e1 / 0.10e2 * t6 * t42 * t78 * t71 + 0.9e1 / 0.20e2 * t6 * t45 * t113 - t6 * t77 * t123 * t71 / 0.10e2 + 0.3e1 / 0.5e1 * t6 * t79 * t113 + 0.9e1 / 0.20e2 * t6 * t83 * t181 + 0.2e1 / 0.45e2 * t6 * t121 * t291 * t71 - t6 * t124 * t113 / 0.10e2 + 0.3e1 / 0.10e2 * t6 * t128 * t181 + 0.3e1 / 0.20e2 * t6 * t132 * t362)
  t377 = f.my_piecewise5(t15, 0, t11, 0, -t263)
  t381 = f.my_piecewise3(t191, 0, -0.10e2 / 0.27e2 / t192 / t190 * t196 * t195 + 0.10e2 / 0.3e1 * t193 * t195 * t201 + 0.5e1 / 0.3e1 * t199 * t377)
  t399 = f.my_piecewise3(t188, 0, 0.3e1 / 0.20e2 * t6 * t381 * t44 * t231 + 0.3e1 / 0.10e2 * t6 * t205 * t78 * t231 - t6 * t237 * t123 * t231 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t243 * t291 * t231)
  d111 = 0.3e1 * t186 + 0.3e1 * t249 + t7 * (t367 + t399)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t20
  t25 = t7 ** 2
  t26 = 0.1e1 / t25
  t28 = -t17 * t26 + t8
  t29 = f.my_piecewise5(t11, 0, t15, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t7
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t17 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t11, 0, t15, 0, t40)
  t44 = t22 ** 2
  t45 = t25 ** 2
  t46 = 0.1e1 / t45
  t49 = -0.6e1 * t17 * t46 + 0.6e1 * t37
  t50 = f.my_piecewise5(t11, 0, t15, 0, t49)
  t54 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t24 * t30 * t29 + 0.10e2 / 0.3e1 * t35 * t41 + 0.5e1 / 0.3e1 * t44 * t50)
  t55 = t7 ** (0.1e1 / 0.3e1)
  t56 = t55 ** 2
  t57 = t54 * t56
  t58 = r0 ** 2
  t59 = r0 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t63 = s0 / t60 / t58
  t64 = jnp.sqrt(s0)
  t66 = 0.1e1 / t59 / r0
  t67 = t64 * t66
  t68 = jnp.asinh(t67)
  t71 = 0.1e1 + 0.253e-1 * t67 * t68
  t72 = 0.1e1 / t71
  t75 = 4 ** (0.1e1 / 0.3e1)
  t79 = 0.2e1 * t75 * t64 * t66 + 0.1e1
  t80 = 0.1e1 / t79
  t83 = 0.1e1 + 0.55e-2 * t63 * t72 - 0.72e-1 * t67 * t80
  t92 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t34 * t30 + 0.5e1 / 0.3e1 * t44 * t41)
  t93 = 0.1e1 / t55
  t94 = t92 * t93
  t98 = t92 * t56
  t99 = t58 * r0
  t102 = s0 / t60 / t99
  t105 = t71 ** 2
  t106 = 0.1e1 / t105
  t109 = t64 / t59 / t58
  t112 = 0.1e1 + t63
  t113 = jnp.sqrt(t112)
  t114 = 0.1e1 / t113
  t117 = -0.33733333333333333333333333333333333333333333333333e-1 * t109 * t68 - 0.33733333333333333333333333333333333333333333333333e-1 * t102 * t114
  t118 = t106 * t117
  t123 = t79 ** 2
  t125 = 0.1e1 / t123 * t75
  t128 = -0.14666666666666666666666666666666666666666666666667e-1 * t102 * t72 - 0.55e-2 * t63 * t118 + 0.96000000000000000000000000000000000000000000000000e-1 * t109 * t80 - 0.19200000000000000000000000000000000000000000000000e0 * t102 * t125
  t134 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t44 * t29)
  t136 = 0.1e1 / t55 / t7
  t137 = t134 * t136
  t141 = t134 * t93
  t145 = t134 * t56
  t146 = t58 ** 2
  t149 = s0 / t60 / t146
  t155 = 0.1e1 / t105 / t71
  t156 = t117 ** 2
  t157 = t155 * t156
  t162 = t64 / t59 / t99
  t167 = s0 ** 2
  t168 = t146 * t99
  t173 = 0.1e1 / t113 / t112
  t176 = 0.78711111111111111111111111111111111111111111111110e-1 * t162 * t68 + 0.16866666666666666666666666666666666666666666666667e0 * t149 * t114 - 0.44977777777777777777777777777777777777777777777777e-1 * t167 / t59 / t168 * t173
  t177 = t106 * t176
  t184 = t64 * s0
  t185 = t146 * t58
  t190 = t75 ** 2
  t191 = 0.1e1 / t123 / t79 * t190
  t194 = 0.53777777777777777777777777777777777777777777777779e-1 * t149 * t72 + 0.29333333333333333333333333333333333333333333333334e-1 * t102 * t118 + 0.110e-1 * t63 * t157 - 0.55e-2 * t63 * t177 - 0.22400000000000000000000000000000000000000000000000e0 * t162 * t80 + 0.96000000000000000000000000000000000000000000000000e0 * t149 * t125 - 0.10240000000000000000000000000000000000000000000000e1 * t184 / t185 * t191
  t198 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t199 = t198 ** 2
  t200 = t199 * f.p.zeta_threshold
  t202 = f.my_piecewise3(t21, t200, t44 * t20)
  t204 = 0.1e1 / t55 / t25
  t205 = t202 * t204
  t209 = t202 * t136
  t213 = t202 * t93
  t217 = t202 * t56
  t218 = t146 * r0
  t221 = s0 / t60 / t218
  t230 = t105 ** 2
  t231 = 0.1e1 / t230
  t233 = t231 * t156 * t117
  t236 = t155 * t117
  t237 = t236 * t176
  t242 = t64 / t59 / t146
  t247 = t146 ** 2
  t250 = t167 / t59 / t247
  t253 = t167 * s0
  t257 = t112 ** 2
  t259 = 0.1e1 / t113 / t257
  t262 = -0.26237037037037037037037037037037037037037037037037e0 * t242 * t68 - 0.89205925925925925925925925925925925925925925925928e0 * t221 * t114 + 0.55472592592592592592592592592592592592592592592592e0 * t250 * t173 - 0.17991111111111111111111111111111111111111111111111e0 * t253 / t247 / t99 * t259
  t263 = t106 * t262
  t274 = t123 ** 2
  t275 = 0.1e1 / t274
  t278 = -0.25096296296296296296296296296296296296296296296297e0 * t221 * t72 - 0.16133333333333333333333333333333333333333333333334e0 * t149 * t118 - 0.88000000000000000000000000000000000000000000000001e-1 * t102 * t157 + 0.44000000000000000000000000000000000000000000000001e-1 * t102 * t177 - 0.330e-1 * t63 * t233 + 0.330e-1 * t63 * t237 - 0.55e-2 * t63 * t263 + 0.74666666666666666666666666666666666666666666666667e0 * t242 * t80 - 0.50773333333333333333333333333333333333333333333333e1 * t221 * t125 + 0.11264000000000000000000000000000000000000000000000e2 * t184 / t168 * t191 - 0.32768000000000000000000000000000000000000000000000e2 * t250 * t275
  t283 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t57 * t83 + 0.3e1 / 0.10e2 * t6 * t94 * t83 + 0.9e1 / 0.20e2 * t6 * t98 * t128 - t6 * t137 * t83 / 0.10e2 + 0.3e1 / 0.5e1 * t6 * t141 * t128 + 0.9e1 / 0.20e2 * t6 * t145 * t194 + 0.2e1 / 0.45e2 * t6 * t205 * t83 - t6 * t209 * t128 / 0.10e2 + 0.3e1 / 0.10e2 * t6 * t213 * t194 + 0.3e1 / 0.20e2 * t6 * t217 * t278)
  t285 = r1 <= f.p.dens_threshold
  t286 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t287 = 0.1e1 + t286
  t288 = t287 <= f.p.zeta_threshold
  t289 = t287 ** (0.1e1 / 0.3e1)
  t291 = 0.1e1 / t289 / t287
  t293 = f.my_piecewise5(t15, 0, t11, 0, -t28)
  t294 = t293 ** 2
  t298 = 0.1e1 / t289
  t299 = t298 * t293
  t301 = f.my_piecewise5(t15, 0, t11, 0, -t40)
  t304 = t289 ** 2
  t306 = f.my_piecewise5(t15, 0, t11, 0, -t49)
  t310 = f.my_piecewise3(t288, 0, -0.10e2 / 0.27e2 * t291 * t294 * t293 + 0.10e2 / 0.3e1 * t299 * t301 + 0.5e1 / 0.3e1 * t304 * t306)
  t312 = r1 ** 2
  t313 = r1 ** (0.1e1 / 0.3e1)
  t314 = t313 ** 2
  t318 = jnp.sqrt(s2)
  t320 = 0.1e1 / t313 / r1
  t321 = t318 * t320
  t322 = jnp.asinh(t321)
  t336 = 0.1e1 + 0.55e-2 * s2 / t314 / t312 / (0.1e1 + 0.253e-1 * t321 * t322) - 0.72e-1 * t321 / (0.2e1 * t75 * t318 * t320 + 0.1e1)
  t345 = f.my_piecewise3(t288, 0, 0.10e2 / 0.9e1 * t298 * t294 + 0.5e1 / 0.3e1 * t304 * t301)
  t352 = f.my_piecewise3(t288, 0, 0.5e1 / 0.3e1 * t304 * t293)
  t358 = f.my_piecewise3(t288, t200, t304 * t287)
  t364 = f.my_piecewise3(t285, 0, 0.3e1 / 0.20e2 * t6 * t310 * t56 * t336 + 0.3e1 / 0.10e2 * t6 * t345 * t93 * t336 - t6 * t352 * t136 * t336 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t358 * t204 * t336)
  t374 = s0 / t60 / t185
  t394 = t167 / t59 / t247 / r0
  t399 = t64 / t59 / t218
  t411 = t167 ** 2
  t437 = t156 ** 2
  t445 = t176 ** 2
  t458 = 0.30762666666666666666666666666666666666666666666666e2 * t374 * t125 - 0.10592711111111111111111111111111111111111111111111e3 * t184 / t247 * t191 - 0.34952533333333333333333333333333333333333333333333e3 * t64 * t167 / t60 / t247 / t58 / t274 / t79 * t75 + 0.63351466666666666666666666666666666666666666666667e3 * t394 * t275 - 0.55e-2 * t63 * t106 * (0.11369382716049382716049382716049382716049382716049e1 * t399 * t68 + 0.54048296296296296296296296296296296296296296296297e1 * t374 * t114 - 0.58121283950617283950617283950617283950617283950617e1 * t394 * t173 + 0.41979259259259259259259259259259259259259259259259e1 * t253 / t247 / t146 * t259 - 0.11994074074074074074074074074074074074074074074074e1 * t411 / t60 / t247 / t185 / t113 / t257 / t112) - 0.32355555555555555555555555555555555555555555555556e1 * t399 * t80 + 0.58666666666666666666666666666666666666666666666668e-1 * t102 * t263 + 0.14221234567901234567901234567901234567901234567902e1 * t374 * t72 + 0.10038518518518518518518518518518518518518518518519e1 * t221 * t118 - 0.32266666666666666666666666666666666666666666666668e0 * t149 * t177 + 0.1320e0 * t63 / t230 / t71 * t437 - 0.1980e0 * t63 * t231 * t156 * t176 + 0.330e-1 * t63 * t155 * t445 + 0.440e-1 * t63 * t236 * t262 + 0.64533333333333333333333333333333333333333333333335e0 * t149 * t157 + 0.35200000000000000000000000000000000000000000000000e0 * t102 * t233 - 0.35200000000000000000000000000000000000000000000000e0 * t102 * t237
  t474 = t20 ** 2
  t477 = t30 ** 2
  t483 = t41 ** 2
  t492 = -0.24e2 * t46 + 0.24e2 * t17 / t45 / t7
  t493 = f.my_piecewise5(t11, 0, t15, 0, t492)
  t497 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t22 / t474 * t477 - 0.20e2 / 0.9e1 * t24 * t30 * t41 + 0.10e2 / 0.3e1 * t34 * t483 + 0.40e2 / 0.9e1 * t35 * t50 + 0.5e1 / 0.3e1 * t44 * t493)
  t524 = 0.1e1 / t55 / t36
  t529 = -t6 * t209 * t194 / 0.5e1 + 0.2e1 / 0.5e1 * t6 * t213 * t278 + 0.3e1 / 0.20e2 * t6 * t217 * t458 - 0.2e1 / 0.5e1 * t6 * t137 * t128 + 0.6e1 / 0.5e1 * t6 * t141 * t194 + 0.3e1 / 0.5e1 * t6 * t145 * t278 + 0.8e1 / 0.45e2 * t6 * t205 * t128 + 0.3e1 / 0.20e2 * t6 * t497 * t56 * t83 + 0.3e1 / 0.5e1 * t6 * t57 * t128 + 0.6e1 / 0.5e1 * t6 * t94 * t128 + 0.9e1 / 0.10e2 * t6 * t98 * t194 + 0.2e1 / 0.5e1 * t6 * t54 * t93 * t83 - t6 * t92 * t136 * t83 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t134 * t204 * t83 - 0.14e2 / 0.135e3 * t6 * t202 * t524 * t83
  t530 = f.my_piecewise3(t1, 0, t529)
  t531 = t287 ** 2
  t534 = t294 ** 2
  t540 = t301 ** 2
  t546 = f.my_piecewise5(t15, 0, t11, 0, -t492)
  t550 = f.my_piecewise3(t288, 0, 0.40e2 / 0.81e2 / t289 / t531 * t534 - 0.20e2 / 0.9e1 * t291 * t294 * t301 + 0.10e2 / 0.3e1 * t298 * t540 + 0.40e2 / 0.9e1 * t299 * t306 + 0.5e1 / 0.3e1 * t304 * t546)
  t572 = f.my_piecewise3(t285, 0, 0.3e1 / 0.20e2 * t6 * t550 * t56 * t336 + 0.2e1 / 0.5e1 * t6 * t310 * t93 * t336 - t6 * t345 * t136 * t336 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t352 * t204 * t336 - 0.14e2 / 0.135e3 * t6 * t358 * t524 * t336)
  d1111 = 0.4e1 * t283 + 0.4e1 * t364 + t7 * (t530 + t572)

  res = {'v4rho4': d1111}
  return res
