"""Generated from gga_x_2d_b88.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  _2d_b88_beta = 0.007

  _2d_b88_csi = 8

  _2d_b88_f = lambda x: 1 + _2d_b88_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b88_csi * _2d_b88_beta * x * jnp.arcsinh(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b88_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  _2d_b88_beta = 0.007

  _2d_b88_csi = 8

  _2d_b88_f = lambda x: 1 + _2d_b88_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b88_csi * _2d_b88_beta * x * jnp.arcsinh(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b88_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  _2d_b88_beta = 0.007

  _2d_b88_csi = 8

  _2d_b88_f = lambda x: 1 + _2d_b88_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b88_csi * _2d_b88_beta * x * jnp.arcsinh(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b88_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = jnp.sqrt(jnp.pi)
  t29 = t28 * s0
  t30 = r0 ** 2
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / t30
  t35 = jnp.sqrt(s0)
  t37 = 0.1e1 / t31 / r0
  t38 = t35 * t37
  t39 = jnp.arcsinh(t38)
  t42 = 0.1e1 + 0.56e-1 * t38 * t39
  t43 = 0.1e1 / t42
  t47 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t29 * t34 * t43
  t51 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t47)
  t52 = r1 <= f.p.dens_threshold
  t53 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t54 = 0.1e1 + t53
  t55 = t54 <= f.p.zeta_threshold
  t56 = t54 ** (0.1e1 / 0.3e1)
  t58 = f.my_piecewise3(t55, t22, t56 * t54)
  t59 = t58 * t26
  t60 = t28 * s2
  t61 = r1 ** 2
  t62 = r1 ** (0.1e1 / 0.3e1)
  t63 = t62 ** 2
  t65 = 0.1e1 / t63 / t61
  t66 = jnp.sqrt(s2)
  t68 = 0.1e1 / t62 / r1
  t69 = t66 * t68
  t70 = jnp.arcsinh(t69)
  t73 = 0.1e1 + 0.56e-1 * t69 * t70
  t74 = 0.1e1 / t73
  t78 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t60 * t65 * t74
  t82 = f.my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t59 * t78)
  t83 = t6 ** 2
  t85 = t16 / t83
  t86 = t7 - t85
  t87 = f.my_piecewise5(t10, 0, t14, 0, t86)
  t90 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t87)
  t95 = t26 ** 2
  t96 = 0.1e1 / t95
  t100 = t5 * t25 * t96 * t47 / 0.8e1
  t103 = 0.1e1 / t32 / t30 / r0
  t107 = t42 ** 2
  t109 = t34 / t107
  t118 = jnp.sqrt(s0 * t34 + 0.1e1)
  t119 = 0.1e1 / t118
  t131 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t90 * t26 * t47 - t100 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.70000000000000000000000000000000000000000000000000e-2 * t29 * t103 * t43 - 0.26250000000000000000000000000000000000000000000000e-2 * t29 * t109 * (-0.74666666666666666666666666666666666666666666666666e-1 * t35 / t31 / t30 * t39 - 0.74666666666666666666666666666666666666666666666666e-1 * s0 * t103 * t119)))
  t133 = f.my_piecewise5(t14, 0, t10, 0, -t86)
  t136 = f.my_piecewise3(t55, 0, 0.4e1 / 0.3e1 * t56 * t133)
  t144 = t5 * t58 * t96 * t78 / 0.8e1
  t146 = f.my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t136 * t26 * t78 - t144)
  vrho_0_ = t51 + t82 + t6 * (t131 + t146)
  t149 = -t7 - t85
  t150 = f.my_piecewise5(t10, 0, t14, 0, t149)
  t153 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t150)
  t159 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t153 * t26 * t47 - t100)
  t161 = f.my_piecewise5(t14, 0, t10, 0, -t149)
  t164 = f.my_piecewise3(t55, 0, 0.4e1 / 0.3e1 * t56 * t161)
  t171 = 0.1e1 / t63 / t61 / r1
  t175 = t73 ** 2
  t177 = t65 / t175
  t186 = jnp.sqrt(s2 * t65 + 0.1e1)
  t187 = 0.1e1 / t186
  t199 = f.my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t164 * t26 * t78 - t144 - 0.3e1 / 0.8e1 * t5 * t59 * (-0.70000000000000000000000000000000000000000000000000e-2 * t60 * t171 * t74 - 0.26250000000000000000000000000000000000000000000000e-2 * t60 * t177 * (-0.74666666666666666666666666666666666666666666666666e-1 * t66 / t62 / t61 * t70 - 0.74666666666666666666666666666666666666666666666666e-1 * s2 * t171 * t187)))
  vrho_1_ = t51 + t82 + t6 * (t159 + t199)
  t219 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.26250000000000000000000000000000000000000000000000e-2 * t28 * t34 * t43 - 0.26250000000000000000000000000000000000000000000000e-2 * t29 * t109 * (0.28000000000000000000000000000000000000000000000000e-1 / t35 * t37 * t39 + 0.28000000000000000000000000000000000000000000000000e-1 * t34 * t119)))
  vsigma_0_ = t6 * t219
  vsigma_1_ = 0.0e0
  t237 = f.my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t59 * (0.26250000000000000000000000000000000000000000000000e-2 * t28 * t65 * t74 - 0.26250000000000000000000000000000000000000000000000e-2 * t60 * t177 * (0.28000000000000000000000000000000000000000000000000e-1 / t66 * t68 * t70 + 0.28000000000000000000000000000000000000000000000000e-1 * t65 * t187)))
  vsigma_2_ = t6 * t237
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  _2d_b88_beta = 0.007

  _2d_b88_csi = 8

  _2d_b88_f = lambda x: 1 + _2d_b88_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b88_csi * _2d_b88_beta * x * jnp.arcsinh(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b88_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = jnp.sqrt(jnp.pi)
  t21 = t20 * s0
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = r0 ** 2
  t25 = t18 ** 2
  t27 = 0.1e1 / t25 / t24
  t28 = t23 * t27
  t29 = jnp.sqrt(s0)
  t30 = t29 * t22
  t32 = 0.1e1 / t18 / r0
  t34 = jnp.arcsinh(t30 * t32)
  t35 = t32 * t34
  t38 = 0.1e1 + 0.56e-1 * t30 * t35
  t39 = 0.1e1 / t38
  t43 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t21 * t28 * t39
  t47 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t43)
  t55 = 0.1e1 / t25 / t24 / r0
  t60 = t21 * t23
  t61 = t38 ** 2
  t63 = t27 / t61
  t69 = s0 * t23
  t72 = jnp.sqrt(t69 * t27 + 0.1e1)
  t73 = 0.1e1 / t72
  t86 = f.my_piecewise3(t2, 0, -t6 * t17 / t25 * t43 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.70000000000000000000000000000000000000000000000000e-2 * t21 * t23 * t55 * t39 - 0.26250000000000000000000000000000000000000000000000e-2 * t60 * t63 * (-0.74666666666666666666666666666666666666666666666666e-1 * t30 / t18 / t24 * t34 - 0.74666666666666666666666666666666666666666666666666e-1 * t69 * t55 * t73)))
  vrho_0_ = 0.2e1 * r0 * t86 + 0.2e1 * t47
  t107 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.26250000000000000000000000000000000000000000000000e-2 * t20 * t23 * t27 * t39 - 0.26250000000000000000000000000000000000000000000000e-2 * t60 * t63 * (0.28000000000000000000000000000000000000000000000000e-1 / t29 * t22 * t35 + 0.28000000000000000000000000000000000000000000000000e-1 * t28 * t73)))
  vsigma_0_ = 0.2e1 * r0 * t107
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = jnp.sqrt(jnp.pi)
  t23 = t22 * s0
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = r0 ** 2
  t28 = 0.1e1 / t19 / t26
  t29 = t25 * t28
  t30 = jnp.sqrt(s0)
  t31 = t30 * t24
  t33 = 0.1e1 / t18 / r0
  t35 = jnp.arcsinh(t31 * t33)
  t36 = t33 * t35
  t39 = 0.1e1 + 0.56e-1 * t31 * t36
  t40 = 0.1e1 / t39
  t44 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t23 * t29 * t40
  t48 = t17 * t18
  t49 = t26 * r0
  t51 = 0.1e1 / t19 / t49
  t52 = t25 * t51
  t56 = t23 * t25
  t57 = t39 ** 2
  t58 = 0.1e1 / t57
  t59 = t28 * t58
  t62 = 0.1e1 / t18 / t26 * t35
  t65 = s0 * t25
  t67 = t65 * t28 + 0.1e1
  t68 = jnp.sqrt(t67)
  t69 = 0.1e1 / t68
  t73 = -0.74666666666666666666666666666666666666666666666666e-1 * t31 * t62 - 0.74666666666666666666666666666666666666666666666666e-1 * t65 * t51 * t69
  t74 = t59 * t73
  t77 = -0.70000000000000000000000000000000000000000000000000e-2 * t23 * t52 * t40 - 0.26250000000000000000000000000000000000000000000000e-2 * t56 * t74
  t82 = f.my_piecewise3(t2, 0, -t6 * t21 * t44 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t48 * t77)
  t93 = t26 ** 2
  t95 = 0.1e1 / t19 / t93
  t100 = t51 * t58
  t106 = t28 / t57 / t39
  t107 = t73 ** 2
  t119 = s0 ** 2
  t125 = 0.1e1 / t68 / t67
  t138 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t44 / 0.12e2 - t6 * t21 * t77 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t48 * (0.25666666666666666666666666666666666666666666666667e-1 * t23 * t25 * t95 * t40 + 0.14000000000000000000000000000000000000000000000000e-1 * t56 * t100 * t73 + 0.52500000000000000000000000000000000000000000000000e-2 * t56 * t106 * t107 - 0.26250000000000000000000000000000000000000000000000e-2 * t56 * t59 * (0.17422222222222222222222222222222222222222222222222e0 * t31 / t18 / t49 * t35 + 0.37333333333333333333333333333333333333333333333333e0 * t65 * t95 * t69 - 0.19911111111111111111111111111111111111111111111111e0 * t119 * t24 / t18 / t93 / t49 * t125)))
  v2rho2_0_ = 0.2e1 * r0 * t138 + 0.4e1 * t82
  t141 = t22 * t25
  t146 = 0.1e1 / t30 * t24
  t151 = 0.28000000000000000000000000000000000000000000000000e-1 * t146 * t36 + 0.28000000000000000000000000000000000000000000000000e-1 * t29 * t69
  t152 = t59 * t151
  t155 = 0.26250000000000000000000000000000000000000000000000e-2 * t141 * t28 * t40 - 0.26250000000000000000000000000000000000000000000000e-2 * t56 * t152
  t159 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t48 * t155)
  t195 = f.my_piecewise3(t2, 0, -t6 * t21 * t155 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t48 * (-0.70000000000000000000000000000000000000000000000000e-2 * t141 * t51 * t40 - 0.26250000000000000000000000000000000000000000000000e-2 * t141 * t74 + 0.70000000000000000000000000000000000000000000000000e-2 * t56 * t100 * t151 + 0.52500000000000000000000000000000000000000000000000e-2 * t56 * t106 * t151 * t73 - 0.26250000000000000000000000000000000000000000000000e-2 * t56 * t59 * (-0.37333333333333333333333333333333333333333333333333e-1 * t146 * t62 - 0.11200000000000000000000000000000000000000000000000e0 * t52 * t69 + 0.74666666666666666666666666666666666666666666666667e-1 * t24 / t18 / t93 / t26 * t125 * s0)))
  v2rhosigma_0_ = 0.2e1 * r0 * t195 + 0.2e1 * t159
  t200 = t151 ** 2
  t228 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t48 * (-0.52500000000000000000000000000000000000000000000000e-2 * t141 * t152 + 0.52500000000000000000000000000000000000000000000000e-2 * t56 * t106 * t200 - 0.26250000000000000000000000000000000000000000000000e-2 * t56 * t59 * (-0.14000000000000000000000000000000000000000000000000e-1 / t30 / s0 * t24 * t36 + 0.14000000000000000000000000000000000000000000000000e-1 / s0 * t25 * t28 * t69 - 0.28000000000000000000000000000000000000000000000000e-1 * t24 / t18 / t93 / r0 * t125)))
  v2sigma2_0_ = 0.2e1 * r0 * t228
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = jnp.sqrt(jnp.pi)
  t24 = t23 * s0
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = r0 ** 2
  t29 = 0.1e1 / t19 / t27
  t31 = jnp.sqrt(s0)
  t32 = t31 * t25
  t34 = 0.1e1 / t18 / r0
  t36 = jnp.asinh(t32 * t34)
  t40 = 0.1e1 + 0.56e-1 * t32 * t34 * t36
  t41 = 0.1e1 / t40
  t45 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t24 * t26 * t29 * t41
  t50 = t17 / t19
  t51 = t27 * r0
  t53 = 0.1e1 / t19 / t51
  t58 = t24 * t26
  t59 = t40 ** 2
  t60 = 0.1e1 / t59
  t61 = t29 * t60
  t67 = s0 * t26
  t69 = t67 * t29 + 0.1e1
  t70 = jnp.sqrt(t69)
  t71 = 0.1e1 / t70
  t75 = -0.74666666666666666666666666666666666666666666666666e-1 * t32 / t18 / t27 * t36 - 0.74666666666666666666666666666666666666666666666666e-1 * t67 * t53 * t71
  t79 = -0.70000000000000000000000000000000000000000000000000e-2 * t24 * t26 * t53 * t41 - 0.26250000000000000000000000000000000000000000000000e-2 * t58 * t61 * t75
  t83 = t17 * t18
  t84 = t27 ** 2
  t86 = 0.1e1 / t19 / t84
  t91 = t53 * t60
  t96 = 0.1e1 / t59 / t40
  t97 = t29 * t96
  t98 = t75 ** 2
  t110 = s0 ** 2
  t111 = t110 * t25
  t116 = 0.1e1 / t70 / t69
  t120 = 0.17422222222222222222222222222222222222222222222222e0 * t32 / t18 / t51 * t36 + 0.37333333333333333333333333333333333333333333333333e0 * t67 * t86 * t71 - 0.19911111111111111111111111111111111111111111111111e0 * t111 / t18 / t84 / t51 * t116
  t124 = 0.25666666666666666666666666666666666666666666666667e-1 * t24 * t26 * t86 * t41 + 0.14000000000000000000000000000000000000000000000000e-1 * t58 * t91 * t75 + 0.52500000000000000000000000000000000000000000000000e-2 * t58 * t97 * t98 - 0.26250000000000000000000000000000000000000000000000e-2 * t58 * t61 * t120
  t129 = f.my_piecewise3(t2, 0, t6 * t22 * t45 / 0.12e2 - t6 * t50 * t79 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t83 * t124)
  t143 = 0.1e1 / t19 / t84 / r0
  t159 = t59 ** 2
  t178 = t84 ** 2
  t188 = t69 ** 2
  t202 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t29 * t45 + t6 * t22 * t79 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t50 * t124 - 0.3e1 / 0.8e1 * t6 * t83 * (-0.11977777777777777777777777777777777777777777777778e0 * t24 * t26 * t143 * t41 - 0.77000000000000000000000000000000000000000000000000e-1 * t58 * t86 * t60 * t75 - 0.42000000000000000000000000000000000000000000000000e-1 * t58 * t53 * t96 * t98 + 0.21000000000000000000000000000000000000000000000000e-1 * t58 * t91 * t120 - 0.15750000000000000000000000000000000000000000000000e-1 * t58 * t29 / t159 * t98 * t75 + 0.15750000000000000000000000000000000000000000000000e-1 * t58 * t97 * t75 * t120 - 0.26250000000000000000000000000000000000000000000000e-2 * t58 * t61 * (-0.58074074074074074074074074074074074074074074074073e0 * t32 / t18 / t84 * t36 - 0.19745185185185185185185185185185185185185185185185e1 * t67 * t143 * t71 + 0.24557037037037037037037037037037037037037037037036e1 * t111 / t18 / t178 * t116 - 0.15928888888888888888888888888888888888888888888889e1 * t110 * s0 / t178 / t51 / t70 / t188)))
  v3rho3_0_ = 0.2e1 * r0 * t202 + 0.6e1 * t129

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = jnp.sqrt(jnp.pi)
  t25 = t24 * s0
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = jnp.sqrt(s0)
  t30 = t29 * t26
  t32 = 0.1e1 / t19 / r0
  t34 = jnp.asinh(t30 * t32)
  t38 = 0.1e1 + 0.56e-1 * t30 * t32 * t34
  t39 = 0.1e1 / t38
  t43 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t25 * t27 * t22 * t39
  t49 = t17 / t20 / r0
  t50 = t18 * r0
  t52 = 0.1e1 / t20 / t50
  t57 = t25 * t27
  t58 = t38 ** 2
  t59 = 0.1e1 / t58
  t60 = t22 * t59
  t66 = s0 * t27
  t68 = t66 * t22 + 0.1e1
  t69 = jnp.sqrt(t68)
  t70 = 0.1e1 / t69
  t74 = -0.74666666666666666666666666666666666666666666666666e-1 * t30 / t19 / t18 * t34 - 0.74666666666666666666666666666666666666666666666666e-1 * t66 * t52 * t70
  t78 = -0.70000000000000000000000000000000000000000000000000e-2 * t25 * t27 * t52 * t39 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t60 * t74
  t83 = t17 / t20
  t84 = t18 ** 2
  t86 = 0.1e1 / t20 / t84
  t91 = t52 * t59
  t96 = 0.1e1 / t58 / t38
  t97 = t22 * t96
  t98 = t74 ** 2
  t110 = s0 ** 2
  t111 = t110 * t26
  t116 = 0.1e1 / t69 / t68
  t120 = 0.17422222222222222222222222222222222222222222222222e0 * t30 / t19 / t50 * t34 + 0.37333333333333333333333333333333333333333333333333e0 * t66 * t86 * t70 - 0.19911111111111111111111111111111111111111111111111e0 * t111 / t19 / t84 / t50 * t116
  t124 = 0.25666666666666666666666666666666666666666666666667e-1 * t25 * t27 * t86 * t39 + 0.14000000000000000000000000000000000000000000000000e-1 * t57 * t91 * t74 + 0.52500000000000000000000000000000000000000000000000e-2 * t57 * t97 * t98 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t60 * t120
  t128 = t17 * t19
  t129 = t84 * r0
  t131 = 0.1e1 / t20 / t129
  t136 = t86 * t59
  t140 = t52 * t96
  t147 = t58 ** 2
  t148 = 0.1e1 / t147
  t149 = t22 * t148
  t150 = t98 * t74
  t154 = t74 * t120
  t166 = t84 ** 2
  t172 = t110 * s0
  t176 = t68 ** 2
  t178 = 0.1e1 / t69 / t176
  t181 = -0.58074074074074074074074074074074074074074074074073e0 * t30 / t19 / t84 * t34 - 0.19745185185185185185185185185185185185185185185185e1 * t66 * t131 * t70 + 0.24557037037037037037037037037037037037037037037036e1 * t111 / t19 / t166 * t116 - 0.15928888888888888888888888888888888888888888888889e1 * t172 / t166 / t50 * t178
  t185 = -0.11977777777777777777777777777777777777777777777778e0 * t25 * t27 * t131 * t39 - 0.77000000000000000000000000000000000000000000000000e-1 * t57 * t136 * t74 - 0.42000000000000000000000000000000000000000000000000e-1 * t57 * t140 * t98 + 0.21000000000000000000000000000000000000000000000000e-1 * t57 * t91 * t120 - 0.15750000000000000000000000000000000000000000000000e-1 * t57 * t149 * t150 + 0.15750000000000000000000000000000000000000000000000e-1 * t57 * t97 * t154 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t60 * t181
  t190 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t43 + t6 * t49 * t78 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t83 * t124 - 0.3e1 / 0.8e1 * t6 * t128 * t185)
  t205 = t84 * t18
  t207 = 0.1e1 / t20 / t205
  t236 = t98 ** 2
  t244 = t120 ** 2
  t271 = t110 ** 2
  t286 = 0.67874074074074074074074074074074074074074074074075e0 * t25 * t27 * t207 * t39 + 0.47911111111111111111111111111111111111111111111111e0 * t57 * t131 * t59 * t74 + 0.30800000000000000000000000000000000000000000000000e0 * t57 * t86 * t96 * t98 - 0.15400000000000000000000000000000000000000000000000e0 * t57 * t136 * t120 + 0.16800000000000000000000000000000000000000000000000e0 * t57 * t52 * t148 * t150 - 0.16800000000000000000000000000000000000000000000000e0 * t57 * t140 * t154 + 0.28000000000000000000000000000000000000000000000000e-1 * t57 * t91 * t181 + 0.63000000000000000000000000000000000000000000000000e-1 * t57 * t22 / t147 / t38 * t236 - 0.94500000000000000000000000000000000000000000000000e-1 * t57 * t149 * t98 * t120 + 0.15750000000000000000000000000000000000000000000000e-1 * t57 * t97 * t244 + 0.21000000000000000000000000000000000000000000000000e-1 * t57 * t97 * t74 * t181 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t60 * (0.25165432098765432098765432098765432098765432098765e1 * t30 / t19 / t129 * t34 + 0.11963259259259259259259259259259259259259259259259e2 * t66 * t207 * t70 - 0.25729580246913580246913580246913580246913580246912e2 * t111 / t19 / t166 / r0 * t116 + 0.37167407407407407407407407407407407407407407407407e2 * t172 / t166 / t84 * t178 - 0.10619259259259259259259259259259259259259259259259e2 * t271 / t20 / t166 / t205 / t69 / t176 / t68 * t27)
  t291 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t52 * t43 - 0.5e1 / 0.9e1 * t6 * t23 * t78 + t6 * t49 * t124 / 0.2e1 - t6 * t83 * t185 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t128 * t286)
  v4rho4_0_ = 0.2e1 * r0 * t291 + 0.8e1 * t190

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = jnp.sqrt(jnp.pi)
  t33 = t32 * s0
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = jnp.sqrt(s0)
  t42 = t39 / t35 / r0
  t43 = jnp.arcsinh(t42)
  t46 = 0.1e1 + 0.56e-1 * t42 * t43
  t47 = 0.1e1 / t46
  t51 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t33 * t38 * t47
  t55 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = t55 * f.p.zeta_threshold
  t58 = f.my_piecewise3(t20, t56, t21 * t19)
  t59 = t30 ** 2
  t60 = 0.1e1 / t59
  t61 = t58 * t60
  t64 = t5 * t61 * t51 / 0.8e1
  t65 = t58 * t30
  t66 = t34 * r0
  t68 = 0.1e1 / t36 / t66
  t72 = t46 ** 2
  t73 = 0.1e1 / t72
  t74 = t38 * t73
  t82 = s0 * t38 + 0.1e1
  t83 = jnp.sqrt(t82)
  t84 = 0.1e1 / t83
  t87 = -0.74666666666666666666666666666666666666666666666666e-1 * t39 / t35 / t34 * t43 - 0.74666666666666666666666666666666666666666666666666e-1 * s0 * t68 * t84
  t91 = -0.70000000000000000000000000000000000000000000000000e-2 * t33 * t68 * t47 - 0.26250000000000000000000000000000000000000000000000e-2 * t33 * t74 * t87
  t96 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t51 - t64 - 0.3e1 / 0.8e1 * t5 * t65 * t91)
  t98 = r1 <= f.p.dens_threshold
  t99 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t100 = 0.1e1 + t99
  t101 = t100 <= f.p.zeta_threshold
  t102 = t100 ** (0.1e1 / 0.3e1)
  t104 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t107 = f.my_piecewise3(t101, 0, 0.4e1 / 0.3e1 * t102 * t104)
  t108 = t107 * t30
  t109 = t32 * s2
  t110 = r1 ** 2
  t111 = r1 ** (0.1e1 / 0.3e1)
  t112 = t111 ** 2
  t114 = 0.1e1 / t112 / t110
  t115 = jnp.sqrt(s2)
  t118 = t115 / t111 / r1
  t119 = jnp.arcsinh(t118)
  t122 = 0.1e1 + 0.56e-1 * t118 * t119
  t123 = 0.1e1 / t122
  t127 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t109 * t114 * t123
  t132 = f.my_piecewise3(t101, t56, t102 * t100)
  t133 = t132 * t60
  t136 = t5 * t133 * t127 / 0.8e1
  t138 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t108 * t127 - t136)
  t140 = t21 ** 2
  t141 = 0.1e1 / t140
  t142 = t26 ** 2
  t147 = t16 / t22 / t6
  t149 = -0.2e1 * t23 + 0.2e1 * t147
  t150 = f.my_piecewise5(t10, 0, t14, 0, t149)
  t154 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t141 * t142 + 0.4e1 / 0.3e1 * t21 * t150)
  t161 = t5 * t29 * t60 * t51
  t167 = 0.1e1 / t59 / t6
  t171 = t5 * t58 * t167 * t51 / 0.12e2
  t173 = t5 * t61 * t91
  t175 = t34 ** 2
  t177 = 0.1e1 / t36 / t175
  t188 = t87 ** 2
  t200 = s0 ** 2
  t218 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t154 * t30 * t51 - t161 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t91 + t171 - t173 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t65 * (0.25666666666666666666666666666666666666666666666667e-1 * t33 * t177 * t47 + 0.14000000000000000000000000000000000000000000000000e-1 * t33 * t68 * t73 * t87 + 0.52500000000000000000000000000000000000000000000000e-2 * t33 * t38 / t72 / t46 * t188 - 0.26250000000000000000000000000000000000000000000000e-2 * t33 * t74 * (0.17422222222222222222222222222222222222222222222222e0 * t39 / t35 / t66 * t43 + 0.37333333333333333333333333333333333333333333333333e0 * s0 * t177 * t84 - 0.99555555555555555555555555555555555555555555555554e-1 * t200 / t35 / t175 / t66 / t83 / t82)))
  t219 = t102 ** 2
  t220 = 0.1e1 / t219
  t221 = t104 ** 2
  t225 = f.my_piecewise5(t14, 0, t10, 0, -t149)
  t229 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t220 * t221 + 0.4e1 / 0.3e1 * t102 * t225)
  t236 = t5 * t107 * t60 * t127
  t241 = t5 * t132 * t167 * t127 / 0.12e2
  t243 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t229 * t30 * t127 - t236 / 0.4e1 + t241)
  d11 = 0.2e1 * t96 + 0.2e1 * t138 + t6 * (t218 + t243)
  t246 = -t7 - t24
  t247 = f.my_piecewise5(t10, 0, t14, 0, t246)
  t250 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t247)
  t251 = t250 * t30
  t256 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t251 * t51 - t64)
  t258 = f.my_piecewise5(t14, 0, t10, 0, -t246)
  t261 = f.my_piecewise3(t101, 0, 0.4e1 / 0.3e1 * t102 * t258)
  t262 = t261 * t30
  t266 = t132 * t30
  t267 = t110 * r1
  t269 = 0.1e1 / t112 / t267
  t273 = t122 ** 2
  t274 = 0.1e1 / t273
  t275 = t114 * t274
  t283 = s2 * t114 + 0.1e1
  t284 = jnp.sqrt(t283)
  t285 = 0.1e1 / t284
  t288 = -0.74666666666666666666666666666666666666666666666666e-1 * t115 / t111 / t110 * t119 - 0.74666666666666666666666666666666666666666666666666e-1 * s2 * t269 * t285
  t292 = -0.70000000000000000000000000000000000000000000000000e-2 * t109 * t269 * t123 - 0.26250000000000000000000000000000000000000000000000e-2 * t109 * t275 * t288
  t297 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t262 * t127 - t136 - 0.3e1 / 0.8e1 * t5 * t266 * t292)
  t301 = 0.2e1 * t147
  t302 = f.my_piecewise5(t10, 0, t14, 0, t301)
  t306 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t141 * t247 * t26 + 0.4e1 / 0.3e1 * t21 * t302)
  t313 = t5 * t250 * t60 * t51
  t321 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t306 * t30 * t51 - t313 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t251 * t91 - t161 / 0.8e1 + t171 - t173 / 0.8e1)
  t325 = f.my_piecewise5(t14, 0, t10, 0, -t301)
  t329 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t220 * t258 * t104 + 0.4e1 / 0.3e1 * t102 * t325)
  t336 = t5 * t261 * t60 * t127
  t343 = t5 * t133 * t292
  t346 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t329 * t30 * t127 - t336 / 0.8e1 - t236 / 0.8e1 + t241 - 0.3e1 / 0.8e1 * t5 * t108 * t292 - t343 / 0.8e1)
  d12 = t96 + t138 + t256 + t297 + t6 * (t321 + t346)
  t351 = t247 ** 2
  t355 = 0.2e1 * t23 + 0.2e1 * t147
  t356 = f.my_piecewise5(t10, 0, t14, 0, t355)
  t360 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t141 * t351 + 0.4e1 / 0.3e1 * t21 * t356)
  t367 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t360 * t30 * t51 - t313 / 0.4e1 + t171)
  t368 = t258 ** 2
  t372 = f.my_piecewise5(t14, 0, t10, 0, -t355)
  t376 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t220 * t368 + 0.4e1 / 0.3e1 * t102 * t372)
  t386 = t110 ** 2
  t388 = 0.1e1 / t112 / t386
  t399 = t288 ** 2
  t411 = s2 ** 2
  t429 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t376 * t30 * t127 - t336 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t262 * t292 + t241 - t343 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t266 * (0.25666666666666666666666666666666666666666666666667e-1 * t109 * t388 * t123 + 0.14000000000000000000000000000000000000000000000000e-1 * t109 * t269 * t274 * t288 + 0.52500000000000000000000000000000000000000000000000e-2 * t109 * t114 / t273 / t122 * t399 - 0.26250000000000000000000000000000000000000000000000e-2 * t109 * t275 * (0.17422222222222222222222222222222222222222222222222e0 * t115 / t111 / t267 * t119 + 0.37333333333333333333333333333333333333333333333333e0 * s2 * t388 * t285 - 0.99555555555555555555555555555555555555555555555554e-1 * t411 / t111 / t386 / t267 / t284 / t283)))
  d22 = 0.2e1 * t256 + 0.2e1 * t297 + t6 * (t367 + t429)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = jnp.sqrt(jnp.pi)
  t45 = t44 * s0
  t46 = r0 ** 2
  t47 = r0 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t50 = 0.1e1 / t48 / t46
  t51 = jnp.sqrt(s0)
  t54 = t51 / t47 / r0
  t55 = jnp.asinh(t54)
  t58 = 0.1e1 + 0.56e-1 * t54 * t55
  t59 = 0.1e1 / t58
  t63 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t45 * t50 * t59
  t69 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t70 = t42 ** 2
  t71 = 0.1e1 / t70
  t72 = t69 * t71
  t76 = t69 * t42
  t77 = t46 * r0
  t79 = 0.1e1 / t48 / t77
  t83 = t58 ** 2
  t84 = 0.1e1 / t83
  t85 = t50 * t84
  t93 = s0 * t50 + 0.1e1
  t94 = jnp.sqrt(t93)
  t95 = 0.1e1 / t94
  t98 = -0.74666666666666666666666666666666666666666666666666e-1 * t51 / t47 / t46 * t55 - 0.74666666666666666666666666666666666666666666666666e-1 * s0 * t79 * t95
  t102 = -0.70000000000000000000000000000000000000000000000000e-2 * t45 * t79 * t59 - 0.26250000000000000000000000000000000000000000000000e-2 * t45 * t85 * t98
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t107 = t106 * f.p.zeta_threshold
  t109 = f.my_piecewise3(t20, t107, t21 * t19)
  t111 = 0.1e1 / t70 / t6
  t112 = t109 * t111
  t116 = t109 * t71
  t120 = t109 * t42
  t121 = t46 ** 2
  t123 = 0.1e1 / t48 / t121
  t127 = t79 * t84
  t132 = 0.1e1 / t83 / t58
  t134 = t98 ** 2
  t146 = s0 ** 2
  t152 = 0.1e1 / t94 / t93
  t155 = 0.17422222222222222222222222222222222222222222222222e0 * t51 / t47 / t77 * t55 + 0.37333333333333333333333333333333333333333333333333e0 * s0 * t123 * t95 - 0.99555555555555555555555555555555555555555555555554e-1 * t146 / t47 / t121 / t77 * t152
  t159 = 0.25666666666666666666666666666666666666666666666667e-1 * t45 * t123 * t59 + 0.14000000000000000000000000000000000000000000000000e-1 * t45 * t127 * t98 + 0.52500000000000000000000000000000000000000000000000e-2 * t45 * t50 * t132 * t134 - 0.26250000000000000000000000000000000000000000000000e-2 * t45 * t85 * t155
  t164 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t63 - t5 * t72 * t63 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t76 * t102 + t5 * t112 * t63 / 0.12e2 - t5 * t116 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t120 * t159)
  t166 = r1 <= f.p.dens_threshold
  t167 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t168 = 0.1e1 + t167
  t169 = t168 <= f.p.zeta_threshold
  t170 = t168 ** (0.1e1 / 0.3e1)
  t171 = t170 ** 2
  t172 = 0.1e1 / t171
  t174 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t175 = t174 ** 2
  t179 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t183 = f.my_piecewise3(t169, 0, 0.4e1 / 0.9e1 * t172 * t175 + 0.4e1 / 0.3e1 * t170 * t179)
  t186 = r1 ** 2
  t187 = r1 ** (0.1e1 / 0.3e1)
  t188 = t187 ** 2
  t191 = jnp.sqrt(s2)
  t194 = t191 / t187 / r1
  t195 = jnp.asinh(t194)
  t203 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t44 * s2 / t188 / t186 / (0.1e1 + 0.56e-1 * t194 * t195)
  t209 = f.my_piecewise3(t169, 0, 0.4e1 / 0.3e1 * t170 * t174)
  t215 = f.my_piecewise3(t169, t107, t170 * t168)
  t221 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t183 * t42 * t203 - t5 * t209 * t71 * t203 / 0.4e1 + t5 * t215 * t111 * t203 / 0.12e2)
  t231 = t24 ** 2
  t235 = 0.6e1 * t33 - 0.6e1 * t16 / t231
  t236 = f.my_piecewise5(t10, 0, t14, 0, t235)
  t240 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t236)
  t263 = 0.1e1 / t70 / t24
  t276 = 0.1e1 / t48 / t121 / r0
  t291 = t83 ** 2
  t311 = t121 ** 2
  t321 = t93 ** 2
  t335 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t240 * t42 * t63 - 0.3e1 / 0.8e1 * t5 * t41 * t71 * t63 - 0.9e1 / 0.8e1 * t5 * t43 * t102 + t5 * t69 * t111 * t63 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t72 * t102 - 0.9e1 / 0.8e1 * t5 * t76 * t159 - 0.5e1 / 0.36e2 * t5 * t109 * t263 * t63 + t5 * t112 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t116 * t159 - 0.3e1 / 0.8e1 * t5 * t120 * (-0.11977777777777777777777777777777777777777777777778e0 * t45 * t276 * t59 - 0.77000000000000000000000000000000000000000000000000e-1 * t45 * t123 * t84 * t98 - 0.42000000000000000000000000000000000000000000000000e-1 * t45 * t79 * t132 * t134 + 0.21000000000000000000000000000000000000000000000000e-1 * t45 * t127 * t155 - 0.15750000000000000000000000000000000000000000000000e-1 * t45 * t50 / t291 * t134 * t98 + 0.15750000000000000000000000000000000000000000000000e-1 * t45 * t50 * t132 * t98 * t155 - 0.26250000000000000000000000000000000000000000000000e-2 * t45 * t85 * (-0.58074074074074074074074074074074074074074074074073e0 * t51 / t47 / t121 * t55 - 0.19745185185185185185185185185185185185185185185185e1 * s0 * t276 * t95 + 0.12278518518518518518518518518518518518518518518518e1 * t146 / t47 / t311 * t152 - 0.39822222222222222222222222222222222222222222222222e0 * t146 * s0 / t311 / t77 / t94 / t321)))
  t345 = f.my_piecewise5(t14, 0, t10, 0, -t235)
  t349 = f.my_piecewise3(t169, 0, -0.8e1 / 0.27e2 / t171 / t168 * t175 * t174 + 0.4e1 / 0.3e1 * t172 * t174 * t179 + 0.4e1 / 0.3e1 * t170 * t345)
  t367 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t349 * t42 * t203 - 0.3e1 / 0.8e1 * t5 * t183 * t71 * t203 + t5 * t209 * t111 * t203 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t215 * t263 * t203)
  d111 = 0.3e1 * t164 + 0.3e1 * t221 + t6 * (t335 + t367)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = jnp.sqrt(jnp.pi)
  t57 = t56 * s0
  t58 = r0 ** 2
  t59 = r0 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t62 = 0.1e1 / t60 / t58
  t63 = jnp.sqrt(s0)
  t66 = t63 / t59 / r0
  t67 = jnp.asinh(t66)
  t70 = 0.1e1 + 0.56e-1 * t66 * t67
  t71 = 0.1e1 / t70
  t75 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t62 * t71
  t84 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t85 = t54 ** 2
  t86 = 0.1e1 / t85
  t87 = t84 * t86
  t91 = t84 * t54
  t92 = t58 * r0
  t94 = 0.1e1 / t60 / t92
  t98 = t70 ** 2
  t99 = 0.1e1 / t98
  t100 = t62 * t99
  t108 = s0 * t62 + 0.1e1
  t109 = jnp.sqrt(t108)
  t110 = 0.1e1 / t109
  t113 = -0.74666666666666666666666666666666666666666666666666e-1 * t63 / t59 / t58 * t67 - 0.74666666666666666666666666666666666666666666666666e-1 * s0 * t94 * t110
  t117 = -0.70000000000000000000000000000000000000000000000000e-2 * t57 * t94 * t71 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t100 * t113
  t123 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t125 = 0.1e1 / t85 / t6
  t126 = t123 * t125
  t130 = t123 * t86
  t134 = t123 * t54
  t135 = t58 ** 2
  t137 = 0.1e1 / t60 / t135
  t141 = t94 * t99
  t146 = 0.1e1 / t98 / t70
  t147 = t62 * t146
  t148 = t113 ** 2
  t160 = s0 ** 2
  t166 = 0.1e1 / t109 / t108
  t169 = 0.17422222222222222222222222222222222222222222222222e0 * t63 / t59 / t92 * t67 + 0.37333333333333333333333333333333333333333333333333e0 * s0 * t137 * t110 - 0.99555555555555555555555555555555555555555555555554e-1 * t160 / t59 / t135 / t92 * t166
  t173 = 0.25666666666666666666666666666666666666666666666667e-1 * t57 * t137 * t71 + 0.14000000000000000000000000000000000000000000000000e-1 * t57 * t141 * t113 + 0.52500000000000000000000000000000000000000000000000e-2 * t57 * t147 * t148 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t100 * t169
  t177 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t178 = t177 * f.p.zeta_threshold
  t180 = f.my_piecewise3(t20, t178, t21 * t19)
  t182 = 0.1e1 / t85 / t25
  t183 = t180 * t182
  t187 = t180 * t125
  t191 = t180 * t86
  t195 = t180 * t54
  t196 = t135 * r0
  t198 = 0.1e1 / t60 / t196
  t202 = t137 * t99
  t213 = t98 ** 2
  t214 = 0.1e1 / t213
  t216 = t148 * t113
  t220 = t57 * t62
  t221 = t146 * t113
  t222 = t221 * t169
  t233 = t135 ** 2
  t239 = t160 * s0
  t243 = t108 ** 2
  t245 = 0.1e1 / t109 / t243
  t248 = -0.58074074074074074074074074074074074074074074074073e0 * t63 / t59 / t135 * t67 - 0.19745185185185185185185185185185185185185185185185e1 * s0 * t198 * t110 + 0.12278518518518518518518518518518518518518518518518e1 * t160 / t59 / t233 * t166 - 0.39822222222222222222222222222222222222222222222222e0 * t239 / t233 / t92 * t245
  t252 = -0.11977777777777777777777777777777777777777777777778e0 * t57 * t198 * t71 - 0.77000000000000000000000000000000000000000000000000e-1 * t57 * t202 * t113 - 0.42000000000000000000000000000000000000000000000000e-1 * t57 * t94 * t146 * t148 + 0.21000000000000000000000000000000000000000000000000e-1 * t57 * t141 * t169 - 0.15750000000000000000000000000000000000000000000000e-1 * t57 * t62 * t214 * t216 + 0.15750000000000000000000000000000000000000000000000e-1 * t220 * t222 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t100 * t248
  t257 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t75 - 0.3e1 / 0.8e1 * t5 * t87 * t75 - 0.9e1 / 0.8e1 * t5 * t91 * t117 + t5 * t126 * t75 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t130 * t117 - 0.9e1 / 0.8e1 * t5 * t134 * t173 - 0.5e1 / 0.36e2 * t5 * t183 * t75 + t5 * t187 * t117 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t191 * t173 - 0.3e1 / 0.8e1 * t5 * t195 * t252)
  t259 = r1 <= f.p.dens_threshold
  t260 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t261 = 0.1e1 + t260
  t262 = t261 <= f.p.zeta_threshold
  t263 = t261 ** (0.1e1 / 0.3e1)
  t264 = t263 ** 2
  t266 = 0.1e1 / t264 / t261
  t268 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t269 = t268 ** 2
  t273 = 0.1e1 / t264
  t274 = t273 * t268
  t276 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t280 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t284 = f.my_piecewise3(t262, 0, -0.8e1 / 0.27e2 * t266 * t269 * t268 + 0.4e1 / 0.3e1 * t274 * t276 + 0.4e1 / 0.3e1 * t263 * t280)
  t287 = r1 ** 2
  t288 = r1 ** (0.1e1 / 0.3e1)
  t289 = t288 ** 2
  t292 = jnp.sqrt(s2)
  t295 = t292 / t288 / r1
  t296 = jnp.asinh(t295)
  t304 = 0.1e1 + 0.26250000000000000000000000000000000000000000000000e-2 * t56 * s2 / t289 / t287 / (0.1e1 + 0.56e-1 * t295 * t296)
  t313 = f.my_piecewise3(t262, 0, 0.4e1 / 0.9e1 * t273 * t269 + 0.4e1 / 0.3e1 * t263 * t276)
  t320 = f.my_piecewise3(t262, 0, 0.4e1 / 0.3e1 * t263 * t268)
  t326 = f.my_piecewise3(t262, t178, t263 * t261)
  t332 = f.my_piecewise3(t259, 0, -0.3e1 / 0.8e1 * t5 * t284 * t54 * t304 - 0.3e1 / 0.8e1 * t5 * t313 * t86 * t304 + t5 * t320 * t125 * t304 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t326 * t182 * t304)
  t343 = t135 * t58
  t345 = 0.1e1 / t60 / t343
  t373 = t148 ** 2
  t381 = t169 ** 2
  t407 = t160 ** 2
  t421 = 0.67874074074074074074074074074074074074074074074075e0 * t57 * t345 * t71 + 0.47911111111111111111111111111111111111111111111111e0 * t57 * t198 * t99 * t113 + 0.30800000000000000000000000000000000000000000000000e0 * t57 * t137 * t146 * t148 - 0.15400000000000000000000000000000000000000000000000e0 * t57 * t202 * t169 + 0.16800000000000000000000000000000000000000000000000e0 * t57 * t94 * t214 * t216 - 0.16800000000000000000000000000000000000000000000000e0 * t57 * t94 * t222 + 0.28000000000000000000000000000000000000000000000000e-1 * t57 * t141 * t248 + 0.63000000000000000000000000000000000000000000000000e-1 * t57 * t62 / t213 / t70 * t373 - 0.94500000000000000000000000000000000000000000000000e-1 * t220 * t214 * t148 * t169 + 0.15750000000000000000000000000000000000000000000000e-1 * t57 * t147 * t381 + 0.21000000000000000000000000000000000000000000000000e-1 * t220 * t221 * t248 - 0.26250000000000000000000000000000000000000000000000e-2 * t57 * t100 * (0.25165432098765432098765432098765432098765432098765e1 * t63 / t59 / t196 * t67 + 0.11963259259259259259259259259259259259259259259259e2 * s0 * t345 * t110 - 0.12864790123456790123456790123456790123456790123457e2 * t160 / t59 / t233 / r0 * t166 + 0.92918518518518518518518518518518518518518518518516e1 * t239 / t233 / t135 * t245 - 0.26548148148148148148148148148148148148148148148148e1 * t407 / t60 / t233 / t343 / t109 / t243 / t108)
  t436 = t19 ** 2
  t439 = t30 ** 2
  t445 = t41 ** 2
  t454 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t455 = f.my_piecewise5(t10, 0, t14, 0, t454)
  t459 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t436 * t439 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t445 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t455)
  t483 = 0.1e1 / t85 / t36
  t488 = -0.5e1 / 0.9e1 * t5 * t183 * t117 + t5 * t187 * t173 / 0.2e1 - t5 * t191 * t252 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t195 * t421 - 0.9e1 / 0.4e1 * t5 * t91 * t173 + t5 * t126 * t117 - 0.3e1 / 0.2e1 * t5 * t130 * t173 - 0.3e1 / 0.2e1 * t5 * t134 * t252 - 0.3e1 / 0.8e1 * t5 * t459 * t54 * t75 - 0.3e1 / 0.2e1 * t5 * t55 * t117 - 0.3e1 / 0.2e1 * t5 * t87 * t117 - t5 * t53 * t86 * t75 / 0.2e1 + t5 * t84 * t125 * t75 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t123 * t182 * t75 + 0.10e2 / 0.27e2 * t5 * t180 * t483 * t75
  t489 = f.my_piecewise3(t1, 0, t488)
  t490 = t261 ** 2
  t493 = t269 ** 2
  t499 = t276 ** 2
  t505 = f.my_piecewise5(t14, 0, t10, 0, -t454)
  t509 = f.my_piecewise3(t262, 0, 0.40e2 / 0.81e2 / t264 / t490 * t493 - 0.16e2 / 0.9e1 * t266 * t269 * t276 + 0.4e1 / 0.3e1 * t273 * t499 + 0.16e2 / 0.9e1 * t274 * t280 + 0.4e1 / 0.3e1 * t263 * t505)
  t531 = f.my_piecewise3(t259, 0, -0.3e1 / 0.8e1 * t5 * t509 * t54 * t304 - t5 * t284 * t86 * t304 / 0.2e1 + t5 * t313 * t125 * t304 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t320 * t182 * t304 + 0.10e2 / 0.27e2 * t5 * t326 * t483 * t304)
  d1111 = 0.4e1 * t257 + 0.4e1 * t332 + t6 * (t489 + t531)

  res = {'v4rho4': d1111}
  return res
