"""Generated from gga_x_c09x.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  c09x_mu = 0.0617

  c09x_kappa = 1.245

  c09x_alpha = 0.0483

  c09x_f0 = lambda s: 1 + c09x_mu * s ** 2 * jnp.exp(-c09x_alpha * s ** 2) + c09x_kappa * (1 - jnp.exp(-1 / 2 * c09x_alpha * s ** 2))

  c09x_f = lambda x: c09x_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, c09x_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  c09x_mu = 0.0617

  c09x_kappa = 1.245

  c09x_alpha = 0.0483

  c09x_f0 = lambda s: 1 + c09x_mu * s ** 2 * jnp.exp(-c09x_alpha * s ** 2) + c09x_kappa * (1 - jnp.exp(-1 / 2 * c09x_alpha * s ** 2))

  c09x_f = lambda x: c09x_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, c09x_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  c09x_mu = 0.0617

  c09x_kappa = 1.245

  c09x_alpha = 0.0483

  c09x_f0 = lambda s: 1 + c09x_mu * s ** 2 * jnp.exp(-c09x_alpha * s ** 2) + c09x_kappa * (1 - jnp.exp(-1 / 2 * c09x_alpha * s ** 2))

  c09x_f = lambda x: c09x_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, c09x_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t40 = t33 * t39
  t42 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t40)
  t47 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t40)
  t49 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t33 * t39 * t42 - 0.1245e1 * t47
  t53 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t49)
  t54 = r1 <= f.p.dens_threshold
  t55 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t56 = 0.1e1 + t55
  t57 = t56 <= f.p.zeta_threshold
  t58 = t56 ** (0.1e1 / 0.3e1)
  t60 = f.my_piecewise3(t57, t22, t58 * t56)
  t61 = t60 * t26
  t62 = r1 ** 2
  t63 = r1 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t66 = 0.1e1 / t64 / t62
  t67 = s2 * t66
  t68 = t33 * t67
  t70 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t68)
  t75 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t68)
  t77 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t33 * t67 * t70 - 0.1245e1 * t75
  t81 = f.my_piecewise3(t54, 0, -0.3e1 / 0.8e1 * t5 * t61 * t77)
  t82 = t6 ** 2
  t84 = t16 / t82
  t85 = t7 - t84
  t86 = f.my_piecewise5(t10, 0, t14, 0, t85)
  t89 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t86)
  t94 = t26 ** 2
  t95 = 0.1e1 / t94
  t99 = t5 * t25 * t95 * t49 / 0.8e1
  t103 = s0 / t36 / t34 / r0
  t107 = t28 ** 2
  t110 = t107 / t30 / t29
  t111 = s0 ** 2
  t112 = t34 ** 2
  t128 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t89 * t26 * t49 - t99 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.68555555555555555555555555555555555555555555555555e-2 * t33 * t103 * t42 + 0.13796805555555555555555555555555555555555555555555e-4 * t110 * t111 / t35 / t112 / t34 * t42 - 0.33407500000000000000000000000000000000000000000000e-2 * t33 * t103 * t47))
  t130 = f.my_piecewise5(t14, 0, t10, 0, -t85)
  t133 = f.my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t130)
  t141 = t5 * t60 * t95 * t77 / 0.8e1
  t143 = f.my_piecewise3(t54, 0, -0.3e1 / 0.8e1 * t5 * t133 * t26 * t77 - t141)
  vrho_0_ = t53 + t81 + t6 * (t128 + t143)
  t146 = -t7 - t84
  t147 = f.my_piecewise5(t10, 0, t14, 0, t146)
  t150 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t147)
  t156 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t150 * t26 * t49 - t99)
  t158 = f.my_piecewise5(t14, 0, t10, 0, -t146)
  t161 = f.my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t158)
  t169 = s2 / t64 / t62 / r1
  t173 = s2 ** 2
  t174 = t62 ** 2
  t190 = f.my_piecewise3(t54, 0, -0.3e1 / 0.8e1 * t5 * t161 * t26 * t77 - t141 - 0.3e1 / 0.8e1 * t5 * t61 * (-0.68555555555555555555555555555555555555555555555555e-2 * t33 * t169 * t70 + 0.13796805555555555555555555555555555555555555555555e-4 * t110 * t173 / t63 / t174 / t62 * t70 - 0.33407500000000000000000000000000000000000000000000e-2 * t33 * t169 * t75))
  vrho_1_ = t53 + t81 + t6 * (t156 + t190)
  t210 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.25708333333333333333333333333333333333333333333333e-2 * t33 * t38 * t42 - 0.51738020833333333333333333333333333333333333333333e-5 * t110 * s0 / t35 / t112 / r0 * t42 + 0.12527812500000000000000000000000000000000000000000e-2 * t33 * t38 * t47))
  vsigma_0_ = t6 * t210
  vsigma_1_ = 0.0e0
  t228 = f.my_piecewise3(t54, 0, -0.3e1 / 0.8e1 * t5 * t61 * (0.25708333333333333333333333333333333333333333333333e-2 * t33 * t66 * t70 - 0.51738020833333333333333333333333333333333333333333e-5 * t110 * s2 / t63 / t174 / r1 * t70 + 0.12527812500000000000000000000000000000000000000000e-2 * t33 * t66 * t75))
  vsigma_2_ = t6 * t228
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  c09x_mu = 0.0617

  c09x_kappa = 1.245

  c09x_alpha = 0.0483

  c09x_f0 = lambda s: 1 + c09x_mu * s ** 2 * jnp.exp(-c09x_alpha * s ** 2) + c09x_kappa * (1 - jnp.exp(-1 / 2 * c09x_alpha * s ** 2))

  c09x_f = lambda x: c09x_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, c09x_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t36 = t25 * s0 * t28 * t32
  t38 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t36)
  t39 = t33 * t38
  t43 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t36)
  t45 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t26 * t39 - 0.1245e1 * t43
  t49 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t45)
  t58 = t28 / t30 / t29 / r0
  t62 = t20 ** 2
  t65 = t62 / t22 / t21
  t66 = s0 ** 2
  t68 = t29 ** 2
  t84 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t45 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.68555555555555555555555555555555555555555555555555e-2 * t26 * t58 * t38 + 0.27593611111111111111111111111111111111111111111110e-4 * t65 * t66 * t27 / t18 / t68 / t29 * t38 - 0.33407500000000000000000000000000000000000000000000e-2 * t26 * t58 * t43))
  vrho_0_ = 0.2e1 * r0 * t84 + 0.2e1 * t49
  t104 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.25708333333333333333333333333333333333333333333333e-2 * t25 * t39 - 0.10347604166666666666666666666666666666666666666667e-4 * t65 * s0 * t27 / t18 / t68 / r0 * t38 + 0.12527812500000000000000000000000000000000000000000e-2 * t25 * t33 * t43))
  vsigma_0_ = 0.2e1 * r0 * t104
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = t27 * s0
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t34 = t30 * t33
  t37 = t27 * s0 * t30 * t33
  t39 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t37)
  t40 = t34 * t39
  t44 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t37)
  t46 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t28 * t40 - 0.1245e1 * t44
  t50 = t17 * t18
  t51 = t31 * r0
  t54 = t30 / t19 / t51
  t55 = t54 * t39
  t58 = t22 ** 2
  t61 = t58 / t24 / t23
  t62 = s0 ** 2
  t63 = t61 * t62
  t64 = t31 ** 2
  t67 = 0.1e1 / t18 / t64 / t31
  t72 = t54 * t44
  t75 = -0.68555555555555555555555555555555555555555555555555e-2 * t28 * t55 + 0.27593611111111111111111111111111111111111111111110e-4 * t63 * t29 * t67 * t39 - 0.33407500000000000000000000000000000000000000000000e-2 * t28 * t72
  t80 = f.my_piecewise3(t2, 0, -t6 * t21 * t46 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t50 * t75)
  t93 = t30 / t19 / t64
  t100 = t29 / t18 / t64 / t51
  t104 = t23 ** 2
  t105 = 0.1e1 / t104
  t108 = t64 ** 2
  t125 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t46 / 0.12e2 - t6 * t21 * t75 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t50 * (0.25137037037037037037037037037037037037037037037037e-1 * t28 * t93 * t39 - 0.24834249999999999999999999999999999999999999999999e-3 * t63 * t100 * t39 + 0.17770285555555555555555555555555555555555555555555e-5 * t105 * t62 * s0 / t108 / t31 * t39 + 0.12249416666666666666666666666666666666666666666667e-1 * t28 * t93 * t44 - 0.17928691666666666666666666666666666666666666666666e-4 * t63 * t100 * t44))
  v2rho2_0_ = 0.2e1 * r0 * t125 + 0.4e1 * t80
  t134 = t29 / t18 / t64 / r0
  t135 = t134 * t39
  t141 = 0.25708333333333333333333333333333333333333333333333e-2 * t27 * t40 - 0.10347604166666666666666666666666666666666666666667e-4 * t61 * s0 * t135 + 0.12527812500000000000000000000000000000000000000000e-2 * t27 * t34 * t44
  t145 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t50 * t141)
  t151 = t61 * t29
  t152 = t67 * s0
  t172 = f.my_piecewise3(t2, 0, -t6 * t21 * t141 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t50 * (-0.68555555555555555555555555555555555555555555555555e-2 * t27 * t55 + 0.82780833333333333333333333333333333333333333333334e-4 * t151 * t152 * t39 - 0.66638570833333333333333333333333333333333333333335e-6 * t105 * t62 / t108 / r0 * t39 - 0.33407500000000000000000000000000000000000000000000e-2 * t27 * t72 + 0.67232593749999999999999999999999999999999999999999e-5 * t151 * t152 * t44))
  v2rhosigma_0_ = 0.2e1 * r0 * t172 + 0.2e1 * t145
  t189 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t50 * (-0.20695208333333333333333333333333333333333333333334e-4 * t61 * t135 + 0.24989464062500000000000000000000000000000000000001e-6 * t105 * s0 / t108 * t39 - 0.25212222656250000000000000000000000000000000000000e-5 * t61 * t134 * t44))
  v2sigma2_0_ = 0.2e1 * r0 * t189
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = t23 / t26
  t29 = t28 * s0
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t38 = t28 * s0 * t31 * t34
  t40 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t38)
  t45 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t38)
  t47 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t29 * t31 * t34 * t40 - 0.1245e1 * t45
  t52 = t17 / t19
  t53 = t32 * r0
  t56 = t31 / t19 / t53
  t60 = t23 ** 2
  t64 = s0 ** 2
  t65 = t60 / t25 / t24 * t64
  t66 = t32 ** 2
  t77 = -0.68555555555555555555555555555555555555555555555555e-2 * t29 * t56 * t40 + 0.27593611111111111111111111111111111111111111111110e-4 * t65 * t30 / t18 / t66 / t32 * t40 - 0.33407500000000000000000000000000000000000000000000e-2 * t29 * t56 * t45
  t81 = t17 * t18
  t84 = t31 / t19 / t66
  t91 = t30 / t18 / t66 / t53
  t95 = t24 ** 2
  t96 = 0.1e1 / t95
  t98 = t96 * t64 * s0
  t99 = t66 ** 2
  t111 = 0.25137037037037037037037037037037037037037037037037e-1 * t29 * t84 * t40 - 0.24834249999999999999999999999999999999999999999999e-3 * t65 * t91 * t40 + 0.17770285555555555555555555555555555555555555555555e-5 * t98 / t99 / t32 * t40 + 0.12249416666666666666666666666666666666666666666667e-1 * t29 * t84 * t45 - 0.17928691666666666666666666666666666666666666666666e-4 * t65 * t91 * t45
  t116 = f.my_piecewise3(t2, 0, t6 * t22 * t47 / 0.12e2 - t6 * t52 * t77 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t111)
  t128 = t66 * r0
  t131 = t31 / t19 / t128
  t137 = t30 / t18 / t99
  t142 = 0.1e1 / t99 / t53
  t146 = t64 ** 2
  t170 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t47 + t6 * t22 * t77 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t52 * t111 - 0.3e1 / 0.8e1 * t6 * t81 * (-0.11730617283950617283950617283950617283950617283951e0 * t29 * t131 * t40 + 0.20909825308641975308641975308641975308641975308642e-2 * t65 * t137 * t40 - 0.33763542555555555555555555555555555555555555555554e-4 * t98 * t142 * t40 + 0.95367199148148148148148148148148148148148148148146e-8 * t96 * t146 / t19 / t99 / t128 * t28 * t31 * t40 - 0.57163944444444444444444444444444444444444444444446e-1 * t29 * t131 * t45 + 0.19721560833333333333333333333333333333333333333333e-3 * t65 * t137 * t45 - 0.57730387166666666666666666666666666666666666666665e-6 * t98 * t142 * t45))
  v3rho3_0_ = 0.2e1 * r0 * t170 + 0.6e1 * t116

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = t29 * s0
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t36 = t29 * s0 * t32 * t22
  t38 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t36)
  t43 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t36)
  t45 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t30 * t32 * t22 * t38 - 0.1245e1 * t43
  t51 = t17 / t20 / r0
  t52 = t18 * r0
  t54 = 0.1e1 / t20 / t52
  t55 = t32 * t54
  t59 = t24 ** 2
  t62 = t59 / t26 / t25
  t63 = s0 ** 2
  t64 = t62 * t63
  t65 = t18 ** 2
  t66 = t65 * t18
  t76 = -0.68555555555555555555555555555555555555555555555555e-2 * t30 * t55 * t38 + 0.27593611111111111111111111111111111111111111111110e-4 * t64 * t31 / t19 / t66 * t38 - 0.33407500000000000000000000000000000000000000000000e-2 * t30 * t55 * t43
  t81 = t17 / t20
  t84 = t32 / t20 / t65
  t91 = t31 / t19 / t65 / t52
  t95 = t25 ** 2
  t96 = 0.1e1 / t95
  t98 = t96 * t63 * s0
  t99 = t65 ** 2
  t111 = 0.25137037037037037037037037037037037037037037037037e-1 * t30 * t84 * t38 - 0.24834249999999999999999999999999999999999999999999e-3 * t64 * t91 * t38 + 0.17770285555555555555555555555555555555555555555555e-5 * t98 / t99 / t18 * t38 + 0.12249416666666666666666666666666666666666666666667e-1 * t30 * t84 * t43 - 0.17928691666666666666666666666666666666666666666666e-4 * t64 * t91 * t43
  t115 = t17 * t19
  t116 = t65 * r0
  t119 = t32 / t20 / t116
  t125 = t31 / t19 / t99
  t130 = 0.1e1 / t99 / t52
  t134 = t63 ** 2
  t135 = t96 * t134
  t141 = t29 * t32 * t38
  t153 = -0.11730617283950617283950617283950617283950617283951e0 * t30 * t119 * t38 + 0.20909825308641975308641975308641975308641975308642e-2 * t64 * t125 * t38 - 0.33763542555555555555555555555555555555555555555554e-4 * t98 * t130 * t38 + 0.95367199148148148148148148148148148148148148148146e-8 * t135 / t20 / t99 / t116 * t141 - 0.57163944444444444444444444444444444444444444444446e-1 * t30 * t119 * t43 + 0.19721560833333333333333333333333333333333333333333e-3 * t64 * t125 * t43 - 0.57730387166666666666666666666666666666666666666665e-6 * t98 * t130 * t43
  t158 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t45 + t6 * t51 * t76 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t81 * t111 - 0.3e1 / 0.8e1 * t6 * t115 * t153)
  t175 = t32 / t20 / t66
  t182 = t31 / t19 / t99 / r0
  t187 = 0.1e1 / t99 / t65
  t194 = t135 / t20 / t99 / t66
  t199 = t99 ** 2
  t226 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t54 * t45 - 0.5e1 / 0.9e1 * t6 * t23 * t76 + t6 * t51 * t111 / 0.2e1 - t6 * t81 * t153 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t115 * (0.66473497942386831275720164609053497942386831275722e0 * t30 * t175 * t38 - 0.18683940679012345679012345679012345679012345679013e-1 * t64 * t182 * t38 + 0.50605824309876543209876543209876543209876543209874e-3 * t98 * t187 * t38 - 0.31153285055061728395061728395061728395061728395060e-6 * t194 * t141 + 0.10236079375234567901234567901234567901234567901234e-9 * t96 * t134 * s0 / t19 / t199 / r0 * t62 * t31 * t38 + 0.32392901851851851851851851851851851851851851851853e0 * t30 * t175 * t43 - 0.19502432379629629629629629629629629629629629629629e-2 * t64 * t182 * t43 + 0.12700685176666666666666666666666666666666666666666e-4 * t98 * t187 * t43 - 0.15490987223055555555555555555555555555555555555555e-8 * t194 * t29 * t32 * t43))
  v4rho4_0_ = 0.2e1 * r0 * t226 + 0.8e1 * t158

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t43 = s0 / t40 / t38
  t44 = t37 * t43
  t46 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t44)
  t51 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t44)
  t53 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t37 * t43 * t46 - 0.1245e1 * t51
  t57 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t58 = t57 * f.p.zeta_threshold
  t60 = f.my_piecewise3(t20, t58, t21 * t19)
  t61 = t30 ** 2
  t62 = 0.1e1 / t61
  t63 = t60 * t62
  t66 = t5 * t63 * t53 / 0.8e1
  t67 = t60 * t30
  t68 = t38 * r0
  t71 = s0 / t40 / t68
  t75 = t32 ** 2
  t78 = t75 / t34 / t33
  t79 = s0 ** 2
  t80 = t38 ** 2
  t91 = -0.68555555555555555555555555555555555555555555555555e-2 * t37 * t71 * t46 + 0.13796805555555555555555555555555555555555555555555e-4 * t78 * t79 / t39 / t80 / t38 * t46 - 0.33407500000000000000000000000000000000000000000000e-2 * t37 * t71 * t51
  t96 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t53 - t66 - 0.3e1 / 0.8e1 * t5 * t67 * t91)
  t98 = r1 <= f.p.dens_threshold
  t99 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t100 = 0.1e1 + t99
  t101 = t100 <= f.p.zeta_threshold
  t102 = t100 ** (0.1e1 / 0.3e1)
  t104 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t107 = f.my_piecewise3(t101, 0, 0.4e1 / 0.3e1 * t102 * t104)
  t108 = t107 * t30
  t109 = r1 ** 2
  t110 = r1 ** (0.1e1 / 0.3e1)
  t111 = t110 ** 2
  t114 = s2 / t111 / t109
  t115 = t37 * t114
  t117 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t115)
  t122 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t115)
  t124 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t37 * t114 * t117 - 0.1245e1 * t122
  t129 = f.my_piecewise3(t101, t58, t102 * t100)
  t130 = t129 * t62
  t133 = t5 * t130 * t124 / 0.8e1
  t135 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t108 * t124 - t133)
  t137 = t21 ** 2
  t138 = 0.1e1 / t137
  t139 = t26 ** 2
  t144 = t16 / t22 / t6
  t146 = -0.2e1 * t23 + 0.2e1 * t144
  t147 = f.my_piecewise5(t10, 0, t14, 0, t146)
  t151 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t138 * t139 + 0.4e1 / 0.3e1 * t21 * t147)
  t158 = t5 * t29 * t62 * t53
  t164 = 0.1e1 / t61 / t6
  t168 = t5 * t60 * t164 * t53 / 0.12e2
  t170 = t5 * t63 * t91
  t174 = s0 / t40 / t80
  t181 = t79 / t39 / t80 / t68
  t185 = t33 ** 2
  t186 = 0.1e1 / t185
  t189 = t80 ** 2
  t206 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t151 * t30 * t53 - t158 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t91 + t168 - t170 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t67 * (0.25137037037037037037037037037037037037037037037037e-1 * t37 * t174 * t46 - 0.12417125000000000000000000000000000000000000000000e-3 * t78 * t181 * t46 + 0.44425713888888888888888888888888888888888888888887e-6 * t186 * t79 * s0 / t189 / t38 * t46 + 0.12249416666666666666666666666666666666666666666667e-1 * t37 * t174 * t51 - 0.89643458333333333333333333333333333333333333333332e-5 * t78 * t181 * t51))
  t207 = t102 ** 2
  t208 = 0.1e1 / t207
  t209 = t104 ** 2
  t213 = f.my_piecewise5(t14, 0, t10, 0, -t146)
  t217 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t208 * t209 + 0.4e1 / 0.3e1 * t102 * t213)
  t224 = t5 * t107 * t62 * t124
  t229 = t5 * t129 * t164 * t124 / 0.12e2
  t231 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t217 * t30 * t124 - t224 / 0.4e1 + t229)
  d11 = 0.2e1 * t96 + 0.2e1 * t135 + t6 * (t206 + t231)
  t234 = -t7 - t24
  t235 = f.my_piecewise5(t10, 0, t14, 0, t234)
  t238 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t235)
  t239 = t238 * t30
  t244 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t239 * t53 - t66)
  t246 = f.my_piecewise5(t14, 0, t10, 0, -t234)
  t249 = f.my_piecewise3(t101, 0, 0.4e1 / 0.3e1 * t102 * t246)
  t250 = t249 * t30
  t254 = t129 * t30
  t255 = t109 * r1
  t258 = s2 / t111 / t255
  t262 = s2 ** 2
  t263 = t109 ** 2
  t274 = -0.68555555555555555555555555555555555555555555555555e-2 * t37 * t258 * t117 + 0.13796805555555555555555555555555555555555555555555e-4 * t78 * t262 / t110 / t263 / t109 * t117 - 0.33407500000000000000000000000000000000000000000000e-2 * t37 * t258 * t122
  t279 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t250 * t124 - t133 - 0.3e1 / 0.8e1 * t5 * t254 * t274)
  t283 = 0.2e1 * t144
  t284 = f.my_piecewise5(t10, 0, t14, 0, t283)
  t288 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t138 * t235 * t26 + 0.4e1 / 0.3e1 * t21 * t284)
  t295 = t5 * t238 * t62 * t53
  t303 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t288 * t30 * t53 - t295 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t239 * t91 - t158 / 0.8e1 + t168 - t170 / 0.8e1)
  t307 = f.my_piecewise5(t14, 0, t10, 0, -t283)
  t311 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t208 * t246 * t104 + 0.4e1 / 0.3e1 * t102 * t307)
  t318 = t5 * t249 * t62 * t124
  t325 = t5 * t130 * t274
  t328 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t311 * t30 * t124 - t318 / 0.8e1 - t224 / 0.8e1 + t229 - 0.3e1 / 0.8e1 * t5 * t108 * t274 - t325 / 0.8e1)
  d12 = t96 + t135 + t244 + t279 + t6 * (t303 + t328)
  t333 = t235 ** 2
  t337 = 0.2e1 * t23 + 0.2e1 * t144
  t338 = f.my_piecewise5(t10, 0, t14, 0, t337)
  t342 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t138 * t333 + 0.4e1 / 0.3e1 * t21 * t338)
  t349 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t342 * t30 * t53 - t295 / 0.4e1 + t168)
  t350 = t246 ** 2
  t354 = f.my_piecewise5(t14, 0, t10, 0, -t337)
  t358 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t208 * t350 + 0.4e1 / 0.3e1 * t102 * t354)
  t370 = s2 / t111 / t263
  t377 = t262 / t110 / t263 / t255
  t383 = t263 ** 2
  t400 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t358 * t30 * t124 - t318 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t250 * t274 + t229 - t325 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t254 * (0.25137037037037037037037037037037037037037037037037e-1 * t37 * t370 * t117 - 0.12417125000000000000000000000000000000000000000000e-3 * t78 * t377 * t117 + 0.44425713888888888888888888888888888888888888888887e-6 * t186 * t262 * s2 / t383 / t109 * t117 + 0.12249416666666666666666666666666666666666666666667e-1 * t37 * t370 * t122 - 0.89643458333333333333333333333333333333333333333332e-5 * t78 * t377 * t122))
  d22 = 0.2e1 * t244 + 0.2e1 * t279 + t6 * (t349 + t400)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = t44 / t47
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t55 = s0 / t52 / t50
  t56 = t49 * t55
  t58 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t56)
  t63 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t56)
  t65 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t49 * t55 * t58 - 0.1245e1 * t63
  t71 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t72 = t42 ** 2
  t73 = 0.1e1 / t72
  t74 = t71 * t73
  t78 = t71 * t42
  t79 = t50 * r0
  t82 = s0 / t52 / t79
  t86 = t44 ** 2
  t89 = t86 / t46 / t45
  t90 = s0 ** 2
  t91 = t50 ** 2
  t102 = -0.68555555555555555555555555555555555555555555555555e-2 * t49 * t82 * t58 + 0.13796805555555555555555555555555555555555555555555e-4 * t89 * t90 / t51 / t91 / t50 * t58 - 0.33407500000000000000000000000000000000000000000000e-2 * t49 * t82 * t63
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t107 = t106 * f.p.zeta_threshold
  t109 = f.my_piecewise3(t20, t107, t21 * t19)
  t111 = 0.1e1 / t72 / t6
  t112 = t109 * t111
  t116 = t109 * t73
  t120 = t109 * t42
  t123 = s0 / t52 / t91
  t130 = t90 / t51 / t91 / t79
  t134 = t45 ** 2
  t135 = 0.1e1 / t134
  t137 = t135 * t90 * s0
  t138 = t91 ** 2
  t150 = 0.25137037037037037037037037037037037037037037037037e-1 * t49 * t123 * t58 - 0.12417125000000000000000000000000000000000000000000e-3 * t89 * t130 * t58 + 0.44425713888888888888888888888888888888888888888887e-6 * t137 / t138 / t50 * t58 + 0.12249416666666666666666666666666666666666666666667e-1 * t49 * t123 * t63 - 0.89643458333333333333333333333333333333333333333332e-5 * t89 * t130 * t63
  t155 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t65 - t5 * t74 * t65 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t78 * t102 + t5 * t112 * t65 / 0.12e2 - t5 * t116 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t120 * t150)
  t157 = r1 <= f.p.dens_threshold
  t158 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t159 = 0.1e1 + t158
  t160 = t159 <= f.p.zeta_threshold
  t161 = t159 ** (0.1e1 / 0.3e1)
  t162 = t161 ** 2
  t163 = 0.1e1 / t162
  t165 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t166 = t165 ** 2
  t170 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t174 = f.my_piecewise3(t160, 0, 0.4e1 / 0.9e1 * t163 * t166 + 0.4e1 / 0.3e1 * t161 * t170)
  t176 = r1 ** 2
  t177 = r1 ** (0.1e1 / 0.3e1)
  t178 = t177 ** 2
  t181 = s2 / t178 / t176
  t182 = t49 * t181
  t184 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t182)
  t189 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t182)
  t191 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t49 * t181 * t184 - 0.1245e1 * t189
  t197 = f.my_piecewise3(t160, 0, 0.4e1 / 0.3e1 * t161 * t165)
  t203 = f.my_piecewise3(t160, t107, t161 * t159)
  t209 = f.my_piecewise3(t157, 0, -0.3e1 / 0.8e1 * t5 * t174 * t42 * t191 - t5 * t197 * t73 * t191 / 0.4e1 + t5 * t203 * t111 * t191 / 0.12e2)
  t219 = t24 ** 2
  t223 = 0.6e1 * t33 - 0.6e1 * t16 / t219
  t224 = f.my_piecewise5(t10, 0, t14, 0, t223)
  t228 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t224)
  t251 = 0.1e1 / t72 / t24
  t262 = t91 * r0
  t265 = s0 / t52 / t262
  t271 = t90 / t51 / t138
  t276 = 0.1e1 / t138 / t79
  t280 = t90 ** 2
  t303 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t228 * t42 * t65 - 0.3e1 / 0.8e1 * t5 * t41 * t73 * t65 - 0.9e1 / 0.8e1 * t5 * t43 * t102 + t5 * t71 * t111 * t65 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t74 * t102 - 0.9e1 / 0.8e1 * t5 * t78 * t150 - 0.5e1 / 0.36e2 * t5 * t109 * t251 * t65 + t5 * t112 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t116 * t150 - 0.3e1 / 0.8e1 * t5 * t120 * (-0.11730617283950617283950617283950617283950617283951e0 * t49 * t265 * t58 + 0.10454912654320987654320987654320987654320987654321e-2 * t89 * t271 * t58 - 0.84408856388888888888888888888888888888888888888887e-5 * t137 * t276 * t58 + 0.23841799787037037037037037037037037037037037037036e-8 * t135 * t280 / t52 / t138 / t262 * t49 * t58 - 0.57163944444444444444444444444444444444444444444446e-1 * t49 * t265 * t63 + 0.98607804166666666666666666666666666666666666666666e-4 * t89 * t271 * t63 - 0.14432596791666666666666666666666666666666666666666e-6 * t137 * t276 * t63))
  t313 = f.my_piecewise5(t14, 0, t10, 0, -t223)
  t317 = f.my_piecewise3(t160, 0, -0.8e1 / 0.27e2 / t162 / t159 * t166 * t165 + 0.4e1 / 0.3e1 * t163 * t165 * t170 + 0.4e1 / 0.3e1 * t161 * t313)
  t335 = f.my_piecewise3(t157, 0, -0.3e1 / 0.8e1 * t5 * t317 * t42 * t191 - 0.3e1 / 0.8e1 * t5 * t174 * t73 * t191 + t5 * t197 * t111 * t191 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t203 * t251 * t191)
  d111 = 0.3e1 * t155 + 0.3e1 * t209 + t6 * (t303 + t335)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t61 = t56 / t59
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t67 = s0 / t64 / t62
  t68 = t61 * t67
  t70 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t68)
  t75 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t68)
  t77 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t61 * t67 * t70 - 0.1245e1 * t75
  t86 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t87 = t54 ** 2
  t88 = 0.1e1 / t87
  t89 = t86 * t88
  t93 = t86 * t54
  t94 = t62 * r0
  t97 = s0 / t64 / t94
  t101 = t56 ** 2
  t104 = t101 / t58 / t57
  t105 = s0 ** 2
  t106 = t62 ** 2
  t107 = t106 * t62
  t117 = -0.68555555555555555555555555555555555555555555555555e-2 * t61 * t97 * t70 + 0.13796805555555555555555555555555555555555555555555e-4 * t104 * t105 / t63 / t107 * t70 - 0.33407500000000000000000000000000000000000000000000e-2 * t61 * t97 * t75
  t123 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t125 = 0.1e1 / t87 / t6
  t126 = t123 * t125
  t130 = t123 * t88
  t134 = t123 * t54
  t137 = s0 / t64 / t106
  t144 = t105 / t63 / t106 / t94
  t148 = t57 ** 2
  t149 = 0.1e1 / t148
  t151 = t149 * t105 * s0
  t152 = t106 ** 2
  t164 = 0.25137037037037037037037037037037037037037037037037e-1 * t61 * t137 * t70 - 0.12417125000000000000000000000000000000000000000000e-3 * t104 * t144 * t70 + 0.44425713888888888888888888888888888888888888888887e-6 * t151 / t152 / t62 * t70 + 0.12249416666666666666666666666666666666666666666667e-1 * t61 * t137 * t75 - 0.89643458333333333333333333333333333333333333333332e-5 * t104 * t144 * t75
  t168 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t169 = t168 * f.p.zeta_threshold
  t171 = f.my_piecewise3(t20, t169, t21 * t19)
  t173 = 0.1e1 / t87 / t25
  t174 = t171 * t173
  t178 = t171 * t125
  t182 = t171 * t88
  t186 = t171 * t54
  t187 = t106 * r0
  t190 = s0 / t64 / t187
  t196 = t105 / t63 / t152
  t201 = 0.1e1 / t152 / t94
  t205 = t105 ** 2
  t206 = t149 * t205
  t211 = t61 * t70
  t223 = -0.11730617283950617283950617283950617283950617283951e0 * t61 * t190 * t70 + 0.10454912654320987654320987654320987654320987654321e-2 * t104 * t196 * t70 - 0.84408856388888888888888888888888888888888888888887e-5 * t151 * t201 * t70 + 0.23841799787037037037037037037037037037037037037036e-8 * t206 / t64 / t152 / t187 * t211 - 0.57163944444444444444444444444444444444444444444446e-1 * t61 * t190 * t75 + 0.98607804166666666666666666666666666666666666666666e-4 * t104 * t196 * t75 - 0.14432596791666666666666666666666666666666666666666e-6 * t151 * t201 * t75
  t228 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t77 - 0.3e1 / 0.8e1 * t5 * t89 * t77 - 0.9e1 / 0.8e1 * t5 * t93 * t117 + t5 * t126 * t77 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t130 * t117 - 0.9e1 / 0.8e1 * t5 * t134 * t164 - 0.5e1 / 0.36e2 * t5 * t174 * t77 + t5 * t178 * t117 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t182 * t164 - 0.3e1 / 0.8e1 * t5 * t186 * t223)
  t230 = r1 <= f.p.dens_threshold
  t231 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t232 = 0.1e1 + t231
  t233 = t232 <= f.p.zeta_threshold
  t234 = t232 ** (0.1e1 / 0.3e1)
  t235 = t234 ** 2
  t237 = 0.1e1 / t235 / t232
  t239 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t240 = t239 ** 2
  t244 = 0.1e1 / t235
  t245 = t244 * t239
  t247 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t251 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t255 = f.my_piecewise3(t233, 0, -0.8e1 / 0.27e2 * t237 * t240 * t239 + 0.4e1 / 0.3e1 * t245 * t247 + 0.4e1 / 0.3e1 * t234 * t251)
  t257 = r1 ** 2
  t258 = r1 ** (0.1e1 / 0.3e1)
  t259 = t258 ** 2
  t262 = s2 / t259 / t257
  t263 = t61 * t262
  t265 = jnp.exp(-0.20125000000000000000000000000000000000000000000000e-2 * t263)
  t270 = jnp.exp(-0.10062500000000000000000000000000000000000000000000e-2 * t263)
  t272 = 0.2245e1 + 0.25708333333333333333333333333333333333333333333333e-2 * t61 * t262 * t265 - 0.1245e1 * t270
  t281 = f.my_piecewise3(t233, 0, 0.4e1 / 0.9e1 * t244 * t240 + 0.4e1 / 0.3e1 * t234 * t247)
  t288 = f.my_piecewise3(t233, 0, 0.4e1 / 0.3e1 * t234 * t239)
  t294 = f.my_piecewise3(t233, t169, t234 * t232)
  t300 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t255 * t54 * t272 - 0.3e1 / 0.8e1 * t5 * t281 * t88 * t272 + t5 * t288 * t125 * t272 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t294 * t173 * t272)
  t303 = 0.1e1 / t87 / t36
  t313 = s0 / t64 / t107
  t320 = t105 / t63 / t152 / r0
  t325 = 0.1e1 / t152 / t106
  t332 = t206 / t64 / t152 / t107
  t337 = t152 ** 2
  t381 = t19 ** 2
  t384 = t30 ** 2
  t390 = t41 ** 2
  t399 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t400 = f.my_piecewise5(t10, 0, t14, 0, t399)
  t404 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t381 * t384 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t390 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t400)
  t424 = 0.10e2 / 0.27e2 * t5 * t171 * t303 * t77 - t5 * t182 * t223 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t186 * (0.66473497942386831275720164609053497942386831275722e0 * t61 * t313 * t70 - 0.93419703395061728395061728395061728395061728395062e-2 * t104 * t320 * t70 + 0.12651456077469135802469135802469135802469135802469e-3 * t151 * t325 * t70 - 0.77883212637654320987654320987654320987654320987653e-7 * t332 * t211 + 0.12795099219043209876543209876543209876543209876543e-10 * t149 * t205 * s0 / t63 / t337 / r0 * t104 * t70 + 0.32392901851851851851851851851851851851851851851853e0 * t61 * t313 * t75 - 0.97512161898148148148148148148148148148148148148147e-3 * t104 * t320 * t75 + 0.31751712941666666666666666666666666666666666666666e-5 * t151 * t325 * t75 - 0.38727468057638888888888888888888888888888888888887e-9 * t332 * t61 * t75) - 0.3e1 / 0.2e1 * t5 * t134 * t223 - 0.5e1 / 0.9e1 * t5 * t174 * t117 + t5 * t178 * t164 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t89 * t117 - 0.9e1 / 0.4e1 * t5 * t93 * t164 + t5 * t126 * t117 - 0.3e1 / 0.2e1 * t5 * t130 * t164 - 0.3e1 / 0.8e1 * t5 * t404 * t54 * t77 - 0.3e1 / 0.2e1 * t5 * t55 * t117 - 0.5e1 / 0.9e1 * t5 * t123 * t173 * t77 - t5 * t53 * t88 * t77 / 0.2e1 + t5 * t86 * t125 * t77 / 0.2e1
  t425 = f.my_piecewise3(t1, 0, t424)
  t426 = t232 ** 2
  t429 = t240 ** 2
  t435 = t247 ** 2
  t441 = f.my_piecewise5(t14, 0, t10, 0, -t399)
  t445 = f.my_piecewise3(t233, 0, 0.40e2 / 0.81e2 / t235 / t426 * t429 - 0.16e2 / 0.9e1 * t237 * t240 * t247 + 0.4e1 / 0.3e1 * t244 * t435 + 0.16e2 / 0.9e1 * t245 * t251 + 0.4e1 / 0.3e1 * t234 * t441)
  t467 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t445 * t54 * t272 - t5 * t255 * t88 * t272 / 0.2e1 + t5 * t281 * t125 * t272 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t288 * t173 * t272 + 0.10e2 / 0.27e2 * t5 * t294 * t303 * t272)
  d1111 = 0.4e1 * t228 + 0.4e1 * t300 + t6 * (t425 + t467)

  res = {'v4rho4': d1111}
  return res
