"""Generated from gga_x_rge2.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  rge2_kappa = 0.804

  rge2_den = lambda s: rge2_kappa + 1 * MU_GE * s ** 2 + MU_GE ** 2 * s ** 4 / rge2_kappa

  rge2_f0 = lambda s: 1 + rge2_kappa * (1 - rge2_kappa / rge2_den(s))

  rge2_f = lambda x: rge2_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, rge2_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  rge2_kappa = 0.804

  rge2_den = lambda s: rge2_kappa + 1 * MU_GE * s ** 2 + MU_GE ** 2 * s ** 4 / rge2_kappa

  rge2_f0 = lambda s: 1 + rge2_kappa * (1 - rge2_kappa / rge2_den(s))

  rge2_f = lambda x: rge2_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, rge2_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  rge2_kappa = 0.804

  rge2_den = lambda s: rge2_kappa + 1 * MU_GE * s ** 2 + MU_GE ** 2 * s ** 4 / rge2_kappa

  rge2_f0 = lambda s: 1 + rge2_kappa * (1 - rge2_kappa / rge2_den(s))

  rge2_f = lambda x: rge2_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, rge2_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t42 = t28 ** 2
  t45 = t42 / t30 / t29
  t46 = s0 ** 2
  t47 = t34 ** 2
  t50 = 0.1e1 / t35 / t47 / r0
  t54 = 0.8040e0 + 0.5e1 / 0.972e3 * t33 * s0 * t38 + 0.32911784453572541027356570127398200111906386204762e-4 * t45 * t46 * t50
  t57 = 0.18040e1 - 0.64641600e0 / t54
  t61 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t57)
  t62 = r1 <= f.p.dens_threshold
  t63 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t64 = 0.1e1 + t63
  t65 = t64 <= f.p.zeta_threshold
  t66 = t64 ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t65, t22, t66 * t64)
  t70 = r1 ** 2
  t71 = r1 ** (0.1e1 / 0.3e1)
  t72 = t71 ** 2
  t74 = 0.1e1 / t72 / t70
  t78 = s2 ** 2
  t79 = t70 ** 2
  t82 = 0.1e1 / t71 / t79 / r1
  t86 = 0.8040e0 + 0.5e1 / 0.972e3 * t33 * s2 * t74 + 0.32911784453572541027356570127398200111906386204762e-4 * t45 * t78 * t82
  t89 = 0.18040e1 - 0.64641600e0 / t86
  t93 = f.my_piecewise3(t62, 0, -0.3e1 / 0.8e1 * t5 * t68 * t26 * t89)
  t94 = t6 ** 2
  t96 = t16 / t94
  t97 = t7 - t96
  t98 = f.my_piecewise5(t10, 0, t14, 0, t97)
  t101 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t98)
  t106 = t26 ** 2
  t107 = 0.1e1 / t106
  t111 = t5 * t25 * t107 * t57 / 0.8e1
  t112 = t5 * t25
  t113 = t54 ** 2
  t115 = t26 / t113
  t133 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t101 * t26 * t57 - t111 - 0.24240600000000000000000000000000000000000000000000e0 * t112 * t115 * (-0.10e2 / 0.729e3 * t33 * s0 / t36 / t34 / r0 - 0.17552951708572021881256837401279040059683405975873e-3 * t45 * t46 / t35 / t47 / t34))
  t135 = f.my_piecewise5(t14, 0, t10, 0, -t97)
  t138 = f.my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t135)
  t146 = t5 * t68 * t107 * t89 / 0.8e1
  t148 = f.my_piecewise3(t62, 0, -0.3e1 / 0.8e1 * t5 * t138 * t26 * t89 - t146)
  vrho_0_ = t61 + t93 + t6 * (t133 + t148)
  t151 = -t7 - t96
  t152 = f.my_piecewise5(t10, 0, t14, 0, t151)
  t155 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t152)
  t161 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t155 * t26 * t57 - t111)
  t163 = f.my_piecewise5(t14, 0, t10, 0, -t151)
  t166 = f.my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t163)
  t171 = t5 * t68
  t172 = t86 ** 2
  t174 = t26 / t172
  t192 = f.my_piecewise3(t62, 0, -0.3e1 / 0.8e1 * t5 * t166 * t26 * t89 - t146 - 0.24240600000000000000000000000000000000000000000000e0 * t171 * t174 * (-0.10e2 / 0.729e3 * t33 * s2 / t72 / t70 / r1 - 0.17552951708572021881256837401279040059683405975873e-3 * t45 * t78 / t71 / t79 / t70))
  vrho_1_ = t61 + t93 + t6 * (t161 + t192)
  t204 = f.my_piecewise3(t1, 0, -0.24240600000000000000000000000000000000000000000000e0 * t112 * t115 * (0.5e1 / 0.972e3 * t33 * t38 + 0.65823568907145082054713140254796400223812772409524e-4 * t45 * s0 * t50))
  vsigma_0_ = t6 * t204
  vsigma_1_ = 0.0e0
  t214 = f.my_piecewise3(t62, 0, -0.24240600000000000000000000000000000000000000000000e0 * t171 * t174 * (0.5e1 / 0.972e3 * t33 * t74 + 0.65823568907145082054713140254796400223812772409524e-4 * t45 * s2 * t82))
  vsigma_2_ = t6 * t214
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  rge2_kappa = 0.804

  rge2_den = lambda s: rge2_kappa + 1 * MU_GE * s ** 2 + MU_GE ** 2 * s ** 4 / rge2_kappa

  rge2_f0 = lambda s: 1 + rge2_kappa * (1 - rge2_kappa / rge2_den(s))

  rge2_f = lambda x: rge2_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, rge2_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t36 = t20 ** 2
  t39 = t36 / t22 / t21
  t40 = s0 ** 2
  t41 = t40 * t26
  t42 = t29 ** 2
  t45 = 0.1e1 / t18 / t42 / r0
  t49 = 0.8040e0 + 0.5e1 / 0.972e3 * t25 * t28 * t32 + 0.65823568907145082054713140254796400223812772409524e-4 * t39 * t41 * t45
  t52 = 0.18040e1 - 0.64641600e0 / t49
  t56 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t52)
  t62 = t6 * t17
  t63 = t49 ** 2
  t65 = t18 / t63
  t83 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t52 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t62 * t65 * (-0.10e2 / 0.729e3 * t25 * t28 / t30 / t29 / r0 - 0.35105903417144043762513674802558080119366811951746e-3 * t39 * t41 / t18 / t42 / t29))
  vrho_0_ = 0.2e1 * r0 * t83 + 0.2e1 * t56
  t97 = f.my_piecewise3(t2, 0, -0.24240600000000000000000000000000000000000000000000e0 * t62 * t65 * (0.5e1 / 0.972e3 * t25 * t27 * t32 + 0.13164713781429016410942628050959280044762554481905e-3 * t39 * s0 * t26 * t45))
  vsigma_0_ = 0.2e1 * r0 * t97
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = 0.1e1 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t37 = t22 ** 2
  t39 = 0.1e1 / t24 / t23
  t40 = t37 * t39
  t41 = s0 ** 2
  t42 = t41 * t28
  t43 = t31 ** 2
  t44 = t43 * r0
  t46 = 0.1e1 / t18 / t44
  t50 = 0.8040e0 + 0.5e1 / 0.972e3 * t27 * t30 * t33 + 0.65823568907145082054713140254796400223812772409524e-4 * t40 * t42 * t46
  t53 = 0.18040e1 - 0.64641600e0 / t50
  t57 = t6 * t17
  t58 = t50 ** 2
  t59 = 0.1e1 / t58
  t60 = t18 * t59
  t61 = t31 * r0
  t63 = 0.1e1 / t19 / t61
  t69 = 0.1e1 / t18 / t43 / t31
  t73 = -0.10e2 / 0.729e3 * t27 * t30 * t63 - 0.35105903417144043762513674802558080119366811951746e-3 * t40 * t42 * t69
  t78 = f.my_piecewise3(t2, 0, -t6 * t17 * t20 * t53 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t57 * t60 * t73)
  t86 = t20 * t59
  t92 = t18 / t58 / t50
  t93 = t73 ** 2
  t113 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t53 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t57 * t86 * t73 + 0.48481200000000000000000000000000000000000000000000e0 * t57 * t92 * t93 - 0.24240600000000000000000000000000000000000000000000e0 * t57 * t60 * (0.110e3 / 0.2187e4 * t27 * t30 / t19 / t43 + 0.22233738830857894382925327374953450742265647569439e-2 * t40 * t42 / t18 / t43 / t61))
  v2rho2_0_ = 0.2e1 * r0 * t113 + 0.4e1 * t78
  t119 = s0 * t28
  t123 = 0.5e1 / 0.972e3 * t27 * t29 * t33 + 0.13164713781429016410942628050959280044762554481905e-3 * t40 * t119 * t46
  t127 = f.my_piecewise3(t2, 0, -0.24240600000000000000000000000000000000000000000000e0 * t57 * t60 * t123)
  t146 = f.my_piecewise3(t2, 0, -0.80802000000000000000000000000000000000000000000000e-1 * t57 * t86 * t123 + 0.48481200000000000000000000000000000000000000000000e0 * t57 * t92 * t123 * t73 - 0.24240600000000000000000000000000000000000000000000e0 * t57 * t60 * (-0.10e2 / 0.729e3 * t27 * t29 * t63 - 0.70211806834288087525027349605116160238733623903493e-3 * t40 * t119 * t69))
  v2rhosigma_0_ = 0.2e1 * r0 * t146 + 0.2e1 * t127
  t149 = t123 ** 2
  t162 = f.my_piecewise3(t2, 0, 0.48481200000000000000000000000000000000000000000000e0 * t57 * t92 * t149 - 0.31912056089010821521109586953208352385307117817407e-4 * t6 * t17 / t44 * t59 * t37 * t39 * t28)
  v2sigma2_0_ = 0.2e1 * r0 * t162
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = t23 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t38 = t23 ** 2
  t41 = t38 / t25 / t24
  t42 = s0 ** 2
  t43 = t42 * t29
  t44 = t32 ** 2
  t45 = t44 * r0
  t51 = 0.8040e0 + 0.5e1 / 0.972e3 * t28 * t31 * t34 + 0.65823568907145082054713140254796400223812772409524e-4 * t41 * t43 / t18 / t45
  t54 = 0.18040e1 - 0.64641600e0 / t51
  t58 = t6 * t17
  t59 = 0.1e1 / t19
  t60 = t51 ** 2
  t61 = 0.1e1 / t60
  t62 = t59 * t61
  t63 = t32 * r0
  t75 = -0.10e2 / 0.729e3 * t28 * t31 / t19 / t63 - 0.35105903417144043762513674802558080119366811951746e-3 * t41 * t43 / t18 / t44 / t32
  t80 = 0.1e1 / t60 / t51
  t81 = t18 * t80
  t82 = t75 ** 2
  t86 = t18 * t61
  t98 = 0.110e3 / 0.2187e4 * t28 * t31 / t19 / t44 + 0.22233738830857894382925327374953450742265647569439e-2 * t41 * t43 / t18 / t44 / t63
  t103 = f.my_piecewise3(t2, 0, t6 * t17 * t21 * t54 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t58 * t62 * t75 + 0.48481200000000000000000000000000000000000000000000e0 * t58 * t81 * t82 - 0.24240600000000000000000000000000000000000000000000e0 * t58 * t86 * t98)
  t120 = t60 ** 2
  t136 = t44 ** 2
  t147 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t54 + 0.16160400000000000000000000000000000000000000000000e0 * t58 * t21 * t61 * t75 + 0.48481200000000000000000000000000000000000000000000e0 * t58 * t59 * t80 * t82 - 0.24240600000000000000000000000000000000000000000000e0 * t58 * t62 * t98 - 0.14544360000000000000000000000000000000000000000000e1 * t58 * t18 / t120 * t82 * t75 + 0.14544360000000000000000000000000000000000000000000e1 * t58 * t81 * t75 * t98 - 0.24240600000000000000000000000000000000000000000000e0 * t58 * t86 * (-0.1540e4 / 0.6561e4 * t28 * t31 / t19 / t45 - 0.16304741809295789214145240074965863877661474884255e-1 * t41 * t43 / t18 / t136))
  v3rho3_0_ = 0.2e1 * r0 * t147 + 0.6e1 * t103

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t36 = t24 ** 2
  t39 = t36 / t26 / t25
  t40 = s0 ** 2
  t41 = t40 * t30
  t42 = t18 ** 2
  t43 = t42 * r0
  t49 = 0.8040e0 + 0.5e1 / 0.972e3 * t29 * t32 * t22 + 0.65823568907145082054713140254796400223812772409524e-4 * t39 * t41 / t19 / t43
  t52 = 0.18040e1 - 0.64641600e0 / t49
  t56 = t6 * t17
  t58 = 0.1e1 / t20 / r0
  t59 = t49 ** 2
  t60 = 0.1e1 / t59
  t61 = t58 * t60
  t62 = t18 * r0
  t64 = 0.1e1 / t20 / t62
  t68 = t42 * t18
  t74 = -0.10e2 / 0.729e3 * t29 * t32 * t64 - 0.35105903417144043762513674802558080119366811951746e-3 * t39 * t41 / t19 / t68
  t78 = 0.1e1 / t20
  t80 = 0.1e1 / t59 / t49
  t81 = t78 * t80
  t82 = t74 ** 2
  t86 = t78 * t60
  t98 = 0.110e3 / 0.2187e4 * t29 * t32 / t20 / t42 + 0.22233738830857894382925327374953450742265647569439e-2 * t39 * t41 / t19 / t42 / t62
  t102 = t59 ** 2
  t103 = 0.1e1 / t102
  t104 = t19 * t103
  t105 = t82 * t74
  t109 = t19 * t80
  t110 = t74 * t98
  t114 = t19 * t60
  t120 = t42 ** 2
  t126 = -0.1540e4 / 0.6561e4 * t29 * t32 / t20 / t43 - 0.16304741809295789214145240074965863877661474884255e-1 * t39 * t41 / t19 / t120
  t131 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t22 * t52 + 0.16160400000000000000000000000000000000000000000000e0 * t56 * t61 * t74 + 0.48481200000000000000000000000000000000000000000000e0 * t56 * t81 * t82 - 0.24240600000000000000000000000000000000000000000000e0 * t56 * t86 * t98 - 0.14544360000000000000000000000000000000000000000000e1 * t56 * t104 * t105 + 0.14544360000000000000000000000000000000000000000000e1 * t56 * t109 * t110 - 0.24240600000000000000000000000000000000000000000000e0 * t56 * t114 * t126)
  t161 = t82 ** 2
  t169 = t98 ** 2
  t192 = 0.10e2 / 0.27e2 * t6 * t17 * t64 * t52 - 0.35912000000000000000000000000000000000000000000000e0 * t56 * t22 * t60 * t74 - 0.64641600000000000000000000000000000000000000000000e0 * t56 * t58 * t80 * t82 + 0.32320800000000000000000000000000000000000000000000e0 * t56 * t61 * t98 - 0.19392480000000000000000000000000000000000000000000e1 * t56 * t78 * t103 * t105 + 0.19392480000000000000000000000000000000000000000000e1 * t56 * t81 * t110 - 0.32320800000000000000000000000000000000000000000000e0 * t56 * t86 * t126 + 0.58177440000000000000000000000000000000000000000000e1 * t56 * t19 / t102 / t49 * t161 - 0.87266160000000000000000000000000000000000000000000e1 * t56 * t104 * t82 * t98 + 0.14544360000000000000000000000000000000000000000000e1 * t56 * t109 * t169 + 0.19392480000000000000000000000000000000000000000000e1 * t56 * t109 * t74 * t126 - 0.24240600000000000000000000000000000000000000000000e0 * t56 * t114 * (0.26180e5 / 0.19683e5 * t29 * t32 / t20 / t68 + 0.13587284841079824345121033395804886564717895736879e0 * t39 * t41 / t19 / t120 / r0)
  t193 = f.my_piecewise3(t2, 0, t192)
  v4rho4_0_ = 0.2e1 * r0 * t193 + 0.8e1 * t131

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t46 = t32 ** 2
  t49 = t46 / t34 / t33
  t50 = s0 ** 2
  t51 = t38 ** 2
  t58 = 0.8040e0 + 0.5e1 / 0.972e3 * t37 * s0 / t40 / t38 + 0.32911784453572541027356570127398200111906386204761e-4 * t49 * t50 / t39 / t51 / r0
  t61 = 0.18040e1 - 0.64641600e0 / t58
  t65 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t66 = t65 * f.p.zeta_threshold
  t68 = f.my_piecewise3(t20, t66, t21 * t19)
  t69 = t30 ** 2
  t70 = 0.1e1 / t69
  t74 = t5 * t68 * t70 * t61 / 0.8e1
  t75 = t5 * t68
  t76 = t58 ** 2
  t77 = 0.1e1 / t76
  t78 = t30 * t77
  t79 = t38 * r0
  t91 = -0.10e2 / 0.729e3 * t37 * s0 / t40 / t79 - 0.17552951708572021881256837401279040059683405975873e-3 * t49 * t50 / t39 / t51 / t38
  t92 = t78 * t91
  t96 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t29 * t30 * t61 - t74 - 0.24240600000000000000000000000000000000000000000000e0 * t75 * t92)
  t98 = r1 <= f.p.dens_threshold
  t99 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t100 = 0.1e1 + t99
  t101 = t100 <= f.p.zeta_threshold
  t102 = t100 ** (0.1e1 / 0.3e1)
  t104 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t107 = f.my_piecewise3(t101, 0, 0.4e1 / 0.3e1 * t102 * t104)
  t109 = r1 ** 2
  t110 = r1 ** (0.1e1 / 0.3e1)
  t111 = t110 ** 2
  t117 = s2 ** 2
  t118 = t109 ** 2
  t125 = 0.8040e0 + 0.5e1 / 0.972e3 * t37 * s2 / t111 / t109 + 0.32911784453572541027356570127398200111906386204761e-4 * t49 * t117 / t110 / t118 / r1
  t128 = 0.18040e1 - 0.64641600e0 / t125
  t133 = f.my_piecewise3(t101, t66, t102 * t100)
  t137 = t5 * t133 * t70 * t128 / 0.8e1
  t139 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t107 * t30 * t128 - t137)
  t141 = t21 ** 2
  t142 = 0.1e1 / t141
  t143 = t26 ** 2
  t148 = t16 / t22 / t6
  t150 = -0.2e1 * t23 + 0.2e1 * t148
  t151 = f.my_piecewise5(t10, 0, t14, 0, t150)
  t155 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t142 * t143 + 0.4e1 / 0.3e1 * t21 * t151)
  t162 = t5 * t29 * t70 * t61
  t168 = 0.1e1 / t69 / t6
  t172 = t5 * t68 * t168 * t61 / 0.12e2
  t175 = t75 * t70 * t77 * t91
  t180 = t91 ** 2
  t200 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t155 * t30 * t61 - t162 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t5 * t29 * t92 + t172 - 0.16160400000000000000000000000000000000000000000000e0 * t175 + 0.48481200000000000000000000000000000000000000000000e0 * t75 * t30 / t76 / t58 * t180 - 0.24240600000000000000000000000000000000000000000000e0 * t75 * t78 * (0.110e3 / 0.2187e4 * t37 * s0 / t40 / t51 + 0.11116869415428947191462663687476725371132823784720e-2 * t49 * t50 / t39 / t51 / t79))
  t201 = t102 ** 2
  t202 = 0.1e1 / t201
  t203 = t104 ** 2
  t207 = f.my_piecewise5(t14, 0, t10, 0, -t150)
  t211 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t202 * t203 + 0.4e1 / 0.3e1 * t102 * t207)
  t218 = t5 * t107 * t70 * t128
  t223 = t5 * t133 * t168 * t128 / 0.12e2
  t225 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t211 * t30 * t128 - t218 / 0.4e1 + t223)
  d11 = 0.2e1 * t96 + 0.2e1 * t139 + t6 * (t200 + t225)
  t228 = -t7 - t24
  t229 = f.my_piecewise5(t10, 0, t14, 0, t228)
  t232 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t229)
  t238 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t30 * t61 - t74)
  t240 = f.my_piecewise5(t14, 0, t10, 0, -t228)
  t243 = f.my_piecewise3(t101, 0, 0.4e1 / 0.3e1 * t102 * t240)
  t248 = t5 * t133
  t249 = t125 ** 2
  t250 = 0.1e1 / t249
  t251 = t30 * t250
  t252 = t109 * r1
  t264 = -0.10e2 / 0.729e3 * t37 * s2 / t111 / t252 - 0.17552951708572021881256837401279040059683405975873e-3 * t49 * t117 / t110 / t118 / t109
  t265 = t251 * t264
  t269 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t243 * t30 * t128 - t137 - 0.24240600000000000000000000000000000000000000000000e0 * t248 * t265)
  t273 = 0.2e1 * t148
  t274 = f.my_piecewise5(t10, 0, t14, 0, t273)
  t278 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t142 * t229 * t26 + 0.4e1 / 0.3e1 * t21 * t274)
  t285 = t5 * t232 * t70 * t61
  t293 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t278 * t30 * t61 - t285 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t5 * t232 * t92 - t162 / 0.8e1 + t172 - 0.80802000000000000000000000000000000000000000000000e-1 * t175)
  t297 = f.my_piecewise5(t14, 0, t10, 0, -t273)
  t301 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t202 * t240 * t104 + 0.4e1 / 0.3e1 * t102 * t297)
  t308 = t5 * t243 * t70 * t128
  t316 = t248 * t70 * t250 * t264
  t319 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t301 * t30 * t128 - t308 / 0.8e1 - t218 / 0.8e1 + t223 - 0.24240600000000000000000000000000000000000000000000e0 * t5 * t107 * t265 - 0.80802000000000000000000000000000000000000000000000e-1 * t316)
  d12 = t96 + t139 + t238 + t269 + t6 * (t293 + t319)
  t324 = t229 ** 2
  t328 = 0.2e1 * t23 + 0.2e1 * t148
  t329 = f.my_piecewise5(t10, 0, t14, 0, t328)
  t333 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t142 * t324 + 0.4e1 / 0.3e1 * t21 * t329)
  t340 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t333 * t30 * t61 - t285 / 0.4e1 + t172)
  t341 = t240 ** 2
  t345 = f.my_piecewise5(t14, 0, t10, 0, -t328)
  t349 = f.my_piecewise3(t101, 0, 0.4e1 / 0.9e1 * t202 * t341 + 0.4e1 / 0.3e1 * t102 * t345)
  t362 = t264 ** 2
  t382 = f.my_piecewise3(t98, 0, -0.3e1 / 0.8e1 * t5 * t349 * t30 * t128 - t308 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t5 * t243 * t265 + t223 - 0.16160400000000000000000000000000000000000000000000e0 * t316 + 0.48481200000000000000000000000000000000000000000000e0 * t248 * t30 / t249 / t125 * t362 - 0.24240600000000000000000000000000000000000000000000e0 * t248 * t251 * (0.110e3 / 0.2187e4 * t37 * s2 / t111 / t118 + 0.11116869415428947191462663687476725371132823784720e-2 * t49 * t117 / t110 / t118 / t252))
  d22 = 0.2e1 * t238 + 0.2e1 * t269 + t6 * (t340 + t382)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = t44 / t47
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t58 = t44 ** 2
  t61 = t58 / t46 / t45
  t62 = s0 ** 2
  t63 = t50 ** 2
  t64 = t63 * r0
  t70 = 0.8040e0 + 0.5e1 / 0.972e3 * t49 * s0 / t52 / t50 + 0.32911784453572541027356570127398200111906386204761e-4 * t61 * t62 / t51 / t64
  t73 = 0.18040e1 - 0.64641600e0 / t70
  t79 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t80 = t42 ** 2
  t81 = 0.1e1 / t80
  t86 = t5 * t79
  t87 = t70 ** 2
  t88 = 0.1e1 / t87
  t89 = t42 * t88
  t90 = t50 * r0
  t102 = -0.10e2 / 0.729e3 * t49 * s0 / t52 / t90 - 0.17552951708572021881256837401279040059683405975873e-3 * t61 * t62 / t51 / t63 / t50
  t103 = t89 * t102
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t107 = t106 * f.p.zeta_threshold
  t109 = f.my_piecewise3(t20, t107, t21 * t19)
  t111 = 0.1e1 / t80 / t6
  t116 = t5 * t109
  t117 = t81 * t88
  t118 = t117 * t102
  t122 = 0.1e1 / t87 / t70
  t123 = t42 * t122
  t124 = t102 ** 2
  t125 = t123 * t124
  t139 = 0.110e3 / 0.2187e4 * t49 * s0 / t52 / t63 + 0.11116869415428947191462663687476725371132823784720e-2 * t61 * t62 / t51 / t63 / t90
  t140 = t89 * t139
  t144 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t41 * t42 * t73 - t5 * t79 * t81 * t73 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t86 * t103 + t5 * t109 * t111 * t73 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t116 * t118 + 0.48481200000000000000000000000000000000000000000000e0 * t116 * t125 - 0.24240600000000000000000000000000000000000000000000e0 * t116 * t140)
  t146 = r1 <= f.p.dens_threshold
  t147 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t148 = 0.1e1 + t147
  t149 = t148 <= f.p.zeta_threshold
  t150 = t148 ** (0.1e1 / 0.3e1)
  t151 = t150 ** 2
  t152 = 0.1e1 / t151
  t154 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t155 = t154 ** 2
  t159 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t163 = f.my_piecewise3(t149, 0, 0.4e1 / 0.9e1 * t152 * t155 + 0.4e1 / 0.3e1 * t150 * t159)
  t165 = r1 ** 2
  t166 = r1 ** (0.1e1 / 0.3e1)
  t167 = t166 ** 2
  t173 = s2 ** 2
  t174 = t165 ** 2
  t184 = 0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t49 * s2 / t167 / t165 + 0.32911784453572541027356570127398200111906386204761e-4 * t61 * t173 / t166 / t174 / r1)
  t190 = f.my_piecewise3(t149, 0, 0.4e1 / 0.3e1 * t150 * t154)
  t196 = f.my_piecewise3(t149, t107, t150 * t148)
  t202 = f.my_piecewise3(t146, 0, -0.3e1 / 0.8e1 * t5 * t163 * t42 * t184 - t5 * t190 * t81 * t184 / 0.4e1 + t5 * t196 * t111 * t184 / 0.12e2)
  t210 = t87 ** 2
  t229 = t24 ** 2
  t233 = 0.6e1 * t33 - 0.6e1 * t16 / t229
  t234 = f.my_piecewise5(t10, 0, t14, 0, t233)
  t238 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t234)
  t259 = 0.1e1 / t80 / t24
  t276 = t63 ** 2
  t286 = 0.14544360000000000000000000000000000000000000000000e1 * t86 * t125 + 0.48481200000000000000000000000000000000000000000000e0 * t116 * t81 * t122 * t124 - 0.14544360000000000000000000000000000000000000000000e1 * t116 * t42 / t210 * t124 * t102 + 0.14544360000000000000000000000000000000000000000000e1 * t116 * t123 * t102 * t139 - 0.3e1 / 0.8e1 * t5 * t238 * t42 * t73 - 0.3e1 / 0.8e1 * t5 * t41 * t81 * t73 - 0.72721800000000000000000000000000000000000000000000e0 * t5 * t41 * t103 + t5 * t79 * t111 * t73 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t86 * t118 - 0.72721800000000000000000000000000000000000000000000e0 * t86 * t140 - 0.5e1 / 0.36e2 * t5 * t109 * t259 * t73 + 0.16160400000000000000000000000000000000000000000000e0 * t116 * t111 * t88 * t102 - 0.24240600000000000000000000000000000000000000000000e0 * t116 * t117 * t139 - 0.24240600000000000000000000000000000000000000000000e0 * t116 * t89 * (-0.1540e4 / 0.6561e4 * t49 * s0 / t52 / t64 - 0.81523709046478946070726200374829319388307374421280e-2 * t61 * t62 / t51 / t276)
  t287 = f.my_piecewise3(t1, 0, t286)
  t297 = f.my_piecewise5(t14, 0, t10, 0, -t233)
  t301 = f.my_piecewise3(t149, 0, -0.8e1 / 0.27e2 / t151 / t148 * t155 * t154 + 0.4e1 / 0.3e1 * t152 * t154 * t159 + 0.4e1 / 0.3e1 * t150 * t297)
  t319 = f.my_piecewise3(t146, 0, -0.3e1 / 0.8e1 * t5 * t301 * t42 * t184 - 0.3e1 / 0.8e1 * t5 * t163 * t81 * t184 + t5 * t190 * t111 * t184 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t196 * t259 * t184)
  d111 = 0.3e1 * t144 + 0.3e1 * t202 + t6 * (t287 + t319)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t25 = -t16 * t23 + t7
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t46 = t32 ** 2
  t49 = t46 / t34 / t33
  t50 = s0 ** 2
  t51 = t38 ** 2
  t52 = t51 * r0
  t58 = 0.8040e0 + 0.5e1 / 0.972e3 * t37 * s0 / t40 / t38 + 0.32911784453572541027356570127398200111906386204761e-4 * t49 * t50 / t39 / t52
  t59 = t58 ** 2
  t61 = 0.1e1 / t59 / t58
  t62 = t31 * t61
  t63 = t38 * r0
  t69 = t51 * t38
  t75 = -0.10e2 / 0.729e3 * t37 * s0 / t40 / t63 - 0.17552951708572021881256837401279040059683405975873e-3 * t49 * t50 / t39 / t69
  t76 = t75 ** 2
  t77 = t62 * t76
  t80 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t81 = t80 * f.p.zeta_threshold
  t83 = f.my_piecewise3(t20, t81, t21 * t19)
  t84 = t5 * t83
  t85 = t31 ** 2
  t86 = 0.1e1 / t85
  t87 = t86 * t61
  t88 = t87 * t76
  t91 = t59 ** 2
  t92 = 0.1e1 / t91
  t93 = t31 * t92
  t94 = t76 * t75
  t95 = t93 * t94
  t109 = 0.110e3 / 0.2187e4 * t37 * s0 / t40 / t51 + 0.11116869415428947191462663687476725371132823784720e-2 * t49 * t50 / t39 / t51 / t63
  t110 = t75 * t109
  t111 = t62 * t110
  t114 = t21 ** 2
  t116 = 0.1e1 / t114 / t19
  t117 = t26 ** 2
  t121 = 0.1e1 / t114
  t122 = t121 * t26
  t123 = t22 * t6
  t124 = 0.1e1 / t123
  t127 = 0.2e1 * t16 * t124 - 0.2e1 * t23
  t128 = f.my_piecewise5(t10, 0, t14, 0, t127)
  t131 = t22 ** 2
  t132 = 0.1e1 / t131
  t135 = -0.6e1 * t16 * t132 + 0.6e1 * t124
  t136 = f.my_piecewise5(t10, 0, t14, 0, t135)
  t140 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t116 * t117 * t26 + 0.4e1 / 0.3e1 * t122 * t128 + 0.4e1 / 0.3e1 * t21 * t136)
  t144 = 0.18040e1 - 0.64641600e0 / t58
  t153 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t121 * t117 + 0.4e1 / 0.3e1 * t21 * t128)
  t158 = t5 * t153
  t159 = 0.1e1 / t59
  t160 = t31 * t159
  t161 = t160 * t75
  t165 = 0.1e1 / t85 / t6
  t170 = t86 * t159
  t171 = t170 * t75
  t174 = t160 * t109
  t178 = 0.1e1 / t85 / t22
  t183 = t165 * t159
  t184 = t183 * t75
  t187 = t170 * t109
  t195 = t51 ** 2
  t201 = -0.1540e4 / 0.6561e4 * t37 * s0 / t40 / t52 - 0.81523709046478946070726200374829319388307374421280e-2 * t49 * t50 / t39 / t195
  t202 = t160 * t201
  t205 = 0.14544360000000000000000000000000000000000000000000e1 * t30 * t77 + 0.48481200000000000000000000000000000000000000000000e0 * t84 * t88 - 0.14544360000000000000000000000000000000000000000000e1 * t84 * t95 + 0.14544360000000000000000000000000000000000000000000e1 * t84 * t111 - 0.3e1 / 0.8e1 * t5 * t140 * t31 * t144 - 0.3e1 / 0.8e1 * t5 * t153 * t86 * t144 - 0.72721800000000000000000000000000000000000000000000e0 * t158 * t161 + t5 * t29 * t165 * t144 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t30 * t171 - 0.72721800000000000000000000000000000000000000000000e0 * t30 * t174 - 0.5e1 / 0.36e2 * t5 * t83 * t178 * t144 + 0.16160400000000000000000000000000000000000000000000e0 * t84 * t184 - 0.24240600000000000000000000000000000000000000000000e0 * t84 * t187 - 0.24240600000000000000000000000000000000000000000000e0 * t84 * t202
  t206 = f.my_piecewise3(t1, 0, t205)
  t208 = r1 <= f.p.dens_threshold
  t209 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t210 = 0.1e1 + t209
  t211 = t210 <= f.p.zeta_threshold
  t212 = t210 ** (0.1e1 / 0.3e1)
  t213 = t212 ** 2
  t215 = 0.1e1 / t213 / t210
  t217 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t218 = t217 ** 2
  t222 = 0.1e1 / t213
  t223 = t222 * t217
  t225 = f.my_piecewise5(t14, 0, t10, 0, -t127)
  t229 = f.my_piecewise5(t14, 0, t10, 0, -t135)
  t233 = f.my_piecewise3(t211, 0, -0.8e1 / 0.27e2 * t215 * t218 * t217 + 0.4e1 / 0.3e1 * t223 * t225 + 0.4e1 / 0.3e1 * t212 * t229)
  t235 = r1 ** 2
  t236 = r1 ** (0.1e1 / 0.3e1)
  t237 = t236 ** 2
  t243 = s2 ** 2
  t244 = t235 ** 2
  t254 = 0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t37 * s2 / t237 / t235 + 0.32911784453572541027356570127398200111906386204761e-4 * t49 * t243 / t236 / t244 / r1)
  t263 = f.my_piecewise3(t211, 0, 0.4e1 / 0.9e1 * t222 * t218 + 0.4e1 / 0.3e1 * t212 * t225)
  t270 = f.my_piecewise3(t211, 0, 0.4e1 / 0.3e1 * t212 * t217)
  t276 = f.my_piecewise3(t211, t81, t212 * t210)
  t282 = f.my_piecewise3(t208, 0, -0.3e1 / 0.8e1 * t5 * t233 * t31 * t254 - 0.3e1 / 0.8e1 * t5 * t263 * t86 * t254 + t5 * t270 * t165 * t254 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t276 * t178 * t254)
  t293 = 0.1e1 / t85 / t123
  t298 = t19 ** 2
  t301 = t117 ** 2
  t307 = t128 ** 2
  t316 = -0.24e2 * t132 + 0.24e2 * t16 / t131 / t6
  t317 = f.my_piecewise5(t10, 0, t14, 0, t316)
  t321 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t114 / t298 * t301 - 0.16e2 / 0.9e1 * t116 * t117 * t128 + 0.4e1 / 0.3e1 * t121 * t307 + 0.16e2 / 0.9e1 * t122 * t136 + 0.4e1 / 0.3e1 * t21 * t317)
  t355 = t5 * t153 * t165 * t144 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t29 * t178 * t144 + 0.10e2 / 0.27e2 * t5 * t83 * t293 * t144 - 0.3e1 / 0.8e1 * t5 * t321 * t31 * t144 - t5 * t140 * t86 * t144 / 0.2e1 + 0.58177440000000000000000000000000000000000000000000e1 * t30 * t111 + 0.19392480000000000000000000000000000000000000000000e1 * t84 * t87 * t110 - 0.87266160000000000000000000000000000000000000000000e1 * t84 * t93 * t76 * t109 + 0.19392480000000000000000000000000000000000000000000e1 * t84 * t62 * t75 * t201 + 0.19392480000000000000000000000000000000000000000000e1 * t30 * t88 - 0.58177440000000000000000000000000000000000000000000e1 * t30 * t95 - 0.64641600000000000000000000000000000000000000000000e0 * t84 * t165 * t61 * t76 - 0.19392480000000000000000000000000000000000000000000e1 * t84 * t86 * t92 * t94
  t359 = t76 ** 2
  t363 = t109 ** 2
  t407 = 0.58177440000000000000000000000000000000000000000000e1 * t84 * t31 / t91 / t58 * t359 + 0.14544360000000000000000000000000000000000000000000e1 * t84 * t62 * t363 + 0.29088720000000000000000000000000000000000000000000e1 * t158 * t77 - 0.96962400000000000000000000000000000000000000000000e0 * t5 * t140 * t161 - 0.96962400000000000000000000000000000000000000000000e0 * t158 * t171 - 0.14544360000000000000000000000000000000000000000000e1 * t158 * t174 + 0.64641600000000000000000000000000000000000000000000e0 * t30 * t184 - 0.96962400000000000000000000000000000000000000000000e0 * t30 * t187 - 0.96962400000000000000000000000000000000000000000000e0 * t30 * t202 - 0.35912000000000000000000000000000000000000000000000e0 * t84 * t178 * t159 * t75 + 0.32320800000000000000000000000000000000000000000000e0 * t84 * t183 * t109 - 0.32320800000000000000000000000000000000000000000000e0 * t84 * t170 * t201 - 0.24240600000000000000000000000000000000000000000000e0 * t84 * t160 * (0.26180e5 / 0.19683e5 * t37 * s0 / t40 / t69 + 0.67936424205399121725605166979024432823589478684400e-1 * t49 * t50 / t39 / t195 / r0)
  t409 = f.my_piecewise3(t1, 0, t355 + t407)
  t410 = t210 ** 2
  t413 = t218 ** 2
  t419 = t225 ** 2
  t425 = f.my_piecewise5(t14, 0, t10, 0, -t316)
  t429 = f.my_piecewise3(t211, 0, 0.40e2 / 0.81e2 / t213 / t410 * t413 - 0.16e2 / 0.9e1 * t215 * t218 * t225 + 0.4e1 / 0.3e1 * t222 * t419 + 0.16e2 / 0.9e1 * t223 * t229 + 0.4e1 / 0.3e1 * t212 * t425)
  t451 = f.my_piecewise3(t208, 0, -0.3e1 / 0.8e1 * t5 * t429 * t31 * t254 - t5 * t233 * t86 * t254 / 0.2e1 + t5 * t263 * t165 * t254 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t270 * t178 * t254 + 0.10e2 / 0.27e2 * t5 * t276 * t293 * t254)
  d1111 = 0.4e1 * t206 + 0.4e1 * t282 + t6 * (t409 + t451)

  res = {'v4rho4': d1111}
  return res
