"""Generated from lda_c_pk09.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a_24_i = np.array([np.nan, -113.69336978972719, 24.005021512787113, 49.341312958396706, -23.82423721683793, 0.9440807416951048, 0.000293039144178338], dtype=np.float64)

  b_24_i = np.array([np.nan, -109.7426349321691, 16.266312944424243, 54.403433137390834, -25.15400990418799, 1.0], dtype=np.float64)

  c_25_i = np.array([np.nan, -0.32481568604919886, 1.1801314654631911, -1.4269304149842164, 0.580344063812248, -0.0109912236729144], dtype=np.float64)

  d_25_i = np.array([np.nan, -0.5778610319323944, 2.0970850588349075, -2.5218818358694817, 1.0], dtype=np.float64)

  eta6 = 0.41081146652128

  eta7 = 0.599343256903515

  eta8 = 1.70939476802168

  eta9 = 0.077123208419481

  eta10 = 0.46958449007619

  eta1 = 0.538074483500437

  eta2 = -2.22609499098519

  eta3 = 0.837303782322808

  eta4 = 2.619709858963178

  eta5 = 1.03665759464352

  ax = (3 * jnp.pi ** 2) ** (1 / 3)

  a1 = 0.1846304394851914

  a2 = 5.939656549519008

  a3 = 2.369580128666418

  a4 = 0.05118886552595877

  a5 = 0.09576892532004282

  a6 = 0.028359261614488256

  a7 = 0.02262741699796952

  a8 = 0.005317361552716548

  a9 = 0.1915378506400854

  a10 = 0.1473137771194929

  a11 = 0.1528250938350897

  a12 = 1.0150830754383913

  a13 = 0.07641254691754473

  a14 = 0.8985374602634734

  a15 = 0.01795667349750801

  a16 = 0.0346182074034769

  a17 = 0.03591334699501599

  a18 = 0.2220173534761558

  c1 = 132.47909028779435

  c2 = 32.40147085167714

  c3 = 22.56644531625038

  c4 = 11.28322265812519

  c5 = 0.4010605239409601

  c6 = 0.32

  c7 = 0.07519884823893001

  c8 = 116.93504264748091

  c9 = 29.62400230469013

  c10 = 0.4822571819944727

  c11 = 0.24690398117909756

  c12 = 1 / 2

  c13 = 0.4107096967781855

  c14 = 0.10532352447676886

  c15 = 14.565097171165966

  c16 = 0.78125

  c17 = 0.6233473131272386

  c18 = 0.146484375

  c19 = 111.81154810579778

  c20 = 0.16004110557090126

  c21 = 0.78125

  c22 = 0.3208669506079574

  c23 = 13.284449507299843

  c24 = 0.26841867131910735

  c25 = 0.4710605979349919

  c26 = 1 / 4

  c27 = 0.2528829196169895

  c28 = 0.07204858311271498

  c29 = 42.64905448910311

  f_r = lambda rs: jnp.sum(jnp.array([a_24_i[i] * rs ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([b_24_i[i] * rs ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  f_s = lambda z: jnp.sum(jnp.array([c_25_i[i] * z ** (i - 1) for i in range(1, 5 + 1)]), axis=0) / jnp.sum(jnp.array([d_25_i[i] * z ** (i - 1) for i in range(1, 4 + 1)]), axis=0)

  alpha_n = lambda rs: +eta6 + eta7 * jnp.exp(-eta8 * rs ** (1 / 3)) * rs ** (2 / 3) + eta9 * jnp.exp(-eta10 * rs ** (1 / 3)) * rs ** (1 / 3)

  beta_eff = lambda rs: +eta1 + eta2 * jnp.exp(-eta3 * rs ** (1 / 3)) * rs ** (1 / 4) + eta4 * jnp.exp(-eta5 * rs ** (1 / 3)) * rs ** (1 / 3)

  k_fs = lambda rs, z: ax * f.RS_FACTOR / rs * f.opz_pow_n(z, 1 / 3)

  D_1 = lambda k: a6 * k ** 2 + a7 * k + a8

  D_3 = lambda k: a5 * k ** 2 + a13 * k + a15

  D_2 = lambda k: a1 * k ** 2 + a10 * k + a16

  D_4 = lambda k: a9 * k ** 2 + a11 * k + a17

  D_5 = lambda k: c5 * k ** 2 + c6 * k + c7

  D_6 = lambda k: c12 * k ** 2 + c13 * k + c14

  D_7 = lambda k: c16 * k ** 2 + c17 * k + c18

  D_8 = lambda k: jnp.sqrt(c26 * k ** 2 + c27 * k + c28)

  ss = lambda rs, z: f_r(rs) * f_s(z) * 1.28

  k_ud = lambda rs, z: beta_eff(rs) * 2 * k_fs(rs, z) * k_fs(rs, -z) / (k_fs(rs, z) + k_fs(rs, -z))

  Q_1ud = lambda k: 1 / D_1(k) * (-jnp.arctan(a2 * k + a3) * D_2(k) / k - jnp.log(D_1(k)) * D_3(k) / k + jnp.log(k) * D_4(k) / k - a4 * k + a12 + a14 / k + a18 / k ** 2)

  Q_2ud = lambda k: -c1 / k - c2 / k ** 2 - c3 * jnp.log(k) / k + c4 * jnp.log(D_5(k)) / k + c8 * jnp.arctan(a2 * k + a3) / k + c9 * jnp.log(k + c10) / k - c11 / k * jnp.log(D_6(k))

  Q_3ud = lambda k: +c19 * jnp.arctan(c20 / (c21 * k + c22)) / k - c23 * jnp.arctanh((c24 + c25 * k) / D_8(k)) / k - c15 * jnp.log(D_7(k)) / k - c29 * D_8(k) / k ** 2

  alpha_z = lambda rs, z: 2 / (f.opz_pow_n(z, ss(rs, z)) + f.opz_pow_n(-z, ss(rs, z)))

  ec_opp = lambda rs, z: (1 - z ** 2) / 4 * (Q_1ud(k_ud(rs, z)) + Q_2ud(k_ud(rs, z)) + Q_3ud(k_ud(rs, z)))

  alpha_eff = lambda rs, z: alpha_n(rs) * alpha_z(rs, z)

  k_uu = lambda rs, z: alpha_eff(rs, z) * k_fs(rs, z)

  k_dd = lambda rs, z: alpha_eff(rs, -z) * k_fs(rs, -z)

  ec_par = lambda rs, z: +f.opz_pow_n(z, 2) / 8 * (Q_1ud(k_uu(rs, z)) + Q_2ud(k_uu(rs, z)) + Q_3ud(k_uu(rs, z))) + f.opz_pow_n(-z, 2) / 8 * (Q_1ud(k_dd(rs, z)) + Q_2ud(k_dd(rs, z)) + Q_3ud(k_dd(rs, z)))

  functional_body = lambda rs, z: f.n_total(rs) * (ec_opp(rs, z) + ec_par(rs, z))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a_24_i = np.array([np.nan, -113.69336978972719, 24.005021512787113, 49.341312958396706, -23.82423721683793, 0.9440807416951048, 0.000293039144178338], dtype=np.float64)

  b_24_i = np.array([np.nan, -109.7426349321691, 16.266312944424243, 54.403433137390834, -25.15400990418799, 1.0], dtype=np.float64)

  c_25_i = np.array([np.nan, -0.32481568604919886, 1.1801314654631911, -1.4269304149842164, 0.580344063812248, -0.0109912236729144], dtype=np.float64)

  d_25_i = np.array([np.nan, -0.5778610319323944, 2.0970850588349075, -2.5218818358694817, 1.0], dtype=np.float64)

  eta6 = 0.41081146652128

  eta7 = 0.599343256903515

  eta8 = 1.70939476802168

  eta9 = 0.077123208419481

  eta10 = 0.46958449007619

  eta1 = 0.538074483500437

  eta2 = -2.22609499098519

  eta3 = 0.837303782322808

  eta4 = 2.619709858963178

  eta5 = 1.03665759464352

  ax = (3 * jnp.pi ** 2) ** (1 / 3)

  a1 = 0.1846304394851914

  a2 = 5.939656549519008

  a3 = 2.369580128666418

  a4 = 0.05118886552595877

  a5 = 0.09576892532004282

  a6 = 0.028359261614488256

  a7 = 0.02262741699796952

  a8 = 0.005317361552716548

  a9 = 0.1915378506400854

  a10 = 0.1473137771194929

  a11 = 0.1528250938350897

  a12 = 1.0150830754383913

  a13 = 0.07641254691754473

  a14 = 0.8985374602634734

  a15 = 0.01795667349750801

  a16 = 0.0346182074034769

  a17 = 0.03591334699501599

  a18 = 0.2220173534761558

  c1 = 132.47909028779435

  c2 = 32.40147085167714

  c3 = 22.56644531625038

  c4 = 11.28322265812519

  c5 = 0.4010605239409601

  c6 = 0.32

  c7 = 0.07519884823893001

  c8 = 116.93504264748091

  c9 = 29.62400230469013

  c10 = 0.4822571819944727

  c11 = 0.24690398117909756

  c12 = 1 / 2

  c13 = 0.4107096967781855

  c14 = 0.10532352447676886

  c15 = 14.565097171165966

  c16 = 0.78125

  c17 = 0.6233473131272386

  c18 = 0.146484375

  c19 = 111.81154810579778

  c20 = 0.16004110557090126

  c21 = 0.78125

  c22 = 0.3208669506079574

  c23 = 13.284449507299843

  c24 = 0.26841867131910735

  c25 = 0.4710605979349919

  c26 = 1 / 4

  c27 = 0.2528829196169895

  c28 = 0.07204858311271498

  c29 = 42.64905448910311

  f_r = lambda rs: jnp.sum(jnp.array([a_24_i[i] * rs ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([b_24_i[i] * rs ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  f_s = lambda z: jnp.sum(jnp.array([c_25_i[i] * z ** (i - 1) for i in range(1, 5 + 1)]), axis=0) / jnp.sum(jnp.array([d_25_i[i] * z ** (i - 1) for i in range(1, 4 + 1)]), axis=0)

  alpha_n = lambda rs: +eta6 + eta7 * jnp.exp(-eta8 * rs ** (1 / 3)) * rs ** (2 / 3) + eta9 * jnp.exp(-eta10 * rs ** (1 / 3)) * rs ** (1 / 3)

  beta_eff = lambda rs: +eta1 + eta2 * jnp.exp(-eta3 * rs ** (1 / 3)) * rs ** (1 / 4) + eta4 * jnp.exp(-eta5 * rs ** (1 / 3)) * rs ** (1 / 3)

  k_fs = lambda rs, z: ax * f.RS_FACTOR / rs * f.opz_pow_n(z, 1 / 3)

  D_1 = lambda k: a6 * k ** 2 + a7 * k + a8

  D_3 = lambda k: a5 * k ** 2 + a13 * k + a15

  D_2 = lambda k: a1 * k ** 2 + a10 * k + a16

  D_4 = lambda k: a9 * k ** 2 + a11 * k + a17

  D_5 = lambda k: c5 * k ** 2 + c6 * k + c7

  D_6 = lambda k: c12 * k ** 2 + c13 * k + c14

  D_7 = lambda k: c16 * k ** 2 + c17 * k + c18

  D_8 = lambda k: jnp.sqrt(c26 * k ** 2 + c27 * k + c28)

  ss = lambda rs, z: f_r(rs) * f_s(z) * 1.28

  k_ud = lambda rs, z: beta_eff(rs) * 2 * k_fs(rs, z) * k_fs(rs, -z) / (k_fs(rs, z) + k_fs(rs, -z))

  Q_1ud = lambda k: 1 / D_1(k) * (-jnp.arctan(a2 * k + a3) * D_2(k) / k - jnp.log(D_1(k)) * D_3(k) / k + jnp.log(k) * D_4(k) / k - a4 * k + a12 + a14 / k + a18 / k ** 2)

  Q_2ud = lambda k: -c1 / k - c2 / k ** 2 - c3 * jnp.log(k) / k + c4 * jnp.log(D_5(k)) / k + c8 * jnp.arctan(a2 * k + a3) / k + c9 * jnp.log(k + c10) / k - c11 / k * jnp.log(D_6(k))

  Q_3ud = lambda k: +c19 * jnp.arctan(c20 / (c21 * k + c22)) / k - c23 * jnp.arctanh((c24 + c25 * k) / D_8(k)) / k - c15 * jnp.log(D_7(k)) / k - c29 * D_8(k) / k ** 2

  alpha_z = lambda rs, z: 2 / (f.opz_pow_n(z, ss(rs, z)) + f.opz_pow_n(-z, ss(rs, z)))

  ec_opp = lambda rs, z: (1 - z ** 2) / 4 * (Q_1ud(k_ud(rs, z)) + Q_2ud(k_ud(rs, z)) + Q_3ud(k_ud(rs, z)))

  alpha_eff = lambda rs, z: alpha_n(rs) * alpha_z(rs, z)

  k_uu = lambda rs, z: alpha_eff(rs, z) * k_fs(rs, z)

  k_dd = lambda rs, z: alpha_eff(rs, -z) * k_fs(rs, -z)

  ec_par = lambda rs, z: +f.opz_pow_n(z, 2) / 8 * (Q_1ud(k_uu(rs, z)) + Q_2ud(k_uu(rs, z)) + Q_3ud(k_uu(rs, z))) + f.opz_pow_n(-z, 2) / 8 * (Q_1ud(k_dd(rs, z)) + Q_2ud(k_dd(rs, z)) + Q_3ud(k_dd(rs, z)))

  functional_body = lambda rs, z: f.n_total(rs) * (ec_opp(rs, z) + ec_par(rs, z))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a_24_i = np.array([np.nan, -113.69336978972719, 24.005021512787113, 49.341312958396706, -23.82423721683793, 0.9440807416951048, 0.000293039144178338], dtype=np.float64)

  b_24_i = np.array([np.nan, -109.7426349321691, 16.266312944424243, 54.403433137390834, -25.15400990418799, 1.0], dtype=np.float64)

  c_25_i = np.array([np.nan, -0.32481568604919886, 1.1801314654631911, -1.4269304149842164, 0.580344063812248, -0.0109912236729144], dtype=np.float64)

  d_25_i = np.array([np.nan, -0.5778610319323944, 2.0970850588349075, -2.5218818358694817, 1.0], dtype=np.float64)

  eta6 = 0.41081146652128

  eta7 = 0.599343256903515

  eta8 = 1.70939476802168

  eta9 = 0.077123208419481

  eta10 = 0.46958449007619

  eta1 = 0.538074483500437

  eta2 = -2.22609499098519

  eta3 = 0.837303782322808

  eta4 = 2.619709858963178

  eta5 = 1.03665759464352

  ax = (3 * jnp.pi ** 2) ** (1 / 3)

  a1 = 0.1846304394851914

  a2 = 5.939656549519008

  a3 = 2.369580128666418

  a4 = 0.05118886552595877

  a5 = 0.09576892532004282

  a6 = 0.028359261614488256

  a7 = 0.02262741699796952

  a8 = 0.005317361552716548

  a9 = 0.1915378506400854

  a10 = 0.1473137771194929

  a11 = 0.1528250938350897

  a12 = 1.0150830754383913

  a13 = 0.07641254691754473

  a14 = 0.8985374602634734

  a15 = 0.01795667349750801

  a16 = 0.0346182074034769

  a17 = 0.03591334699501599

  a18 = 0.2220173534761558

  c1 = 132.47909028779435

  c2 = 32.40147085167714

  c3 = 22.56644531625038

  c4 = 11.28322265812519

  c5 = 0.4010605239409601

  c6 = 0.32

  c7 = 0.07519884823893001

  c8 = 116.93504264748091

  c9 = 29.62400230469013

  c10 = 0.4822571819944727

  c11 = 0.24690398117909756

  c12 = 1 / 2

  c13 = 0.4107096967781855

  c14 = 0.10532352447676886

  c15 = 14.565097171165966

  c16 = 0.78125

  c17 = 0.6233473131272386

  c18 = 0.146484375

  c19 = 111.81154810579778

  c20 = 0.16004110557090126

  c21 = 0.78125

  c22 = 0.3208669506079574

  c23 = 13.284449507299843

  c24 = 0.26841867131910735

  c25 = 0.4710605979349919

  c26 = 1 / 4

  c27 = 0.2528829196169895

  c28 = 0.07204858311271498

  c29 = 42.64905448910311

  f_r = lambda rs: jnp.sum(jnp.array([a_24_i[i] * rs ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([b_24_i[i] * rs ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  f_s = lambda z: jnp.sum(jnp.array([c_25_i[i] * z ** (i - 1) for i in range(1, 5 + 1)]), axis=0) / jnp.sum(jnp.array([d_25_i[i] * z ** (i - 1) for i in range(1, 4 + 1)]), axis=0)

  alpha_n = lambda rs: +eta6 + eta7 * jnp.exp(-eta8 * rs ** (1 / 3)) * rs ** (2 / 3) + eta9 * jnp.exp(-eta10 * rs ** (1 / 3)) * rs ** (1 / 3)

  beta_eff = lambda rs: +eta1 + eta2 * jnp.exp(-eta3 * rs ** (1 / 3)) * rs ** (1 / 4) + eta4 * jnp.exp(-eta5 * rs ** (1 / 3)) * rs ** (1 / 3)

  k_fs = lambda rs, z: ax * f.RS_FACTOR / rs * f.opz_pow_n(z, 1 / 3)

  D_1 = lambda k: a6 * k ** 2 + a7 * k + a8

  D_3 = lambda k: a5 * k ** 2 + a13 * k + a15

  D_2 = lambda k: a1 * k ** 2 + a10 * k + a16

  D_4 = lambda k: a9 * k ** 2 + a11 * k + a17

  D_5 = lambda k: c5 * k ** 2 + c6 * k + c7

  D_6 = lambda k: c12 * k ** 2 + c13 * k + c14

  D_7 = lambda k: c16 * k ** 2 + c17 * k + c18

  D_8 = lambda k: jnp.sqrt(c26 * k ** 2 + c27 * k + c28)

  ss = lambda rs, z: f_r(rs) * f_s(z) * 1.28

  k_ud = lambda rs, z: beta_eff(rs) * 2 * k_fs(rs, z) * k_fs(rs, -z) / (k_fs(rs, z) + k_fs(rs, -z))

  Q_1ud = lambda k: 1 / D_1(k) * (-jnp.arctan(a2 * k + a3) * D_2(k) / k - jnp.log(D_1(k)) * D_3(k) / k + jnp.log(k) * D_4(k) / k - a4 * k + a12 + a14 / k + a18 / k ** 2)

  Q_2ud = lambda k: -c1 / k - c2 / k ** 2 - c3 * jnp.log(k) / k + c4 * jnp.log(D_5(k)) / k + c8 * jnp.arctan(a2 * k + a3) / k + c9 * jnp.log(k + c10) / k - c11 / k * jnp.log(D_6(k))

  Q_3ud = lambda k: +c19 * jnp.arctan(c20 / (c21 * k + c22)) / k - c23 * jnp.arctanh((c24 + c25 * k) / D_8(k)) / k - c15 * jnp.log(D_7(k)) / k - c29 * D_8(k) / k ** 2

  alpha_z = lambda rs, z: 2 / (f.opz_pow_n(z, ss(rs, z)) + f.opz_pow_n(-z, ss(rs, z)))

  ec_opp = lambda rs, z: (1 - z ** 2) / 4 * (Q_1ud(k_ud(rs, z)) + Q_2ud(k_ud(rs, z)) + Q_3ud(k_ud(rs, z)))

  alpha_eff = lambda rs, z: alpha_n(rs) * alpha_z(rs, z)

  k_uu = lambda rs, z: alpha_eff(rs, z) * k_fs(rs, z)

  k_dd = lambda rs, z: alpha_eff(rs, -z) * k_fs(rs, -z)

  ec_par = lambda rs, z: +f.opz_pow_n(z, 2) / 8 * (Q_1ud(k_uu(rs, z)) + Q_2ud(k_uu(rs, z)) + Q_3ud(k_uu(rs, z))) + f.opz_pow_n(-z, 2) / 8 * (Q_1ud(k_dd(rs, z)) + Q_2ud(k_dd(rs, z)) + Q_3ud(k_dd(rs, z)))

  functional_body = lambda rs, z: f.n_total(rs) * (ec_opp(rs, z) + ec_par(rs, z))

  t1 = r0 + r1
  t2 = r0 - r1
  t3 = t2 ** 2
  t4 = t1 ** 2
  t5 = 0.1e1 / t4
  t6 = t3 * t5
  t8 = 0.1e1 / 0.4e1 - t6 / 0.4e1
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = 3 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 / jnp.pi
  t13 = t12 ** (0.1e1 / 0.3e1)
  t14 = t11 * t13
  t15 = t1 ** (0.1e1 / 0.3e1)
  t16 = 0.1e1 / t15
  t18 = t14 * t10 * t16
  t19 = t18 ** (0.1e1 / 0.3e1)
  t20 = t10 * t19
  t22 = jnp.exp(-0.20932594558070200000000000000000000000000000000000e0 * t20)
  t23 = 4 ** (0.1e1 / 0.4e1)
  t24 = t23 ** 2
  t27 = t18 ** (0.1e1 / 0.4e1)
  t31 = jnp.exp(-0.25916439866088000000000000000000000000000000000000e0 * t20)
  t35 = 0.1076148967000874e1 - 0.11130474954925950000000000000000000000000000000000e1 * t22 * t24 * t23 * t27 + 0.13098549294815890000000000000000000000000000000000e1 * t31 * t10 * t19
  t36 = t35 ** 2
  t37 = t36 * t11
  t38 = jnp.pi ** 2
  t39 = t38 ** (0.1e1 / 0.3e1)
  t40 = t39 * t38
  t41 = t37 * t40
  t42 = t15 * t1
  t43 = 0.1e1 / t1
  t44 = t2 * t43
  t45 = 0.1e1 + t44
  t46 = t45 <= f.p.zeta_threshold
  t47 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t48 = t45 ** (0.1e1 / 0.3e1)
  t49 = f.my_piecewise3(t46, t47, t48)
  t50 = t49 ** 2
  t52 = 0.1e1 - t44
  t53 = t52 <= f.p.zeta_threshold
  t54 = t52 ** (0.1e1 / 0.3e1)
  t55 = f.my_piecewise3(t53, t47, t54)
  t56 = t55 ** 2
  t57 = t11 * t39
  t62 = t57 * t15 * t49 + t57 * t15 * t55
  t63 = t62 ** 2
  t64 = 0.1e1 / t63
  t65 = t56 * t64
  t67 = t41 * t42 * t50 * t65
  t69 = t11 ** 2
  t70 = t35 * t69
  t71 = t39 ** 2
  t72 = t70 * t71
  t73 = t15 ** 2
  t74 = t73 * t49
  t75 = 0.1e1 / t62
  t76 = t55 * t75
  t77 = t74 * t76
  t78 = t72 * t77
  t80 = 0.850777848434647695e-1 * t67 + 0.226274169979695208e-1 * t78 + 0.531736155271654809e-2
  t81 = 0.1e1 / t80
  t83 = 0.593965654951900799e1 * t78 + 0.236958012866641818e1
  t84 = jnp.arctan(t83)
  t87 = 0.5538913184555742e0 * t67 + 0.1473137771194929e0 * t78 + 0.3461820740347690e-1
  t88 = t84 * t87
  t89 = 0.1e1 / t35
  t90 = t89 * t11
  t91 = t88 * t90
  t92 = 0.1e1 / t71
  t93 = 0.1e1 / t73
  t94 = t92 * t93
  t95 = 0.1e1 / t49
  t96 = 0.1e1 / t55
  t97 = t95 * t96
  t98 = t97 * t62
  t99 = t94 * t98
  t102 = jnp.log(t80)
  t105 = 0.28730677596012843e0 * t67 + 0.7641254691754473e-1 * t78 + 0.1795667349750801e-1
  t106 = t102 * t105
  t107 = t106 * t90
  t110 = jnp.log(t78)
  t113 = 0.5746135519202562e0 * t67 + 0.1528250938350897e0 * t78 + 0.3591334699501599e-1
  t114 = t110 * t113
  t115 = t114 * t90
  t119 = t90 * t92
  t120 = t93 * t95
  t121 = t96 * t62
  t122 = t120 * t121
  t123 = t119 * t122
  t125 = 0.1e1 / t36
  t126 = t125 * t69
  t127 = 0.1e1 / t40
  t128 = t126 * t127
  t129 = 0.1e1 / t42
  t130 = 0.1e1 / t50
  t131 = t129 * t130
  t132 = 0.1e1 / t56
  t133 = t132 * t63
  t134 = t131 * t133
  t135 = t128 * t134
  t137 = -t91 * t99 / 0.3e1 - t107 * t99 / 0.3e1 + t115 * t99 / 0.3e1 - 0.51188865525958770e-1 * t78 + 0.101508307543839117e1 + 0.29951248675449113666666666666666666666666666666667e0 * t123 + 0.24668594830683977666666666666666666666666666666667e-1 * t135
  t142 = t11 * t92
  t143 = t110 * t89 * t142
  t148 = 0.1203181571822880246e1 * t67 + 0.32e0 * t78 + 0.751988482389300153e-1
  t149 = jnp.log(t148)
  t151 = t149 * t89 * t142
  t155 = t84 * t89 * t142
  t158 = t78 + 0.482257181994472723e0
  t159 = jnp.log(t158)
  t161 = t159 * t89 * t142
  t164 = t90 * t94
  t167 = 0.15000000000000000000000000000000000000000000000000e1 * t67 + 0.410709696778185459e0 * t78 + 0.105323524476768857e0
  t168 = jnp.log(t167)
  t169 = t62 * t168
  t170 = t97 * t169
  t174 = 0.78125e0 * t78 + 0.32086695060795739e0
  t177 = jnp.arctan(0.160041105570901272e0 / t174)
  t179 = t177 * t89 * t142
  t183 = 0.268418671319107341e0 + 0.471060597934991862e0 * t78
  t186 = 0.75000000000000000000000000000000000000000000000000e0 * t67 + 0.252882919616989509e0 * t78 + 0.720485831127149779e-1
  t187 = jnp.sqrt(t186)
  t188 = 0.1e1 / t187
  t190 = jnp.arctanh(t183 * t188)
  t192 = t190 * t89 * t142
  t197 = 0.2343750000000000000e1 * t67 + 0.623347313127238558e0 * t78 + 0.146484374999999999e0
  t198 = jnp.log(t197)
  t200 = t198 * t89 * t142
  t204 = t69 * t127
  t205 = t187 * t125 * t204
  t208 = t81 * t137 - 0.44159696762598118333333333333333333333333333333333e2 * t123 - 0.36001634279641263111111111111111111111111111111111e1 * t135 - 0.75221484387501268666666666666666666666666666666667e1 * t143 * t122 + 0.37610742193750634333333333333333333333333333333333e1 * t151 * t122 + 0.38978347549160303333333333333333333333333333333333e2 * t155 * t122 + 0.98746674348967096333333333333333333333333333333333e1 * t161 * t122 - 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t170 + 0.37270516035265929333333333333333333333333333333333e2 * t179 * t122 - 0.44281498357666145333333333333333333333333333333333e1 * t192 * t122 - 0.48550323903886556666666666666666666666666666666667e1 * t200 * t122 - 0.47387838321225674777777777777777777777777777777778e1 * t205 * t134
  t210 = f.p.zeta_threshold ** 2
  t211 = t45 ** 2
  t212 = f.my_piecewise3(t46, t210, t211)
  t214 = jnp.exp(-0.42734869200542000000000000000000000000000000000000e0 * t20)
  t216 = t19 ** 2
  t220 = jnp.exp(-0.11739612251904750000000000000000000000000000000000e0 * t20)
  t224 = 0.41081146652128e0 + 0.14983581422587875000000000000000000000000000000000e0 * t214 * t9 * t216 + 0.19280802104870250000000000000000000000000000000000e-1 * t220 * t10 * t19
  t225 = t224 ** 2
  t227 = t13 ** 2
  t228 = t69 * t227
  t230 = t228 * t9 * t93
  t232 = t12 * t43
  t235 = t11 * t13 * t12
  t236 = t10 * t129
  t237 = t235 * t236
  t240 = t69 * t227 * t12
  t242 = 0.1e1 / t73 / t1
  t243 = t9 * t242
  t246 = -0.113693369789727190e3 + 0.60012553781967786000000000000000000000000000000000e1 * t18 + 0.12335328239599176875000000000000000000000000000000e2 * t230 - 0.17868177912628447650000000000000000000000000000000e2 * t232 + 0.17701513906783214887500000000000000000000000000000e0 * t237 + 0.54944839533438375000000000000000000000000000000000e-4 * t240 * t243
  t251 = -0.10974263493216910e3 + 0.40665782361060603750000000000000000000000000000000e1 * t18 + 0.13600858284347709150000000000000000000000000000000e2 * t230 - 0.18865507428140992500000000000000000000000000000000e2 * t232 + 0.18750000000000000000000000000000000000000000000000e0 * t237
  t252 = 0.1e1 / t251
  t253 = t246 * t252
  t254 = 0.1180131465463191050e1 * t44
  t255 = 0.142693041498421640e1 * t6
  t256 = t3 * t2
  t258 = 0.1e1 / t4 / t1
  t259 = t256 * t258
  t260 = 0.580344063812247980e0 * t259
  t261 = t3 ** 2
  t262 = t4 ** 2
  t263 = 0.1e1 / t262
  t265 = 0.1099122367291440e-1 * t261 * t263
  t266 = -0.32481568604919886e0 + t254 - t255 + t260 - t265
  t267 = 0.209708505883490736e1 * t44
  t268 = 0.252188183586948180e1 * t6
  t269 = 0.10e1 * t259
  t270 = -0.57786103193239430e0 + t267 - t268 + t269
  t271 = 0.1e1 / t270
  t272 = t266 * t271
  t274 = 0.128e1 * t253 * t272
  t275 = f.p.zeta_threshold ** t274
  t276 = t45 ** t274
  t277 = f.my_piecewise3(t46, t275, t276)
  t278 = t52 ** t274
  t279 = f.my_piecewise3(t53, t275, t278)
  t280 = t277 + t279
  t281 = t280 ** 2
  t282 = 0.1e1 / t281
  t284 = t225 * t282 * t69
  t285 = t71 * t73
  t287 = t284 * t285 * t50
  t289 = 0.1e1 / t280
  t291 = t224 * t289 * t11
  t292 = t39 * t15
  t293 = t292 * t49
  t294 = t291 * t293
  t296 = 0.1134370464579530260e0 * t287 + 0.452548339959390416e-1 * t294 + 0.531736155271654809e-2
  t297 = 0.1e1 / t296
  t299 = 0.1187931309903801598e2 * t294 + 0.236958012866641818e1
  t300 = jnp.arctan(t299)
  t303 = 0.7385217579407656e0 * t287 + 0.2946275542389858e0 * t294 + 0.3461820740347690e-1
  t304 = t300 * t303
  t305 = 0.1e1 / t224
  t306 = t305 * t280
  t307 = t304 * t306
  t308 = 0.1e1 / t39
  t309 = t69 * t308
  t310 = t16 * t95
  t311 = t309 * t310
  t314 = jnp.log(t296)
  t317 = 0.38307570128017124e0 * t287 + 0.15282509383508946e0 * t294 + 0.1795667349750801e-1
  t318 = t314 * t317
  t319 = t318 * t306
  t322 = 0.2e1 * t294
  t323 = jnp.log(t322)
  t326 = 0.7661514025603416e0 * t287 + 0.3056501876701794e0 * t294 + 0.3591334699501599e-1
  t327 = t323 * t326
  t328 = t327 * t306
  t332 = t306 * t69
  t333 = t308 * t16
  t334 = t333 * t95
  t335 = t332 * t334
  t337 = 0.1e1 / t225
  t339 = t337 * t281 * t11
  t341 = t339 * t94 * t130
  t343 = -t307 * t311 / 0.6e1 - t319 * t311 / 0.6e1 + t328 * t311 / 0.6e1 - 0.102377731051917540e0 * t294 + 0.101508307543839117e1 + 0.14975624337724556833333333333333333333333333333333e0 * t335 + 0.18501446123012983250000000000000000000000000000000e-1 * t341
  t347 = t323 * t305
  t348 = t347 * t280
  t353 = 0.1604242095763840328e1 * t287 + 0.64e0 * t294 + 0.751988482389300153e-1
  t354 = jnp.log(t353)
  t355 = t354 * t305
  t356 = t355 * t280
  t359 = t300 * t305
  t360 = t359 * t280
  t363 = t322 + 0.482257181994472723e0
  t364 = jnp.log(t363)
  t365 = t364 * t305
  t366 = t365 * t280
  t371 = 0.20000000000000000000000000000000000000000000000000e1 * t287 + 0.821419393556370918e0 * t294 + 0.105323524476768857e0
  t372 = jnp.log(t371)
  t373 = t95 * t372
  t374 = t333 * t373
  t378 = 0.156250e1 * t294 + 0.32086695060795739e0
  t381 = jnp.arctan(0.160041105570901272e0 / t378)
  t382 = t381 * t305
  t383 = t382 * t280
  t387 = 0.268418671319107341e0 + 0.942121195869983724e0 * t294
  t390 = 0.10000000000000000000000000000000000000000000000000e1 * t287 + 0.505765839233979018e0 * t294 + 0.720485831127149779e-1
  t391 = jnp.sqrt(t390)
  t392 = 0.1e1 / t391
  t394 = jnp.arctanh(t387 * t392)
  t395 = t394 * t305
  t396 = t395 * t280
  t401 = 0.3125000000000000000e1 * t287 + 0.1246694626254477116e1 * t294 + 0.146484374999999999e0
  t402 = jnp.log(t401)
  t403 = t402 * t305
  t404 = t403 * t280
  t407 = t391 * t337
  t408 = t407 * t281
  t409 = t93 * t130
  t410 = t142 * t409
  t413 = t297 * t343 - 0.22079848381299059166666666666666666666666666666667e2 * t335 - 0.27001225709730947333333333333333333333333333333333e1 * t341 - 0.37610742193750634333333333333333333333333333333333e1 * t348 * t311 + 0.18805371096875317166666666666666666666666666666667e1 * t356 * t311 + 0.19489173774580151666666666666666666666666666666667e2 * t360 * t311 + 0.49373337174483548166666666666666666666666666666667e1 * t366 * t311 - 0.41150663529849592833333333333333333333333333333333e-1 * t332 * t374 + 0.18635258017632964666666666666666666666666666666667e2 * t383 * t311 - 0.22140749178833072666666666666666666666666666666667e1 * t396 * t311 - 0.24275161951943278333333333333333333333333333333333e1 * t404 * t311 - 0.35540878740919256083333333333333333333333333333333e1 * t408 * t410
  t416 = t52 ** 2
  t417 = f.my_piecewise3(t53, t210, t416)
  t418 = -0.32481568604919886e0 - t254 - t255 - t260 - t265
  t419 = -0.57786103193239430e0 - t267 - t268 - t269
  t420 = 0.1e1 / t419
  t421 = t418 * t420
  t423 = 0.128e1 * t253 * t421
  t424 = f.p.zeta_threshold ** t423
  t425 = t52 ** t423
  t426 = f.my_piecewise3(t53, t424, t425)
  t427 = t45 ** t423
  t428 = f.my_piecewise3(t46, t424, t427)
  t429 = t426 + t428
  t430 = t429 ** 2
  t431 = 0.1e1 / t430
  t433 = t225 * t431 * t69
  t435 = t433 * t285 * t56
  t437 = 0.1e1 / t429
  t439 = t224 * t437 * t11
  t440 = t292 * t55
  t441 = t439 * t440
  t443 = 0.1134370464579530260e0 * t435 + 0.452548339959390416e-1 * t441 + 0.531736155271654809e-2
  t444 = 0.1e1 / t443
  t446 = 0.1187931309903801598e2 * t441 + 0.236958012866641818e1
  t447 = jnp.arctan(t446)
  t450 = 0.7385217579407656e0 * t435 + 0.2946275542389858e0 * t441 + 0.3461820740347690e-1
  t451 = t447 * t450
  t452 = t305 * t429
  t453 = t451 * t452
  t454 = t16 * t96
  t455 = t309 * t454
  t458 = jnp.log(t443)
  t461 = 0.38307570128017124e0 * t435 + 0.15282509383508946e0 * t441 + 0.1795667349750801e-1
  t462 = t458 * t461
  t463 = t462 * t452
  t466 = 0.2e1 * t441
  t467 = jnp.log(t466)
  t470 = 0.7661514025603416e0 * t435 + 0.3056501876701794e0 * t441 + 0.3591334699501599e-1
  t471 = t467 * t470
  t472 = t471 * t452
  t476 = t452 * t69
  t477 = t333 * t96
  t478 = t476 * t477
  t481 = t337 * t430 * t11
  t483 = t481 * t94 * t132
  t485 = -t453 * t455 / 0.6e1 - t463 * t455 / 0.6e1 + t472 * t455 / 0.6e1 - 0.102377731051917540e0 * t441 + 0.101508307543839117e1 + 0.14975624337724556833333333333333333333333333333333e0 * t478 + 0.18501446123012983250000000000000000000000000000000e-1 * t483
  t489 = t467 * t305
  t490 = t489 * t429
  t495 = 0.1604242095763840328e1 * t435 + 0.64e0 * t441 + 0.751988482389300153e-1
  t496 = jnp.log(t495)
  t497 = t496 * t305
  t498 = t497 * t429
  t501 = t447 * t305
  t502 = t501 * t429
  t505 = t466 + 0.482257181994472723e0
  t506 = jnp.log(t505)
  t507 = t506 * t305
  t508 = t507 * t429
  t513 = 0.20000000000000000000000000000000000000000000000000e1 * t435 + 0.821419393556370918e0 * t441 + 0.105323524476768857e0
  t514 = jnp.log(t513)
  t515 = t96 * t514
  t516 = t333 * t515
  t520 = 0.156250e1 * t441 + 0.32086695060795739e0
  t523 = jnp.arctan(0.160041105570901272e0 / t520)
  t524 = t523 * t305
  t525 = t524 * t429
  t529 = 0.268418671319107341e0 + 0.942121195869983724e0 * t441
  t532 = 0.10000000000000000000000000000000000000000000000000e1 * t435 + 0.505765839233979018e0 * t441 + 0.720485831127149779e-1
  t533 = jnp.sqrt(t532)
  t534 = 0.1e1 / t533
  t536 = jnp.arctanh(t529 * t534)
  t537 = t536 * t305
  t538 = t537 * t429
  t543 = 0.3125000000000000000e1 * t435 + 0.1246694626254477116e1 * t441 + 0.146484374999999999e0
  t544 = jnp.log(t543)
  t545 = t544 * t305
  t546 = t545 * t429
  t549 = t533 * t337
  t550 = t549 * t430
  t552 = t142 * t93 * t132
  t555 = t444 * t485 - 0.22079848381299059166666666666666666666666666666667e2 * t478 - 0.27001225709730947333333333333333333333333333333333e1 * t483 - 0.37610742193750634333333333333333333333333333333333e1 * t490 * t455 + 0.18805371096875317166666666666666666666666666666667e1 * t498 * t455 + 0.19489173774580151666666666666666666666666666666667e2 * t502 * t455 + 0.49373337174483548166666666666666666666666666666667e1 * t508 * t455 - 0.41150663529849592833333333333333333333333333333333e-1 * t476 * t516 + 0.18635258017632964666666666666666666666666666666667e2 * t525 * t455 - 0.22140749178833072666666666666666666666666666666667e1 * t538 * t455 - 0.24275161951943278333333333333333333333333333333333e1 * t546 * t455 - 0.35540878740919256083333333333333333333333333333333e1 * t550 * t552
  t560 = 0.2e1 * t1 * (t8 * t208 + t212 * t413 / 0.8e1 + t417 * t555 / 0.8e1)
  t561 = t2 * t5
  t562 = t3 * t258
  t566 = t48 ** 2
  t567 = 0.1e1 / t566
  t568 = t43 - t561
  t571 = f.my_piecewise3(t46, 0, t567 * t568 / 0.3e1)
  t573 = t409 * t121 * t571
  t576 = t132 * t62
  t577 = t54 ** 2
  t578 = 0.1e1 / t577
  t579 = -t568
  t582 = f.my_piecewise3(t53, 0, t578 * t579 / 0.3e1)
  t584 = t120 * t576 * t582
  t587 = 4 ** (0.1e1 / 0.12e2)
  t588 = t18 ** (0.1e1 / 0.12e2)
  t589 = t588 ** 2
  t590 = t589 ** 2
  t595 = t13 * t129
  t599 = t587 ** 2
  t600 = t599 ** 2
  t603 = t27 ** 2
  t607 = t14 * t129
  t610 = 0.1e1 / t19
  t611 = t610 * t11
  t612 = t595 * t31
  t617 = t9 / t216 * t11
  t620 = -0.41420394572483483663078382522666666666666666666666e0 * t587 / t590 / t588 * t11 * t595 * t22 + 0.37101583183086500000000000000000000000000000000000e0 * t22 * t600 * t587 / t603 / t27 * t607 + 0.60349824912370736189193695701333333333333333333332e0 * t611 * t612 - 0.58215774643626177777777777777777777777777777777778e0 * t617 * t612
  t623 = t620 * t69 * t71 * t77
  t626 = t72 * t16 * t49 * t76
  t627 = 0.2e1 / 0.3e1 * t626
  t630 = t72 * t73 * t571 * t76
  t633 = t72 * t74 * t582 * t75
  t634 = t70 * t285
  t635 = t49 * t55
  t638 = t57 * t93 * t49 / 0.3e1
  t643 = t57 * t93 * t55 / 0.3e1
  t646 = t57 * t15 * t571 + t57 * t15 * t582 + t638 + t643
  t649 = t634 * t635 * t64 * t646
  t650 = t623 + t627 + t630 + t633 - t649
  t651 = 0.1e1 / t158
  t656 = t125 * t11
  t657 = t656 * t94
  t661 = 0.82301327059699185666666666666666666666666666666667e-1 * t657 * t97 * t169 * t620
  t669 = t120 * t121 * t620
  t671 = 0.37610742193750634333333333333333333333333333333333e1 * t149 * t125 * t142 * t669
  t677 = t40 * t42
  t679 = t50 * t56
  t682 = t35 * t11 * t677 * t679 * t64 * t620
  t683 = 0.2406363143645760492e1 * t682
  t686 = t41 * t15 * t50 * t65
  t687 = 0.16042420957638403280000000000000000000000000000000e1 * t686
  t688 = t37 * t677
  t689 = t49 * t56
  t692 = t688 * t689 * t64 * t571
  t694 = t50 * t55
  t697 = t688 * t694 * t64 * t582
  t700 = 0.1e1 / t63 / t62
  t703 = t688 * t679 * t700 * t646
  t705 = 0.32e0 * t623
  t706 = 0.21333333333333333333333333333333333333333333333333e0 * t626
  t711 = 0.1e1 / t148
  t719 = 0.38978347549160303333333333333333333333333333333333e2 * t84 * t125 * t142 * t669
  t723 = 0.75221484387501268666666666666666666666666666666667e1 * t110 * t125 * t142 * t669
  t724 = 0.471060597934991862e0 * t623
  t725 = 0.31404039862332790800000000000000000000000000000000e0 * t626
  t733 = t183 / t187 / t186
  t734 = 0.15000000000000000000000000000000000000000000000000e1 * t682
  t735 = 0.10000000000000000000000000000000000000000000000000e1 * t686
  t739 = 0.252882919616989509e0 * t623
  t740 = 0.16858861307799300600000000000000000000000000000000e0 * t626
  t744 = t734 + t735 + 0.15000000000000000000000000000000000000000000000000e1 * t692 + 0.15000000000000000000000000000000000000000000000000e1 * t697 - 0.15000000000000000000000000000000000000000000000000e1 * t703 + t739 + t740 + 0.252882919616989509e0 * t630 + 0.252882919616989509e0 * t633 - 0.252882919616989509e0 * t649
  t748 = t183 ** 2
  t752 = 0.1e1 / (0.1e1 - t748 / t186)
  t760 = 0.48550323903886556666666666666666666666666666666667e1 * t198 * t125 * t142 * t669
  t763 = t130 * t96
  t768 = -0.98746674348967096333333333333333333333333333333333e1 * t161 * t573 - 0.98746674348967096333333333333333333333333333333333e1 * t161 * t584 + 0.98746674348967096333333333333333333333333333333333e1 * t650 * t651 * t90 * t99 + t661 + 0.75221484387501268666666666666666666666666666666667e1 * t143 * t573 + 0.75221484387501268666666666666666666666666666666667e1 * t143 * t584 - t671 - 0.37610742193750634333333333333333333333333333333333e1 * t151 * t573 - 0.37610742193750634333333333333333333333333333333333e1 * t151 * t584 + 0.37610742193750634333333333333333333333333333333333e1 * (t683 + t687 + 0.2406363143645760492e1 * t692 + 0.2406363143645760492e1 * t697 - 0.2406363143645760492e1 * t703 + t705 + t706 + 0.32e0 * t630 + 0.32e0 * t633 - 0.32e0 * t649) * t711 * t90 * t99 - t719 + t723 - 0.44281498357666145333333333333333333333333333333333e1 * ((t724 + t725 + 0.471060597934991862e0 * t630 + 0.471060597934991862e0 * t633 - 0.471060597934991862e0 * t649) * t188 - t733 * t744 / 0.2e1) * t752 * t90 * t99 + t760 + 0.48550323903886556666666666666666666666666666666667e1 * t200 * t573 + 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t763 * t169 * t571
  t769 = t95 * t132
  t774 = 0.30000000000000000000000000000000000000000000000000e1 * t682
  t775 = 0.20000000000000000000000000000000000000000000000000e1 * t686
  t779 = 0.410709696778185459e0 * t623
  t780 = 0.27380646451879030600000000000000000000000000000000e0 * t626
  t786 = 0.1e1 / t167
  t794 = 0.37270516035265929333333333333333333333333333333333e2 * t177 * t125 * t142 * t669
  t803 = 0.593965654951900799e1 * t623
  t804 = 0.39597710330126719933333333333333333333333333333333e1 * t626
  t809 = t83 ** 2
  t811 = 0.1e1 / (0.1e1 + t809)
  t812 = (t803 + t804 + 0.593965654951900799e1 * t630 + 0.593965654951900799e1 * t633 - 0.593965654951900799e1 * t649) * t811
  t819 = 0.98746674348967096333333333333333333333333333333333e1 * t159 * t125 * t142 * t669
  t822 = 0.4687500000000000000e1 * t682
  t823 = 0.31250000000000000000000000000000000000000000000000e1 * t686
  t827 = 0.623347313127238558e0 * t623
  t828 = 0.41556487541815903866666666666666666666666666666667e0 * t626
  t833 = 0.1e1 / t197
  t839 = t188 * t125 * t204
  t845 = 0.1e1 / t36 / t35
  t851 = 0.94775676642451349555555555555555555555555555555556e1 * t187 * t845 * t204 * t131 * t133 * t620
  t853 = 0.1e1 / t50 / t49
  t854 = t129 * t853
  t860 = 0.1e1 / t56 / t55
  t861 = t860 * t63
  t873 = 0.44281498357666145333333333333333333333333333333333e1 * t190 * t125 * t142 * t669
  t874 = 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t769 * t169 * t582 - 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t97 * t62 * (t774 + t775 + 0.30000000000000000000000000000000000000000000000000e1 * t692 + 0.30000000000000000000000000000000000000000000000000e1 * t697 - 0.30000000000000000000000000000000000000000000000000e1 * t703 + t779 + t780 + 0.410709696778185459e0 * t630 + 0.410709696778185459e0 * t633 - 0.410709696778185459e0 * t649) * t786 - t794 - 0.37270516035265929333333333333333333333333333333333e2 * t179 * t573 - 0.37270516035265929333333333333333333333333333333333e2 * t179 * t584 - 0.38978347549160303333333333333333333333333333333333e2 * t155 * t573 - 0.38978347549160303333333333333333333333333333333333e2 * t155 * t584 + 0.38978347549160303333333333333333333333333333333333e2 * t812 * t90 * t99 - t819 + 0.48550323903886556666666666666666666666666666666667e1 * t200 * t584 - 0.48550323903886556666666666666666666666666666666667e1 * (t822 + t823 + 0.4687500000000000000e1 * t692 + 0.4687500000000000000e1 * t697 - 0.4687500000000000000e1 * t703 + t827 + t828 + 0.623347313127238558e0 * t630 + 0.623347313127238558e0 * t633 - 0.623347313127238558e0 * t649) * t833 * t90 * t99 - 0.23693919160612837388888888888888888888888888888889e1 * t839 * t131 * t133 * t744 + t851 + 0.94775676642451349555555555555555555555555555555556e1 * t205 * t854 * t133 * t571 + 0.94775676642451349555555555555555555555555555555556e1 * t205 * t131 * t861 * t582 - 0.94775676642451349555555555555555555555555555555556e1 * t205 * t131 * t576 * t646 + t873
  t880 = t174 ** 2
  t881 = 0.1e1 / t880
  t882 = 0.78125e0 * t623
  t883 = 0.52083333333333333333333333333333333333333333333333e0 * t626
  t893 = 0.1e1 / (0.1e1 + 0.25613155472356366159499382371217984e-1 * t881) * t89 * t11
  t897 = t80 ** 2
  t899 = 0.1e1 / t897 * t137
  t900 = 0.1701555696869295390e0 * t682
  t901 = 0.11343704645795302600000000000000000000000000000000e0 * t686
  t905 = 0.226274169979695208e-1 * t623
  t906 = 0.15084944665313013866666666666666666666666666666667e-1 * t626
  t910 = t900 + t901 + 0.1701555696869295390e0 * t692 + 0.1701555696869295390e0 * t697 - 0.1701555696869295390e0 * t703 + t905 + t906 + 0.226274169979695208e-1 * t630 + 0.226274169979695208e-1 * t633 - 0.226274169979695208e-1 * t649
  t913 = t242 * t95 * t121
  t915 = 0.32366882602591037777777777777777777777777777777778e1 * t200 * t913
  t917 = 0.24847010690177286222222222222222222222222222222222e2 * t179 * t913
  t919 = 0.25985565032773535555555555555555555555555555555555e2 * t155 * t913
  t921 = 0.65831116232644730888888888888888888888888888888889e1 * t161 * t913
  t922 = t92 * t242
  t925 = 0.54867551373132790444444444444444444444444444444445e-1 * t90 * t922 * t170
  t927 = 0.50147656258334179111111111111111111111111111111111e1 * t143 * t913
  t929 = 0.25073828129167089555555555555555555555555555555555e1 * t151 * t913
  t931 = t120 * t96 * t646
  t944 = 0.44281498357666145333333333333333333333333333333333e1 * t192 * t573 + 0.44281498357666145333333333333333333333333333333333e1 * t192 * t584 - 0.59648145914819633119882959146621119999999999999999e1 * t881 * (t882 + t883 + 0.78125e0 * t630 + 0.78125e0 * t633 - 0.78125e0 * t649) * t893 * t99 - t899 * t910 + t915 - t917 - t919 - t921 + t925 + t927 - t929 - 0.48550323903886556666666666666666666666666666666667e1 * t200 * t931 - 0.44281498357666145333333333333333333333333333333333e1 * t192 * t931 + 0.37270516035265929333333333333333333333333333333333e2 * t179 * t931 + 0.98746674348967096333333333333333333333333333333333e1 * t161 * t931 - 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t97 * t646 * t168
  t952 = t650 * t125 * t204
  t955 = t127 * t129
  t956 = t126 * t955
  t957 = t853 * t132
  t960 = t956 * t957 * t63 * t571
  t962 = t130 * t860
  t965 = t956 * t962 * t63 * t582
  t967 = t130 * t132
  t970 = t956 * t967 * t62 * t646
  t974 = t657 * t97 * t62 * t620
  t975 = 0.44159696762598118333333333333333333333333333333333e2 * t974
  t978 = t164 * t763 * t62 * t571
  t982 = t164 * t769 * t62 * t582
  t988 = t845 * t69 * t955 * t967 * t63 * t620
  t989 = 0.72003268559282526222222222222222222222222222222222e1 * t988
  t991 = 0.1e1 / t15 / t4
  t993 = t991 * t130 * t133
  t995 = 0.63183784428300899703703703703703703703703703703704e1 * t205 * t993
  t997 = 0.29520998905110763555555555555555555555555555555555e1 * t192 * t913
  t998 = t128 * t993
  t999 = 0.48002179039521684148148148148148148148148148148148e1 * t998
  t1000 = t119 * t913
  t1001 = 0.29439797841732078888888888888888888888888888888889e2 * t1000
  t1002 = t119 * t931
  t1004 = t922 * t98
  t1006 = 0.2e1 / 0.9e1 * t91 * t1004
  t1007 = 0.57461355192025686e0 * t682
  t1008 = 0.38307570128017124000000000000000000000000000000000e0 * t686
  t1012 = 0.7641254691754473e-1 * t623
  t1013 = 0.50941697945029820000000000000000000000000000000000e-1 * t626
  t1023 = t94 * t97 * t646
  t1026 = 0.11492271038405124e1 * t682
  t1027 = 0.76615140256034160000000000000000000000000000000000e0 * t686
  t1031 = 0.1528250938350897e0 * t623
  t1032 = 0.10188339589005980000000000000000000000000000000000e0 * t626
  t1041 = 0.11077826369111484e1 * t682
  t1042 = 0.73852175794076560000000000000000000000000000000000e0 * t686
  t1046 = 0.1473137771194929e0 * t623
  t1047 = 0.98209184746328600000000000000000000000000000000000e-1 * t626
  t1059 = 0.2e1 / 0.9e1 * t107 * t1004
  t1061 = 0.2e1 / 0.9e1 * t115 * t1004
  t1065 = t131 * t133 * t113
  t1068 = t88 * t119
  t1072 = t87 * t89 * t11
  t1076 = t656 * t92
  t1079 = t106 * t1076 * t669 / 0.3e1
  t1080 = t106 * t119
  t1087 = t105 * t89 * t11
  t1093 = t114 * t1076 * t669 / 0.3e1
  t1094 = t114 * t119
  t1097 = t1006 - t102 * (t1007 + t1008 + 0.57461355192025686e0 * t692 + 0.57461355192025686e0 * t697 - 0.57461355192025686e0 * t703 + t1012 + t1013 + 0.7641254691754473e-1 * t630 + 0.7641254691754473e-1 * t633 - 0.7641254691754473e-1 * t649) * t90 * t99 / 0.3e1 - t107 * t1023 / 0.3e1 + t110 * (t1026 + t1027 + 0.11492271038405124e1 * t692 + 0.11492271038405124e1 * t697 - 0.11492271038405124e1 * t703 + t1031 + t1032 + 0.1528250938350897e0 * t630 + 0.1528250938350897e0 * t633 - 0.1528250938350897e0 * t649) * t90 * t99 / 0.3e1 - t84 * (t1041 + t1042 + 0.11077826369111484e1 * t692 + 0.11077826369111484e1 * t697 - 0.11077826369111484e1 * t703 + t1046 + t1047 + 0.1473137771194929e0 * t630 + 0.1473137771194929e0 * t633 - 0.1473137771194929e0 * t649) * t90 * t99 / 0.3e1 - t91 * t1023 / 0.3e1 + t1059 - t1061 + t115 * t1023 / 0.3e1 + t952 * t1065 / 0.9e1 + t1068 * t584 / 0.3e1 - t812 * t1072 * t99 / 0.3e1 + t1079 + t1080 * t573 / 0.3e1 + t1080 * t584 / 0.3e1 - t910 * t81 * t1087 * t99 / 0.3e1 - t1093 - t1094 * t573 / 0.3e1
  t1102 = t88 * t1076 * t669 / 0.3e1
  t1109 = 0.29951248675449113666666666666666666666666666666667e0 * t974
  t1112 = 0.49337189661367955333333333333333333333333333333334e-1 * t988
  t1113 = 0.51188865525958770e-1 * t623
  t1114 = 0.34125910350639180000000000000000000000000000000000e-1 * t626
  t1117 = 0.32891459774245303555555555555555555555555555555556e-1 * t998
  t1118 = 0.19967499116966075777777777777777777777777777777778e0 * t1000
  t1120 = -t1094 * t584 / 0.3e1 + t1102 + t1068 * t573 / 0.3e1 + 0.51188865525958770e-1 * t649 - 0.49337189661367955333333333333333333333333333333334e-1 * t960 - 0.49337189661367955333333333333333333333333333333334e-1 * t965 + 0.49337189661367955333333333333333333333333333333334e-1 * t970 - t1109 - 0.29951248675449113666666666666666666666666666666667e0 * t978 - 0.29951248675449113666666666666666666666666666666667e0 * t982 - t1112 - t1113 - t1114 - 0.51188865525958770e-1 * t630 - 0.51188865525958770e-1 * t633 - t1117 - t1118 + 0.29951248675449113666666666666666666666666666666667e0 * t1002
  t1123 = 0.37610742193750634333333333333333333333333333333333e1 * t151 * t931 + 0.38978347549160303333333333333333333333333333333333e2 * t155 * t931 - 0.75221484387501268666666666666666666666666666666667e1 * t143 * t931 - 0.25073828129167089555555555555555555555555555555556e1 * t952 * t134 + 0.72003268559282526222222222222222222222222222222222e1 * t960 + 0.72003268559282526222222222222222222222222222222222e1 * t965 - 0.72003268559282526222222222222222222222222222222222e1 * t970 + t975 + 0.44159696762598118333333333333333333333333333333333e2 * t978 + 0.44159696762598118333333333333333333333333333333333e2 * t982 + t989 + t995 + t997 + t999 + t1001 - 0.44159696762598118333333333333333333333333333333333e2 * t1002 + t81 * (t1097 + t1120)
  t1129 = f.my_piecewise3(t46, 0, 0.2e1 * t45 * t568)
  t1132 = t337 * t280
  t1141 = t595 * t220
  t1146 = 0.28458728544442838433866339033333333333333333333333e-1 * t10 * t11 * t595 * t214 - 0.13318739042300333333333333333333333333333333333333e0 * t214 * t610 * t607 + 0.40239847220779676332411397100000000000000000000000e-2 * t611 * t1141 - 0.85692453799423333333333333333333333333333333333333e-2 * t617 * t1141
  t1148 = t309 * t310 * t1146
  t1150 = t327 * t1132 * t1148 / 0.6e1
  t1151 = t16 * t130
  t1153 = t309 * t1151 * t571
  t1158 = t304 * t1132 * t1148 / 0.6e1
  t1163 = t1146 * t289 * t11 * t293
  t1164 = 0.1187931309903801598e2 * t1163
  t1165 = t224 * t282
  t1166 = t1165 * t11
  t1167 = t14 * t236
  t1169 = t228 * t243
  t1171 = t12 * t5
  t1174 = t235 * t10 * t991
  t1182 = (-0.20004184593989262000000000000000000000000000000000e1 * t1167 - 0.82235521597327845833333333333333333333333333333333e1 * t1169 + 0.17868177912628447650000000000000000000000000000000e2 * t1171 - 0.23602018542377619850000000000000000000000000000000e0 * t1174 - 0.91574732555730625000000000000000000000000000000000e-4 * t240 * t9 / t73 / t4) * t252
  t1184 = 0.128e1 * t1182 * t272
  t1185 = t251 ** 2
  t1187 = t246 / t1185
  t1192 = -0.13555260787020201250000000000000000000000000000000e1 * t1167 - 0.90672388562318061000000000000000000000000000000000e1 * t1169 + 0.18865507428140992500000000000000000000000000000000e2 * t1171 - 0.25000000000000000000000000000000000000000000000000e0 * t1174
  t1195 = 0.128e1 * t1187 * t272 * t1192
  t1196 = 0.1180131465463191050e1 * t43
  t1197 = 0.4033992295431623850e1 * t561
  t1198 = 0.4594893021405176740e1 * t562
  t1199 = t256 * t263
  t1200 = 0.1784997086128401540e1 * t1199
  t1204 = 0.4396489469165760e-1 * t261 / t262 / t1
  t1209 = t270 ** 2
  t1211 = t266 / t1209
  t1212 = 0.209708505883490736e1 * t43
  t1213 = 0.714084873057387096e1 * t561
  t1214 = 0.804376367173896360e1 * t562
  t1215 = 0.30e1 * t1199
  t1220 = t1184 - t1195 + 0.128e1 * t253 * (t1196 - t1197 + t1198 - t1200 + t1204) * t271 - 0.128e1 * t253 * t1211 * (t1212 - t1213 + t1214 - t1215)
  t1222 = jnp.log(f.p.zeta_threshold)
  t1223 = t275 * t1220 * t1222
  t1224 = jnp.log(t45)
  t1226 = t253 * t266
  t1228 = 0.1e1 / t45
  t1234 = f.my_piecewise3(t46, t1223, t276 * (t1220 * t1224 + 0.128e1 * t1226 * t271 * t568 * t1228))
  t1235 = jnp.log(t52)
  t1238 = 0.1e1 / t52
  t1244 = f.my_piecewise3(t53, t1223, t278 * (t1220 * t1235 + 0.128e1 * t1226 * t271 * t579 * t1238))
  t1245 = t1234 + t1244
  t1248 = t1166 * t292 * t49 * t1245
  t1250 = t39 * t93
  t1252 = t291 * t1250 * t49
  t1253 = 0.39597710330126719933333333333333333333333333333333e1 * t1252
  t1255 = t291 * t292 * t571
  t1258 = t299 ** 2
  t1260 = 0.1e1 / (0.1e1 + t1258)
  t1261 = (t1164 - 0.1187931309903801598e2 * t1248 + t1253 + 0.1187931309903801598e2 * t1255) * t1260
  t1262 = t303 * t305
  t1264 = t280 * t69
  t1265 = t1264 * t334
  t1270 = t318 * t1132 * t1148 / 0.6e1
  t1276 = t1165 * t69 * t285 * t50 * t1146
  t1277 = 0.2268740929159060520e0 * t1276
  t1281 = t225 / t281 / t280 * t69
  t1284 = t1281 * t285 * t50 * t1245
  t1286 = t71 * t16
  t1288 = t284 * t1286 * t50
  t1289 = 0.75624697638635350666666666666666666666666666666667e-1 * t1288
  t1292 = t284 * t285 * t49 * t571
  t1294 = 0.452548339959390416e-1 * t1163
  t1296 = 0.15084944665313013866666666666666666666666666666667e-1 * t1252
  t1298 = t1277 - 0.2268740929159060520e0 * t1284 + t1289 + 0.2268740929159060520e0 * t1292 + t1294 - 0.452548339959390416e-1 * t1248 + t1296 + 0.452548339959390416e-1 * t1255
  t1300 = t317 * t305
  t1304 = t308 * t129
  t1306 = t332 * t1304 * t95
  t1307 = 0.49918747792415189444444444444444444444444444444443e-1 * t1306
  t1309 = t339 * t922 * t130
  t1310 = 0.12334297415341988833333333333333333333333333333333e-1 * t1309
  t1311 = t305 * t1245
  t1312 = t1311 * t69
  t1313 = t1312 * t334
  t1316 = t333 * t130 * t571
  t1317 = t332 * t1316
  t1320 = 0.1e1 / t225 / t224
  t1324 = t94 * t130 * t1146
  t1325 = t1320 * t281 * t11 * t1324
  t1326 = 0.37002892246025966500000000000000000000000000000000e-1 * t1325
  t1327 = t1132 * t11
  t1329 = t94 * t130 * t1245
  t1330 = t1327 * t1329
  t1333 = t94 * t853 * t571
  t1334 = t339 * t1333
  t1336 = -t1150 - t328 * t1153 / 0.6e1 + t1158 + t307 * t1153 / 0.6e1 - t1261 * t1262 * t1265 / 0.6e1 + t1270 + t319 * t1153 / 0.6e1 - t1298 * t297 * t1300 * t1265 / 0.6e1 - t1307 - t1310 + 0.14975624337724556833333333333333333333333333333333e0 * t1313 - 0.14975624337724556833333333333333333333333333333333e0 * t1317 - t1326 + 0.37002892246025966500000000000000000000000000000000e-1 * t1330 - 0.37002892246025966500000000000000000000000000000000e-1 * t1334
  t1339 = t333 * t95 * t1146
  t1340 = t1132 * t69 * t1339
  t1341 = 0.14975624337724556833333333333333333333333333333333e0 * t1340
  t1343 = 0.102377731051917540e0 * t1163
  t1344 = 0.34125910350639180000000000000000000000000000000000e-1 * t1252
  t1346 = 0.2e1 * t1163
  t1348 = 0.2e1 / 0.3e1 * t1252
  t1350 = t1346 - 0.2e1 * t1248 + t1348 + 0.2e1 * t1255
  t1351 = t1350 * t337
  t1352 = t281 * t11
  t1355 = t94 * t130 * t326
  t1358 = 0.15323028051206832e1 * t1276
  t1360 = 0.51076760170689440000000000000000000000000000000000e0 * t1288
  t1362 = 0.3056501876701794e0 * t1163
  t1364 = 0.10188339589005980000000000000000000000000000000000e0 * t1252
  t1374 = 0.76615140256034248e0 * t1276
  t1376 = 0.25538380085344749333333333333333333333333333333333e0 * t1288
  t1378 = 0.15282509383508946e0 * t1163
  t1380 = 0.50941697945029820000000000000000000000000000000000e-1 * t1252
  t1393 = 0.14770435158815312e1 * t1276
  t1395 = 0.49234783862717706666666666666666666666666666666667e0 * t1288
  t1397 = 0.2946275542389858e0 * t1163
  t1399 = 0.98209184746328600000000000000000000000000000000000e-1 * t1252
  t1407 = t309 * t129 * t95
  t1409 = t328 * t1407 / 0.18e2
  t1411 = t307 * t1407 / 0.18e2
  t1413 = t319 * t1407 / 0.18e2
  t1414 = -t1341 + 0.102377731051917540e0 * t1248 - t1343 - t1344 - 0.102377731051917540e0 * t1255 + t1351 * t1352 * t1355 / 0.12e2 + t323 * (t1358 - 0.15323028051206832e1 * t1284 + t1360 + 0.15323028051206832e1 * t1292 + t1362 - 0.3056501876701794e0 * t1248 + t1364 + 0.3056501876701794e0 * t1255) * t306 * t311 / 0.6e1 + t327 * t1311 * t311 / 0.6e1 - t314 * (t1374 - 0.76615140256034248e0 * t1284 + t1376 + 0.76615140256034248e0 * t1292 + t1378 - 0.15282509383508946e0 * t1248 + t1380 + 0.15282509383508946e0 * t1255) * t306 * t311 / 0.6e1 - t318 * t1311 * t311 / 0.6e1 - t304 * t1311 * t311 / 0.6e1 - t300 * (t1393 - 0.14770435158815312e1 * t1284 + t1395 + 0.14770435158815312e1 * t1292 + t1397 - 0.2946275542389858e0 * t1248 + t1399 + 0.2946275542389858e0 * t1255) * t306 * t311 / 0.6e1 - t1409 + t1411 + t1413
  t1417 = t378 ** 2
  t1418 = 0.1e1 / t1417
  t1419 = 0.156250e1 * t1163
  t1421 = 0.52083333333333333333333333333333333333333333333333e0 * t1252
  t1428 = 0.1e1 / (0.1e1 + 0.25613155472356366159499382371217984e-1 * t1418) * t305
  t1432 = 0.73599494604330197222222222222222222222222222222223e1 * t1306
  t1433 = 0.18000817139820631555555555555555555555555555555555e1 * t1309
  t1436 = 0.12536914064583544777777777777777777777777777777778e1 * t348 * t1407
  t1441 = 0.54002451419461894666666666666666666666666666666666e1 * t1325
  t1444 = 0.22079848381299059166666666666666666666666666666667e2 * t1340
  t1446 = 0.62684570322917723888888888888888888888888888888890e0 * t356 * t1407
  t1447 = t297 * (t1336 + t1414) - 0.29824072957409816559941479573310560000000000000001e1 * t1418 * (t1419 - 0.156250e1 * t1248 + t1421 + 0.156250e1 * t1255) * t1428 * t1265 + t1432 + t1433 - 0.22079848381299059166666666666666666666666666666667e2 * t1313 + t1436 - 0.18805371096875317166666666666666666666666666666666e1 * t1351 * t281 * t410 + 0.22079848381299059166666666666666666666666666666667e2 * t1317 + t1441 - 0.54002451419461894666666666666666666666666666666666e1 * t1330 + 0.54002451419461894666666666666666666666666666666666e1 * t1334 + t1444 - t1446
  t1449 = 0.64963912581933838888888888888888888888888888888890e1 * t360 * t1407
  t1452 = 0.13716887843283197611111111111111111111111111111111e-1 * t332 * t1304 * t373
  t1468 = 0.62117526725443215555555555555555555555555555555557e1 * t383 * t1407
  t1470 = 0.16457779058161182722222222222222222222222222222222e1 * t366 * t1407
  t1472 = 0.73802497262776908888888888888888888888888888888890e0 * t396 * t1407
  t1485 = 0.23693919160612837388888888888888888888888888888889e1 * t408 * t142 * t242 * t130
  t1486 = -t1449 + t1452 + 0.49373337174483548166666666666666666666666666666667e1 * t365 * t1245 * t311 - 0.41150663529849592833333333333333333333333333333333e-1 * t1312 * t374 + 0.19489173774580151666666666666666666666666666666667e2 * t359 * t1245 * t311 + 0.18805371096875317166666666666666666666666666666667e1 * t355 * t1245 * t311 - 0.37610742193750634333333333333333333333333333333333e1 * t347 * t1245 * t311 - t1468 - t1470 + t1472 - 0.24275161951943278333333333333333333333333333333333e1 * t403 * t1245 * t311 - 0.22140749178833072666666666666666666666666666666667e1 * t395 * t1245 * t311 + 0.18635258017632964666666666666666666666666666666667e2 * t382 * t1245 * t311 + t1485
  t1489 = 0.80917206506477594444444444444444444444444444444443e0 * t404 * t1407
  t1493 = 0.71081757481838512166666666666666666666666666666666e1 * t391 * t1320 * t1352 * t1324
  t1495 = t407 * t280 * t11
  t1498 = t407 * t1352
  t1504 = 0.24275161951943278333333333333333333333333333333333e1 * t402 * t337 * t1264 * t1339
  t1505 = t403 * t1264
  t1508 = t296 ** 2
  t1510 = 0.1e1 / t1508 * t343
  t1512 = 0.6250000000000000000e1 * t1276
  t1514 = 0.20833333333333333333333333333333333333333333333333e1 * t1288
  t1516 = 0.1246694626254477116e1 * t1163
  t1518 = 0.41556487541815903866666666666666666666666666666667e0 * t1252
  t1521 = 0.1e1 / t401
  t1527 = t392 * t337 * t1352
  t1528 = 0.20000000000000000000000000000000000000000000000000e1 * t1276
  t1530 = 0.66666666666666666666666666666666666666666666666667e0 * t1288
  t1532 = 0.505765839233979018e0 * t1163
  t1534 = 0.16858861307799300600000000000000000000000000000000e0 * t1252
  t1536 = t1528 - 0.20000000000000000000000000000000000000000000000000e1 * t1284 + t1530 + 0.20000000000000000000000000000000000000000000000000e1 * t1292 + t1532 - 0.505765839233979018e0 * t1248 + t1534 + 0.505765839233979018e0 * t1255
  t1544 = 0.22140749178833072666666666666666666666666666666667e1 * t394 * t337 * t1264 * t1339
  t1545 = t395 * t1264
  t1548 = 0.942121195869983724e0 * t1163
  t1550 = 0.31404039862332790800000000000000000000000000000000e0 * t1252
  t1556 = t387 / t391 / t390
  t1560 = t387 ** 2
  t1564 = 0.1e1 / (0.1e1 - t1560 / t390)
  t1569 = t382 * t1264
  t1572 = t306 * t309
  t1573 = 0.40000000000000000000000000000000000000000000000000e1 * t1276
  t1575 = 0.13333333333333333333333333333333333333333333333333e1 * t1288
  t1577 = 0.821419393556370918e0 * t1163
  t1579 = 0.27380646451879030600000000000000000000000000000000e0 * t1252
  t1582 = 0.1e1 / t371
  t1587 = t1489 + t1493 - 0.71081757481838512166666666666666666666666666666666e1 * t1495 * t1329 + 0.71081757481838512166666666666666666666666666666666e1 * t1498 * t1333 + t1504 + 0.24275161951943278333333333333333333333333333333333e1 * t1505 * t1316 - t1510 * t1298 - 0.24275161951943278333333333333333333333333333333333e1 * (t1512 - 0.6250000000000000000e1 * t1284 + t1514 + 0.6250000000000000000e1 * t1292 + t1516 - 0.1246694626254477116e1 * t1248 + t1518 + 0.1246694626254477116e1 * t1255) * t1521 * t306 * t311 - 0.17770439370459628041666666666666666666666666666666e1 * t1527 * t94 * t130 * t1536 + t1544 + 0.22140749178833072666666666666666666666666666666667e1 * t1545 * t1316 - 0.22140749178833072666666666666666666666666666666667e1 * ((t1548 - 0.942121195869983724e0 * t1248 + t1550 + 0.942121195869983724e0 * t1255) * t392 - t1556 * t1536 / 0.2e1) * t1564 * t306 * t311 - 0.18635258017632964666666666666666666666666666666667e2 * t1569 * t1316 - 0.41150663529849592833333333333333333333333333333333e-1 * t1572 * t310 * (t1573 - 0.40000000000000000000000000000000000000000000000000e1 * t1284 + t1575 + 0.40000000000000000000000000000000000000000000000000e1 * t1292 + t1577 - 0.821419393556370918e0 * t1248 + t1579 + 0.821419393556370918e0 * t1255) * t1582
  t1591 = 0.18635258017632964666666666666666666666666666666667e2 * t381 * t337 * t1264 * t1339
  t1595 = 0.49373337174483548166666666666666666666666666666667e1 * t364 * t337 * t1264 * t1339
  t1596 = t365 * t1264
  t1599 = 0.1e1 / t363
  t1608 = 0.41150663529849592833333333333333333333333333333333e-1 * t1132 * t309 * t310 * t372 * t1146
  t1613 = t355 * t1264
  t1616 = 0.3208484191527680656e1 * t1276
  t1618 = 0.10694947305092268853333333333333333333333333333333e1 * t1288
  t1620 = 0.64e0 * t1163
  t1622 = 0.21333333333333333333333333333333333333333333333333e0 * t1252
  t1625 = 0.1e1 / t353
  t1633 = 0.19489173774580151666666666666666666666666666666667e2 * t300 * t337 * t1264 * t1339
  t1634 = t359 * t1264
  t1640 = t347 * t1264
  t1646 = 0.18805371096875317166666666666666666666666666666667e1 * t354 * t337 * t1264 * t1339
  t1650 = 0.37610742193750634333333333333333333333333333333333e1 * t323 * t337 * t1264 * t1339
  t1651 = -t1591 - t1595 - 0.49373337174483548166666666666666666666666666666667e1 * t1596 * t1316 + 0.49373337174483548166666666666666666666666666666667e1 * t1350 * t1599 * t306 * t311 + t1608 + 0.41150663529849592833333333333333333333333333333333e-1 * t1572 * t1151 * t372 * t571 - 0.18805371096875317166666666666666666666666666666667e1 * t1613 * t1316 + 0.18805371096875317166666666666666666666666666666667e1 * (t1616 - 0.3208484191527680656e1 * t1284 + t1618 + 0.3208484191527680656e1 * t1292 + t1620 - 0.64e0 * t1248 + t1622 + 0.64e0 * t1255) * t1625 * t306 * t311 - t1633 - 0.19489173774580151666666666666666666666666666666667e2 * t1634 * t1316 + 0.19489173774580151666666666666666666666666666666667e2 * t1261 * t306 * t311 + 0.37610742193750634333333333333333333333333333333333e1 * t1640 * t1316 - t1646 + t1650
  t1658 = f.my_piecewise3(t53, 0, 0.2e1 * t52 * t579)
  t1661 = t520 ** 2
  t1662 = 0.1e1 / t1661
  t1665 = t1146 * t437 * t11 * t440
  t1666 = 0.156250e1 * t1665
  t1667 = t224 * t431
  t1668 = t1667 * t11
  t1670 = 0.128e1 * t1182 * t421
  t1673 = 0.128e1 * t1187 * t421 * t1192
  t1674 = 0.1673729364505241750e1 * t561
  t1675 = 0.1112828638531688860e1 * t562
  t1676 = 0.1697067296745086340e1 * t1199
  t1681 = t419 ** 2
  t1683 = t418 / t1681
  t1684 = 0.294667861290405624e1 * t561
  t1685 = 0.204376367173896360e1 * t562
  t1690 = t1670 - t1673 + 0.128e1 * t253 * (-t1196 - t1674 + t1675 + t1676 + t1204) * t420 - 0.128e1 * t253 * t1683 * (-t1212 - t1684 + t1685 + t1215)
  t1692 = t424 * t1690 * t1222
  t1694 = t253 * t418
  t1701 = f.my_piecewise3(t53, t1692, t425 * (t1690 * t1235 + 0.128e1 * t1694 * t420 * t579 * t1238))
  t1709 = f.my_piecewise3(t46, t1692, t427 * (t1690 * t1224 + 0.128e1 * t1694 * t420 * t568 * t1228))
  t1710 = t1701 + t1709
  t1713 = t1668 * t292 * t55 * t1710
  t1716 = t439 * t1250 * t55
  t1717 = 0.52083333333333333333333333333333333333333333333333e0 * t1716
  t1719 = t439 * t292 * t582
  t1726 = 0.1e1 / (0.1e1 + 0.25613155472356366159499382371217984e-1 * t1662) * t305
  t1728 = t429 * t69
  t1729 = t1728 * t477
  t1733 = t476 * t1304 * t96
  t1734 = 0.73599494604330197222222222222222222222222222222223e1 * t1733
  t1736 = t481 * t922 * t132
  t1737 = 0.18000817139820631555555555555555555555555555555555e1 * t1736
  t1738 = t305 * t1710
  t1739 = t1738 * t69
  t1740 = t1739 * t477
  t1743 = t309 * t129 * t96
  t1745 = 0.64963912581933838888888888888888888888888888888890e1 * t502 * t1743
  t1747 = 0.12536914064583544777777777777777777777777777777778e1 * t490 * t1743
  t1749 = 0.62117526725443215555555555555555555555555555555557e1 * t525 * t1743
  t1751 = 0.16457779058161182722222222222222222222222222222222e1 * t508 * t1743
  t1754 = 0.13716887843283197611111111111111111111111111111111e-1 * t476 * t1304 * t515
  t1756 = 0.62684570322917723888888888888888888888888888888890e0 * t498 * t1743
  t1763 = 0.2e1 * t1665
  t1765 = 0.2e1 / 0.3e1 * t1716
  t1767 = t1763 - 0.2e1 * t1713 + t1765 + 0.2e1 * t1719
  t1768 = t1767 * t337
  t1772 = -0.29824072957409816559941479573310560000000000000001e1 * t1662 * (t1666 - 0.156250e1 * t1713 + t1717 + 0.156250e1 * t1719) * t1726 * t1729 + t1734 + t1737 - 0.22079848381299059166666666666666666666666666666667e2 * t1740 - t1745 + t1747 - t1749 - t1751 + t1754 - t1756 + 0.18805371096875317166666666666666666666666666666667e1 * t497 * t1710 * t455 - 0.37610742193750634333333333333333333333333333333333e1 * t489 * t1710 * t455 - 0.18805371096875317166666666666666666666666666666666e1 * t1768 * t430 * t552
  t1774 = t94 * t860 * t582
  t1775 = t481 * t1774
  t1777 = t337 * t429
  t1780 = t333 * t96 * t1146
  t1781 = t1777 * t69 * t1780
  t1782 = 0.22079848381299059166666666666666666666666666666667e2 * t1781
  t1784 = t333 * t132 * t582
  t1785 = t476 * t1784
  t1790 = t94 * t132 * t1146
  t1791 = t1320 * t430 * t11 * t1790
  t1792 = 0.54002451419461894666666666666666666666666666666666e1 * t1791
  t1793 = t1777 * t11
  t1795 = t94 * t132 * t1710
  t1796 = t1793 * t1795
  t1816 = 0.73802497262776908888888888888888888888888888888890e0 * t538 * t1743
  t1820 = 0.23693919160612837388888888888888888888888888888889e1 * t550 * t142 * t242 * t132
  t1822 = 0.80917206506477594444444444444444444444444444444443e0 * t546 * t1743
  t1823 = 0.54002451419461894666666666666666666666666666666666e1 * t1775 + t1782 + 0.22079848381299059166666666666666666666666666666667e2 * t1785 + t1792 - 0.54002451419461894666666666666666666666666666666666e1 * t1796 - 0.24275161951943278333333333333333333333333333333333e1 * t545 * t1710 * t455 - 0.22140749178833072666666666666666666666666666666667e1 * t537 * t1710 * t455 + 0.18635258017632964666666666666666666666666666666667e2 * t524 * t1710 * t455 + 0.49373337174483548166666666666666666666666666666667e1 * t507 * t1710 * t455 - 0.41150663529849592833333333333333333333333333333333e-1 * t1739 * t516 + 0.19489173774580151666666666666666666666666666666667e2 * t501 * t1710 * t455 + t1816 + t1820 + t1822
  t1826 = t430 * t11
  t1829 = 0.71081757481838512166666666666666666666666666666666e1 * t533 * t1320 * t1826 * t1790
  t1831 = t549 * t429 * t11
  t1834 = t549 * t1826
  t1840 = 0.24275161951943278333333333333333333333333333333333e1 * t544 * t337 * t1728 * t1780
  t1841 = t545 * t1728
  t1847 = t1667 * t69 * t285 * t56 * t1146
  t1848 = 0.6250000000000000000e1 * t1847
  t1852 = t225 / t430 / t429 * t69
  t1855 = t1852 * t285 * t56 * t1710
  t1858 = t433 * t1286 * t56
  t1859 = 0.20833333333333333333333333333333333333333333333333e1 * t1858
  t1862 = t433 * t285 * t55 * t582
  t1864 = 0.1246694626254477116e1 * t1665
  t1866 = 0.41556487541815903866666666666666666666666666666667e0 * t1716
  t1869 = 0.1e1 / t543
  t1875 = t534 * t337 * t1826
  t1876 = 0.20000000000000000000000000000000000000000000000000e1 * t1847
  t1878 = 0.66666666666666666666666666666666666666666666666667e0 * t1858
  t1880 = 0.505765839233979018e0 * t1665
  t1882 = 0.16858861307799300600000000000000000000000000000000e0 * t1716
  t1884 = t1876 - 0.20000000000000000000000000000000000000000000000000e1 * t1855 + t1878 + 0.20000000000000000000000000000000000000000000000000e1 * t1862 + t1880 - 0.505765839233979018e0 * t1713 + t1882 + 0.505765839233979018e0 * t1719
  t1892 = 0.22140749178833072666666666666666666666666666666667e1 * t536 * t337 * t1728 * t1780
  t1893 = t537 * t1728
  t1896 = 0.942121195869983724e0 * t1665
  t1898 = 0.31404039862332790800000000000000000000000000000000e0 * t1716
  t1904 = t529 / t533 / t532
  t1908 = t529 ** 2
  t1912 = 0.1e1 / (0.1e1 - t1908 / t532)
  t1917 = t524 * t1728
  t1920 = t452 * t309
  t1921 = 0.40000000000000000000000000000000000000000000000000e1 * t1847
  t1923 = 0.13333333333333333333333333333333333333333333333333e1 * t1858
  t1925 = 0.821419393556370918e0 * t1665
  t1927 = 0.27380646451879030600000000000000000000000000000000e0 * t1716
  t1930 = 0.1e1 / t513
  t1938 = 0.18635258017632964666666666666666666666666666666667e2 * t523 * t337 * t1728 * t1780
  t1942 = 0.49373337174483548166666666666666666666666666666667e1 * t506 * t337 * t1728 * t1780
  t1943 = t1829 - 0.71081757481838512166666666666666666666666666666666e1 * t1831 * t1795 + 0.71081757481838512166666666666666666666666666666666e1 * t1834 * t1774 + t1840 + 0.24275161951943278333333333333333333333333333333333e1 * t1841 * t1784 - 0.24275161951943278333333333333333333333333333333333e1 * (t1848 - 0.6250000000000000000e1 * t1855 + t1859 + 0.6250000000000000000e1 * t1862 + t1864 - 0.1246694626254477116e1 * t1713 + t1866 + 0.1246694626254477116e1 * t1719) * t1869 * t452 * t455 - 0.17770439370459628041666666666666666666666666666666e1 * t1875 * t94 * t132 * t1884 + t1892 + 0.22140749178833072666666666666666666666666666666667e1 * t1893 * t1784 - 0.22140749178833072666666666666666666666666666666667e1 * ((t1896 - 0.942121195869983724e0 * t1713 + t1898 + 0.942121195869983724e0 * t1719) * t534 - t1904 * t1884 / 0.2e1) * t1912 * t452 * t455 - 0.18635258017632964666666666666666666666666666666667e2 * t1917 * t1784 - 0.41150663529849592833333333333333333333333333333333e-1 * t1920 * t454 * (t1921 - 0.40000000000000000000000000000000000000000000000000e1 * t1855 + t1923 + 0.40000000000000000000000000000000000000000000000000e1 * t1862 + t1925 - 0.821419393556370918e0 * t1713 + t1927 + 0.821419393556370918e0 * t1719) * t1930 - t1938 - t1942
  t1944 = t507 * t1728
  t1947 = 0.1e1 / t505
  t1956 = 0.41150663529849592833333333333333333333333333333333e-1 * t1777 * t309 * t454 * t514 * t1146
  t1957 = t16 * t132
  t1962 = t497 * t1728
  t1965 = 0.3208484191527680656e1 * t1847
  t1967 = 0.10694947305092268853333333333333333333333333333333e1 * t1858
  t1969 = 0.64e0 * t1665
  t1971 = 0.21333333333333333333333333333333333333333333333333e0 * t1716
  t1974 = 0.1e1 / t495
  t1982 = 0.19489173774580151666666666666666666666666666666667e2 * t447 * t337 * t1728 * t1780
  t1983 = t501 * t1728
  t1986 = 0.1187931309903801598e2 * t1665
  t1988 = 0.39597710330126719933333333333333333333333333333333e1 * t1716
  t1991 = t446 ** 2
  t1993 = 0.1e1 / (0.1e1 + t1991)
  t1994 = (t1986 - 0.1187931309903801598e2 * t1713 + t1988 + 0.1187931309903801598e2 * t1719) * t1993
  t1998 = t489 * t1728
  t2004 = 0.18805371096875317166666666666666666666666666666667e1 * t496 * t337 * t1728 * t1780
  t2008 = 0.37610742193750634333333333333333333333333333333333e1 * t467 * t337 * t1728 * t1780
  t2009 = t443 ** 2
  t2011 = 0.1e1 / t2009 * t485
  t2012 = 0.2268740929159060520e0 * t1847
  t2014 = 0.75624697638635350666666666666666666666666666666667e-1 * t1858
  t2016 = 0.452548339959390416e-1 * t1665
  t2018 = 0.15084944665313013866666666666666666666666666666667e-1 * t1716
  t2020 = t2012 - 0.2268740929159060520e0 * t1855 + t2014 + 0.2268740929159060520e0 * t1862 + t2016 - 0.452548339959390416e-1 * t1713 + t2018 + 0.452548339959390416e-1 * t1719
  t2024 = t309 * t454 * t1146
  t2026 = t451 * t1777 * t2024 / 0.6e1
  t2028 = t309 * t1957 * t582
  t2031 = t450 * t305
  t2037 = t462 * t1777 * t2024 / 0.6e1
  t2041 = t461 * t305
  t2047 = t471 * t1777 * t2024 / 0.6e1
  t2050 = 0.49918747792415189444444444444444444444444444444443e-1 * t1733
  t2051 = 0.12334297415341988833333333333333333333333333333333e-1 * t1736
  t2053 = 0.102377731051917540e0 * t1665
  t2054 = 0.34125910350639180000000000000000000000000000000000e-1 * t1716
  t2057 = t2026 + t453 * t2028 / 0.6e1 - t1994 * t2031 * t1729 / 0.6e1 + t2037 + t463 * t2028 / 0.6e1 - t2020 * t444 * t2041 * t1729 / 0.6e1 - t2047 - t472 * t2028 / 0.6e1 - t2050 - t2051 + 0.14975624337724556833333333333333333333333333333333e0 * t1740 - t2053 - t2054 - 0.102377731051917540e0 * t1719 - 0.37002892246025966500000000000000000000000000000000e-1 * t1775
  t2058 = 0.14975624337724556833333333333333333333333333333333e0 * t1781
  t2060 = 0.37002892246025966500000000000000000000000000000000e-1 * t1791
  t2064 = t463 * t1743 / 0.18e2
  t2066 = t472 * t1743 / 0.18e2
  t2069 = t94 * t132 * t470
  t2072 = 0.15323028051206832e1 * t1847
  t2074 = 0.51076760170689440000000000000000000000000000000000e0 * t1858
  t2076 = 0.3056501876701794e0 * t1665
  t2078 = 0.10188339589005980000000000000000000000000000000000e0 * t1716
  t2088 = 0.76615140256034248e0 * t1847
  t2090 = 0.25538380085344749333333333333333333333333333333333e0 * t1858
  t2092 = 0.15282509383508946e0 * t1665
  t2094 = 0.50941697945029820000000000000000000000000000000000e-1 * t1716
  t2107 = 0.14770435158815312e1 * t1847
  t2109 = 0.49234783862717706666666666666666666666666666666667e0 * t1858
  t2111 = 0.2946275542389858e0 * t1665
  t2113 = 0.98209184746328600000000000000000000000000000000000e-1 * t1716
  t2121 = t453 * t1743 / 0.18e2
  t2122 = -t2058 - 0.14975624337724556833333333333333333333333333333333e0 * t1785 - t2060 + 0.37002892246025966500000000000000000000000000000000e-1 * t1796 + 0.102377731051917540e0 * t1713 + t2064 - t2066 + t1768 * t1826 * t2069 / 0.12e2 + t467 * (t2072 - 0.15323028051206832e1 * t1855 + t2074 + 0.15323028051206832e1 * t1862 + t2076 - 0.3056501876701794e0 * t1713 + t2078 + 0.3056501876701794e0 * t1719) * t452 * t455 / 0.6e1 + t471 * t1738 * t455 / 0.6e1 - t458 * (t2088 - 0.76615140256034248e0 * t1855 + t2090 + 0.76615140256034248e0 * t1862 + t2092 - 0.15282509383508946e0 * t1713 + t2094 + 0.15282509383508946e0 * t1719) * t452 * t455 / 0.6e1 - t462 * t1738 * t455 / 0.6e1 - t451 * t1738 * t455 / 0.6e1 - t447 * (t2107 - 0.14770435158815312e1 * t1855 + t2109 + 0.14770435158815312e1 * t1862 + t2111 - 0.2946275542389858e0 * t1713 + t2113 + 0.2946275542389858e0 * t1719) * t452 * t455 / 0.6e1 + t2121
  t2125 = -0.49373337174483548166666666666666666666666666666667e1 * t1944 * t1784 + 0.49373337174483548166666666666666666666666666666667e1 * t1767 * t1947 * t452 * t455 + t1956 + 0.41150663529849592833333333333333333333333333333333e-1 * t1920 * t1957 * t514 * t582 - 0.18805371096875317166666666666666666666666666666667e1 * t1962 * t1784 + 0.18805371096875317166666666666666666666666666666667e1 * (t1965 - 0.3208484191527680656e1 * t1855 + t1967 + 0.3208484191527680656e1 * t1862 + t1969 - 0.64e0 * t1713 + t1971 + 0.64e0 * t1719) * t1974 * t452 * t455 - t1982 - 0.19489173774580151666666666666666666666666666666667e2 * t1983 * t1784 + 0.19489173774580151666666666666666666666666666666667e2 * t1994 * t452 * t455 + 0.37610742193750634333333333333333333333333333333333e1 * t1998 * t1784 - t2004 + t2008 - t2011 * t2020 + t444 * (t2057 + t2122)
  vrho_0_ = t560 + t4 * ((-t561 / 0.2e1 + t562 / 0.2e1) * t208 + t8 * (t768 + t874 + t944 + t1123) + t1129 * t413 / 0.8e1 + t212 * (t1447 + t1486 + t1587 + t1651) / 0.8e1 + t1658 * t555 / 0.8e1 + t417 * (t1772 + t1823 + t1943 + t2125) / 0.8e1)
  t2135 = -t43 - t561
  t2138 = f.my_piecewise3(t46, 0, t567 * t2135 / 0.3e1)
  t2141 = t688 * t689 * t64 * t2138
  t2143 = -t2135
  t2146 = f.my_piecewise3(t53, 0, t578 * t2143 / 0.3e1)
  t2149 = t688 * t694 * t64 * t2146
  t2155 = t57 * t15 * t2138 + t57 * t15 * t2146 + t638 + t643
  t2158 = t688 * t679 * t700 * t2155
  t2162 = t72 * t73 * t2138 * t76
  t2166 = t72 * t74 * t2146 * t75
  t2170 = t634 * t635 * t64 * t2155
  t2172 = t734 + t735 + 0.15000000000000000000000000000000000000000000000000e1 * t2141 + 0.15000000000000000000000000000000000000000000000000e1 * t2149 - 0.15000000000000000000000000000000000000000000000000e1 * t2158 + t739 + t740 + 0.252882919616989509e0 * t2162 + 0.252882919616989509e0 * t2166 - 0.252882919616989509e0 * t2170
  t2178 = t409 * t121 * t2138
  t2182 = t120 * t576 * t2146
  t2205 = t623 + t627 + t2162 + t2166 - t2170
  t2244 = -0.23693919160612837388888888888888888888888888888889e1 * t839 * t131 * t133 * t2172 - 0.37270516035265929333333333333333333333333333333333e2 * t179 * t2178 - 0.37270516035265929333333333333333333333333333333333e2 * t179 * t2182 + 0.44281498357666145333333333333333333333333333333333e1 * t192 * t2178 + 0.44281498357666145333333333333333333333333333333333e1 * t192 * t2182 - 0.44281498357666145333333333333333333333333333333333e1 * ((t724 + t725 + 0.471060597934991862e0 * t2162 + 0.471060597934991862e0 * t2166 - 0.471060597934991862e0 * t2170) * t188 - t733 * t2172 / 0.2e1) * t752 * t90 * t99 - 0.98746674348967096333333333333333333333333333333333e1 * t161 * t2178 - 0.98746674348967096333333333333333333333333333333333e1 * t161 * t2182 + 0.98746674348967096333333333333333333333333333333333e1 * t2205 * t651 * t90 * t99 + 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t763 * t169 * t2138 + 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t769 * t169 * t2146 - 0.82301327059699185666666666666666666666666666666667e-1 * t164 * t97 * t62 * (t774 + t775 + 0.30000000000000000000000000000000000000000000000000e1 * t2141 + 0.30000000000000000000000000000000000000000000000000e1 * t2149 - 0.30000000000000000000000000000000000000000000000000e1 * t2158 + t779 + t780 + 0.410709696778185459e0 * t2162 + 0.410709696778185459e0 * t2166 - 0.410709696778185459e0 * t2170) * t786 - 0.37610742193750634333333333333333333333333333333333e1 * t151 * t2178 + 0.94775676642451349555555555555555555555555555555556e1 * t205 * t854 * t133 * t2138 + 0.94775676642451349555555555555555555555555555555556e1 * t205 * t131 * t861 * t2146 - 0.94775676642451349555555555555555555555555555555556e1 * t205 * t131 * t576 * t2155
  t2261 = t120 * t96 * t2155
  t2262 = t119 * t2261
  t2278 = 0.48550323903886556666666666666666666666666666666667e1 * t200 * t2178 + 0.48550323903886556666666666666666666666666666666667e1 * t200 * t2182 - 0.48550323903886556666666666666666666666666666666667e1 * (t822 + t823 + 0.4687500000000000000e1 * t2141 + 0.4687500000000000000e1 * t2149 - 0.4687500000000000000e1 * t2158 + t827 + t828 + 0.623347313127238558e0 * t2162 + 0.623347313127238558e0 * t2166 - 0.623347313127238558e0 * t2170) * t833 * t90 * t99 + t661 - t671 - t719 + t723 + t760 - t794 - t819 + t851 + t873 - 0.44159696762598118333333333333333333333333333333333e2 * t2262 - 0.59648145914819633119882959146621119999999999999999e1 * t881 * (t882 + t883 + 0.78125e0 * t2162 + 0.78125e0 * t2166 - 0.78125e0 * t2170) * t893 * t99 + 0.37270516035265929333333333333333333333333333333333e2 * t179 * t2261 + 0.38978347549160303333333333333333333333333333333333e2 * t155 * t2261 + 0.98746674348967096333333333333333333333333333333333e1 * t161 * t2261
  t2289 = t2205 * t125 * t204
  t2298 = t164 * t763 * t62 * t2138
  t2302 = t164 * t769 * t62 * t2146
  t2306 = t956 * t957 * t63 * t2138
  t2310 = t956 * t962 * t63 * t2146
  t2314 = t956 * t967 * t62 * t2155
  t2339 = t94 * t97 * t2155
  t2372 = t900 + t901 + 0.1701555696869295390e0 * t2141 + 0.1701555696869295390e0 * t2149 - 0.1701555696869295390e0 * t2158 + t905 + t906 + 0.226274169979695208e-1 * t2162 + 0.226274169979695208e-1 * t2166 - 0.226274169979695208e-1 * t2170
  t2381 = -t102 * (t1007 + t1008 + 0.57461355192025686e0 * t2141 + 0.57461355192025686e0 * t2149 - 0.57461355192025686e0 * t2158 + t1012 + t1013 + 0.7641254691754473e-1 * t2162 + 0.7641254691754473e-1 * t2166 - 0.7641254691754473e-1 * t2170) * t90 * t99 / 0.3e1 - t84 * (t1041 + t1042 + 0.11077826369111484e1 * t2141 + 0.11077826369111484e1 * t2149 - 0.11077826369111484e1 * t2158 + t1046 + t1047 + 0.1473137771194929e0 * t2162 + 0.1473137771194929e0 * t2166 - 0.1473137771194929e0 * t2170) * t90 * t99 / 0.3e1 - t107 * t2339 / 0.3e1 + t110 * (t1026 + t1027 + 0.11492271038405124e1 * t2141 + 0.11492271038405124e1 * t2149 - 0.11492271038405124e1 * t2158 + t1031 + t1032 + 0.1528250938350897e0 * t2162 + 0.1528250938350897e0 * t2166 - 0.1528250938350897e0 * t2170) * t90 * t99 / 0.3e1 + t115 * t2339 / 0.3e1 + t2289 * t1065 / 0.9e1 - t91 * t2339 / 0.3e1 + t1006 + t1059 - t1061 + 0.29951248675449113666666666666666666666666666666667e0 * t2262 - 0.51188865525958770e-1 * t2162 - 0.51188865525958770e-1 * t2166 + t1080 * t2178 / 0.3e1 + t1080 * t2182 / 0.3e1 - t2372 * t81 * t1087 * t99 / 0.3e1 - t1094 * t2178 / 0.3e1 - t1094 * t2182 / 0.3e1
  t2390 = (t803 + t804 + 0.593965654951900799e1 * t2162 + 0.593965654951900799e1 * t2166 - 0.593965654951900799e1 * t2170) * t811
  t2400 = t1068 * t2178 / 0.3e1 + t1068 * t2182 / 0.3e1 - t2390 * t1072 * t99 / 0.3e1 + t1079 - t1093 + t1102 - 0.29951248675449113666666666666666666666666666666667e0 * t2298 - 0.29951248675449113666666666666666666666666666666667e0 * t2302 - 0.49337189661367955333333333333333333333333333333334e-1 * t2306 - 0.49337189661367955333333333333333333333333333333334e-1 * t2310 + 0.49337189661367955333333333333333333333333333333334e-1 * t2314 + 0.51188865525958770e-1 * t2170 - t1109 - t1112 - t1113 - t1114 - t1117 - t1118
  t2419 = -0.82301327059699185666666666666666666666666666666667e-1 * t164 * t97 * t2155 * t168 + 0.37610742193750634333333333333333333333333333333333e1 * t151 * t2261 - 0.75221484387501268666666666666666666666666666666667e1 * t143 * t2261 - 0.25073828129167089555555555555555555555555555555556e1 * t2289 * t134 - 0.48550323903886556666666666666666666666666666666667e1 * t200 * t2261 - 0.44281498357666145333333333333333333333333333333333e1 * t192 * t2261 + 0.44159696762598118333333333333333333333333333333333e2 * t2298 + 0.44159696762598118333333333333333333333333333333333e2 * t2302 + 0.72003268559282526222222222222222222222222222222222e1 * t2306 + 0.72003268559282526222222222222222222222222222222222e1 * t2310 - 0.72003268559282526222222222222222222222222222222222e1 * t2314 + t81 * (t2381 + t2400) - t899 * t2372 - 0.37610742193750634333333333333333333333333333333333e1 * t151 * t2182 + 0.37610742193750634333333333333333333333333333333333e1 * (t683 + t687 + 0.2406363143645760492e1 * t2141 + 0.2406363143645760492e1 * t2149 - 0.2406363143645760492e1 * t2158 + t705 + t706 + 0.32e0 * t2162 + 0.32e0 * t2166 - 0.32e0 * t2170) * t711 * t90 * t99 - 0.38978347549160303333333333333333333333333333333333e2 * t155 * t2178
  t2429 = -0.38978347549160303333333333333333333333333333333333e2 * t155 * t2182 + 0.38978347549160303333333333333333333333333333333333e2 * t2390 * t90 * t99 + 0.75221484387501268666666666666666666666666666666667e1 * t143 * t2178 + 0.75221484387501268666666666666666666666666666666667e1 * t143 * t2182 + t915 - t917 - t919 - t921 + t925 + t927 - t929 + t975 + t989 + t995 + t997 + t999 + t1001
  t2435 = f.my_piecewise3(t46, 0, 0.2e1 * t45 * t2135)
  t2446 = t1184 - t1195 + 0.128e1 * t253 * (-t1196 + t1674 + t1675 - t1676 + t1204) * t271 - 0.128e1 * t253 * t1211 * (-t1212 + t1684 + t1685 - t1215)
  t2448 = t275 * t2446 * t1222
  t2456 = f.my_piecewise3(t46, t2448, t276 * (t2446 * t1224 + 0.128e1 * t1226 * t271 * t2135 * t1228))
  t2464 = f.my_piecewise3(t53, t2448, t278 * (t2446 * t1235 + 0.128e1 * t1226 * t271 * t2143 * t1238))
  t2465 = t2456 + t2464
  t2475 = t305 * t2465
  t2476 = t2475 * t69
  t2493 = t1166 * t292 * t49 * t2465
  t2496 = t291 * t292 * t2138
  t2498 = t1346 - 0.2e1 * t2493 + t1348 + 0.2e1 * t2496
  t2499 = t2498 * t337
  t2504 = t333 * t130 * t2138
  t2505 = t332 * t2504
  t2508 = t94 * t130 * t2465
  t2509 = t1327 * t2508
  t2512 = t94 * t853 * t2138
  t2513 = t339 * t2512
  t2520 = t2476 * t334
  t2522 = -t1150 + t1158 + t1270 + 0.102377731051917540e0 * t2493 - 0.14975624337724556833333333333333333333333333333333e0 * t2505 + 0.37002892246025966500000000000000000000000000000000e-1 * t2509 - 0.37002892246025966500000000000000000000000000000000e-1 * t2513 - t1307 - t1310 - 0.102377731051917540e0 * t2496 + 0.14975624337724556833333333333333333333333333333333e0 * t2520 - t1326 - t1341 - t1343 - t1344
  t2525 = t1281 * t285 * t50 * t2465
  t2529 = t284 * t285 * t49 * t2138
  t2569 = t309 * t1151 * t2138
  t2576 = t1277 - 0.2268740929159060520e0 * t2525 + t1289 + 0.2268740929159060520e0 * t2529 + t1294 - 0.452548339959390416e-1 * t2493 + t1296 + 0.452548339959390416e-1 * t2496
  t2588 = (t1164 - 0.1187931309903801598e2 * t2493 + t1253 + 0.1187931309903801598e2 * t2496) * t1260
  t2592 = t323 * (t1358 - 0.15323028051206832e1 * t2525 + t1360 + 0.15323028051206832e1 * t2529 + t1362 - 0.3056501876701794e0 * t2493 + t1364 + 0.3056501876701794e0 * t2496) * t306 * t311 / 0.6e1 - t314 * (t1374 - 0.76615140256034248e0 * t2525 + t1376 + 0.76615140256034248e0 * t2529 + t1378 - 0.15282509383508946e0 * t2493 + t1380 + 0.15282509383508946e0 * t2496) * t306 * t311 / 0.6e1 - t304 * t2475 * t311 / 0.6e1 - t300 * (t1393 - 0.14770435158815312e1 * t2525 + t1395 + 0.14770435158815312e1 * t2529 + t1397 - 0.2946275542389858e0 * t2493 + t1399 + 0.2946275542389858e0 * t2496) * t306 * t311 / 0.6e1 + t327 * t2475 * t311 / 0.6e1 + t2499 * t1352 * t1355 / 0.12e2 - t318 * t2475 * t311 / 0.6e1 + t319 * t2569 / 0.6e1 - t2576 * t297 * t1300 * t1265 / 0.6e1 - t328 * t2569 / 0.6e1 + t307 * t2569 / 0.6e1 - t2588 * t1262 * t1265 / 0.6e1 - t1409 + t1411 + t1413
  t2595 = -0.24275161951943278333333333333333333333333333333333e1 * t403 * t2465 * t311 - 0.22140749178833072666666666666666666666666666666667e1 * t395 * t2465 * t311 + 0.18635258017632964666666666666666666666666666666667e2 * t382 * t2465 * t311 - 0.41150663529849592833333333333333333333333333333333e-1 * t2476 * t374 + 0.19489173774580151666666666666666666666666666666667e2 * t359 * t2465 * t311 + 0.49373337174483548166666666666666666666666666666667e1 * t365 * t2465 * t311 + 0.18805371096875317166666666666666666666666666666667e1 * t355 * t2465 * t311 - 0.37610742193750634333333333333333333333333333333333e1 * t347 * t2465 * t311 - 0.18805371096875317166666666666666666666666666666666e1 * t2499 * t281 * t410 + 0.22079848381299059166666666666666666666666666666667e2 * t2505 - 0.54002451419461894666666666666666666666666666666666e1 * t2509 + 0.54002451419461894666666666666666666666666666666666e1 * t2513 + t297 * (t2522 + t2592)
  t2597 = t1432 + t1433 - 0.22079848381299059166666666666666666666666666666667e2 * t2520 + t1436 + t1441 + t1444 - t1446 - t1449 + t1452 - t1468 - t1470 + t1472 + t1485 + t1489
  t2636 = t1528 - 0.20000000000000000000000000000000000000000000000000e1 * t2525 + t1530 + 0.20000000000000000000000000000000000000000000000000e1 * t2529 + t1532 - 0.505765839233979018e0 * t2493 + t1534 + 0.505765839233979018e0 * t2496
  t2669 = -0.19489173774580151666666666666666666666666666666667e2 * t1634 * t2504 + 0.19489173774580151666666666666666666666666666666667e2 * t2588 * t306 * t311 - 0.49373337174483548166666666666666666666666666666667e1 * t1596 * t2504 + 0.49373337174483548166666666666666666666666666666667e1 * t2498 * t1599 * t306 * t311 - 0.18805371096875317166666666666666666666666666666667e1 * t1613 * t2504 + 0.18805371096875317166666666666666666666666666666667e1 * (t1616 - 0.3208484191527680656e1 * t2525 + t1618 + 0.3208484191527680656e1 * t2529 + t1620 - 0.64e0 * t2493 + t1622 + 0.64e0 * t2496) * t1625 * t306 * t311 + 0.37610742193750634333333333333333333333333333333333e1 * t1640 * t2504 - 0.24275161951943278333333333333333333333333333333333e1 * (t1512 - 0.6250000000000000000e1 * t2525 + t1514 + 0.6250000000000000000e1 * t2529 + t1516 - 0.1246694626254477116e1 * t2493 + t1518 + 0.1246694626254477116e1 * t2496) * t1521 * t306 * t311 - 0.17770439370459628041666666666666666666666666666666e1 * t1527 * t94 * t130 * t2636 + 0.22140749178833072666666666666666666666666666666667e1 * t1545 * t2504 - 0.22140749178833072666666666666666666666666666666667e1 * ((t1548 - 0.942121195869983724e0 * t2493 + t1550 + 0.942121195869983724e0 * t2496) * t392 - t1556 * t2636 / 0.2e1) * t1564 * t306 * t311 - 0.18635258017632964666666666666666666666666666666667e2 * t1569 * t2504 + 0.41150663529849592833333333333333333333333333333333e-1 * t1572 * t1151 * t372 * t2138 - 0.41150663529849592833333333333333333333333333333333e-1 * t1572 * t310 * (t1573 - 0.40000000000000000000000000000000000000000000000000e1 * t2525 + t1575 + 0.40000000000000000000000000000000000000000000000000e1 * t2529 + t1577 - 0.821419393556370918e0 * t2493 + t1579 + 0.821419393556370918e0 * t2496) * t1582
  t2684 = -0.71081757481838512166666666666666666666666666666666e1 * t1495 * t2508 + 0.71081757481838512166666666666666666666666666666666e1 * t1498 * t2512 + 0.24275161951943278333333333333333333333333333333333e1 * t1505 * t2504 - 0.29824072957409816559941479573310560000000000000001e1 * t1418 * (t1419 - 0.156250e1 * t2493 + t1421 + 0.156250e1 * t2496) * t1428 * t1265 - t1510 * t2576 + t1493 + t1504 + t1544 - t1591 - t1595 + t1608 - t1633 - t1646 + t1650
  t2691 = f.my_piecewise3(t53, 0, 0.2e1 * t52 * t2143)
  t2702 = t1670 - t1673 + 0.128e1 * t253 * (t1196 + t1197 + t1198 + t1200 + t1204) * t420 - 0.128e1 * t253 * t1683 * (t1212 + t1213 + t1214 + t1215)
  t2704 = t424 * t2702 * t1222
  t2712 = f.my_piecewise3(t53, t2704, t425 * (t2702 * t1235 + 0.128e1 * t1694 * t420 * t2143 * t1238))
  t2720 = f.my_piecewise3(t46, t2704, t427 * (t2702 * t1224 + 0.128e1 * t1694 * t420 * t2135 * t1228))
  t2721 = t2712 + t2720
  t2724 = t1668 * t292 * t55 * t2721
  t2727 = t439 * t292 * t2146
  t2729 = t1763 - 0.2e1 * t2724 + t1765 + 0.2e1 * t2727
  t2730 = t2729 * t337
  t2735 = t333 * t132 * t2146
  t2736 = t476 * t2735
  t2739 = t94 * t132 * t2721
  t2740 = t1793 * t2739
  t2743 = t94 * t860 * t2146
  t2744 = t481 * t2743
  t2758 = t305 * t2721
  t2759 = t2758 * t69
  t2771 = -0.18805371096875317166666666666666666666666666666666e1 * t2730 * t430 * t552 + 0.22079848381299059166666666666666666666666666666667e2 * t2736 - 0.54002451419461894666666666666666666666666666666666e1 * t2740 + 0.54002451419461894666666666666666666666666666666666e1 * t2744 - 0.24275161951943278333333333333333333333333333333333e1 * t545 * t2721 * t455 - 0.22140749178833072666666666666666666666666666666667e1 * t537 * t2721 * t455 + 0.18635258017632964666666666666666666666666666666667e2 * t524 * t2721 * t455 + 0.49373337174483548166666666666666666666666666666667e1 * t507 * t2721 * t455 - 0.41150663529849592833333333333333333333333333333333e-1 * t2759 * t516 + 0.19489173774580151666666666666666666666666666666667e2 * t501 * t2721 * t455 + 0.18805371096875317166666666666666666666666666666667e1 * t497 * t2721 * t455 - 0.37610742193750634333333333333333333333333333333333e1 * t489 * t2721 * t455 + t1734
  t2772 = t2759 * t477
  t2776 = t1737 - t1745 + t1747 - t1749 - t1751 + t1754 - t1756 - 0.22079848381299059166666666666666666666666666666667e2 * t2772 + t1782 + t1792 + t1816 + t1820 + t1822 - 0.18635258017632964666666666666666666666666666666667e2 * t1917 * t2735
  t2784 = t1852 * t285 * t56 * t2721
  t2788 = t433 * t285 * t55 * t2146
  t2802 = (t1986 - 0.1187931309903801598e2 * t2724 + t1988 + 0.1187931309903801598e2 * t2727) * t1993
  t2844 = t1876 - 0.20000000000000000000000000000000000000000000000000e1 * t2784 + t1878 + 0.20000000000000000000000000000000000000000000000000e1 * t2788 + t1880 - 0.505765839233979018e0 * t2724 + t1882 + 0.505765839233979018e0 * t2727
  t2849 = 0.41150663529849592833333333333333333333333333333333e-1 * t1920 * t1957 * t514 * t2146 - 0.41150663529849592833333333333333333333333333333333e-1 * t1920 * t454 * (t1921 - 0.40000000000000000000000000000000000000000000000000e1 * t2784 + t1923 + 0.40000000000000000000000000000000000000000000000000e1 * t2788 + t1925 - 0.821419393556370918e0 * t2724 + t1927 + 0.821419393556370918e0 * t2727) * t1930 - 0.19489173774580151666666666666666666666666666666667e2 * t1983 * t2735 + 0.19489173774580151666666666666666666666666666666667e2 * t2802 * t452 * t455 - 0.49373337174483548166666666666666666666666666666667e1 * t1944 * t2735 + 0.49373337174483548166666666666666666666666666666667e1 * t2729 * t1947 * t452 * t455 - 0.18805371096875317166666666666666666666666666666667e1 * t1962 * t2735 + 0.18805371096875317166666666666666666666666666666667e1 * (t1965 - 0.3208484191527680656e1 * t2784 + t1967 + 0.3208484191527680656e1 * t2788 + t1969 - 0.64e0 * t2724 + t1971 + 0.64e0 * t2727) * t1974 * t452 * t455 + 0.37610742193750634333333333333333333333333333333333e1 * t1998 * t2735 - 0.71081757481838512166666666666666666666666666666666e1 * t1831 * t2739 + 0.71081757481838512166666666666666666666666666666666e1 * t1834 * t2743 + 0.24275161951943278333333333333333333333333333333333e1 * t1841 * t2735 - 0.24275161951943278333333333333333333333333333333333e1 * (t1848 - 0.6250000000000000000e1 * t2784 + t1859 + 0.6250000000000000000e1 * t2788 + t1864 - 0.1246694626254477116e1 * t2724 + t1866 + 0.1246694626254477116e1 * t2727) * t1869 * t452 * t455 - 0.17770439370459628041666666666666666666666666666666e1 * t1875 * t94 * t132 * t2844
  t2867 = t2012 - 0.2268740929159060520e0 * t2784 + t2014 + 0.2268740929159060520e0 * t2788 + t2016 - 0.452548339959390416e-1 * t2724 + t2018 + 0.452548339959390416e-1 * t2727
  t2882 = t2026 + t2037 - t2047 - 0.14975624337724556833333333333333333333333333333333e0 * t2736 + 0.37002892246025966500000000000000000000000000000000e-1 * t2740 - 0.37002892246025966500000000000000000000000000000000e-1 * t2744 + 0.102377731051917540e0 * t2724 - t2050 - t2051 - t2053 - t2054 + 0.14975624337724556833333333333333333333333333333333e0 * t2772 - 0.102377731051917540e0 * t2727 - t2058 - t2060
  t2927 = t309 * t1957 * t2146
  t2937 = t2730 * t1826 * t2069 / 0.12e2 - t462 * t2758 * t455 / 0.6e1 + t467 * (t2072 - 0.15323028051206832e1 * t2784 + t2074 + 0.15323028051206832e1 * t2788 + t2076 - 0.3056501876701794e0 * t2724 + t2078 + 0.3056501876701794e0 * t2727) * t452 * t455 / 0.6e1 - t458 * (t2088 - 0.76615140256034248e0 * t2784 + t2090 + 0.76615140256034248e0 * t2788 + t2092 - 0.15282509383508946e0 * t2724 + t2094 + 0.15282509383508946e0 * t2727) * t452 * t455 / 0.6e1 - t451 * t2758 * t455 / 0.6e1 - t447 * (t2107 - 0.14770435158815312e1 * t2784 + t2109 + 0.14770435158815312e1 * t2788 + t2111 - 0.2946275542389858e0 * t2724 + t2113 + 0.2946275542389858e0 * t2727) * t452 * t455 / 0.6e1 + t471 * t2758 * t455 / 0.6e1 - t2867 * t444 * t2041 * t1729 / 0.6e1 - t472 * t2927 / 0.6e1 + t453 * t2927 / 0.6e1 - t2802 * t2031 * t1729 / 0.6e1 + t463 * t2927 / 0.6e1 + t2064 - t2066 + t2121
  t2940 = 0.22140749178833072666666666666666666666666666666667e1 * t1893 * t2735 - 0.22140749178833072666666666666666666666666666666667e1 * ((t1896 - 0.942121195869983724e0 * t2724 + t1898 + 0.942121195869983724e0 * t2727) * t534 - t1904 * t2844 / 0.2e1) * t1912 * t452 * t455 - t2011 * t2867 - 0.29824072957409816559941479573310560000000000000001e1 * t1662 * (t1666 - 0.156250e1 * t2724 + t1717 + 0.156250e1 * t2727) * t1726 * t1729 + t444 * (t2882 + t2937) + t1829 + t1840 + t1892 - t1938 - t1942 + t1956 - t1982 - t2004 + t2008
  vrho_1_ = t560 + t4 * ((t561 / 0.2e1 + t562 / 0.2e1) * t208 + t8 * (t2244 + t2278 + t2419 + t2429) + t2435 * t413 / 0.8e1 + t212 * (t2595 + t2597 + t2669 + t2684) / 0.8e1 + t2691 * t555 / 0.8e1 + t417 * (t2771 + t2776 + t2849 + t2940) / 0.8e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a_24_i = np.array([np.nan, -113.69336978972719, 24.005021512787113, 49.341312958396706, -23.82423721683793, 0.9440807416951048, 0.000293039144178338], dtype=np.float64)

  b_24_i = np.array([np.nan, -109.7426349321691, 16.266312944424243, 54.403433137390834, -25.15400990418799, 1.0], dtype=np.float64)

  c_25_i = np.array([np.nan, -0.32481568604919886, 1.1801314654631911, -1.4269304149842164, 0.580344063812248, -0.0109912236729144], dtype=np.float64)

  d_25_i = np.array([np.nan, -0.5778610319323944, 2.0970850588349075, -2.5218818358694817, 1.0], dtype=np.float64)

  eta6 = 0.41081146652128

  eta7 = 0.599343256903515

  eta8 = 1.70939476802168

  eta9 = 0.077123208419481

  eta10 = 0.46958449007619

  eta1 = 0.538074483500437

  eta2 = -2.22609499098519

  eta3 = 0.837303782322808

  eta4 = 2.619709858963178

  eta5 = 1.03665759464352

  ax = (3 * jnp.pi ** 2) ** (1 / 3)

  a1 = 0.1846304394851914

  a2 = 5.939656549519008

  a3 = 2.369580128666418

  a4 = 0.05118886552595877

  a5 = 0.09576892532004282

  a6 = 0.028359261614488256

  a7 = 0.02262741699796952

  a8 = 0.005317361552716548

  a9 = 0.1915378506400854

  a10 = 0.1473137771194929

  a11 = 0.1528250938350897

  a12 = 1.0150830754383913

  a13 = 0.07641254691754473

  a14 = 0.8985374602634734

  a15 = 0.01795667349750801

  a16 = 0.0346182074034769

  a17 = 0.03591334699501599

  a18 = 0.2220173534761558

  c1 = 132.47909028779435

  c2 = 32.40147085167714

  c3 = 22.56644531625038

  c4 = 11.28322265812519

  c5 = 0.4010605239409601

  c6 = 0.32

  c7 = 0.07519884823893001

  c8 = 116.93504264748091

  c9 = 29.62400230469013

  c10 = 0.4822571819944727

  c11 = 0.24690398117909756

  c12 = 1 / 2

  c13 = 0.4107096967781855

  c14 = 0.10532352447676886

  c15 = 14.565097171165966

  c16 = 0.78125

  c17 = 0.6233473131272386

  c18 = 0.146484375

  c19 = 111.81154810579778

  c20 = 0.16004110557090126

  c21 = 0.78125

  c22 = 0.3208669506079574

  c23 = 13.284449507299843

  c24 = 0.26841867131910735

  c25 = 0.4710605979349919

  c26 = 1 / 4

  c27 = 0.2528829196169895

  c28 = 0.07204858311271498

  c29 = 42.64905448910311

  f_r = lambda rs: jnp.sum(jnp.array([a_24_i[i] * rs ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([b_24_i[i] * rs ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  f_s = lambda z: jnp.sum(jnp.array([c_25_i[i] * z ** (i - 1) for i in range(1, 5 + 1)]), axis=0) / jnp.sum(jnp.array([d_25_i[i] * z ** (i - 1) for i in range(1, 4 + 1)]), axis=0)

  alpha_n = lambda rs: +eta6 + eta7 * jnp.exp(-eta8 * rs ** (1 / 3)) * rs ** (2 / 3) + eta9 * jnp.exp(-eta10 * rs ** (1 / 3)) * rs ** (1 / 3)

  beta_eff = lambda rs: +eta1 + eta2 * jnp.exp(-eta3 * rs ** (1 / 3)) * rs ** (1 / 4) + eta4 * jnp.exp(-eta5 * rs ** (1 / 3)) * rs ** (1 / 3)

  k_fs = lambda rs, z: ax * f.RS_FACTOR / rs * f.opz_pow_n(z, 1 / 3)

  D_1 = lambda k: a6 * k ** 2 + a7 * k + a8

  D_3 = lambda k: a5 * k ** 2 + a13 * k + a15

  D_2 = lambda k: a1 * k ** 2 + a10 * k + a16

  D_4 = lambda k: a9 * k ** 2 + a11 * k + a17

  D_5 = lambda k: c5 * k ** 2 + c6 * k + c7

  D_6 = lambda k: c12 * k ** 2 + c13 * k + c14

  D_7 = lambda k: c16 * k ** 2 + c17 * k + c18

  D_8 = lambda k: jnp.sqrt(c26 * k ** 2 + c27 * k + c28)

  ss = lambda rs, z: f_r(rs) * f_s(z) * 1.28

  k_ud = lambda rs, z: beta_eff(rs) * 2 * k_fs(rs, z) * k_fs(rs, -z) / (k_fs(rs, z) + k_fs(rs, -z))

  Q_1ud = lambda k: 1 / D_1(k) * (-jnp.arctan(a2 * k + a3) * D_2(k) / k - jnp.log(D_1(k)) * D_3(k) / k + jnp.log(k) * D_4(k) / k - a4 * k + a12 + a14 / k + a18 / k ** 2)

  Q_2ud = lambda k: -c1 / k - c2 / k ** 2 - c3 * jnp.log(k) / k + c4 * jnp.log(D_5(k)) / k + c8 * jnp.arctan(a2 * k + a3) / k + c9 * jnp.log(k + c10) / k - c11 / k * jnp.log(D_6(k))

  Q_3ud = lambda k: +c19 * jnp.arctan(c20 / (c21 * k + c22)) / k - c23 * jnp.arctanh((c24 + c25 * k) / D_8(k)) / k - c15 * jnp.log(D_7(k)) / k - c29 * D_8(k) / k ** 2

  alpha_z = lambda rs, z: 2 / (f.opz_pow_n(z, ss(rs, z)) + f.opz_pow_n(-z, ss(rs, z)))

  ec_opp = lambda rs, z: (1 - z ** 2) / 4 * (Q_1ud(k_ud(rs, z)) + Q_2ud(k_ud(rs, z)) + Q_3ud(k_ud(rs, z)))

  alpha_eff = lambda rs, z: alpha_n(rs) * alpha_z(rs, z)

  k_uu = lambda rs, z: alpha_eff(rs, z) * k_fs(rs, z)

  k_dd = lambda rs, z: alpha_eff(rs, -z) * k_fs(rs, -z)

  ec_par = lambda rs, z: +f.opz_pow_n(z, 2) / 8 * (Q_1ud(k_uu(rs, z)) + Q_2ud(k_uu(rs, z)) + Q_3ud(k_uu(rs, z))) + f.opz_pow_n(-z, 2) / 8 * (Q_1ud(k_dd(rs, z)) + Q_2ud(k_dd(rs, z)) + Q_3ud(k_dd(rs, z)))

  functional_body = lambda rs, z: f.n_total(rs) * (ec_opp(rs, z) + ec_par(rs, z))

  t1 = 4 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / jnp.pi
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t3 * t5
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t10 = t6 * t2 * t8
  t11 = t10 ** (0.1e1 / 0.3e1)
  t12 = t2 * t11
  t14 = jnp.exp(-0.20932594558070200000000000000000000000000000000000e0 * t12)
  t15 = 4 ** (0.1e1 / 0.4e1)
  t16 = t15 ** 2
  t19 = t10 ** (0.1e1 / 0.4e1)
  t23 = jnp.exp(-0.25916439866088000000000000000000000000000000000000e0 * t12)
  t27 = 0.1076148967000874e1 - 0.11130474954925950000000000000000000000000000000000e1 * t14 * t16 * t15 * t19 + 0.13098549294815890000000000000000000000000000000000e1 * t23 * t2 * t11
  t28 = t27 ** 2
  t29 = t3 ** 2
  t30 = t28 * t29
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t7 ** 2
  t35 = t33 * t34
  t36 = 0.1e1 <= f.p.zeta_threshold
  t37 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t38 = f.my_piecewise3(t36, t37, 1)
  t39 = t38 ** 2
  t40 = t35 * t39
  t41 = t30 * t40
  t43 = t27 * t3
  t44 = t32 * t7
  t45 = t44 * t38
  t46 = t43 * t45
  t48 = 0.70898154036220641250000000000000000000000000000000e-2 * t41 + 0.11313708498984760400000000000000000000000000000000e-1 * t46 + 0.531736155271654809e-2
  t49 = 0.1e1 / t48
  t51 = 0.29698282747595039950000000000000000000000000000000e1 * t46 + 0.236958012866641818e1
  t52 = jnp.arctan(t51)
  t55 = 0.46157609871297850000000000000000000000000000000000e-1 * t41 + 0.73656888559746450000000000000000000000000000000000e-1 * t46 + 0.3461820740347690e-1
  t56 = t52 * t55
  t57 = 0.1e1 / t27
  t58 = t56 * t57
  t59 = 0.1e1 / t32
  t60 = t29 * t59
  t61 = 0.1e1 / t38
  t62 = t8 * t61
  t63 = t60 * t62
  t66 = jnp.log(t48)
  t69 = 0.23942231330010702500000000000000000000000000000000e-1 * t41 + 0.38206273458772365000000000000000000000000000000000e-1 * t46 + 0.1795667349750801e-1
  t70 = t66 * t69
  t71 = t70 * t57
  t74 = t46 / 0.2e1
  t75 = jnp.log(t74)
  t78 = 0.47884462660021350000000000000000000000000000000000e-1 * t41 + 0.76412546917544850000000000000000000000000000000000e-1 * t46 + 0.3591334699501599e-1
  t79 = t75 * t78
  t80 = t79 * t57
  t84 = t57 * t29
  t85 = t59 * t8
  t86 = t85 * t61
  t87 = t84 * t86
  t89 = 0.1e1 / t28
  t90 = t89 * t3
  t91 = 0.1e1 / t33
  t92 = 0.1e1 / t34
  t93 = t91 * t92
  t94 = 0.1e1 / t39
  t95 = t93 * t94
  t96 = t90 * t95
  t98 = -0.2e1 / 0.3e1 * t58 * t63 - 0.2e1 / 0.3e1 * t71 * t63 + 0.2e1 / 0.3e1 * t80 * t63 - 0.25594432762979385000000000000000000000000000000000e-1 * t46 + 0.101508307543839117e1 + 0.59902497350898227333333333333333333333333333333333e0 * t87 + 0.29602313796820773200000000000000000000000000000000e0 * t96
  t104 = t75 * t57 * t29
  t109 = 0.10026513098524002050000000000000000000000000000000e0 * t41 + 0.16000000000000000000000000000000000000000000000000e0 * t46 + 0.751988482389300153e-1
  t110 = jnp.log(t109)
  t112 = t110 * t57 * t29
  t116 = t52 * t57 * t29
  t119 = t74 + 0.482257181994472723e0
  t120 = jnp.log(t119)
  t122 = t120 * t57 * t29
  t125 = t84 * t59
  t128 = 0.12500000000000000000000000000000000000000000000000e0 * t41 + 0.20535484838909272950000000000000000000000000000000e0 * t46 + 0.105323524476768857e0
  t129 = jnp.log(t128)
  t134 = 0.39062500000000000000000000000000000000000000000000e0 * t46 + 0.32086695060795739e0
  t137 = jnp.arctan(0.160041105570901272e0 / t134)
  t139 = t137 * t57 * t29
  t143 = 0.268418671319107341e0 + 0.23553029896749593100000000000000000000000000000000e0 * t46
  t146 = 0.62500000000000000000000000000000000000000000000000e-1 * t41 + 0.12644145980849475450000000000000000000000000000000e0 * t46 + 0.720485831127149779e-1
  t147 = jnp.sqrt(t146)
  t148 = 0.1e1 / t147
  t150 = jnp.arctanh(t143 * t148)
  t152 = t150 * t57 * t29
  t157 = 0.19531250000000000000000000000000000000000000000000e0 * t41 + 0.31167365656361927900000000000000000000000000000000e0 * t46 + 0.146484374999999999e0
  t158 = jnp.log(t157)
  t160 = t158 * t57 * t29
  t164 = t147 * t89 * t3
  t167 = f.p.zeta_threshold ** 2
  t168 = f.my_piecewise3(t36, t167, 1)
  t170 = jnp.exp(-0.42734869200542000000000000000000000000000000000000e0 * t12)
  t172 = t11 ** 2
  t176 = jnp.exp(-0.11739612251904750000000000000000000000000000000000e0 * t12)
  t180 = 0.41081146652128e0 + 0.14983581422587875000000000000000000000000000000000e0 * t170 * t1 * t172 + 0.19280802104870250000000000000000000000000000000000e-1 * t176 * t2 * t11
  t181 = t180 ** 2
  t183 = t5 ** 2
  t184 = t29 * t183
  t186 = t184 * t1 * t92
  t189 = t4 / r0
  t192 = t3 * t5 * t4
  t194 = 0.1e1 / t7 / r0
  t195 = t2 * t194
  t196 = t192 * t195
  t199 = t29 * t183 * t4
  t201 = 0.1e1 / t34 / r0
  t202 = t1 * t201
  t205 = -0.113693369789727190e3 + 0.60012553781967786000000000000000000000000000000000e1 * t10 + 0.12335328239599176875000000000000000000000000000000e2 * t186 - 0.17868177912628447650000000000000000000000000000000e2 * t189 + 0.17701513906783214887500000000000000000000000000000e0 * t196 + 0.54944839533438375000000000000000000000000000000000e-4 * t199 * t202
  t210 = -0.10974263493216910e3 + 0.40665782361060603750000000000000000000000000000000e1 * t10 + 0.13600858284347709150000000000000000000000000000000e2 * t186 - 0.18865507428140992500000000000000000000000000000000e2 * t189 + 0.18750000000000000000000000000000000000000000000000e0 * t196
  t211 = 0.1e1 / t210
  t214 = f.p.zeta_threshold ** (0.71948800000000005309511855713699112460352973043633e0 * t205 * t211)
  t215 = f.my_piecewise3(t36, t214, 1)
  t216 = t215 ** 2
  t217 = 0.1e1 / t216
  t219 = t181 * t217 * t29
  t220 = t219 * t40
  t222 = 0.1e1 / t215
  t224 = t180 * t222 * t3
  t225 = t224 * t45
  t227 = 0.283592616144882565e-1 * t220 + 0.226274169979695208e-1 * t225 + 0.531736155271654809e-2
  t228 = 0.1e1 / t227
  t230 = 0.593965654951900799e1 * t225 + 0.236958012866641818e1
  t231 = jnp.arctan(t230)
  t234 = 0.1846304394851914e0 * t220 + 0.1473137771194929e0 * t225 + 0.3461820740347690e-1
  t235 = t231 * t234
  t236 = 0.1e1 / t180
  t237 = t236 * t215
  t238 = t235 * t237
  t241 = jnp.log(t227)
  t244 = 0.9576892532004281e-1 * t220 + 0.7641254691754473e-1 * t225 + 0.1795667349750801e-1
  t245 = t241 * t244
  t246 = t245 * t237
  t249 = jnp.log(t225)
  t252 = 0.1915378506400854e0 * t220 + 0.1528250938350897e0 * t225 + 0.3591334699501599e-1
  t253 = t249 * t252
  t254 = t253 * t237
  t258 = t237 * t29
  t259 = t258 * t86
  t261 = 0.1e1 / t181
  t263 = t261 * t216 * t3
  t264 = t263 * t95
  t266 = -t238 * t63 / 0.3e1 - t246 * t63 / 0.3e1 + t254 * t63 / 0.3e1 - 0.51188865525958770e-1 * t225 + 0.101508307543839117e1 + 0.29951248675449113666666666666666666666666666666667e0 * t259 + 0.74005784492051933000000000000000000000000000000000e-1 * t264
  t270 = t249 * t236
  t271 = t270 * t215
  t276 = 0.401060523940960082e0 * t220 + 0.32e0 * t225 + 0.751988482389300153e-1
  t277 = jnp.log(t276)
  t278 = t277 * t236
  t279 = t278 * t215
  t282 = t231 * t236
  t283 = t282 * t215
  t286 = t225 + 0.482257181994472723e0
  t287 = jnp.log(t286)
  t288 = t287 * t236
  t289 = t288 * t215
  t294 = 0.50000000000000000000000000000000000000000000000000e0 * t220 + 0.410709696778185459e0 * t225 + 0.105323524476768857e0
  t295 = jnp.log(t294)
  t296 = t61 * t295
  t297 = t85 * t296
  t301 = 0.78125e0 * t225 + 0.32086695060795739e0
  t304 = jnp.arctan(0.160041105570901272e0 / t301)
  t305 = t304 * t236
  t306 = t305 * t215
  t310 = 0.268418671319107341e0 + 0.471060597934991862e0 * t225
  t313 = 0.25000000000000000000000000000000000000000000000000e0 * t220 + 0.252882919616989509e0 * t225 + 0.720485831127149779e-1
  t314 = jnp.sqrt(t313)
  t315 = 0.1e1 / t314
  t317 = jnp.arctanh(t310 * t315)
  t318 = t317 * t236
  t319 = t318 * t215
  t324 = 0.781250000000000000e0 * t220 + 0.623347313127238558e0 * t225 + 0.146484374999999999e0
  t325 = jnp.log(t324)
  t326 = t325 * t236
  t327 = t326 * t215
  t330 = t314 * t261
  t331 = t330 * t216
  t332 = t3 * t91
  t333 = t92 * t94
  t334 = t332 * t333
  t337 = t228 * t266 - 0.44159696762598118333333333333333333333333333333333e2 * t259 - 0.10800490283892378933333333333333333333333333333333e2 * t264 - 0.75221484387501268666666666666666666666666666666667e1 * t271 * t63 + 0.37610742193750634333333333333333333333333333333333e1 * t279 * t63 + 0.38978347549160303333333333333333333333333333333333e2 * t283 * t63 + 0.98746674348967096333333333333333333333333333333333e1 * t289 * t63 - 0.82301327059699185666666666666666666666666666666667e-1 * t258 * t297 + 0.37270516035265929333333333333333333333333333333333e2 * t306 * t63 - 0.44281498357666145333333333333333333333333333333333e1 * t319 * t63 - 0.48550323903886556666666666666666666666666666666667e1 * t327 * t63 - 0.14216351496367702433333333333333333333333333333333e2 * t331 * t334
  t340 = t49 * t98 / 0.4e1 - 0.22079848381299059166666666666666666666666666666667e2 * t87 - 0.10800490283892378933333333333333333333333333333333e2 * t96 - 0.37610742193750634333333333333333333333333333333332e1 * t104 * t86 + 0.18805371096875317166666666666666666666666666666667e1 * t112 * t86 + 0.19489173774580151666666666666666666666666666666667e2 * t116 * t86 + 0.49373337174483548166666666666666666666666666666668e1 * t122 * t86 - 0.41150663529849592833333333333333333333333333333332e-1 * t125 * t62 * t129 + 0.18635258017632964666666666666666666666666666666667e2 * t139 * t86 - 0.22140749178833072666666666666666666666666666666667e1 * t152 * t86 - 0.24275161951943278333333333333333333333333333333333e1 * t160 * t86 - 0.14216351496367702433333333333333333333333333333333e2 * t164 * t95 + t168 * t337 / 0.4e1
  t343 = r0 ** 2
  t344 = t48 ** 2
  t350 = 4 ** (0.1e1 / 0.12e2)
  t351 = t10 ** (0.1e1 / 0.12e2)
  t352 = t351 ** 2
  t353 = t352 ** 2
  t358 = t5 * t194
  t362 = t350 ** 2
  t363 = t362 ** 2
  t366 = t19 ** 2
  t370 = t6 * t194
  t373 = 0.1e1 / t11
  t374 = t373 * t3
  t375 = t358 * t23
  t380 = t1 / t172 * t3
  t383 = -0.41420394572483483663078382522666666666666666666666e0 * t350 / t353 / t351 * t3 * t358 * t14 + 0.37101583183086500000000000000000000000000000000000e0 * t14 * t363 * t350 / t366 / t19 * t370 + 0.60349824912370736189193695701333333333333333333332e0 * t374 * t375 - 0.58215774643626177777777777777777777777777777777778e0 * t380 * t375
  t385 = t27 * t29 * t33 * t34 * t39 * t383
  t388 = t33 * t8 * t39
  t389 = t30 * t388
  t392 = t383 * t3 * t45
  t395 = t32 * t92 * t38
  t396 = t43 * t395
  t398 = 0.14179630807244128250000000000000000000000000000000e-1 * t385 + 0.47265436024147094166666666666666666666666666666667e-2 * t389 + 0.11313708498984760400000000000000000000000000000000e-1 * t392 + 0.37712361663282534666666666666666666666666666666667e-2 * t396
  t401 = t134 ** 2
  t402 = 0.1e1 / t401
  t414 = t59 * t194
  t415 = t414 * t61
  t416 = t84 * t415
  t419 = t91 * t201 * t94
  t420 = t90 * t419
  t422 = t227 ** 2
  t425 = t180 * t217
  t434 = t358 * t176
  t439 = 0.28458728544442838433866339033333333333333333333333e-1 * t2 * t3 * t358 * t170 - 0.13318739042300333333333333333333333333333333333333e0 * t170 * t373 * t370 + 0.40239847220779676332411397100000000000000000000000e-2 * t374 * t434 - 0.85692453799423333333333333333333333333333333333333e-2 * t380 * t434
  t442 = t425 * t29 * t35 * t39 * t439
  t448 = t6 * t195
  t450 = t184 * t202
  t453 = t4 / t343
  t458 = t192 * t2 / t7 / t343
  t468 = t210 ** 2
  t480 = jnp.log(f.p.zeta_threshold)
  t482 = f.my_piecewise3(t36, t214 * (0.71948800000000005309511855713699112460352973043633e0 * (-0.20004184593989262000000000000000000000000000000000e1 * t448 - 0.82235521597327845833333333333333333333333333333333e1 * t450 + 0.17868177912628447650000000000000000000000000000000e2 * t453 - 0.23602018542377619850000000000000000000000000000000e0 * t458 - 0.91574732555730625000000000000000000000000000000000e-4 * t199 * t1 / t34 / t343) * t211 - 0.71948800000000005309511855713699112460352973043633e0 * t205 / t468 * (-0.13555260787020201250000000000000000000000000000000e1 * t448 - 0.90672388562318061000000000000000000000000000000000e1 * t450 + 0.18865507428140992500000000000000000000000000000000e2 * t453 - 0.25000000000000000000000000000000000000000000000000e0 * t458)) * t480, 0)
  t485 = t181 / t216 / t215 * t29 * t35 * t39 * t482
  t487 = t219 * t388
  t491 = t439 * t222 * t3 * t45
  t496 = t425 * t3 * t44 * t38 * t482
  t498 = t224 * t395
  t500 = 0.567185232289765130e-1 * t442 - 0.567185232289765130e-1 * t485 + 0.18906174409658837666666666666666666666666666666667e-1 * t487 + 0.226274169979695208e-1 * t491 - 0.226274169979695208e-1 * t496 + 0.75424723326565069333333333333333333333333333333333e-2 * t498
  t503 = t215 * t29
  t506 = t85 * t61 * t439
  t514 = 0.1e1 / t181 / t180
  t516 = t216 * t3
  t519 = t93 * t94 * t439
  t525 = t93 * t94 * t482
  t546 = 0.50000000000000000000000000000000000000000000000000e0 * t442 - 0.50000000000000000000000000000000000000000000000000e0 * t485 + 0.16666666666666666666666666666666666666666666666667e0 * t487 + 0.252882919616989509e0 * t491 - 0.252882919616989509e0 * t496 + 0.84294306538996503000000000000000000000000000000000e-1 * t498
  t550 = t310 ** 2
  t594 = -0.1e1 / t422 * t266 * t500 - 0.38978347549160303333333333333333333333333333333333e2 * t231 * t261 * t503 * t506 + 0.75221484387501268666666666666666666666666666666667e1 * t249 * t261 * t503 * t506 + 0.28432702992735404866666666666666666666666666666666e2 * t314 * t514 * t516 * t519 - 0.28432702992735404866666666666666666666666666666666e2 * t330 * t215 * t3 * t525 + 0.44281498357666145333333333333333333333333333333333e1 * t317 * t261 * t503 * t506 - 0.44281498357666145333333333333333333333333333333333e1 * ((0.471060597934991862e0 * t491 - 0.471060597934991862e0 * t496 + 0.15702019931166395400000000000000000000000000000000e0 * t498) * t315 - t310 / t314 / t313 * t546 / 0.2e1) / (0.1e1 - t550 / t313) * t237 * t63 + 0.48550323903886556666666666666666666666666666666667e1 * t325 * t261 * t503 * t506 - 0.48550323903886556666666666666666666666666666666667e1 * (0.1562500000000000000e1 * t442 - 0.1562500000000000000e1 * t485 + 0.52083333333333333333333333333333333333333333333333e0 * t487 + 0.623347313127238558e0 * t491 - 0.623347313127238558e0 * t496 + 0.20778243770907951933333333333333333333333333333333e0 * t498) / t324 * t237 * t63 - 0.71081757481838512166666666666666666666666666666665e1 * t315 * t261 * t516 * t93 * t94 * t546 - 0.82301327059699185666666666666666666666666666666667e-1 * t237 * t60 * t62 * (0.10000000000000000000000000000000000000000000000000e1 * t442 - 0.10000000000000000000000000000000000000000000000000e1 * t485 + 0.33333333333333333333333333333333333333333333333333e0 * t487 + 0.410709696778185459e0 * t491 - 0.410709696778185459e0 * t496 + 0.13690323225939515300000000000000000000000000000000e0 * t498) / t294
  t603 = t230 ** 2
  t606 = (0.593965654951900799e1 * t491 - 0.593965654951900799e1 * t496 + 0.19798855165063359966666666666666666666666666666667e1 * t498) / (0.1e1 + t603)
  t615 = t491 - t496 + t498 / 0.3e1
  t621 = t261 * t215
  t645 = t503 * t86
  t661 = t60 * t62 * t439
  t664 = t236 * t482
  t668 = t194 * t61
  t669 = t60 * t668
  t696 = t615 * t261
  t713 = -t606 * t234 * t236 * t645 / 0.3e1 - t231 * (0.3692608789703828e0 * t442 - 0.3692608789703828e0 * t485 + 0.12308695965679426666666666666666666666666666666667e0 * t487 + 0.1473137771194929e0 * t491 - 0.1473137771194929e0 * t496 + 0.49104592373164300000000000000000000000000000000000e-1 * t498) * t237 * t63 / 0.3e1 + t235 * t621 * t661 / 0.3e1 - t235 * t664 * t63 / 0.3e1 + t238 * t669 / 0.9e1 - t500 * t228 * t244 * t236 * t645 / 0.3e1 - t241 * (0.19153785064008562e0 * t442 - 0.19153785064008562e0 * t485 + 0.63845950213361873333333333333333333333333333333333e-1 * t487 + 0.7641254691754473e-1 * t491 - 0.7641254691754473e-1 * t496 + 0.25470848972514910000000000000000000000000000000000e-1 * t498) * t237 * t63 / 0.3e1 + t245 * t621 * t661 / 0.3e1 - t245 * t664 * t63 / 0.3e1 + t246 * t669 / 0.9e1 + t696 * t516 * t93 * t94 * t252 / 0.3e1 + t249 * (0.3830757012801708e0 * t442 - 0.3830757012801708e0 * t485 + 0.12769190042672360000000000000000000000000000000000e0 * t487 + 0.1528250938350897e0 * t491 - 0.1528250938350897e0 * t496 + 0.50941697945029900000000000000000000000000000000000e-1 * t498) * t237 * t63 / 0.3e1
  t726 = t621 * t29 * t506
  t728 = t664 * t29
  t729 = t728 * t86
  t731 = t258 * t415
  t735 = t514 * t216 * t3 * t519
  t738 = t621 * t3 * t525
  t740 = t263 * t419
  t742 = -t253 * t621 * t661 / 0.3e1 + t253 * t664 * t63 / 0.3e1 - t254 * t669 / 0.9e1 - 0.51188865525958770e-1 * t491 + 0.51188865525958770e-1 * t496 - 0.17062955175319590000000000000000000000000000000000e-1 * t498 - 0.29951248675449113666666666666666666666666666666667e0 * t726 + 0.29951248675449113666666666666666666666666666666667e0 * t729 - 0.99837495584830378888888888888888888888888888888890e-1 * t731 - 0.14801156898410386600000000000000000000000000000000e0 * t735 + 0.14801156898410386600000000000000000000000000000000e0 * t738 - 0.49337189661367955333333333333333333333333333333333e-1 * t740
  t745 = t301 ** 2
  t746 = 0.1e1 / t745
  t763 = -0.37270516035265929333333333333333333333333333333333e2 * t304 * t261 * t503 * t506 + 0.38978347549160303333333333333333333333333333333333e2 * t606 * t237 * t63 - 0.98746674348967096333333333333333333333333333333333e1 * t287 * t261 * t503 * t506 + 0.98746674348967096333333333333333333333333333333333e1 * t615 / t286 * t237 * t63 + 0.82301327059699185666666666666666666666666666666667e-1 * t621 * t60 * t62 * t295 * t439 - 0.37610742193750634333333333333333333333333333333333e1 * t277 * t261 * t503 * t506 + 0.37610742193750634333333333333333333333333333333333e1 * (0.802121047881920164e0 * t442 - 0.802121047881920164e0 * t485 + 0.26737368262730672133333333333333333333333333333333e0 * t487 + 0.32e0 * t491 - 0.32e0 * t496 + 0.10666666666666666666666666666666666666666666666667e0 * t498) / t276 * t237 * t63 + t228 * (t713 + t742) - 0.59648145914819633119882959146621119999999999999999e1 * t746 * (0.78125e0 * t491 - 0.78125e0 * t496 + 0.26041666666666666666666666666666666666666666666667e0 * t498) / (0.1e1 + 0.25613155472356366159499382371217984e-1 * t746) * t236 * t645 + 0.25073828129167089555555555555555555555555555555556e1 * t271 * t669 - 0.12536914064583544777777777777777777777777777777778e1 * t279 * t669
  t791 = -0.48550323903886556666666666666666666666666666666667e1 * t326 * t482 * t63 - 0.44281498357666145333333333333333333333333333333333e1 * t318 * t482 * t63 + 0.37270516035265929333333333333333333333333333333333e2 * t305 * t482 * t63 + 0.38978347549160303333333333333333333333333333333333e2 * t282 * t482 * t63 + 0.98746674348967096333333333333333333333333333333333e1 * t288 * t482 * t63 - 0.82301327059699185666666666666666666666666666666667e-1 * t728 * t297 + 0.37610742193750634333333333333333333333333333333333e1 * t278 * t482 * t63 - 0.75221484387501268666666666666666666666666666666667e1 * t270 * t482 * t63 - 0.21600980567784757866666666666666666666666666666666e2 * t738 + 0.44159696762598118333333333333333333333333333333333e2 * t726 + 0.21600980567784757866666666666666666666666666666666e2 * t735
  t815 = -0.75221484387501268666666666666666666666666666666667e1 * t696 * t216 * t334 + 0.94775676642451349555555555555555555555555555555553e1 * t331 * t332 * t201 * t94 + 0.14760499452555381777777777777777777777777777777778e1 * t319 * t669 + 0.16183441301295518888888888888888888888888888888889e1 * t327 * t669 - 0.12423505345088643111111111111111111111111111111111e2 * t306 * t669 - 0.12992782516386767777777777777777777777777777777778e2 * t283 * t669 - 0.32915558116322365444444444444444444444444444444444e1 * t289 * t669 + 0.27433775686566395222222222222222222222222222222222e-1 * t258 * t414 * t296 - 0.44159696762598118333333333333333333333333333333333e2 * t729 + 0.72003268559282526222222222222222222222222222222220e1 * t740 + 0.14719898920866039444444444444444444444444444444444e2 * t731
  t823 = t51 ** 2
  t826 = (0.29698282747595039950000000000000000000000000000000e1 * t392 + 0.98994275825316799833333333333333333333333333333333e0 * t396) / (0.1e1 + t823)
  t840 = t89 * t29
  t843 = t85 * t61 * t383
  t869 = t392 / 0.2e1 + t396 / 0.6e1
  t871 = t869 * t89 * t3
  t892 = t840 * t59
  t894 = t892 * t62 * t383
  t898 = 0.1e1 / t28 / t27
  t902 = t898 * t3 * t91 * t333 * t383
  t905 = -0.2e1 / 0.3e1 * t826 * t55 * t57 * t63 - 0.2e1 / 0.3e1 * t52 * (0.92315219742595700000000000000000000000000000000000e-1 * t385 + 0.30771739914198566666666666666666666666666666666667e-1 * t389 + 0.73656888559746450000000000000000000000000000000000e-1 * t392 + 0.24552296186582150000000000000000000000000000000000e-1 * t396) * t57 * t63 + 0.2e1 / 0.3e1 * t56 * t840 * t843 + 0.2e1 / 0.9e1 * t58 * t669 - 0.2e1 / 0.3e1 * t398 * t49 * t69 * t57 * t63 - 0.2e1 / 0.3e1 * t66 * (0.47884462660021405000000000000000000000000000000000e-1 * t385 + 0.15961487553340468333333333333333333333333333333333e-1 * t389 + 0.38206273458772365000000000000000000000000000000000e-1 * t392 + 0.12735424486257455000000000000000000000000000000000e-1 * t396) * t57 * t63 + 0.2e1 / 0.3e1 * t70 * t840 * t843 + 0.2e1 / 0.9e1 * t71 * t669 + 0.4e1 / 0.3e1 * t871 * t93 * t94 * t78 + 0.2e1 / 0.3e1 * t75 * (0.95768925320042700000000000000000000000000000000000e-1 * t385 + 0.31922975106680900000000000000000000000000000000000e-1 * t389 + 0.76412546917544850000000000000000000000000000000000e-1 * t392 + 0.25470848972514950000000000000000000000000000000000e-1 * t396) * t57 * t63 - 0.2e1 / 0.3e1 * t79 * t840 * t843 - 0.2e1 / 0.9e1 * t80 * t669 - 0.25594432762979385000000000000000000000000000000000e-1 * t392 - 0.85314775876597950000000000000000000000000000000000e-2 * t396 - 0.59902497350898227333333333333333333333333333333333e0 * t894 - 0.19967499116966075777777777777777777777777777777778e0 * t416 - 0.59204627593641546400000000000000000000000000000000e0 * t902 - 0.19734875864547182133333333333333333333333333333333e0 * t420
  t914 = 0.12500000000000000000000000000000000000000000000000e0 * t385 + 0.41666666666666666666666666666666666666666666666667e-1 * t389 + 0.12644145980849475450000000000000000000000000000000e0 * t392 + 0.42147153269498251500000000000000000000000000000000e-1 * t396
  t939 = t143 ** 2
  t994 = -0.1e1 / t344 * t98 * t398 / 0.4e1 - 0.29824072957409816559941479573310560000000000000001e1 * t402 * (0.39062500000000000000000000000000000000000000000000e0 * t392 + 0.13020833333333333333333333333333333333333333333333e0 * t396) / (0.1e1 + 0.25613155472356366159499382371217984e-1 * t402) * t57 * t63 + 0.73599494604330197222222222222222222222222222222223e1 * t416 + 0.72003268559282526222222222222222222222222222222220e1 * t420 + t168 * (t594 + t763 + t791 + t815) / 0.4e1 + t49 * t905 / 0.4e1 - 0.71081757481838512166666666666666666666666666666665e1 * t148 * t89 * t3 * t93 * t94 * t914 + 0.28432702992735404866666666666666666666666666666666e2 * t147 * t898 * t3 * t93 * t94 * t383 + 0.22140749178833072666666666666666666666666666666667e1 * t150 * t89 * t29 * t843 - 0.22140749178833072666666666666666666666666666666667e1 * ((0.23553029896749593100000000000000000000000000000000e0 * t392 + 0.78510099655831977000000000000000000000000000000000e-1 * t396) * t148 - t143 / t147 / t146 * t914 / 0.2e1) / (0.1e1 - t939 / t146) * t57 * t63 + 0.24275161951943278333333333333333333333333333333333e1 * t158 * t89 * t29 * t843 - 0.18635258017632964666666666666666666666666666666667e2 * t137 * t89 * t29 * t843 - 0.41150663529849592833333333333333333333333333333332e-1 * t125 * t62 * (0.25000000000000000000000000000000000000000000000000e0 * t385 + 0.83333333333333333333333333333333333333333333333333e-1 * t389 + 0.20535484838909272950000000000000000000000000000000e0 * t392 + 0.68451616129697576500000000000000000000000000000000e-1 * t396) / t128 + 0.37610742193750634333333333333333333333333333333332e1 * t75 * t89 * t29 * t843 - 0.18805371096875317166666666666666666666666666666667e1 * t110 * t89 * t29 * t843 + 0.18805371096875317166666666666666666666666666666667e1 * (0.20053026197048004100000000000000000000000000000000e0 * t385 + 0.66843420656826680333333333333333333333333333333333e-1 * t389 + 0.16000000000000000000000000000000000000000000000000e0 * t392 + 0.53333333333333333333333333333333333333333333333333e-1 * t396) / t109 * t57 * t63 - 0.24275161951943278333333333333333333333333333333333e1 * (0.39062500000000000000000000000000000000000000000000e0 * t385 + 0.13020833333333333333333333333333333333333333333333e0 * t389 + 0.31167365656361927900000000000000000000000000000000e0 * t392 + 0.10389121885453975966666666666666666666666666666667e0 * t396) / t157 * t57 * t63
  t1038 = -0.19489173774580151666666666666666666666666666666667e2 * t52 * t89 * t29 * t843 + 0.19489173774580151666666666666666666666666666666667e2 * t826 * t57 * t63 - 0.49373337174483548166666666666666666666666666666668e1 * t120 * t89 * t29 * t843 + 0.49373337174483548166666666666666666666666666666668e1 * t869 / t119 * t57 * t63 + 0.41150663529849592833333333333333333333333333333332e-1 * t892 * t62 * t129 * t383 - 0.64963912581933838888888888888888888888888888888890e1 * t116 * t415 - 0.16457779058161182722222222222222222222222222222223e1 * t122 * t415 + 0.13716887843283197611111111111111111111111111111111e-1 * t125 * t668 * t129 + 0.12536914064583544777777777777777777777777777777777e1 * t104 * t415 - 0.62684570322917723888888888888888888888888888888890e0 * t112 * t415 + 0.80917206506477594444444444444444444444444444444443e0 * t160 * t415 + 0.94775676642451349555555555555555555555555555555553e1 * t164 * t419 + 0.73802497262776908888888888888888888888888888888890e0 * t152 * t415 - 0.62117526725443215555555555555555555555555555555557e1 * t139 * t415 - 0.75221484387501268666666666666666666666666666666664e1 * t871 * t95 + 0.21600980567784757866666666666666666666666666666666e2 * t902 + 0.22079848381299059166666666666666666666666666666667e2 * t894
  vrho_0_ = 0.2e1 * r0 * t340 + t343 * (t994 + t1038)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  v2rho2_0_ = 0

  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  v3rho3_0_ = 0

  res = {'v3rho3': v3rho3_0_}
  return res
