"""Generated from lda_c_vwn_2.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn - DRPA(rs, z) * f.f_zeta(z) * (1 - z ** 4) + DMC(rs, z) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn - DRPA(rs, z) * f.f_zeta(z) * (1 - z ** 4) + DMC(rs, z) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn - DRPA(rs, z) * f.f_zeta(z) * (1 - z ** 4) + DMC(rs, z) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = t11 / 0.4e1
  t13 = jnp.sqrt(t11)
  t15 = t12 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t16 = 0.1e1 / t15
  t20 = jnp.log(t4 * t10 * t16 / 0.4e1)
  t21 = 0.310907e-1 * t20
  t22 = t13 + 0.372744e1
  t25 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t22)
  t26 = 0.38783294878113014394824731224995739188004877421366e-1 * t25
  t27 = t13 / 0.2e1
  t28 = t27 + 0.10498e0
  t29 = t28 ** 2
  t31 = jnp.log(t29 * t16)
  t32 = 0.96902277115443742137603943210562149050493484994510e-3 * t31
  t33 = jnp.pi ** 2
  t34 = 0.1e1 / t33
  t36 = t12 + 0.53417500000000000000000000000000000000000000000000e0 * t13 + 0.114813e2
  t37 = 0.1e1 / t36
  t41 = jnp.log(t4 * t10 * t37 / 0.4e1)
  t42 = t13 + 0.106835e1
  t45 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t42)
  t47 = t27 + 0.228344e0
  t48 = t47 ** 2
  t50 = jnp.log(t48 * t37)
  t53 = t34 * (t41 + 0.32323836906055067299704130765928097906535029214057e0 * t45 + 0.21608710360898267021763215722876235716176892439270e-1 * t50)
  t54 = r0 - r1
  t55 = 0.1e1 / t7
  t56 = t54 * t55
  t57 = 0.1e1 + t56
  t58 = t57 <= f.p.zeta_threshold
  t59 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t60 = t59 * f.p.zeta_threshold
  t61 = t57 ** (0.1e1 / 0.3e1)
  t63 = f.my_piecewise3(t58, t60, t61 * t57)
  t64 = 0.1e1 - t56
  t65 = t64 <= f.p.zeta_threshold
  t66 = t64 ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t65, t60, t66 * t64)
  t69 = t63 + t68 - 0.2e1
  t70 = t53 * t69
  t71 = 2 ** (0.1e1 / 0.3e1)
  t72 = t71 - 0.1e1
  t74 = 0.1e1 / t72 / 0.2e1
  t75 = t54 ** 2
  t76 = t75 ** 2
  t77 = t7 ** 2
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t82 = t74 * (-t76 * t79 + 0.1e1)
  t83 = 0.9e1 / 0.4e1 * t72
  t84 = t82 * t83
  t86 = t70 * t84 / 0.6e1
  t88 = t12 + 0.10061550000000000000000000000000000000000000000000e2 * t13 + 0.101578e3
  t89 = 0.1e1 / t88
  t93 = jnp.log(t4 * t10 * t89 / 0.4e1)
  t95 = t13 + 0.201231e2
  t98 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t95)
  t100 = t27 + 0.743294e0
  t101 = t100 ** 2
  t103 = jnp.log(t101 * t89)
  t106 = t12 + 0.65360000000000000000000000000000000000000000000000e1 * t13 + 0.427198e2
  t107 = 0.1e1 / t106
  t111 = jnp.log(t4 * t10 * t107 / 0.4e1)
  t113 = t13 + 0.130720e2
  t116 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t113)
  t118 = t27 + 0.409286e0
  t119 = t118 ** 2
  t121 = jnp.log(t119 * t107)
  t123 = 0.1554535e-1 * t93 + 0.61881802979060631480216141626488805225499304723700e0 * t98 + 0.26673100072733151593315970562575695370840511204614e-2 * t103 - 0.310907e-1 * t111 - 0.20521972937837502661166379517614390730124411627871e2 * t116 - 0.44313737677495382697984551091739236689629774931818e-2 * t121
  t124 = t123 * t69
  t125 = t124 * t82
  t127 = t12 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t128 = 0.1e1 / t127
  t132 = jnp.log(t4 * t10 * t128 / 0.4e1)
  t134 = t13 + 0.706042e1
  t137 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t134)
  t139 = t27 + 0.32500e0
  t140 = t139 ** 2
  t142 = jnp.log(t140 * t128)
  t144 = 0.1554535e-1 * t132 + 0.52491393169780936217021346072241076933841385384498e-1 * t137 + 0.22478670955426118383265363956423012380560746650571e-2 * t142 - t21 - t26 - t32
  t146 = t144 * t69 * t74
  t148 = 0.1e1 / t8 / t7
  t149 = t6 * t148
  t153 = t4 * t6
  t154 = t15 ** 2
  t155 = 0.1e1 / t154
  t157 = t4 * t149
  t158 = t157 / 0.12e2
  t159 = 0.1e1 / t13
  t161 = t3 * t6
  t163 = t159 * t1 * t161 * t148
  t165 = -t158 - 0.31062000000000000000000000000000000000000000000000e0 * t163
  t170 = t1 ** 2
  t172 = 0.1e1 / t3
  t174 = t5 * t8
  t177 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t149 * t16 / 0.12e2 - t153 * t9 * t155 * t165 / 0.4e1) * t170 * t172 * t174 * t15
  t178 = t22 ** 2
  t179 = 0.1e1 / t178
  t188 = 0.39765745675026770180313930393880960493473766078662e-1 * t179 * t159 * t1 * t161 * t148 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t179)
  t199 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t28 * t16 * t159 * t157 / 0.6e1 - t29 * t155 * t165) / t29 * t15
  t203 = t36 ** 2
  t204 = 0.1e1 / t203
  t207 = -t158 - 0.89029166666666666666666666666666666666666666666667e-1 * t163
  t217 = t42 ** 2
  t218 = 0.1e1 / t217
  t243 = t34 * ((-t4 * t149 * t37 / 0.12e2 - t153 * t9 * t204 * t207 / 0.4e1) * t170 * t172 * t174 * t36 / 0.3e1 + 0.36052240899892258526768857735182864136354273012771e0 * t218 * t159 * t1 * t161 * t148 / (0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t218) + 0.21608710360898267021763215722876235716176892439270e-1 * (-t47 * t37 * t159 * t157 / 0.6e1 - t48 * t204 * t207) / t48 * t36) * t69 * t84 / 0.6e1
  t245 = t54 / t77
  t246 = t55 - t245
  t249 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t246)
  t253 = f.my_piecewise3(t65, 0, -0.4e1 / 0.3e1 * t66 * t246)
  t254 = t249 + t253
  t259 = t75 * t54 * t79
  t262 = t76 / t78 / t7
  t265 = t74 * (-0.4e1 * t259 + 0.4e1 * t262)
  t272 = t88 ** 2
  t273 = 0.1e1 / t272
  t276 = -t158 - 0.16769250000000000000000000000000000000000000000000e1 * t163
  t286 = t95 ** 2
  t287 = 0.1e1 / t286
  t311 = t106 ** 2
  t312 = 0.1e1 / t311
  t315 = -t158 - 0.10893333333333333333333333333333333333333333333333e1 * t163
  t325 = t113 ** 2
  t326 = 0.1e1 / t325
  t349 = (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t149 * t89 / 0.12e2 - t153 * t9 * t273 * t276 / 0.4e1) * t170 * t172 * t174 * t88 + 0.12084332918108974174888840683936962325623378790503e0 * t287 * t159 * t1 * t161 * t148 / (0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t287) + 0.26673100072733151593315970562575695370840511204614e-2 * (-t100 * t89 * t159 * t157 / 0.6e1 - t101 * t273 * t276) / t101 * t88 - 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t149 * t107 / 0.12e2 - t153 * t9 * t312 * t315 / 0.4e1) * t170 * t172 * t174 * t106 - 0.15357238326806922974073998139716493771837789312610e0 * t326 * t159 * t1 * t161 * t148 / (0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t326) - 0.44313737677495382697984551091739236689629774931818e-2 * (-t118 * t107 * t159 * t157 / 0.6e1 - t119 * t312 * t315) / t119 * t106) * t69 * t82
  t356 = t127 ** 2
  t357 = 0.1e1 / t356
  t360 = -t158 - 0.58836833333333333333333333333333333333333333333333e0 * t163
  t370 = t134 ** 2
  t371 = 0.1e1 / t370
  t394 = (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t149 * t128 / 0.12e2 - t153 * t9 * t357 * t360 / 0.4e1) * t170 * t172 * t174 * t127 + 0.41388824077869423260215065147117773567486474051459e-1 * t371 * t159 * t1 * t161 * t148 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t371) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t139 * t128 * t159 * t157 / 0.6e1 - t140 * t357 * t360) / t140 * t127 - t177 - t188 - t199) * t69 * t74
  t397 = t177 + t188 + t199 - t243 - t53 * t254 * t84 / 0.6e1 - t70 * t265 * t83 / 0.6e1 - t349 - t123 * t254 * t82 - t124 * t265 + t394 + t144 * t254 * t74
  vrho_0_ = t7 * t397 - t125 + t146 + t21 + t26 + t32 - t86
  t399 = -t55 - t245
  t402 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t399)
  t406 = f.my_piecewise3(t65, 0, -0.4e1 / 0.3e1 * t66 * t399)
  t407 = t402 + t406
  t413 = t74 * (0.4e1 * t259 + 0.4e1 * t262)
  t422 = t177 + t188 + t199 - t243 - t53 * t407 * t84 / 0.6e1 - t70 * t413 * t83 / 0.6e1 - t349 - t123 * t407 * t82 - t124 * t413 + t394 + t144 * t407 * t74
  vrho_1_ = t7 * t422 - t125 + t146 + t21 + t26 + t32 - t86
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn - DRPA(rs, z) * f.f_zeta(z) * (1 - z ** 4) + DMC(rs, z) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = t10 / 0.4e1
  t12 = jnp.sqrt(t10)
  t14 = t11 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t15 = 0.1e1 / t14
  t19 = jnp.log(t4 * t9 * t15 / 0.4e1)
  t20 = 0.310907e-1 * t19
  t21 = t12 + 0.372744e1
  t24 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t21)
  t25 = 0.38783294878113014394824731224995739188004877421366e-1 * t24
  t26 = t12 / 0.2e1
  t27 = t26 + 0.10498e0
  t28 = t27 ** 2
  t30 = jnp.log(t28 * t15)
  t31 = 0.96902277115443742137603943210562149050493484994510e-3 * t30
  t32 = jnp.pi ** 2
  t33 = 0.1e1 / t32
  t35 = t11 + 0.53417500000000000000000000000000000000000000000000e0 * t12 + 0.114813e2
  t36 = 0.1e1 / t35
  t40 = jnp.log(t4 * t9 * t36 / 0.4e1)
  t41 = t12 + 0.106835e1
  t44 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t41)
  t46 = t26 + 0.228344e0
  t47 = t46 ** 2
  t49 = jnp.log(t47 * t36)
  t54 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t54 * f.p.zeta_threshold, 1)
  t58 = 0.2e1 * t56 - 0.2e1
  t59 = 2 ** (0.1e1 / 0.3e1)
  t60 = t59 - 0.1e1
  t62 = 0.1e1 / t60 / 0.2e1
  t65 = 0.9e1 / 0.4e1 * t58 * t62 * t60
  t69 = t11 + 0.10061550000000000000000000000000000000000000000000e2 * t12 + 0.101578e3
  t70 = 0.1e1 / t69
  t74 = jnp.log(t4 * t9 * t70 / 0.4e1)
  t76 = t12 + 0.201231e2
  t79 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t76)
  t81 = t26 + 0.743294e0
  t82 = t81 ** 2
  t84 = jnp.log(t82 * t70)
  t87 = t11 + 0.65360000000000000000000000000000000000000000000000e1 * t12 + 0.427198e2
  t88 = 0.1e1 / t87
  t92 = jnp.log(t4 * t9 * t88 / 0.4e1)
  t94 = t12 + 0.130720e2
  t97 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t94)
  t99 = t26 + 0.409286e0
  t100 = t99 ** 2
  t102 = jnp.log(t100 * t88)
  t108 = t11 + 0.35302100000000000000000000000000000000000000000000e1 * t12 + 0.180578e2
  t109 = 0.1e1 / t108
  t113 = jnp.log(t4 * t9 * t109 / 0.4e1)
  t115 = t12 + 0.706042e1
  t118 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t115)
  t120 = t26 + 0.32500e0
  t121 = t120 ** 2
  t123 = jnp.log(t121 * t109)
  t129 = 0.1e1 / t7 / r0
  t130 = t6 * t129
  t134 = t4 * t6
  t135 = t14 ** 2
  t136 = 0.1e1 / t135
  t138 = t4 * t130
  t139 = t138 / 0.12e2
  t140 = 0.1e1 / t12
  t142 = t3 * t6
  t144 = t140 * t1 * t142 * t129
  t146 = -t139 - 0.31062000000000000000000000000000000000000000000000e0 * t144
  t151 = t1 ** 2
  t153 = 0.1e1 / t3
  t155 = t5 * t7
  t158 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t130 * t15 / 0.12e2 - t134 * t8 * t136 * t146 / 0.4e1) * t151 * t153 * t155 * t14
  t159 = t21 ** 2
  t160 = 0.1e1 / t159
  t169 = 0.39765745675026770180313930393880960493473766078662e-1 * t160 * t140 * t1 * t142 * t129 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t160)
  t180 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t27 * t15 * t140 * t138 / 0.6e1 - t28 * t136 * t146) / t28 * t14
  t184 = t35 ** 2
  t185 = 0.1e1 / t184
  t188 = -t139 - 0.89029166666666666666666666666666666666666666666667e-1 * t144
  t198 = t41 ** 2
  t199 = 0.1e1 / t198
  t227 = t69 ** 2
  t228 = 0.1e1 / t227
  t231 = -t139 - 0.16769250000000000000000000000000000000000000000000e1 * t144
  t241 = t76 ** 2
  t242 = 0.1e1 / t241
  t266 = t87 ** 2
  t267 = 0.1e1 / t266
  t270 = -t139 - 0.10893333333333333333333333333333333333333333333333e1 * t144
  t280 = t94 ** 2
  t281 = 0.1e1 / t280
  t308 = t108 ** 2
  t309 = 0.1e1 / t308
  t312 = -t139 - 0.58836833333333333333333333333333333333333333333333e0 * t144
  t322 = t115 ** 2
  t323 = 0.1e1 / t322
  vrho_0_ = t20 + t25 + t31 - t33 * (t40 + 0.32323836906055067299704130765928097906535029214057e0 * t44 + 0.21608710360898267021763215722876235716176892439270e-1 * t49) * t65 / 0.6e1 - (0.1554535e-1 * t74 + 0.61881802979060631480216141626488805225499304723700e0 * t79 + 0.26673100072733151593315970562575695370840511204614e-2 * t84 - 0.310907e-1 * t92 - 0.20521972937837502661166379517614390730124411627871e2 * t97 - 0.44313737677495382697984551091739236689629774931818e-2 * t102) * t58 * t62 + (0.1554535e-1 * t113 + 0.52491393169780936217021346072241076933841385384498e-1 * t118 + 0.22478670955426118383265363956423012380560746650571e-2 * t123 - t20 - t25 - t31) * t58 * t62 + r0 * (t158 + t169 + t180 - t33 * ((-t4 * t130 * t36 / 0.12e2 - t134 * t8 * t185 * t188 / 0.4e1) * t151 * t153 * t155 * t35 / 0.3e1 + 0.36052240899892258526768857735182864136354273012771e0 * t199 * t140 * t1 * t142 * t129 / (0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t199) + 0.21608710360898267021763215722876235716176892439270e-1 * (-t46 * t36 * t140 * t138 / 0.6e1 - t47 * t185 * t188) / t47 * t35) * t65 / 0.6e1 - (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t130 * t70 / 0.12e2 - t134 * t8 * t228 * t231 / 0.4e1) * t151 * t153 * t155 * t69 + 0.12084332918108974174888840683936962325623378790503e0 * t242 * t140 * t1 * t142 * t129 / (0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t242) + 0.26673100072733151593315970562575695370840511204614e-2 * (-t81 * t70 * t140 * t138 / 0.6e1 - t82 * t228 * t231) / t82 * t69 - 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t130 * t88 / 0.12e2 - t134 * t8 * t267 * t270 / 0.4e1) * t151 * t153 * t155 * t87 - 0.15357238326806922974073998139716493771837789312610e0 * t281 * t140 * t1 * t142 * t129 / (0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t281) - 0.44313737677495382697984551091739236689629774931818e-2 * (-t99 * t88 * t140 * t138 / 0.6e1 - t100 * t267 * t270) / t100 * t87) * t58 * t62 + (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t130 * t109 / 0.12e2 - t134 * t8 * t309 * t312 / 0.4e1) * t151 * t153 * t155 * t108 + 0.41388824077869423260215065147117773567486474051459e-1 * t323 * t140 * t1 * t142 * t129 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t323) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t120 * t109 * t140 * t138 / 0.6e1 - t121 * t309 * t312) / t121 * t108 - t158 - t169 - t180) * t58 * t62)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t13 = t4 * t6 * t11
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t18 = 0.1e1 / t17
  t22 = t4 * t6
  t23 = t17 ** 2
  t24 = 0.1e1 / t23
  t25 = t11 * t24
  t26 = t4 * t10
  t27 = t26 / 0.12e2
  t28 = 0.1e1 / t15
  t29 = t28 * t1
  t30 = t3 * t6
  t32 = t29 * t30 * t9
  t34 = -t27 - 0.31062000000000000000000000000000000000000000000000e0 * t32
  t39 = t1 ** 2
  t41 = 0.1e1 / t3
  t42 = (-t4 * t10 * t18 / 0.12e2 - t22 * t25 * t34 / 0.4e1) * t39 * t41
  t43 = t5 * t7
  t44 = t43 * t17
  t45 = t42 * t44
  t47 = t15 + 0.372744e1
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t51 = t49 * t28 * t1
  t53 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t49
  t54 = 0.1e1 / t53
  t57 = t51 * t30 * t9 * t54
  t59 = t15 / 0.2e1
  t60 = t59 + 0.10498e0
  t61 = t60 * t18
  t62 = t61 * t28
  t65 = t60 ** 2
  t66 = t65 * t24
  t68 = -t62 * t26 / 0.6e1 - t66 * t34
  t69 = 0.1e1 / t65
  t70 = t68 * t69
  t71 = t70 * t17
  t73 = jnp.pi ** 2
  t74 = 0.1e1 / t73
  t76 = t14 + 0.53417500000000000000000000000000000000000000000000e0 * t15 + 0.114813e2
  t77 = 0.1e1 / t76
  t81 = t76 ** 2
  t82 = 0.1e1 / t81
  t83 = t11 * t82
  t85 = -t27 - 0.89029166666666666666666666666666666666666666666667e-1 * t32
  t91 = (-t4 * t10 * t77 / 0.12e2 - t22 * t83 * t85 / 0.4e1) * t39 * t41
  t92 = t43 * t76
  t95 = t15 + 0.106835e1
  t96 = t95 ** 2
  t97 = 0.1e1 / t96
  t99 = t97 * t28 * t1
  t101 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t97
  t102 = 0.1e1 / t101
  t107 = t59 + 0.228344e0
  t108 = t107 * t77
  t109 = t108 * t28
  t112 = t107 ** 2
  t113 = t112 * t82
  t115 = -t109 * t26 / 0.6e1 - t113 * t85
  t116 = 0.1e1 / t112
  t117 = t115 * t116
  t123 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t125 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t123 * f.p.zeta_threshold, 1)
  t127 = 0.2e1 * t125 - 0.2e1
  t128 = 2 ** (0.1e1 / 0.3e1)
  t129 = t128 - 0.1e1
  t131 = 0.1e1 / t129 / 0.2e1
  t134 = 0.9e1 * t127 * t131 * t129
  t138 = t14 + 0.10061550000000000000000000000000000000000000000000e2 * t15 + 0.101578e3
  t139 = 0.1e1 / t138
  t143 = t138 ** 2
  t144 = 0.1e1 / t143
  t145 = t11 * t144
  t147 = -t27 - 0.16769250000000000000000000000000000000000000000000e1 * t32
  t153 = (-t4 * t10 * t139 / 0.12e2 - t22 * t145 * t147 / 0.4e1) * t39 * t41
  t154 = t43 * t138
  t157 = t15 + 0.201231e2
  t158 = t157 ** 2
  t159 = 0.1e1 / t158
  t161 = t159 * t28 * t1
  t163 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t159
  t164 = 0.1e1 / t163
  t169 = t59 + 0.743294e0
  t170 = t169 * t139
  t171 = t170 * t28
  t174 = t169 ** 2
  t175 = t174 * t144
  t177 = -t171 * t26 / 0.6e1 - t175 * t147
  t178 = 0.1e1 / t174
  t179 = t177 * t178
  t183 = t14 + 0.65360000000000000000000000000000000000000000000000e1 * t15 + 0.427198e2
  t184 = 0.1e1 / t183
  t188 = t183 ** 2
  t189 = 0.1e1 / t188
  t190 = t11 * t189
  t192 = -t27 - 0.10893333333333333333333333333333333333333333333333e1 * t32
  t198 = (-t4 * t10 * t184 / 0.12e2 - t22 * t190 * t192 / 0.4e1) * t39 * t41
  t199 = t43 * t183
  t202 = t15 + 0.130720e2
  t203 = t202 ** 2
  t204 = 0.1e1 / t203
  t206 = t204 * t28 * t1
  t208 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t204
  t209 = 0.1e1 / t208
  t214 = t59 + 0.409286e0
  t215 = t214 * t184
  t216 = t215 * t28
  t219 = t214 ** 2
  t220 = t219 * t189
  t222 = -t216 * t26 / 0.6e1 - t220 * t192
  t223 = 0.1e1 / t219
  t224 = t222 * t223
  t232 = t14 + 0.35302100000000000000000000000000000000000000000000e1 * t15 + 0.180578e2
  t233 = 0.1e1 / t232
  t237 = t232 ** 2
  t238 = 0.1e1 / t237
  t239 = t11 * t238
  t241 = -t27 - 0.58836833333333333333333333333333333333333333333333e0 * t32
  t247 = (-t4 * t10 * t233 / 0.12e2 - t22 * t239 * t241 / 0.4e1) * t39 * t41
  t248 = t43 * t232
  t251 = t15 + 0.706042e1
  t252 = t251 ** 2
  t253 = 0.1e1 / t252
  t255 = t253 * t28 * t1
  t257 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t253
  t258 = 0.1e1 / t257
  t263 = t59 + 0.32500e0
  t264 = t263 * t233
  t265 = t264 * t28
  t268 = t263 ** 2
  t269 = t268 * t238
  t271 = -t265 * t26 / 0.6e1 - t269 * t241
  t272 = 0.1e1 / t268
  t273 = t271 * t272
  t283 = r0 ** 2
  t285 = 0.1e1 / t7 / t283
  t286 = t6 * t285
  t288 = t4 * t286 * t18
  t295 = 0.1e1 / t23 / t17
  t297 = t34 ** 2
  t301 = t4 * t286
  t302 = t301 / 0.9e1
  t304 = 0.1e1 / t15 / t13
  t306 = t3 ** 2
  t307 = t306 * t5
  t308 = t7 ** 2
  t310 = 0.1e1 / t308 / t283
  t312 = t304 * t39 * t307 * t310
  t315 = t29 * t30 * t285
  t317 = t302 - 0.20708000000000000000000000000000000000000000000000e0 * t312 + 0.41416000000000000000000000000000000000000000000000e0 * t315
  t325 = 0.10363566666666666666666666666666666666666666666667e-1 * (t288 / 0.9e1 + t22 * t9 * t24 * t34 / 0.6e1 + t22 * t11 * t295 * t297 / 0.2e1 - t22 * t25 * t317 / 0.4e1) * t39 * t41 * t44
  t327 = t5 / t308
  t330 = 0.34545222222222222222222222222222222222222222222223e-2 * t42 * t327 * t17
  t333 = 0.10363566666666666666666666666666666666666666666667e-1 * t42 * t43 * t34
  t340 = 0.13255248558342256726771310131293653497824588692887e-1 / t48 / t47 * t1 * t3 * t286 * t54
  t346 = 0.26510497116684513453542620262587306995649177385775e-1 * t49 * t304 * t39 * t307 * t310 * t54
  t350 = 0.53020994233369026907085240525174613991298354771549e-1 * t51 * t30 * t285 * t54
  t351 = t48 ** 2
  t356 = t53 ** 2
  t360 = 0.50167127350538589836488394571946851238131125013746e0 / t351 / t47 * t1 * t3 * t286 / t356
  t371 = t39 * t306 * t5 * t310
  t383 = 0.96902277115443742137603943210562149050493484994510e-3 * (t288 / 0.72e2 + t60 * t24 * t29 * t30 * t9 * t34 / 0.3e1 - t61 * t304 * t371 / 0.9e1 + 0.2e1 / 0.9e1 * t62 * t301 + 0.2e1 * t65 * t295 * t297 - t66 * t317) * t69 * t17
  t390 = 0.16150379519240623689600657201760358175082247499085e-3 * t68 / t65 / t60 * t17 * t28 * t26
  t392 = 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t34
  t394 = t4 * t286 * t77
  t401 = 0.1e1 / t81 / t76
  t403 = t85 ** 2
  t409 = t302 - 0.59352777777777777777777777777777777777777777777778e-1 * t312 + 0.11870555555555555555555555555555555555555555555556e0 * t315
  t441 = t96 ** 2
  t446 = t101 ** 2
  t485 = t4 * t286 * t139
  t492 = 0.1e1 / t143 / t138
  t494 = t147 ** 2
  t500 = t302 - 0.11179500000000000000000000000000000000000000000000e1 * t312 + 0.22359000000000000000000000000000000000000000000000e1 * t315
  t532 = t158 ** 2
  t537 = t163 ** 2
  t572 = t4 * t286 * t184
  t579 = 0.1e1 / t188 / t183
  t581 = t192 ** 2
  t587 = t302 - 0.72622222222222222222222222222222222222222222222220e0 * t312 + 0.14524444444444444444444444444444444444444444444444e1 * t315
  t619 = t203 ** 2
  t624 = t208 ** 2
  t658 = 0.51817833333333333333333333333333333333333333333333e-2 * (t485 / 0.9e1 + t22 * t9 * t144 * t147 / 0.6e1 + t22 * t11 * t492 * t494 / 0.2e1 - t22 * t145 * t500 / 0.4e1) * t39 * t41 * t154 + 0.17272611111111111111111111111111111111111111111111e-2 * t153 * t327 * t138 + 0.51817833333333333333333333333333333333333333333333e-2 * t153 * t43 * t147 + 0.40281109727029913916296135613123207752077929301677e-1 / t158 / t157 * t1 * t3 * t286 * t164 + 0.80562219454059827832592271226246415504155858603353e-1 * t159 * t304 * t39 * t307 * t310 * t164 - 0.16112443890811965566518454245249283100831171720671e0 * t161 * t30 * t285 * t164 - 0.55299776073946902741997911947426632387660200240483e-1 / t532 / t157 * t1 * t3 * t286 / t537 + 0.26673100072733151593315970562575695370840511204614e-2 * (t485 / 0.72e2 + t169 * t144 * t29 * t30 * t9 * t147 / 0.3e1 - t170 * t304 * t371 / 0.9e1 + 0.2e1 / 0.9e1 * t171 * t301 + 0.2e1 * t174 * t492 * t494 - t175 * t500) * t178 * t138 + 0.44455166787888585988859950937626158951400852007690e-3 * t177 / t174 / t169 * t138 * t28 * t26 + 0.26673100072733151593315970562575695370840511204614e-2 * t179 * t147 - 0.10363566666666666666666666666666666666666666666667e-1 * (t572 / 0.9e1 + t22 * t9 * t189 * t192 / 0.6e1 + t22 * t11 * t579 * t581 / 0.2e1 - t22 * t190 * t587 / 0.4e1) * t39 * t41 * t199 - 0.34545222222222222222222222222222222222222222222223e-2 * t198 * t327 * t183 - 0.10363566666666666666666666666666666666666666666667e-1 * t198 * t43 * t192 - 0.51190794422689743246913327132388312572792631042033e-1 / t203 / t202 * t1 * t3 * t286 * t209 - 0.10238158884537948649382665426477662514558526208407e0 * t204 * t304 * t39 * t307 * t310 * t209 + 0.20476317769075897298765330852955325029117052416813e0 * t206 * t30 * t285 * t209 + 0.10320064155614252238577726749889483814674994418074e-3 / t619 / t202 * t1 * t3 * t286 / t624 - 0.44313737677495382697984551091739236689629774931818e-2 * (t572 / 0.72e2 + t214 * t189 * t29 * t30 * t9 * t192 / 0.3e1 - t215 * t304 * t371 / 0.9e1 + 0.2e1 / 0.9e1 * t216 * t301 + 0.2e1 * t219 * t579 * t581 - t220 * t587) * t223 * t183 - 0.73856229462492304496640918486232061149382958219697e-3 * t222 / t219 / t214 * t183 * t28 * t26 - 0.44313737677495382697984551091739236689629774931818e-2 * t224 * t192
  t662 = t4 * t286 * t233
  t669 = 0.1e1 / t237 / t232
  t671 = t241 ** 2
  t677 = t302 - 0.39224555555555555555555555555555555555555555555555e0 * t312 + 0.78449111111111111111111111111111111111111111111110e0 * t315
  t709 = t252 ** 2
  t714 = t257 ** 2
  t748 = 0.51817833333333333333333333333333333333333333333333e-2 * (t662 / 0.9e1 + t22 * t9 * t238 * t241 / 0.6e1 + t22 * t11 * t669 * t671 / 0.2e1 - t22 * t239 * t677 / 0.4e1) * t39 * t41 * t248 + 0.17272611111111111111111111111111111111111111111111e-2 * t247 * t327 * t232 + 0.51817833333333333333333333333333333333333333333333e-2 * t247 * t43 * t241 + 0.13796274692623141086738355049039257855828824683819e-1 / t252 / t251 * t1 * t3 * t286 * t258 + 0.27592549385246282173476710098078515711657649367639e-1 * t253 * t304 * t39 * t307 * t310 * t258 - 0.55185098770492564346953420196157031423315298735277e-1 * t255 * t30 * t285 * t258 - 0.30878365944746984533884071665444263610784010246137e0 / t709 / t251 * t1 * t3 * t286 / t714 + 0.22478670955426118383265363956423012380560746650571e-2 * (t662 / 0.72e2 + t263 * t238 * t29 * t30 * t9 * t241 / 0.3e1 - t264 * t304 * t371 / 0.9e1 + 0.2e1 / 0.9e1 * t265 * t301 + 0.2e1 * t268 * t669 * t671 - t269 * t677) * t272 * t232 + 0.37464451592376863972108939927371687300934577750952e-3 * t271 / t268 / t263 * t232 * t28 * t26 + 0.22478670955426118383265363956423012380560746650571e-2 * t273 * t241 - t325 - t330 - t333 - t340 - t346 + t350 + t360 - t383 - t390 - t392
  t751 = t325 + t330 + t333 + t340 + t346 - t350 - t360 + t383 + t390 + t392 - t74 * ((t394 / 0.9e1 + t22 * t9 * t82 * t85 / 0.6e1 + t22 * t11 * t401 * t403 / 0.2e1 - t22 * t83 * t409 / 0.4e1) * t39 * t41 * t92 / 0.3e1 + t91 * t327 * t76 / 0.9e1 + t91 * t43 * t85 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 / t96 / t95 * t1 * t3 * t286 * t102 + 0.24034827266594839017845905156788576090902848675181e0 * t97 * t304 * t39 * t307 * t310 * t102 - 0.48069654533189678035691810313577152181805697350363e0 * t99 * t30 * t285 * t102 - 0.53818578849327899137148388724908565251436770250246e1 / t441 / t95 * t1 * t3 * t286 / t446 + 0.21608710360898267021763215722876235716176892439270e-1 * (t394 / 0.72e2 + t107 * t82 * t29 * t30 * t9 * t85 / 0.3e1 - t108 * t304 * t371 / 0.9e1 + 0.2e1 / 0.9e1 * t109 * t301 + 0.2e1 * t112 * t401 * t403 - t113 * t409) * t116 * t76 + 0.36014517268163778369605359538127059526961487398783e-2 * t115 / t112 / t107 * t76 * t28 * t26 + 0.21608710360898267021763215722876235716176892439270e-1 * t117 * t85) * t134 / 0.24e2 - t658 * t127 * t131 + t748 * t127 * t131
  v2rho2_0_ = 0.20727133333333333333333333333333333333333333333334e-1 * t45 + 0.79531491350053540360627860787761920986947532157324e-1 * t57 + 0.19380455423088748427520788642112429810098696998902e-2 * t71 - t74 * (t91 * t92 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t99 * t30 * t9 * t102 + 0.21608710360898267021763215722876235716176892439270e-1 * t117 * t76) * t134 / 0.12e2 - 0.2e1 * (0.51817833333333333333333333333333333333333333333333e-2 * t153 * t154 + 0.12084332918108974174888840683936962325623378790503e0 * t161 * t30 * t9 * t164 + 0.26673100072733151593315970562575695370840511204614e-2 * t179 * t138 - 0.10363566666666666666666666666666666666666666666667e-1 * t198 * t199 - 0.15357238326806922974073998139716493771837789312610e0 * t206 * t30 * t9 * t209 - 0.44313737677495382697984551091739236689629774931818e-2 * t224 * t183) * t127 * t131 + 0.2e1 * (0.51817833333333333333333333333333333333333333333333e-2 * t247 * t248 + 0.41388824077869423260215065147117773567486474051458e-1 * t255 * t30 * t9 * t258 + 0.22478670955426118383265363956423012380560746650571e-2 * t273 * t232 - 0.10363566666666666666666666666666666666666666666667e-1 * t45 - 0.39765745675026770180313930393880960493473766078662e-1 * t57 - 0.96902277115443742137603943210562149050493484994510e-3 * t71) * t127 * t131 + r0 * t751
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t10 = t4 * t6 * t8
  t11 = jnp.sqrt(t10)
  t12 = t11 + 0.372744e1
  t13 = t12 ** 2
  t14 = 0.1e1 / t13
  t15 = t1 ** 2
  t16 = t3 ** 2
  t17 = t15 * t16
  t18 = t7 ** 2
  t20 = t5 / t18
  t24 = 0.1e1 / t11 / t17 / t20 / 0.4e1
  t26 = r0 ** 2
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t2 * t28
  t31 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t14
  t32 = 0.1e1 / t31
  t35 = 0.15906298270010708072125572157552384197389506431465e0 * t14 * t24 * t29 * t32
  t37 = 0.1e1 / t7 / t26
  t38 = t6 * t37
  t39 = t10 / 0.4e1
  t41 = t39 + 0.18637200000000000000000000000000000000000000000000e1 * t11 + 0.129352e2
  t42 = 0.1e1 / t41
  t44 = t4 * t38 * t42
  t46 = t11 / 0.2e1
  t47 = t46 + 0.10498e0
  t48 = t41 ** 2
  t49 = 0.1e1 / t48
  t50 = t47 * t49
  t51 = 0.1e1 / t11
  t52 = t51 * t1
  t53 = t50 * t52
  t54 = t3 * t6
  t56 = 0.1e1 / t7 / r0
  t57 = t6 * t56
  t58 = t4 * t57
  t59 = t58 / 0.12e2
  t61 = t52 * t54 * t56
  t63 = -t59 - 0.31062000000000000000000000000000000000000000000000e0 * t61
  t68 = t47 * t42
  t70 = 0.1e1 / t11 / t10
  t71 = t68 * t70
  t73 = 0.1e1 / t18 / t26
  t75 = t17 * t5 * t73
  t78 = t68 * t51
  t79 = t4 * t38
  t82 = t47 ** 2
  t84 = 0.1e1 / t48 / t41
  t85 = t82 * t84
  t86 = t63 ** 2
  t89 = t82 * t49
  t90 = t79 / 0.9e1
  t91 = t70 * t15
  t92 = t16 * t5
  t94 = t91 * t92 * t73
  t97 = t52 * t54 * t37
  t99 = t90 - 0.20708000000000000000000000000000000000000000000000e0 * t94 + 0.41416000000000000000000000000000000000000000000000e0 * t97
  t101 = t44 / 0.72e2 + t53 * t54 * t56 * t63 / 0.3e1 - t71 * t75 / 0.9e1 + 0.2e1 / 0.9e1 * t78 * t79 + 0.2e1 * t85 * t86 - t89 * t99
  t103 = 0.1e1 / t82 / t47
  t105 = t41 * t51
  t108 = 0.32300759038481247379201314403520716350164494998170e-3 * t101 * t103 * t105 * t58
  t112 = -t78 * t58 / 0.6e1 - t89 * t63
  t113 = t112 * t103
  t117 = 0.32300759038481247379201314403520716350164494998170e-3 * t113 * t63 * t51 * t58
  t121 = 0.10766919679493749126400438134506905450054831666057e-3 * t113 * t41 * t70 * t75
  t122 = t113 * t105
  t124 = 0.21533839358987498252800876269013810900109663332113e-3 * t122 * t79
  t125 = 0.1e1 / t82
  t126 = t112 * t125
  t128 = 0.96902277115443742137603943210562149050493484994510e-3 * t126 * t99
  t129 = t26 * r0
  t131 = 0.1e1 / t7 / t129
  t132 = t6 * t131
  t134 = t4 * t132 * t42
  t136 = t4 * t6
  t139 = t136 * t37 * t49 * t63
  t159 = 0.1e1 / t16
  t161 = t1 * t159 * t6
  t162 = t131 * t2
  t167 = t24 * t2 * t28
  t171 = 0.1e1 / t18 / t129
  t172 = t5 * t171
  t173 = t17 * t172
  t176 = t4 * t132
  t179 = t48 ** 2
  t180 = 0.1e1 / t179
  t182 = t86 * t63
  t185 = t63 * t99
  t188 = 0.7e1 / 0.27e2 * t176
  t191 = t91 * t92 * t171
  t194 = t52 * t54 * t131
  t196 = -t188 - 0.12424800000000000000000000000000000000000000000000e1 * t167 + 0.82832000000000000000000000000000000000000000000000e0 * t191 - 0.96637333333333333333333333333333333333333333333333e0 * t194
  t198 = -0.11e2 / 0.216e3 * t134 - t139 / 0.24e2 - t47 * t84 * t52 * t54 * t56 * t86 + t50 * t91 * t92 * t73 * t63 / 0.3e1 - 0.2e1 / 0.3e1 * t53 * t54 * t37 * t63 + t53 * t54 * t56 * t99 / 0.2e1 + t161 * t162 * t42 / 0.432e3 - 0.2e1 / 0.3e1 * t68 * t167 + 0.4e1 / 0.9e1 * t71 * t173 - 0.14e2 / 0.27e2 * t78 * t176 - 0.6e1 * t82 * t180 * t182 + 0.6e1 * t85 * t185 - t89 * t196
  t201 = 0.96902277115443742137603943210562149050493484994510e-3 * t198 * t125 * t41
  t202 = t101 * t125
  t204 = 0.19380455423088748427520788642112429810098696998902e-2 * t202 * t63
  t206 = t39 + 0.35302100000000000000000000000000000000000000000000e1 * t11 + 0.180578e2
  t207 = 0.1e1 / t206
  t209 = t4 * t38 * t207
  t211 = t46 + 0.32500e0
  t212 = t206 ** 2
  t213 = 0.1e1 / t212
  t214 = t211 * t213
  t215 = t214 * t52
  t217 = -t59 - 0.58836833333333333333333333333333333333333333333333e0 * t61
  t222 = t211 * t207
  t223 = t222 * t70
  t226 = t222 * t51
  t229 = t211 ** 2
  t231 = 0.1e1 / t212 / t206
  t232 = t229 * t231
  t233 = t217 ** 2
  t236 = t229 * t213
  t239 = t90 - 0.39224555555555555555555555555555555555555555555555e0 * t94 + 0.78449111111111111111111111111111111111111111111110e0 * t97
  t241 = t209 / 0.72e2 + t215 * t54 * t56 * t217 / 0.3e1 - t223 * t75 / 0.9e1 + 0.2e1 / 0.9e1 * t226 * t79 + 0.2e1 * t232 * t233 - t236 * t239
  t243 = 0.1e1 / t229 / t211
  t245 = t206 * t51
  t252 = -t226 * t58 / 0.6e1 - t236 * t217
  t253 = t252 * t243
  t262 = t253 * t245
  t265 = t11 + 0.706042e1
  t266 = t265 ** 2
  t267 = 0.1e1 / t266
  t270 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t267
  t271 = 0.1e1 / t270
  t275 = -t35 + 0.74928903184753727944217879854743374601869155501904e-3 * t241 * t243 * t245 * t58 + 0.74928903184753727944217879854743374601869155501904e-3 * t253 * t217 * t51 * t58 + 0.24976301061584575981405959951581124867289718500635e-3 * t253 * t206 * t70 * t75 - t108 - t117 - t121 - 0.49952602123169151962811919903162249734579437001269e-3 * t262 * t79 + t124 + 0.16555529631147769304086026058847109426994589620583e0 * t267 * t24 * t29 * t271 - t128 - t201
  t276 = 0.1e1 / t229
  t277 = t252 * t276
  t281 = t4 * t132 * t207
  t285 = t136 * t37 * t213 * t217
  t314 = t212 ** 2
  t315 = 0.1e1 / t314
  t317 = t233 * t217
  t320 = t217 * t239
  t326 = -t188 - 0.23534733333333333333333333333333333333333333333333e1 * t167 + 0.15689822222222222222222222222222222222222222222222e1 * t191 - 0.18304792592592592592592592592592592592592592592592e1 * t194
  t328 = -0.11e2 / 0.216e3 * t281 - t285 / 0.24e2 - t211 * t231 * t52 * t54 * t56 * t233 + t214 * t91 * t92 * t73 * t217 / 0.3e1 - 0.2e1 / 0.3e1 * t215 * t54 * t37 * t217 + t215 * t54 * t56 * t239 / 0.2e1 + t161 * t162 * t207 / 0.432e3 - 0.2e1 / 0.3e1 * t222 * t167 + 0.4e1 / 0.9e1 * t223 * t173 - 0.14e2 / 0.27e2 * t226 * t176 - 0.6e1 * t229 * t315 * t317 + 0.6e1 * t232 * t320 - t236 * t326
  t332 = t241 * t276
  t336 = t56 * t49
  t340 = t8 * t84
  t344 = t8 * t49
  t350 = 0.1e1 / t3
  t351 = (t44 / 0.9e1 + t136 * t336 * t63 / 0.6e1 + t136 * t340 * t86 / 0.2e1 - t136 * t344 * t99 / 0.4e1) * t15 * t350
  t352 = t20 * t41
  t354 = 0.69090444444444444444444444444444444444444444444446e-2 * t351 * t352
  t363 = (-t4 * t57 * t42 / 0.12e2 - t136 * t344 * t63 / 0.4e1) * t15 * t350
  t366 = t5 / t18 / r0
  t369 = 0.23030148148148148148148148148148148148148148148149e-2 * t363 * t366 * t41
  t370 = t266 ** 2
  t373 = 0.1e1 / t370 / t265 * t1
  t374 = t373 * t3
  t375 = t270 ** 2
  t376 = 0.1e1 / t375
  t383 = t8 * t213
  t389 = (-t4 * t57 * t207 / 0.12e2 - t136 * t383 * t217 / 0.4e1) * t15 * t350
  t390 = t5 * t7
  t396 = 0.69090444444444444444444444444444444444444444444446e-2 * t363 * t20 * t63
  t399 = 0.10363566666666666666666666666666666666666666666667e-1 * t363 * t390 * t99
  t400 = t390 * t63
  t402 = 0.20727133333333333333333333333333333333333333333334e-1 * t351 * t400
  t425 = t390 * t41
  t427 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t134 - t139 / 0.3e1 - t136 * t56 * t84 * t86 / 0.2e1 + t136 * t336 * t99 / 0.4e1 - 0.3e1 / 0.2e1 * t136 * t8 * t180 * t182 + 0.3e1 / 0.2e1 * t136 * t340 * t185 - t136 * t344 * t196 / 0.4e1) * t15 * t350 * t425
  t428 = -t204 + 0.22478670955426118383265363956423012380560746650571e-2 * t277 * t239 + 0.22478670955426118383265363956423012380560746650571e-2 * t328 * t276 * t206 + 0.44957341910852236766530727912846024761121493301142e-2 * t332 * t217 - t354 + t369 + 0.11322067513073894329090826277329563323954137090250e1 * t374 * t132 * t376 + 0.51817833333333333333333333333333333333333333333333e-2 * t389 * t390 * t239 - t396 - t399 - t402 - t427
  t432 = 0.1e1 / t13 / t12 * t1
  t433 = t432 * t3
  t436 = 0.48602578047254941331494803814743396158690158540586e-1 * t433 * t132 * t32
  t442 = 0.1e1 / t266 / t265 * t1
  t443 = t442 * t3
  t448 = t56 * t213
  t452 = t8 * t231
  t461 = (t209 / 0.9e1 + t136 * t448 * t217 / 0.6e1 + t136 * t452 * t233 / 0.2e1 - t136 * t383 * t239 / 0.4e1) * t15 * t350
  t462 = t20 * t206
  t490 = t390 * t206
  t493 = t13 ** 2
  t496 = 0.1e1 / t493 / t12 * t1
  t497 = t496 * t3
  t498 = t31 ** 2
  t499 = 0.1e1 / t498
  t502 = 0.18394613361864149606712411343047178787314745838373e1 * t497 * t132 * t499
  t503 = t390 * t217
  t506 = t229 ** 2
  t512 = t370 ** 2
  t537 = t436 + 0.34545222222222222222222222222222222222222222222222e-2 * t389 * t20 * t217 - 0.50586340539618183984707301846477278804705690507337e-1 * t443 * t132 * t271 + 0.34545222222222222222222222222222222222222222222222e-2 * t461 * t462 - 0.11515074074074074074074074074074074074074074074074e-2 * t389 * t366 * t206 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t281 - t285 / 0.3e1 - t136 * t56 * t231 * t233 / 0.2e1 + t136 * t448 * t239 / 0.4e1 - 0.3e1 / 0.2e1 * t136 * t8 * t315 * t317 + 0.3e1 / 0.2e1 * t136 * t452 * t320 - t136 * t383 * t326 / 0.4e1) * t15 * t350 * t490 - t502 + 0.10363566666666666666666666666666666666666666666667e-1 * t461 * t503 + 0.93661128980942159930272349818429218252336444377380e-4 * t252 / t506 * t206 * t79 + 0.18429583437767336287475605998441200095133403022660e2 / t512 * t15 * t16 * t172 / t375 / t270 * t51 + 0.27592549385246282173476710098078515711657649367638e-1 / t370 * t15 * t16 * t172 * t271 * t51 - 0.14409904107548592782479233443873989685032538114864e1 / t370 / t266 * t15 * t16 * t172 * t376 * t51
  t544 = t267 * t51 * t1
  t550 = t267 * t70 * t15
  t556 = t14 * t70 * t15
  t560 = 0.10604198846673805381417048105034922798259670954310e0 * t556 * t92 * t171 * t32
  t562 = t14 * t51 * t1
  t566 = 0.12371565321119439611653222789207409931302949446695e0 * t562 * t54 * t131 * t32
  t567 = t82 ** 2
  t572 = 0.40375948798101559224001643004400895437705618747712e-4 * t112 / t567 * t41 * t79
  t579 = 0.26510497116684513453542620262587306995649177385774e-1 / t493 * t15 * t16 * t172 * t32 * t51
  t592 = 0.23411326096918008590361250800241863911127858339748e1 / t493 / t13 * t15 * t16 * t172 * t499 * t51
  t597 = 0.22092080930570427877952183552156089163040981154812e-2 * t432 * t159 * t132 * t2 * t32
  t602 = 0.83611878917564316394147324286578085396885208356242e-1 * t496 * t159 * t132 * t2 * t499
  t603 = t493 ** 2
  t612 = 0.50631328524251801700246888250186209051365905137714e2 / t603 * t15 * t16 * t172 / t498 / t31 * t51
  t613 = 0.22993791154371901811230591748398763093048041139699e-2 * t442 * t159 * t132 * t2 * t271 + 0.12876523046448265014289131379103307332106903038231e0 * t544 * t54 * t131 * t271 - 0.11037019754098512869390684039231406284663059747056e0 * t550 * t92 * t171 * t271 + t560 - t566 - t572 - t579 - 0.51463943241244974223140119442407106017973350410227e-1 * t373 * t159 * t132 * t2 * t376 + t592 - t597 + t602 - t612
  t617 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t619 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t617 * f.p.zeta_threshold, 1)
  t621 = 0.2e1 * t619 - 0.2e1
  t623 = 2 ** (0.1e1 / 0.3e1)
  t624 = t623 - 0.1e1
  t626 = 0.1e1 / t624 / 0.2e1
  t628 = t35 + t108 + t117 + t121 - t124 + t128 + t201 + t204 + (t275 + t428 + t537 + t613) * t621 * t626 + t354 - t369 + t396 + t399
  t629 = jnp.pi ** 2
  t630 = 0.1e1 / t629
  t631 = t46 + 0.228344e0
  t633 = t39 + 0.53417500000000000000000000000000000000000000000000e0 * t11 + 0.114813e2
  t634 = 0.1e1 / t633
  t635 = t631 * t634
  t636 = t635 * t51
  t639 = t631 ** 2
  t640 = t633 ** 2
  t641 = 0.1e1 / t640
  t642 = t639 * t641
  t644 = -t59 - 0.89029166666666666666666666666666666666666666666667e-1 * t61
  t646 = -t636 * t58 / 0.6e1 - t642 * t644
  t647 = 0.1e1 / t639
  t648 = t646 * t647
  t651 = t90 - 0.59352777777777777777777777777777777777777777777778e-1 * t94 + 0.11870555555555555555555555555555555555555555555556e0 * t97
  t655 = t4 * t38 * t634
  t657 = t631 * t641
  t658 = t657 * t52
  t663 = t635 * t70
  t669 = 0.1e1 / t640 / t633
  t670 = t639 * t669
  t671 = t644 ** 2
  t675 = t655 / 0.72e2 + t658 * t54 * t56 * t644 / 0.3e1 - t663 * t75 / 0.9e1 + 0.2e1 / 0.9e1 * t636 * t79 + 0.2e1 * t670 * t671 - t642 * t651
  t676 = t675 * t647
  t680 = t4 * t132 * t634
  t684 = t136 * t37 * t641 * t644
  t713 = t640 ** 2
  t714 = 0.1e1 / t713
  t716 = t671 * t644
  t719 = t644 * t651
  t725 = -t188 - 0.35611666666666666666666666666666666666666666666667e0 * t167 + 0.23741111111111111111111111111111111111111111111111e0 * t191 - 0.27697962962962962962962962962962962962962962962964e0 * t194
  t727 = -0.11e2 / 0.216e3 * t680 - t684 / 0.24e2 - t631 * t669 * t52 * t54 * t56 * t671 + t657 * t91 * t92 * t73 * t644 / 0.3e1 - 0.2e1 / 0.3e1 * t658 * t54 * t37 * t644 + t658 * t54 * t56 * t651 / 0.2e1 + t161 * t162 * t634 / 0.432e3 - 0.2e1 / 0.3e1 * t635 * t167 + 0.4e1 / 0.9e1 * t663 * t173 - 0.14e2 / 0.27e2 * t636 * t176 - 0.6e1 * t639 * t714 * t716 + 0.6e1 * t670 * t719 - t642 * t725
  t731 = t11 + 0.106835e1
  t732 = t731 ** 2
  t733 = t732 ** 2
  t736 = 0.1e1 / t733 / t731 * t1
  t737 = t736 * t3
  t738 = 0.1e1 / t732
  t740 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t738
  t741 = t740 ** 2
  t742 = 0.1e1 / t741
  t749 = t8 * t641
  t755 = (-t4 * t57 * t634 / 0.12e2 - t136 * t749 * t644 / 0.4e1) * t15 * t350
  t763 = t56 * t641
  t767 = t8 * t669
  t776 = (t655 / 0.9e1 + t136 * t763 * t644 / 0.6e1 + t136 * t767 * t671 / 0.2e1 - t136 * t749 * t651 / 0.4e1) * t15 * t350
  t777 = t390 * t644
  t802 = t390 * t633
  t806 = 0.1e1 / t740
  t811 = 0.1e1 / t639 / t631
  t813 = t633 * t51
  t817 = t646 * t811
  t826 = 0.21608710360898267021763215722876235716176892439270e-1 * t648 * t651 + 0.43217420721796534043526431445752471432353784878540e-1 * t676 * t644 + 0.21608710360898267021763215722876235716176892439270e-1 * t727 * t647 * t633 + 0.19733478911420229683621075865799807258860149091757e2 * t737 * t132 * t742 + t755 * t390 * t651 / 0.3e1 + 0.2e1 / 0.9e1 * t755 * t20 * t644 + 0.2e1 / 0.3e1 * t776 * t777 + (-0.7e1 / 0.27e2 * t680 - t684 / 0.3e1 - t136 * t56 * t669 * t671 / 0.2e1 + t136 * t763 * t651 / 0.4e1 - 0.3e1 / 0.2e1 * t136 * t8 * t714 * t716 + 0.3e1 / 0.2e1 * t136 * t767 * t719 - t136 * t749 * t725 / 0.4e1) * t15 * t350 * t802 / 0.3e1 + 0.14420896359956903410707543094073145654541709205109e1 * t738 * t24 * t29 * t806 + 0.72029034536327556739210719076254119053922974797566e-2 * t675 * t811 * t813 * t58 + 0.72029034536327556739210719076254119053922974797566e-2 * t817 * t644 * t51 * t58 + 0.24009678178775852246403573025418039684640991599189e-2 * t817 * t633 * t70 * t75
  t828 = t738 * t51 * t1
  t834 = t738 * t70 * t15
  t839 = t639 ** 2
  t847 = 0.1e1 / t732 / t731 * t1
  t848 = t847 * t3
  t877 = t733 ** 2
  t887 = t20 * t633
  t893 = t817 * t813
  t896 = 0.11216252724410924874994755739834668842421329381751e1 * t828 * t54 * t131 * t806 - 0.96139309066379356071383620627154304363611394700724e0 * t834 * t92 * t171 * t806 + 0.90036293170409445924013398845317648817403718496958e-3 * t646 / t839 * t633 * t79 - 0.44063849988757204866050826120779056166655222571167e0 * t848 * t132 * t806 + 0.24034827266594839017845905156788576090902848675182e0 / t733 * t15 * t16 * t172 * t806 * t51 - 0.25115336796353019597335914738290663784003826116781e2 / t733 / t732 * t15 * t16 * t172 * t742 * t51 + 0.20029022722162365848204920963990480075752373895984e-1 * t847 * t159 * t132 * t2 * t806 - 0.89697631415546498561913981208180942085727950417076e0 * t736 * t159 * t132 * t2 * t742 + 0.64272053155397178166610502978456596616246611440970e3 / t877 * t15 * t16 * t172 / t741 / t740 * t51 + 0.2e1 / 0.9e1 * t776 * t887 - 0.2e1 / 0.27e2 * t755 * t366 * t633 - 0.48019356357551704492807146050836079369281983198377e-2 * t893 * t79
  t901 = 0.9e1 * t621 * t626 * t624
  t904 = t11 + 0.130720e2
  t905 = t904 ** 2
  t906 = 0.1e1 / t905
  t909 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t906
  t910 = 0.1e1 / t909
  t914 = t11 + 0.201231e2
  t915 = t914 ** 2
  t916 = 0.1e1 / t915
  t919 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t916
  t920 = 0.1e1 / t919
  t925 = t39 + 0.65360000000000000000000000000000000000000000000000e1 * t11 + 0.427198e2
  t926 = 0.1e1 / t925
  t928 = t4 * t38 * t926
  t930 = t46 + 0.409286e0
  t931 = t925 ** 2
  t932 = 0.1e1 / t931
  t933 = t930 * t932
  t934 = t933 * t52
  t936 = -t59 - 0.10893333333333333333333333333333333333333333333333e1 * t61
  t941 = t930 * t926
  t942 = t941 * t70
  t945 = t941 * t51
  t948 = t930 ** 2
  t950 = 0.1e1 / t931 / t925
  t951 = t948 * t950
  t952 = t936 ** 2
  t955 = t948 * t932
  t958 = t90 - 0.72622222222222222222222222222222222222222222222220e0 * t94 + 0.14524444444444444444444444444444444444444444444444e1 * t97
  t960 = t928 / 0.72e2 + t934 * t54 * t56 * t936 / 0.3e1 - t942 * t75 / 0.9e1 + 0.2e1 / 0.9e1 * t945 * t79 + 0.2e1 * t951 * t952 - t955 * t958
  t962 = 0.1e1 / t948 / t930
  t964 = t925 * t51
  t971 = -t945 * t58 / 0.6e1 - t955 * t936
  t972 = t971 * t962
  t981 = t46 + 0.743294e0
  t983 = t39 + 0.10061550000000000000000000000000000000000000000000e2 * t11 + 0.101578e3
  t984 = 0.1e1 / t983
  t985 = t981 * t984
  t986 = t985 * t51
  t989 = t981 ** 2
  t990 = t983 ** 2
  t991 = 0.1e1 / t990
  t992 = t989 * t991
  t994 = -t59 - 0.16769250000000000000000000000000000000000000000000e1 * t61
  t996 = -t986 * t58 / 0.6e1 - t992 * t994
  t998 = 0.1e1 / t989 / t981
  t999 = t996 * t998
  t1009 = t4 * t38 * t984
  t1011 = t981 * t991
  t1012 = t1011 * t52
  t1017 = t985 * t70
  t1023 = 0.1e1 / t990 / t983
  t1024 = t989 * t1023
  t1025 = t994 ** 2
  t1030 = t90 - 0.11179500000000000000000000000000000000000000000000e1 * t94 + 0.22359000000000000000000000000000000000000000000000e1 * t97
  t1032 = t1009 / 0.72e2 + t1012 * t54 * t56 * t994 / 0.3e1 - t1017 * t75 / 0.9e1 + 0.2e1 / 0.9e1 * t986 * t79 + 0.2e1 * t1024 * t1025 - t992 * t1030
  t1034 = t983 * t51
  t1038 = t972 * t964
  t1041 = t999 * t1034
  t1045 = t916 * t51 * t1
  t1050 = t948 ** 2
  t1056 = -0.61428953307227691896295992558865975087351157250442e0 * t906 * t24 * t29 * t910 + 0.48337331672435896699555362735747849302493515162012e0 * t916 * t24 * t29 * t920 - 0.14771245892498460899328183697246412229876591643939e-2 * t960 * t962 * t964 * t58 - 0.14771245892498460899328183697246412229876591643939e-2 * t972 * t936 * t51 * t58 - 0.49237486308328202997760612324154707432921972146465e-3 * t972 * t925 * t70 * t75 + 0.88910333575777171977719901875252317902801704015380e-3 * t999 * t994 * t51 * t58 + 0.29636777858592390659239967291750772634267234671793e-3 * t999 * t983 * t70 * t75 + 0.88910333575777171977719901875252317902801704015380e-3 * t1032 * t998 * t1034 * t58 + 0.98474972616656405995521224648309414865843944292929e-3 * t1038 * t79 - 0.59273555717184781318479934583501545268534469343587e-3 * t1041 * t79 + 0.37595702411894586321876393238914993901939400681566e0 * t1045 * t54 * t131 * t920 - 0.18464057365623076124160229621558015287345739554924e-3 * t971 / t1050 * t925 * t79
  t1057 = t905 ** 2
  t1058 = t1057 ** 2
  t1062 = t909 ** 2
  t1080 = 0.1e1 / t1062
  t1087 = 0.1e1 / t905 / t904 * t1
  t1095 = 0.1e1 / t1057 / t904 * t1
  t1101 = t915 ** 2
  t1102 = t1101 ** 2
  t1106 = t919 ** 2
  t1113 = t989 ** 2
  t1130 = 0.1e1 / t1106
  t1137 = 0.1e1 / t915 / t914 * t1
  t1145 = 0.1e1 / t1101 / t914 * t1
  t1152 = t906 * t70 * t15
  t1157 = -0.55480664900582220034593859007405864987692769991566e-6 / t1058 * t15 * t16 * t172 / t1062 / t909 * t51 - 0.10238158884537948649382665426477662514558526208407e0 / t1057 * t15 * t16 * t172 * t910 * t51 + 0.48160299392866510446696058166150924468483307284345e-3 / t1057 / t905 * t15 * t16 * t172 * t1080 * t51 - 0.85317990704482905411522211887313854287987718403392e-2 * t1087 * t159 * t132 * t2 * t910 + 0.17200106926023753730962877916482473024458324030124e-4 * t1095 * t159 * t132 * t2 * t1080 + 0.20244826120247034261608782614550005883535036385819e0 / t1102 * t15 * t16 * t172 / t1106 / t919 * t51 + 0.11113791696972146497214987734406539737850213001922e-3 * t996 / t1113 * t983 * t79 + 0.80562219454059827832592271226246415504155858603354e-1 / t1101 * t15 * t16 * t172 * t920 * t51 - 0.25806562167841887946265692242132428447574760112225e0 / t1101 / t915 * t15 * t16 * t172 * t1130 * t51 + 0.67135182878383189860493559355205346253463215502794e-2 * t1137 * t159 * t132 * t2 * t920 - 0.92166293456578171236663186579044387312767000400800e-2 * t1145 * t159 * t132 * t2 * t1130 + 0.40952635538151794597530661705910650058234104833627e0 * t1152 * t92 * t171 * t910
  t1160 = t906 * t51 * t1
  t1166 = t916 * t70 * t15
  t1174 = t8 * t991
  t1180 = (-t4 * t57 * t984 / 0.12e2 - t136 * t1174 * t994 / 0.4e1) * t15 * t350
  t1184 = t1087 * t3
  t1189 = t4 * t132 * t984
  t1193 = t136 * t37 * t991 * t994
  t1199 = t56 * t991
  t1203 = t990 ** 2
  t1204 = 0.1e1 / t1203
  t1206 = t1025 * t994
  t1210 = t8 * t1023
  t1211 = t994 * t1030
  t1218 = -t188 - 0.67077000000000000000000000000000000000000000000000e1 * t167 + 0.44718000000000000000000000000000000000000000000000e1 * t191 - 0.52171000000000000000000000000000000000000000000000e1 * t194
  t1225 = t390 * t983
  t1229 = t56 * t932
  t1233 = t8 * t950
  t1237 = t8 * t932
  t1243 = (t928 / 0.9e1 + t136 * t1229 * t936 / 0.6e1 + t136 * t1233 * t952 / 0.2e1 - t136 * t1237 * t958 / 0.4e1) * t15 * t350
  t1244 = t20 * t925
  t1247 = t390 * t936
  t1251 = t4 * t132 * t926
  t1255 = t136 * t37 * t932 * t936
  t1264 = t931 ** 2
  t1265 = 0.1e1 / t1264
  t1267 = t952 * t936
  t1271 = t936 * t958
  t1278 = -t188 - 0.43573333333333333333333333333333333333333333333332e1 * t167 + 0.29048888888888888888888888888888888888888888888888e1 * t191 - 0.33890370370370370370370370370370370370370370370369e1 * t194
  t1285 = t390 * t925
  t1288 = t1145 * t3
  t1307 = (t1009 / 0.9e1 + t136 * t1199 * t994 / 0.6e1 + t136 * t1210 * t1025 / 0.2e1 - t136 * t1174 * t1030 / 0.4e1) * t15 * t350
  t1308 = t390 * t994
  t1319 = (-t4 * t57 * t926 / 0.12e2 - t136 * t1237 * t936 / 0.4e1) * t15 * t350
  t1323 = -0.47778074794510427030452438656895758401273122305897e0 * t1160 * t54 * t131 * t910 - 0.32224887781623931133036908490498566201662343441341e0 * t1166 * t92 * t171 * t920 + 0.34545222222222222222222222222222222222222222222222e-2 * t1180 * t20 * t994 + 0.18769957954986239190534886615209047943357298048745e0 * t1184 * t132 * t910 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1189 - t1193 / 0.3e1 - t136 * t56 * t1023 * t1025 / 0.2e1 + t136 * t1199 * t1030 / 0.4e1 - 0.3e1 / 0.2e1 * t136 * t8 * t1204 * t1206 + 0.3e1 / 0.2e1 * t136 * t1210 * t1211 - t136 * t1174 * t1218 / 0.4e1) * t15 * t350 * t1225 - 0.69090444444444444444444444444444444444444444444446e-2 * t1243 * t1244 - 0.20727133333333333333333333333333333333333333333334e-1 * t1243 * t1247 - 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t1251 - t1255 / 0.3e1 - t136 * t56 * t950 * t952 / 0.2e1 + t136 * t1229 * t958 / 0.4e1 - 0.3e1 / 0.2e1 * t136 * t8 * t1265 * t1267 + 0.3e1 / 0.2e1 * t136 * t1233 * t1271 - t136 * t1237 * t1278 / 0.4e1) * t15 * t350 * t1285 + 0.20276584560447197672065901047389765208808740088178e0 * t1288 * t132 * t1130 + 0.51817833333333333333333333333333333333333333333333e-2 * t1180 * t390 * t1030 + 0.10363566666666666666666666666666666666666666666667e-1 * t1307 * t1308 + 0.23030148148148148148148148148148148148148148148149e-2 * t1319 * t366 * t925
  t1324 = t1137 * t3
  t1328 = t20 * t983
  t1337 = t1095 * t3
  t1379 = -0.11e2 / 0.216e3 * t1189 - t1193 / 0.24e2 - t981 * t1023 * t52 * t54 * t56 * t1025 + t1011 * t91 * t92 * t73 * t994 / 0.3e1 - 0.2e1 / 0.3e1 * t1012 * t54 * t37 * t994 + t1012 * t54 * t56 * t1030 / 0.2e1 + t161 * t162 * t984 / 0.432e3 - 0.2e1 / 0.3e1 * t985 * t167 + 0.4e1 / 0.9e1 * t1017 * t173 - 0.14e2 / 0.27e2 * t986 * t176 - 0.6e1 * t989 * t1204 * t1206 + 0.6e1 * t1024 * t1211 - t992 * t1218
  t1380 = 0.1e1 / t989
  t1384 = 0.1e1 / t948
  t1385 = t971 * t1384
  t1423 = -0.11e2 / 0.216e3 * t1251 - t1255 / 0.24e2 - t930 * t950 * t52 * t54 * t56 * t952 + t933 * t91 * t92 * t73 * t936 / 0.3e1 - 0.2e1 / 0.3e1 * t934 * t54 * t37 * t936 + t934 * t54 * t56 * t958 / 0.2e1 + t161 * t162 * t926 / 0.432e3 - 0.2e1 / 0.3e1 * t941 * t167 + 0.4e1 / 0.9e1 * t942 * t173 - 0.14e2 / 0.27e2 * t945 * t176 - 0.6e1 * t948 * t1265 * t1267 + 0.6e1 * t951 * t1271 - t955 * t1278
  t1427 = t960 * t1384
  t1430 = t1032 * t1380
  t1433 = t996 * t1380
  t1436 = -0.14769740233244301769308583058145176175761907410615e0 * t1324 * t132 * t920 + 0.34545222222222222222222222222222222222222222222222e-2 * t1307 * t1328 - 0.11515074074074074074074074074074074074074074074074e-2 * t1180 * t366 * t983 - 0.10363566666666666666666666666666666666666666666667e-1 * t1319 * t390 * t958 - 0.37840235237252258208118331416261440653808312866271e-3 * t1337 * t132 * t1080 - 0.69090444444444444444444444444444444444444444444446e-2 * t1319 * t20 * t936 + 0.26673100072733151593315970562575695370840511204614e-2 * t1379 * t1380 * t983 - 0.44313737677495382697984551091739236689629774931818e-2 * t1385 * t958 - 0.44313737677495382697984551091739236689629774931818e-2 * t1423 * t1384 * t925 - 0.88627475354990765395969102183478473379259549863636e-2 * t1427 * t936 + 0.53346200145466303186631941125151390741681022409228e-2 * t1430 * t994 + 0.26673100072733151593315970562575695370840511204614e-2 * t1433 * t1030
  t1441 = t402 + t427 - t436 + t502 - t560 + t566 + t572 + t579 - t592 + t597 - t602 + t612 - t630 * (t826 + t896) * t901 / 0.24e2 - (t1056 + t1157 + t1323 + t1436) * t621 * t626
  t1474 = t363 * t400
  t1477 = t433 * t38 * t32
  t1480 = t497 * t38 * t499
  t1482 = t351 * t425
  t1484 = t363 * t352
  t1488 = t556 * t92 * t73 * t32
  t1492 = t562 * t54 * t37 * t32
  t1494 = t122 * t58
  t1496 = t202 * t41
  t1498 = t126 * t63
  t1552 = 0.51817833333333333333333333333333333333333333333333e-2 * t1307 * t1225 + 0.17272611111111111111111111111111111111111111111111e-2 * t1180 * t1328 + 0.51817833333333333333333333333333333333333333333333e-2 * t1180 * t1308 + 0.40281109727029913916296135613123207752077929301677e-1 * t1324 * t38 * t920 + 0.80562219454059827832592271226246415504155858603353e-1 * t1166 * t92 * t73 * t920 - 0.16112443890811965566518454245249283100831171720671e0 * t1045 * t54 * t37 * t920 - 0.55299776073946902741997911947426632387660200240483e-1 * t1288 * t38 * t1130 + 0.26673100072733151593315970562575695370840511204614e-2 * t1430 * t983 + 0.44455166787888585988859950937626158951400852007690e-3 * t1041 * t58 + 0.26673100072733151593315970562575695370840511204614e-2 * t1433 * t994 - 0.10363566666666666666666666666666666666666666666667e-1 * t1243 * t1285 - 0.34545222222222222222222222222222222222222222222223e-2 * t1319 * t1244 - 0.10363566666666666666666666666666666666666666666667e-1 * t1319 * t1247 - 0.51190794422689743246913327132388312572792631042033e-1 * t1184 * t38 * t910 - 0.10238158884537948649382665426477662514558526208407e0 * t1152 * t92 * t73 * t910 + 0.20476317769075897298765330852955325029117052416813e0 * t1160 * t54 * t37 * t910 + 0.10320064155614252238577726749889483814674994418074e-3 * t1337 * t38 * t1080 - 0.44313737677495382697984551091739236689629774931818e-2 * t1427 * t925 - 0.73856229462492304496640918486232061149382958219697e-3 * t1038 * t58 - 0.44313737677495382697984551091739236689629774931818e-2 * t1385 * t936
  t1592 = 0.51817833333333333333333333333333333333333333333333e-2 * t461 * t490 + 0.17272611111111111111111111111111111111111111111111e-2 * t389 * t462 + 0.51817833333333333333333333333333333333333333333333e-2 * t389 * t503 + 0.13796274692623141086738355049039257855828824683819e-1 * t443 * t38 * t271 + 0.27592549385246282173476710098078515711657649367639e-1 * t550 * t92 * t73 * t271 - 0.55185098770492564346953420196157031423315298735277e-1 * t544 * t54 * t37 * t271 - 0.30878365944746984533884071665444263610784010246137e0 * t374 * t38 * t376 + 0.22478670955426118383265363956423012380560746650571e-2 * t332 * t206 + 0.37464451592376863972108939927371687300934577750952e-3 * t262 * t58 + 0.22478670955426118383265363956423012380560746650571e-2 * t277 * t217 - 0.10363566666666666666666666666666666666666666666667e-1 * t1482 - 0.34545222222222222222222222222222222222222222222223e-2 * t1484 - 0.10363566666666666666666666666666666666666666666667e-1 * t1474 - 0.13255248558342256726771310131293653497824588692887e-1 * t1477 - 0.26510497116684513453542620262587306995649177385775e-1 * t1488 + 0.53020994233369026907085240525174613991298354771549e-1 * t1492 + 0.50167127350538589836488394571946851238131125013746e0 * t1480 - 0.96902277115443742137603943210562149050493484994510e-3 * t1496 - 0.16150379519240623689600657201760358175082247499085e-3 * t1494 - 0.96902277115443742137603943210562149050493484994510e-3 * t1498
  v3rho3_0_ = r0 * (t628 + t1441) - t630 * (t776 * t802 / 0.3e1 + t755 * t887 / 0.9e1 + t755 * t777 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t848 * t38 * t806 + 0.24034827266594839017845905156788576090902848675181e0 * t834 * t92 * t73 * t806 - 0.48069654533189678035691810313577152181805697350363e0 * t828 * t54 * t37 * t806 - 0.53818578849327899137148388724908565251436770250246e1 * t737 * t38 * t742 + 0.21608710360898267021763215722876235716176892439270e-1 * t676 * t633 + 0.36014517268163778369605359538127059526961487398783e-2 * t893 * t58 + 0.21608710360898267021763215722876235716176892439270e-1 * t648 * t644) * t901 / 0.8e1 + 0.31090700000000000000000000000000000000000000000001e-1 * t1474 + 0.39765745675026770180313930393880960493473766078662e-1 * t1477 - 0.15050138205161576950946518371584055371439337504124e1 * t1480 + 0.31090700000000000000000000000000000000000000000001e-1 * t1482 + 0.10363566666666666666666666666666666666666666666667e-1 * t1484 + 0.79531491350053540360627860787761920986947532157324e-1 * t1488 - 0.15906298270010708072125572157552384197389506431465e0 * t1492 + 0.48451138557721871068801971605281074525246742497255e-3 * t1494 + 0.29070683134633122641281182963168644715148045498353e-2 * t1496 + 0.29070683134633122641281182963168644715148045498353e-2 * t1498 - 0.3e1 * t1552 * t621 * t626 + 0.3e1 * t1592 * t621 * t626

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.pi ** 2
  t2 = 0.1e1 / t1
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / jnp.pi
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t3 * t5
  t7 = 4 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t9
  t12 = t6 * t8 * t10
  t13 = jnp.sqrt(t12)
  t14 = t13 / 0.2e1
  t15 = t14 + 0.228344e0
  t16 = t12 / 0.4e1
  t18 = t16 + 0.53417500000000000000000000000000000000000000000000e0 * t13 + 0.114813e2
  t19 = 0.1e1 / t18
  t20 = t15 * t19
  t21 = 0.1e1 / t13
  t22 = t20 * t21
  t24 = 0.1e1 / t9 / r0
  t25 = t8 * t24
  t26 = t6 * t25
  t29 = t15 ** 2
  t30 = t18 ** 2
  t31 = 0.1e1 / t30
  t32 = t29 * t31
  t33 = t26 / 0.12e2
  t34 = t21 * t3
  t35 = t5 * t8
  t37 = t34 * t35 * t24
  t39 = -t33 - 0.89029166666666666666666666666666666666666666666667e-1 * t37
  t41 = -t22 * t26 / 0.6e1 - t32 * t39
  t42 = 0.1e1 / t29
  t43 = t41 * t42
  t44 = r0 ** 2
  t46 = 0.1e1 / t9 / t44
  t47 = t8 * t46
  t48 = t6 * t47
  t49 = t48 / 0.9e1
  t51 = 0.1e1 / t13 / t12
  t52 = t3 ** 2
  t53 = t51 * t52
  t54 = t5 ** 2
  t55 = t54 * t7
  t56 = t9 ** 2
  t58 = 0.1e1 / t56 / t44
  t60 = t53 * t55 * t58
  t63 = t34 * t35 * t46
  t65 = t49 - 0.59352777777777777777777777777777777777777777777778e-1 * t60 + 0.11870555555555555555555555555555555555555555555556e0 * t63
  t68 = t44 * r0
  t70 = 0.1e1 / t9 / t68
  t71 = t8 * t70
  t73 = t6 * t71 * t19
  t75 = t6 * t8
  t76 = t46 * t31
  t78 = t75 * t76 * t39
  t81 = 0.1e1 / t30 / t18
  t82 = t15 * t81
  t83 = t82 * t34
  t84 = t39 ** 2
  t88 = t15 * t31
  t89 = t88 * t53
  t94 = t88 * t34
  t103 = 0.1e1 / t54
  t105 = t3 * t103 * t8
  t106 = t70 * t4
  t110 = t52 * t54
  t112 = t7 / t56
  t116 = 0.1e1 / t13 / t110 / t112 / 0.4e1
  t117 = t116 * t4
  t118 = t44 ** 2
  t119 = 0.1e1 / t118
  t120 = t117 * t119
  t123 = t20 * t51
  t125 = 0.1e1 / t56 / t68
  t126 = t7 * t125
  t127 = t110 * t126
  t130 = t6 * t71
  t133 = t30 ** 2
  t134 = 0.1e1 / t133
  t135 = t29 * t134
  t136 = t84 * t39
  t139 = t29 * t81
  t140 = t39 * t65
  t143 = 0.7e1 / 0.27e2 * t130
  t146 = t53 * t55 * t125
  t149 = t34 * t35 * t70
  t151 = -t143 - 0.35611666666666666666666666666666666666666666666667e0 * t120 + 0.23741111111111111111111111111111111111111111111111e0 * t146 - 0.27697962962962962962962962962962962962962962962964e0 * t149
  t153 = -0.11e2 / 0.216e3 * t73 - t78 / 0.24e2 - t83 * t35 * t24 * t84 + t89 * t55 * t58 * t39 / 0.3e1 - 0.2e1 / 0.3e1 * t94 * t35 * t46 * t39 + t94 * t35 * t24 * t65 / 0.2e1 + t105 * t106 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t20 * t120 + 0.4e1 / 0.9e1 * t123 * t127 - 0.14e2 / 0.27e2 * t22 * t130 - 0.6e1 * t135 * t136 + 0.6e1 * t139 * t140 - t32 * t151
  t154 = t153 * t42
  t158 = t6 * t47 * t19
  t160 = t24 * t39
  t164 = t7 * t58
  t165 = t110 * t164
  t173 = t158 / 0.72e2 + t94 * t35 * t160 / 0.3e1 - t123 * t165 / 0.9e1 + 0.2e1 / 0.9e1 * t22 * t48 + 0.2e1 * t139 * t84 - t32 * t65
  t174 = t173 * t42
  t177 = t13 + 0.106835e1
  t178 = t177 ** 2
  t179 = t178 ** 2
  t181 = 0.1e1 / t179 / t177
  t182 = t181 * t3
  t183 = t182 * t5
  t184 = 0.1e1 / t178
  t186 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t184
  t187 = t186 ** 2
  t188 = 0.1e1 / t187
  t195 = t10 * t31
  t201 = 0.1e1 / t5
  t202 = (-t6 * t25 * t19 / 0.12e2 - t75 * t195 * t39 / 0.4e1) * t52 * t201
  t203 = t7 * t9
  t204 = t203 * t65
  t207 = t112 * t39
  t211 = t24 * t31
  t215 = t10 * t81
  t224 = (t158 / 0.9e1 + t75 * t211 * t39 / 0.6e1 + t75 * t215 * t84 / 0.2e1 - t75 * t195 * t65 / 0.4e1) * t52 * t201
  t225 = t203 * t39
  t230 = t24 * t81
  t237 = t10 * t134
  t249 = (-0.7e1 / 0.27e2 * t73 - t78 / 0.3e1 - t75 * t230 * t84 / 0.2e1 + t75 * t211 * t65 / 0.4e1 - 0.3e1 / 0.2e1 * t75 * t237 * t136 + 0.3e1 / 0.2e1 * t75 * t215 * t140 - t75 * t195 * t151 / 0.4e1) * t52 * t201
  t250 = t203 * t18
  t253 = t184 * t116
  t254 = t4 * t119
  t255 = 0.1e1 / t186
  t260 = 0.1e1 / t29 / t15
  t261 = t41 * t260
  t262 = t39 * t21
  t263 = t261 * t262
  t266 = t18 * t51
  t267 = t261 * t266
  t271 = t184 * t21 * t3
  t276 = 0.21608710360898267021763215722876235716176892439270e-1 * t43 * t65 + 0.21608710360898267021763215722876235716176892439270e-1 * t154 * t18 + 0.43217420721796534043526431445752471432353784878540e-1 * t174 * t39 + 0.19733478911420229683621075865799807258860149091757e2 * t183 * t71 * t188 + t202 * t204 / 0.3e1 + 0.2e1 / 0.9e1 * t202 * t207 + 0.2e1 / 0.3e1 * t224 * t225 + t249 * t250 / 0.3e1 + 0.14420896359956903410707543094073145654541709205109e1 * t253 * t254 * t255 + 0.72029034536327556739210719076254119053922974797566e-2 * t263 * t26 + 0.24009678178775852246403573025418039684640991599189e-2 * t267 * t165 + 0.11216252724410924874994755739834668842421329381751e1 * t271 * t35 * t70 * t255
  t277 = t173 * t260
  t278 = t18 * t21
  t279 = t277 * t278
  t283 = t184 * t51 * t52
  t288 = t29 ** 2
  t289 = 0.1e1 / t288
  t290 = t41 * t289
  t291 = t290 * t18
  t294 = t178 * t177
  t295 = 0.1e1 / t294
  t296 = t295 * t3
  t301 = 0.1e1 / t179
  t302 = t301 * t52
  t303 = t302 * t54
  t304 = t255 * t21
  t309 = 0.1e1 / t179 / t178
  t310 = t309 * t52
  t311 = t310 * t54
  t312 = t188 * t21
  t316 = t296 * t103
  t317 = t4 * t255
  t321 = t182 * t103
  t322 = t4 * t188
  t326 = t179 ** 2
  t327 = 0.1e1 / t326
  t328 = t327 * t52
  t329 = t328 * t54
  t331 = 0.1e1 / t187 / t186
  t332 = t331 * t21
  t336 = t112 * t18
  t341 = t7 / t56 / r0
  t342 = t341 * t18
  t345 = t261 * t278
  t348 = 0.72029034536327556739210719076254119053922974797566e-2 * t279 * t26 - 0.96139309066379356071383620627154304363611394700724e0 * t283 * t55 * t125 * t255 + 0.90036293170409445924013398845317648817403718496958e-3 * t291 * t48 - 0.44063849988757204866050826120779056166655222571167e0 * t296 * t5 * t71 * t255 + 0.24034827266594839017845905156788576090902848675182e0 * t303 * t126 * t304 - 0.25115336796353019597335914738290663784003826116781e2 * t311 * t126 * t312 + 0.20029022722162365848204920963990480075752373895984e-1 * t316 * t71 * t317 - 0.89697631415546498561913981208180942085727950417076e0 * t321 * t71 * t322 + 0.64272053155397178166610502978456596616246611440970e3 * t329 * t126 * t332 + 0.2e1 / 0.9e1 * t224 * t336 - 0.2e1 / 0.27e2 * t202 * t342 - 0.48019356357551704492807146050836079369281983198377e-2 * t345 * t48
  t352 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t354 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t352 * f.p.zeta_threshold, 1)
  t356 = 0.2e1 * t354 - 0.2e1
  t357 = 2 ** (0.1e1 / 0.3e1)
  t358 = t357 - 0.1e1
  t360 = 0.1e1 / t358 / 0.2e1
  t363 = 0.9e1 * t356 * t360 * t358
  t366 = t13 + 0.372744e1
  t367 = t366 ** 2
  t368 = 0.1e1 / t367
  t369 = t368 * t116
  t371 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t368
  t372 = 0.1e1 / t371
  t374 = t369 * t254 * t372
  t376 = t14 + 0.10498e0
  t378 = t16 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t379 = 0.1e1 / t378
  t380 = t376 * t379
  t381 = t380 * t21
  t384 = t376 ** 2
  t385 = t378 ** 2
  t386 = 0.1e1 / t385
  t387 = t384 * t386
  t389 = -t33 - 0.31062000000000000000000000000000000000000000000000e0 * t37
  t391 = -t381 * t26 / 0.6e1 - t387 * t389
  t393 = 0.1e1 / t384 / t376
  t394 = t391 * t393
  t395 = t389 * t21
  t396 = t394 * t395
  t397 = t396 * t26
  t399 = t378 * t51
  t400 = t394 * t399
  t401 = t400 * t165
  t403 = t378 * t21
  t404 = t394 * t403
  t405 = t404 * t48
  t408 = t6 * t47 * t379
  t410 = t376 * t386
  t411 = t410 * t34
  t412 = t24 * t389
  t416 = t380 * t51
  t422 = 0.1e1 / t385 / t378
  t423 = t384 * t422
  t424 = t389 ** 2
  t429 = t49 - 0.20708000000000000000000000000000000000000000000000e0 * t60 + 0.41416000000000000000000000000000000000000000000000e0 * t63
  t431 = t408 / 0.72e2 + t411 * t35 * t412 / 0.3e1 - t416 * t165 / 0.9e1 + 0.2e1 / 0.9e1 * t381 * t48 + 0.2e1 * t423 * t424 - t387 * t429
  t432 = t431 * t393
  t433 = t432 * t403
  t434 = t433 * t26
  t439 = t10 * t386
  t445 = (-t6 * t25 * t379 / 0.12e2 - t75 * t439 * t389 / 0.4e1) * t52 * t201
  t446 = t203 * t429
  t447 = t445 * t446
  t450 = t24 * t386
  t454 = t10 * t422
  t463 = (t408 / 0.9e1 + t75 * t450 * t389 / 0.6e1 + t75 * t454 * t424 / 0.2e1 - t75 * t439 * t429 / 0.4e1) * t52 * t201
  t464 = t203 * t389
  t465 = t463 * t464
  t468 = t6 * t71 * t379
  t470 = t46 * t386
  t472 = t75 * t470 * t389
  t474 = t24 * t422
  t481 = t385 ** 2
  t482 = 0.1e1 / t481
  t483 = t10 * t482
  t484 = t424 * t389
  t488 = t389 * t429
  t495 = -t143 - 0.12424800000000000000000000000000000000000000000000e1 * t120 + 0.82832000000000000000000000000000000000000000000000e0 * t146 - 0.96637333333333333333333333333333333333333333333333e0 * t149
  t501 = (-0.7e1 / 0.27e2 * t468 - t472 / 0.3e1 - t75 * t474 * t424 / 0.2e1 + t75 * t450 * t429 / 0.4e1 - 0.3e1 / 0.2e1 * t75 * t483 * t484 + 0.3e1 / 0.2e1 * t75 * t454 * t488 - t75 * t439 * t495 / 0.4e1) * t52 * t201
  t502 = t203 * t378
  t503 = t501 * t502
  t505 = t367 * t366
  t507 = 0.1e1 / t505 * t3
  t508 = t507 * t5
  t510 = t508 * t71 * t372
  t512 = t112 * t389
  t514 = 0.20727133333333333333333333333333333333333333333334e-1 * t463 * t512
  t515 = t112 * t378
  t517 = 0.10363566666666666666666666666666666666666666666667e-1 * t501 * t515
  t519 = 0.1e1 / t9 / t118
  t520 = t8 * t519
  t523 = 0.20435174860777645787105769785744382475812907568201e0 * t508 * t520 * t372
  t526 = 0.10363566666666666666666666666666666666666666666667e-1 * t445 * t203 * t495
  t528 = 0.31090700000000000000000000000000000000000000000001e-1 * t463 * t446
  t531 = 0.38383580246913580246913580246913580246913580246915e-2 * t445 * t164 * t378
  t532 = t367 ** 2
  t534 = 0.1e1 / t532 / t366
  t535 = t534 * t3
  t536 = t535 * t5
  t537 = t371 ** 2
  t538 = 0.1e1 / t537
  t541 = 0.77340987998746992664586274965084728992118817729523e1 * t536 * t520 * t538
  t542 = t341 * t378
  t544 = 0.69090444444444444444444444444444444444444444444446e-2 * t463 * t542
  t547 = 0.10363566666666666666666666666666666666666666666667e-1 * t445 * t112 * t429
  t549 = t6 * t520 * t379
  t553 = t75 * t70 * t386 * t389
  t557 = t75 * t46 * t422 * t424
  t560 = t75 * t470 * t429
  t573 = 0.1e1 / t481 / t378
  t575 = t424 ** 2
  t579 = t424 * t429
  t583 = t429 ** 2
  t587 = t389 * t495
  t591 = t6 * t520
  t592 = 0.70e2 / 0.81e2 * t591
  t597 = 0.1e1 / t13 / t4 * r0 / 0.48e2
  t598 = t597 * t4
  t599 = t118 * r0
  t601 = 0.1e1 / t9 / t599
  t603 = t598 * t601 * t75
  t605 = 0.1e1 / t599
  t606 = t117 * t605
  t609 = 0.1e1 / t56 / t118
  t611 = t53 * t55 * t609
  t614 = t34 * t35 * t519
  t616 = t592 - 0.10354000000000000000000000000000000000000000000000e1 * t603 + 0.99398400000000000000000000000000000000000000000000e1 * t606 - 0.36814222222222222222222222222222222222222222222222e1 * t611 + 0.32212444444444444444444444444444444444444444444444e1 * t614
  t620 = 0.70e2 / 0.81e2 * t549 + 0.28e2 / 0.27e2 * t553 + 0.4e1 / 0.3e1 * t557 - 0.2e1 / 0.3e1 * t560 + 0.2e1 * t75 * t24 * t482 * t484 - 0.2e1 * t75 * t474 * t488 + t75 * t450 * t495 / 0.3e1 + 0.6e1 * t75 * t10 * t573 * t575 - 0.9e1 * t75 * t483 * t579 + 0.3e1 / 0.2e1 * t75 * t454 * t583 + 0.2e1 * t75 * t454 * t587 - t75 * t439 * t616 / 0.4e1
  t624 = 0.10363566666666666666666666666666666666666666666667e-1 * t620 * t52 * t201 * t502
  t626 = 0.31090700000000000000000000000000000000000000000001e-1 * t501 * t464
  t629 = 0.64601518076962494758402628807041432700328989996342e-3 * t394 * t378 * t120
  t632 = 0.69090444444444444444444444444444444444444444444446e-2 * t445 * t341 * t389
  t633 = t514 + t517 + t523 + t526 + t528 + t531 - t541 - t544 + t547 + t624 + t626 + t629 - t632
  t634 = t532 ** 2
  t635 = 0.1e1 / t634
  t638 = 0.1e1 / t537 / t371
  t642 = 0.10126265704850360340049377650037241810273181027543e3 * t635 * t4 * t605 * t638 * t51
  t643 = t4 * t605
  t646 = 0.12725038616008566457700457726041907357911605145172e1 * t369 * t643 * t372
  t647 = 0.1e1 / t532
  t652 = 0.53020994233369026907085240525174613991298354771548e-1 * t647 * t4 * t605 * t372 * t51
  t654 = 0.1e1 / t532 / t367
  t659 = 0.46822652193836017180722501600483727822255716679496e1 * t654 * t4 * t605 * t538 * t51
  t663 = t6 * t520 * t19
  t667 = t75 * t70 * t31 * t39
  t671 = t75 * t46 * t81 * t84
  t674 = t75 * t76 * t65
  t687 = 0.1e1 / t133 / t18
  t689 = t84 ** 2
  t693 = t84 * t65
  t697 = t65 ** 2
  t701 = t39 * t151
  t709 = t592 - 0.29676388888888888888888888888888888888888888888889e0 * t603 + 0.28489333333333333333333333333333333333333333333334e1 * t606 - 0.10551604938271604938271604938271604938271604938272e1 * t611 + 0.92326543209876543209876543209876543209876543209880e0 * t614
  t713 = 0.70e2 / 0.81e2 * t663 + 0.28e2 / 0.27e2 * t667 + 0.4e1 / 0.3e1 * t671 - 0.2e1 / 0.3e1 * t674 + 0.2e1 * t75 * t24 * t134 * t136 - 0.2e1 * t75 * t230 * t140 + t75 * t211 * t151 / 0.3e1 + 0.6e1 * t75 * t10 * t687 * t689 - 0.9e1 * t75 * t237 * t693 + 0.3e1 / 0.2e1 * t75 * t215 * t697 + 0.2e1 * t75 * t215 * t701 - t75 * t195 * t709 / 0.4e1
  t745 = t249 * t336 / 0.3e1 + t713 * t52 * t201 * t250 / 0.3e1 - 0.2e1 / 0.9e1 * t202 * t341 * t39 - 0.82970309059380511169770432617567371429298354135795e2 * t183 * t520 * t188 + t202 * t112 * t65 / 0.3e1 + 0.14405806907265511347842143815250823810784594959513e-1 * t261 * t18 * t120 + 0.18526846018000188409589551891691194070070945853786e1 * t295 * t519 * t255 * t75 - 0.2e1 / 0.9e1 * t224 * t342 + 0.10e2 / 0.81e2 * t202 * t164 * t18 + 0.2e1 / 0.3e1 * t224 * t207 + t224 * t204 + t202 * t203 * t151 / 0.3e1
  t775 = t7 * t609
  t782 = t201 * t7
  t801 = t249 * t225 + 0.48069654533189678035691810313577152181805697350364e0 * t301 * t4 * t605 * t255 * t51 - 0.11536717087965522728566034475258516523633367364087e2 * t253 * t643 * t255 - 0.50230673592706039194671829476581327568007652233562e2 * t309 * t4 * t605 * t188 * t51 + 0.12854410631079435633322100595691319323249322288194e4 * t327 * t4 * t605 * t331 * t51 + 0.27010887951122833777204019653595294645221115549088e-2 * t173 * t289 * t18 * t48 - 0.14687949996252401622016942040259685388885074190388e0 * t316 * t520 * t317 + 0.65778263038067432278736919552666024196200496972522e1 * t321 * t520 * t322 - 0.17625539995502881946420330448311622466662089028467e1 * t303 * t775 * t304 + 0.16023218177729892678563936771192384060601899116788e0 * t181 * t4 * t609 * t255 * t52 * t782 - 0.28703242052974879539812473986617901467432944133464e2 / t179 / t294 * t4 * t609 * t188 * t52 * t782 + 0.27010887951122833777204019653595294645221115549088e-2 * t290 * t39 * t48 + 0.42728581807279713809503831389846357494938397644766e1 * t283 * t55 * t609 * t255
  t827 = t187 ** 2
  t837 = t519 * t4
  t853 = t110 * t775
  t866 = -0.11e2 / 0.648e3 * t105 * t837 * t19 + 0.8e1 / 0.3e1 * t88 * t116 * t254 * t39 + 0.11e2 / 0.54e2 * t667 + t671 / 0.6e1 - t674 / 0.12e2 + 0.185e3 / 0.864e3 * t663 - t105 * t106 * t31 * t39 / 0.108e3 - 0.160e3 / 0.81e2 * t123 * t853 + 0.140e3 / 0.81e2 * t22 * t591 + 0.16e2 / 0.3e1 * t20 * t606 - 0.4e1 * t83 * t35 * t160 * t65 - 0.36e2 * t135 * t693
  t908 = t601 * t3 * t35
  t915 = 0.8e1 * t139 * t701 + 0.24e2 * t29 * t687 * t689 + 0.6e1 * t139 * t697 - t32 * t709 + 0.56e2 / 0.27e2 * t94 * t35 * t70 * t39 + 0.4e1 * t15 * t134 * t34 * t35 * t24 * t136 + 0.8e1 / 0.3e1 * t83 * t35 * t46 * t84 - 0.4e1 / 0.3e1 * t82 * t53 * t55 * t58 * t84 + 0.2e1 / 0.3e1 * t89 * t55 * t58 * t65 - 0.4e1 / 0.3e1 * t94 * t35 * t46 * t65 + 0.2e1 / 0.3e1 * t94 * t35 * t24 * t151 - 0.5e1 / 0.9e1 * t20 * t598 * t908 - 0.16e2 / 0.9e1 * t89 * t55 * t125 * t39
  t928 = t103 * t8 * t106
  t931 = 0.18417913650658881038046337474746486774936139152306e3 * t311 * t775 * t312 - 0.47132838980624597322181035517534837518580848390044e4 * t329 * t775 * t332 - 0.33013307495816796838804912909949804566381363448884e-2 * t291 * t130 - 0.37387509081369749583315852466115562808071097939170e1 * t271 * t35 * t519 * t255 + 0.16068013288849294541652625744614149154061652860242e4 / t326 / t177 * t4 * t609 * t331 * t52 * t782 - 0.28783485915536592493215570496151025048490758133637e5 / t326 / t294 * t4 * t609 / t827 * t52 * t782 + 0.64826131082694801065289647168628707148530677317810e-1 * t174 * t65 + 0.21608710360898267021763215722876235716176892439270e-1 * t43 * t151 + 0.21608710360898267021763215722876235716176892439270e-1 * (t866 + t915) * t42 * t18 + 0.64826131082694801065289647168628707148530677317810e-1 * t154 * t39 + 0.72029034536327556739210719076254119053922974797566e-2 * t277 * t266 * t165 + 0.15006048861734907654002233140886274802900619749493e-3 * t290 * t18 * t3 * t928
  t933 = t4 * t601
  t956 = t609 * t4
  t974 = t55 * t125 * t21
  t984 = 0.12017413633297419508922952578394288045451424337591e1 * t184 * t597 * t933 * t255 * t3 * t35 + 0.11204516483428731048321667411861751852832462746288e-1 * t345 * t130 - 0.14405806907265511347842143815250823810784594959513e-1 * t279 * t48 - 0.14405806907265511347842143815250823810784594959513e-1 * t263 * t48 - 0.96038712715103408985614292101672158738563966396755e-2 * t267 * t127 + 0.10804355180449133510881607861438117858088446219635e-1 * t261 * t65 * t21 * t26 + 0.10804355180449133510881607861438117858088446219635e-1 * t153 * t260 * t278 * t26 + 0.10712008859232863027768417163076099436041101906828e3 * t328 * t782 * t956 * t332 + 0.40058045444324731696409841927980960151504747791968e-1 * t302 * t782 * t956 * t304 - 0.41858894660588365995559857897151106306673043527969e1 * t310 * t782 * t956 * t312 + 0.12004839089387926123201786512709019842320495799594e-2 * t41 / t288 / t15 * t18 * t52 * t974 + 0.72029034536327556739210719076254119053922974797566e-2 * t261 * t39 * t51 * t165 + 0.21608710360898267021763215722876235716176892439270e-1 * t277 * t262 * t26
  t990 = t384 ** 2
  t991 = 0.1e1 / t990
  t992 = t391 * t991
  t993 = t992 * t378
  t995 = 0.14804514559303905048800602434946994993825393540828e-3 * t993 * t130
  t996 = t507 * t103
  t997 = t4 * t372
  t1000 = 0.16200859349084980443831601271581132052896719513529e-1 * t996 * t520 * t997
  t1001 = t535 * t103
  t1002 = t4 * t538
  t1005 = 0.61315377872880498689041371143490595957715819461244e0 * t1001 * t520 * t1002
  t1010 = t537 ** 2
  t1015 = 0.19162434373246948642083122762742588170998040494372e4 / t634 / t505 * t4 * t609 / t1010 * t52 * t782
  t1017 = t368 * t51 * t52
  t1021 = 0.47129772651883579472964658244599656881154093130267e0 * t1017 * t55 * t609 * t372
  t1025 = 0.12112784639430467767200492901320268631311685624314e-3 * t431 * t991 * t378 * t48
  t1028 = 0.12112784639430467767200492901320268631311685624314e-3 * t992 * t389 * t48
  t1034 = 0.17673664744456342302361746841724871330432784923849e-1 * t534 * t4 * t609 * t372 * t52 * t782
  t1035 = t642 - t646 + t652 - t659 - t2 * (t745 + t801 + t931 + t984) * t363 / 0.24e2 - t995 - t1000 + t1005 - t1015 + t1021 + t1025 + t1028 + t1034
  t1044 = 0.26755801253620581246127143771704987327003266673998e1 / t532 / t505 * t4 * t609 * t538 * t52 * t782
  t1052 = 0.12657832131062950425061722062546552262841476284429e3 / t634 / t366 * t4 * t609 * t638 * t52 * t782
  t1053 = t635 * t52
  t1054 = t1053 * t54
  t1055 = t638 * t21
  t1058 = 0.37129640917784654580181051383469886637668330434323e3 * t1054 * t775 * t1055
  t1059 = t647 * t52
  t1060 = t1059 * t54
  t1061 = t372 * t21
  t1064 = 0.19441031218901976532597921525897358463476063416234e0 * t1060 * t775 * t1061
  t1065 = t654 * t52
  t1066 = t1065 * t54
  t1067 = t538 * t21
  t1070 = 0.17168305804406539632931583920177366868160429449148e2 * t1066 * t775 * t1067
  t1072 = t368 * t21 * t3
  t1076 = 0.41238551070398132038844075964024699771009831488983e0 * t1072 * t35 * t519 * t372
  t1077 = t13 + 0.130720e2
  t1078 = t1077 ** 2
  t1079 = t1078 ** 2
  t1080 = t1079 ** 2
  t1081 = 0.1e1 / t1080
  t1083 = 0.1e1 / t1078
  t1085 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t1083
  t1086 = t1085 ** 2
  t1088 = 0.1e1 / t1086 / t1085
  t1093 = 0.1e1 / t1079
  t1095 = 0.1e1 / t1085
  t1101 = 0.1e1 / t1079 / t1078
  t1103 = 0.1e1 / t1086
  t1108 = t1083 * t116
  t1112 = t13 + 0.201231e2
  t1113 = t1112 ** 2
  t1114 = 0.1e1 / t1113
  t1115 = t1114 * t116
  t1117 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t1114
  t1118 = 0.1e1 / t1117
  t1122 = t1113 ** 2
  t1123 = 0.1e1 / t1122
  t1130 = 0.1e1 / t1122 / t1113
  t1132 = t1117 ** 2
  t1133 = 0.1e1 / t1132
  t1138 = t1122 ** 2
  t1139 = 0.1e1 / t1138
  t1142 = 0.1e1 / t1132 / t1117
  t1148 = 0.1e1 / t1079 / t1077
  t1155 = t1078 * t1077
  t1164 = t14 + 0.743294e0
  t1166 = t16 + 0.10061550000000000000000000000000000000000000000000e2 * t13 + 0.101578e3
  t1167 = 0.1e1 / t1166
  t1168 = t1164 * t1167
  t1169 = t1168 * t21
  t1172 = t1164 ** 2
  t1173 = t1166 ** 2
  t1174 = 0.1e1 / t1173
  t1175 = t1172 * t1174
  t1177 = -t33 - 0.16769250000000000000000000000000000000000000000000e1 * t37
  t1179 = -t1169 * t26 / 0.6e1 - t1175 * t1177
  t1180 = t1172 ** 2
  t1181 = 0.1e1 / t1180
  t1182 = t1179 * t1181
  t1187 = 0.1e1 / t1122 / t1112
  t1194 = -0.11096132980116444006918771801481172997538553998313e-5 * t1081 * t4 * t605 * t1088 * t51 - 0.20476317769075897298765330852955325029117052416814e0 * t1093 * t4 * t605 * t1095 * t51 + 0.96320598785733020893392116332301848936966614568690e-3 * t1101 * t4 * t605 * t1103 * t51 + 0.49143162645782153517036794047092780069880925800353e1 * t1108 * t643 * t1095 - 0.38669865337948717359644290188598279441994812129610e1 * t1115 * t643 * t1118 + 0.16112443890811965566518454245249283100831171720671e0 * t1123 * t4 * t605 * t1118 * t51 - 0.51613124335683775892531384484264856895149520224450e0 * t1130 * t4 * t605 * t1133 * t51 + 0.40489652240494068523217565229100011767070072771638e0 * t1139 * t4 * t605 * t1142 * t51 - 0.68254392563586324329217769509851083430390174722713e-1 * t1148 * t4 * t609 * t1095 * t52 * t782 + 0.55040342163276011939081209332743913678266636896394e-3 / t1079 / t1155 * t4 * t609 * t1103 * t52 * t782 + 0.33341375090916439491644963203219619213550639005767e-3 * t1182 * t1177 * t48 + 0.53708146302706551888394847484164277002770572402236e-1 * t1187 * t4 * t609 * t1118 * t52 * t782
  t1195 = t1113 * t1112
  t1205 = 0.1e1 / t1155 * t3
  t1206 = t1205 * t103
  t1207 = t4 * t1095
  t1211 = t1148 * t3
  t1212 = t1211 * t103
  t1213 = t4 * t1103
  t1218 = t16 + 0.65360000000000000000000000000000000000000000000000e1 * t13 + 0.427198e2
  t1219 = 0.1e1 / t1218
  t1221 = t6 * t47 * t1219
  t1223 = t14 + 0.409286e0
  t1224 = t1218 ** 2
  t1225 = 0.1e1 / t1224
  t1226 = t1223 * t1225
  t1227 = t1226 * t34
  t1229 = -t33 - 0.10893333333333333333333333333333333333333333333333e1 * t37
  t1230 = t24 * t1229
  t1234 = t1223 * t1219
  t1235 = t1234 * t51
  t1238 = t1234 * t21
  t1241 = t1223 ** 2
  t1243 = 0.1e1 / t1224 / t1218
  t1244 = t1241 * t1243
  t1245 = t1229 ** 2
  t1248 = t1241 * t1225
  t1251 = t49 - 0.72622222222222222222222222222222222222222222222220e0 * t60 + 0.14524444444444444444444444444444444444444444444444e1 * t63
  t1253 = t1221 / 0.72e2 + t1227 * t35 * t1230 / 0.3e1 - t1235 * t165 / 0.9e1 + 0.2e1 / 0.9e1 * t1238 * t48 + 0.2e1 * t1244 * t1245 - t1248 * t1251
  t1254 = t1241 ** 2
  t1255 = 0.1e1 / t1254
  t1272 = t1132 ** 2
  t1279 = t6 * t47 * t1167
  t1281 = t1164 * t1174
  t1282 = t1281 * t34
  t1283 = t24 * t1177
  t1287 = t1168 * t51
  t1293 = 0.1e1 / t1173 / t1166
  t1294 = t1172 * t1293
  t1295 = t1177 ** 2
  t1300 = t49 - 0.11179500000000000000000000000000000000000000000000e1 * t60 + 0.22359000000000000000000000000000000000000000000000e1 * t63
  t1302 = t1279 / 0.72e2 + t1282 * t35 * t1283 / 0.3e1 - t1287 * t165 / 0.9e1 + 0.2e1 / 0.9e1 * t1169 * t48 + 0.2e1 * t1294 * t1295 - t1175 * t1300
  t1307 = t1081 * t52
  t1308 = t1307 * t54
  t1309 = t1088 * t21
  t1316 = -t1238 * t26 / 0.6e1 - t1248 * t1229
  t1317 = t1316 * t1255
  t1318 = t1317 * t1218
  t1321 = t1187 * t3
  t1322 = t1321 * t103
  t1323 = t4 * t1133
  t1328 = t1083 * t51 * t52
  t1334 = t1083 * t21 * t3
  t1340 = t1114 * t51 * t52
  t1345 = -0.29493213906105014795732219705294203940085440128257e0 / t1122 / t1195 * t4 * t609 * t1133 * t52 * t782 + 0.62566526516620797301782955384030159811190993495820e-1 * t1206 * t520 * t1207 - 0.12613411745750752736039443805420480217936104288757e-3 * t1212 * t520 * t1213 - 0.55392172096869228372480688864674045862037218664772e-3 * t1253 * t1255 * t1218 * t48 + 0.50612065300617585654021956536375014708837590964548e0 / t1138 / t1112 * t4 * t609 * t1142 * t52 * t782 - 0.27793036455358846894255932804679737051689835140790e0 / t1138 / t1195 * t4 * t609 / t1272 * t52 * t782 + 0.33341375090916439491644963203219619213550639005767e-3 * t1302 * t1181 * t1166 * t48 + 0.40685820927093628025368829938764300990974697993815e-5 * t1308 * t775 * t1309 + 0.67701543673951279121920841945712722720267711701388e-3 * t1318 * t130 + 0.67588615201490658906886336824632550696029133627253e-1 * t1322 * t520 * t1323 - 0.18201171350289686487791405202626955581437379926057e1 * t1328 * t55 * t609 * t1095 + 0.15926024931503475676817479552298586133757707435299e1 * t1334 * t35 * t519 * t1095 + 0.14322172347388413836905292662443807200738819307263e1 * t1340 * t55 * t609 * t1118
  t1347 = t1182 * t1166
  t1351 = 0.1e1 / t1195 * t3
  t1352 = t1351 * t103
  t1353 = t4 * t1118
  t1357 = t1130 * t52
  t1358 = t1357 * t54
  t1359 = t1133 * t21
  t1363 = t1139 * t52
  t1364 = t1363 * t54
  t1365 = t1142 * t21
  t1369 = t1093 * t52
  t1370 = t1369 * t54
  t1371 = t1095 * t21
  t1375 = t1101 * t52
  t1376 = t1375 * t54
  t1377 = t1103 * t21
  t1396 = t1086 ** 2
  t1402 = t1123 * t52
  t1403 = t1402 * t54
  t1404 = t1118 * t21
  t1409 = t1114 * t21 * t3
  t1415 = t6 * t71 * t1219
  t1417 = t46 * t1225
  t1419 = t75 * t1417 * t1229
  t1421 = t1223 * t1243
  t1422 = t1421 * t34
  t1426 = t1226 * t53
  t1448 = t1224 ** 2
  t1449 = 0.1e1 / t1448
  t1450 = t1241 * t1449
  t1451 = t1245 * t1229
  t1454 = t1229 * t1251
  t1460 = -t143 - 0.43573333333333333333333333333333333333333333333332e1 * t120 + 0.29048888888888888888888888888888888888888888888888e1 * t146 - 0.33890370370370370370370370370370370370370370370369e1 * t149
  t1462 = -0.11e2 / 0.216e3 * t1415 - t1419 / 0.24e2 - t1422 * t35 * t24 * t1245 + t1426 * t55 * t58 * t1229 / 0.3e1 - 0.2e1 / 0.3e1 * t1227 * t35 * t46 * t1229 + t1227 * t35 * t24 * t1251 / 0.2e1 + t105 * t106 * t1219 / 0.432e3 - 0.2e1 / 0.3e1 * t1234 * t120 + 0.4e1 / 0.9e1 * t1235 * t127 - 0.14e2 / 0.27e2 * t1238 * t130 - 0.6e1 * t1450 * t1451 + 0.6e1 * t1244 * t1454 - t1248 * t1460
  t1464 = 0.1e1 / t1241 / t1223
  t1466 = t1218 * t21
  t1470 = -0.40750569555564537156454955026157312372117447673715e-3 * t1347 * t130 - 0.49232467444147672564361943527150587252539691368716e-1 * t1352 * t520 * t1353 + 0.18924812256417384493928174310897114194888157415632e1 * t1358 * t775 * t1359 - 0.14846205821514491791846440584003337647925693349601e1 * t1364 * t775 * t1365 + 0.75079831819944956762139546460836191773429192194982e0 * t1370 * t775 * t1371 - 0.35317552888102107660910442655177344610221092008520e-2 * t1376 * t775 * t1377 - 0.55392172096869228372480688864674045862037218664772e-3 * t1317 * t1229 * t48 - 0.13870166225145555008648464751851466246923192497891e-5 / t1080 / t1077 * t4 * t609 * t1088 * t52 * t782 + 0.11184902043957375558974121975893022381518862430300e-8 / t1080 / t1155 * t4 * t609 / t1396 * t52 * t782 - 0.59078960932977207077234332232580704703047629642460e0 * t1403 * t775 * t1404 - 0.12531900803964862107292131079638331300646466893855e1 * t1409 * t35 * t519 * t1118 - 0.22156868838747691348992275545869618344814887465909e-2 * t1462 * t1464 * t1466 * t26
  t1484 = 0.1e1 / t1172 / t1164
  t1485 = t1302 * t1484
  t1486 = t1166 * t21
  t1487 = t1485 * t1486
  t1516 = t1316 * t1464
  t1533 = t1179 * t1484
  t1538 = -0.17063598140896581082304442377462770857597543680678e-1 * t1369 * t782 * t956 * t1371 + 0.80267165654777517411160096943584874114138845473912e-4 * t1375 * t782 * t956 * t1377 - 0.92467774834303700057656431679009774979487949985947e-7 * t1307 * t782 * t956 * t1309 - 0.17782066715155434395543980375050463580560340803076e-2 * t1487 * t48 - 0.24618743154164101498880306162077353716460986073232e-3 * t1316 / t1254 / t1223 * t1218 * t52 * t974 + 0.33741376867078390436014637690916676472558393976364e-1 * t1363 * t782 * t956 * t1365 + 0.14818388929296195329619983645875386317133617335896e-3 * t1179 / t1180 / t1164 * t1166 * t52 * t974 + 0.13427036575676637972098711871041069250692643100559e-1 * t1402 * t782 * t956 * t1404 - 0.43010936946403146577109487070220714079291266853706e-1 * t1357 * t782 * t956 * t1359 - 0.22156868838747691348992275545869618344814887465909e-2 * t1516 * t1251 * t21 * t26 - 0.51190794422689743246913327132388312572792631042035e0 * t1083 * t597 * t933 * t1095 * t3 * t35 + 0.40281109727029913916296135613123207752077929301677e0 * t1114 * t597 * t933 * t1118 * t3 * t35 + 0.13336550036366575796657985281287847685420255602307e-2 * t1533 * t1300 * t21 * t26
  t1545 = t1253 * t1464
  t1546 = t1229 * t21
  t1550 = t1218 * t51
  t1562 = t1177 * t21
  t1566 = t1533 * t1562
  t1569 = t1166 * t51
  t1570 = t1533 * t1569
  t1573 = t1516 * t1466
  t1576 = t1545 * t1466
  t1579 = t1516 * t1546
  t1582 = t1516 * t1550
  t1585 = 0.88910333575777171977719901875252317902801704015380e-3 * t1533 * t1177 * t51 * t165 - 0.44313737677495382697984551091739236689629774931817e-2 * t1545 * t1546 * t26 - 0.14771245892498460899328183697246412229876591643939e-2 * t1545 * t1550 * t165 - 0.14771245892498460899328183697246412229876591643939e-2 * t1516 * t1229 * t51 * t165 - 0.30773428942705126873600382702596692145576232591541e-4 * t1317 * t1218 * t3 * t928 + 0.26673100072733151593315970562575695370840511204614e-2 * t1485 * t1562 * t26 - 0.17782066715155434395543980375050463580560340803076e-2 * t1566 * t48 - 0.11854711143436956263695986916700309053706893868717e-2 * t1570 * t127 - 0.22977493610553161398954952417938863468696920335017e-2 * t1573 * t130 + 0.29542491784996921798656367394492824459753183287878e-2 * t1576 * t48 + 0.29542491784996921798656367394492824459753183287878e-2 * t1579 * t48 + 0.19694994523331281199104244929661882973168788858586e-2 * t1582 * t127
  t1586 = t1533 * t1486
  t1590 = t6 * t71 * t1167
  t1592 = t46 * t1174
  t1594 = t75 * t1592 * t1177
  t1596 = t1164 * t1293
  t1597 = t1596 * t34
  t1601 = t1281 * t53
  t1623 = t1173 ** 2
  t1624 = 0.1e1 / t1623
  t1625 = t1172 * t1624
  t1626 = t1295 * t1177
  t1629 = t1177 * t1300
  t1635 = -t143 - 0.67077000000000000000000000000000000000000000000000e1 * t120 + 0.44718000000000000000000000000000000000000000000000e1 * t146 - 0.52171000000000000000000000000000000000000000000000e1 * t149
  t1637 = -0.11e2 / 0.216e3 * t1590 - t1594 / 0.24e2 - t1597 * t35 * t24 * t1295 + t1601 * t55 * t58 * t1177 / 0.3e1 - 0.2e1 / 0.3e1 * t1282 * t35 * t46 * t1177 + t1282 * t35 * t24 * t1300 / 0.2e1 + t105 * t106 * t1167 / 0.432e3 - 0.2e1 / 0.3e1 * t1168 * t120 + 0.4e1 / 0.9e1 * t1287 * t127 - 0.14e2 / 0.27e2 * t1169 * t130 - 0.6e1 * t1625 * t1626 + 0.6e1 * t1294 * t1629 - t1175 * t1635
  t1644 = t24 * t1243
  t1648 = t24 * t1225
  t1652 = t10 * t1449
  t1656 = t10 * t1243
  t1660 = t10 * t1225
  t1666 = (-0.7e1 / 0.27e2 * t1415 - t1419 / 0.3e1 - t75 * t1644 * t1245 / 0.2e1 + t75 * t1648 * t1251 / 0.4e1 - 0.3e1 / 0.2e1 * t75 * t1652 * t1451 + 0.3e1 / 0.2e1 * t75 * t1656 * t1454 - t75 * t1660 * t1460 / 0.4e1) * t52 * t201
  t1667 = t203 * t1229
  t1670 = t1321 * t5
  t1677 = t10 * t1174
  t1683 = (-t6 * t25 * t1167 / 0.12e2 - t75 * t1677 * t1177 / 0.4e1) * t52 * t201
  t1688 = t6 * t520 * t1219
  t1692 = t75 * t70 * t1225 * t1229
  t1696 = t75 * t46 * t1243 * t1245
  t1699 = t75 * t1417 * t1251
  t1712 = 0.1e1 / t1448 / t1218
  t1714 = t1245 ** 2
  t1718 = t1245 * t1251
  t1722 = t1251 ** 2
  t1726 = t1229 * t1460
  t1734 = t592 - 0.36311111111111111111111111111111111111111111111110e1 * t603 + 0.34858666666666666666666666666666666666666666666666e2 * t606 - 0.12910617283950617283950617283950617283950617283950e2 * t611 + 0.11296790123456790123456790123456790123456790123456e2 * t614
  t1738 = 0.70e2 / 0.81e2 * t1688 + 0.28e2 / 0.27e2 * t1692 + 0.4e1 / 0.3e1 * t1696 - 0.2e1 / 0.3e1 * t1699 + 0.2e1 * t75 * t24 * t1449 * t1451 - 0.2e1 * t75 * t1644 * t1454 + t75 * t1648 * t1460 / 0.3e1 + 0.6e1 * t75 * t10 * t1712 * t1714 - 0.9e1 * t75 * t1652 * t1718 + 0.3e1 / 0.2e1 * t75 * t1656 * t1722 + 0.2e1 * t75 * t1656 * t1726 - t75 * t1660 * t1734 / 0.4e1
  t1741 = t203 * t1218
  t1745 = t24 * t1174
  t1749 = t10 * t1293
  t1758 = (t1279 / 0.9e1 + t75 * t1745 * t1177 / 0.6e1 + t75 * t1749 * t1295 / 0.2e1 - t75 * t1677 * t1300 / 0.4e1) * t52 * t201
  t1759 = t203 * t1300
  t1762 = t112 * t1177
  t1765 = t1205 * t5
  t1787 = (t1221 / 0.9e1 + t75 * t1648 * t1229 / 0.6e1 + t75 * t1656 * t1245 / 0.2e1 - t75 * t1660 * t1251 / 0.4e1) * t52 * t201
  t1788 = t203 * t1251
  t1791 = t341 * t1218
  t1794 = 0.13830496334009782307645318069483693895991376180170e-2 * t1586 * t130 + 0.13336550036366575796657985281287847685420255602307e-2 * t1637 * t1484 * t1486 * t26 - 0.31090700000000000000000000000000000000000000000001e-1 * t1666 * t1667 - 0.85253821447334808393913447585616058264309475370748e0 * t1670 * t520 * t1133 - 0.34545222222222222222222222222222222222222222222222e-2 * t1683 * t341 * t1177 - 0.10363566666666666666666666666666666666666666666667e-1 * t1738 * t52 * t201 * t1741 + 0.15545350000000000000000000000000000000000000000000e-1 * t1758 * t1759 + 0.10363566666666666666666666666666666666666666666667e-1 * t1758 * t1762 - 0.78919141401646687505658045995765315216388639523133e0 * t1765 * t520 * t1095 + 0.51817833333333333333333333333333333333333333333333e-2 * t1683 * t203 * t1635 + 0.51817833333333333333333333333333333333333333333333e-2 * t1683 * t112 * t1300 - 0.31090700000000000000000000000000000000000000000001e-1 * t1787 * t1788 + 0.69090444444444444444444444444444444444444444444446e-2 * t1787 * t1791
  t1804 = (-t6 * t25 * t1219 / 0.12e2 - t75 * t1660 * t1229 / 0.4e1) * t52 * t201
  t1808 = t112 * t1229
  t1817 = t1351 * t5
  t1822 = t6 * t520 * t1167
  t1826 = t75 * t70 * t1174 * t1177
  t1830 = t75 * t46 * t1293 * t1295
  t1833 = t75 * t1592 * t1300
  t1839 = t24 * t1293
  t1847 = 0.1e1 / t1623 / t1166
  t1849 = t1295 ** 2
  t1853 = t10 * t1624
  t1854 = t1295 * t1300
  t1858 = t1300 ** 2
  t1862 = t1177 * t1635
  t1870 = t592 - 0.55897500000000000000000000000000000000000000000000e1 * t603 + 0.53661600000000000000000000000000000000000000000000e2 * t606 - 0.19874666666666666666666666666666666666666666666667e2 * t611 + 0.17390333333333333333333333333333333333333333333333e2 * t614
  t1874 = 0.70e2 / 0.81e2 * t1822 + 0.28e2 / 0.27e2 * t1826 + 0.4e1 / 0.3e1 * t1830 - 0.2e1 / 0.3e1 * t1833 + 0.2e1 * t75 * t24 * t1624 * t1626 - 0.2e1 * t75 * t1839 * t1629 + t75 * t1745 * t1635 / 0.3e1 + 0.6e1 * t75 * t10 * t1847 * t1849 - 0.9e1 * t75 * t1853 * t1854 + 0.3e1 / 0.2e1 * t75 * t1749 * t1858 + 0.2e1 * t75 * t1749 * t1862 - t75 * t1677 * t1870 / 0.4e1
  t1877 = t203 * t1166
  t1883 = t1211 * t5
  t1887 = t341 * t1166
  t1890 = t112 * t1218
  t1912 = (-0.7e1 / 0.27e2 * t1590 - t1594 / 0.3e1 - t75 * t1839 * t1295 / 0.2e1 + t75 * t1745 * t1300 / 0.4e1 - 0.3e1 / 0.2e1 * t75 * t1853 * t1626 + 0.3e1 / 0.2e1 * t75 * t1749 * t1629 - t75 * t1677 * t1635 / 0.4e1) * t52 * t201
  t1913 = t203 * t1177
  t1916 = t112 * t1166
  t1919 = -0.10363566666666666666666666666666666666666666666667e-1 * t1804 * t203 * t1460 - 0.20727133333333333333333333333333333333333333333334e-1 * t1787 * t1808 + 0.19191790123456790123456790123456790123456790123457e-2 * t1683 * t164 * t1166 - 0.38383580246913580246913580246913580246913580246915e-2 * t1804 * t164 * t1218 + 0.62100044162504450620956542403564945284453474340086e0 * t1817 * t520 * t1118 + 0.51817833333333333333333333333333333333333333333333e-2 * t1874 * t52 * t201 * t1877 - 0.10363566666666666666666666666666666666666666666667e-1 * t1804 * t112 * t1251 + 0.15910098906571972201140662072746287547623949727864e-2 * t1883 * t520 * t1103 - 0.34545222222222222222222222222222222222222222222222e-2 * t1758 * t1887 - 0.10363566666666666666666666666666666666666666666667e-1 * t1666 * t1890 + 0.15545350000000000000000000000000000000000000000000e-1 * t1912 * t1913 + 0.51817833333333333333333333333333333333333333333333e-2 * t1912 * t1916
  t1978 = 0.185e3 / 0.864e3 * t1688 + 0.16e2 / 0.3e1 * t1234 * t606 - 0.4e1 / 0.3e1 * t1421 * t53 * t55 * t58 * t1245 + 0.2e1 / 0.3e1 * t1426 * t55 * t58 * t1251 - 0.4e1 / 0.3e1 * t1227 * t35 * t46 * t1251 + 0.2e1 / 0.3e1 * t1227 * t35 * t24 * t1460 - 0.5e1 / 0.9e1 * t1234 * t598 * t908 + 0.4e1 * t1223 * t1449 * t34 * t35 * t24 * t1451 + 0.8e1 / 0.3e1 * t1422 * t35 * t46 * t1245 - 0.16e2 / 0.9e1 * t1426 * t55 * t125 * t1229 + 0.56e2 / 0.27e2 * t1227 * t35 * t70 * t1229 - t1699 / 0.12e2
  t2010 = 0.8e1 / 0.3e1 * t1226 * t116 * t254 * t1229 - 0.11e2 / 0.648e3 * t105 * t837 * t1219 + 0.11e2 / 0.54e2 * t1692 + t1696 / 0.6e1 - 0.4e1 * t1422 * t35 * t1230 * t1251 - t1248 * t1734 + 0.24e2 * t1241 * t1712 * t1714 + 0.6e1 * t1244 * t1722 - 0.36e2 * t1450 * t1718 + 0.8e1 * t1244 * t1726 - 0.160e3 / 0.81e2 * t1235 * t853 + 0.140e3 / 0.81e2 * t1238 * t591 - t105 * t106 * t1225 * t1229 / 0.108e3
  t2012 = 0.1e1 / t1241
  t2060 = 0.185e3 / 0.864e3 * t1822 + 0.16e2 / 0.3e1 * t1168 * t606 + 0.4e1 * t1164 * t1624 * t34 * t35 * t24 * t1626 + 0.8e1 / 0.3e1 * t1597 * t35 * t46 * t1295 - 0.16e2 / 0.9e1 * t1601 * t55 * t125 * t1177 + 0.56e2 / 0.27e2 * t1282 * t35 * t70 * t1177 + 0.2e1 / 0.3e1 * t1601 * t55 * t58 * t1300 - 0.4e1 / 0.3e1 * t1282 * t35 * t46 * t1300 + 0.2e1 / 0.3e1 * t1282 * t35 * t24 * t1635 - 0.5e1 / 0.9e1 * t1168 * t598 * t908 - 0.4e1 / 0.3e1 * t1596 * t53 * t55 * t58 * t1295 - 0.11e2 / 0.648e3 * t105 * t837 * t1167
  t2090 = 0.8e1 / 0.3e1 * t1281 * t116 * t254 * t1177 + 0.11e2 / 0.54e2 * t1826 + t1830 / 0.6e1 - t1833 / 0.12e2 - 0.4e1 * t1597 * t35 * t1283 * t1300 + 0.8e1 * t1294 * t1862 - 0.36e2 * t1625 * t1854 + 0.24e2 * t1172 * t1847 * t1849 + 0.6e1 * t1294 * t1858 - t1175 * t1870 + 0.140e3 / 0.81e2 * t1169 * t591 - t105 * t106 * t1174 * t1177 / 0.108e3 - 0.160e3 / 0.81e2 * t1287 * t853
  t2092 = 0.1e1 / t1172
  t2096 = t1253 * t2012
  t2099 = t1316 * t2012
  t2102 = t1462 * t2012
  t2105 = t1637 * t2092
  t2108 = t1302 * t2092
  t2111 = t1179 * t2092
  t2114 = 0.17782066715155434395543980375050463580560340803076e-2 * t1533 * t1166 * t120 - 0.29542491784996921798656367394492824459753183287879e-2 * t1516 * t1218 * t120 + 0.69090444444444444444444444444444444444444444444446e-2 * t1804 * t341 * t1229 + 0.88910333575777171977719901875252317902801704015380e-3 * t1485 * t1569 * t165 + 0.18522986161620244162024979557344232896417021669871e-4 * t1182 * t1166 * t3 * t928 - 0.44313737677495382697984551091739236689629774931818e-2 * (t1978 + t2010) * t2012 * t1218 + 0.26673100072733151593315970562575695370840511204614e-2 * (t2060 + t2090) * t2092 * t1166 - 0.13294121303248614809395365327521771006888932479545e-1 * t2096 * t1251 - 0.44313737677495382697984551091739236689629774931818e-2 * t2099 * t1460 - 0.13294121303248614809395365327521771006888932479545e-1 * t2102 * t1229 + 0.80019300218199454779947911687727086112521533613842e-2 * t2105 * t1177 + 0.80019300218199454779947911687727086112521533613842e-2 * t2108 * t1300 + 0.26673100072733151593315970562575695370840511204614e-2 * t2111 * t1635
  t2120 = -t514 - t517 - t523 - t526 - t528 - t531 + t541 + t544 - t547 - t624 - t626 - t629
  t2121 = t13 + 0.706042e1
  t2122 = t2121 ** 2
  t2123 = t2122 ** 2
  t2125 = 0.1e1 / t2123 / t2122
  t2127 = 0.1e1 / t2122
  t2129 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t2127
  t2130 = t2129 ** 2
  t2131 = 0.1e1 / t2130
  t2136 = t2127 * t116
  t2137 = 0.1e1 / t2129
  t2141 = t2123 ** 2
  t2142 = 0.1e1 / t2141
  t2145 = 0.1e1 / t2130 / t2129
  t2150 = 0.1e1 / t2123
  t2157 = t2127 * t51 * t52
  t2163 = t2127 * t21 * t3
  t2168 = t2150 * t52
  t2169 = t2168 * t54
  t2170 = t2137 * t21
  t2174 = t2125 * t52
  t2175 = t2174 * t54
  t2176 = t2131 * t21
  t2180 = t632 - 0.28819808215097185564958466887747979370065076229728e1 * t2125 * t4 * t605 * t2131 * t51 - 0.13244423704918215443268820847077687541595671696467e1 * t2136 * t643 * t2137 + 0.36859166875534672574951211996882400190266806045320e2 * t2142 * t4 * t605 * t2145 * t51 + 0.55185098770492564346953420196157031423315298735276e-1 * t2150 * t4 * t605 * t2137 * t51 - t642 + t646 - t652 + t659 + 0.49053421129326723863958595729917361265169154431359e0 * t2157 * t55 * t609 * t2137 - 0.42921743488160883380963771263677691107023010127437e0 * t2163 * t35 * t519 * t2137 - 0.20234536215847273593882920738590911521882276202934e0 * t2169 * t775 * t2170 + 0.10567263012202301373818104525507592435690527950900e2 * t2175 * t775 * t2176
  t2182 = t2122 * t2121
  t2184 = 0.1e1 / t2182 * t3
  t2185 = t2184 * t103
  t2186 = t4 * t2137
  t2191 = 0.1e1 / t2123 / t2121
  t2192 = t2191 * t3
  t2193 = t2192 * t103
  t2194 = t4 * t2131
  t2198 = t14 + 0.32500e0
  t2200 = t16 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t2201 = 0.1e1 / t2200
  t2202 = t2198 * t2201
  t2203 = t2202 * t21
  t2206 = t2198 ** 2
  t2207 = t2200 ** 2
  t2208 = 0.1e1 / t2207
  t2209 = t2206 * t2208
  t2211 = -t33 - 0.58836833333333333333333333333333333333333333333333e0 * t37
  t2213 = -t2203 * t26 / 0.6e1 - t2209 * t2211
  t2214 = t2206 ** 2
  t2215 = 0.1e1 / t2214
  t2216 = t2213 * t2215
  t2217 = t2216 * t2200
  t2220 = t2142 * t52
  t2221 = t2220 * t54
  t2222 = t2145 * t21
  t2238 = t2130 ** 2
  t2259 = t6 * t47 * t2201
  t2261 = t2198 * t2208
  t2262 = t2261 * t34
  t2263 = t24 * t2211
  t2267 = t2202 * t51
  t2273 = 0.1e1 / t2207 / t2200
  t2274 = t2206 * t2273
  t2275 = t2211 ** 2
  t2280 = t49 - 0.39224555555555555555555555555555555555555555555555e0 * t60 + 0.78449111111111111111111111111111111111111111111110e0 * t63
  t2282 = t2259 / 0.72e2 + t2262 * t35 * t2263 / 0.3e1 - t2267 * t165 / 0.9e1 + 0.2e1 / 0.9e1 * t2203 * t48 + 0.2e1 * t2274 * t2275 - t2209 * t2280
  t2290 = -0.16862113513206061328235767282159092934901896835780e-1 * t2185 * t520 * t2186 + 0.37740225043579647763636087591098544413180456967501e0 * t2193 * t520 * t2194 - 0.34342413959678791974433194933424046692523362938372e-3 * t2217 * t130 - 0.13515027854362713277482111065523546736431162216617e3 * t2221 * t775 * t2222 + 0.46073958594418340718689014996103000237833507556650e2 / t2141 / t2121 * t4 * t609 * t2145 * t52 * t782 - 0.41248484411876216403621151040619215743173669759529e3 / t2141 / t2182 * t4 * t609 / t2238 * t52 * t782 + 0.18395032923497521448984473398719010474438432911759e-1 * t2191 * t4 * t609 * t2137 * t52 * t782 - 0.16468461837198391751404838221570273925751472131273e1 / t2123 / t2182 * t4 * t609 * t2131 * t52 * t782 + 0.28098338694282647979081704945528765475700933313214e-3 * t2282 * t2215 * t2200 * t48 + 0.28098338694282647979081704945528765475700933313214e-3 * t2216 * t2211 * t48 + t995 + t1000
  t2292 = t6 * t520 * t2201
  t2296 = t75 * t70 * t2208 * t2211
  t2300 = t75 * t46 * t2273 * t2275
  t2302 = t46 * t2208
  t2304 = t75 * t2302 * t2280
  t2306 = t2207 ** 2
  t2307 = 0.1e1 / t2306
  t2309 = t2275 * t2211
  t2313 = t24 * t2273
  t2314 = t2211 * t2280
  t2318 = t24 * t2208
  t2322 = -t143 - 0.23534733333333333333333333333333333333333333333333e1 * t120 + 0.15689822222222222222222222222222222222222222222222e1 * t146 - 0.18304792592592592592592592592592592592592592592592e1 * t149
  t2327 = 0.1e1 / t2306 / t2200
  t2329 = t2275 ** 2
  t2333 = t10 * t2307
  t2334 = t2275 * t2280
  t2338 = t10 * t2273
  t2339 = t2280 ** 2
  t2343 = t2211 * t2322
  t2347 = t10 * t2208
  t2352 = t592 - 0.19612277777777777777777777777777777777777777777777e1 * t603 + 0.18827786666666666666666666666666666666666666666666e2 * t606 - 0.69732543209876543209876543209876543209876543209875e1 * t611 + 0.61015975308641975308641975308641975308641975308640e1 * t614
  t2356 = 0.70e2 / 0.81e2 * t2292 + 0.28e2 / 0.27e2 * t2296 + 0.4e1 / 0.3e1 * t2300 - 0.2e1 / 0.3e1 * t2304 + 0.2e1 * t75 * t24 * t2307 * t2309 - 0.2e1 * t75 * t2313 * t2314 + t75 * t2318 * t2322 / 0.3e1 + 0.6e1 * t75 * t10 * t2327 * t2329 - 0.9e1 * t75 * t2333 * t2334 + 0.3e1 / 0.2e1 * t75 * t2338 * t2339 + 0.2e1 * t75 * t2338 * t2343 - t75 * t2347 * t2352 / 0.4e1
  t2359 = t203 * t2200
  t2362 = -t1005 + t1015 - t1021 - t1025 - t1028 - t1034 + t1044 - t1052 + t1058 + t1064 - t1070 + t1076 + 0.51817833333333333333333333333333333333333333333333e-2 * t2356 * t52 * t201 * t2359
  t2373 = (-t6 * t25 * t2201 / 0.12e2 - t75 * t2347 * t2211 / 0.4e1) * t52 * t201
  t2378 = t6 * t71 * t2201
  t2381 = t75 * t2302 * t2211
  t2400 = (-0.7e1 / 0.27e2 * t2378 - t2381 / 0.3e1 - t75 * t2313 * t2275 / 0.2e1 + t75 * t2318 * t2280 / 0.4e1 - 0.3e1 / 0.2e1 * t75 * t2333 * t2309 + 0.3e1 / 0.2e1 * t75 * t2338 * t2314 - t75 * t2347 * t2322 / 0.4e1) * t52 * t201
  t2401 = t112 * t2200
  t2419 = (t2259 / 0.9e1 + t75 * t2318 * t2211 / 0.6e1 + t75 * t2338 * t2275 / 0.2e1 - t75 * t2347 * t2280 / 0.4e1) * t52 * t201
  t2420 = t112 * t2211
  t2444 = t2206 * t2307
  t2457 = 0.16e2 / 0.3e1 * t2202 * t606 + 0.185e3 / 0.864e3 * t2292 + 0.2e1 / 0.3e1 * t2262 * t35 * t24 * t2322 - 0.5e1 / 0.9e1 * t2202 * t598 * t908 - 0.160e3 / 0.81e2 * t2267 * t853 + 0.140e3 / 0.81e2 * t2203 * t591 - t105 * t106 * t2208 * t2211 / 0.108e3 - 0.36e2 * t2444 * t2334 + 0.8e1 * t2274 * t2343 - 0.11e2 / 0.648e3 * t105 * t837 * t2201 + 0.8e1 / 0.3e1 * t2261 * t116 * t254 * t2211 + 0.11e2 / 0.54e2 * t2296
  t2460 = t2198 * t2273
  t2461 = t2460 * t34
  t2486 = t2261 * t53
  t2504 = t2300 / 0.6e1 - t2304 / 0.12e2 - 0.4e1 * t2461 * t35 * t2263 * t2280 - t2209 * t2352 + 0.24e2 * t2206 * t2327 * t2329 + 0.6e1 * t2274 * t2339 + 0.56e2 / 0.27e2 * t2262 * t35 * t70 * t2211 + 0.4e1 * t2198 * t2307 * t34 * t35 * t24 * t2309 + 0.8e1 / 0.3e1 * t2461 * t35 * t46 * t2275 - 0.16e2 / 0.9e1 * t2486 * t55 * t125 * t2211 - 0.4e1 / 0.3e1 * t2460 * t53 * t55 * t58 * t2275 + 0.2e1 / 0.3e1 * t2486 * t55 * t58 * t2280 - 0.4e1 / 0.3e1 * t2262 * t35 * t46 * t2280
  t2506 = 0.1e1 / t2206
  t2541 = -0.11e2 / 0.216e3 * t2378 - t2381 / 0.24e2 - t2461 * t35 * t24 * t2275 + t2486 * t55 * t58 * t2211 / 0.3e1 - 0.2e1 / 0.3e1 * t2262 * t35 * t46 * t2211 + t2262 * t35 * t24 * t2280 / 0.2e1 + t105 * t106 * t2201 / 0.432e3 - 0.2e1 / 0.3e1 * t2202 * t120 + 0.4e1 / 0.9e1 * t2267 * t127 - 0.14e2 / 0.27e2 * t2203 * t130 - 0.6e1 * t2444 * t2309 + 0.6e1 * t2274 * t2314 - t2209 * t2322
  t2542 = t2541 * t2506
  t2547 = t384 * t482
  t2555 = t410 * t53
  t2568 = t376 * t422
  t2569 = t2568 * t34
  t2582 = 0.8e1 * t423 * t587 - 0.36e2 * t2547 * t579 + 0.16e2 / 0.3e1 * t380 * t606 + 0.11e2 / 0.54e2 * t553 + t557 / 0.6e1 - t560 / 0.12e2 + 0.2e1 / 0.3e1 * t2555 * t55 * t58 * t429 - 0.4e1 / 0.3e1 * t411 * t35 * t46 * t429 + 0.2e1 / 0.3e1 * t411 * t35 * t24 * t495 + 0.8e1 / 0.3e1 * t2569 * t35 * t46 * t424 - 0.16e2 / 0.9e1 * t2555 * t55 * t125 * t389 + 0.56e2 / 0.27e2 * t411 * t35 * t70 * t389
  t2623 = 0.4e1 * t376 * t482 * t34 * t35 * t24 * t484 - 0.5e1 / 0.9e1 * t380 * t598 * t908 - 0.4e1 / 0.3e1 * t2568 * t53 * t55 * t58 * t424 - t105 * t106 * t386 * t389 / 0.108e3 - 0.160e3 / 0.81e2 * t416 * t853 + 0.140e3 / 0.81e2 * t381 * t591 + 0.185e3 / 0.864e3 * t549 + 0.8e1 / 0.3e1 * t410 * t116 * t254 * t389 - 0.11e2 / 0.648e3 * t105 * t837 * t379 - 0.4e1 * t2569 * t35 * t412 * t429 + 0.24e2 * t384 * t573 * t575 + 0.6e1 * t423 * t583 - t387 * t616
  t2625 = 0.1e1 / t384
  t2628 = 0.96902277115443742137603943210562149050493484994510e-3 * (t2582 + t2623) * t2625 * t378
  t2660 = -0.11e2 / 0.216e3 * t468 - t472 / 0.24e2 - t2569 * t35 * t24 * t424 + t2555 * t55 * t58 * t389 / 0.3e1 - 0.2e1 / 0.3e1 * t411 * t35 * t46 * t389 + t411 * t35 * t24 * t429 / 0.2e1 + t105 * t106 * t379 / 0.432e3 - 0.2e1 / 0.3e1 * t380 * t120 + 0.4e1 / 0.9e1 * t416 * t127 - 0.14e2 / 0.27e2 * t381 * t130 - 0.6e1 * t2547 * t484 + 0.6e1 * t423 * t488 - t387 * t495
  t2661 = t2660 * t2625
  t2663 = 0.29070683134633122641281182963168644715148045498353e-2 * t2661 * t389
  t2664 = t431 * t2625
  t2666 = 0.29070683134633122641281182963168644715148045498353e-2 * t2664 * t429
  t2667 = t391 * t2625
  t2669 = 0.96902277115443742137603943210562149050493484994510e-3 * t2667 * t495
  t2670 = t2282 * t2506
  t2673 = 0.19191790123456790123456790123456790123456790123457e-2 * t2373 * t164 * t2200 + 0.51817833333333333333333333333333333333333333333333e-2 * t2400 * t2401 + 0.51817833333333333333333333333333333333333333333333e-2 * t2373 * t112 * t2280 + 0.10363566666666666666666666666666666666666666666667e-1 * t2419 * t2420 - 0.34545222222222222222222222222222222222222222222222e-2 * t2373 * t341 * t2211 + 0.22478670955426118383265363956423012380560746650571e-2 * (t2457 + t2504) * t2506 * t2200 + 0.67436012866278355149796091869269037141682239951713e-2 * t2542 * t2211 - t2628 - t2663 - t2666 - t2669 + 0.67436012866278355149796091869269037141682239951713e-2 * t2670 * t2280
  t2674 = t2213 * t2506
  t2680 = 0.67293247996835932040002738340668159062842697912856e-5 * t992 * t378 * t3 * t928
  t2682 = 0.64601518076962494758402628807041432700328989996340e-3 * t433 * t48
  t2686 = 0.48451138557721871068801971605281074525246742497255e-3 * t2660 * t393 * t403 * t26
  t2692 = 0.13255248558342256726771310131293653497824588692887e0 * t368 * t597 * t933 * t372 * t3 * t35
  t2696 = 0.48451138557721871068801971605281074525246742497255e-3 * t394 * t429 * t21 * t26
  t2700 = 0.32300759038481247379201314403520716350164494998170e-3 * t394 * t389 * t51 * t165
  t2703 = 0.32300759038481247379201314403520716350164494998170e-3 * t432 * t399 * t165
  t2705 = 0.64601518076962494758402628807041432700328989996340e-3 * t396 * t48
  t2707 = 0.43067678717974996505601752538027621800219326664227e-3 * t400 * t127
  t2709 = 0.50245625170970829256535377961032225433589214441597e-3 * t404 * t130
  t2712 = 0.96902277115443742137603943210562149050493484994510e-3 * t432 * t395 * t26
  t2719 = 0.53834598397468745632002190672534527250274158330283e-4 * t391 / t990 / t376 * t378 * t52 * t974
  t2720 = 0.22478670955426118383265363956423012380560746650571e-2 * t2674 * t2322 - t2680 + t2682 - t2686 - t2692 - t2696 - t2700 - t2703 + t2705 + t2707 - t2709 - t2712 - t2719
  t2725 = 0.44184161861140855755904367104312178326081962309624e-2 * t1059 * t782 * t956 * t1061
  t2729 = 0.39018876828196680983935418000403106518546430566246e0 * t1065 * t782 * t956 * t1067
  t2733 = 0.84385547540419669500411480416977015085609841896189e1 * t1053 * t782 * t956 * t1055
  t2735 = 0.1e1 / t2206 / t2198
  t2737 = t2200 * t21
  t2741 = t2282 * t2735
  t2742 = t2211 * t21
  t2765 = t2741 * t2737
  t2768 = t2213 * t2735
  t2769 = t2768 * t2737
  t2772 = t2200 * t51
  t2773 = t2768 * t2772
  t2776 = -t2725 + t2729 - t2733 + 0.11239335477713059191632681978211506190280373325286e-2 * t2541 * t2735 * t2737 * t26 + 0.22478670955426118383265363956423012380560746650571e-2 * t2741 * t2742 * t26 + 0.45987582308743803622461183496797526186096082279398e-2 * t2168 * t782 * t956 * t2170 - 0.24016506845914321304132055739789982808387563524773e0 * t2174 * t782 * t956 * t2176 + 0.30715972396278893812459343330735333491889005037766e1 * t2220 * t782 * t956 * t2222 + 0.12488150530792287990702979975790562433644859250317e-3 * t2213 / t2214 / t2198 * t2200 * t52 * t974 - 0.14985780636950745588843575970948674920373831100381e-2 * t2765 * t48 + 0.11655607162072802124656114644071191604735201966963e-2 * t2769 * t130 - 0.99905204246338303925623839806324499469158874002539e-3 * t2773 * t127
  t2777 = t2768 * t2742
  t2801 = t341 * t2200
  t2807 = t2184 * t5
  t2811 = t2192 * t5
  t2818 = t203 * t2211
  t2821 = t203 * t2280
  t2824 = -0.14985780636950745588843575970948674920373831100381e-2 * t2777 * t48 + 0.13796274692623141086738355049039257855828824683819e0 * t2127 * t597 * t933 * t2137 * t3 * t35 + 0.11239335477713059191632681978211506190280373325286e-2 * t2768 * t2280 * t21 * t26 + 0.74928903184753727944217879854743374601869155501904e-3 * t2768 * t2211 * t51 * t165 + 0.74928903184753727944217879854743374601869155501904e-3 * t2741 * t2772 * t165 + 0.15610188163490359988378724969738203042056074062897e-4 * t2216 * t2200 * t3 * t928 - 0.34545222222222222222222222222222222222222222222222e-2 * t2419 * t2801 + 0.14985780636950745588843575970948674920373831100381e-2 * t2768 * t2200 * t120 + 0.21269256817794009175388297367268855861069438054221e0 * t2807 * t520 * t2137 - 0.47604147498151601156404610484226573066625349129460e1 * t2811 * t520 * t2131 + 0.51817833333333333333333333333333333333333333333333e-2 * t2373 * t203 * t2322 + 0.15545350000000000000000000000000000000000000000000e-1 * t2400 * t2818 + 0.15545350000000000000000000000000000000000000000000e-1 * t2419 * t2821
  t2830 = -t1044 + t1052 - t1058 - t1064 + t1070 - t1076 - (t1194 + t1345 + t1470 + t1538 + t1585 + t1794 + t1919 + t2114) * t356 * t360 + (t2120 + t2180 + t2290 + t2362 + t2673 + t2720 + t2776 + t2824) * t356 * t360 + t2628 + t2663 + t2666 + t2669 + t2680
  t2831 = -t2682 + t2686 + t2692 + t2696 + t2700 + t2703 - t2705 - t2707 + t2709 + t2712 + t2719 + t2725 - t2729 + t2733
  t2835 = t463 * t515
  t2837 = t445 * t542
  t2840 = t536 * t71 * t538
  t2842 = -t2 * (t276 + t348) * t363 / 0.6e1 + 0.63625193080042832288502288630209536789558025725859e0 * t374 + 0.12920303615392498951680525761408286540065797999268e-2 * t397 + 0.43067678717974996505601752538027621800219326664227e-3 * t401 - 0.86135357435949993011203505076055243600438653328453e-3 * t405 + 0.12920303615392498951680525761408286540065797999268e-2 * t434 + 0.41454266666666666666666666666666666666666666666668e-1 * t447 + 0.82908533333333333333333333333333333333333333333336e-1 * t465 + 0.41454266666666666666666666666666666666666666666668e-1 * t503 - 0.19441031218901976532597921525897358463476063416235e0 * t510 + r0 * (t633 + t1035 + t2830 + t2831) + 0.27636177777777777777777777777777777777777777777779e-1 * t2835 - 0.92120592592592592592592592592592592592592592592596e-2 * t2837 + 0.73578453447456598426849645372188715149258983353495e1 * t2840
  t2845 = t1072 * t35 * t70 * t372
  t2847 = t993 * t48
  t2850 = t1060 * t126 * t1061
  t2853 = t1066 * t126 * t1067
  t2856 = t996 * t71 * t997
  t2859 = t1001 * t71 * t1002
  t2862 = t1054 * t126 * t1055
  t2866 = t1017 * t55 * t125 * t372
  t2895 = -0.14771245892498460899328183697246412229876591643939e-2 * t1576 * t26 - 0.14771245892498460899328183697246412229876591643939e-2 * t1579 * t26 - 0.49237486308328202997760612324154707432921972146465e-3 * t1582 * t165 + 0.88910333575777171977719901875252317902801704015380e-3 * t1566 * t26 + 0.29636777858592390659239967291750772634267234671793e-3 * t1570 * t165 + 0.88910333575777171977719901875252317902801704015380e-3 * t1487 * t26 + 0.98474972616656405995521224648309414865843944292929e-3 * t1573 * t48 - 0.59273555717184781318479934583501545268534469343587e-3 * t1586 * t48 + 0.11113791696972146497214987734406539737850213001922e-3 * t1347 * t48 + 0.80562219454059827832592271226246415504155858603354e-1 * t1403 * t126 * t1404 - 0.25806562167841887946265692242132428447574760112225e0 * t1358 * t126 * t1359 + 0.67135182878383189860493559355205346253463215502794e-2 * t1352 * t71 * t1353
  t2935 = -0.92166293456578171236663186579044387312767000400800e-2 * t1322 * t71 * t1323 + 0.40952635538151794597530661705910650058234104833627e0 * t1328 * t55 * t125 * t1095 - 0.47778074794510427030452438656895758401273122305897e0 * t1334 * t35 * t70 * t1095 - 0.32224887781623931133036908490498566201662343441341e0 * t1340 * t55 * t125 * t1118 + 0.37595702411894586321876393238914993901939400681566e0 * t1409 * t35 * t70 * t1118 - 0.18464057365623076124160229621558015287345739554924e-3 * t1318 * t48 - 0.55480664900582220034593859007405864987692769991566e-6 * t1308 * t126 * t1309 - 0.10238158884537948649382665426477662514558526208407e0 * t1370 * t126 * t1371 + 0.48160299392866510446696058166150924468483307284345e-3 * t1376 * t126 * t1377 - 0.85317990704482905411522211887313854287987718403392e-2 * t1206 * t71 * t1207 + 0.17200106926023753730962877916482473024458324030124e-4 * t1212 * t71 * t1213 + 0.20244826120247034261608782614550005883535036385819e0 * t1364 * t126 * t1365
  t2966 = -0.61428953307227691896295992558865975087351157250442e0 * t1108 * t254 * t1095 + 0.48337331672435896699555362735747849302493515162012e0 * t1115 * t254 * t1118 + 0.51817833333333333333333333333333333333333333333333e-2 * t1683 * t1759 - 0.69090444444444444444444444444444444444444444444446e-2 * t1787 * t1890 + 0.23030148148148148148148148148148148148148148148149e-2 * t1804 * t1791 - 0.14769740233244301769308583058145176175761907410615e0 * t1817 * t71 * t1118 + 0.10363566666666666666666666666666666666666666666667e-1 * t1758 * t1913 + 0.18769957954986239190534886615209047943357298048745e0 * t1765 * t71 * t1095 - 0.20727133333333333333333333333333333333333333333334e-1 * t1787 * t1667 - 0.10363566666666666666666666666666666666666666666667e-1 * t1666 * t1741 + 0.20276584560447197672065901047389765208808740088178e0 * t1670 * t71 * t1133 + 0.34545222222222222222222222222222222222222222222222e-2 * t1683 * t1762
  t2992 = 0.34545222222222222222222222222222222222222222222222e-2 * t1758 * t1916 - 0.11515074074074074074074074074074074074074074074074e-2 * t1683 * t1887 - 0.10363566666666666666666666666666666666666666666667e-1 * t1804 * t1788 - 0.37840235237252258208118331416261440653808312866271e-3 * t1883 * t71 * t1103 - 0.69090444444444444444444444444444444444444444444446e-2 * t1804 * t1808 + 0.51817833333333333333333333333333333333333333333333e-2 * t1912 * t1877 - 0.88627475354990765395969102183478473379259549863636e-2 * t2096 * t1229 + 0.53346200145466303186631941125151390741681022409228e-2 * t2108 * t1177 + 0.26673100072733151593315970562575695370840511204614e-2 * t2111 * t1300 + 0.26673100072733151593315970562575695370840511204614e-2 * t2105 * t1166 - 0.44313737677495382697984551091739236689629774931818e-2 * t2099 * t1251 - 0.44313737677495382697984551091739236689629774931818e-2 * t2102 * t1218
  t2998 = t2661 * t378
  t3000 = t2664 * t389
  t3002 = t2667 * t429
  t3023 = -0.15906298270010708072125572157552384197389506431465e0 * t374 - 0.32300759038481247379201314403520716350164494998170e-3 * t397 - 0.10766919679493749126400438134506905450054831666057e-3 * t401 + 0.21533839358987498252800876269013810900109663332113e-3 * t405 - 0.32300759038481247379201314403520716350164494998170e-3 * t434 + 0.74928903184753727944217879854743374601869155501904e-3 * t2777 * t26 + 0.24976301061584575981405959951581124867289718500635e-3 * t2773 * t165 + 0.74928903184753727944217879854743374601869155501904e-3 * t2765 * t26 - 0.49952602123169151962811919903162249734579437001269e-3 * t2769 * t48 + 0.51817833333333333333333333333333333333333333333333e-2 * t2373 * t2821 + 0.10363566666666666666666666666666666666666666666667e-1 * t2419 * t2818 + 0.93661128980942159930272349818429218252336444377380e-4 * t2217 * t48
  t3053 = 0.18429583437767336287475605998441200095133403022660e2 * t2221 * t126 * t2222 + 0.27592549385246282173476710098078515711657649367638e-1 * t2169 * t126 * t2170 - 0.14409904107548592782479233443873989685032538114864e1 * t2175 * t126 * t2176 + 0.22993791154371901811230591748398763093048041139699e-2 * t2185 * t71 * t2186 - 0.51463943241244974223140119442407106017973350410227e-1 * t2193 * t71 * t2194 - 0.11037019754098512869390684039231406284663059747056e0 * t2157 * t55 * t125 * t2137 + 0.12876523046448265014289131379103307332106903038231e0 * t2163 * t35 * t70 * t2137 - 0.10363566666666666666666666666666666666666666666667e-1 * t447 - 0.20727133333333333333333333333333333333333333333334e-1 * t465 - 0.10363566666666666666666666666666666666666666666667e-1 * t503 + 0.48602578047254941331494803814743396158690158540586e-1 * t510 + 0.51817833333333333333333333333333333333333333333333e-2 * t2400 * t2359
  t3075 = 0.11322067513073894329090826277329563323954137090250e1 * t2811 * t71 * t2131 - 0.11515074074074074074074074074074074074074074074074e-2 * t2373 * t2801 + 0.16555529631147769304086026058847109426994589620583e0 * t2136 * t254 * t2137 + 0.34545222222222222222222222222222222222222222222222e-2 * t2373 * t2420 - 0.50586340539618183984707301846477278804705690507337e-1 * t2807 * t71 * t2137 - 0.69090444444444444444444444444444444444444444444446e-2 * t2835 + 0.23030148148148148148148148148148148148148148148149e-2 * t2837 - 0.18394613361864149606712411343047178787314745838373e1 * t2840 - 0.12371565321119439611653222789207409931302949446695e0 * t2845 - 0.40375948798101559224001643004400895437705618747712e-4 * t2847 - 0.26510497116684513453542620262587306995649177385774e-1 * t2850 + 0.23411326096918008590361250800241863911127858339748e1 * t2853
  t3089 = t445 * t512
  t3093 = -0.22092080930570427877952183552156089163040981154812e-2 * t2856 + 0.83611878917564316394147324286578085396885208356242e-1 * t2859 - 0.50631328524251801700246888250186209051365905137714e2 * t2862 + 0.10604198846673805381417048105034922798259670954310e0 * t2866 - 0.96902277115443742137603943210562149050493484994510e-3 * t2998 - 0.19380455423088748427520788642112429810098696998902e-2 * t3000 + 0.44957341910852236766530727912846024761121493301142e-2 * t2670 * t2211 + 0.22478670955426118383265363956423012380560746650571e-2 * t2674 * t2280 - 0.96902277115443742137603943210562149050493484994510e-3 * t3002 + 0.22478670955426118383265363956423012380560746650571e-2 * t2542 * t2200 - 0.69090444444444444444444444444444444444444444444446e-2 * t3089 + 0.34545222222222222222222222222222222222222222222222e-2 * t2419 * t2401
  t3100 = 0.49486261284477758446612891156829639725211797786780e0 * t2845 + 0.16150379519240623689600657201760358175082247499085e-3 * t2847 + 0.10604198846673805381417048105034922798259670954310e0 * t2850 - 0.93645304387672034361445003200967455644511433358993e1 * t2853 + 0.88368323722281711511808734208624356652163924619249e-2 * t2856 - 0.33444751567025726557658929714631234158754083342496e0 * t2859 + 0.20252531409700720680098755300074483620546362055085e3 * t2862 - 0.42416795386695221525668192420139691193038683817240e0 * t2866 - 0.4e1 * (t2895 + t2935 + t2966 + t2992) * t356 * t360 + 0.38760910846177496855041577284224859620197393997804e-2 * t2998 + 0.77521821692354993710083154568449719240394787995608e-2 * t3000 + 0.38760910846177496855041577284224859620197393997804e-2 * t3002 + 0.4e1 * (t3023 + t3053 + t3075 + t3093) * t356 * t360 + 0.27636177777777777777777777777777777777777777777779e-1 * t3089
  v4rho4_0_ = t2842 + t3100

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t23 = t4 * t6
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t4 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t1
  t31 = t3 * t6
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t40 = t1 ** 2
  t42 = 0.1e1 / t3
  t43 = (-t4 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t5 * t8
  t45 = t44 * t18
  t46 = t43 * t45
  t47 = 0.20727133333333333333333333333333333333333333333334e-1 * t46
  t48 = t16 + 0.372744e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t1
  t54 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t58 = t52 * t31 * t10 * t55
  t59 = 0.79531491350053540360627860787761920986947532157324e-1 * t58
  t60 = t16 / 0.2e1
  t61 = t60 + 0.10498e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t72 = t71 * t18
  t73 = 0.19380455423088748427520788642112429810098696998902e-2 * t72
  t74 = jnp.pi ** 2
  t75 = 0.1e1 / t74
  t77 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t78 = 0.1e1 / t77
  t82 = t77 ** 2
  t83 = 0.1e1 / t82
  t84 = t12 * t83
  t86 = -t28 - 0.89029166666666666666666666666666666666666666666667e-1 * t33
  t92 = (-t4 * t11 * t78 / 0.12e2 - t23 * t84 * t86 / 0.4e1) * t40 * t42
  t93 = t44 * t77
  t96 = t16 + 0.106835e1
  t97 = t96 ** 2
  t98 = 0.1e1 / t97
  t100 = t98 * t29 * t1
  t102 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t98
  t103 = 0.1e1 / t102
  t108 = t60 + 0.228344e0
  t109 = t108 * t78
  t110 = t109 * t29
  t113 = t108 ** 2
  t114 = t113 * t83
  t116 = -t110 * t27 / 0.6e1 - t114 * t86
  t117 = 0.1e1 / t113
  t118 = t116 * t117
  t122 = t75 * (t92 * t93 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t100 * t31 * t10 * t103 + 0.21608710360898267021763215722876235716176892439270e-1 * t118 * t77)
  t123 = r0 - r1
  t124 = 0.1e1 / t7
  t125 = t123 * t124
  t126 = 0.1e1 + t125
  t127 = t126 <= f.p.zeta_threshold
  t128 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t129 = t128 * f.p.zeta_threshold
  t130 = t126 ** (0.1e1 / 0.3e1)
  t132 = f.my_piecewise3(t127, t129, t130 * t126)
  t133 = 0.1e1 - t125
  t134 = t133 <= f.p.zeta_threshold
  t135 = t133 ** (0.1e1 / 0.3e1)
  t137 = f.my_piecewise3(t134, t129, t135 * t133)
  t138 = t132 + t137 - 0.2e1
  t139 = t122 * t138
  t140 = 2 ** (0.1e1 / 0.3e1)
  t141 = t140 - 0.1e1
  t143 = 0.1e1 / t141 / 0.2e1
  t144 = t123 ** 2
  t145 = t144 ** 2
  t146 = t7 ** 2
  t147 = t146 ** 2
  t148 = 0.1e1 / t147
  t151 = t143 * (-t145 * t148 + 0.1e1)
  t152 = 0.9e1 * t141
  t153 = t151 * t152
  t155 = t139 * t153 / 0.12e2
  t159 = jnp.log(t4 * t13 * t78 / 0.4e1)
  t162 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t96)
  t165 = jnp.log(t113 * t78)
  t168 = t75 * (t159 + 0.32323836906055067299704130765928097906535029214058e0 * t162 + 0.21608710360898267021763215722876235716176892439270e-1 * t165)
  t169 = 0.1e1 / t146
  t170 = t123 * t169
  t171 = t124 - t170
  t174 = f.my_piecewise3(t127, 0, 0.4e1 / 0.3e1 * t130 * t171)
  t175 = -t171
  t178 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t175)
  t179 = t174 + t178
  t180 = t168 * t179
  t181 = t180 * t153
  t183 = t168 * t138
  t184 = t144 * t123
  t185 = t184 * t148
  t187 = 0.1e1 / t147 / t7
  t188 = t145 * t187
  t191 = t143 * (-0.4e1 * t185 + 0.4e1 * t188)
  t192 = t191 * t152
  t193 = t183 * t192
  t196 = t15 + 0.10061550000000000000000000000000000000000000000000e2 * t16 + 0.101578e3
  t197 = 0.1e1 / t196
  t201 = t196 ** 2
  t202 = 0.1e1 / t201
  t203 = t12 * t202
  t205 = -t28 - 0.16769250000000000000000000000000000000000000000000e1 * t33
  t211 = (-t4 * t11 * t197 / 0.12e2 - t23 * t203 * t205 / 0.4e1) * t40 * t42
  t212 = t44 * t196
  t215 = t16 + 0.201231e2
  t216 = t215 ** 2
  t217 = 0.1e1 / t216
  t219 = t217 * t29 * t1
  t221 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t217
  t222 = 0.1e1 / t221
  t227 = t60 + 0.743294e0
  t228 = t227 * t197
  t229 = t228 * t29
  t232 = t227 ** 2
  t233 = t232 * t202
  t235 = -t229 * t27 / 0.6e1 - t233 * t205
  t236 = 0.1e1 / t232
  t237 = t235 * t236
  t241 = t15 + 0.65360000000000000000000000000000000000000000000000e1 * t16 + 0.427198e2
  t242 = 0.1e1 / t241
  t246 = t241 ** 2
  t247 = 0.1e1 / t246
  t248 = t12 * t247
  t250 = -t28 - 0.10893333333333333333333333333333333333333333333333e1 * t33
  t256 = (-t4 * t11 * t242 / 0.12e2 - t23 * t248 * t250 / 0.4e1) * t40 * t42
  t257 = t44 * t241
  t260 = t16 + 0.130720e2
  t261 = t260 ** 2
  t262 = 0.1e1 / t261
  t264 = t262 * t29 * t1
  t266 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t262
  t267 = 0.1e1 / t266
  t272 = t60 + 0.409286e0
  t273 = t272 * t242
  t274 = t273 * t29
  t277 = t272 ** 2
  t278 = t277 * t247
  t280 = -t274 * t27 / 0.6e1 - t278 * t250
  t281 = 0.1e1 / t277
  t282 = t280 * t281
  t285 = 0.51817833333333333333333333333333333333333333333333e-2 * t211 * t212 + 0.12084332918108974174888840683936962325623378790503e0 * t219 * t31 * t10 * t222 + 0.26673100072733151593315970562575695370840511204614e-2 * t237 * t196 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t257 - 0.15357238326806922974073998139716493771837789312610e0 * t264 * t31 * t10 * t267 - 0.44313737677495382697984551091739236689629774931818e-2 * t282 * t241
  t286 = t285 * t138
  t288 = 0.2e1 * t286 * t151
  t292 = jnp.log(t4 * t13 * t197 / 0.4e1)
  t296 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t215)
  t299 = jnp.log(t232 * t197)
  t304 = jnp.log(t4 * t13 * t242 / 0.4e1)
  t308 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t260)
  t311 = jnp.log(t277 * t242)
  t313 = 0.1554535e-1 * t292 + 0.61881802979060631480216141626488805225499304723700e0 * t296 + 0.26673100072733151593315970562575695370840511204614e-2 * t299 - 0.310907e-1 * t304 - 0.20521972937837502661166379517614390730124411627871e2 * t308 - 0.44313737677495382697984551091739236689629774931818e-2 * t311
  t314 = t313 * t179
  t315 = t314 * t151
  t317 = t313 * t138
  t318 = t317 * t191
  t321 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t322 = 0.1e1 / t321
  t326 = t321 ** 2
  t327 = 0.1e1 / t326
  t328 = t12 * t327
  t330 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t336 = (-t4 * t11 * t322 / 0.12e2 - t23 * t328 * t330 / 0.4e1) * t40 * t42
  t337 = t44 * t321
  t340 = t16 + 0.706042e1
  t341 = t340 ** 2
  t342 = 0.1e1 / t341
  t344 = t342 * t29 * t1
  t346 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t342
  t347 = 0.1e1 / t346
  t352 = t60 + 0.32500e0
  t353 = t352 * t322
  t354 = t353 * t29
  t357 = t352 ** 2
  t358 = t357 * t327
  t360 = -t354 * t27 / 0.6e1 - t358 * t330
  t361 = 0.1e1 / t357
  t362 = t360 * t361
  t368 = 0.51817833333333333333333333333333333333333333333333e-2 * t336 * t337 + 0.41388824077869423260215065147117773567486474051458e-1 * t344 * t31 * t10 * t347 + 0.22478670955426118383265363956423012380560746650571e-2 * t362 * t321 - 0.10363566666666666666666666666666666666666666666667e-1 * t46 - 0.39765745675026770180313930393880960493473766078662e-1 * t58 - 0.96902277115443742137603943210562149050493484994510e-3 * t72
  t371 = 0.2e1 * t368 * t138 * t143
  t375 = jnp.log(t4 * t13 * t322 / 0.4e1)
  t379 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t340)
  t382 = jnp.log(t357 * t322)
  t387 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t391 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t48)
  t394 = jnp.log(t66 * t19)
  t396 = 0.1554535e-1 * t375 + 0.52491393169780936217021346072241076933841385384497e-1 * t379 + 0.22478670955426118383265363956423012380560746650571e-2 * t382 - 0.310907e-1 * t387 - 0.38783294878113014394824731224995739188004877421366e-1 * t391 - 0.96902277115443742137603943210562149050493484994510e-3 * t394
  t398 = t396 * t179 * t143
  t400 = t139 * t192
  t402 = t130 ** 2
  t403 = 0.1e1 / t402
  t404 = t171 ** 2
  t408 = 0.1e1 / t146 / t7
  t409 = t123 * t408
  t411 = -0.2e1 * t169 + 0.2e1 * t409
  t415 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t403 * t404 + 0.4e1 / 0.3e1 * t130 * t411)
  t416 = t135 ** 2
  t417 = 0.1e1 / t416
  t418 = t175 ** 2
  t425 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t417 * t418 - 0.4e1 / 0.3e1 * t135 * t411)
  t426 = t415 + t425
  t433 = 0.12e2 * t144 * t148
  t435 = 0.32e2 * t184 * t187
  t439 = 0.20e2 * t145 / t147 / t146
  t441 = t143 * (-t433 + t435 - t439)
  t446 = 0.1e1 / t8 / t146
  t447 = t6 * t446
  t449 = t4 * t447 * t78
  t456 = 0.1e1 / t82 / t77
  t458 = t86 ** 2
  t462 = t4 * t447
  t463 = t462 / 0.9e1
  t465 = 0.1e1 / t16 / t14
  t467 = t3 ** 2
  t468 = t467 * t5
  t469 = t8 ** 2
  t471 = 0.1e1 / t469 / t146
  t473 = t465 * t40 * t468 * t471
  t476 = t30 * t31 * t446
  t478 = t463 - 0.59352777777777777777777777777777777777777777777778e-1 * t473 + 0.11870555555555555555555555555555555555555555555556e0 * t476
  t488 = t5 / t469
  t512 = t97 ** 2
  t517 = t102 ** 2
  t532 = t40 * t467 * t5 * t471
  t558 = t75 * ((t449 / 0.9e1 + t23 * t10 * t83 * t86 / 0.6e1 + t23 * t12 * t456 * t458 / 0.2e1 - t23 * t84 * t478 / 0.4e1) * t40 * t42 * t93 / 0.3e1 + t92 * t488 * t77 / 0.9e1 + t92 * t44 * t86 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 / t97 / t96 * t1 * t3 * t447 * t103 + 0.24034827266594839017845905156788576090902848675181e0 * t98 * t465 * t40 * t468 * t471 * t103 - 0.48069654533189678035691810313577152181805697350363e0 * t100 * t31 * t446 * t103 - 0.53818578849327899137148388724908565251436770250246e1 / t512 / t96 * t1 * t3 * t447 / t517 + 0.21608710360898267021763215722876235716176892439270e-1 * (t449 / 0.72e2 + t108 * t83 * t30 * t31 * t10 * t86 / 0.3e1 - t109 * t465 * t532 / 0.9e1 + 0.2e1 / 0.9e1 * t110 * t462 + 0.2e1 * t113 * t456 * t458 - t114 * t478) * t117 * t77 + 0.36014517268163778369605359538127059526961487398783e-2 * t116 / t113 / t108 * t77 * t29 * t27 + 0.21608710360898267021763215722876235716176892439270e-1 * t118 * t86) * t138 * t153 / 0.24e2
  t560 = t122 * t179 * t153
  t563 = t4 * t447 * t19
  t570 = 0.1e1 / t24 / t18
  t572 = t35 ** 2
  t578 = t463 - 0.20708000000000000000000000000000000000000000000000e0 * t473 + 0.41416000000000000000000000000000000000000000000000e0 * t476
  t586 = 0.10363566666666666666666666666666666666666666666667e-1 * (t563 / 0.9e1 + t23 * t10 * t25 * t35 / 0.6e1 + t23 * t12 * t570 * t572 / 0.2e1 - t23 * t26 * t578 / 0.4e1) * t40 * t42 * t45
  t589 = 0.34545222222222222222222222222222222222222222222223e-2 * t43 * t488 * t18
  t592 = 0.10363566666666666666666666666666666666666666666667e-1 * t43 * t44 * t35
  t599 = 0.13255248558342256726771310131293653497824588692887e-1 / t49 / t48 * t1 * t3 * t447 * t55
  t600 = t49 ** 2
  t605 = t54 ** 2
  t609 = 0.50167127350538589836488394571946851238131125013746e0 / t600 / t48 * t1 * t3 * t447 / t605
  t615 = 0.26510497116684513453542620262587306995649177385775e-1 * t50 * t465 * t40 * t468 * t471 * t55
  t616 = -t400 / 0.12e2 - t168 * t426 * t153 / 0.24e2 - t180 * t192 / 0.12e2 - t183 * t441 * t152 / 0.24e2 - t558 - t560 / 0.12e2 + t586 + t589 + t592 + t599 - t609 + t615
  t620 = 0.53020994233369026907085240525174613991298354771549e-1 * t52 * t31 * t446 * t55
  t640 = 0.96902277115443742137603943210562149050493484994510e-3 * (t563 / 0.72e2 + t61 * t25 * t30 * t31 * t10 * t35 / 0.3e1 - t62 * t465 * t532 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t462 + 0.2e1 * t66 * t570 * t572 - t67 * t578) * t70 * t18
  t642 = 0.96902277115443742137603943210562149050493484994510e-3 * t71 * t35
  t644 = t4 * t447 * t322
  t651 = 0.1e1 / t326 / t321
  t653 = t330 ** 2
  t659 = t463 - 0.39224555555555555555555555555555555555555555555555e0 * t473 + 0.78449111111111111111111111111111111111111111111110e0 * t476
  t691 = t341 ** 2
  t696 = t346 ** 2
  t736 = 0.16150379519240623689600657201760358175082247499085e-3 * t69 / t66 / t61 * t18 * t29 * t27
  t737 = 0.51817833333333333333333333333333333333333333333333e-2 * (t644 / 0.9e1 + t23 * t10 * t327 * t330 / 0.6e1 + t23 * t12 * t651 * t653 / 0.2e1 - t23 * t328 * t659 / 0.4e1) * t40 * t42 * t337 + 0.17272611111111111111111111111111111111111111111111e-2 * t336 * t488 * t321 + 0.51817833333333333333333333333333333333333333333333e-2 * t336 * t44 * t330 + 0.13796274692623141086738355049039257855828824683819e-1 / t341 / t340 * t1 * t3 * t447 * t347 + 0.27592549385246282173476710098078515711657649367639e-1 * t342 * t465 * t40 * t468 * t471 * t347 - 0.55185098770492564346953420196157031423315298735277e-1 * t344 * t31 * t446 * t347 - 0.30878365944746984533884071665444263610784010246137e0 / t691 / t340 * t1 * t3 * t447 / t696 + 0.22478670955426118383265363956423012380560746650571e-2 * (t644 / 0.72e2 + t352 * t327 * t30 * t31 * t10 * t330 / 0.3e1 - t353 * t465 * t532 / 0.9e1 + 0.2e1 / 0.9e1 * t354 * t462 + 0.2e1 * t357 * t651 * t653 - t358 * t659) * t361 * t321 + 0.37464451592376863972108939927371687300934577750952e-3 * t360 / t357 / t352 * t321 * t29 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t362 * t330 - t586 - t589 - t592 - t599 - t615 + t620 + t609 - t640 - t736 - t642
  t739 = t737 * t138 * t143
  t741 = t368 * t179 * t143
  t746 = t285 * t179 * t151
  t753 = t286 * t191
  t756 = t4 * t447 * t197
  t763 = 0.1e1 / t201 / t196
  t765 = t205 ** 2
  t771 = t463 - 0.11179500000000000000000000000000000000000000000000e1 * t473 + 0.22359000000000000000000000000000000000000000000000e1 * t476
  t803 = t216 ** 2
  t808 = t221 ** 2
  t843 = t4 * t447 * t242
  t850 = 0.1e1 / t246 / t241
  t852 = t250 ** 2
  t858 = t463 - 0.72622222222222222222222222222222222222222222222220e0 * t473 + 0.14524444444444444444444444444444444444444444444444e1 * t476
  t890 = t261 ** 2
  t895 = t266 ** 2
  t929 = 0.51817833333333333333333333333333333333333333333333e-2 * (t756 / 0.9e1 + t23 * t10 * t202 * t205 / 0.6e1 + t23 * t12 * t763 * t765 / 0.2e1 - t23 * t203 * t771 / 0.4e1) * t40 * t42 * t212 + 0.17272611111111111111111111111111111111111111111111e-2 * t211 * t488 * t196 + 0.51817833333333333333333333333333333333333333333333e-2 * t211 * t44 * t205 + 0.40281109727029913916296135613123207752077929301677e-1 / t216 / t215 * t1 * t3 * t447 * t222 + 0.80562219454059827832592271226246415504155858603353e-1 * t217 * t465 * t40 * t468 * t471 * t222 - 0.16112443890811965566518454245249283100831171720671e0 * t219 * t31 * t446 * t222 - 0.55299776073946902741997911947426632387660200240483e-1 / t803 / t215 * t1 * t3 * t447 / t808 + 0.26673100072733151593315970562575695370840511204614e-2 * (t756 / 0.72e2 + t227 * t202 * t30 * t31 * t10 * t205 / 0.3e1 - t228 * t465 * t532 / 0.9e1 + 0.2e1 / 0.9e1 * t229 * t462 + 0.2e1 * t232 * t763 * t765 - t233 * t771) * t236 * t196 + 0.44455166787888585988859950937626158951400852007690e-3 * t235 / t232 / t227 * t196 * t29 * t27 + 0.26673100072733151593315970562575695370840511204614e-2 * t237 * t205 - 0.10363566666666666666666666666666666666666666666667e-1 * (t843 / 0.9e1 + t23 * t10 * t247 * t250 / 0.6e1 + t23 * t12 * t850 * t852 / 0.2e1 - t23 * t248 * t858 / 0.4e1) * t40 * t42 * t257 - 0.34545222222222222222222222222222222222222222222223e-2 * t256 * t488 * t241 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t44 * t250 - 0.51190794422689743246913327132388312572792631042033e-1 / t261 / t260 * t1 * t3 * t447 * t267 - 0.10238158884537948649382665426477662514558526208407e0 * t262 * t465 * t40 * t468 * t471 * t267 + 0.20476317769075897298765330852955325029117052416813e0 * t264 * t31 * t446 * t267 + 0.10320064155614252238577726749889483814674994418074e-3 / t890 / t260 * t1 * t3 * t447 / t895 - 0.44313737677495382697984551091739236689629774931818e-2 * (t843 / 0.72e2 + t272 * t247 * t30 * t31 * t10 * t250 / 0.3e1 - t273 * t465 * t532 / 0.9e1 + 0.2e1 / 0.9e1 * t274 * t462 + 0.2e1 * t277 * t850 * t852 - t278 * t858) * t281 * t241 - 0.73856229462492304496640918486232061149382958219697e-3 * t280 / t277 / t272 * t241 * t29 * t27 - 0.44313737677495382697984551091739236689629774931818e-2 * t282 * t250
  t931 = t929 * t138 * t151
  t932 = t396 * t426 * t143 - t313 * t426 * t151 - 0.2e1 * t314 * t191 - t317 * t441 - t620 + t640 + t642 + t736 + t739 + 0.2e1 * t741 - 0.2e1 * t746 - 0.2e1 * t753 - t931
  d11 = t47 + t59 + t73 - t155 - t181 / 0.12e2 - t193 / 0.12e2 - t288 - 0.2e1 * t315 - 0.2e1 * t318 + t371 + 0.2e1 * t398 + t7 * (t616 + t932)
  t937 = -t124 - t170
  t940 = f.my_piecewise3(t127, 0, 0.4e1 / 0.3e1 * t130 * t937)
  t941 = -t937
  t944 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t941)
  t945 = t940 + t944
  t946 = t168 * t945
  t947 = t946 * t153
  t951 = t143 * (0.4e1 * t185 + 0.4e1 * t188)
  t952 = t951 * t152
  t953 = t183 * t952
  t955 = t313 * t945
  t956 = t955 * t151
  t957 = t317 * t951
  t959 = t396 * t945 * t143
  t961 = t122 * t945 * t153
  t970 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t403 * t937 * t171 + 0.8e1 / 0.3e1 * t130 * t123 * t408)
  t978 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t417 * t941 * t175 - 0.8e1 / 0.3e1 * t135 * t123 * t408)
  t979 = t970 + t978
  t985 = t139 * t952
  t990 = t143 * (t433 - t439)
  t996 = -t961 / 0.24e2 - t168 * t979 * t153 / 0.24e2 - t946 * t192 / 0.24e2 - t985 / 0.24e2 - t180 * t952 / 0.24e2 - t183 * t990 * t152 / 0.24e2 - t400 / 0.24e2 - t558 - t560 / 0.24e2 + t586 + t589 + t592 + t599 - t609 + t615 - t620
  t998 = t285 * t945 * t151
  t999 = t286 * t951
  t1006 = t368 * t945 * t143
  t1009 = t396 * t979 * t143 - t313 * t979 * t151 - t955 * t191 - t314 * t951 - t317 * t990 + t1006 + t640 + t642 + t736 + t739 + t741 - t746 - t753 - t931 - t998 - t999
  d12 = t47 + t59 + t73 - t155 - t181 / 0.24e2 - t193 / 0.24e2 - t288 - t315 - t318 + t371 + t398 - t947 / 0.24e2 - t953 / 0.24e2 - t956 - t957 + t959 + t7 * (t996 + t1009)
  t1020 = t143 * (-t433 - t435 - t439)
  t1024 = t937 ** 2
  t1028 = 0.2e1 * t169 + 0.2e1 * t409
  t1032 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t403 * t1024 + 0.4e1 / 0.3e1 * t130 * t1028)
  t1033 = t941 ** 2
  t1040 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t417 * t1033 - 0.4e1 / 0.3e1 * t135 * t1028)
  t1041 = t1032 + t1040
  t1047 = -t961 / 0.12e2 - t985 / 0.12e2 - t558 + t586 + t589 + t592 + t599 - t609 - t183 * t1020 * t152 / 0.24e2 - t168 * t1041 * t153 / 0.24e2 - t946 * t952 / 0.12e2 + t615
  t1058 = t396 * t1041 * t143 - t313 * t1041 * t151 - t317 * t1020 - 0.2e1 * t955 * t951 + 0.2e1 * t1006 - t620 + t640 + t642 + t736 + t739 - t931 - 0.2e1 * t998 - 0.2e1 * t999
  d22 = t47 + t59 + t73 - t155 - t947 / 0.12e2 - t953 / 0.12e2 - t288 - 0.2e1 * t956 - 0.2e1 * t957 + t371 + 0.2e1 * t959 + t7 * (t1047 + t1058)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / jnp.pi
  t4 = t3 ** (0.1e1 / 0.3e1)
  t5 = t2 * t4
  t6 = 4 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** 2
  t9 = t1 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = t7 * t11
  t13 = 0.1e1 / t9
  t14 = t7 * t13
  t15 = t5 * t14
  t16 = t15 / 0.4e1
  t17 = jnp.sqrt(t15)
  t19 = t16 + 0.10061550000000000000000000000000000000000000000000e2 * t17 + 0.101578e3
  t20 = 0.1e1 / t19
  t22 = t5 * t12 * t20
  t24 = t5 * t7
  t26 = 0.1e1 / t9 / t1
  t27 = t19 ** 2
  t28 = 0.1e1 / t27
  t29 = t26 * t28
  t30 = t7 * t26
  t31 = t5 * t30
  t32 = t31 / 0.12e2
  t33 = 0.1e1 / t17
  t34 = t33 * t2
  t35 = t4 * t7
  t37 = t34 * t35 * t26
  t39 = -t32 - 0.16769250000000000000000000000000000000000000000000e1 * t37
  t44 = 0.1e1 / t27 / t19
  t45 = t13 * t44
  t46 = t39 ** 2
  t50 = t13 * t28
  t51 = t5 * t12
  t52 = t51 / 0.9e1
  t54 = 0.1e1 / t17 / t15
  t55 = t2 ** 2
  t56 = t54 * t55
  t57 = t4 ** 2
  t58 = t57 * t6
  t59 = t9 ** 2
  t61 = 0.1e1 / t59 / t8
  t63 = t56 * t58 * t61
  t66 = t34 * t35 * t11
  t68 = t52 - 0.11179500000000000000000000000000000000000000000000e1 * t63 + 0.22359000000000000000000000000000000000000000000000e1 * t66
  t74 = 0.1e1 / t4
  t75 = (t22 / 0.9e1 + t24 * t29 * t39 / 0.6e1 + t24 * t45 * t46 / 0.2e1 - t24 * t50 * t68 / 0.4e1) * t55 * t74
  t76 = t6 * t9
  t77 = t76 * t19
  t88 = (-t5 * t30 * t20 / 0.12e2 - t24 * t50 * t39 / 0.4e1) * t55 * t74
  t90 = t6 / t59
  t91 = t90 * t19
  t94 = t76 * t39
  t97 = t17 + 0.201231e2
  t98 = t97 ** 2
  t101 = 0.1e1 / t98 / t97 * t2
  t102 = t101 * t4
  t103 = 0.1e1 / t98
  t105 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t103
  t106 = 0.1e1 / t105
  t111 = t103 * t54 * t55
  t117 = t103 * t33 * t2
  t122 = t98 ** 2
  t125 = 0.1e1 / t122 / t97 * t2
  t126 = t125 * t4
  t127 = t105 ** 2
  t128 = 0.1e1 / t127
  t133 = t17 / 0.2e1
  t134 = t133 + 0.743294e0
  t135 = t134 * t28
  t136 = t135 * t34
  t141 = t134 * t20
  t142 = t141 * t54
  t143 = t55 * t57
  t145 = t143 * t6 * t61
  t148 = t141 * t33
  t151 = t134 ** 2
  t152 = t151 * t44
  t155 = t151 * t28
  t157 = t22 / 0.72e2 + t136 * t35 * t26 * t39 / 0.3e1 - t142 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t148 * t51 + 0.2e1 * t152 * t46 - t155 * t68
  t158 = 0.1e1 / t151
  t159 = t157 * t158
  t165 = -t148 * t31 / 0.6e1 - t155 * t39
  t167 = 0.1e1 / t151 / t134
  t168 = t165 * t167
  t169 = t19 * t33
  t170 = t168 * t169
  t173 = t165 * t158
  t177 = t16 + 0.65360000000000000000000000000000000000000000000000e1 * t17 + 0.427198e2
  t178 = 0.1e1 / t177
  t180 = t5 * t12 * t178
  t182 = t177 ** 2
  t183 = 0.1e1 / t182
  t184 = t26 * t183
  t186 = -t32 - 0.10893333333333333333333333333333333333333333333333e1 * t37
  t191 = 0.1e1 / t182 / t177
  t192 = t13 * t191
  t193 = t186 ** 2
  t197 = t13 * t183
  t200 = t52 - 0.72622222222222222222222222222222222222222222222220e0 * t63 + 0.14524444444444444444444444444444444444444444444444e1 * t66
  t206 = (t180 / 0.9e1 + t24 * t184 * t186 / 0.6e1 + t24 * t192 * t193 / 0.2e1 - t24 * t197 * t200 / 0.4e1) * t55 * t74
  t207 = t76 * t177
  t218 = (-t5 * t30 * t178 / 0.12e2 - t24 * t197 * t186 / 0.4e1) * t55 * t74
  t219 = t90 * t177
  t222 = t76 * t186
  t225 = t17 + 0.130720e2
  t226 = t225 ** 2
  t229 = 0.1e1 / t226 / t225 * t2
  t230 = t229 * t4
  t231 = 0.1e1 / t226
  t233 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t231
  t234 = 0.1e1 / t233
  t239 = t231 * t54 * t55
  t245 = t231 * t33 * t2
  t250 = t226 ** 2
  t253 = 0.1e1 / t250 / t225 * t2
  t254 = t253 * t4
  t255 = t233 ** 2
  t256 = 0.1e1 / t255
  t261 = t133 + 0.409286e0
  t262 = t261 * t183
  t263 = t262 * t34
  t268 = t261 * t178
  t269 = t268 * t54
  t272 = t268 * t33
  t275 = t261 ** 2
  t276 = t275 * t191
  t279 = t275 * t183
  t281 = t180 / 0.72e2 + t263 * t35 * t26 * t186 / 0.3e1 - t269 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t272 * t51 + 0.2e1 * t276 * t193 - t279 * t200
  t282 = 0.1e1 / t275
  t283 = t281 * t282
  t289 = -t272 * t31 / 0.6e1 - t279 * t186
  t291 = 0.1e1 / t275 / t261
  t292 = t289 * t291
  t293 = t177 * t33
  t294 = t292 * t293
  t297 = t289 * t282
  t300 = 0.51817833333333333333333333333333333333333333333333e-2 * t75 * t77 + 0.17272611111111111111111111111111111111111111111111e-2 * t88 * t91 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t94 + 0.40281109727029913916296135613123207752077929301677e-1 * t102 * t12 * t106 + 0.80562219454059827832592271226246415504155858603353e-1 * t111 * t58 * t61 * t106 - 0.16112443890811965566518454245249283100831171720671e0 * t117 * t35 * t11 * t106 - 0.55299776073946902741997911947426632387660200240483e-1 * t126 * t12 * t128 + 0.26673100072733151593315970562575695370840511204614e-2 * t159 * t19 + 0.44455166787888585988859950937626158951400852007690e-3 * t170 * t31 + 0.26673100072733151593315970562575695370840511204614e-2 * t173 * t39 - 0.10363566666666666666666666666666666666666666666667e-1 * t206 * t207 - 0.34545222222222222222222222222222222222222222222223e-2 * t218 * t219 - 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t222 - 0.51190794422689743246913327132388312572792631042033e-1 * t230 * t12 * t234 - 0.10238158884537948649382665426477662514558526208407e0 * t239 * t58 * t61 * t234 + 0.20476317769075897298765330852955325029117052416813e0 * t245 * t35 * t11 * t234 + 0.10320064155614252238577726749889483814674994418074e-3 * t254 * t12 * t256 - 0.44313737677495382697984551091739236689629774931818e-2 * t283 * t177 - 0.73856229462492304496640918486232061149382958219697e-3 * t294 * t31 - 0.44313737677495382697984551091739236689629774931818e-2 * t297 * t186
  t301 = r0 - r1
  t302 = 0.1e1 / t1
  t303 = t301 * t302
  t304 = 0.1e1 + t303
  t305 = t304 <= f.p.zeta_threshold
  t306 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t307 = t306 * f.p.zeta_threshold
  t308 = t304 ** (0.1e1 / 0.3e1)
  t310 = f.my_piecewise3(t305, t307, t308 * t304)
  t311 = 0.1e1 - t303
  t312 = t311 <= f.p.zeta_threshold
  t313 = t311 ** (0.1e1 / 0.3e1)
  t315 = f.my_piecewise3(t312, t307, t313 * t311)
  t316 = t310 + t315 - 0.2e1
  t317 = t300 * t316
  t318 = 2 ** (0.1e1 / 0.3e1)
  t319 = t318 - 0.1e1
  t321 = 0.1e1 / t319 / 0.2e1
  t322 = t301 ** 2
  t323 = t322 * t301
  t324 = t8 ** 2
  t325 = 0.1e1 / t324
  t327 = t322 ** 2
  t329 = 0.1e1 / t324 / t1
  t333 = t321 * (-0.4e1 * t323 * t325 + 0.4e1 * t327 * t329)
  t336 = 0.1e1 / t8
  t338 = -t301 * t336 + t302
  t341 = f.my_piecewise3(t305, 0, 0.4e1 / 0.3e1 * t308 * t338)
  t342 = -t338
  t345 = f.my_piecewise3(t312, 0, 0.4e1 / 0.3e1 * t313 * t342)
  t346 = t341 + t345
  t350 = t321 * (-t327 * t325 + 0.1e1)
  t369 = 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t77 + 0.12084332918108974174888840683936962325623378790503e0 * t117 * t35 * t26 * t106 + 0.26673100072733151593315970562575695370840511204614e-2 * t173 * t19 - 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t207 - 0.15357238326806922974073998139716493771837789312610e0 * t245 * t35 * t26 * t234 - 0.44313737677495382697984551091739236689629774931818e-2 * t297 * t177
  t370 = t369 * t316
  t376 = 0.1e1 / t324 / t8
  t380 = t321 * (-0.12e2 * t322 * t325 + 0.32e2 * t323 * t329 - 0.20e2 * t327 * t376)
  t386 = jnp.log(t5 * t14 * t20 / 0.4e1)
  t390 = jnp.atan(0.11716852777089929792201907797022178188779527234376e1 / t97)
  t393 = jnp.log(t151 * t20)
  t398 = jnp.log(t5 * t14 * t178 / 0.4e1)
  t402 = jnp.atan(0.44899888641287296627004984787798591621072237693345e-1 / t225)
  t405 = jnp.log(t275 * t178)
  t407 = 0.1554535e-1 * t386 + 0.61881802979060631480216141626488805225499304723700e0 * t390 + 0.26673100072733151593315970562575695370840511204614e-2 * t393 - 0.310907e-1 * t398 - 0.20521972937837502661166379517614390730124411627871e2 * t402 - 0.44313737677495382697984551091739236689629774931818e-2 * t405
  t408 = t407 * t316
  t409 = t301 * t325
  t415 = t8 * t1
  t421 = t321 * (-0.24e2 * t409 + 0.144e3 * t322 * t329 - 0.240e3 * t323 * t376 + 0.120e3 * t327 / t324 / t415)
  t423 = t308 ** 2
  t424 = 0.1e1 / t423
  t425 = t338 ** 2
  t428 = 0.1e1 / t415
  t431 = 0.2e1 * t301 * t428 - 0.2e1 * t336
  t435 = f.my_piecewise3(t305, 0, 0.4e1 / 0.9e1 * t424 * t425 + 0.4e1 / 0.3e1 * t308 * t431)
  t436 = t313 ** 2
  t437 = 0.1e1 / t436
  t438 = t342 ** 2
  t441 = -t431
  t445 = f.my_piecewise3(t312, 0, 0.4e1 / 0.9e1 * t437 * t438 + 0.4e1 / 0.3e1 * t313 * t441)
  t446 = t435 + t445
  t450 = t369 * t346
  t454 = t16 + 0.35302100000000000000000000000000000000000000000000e1 * t17 + 0.180578e2
  t455 = 0.1e1 / t454
  t459 = jnp.log(t5 * t14 * t455 / 0.4e1)
  t461 = t17 + 0.706042e1
  t464 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t461)
  t466 = t133 + 0.32500e0
  t467 = t466 ** 2
  t469 = jnp.log(t467 * t455)
  t472 = t16 + 0.18637200000000000000000000000000000000000000000000e1 * t17 + 0.129352e2
  t473 = 0.1e1 / t472
  t477 = jnp.log(t5 * t14 * t473 / 0.4e1)
  t479 = t17 + 0.372744e1
  t482 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t479)
  t484 = t133 + 0.10498e0
  t485 = t484 ** 2
  t487 = jnp.log(t485 * t473)
  t489 = 0.1554535e-1 * t459 + 0.52491393169780936217021346072241076933841385384497e-1 * t464 + 0.22478670955426118383265363956423012380560746650571e-2 * t469 - 0.310907e-1 * t477 - 0.38783294878113014394824731224995739188004877421366e-1 * t482 - 0.96902277115443742137603943210562149050493484994510e-3 * t487
  t499 = 0.6e1 * t428 - 0.6e1 * t409
  t503 = f.my_piecewise3(t305, 0, -0.8e1 / 0.27e2 / t423 / t304 * t425 * t338 + 0.4e1 / 0.3e1 * t424 * t338 * t431 + 0.4e1 / 0.3e1 * t308 * t499)
  t516 = f.my_piecewise3(t312, 0, -0.8e1 / 0.27e2 / t436 / t311 * t438 * t342 + 0.4e1 / 0.3e1 * t437 * t342 * t441 - 0.4e1 / 0.3e1 * t313 * t499)
  t517 = t503 + t516
  t521 = t5 * t12 * t455
  t523 = t454 ** 2
  t524 = 0.1e1 / t523
  t525 = t26 * t524
  t527 = -t32 - 0.58836833333333333333333333333333333333333333333333e0 * t37
  t532 = 0.1e1 / t523 / t454
  t533 = t13 * t532
  t534 = t527 ** 2
  t538 = t13 * t524
  t541 = t52 - 0.39224555555555555555555555555555555555555555555555e0 * t63 + 0.78449111111111111111111111111111111111111111111110e0 * t66
  t547 = (t521 / 0.9e1 + t24 * t525 * t527 / 0.6e1 + t24 * t533 * t534 / 0.2e1 - t24 * t538 * t541 / 0.4e1) * t55 * t74
  t548 = t76 * t454
  t559 = (-t5 * t30 * t455 / 0.12e2 - t24 * t538 * t527 / 0.4e1) * t55 * t74
  t560 = t90 * t454
  t563 = t76 * t527
  t566 = t461 ** 2
  t569 = 0.1e1 / t566 / t461 * t2
  t570 = t569 * t4
  t571 = 0.1e1 / t566
  t573 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t571
  t574 = 0.1e1 / t573
  t579 = t571 * t54 * t55
  t585 = t571 * t33 * t2
  t590 = t566 ** 2
  t593 = 0.1e1 / t590 / t461 * t2
  t594 = t593 * t4
  t595 = t573 ** 2
  t596 = 0.1e1 / t595
  t601 = t466 * t524
  t602 = t601 * t34
  t607 = t466 * t455
  t608 = t607 * t54
  t611 = t607 * t33
  t614 = t467 * t532
  t617 = t467 * t524
  t619 = t521 / 0.72e2 + t602 * t35 * t26 * t527 / 0.3e1 - t608 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t611 * t51 + 0.2e1 * t614 * t534 - t617 * t541
  t620 = 0.1e1 / t467
  t621 = t619 * t620
  t627 = -t611 * t31 / 0.6e1 - t617 * t527
  t629 = 0.1e1 / t467 / t466
  t630 = t627 * t629
  t631 = t454 * t33
  t632 = t630 * t631
  t635 = t627 * t620
  t639 = t5 * t12 * t473
  t641 = t472 ** 2
  t642 = 0.1e1 / t641
  t643 = t26 * t642
  t645 = -t32 - 0.31062000000000000000000000000000000000000000000000e0 * t37
  t650 = 0.1e1 / t641 / t472
  t651 = t13 * t650
  t652 = t645 ** 2
  t656 = t13 * t642
  t659 = t52 - 0.20708000000000000000000000000000000000000000000000e0 * t63 + 0.41416000000000000000000000000000000000000000000000e0 * t66
  t665 = (t639 / 0.9e1 + t24 * t643 * t645 / 0.6e1 + t24 * t651 * t652 / 0.2e1 - t24 * t656 * t659 / 0.4e1) * t55 * t74
  t666 = t76 * t472
  t667 = t665 * t666
  t677 = (-t5 * t30 * t473 / 0.12e2 - t24 * t656 * t645 / 0.4e1) * t55 * t74
  t678 = t90 * t472
  t679 = t677 * t678
  t681 = t76 * t645
  t682 = t677 * t681
  t684 = t479 ** 2
  t687 = 0.1e1 / t684 / t479 * t2
  t688 = t687 * t4
  t689 = 0.1e1 / t684
  t691 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t689
  t692 = 0.1e1 / t691
  t694 = t688 * t12 * t692
  t697 = t689 * t54 * t55
  t700 = t697 * t58 * t61 * t692
  t703 = t689 * t33 * t2
  t706 = t703 * t35 * t11 * t692
  t708 = t684 ** 2
  t711 = 0.1e1 / t708 / t479 * t2
  t712 = t711 * t4
  t713 = t691 ** 2
  t714 = 0.1e1 / t713
  t716 = t712 * t12 * t714
  t719 = t484 * t642
  t720 = t719 * t34
  t725 = t484 * t473
  t726 = t725 * t54
  t729 = t725 * t33
  t732 = t485 * t650
  t735 = t485 * t642
  t737 = t639 / 0.72e2 + t720 * t35 * t26 * t645 / 0.3e1 - t726 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t729 * t51 + 0.2e1 * t732 * t652 - t735 * t659
  t738 = 0.1e1 / t485
  t739 = t737 * t738
  t740 = t739 * t472
  t745 = -t729 * t31 / 0.6e1 - t735 * t645
  t747 = 0.1e1 / t485 / t484
  t748 = t745 * t747
  t749 = t472 * t33
  t750 = t748 * t749
  t751 = t750 * t31
  t753 = t745 * t738
  t754 = t753 * t645
  t756 = 0.51817833333333333333333333333333333333333333333333e-2 * t547 * t548 + 0.17272611111111111111111111111111111111111111111111e-2 * t559 * t560 + 0.51817833333333333333333333333333333333333333333333e-2 * t559 * t563 + 0.13796274692623141086738355049039257855828824683819e-1 * t570 * t12 * t574 + 0.27592549385246282173476710098078515711657649367639e-1 * t579 * t58 * t61 * t574 - 0.55185098770492564346953420196157031423315298735277e-1 * t585 * t35 * t11 * t574 - 0.30878365944746984533884071665444263610784010246137e0 * t594 * t12 * t596 + 0.22478670955426118383265363956423012380560746650571e-2 * t621 * t454 + 0.37464451592376863972108939927371687300934577750952e-3 * t632 * t31 + 0.22478670955426118383265363956423012380560746650571e-2 * t635 * t527 - 0.10363566666666666666666666666666666666666666666667e-1 * t667 - 0.34545222222222222222222222222222222222222222222223e-2 * t679 - 0.10363566666666666666666666666666666666666666666667e-1 * t682 - 0.13255248558342256726771310131293653497824588692887e-1 * t694 - 0.26510497116684513453542620262587306995649177385775e-1 * t700 + 0.53020994233369026907085240525174613991298354771549e-1 * t706 + 0.50167127350538589836488394571946851238131125013746e0 * t716 - 0.96902277115443742137603943210562149050493484994510e-3 * t740 - 0.16150379519240623689600657201760358175082247499085e-3 * t751 - 0.96902277115443742137603943210562149050493484994510e-3 * t754
  t776 = 0.51817833333333333333333333333333333333333333333333e-2 * t559 * t548 + 0.41388824077869423260215065147117773567486474051458e-1 * t585 * t35 * t26 * t574 + 0.22478670955426118383265363956423012380560746650571e-2 * t635 * t454 - 0.10363566666666666666666666666666666666666666666667e-1 * t677 * t666 - 0.39765745675026770180313930393880960493473766078662e-1 * t703 * t35 * t26 * t692 - 0.96902277115443742137603943210562149050493484994510e-3 * t753 * t472
  t781 = 0.1e1 / t9 / t415
  t782 = t7 * t781
  t784 = t5 * t782 * t473
  t788 = t24 * t11 * t642 * t645
  t808 = 0.1e1 / t57
  t810 = t2 * t808 * t7
  t811 = t781 * t3
  t818 = 0.1e1 / t17 / t143 / t90 / 0.4e1
  t820 = t818 * t3 * t325
  t824 = 0.1e1 / t59 / t415
  t825 = t6 * t824
  t826 = t143 * t825
  t829 = t5 * t782
  t832 = t641 ** 2
  t833 = 0.1e1 / t832
  t835 = t652 * t645
  t838 = t645 * t659
  t841 = 0.7e1 / 0.27e2 * t829
  t844 = t56 * t58 * t824
  t847 = t34 * t35 * t781
  t849 = -t841 - 0.12424800000000000000000000000000000000000000000000e1 * t820 + 0.82832000000000000000000000000000000000000000000000e0 * t844 - 0.96637333333333333333333333333333333333333333333333e0 * t847
  t851 = -0.11e2 / 0.216e3 * t784 - t788 / 0.24e2 - t484 * t650 * t34 * t35 * t26 * t652 + t719 * t56 * t58 * t61 * t645 / 0.3e1 - 0.2e1 / 0.3e1 * t720 * t35 * t11 * t645 + t720 * t35 * t26 * t659 / 0.2e1 + t810 * t811 * t473 / 0.432e3 - 0.2e1 / 0.3e1 * t725 * t820 + 0.4e1 / 0.9e1 * t726 * t826 - 0.14e2 / 0.27e2 * t729 * t829 - 0.6e1 * t485 * t833 * t835 + 0.6e1 * t732 * t838 - t735 * t849
  t854 = 0.96902277115443742137603943210562149050493484994510e-3 * t851 * t738 * t472
  t856 = 0.19380455423088748427520788642112429810098696998902e-2 * t739 * t645
  t858 = 0.96902277115443742137603943210562149050493484994510e-3 * t753 * t659
  t859 = -0.3e1 * t300 * t346 * t350 + 0.3e1 * t756 * t346 * t321 + 0.3e1 * t776 * t446 * t321 + t489 * t517 * t321 - 0.3e1 * t369 * t446 * t350 - 0.3e1 * t317 * t333 - 0.6e1 * t450 * t333 - 0.3e1 * t370 * t380 - t408 * t421 + t854 + t856 + t858
  t861 = t5 * t782 * t455
  t865 = t24 * t11 * t524 * t527
  t894 = t523 ** 2
  t895 = 0.1e1 / t894
  t897 = t534 * t527
  t900 = t527 * t541
  t906 = -t841 - 0.23534733333333333333333333333333333333333333333333e1 * t820 + 0.15689822222222222222222222222222222222222222222222e1 * t844 - 0.18304792592592592592592592592592592592592592592592e1 * t847
  t908 = -0.11e2 / 0.216e3 * t861 - t865 / 0.24e2 - t466 * t532 * t34 * t35 * t26 * t534 + t601 * t56 * t58 * t61 * t527 / 0.3e1 - 0.2e1 / 0.3e1 * t602 * t35 * t11 * t527 + t602 * t35 * t26 * t541 / 0.2e1 + t810 * t811 * t455 / 0.432e3 - 0.2e1 / 0.3e1 * t607 * t820 + 0.4e1 / 0.9e1 * t608 * t826 - 0.14e2 / 0.27e2 * t611 * t829 - 0.6e1 * t467 * t895 * t897 + 0.6e1 * t614 * t900 - t617 * t906
  t917 = t3 * t325
  t924 = 0.15906298270010708072125572157552384197389506431465e0 * t689 * t818 * t917 * t692
  t939 = 0.22478670955426118383265363956423012380560746650571e-2 * t908 * t620 * t454 - t854 - t856 - t858 + 0.44957341910852236766530727912846024761121493301142e-2 * t621 * t527 + 0.22478670955426118383265363956423012380560746650571e-2 * t635 * t541 + 0.16555529631147769304086026058847109426994589620583e0 * t571 * t818 * t917 * t574 - t924 - 0.49952602123169151962811919903162249734579437001269e-3 * t632 * t51 + 0.74928903184753727944217879854743374601869155501904e-3 * t619 * t629 * t631 * t31 + 0.74928903184753727944217879854743374601869155501904e-3 * t630 * t527 * t33 * t31 + 0.24976301061584575981405959951581124867289718500635e-3 * t630 * t454 * t54 * t145
  t943 = 0.32300759038481247379201314403520716350164494998170e-3 * t748 * t645 * t33 * t31
  t945 = 0.21533839358987498252800876269013810900109663332113e-3 * t750 * t51
  t949 = 0.10766919679493749126400438134506905450054831666057e-3 * t748 * t472 * t54 * t145
  t953 = 0.32300759038481247379201314403520716350164494998170e-3 * t737 * t747 * t749 * t31
  t962 = t467 ** 2
  t993 = t590 ** 2
  t1003 = -t943 + t945 - t949 - t953 - 0.11037019754098512869390684039231406284663059747056e0 * t579 * t58 * t824 * t574 + 0.12876523046448265014289131379103307332106903038231e0 * t585 * t35 * t781 * t574 + 0.93661128980942159930272349818429218252336444377380e-4 * t627 / t962 * t454 * t51 + 0.27592549385246282173476710098078515711657649367638e-1 / t590 * t55 * t57 * t825 * t574 * t33 - 0.14409904107548592782479233443873989685032538114864e1 / t590 / t566 * t55 * t57 * t825 * t596 * t33 + 0.22993791154371901811230591748398763093048041139699e-2 * t569 * t808 * t782 * t3 * t574 - 0.51463943241244974223140119442407106017973350410227e-1 * t593 * t808 * t782 * t3 * t596 + 0.18429583437767336287475605998441200095133403022660e2 / t993 * t55 * t57 * t825 / t595 / t573 * t33
  t1011 = 0.26510497116684513453542620262587306995649177385774e-1 / t708 * t55 * t57 * t825 * t692 * t33
  t1019 = 0.23411326096918008590361250800241863911127858339748e1 / t708 / t684 * t55 * t57 * t825 * t714 * t33
  t1020 = t708 ** 2
  t1029 = 0.50631328524251801700246888250186209051365905137714e2 / t1020 * t55 * t57 * t825 / t713 / t691 * t33
  t1033 = 0.10604198846673805381417048105034922798259670954310e0 * t697 * t58 * t824 * t692
  t1038 = 0.22092080930570427877952183552156089163040981154812e-2 * t687 * t808 * t782 * t3 * t692
  t1043 = 0.83611878917564316394147324286578085396885208356242e-1 * t711 * t808 * t782 * t3 * t714
  t1047 = 0.12371565321119439611653222789207409931302949446695e0 * t703 * t35 * t781 * t692
  t1048 = t485 ** 2
  t1053 = 0.40375948798101559224001643004400895437705618747712e-4 * t745 / t1048 * t472 * t51
  t1055 = 0.69090444444444444444444444444444444444444444444446e-2 * t665 * t678
  t1058 = t6 / t59 / t1
  t1061 = 0.23030148148148148148148148148148148148148148148149e-2 * t677 * t1058 * t472
  t1085 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t784 - t788 / 0.3e1 - t24 * t26 * t650 * t652 / 0.2e1 + t24 * t643 * t659 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t833 * t835 + 0.3e1 / 0.2e1 * t24 * t651 * t838 - t24 * t656 * t849 / 0.4e1) * t55 * t74 * t666
  t1089 = -t1011 + t1019 - t1029 + t1033 - t1038 + t1043 - t1047 - t1053 - t1055 + t1061 - t1085 - 0.11515074074074074074074074074074074074074074074074e-2 * t559 * t1058 * t454
  t1097 = 0.48602578047254941331494803814743396158690158540586e-1 * t688 * t782 * t692
  t1100 = 0.18394613361864149606712411343047178787314745838373e1 * t712 * t782 * t714
  t1103 = 0.69090444444444444444444444444444444444444444444446e-2 * t677 * t90 * t645
  t1130 = 0.10363566666666666666666666666666666666666666666667e-1 * t677 * t76 * t659
  t1132 = 0.20727133333333333333333333333333333333333333333334e-1 * t665 * t681
  t1144 = -0.50586340539618183984707301846477278804705690507337e-1 * t570 * t782 * t574 + 0.34545222222222222222222222222222222222222222222222e-2 * t547 * t560 + t1097 - t1100 - t1103 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t861 - t865 / 0.3e1 - t24 * t26 * t532 * t534 / 0.2e1 + t24 * t525 * t541 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t895 * t897 + 0.3e1 / 0.2e1 * t24 * t533 * t900 - t24 * t538 * t906 / 0.4e1) * t55 * t74 * t548 - t1130 - t1132 + 0.11322067513073894329090826277329563323954137090250e1 * t594 * t782 * t596 + 0.51817833333333333333333333333333333333333333333333e-2 * t559 * t76 * t541 + 0.34545222222222222222222222222222222222222222222222e-2 * t559 * t90 * t527 + 0.10363566666666666666666666666666666666666666666667e-1 * t547 * t563
  t1149 = jnp.pi ** 2
  t1150 = 0.1e1 / t1149
  t1152 = t16 + 0.53417500000000000000000000000000000000000000000000e0 * t17 + 0.114813e2
  t1153 = 0.1e1 / t1152
  t1157 = t1152 ** 2
  t1158 = 0.1e1 / t1157
  t1159 = t13 * t1158
  t1161 = -t32 - 0.89029166666666666666666666666666666666666666666667e-1 * t37
  t1167 = (-t5 * t30 * t1153 / 0.12e2 - t24 * t1159 * t1161 / 0.4e1) * t55 * t74
  t1168 = t76 * t1152
  t1171 = t17 + 0.106835e1
  t1172 = t1171 ** 2
  t1173 = 0.1e1 / t1172
  t1175 = t1173 * t33 * t2
  t1177 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t1173
  t1178 = 0.1e1 / t1177
  t1183 = t133 + 0.228344e0
  t1184 = t1183 * t1153
  t1185 = t1184 * t33
  t1188 = t1183 ** 2
  t1189 = t1188 * t1158
  t1191 = -t1185 * t31 / 0.6e1 - t1189 * t1161
  t1192 = 0.1e1 / t1188
  t1193 = t1191 * t1192
  t1197 = t1150 * (t1167 * t1168 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t1175 * t35 * t26 * t1178 + 0.21608710360898267021763215722876235716176892439270e-1 * t1193 * t1152)
  t1199 = 0.9e1 * t319
  t1200 = t350 * t1199
  t1203 = t1197 * t346
  t1204 = t333 * t1199
  t1208 = t5 * t12 * t1153
  t1210 = t26 * t1158
  t1215 = 0.1e1 / t1157 / t1152
  t1216 = t13 * t1215
  t1217 = t1161 ** 2
  t1223 = t52 - 0.59352777777777777777777777777777777777777777777778e-1 * t63 + 0.11870555555555555555555555555555555555555555555556e0 * t66
  t1229 = (t1208 / 0.9e1 + t24 * t1210 * t1161 / 0.6e1 + t24 * t1216 * t1217 / 0.2e1 - t24 * t1159 * t1223 / 0.4e1) * t55 * t74
  t1232 = t90 * t1152
  t1235 = t76 * t1161
  t1240 = 0.1e1 / t1172 / t1171 * t2
  t1241 = t1240 * t4
  t1246 = t1173 * t54 * t55
  t1255 = t1172 ** 2
  t1258 = 0.1e1 / t1255 / t1171 * t2
  t1259 = t1258 * t4
  t1260 = t1177 ** 2
  t1261 = 0.1e1 / t1260
  t1266 = t1183 * t1158
  t1267 = t1266 * t34
  t1272 = t1184 * t54
  t1277 = t1188 * t1215
  t1281 = t1208 / 0.72e2 + t1267 * t35 * t26 * t1161 / 0.3e1 - t1272 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t1185 * t51 + 0.2e1 * t1277 * t1217 - t1189 * t1223
  t1282 = t1281 * t1192
  t1286 = 0.1e1 / t1188 / t1183
  t1287 = t1191 * t1286
  t1288 = t1152 * t33
  t1289 = t1287 * t1288
  t1295 = t1150 * (t1229 * t1168 / 0.3e1 + t1167 * t1232 / 0.9e1 + t1167 * t1235 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t1241 * t12 * t1178 + 0.24034827266594839017845905156788576090902848675181e0 * t1246 * t58 * t61 * t1178 - 0.48069654533189678035691810313577152181805697350363e0 * t1175 * t35 * t11 * t1178 - 0.53818578849327899137148388724908565251436770250246e1 * t1259 * t12 * t1261 + 0.21608710360898267021763215722876235716176892439270e-1 * t1282 * t1152 + 0.36014517268163778369605359538127059526961487398783e-2 * t1289 * t31 + 0.21608710360898267021763215722876235716176892439270e-1 * t1193 * t1161)
  t1296 = t1295 * t316
  t1302 = jnp.log(t5 * t14 * t1153 / 0.4e1)
  t1305 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t1171)
  t1308 = jnp.log(t1188 * t1153)
  t1311 = t1150 * (t1302 + 0.32323836906055067299704130765928097906535029214058e0 * t1305 + 0.21608710360898267021763215722876235716176892439270e-1 * t1308)
  t1312 = t1311 * t316
  t1316 = t1311 * t346
  t1317 = t380 * t1199
  t1323 = t1311 * t446
  t1326 = t1197 * t316
  t1332 = (t939 + t1003 + t1089 + t1144) * t316 * t321 - t1197 * t446 * t1200 / 0.8e1 - t1203 * t1204 / 0.4e1 - t1296 * t1204 / 0.8e1 - t1312 * t421 * t1199 / 0.24e2 - t1316 * t1317 / 0.8e1 - t1311 * t517 * t1200 / 0.24e2 - t1323 * t1204 / 0.8e1 - t1326 * t1317 / 0.8e1 - t1295 * t346 * t1200 / 0.8e1 + t924 + t943
  t1334 = -t945 + t949 + t953 + t1011 - t1019 + t1029 - t1033 + t1038 - t1043 + t1047 + t1053 + t1055
  t1335 = t1188 ** 2
  t1366 = t1255 ** 2
  t1393 = 0.90036293170409445924013398845317648817403718496958e-3 * t1191 / t1335 * t1152 * t51 + 0.24034827266594839017845905156788576090902848675182e0 / t1255 * t55 * t57 * t825 * t1178 * t33 - 0.25115336796353019597335914738290663784003826116781e2 / t1255 / t1172 * t55 * t57 * t825 * t1261 * t33 + 0.20029022722162365848204920963990480075752373895984e-1 * t1240 * t808 * t782 * t3 * t1178 - 0.89697631415546498561913981208180942085727950417076e0 * t1258 * t808 * t782 * t3 * t1261 + 0.64272053155397178166610502978456596616246611440970e3 / t1366 * t55 * t57 * t825 / t1260 / t1177 * t33 - 0.2e1 / 0.27e2 * t1167 * t1058 * t1152 - 0.44063849988757204866050826120779056166655222571167e0 * t1241 * t782 * t1178 + 0.19733478911420229683621075865799807258860149091757e2 * t1259 * t782 * t1261 + 0.2e1 / 0.9e1 * t1167 * t90 * t1161 + t1167 * t76 * t1223 / 0.3e1 + 0.2e1 / 0.3e1 * t1229 * t1235
  t1395 = t5 * t782 * t1153
  t1399 = t24 * t11 * t1158 * t1161
  t1408 = t1157 ** 2
  t1409 = 0.1e1 / t1408
  t1411 = t1217 * t1161
  t1415 = t1161 * t1223
  t1422 = -t841 - 0.35611666666666666666666666666666666666666666666667e0 * t820 + 0.23741111111111111111111111111111111111111111111111e0 * t844 - 0.27697962962962962962962962962962962962962962962964e0 * t847
  t1494 = -0.11e2 / 0.216e3 * t1395 - t1399 / 0.24e2 - t1183 * t1215 * t34 * t35 * t26 * t1217 + t1266 * t56 * t58 * t61 * t1161 / 0.3e1 - 0.2e1 / 0.3e1 * t1267 * t35 * t11 * t1161 + t1267 * t35 * t26 * t1223 / 0.2e1 + t810 * t811 * t1153 / 0.432e3 - 0.2e1 / 0.3e1 * t1184 * t820 + 0.4e1 / 0.9e1 * t1272 * t826 - 0.14e2 / 0.27e2 * t1185 * t829 - 0.6e1 * t1188 * t1409 * t1411 + 0.6e1 * t1277 * t1415 - t1189 * t1422
  t1502 = (-0.7e1 / 0.27e2 * t1395 - t1399 / 0.3e1 - t24 * t26 * t1215 * t1217 / 0.2e1 + t24 * t1210 * t1223 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t1409 * t1411 + 0.3e1 / 0.2e1 * t24 * t1216 * t1415 - t24 * t1159 * t1422 / 0.4e1) * t55 * t74 * t1168 / 0.3e1 + 0.14420896359956903410707543094073145654541709205109e1 * t1173 * t818 * t917 * t1178 + 0.2e1 / 0.9e1 * t1229 * t1232 + 0.11216252724410924874994755739834668842421329381751e1 * t1175 * t35 * t781 * t1178 - 0.96139309066379356071383620627154304363611394700724e0 * t1246 * t58 * t824 * t1178 - 0.48019356357551704492807146050836079369281983198377e-2 * t1289 * t51 + 0.72029034536327556739210719076254119053922974797566e-2 * t1281 * t1286 * t1288 * t31 + 0.72029034536327556739210719076254119053922974797566e-2 * t1287 * t1161 * t33 * t31 + 0.24009678178775852246403573025418039684640991599189e-2 * t1287 * t1152 * t54 * t145 + 0.21608710360898267021763215722876235716176892439270e-1 * t1494 * t1192 * t1152 + 0.43217420721796534043526431445752471432353784878540e-1 * t1282 * t1161 + 0.21608710360898267021763215722876235716176892439270e-1 * t1193 * t1223
  t1519 = t5 * t782 * t20
  t1523 = t24 * t11 * t28 * t39
  t1552 = t27 ** 2
  t1553 = 0.1e1 / t1552
  t1555 = t46 * t39
  t1558 = t39 * t68
  t1564 = -t841 - 0.67077000000000000000000000000000000000000000000000e1 * t820 + 0.44718000000000000000000000000000000000000000000000e1 * t844 - 0.52171000000000000000000000000000000000000000000000e1 * t847
  t1566 = -0.11e2 / 0.216e3 * t1519 - t1523 / 0.24e2 - t134 * t44 * t34 * t35 * t26 * t46 + t135 * t56 * t58 * t61 * t39 / 0.3e1 - 0.2e1 / 0.3e1 * t136 * t35 * t11 * t39 + t136 * t35 * t26 * t68 / 0.2e1 + t810 * t811 * t20 / 0.432e3 - 0.2e1 / 0.3e1 * t141 * t820 + 0.4e1 / 0.9e1 * t142 * t826 - 0.14e2 / 0.27e2 * t148 * t829 - 0.6e1 * t151 * t1553 * t1555 + 0.6e1 * t152 * t1558 - t155 * t1564
  t1575 = t5 * t782 * t178
  t1579 = t24 * t11 * t183 * t186
  t1608 = t182 ** 2
  t1609 = 0.1e1 / t1608
  t1611 = t193 * t186
  t1614 = t186 * t200
  t1620 = -t841 - 0.43573333333333333333333333333333333333333333333332e1 * t820 + 0.29048888888888888888888888888888888888888888888888e1 * t844 - 0.33890370370370370370370370370370370370370370370369e1 * t847
  t1622 = -0.11e2 / 0.216e3 * t1575 - t1579 / 0.24e2 - t261 * t191 * t34 * t35 * t26 * t193 + t262 * t56 * t58 * t61 * t186 / 0.3e1 - 0.2e1 / 0.3e1 * t263 * t35 * t11 * t186 + t263 * t35 * t26 * t200 / 0.2e1 + t810 * t811 * t178 / 0.432e3 - 0.2e1 / 0.3e1 * t268 * t820 + 0.4e1 / 0.9e1 * t269 * t826 - 0.14e2 / 0.27e2 * t272 * t829 - 0.6e1 * t275 * t1609 * t1611 + 0.6e1 * t276 * t1614 - t279 * t1620
  t1638 = -0.61428953307227691896295992558865975087351157250442e0 * t231 * t818 * t917 * t234 + 0.48337331672435896699555362735747849302493515162012e0 * t103 * t818 * t917 * t106 - 0.44313737677495382697984551091739236689629774931818e-2 * t297 * t200 + 0.26673100072733151593315970562575695370840511204614e-2 * t1566 * t158 * t19 + 0.53346200145466303186631941125151390741681022409228e-2 * t159 * t39 + 0.26673100072733151593315970562575695370840511204614e-2 * t173 * t68 - 0.44313737677495382697984551091739236689629774931818e-2 * t1622 * t282 * t177 - 0.88627475354990765395969102183478473379259549863636e-2 * t283 * t186 - 0.69090444444444444444444444444444444444444444444446e-2 * t206 * t219 + 0.23030148148148148148148148148148148148148148148149e-2 * t218 * t1058 * t177 - 0.14769740233244301769308583058145176175761907410615e0 * t102 * t782 * t106 + 0.34545222222222222222222222222222222222222222222222e-2 * t75 * t91
  t1715 = -0.11515074074074074074074074074074074074074074074074e-2 * t88 * t1058 * t19 + 0.34545222222222222222222222222222222222222222222222e-2 * t88 * t90 * t39 + 0.10363566666666666666666666666666666666666666666667e-1 * t75 * t94 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1519 - t1523 / 0.3e1 - t24 * t26 * t44 * t46 / 0.2e1 + t24 * t29 * t68 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t1553 * t1555 + 0.3e1 / 0.2e1 * t24 * t45 * t1558 - t24 * t50 * t1564 / 0.4e1) * t55 * t74 * t77 + 0.18769957954986239190534886615209047943357298048745e0 * t230 * t782 * t234 - 0.69090444444444444444444444444444444444444444444446e-2 * t218 * t90 * t186 - 0.20727133333333333333333333333333333333333333333334e-1 * t206 * t222 - 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t1575 - t1579 / 0.3e1 - t24 * t26 * t191 * t193 / 0.2e1 + t24 * t184 * t200 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t1609 * t1611 + 0.3e1 / 0.2e1 * t24 * t192 * t1614 - t24 * t197 * t1620 / 0.4e1) * t55 * t74 * t207 + 0.20276584560447197672065901047389765208808740088178e0 * t126 * t782 * t128 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t76 * t68 - 0.37840235237252258208118331416261440653808312866271e-3 * t254 * t782 * t256 - 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t76 * t200
  t1745 = t122 ** 2
  t1767 = -0.14771245892498460899328183697246412229876591643939e-2 * t281 * t291 * t293 * t31 - 0.14771245892498460899328183697246412229876591643939e-2 * t292 * t186 * t33 * t31 - 0.49237486308328202997760612324154707432921972146465e-3 * t292 * t177 * t54 * t145 + 0.88910333575777171977719901875252317902801704015380e-3 * t157 * t167 * t169 * t31 + 0.88910333575777171977719901875252317902801704015380e-3 * t168 * t39 * t33 * t31 + 0.29636777858592390659239967291750772634267234671793e-3 * t168 * t19 * t54 * t145 + 0.98474972616656405995521224648309414865843944292929e-3 * t294 * t51 - 0.59273555717184781318479934583501545268534469343587e-3 * t170 * t51 + 0.20244826120247034261608782614550005883535036385819e0 / t1745 * t55 * t57 * t825 / t127 / t105 * t33 + 0.40952635538151794597530661705910650058234104833627e0 * t239 * t58 * t824 * t234 - 0.47778074794510427030452438656895758401273122305897e0 * t245 * t35 * t781 * t234 - 0.32224887781623931133036908490498566201662343441341e0 * t111 * t58 * t824 * t106
  t1772 = t250 ** 2
  t1782 = t275 ** 2
  t1813 = t151 ** 2
  t1844 = 0.37595702411894586321876393238914993901939400681566e0 * t117 * t35 * t781 * t106 - 0.55480664900582220034593859007405864987692769991566e-6 / t1772 * t55 * t57 * t825 / t255 / t233 * t33 - 0.18464057365623076124160229621558015287345739554924e-3 * t289 / t1782 * t177 * t51 - 0.10238158884537948649382665426477662514558526208407e0 / t250 * t55 * t57 * t825 * t234 * t33 + 0.48160299392866510446696058166150924468483307284345e-3 / t250 / t226 * t55 * t57 * t825 * t256 * t33 - 0.85317990704482905411522211887313854287987718403392e-2 * t229 * t808 * t782 * t3 * t234 + 0.17200106926023753730962877916482473024458324030124e-4 * t253 * t808 * t782 * t3 * t256 + 0.11113791696972146497214987734406539737850213001922e-3 * t165 / t1813 * t19 * t51 + 0.80562219454059827832592271226246415504155858603354e-1 / t122 * t55 * t57 * t825 * t106 * t33 - 0.25806562167841887946265692242132428447574760112225e0 / t122 / t98 * t55 * t57 * t825 * t128 * t33 + 0.67135182878383189860493559355205346253463215502794e-2 * t101 * t808 * t782 * t3 * t106 - 0.92166293456578171236663186579044387312767000400800e-2 * t125 * t808 * t782 * t3 * t128
  t1851 = t407 * t446
  t1854 = t407 * t346
  t1857 = -t1061 + t1085 - t1097 + t1100 + t1103 + t1130 + t1132 - t1150 * (t1393 + t1502) * t316 * t1200 / 0.24e2 - (t1638 + t1715 + t1767 + t1844) * t316 * t350 - t407 * t517 * t350 - 0.3e1 * t1851 * t333 - 0.3e1 * t1854 * t380
  t1884 = t1 * (t859 + t1332 + t1334 + t1857) + 0.29070683134633122641281182963168644715148045498353e-2 * t740 + 0.29070683134633122641281182963168644715148045498353e-2 * t754 + 0.3e1 * t756 * t316 * t321 + 0.6e1 * t776 * t346 * t321 + 0.3e1 * t489 * t446 * t321 + 0.48451138557721871068801971605281074525246742497255e-3 * t751 - 0.3e1 * t317 * t350 - 0.6e1 * t370 * t333 - 0.6e1 * t1854 * t333 - 0.3e1 * t408 * t380 - 0.3e1 * t1851 * t350 + 0.79531491350053540360627860787761920986947532157324e-1 * t700
  t1905 = -0.15906298270010708072125572157552384197389506431465e0 * t706 + 0.31090700000000000000000000000000000000000000000001e-1 * t682 + 0.39765745675026770180313930393880960493473766078662e-1 * t694 - 0.15050138205161576950946518371584055371439337504124e1 * t716 + 0.31090700000000000000000000000000000000000000000001e-1 * t667 + 0.10363566666666666666666666666666666666666666666667e-1 * t679 - t1296 * t1200 / 0.8e1 - t1203 * t1200 / 0.4e1 - t1326 * t1204 / 0.4e1 - t1323 * t1200 / 0.8e1 - t1316 * t1204 / 0.4e1 - t1312 * t1317 / 0.8e1 - 0.6e1 * t450 * t350
  d111 = t1884 + t1905

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = jnp.sqrt(t11)
  t13 = t12 + 0.372744e1
  t14 = t13 ** 2
  t15 = t14 * t13
  t17 = 0.1e1 / t15 * t1
  t18 = t17 * t3
  t19 = t7 ** 2
  t20 = t19 * t7
  t22 = 0.1e1 / t8 / t20
  t23 = t6 * t22
  t24 = 0.1e1 / t14
  t26 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t24
  t27 = 0.1e1 / t26
  t29 = t18 * t23 * t27
  t31 = t14 ** 2
  t33 = 0.1e1 / t31 / t13
  t34 = t33 * t1
  t35 = t34 * t3
  t36 = t26 ** 2
  t37 = 0.1e1 / t36
  t39 = t35 * t23 * t37
  t42 = 0.1e1 / t8 / t7
  t43 = t6 * t42
  t44 = t11 / 0.4e1
  t46 = t44 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t47 = 0.1e1 / t46
  t51 = t4 * t6
  t52 = t46 ** 2
  t53 = 0.1e1 / t52
  t54 = t9 * t53
  t55 = t4 * t43
  t56 = t55 / 0.12e2
  t57 = 0.1e1 / t12
  t58 = t57 * t1
  t59 = t3 * t6
  t61 = t58 * t59 * t42
  t63 = -t56 - 0.31062000000000000000000000000000000000000000000000e0 * t61
  t68 = t1 ** 2
  t70 = 0.1e1 / t3
  t71 = (-t4 * t43 * t47 / 0.12e2 - t51 * t54 * t63 / 0.4e1) * t68 * t70
  t72 = t5 * t8
  t74 = 0.1e1 / t8 / t19
  t75 = t6 * t74
  t76 = t4 * t75
  t77 = t76 / 0.9e1
  t79 = 0.1e1 / t12 / t11
  t80 = t79 * t68
  t81 = t3 ** 2
  t82 = t81 * t5
  t83 = t8 ** 2
  t85 = 0.1e1 / t83 / t19
  t87 = t80 * t82 * t85
  t90 = t58 * t59 * t74
  t92 = t77 - 0.20708000000000000000000000000000000000000000000000e0 * t87 + 0.41416000000000000000000000000000000000000000000000e0 * t90
  t93 = t72 * t92
  t94 = t71 * t93
  t97 = t5 / t83
  t98 = t97 * t63
  t99 = t71 * t98
  t102 = t4 * t75 * t47
  t104 = t42 * t53
  t109 = 0.1e1 / t52 / t46
  t110 = t9 * t109
  t111 = t63 ** 2
  t120 = (t102 / 0.9e1 + t51 * t104 * t63 / 0.6e1 + t51 * t110 * t111 / 0.2e1 - t51 * t54 * t92 / 0.4e1) * t68 * t70
  t121 = t72 * t63
  t122 = t120 * t121
  t124 = t97 * t46
  t125 = t120 * t124
  t129 = t5 / t83 / t7
  t130 = t129 * t46
  t131 = t71 * t130
  t134 = t4 * t23 * t47
  t136 = t74 * t53
  t138 = t51 * t136 * t63
  t140 = t42 * t109
  t147 = t52 ** 2
  t148 = 0.1e1 / t147
  t149 = t9 * t148
  t150 = t111 * t63
  t154 = t63 * t92
  t158 = t4 * t23
  t159 = 0.7e1 / 0.27e2 * t158
  t160 = t68 * t81
  t164 = 0.1e1 / t12 / t160 / t97 / 0.4e1
  t165 = t164 * t2
  t166 = t19 ** 2
  t167 = 0.1e1 / t166
  t168 = t165 * t167
  t171 = 0.1e1 / t83 / t20
  t173 = t80 * t82 * t171
  t176 = t58 * t59 * t22
  t178 = -t159 - 0.12424800000000000000000000000000000000000000000000e1 * t168 + 0.82832000000000000000000000000000000000000000000000e0 * t173 - 0.96637333333333333333333333333333333333333333333333e0 * t176
  t184 = (-0.7e1 / 0.27e2 * t134 - t138 / 0.3e1 - t51 * t140 * t111 / 0.2e1 + t51 * t104 * t92 / 0.4e1 - 0.3e1 / 0.2e1 * t51 * t149 * t150 + 0.3e1 / 0.2e1 * t51 * t110 * t154 - t51 * t54 * t178 / 0.4e1) * t68 * t70
  t185 = t72 * t46
  t186 = t184 * t185
  t188 = jnp.pi ** 2
  t189 = 0.1e1 / t188
  t191 = t44 + 0.53417500000000000000000000000000000000000000000000e0 * t12 + 0.114813e2
  t192 = 0.1e1 / t191
  t194 = t4 * t75 * t192
  t196 = t191 ** 2
  t197 = 0.1e1 / t196
  t198 = t42 * t197
  t200 = -t56 - 0.89029166666666666666666666666666666666666666666667e-1 * t61
  t205 = 0.1e1 / t196 / t191
  t206 = t9 * t205
  t207 = t200 ** 2
  t211 = t9 * t197
  t214 = t77 - 0.59352777777777777777777777777777777777777777777778e-1 * t87 + 0.11870555555555555555555555555555555555555555555556e0 * t90
  t220 = (t194 / 0.9e1 + t51 * t198 * t200 / 0.6e1 + t51 * t206 * t207 / 0.2e1 - t51 * t211 * t214 / 0.4e1) * t68 * t70
  t221 = t72 * t191
  t232 = (-t4 * t43 * t192 / 0.12e2 - t51 * t211 * t200 / 0.4e1) * t68 * t70
  t233 = t97 * t191
  t236 = t72 * t200
  t239 = t12 + 0.106835e1
  t240 = t239 ** 2
  t241 = t240 * t239
  t242 = 0.1e1 / t241
  t243 = t242 * t1
  t244 = t243 * t3
  t245 = 0.1e1 / t240
  t247 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t245
  t248 = 0.1e1 / t247
  t253 = t245 * t79 * t68
  t259 = t245 * t57 * t1
  t264 = t240 ** 2
  t266 = 0.1e1 / t264 / t239
  t267 = t266 * t1
  t268 = t267 * t3
  t269 = t247 ** 2
  t270 = 0.1e1 / t269
  t275 = t12 / 0.2e1
  t276 = t275 + 0.228344e0
  t277 = t276 * t197
  t278 = t277 * t58
  t279 = t42 * t200
  t283 = t276 * t192
  t284 = t283 * t79
  t285 = t5 * t85
  t286 = t160 * t285
  t289 = t283 * t57
  t292 = t276 ** 2
  t293 = t292 * t205
  t296 = t292 * t197
  t298 = t194 / 0.72e2 + t278 * t59 * t279 / 0.3e1 - t284 * t286 / 0.9e1 + 0.2e1 / 0.9e1 * t289 * t76 + 0.2e1 * t293 * t207 - t296 * t214
  t299 = 0.1e1 / t292
  t300 = t298 * t299
  t306 = -t289 * t55 / 0.6e1 - t296 * t200
  t308 = 0.1e1 / t292 / t276
  t309 = t306 * t308
  t310 = t191 * t57
  t311 = t309 * t310
  t314 = t306 * t299
  t318 = t189 * (t220 * t221 / 0.3e1 + t232 * t233 / 0.9e1 + t232 * t236 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t244 * t75 * t248 + 0.24034827266594839017845905156788576090902848675181e0 * t253 * t82 * t85 * t248 - 0.48069654533189678035691810313577152181805697350363e0 * t259 * t59 * t74 * t248 - 0.53818578849327899137148388724908565251436770250246e1 * t268 * t75 * t270 + 0.21608710360898267021763215722876235716176892439270e-1 * t300 * t191 + 0.36014517268163778369605359538127059526961487398783e-2 * t311 * t55 + 0.21608710360898267021763215722876235716176892439270e-1 * t314 * t200)
  t319 = r0 - r1
  t320 = 0.1e1 / t7
  t321 = t319 * t320
  t322 = 0.1e1 + t321
  t323 = t322 <= f.p.zeta_threshold
  t324 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t325 = t324 * f.p.zeta_threshold
  t326 = t322 ** (0.1e1 / 0.3e1)
  t328 = f.my_piecewise3(t323, t325, t326 * t322)
  t329 = 0.1e1 - t321
  t330 = t329 <= f.p.zeta_threshold
  t331 = t329 ** (0.1e1 / 0.3e1)
  t333 = f.my_piecewise3(t330, t325, t331 * t329)
  t334 = t328 + t333 - 0.2e1
  t335 = t318 * t334
  t336 = 2 ** (0.1e1 / 0.3e1)
  t337 = t336 - 0.1e1
  t339 = 0.1e1 / t337 / 0.2e1
  t340 = t319 ** 2
  t341 = t340 * t319
  t343 = t340 ** 2
  t344 = t166 * t7
  t345 = 0.1e1 / t344
  t349 = t339 * (-0.4e1 * t341 * t167 + 0.4e1 * t343 * t345)
  t350 = 0.9e1 * t337
  t351 = t349 * t350
  t363 = t189 * (t232 * t221 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t259 * t59 * t42 * t248 + 0.21608710360898267021763215722876235716176892439270e-1 * t314 * t191)
  t364 = t326 ** 2
  t365 = 0.1e1 / t364
  t366 = 0.1e1 / t19
  t368 = -t319 * t366 + t320
  t369 = t368 ** 2
  t372 = 0.1e1 / t20
  t375 = 0.2e1 * t319 * t372 - 0.2e1 * t366
  t379 = f.my_piecewise3(t323, 0, 0.4e1 / 0.9e1 * t365 * t369 + 0.4e1 / 0.3e1 * t326 * t375)
  t380 = t331 ** 2
  t381 = 0.1e1 / t380
  t382 = -t368
  t383 = t382 ** 2
  t386 = -t375
  t390 = f.my_piecewise3(t330, 0, 0.4e1 / 0.9e1 * t381 * t383 + 0.4e1 / 0.3e1 * t331 * t386)
  t391 = t379 + t390
  t392 = t363 * t391
  t395 = t339 * (-t343 * t167 + 0.1e1)
  t396 = t395 * t350
  t401 = f.my_piecewise3(t323, 0, 0.4e1 / 0.3e1 * t326 * t368)
  t404 = f.my_piecewise3(t330, 0, 0.4e1 / 0.3e1 * t331 * t382)
  t405 = t401 + t404
  t406 = t363 * t405
  t408 = t363 * t334
  t414 = 0.1e1 / t166 / t19
  t418 = t339 * (-0.12e2 * t340 * t167 + 0.32e2 * t341 * t345 - 0.20e2 * t343 * t414)
  t419 = t418 * t350
  t422 = -0.19441031218901976532597921525897358463476063416235e0 * t29 + 0.73578453447456598426849645372188715149258983353495e1 * t39 + 0.41454266666666666666666666666666666666666666666668e-1 * t94 + 0.27636177777777777777777777777777777777777777777779e-1 * t99 + 0.82908533333333333333333333333333333333333333333336e-1 * t122 + 0.27636177777777777777777777777777777777777777777779e-1 * t125 - 0.92120592592592592592592592592592592592592592592596e-2 * t131 + 0.41454266666666666666666666666666666666666666666668e-1 * t186 - t335 * t351 / 0.2e1 - t392 * t396 / 0.2e1 - t406 * t351 - t408 * t419 / 0.2e1
  t426 = jnp.log(t4 * t10 * t192 / 0.4e1)
  t429 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t239)
  t432 = jnp.log(t292 * t192)
  t435 = t189 * (t426 + 0.32323836906055067299704130765928097906535029214058e0 * t429 + 0.21608710360898267021763215722876235716176892439270e-1 * t432)
  t436 = t435 * t334
  t437 = t319 * t167
  t444 = 0.1e1 / t166 / t20
  t448 = t339 * (0.144e3 * t340 * t345 - 0.240e3 * t341 * t414 + 0.120e3 * t343 * t444 - 0.24e2 * t437)
  t449 = t448 * t350
  t453 = 0.1e1 / t364 / t322
  t457 = t365 * t368
  t461 = 0.6e1 * t372 - 0.6e1 * t437
  t465 = f.my_piecewise3(t323, 0, -0.8e1 / 0.27e2 * t453 * t369 * t368 + 0.4e1 / 0.3e1 * t457 * t375 + 0.4e1 / 0.3e1 * t326 * t461)
  t467 = 0.1e1 / t380 / t329
  t471 = t381 * t382
  t474 = -t461
  t478 = f.my_piecewise3(t330, 0, -0.8e1 / 0.27e2 * t467 * t383 * t382 + 0.4e1 / 0.3e1 * t471 * t386 + 0.4e1 / 0.3e1 * t331 * t474)
  t479 = t465 + t478
  t480 = t435 * t479
  t483 = t435 * t391
  t486 = t435 * t405
  t490 = t44 + 0.10061550000000000000000000000000000000000000000000e2 * t12 + 0.101578e3
  t491 = 0.1e1 / t490
  t493 = t4 * t75 * t491
  t495 = t490 ** 2
  t496 = 0.1e1 / t495
  t497 = t42 * t496
  t499 = -t56 - 0.16769250000000000000000000000000000000000000000000e1 * t61
  t504 = 0.1e1 / t495 / t490
  t505 = t9 * t504
  t506 = t499 ** 2
  t510 = t9 * t496
  t513 = t77 - 0.11179500000000000000000000000000000000000000000000e1 * t87 + 0.22359000000000000000000000000000000000000000000000e1 * t90
  t519 = (t493 / 0.9e1 + t51 * t497 * t499 / 0.6e1 + t51 * t505 * t506 / 0.2e1 - t51 * t510 * t513 / 0.4e1) * t68 * t70
  t520 = t72 * t490
  t531 = (-t4 * t43 * t491 / 0.12e2 - t51 * t510 * t499 / 0.4e1) * t68 * t70
  t532 = t97 * t490
  t535 = t72 * t499
  t538 = t12 + 0.201231e2
  t539 = t538 ** 2
  t540 = t539 * t538
  t542 = 0.1e1 / t540 * t1
  t543 = t542 * t3
  t544 = 0.1e1 / t539
  t546 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t544
  t547 = 0.1e1 / t546
  t552 = t544 * t79 * t68
  t558 = t544 * t57 * t1
  t563 = t539 ** 2
  t565 = 0.1e1 / t563 / t538
  t566 = t565 * t1
  t567 = t566 * t3
  t568 = t546 ** 2
  t569 = 0.1e1 / t568
  t574 = t275 + 0.743294e0
  t575 = t574 * t496
  t576 = t575 * t58
  t577 = t42 * t499
  t581 = t574 * t491
  t582 = t581 * t79
  t585 = t581 * t57
  t588 = t574 ** 2
  t589 = t588 * t504
  t592 = t588 * t496
  t594 = t493 / 0.72e2 + t576 * t59 * t577 / 0.3e1 - t582 * t286 / 0.9e1 + 0.2e1 / 0.9e1 * t585 * t76 + 0.2e1 * t589 * t506 - t592 * t513
  t595 = 0.1e1 / t588
  t596 = t594 * t595
  t602 = -t585 * t55 / 0.6e1 - t592 * t499
  t604 = 0.1e1 / t588 / t574
  t605 = t602 * t604
  t606 = t490 * t57
  t607 = t605 * t606
  t610 = t602 * t595
  t614 = t44 + 0.65360000000000000000000000000000000000000000000000e1 * t12 + 0.427198e2
  t615 = 0.1e1 / t614
  t617 = t4 * t75 * t615
  t619 = t614 ** 2
  t620 = 0.1e1 / t619
  t621 = t42 * t620
  t623 = -t56 - 0.10893333333333333333333333333333333333333333333333e1 * t61
  t628 = 0.1e1 / t619 / t614
  t629 = t9 * t628
  t630 = t623 ** 2
  t634 = t9 * t620
  t637 = t77 - 0.72622222222222222222222222222222222222222222222220e0 * t87 + 0.14524444444444444444444444444444444444444444444444e1 * t90
  t643 = (t617 / 0.9e1 + t51 * t621 * t623 / 0.6e1 + t51 * t629 * t630 / 0.2e1 - t51 * t634 * t637 / 0.4e1) * t68 * t70
  t644 = t72 * t614
  t655 = (-t4 * t43 * t615 / 0.12e2 - t51 * t634 * t623 / 0.4e1) * t68 * t70
  t656 = t97 * t614
  t659 = t72 * t623
  t662 = t12 + 0.130720e2
  t663 = t662 ** 2
  t664 = t663 * t662
  t666 = 0.1e1 / t664 * t1
  t667 = t666 * t3
  t668 = 0.1e1 / t663
  t670 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t668
  t671 = 0.1e1 / t670
  t676 = t668 * t79 * t68
  t682 = t668 * t57 * t1
  t687 = t663 ** 2
  t689 = 0.1e1 / t687 / t662
  t690 = t689 * t1
  t691 = t690 * t3
  t692 = t670 ** 2
  t693 = 0.1e1 / t692
  t698 = t275 + 0.409286e0
  t699 = t698 * t620
  t700 = t699 * t58
  t701 = t42 * t623
  t705 = t698 * t615
  t706 = t705 * t79
  t709 = t705 * t57
  t712 = t698 ** 2
  t713 = t712 * t628
  t716 = t712 * t620
  t718 = t617 / 0.72e2 + t700 * t59 * t701 / 0.3e1 - t706 * t286 / 0.9e1 + 0.2e1 / 0.9e1 * t709 * t76 + 0.2e1 * t713 * t630 - t716 * t637
  t719 = 0.1e1 / t712
  t720 = t718 * t719
  t726 = -t709 * t55 / 0.6e1 - t716 * t623
  t728 = 0.1e1 / t712 / t698
  t729 = t726 * t728
  t730 = t614 * t57
  t731 = t729 * t730
  t734 = t726 * t719
  t737 = 0.51817833333333333333333333333333333333333333333333e-2 * t519 * t520 + 0.17272611111111111111111111111111111111111111111111e-2 * t531 * t532 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t535 + 0.40281109727029913916296135613123207752077929301677e-1 * t543 * t75 * t547 + 0.80562219454059827832592271226246415504155858603353e-1 * t552 * t82 * t85 * t547 - 0.16112443890811965566518454245249283100831171720671e0 * t558 * t59 * t74 * t547 - 0.55299776073946902741997911947426632387660200240483e-1 * t567 * t75 * t569 + 0.26673100072733151593315970562575695370840511204614e-2 * t596 * t490 + 0.44455166787888585988859950937626158951400852007690e-3 * t607 * t55 + 0.26673100072733151593315970562575695370840511204614e-2 * t610 * t499 - 0.10363566666666666666666666666666666666666666666667e-1 * t643 * t644 - 0.34545222222222222222222222222222222222222222222223e-2 * t655 * t656 - 0.10363566666666666666666666666666666666666666666667e-1 * t655 * t659 - 0.51190794422689743246913327132388312572792631042033e-1 * t667 * t75 * t671 - 0.10238158884537948649382665426477662514558526208407e0 * t676 * t82 * t85 * t671 + 0.20476317769075897298765330852955325029117052416813e0 * t682 * t59 * t74 * t671 + 0.10320064155614252238577726749889483814674994418074e-3 * t691 * t75 * t693 - 0.44313737677495382697984551091739236689629774931818e-2 * t720 * t614 - 0.73856229462492304496640918486232061149382958219697e-3 * t731 * t55 - 0.44313737677495382697984551091739236689629774931818e-2 * t734 * t623
  t738 = t737 * t405
  t742 = t24 * t57 * t1
  t745 = t742 * t59 * t22 * t27
  t747 = t275 + 0.10498e0
  t748 = t747 * t47
  t749 = t748 * t57
  t752 = t747 ** 2
  t753 = t752 * t53
  t755 = -t749 * t55 / 0.6e1 - t753 * t63
  t756 = t752 ** 2
  t757 = 0.1e1 / t756
  t758 = t755 * t757
  t759 = t758 * t46
  t760 = t759 * t76
  t763 = t24 * t79 * t68
  t766 = t763 * t82 * t171 * t27
  t768 = 0.1e1 / t81
  t769 = t17 * t768
  t770 = t2 * t27
  t772 = t769 * t23 * t770
  t774 = t34 * t768
  t775 = t2 * t37
  t777 = t774 * t23 * t775
  t779 = 0.1e1 / t31
  t780 = t779 * t68
  t781 = t780 * t81
  t782 = t5 * t171
  t783 = t27 * t57
  t785 = t781 * t782 * t783
  t788 = 0.1e1 / t31 / t14
  t789 = t788 * t68
  t790 = t789 * t81
  t791 = t37 * t57
  t793 = t790 * t782 * t791
  t795 = -t436 * t449 / 0.6e1 - t480 * t396 / 0.6e1 - t483 * t351 / 0.2e1 - t486 * t419 / 0.2e1 - 0.12e2 * t738 * t395 + 0.49486261284477758446612891156829639725211797786780e0 * t745 + 0.16150379519240623689600657201760358175082247499085e-3 * t760 - 0.42416795386695221525668192420139691193038683817240e0 * t766 + 0.88368323722281711511808734208624356652163924619249e-2 * t772 - 0.33444751567025726557658929714631234158754083342496e0 * t777 + 0.10604198846673805381417048105034922798259670954310e0 * t785 - 0.93645304387672034361445003200967455644511433358993e1 * t793
  t797 = t31 ** 2
  t798 = 0.1e1 / t797
  t799 = t798 * t68
  t800 = t799 * t81
  t802 = 0.1e1 / t36 / t26
  t803 = t802 * t57
  t805 = t800 * t782 * t803
  t823 = 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t520 + 0.12084332918108974174888840683936962325623378790503e0 * t558 * t59 * t42 * t547 + 0.26673100072733151593315970562575695370840511204614e-2 * t610 * t490 - 0.10363566666666666666666666666666666666666666666667e-1 * t655 * t644 - 0.15357238326806922974073998139716493771837789312610e0 * t682 * t59 * t42 * t671 - 0.44313737677495382697984551091739236689629774931818e-2 * t734 * t614
  t824 = t823 * t405
  t830 = jnp.log(t4 * t10 * t491 / 0.4e1)
  t834 = jnp.atan(0.11716852777089929792201907797022178188779527234376e1 / t538)
  t837 = jnp.log(t588 * t491)
  t842 = jnp.log(t4 * t10 * t615 / 0.4e1)
  t846 = jnp.atan(0.44899888641287296627004984787798591621072237693345e-1 / t662)
  t849 = jnp.log(t712 * t615)
  t851 = 0.1554535e-1 * t830 + 0.61881802979060631480216141626488805225499304723700e0 * t834 + 0.26673100072733151593315970562575695370840511204614e-2 * t837 - 0.310907e-1 * t842 - 0.20521972937837502661166379517614390730124411627871e2 * t846 - 0.44313737677495382697984551091739236689629774931818e-2 * t849
  t852 = t851 * t405
  t856 = 0.1e1 / t752 / t747
  t857 = t755 * t856
  t858 = t46 * t57
  t859 = t857 * t858
  t860 = t859 * t76
  t863 = t747 * t53
  t864 = t863 * t58
  t865 = t42 * t63
  t869 = t748 * t79
  t874 = t752 * t109
  t878 = t102 / 0.72e2 + t864 * t59 * t865 / 0.3e1 - t869 * t286 / 0.9e1 + 0.2e1 / 0.9e1 * t749 * t76 + 0.2e1 * t874 * t111 - t753 * t92
  t879 = t878 * t856
  t880 = t879 * t858
  t881 = t880 * t55
  t883 = t63 * t57
  t884 = t857 * t883
  t885 = t884 * t55
  t887 = t46 * t79
  t888 = t857 * t887
  t889 = t888 * t286
  t892 = 0.1e1 / t8 / t166
  t896 = 0.41238551070398132038844075964024699771009831488983e0 * t742 * t59 * t892 * t27
  t898 = 0.14804514559303905048800602434946994993825393540828e-3 * t759 * t158
  t900 = 0.1e1 / t83 / t166
  t901 = t5 * t900
  t904 = 0.19441031218901976532597921525897358463476063416234e0 * t781 * t901 * t783
  t907 = 0.17168305804406539632931583920177366868160429449148e2 * t790 * t901 * t791
  t910 = 0.37129640917784654580181051383469886637668330434323e3 * t800 * t901 * t803
  t915 = t36 ** 2
  t918 = t70 * t5
  t921 = 0.19162434373246948642083122762742588170998040494372e4 / t797 / t15 * t2 * t900 / t915 * t68 * t918
  t924 = 0.12112784639430467767200492901320268631311685624314e-3 * t758 * t63 * t76
  t925 = t6 * t892
  t928 = 0.16200859349084980443831601271581132052896719513529e-1 * t769 * t925 * t770
  t931 = 0.61315377872880498689041371143490595957715819461244e0 * t774 * t925 * t775
  t937 = 0.17673664744456342302361746841724871330432784923849e-1 * t33 * t2 * t900 * t27 * t68 * t918
  t946 = 0.26755801253620581246127143771704987327003266673998e1 / t31 / t15 * t2 * t900 * t37 * t68 * t918
  t954 = 0.12657832131062950425061722062546552262841476284429e3 / t797 / t13 * t2 * t900 * t802 * t68 * t918
  t958 = 0.47129772651883579472964658244599656881154093130267e0 * t763 * t82 * t900 * t27
  t962 = 0.12112784639430467767200492901320268631311685624314e-3 * t878 * t757 * t46 * t76
  t963 = t588 ** 2
  t964 = 0.1e1 / t963
  t965 = t602 * t964
  t966 = t965 * t490
  t969 = 0.1e1 / t563
  t970 = t969 * t68
  t971 = t970 * t81
  t972 = t547 * t57
  t977 = 0.1e1 / t563 / t539
  t978 = t977 * t68
  t979 = t978 * t81
  t980 = t569 * t57
  t984 = t542 * t768
  t985 = t2 * t547
  t989 = t566 * t768
  t990 = t2 * t569
  t994 = t563 ** 2
  t995 = 0.1e1 / t994
  t996 = t995 * t68
  t997 = t996 * t81
  t999 = 0.1e1 / t568 / t546
  t1000 = t999 * t57
  t1020 = t687 ** 2
  t1021 = 0.1e1 / t1020
  t1022 = t1021 * t68
  t1023 = t1022 * t81
  t1025 = 0.1e1 / t692 / t670
  t1026 = t1025 * t57
  t1031 = t4 * t23 * t491
  t1033 = t74 * t496
  t1035 = t51 * t1033 * t499
  t1037 = t42 * t504
  t1044 = t495 ** 2
  t1045 = 0.1e1 / t1044
  t1046 = t9 * t1045
  t1047 = t506 * t499
  t1051 = t499 * t513
  t1058 = -t159 - 0.67077000000000000000000000000000000000000000000000e1 * t168 + 0.44718000000000000000000000000000000000000000000000e1 * t173 - 0.52171000000000000000000000000000000000000000000000e1 * t176
  t1064 = (-0.7e1 / 0.27e2 * t1031 - t1035 / 0.3e1 - t51 * t1037 * t506 / 0.2e1 + t51 * t497 * t513 / 0.4e1 - 0.3e1 / 0.2e1 * t51 * t1046 * t1047 + 0.3e1 / 0.2e1 * t51 * t505 * t1051 - t51 * t510 * t1058 / 0.4e1) * t68 * t70
  t1067 = 0.11113791696972146497214987734406539737850213001922e-3 * t966 * t76 + 0.80562219454059827832592271226246415504155858603354e-1 * t971 * t782 * t972 - 0.25806562167841887946265692242132428447574760112225e0 * t979 * t782 * t980 + 0.67135182878383189860493559355205346253463215502794e-2 * t984 * t23 * t985 - 0.92166293456578171236663186579044387312767000400800e-2 * t989 * t23 * t990 + 0.20244826120247034261608782614550005883535036385819e0 * t997 * t782 * t1000 + 0.40952635538151794597530661705910650058234104833627e0 * t676 * t82 * t171 * t671 - 0.47778074794510427030452438656895758401273122305897e0 * t682 * t59 * t22 * t671 - 0.32224887781623931133036908490498566201662343441341e0 * t552 * t82 * t171 * t547 + 0.37595702411894586321876393238914993901939400681566e0 * t558 * t59 * t22 * t547 - 0.55480664900582220034593859007405864987692769991566e-6 * t1023 * t782 * t1026 + 0.51817833333333333333333333333333333333333333333333e-2 * t1064 * t520
  t1071 = t668 * t164
  t1072 = t2 * t167
  t1076 = t544 * t164
  t1080 = t97 * t623
  t1088 = t72 * t637
  t1091 = t712 ** 2
  t1092 = 0.1e1 / t1091
  t1093 = t726 * t1092
  t1094 = t1093 * t614
  t1097 = 0.1e1 / t687
  t1098 = t1097 * t68
  t1099 = t1098 * t81
  t1100 = t671 * t57
  t1105 = 0.1e1 / t687 / t663
  t1106 = t1105 * t68
  t1107 = t1106 * t81
  t1108 = t693 * t57
  t1112 = t666 * t768
  t1113 = t2 * t671
  t1117 = t690 * t768
  t1118 = t2 * t693
  t1122 = 0.18769957954986239190534886615209047943357298048745e0 * t667 * t23 * t671 - 0.61428953307227691896295992558865975087351157250442e0 * t1071 * t1072 * t671 + 0.48337331672435896699555362735747849302493515162012e0 * t1076 * t1072 * t547 - 0.69090444444444444444444444444444444444444444444446e-2 * t655 * t1080 - 0.37840235237252258208118331416261440653808312866271e-3 * t691 * t23 * t693 - 0.20727133333333333333333333333333333333333333333334e-1 * t643 * t659 - 0.10363566666666666666666666666666666666666666666667e-1 * t655 * t1088 - 0.18464057365623076124160229621558015287345739554924e-3 * t1094 * t76 - 0.10238158884537948649382665426477662514558526208407e0 * t1099 * t782 * t1100 + 0.48160299392866510446696058166150924468483307284345e-3 * t1107 * t782 * t1108 - 0.85317990704482905411522211887313854287987718403392e-2 * t1112 * t23 * t1113 + 0.17200106926023753730962877916482473024458324030124e-4 * t1117 * t23 * t1118
  t1126 = t129 * t614
  t1138 = t574 * t504
  t1139 = t1138 * t58
  t1143 = t575 * t80
  t1157 = t1 * t768 * t6
  t1158 = t22 * t2
  t1164 = t160 * t782
  t1169 = t588 * t1045
  t1175 = -0.11e2 / 0.216e3 * t1031 - t1035 / 0.24e2 - t1139 * t59 * t42 * t506 + t1143 * t82 * t85 * t499 / 0.3e1 - 0.2e1 / 0.3e1 * t576 * t59 * t74 * t499 + t576 * t59 * t42 * t513 / 0.2e1 + t1157 * t1158 * t491 / 0.432e3 - 0.2e1 / 0.3e1 * t581 * t168 + 0.4e1 / 0.9e1 * t582 * t1164 - 0.14e2 / 0.27e2 * t585 * t158 - 0.6e1 * t1169 * t1047 + 0.6e1 * t589 * t1051 - t592 * t1058
  t1176 = t1175 * t595
  t1184 = t4 * t23 * t615
  t1186 = t74 * t620
  t1188 = t51 * t1186 * t623
  t1190 = t698 * t628
  t1191 = t1190 * t58
  t1195 = t699 * t80
  t1217 = t619 ** 2
  t1218 = 0.1e1 / t1217
  t1219 = t712 * t1218
  t1220 = t630 * t623
  t1223 = t623 * t637
  t1229 = -t159 - 0.43573333333333333333333333333333333333333333333332e1 * t168 + 0.29048888888888888888888888888888888888888888888888e1 * t173 - 0.33890370370370370370370370370370370370370370370369e1 * t176
  t1231 = -0.11e2 / 0.216e3 * t1184 - t1188 / 0.24e2 - t1191 * t59 * t42 * t630 + t1195 * t82 * t85 * t623 / 0.3e1 - 0.2e1 / 0.3e1 * t700 * t59 * t74 * t623 + t700 * t59 * t42 * t637 / 0.2e1 + t1157 * t1158 * t615 / 0.432e3 - 0.2e1 / 0.3e1 * t705 * t168 + 0.4e1 / 0.9e1 * t706 * t1164 - 0.14e2 / 0.27e2 * t709 * t158 - 0.6e1 * t1219 * t1220 + 0.6e1 * t713 * t1223 - t716 * t1229
  t1232 = t1231 * t719
  t1239 = t718 * t728
  t1240 = t1239 * t730
  t1243 = -0.69090444444444444444444444444444444444444444444446e-2 * t643 * t656 + 0.23030148148148148148148148148148148148148148148149e-2 * t655 * t1126 - 0.14769740233244301769308583058145176175761907410615e0 * t543 * t23 * t547 + 0.98474972616656405995521224648309414865843944292929e-3 * t731 * t76 - 0.59273555717184781318479934583501545268534469343587e-3 * t607 * t76 + 0.26673100072733151593315970562575695370840511204614e-2 * t1176 * t490 + 0.53346200145466303186631941125151390741681022409228e-2 * t596 * t499 + 0.26673100072733151593315970562575695370840511204614e-2 * t610 * t513 - 0.44313737677495382697984551091739236689629774931818e-2 * t1232 * t614 - 0.88627475354990765395969102183478473379259549863636e-2 * t720 * t623 - 0.44313737677495382697984551091739236689629774931818e-2 * t734 * t637 - 0.14771245892498460899328183697246412229876591643939e-2 * t1240 * t55
  t1244 = t623 * t57
  t1245 = t729 * t1244
  t1248 = t614 * t79
  t1249 = t729 * t1248
  t1252 = t594 * t604
  t1253 = t1252 * t606
  t1256 = t499 * t57
  t1257 = t605 * t1256
  t1260 = t490 * t79
  t1261 = t605 * t1260
  t1266 = t129 * t490
  t1271 = t42 * t628
  t1278 = t9 * t1218
  t1290 = (-0.7e1 / 0.27e2 * t1184 - t1188 / 0.3e1 - t51 * t1271 * t630 / 0.2e1 + t51 * t621 * t637 / 0.4e1 - 0.3e1 / 0.2e1 * t51 * t1278 * t1220 + 0.3e1 / 0.2e1 * t51 * t629 * t1223 - t51 * t634 * t1229 / 0.4e1) * t68 * t70
  t1296 = t72 * t513
  t1299 = t97 * t499
  t1304 = -0.14771245892498460899328183697246412229876591643939e-2 * t1245 * t55 - 0.49237486308328202997760612324154707432921972146465e-3 * t1249 * t286 + 0.88910333575777171977719901875252317902801704015380e-3 * t1253 * t55 + 0.88910333575777171977719901875252317902801704015380e-3 * t1257 * t55 + 0.29636777858592390659239967291750772634267234671793e-3 * t1261 * t286 + 0.34545222222222222222222222222222222222222222222222e-2 * t519 * t532 - 0.11515074074074074074074074074074074074074074074074e-2 * t531 * t1266 - 0.10363566666666666666666666666666666666666666666667e-1 * t1290 * t644 + 0.20276584560447197672065901047389765208808740088178e0 * t567 * t23 * t569 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t1296 + 0.34545222222222222222222222222222222222222222222222e-2 * t531 * t1299 + 0.10363566666666666666666666666666666666666666666667e-1 * t519 * t535
  t1306 = t1067 + t1122 + t1243 + t1304
  t1307 = t1306 * t334
  t1317 = t318 * t405
  t1322 = t747 * t109
  t1323 = t1322 * t58
  t1327 = t863 * t80
  t1349 = t752 * t148
  t1355 = -0.11e2 / 0.216e3 * t134 - t138 / 0.24e2 - t1323 * t59 * t42 * t111 + t1327 * t82 * t85 * t63 / 0.3e1 - 0.2e1 / 0.3e1 * t864 * t59 * t74 * t63 + t864 * t59 * t42 * t92 / 0.2e1 + t1157 * t1158 * t47 / 0.432e3 - 0.2e1 / 0.3e1 * t748 * t168 + 0.4e1 / 0.9e1 * t869 * t1164 - 0.14e2 / 0.27e2 * t749 * t158 - 0.6e1 * t1349 * t150 + 0.6e1 * t874 * t154 - t753 * t178
  t1359 = 0.48451138557721871068801971605281074525246742497255e-3 * t1355 * t856 * t858 * t55
  t1362 = 0.96902277115443742137603943210562149050493484994510e-3 * t879 * t883 * t55
  t1363 = -t946 + t954 + t958 + t962 - 0.4e1 * t1307 * t349 - 0.4e1 * t852 * t448 - t363 * t479 * t396 / 0.6e1 - t392 * t351 / 0.2e1 - t1317 * t351 / 0.2e1 + t1359 + t1362
  t1366 = 0.64601518076962494758402628807041432700328989996340e-3 * t880 * t76
  t1368 = 0.64601518076962494758402628807041432700328989996340e-3 * t884 * t76
  t1370 = t900 * t2
  t1373 = 0.44184161861140855755904367104312178326081962309624e-2 * t780 * t918 * t1370 * t783
  t1377 = 0.39018876828196680983935418000403106518546430566246e0 * t789 * t918 * t1370 * t791
  t1381 = 0.84385547540419669500411480416977015085609841896189e1 * t799 * t918 * t1370 * t803
  t1383 = 0.50245625170970829256535377961032225433589214441597e-3 * t859 * t158
  t1387 = t768 * t6 * t1158
  t1389 = 0.67293247996835932040002738340668159062842697912856e-5 * t758 * t46 * t1 * t1387
  t1396 = t82 * t171 * t57
  t1398 = 0.53834598397468745632002190672534527250274158330283e-4 * t755 / t756 / t747 * t46 * t68 * t1396
  t1402 = 0.1e1 / t12 / t2 / t320 / 0.48e2
  t1405 = 0.1e1 / t8 / t344
  t1406 = t2 * t1405
  t1411 = 0.13255248558342256726771310131293653497824588692887e0 * t24 * t1402 * t1406 * t27 * t1 * t59
  t1414 = 0.32300759038481247379201314403520716350164494998170e-3 * t879 * t887 * t286
  t1419 = 0.48451138557721871068801971605281074525246742497255e-3 * t857 * t92 * t57 * t55
  t1423 = 0.32300759038481247379201314403520716350164494998170e-3 * t857 * t63 * t79 * t286
  t1425 = 0.43067678717974996505601752538027621800219326664227e-3 * t888 * t1164
  t1433 = t319 * t345
  t1439 = t166 ** 2
  t1444 = t339 * (-0.24e2 * t167 + 0.384e3 * t1433 - 0.1440e4 * t340 * t414 + 0.1920e4 * t341 * t444 - 0.840e3 * t343 / t1439)
  t1448 = t322 ** 2
  t1451 = t369 ** 2
  t1457 = t375 ** 2
  t1463 = -0.24e2 * t167 + 0.24e2 * t1433
  t1467 = f.my_piecewise3(t323, 0, 0.40e2 / 0.81e2 / t364 / t1448 * t1451 - 0.16e2 / 0.9e1 * t453 * t369 * t375 + 0.4e1 / 0.3e1 * t365 * t1457 + 0.16e2 / 0.9e1 * t457 * t461 + 0.4e1 / 0.3e1 * t326 * t1463)
  t1468 = t329 ** 2
  t1471 = t383 ** 2
  t1477 = t386 ** 2
  t1486 = f.my_piecewise3(t330, 0, 0.40e2 / 0.81e2 / t380 / t1468 * t1471 - 0.16e2 / 0.9e1 * t467 * t383 * t386 + 0.4e1 / 0.3e1 * t381 * t1477 + 0.16e2 / 0.9e1 * t471 * t474 - 0.4e1 / 0.3e1 * t331 * t1463)
  t1487 = t1467 + t1486
  t1498 = t1419 + t1423 - t1425 - t335 * t419 / 0.4e1 - t483 * t419 / 0.4e1 - t486 * t449 / 0.6e1 - t436 * t1444 * t350 / 0.24e2 - t435 * t1487 * t396 / 0.24e2 - t480 * t351 / 0.6e1 - t408 * t449 / 0.6e1 - 0.4e1 * t1306 * t405 * t395
  t1502 = 0.31090700000000000000000000000000000000000000000001e-1 * t120 * t93
  t1504 = 0.69090444444444444444444444444444444444444444444446e-2 * t120 * t130
  t1507 = 0.69090444444444444444444444444444444444444444444446e-2 * t71 * t129 * t63
  t1509 = 0.31090700000000000000000000000000000000000000000001e-1 * t184 * t121
  t1512 = 0.10363566666666666666666666666666666666666666666667e-1 * t71 * t72 * t178
  t1514 = 0.20727133333333333333333333333333333333333333333334e-1 * t120 * t98
  t1516 = t4 * t925 * t47
  t1520 = t51 * t22 * t53 * t63
  t1524 = t51 * t74 * t109 * t111
  t1527 = t51 * t136 * t92
  t1540 = 0.1e1 / t147 / t46
  t1542 = t111 ** 2
  t1546 = t111 * t92
  t1550 = t92 ** 2
  t1554 = t63 * t178
  t1558 = t4 * t925
  t1559 = 0.70e2 / 0.81e2 * t1558
  t1560 = t1402 * t2
  t1562 = t1560 * t1405 * t51
  t1564 = t165 * t345
  t1567 = t80 * t82 * t900
  t1570 = t58 * t59 * t892
  t1572 = t1559 - 0.10354000000000000000000000000000000000000000000000e1 * t1562 + 0.99398400000000000000000000000000000000000000000000e1 * t1564 - 0.36814222222222222222222222222222222222222222222222e1 * t1567 + 0.32212444444444444444444444444444444444444444444444e1 * t1570
  t1576 = 0.70e2 / 0.81e2 * t1516 + 0.28e2 / 0.27e2 * t1520 + 0.4e1 / 0.3e1 * t1524 - 0.2e1 / 0.3e1 * t1527 + 0.2e1 * t51 * t42 * t148 * t150 - 0.2e1 * t51 * t140 * t154 + t51 * t104 * t178 / 0.3e1 + 0.6e1 * t51 * t9 * t1540 * t1542 - 0.9e1 * t51 * t149 * t1546 + 0.3e1 / 0.2e1 * t51 * t110 * t1550 + 0.2e1 * t51 * t110 * t1554 - t51 * t54 * t1572 / 0.4e1
  t1580 = 0.10363566666666666666666666666666666666666666666667e-1 * t1576 * t68 * t70 * t185
  t1583 = 0.10363566666666666666666666666666666666666666666667e-1 * t71 * t97 * t92
  t1586 = 0.20435174860777645787105769785744382475812907568201e0 * t18 * t925 * t27
  t1589 = 0.77340987998746992664586274965084728992118817729523e1 * t35 * t925 * t37
  t1593 = 0.38383580246913580246913580246913580246913580246915e-2 * t71 * t285 * t46
  t1594 = t245 * t164
  t1598 = t292 ** 2
  t1599 = 0.1e1 / t1598
  t1600 = t306 * t1599
  t1601 = t1600 * t191
  t1605 = 0.1e1 / t264 / t240
  t1606 = t1605 * t68
  t1607 = t1606 * t81
  t1608 = t270 * t57
  t1612 = t243 * t768
  t1613 = t2 * t248
  t1617 = t267 * t768
  t1618 = t2 * t270
  t1622 = t264 ** 2
  t1623 = 0.1e1 / t1622
  t1624 = t1623 * t68
  t1625 = t1624 * t81
  t1627 = 0.1e1 / t269 / t247
  t1628 = t1627 * t57
  t1632 = t129 * t191
  t1638 = 0.1e1 / t264
  t1639 = t1638 * t68
  t1640 = t1639 * t81
  t1641 = t248 * t57
  t1650 = t72 * t214
  t1653 = 0.14420896359956903410707543094073145654541709205109e1 * t1594 * t1072 * t248 + 0.90036293170409445924013398845317648817403718496958e-3 * t1601 * t76 - 0.25115336796353019597335914738290663784003826116781e2 * t1607 * t782 * t1608 + 0.20029022722162365848204920963990480075752373895984e-1 * t1612 * t23 * t1613 - 0.89697631415546498561913981208180942085727950417076e0 * t1617 * t23 * t1618 + 0.64272053155397178166610502978456596616246611440970e3 * t1625 * t782 * t1628 - 0.2e1 / 0.27e2 * t232 * t1632 - 0.44063849988757204866050826120779056166655222571167e0 * t244 * t23 * t248 + 0.24034827266594839017845905156788576090902848675182e0 * t1640 * t782 * t1641 + 0.2e1 / 0.9e1 * t220 * t233 + 0.19733478911420229683621075865799807258860149091757e2 * t268 * t23 * t270 + t232 * t1650 / 0.3e1
  t1654 = t97 * t200
  t1660 = t4 * t23 * t192
  t1662 = t74 * t197
  t1664 = t51 * t1662 * t200
  t1666 = t42 * t205
  t1673 = t196 ** 2
  t1674 = 0.1e1 / t1673
  t1675 = t9 * t1674
  t1676 = t207 * t200
  t1680 = t200 * t214
  t1687 = -t159 - 0.35611666666666666666666666666666666666666666666667e0 * t168 + 0.23741111111111111111111111111111111111111111111111e0 * t173 - 0.27697962962962962962962962962962962962962962962964e0 * t176
  t1693 = (-0.7e1 / 0.27e2 * t1660 - t1664 / 0.3e1 - t51 * t1666 * t207 / 0.2e1 + t51 * t198 * t214 / 0.4e1 - 0.3e1 / 0.2e1 * t51 * t1675 * t1676 + 0.3e1 / 0.2e1 * t51 * t206 * t1680 - t51 * t211 * t1687 / 0.4e1) * t68 * t70
  t1708 = t276 * t205
  t1709 = t1708 * t58
  t1713 = t277 * t80
  t1735 = t292 * t1674
  t1741 = -0.11e2 / 0.216e3 * t1660 - t1664 / 0.24e2 - t1709 * t59 * t42 * t207 + t1713 * t82 * t85 * t200 / 0.3e1 - 0.2e1 / 0.3e1 * t278 * t59 * t74 * t200 + t278 * t59 * t42 * t214 / 0.2e1 + t1157 * t1158 * t192 / 0.432e3 - 0.2e1 / 0.3e1 * t283 * t168 + 0.4e1 / 0.9e1 * t284 * t1164 - 0.14e2 / 0.27e2 * t289 * t158 - 0.6e1 * t1735 * t1676 + 0.6e1 * t293 * t1680 - t296 * t1687
  t1742 = t1741 * t299
  t1749 = t298 * t308
  t1750 = t1749 * t310
  t1753 = t200 * t57
  t1754 = t309 * t1753
  t1757 = t191 * t79
  t1758 = t309 * t1757
  t1761 = 0.2e1 / 0.9e1 * t232 * t1654 + 0.2e1 / 0.3e1 * t220 * t236 + t1693 * t221 / 0.3e1 - 0.96139309066379356071383620627154304363611394700724e0 * t253 * t82 * t171 * t248 - 0.48019356357551704492807146050836079369281983198377e-2 * t311 * t76 + 0.11216252724410924874994755739834668842421329381751e1 * t259 * t59 * t22 * t248 + 0.21608710360898267021763215722876235716176892439270e-1 * t1742 * t191 + 0.43217420721796534043526431445752471432353784878540e-1 * t300 * t200 + 0.21608710360898267021763215722876235716176892439270e-1 * t314 * t214 + 0.72029034536327556739210719076254119053922974797566e-2 * t1750 * t55 + 0.72029034536327556739210719076254119053922974797566e-2 * t1754 * t55 + 0.24009678178775852246403573025418039684640991599189e-2 * t1758 * t286
  t1763 = t189 * (t1653 + t1761)
  t1764 = t1763 * t334
  t1767 = t24 * t164
  t1768 = t2 * t345
  t1771 = 0.12725038616008566457700457726041907357911605145172e1 * t1767 * t1768 * t27
  t1776 = 0.46822652193836017180722501600483727822255716679496e1 * t788 * t2 * t345 * t37 * t79
  t1781 = 0.10126265704850360340049377650037241810273181027543e3 * t798 * t2 * t345 * t802 * t79
  t1786 = 0.53020994233369026907085240525174613991298354771548e-1 * t779 * t2 * t345 * t27 * t79
  t1787 = t737 * t334
  t1822 = t4 * t925 * t491
  t1826 = t51 * t22 * t496 * t499
  t1830 = t51 * t74 * t504 * t506
  t1833 = t51 * t1033 * t513
  t1846 = 0.1e1 / t1044 / t490
  t1848 = t506 ** 2
  t1852 = t506 * t513
  t1856 = t513 ** 2
  t1860 = t499 * t1058
  t1868 = t1559 - 0.55897500000000000000000000000000000000000000000000e1 * t1562 + 0.53661600000000000000000000000000000000000000000000e2 * t1564 - 0.19874666666666666666666666666666666666666666666667e2 * t1567 + 0.17390333333333333333333333333333333333333333333333e2 * t1570
  t1872 = 0.70e2 / 0.81e2 * t1822 + 0.28e2 / 0.27e2 * t1826 + 0.4e1 / 0.3e1 * t1830 - 0.2e1 / 0.3e1 * t1833 + 0.2e1 * t51 * t42 * t1045 * t1047 - 0.2e1 * t51 * t1037 * t1051 + t51 * t497 * t1058 / 0.3e1 + 0.6e1 * t51 * t9 * t1846 * t1848 - 0.9e1 * t51 * t1046 * t1852 + 0.3e1 / 0.2e1 * t51 * t505 * t1856 + 0.2e1 * t51 * t505 * t1860 - t51 * t510 * t1868 / 0.4e1
  t1884 = 0.67588615201490658906886336824632550696029133627253e-1 * t989 * t925 * t990 - 0.14846205821514491791846440584003337647925693349601e1 * t997 * t901 * t1000 - 0.18201171350289686487791405202626955581437379926057e1 * t676 * t82 * t900 * t671 + 0.15926024931503475676817479552298586133757707435299e1 * t682 * t59 * t892 * t671 + 0.14322172347388413836905292662443807200738819307263e1 * t552 * t82 * t900 * t547 - 0.12531900803964862107292131079638331300646466893855e1 * t558 * t59 * t892 * t547 - 0.59078960932977207077234332232580704703047629642460e0 * t971 * t901 * t972 + 0.18924812256417384493928174310897114194888157415632e1 * t979 * t901 * t980 - 0.49232467444147672564361943527150587252539691368716e-1 * t984 * t925 * t985 + 0.51817833333333333333333333333333333333333333333333e-2 * t1872 * t68 * t70 * t520 - 0.44313737677495382697984551091739236689629774931817e-2 * t1239 * t1244 * t55 - 0.22156868838747691348992275545869618344814887465909e-2 * t729 * t637 * t57 * t55
  t1931 = 0.13830496334009782307645318069483693895991376180170e-2 * t607 * t158 - 0.17782066715155434395543980375050463580560340803076e-2 * t1257 * t76 - 0.11854711143436956263695986916700309053706893868717e-2 * t1261 * t1164 - 0.22977493610553161398954952417938863468696920335017e-2 * t731 * t158 + 0.33741376867078390436014637690916676472558393976364e-1 * t996 * t918 * t1370 * t1000 + 0.69090444444444444444444444444444444444444444444446e-2 * t655 * t129 * t623 + 0.49143162645782153517036794047092780069880925800353e1 * t1071 * t1768 * t671 - 0.38669865337948717359644290188598279441994812129610e1 * t1076 * t1768 * t547 - 0.51613124335683775892531384484264856895149520224450e0 * t977 * t2 * t345 * t569 * t79 + 0.40489652240494068523217565229100011767070072771638e0 * t995 * t2 * t345 * t999 * t79 - 0.11096132980116444006918771801481172997538553998313e-5 * t1021 * t2 * t345 * t1025 * t79 - 0.20476317769075897298765330852955325029117052416814e0 * t1097 * t2 * t345 * t671 * t79 + 0.96320598785733020893392116332301848936966614568690e-3 * t1105 * t2 * t345 * t693 * t79
  t1946 = t160 * t901
  t1957 = t51 * t22 * t620 * t623
  t1961 = t51 * t74 * t628 * t630
  t1964 = t51 * t1186 * t637
  t1967 = t4 * t925 * t615
  t1969 = t892 * t2
  t1977 = t623 * t1229
  t1980 = 0.16e2 / 0.3e1 * t705 * t1564 - t1157 * t1158 * t620 * t623 / 0.108e3 - 0.160e3 / 0.81e2 * t706 * t1946 + 0.140e3 / 0.81e2 * t709 * t1558 - 0.4e1 * t1191 * t59 * t701 * t637 + 0.11e2 / 0.54e2 * t1957 + t1961 / 0.6e1 - t1964 / 0.12e2 + 0.185e3 / 0.864e3 * t1967 - 0.11e2 / 0.648e3 * t1157 * t1969 * t615 + 0.8e1 / 0.3e1 * t699 * t164 * t1072 * t623 + 0.8e1 * t713 * t1977
  t1981 = t630 * t637
  t1984 = t637 ** 2
  t1988 = 0.1e1 / t1217 / t614
  t1990 = t630 ** 2
  t1997 = t1559 - 0.36311111111111111111111111111111111111111111111110e1 * t1562 + 0.34858666666666666666666666666666666666666666666666e2 * t1564 - 0.12910617283950617283950617283950617283950617283950e2 * t1567 + 0.11296790123456790123456790123456790123456790123456e2 * t1570
  t2009 = t1405 * t1 * t59
  t2039 = -0.36e2 * t1219 * t1981 + 0.6e1 * t713 * t1984 + 0.24e2 * t712 * t1988 * t1990 - t716 * t1997 - 0.4e1 / 0.3e1 * t700 * t59 * t74 * t637 + 0.2e1 / 0.3e1 * t700 * t59 * t42 * t1229 - 0.5e1 / 0.9e1 * t705 * t1560 * t2009 - 0.4e1 / 0.3e1 * t1190 * t80 * t82 * t85 * t630 + 0.2e1 / 0.3e1 * t1195 * t82 * t85 * t637 + 0.4e1 * t698 * t1218 * t58 * t59 * t42 * t1220 + 0.8e1 / 0.3e1 * t1191 * t59 * t74 * t630 - 0.16e2 / 0.9e1 * t1195 * t82 * t171 * t623 + 0.56e2 / 0.27e2 * t700 * t59 * t22 * t623
  t2077 = 0.16e2 / 0.3e1 * t581 * t1564 - t1157 * t1158 * t496 * t499 / 0.108e3 - 0.160e3 / 0.81e2 * t582 * t1946 + 0.140e3 / 0.81e2 * t585 * t1558 - 0.4e1 * t1139 * t59 * t577 * t513 - 0.11e2 / 0.648e3 * t1157 * t1969 * t491 + 0.8e1 / 0.3e1 * t575 * t164 * t1072 * t499 - 0.36e2 * t1169 * t1852 + 0.8e1 * t589 * t1860 + 0.185e3 / 0.864e3 * t1822 + 0.24e2 * t588 * t1846 * t1848 + 0.6e1 * t589 * t1856
  t2120 = -t592 * t1868 - 0.16e2 / 0.9e1 * t1143 * t82 * t171 * t499 + 0.56e2 / 0.27e2 * t576 * t59 * t22 * t499 + 0.4e1 * t574 * t1045 * t58 * t59 * t42 * t1047 + 0.8e1 / 0.3e1 * t1139 * t59 * t74 * t506 - 0.4e1 / 0.3e1 * t1138 * t80 * t82 * t85 * t506 + 0.2e1 / 0.3e1 * t1143 * t82 * t85 * t513 - 0.4e1 / 0.3e1 * t576 * t59 * t74 * t513 + 0.2e1 / 0.3e1 * t576 * t59 * t42 * t1058 - 0.5e1 / 0.9e1 * t581 * t1560 * t2009 + 0.11e2 / 0.54e2 * t1826 + t1830 / 0.6e1 - t1833 / 0.12e2
  t2163 = 0.70e2 / 0.81e2 * t1967 + 0.28e2 / 0.27e2 * t1957 + 0.4e1 / 0.3e1 * t1961 - 0.2e1 / 0.3e1 * t1964 + 0.2e1 * t51 * t42 * t1218 * t1220 - 0.2e1 * t51 * t1271 * t1223 + t51 * t621 * t1229 / 0.3e1 + 0.6e1 * t51 * t9 * t1988 * t1990 - 0.9e1 * t51 * t1278 * t1981 + 0.3e1 / 0.2e1 * t51 * t629 * t1984 + 0.2e1 * t51 * t629 * t1977 - t51 * t634 * t1997 / 0.4e1
  t2174 = 0.16112443890811965566518454245249283100831171720671e0 * t969 * t2 * t345 * t547 * t79 + 0.26673100072733151593315970562575695370840511204614e-2 * t610 * t1058 - 0.44313737677495382697984551091739236689629774931818e-2 * (t1980 + t2039) * t719 * t614 - 0.44313737677495382697984551091739236689629774931818e-2 * t734 * t1229 + 0.26673100072733151593315970562575695370840511204614e-2 * (t2077 + t2120) * t595 * t490 - 0.13294121303248614809395365327521771006888932479545e-1 * t1232 * t623 + 0.80019300218199454779947911687727086112521533613842e-2 * t596 * t513 - 0.13294121303248614809395365327521771006888932479545e-1 * t720 * t637 + 0.80019300218199454779947911687727086112521533613842e-2 * t1176 * t499 - 0.10363566666666666666666666666666666666666666666667e-1 * t2163 * t68 * t70 * t644 + 0.17782066715155434395543980375050463580560340803076e-2 * t605 * t490 * t168 - 0.78919141401646687505658045995765315216388639523133e0 * t667 * t925 * t671
  t2212 = 0.15910098906571972201140662072746287547623949727864e-2 * t691 * t925 * t693 + 0.62100044162504450620956542403564945284453474340086e0 * t543 * t925 * t547 - 0.85253821447334808393913447585616058264309475370748e0 * t567 * t925 * t569 - 0.10363566666666666666666666666666666666666666666667e-1 * t1290 * t656 - 0.29542491784996921798656367394492824459753183287879e-2 * t729 * t614 * t168 - 0.10363566666666666666666666666666666666666666666667e-1 * t655 * t72 * t1229 - 0.31090700000000000000000000000000000000000000000001e-1 * t643 * t1088 - 0.17782066715155434395543980375050463580560340803076e-2 * t1253 * t76 + 0.19694994523331281199104244929661882973168788858586e-2 * t1249 * t1164 - 0.22156868838747691348992275545869618344814887465909e-2 * t1231 * t728 * t730 * t55 + 0.13427036575676637972098711871041069250692643100559e-1 * t970 * t918 * t1370 * t972 - 0.43010936946403146577109487070220714079291266853706e-1 * t978 * t918 * t1370 * t980 + 0.29542491784996921798656367394492824459753183287878e-2 * t1245 * t76
  t2267 = -0.92467774834303700057656431679009774979487949985947e-7 * t1022 * t918 * t1370 * t1026 + 0.14818388929296195329619983645875386317133617335896e-3 * t602 / t963 / t574 * t490 * t68 * t1396 - 0.51190794422689743246913327132388312572792631042035e0 * t668 * t1402 * t1406 * t671 * t1 * t59 + 0.40281109727029913916296135613123207752077929301677e0 * t544 * t1402 * t1406 * t547 * t1 * t59 - 0.14771245892498460899328183697246412229876591643939e-2 * t1239 * t1248 * t286 - 0.14771245892498460899328183697246412229876591643939e-2 * t729 * t623 * t79 * t286 - 0.30773428942705126873600382702596692145576232591541e-4 * t1093 * t614 * t1 * t1387 + 0.13336550036366575796657985281287847685420255602307e-2 * t1175 * t604 * t606 * t55 + 0.26673100072733151593315970562575695370840511204614e-2 * t1252 * t1256 * t55 + 0.88910333575777171977719901875252317902801704015380e-3 * t1252 * t1260 * t286 + 0.13336550036366575796657985281287847685420255602307e-2 * t605 * t513 * t57 * t55 + 0.88910333575777171977719901875252317902801704015380e-3 * t605 * t499 * t79 * t286
  t2308 = 0.18522986161620244162024979557344232896417021669871e-4 * t965 * t490 * t1 * t1387 + 0.29542491784996921798656367394492824459753183287878e-2 * t1240 * t76 - 0.17063598140896581082304442377462770857597543680678e-1 * t1098 * t918 * t1370 * t1100 + 0.80267165654777517411160096943584874114138845473912e-4 * t1106 * t918 * t1370 * t1108 - 0.24618743154164101498880306162077353716460986073232e-3 * t726 / t1091 / t698 * t614 * t68 * t1396 - 0.34545222222222222222222222222222222222222222222222e-2 * t519 * t1266 + 0.69090444444444444444444444444444444444444444444446e-2 * t643 * t1126 - 0.38383580246913580246913580246913580246913580246915e-2 * t655 * t285 * t614 + 0.51817833333333333333333333333333333333333333333333e-2 * t1064 * t532 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t97 * t513 - 0.34545222222222222222222222222222222222222222222222e-2 * t531 * t129 * t499 + 0.15545350000000000000000000000000000000000000000000e-1 * t519 * t1296 - 0.31090700000000000000000000000000000000000000000001e-1 * t1290 * t659
  t2342 = 0.19191790123456790123456790123456790123456790123457e-2 * t531 * t285 * t490 + 0.15545350000000000000000000000000000000000000000000e-1 * t1064 * t535 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t72 * t1058 + 0.10363566666666666666666666666666666666666666666667e-1 * t519 * t1299 - 0.20727133333333333333333333333333333333333333333334e-1 * t643 * t1080 - 0.10363566666666666666666666666666666666666666666667e-1 * t655 * t97 * t637 - 0.40750569555564537156454955026157312372117447673715e-3 * t966 * t158 + 0.62566526516620797301782955384030159811190993495820e-1 * t1112 * t925 * t1113 - 0.12613411745750752736039443805420480217936104288757e-3 * t1117 * t925 * t1118 + 0.75079831819944956762139546460836191773429192194982e0 * t1099 * t901 * t1100 - 0.35317552888102107660910442655177344610221092008520e-2 * t1107 * t901 * t1108 + 0.40685820927093628025368829938764300990974697993815e-5 * t1023 * t901 * t1026
  t2353 = t568 ** 2
  t2417 = t692 ** 2
  t2423 = 0.67701543673951279121920841945712722720267711701388e-3 * t1094 * t158 - 0.55392172096869228372480688864674045862037218664772e-3 * t718 * t1092 * t614 * t76 - 0.27793036455358846894255932804679737051689835140790e0 / t994 / t540 * t2 * t900 / t2353 * t68 * t918 + 0.33341375090916439491644963203219619213550639005767e-3 * t594 * t964 * t490 * t76 + 0.33341375090916439491644963203219619213550639005767e-3 * t965 * t499 * t76 + 0.53708146302706551888394847484164277002770572402236e-1 * t565 * t2 * t900 * t547 * t68 * t918 - 0.29493213906105014795732219705294203940085440128257e0 / t563 / t540 * t2 * t900 * t569 * t68 * t918 + 0.50612065300617585654021956536375014708837590964548e0 / t994 / t538 * t2 * t900 * t999 * t68 * t918 - 0.55392172096869228372480688864674045862037218664772e-3 * t1093 * t623 * t76 - 0.68254392563586324329217769509851083430390174722713e-1 * t689 * t2 * t900 * t671 * t68 * t918 + 0.55040342163276011939081209332743913678266636896394e-3 / t687 / t664 * t2 * t900 * t693 * t68 * t918 - 0.13870166225145555008648464751851466246923192497891e-5 / t1020 / t662 * t2 * t900 * t1025 * t68 * t918 + 0.11184902043957375558974121975893022381518862430300e-8 / t1020 / t664 * t2 * t900 / t2417 * t68 * t918
  t2435 = t823 * t334
  t2438 = t1593 - t1764 * t351 / 0.6e1 - t1771 - t1776 + t1781 + t1786 - 0.6e1 * t1787 * t418 - (t1884 + t1931 + t2174 + t2212 + t2267 + t2308 + t2342 + t2423) * t334 * t395 - 0.6e1 * t737 * t391 * t395 - 0.4e1 * t823 * t479 * t395 - 0.4e1 * t2435 * t448
  t2440 = t851 * t334
  t2444 = t851 * t391
  t2449 = t851 * t479
  t2452 = t823 * t391
  t2455 = 0.1e1 / t752
  t2456 = t755 * t2455
  t2458 = 0.96902277115443742137603943210562149050493484994510e-3 * t2456 * t178
  t2459 = t12 + 0.706042e1
  t2460 = t2459 ** 2
  t2461 = t2460 ** 2
  t2462 = t2461 ** 2
  t2467 = 0.1e1 / t2460
  t2469 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t2467
  t2470 = t2469 ** 2
  t2472 = 0.1e1 / t2470 / t2469
  t2477 = t2460 * t2459
  t2482 = t2470 ** 2
  t2488 = 0.1e1 / t2477
  t2489 = t2488 * t1
  t2490 = t2489 * t768
  t2491 = 0.1e1 / t2469
  t2492 = t2 * t2491
  t2497 = 0.1e1 / t2461 / t2459
  t2498 = t2497 * t1
  t2499 = t2498 * t768
  t2500 = 0.1e1 / t2470
  t2501 = t2 * t2500
  t2506 = t44 + 0.35302100000000000000000000000000000000000000000000e1 * t12 + 0.180578e2
  t2507 = 0.1e1 / t2506
  t2509 = t4 * t75 * t2507
  t2511 = t275 + 0.32500e0
  t2512 = t2506 ** 2
  t2513 = 0.1e1 / t2512
  t2514 = t2511 * t2513
  t2515 = t2514 * t58
  t2517 = -t56 - 0.58836833333333333333333333333333333333333333333333e0 * t61
  t2518 = t42 * t2517
  t2522 = t2511 * t2507
  t2523 = t2522 * t79
  t2526 = t2522 * t57
  t2529 = t2511 ** 2
  t2531 = 0.1e1 / t2512 / t2506
  t2532 = t2529 * t2531
  t2533 = t2517 ** 2
  t2536 = t2529 * t2513
  t2539 = t77 - 0.39224555555555555555555555555555555555555555555555e0 * t87 + 0.78449111111111111111111111111111111111111111111110e0 * t90
  t2541 = t2509 / 0.72e2 + t2515 * t59 * t2518 / 0.3e1 - t2523 * t286 / 0.9e1 + 0.2e1 / 0.9e1 * t2526 * t76 + 0.2e1 * t2532 * t2533 - t2536 * t2539
  t2542 = t2529 ** 2
  t2543 = 0.1e1 / t2542
  t2551 = -t2526 * t55 / 0.6e1 - t2536 * t2517
  t2552 = t2551 * t2543
  t2570 = 0.1e1 / t2461
  t2571 = t2570 * t68
  t2572 = t2571 * t81
  t2573 = t2491 * t57
  t2578 = 0.1e1 / t2461 / t2460
  t2579 = t2578 * t68
  t2580 = t2579 * t81
  t2581 = t2500 * t57
  t2586 = t2467 * t79 * t68
  t2592 = t2467 * t57 * t1
  t2597 = 0.46073958594418340718689014996103000237833507556650e2 / t2462 / t2459 * t2 * t900 * t2472 * t68 * t918 - 0.41248484411876216403621151040619215743173669759529e3 / t2462 / t2477 * t2 * t900 / t2482 * t68 * t918 - 0.16862113513206061328235767282159092934901896835780e-1 * t2490 * t925 * t2492 + 0.37740225043579647763636087591098544413180456967501e0 * t2499 * t925 * t2501 + 0.28098338694282647979081704945528765475700933313214e-3 * t2541 * t2543 * t2506 * t76 + 0.28098338694282647979081704945528765475700933313214e-3 * t2552 * t2517 * t76 + 0.18395032923497521448984473398719010474438432911759e-1 * t2497 * t2 * t900 * t2491 * t68 * t918 - 0.16468461837198391751404838221570273925751472131273e1 / t2461 / t2477 * t2 * t900 * t2500 * t68 * t918 - 0.20234536215847273593882920738590911521882276202934e0 * t2572 * t901 * t2573 + 0.10567263012202301373818104525507592435690527950900e2 * t2580 * t901 * t2581 + 0.49053421129326723863958595729917361265169154431359e0 * t2586 * t82 * t900 * t2491 - 0.42921743488160883380963771263677691107023010127437e0 * t2592 * t59 * t892 * t2491
  t2598 = t2552 * t2506
  t2601 = 0.1e1 / t2462
  t2602 = t2601 * t68
  t2603 = t2602 * t81
  t2604 = t2472 * t57
  t2609 = 0.1e1 / t2529 / t2511
  t2610 = t2551 * t2609
  t2614 = -0.34342413959678791974433194933424046692523362938372e-3 * t2598 * t158 - 0.13515027854362713277482111065523546736431162216617e3 * t2603 * t901 * t2604 + 0.14985780636950745588843575970948674920373831100381e-2 * t2610 * t2506 * t168 + t896 + t898 + t904 - t907 + t910 + t921 - t924 + t928 - t931 - t937
  t2616 = t2467 * t164
  t2635 = t946 - t954 - t958 - t962 - 0.13244423704918215443268820847077687541595671696467e1 * t2616 * t1768 * t2491 + 0.55185098770492564346953420196157031423315298735276e-1 * t2570 * t2 * t345 * t2491 * t79 + 0.36859166875534672574951211996882400190266806045320e2 * t2601 * t2 * t345 * t2472 * t79 - 0.28819808215097185564958466887747979370065076229728e1 * t2578 * t2 * t345 * t2500 * t79 - t1359 - t1362 + t1366 + t1368
  t2637 = t42 * t2513
  t2641 = t9 * t2531
  t2645 = t9 * t2513
  t2651 = (t2509 / 0.9e1 + t51 * t2637 * t2517 / 0.6e1 + t51 * t2641 * t2533 / 0.2e1 - t51 * t2645 * t2539 / 0.4e1) * t68 * t70
  t2652 = t129 * t2506
  t2655 = -t1373 + t1377 - t1381 - t1383 - t1389 - t1398 - t1411 - t1414 - t1419 - t1423 + t1425 - 0.34545222222222222222222222222222222222222222222222e-2 * t2651 * t2652 - t1502
  t2666 = (-t4 * t43 * t2507 / 0.12e2 - t51 * t2645 * t2517 / 0.4e1) * t68 * t70
  t2670 = -t159 - 0.23534733333333333333333333333333333333333333333333e1 * t168 + 0.15689822222222222222222222222222222222222222222222e1 * t173 - 0.18304792592592592592592592592592592592592592592592e1 * t176
  t2677 = t97 * t2517
  t2680 = t1504 + t1507 + 0.51817833333333333333333333333333333333333333333333e-2 * t2666 * t72 * t2670 - t1509 - t1512 - t1514 - t1580 - t1583 - t1586 + t1589 + 0.19191790123456790123456790123456790123456790123457e-2 * t2666 * t285 * t2506 + 0.10363566666666666666666666666666666666666666666667e-1 * t2651 * t2677
  t2681 = t72 * t2539
  t2685 = t4 * t23 * t2507
  t2687 = t74 * t2513
  t2689 = t51 * t2687 * t2517
  t2691 = t42 * t2531
  t2698 = t2512 ** 2
  t2699 = 0.1e1 / t2698
  t2700 = t9 * t2699
  t2701 = t2533 * t2517
  t2705 = t2517 * t2539
  t2714 = (-0.7e1 / 0.27e2 * t2685 - t2689 / 0.3e1 - t51 * t2691 * t2533 / 0.2e1 + t51 * t2637 * t2539 / 0.4e1 - 0.3e1 / 0.2e1 * t51 * t2700 * t2701 + 0.3e1 / 0.2e1 * t51 * t2641 * t2705 - t51 * t2645 * t2670 / 0.4e1) * t68 * t70
  t2715 = t72 * t2517
  t2720 = t2511 * t2531
  t2721 = t2720 * t58
  t2725 = t2514 * t80
  t2747 = t2529 * t2699
  t2753 = -0.11e2 / 0.216e3 * t2685 - t2689 / 0.24e2 - t2721 * t59 * t42 * t2533 + t2725 * t82 * t85 * t2517 / 0.3e1 - 0.2e1 / 0.3e1 * t2515 * t59 * t74 * t2517 + t2515 * t59 * t42 * t2539 / 0.2e1 + t1157 * t1158 * t2507 / 0.432e3 - 0.2e1 / 0.3e1 * t2522 * t168 + 0.4e1 / 0.9e1 * t2523 * t1164 - 0.14e2 / 0.27e2 * t2526 * t158 - 0.6e1 * t2747 * t2701 + 0.6e1 * t2532 * t2705 - t2536 * t2670
  t2754 = 0.1e1 / t2529
  t2755 = t2753 * t2754
  t2758 = t2541 * t2754
  t2761 = t2551 * t2754
  t2765 = t4 * t925 * t2507
  t2789 = 0.1e1 / t2698 / t2506
  t2791 = t2533 ** 2
  t2794 = t2539 ** 2
  t2801 = t1559 - 0.19612277777777777777777777777777777777777777777777e1 * t1562 + 0.18827786666666666666666666666666666666666666666666e2 * t1564 - 0.69732543209876543209876543209876543209876543209875e1 * t1567 + 0.61015975308641975308641975308641975308641975308640e1 * t1570
  t2807 = 0.185e3 / 0.864e3 * t2765 - 0.160e3 / 0.81e2 * t2523 * t1946 + 0.140e3 / 0.81e2 * t2526 * t1558 - 0.4e1 * t2721 * t59 * t2518 * t2539 - 0.11e2 / 0.648e3 * t1157 * t1969 * t2507 + 0.8e1 / 0.3e1 * t2514 * t164 * t1072 * t2517 + 0.16e2 / 0.3e1 * t2522 * t1564 - t1157 * t1158 * t2513 * t2517 / 0.108e3 + 0.24e2 * t2529 * t2789 * t2791 + 0.6e1 * t2532 * t2794 - t2536 * t2801 + 0.56e2 / 0.27e2 * t2515 * t59 * t22 * t2517
  t2844 = t51 * t22 * t2513 * t2517
  t2848 = t51 * t74 * t2531 * t2533
  t2851 = t51 * t2687 * t2539
  t2853 = t2517 * t2670
  t2856 = t2533 * t2539
  t2859 = 0.4e1 * t2511 * t2699 * t58 * t59 * t42 * t2701 + 0.8e1 / 0.3e1 * t2721 * t59 * t74 * t2533 - 0.16e2 / 0.9e1 * t2725 * t82 * t171 * t2517 - 0.4e1 / 0.3e1 * t2720 * t80 * t82 * t85 * t2533 + 0.2e1 / 0.3e1 * t2725 * t82 * t85 * t2539 - 0.4e1 / 0.3e1 * t2515 * t59 * t74 * t2539 + 0.2e1 / 0.3e1 * t2515 * t59 * t42 * t2670 - 0.5e1 / 0.9e1 * t2522 * t1560 * t2009 + 0.11e2 / 0.54e2 * t2844 + t2848 / 0.6e1 - t2851 / 0.12e2 + 0.8e1 * t2532 * t2853 - 0.36e2 * t2747 * t2856
  t2892 = -0.4e1 * t1323 * t59 * t865 * t92 + 0.8e1 / 0.3e1 * t863 * t164 * t1072 * t63 - 0.11e2 / 0.648e3 * t1157 * t1969 * t47 + t1524 / 0.6e1 - t1527 / 0.12e2 + 0.11e2 / 0.54e2 * t1520 + 0.16e2 / 0.3e1 * t748 * t1564 - 0.160e3 / 0.81e2 * t869 * t1946 + 0.140e3 / 0.81e2 * t749 * t1558 - t1157 * t1158 * t53 * t63 / 0.108e3 - 0.36e2 * t1349 * t1546 + 0.8e1 * t874 * t1554
  t2938 = 0.185e3 / 0.864e3 * t1516 + 0.24e2 * t752 * t1540 * t1542 + 0.6e1 * t874 * t1550 - t753 * t1572 + 0.2e1 / 0.3e1 * t864 * t59 * t42 * t178 - 0.5e1 / 0.9e1 * t748 * t1560 * t2009 + 0.56e2 / 0.27e2 * t864 * t59 * t22 * t63 + 0.4e1 * t747 * t148 * t58 * t59 * t42 * t150 + 0.8e1 / 0.3e1 * t1323 * t59 * t74 * t111 - 0.16e2 / 0.9e1 * t1327 * t82 * t171 * t63 - 0.4e1 / 0.3e1 * t1322 * t80 * t82 * t85 * t111 + 0.2e1 / 0.3e1 * t1327 * t82 * t85 * t92 - 0.4e1 / 0.3e1 * t864 * t59 * t74 * t92
  t2942 = 0.96902277115443742137603943210562149050493484994510e-3 * (t2892 + t2938) * t2455 * t46
  t2943 = -t1593 + t1771 + t1776 - t1781 - t1786 + 0.15545350000000000000000000000000000000000000000000e-1 * t2651 * t2681 + 0.15545350000000000000000000000000000000000000000000e-1 * t2714 * t2715 - t2458 + 0.67436012866278355149796091869269037141682239951713e-2 * t2755 * t2517 + 0.67436012866278355149796091869269037141682239951713e-2 * t2758 * t2539 + 0.22478670955426118383265363956423012380560746650571e-2 * t2761 * t2670 + 0.22478670955426118383265363956423012380560746650571e-2 * (t2807 + t2859) * t2754 * t2506 - t2942
  t2945 = t1355 * t2455
  t2947 = 0.29070683134633122641281182963168644715148045498353e-2 * t2945 * t63
  t2948 = t878 * t2455
  t2950 = 0.29070683134633122641281182963168644715148045498353e-2 * t2948 * t92
  t2951 = t2541 * t2609
  t2952 = t2517 * t57
  t2966 = t2506 * t57
  t2967 = t2610 * t2966
  t2974 = t2506 * t79
  t2982 = t2951 * t2966
  t2985 = t2610 * t2952
  t2988 = t2610 * t2974
  t2991 = -t2947 - t2950 + 0.22478670955426118383265363956423012380560746650571e-2 * t2951 * t2952 * t55 + 0.11239335477713059191632681978211506190280373325286e-2 * t2610 * t2539 * t57 * t55 + 0.13796274692623141086738355049039257855828824683819e0 * t2467 * t1402 * t1406 * t2491 * t1 * t59 + 0.11655607162072802124656114644071191604735201966963e-2 * t2967 * t158 + 0.15610188163490359988378724969738203042056074062897e-4 * t2552 * t2506 * t1 * t1387 + 0.74928903184753727944217879854743374601869155501904e-3 * t2951 * t2974 * t286 + 0.74928903184753727944217879854743374601869155501904e-3 * t2610 * t2517 * t79 * t286 - 0.14985780636950745588843575970948674920373831100381e-2 * t2982 * t76 - 0.14985780636950745588843575970948674920373831100381e-2 * t2985 * t76 - 0.99905204246338303925623839806324499469158874002539e-3 * t2988 * t1164
  t3045 = 0.70e2 / 0.81e2 * t2765 + 0.28e2 / 0.27e2 * t2844 + 0.4e1 / 0.3e1 * t2848 - 0.2e1 / 0.3e1 * t2851 + 0.2e1 * t51 * t42 * t2699 * t2701 - 0.2e1 * t51 * t2691 * t2705 + t51 * t2637 * t2670 / 0.3e1 + 0.6e1 * t51 * t9 * t2789 * t2791 - 0.9e1 * t51 * t2700 * t2856 + 0.3e1 / 0.2e1 * t51 * t2641 * t2794 + 0.2e1 * t51 * t2641 * t2853 - t51 * t2645 * t2801 / 0.4e1
  t3048 = t72 * t2506
  t3052 = 0.10363566666666666666666666666666666666666666666667e-1 * t184 * t124
  t3055 = 0.64601518076962494758402628807041432700328989996342e-3 * t857 * t46 * t168
  t3056 = t97 * t2506
  t3073 = 0.45987582308743803622461183496797526186096082279398e-2 * t2571 * t918 * t1370 * t2573 - 0.24016506845914321304132055739789982808387563524773e0 * t2579 * t918 * t1370 * t2581 + 0.30715972396278893812459343330735333491889005037766e1 * t2602 * t918 * t1370 * t2604 + 0.12488150530792287990702979975790562433644859250317e-3 * t2551 / t2542 / t2511 * t2506 * t68 * t1396 + 0.11239335477713059191632681978211506190280373325286e-2 * t2753 * t2609 * t2966 * t55 + 0.51817833333333333333333333333333333333333333333333e-2 * t3045 * t68 * t70 * t3048 - t3052 - t3055 + 0.51817833333333333333333333333333333333333333333333e-2 * t2714 * t3056 - 0.34545222222222222222222222222222222222222222222222e-2 * t2666 * t129 * t2517 + 0.51817833333333333333333333333333333333333333333333e-2 * t2666 * t97 * t2539 - 0.47604147498151601156404610484226573066625349129460e1 * t2497 * t892 * t2500 * t51 + 0.21269256817794009175388297367268855861069438054221e0 * t2488 * t892 * t2491 * t51
  t3079 = -t2440 * t1444 - 0.12e2 * t824 * t418 - 0.6e1 * t2444 * t418 - t851 * t1487 * t395 - 0.4e1 * t2449 * t349 - 0.12e2 * t2452 * t349 + t2458 + (t2597 + t2614 + t2635 + t2655 + t2680 + t2943 + t2991 + t3073) * t334 * t339 + t2942 + t2947 + t2950
  t3094 = t2489 * t3
  t3098 = 0.34545222222222222222222222222222222222222222222222e-2 * t2651 * t3056 + 0.48602578047254941331494803814743396158690158540586e-1 * t29 - 0.18394613361864149606712411343047178787314745838373e1 * t39 - 0.10363566666666666666666666666666666666666666666667e-1 * t94 - 0.69090444444444444444444444444444444444444444444446e-2 * t99 - 0.20727133333333333333333333333333333333333333333334e-1 * t122 - 0.69090444444444444444444444444444444444444444444446e-2 * t125 + 0.23030148148148148148148148148148148148148148148149e-2 * t131 + 0.51817833333333333333333333333333333333333333333333e-2 * t2714 * t3048 - 0.10363566666666666666666666666666666666666666666667e-1 * t186 - 0.11515074074074074074074074074074074074074074074074e-2 * t2666 * t2652 - 0.50586340539618183984707301846477278804705690507337e-1 * t3094 * t23 * t2491
  t3101 = t2498 * t3
  t3132 = 0.10363566666666666666666666666666666666666666666667e-1 * t2651 * t2715 + 0.11322067513073894329090826277329563323954137090250e1 * t3101 * t23 * t2500 + 0.51817833333333333333333333333333333333333333333333e-2 * t2666 * t2681 + 0.34545222222222222222222222222222222222222222222222e-2 * t2666 * t2677 - 0.11037019754098512869390684039231406284663059747056e0 * t2586 * t82 * t171 * t2491 + 0.12876523046448265014289131379103307332106903038231e0 * t2592 * t59 * t22 * t2491 + 0.93661128980942159930272349818429218252336444377380e-4 * t2598 * t76 + 0.27592549385246282173476710098078515711657649367638e-1 * t2572 * t782 * t2573 - 0.14409904107548592782479233443873989685032538114864e1 * t2580 * t782 * t2581 + 0.22993791154371901811230591748398763093048041139699e-2 * t2490 * t23 * t2492 - 0.51463943241244974223140119442407106017973350410227e-1 * t2499 * t23 * t2501 - 0.12371565321119439611653222789207409931302949446695e0 * t745
  t3150 = -0.40375948798101559224001643004400895437705618747712e-4 * t760 + 0.10604198846673805381417048105034922798259670954310e0 * t766 - 0.22092080930570427877952183552156089163040981154812e-2 * t772 + 0.83611878917564316394147324286578085396885208356242e-1 * t777 - 0.26510497116684513453542620262587306995649177385774e-1 * t785 + 0.23411326096918008590361250800241863911127858339748e1 * t793 - 0.50631328524251801700246888250186209051365905137714e2 * t805 + 0.18429583437767336287475605998441200095133403022660e2 * t2603 * t782 * t2604 + 0.74928903184753727944217879854743374601869155501904e-3 * t2985 * t55 + 0.24976301061584575981405959951581124867289718500635e-3 * t2988 * t286 + 0.21533839358987498252800876269013810900109663332113e-3 * t860 - 0.32300759038481247379201314403520716350164494998170e-3 * t881
  t3158 = t1767 * t1072 * t27
  t3163 = t2948 * t63
  t3165 = t2456 * t92
  t3173 = t2945 * t46
  t3175 = -0.32300759038481247379201314403520716350164494998170e-3 * t885 - 0.10766919679493749126400438134506905450054831666057e-3 * t889 - 0.49952602123169151962811919903162249734579437001269e-3 * t2967 * t76 + 0.74928903184753727944217879854743374601869155501904e-3 * t2982 * t55 - 0.15906298270010708072125572157552384197389506431465e0 * t3158 + 0.16555529631147769304086026058847109426994589620583e0 * t2616 * t1072 * t2491 - 0.19380455423088748427520788642112429810098696998902e-2 * t3163 - 0.96902277115443742137603943210562149050493484994510e-3 * t3165 + 0.44957341910852236766530727912846024761121493301142e-2 * t2758 * t2517 + 0.22478670955426118383265363956423012380560746650571e-2 * t2761 * t2539 + 0.22478670955426118383265363956423012380560746650571e-2 * t2755 * t2506 - 0.96902277115443742137603943210562149050493484994510e-3 * t3173
  t3177 = t3098 + t3132 + t3150 + t3175
  t3233 = 0.51817833333333333333333333333333333333333333333333e-2 * t2651 * t3048 + 0.17272611111111111111111111111111111111111111111111e-2 * t2666 * t3056 + 0.51817833333333333333333333333333333333333333333333e-2 * t2666 * t2715 + 0.13796274692623141086738355049039257855828824683819e-1 * t3094 * t75 * t2491 + 0.27592549385246282173476710098078515711657649367639e-1 * t2586 * t82 * t85 * t2491 - 0.55185098770492564346953420196157031423315298735277e-1 * t2592 * t59 * t74 * t2491 - 0.30878365944746984533884071665444263610784010246137e0 * t3101 * t75 * t2500 + 0.22478670955426118383265363956423012380560746650571e-2 * t2758 * t2506 + 0.37464451592376863972108939927371687300934577750952e-3 * t2967 * t55 + 0.22478670955426118383265363956423012380560746650571e-2 * t2761 * t2517 - 0.10363566666666666666666666666666666666666666666667e-1 * t120 * t185 - 0.34545222222222222222222222222222222222222222222223e-2 * t71 * t124 - 0.10363566666666666666666666666666666666666666666667e-1 * t71 * t121 - 0.13255248558342256726771310131293653497824588692887e-1 * t18 * t75 * t27 - 0.26510497116684513453542620262587306995649177385775e-1 * t763 * t82 * t85 * t27 + 0.53020994233369026907085240525174613991298354771549e-1 * t742 * t59 * t74 * t27 + 0.50167127350538589836488394571946851238131125013746e0 * t35 * t75 * t37 - 0.96902277115443742137603943210562149050493484994510e-3 * t2948 * t46 - 0.16150379519240623689600657201760358175082247499085e-3 * t859 * t55 - 0.96902277115443742137603943210562149050493484994510e-3 * t2456 * t63
  t3253 = 0.51817833333333333333333333333333333333333333333333e-2 * t2666 * t3048 + 0.41388824077869423260215065147117773567486474051458e-1 * t2592 * t59 * t42 * t2491 + 0.22478670955426118383265363956423012380560746650571e-2 * t2761 * t2506 - 0.10363566666666666666666666666666666666666666666667e-1 * t71 * t185 - 0.39765745675026770180313930393880960493473766078662e-1 * t742 * t59 * t42 * t27 - 0.96902277115443742137603943210562149050493484994510e-3 * t2456 * t46
  t3260 = jnp.log(t4 * t10 * t2507 / 0.4e1)
  t3264 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t2459)
  t3267 = jnp.log(t2529 * t2507)
  t3272 = jnp.log(t4 * t10 * t47 / 0.4e1)
  t3276 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t13)
  t3279 = jnp.log(t752 * t47)
  t3281 = 0.1554535e-1 * t3260 + 0.52491393169780936217021346072241076933841385384497e-1 * t3264 + 0.22478670955426118383265363956423012380560746650571e-2 * t3267 - 0.310907e-1 * t3272 - 0.38783294878113014394824731224995739188004877421366e-1 * t3276 - 0.96902277115443742137603943210562149050493484994510e-3 * t3279
  t3318 = t269 ** 2
  t3337 = 0.16068013288849294541652625744614149154061652860242e4 / t1622 / t239 * t2 * t900 * t1627 * t68 * t918 - 0.37387509081369749583315852466115562808071097939170e1 * t259 * t59 * t892 * t248 + 0.42728581807279713809503831389846357494938397644766e1 * t253 * t82 * t900 * t248 - 0.47132838980624597322181035517534837518580848390044e4 * t1625 * t901 * t1628 - 0.33013307495816796838804912909949804566381363448884e-2 * t1601 * t158 + 0.18417913650658881038046337474746486774936139152306e3 * t1607 * t901 * t1608 - 0.14687949996252401622016942040259685388885074190388e0 * t1612 * t925 * t1613 + 0.65778263038067432278736919552666024196200496972522e1 * t1617 * t925 * t1618 - 0.28783485915536592493215570496151025048490758133637e5 / t1622 / t241 * t2 * t900 / t3318 * t68 * t918 - 0.17625539995502881946420330448311622466662089028467e1 * t1640 * t901 * t1641 + 0.16023218177729892678563936771192384060601899116788e0 * t266 * t2 * t900 * t248 * t68 * t918 + 0.27010887951122833777204019653595294645221115549088e-2 * t298 * t1599 * t191 * t76
  t3364 = t4 * t925 * t192
  t3368 = t51 * t22 * t197 * t200
  t3372 = t51 * t74 * t205 * t207
  t3375 = t51 * t1662 * t214
  t3388 = 0.1e1 / t1673 / t191
  t3390 = t207 ** 2
  t3394 = t207 * t214
  t3398 = t214 ** 2
  t3402 = t200 * t1687
  t3410 = t1559 - 0.29676388888888888888888888888888888888888888888889e0 * t1562 + 0.28489333333333333333333333333333333333333333333334e1 * t1564 - 0.10551604938271604938271604938271604938271604938272e1 * t1567 + 0.92326543209876543209876543209876543209876543209880e0 * t1570
  t3414 = 0.70e2 / 0.81e2 * t3364 + 0.28e2 / 0.27e2 * t3368 + 0.4e1 / 0.3e1 * t3372 - 0.2e1 / 0.3e1 * t3375 + 0.2e1 * t51 * t42 * t1674 * t1676 - 0.2e1 * t51 * t1666 * t1680 + t51 * t198 * t1687 / 0.3e1 + 0.6e1 * t51 * t9 * t3388 * t3390 - 0.9e1 * t51 * t1675 * t3394 + 0.3e1 / 0.2e1 * t51 * t206 * t3398 + 0.2e1 * t51 * t206 * t3402 - t51 * t211 * t3410 / 0.4e1
  t3440 = 0.27010887951122833777204019653595294645221115549088e-2 * t1600 * t200 * t76 - 0.28703242052974879539812473986617901467432944133464e2 / t264 / t241 * t2 * t900 * t270 * t68 * t918 + 0.48069654533189678035691810313577152181805697350364e0 * t1638 * t2 * t345 * t248 * t79 + 0.12854410631079435633322100595691319323249322288194e4 * t1623 * t2 * t345 * t1627 * t79 + 0.10804355180449133510881607861438117858088446219635e-1 * t309 * t214 * t57 * t55 + t3414 * t68 * t70 * t221 / 0.3e1 + t1693 * t236 - 0.82970309059380511169770432617567371429298354135795e2 * t266 * t892 * t270 * t51 - 0.11536717087965522728566034475258516523633367364087e2 * t1594 * t1768 * t248 - 0.50230673592706039194671829476581327568007652233562e2 * t1605 * t2 * t345 * t270 * t79 + 0.10e2 / 0.81e2 * t232 * t285 * t191 + t1693 * t233 / 0.3e1 + 0.14405806907265511347842143815250823810784594959513e-1 * t309 * t191 * t168
  t3508 = -0.160e3 / 0.81e2 * t284 * t1946 + 0.140e3 / 0.81e2 * t289 * t1558 - t1157 * t1158 * t197 * t200 / 0.108e3 + 0.2e1 / 0.3e1 * t1713 * t82 * t85 * t214 - 0.4e1 / 0.3e1 * t278 * t59 * t74 * t214 + 0.2e1 / 0.3e1 * t278 * t59 * t42 * t1687 - 0.5e1 / 0.9e1 * t283 * t1560 * t2009 - 0.16e2 / 0.9e1 * t1713 * t82 * t171 * t200 + 0.56e2 / 0.27e2 * t278 * t59 * t22 * t200 + 0.4e1 * t276 * t1674 * t58 * t59 * t42 * t1676 + 0.8e1 / 0.3e1 * t1709 * t59 * t74 * t207 - 0.4e1 / 0.3e1 * t1708 * t80 * t82 * t85 * t207
  t3536 = -t3375 / 0.12e2 + 0.11e2 / 0.54e2 * t3368 + t3372 / 0.6e1 - 0.4e1 * t1709 * t59 * t279 * t214 + 0.8e1 / 0.3e1 * t277 * t164 * t1072 * t200 - 0.11e2 / 0.648e3 * t1157 * t1969 * t192 + 0.16e2 / 0.3e1 * t283 * t1564 + 0.185e3 / 0.864e3 * t3364 + 0.6e1 * t293 * t3398 - t296 * t3410 + 0.24e2 * t292 * t3388 * t3390 + 0.8e1 * t293 * t3402 - 0.36e2 * t1735 * t3394
  t3549 = -0.2e1 / 0.9e1 * t220 * t1632 - 0.2e1 / 0.9e1 * t232 * t129 * t200 + 0.18526846018000188409589551891691194070070945853786e1 * t242 * t892 * t248 * t51 + t232 * t97 * t214 / 0.3e1 + 0.2e1 / 0.3e1 * t220 * t1654 + t220 * t1650 + t232 * t72 * t1687 / 0.3e1 + 0.64826131082694801065289647168628707148530677317810e-1 * t1742 * t200 + 0.21608710360898267021763215722876235716176892439270e-1 * (t3508 + t3536) * t299 * t191 + 0.11204516483428731048321667411861751852832462746288e-1 * t311 * t158 + 0.10804355180449133510881607861438117858088446219635e-1 * t1741 * t308 * t310 * t55 - 0.96038712715103408985614292101672158738563966396755e-2 * t1758 * t1164
  t3597 = 0.64826131082694801065289647168628707148530677317810e-1 * t300 * t214 + 0.21608710360898267021763215722876235716176892439270e-1 * t314 * t1687 - 0.14405806907265511347842143815250823810784594959513e-1 * t1750 * t76 - 0.14405806907265511347842143815250823810784594959513e-1 * t1754 * t76 + 0.10712008859232863027768417163076099436041101906828e3 * t1624 * t918 * t1370 * t1628 + 0.12004839089387926123201786512709019842320495799594e-2 * t306 / t1598 / t276 * t191 * t68 * t1396 + 0.40058045444324731696409841927980960151504747791968e-1 * t1639 * t918 * t1370 * t1641 - 0.41858894660588365995559857897151106306673043527969e1 * t1606 * t918 * t1370 * t1608 + 0.12017413633297419508922952578394288045451424337591e1 * t245 * t1402 * t1406 * t248 * t1 * t59 + 0.15006048861734907654002233140886274802900619749493e-3 * t1600 * t191 * t1 * t1387 + 0.72029034536327556739210719076254119053922974797566e-2 * t1749 * t1757 * t286 + 0.72029034536327556739210719076254119053922974797566e-2 * t309 * t200 * t79 * t286 + 0.21608710360898267021763215722876235716176892439270e-1 * t1749 * t1753 * t55
  t3614 = 0.4e1 * t3177 * t405 * t339 + 0.6e1 * t3233 * t391 * t339 + 0.4e1 * t3253 * t479 * t339 + t3281 * t1487 * t339 - t189 * (t3337 + t3440 + t3549 + t3597) * t334 * t396 / 0.24e2 - t318 * t391 * t396 / 0.4e1 - t406 * t419 / 0.2e1 + t3052 + t3055 - t1763 * t405 * t396 / 0.6e1 - 0.12e2 * t738 * t349
  t3627 = 0.20252531409700720680098755300074483620546362055085e3 * t805 - 0.24e2 * t824 * t349 - 0.12e2 * t852 * t418 - 0.86135357435949993011203505076055243600438653328453e-3 * t860 + 0.12920303615392498951680525761408286540065797999268e-2 * t881 + 0.12920303615392498951680525761408286540065797999268e-2 * t885 + 0.43067678717974996505601752538027621800219326664227e-3 * t889 + t7 * (t1414 + t3614 - t921 + t924 - t910 - t904 + t907 - t896 - t898 + t1381 - t1589 + t1586 + t937 + t931 + t1512 + t1514 - t1507 + t1509 - t1366 - t1368 + t1502 - t1504 + t1498 - t928 + t2438 + t1580 + t1583 - t1377 + t1373 + t1363 + t1411 + t1398 + t1389 + t1383 + t3079) - t1764 * t396 / 0.6e1 + 0.63625193080042832288502288630209536789558025725859e0 * t3158 - t1317 * t396 / 0.2e1 + 0.12e2 * t3233 * t405 * t339
  t3654 = -0.12e2 * t2435 * t418 - 0.4e1 * t2440 * t448 - 0.12e2 * t1787 * t349 + 0.4e1 * t3177 * t334 * t339 + 0.77521821692354993710083154568449719240394787995608e-2 * t3163 + 0.38760910846177496855041577284224859620197393997804e-2 * t3165 + 0.38760910846177496855041577284224859620197393997804e-2 * t3173 + 0.4e1 * t3281 * t479 * t339 + 0.12e2 * t3253 * t391 * t339 - 0.4e1 * t1307 * t395 - 0.4e1 * t2449 * t395 - 0.12e2 * t2444 * t349 - 0.12e2 * t2452 * t395
  d1111 = t422 + t795 + t3627 + t3654

  res = {'v4rho4': d1111}
  return res
