"""Generated from mgga_c_kcisk.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  kcisk_p = 0.193

  kcisk_gcnst = 20 / (3 * jnp.pi * (6 * jnp.pi ** 2) ** (1 / 3))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcisk_gamma0 = lambda rs: jnp.maximum(0, kcis_beta + 2 ** (1 / 3) * kcisk_gcnst * f_pw(2 ** (1 / 3) * rs, 0) / f.n_total(rs) ** (1 / 3))

  kcisk_gamma1 = lambda rs: jnp.maximum(0, kcis_beta + kcisk_gcnst * f_pw(rs, 0) / f.n_total(rs) ** (1 / 3))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcisk_p * jnp.log(1 + kcisk_gamma0(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 0)))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcisk_p * jnp.log(1 + 2 ** (-1 / 3) * kcisk_gamma1(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 1)))))

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  kcisk_p = 0.193

  kcisk_gcnst = 20 / (3 * jnp.pi * (6 * jnp.pi ** 2) ** (1 / 3))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcisk_gamma0 = lambda rs: jnp.maximum(0, kcis_beta + 2 ** (1 / 3) * kcisk_gcnst * f_pw(2 ** (1 / 3) * rs, 0) / f.n_total(rs) ** (1 / 3))

  kcisk_gamma1 = lambda rs: jnp.maximum(0, kcis_beta + kcisk_gcnst * f_pw(rs, 0) / f.n_total(rs) ** (1 / 3))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcisk_p * jnp.log(1 + kcisk_gamma0(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 0)))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcisk_p * jnp.log(1 + 2 ** (-1 / 3) * kcisk_gamma1(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 1)))))

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  kcisk_p = 0.193

  kcisk_gcnst = 20 / (3 * jnp.pi * (6 * jnp.pi ** 2) ** (1 / 3))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcisk_gamma0 = lambda rs: jnp.maximum(0, kcis_beta + 2 ** (1 / 3) * kcisk_gcnst * f_pw(2 ** (1 / 3) * rs, 0) / f.n_total(rs) ** (1 / 3))

  kcisk_gamma1 = lambda rs: jnp.maximum(0, kcis_beta + kcisk_gcnst * f_pw(rs, 0) / f.n_total(rs) ** (1 / 3))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcisk_p * jnp.log(1 + kcisk_gamma0(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 0)))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcisk_p * jnp.log(1 + 2 ** (-1 / 3) * kcisk_gamma1(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 1)))))

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t13 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t23 = 0.1e1 / t22
  t24 = t5 * t23
  t25 = t21 * t24
  t27 = 0.23615790870000000000000000000000000000000000000000e0 * t14 + 0.55771035800000000000000000000000000000000000000000e-1 * t11 + 0.12733319050000000000000000000000000000000000000000e-1 * t17 + 0.76629987700000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t33 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = t33 * f.p.zeta_threshold
  t35 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t34, 1)
  t38 = 2 ** (0.1e1 / 0.3e1)
  t41 = 0.1e1 / (0.2e1 * t38 - 0.2e1)
  t42 = (0.2e1 * t35 - 0.2e1) * t41
  t44 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t11
  t49 = 0.17489865900000000000000000000000000000000000000000e0 * t14 + 0.30591644850000000000000000000000000000000000000000e-1 * t11 + 0.37162376550000000000000000000000000000000000000000e-2 * t17 + 0.41939708850000000000000000000000000000000000000000e-2 * t25
  t51 = 0.1e1 + 0.1e1 / t49
  t52 = jnp.log(t51)
  t53 = t44 * t52
  t54 = t42 * t53
  t56 = -t31 + 0.58482233974552040708313425006184496242808878304904e0 * t54
  t58 = 6 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = t38 * t2 * t59
  t61 = jnp.pi ** 2
  t62 = t61 ** (0.1e1 / 0.3e1)
  t63 = 0.1e1 / t62
  t64 = t38 * t1
  t65 = t3 * t6
  t67 = t64 * t65 * t9
  t69 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t67
  t70 = jnp.sqrt(t67)
  t73 = t67 ** 0.15e1
  t75 = t38 ** 2
  t76 = t75 * t19
  t77 = t20 * t5
  t79 = t76 * t77 * t23
  t81 = 0.23615790870000000000000000000000000000000000000000e0 * t70 + 0.55771035800000000000000000000000000000000000000000e-1 * t67 + 0.12733319050000000000000000000000000000000000000000e-1 * t73 + 0.76629987700000000000000000000000000000000000000000e-2 * t79
  t83 = 0.1e1 + 0.1e1 / t81
  t84 = jnp.log(t83)
  t87 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t67
  t92 = 0.17489865900000000000000000000000000000000000000000e0 * t70 + 0.30591644850000000000000000000000000000000000000000e-1 * t67 + 0.37162376550000000000000000000000000000000000000000e-2 * t73 + 0.41939708850000000000000000000000000000000000000000e-2 * t79
  t94 = 0.1e1 + 0.1e1 / t92
  t95 = jnp.log(t94)
  t100 = t63 * (-t69 * t84 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * t87 * t95)
  t103 = 0.10e2 / 0.9e1 * t60 * t100 * t9
  t104 = t103 < -0.66725e-1
  t106 = f.my_piecewise3(t104, 0, 0.66725e-1 + t103)
  t107 = t106 * t38
  t109 = s0 + 0.2e1 * s1 + s2
  t110 = t7 ** 2
  t112 = 0.1e1 / t8 / t110
  t113 = t109 * t112
  t114 = t107 * t113
  t115 = 0.1e1 / t3
  t116 = t19 * t115
  t117 = 0.0e0 < t56
  t119 = f.my_piecewise3(t117, t56, -t56)
  t121 = t5 / t119
  t122 = t116 * t121
  t125 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t114 * t122
  t126 = jnp.log(t125)
  t128 = 0.1e1 + 0.193e0 * t126
  t129 = 0.1e1 / t128
  t132 = t1 / t20
  t133 = t132 * t6
  t135 = 0.1e1 / t8 / t7
  t136 = 0.1e1 / t7
  t137 = t2 * t136
  t140 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t14 + 0.12382500000000000000000000000000000000000000000000e-1 * t11
  t143 = 0.1e1 + t14 * t140 / 0.2e1
  t144 = t143 ** 2
  t145 = 0.1e1 / t144
  t150 = t1 * t3 * t2
  t151 = t6 * t135
  t152 = t150 * t151
  t155 = t19 * t20 * t2
  t157 = 0.1e1 / t22 / t7
  t158 = t5 * t157
  t159 = t155 * t158
  t161 = 0.1e1 / t61
  t162 = 0.1e1 / t110
  t163 = t161 * t162
  t166 = t1 * t3 * t161
  t167 = t6 * t112
  t168 = t166 * t167
  t170 = -0.18780000000000000000000000000000000000000000000000e-1 * t137 + 0.13173750000000000000000000000000000000000000000000e-2 * t152 - 0.23775000000000000000000000000000000000000000000000e-3 * t159 + 0.63900000000000000000000000000000000000000000000000e-4 * t163 - 0.54014062500000000000000000000000000000000000000000e-6 * t168
  t172 = 0.36798313500000000000000000000000000000000000000000e-2 * t137 * t145 - t56 * t170
  t173 = t135 * t172
  t174 = 4 ** (0.1e1 / 0.6e1)
  t175 = t132 * t174
  t176 = t14 * t11
  t177 = t22 * t176
  t178 = 0.1e1 / t143
  t182 = t56 ** 2
  t184 = 0.19711289000000000000000000000000000000000000000000e-2 * t175 * t177 * t178 - 0.2e1 * t182
  t185 = 0.1e1 / t184
  t186 = t185 * t109
  t188 = t133 * t173 * t186
  t190 = t56 * t129 + 0.99491666666666666666666666666666666666666666666666e-2 * t188
  t193 = -0.2e1 * t31 + 0.11696446794910408141662685001236899248561775660981e1 * t54
  t194 = jnp.sqrt(0.4e1)
  t195 = t193 * t194
  t196 = t176 * t178
  t199 = t6 * t22
  t203 = 0.30956250000000000000000000000000000000000000000000e-2 * t195 * t196 - 0.79593333333333333333333333333333333333333333333333e-1 * t132 * t199 * t170
  t204 = t203 * t185
  t205 = t109 * t162
  t206 = t204 * t205
  t208 = t172 * t185
  t209 = t109 ** 2
  t210 = t110 ** 2
  t211 = 0.1e1 / t210
  t212 = t209 * t211
  t213 = t208 * t212
  t215 = 0.1e1 + t206 / 0.8e1 - t213 / 0.64e2
  t216 = 0.1e1 / t215
  t217 = t190 * t216
  t218 = r0 - r1
  t219 = t218 * t136
  t220 = 0.1e1 + t219
  t221 = t220 <= f.p.zeta_threshold
  t222 = t220 ** (0.1e1 / 0.3e1)
  t224 = f.my_piecewise3(t221, t34, t222 * t220)
  t225 = 0.1e1 - t219
  t226 = t225 <= f.p.zeta_threshold
  t227 = t225 ** (0.1e1 / 0.3e1)
  t229 = f.my_piecewise3(t226, t34, t227 * t225)
  t231 = (t224 + t229 - 0.2e1) * t41
  t234 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t34, 0.2e1 * t38)
  t236 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t34, 0)
  t238 = (t234 + t236 - 0.2e1) * t41
  t240 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t11
  t245 = 0.21947830050000000000000000000000000000000000000000e0 * t14 + 0.48171623250000000000000000000000000000000000000000e-1 * t11 + 0.13081894750000000000000000000000000000000000000000e-1 * t17 + 0.48591338250000000000000000000000000000000000000000e-2 * t25
  t247 = 0.1e1 + 0.1e1 / t245
  t248 = jnp.log(t247)
  t255 = -t31 + t238 * (-t240 * t248 + t31 - 0.58482233974552040708313425006184496242808878304904e0 * t53) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t53
  t256 = t2 * t59
  t257 = t63 * t56
  t260 = 0.10e2 / 0.9e1 * t256 * t257 * t9
  t261 = t260 < -0.66725e-1
  t263 = f.my_piecewise3(t261, 0, 0.66725e-1 + t260)
  t264 = t263 * t109
  t266 = 0.0e0 < t255
  t268 = f.my_piecewise3(t266, t255, -t255)
  t270 = t5 / t268
  t271 = t116 * t270
  t274 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t264 * t112 * t271
  t275 = jnp.log(t274)
  t277 = 0.1e1 + 0.193e0 * t275
  t278 = 0.1e1 / t277
  t281 = t255 * t278 + 0.69644166666666666666666666666666666666666666666666e-2 * t188
  t284 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t206 - 0.40468750000000000000000000000000000000000000000000e-1 * t213
  t285 = 0.1e1 / t284
  t287 = t281 * t285 - t217
  t288 = t231 * t287
  t289 = 0.1e1 / r0
  t290 = s0 * t289
  t291 = 0.1e1 / tau0
  t292 = f.my_piecewise3(t221, f.p.zeta_threshold, t220)
  t293 = t291 * t292
  t294 = t4 * t6
  t295 = t9 * t38
  t296 = 0.1e1 / t220
  t297 = t296 ** (0.1e1 / 0.3e1)
  t299 = t294 * t295 * t297
  t301 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t299
  t302 = jnp.sqrt(t299)
  t305 = t299 ** 0.15e1
  t307 = t21 * t5
  t308 = t23 * t75
  t309 = t297 ** 2
  t311 = t307 * t308 * t309
  t313 = 0.23615790870000000000000000000000000000000000000000e0 * t302 + 0.55771035800000000000000000000000000000000000000000e-1 * t299 + 0.12733319050000000000000000000000000000000000000000e-1 * t305 + 0.76629987700000000000000000000000000000000000000000e-2 * t311
  t315 = 0.1e1 + 0.1e1 / t313
  t316 = jnp.log(t315)
  t317 = t301 * t316
  t319 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t299
  t324 = 0.17489865900000000000000000000000000000000000000000e0 * t302 + 0.30591644850000000000000000000000000000000000000000e-1 * t299 + 0.37162376550000000000000000000000000000000000000000e-2 * t305 + 0.41939708850000000000000000000000000000000000000000e-2 * t311
  t326 = 0.1e1 + 0.1e1 / t324
  t327 = jnp.log(t326)
  t328 = t319 * t327
  t329 = t42 * t328
  t331 = -t317 + 0.58482233974552040708313425006184496242808878304904e0 * t329
  t333 = t75 * t2 * t59
  t334 = t75 * t1
  t335 = t334 * t3
  t337 = t335 * t10 * t297
  t339 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t337
  t340 = jnp.sqrt(t337)
  t343 = t337 ** 0.15e1
  t345 = t38 * t19
  t346 = t345 * t20
  t348 = t346 * t24 * t309
  t350 = 0.23615790870000000000000000000000000000000000000000e0 * t340 + 0.55771035800000000000000000000000000000000000000000e-1 * t337 + 0.12733319050000000000000000000000000000000000000000e-1 * t343 + 0.15325997540000000000000000000000000000000000000000e-1 * t348
  t352 = 0.1e1 + 0.1e1 / t350
  t353 = jnp.log(t352)
  t356 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t337
  t361 = 0.17489865900000000000000000000000000000000000000000e0 * t340 + 0.30591644850000000000000000000000000000000000000000e-1 * t337 + 0.37162376550000000000000000000000000000000000000000e-2 * t343 + 0.83879417700000000000000000000000000000000000000000e-2 * t348
  t363 = 0.1e1 + 0.1e1 / t361
  t364 = jnp.log(t363)
  t369 = t63 * (-t339 * t353 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * t356 * t364)
  t370 = t7 * t220
  t371 = t370 ** (0.1e1 / 0.3e1)
  t372 = 0.1e1 / t371
  t375 = 0.10e2 / 0.9e1 * t333 * t369 * t372
  t376 = t375 < -0.66725e-1
  t378 = f.my_piecewise3(t376, 0, 0.66725e-1 + t375)
  t379 = t378 * s0
  t380 = r0 ** 2
  t381 = r0 ** (0.1e1 / 0.3e1)
  t382 = t381 ** 2
  t384 = 0.1e1 / t382 / t380
  t385 = t384 * t19
  t386 = t379 * t385
  t387 = t115 * t5
  t388 = 0.1e1 / t297
  t389 = t8 * t388
  t390 = 0.0e0 < t331
  t392 = f.my_piecewise3(t390, t331, -t331)
  t393 = 0.1e1 / t392
  t395 = t387 * t389 * t393
  t398 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t386 * t395
  t399 = jnp.log(t398)
  t401 = 0.1e1 + 0.193e0 * t399
  t402 = 0.1e1 / t401
  t405 = t132 * t199 * t75
  t406 = 0.1e1 / t309
  t409 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t302 + 0.12382500000000000000000000000000000000000000000000e-1 * t299
  t412 = 0.1e1 + t302 * t409 / 0.2e1
  t413 = t412 ** 2
  t414 = 0.1e1 / t413
  t415 = t296 * t414
  t420 = t150 * t6
  t421 = t135 * t38
  t422 = t297 * t296
  t426 = t155 * t5
  t427 = t157 * t75
  t428 = t309 * t296
  t432 = t220 ** 2
  t433 = 0.1e1 / t432
  t436 = t166 * t6
  t437 = t112 * t38
  t438 = t297 * t433
  t442 = -0.37560000000000000000000000000000000000000000000000e-1 * t137 * t296 + 0.26347500000000000000000000000000000000000000000000e-2 * t420 * t421 * t422 - 0.47550000000000000000000000000000000000000000000000e-3 * t426 * t427 * t428 + 0.25560000000000000000000000000000000000000000000000e-3 * t163 * t433 - 0.21605625000000000000000000000000000000000000000000e-5 * t436 * t437 * t438
  t444 = 0.73596627000000000000000000000000000000000000000000e-2 * t137 * t415 - t331 * t442
  t445 = t406 * t444
  t446 = t174 * t22
  t447 = t132 * t446
  t448 = t38 * t406
  t449 = t302 * t299
  t450 = 0.1e1 / t412
  t451 = t449 * t450
  t452 = t448 * t451
  t455 = t331 ** 2
  t457 = 0.98556445000000000000000000000000000000000000000000e-3 * t447 * t452 - 0.2e1 * t455
  t458 = 0.1e1 / t457
  t459 = t445 * t458
  t460 = s0 * t384
  t461 = t371 ** 2
  t462 = t460 * t461
  t463 = t459 * t462
  t464 = t405 * t463
  t466 = t331 * t402 + 0.24872916666666666666666666666666666666666666666667e-2 * t464
  t470 = (-0.2e1 * t317 + 0.11696446794910408141662685001236899248561775660981e1 * t329) * t194
  t473 = t22 * t38
  t474 = t406 * t442
  t478 = 0.30956250000000000000000000000000000000000000000000e-2 * t470 * t451 - 0.39796666666666666666666666666666666666666666666667e-1 * t133 * t473 * t474
  t479 = t478 * t458
  t480 = t479 * s0
  t481 = t384 * t38
  t482 = t481 * t461
  t483 = t480 * t482
  t485 = t444 * t458
  t486 = s0 ** 2
  t487 = t485 * t486
  t488 = t380 ** 2
  t492 = 0.1e1 / t381 / t488 / r0 * t75
  t493 = t371 * t370
  t494 = t492 * t493
  t495 = t487 * t494
  t497 = 0.1e1 + t483 / 0.16e2 - t495 / 0.256e3
  t498 = 0.1e1 / t497
  t499 = t466 * t498
  t501 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t299
  t506 = 0.21947830050000000000000000000000000000000000000000e0 * t302 + 0.48171623250000000000000000000000000000000000000000e-1 * t299 + 0.13081894750000000000000000000000000000000000000000e-1 * t305 + 0.48591338250000000000000000000000000000000000000000e-2 * t311
  t508 = 0.1e1 + 0.1e1 / t506
  t509 = jnp.log(t508)
  t516 = -t317 + t238 * (-t501 * t509 + t317 - 0.58482233974552040708313425006184496242808878304904e0 * t328) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t328
  t517 = t256 * t63
  t518 = t331 * t38
  t521 = 0.10e2 / 0.9e1 * t517 * t518 * t372
  t522 = t521 < -0.66725e-1
  t524 = f.my_piecewise3(t522, 0, 0.66725e-1 + t521)
  t525 = t75 * t524
  t526 = t460 * t19
  t527 = t525 * t526
  t528 = 0.0e0 < t516
  t530 = f.my_piecewise3(t528, t516, -t516)
  t531 = 0.1e1 / t530
  t533 = t387 * t389 * t531
  t536 = 0.1e1 + 0.26986183074265975820379965457685664939550949913644e-1 * t527 * t533
  t537 = jnp.log(t536)
  t539 = 0.1e1 + 0.193e0 * t537
  t540 = 0.1e1 / t539
  t543 = t516 * t540 + 0.17411041666666666666666666666666666666666666666667e-2 * t464
  t546 = 0.1e1 + 0.93750000000000000000000000000000000000000000000000e-1 * t483 - 0.10117187500000000000000000000000000000000000000000e-1 * t495
  t547 = 0.1e1 / t546
  t551 = t499 + t238 * (t543 * t547 - t499)
  t552 = t293 * t551
  t554 = t290 * t552 / 0.16e2
  t555 = 0.1e1 / r1
  t556 = s2 * t555
  t557 = 0.1e1 / tau1
  t558 = f.my_piecewise3(t226, f.p.zeta_threshold, t225)
  t559 = t557 * t558
  t560 = 0.1e1 / t225
  t561 = t560 ** (0.1e1 / 0.3e1)
  t563 = t294 * t295 * t561
  t565 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t563
  t566 = jnp.sqrt(t563)
  t569 = t563 ** 0.15e1
  t571 = t561 ** 2
  t573 = t307 * t308 * t571
  t575 = 0.23615790870000000000000000000000000000000000000000e0 * t566 + 0.55771035800000000000000000000000000000000000000000e-1 * t563 + 0.12733319050000000000000000000000000000000000000000e-1 * t569 + 0.76629987700000000000000000000000000000000000000000e-2 * t573
  t577 = 0.1e1 + 0.1e1 / t575
  t578 = jnp.log(t577)
  t579 = t565 * t578
  t581 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t563
  t586 = 0.17489865900000000000000000000000000000000000000000e0 * t566 + 0.30591644850000000000000000000000000000000000000000e-1 * t563 + 0.37162376550000000000000000000000000000000000000000e-2 * t569 + 0.41939708850000000000000000000000000000000000000000e-2 * t573
  t588 = 0.1e1 + 0.1e1 / t586
  t589 = jnp.log(t588)
  t590 = t581 * t589
  t591 = t42 * t590
  t593 = -t579 + 0.58482233974552040708313425006184496242808878304904e0 * t591
  t595 = t335 * t10 * t561
  t597 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t595
  t598 = jnp.sqrt(t595)
  t601 = t595 ** 0.15e1
  t604 = t346 * t24 * t571
  t606 = 0.23615790870000000000000000000000000000000000000000e0 * t598 + 0.55771035800000000000000000000000000000000000000000e-1 * t595 + 0.12733319050000000000000000000000000000000000000000e-1 * t601 + 0.15325997540000000000000000000000000000000000000000e-1 * t604
  t608 = 0.1e1 + 0.1e1 / t606
  t609 = jnp.log(t608)
  t612 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t595
  t617 = 0.17489865900000000000000000000000000000000000000000e0 * t598 + 0.30591644850000000000000000000000000000000000000000e-1 * t595 + 0.37162376550000000000000000000000000000000000000000e-2 * t601 + 0.83879417700000000000000000000000000000000000000000e-2 * t604
  t619 = 0.1e1 + 0.1e1 / t617
  t620 = jnp.log(t619)
  t625 = t63 * (-t597 * t609 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * t612 * t620)
  t626 = t7 * t225
  t627 = t626 ** (0.1e1 / 0.3e1)
  t628 = 0.1e1 / t627
  t631 = 0.10e2 / 0.9e1 * t333 * t625 * t628
  t632 = t631 < -0.66725e-1
  t634 = f.my_piecewise3(t632, 0, 0.66725e-1 + t631)
  t635 = t634 * s2
  t636 = r1 ** 2
  t637 = r1 ** (0.1e1 / 0.3e1)
  t638 = t637 ** 2
  t640 = 0.1e1 / t638 / t636
  t641 = t640 * t19
  t642 = t635 * t641
  t643 = 0.1e1 / t561
  t644 = t8 * t643
  t645 = 0.0e0 < t593
  t647 = f.my_piecewise3(t645, t593, -t593)
  t648 = 0.1e1 / t647
  t650 = t387 * t644 * t648
  t653 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t642 * t650
  t654 = jnp.log(t653)
  t656 = 0.1e1 + 0.193e0 * t654
  t657 = 0.1e1 / t656
  t659 = 0.1e1 / t571
  t662 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t566 + 0.12382500000000000000000000000000000000000000000000e-1 * t563
  t665 = 0.1e1 + t566 * t662 / 0.2e1
  t666 = t665 ** 2
  t667 = 0.1e1 / t666
  t668 = t560 * t667
  t673 = t561 * t560
  t677 = t571 * t560
  t681 = t225 ** 2
  t682 = 0.1e1 / t681
  t685 = t561 * t682
  t689 = -0.37560000000000000000000000000000000000000000000000e-1 * t137 * t560 + 0.26347500000000000000000000000000000000000000000000e-2 * t420 * t421 * t673 - 0.47550000000000000000000000000000000000000000000000e-3 * t426 * t427 * t677 + 0.25560000000000000000000000000000000000000000000000e-3 * t163 * t682 - 0.21605625000000000000000000000000000000000000000000e-5 * t436 * t437 * t685
  t691 = 0.73596627000000000000000000000000000000000000000000e-2 * t137 * t668 - t593 * t689
  t692 = t659 * t691
  t693 = t38 * t659
  t694 = t566 * t563
  t695 = 0.1e1 / t665
  t696 = t694 * t695
  t697 = t693 * t696
  t700 = t593 ** 2
  t702 = 0.98556445000000000000000000000000000000000000000000e-3 * t447 * t697 - 0.2e1 * t700
  t703 = 0.1e1 / t702
  t704 = t692 * t703
  t705 = s2 * t640
  t706 = t627 ** 2
  t707 = t705 * t706
  t708 = t704 * t707
  t709 = t405 * t708
  t711 = t593 * t657 + 0.24872916666666666666666666666666666666666666666667e-2 * t709
  t715 = (-0.2e1 * t579 + 0.11696446794910408141662685001236899248561775660981e1 * t591) * t194
  t718 = t659 * t689
  t722 = 0.30956250000000000000000000000000000000000000000000e-2 * t715 * t696 - 0.39796666666666666666666666666666666666666666666667e-1 * t133 * t473 * t718
  t723 = t722 * t703
  t724 = t723 * s2
  t725 = t640 * t38
  t726 = t725 * t706
  t727 = t724 * t726
  t729 = t691 * t703
  t730 = s2 ** 2
  t731 = t729 * t730
  t732 = t636 ** 2
  t736 = 0.1e1 / t637 / t732 / r1 * t75
  t737 = t627 * t626
  t738 = t736 * t737
  t739 = t731 * t738
  t741 = 0.1e1 + t727 / 0.16e2 - t739 / 0.256e3
  t742 = 0.1e1 / t741
  t743 = t711 * t742
  t745 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t563
  t750 = 0.21947830050000000000000000000000000000000000000000e0 * t566 + 0.48171623250000000000000000000000000000000000000000e-1 * t563 + 0.13081894750000000000000000000000000000000000000000e-1 * t569 + 0.48591338250000000000000000000000000000000000000000e-2 * t573
  t752 = 0.1e1 + 0.1e1 / t750
  t753 = jnp.log(t752)
  t760 = -t579 + t238 * (-t745 * t753 + t579 - 0.58482233974552040708313425006184496242808878304904e0 * t590) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t590
  t761 = t593 * t38
  t764 = 0.10e2 / 0.9e1 * t517 * t761 * t628
  t765 = t764 < -0.66725e-1
  t767 = f.my_piecewise3(t765, 0, 0.66725e-1 + t764)
  t768 = t75 * t767
  t769 = t705 * t19
  t770 = t768 * t769
  t771 = 0.0e0 < t760
  t773 = f.my_piecewise3(t771, t760, -t760)
  t774 = 0.1e1 / t773
  t776 = t387 * t644 * t774
  t779 = 0.1e1 + 0.26986183074265975820379965457685664939550949913644e-1 * t770 * t776
  t780 = jnp.log(t779)
  t782 = 0.1e1 + 0.193e0 * t780
  t783 = 0.1e1 / t782
  t786 = t760 * t783 + 0.17411041666666666666666666666666666666666666666667e-2 * t709
  t789 = 0.1e1 + 0.93750000000000000000000000000000000000000000000000e-1 * t727 - 0.10117187500000000000000000000000000000000000000000e-1 * t739
  t790 = 0.1e1 / t789
  t794 = t743 + t238 * (t786 * t790 - t743)
  t795 = t559 * t794
  t797 = t556 * t795 / 0.16e2
  t799 = t4 * t151 * t30
  t800 = 0.11073577833333333333333333333333333333333333333333e-2 * t799
  t801 = t27 ** 2
  t804 = 0.1e1 / t14
  t806 = t65 * t135
  t807 = t804 * t1 * t806
  t809 = t4 * t151
  t811 = t11 ** 0.5e0
  t813 = t811 * t1 * t806
  t815 = t21 * t158
  t820 = t13 / t801 * (-0.39359651450000000000000000000000000000000000000000e-1 * t807 - 0.18590345266666666666666666666666666666666666666667e-1 * t809 - 0.63666595250000000000000000000000000000000000000000e-2 * t813 - 0.51086658466666666666666666666666666666666666666667e-2 * t815) / t29
  t823 = t65 * t135 * t52
  t824 = t42 * t1 * t823
  t827 = t49 ** 2
  t828 = 0.1e1 / t827
  t833 = -0.29149776500000000000000000000000000000000000000000e-1 * t807 - 0.10197214950000000000000000000000000000000000000000e-1 * t809 - 0.18581188275000000000000000000000000000000000000000e-2 * t813 - 0.27959805900000000000000000000000000000000000000000e-2 * t815
  t835 = 0.1e1 / t51
  t836 = t828 * t833 * t835
  t837 = t42 * t44 * t836
  t839 = t800 + t820 - 0.18311555036753159941307229983139571945136646663793e-3 * t824 - 0.58482233974552040708313425006184496242808878304904e0 * t837
  t841 = t128 ** 2
  t843 = t56 / t841
  t848 = t81 ** 2
  t854 = 0.1e1 / t70 * t38 * t1 * t806
  t856 = t64 * t806
  t858 = t67 ** 0.5e0
  t861 = t858 * t38 * t1 * t806
  t864 = t76 * t77 * t157
  t876 = t92 ** 2
  t897 = f.my_piecewise3(t104, 0, 0.10e2 / 0.9e1 * t60 * t63 * (0.11073577833333333333333333333333333333333333333333e-2 * t64 * t3 * t151 * t84 + t69 / t848 * (-0.39359651450000000000000000000000000000000000000000e-1 * t854 - 0.18590345266666666666666666666666666666666666666667e-1 * t856 - 0.63666595250000000000000000000000000000000000000000e-2 * t861 - 0.51086658466666666666666666666666666666666666666667e-2 * t864) / t83 - 0.18311555036753159941307229983139571945136646663793e-3 * t42 * t64 * t65 * t135 * t95 - 0.58482233974552040708313425006184496242808878304904e0 * t42 * t87 / t876 * (-0.29149776500000000000000000000000000000000000000000e-1 * t854 - 0.10197214950000000000000000000000000000000000000000e-1 * t856 - 0.18581188275000000000000000000000000000000000000000e-2 * t861 - 0.27959805900000000000000000000000000000000000000000e-2 * t864) / t94) * t9 - 0.10e2 / 0.27e2 * t60 * t100 * t135)
  t902 = t110 * t7
  t904 = 0.1e1 / t8 / t902
  t909 = t119 ** 2
  t913 = f.my_piecewise3(t117, t839, -t839)
  t919 = 0.1e1 / t125
  t925 = t133 * t112 * t172 * t186
  t927 = t2 * t162
  t941 = -t804 * t140 * t1 * t806 / 0.12e2 + t14 * (-0.66066666666666666666666666666666666666666666666667e-2 * t807 - 0.41275000000000000000000000000000000000000000000000e-2 * t809) / 0.2e1
  t950 = 0.1e1 / t22 / t110
  t954 = 0.1e1 / t902
  t955 = t161 * t954
  t960 = 0.18780000000000000000000000000000000000000000000000e-1 * t927 - 0.17565000000000000000000000000000000000000000000000e-2 * t150 * t167 + 0.39625000000000000000000000000000000000000000000000e-3 * t155 * t5 * t950 - 0.12780000000000000000000000000000000000000000000000e-3 * t955 + 0.12603281250000000000000000000000000000000000000000e-5 * t166 * t6 * t904
  t962 = -0.36798313500000000000000000000000000000000000000000e-2 * t927 * t145 - 0.73596627000000000000000000000000000000000000000000e-2 * t137 / t144 / t143 * t941 - t839 * t170 - t56 * t960
  t965 = t133 * t135 * t962 * t186
  t968 = t184 ** 2
  t969 = 0.1e1 / t968
  t970 = t172 * t969
  t975 = t174 ** 2
  t976 = t975 ** 2
  t989 = 0.13140859333333333333333333333333333333333333333333e-2 * t175 * t9 * t176 * t178 - 0.98556445000000000000000000000000000000000000000000e-3 * t116 * t976 * t174 * t23 * t14 * t178 - 0.19711289000000000000000000000000000000000000000000e-2 * t175 * t177 * t145 * t941 - 0.4e1 * t56 * t839
  t992 = t132 * t151 * t970 * t109 * t989
  t995 = (t839 * t129 - 0.193e0 * t843 * (0.53972366148531951640759930915371329879101899827289e-1 * t897 * t38 * t113 * t122 - 0.12593552101324122049510650546919976971790443293034e0 * t107 * t109 * t904 * t122 - 0.53972366148531951640759930915371329879101899827289e-1 * t114 * t116 * t5 / t909 * t913) * t919 - 0.13265555555555555555555555555555555555555555555555e-1 * t925 + 0.99491666666666666666666666666666666666666666666666e-2 * t965 - 0.99491666666666666666666666666666666666666666666666e-2 * t992) * t216
  t996 = t215 ** 2
  t998 = t190 / t996
  t1026 = (0.30956250000000000000000000000000000000000000000000e-2 * (0.22147155666666666666666666666666666666666666666666e-2 * t799 + 0.2e1 * t820 - 0.36623110073506319882614459966279143890273293327587e-3 * t824 - 0.11696446794910408141662685001236899248561775660981e1 * t837) * t194 * t196 - 0.61912500000000000000000000000000000000000000000000e-2 * t193 * t174 * t14 * t178 * t1 * t3 * t135 - 0.30956250000000000000000000000000000000000000000000e-2 * t195 * t176 * t145 * t941 - 0.53062222222222222222222222222222222222222222222222e-1 * t132 * t10 * t170 - 0.79593333333333333333333333333333333333333333333333e-1 * t132 * t199 * t960) * t185 * t205
  t1030 = t203 * t969 * t205 * t989
  t1033 = t204 * t109 * t954
  t1036 = t962 * t185 * t212
  t1039 = t970 * t212 * t989
  t1044 = t208 * t209 / t210 / t7
  t1047 = t998 * (t1026 / 0.8e1 - t1030 / 0.8e1 - t1033 / 0.4e1 - t1036 / 0.64e2 + t1039 / 0.64e2 + t1044 / 0.16e2)
  t1048 = t218 * t162
  t1049 = t136 - t1048
  t1052 = f.my_piecewise3(t221, 0, 0.4e1 / 0.3e1 * t222 * t1049)
  t1053 = -t1049
  t1056 = f.my_piecewise3(t226, 0, 0.4e1 / 0.3e1 * t227 * t1053)
  t1063 = t245 ** 2
  t1089 = t800 + t820 + t238 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t151 * t248 + t240 / t1063 * (-0.36579716750000000000000000000000000000000000000000e-1 * t807 - 0.16057207750000000000000000000000000000000000000000e-1 * t809 - 0.65409473750000000000000000000000000000000000000000e-2 * t813 - 0.32394225500000000000000000000000000000000000000000e-2 * t815) / t247 - t800 - t820 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t151 * t52 + 0.58482233974552040708313425006184496242808878304904e0 * t44 * t828 * t833 * t835) - 0.18311555036753159941307229983139571945136646663793e-3 * t238 * t1 * t823 - 0.58482233974552040708313425006184496242808878304904e0 * t238 * t44 * t836
  t1091 = t277 ** 2
  t1093 = t255 / t1091
  t1102 = f.my_piecewise3(t261, 0, 0.10e2 / 0.9e1 * t256 * t63 * t839 * t9 - 0.10e2 / 0.27e2 * t256 * t257 * t135)
  t1112 = t268 ** 2
  t1115 = f.my_piecewise3(t266, t1089, -t1089)
  t1121 = 0.1e1 / t274
  t1130 = t284 ** 2
  t1132 = t281 / t1130
  t1142 = t231 * ((t1089 * t278 - 0.193e0 * t1093 * (0.53972366148531951640759930915371329879101899827289e-1 * t1102 * t109 * t112 * t271 - 0.12593552101324122049510650546919976971790443293034e0 * t264 * t904 * t271 - 0.53972366148531951640759930915371329879101899827289e-1 * t264 * t112 * t19 * t387 / t1112 * t1115) * t1121 - 0.92858888888888888888888888888888888888888888888888e-2 * t925 + 0.69644166666666666666666666666666666666666666666666e-2 * t965 - 0.69644166666666666666666666666666666666666666666666e-2 * t992) * t285 - t1132 * (0.18750000000000000000000000000000000000000000000000e0 * t1026 - 0.18750000000000000000000000000000000000000000000000e0 * t1030 - 0.37500000000000000000000000000000000000000000000000e0 * t1033 - 0.40468750000000000000000000000000000000000000000000e-1 * t1036 + 0.40468750000000000000000000000000000000000000000000e-1 * t1039 + 0.16187500000000000000000000000000000000000000000000e0 * t1044) - t995 + t1047)
  t1147 = f.my_piecewise3(t221, 0, t1049)
  t1153 = t294 * t421 * t297
  t1154 = 0.11073577833333333333333333333333333333333333333333e-2 * t1153
  t1155 = t433 * t1049
  t1157 = t11 * t448 * t1155
  t1160 = (-t1154 - 0.11073577833333333333333333333333333333333333333333e-2 * t1157) * t316
  t1161 = t313 ** 2
  t1163 = t301 / t1161
  t1164 = 0.1e1 / t302
  t1166 = -t1153 / 0.3e1 - t1157 / 0.3e1
  t1167 = t1164 * t1166
  t1169 = 0.18590345266666666666666666666666666666666666666667e-1 * t1153
  t1171 = t299 ** 0.5e0
  t1172 = t1171 * t1166
  t1175 = t307 * t427 * t309
  t1176 = 0.51086658466666666666666666666666666666666666666667e-2 * t1175
  t1177 = t75 * t388
  t1179 = t25 * t1177 * t1155
  t1182 = 0.1e1 / t315
  t1184 = t1163 * (0.11807895435000000000000000000000000000000000000000e0 * t1167 - t1169 - 0.18590345266666666666666666666666666666666666666667e-1 * t1157 + 0.19099978575000000000000000000000000000000000000000e-1 * t1172 - t1176 - 0.51086658466666666666666666666666666666666666666667e-2 * t1179) * t1182
  t1185 = 0.31311312500000000000000000000000000000000000000000e-3 * t1153
  t1188 = (-t1185 - 0.31311312500000000000000000000000000000000000000000e-3 * t1157) * t327
  t1189 = t42 * t1188
  t1191 = t42 * t319
  t1192 = t324 ** 2
  t1193 = 0.1e1 / t1192
  t1195 = 0.10197214950000000000000000000000000000000000000000e-1 * t1153
  t1198 = 0.27959805900000000000000000000000000000000000000000e-2 * t1175
  t1200 = 0.87449329500000000000000000000000000000000000000000e-1 * t1167 - t1195 - 0.10197214950000000000000000000000000000000000000000e-1 * t1157 + 0.55743564825000000000000000000000000000000000000000e-2 * t1172 - t1198 - 0.27959805900000000000000000000000000000000000000000e-2 * t1179
  t1202 = 0.1e1 / t326
  t1203 = t1193 * t1200 * t1202
  t1204 = t1191 * t1203
  t1206 = -t1160 + t1184 + 0.58482233974552040708313425006184496242808878304904e0 * t1189 - 0.58482233974552040708313425006184496242808878304904e0 * t1204
  t1208 = t401 ** 2
  t1210 = t331 / t1208
  t1212 = t335 * t151 * t297
  t1213 = 0.11073577833333333333333333333333333333333333333333e-2 * t1212
  t1214 = t334 * t65
  t1215 = t9 * t406
  t1217 = t1214 * t1215 * t1155
  t1221 = t350 ** 2
  t1223 = t339 / t1221
  t1224 = 0.1e1 / t340
  t1226 = -t1212 / 0.3e1 - t1217 / 0.3e1
  t1227 = t1224 * t1226
  t1229 = 0.18590345266666666666666666666666666666666666666667e-1 * t1212
  t1231 = t337 ** 0.5e0
  t1232 = t1231 * t1226
  t1235 = t346 * t158 * t309
  t1236 = 0.10217331693333333333333333333333333333333333333333e-1 * t1235
  t1237 = t345 * t77
  t1238 = t23 * t388
  t1240 = t1237 * t1238 * t1155
  t1243 = 0.1e1 / t352
  t1246 = 0.31311312500000000000000000000000000000000000000000e-3 * t1212
  t1252 = t42 * t356
  t1253 = t361 ** 2
  t1254 = 0.1e1 / t1253
  t1256 = 0.10197214950000000000000000000000000000000000000000e-1 * t1212
  t1259 = 0.55919611800000000000000000000000000000000000000000e-2 * t1235
  t1263 = 0.1e1 / t363
  t1272 = 0.1e1 / t493
  t1274 = t7 * t1049 + t219 + 0.1e1
  t1275 = t1272 * t1274
  t1280 = f.my_piecewise3(t376, 0, 0.10e2 / 0.9e1 * t333 * t63 * (-(-t1213 - 0.11073577833333333333333333333333333333333333333333e-2 * t1217) * t353 + t1223 * (0.11807895435000000000000000000000000000000000000000e0 * t1227 - t1229 - 0.18590345266666666666666666666666666666666666666667e-1 * t1217 + 0.19099978575000000000000000000000000000000000000000e-1 * t1232 - t1236 - 0.10217331693333333333333333333333333333333333333333e-1 * t1240) * t1243 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * (-t1246 - 0.31311312500000000000000000000000000000000000000000e-3 * t1217) * t364 - 0.58482233974552040708313425006184496242808878304904e0 * t1252 * t1254 * (0.87449329500000000000000000000000000000000000000000e-1 * t1227 - t1256 - 0.10197214950000000000000000000000000000000000000000e-1 * t1217 + 0.55743564825000000000000000000000000000000000000000e-2 * t1232 - t1259 - 0.55919611800000000000000000000000000000000000000000e-2 * t1240) * t1263) * t372 - 0.10e2 / 0.27e2 * t333 * t369 * t1275)
  t1287 = 0.1e1 / t382 / t380 / r0
  t1295 = 0.17990788716177317213586643638457109959700633275763e-1 * t386 * t387 * t1238 * t393
  t1296 = t385 * t115
  t1297 = t379 * t1296
  t1298 = t5 * t8
  t1300 = t1298 / t422
  t1301 = t393 * t433
  t1306 = t392 ** 2
  t1308 = t388 / t1306
  t1310 = f.my_piecewise3(t390, t1206, -t1206)
  t1316 = 0.1e1 / t398
  t1321 = t132 * t10 * t75
  t1322 = t1321 * t463
  t1323 = 0.16581944444444444444444444444444444444444444444445e-2 * t1322
  t1324 = t22 * t75
  t1325 = 0.1e1 / t428
  t1327 = t133 * t1324 * t1325
  t1328 = t485 * s0
  t1329 = t384 * t461
  t1332 = t1327 * t1328 * t1329 * t1155
  t1335 = 0.73596627000000000000000000000000000000000000000000e-2 * t927 * t415
  t1336 = t433 * t414
  t1342 = t296 / t413 / t412
  t1343 = t1164 * t409
  t1347 = 0.41275000000000000000000000000000000000000000000000e-2 * t1153
  t1352 = t1343 * t1166 / 0.4e1 + t302 * (0.19820000000000000000000000000000000000000000000000e-1 * t1167 - t1347 - 0.41275000000000000000000000000000000000000000000000e-2 * t1157) / 0.2e1
  t1358 = 0.37560000000000000000000000000000000000000000000000e-1 * t927 * t296
  t1363 = 0.35130000000000000000000000000000000000000000000000e-2 * t420 * t437 * t422
  t1364 = t38 * t297
  t1368 = t950 * t75
  t1371 = 0.79250000000000000000000000000000000000000000000000e-3 * t426 * t1368 * t428
  t1372 = t75 * t309
  t1377 = 0.51120000000000000000000000000000000000000000000000e-3 * t955 * t433
  t1379 = 0.1e1 / t432 / t220
  t1383 = t904 * t38
  t1386 = 0.50413125000000000000000000000000000000000000000000e-5 * t436 * t1383 * t438
  t1387 = t38 * t422
  t1391 = t1358 + 0.37560000000000000000000000000000000000000000000000e-1 * t137 * t1155 - t1363 - 0.35130000000000000000000000000000000000000000000000e-2 * t152 * t1364 * t1155 + t1371 + 0.79250000000000000000000000000000000000000000000000e-3 * t159 * t1372 * t1155 - t1377 - 0.51120000000000000000000000000000000000000000000000e-3 * t163 * t1379 * t1049 + t1386 + 0.50413125000000000000000000000000000000000000000000e-5 * t168 * t1387 * t1155
  t1393 = -t1335 - 0.73596627000000000000000000000000000000000000000000e-2 * t137 * t1336 * t1049 - 0.14719325400000000000000000000000000000000000000000e-1 * t137 * t1342 * t1352 - t1206 * t442 - t331 * t1391
  t1397 = t405 * t406 * t1393 * t458 * t462
  t1400 = t133 * t1324 * t406
  t1401 = t457 ** 2
  t1402 = 0.1e1 / t1401
  t1403 = t444 * t1402
  t1404 = t1403 * s0
  t1406 = t132 * t174 * t9
  t1408 = 0.65704296666666666666666666666666666666666666666667e-3 * t1406 * t452
  t1410 = t132 * t446 * t38
  t1411 = t1325 * t449
  t1412 = t450 * t433
  t1417 = t302 * t450
  t1418 = t1417 * t1166
  t1422 = t449 * t414
  t1423 = t1422 * t1352
  t1429 = t1408 + 0.65704296666666666666666666666666666666666666666667e-3 * t1410 * t1411 * t1412 * t1049 + 0.14783466750000000000000000000000000000000000000000e-2 * t447 * t448 * t1418 - 0.98556445000000000000000000000000000000000000000000e-3 * t447 * t448 * t1423 - 0.4e1 * t331 * t1206
  t1432 = t1400 * t1404 * t1329 * t1429
  t1434 = s0 * t1287
  t1437 = t405 * t459 * t1434 * t461
  t1439 = t384 * t372
  t1442 = t1400 * t1328 * t1439 * t1274
  t1445 = (t1206 * t402 - 0.193e0 * t1210 * (0.53972366148531951640759930915371329879101899827289e-1 * t1280 * s0 * t385 * t395 - 0.14392630972941853770869314910765687967760506620610e0 * t379 * t1287 * t19 * t395 + t1295 + 0.17990788716177317213586643638457109959700633275763e-1 * t1297 * t1300 * t1301 * t1049 - 0.53972366148531951640759930915371329879101899827289e-1 * t1297 * t1298 * t1308 * t1310) * t1316 + t1323 + 0.16581944444444444444444444444444444444444444444445e-2 * t1332 + 0.24872916666666666666666666666666666666666666666667e-2 * t1397 - 0.24872916666666666666666666666666666666666666666667e-2 * t1432 - 0.66327777777777777777777777777777777777777777777779e-2 * t1437 + 0.16581944444444444444444444444444444444444444444445e-2 * t1442) * t498
  t1446 = t497 ** 2
  t1448 = t466 / t1446
  t1463 = 0.26531111111111111111111111111111111111111111111111e-1 * t133 * t295 * t474
  t1464 = t132 * t199
  t1465 = t38 * t1325
  t1466 = t442 * t433
  t1478 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t1160 + 0.2e1 * t1184 + 0.11696446794910408141662685001236899248561775660981e1 * t1189 - 0.11696446794910408141662685001236899248561775660981e1 * t1204) * t194 * t451 + 0.46434375000000000000000000000000000000000000000000e-2 * t470 * t1418 - 0.30956250000000000000000000000000000000000000000000e-2 * t470 * t1423 - t1463 - 0.26531111111111111111111111111111111111111111111111e-1 * t1464 * t1465 * t1466 * t1049 - 0.39796666666666666666666666666666666666666666666667e-1 * t133 * t473 * t406 * t1391) * t458 * s0 * t482
  t1481 = t478 * t1402 * s0
  t1484 = t1481 * t481 * t461 * t1429
  t1488 = t480 * t1287 * t38 * t461
  t1492 = t480 * t481 * t372 * t1274
  t1496 = t1393 * t458 * t486 * t494
  t1498 = t1403 * t486
  t1501 = t1498 * t492 * t493 * t1429
  t1508 = t487 / t381 / t488 / t380 * t75 * t493
  t1512 = t487 * t492 * t371 * t1274
  t1515 = t1448 * (t1478 / 0.16e2 - t1484 / 0.16e2 - t1488 / 0.6e1 + t1492 / 0.24e2 - t1496 / 0.256e3 + t1501 / 0.256e3 + t1508 / 0.48e2 - t1512 / 0.192e3)
  t1516 = 0.53236443333333333333333333333333333333333333333333e-3 * t1153
  t1520 = t506 ** 2
  t1522 = t501 / t1520
  t1524 = 0.16057207750000000000000000000000000000000000000000e-1 * t1153
  t1527 = 0.32394225500000000000000000000000000000000000000000e-2 * t1175
  t1530 = 0.1e1 / t508
  t1534 = t319 * t1193
  t1542 = t238 * t319
  t1545 = -t1160 + t1184 + t238 * (-(-t1516 - 0.53236443333333333333333333333333333333333333333333e-3 * t1157) * t509 + t1522 * (0.10973915025000000000000000000000000000000000000000e0 * t1167 - t1524 - 0.16057207750000000000000000000000000000000000000000e-1 * t1157 + 0.19622842125000000000000000000000000000000000000000e-1 * t1172 - t1527 - 0.32394225500000000000000000000000000000000000000000e-2 * t1179) * t1530 + t1160 - t1184 - 0.58482233974552040708313425006184496242808878304904e0 * t1188 + 0.58482233974552040708313425006184496242808878304904e0 * t1534 * t1200 * t1202) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t1188 - 0.58482233974552040708313425006184496242808878304904e0 * t1542 * t1203
  t1547 = t539 ** 2
  t1549 = t516 / t1547
  t1558 = f.my_piecewise3(t522, 0, 0.10e2 / 0.9e1 * t517 * t1206 * t38 * t372 - 0.10e2 / 0.27e2 * t517 * t518 * t1275)
  t1570 = 0.89953943580886586067933218192285549798503166378813e-2 * t527 * t387 * t1238 * t531
  t1572 = t525 * s0 * t1296
  t1573 = t531 * t433
  t1578 = t387 * t8
  t1579 = t530 ** 2
  t1581 = t388 / t1579
  t1583 = f.my_piecewise3(t528, t1545, -t1545)
  t1589 = 0.1e1 / t536
  t1593 = 0.11607361111111111111111111111111111111111111111111e-2 * t1322
  t1601 = t546 ** 2
  t1603 = t543 / t1601
  t1620 = f.my_piecewise3(t226, 0, t1053)
  t1626 = t294 * t421 * t561
  t1627 = 0.11073577833333333333333333333333333333333333333333e-2 * t1626
  t1628 = t682 * t1053
  t1630 = t11 * t693 * t1628
  t1633 = (-t1627 - 0.11073577833333333333333333333333333333333333333333e-2 * t1630) * t578
  t1634 = t575 ** 2
  t1636 = t565 / t1634
  t1637 = 0.1e1 / t566
  t1639 = -t1626 / 0.3e1 - t1630 / 0.3e1
  t1640 = t1637 * t1639
  t1642 = 0.18590345266666666666666666666666666666666666666667e-1 * t1626
  t1644 = t563 ** 0.5e0
  t1645 = t1644 * t1639
  t1648 = t307 * t427 * t571
  t1649 = 0.51086658466666666666666666666666666666666666666667e-2 * t1648
  t1650 = t75 * t643
  t1652 = t25 * t1650 * t1628
  t1655 = 0.1e1 / t577
  t1657 = t1636 * (0.11807895435000000000000000000000000000000000000000e0 * t1640 - t1642 - 0.18590345266666666666666666666666666666666666666667e-1 * t1630 + 0.19099978575000000000000000000000000000000000000000e-1 * t1645 - t1649 - 0.51086658466666666666666666666666666666666666666667e-2 * t1652) * t1655
  t1658 = 0.31311312500000000000000000000000000000000000000000e-3 * t1626
  t1661 = (-t1658 - 0.31311312500000000000000000000000000000000000000000e-3 * t1630) * t589
  t1662 = t42 * t1661
  t1664 = t42 * t581
  t1665 = t586 ** 2
  t1666 = 0.1e1 / t1665
  t1668 = 0.10197214950000000000000000000000000000000000000000e-1 * t1626
  t1671 = 0.27959805900000000000000000000000000000000000000000e-2 * t1648
  t1673 = 0.87449329500000000000000000000000000000000000000000e-1 * t1640 - t1668 - 0.10197214950000000000000000000000000000000000000000e-1 * t1630 + 0.55743564825000000000000000000000000000000000000000e-2 * t1645 - t1671 - 0.27959805900000000000000000000000000000000000000000e-2 * t1652
  t1675 = 0.1e1 / t588
  t1676 = t1666 * t1673 * t1675
  t1677 = t1664 * t1676
  t1679 = -t1633 + t1657 + 0.58482233974552040708313425006184496242808878304904e0 * t1662 - 0.58482233974552040708313425006184496242808878304904e0 * t1677
  t1681 = t656 ** 2
  t1683 = t593 / t1681
  t1685 = t335 * t151 * t561
  t1686 = 0.11073577833333333333333333333333333333333333333333e-2 * t1685
  t1687 = t9 * t659
  t1689 = t1214 * t1687 * t1628
  t1693 = t606 ** 2
  t1695 = t597 / t1693
  t1696 = 0.1e1 / t598
  t1698 = -t1685 / 0.3e1 - t1689 / 0.3e1
  t1699 = t1696 * t1698
  t1701 = 0.18590345266666666666666666666666666666666666666667e-1 * t1685
  t1703 = t595 ** 0.5e0
  t1704 = t1703 * t1698
  t1707 = t346 * t158 * t571
  t1708 = 0.10217331693333333333333333333333333333333333333333e-1 * t1707
  t1709 = t23 * t643
  t1711 = t1237 * t1709 * t1628
  t1714 = 0.1e1 / t608
  t1717 = 0.31311312500000000000000000000000000000000000000000e-3 * t1685
  t1723 = t42 * t612
  t1724 = t617 ** 2
  t1725 = 0.1e1 / t1724
  t1727 = 0.10197214950000000000000000000000000000000000000000e-1 * t1685
  t1730 = 0.55919611800000000000000000000000000000000000000000e-2 * t1707
  t1734 = 0.1e1 / t619
  t1743 = 0.1e1 / t737
  t1745 = t7 * t1053 - t219 + 0.1e1
  t1746 = t1743 * t1745
  t1751 = f.my_piecewise3(t632, 0, 0.10e2 / 0.9e1 * t333 * t63 * (-(-t1686 - 0.11073577833333333333333333333333333333333333333333e-2 * t1689) * t609 + t1695 * (0.11807895435000000000000000000000000000000000000000e0 * t1699 - t1701 - 0.18590345266666666666666666666666666666666666666667e-1 * t1689 + 0.19099978575000000000000000000000000000000000000000e-1 * t1704 - t1708 - 0.10217331693333333333333333333333333333333333333333e-1 * t1711) * t1714 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * (-t1717 - 0.31311312500000000000000000000000000000000000000000e-3 * t1689) * t620 - 0.58482233974552040708313425006184496242808878304904e0 * t1723 * t1725 * (0.87449329500000000000000000000000000000000000000000e-1 * t1699 - t1727 - 0.10197214950000000000000000000000000000000000000000e-1 * t1689 + 0.55743564825000000000000000000000000000000000000000e-2 * t1704 - t1730 - 0.55919611800000000000000000000000000000000000000000e-2 * t1711) * t1734) * t628 - 0.10e2 / 0.27e2 * t333 * t625 * t1746)
  t1759 = 0.17990788716177317213586643638457109959700633275763e-1 * t642 * t387 * t1709 * t648
  t1760 = t641 * t115
  t1761 = t635 * t1760
  t1763 = t1298 / t673
  t1764 = t648 * t682
  t1769 = t647 ** 2
  t1771 = t643 / t1769
  t1773 = f.my_piecewise3(t645, t1679, -t1679)
  t1779 = 0.1e1 / t653
  t1783 = t1321 * t708
  t1784 = 0.16581944444444444444444444444444444444444444444445e-2 * t1783
  t1785 = 0.1e1 / t677
  t1787 = t133 * t1324 * t1785
  t1788 = t729 * s2
  t1789 = t640 * t706
  t1792 = t1787 * t1788 * t1789 * t1628
  t1795 = 0.73596627000000000000000000000000000000000000000000e-2 * t927 * t668
  t1796 = t682 * t667
  t1802 = t560 / t666 / t665
  t1803 = t1637 * t662
  t1807 = 0.41275000000000000000000000000000000000000000000000e-2 * t1626
  t1812 = t1803 * t1639 / 0.4e1 + t566 * (0.19820000000000000000000000000000000000000000000000e-1 * t1640 - t1807 - 0.41275000000000000000000000000000000000000000000000e-2 * t1630) / 0.2e1
  t1818 = 0.37560000000000000000000000000000000000000000000000e-1 * t927 * t560
  t1823 = 0.35130000000000000000000000000000000000000000000000e-2 * t420 * t437 * t673
  t1824 = t38 * t561
  t1830 = 0.79250000000000000000000000000000000000000000000000e-3 * t426 * t1368 * t677
  t1831 = t75 * t571
  t1836 = 0.51120000000000000000000000000000000000000000000000e-3 * t955 * t682
  t1838 = 0.1e1 / t681 / t225
  t1844 = 0.50413125000000000000000000000000000000000000000000e-5 * t436 * t1383 * t685
  t1845 = t38 * t673
  t1849 = t1818 + 0.37560000000000000000000000000000000000000000000000e-1 * t137 * t1628 - t1823 - 0.35130000000000000000000000000000000000000000000000e-2 * t152 * t1824 * t1628 + t1830 + 0.79250000000000000000000000000000000000000000000000e-3 * t159 * t1831 * t1628 - t1836 - 0.51120000000000000000000000000000000000000000000000e-3 * t163 * t1838 * t1053 + t1844 + 0.50413125000000000000000000000000000000000000000000e-5 * t168 * t1845 * t1628
  t1851 = -t1795 - 0.73596627000000000000000000000000000000000000000000e-2 * t137 * t1796 * t1053 - 0.14719325400000000000000000000000000000000000000000e-1 * t137 * t1802 * t1812 - t1679 * t689 - t593 * t1849
  t1855 = t405 * t659 * t1851 * t703 * t707
  t1858 = t133 * t1324 * t659
  t1859 = t702 ** 2
  t1860 = 0.1e1 / t1859
  t1861 = t691 * t1860
  t1862 = t1861 * s2
  t1864 = 0.65704296666666666666666666666666666666666666666667e-3 * t1406 * t697
  t1865 = t1785 * t694
  t1866 = t695 * t682
  t1871 = t566 * t695
  t1872 = t1871 * t1639
  t1876 = t694 * t667
  t1877 = t1876 * t1812
  t1883 = t1864 + 0.65704296666666666666666666666666666666666666666667e-3 * t1410 * t1865 * t1866 * t1053 + 0.14783466750000000000000000000000000000000000000000e-2 * t447 * t693 * t1872 - 0.98556445000000000000000000000000000000000000000000e-3 * t447 * t693 * t1877 - 0.4e1 * t593 * t1679
  t1886 = t1858 * t1862 * t1789 * t1883
  t1888 = t640 * t628
  t1891 = t1858 * t1788 * t1888 * t1745
  t1894 = (t1679 * t657 - 0.193e0 * t1683 * (0.53972366148531951640759930915371329879101899827289e-1 * t1751 * s2 * t641 * t650 + t1759 + 0.17990788716177317213586643638457109959700633275763e-1 * t1761 * t1763 * t1764 * t1053 - 0.53972366148531951640759930915371329879101899827289e-1 * t1761 * t1298 * t1771 * t1773) * t1779 + t1784 + 0.16581944444444444444444444444444444444444444444445e-2 * t1792 + 0.24872916666666666666666666666666666666666666666667e-2 * t1855 - 0.24872916666666666666666666666666666666666666666667e-2 * t1886 + 0.16581944444444444444444444444444444444444444444445e-2 * t1891) * t742
  t1895 = t741 ** 2
  t1897 = t711 / t1895
  t1912 = 0.26531111111111111111111111111111111111111111111111e-1 * t133 * t295 * t718
  t1913 = t38 * t1785
  t1914 = t689 * t682
  t1926 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t1633 + 0.2e1 * t1657 + 0.11696446794910408141662685001236899248561775660981e1 * t1662 - 0.11696446794910408141662685001236899248561775660981e1 * t1677) * t194 * t696 + 0.46434375000000000000000000000000000000000000000000e-2 * t715 * t1872 - 0.30956250000000000000000000000000000000000000000000e-2 * t715 * t1877 - t1912 - 0.26531111111111111111111111111111111111111111111111e-1 * t1464 * t1913 * t1914 * t1053 - 0.39796666666666666666666666666666666666666666666667e-1 * t133 * t473 * t659 * t1849) * t703 * s2 * t726
  t1929 = t722 * t1860 * s2
  t1932 = t1929 * t725 * t706 * t1883
  t1936 = t724 * t725 * t628 * t1745
  t1940 = t1851 * t703 * t730 * t738
  t1942 = t1861 * t730
  t1945 = t1942 * t736 * t737 * t1883
  t1949 = t731 * t736 * t627 * t1745
  t1952 = t1897 * (t1926 / 0.16e2 - t1932 / 0.16e2 + t1936 / 0.24e2 - t1940 / 0.256e3 + t1945 / 0.256e3 - t1949 / 0.192e3)
  t1953 = 0.53236443333333333333333333333333333333333333333333e-3 * t1626
  t1957 = t750 ** 2
  t1959 = t745 / t1957
  t1961 = 0.16057207750000000000000000000000000000000000000000e-1 * t1626
  t1964 = 0.32394225500000000000000000000000000000000000000000e-2 * t1648
  t1967 = 0.1e1 / t752
  t1971 = t581 * t1666
  t1979 = t238 * t581
  t1982 = -t1633 + t1657 + t238 * (-(-t1953 - 0.53236443333333333333333333333333333333333333333333e-3 * t1630) * t753 + t1959 * (0.10973915025000000000000000000000000000000000000000e0 * t1640 - t1961 - 0.16057207750000000000000000000000000000000000000000e-1 * t1630 + 0.19622842125000000000000000000000000000000000000000e-1 * t1645 - t1964 - 0.32394225500000000000000000000000000000000000000000e-2 * t1652) * t1967 + t1633 - t1657 - 0.58482233974552040708313425006184496242808878304904e0 * t1661 + 0.58482233974552040708313425006184496242808878304904e0 * t1971 * t1673 * t1675) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t1661 - 0.58482233974552040708313425006184496242808878304904e0 * t1979 * t1676
  t1984 = t782 ** 2
  t1986 = t760 / t1984
  t1995 = f.my_piecewise3(t765, 0, 0.10e2 / 0.9e1 * t517 * t1679 * t38 * t628 - 0.10e2 / 0.27e2 * t517 * t761 * t1746)
  t2003 = 0.89953943580886586067933218192285549798503166378813e-2 * t770 * t387 * t1709 * t774
  t2005 = t768 * s2 * t1760
  t2006 = t774 * t682
  t2011 = t773 ** 2
  t2013 = t643 / t2011
  t2015 = f.my_piecewise3(t771, t1982, -t1982)
  t2021 = 0.1e1 / t779
  t2025 = 0.11607361111111111111111111111111111111111111111111e-2 * t1783
  t2032 = t789 ** 2
  t2034 = t786 / t2032
  vrho_0_ = t217 + t288 - t554 - t797 + t7 * (t995 - t1047 + (t1052 + t1056) * t41 * t287 + t1142 + s0 / t380 * t552 / 0.16e2 - t290 * t291 * t1147 * t551 / 0.16e2 - t290 * t293 * (t1445 - t1515 + t238 * ((t1545 * t540 - 0.193e0 * t1549 * (0.26986183074265975820379965457685664939550949913644e-1 * t75 * t1558 * t526 * t533 - 0.71963154864709268854346574553828439838802533103051e-1 * t525 * t1434 * t19 * t533 + t1570 + 0.89953943580886586067933218192285549798503166378813e-2 * t1572 * t1300 * t1573 * t1049 - 0.26986183074265975820379965457685664939550949913644e-1 * t527 * t1578 * t1581 * t1583) * t1589 + t1593 + 0.11607361111111111111111111111111111111111111111111e-2 * t1332 + 0.17411041666666666666666666666666666666666666666667e-2 * t1397 - 0.17411041666666666666666666666666666666666666666667e-2 * t1432 - 0.46429444444444444444444444444444444444444444444445e-2 * t1437 + 0.11607361111111111111111111111111111111111111111111e-2 * t1442) * t547 - t1603 * (0.93750000000000000000000000000000000000000000000000e-1 * t1478 - 0.93750000000000000000000000000000000000000000000000e-1 * t1484 - 0.25000000000000000000000000000000000000000000000000e0 * t1488 + 0.62500000000000000000000000000000000000000000000000e-1 * t1492 - 0.10117187500000000000000000000000000000000000000000e-1 * t1496 + 0.10117187500000000000000000000000000000000000000000e-1 * t1501 + 0.53958333333333333333333333333333333333333333333333e-1 * t1508 - 0.13489583333333333333333333333333333333333333333333e-1 * t1512) - t1445 + t1515)) / 0.16e2 - t556 * t557 * t1620 * t794 / 0.16e2 - t556 * t559 * (t1894 - t1952 + t238 * ((t1982 * t783 - 0.193e0 * t1986 * (0.26986183074265975820379965457685664939550949913644e-1 * t75 * t1995 * t769 * t776 + t2003 + 0.89953943580886586067933218192285549798503166378813e-2 * t2005 * t1763 * t2006 * t1053 - 0.26986183074265975820379965457685664939550949913644e-1 * t770 * t1578 * t2013 * t2015) * t2021 + t2025 + 0.11607361111111111111111111111111111111111111111111e-2 * t1792 + 0.17411041666666666666666666666666666666666666666667e-2 * t1855 - 0.17411041666666666666666666666666666666666666666667e-2 * t1886 + 0.11607361111111111111111111111111111111111111111111e-2 * t1891) * t790 - t2034 * (0.93750000000000000000000000000000000000000000000000e-1 * t1926 - 0.93750000000000000000000000000000000000000000000000e-1 * t1932 + 0.62500000000000000000000000000000000000000000000000e-1 * t1936 - 0.10117187500000000000000000000000000000000000000000e-1 * t1940 + 0.10117187500000000000000000000000000000000000000000e-1 * t1945 - 0.13489583333333333333333333333333333333333333333333e-1 * t1949) - t1894 + t1952)) / 0.16e2)
  t2051 = -t136 - t1048
  t2054 = f.my_piecewise3(t221, 0, 0.4e1 / 0.3e1 * t222 * t2051)
  t2055 = -t2051
  t2058 = f.my_piecewise3(t226, 0, 0.4e1 / 0.3e1 * t227 * t2055)
  t2062 = f.my_piecewise3(t221, 0, t2051)
  t2067 = t433 * t2051
  t2069 = t11 * t448 * t2067
  t2072 = (-t1154 - 0.11073577833333333333333333333333333333333333333333e-2 * t2069) * t316
  t2074 = -t1153 / 0.3e1 - t2069 / 0.3e1
  t2075 = t1164 * t2074
  t2078 = t1171 * t2074
  t2081 = t25 * t1177 * t2067
  t2085 = t1163 * (0.11807895435000000000000000000000000000000000000000e0 * t2075 - t1169 - 0.18590345266666666666666666666666666666666666666667e-1 * t2069 + 0.19099978575000000000000000000000000000000000000000e-1 * t2078 - t1176 - 0.51086658466666666666666666666666666666666666666667e-2 * t2081) * t1182
  t2088 = (-t1185 - 0.31311312500000000000000000000000000000000000000000e-3 * t2069) * t327
  t2089 = t42 * t2088
  t2095 = 0.87449329500000000000000000000000000000000000000000e-1 * t2075 - t1195 - 0.10197214950000000000000000000000000000000000000000e-1 * t2069 + 0.55743564825000000000000000000000000000000000000000e-2 * t2078 - t1198 - 0.27959805900000000000000000000000000000000000000000e-2 * t2081
  t2097 = t1193 * t2095 * t1202
  t2098 = t1191 * t2097
  t2100 = -t2072 + t2085 + 0.58482233974552040708313425006184496242808878304904e0 * t2089 - 0.58482233974552040708313425006184496242808878304904e0 * t2098
  t2103 = t1214 * t1215 * t2067
  t2108 = -t1212 / 0.3e1 - t2103 / 0.3e1
  t2109 = t1224 * t2108
  t2112 = t1231 * t2108
  t2115 = t1237 * t1238 * t2067
  t2140 = t7 * t2051 + t219 + 0.1e1
  t2141 = t1272 * t2140
  t2146 = f.my_piecewise3(t376, 0, 0.10e2 / 0.9e1 * t333 * t63 * (-(-t1213 - 0.11073577833333333333333333333333333333333333333333e-2 * t2103) * t353 + t1223 * (0.11807895435000000000000000000000000000000000000000e0 * t2109 - t1229 - 0.18590345266666666666666666666666666666666666666667e-1 * t2103 + 0.19099978575000000000000000000000000000000000000000e-1 * t2112 - t1236 - 0.10217331693333333333333333333333333333333333333333e-1 * t2115) * t1243 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * (-t1246 - 0.31311312500000000000000000000000000000000000000000e-3 * t2103) * t364 - 0.58482233974552040708313425006184496242808878304904e0 * t1252 * t1254 * (0.87449329500000000000000000000000000000000000000000e-1 * t2109 - t1256 - 0.10197214950000000000000000000000000000000000000000e-1 * t2103 + 0.55743564825000000000000000000000000000000000000000e-2 * t2112 - t1259 - 0.55919611800000000000000000000000000000000000000000e-2 * t2115) * t1263) * t372 - 0.10e2 / 0.27e2 * t333 * t369 * t2141)
  t2156 = f.my_piecewise3(t390, t2100, -t2100)
  t2167 = t1327 * t1328 * t1329 * t2067
  t2179 = t1343 * t2074 / 0.4e1 + t302 * (0.19820000000000000000000000000000000000000000000000e-1 * t2075 - t1347 - 0.41275000000000000000000000000000000000000000000000e-2 * t2069) / 0.2e1
  t2198 = t1358 + 0.37560000000000000000000000000000000000000000000000e-1 * t137 * t2067 - t1363 - 0.35130000000000000000000000000000000000000000000000e-2 * t152 * t1364 * t2067 + t1371 + 0.79250000000000000000000000000000000000000000000000e-3 * t159 * t1372 * t2067 - t1377 - 0.51120000000000000000000000000000000000000000000000e-3 * t163 * t1379 * t2051 + t1386 + 0.50413125000000000000000000000000000000000000000000e-5 * t168 * t1387 * t2067
  t2200 = -t1335 - 0.73596627000000000000000000000000000000000000000000e-2 * t137 * t1336 * t2051 - 0.14719325400000000000000000000000000000000000000000e-1 * t137 * t1342 * t2179 - t2100 * t442 - t331 * t2198
  t2204 = t405 * t406 * t2200 * t458 * t462
  t2210 = t1417 * t2074
  t2214 = t1422 * t2179
  t2220 = t1408 + 0.65704296666666666666666666666666666666666666666667e-3 * t1410 * t1411 * t1412 * t2051 + 0.14783466750000000000000000000000000000000000000000e-2 * t447 * t448 * t2210 - 0.98556445000000000000000000000000000000000000000000e-3 * t447 * t448 * t2214 - 0.4e1 * t331 * t2100
  t2223 = t1400 * t1404 * t1329 * t2220
  t2227 = t1400 * t1328 * t1439 * t2140
  t2230 = (t2100 * t402 - 0.193e0 * t1210 * (0.53972366148531951640759930915371329879101899827289e-1 * t2146 * s0 * t385 * t395 + t1295 + 0.17990788716177317213586643638457109959700633275763e-1 * t1297 * t1300 * t1301 * t2051 - 0.53972366148531951640759930915371329879101899827289e-1 * t1297 * t1298 * t1308 * t2156) * t1316 + t1323 + 0.16581944444444444444444444444444444444444444444445e-2 * t2167 + 0.24872916666666666666666666666666666666666666666667e-2 * t2204 - 0.24872916666666666666666666666666666666666666666667e-2 * t2223 + 0.16581944444444444444444444444444444444444444444445e-2 * t2227) * t498
  t2254 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t2072 + 0.2e1 * t2085 + 0.11696446794910408141662685001236899248561775660981e1 * t2089 - 0.11696446794910408141662685001236899248561775660981e1 * t2098) * t194 * t451 + 0.46434375000000000000000000000000000000000000000000e-2 * t470 * t2210 - 0.30956250000000000000000000000000000000000000000000e-2 * t470 * t2214 - t1463 - 0.26531111111111111111111111111111111111111111111111e-1 * t1464 * t1465 * t1466 * t2051 - 0.39796666666666666666666666666666666666666666666667e-1 * t133 * t473 * t406 * t2198) * t458 * s0 * t482
  t2258 = t1481 * t481 * t461 * t2220
  t2262 = t480 * t481 * t372 * t2140
  t2266 = t2200 * t458 * t486 * t494
  t2270 = t1498 * t492 * t493 * t2220
  t2274 = t487 * t492 * t371 * t2140
  t2277 = t1448 * (t2254 / 0.16e2 - t2258 / 0.16e2 + t2262 / 0.24e2 - t2266 / 0.256e3 + t2270 / 0.256e3 - t2274 / 0.192e3)
  t2298 = -t2072 + t2085 + t238 * (-(-t1516 - 0.53236443333333333333333333333333333333333333333333e-3 * t2069) * t509 + t1522 * (0.10973915025000000000000000000000000000000000000000e0 * t2075 - t1524 - 0.16057207750000000000000000000000000000000000000000e-1 * t2069 + 0.19622842125000000000000000000000000000000000000000e-1 * t2078 - t1527 - 0.32394225500000000000000000000000000000000000000000e-2 * t2081) * t1530 + t2072 - t2085 - 0.58482233974552040708313425006184496242808878304904e0 * t2088 + 0.58482233974552040708313425006184496242808878304904e0 * t1534 * t2095 * t1202) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t2088 - 0.58482233974552040708313425006184496242808878304904e0 * t1542 * t2097
  t2308 = f.my_piecewise3(t522, 0, 0.10e2 / 0.9e1 * t517 * t2100 * t38 * t372 - 0.10e2 / 0.27e2 * t517 * t518 * t2141)
  t2318 = f.my_piecewise3(t528, t2298, -t2298)
  t2351 = f.my_piecewise3(t226, 0, t2055)
  t2356 = t682 * t2055
  t2358 = t11 * t693 * t2356
  t2361 = (-t1627 - 0.11073577833333333333333333333333333333333333333333e-2 * t2358) * t578
  t2363 = -t1626 / 0.3e1 - t2358 / 0.3e1
  t2364 = t1637 * t2363
  t2367 = t1644 * t2363
  t2370 = t25 * t1650 * t2356
  t2374 = t1636 * (0.11807895435000000000000000000000000000000000000000e0 * t2364 - t1642 - 0.18590345266666666666666666666666666666666666666667e-1 * t2358 + 0.19099978575000000000000000000000000000000000000000e-1 * t2367 - t1649 - 0.51086658466666666666666666666666666666666666666667e-2 * t2370) * t1655
  t2377 = (-t1658 - 0.31311312500000000000000000000000000000000000000000e-3 * t2358) * t589
  t2378 = t42 * t2377
  t2384 = 0.87449329500000000000000000000000000000000000000000e-1 * t2364 - t1668 - 0.10197214950000000000000000000000000000000000000000e-1 * t2358 + 0.55743564825000000000000000000000000000000000000000e-2 * t2367 - t1671 - 0.27959805900000000000000000000000000000000000000000e-2 * t2370
  t2386 = t1666 * t2384 * t1675
  t2387 = t1664 * t2386
  t2389 = -t2361 + t2374 + 0.58482233974552040708313425006184496242808878304904e0 * t2378 - 0.58482233974552040708313425006184496242808878304904e0 * t2387
  t2392 = t1214 * t1687 * t2356
  t2397 = -t1685 / 0.3e1 - t2392 / 0.3e1
  t2398 = t1696 * t2397
  t2401 = t1703 * t2397
  t2404 = t1237 * t1709 * t2356
  t2429 = t7 * t2055 - t219 + 0.1e1
  t2430 = t1743 * t2429
  t2435 = f.my_piecewise3(t632, 0, 0.10e2 / 0.9e1 * t333 * t63 * (-(-t1686 - 0.11073577833333333333333333333333333333333333333333e-2 * t2392) * t609 + t1695 * (0.11807895435000000000000000000000000000000000000000e0 * t2398 - t1701 - 0.18590345266666666666666666666666666666666666666667e-1 * t2392 + 0.19099978575000000000000000000000000000000000000000e-1 * t2401 - t1708 - 0.10217331693333333333333333333333333333333333333333e-1 * t2404) * t1714 + 0.58482233974552040708313425006184496242808878304904e0 * t42 * (-t1717 - 0.31311312500000000000000000000000000000000000000000e-3 * t2392) * t620 - 0.58482233974552040708313425006184496242808878304904e0 * t1723 * t1725 * (0.87449329500000000000000000000000000000000000000000e-1 * t2398 - t1727 - 0.10197214950000000000000000000000000000000000000000e-1 * t2392 + 0.55743564825000000000000000000000000000000000000000e-2 * t2401 - t1730 - 0.55919611800000000000000000000000000000000000000000e-2 * t2404) * t1734) * t628 - 0.10e2 / 0.27e2 * t333 * t625 * t2430)
  t2442 = 0.1e1 / t638 / t636 / r1
  t2452 = f.my_piecewise3(t645, t2389, -t2389)
  t2463 = t1787 * t1788 * t1789 * t2356
  t2475 = t1803 * t2363 / 0.4e1 + t566 * (0.19820000000000000000000000000000000000000000000000e-1 * t2364 - t1807 - 0.41275000000000000000000000000000000000000000000000e-2 * t2358) / 0.2e1
  t2494 = t1818 + 0.37560000000000000000000000000000000000000000000000e-1 * t137 * t2356 - t1823 - 0.35130000000000000000000000000000000000000000000000e-2 * t152 * t1824 * t2356 + t1830 + 0.79250000000000000000000000000000000000000000000000e-3 * t159 * t1831 * t2356 - t1836 - 0.51120000000000000000000000000000000000000000000000e-3 * t163 * t1838 * t2055 + t1844 + 0.50413125000000000000000000000000000000000000000000e-5 * t168 * t1845 * t2356
  t2496 = -t1795 - 0.73596627000000000000000000000000000000000000000000e-2 * t137 * t1796 * t2055 - 0.14719325400000000000000000000000000000000000000000e-1 * t137 * t1802 * t2475 - t2389 * t689 - t593 * t2494
  t2500 = t405 * t659 * t2496 * t703 * t707
  t2506 = t1871 * t2363
  t2510 = t1876 * t2475
  t2516 = t1864 + 0.65704296666666666666666666666666666666666666666667e-3 * t1410 * t1865 * t1866 * t2055 + 0.14783466750000000000000000000000000000000000000000e-2 * t447 * t693 * t2506 - 0.98556445000000000000000000000000000000000000000000e-3 * t447 * t693 * t2510 - 0.4e1 * t593 * t2389
  t2519 = t1858 * t1862 * t1789 * t2516
  t2521 = s2 * t2442
  t2524 = t405 * t704 * t2521 * t706
  t2528 = t1858 * t1788 * t1888 * t2429
  t2531 = (t2389 * t657 - 0.193e0 * t1683 * (0.53972366148531951640759930915371329879101899827289e-1 * t2435 * s2 * t641 * t650 - 0.14392630972941853770869314910765687967760506620610e0 * t635 * t2442 * t19 * t650 + t1759 + 0.17990788716177317213586643638457109959700633275763e-1 * t1761 * t1763 * t1764 * t2055 - 0.53972366148531951640759930915371329879101899827289e-1 * t1761 * t1298 * t1771 * t2452) * t1779 + t1784 + 0.16581944444444444444444444444444444444444444444445e-2 * t2463 + 0.24872916666666666666666666666666666666666666666667e-2 * t2500 - 0.24872916666666666666666666666666666666666666666667e-2 * t2519 - 0.66327777777777777777777777777777777777777777777779e-2 * t2524 + 0.16581944444444444444444444444444444444444444444445e-2 * t2528) * t742
  t2555 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t2361 + 0.2e1 * t2374 + 0.11696446794910408141662685001236899248561775660981e1 * t2378 - 0.11696446794910408141662685001236899248561775660981e1 * t2387) * t194 * t696 + 0.46434375000000000000000000000000000000000000000000e-2 * t715 * t2506 - 0.30956250000000000000000000000000000000000000000000e-2 * t715 * t2510 - t1912 - 0.26531111111111111111111111111111111111111111111111e-1 * t1464 * t1913 * t1914 * t2055 - 0.39796666666666666666666666666666666666666666666667e-1 * t133 * t473 * t659 * t2494) * t703 * s2 * t726
  t2559 = t1929 * t725 * t706 * t2516
  t2563 = t724 * t2442 * t38 * t706
  t2567 = t724 * t725 * t628 * t2429
  t2571 = t2496 * t703 * t730 * t738
  t2575 = t1942 * t736 * t737 * t2516
  t2582 = t731 / t637 / t732 / t636 * t75 * t737
  t2586 = t731 * t736 * t627 * t2429
  t2589 = t1897 * (t2555 / 0.16e2 - t2559 / 0.16e2 - t2563 / 0.6e1 + t2567 / 0.24e2 - t2571 / 0.256e3 + t2575 / 0.256e3 + t2582 / 0.48e2 - t2586 / 0.192e3)
  t2610 = -t2361 + t2374 + t238 * (-(-t1953 - 0.53236443333333333333333333333333333333333333333333e-3 * t2358) * t753 + t1959 * (0.10973915025000000000000000000000000000000000000000e0 * t2364 - t1961 - 0.16057207750000000000000000000000000000000000000000e-1 * t2358 + 0.19622842125000000000000000000000000000000000000000e-1 * t2367 - t1964 - 0.32394225500000000000000000000000000000000000000000e-2 * t2370) * t1967 + t2361 - t2374 - 0.58482233974552040708313425006184496242808878304904e0 * t2377 + 0.58482233974552040708313425006184496242808878304904e0 * t1971 * t2384 * t1675) + 0.58482233974552040708313425006184496242808878304904e0 * t238 * t2377 - 0.58482233974552040708313425006184496242808878304904e0 * t1979 * t2386
  t2620 = f.my_piecewise3(t765, 0, 0.10e2 / 0.9e1 * t517 * t2389 * t38 * t628 - 0.10e2 / 0.27e2 * t517 * t761 * t2430)
  t2634 = f.my_piecewise3(t771, t2610, -t2610)
  vrho_1_ = t217 + t288 - t554 - t797 + t7 * (t995 - t1047 + (t2054 + t2058) * t41 * t287 + t1142 - t290 * t291 * t2062 * t551 / 0.16e2 - t290 * t293 * (t2230 - t2277 + t238 * ((t2298 * t540 - 0.193e0 * t1549 * (0.26986183074265975820379965457685664939550949913644e-1 * t75 * t2308 * t526 * t533 + t1570 + 0.89953943580886586067933218192285549798503166378813e-2 * t1572 * t1300 * t1573 * t2051 - 0.26986183074265975820379965457685664939550949913644e-1 * t527 * t1578 * t1581 * t2318) * t1589 + t1593 + 0.11607361111111111111111111111111111111111111111111e-2 * t2167 + 0.17411041666666666666666666666666666666666666666667e-2 * t2204 - 0.17411041666666666666666666666666666666666666666667e-2 * t2223 + 0.11607361111111111111111111111111111111111111111111e-2 * t2227) * t547 - t1603 * (0.93750000000000000000000000000000000000000000000000e-1 * t2254 - 0.93750000000000000000000000000000000000000000000000e-1 * t2258 + 0.62500000000000000000000000000000000000000000000000e-1 * t2262 - 0.10117187500000000000000000000000000000000000000000e-1 * t2266 + 0.10117187500000000000000000000000000000000000000000e-1 * t2270 - 0.13489583333333333333333333333333333333333333333333e-1 * t2274) - t2230 + t2277)) / 0.16e2 + s2 / t636 * t795 / 0.16e2 - t556 * t557 * t2351 * t794 / 0.16e2 - t556 * t559 * (t2531 - t2589 + t238 * ((t2610 * t783 - 0.193e0 * t1986 * (0.26986183074265975820379965457685664939550949913644e-1 * t75 * t2620 * t769 * t776 - 0.71963154864709268854346574553828439838802533103051e-1 * t768 * t2521 * t19 * t776 + t2003 + 0.89953943580886586067933218192285549798503166378813e-2 * t2005 * t1763 * t2006 * t2055 - 0.26986183074265975820379965457685664939550949913644e-1 * t770 * t1578 * t2013 * t2634) * t2021 + t2025 + 0.11607361111111111111111111111111111111111111111111e-2 * t2463 + 0.17411041666666666666666666666666666666666666666667e-2 * t2500 - 0.17411041666666666666666666666666666666666666666667e-2 * t2519 - 0.46429444444444444444444444444444444444444444444445e-2 * t2524 + 0.11607361111111111111111111111111111111111111111111e-2 * t2528) * t790 - t2034 * (0.93750000000000000000000000000000000000000000000000e-1 * t2555 - 0.93750000000000000000000000000000000000000000000000e-1 * t2559 - 0.25000000000000000000000000000000000000000000000000e0 * t2563 + 0.62500000000000000000000000000000000000000000000000e-1 * t2567 - 0.10117187500000000000000000000000000000000000000000e-1 * t2571 + 0.10117187500000000000000000000000000000000000000000e-1 * t2575 + 0.53958333333333333333333333333333333333333333333333e-1 * t2582 - 0.13489583333333333333333333333333333333333333333333e-1 * t2586) - t2531 + t2589)) / 0.16e2)
  t2672 = t843 * t107 * t112 * t116 * t121 * t919
  t2675 = t133 * t173 * t185
  t2678 = (-0.10416666666666666666666666666666666666666666666667e-1 * t2672 + 0.99491666666666666666666666666666666666666666666666e-2 * t2675) * t216
  t2679 = t204 * t162
  t2682 = t208 * t109 * t211
  t2685 = t998 * (t2679 / 0.8e1 - t2682 / 0.32e2)
  t2690 = t1093 * t263 * t112 * t116 * t270 * t1121
  t2700 = t231 * ((-0.10416666666666666666666666666666666666666666666667e-1 * t2690 + 0.69644166666666666666666666666666666666666666666666e-2 * t2675) * t285 - t1132 * (0.18750000000000000000000000000000000000000000000000e0 * t2679 - 0.80937500000000000000000000000000000000000000000000e-1 * t2682) - t2678 + t2685)
  t2716 = t405 * t445 * t458 * t384 * t461
  t2719 = (-0.10416666666666666666666666666666666666666666666667e-1 * t1210 * t378 * t384 * t19 * t1578 * t388 * t393 * t1316 + 0.24872916666666666666666666666666666666666666666667e-2 * t2716) * t498
  t2720 = t479 * t482
  t2722 = t1328 * t494
  t2725 = t1448 * (t2720 / 0.16e2 - t2722 / 0.128e3)
  vsigma_0_ = t7 * (t2678 - t2685 + t2700 - t289 * t291 * t292 * t551 / 0.16e2 - t290 * t293 * (t2719 - t2725 + t238 * ((-0.52083333333333333333333333333333333333333333333333e-2 * t1549 * t75 * t524 * t384 * t19 * t1578 * t388 * t531 * t1589 + 0.17411041666666666666666666666666666666666666666667e-2 * t2716) * t547 - t1603 * (0.93750000000000000000000000000000000000000000000000e-1 * t2720 - 0.20234375000000000000000000000000000000000000000000e-1 * t2722) - t2719 + t2725)) / 0.16e2)
  t2752 = (-0.20833333333333333333333333333333333333333333333334e-1 * t2672 + 0.19898333333333333333333333333333333333333333333333e-1 * t2675) * t216
  t2756 = t998 * (t2679 / 0.4e1 - t2682 / 0.16e2)
  vsigma_1_ = t7 * (t2752 - t2756 + t231 * ((-0.20833333333333333333333333333333333333333333333334e-1 * t2690 + 0.13928833333333333333333333333333333333333333333333e-1 * t2675) * t285 - t1132 * (0.37500000000000000000000000000000000000000000000000e0 * t2679 - 0.16187500000000000000000000000000000000000000000000e0 * t2682) - t2752 + t2756))
  t2783 = t405 * t692 * t703 * t640 * t706
  t2786 = (-0.10416666666666666666666666666666666666666666666667e-1 * t1683 * t634 * t640 * t19 * t1578 * t643 * t648 * t1779 + 0.24872916666666666666666666666666666666666666666667e-2 * t2783) * t742
  t2787 = t723 * t726
  t2789 = t1788 * t738
  t2792 = t1897 * (t2787 / 0.16e2 - t2789 / 0.128e3)
  vsigma_2_ = t7 * (t2678 - t2685 + t2700 - t555 * t557 * t558 * t794 / 0.16e2 - t556 * t559 * (t2786 - t2792 + t238 * ((-0.52083333333333333333333333333333333333333333333333e-2 * t1986 * t75 * t767 * t640 * t19 * t1578 * t643 * t774 * t2021 + 0.17411041666666666666666666666666666666666666666667e-2 * t2783) * t790 - t2034 * (0.93750000000000000000000000000000000000000000000000e-1 * t2787 - 0.20234375000000000000000000000000000000000000000000e-1 * t2789) - t2786 + t2792)) / 0.16e2)
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t2818 = tau0 ** 2
  vtau_0_ = t7 * s0 * t289 / t2818 * t292 * t551 / 0.16e2
  t2825 = tau1 ** 2
  vtau_1_ = t7 * s2 * t555 / t2825 * t558 * t794 / 0.16e2
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  kcisk_p = 0.193

  kcisk_gcnst = 20 / (3 * jnp.pi * (6 * jnp.pi ** 2) ** (1 / 3))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcisk_gamma0 = lambda rs: jnp.maximum(0, kcis_beta + 2 ** (1 / 3) * kcisk_gcnst * f_pw(2 ** (1 / 3) * rs, 0) / f.n_total(rs) ** (1 / 3))

  kcisk_gamma1 = lambda rs: jnp.maximum(0, kcis_beta + kcisk_gcnst * f_pw(rs, 0) / f.n_total(rs) ** (1 / 3))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcisk_p * jnp.log(1 + kcisk_gamma0(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 0)))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcisk_p * jnp.log(1 + 2 ** (-1 / 3) * kcisk_gamma1(rs) * kcis_t(rs, xt) ** 2 / (kcisk_p * jnp.abs(f_pw(rs, 1)))))

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t12 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t24 = t20 * t5 * t22
  t26 = 0.23615790870000000000000000000000000000000000000000e0 * t13 + 0.55771035800000000000000000000000000000000000000000e-1 * t10 + 0.12733319050000000000000000000000000000000000000000e-1 * t16 + 0.76629987700000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t33 = t32 * f.p.zeta_threshold
  t34 = f.my_piecewise3(t31, t33, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = (0.2e1 * t34 - 0.2e1) * t40
  t43 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489865900000000000000000000000000000000000000000e0 * t13 + 0.30591644850000000000000000000000000000000000000000e-1 * t10 + 0.37162376550000000000000000000000000000000000000000e-2 * t16 + 0.41939708850000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t52 = t43 * t51
  t53 = t41 * t52
  t55 = -t30 + 0.58482233974552040708313425006184496242808878304904e0 * t53
  t57 = 6 ** (0.1e1 / 0.3e1)
  t58 = t57 ** 2
  t59 = t37 * t2 * t58
  t60 = jnp.pi ** 2
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / t61
  t63 = t37 * t1
  t64 = t3 * t6
  t65 = t64 * t8
  t66 = t63 * t65
  t68 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t66
  t69 = jnp.sqrt(t66)
  t72 = t66 ** 0.15e1
  t74 = t37 ** 2
  t75 = t74 * t18
  t76 = t19 * t5
  t77 = t76 * t22
  t78 = t75 * t77
  t80 = 0.23615790870000000000000000000000000000000000000000e0 * t69 + 0.55771035800000000000000000000000000000000000000000e-1 * t66 + 0.12733319050000000000000000000000000000000000000000e-1 * t72 + 0.76629987700000000000000000000000000000000000000000e-2 * t78
  t82 = 0.1e1 + 0.1e1 / t80
  t83 = jnp.log(t82)
  t84 = t68 * t83
  t86 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t66
  t91 = 0.17489865900000000000000000000000000000000000000000e0 * t69 + 0.30591644850000000000000000000000000000000000000000e-1 * t66 + 0.37162376550000000000000000000000000000000000000000e-2 * t72 + 0.41939708850000000000000000000000000000000000000000e-2 * t78
  t93 = 0.1e1 + 0.1e1 / t91
  t94 = jnp.log(t93)
  t95 = t86 * t94
  t96 = t41 * t95
  t98 = -t84 + 0.58482233974552040708313425006184496242808878304904e0 * t96
  t99 = t62 * t98
  t102 = 0.10e2 / 0.9e1 * t59 * t99 * t8
  t103 = t102 < -0.66725e-1
  t105 = f.my_piecewise3(t103, 0, 0.66725e-1 + t102)
  t106 = t105 * t37
  t107 = r0 ** 2
  t109 = 0.1e1 / t7 / t107
  t110 = s0 * t109
  t111 = t106 * t110
  t112 = 0.1e1 / t3
  t113 = t18 * t112
  t114 = 0.0e0 < t55
  t116 = f.my_piecewise3(t114, t55, -t55)
  t118 = t5 / t116
  t119 = t113 * t118
  t122 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t111 * t119
  t123 = jnp.log(t122)
  t125 = 0.1e1 + 0.193e0 * t123
  t126 = 0.1e1 / t125
  t128 = 0.1e1 / t19
  t129 = t1 * t128
  t130 = t129 * t6
  t132 = 0.1e1 / t7 / r0
  t133 = 0.1e1 / r0
  t134 = t2 * t133
  t137 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t13 + 0.12382500000000000000000000000000000000000000000000e-1 * t10
  t140 = 0.1e1 + t13 * t137 / 0.2e1
  t141 = t140 ** 2
  t142 = 0.1e1 / t141
  t146 = t3 * t2
  t147 = t1 * t146
  t148 = t6 * t132
  t151 = t19 * t2
  t152 = t18 * t151
  t154 = 0.1e1 / t21 / r0
  t155 = t5 * t154
  t158 = 0.1e1 / t60
  t159 = 0.1e1 / t107
  t160 = t158 * t159
  t162 = t3 * t158
  t163 = t1 * t162
  t164 = t6 * t109
  t167 = -0.18780000000000000000000000000000000000000000000000e-1 * t134 + 0.13173750000000000000000000000000000000000000000000e-2 * t147 * t148 - 0.23775000000000000000000000000000000000000000000000e-3 * t152 * t155 + 0.63900000000000000000000000000000000000000000000000e-4 * t160 - 0.54014062500000000000000000000000000000000000000000e-6 * t163 * t164
  t169 = 0.36798313500000000000000000000000000000000000000000e-2 * t134 * t142 - t55 * t167
  t170 = t132 * t169
  t171 = 4 ** (0.1e1 / 0.6e1)
  t172 = t129 * t171
  t173 = t13 * t10
  t174 = t21 * t173
  t175 = 0.1e1 / t140
  t179 = t55 ** 2
  t181 = 0.19711289000000000000000000000000000000000000000000e-2 * t172 * t174 * t175 - 0.2e1 * t179
  t182 = 0.1e1 / t181
  t183 = t182 * s0
  t185 = t130 * t170 * t183
  t187 = t55 * t126 + 0.99491666666666666666666666666666666666666666666666e-2 * t185
  t190 = -0.2e1 * t30 + 0.11696446794910408141662685001236899248561775660981e1 * t53
  t191 = jnp.sqrt(0.4e1)
  t192 = t190 * t191
  t193 = t173 * t175
  t196 = t6 * t21
  t200 = 0.30956250000000000000000000000000000000000000000000e-2 * t192 * t193 - 0.79593333333333333333333333333333333333333333333333e-1 * t129 * t196 * t167
  t201 = t200 * t182
  t202 = s0 * t159
  t203 = t201 * t202
  t205 = t169 * t182
  t206 = s0 ** 2
  t207 = t107 ** 2
  t208 = 0.1e1 / t207
  t209 = t206 * t208
  t210 = t205 * t209
  t212 = 0.1e1 + t203 / 0.8e1 - t210 / 0.64e2
  t213 = 0.1e1 / t212
  t214 = t187 * t213
  t217 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t33, 0.2e1 * t37)
  t219 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t33, 0)
  t221 = (t217 + t219 - 0.2e1) * t40
  t223 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t10
  t228 = 0.21947830050000000000000000000000000000000000000000e0 * t13 + 0.48171623250000000000000000000000000000000000000000e-1 * t10 + 0.13081894750000000000000000000000000000000000000000e-1 * t16 + 0.48591338250000000000000000000000000000000000000000e-2 * t24
  t230 = 0.1e1 + 0.1e1 / t228
  t231 = jnp.log(t230)
  t238 = -t30 + t221 * (-t223 * t231 + t30 - 0.58482233974552040708313425006184496242808878304904e0 * t52) + 0.58482233974552040708313425006184496242808878304904e0 * t221 * t52
  t239 = t2 * t58
  t240 = t62 * t55
  t243 = 0.10e2 / 0.9e1 * t239 * t240 * t8
  t244 = t243 < -0.66725e-1
  t246 = f.my_piecewise3(t244, 0, 0.66725e-1 + t243)
  t247 = t246 * s0
  t249 = 0.0e0 < t238
  t251 = f.my_piecewise3(t249, t238, -t238)
  t253 = t5 / t251
  t254 = t113 * t253
  t257 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t247 * t109 * t254
  t258 = jnp.log(t257)
  t260 = 0.1e1 + 0.193e0 * t258
  t261 = 0.1e1 / t260
  t264 = t238 * t261 + 0.69644166666666666666666666666666666666666666666666e-2 * t185
  t267 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t203 - 0.40468750000000000000000000000000000000000000000000e-1 * t210
  t268 = 0.1e1 / t267
  t272 = s0 * t133
  t273 = 0.1e1 / tau0
  t274 = f.my_piecewise3(t31, f.p.zeta_threshold, 1)
  t275 = t273 * t274
  t277 = t74 * t2 * t58
  t278 = t74 * t1
  t279 = t278 * t65
  t281 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t279
  t282 = jnp.sqrt(t279)
  t285 = t279 ** 0.15e1
  t287 = t37 * t18
  t288 = t287 * t77
  t290 = 0.23615790870000000000000000000000000000000000000000e0 * t282 + 0.55771035800000000000000000000000000000000000000000e-1 * t279 + 0.12733319050000000000000000000000000000000000000000e-1 * t285 + 0.15325997540000000000000000000000000000000000000000e-1 * t288
  t292 = 0.1e1 + 0.1e1 / t290
  t293 = jnp.log(t292)
  t296 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t279
  t301 = 0.17489865900000000000000000000000000000000000000000e0 * t282 + 0.30591644850000000000000000000000000000000000000000e-1 * t279 + 0.37162376550000000000000000000000000000000000000000e-2 * t285 + 0.83879417700000000000000000000000000000000000000000e-2 * t288
  t303 = 0.1e1 + 0.1e1 / t301
  t304 = jnp.log(t303)
  t309 = t62 * (-t281 * t293 + 0.58482233974552040708313425006184496242808878304904e0 * t41 * t296 * t304)
  t312 = 0.10e2 / 0.9e1 * t277 * t309 * t8
  t313 = t312 < -0.66725e-1
  t315 = f.my_piecewise3(t313, 0, 0.66725e-1 + t312)
  t316 = t315 * s0
  t317 = t109 * t74
  t318 = t316 * t317
  t319 = 0.0e0 < t98
  t321 = f.my_piecewise3(t319, t98, -t98)
  t323 = t5 / t321
  t324 = t113 * t323
  t327 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t318 * t324
  t328 = jnp.log(t327)
  t330 = 0.1e1 + 0.193e0 * t328
  t331 = 0.1e1 / t330
  t334 = t63 * t128 * t6
  t337 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t69 + 0.12382500000000000000000000000000000000000000000000e-1 * t66
  t340 = 0.1e1 + t69 * t337 / 0.2e1
  t341 = t340 ** 2
  t342 = 0.1e1 / t341
  t346 = t146 * t6
  t350 = t151 * t5
  t355 = t162 * t6
  t359 = -0.37560000000000000000000000000000000000000000000000e-1 * t134 + 0.26347500000000000000000000000000000000000000000000e-2 * t63 * t346 * t132 - 0.47550000000000000000000000000000000000000000000000e-3 * t75 * t350 * t154 + 0.25560000000000000000000000000000000000000000000000e-3 * t160 - 0.21605625000000000000000000000000000000000000000000e-5 * t63 * t355 * t109
  t361 = 0.73596627000000000000000000000000000000000000000000e-2 * t134 * t342 - t98 * t359
  t362 = t132 * t361
  t363 = t63 * t128
  t365 = t69 * t66
  t366 = 0.1e1 / t340
  t367 = t365 * t366
  t371 = t98 ** 2
  t373 = 0.98556445000000000000000000000000000000000000000000e-3 * t363 * t171 * t21 * t367 - 0.2e1 * t371
  t374 = 0.1e1 / t373
  t375 = t374 * s0
  t377 = t334 * t362 * t375
  t379 = t98 * t331 + 0.49745833333333333333333333333333333333333333333334e-2 * t377
  t382 = -0.2e1 * t84 + 0.11696446794910408141662685001236899248561775660981e1 * t96
  t383 = t382 * t191
  t389 = 0.30956250000000000000000000000000000000000000000000e-2 * t383 * t367 - 0.39796666666666666666666666666666666666666666666667e-1 * t363 * t196 * t359
  t390 = t389 * t374
  t391 = t390 * t202
  t393 = t361 * t374
  t394 = t393 * t209
  t396 = 0.1e1 + t391 / 0.8e1 - t394 / 0.64e2
  t397 = 0.1e1 / t396
  t398 = t379 * t397
  t400 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t66
  t405 = 0.21947830050000000000000000000000000000000000000000e0 * t69 + 0.48171623250000000000000000000000000000000000000000e-1 * t66 + 0.13081894750000000000000000000000000000000000000000e-1 * t72 + 0.48591338250000000000000000000000000000000000000000e-2 * t78
  t407 = 0.1e1 + 0.1e1 / t405
  t408 = jnp.log(t407)
  t415 = -t84 + t221 * (-t400 * t408 + t84 - 0.58482233974552040708313425006184496242808878304904e0 * t95) + 0.58482233974552040708313425006184496242808878304904e0 * t221 * t95
  t416 = 0.0e0 < t415
  t418 = f.my_piecewise3(t416, t415, -t415)
  t420 = t5 / t418
  t421 = t113 * t420
  t424 = 0.1e1 + 0.53972366148531951640759930915371329879101899827289e-1 * t111 * t421
  t425 = jnp.log(t424)
  t427 = 0.1e1 + 0.193e0 * t425
  t428 = 0.1e1 / t427
  t431 = t415 * t428 + 0.34822083333333333333333333333333333333333333333334e-2 * t377
  t434 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t391 - 0.40468750000000000000000000000000000000000000000000e-1 * t394
  t435 = 0.1e1 / t434
  t439 = t398 + t221 * (t431 * t435 - t398)
  t440 = t275 * t439
  t444 = t4 * t148 * t29
  t445 = 0.11073577833333333333333333333333333333333333333333e-2 * t444
  t446 = t26 ** 2
  t449 = 0.1e1 / t13
  t451 = t64 * t132
  t452 = t449 * t1 * t451
  t454 = t4 * t148
  t456 = t10 ** 0.5e0
  t458 = t456 * t1 * t451
  t460 = t20 * t155
  t465 = t12 / t446 * (-0.39359651450000000000000000000000000000000000000000e-1 * t452 - 0.18590345266666666666666666666666666666666666666667e-1 * t454 - 0.63666595250000000000000000000000000000000000000000e-2 * t458 - 0.51086658466666666666666666666666666666666666666667e-2 * t460) / t28
  t468 = t64 * t132 * t51
  t469 = t41 * t1 * t468
  t472 = t48 ** 2
  t473 = 0.1e1 / t472
  t478 = -0.29149776500000000000000000000000000000000000000000e-1 * t452 - 0.10197214950000000000000000000000000000000000000000e-1 * t454 - 0.18581188275000000000000000000000000000000000000000e-2 * t458 - 0.27959805900000000000000000000000000000000000000000e-2 * t460
  t480 = 0.1e1 / t50
  t481 = t473 * t478 * t480
  t482 = t41 * t43 * t481
  t484 = t445 + t465 - 0.18311555036753159941307229983139571945136646663793e-3 * t469 - 0.58482233974552040708313425006184496242808878304904e0 * t482
  t486 = t125 ** 2
  t488 = t55 / t486
  t489 = t63 * t3
  t491 = t489 * t148 * t83
  t492 = 0.11073577833333333333333333333333333333333333333333e-2 * t491
  t493 = t80 ** 2
  t496 = 0.1e1 / t69
  t499 = t496 * t37 * t1 * t451
  t501 = t63 * t451
  t503 = t66 ** 0.5e0
  t506 = t503 * t37 * t1 * t451
  t508 = t76 * t154
  t509 = t75 * t508
  t514 = t68 / t493 * (-0.39359651450000000000000000000000000000000000000000e-1 * t499 - 0.18590345266666666666666666666666666666666666666667e-1 * t501 - 0.63666595250000000000000000000000000000000000000000e-2 * t506 - 0.51086658466666666666666666666666666666666666666667e-2 * t509) / t82
  t517 = t64 * t132 * t94
  t518 = t41 * t63 * t517
  t521 = t91 ** 2
  t522 = 0.1e1 / t521
  t527 = -0.29149776500000000000000000000000000000000000000000e-1 * t499 - 0.10197214950000000000000000000000000000000000000000e-1 * t501 - 0.18581188275000000000000000000000000000000000000000e-2 * t506 - 0.27959805900000000000000000000000000000000000000000e-2 * t509
  t529 = 0.1e1 / t93
  t530 = t522 * t527 * t529
  t531 = t41 * t86 * t530
  t533 = t492 + t514 - 0.18311555036753159941307229983139571945136646663793e-3 * t518 - 0.58482233974552040708313425006184496242808878304904e0 * t531
  t542 = f.my_piecewise3(t103, 0, 0.10e2 / 0.9e1 * t59 * t62 * t533 * t8 - 0.10e2 / 0.27e2 * t59 * t99 * t132)
  t544 = t542 * t37 * t110
  t547 = t107 * r0
  t549 = 0.1e1 / t7 / t547
  t551 = t106 * s0 * t549
  t554 = t116 ** 2
  t558 = f.my_piecewise3(t114, t484, -t484)
  t564 = 0.1e1 / t122
  t570 = t130 * t109 * t169 * t183
  t572 = t2 * t159
  t586 = -t449 * t137 * t1 * t451 / 0.12e2 + t13 * (-0.66066666666666666666666666666666666666666666666667e-2 * t452 - 0.41275000000000000000000000000000000000000000000000e-2 * t454) / 0.2e1
  t595 = 0.1e1 / t21 / t107
  t599 = 0.1e1 / t547
  t600 = t158 * t599
  t605 = 0.18780000000000000000000000000000000000000000000000e-1 * t572 - 0.17565000000000000000000000000000000000000000000000e-2 * t147 * t164 + 0.39625000000000000000000000000000000000000000000000e-3 * t152 * t5 * t595 - 0.12780000000000000000000000000000000000000000000000e-3 * t600 + 0.12603281250000000000000000000000000000000000000000e-5 * t163 * t6 * t549
  t607 = -0.36798313500000000000000000000000000000000000000000e-2 * t572 * t142 - 0.73596627000000000000000000000000000000000000000000e-2 * t134 / t141 / t140 * t586 - t484 * t167 - t55 * t605
  t610 = t130 * t132 * t607 * t183
  t613 = t181 ** 2
  t614 = 0.1e1 / t613
  t615 = t169 * t614
  t620 = t171 ** 2
  t621 = t620 ** 2
  t622 = t621 * t171
  t634 = 0.13140859333333333333333333333333333333333333333333e-2 * t172 * t8 * t173 * t175 - 0.98556445000000000000000000000000000000000000000000e-3 * t113 * t622 * t22 * t13 * t175 - 0.19711289000000000000000000000000000000000000000000e-2 * t172 * t174 * t142 * t586 - 0.4e1 * t55 * t484
  t637 = t129 * t148 * t615 * s0 * t634
  t640 = (t484 * t126 - 0.193e0 * t488 * (0.53972366148531951640759930915371329879101899827289e-1 * t544 * t119 - 0.12593552101324122049510650546919976971790443293034e0 * t551 * t119 - 0.53972366148531951640759930915371329879101899827289e-1 * t111 * t113 * t5 / t554 * t558) * t564 - 0.13265555555555555555555555555555555555555555555555e-1 * t570 + 0.99491666666666666666666666666666666666666666666666e-2 * t610 - 0.99491666666666666666666666666666666666666666666666e-2 * t637) * t213
  t641 = t212 ** 2
  t643 = t187 / t641
  t655 = t3 * t132
  t671 = (0.30956250000000000000000000000000000000000000000000e-2 * (0.22147155666666666666666666666666666666666666666666e-2 * t444 + 0.2e1 * t465 - 0.36623110073506319882614459966279143890273293327587e-3 * t469 - 0.11696446794910408141662685001236899248561775660981e1 * t482) * t191 * t193 - 0.61912500000000000000000000000000000000000000000000e-2 * t190 * t171 * t13 * t175 * t1 * t655 - 0.30956250000000000000000000000000000000000000000000e-2 * t192 * t173 * t142 * t586 - 0.53062222222222222222222222222222222222222222222222e-1 * t129 * t9 * t167 - 0.79593333333333333333333333333333333333333333333333e-1 * t129 * t196 * t605) * t182 * t202
  t675 = t200 * t614 * t202 * t634
  t677 = s0 * t599
  t678 = t201 * t677
  t681 = t607 * t182 * t209
  t684 = t615 * t209 * t634
  t688 = t206 / t207 / r0
  t689 = t205 * t688
  t692 = t643 * (t671 / 0.8e1 - t675 / 0.8e1 - t678 / 0.4e1 - t681 / 0.64e2 + t684 / 0.64e2 + t689 / 0.16e2)
  t696 = t228 ** 2
  t722 = t445 + t465 + t221 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t148 * t231 + t223 / t696 * (-0.36579716750000000000000000000000000000000000000000e-1 * t452 - 0.16057207750000000000000000000000000000000000000000e-1 * t454 - 0.65409473750000000000000000000000000000000000000000e-2 * t458 - 0.32394225500000000000000000000000000000000000000000e-2 * t460) / t230 - t445 - t465 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t148 * t51 + 0.58482233974552040708313425006184496242808878304904e0 * t43 * t473 * t478 * t480) - 0.18311555036753159941307229983139571945136646663793e-3 * t221 * t1 * t468 - 0.58482233974552040708313425006184496242808878304904e0 * t221 * t43 * t481
  t724 = t260 ** 2
  t726 = t238 / t724
  t735 = f.my_piecewise3(t244, 0, 0.10e2 / 0.9e1 * t239 * t62 * t484 * t8 - 0.10e2 / 0.27e2 * t239 * t240 * t132)
  t746 = t251 ** 2
  t749 = f.my_piecewise3(t249, t722, -t722)
  t755 = 0.1e1 / t257
  t764 = t267 ** 2
  t766 = t264 / t764
  t780 = t330 ** 2
  t782 = t98 / t780
  t787 = t290 ** 2
  t793 = 0.1e1 / t282 * t74 * t1 * t451
  t795 = t278 * t451
  t797 = t279 ** 0.5e0
  t800 = t797 * t74 * t1 * t451
  t802 = t287 * t508
  t814 = t301 ** 2
  t835 = f.my_piecewise3(t313, 0, 0.10e2 / 0.9e1 * t277 * t62 * (0.11073577833333333333333333333333333333333333333333e-2 * t278 * t3 * t148 * t293 + t281 / t787 * (-0.39359651450000000000000000000000000000000000000000e-1 * t793 - 0.18590345266666666666666666666666666666666666666667e-1 * t795 - 0.63666595250000000000000000000000000000000000000000e-2 * t800 - 0.10217331693333333333333333333333333333333333333333e-1 * t802) / t292 - 0.18311555036753159941307229983139571945136646663793e-3 * t41 * t278 * t64 * t132 * t304 - 0.58482233974552040708313425006184496242808878304904e0 * t41 * t296 / t814 * (-0.29149776500000000000000000000000000000000000000000e-1 * t793 - 0.10197214950000000000000000000000000000000000000000e-1 * t795 - 0.18581188275000000000000000000000000000000000000000e-2 * t800 - 0.55919611800000000000000000000000000000000000000000e-2 * t802) / t303) * t8 - 0.10e2 / 0.27e2 * t277 * t309 * t132)
  t844 = t321 ** 2
  t848 = f.my_piecewise3(t319, t533, -t533)
  t854 = 0.1e1 / t327
  t860 = t334 * t109 * t361 * t375
  t875 = -t496 * t337 * t37 * t454 / 0.12e2 + t69 * (-0.66066666666666666666666666666666666666666666666667e-2 * t499 - 0.41275000000000000000000000000000000000000000000000e-2 * t501) / 0.2e1
  t891 = 0.37560000000000000000000000000000000000000000000000e-1 * t572 - 0.35130000000000000000000000000000000000000000000000e-2 * t63 * t346 * t109 + 0.79250000000000000000000000000000000000000000000000e-3 * t75 * t350 * t595 - 0.51120000000000000000000000000000000000000000000000e-3 * t600 + 0.50413125000000000000000000000000000000000000000000e-5 * t63 * t355 * t549
  t893 = -0.73596627000000000000000000000000000000000000000000e-2 * t572 * t342 - 0.14719325400000000000000000000000000000000000000000e-1 * t134 / t341 / t340 * t875 - t533 * t359 - t98 * t891
  t896 = t334 * t132 * t893 * t375
  t898 = t373 ** 2
  t899 = 0.1e1 / t898
  t907 = t69 * t366
  t920 = 0.65704296666666666666666666666666666666666666666667e-3 * t363 * t171 * t8 * t367 - 0.49278222500000000000000000000000000000000000000000e-3 * t75 * t112 * t622 * t22 * t907 - 0.98556445000000000000000000000000000000000000000000e-3 * t63 * t128 * t171 * t21 * t365 * t342 * t875 - 0.4e1 * t98 * t533
  t923 = t334 * t362 * t899 * s0 * t920
  t926 = (t533 * t331 - 0.193e0 * t782 * (0.53972366148531951640759930915371329879101899827289e-1 * t835 * s0 * t317 * t324 - 0.12593552101324122049510650546919976971790443293034e0 * t316 * t549 * t74 * t324 - 0.53972366148531951640759930915371329879101899827289e-1 * t318 * t113 * t5 / t844 * t848) * t854 - 0.66327777777777777777777777777777777777777777777779e-2 * t860 + 0.49745833333333333333333333333333333333333333333334e-2 * t896 - 0.49745833333333333333333333333333333333333333333334e-2 * t923) * t397
  t927 = t396 ** 2
  t929 = t379 / t927
  t955 = (0.30956250000000000000000000000000000000000000000000e-2 * (0.22147155666666666666666666666666666666666666666666e-2 * t491 + 0.2e1 * t514 - 0.36623110073506319882614459966279143890273293327587e-3 * t518 - 0.11696446794910408141662685001236899248561775660981e1 * t531) * t191 * t367 - 0.61912500000000000000000000000000000000000000000000e-2 * t382 * t171 * t907 * t63 * t655 - 0.30956250000000000000000000000000000000000000000000e-2 * t383 * t365 * t342 * t875 - 0.26531111111111111111111111111111111111111111111111e-1 * t363 * t9 * t359 - 0.39796666666666666666666666666666666666666666666667e-1 * t363 * t196 * t891) * t374 * t202
  t959 = t389 * t899 * t202 * t920
  t961 = t390 * t677
  t964 = t893 * t374 * t209
  t968 = t361 * t899 * t209 * t920
  t970 = t393 * t688
  t973 = t929 * (t955 / 0.8e1 - t959 / 0.8e1 - t961 / 0.4e1 - t964 / 0.64e2 + t968 / 0.64e2 + t970 / 0.16e2)
  t977 = t405 ** 2
  t1003 = t492 + t514 + t221 * (0.53236443333333333333333333333333333333333333333333e-3 * t489 * t148 * t408 + t400 / t977 * (-0.36579716750000000000000000000000000000000000000000e-1 * t499 - 0.16057207750000000000000000000000000000000000000000e-1 * t501 - 0.65409473750000000000000000000000000000000000000000e-2 * t506 - 0.32394225500000000000000000000000000000000000000000e-2 * t509) / t407 - t492 - t514 + 0.18311555036753159941307229983139571945136646663793e-3 * t489 * t148 * t94 + 0.58482233974552040708313425006184496242808878304904e0 * t86 * t522 * t527 * t529) - 0.18311555036753159941307229983139571945136646663793e-3 * t221 * t63 * t517 - 0.58482233974552040708313425006184496242808878304904e0 * t221 * t86 * t530
  t1005 = t427 ** 2
  t1007 = t415 / t1005
  t1012 = t418 ** 2
  t1016 = f.my_piecewise3(t416, t1003, -t1003)
  t1022 = 0.1e1 / t424
  t1031 = t434 ** 2
  t1033 = t431 / t1031
  vrho_0_ = t214 + t41 * (t264 * t268 - t214) - t272 * t440 / 0.8e1 + r0 * (t640 - t692 + t41 * ((t722 * t261 - 0.193e0 * t726 * (0.53972366148531951640759930915371329879101899827289e-1 * t735 * s0 * t109 * t254 - 0.12593552101324122049510650546919976971790443293034e0 * t247 * t549 * t254 - 0.53972366148531951640759930915371329879101899827289e-1 * t247 * t109 * t18 * t112 * t5 / t746 * t749) * t755 - 0.92858888888888888888888888888888888888888888888888e-2 * t570 + 0.69644166666666666666666666666666666666666666666666e-2 * t610 - 0.69644166666666666666666666666666666666666666666666e-2 * t637) * t268 - t766 * (0.18750000000000000000000000000000000000000000000000e0 * t671 - 0.18750000000000000000000000000000000000000000000000e0 * t675 - 0.37500000000000000000000000000000000000000000000000e0 * t678 - 0.40468750000000000000000000000000000000000000000000e-1 * t681 + 0.40468750000000000000000000000000000000000000000000e-1 * t684 + 0.16187500000000000000000000000000000000000000000000e0 * t689) - t640 + t692) + t202 * t440 / 0.8e1 - t272 * t275 * (t926 - t973 + t221 * ((t1003 * t428 - 0.193e0 * t1007 * (0.53972366148531951640759930915371329879101899827289e-1 * t544 * t421 - 0.12593552101324122049510650546919976971790443293034e0 * t551 * t421 - 0.53972366148531951640759930915371329879101899827289e-1 * t111 * t113 * t5 / t1012 * t1016) * t1022 - 0.46429444444444444444444444444444444444444444444445e-2 * t860 + 0.34822083333333333333333333333333333333333333333334e-2 * t896 - 0.34822083333333333333333333333333333333333333333334e-2 * t923) * t435 - t1033 * (0.18750000000000000000000000000000000000000000000000e0 * t955 - 0.18750000000000000000000000000000000000000000000000e0 * t959 - 0.37500000000000000000000000000000000000000000000000e0 * t961 - 0.40468750000000000000000000000000000000000000000000e-1 * t964 + 0.40468750000000000000000000000000000000000000000000e-1 * t968 + 0.16187500000000000000000000000000000000000000000000e0 * t970) - t926 + t973)) / 0.8e1)
  t1050 = t106 * t109
  t1057 = t130 * t170 * t182
  t1060 = (-0.10416666666666666666666666666666666666666666666667e-1 * t488 * t1050 * t113 * t118 * t564 + 0.99491666666666666666666666666666666666666666666666e-2 * t1057) * t213
  t1061 = t201 * t159
  t1063 = s0 * t208
  t1064 = t205 * t1063
  t1067 = t643 * (t1061 / 0.8e1 - t1064 / 0.32e2)
  t1084 = t274 * t439
  t1095 = t363 * t148 * t393
  t1098 = (-0.10416666666666666666666666666666666666666666666667e-1 * t782 * t315 * t109 * t74 * t113 * t323 * t854 + 0.49745833333333333333333333333333333333333333333334e-2 * t1095) * t397
  t1099 = t390 * t159
  t1101 = t393 * t1063
  t1104 = t929 * (t1099 / 0.8e1 - t1101 / 0.32e2)
  vsigma_0_ = r0 * (t1060 - t1067 + t41 * ((-0.10416666666666666666666666666666666666666666666667e-1 * t726 * t246 * t109 * t113 * t253 * t755 + 0.69644166666666666666666666666666666666666666666666e-2 * t1057) * t268 - t766 * (0.18750000000000000000000000000000000000000000000000e0 * t1061 - 0.80937500000000000000000000000000000000000000000000e-1 * t1064) - t1060 + t1067) - t133 * t273 * t1084 / 0.8e1 - t272 * t275 * (t1098 - t1104 + t221 * ((-0.10416666666666666666666666666666666666666666666667e-1 * t1007 * t1050 * t113 * t420 * t1022 + 0.34822083333333333333333333333333333333333333333334e-2 * t1095) * t435 - t1033 * (0.18750000000000000000000000000000000000000000000000e0 * t1099 - 0.80937500000000000000000000000000000000000000000000e-1 * t1101) - t1098 + t1104)) / 0.8e1)
  vlapl_0_ = 0.0e0
  t1124 = tau0 ** 2
  vtau_0_ = s0 / t1124 * t1084 / 0.8e1
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def _energy_unpol_sum(p, r, s=None, l=None, tau=None):
  val = unpol(p, r, s, l, tau)
  import jax.numpy as jnp
  return jnp.sum(val)

def unpol_fxc(p, r, s=None, l=None, tau=None):
  import jax
  v2rho2 = jax.jacfwd(jax.grad(_energy_unpol_sum, argnums=1), argnums=1)(p, r, s, l, tau)
  return {'v2rho2': v2rho2}

def unpol_kxc(p, r, s=None, l=None, tau=None):
  import jax
  d1 = jax.grad(_energy_unpol_sum, argnums=1)
  d2 = jax.jacfwd(d1, argnums=1)
  d3 = jax.jacfwd(lambda pp, rr, ss, ll=None, tt=None: d2(pp, rr, ss, ll, tt), argnums=1)
  v3rho3 = d3(p, r, s, l, tau)
  return {'v3rho3': v3rho3}

def unpol_lxc(p, r, s=None, l=None, tau=None):
  import jax
  d1 = jax.grad(_energy_unpol_sum, argnums=1)
  d2 = jax.jacfwd(d1, argnums=1)
  d3 = jax.jacfwd(lambda pp, rr, ss=None, ll=None, tt=None: d2(pp, rr, ss, ll, tt), argnums=1)
  d4 = jax.jacfwd(lambda pp, rr, ss=None, ll=None, tt=None: d3(pp, rr, ss, ll, tt), argnums=1)
  v4rho4 = d4(p, r, s, l, tau)
  return {'v4rho4': v4rho4}
