"""Generated from mgga_x_m11.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import scipy.special as sp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  m11_f = lambda rs, z, x, u, t: attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3)) * m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, m11_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  m11_f = lambda rs, z, x, u, t: attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3)) * m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, m11_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  m11_f = lambda rs, z, x, u, t: attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3)) * m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, m11_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = 9 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = t29 * t32 * f.p.cam_omega
  t36 = t2 / t27
  t38 = 0.1e1 + t17 <= f.p.zeta_threshold
  t40 = 0.1e1 - t17 <= f.p.zeta_threshold
  t41 = f.my_piecewise5(t38, t11, t40, t15, t17)
  t42 = 0.1e1 + t41
  t43 = t42 <= f.p.zeta_threshold
  t44 = t42 ** (0.1e1 / 0.3e1)
  t45 = f.my_piecewise3(t43, t21, t44)
  t46 = 0.1e1 / t45
  t49 = t34 * t36 * t46 / 0.18e2
  t50 = 0.135e1 <= t49
  t51 = 0.135e1 < t49
  t52 = f.my_piecewise3(t51, t49, 0.135e1)
  t53 = t52 ** 2
  t56 = t53 ** 2
  t59 = t56 * t53
  t62 = t56 ** 2
  t74 = t62 ** 2
  t78 = f.my_piecewise3(t51, 0.135e1, t49)
  t79 = jnp.sqrt(jnp.pi)
  t80 = 0.1e1 / t78
  t82 = jax.lax.erf(t80 / 0.2e1)
  t84 = t78 ** 2
  t85 = 0.1e1 / t84
  t87 = jnp.exp(-t85 / 0.4e1)
  t88 = t87 - 0.1e1
  t91 = t87 - 0.3e1 / 0.2e1 - 0.2e1 * t84 * t88
  t94 = 0.2e1 * t78 * t91 + t79 * t82
  t98 = f.my_piecewise3(t50, 0.1e1 / t53 / 0.36e2 - 0.1e1 / t56 / 0.960e3 + 0.1e1 / t59 / 0.26880e5 - 0.1e1 / t62 / 0.829440e6 + 0.1e1 / t62 / t53 / 0.28385280e8 - 0.1e1 / t62 / t56 / 0.1073479680e10 + 0.1e1 / t62 / t59 / 0.44590694400e11 - 0.1e1 / t74 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t78 * t94)
  t99 = t27 * t98
  t100 = 6 ** (0.1e1 / 0.3e1)
  t101 = jnp.pi ** 2
  t102 = t101 ** (0.1e1 / 0.3e1)
  t103 = t102 ** 2
  t104 = 0.1e1 / t103
  t105 = t100 * t104
  t106 = r0 ** 2
  t107 = r0 ** (0.1e1 / 0.3e1)
  t108 = t107 ** 2
  t110 = 0.1e1 / t108 / t106
  t112 = t105 * s0 * t110
  t114 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t112
  t117 = 0.18040e1 - 0.64641600e0 / t114
  t118 = params.a[0]
  t119 = params.a[1]
  t120 = t100 ** 2
  t122 = 0.3e1 / 0.10e2 * t120 * t103
  t124 = 0.1e1 / t108 / r0
  t125 = tau0 * t124
  t126 = t122 - t125
  t127 = t119 * t126
  t128 = t122 + t125
  t129 = 0.1e1 / t128
  t131 = params.a[2]
  t132 = t126 ** 2
  t133 = t131 * t132
  t134 = t128 ** 2
  t135 = 0.1e1 / t134
  t137 = params.a[3]
  t138 = t132 * t126
  t139 = t137 * t138
  t140 = t134 * t128
  t141 = 0.1e1 / t140
  t143 = params.a[4]
  t144 = t132 ** 2
  t145 = t143 * t144
  t146 = t134 ** 2
  t147 = 0.1e1 / t146
  t149 = params.a[5]
  t150 = t144 * t126
  t151 = t149 * t150
  t153 = 0.1e1 / t146 / t128
  t155 = params.a[6]
  t156 = t144 * t132
  t157 = t155 * t156
  t159 = 0.1e1 / t146 / t134
  t161 = params.a[7]
  t162 = t144 * t138
  t163 = t161 * t162
  t165 = 0.1e1 / t146 / t140
  t167 = params.a[8]
  t168 = t144 ** 2
  t169 = t167 * t168
  t170 = t146 ** 2
  t171 = 0.1e1 / t170
  t173 = params.a[9]
  t174 = t168 * t126
  t175 = t173 * t174
  t177 = 0.1e1 / t170 / t128
  t179 = params.a[10]
  t180 = t168 * t132
  t181 = t179 * t180
  t183 = 0.1e1 / t170 / t134
  t185 = params.a[11]
  t186 = t168 * t138
  t187 = t185 * t186
  t189 = 0.1e1 / t170 / t140
  t191 = t127 * t129 + t133 * t135 + t139 * t141 + t145 * t147 + t151 * t153 + t157 * t159 + t163 * t165 + t169 * t171 + t175 * t177 + t181 * t183 + t187 * t189 + t118
  t194 = jnp.exp(-0.93189002206715572255024750998986103655990934573863e-2 * t112)
  t196 = 0.1552e1 - 0.552e0 * t194
  t197 = params.b[0]
  t198 = params.b[1]
  t199 = t198 * t126
  t201 = params.b[2]
  t202 = t201 * t132
  t204 = params.b[3]
  t205 = t204 * t138
  t207 = params.b[4]
  t208 = t207 * t144
  t210 = params.b[5]
  t211 = t210 * t150
  t213 = params.b[6]
  t214 = t213 * t156
  t216 = params.b[7]
  t217 = t216 * t162
  t219 = params.b[8]
  t220 = t219 * t168
  t222 = params.b[9]
  t223 = t222 * t174
  t225 = params.b[10]
  t226 = t225 * t180
  t228 = params.b[11]
  t229 = t228 * t186
  t231 = t199 * t129 + t202 * t135 + t205 * t141 + t208 * t147 + t211 * t153 + t214 * t159 + t217 * t165 + t220 * t171 + t223 * t177 + t226 * t183 + t229 * t189 + t197
  t233 = t117 * t191 + t196 * t231
  t234 = t99 * t233
  t237 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t234)
  t238 = r1 <= f.p.dens_threshold
  t239 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t240 = 0.1e1 + t239
  t241 = t240 <= f.p.zeta_threshold
  t242 = t240 ** (0.1e1 / 0.3e1)
  t244 = f.my_piecewise3(t241, t22, t242 * t240)
  t245 = t5 * t244
  t246 = f.my_piecewise5(t40, t11, t38, t15, -t17)
  t247 = 0.1e1 + t246
  t248 = t247 <= f.p.zeta_threshold
  t249 = t247 ** (0.1e1 / 0.3e1)
  t250 = f.my_piecewise3(t248, t21, t249)
  t251 = 0.1e1 / t250
  t254 = t34 * t36 * t251 / 0.18e2
  t255 = 0.135e1 <= t254
  t256 = 0.135e1 < t254
  t257 = f.my_piecewise3(t256, t254, 0.135e1)
  t258 = t257 ** 2
  t261 = t258 ** 2
  t264 = t261 * t258
  t267 = t261 ** 2
  t279 = t267 ** 2
  t283 = f.my_piecewise3(t256, 0.135e1, t254)
  t284 = 0.1e1 / t283
  t286 = jax.lax.erf(t284 / 0.2e1)
  t288 = t283 ** 2
  t289 = 0.1e1 / t288
  t291 = jnp.exp(-t289 / 0.4e1)
  t292 = t291 - 0.1e1
  t295 = t291 - 0.3e1 / 0.2e1 - 0.2e1 * t288 * t292
  t298 = 0.2e1 * t283 * t295 + t79 * t286
  t302 = f.my_piecewise3(t255, 0.1e1 / t258 / 0.36e2 - 0.1e1 / t261 / 0.960e3 + 0.1e1 / t264 / 0.26880e5 - 0.1e1 / t267 / 0.829440e6 + 0.1e1 / t267 / t258 / 0.28385280e8 - 0.1e1 / t267 / t261 / 0.1073479680e10 + 0.1e1 / t267 / t264 / 0.44590694400e11 - 0.1e1 / t279 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t283 * t298)
  t303 = t27 * t302
  t304 = r1 ** 2
  t305 = r1 ** (0.1e1 / 0.3e1)
  t306 = t305 ** 2
  t308 = 0.1e1 / t306 / t304
  t310 = t105 * s2 * t308
  t312 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t310
  t315 = 0.18040e1 - 0.64641600e0 / t312
  t317 = 0.1e1 / t306 / r1
  t318 = tau1 * t317
  t319 = t122 - t318
  t320 = t119 * t319
  t321 = t122 + t318
  t322 = 0.1e1 / t321
  t324 = t319 ** 2
  t325 = t131 * t324
  t326 = t321 ** 2
  t327 = 0.1e1 / t326
  t329 = t324 * t319
  t330 = t137 * t329
  t331 = t326 * t321
  t332 = 0.1e1 / t331
  t334 = t324 ** 2
  t335 = t143 * t334
  t336 = t326 ** 2
  t337 = 0.1e1 / t336
  t339 = t334 * t319
  t340 = t149 * t339
  t342 = 0.1e1 / t336 / t321
  t344 = t334 * t324
  t345 = t155 * t344
  t347 = 0.1e1 / t336 / t326
  t349 = t334 * t329
  t350 = t161 * t349
  t352 = 0.1e1 / t336 / t331
  t354 = t334 ** 2
  t355 = t167 * t354
  t356 = t336 ** 2
  t357 = 0.1e1 / t356
  t359 = t354 * t319
  t360 = t173 * t359
  t362 = 0.1e1 / t356 / t321
  t364 = t354 * t324
  t365 = t179 * t364
  t367 = 0.1e1 / t356 / t326
  t369 = t354 * t329
  t370 = t185 * t369
  t372 = 0.1e1 / t356 / t331
  t374 = t320 * t322 + t325 * t327 + t330 * t332 + t335 * t337 + t340 * t342 + t345 * t347 + t350 * t352 + t355 * t357 + t360 * t362 + t365 * t367 + t370 * t372 + t118
  t377 = jnp.exp(-0.93189002206715572255024750998986103655990934573863e-2 * t310)
  t379 = 0.1552e1 - 0.552e0 * t377
  t380 = t198 * t319
  t382 = t201 * t324
  t384 = t204 * t329
  t386 = t207 * t334
  t388 = t210 * t339
  t390 = t213 * t344
  t392 = t216 * t349
  t394 = t219 * t354
  t396 = t222 * t359
  t398 = t225 * t364
  t400 = t228 * t369
  t402 = t380 * t322 + t382 * t327 + t384 * t332 + t386 * t337 + t388 * t342 + t390 * t347 + t392 * t352 + t394 * t357 + t396 * t362 + t398 * t367 + t400 * t372 + t197
  t404 = t315 * t374 + t379 * t402
  t405 = t303 * t404
  t408 = f.my_piecewise3(t238, 0, -0.3e1 / 0.8e1 * t245 * t405)
  t409 = t6 ** 2
  t411 = t16 / t409
  t412 = t7 - t411
  t413 = f.my_piecewise5(t10, 0, t14, 0, t412)
  t416 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t413)
  t420 = t27 ** 2
  t421 = 0.1e1 / t420
  t425 = t26 * t421 * t98 * t233 / 0.8e1
  t426 = t53 * t52
  t427 = 0.1e1 / t426
  t430 = t2 / t27 / t6
  t433 = t34 * t430 * t46 / 0.54e2
  t434 = t45 ** 2
  t435 = 0.1e1 / t434
  t436 = t44 ** 2
  t437 = 0.1e1 / t436
  t438 = f.my_piecewise5(t38, 0, t40, 0, t412)
  t441 = f.my_piecewise3(t43, 0, t437 * t438 / 0.3e1)
  t446 = -t433 - t34 * t36 * t435 * t441 / 0.18e2
  t447 = f.my_piecewise3(t51, t446, 0)
  t450 = t56 * t52
  t451 = 0.1e1 / t450
  t454 = t56 * t426
  t455 = 0.1e1 / t454
  t459 = 0.1e1 / t62 / t52
  t463 = 0.1e1 / t62 / t426
  t467 = 0.1e1 / t62 / t450
  t471 = 0.1e1 / t62 / t454
  t475 = 0.1e1 / t74 / t52
  t479 = f.my_piecewise3(t51, 0, t446)
  t481 = t87 * t85
  t486 = 0.1e1 / t84 / t78
  t490 = t78 * t88
  t502 = f.my_piecewise3(t50, -t427 * t447 / 0.18e2 + t451 * t447 / 0.240e3 - t455 * t447 / 0.4480e4 + t459 * t447 / 0.103680e6 - t463 * t447 / 0.2838528e7 + t467 * t447 / 0.89456640e8 - t471 * t447 / 0.3185049600e10 + t475 * t447 / 0.126340300800e12, -0.8e1 / 0.3e1 * t479 * t94 - 0.8e1 / 0.3e1 * t78 * (-t481 * t479 + 0.2e1 * t479 * t91 + 0.2e1 * t78 * (t486 * t479 * t87 / 0.2e1 - 0.4e1 * t490 * t479 - t80 * t479 * t87)))
  t507 = t114 ** 2
  t509 = 0.1e1 / t507 * t100
  t513 = 0.1e1 / t108 / t106 / r0
  t519 = t110 * t129
  t523 = t135 * tau0 * t110
  t526 = t131 * t126
  t530 = t141 * tau0 * t110
  t533 = t137 * t132
  t537 = t147 * tau0 * t110
  t540 = t143 * t138
  t544 = t153 * tau0 * t110
  t547 = t149 * t144
  t551 = t159 * tau0 * t110
  t554 = t155 * t150
  t557 = 0.5e1 / 0.3e1 * t119 * tau0 * t519 + 0.5e1 / 0.3e1 * t127 * t523 + 0.10e2 / 0.3e1 * t526 * t523 + 0.10e2 / 0.3e1 * t133 * t530 + 0.5e1 * t533 * t530 + 0.5e1 * t139 * t537 + 0.20e2 / 0.3e1 * t540 * t537 + 0.20e2 / 0.3e1 * t145 * t544 + 0.25e2 / 0.3e1 * t547 * t544 + 0.25e2 / 0.3e1 * t151 * t551 + 0.10e2 * t554 * t551
  t559 = t165 * tau0 * t110
  t562 = t161 * t156
  t566 = t171 * tau0 * t110
  t569 = t167 * t162
  t573 = t177 * tau0 * t110
  t576 = t173 * t168
  t580 = t183 * tau0 * t110
  t583 = t179 * t174
  t587 = t189 * tau0 * t110
  t590 = t185 * t180
  t594 = 0.1e1 / t170 / t146
  t596 = t594 * tau0 * t110
  t599 = 0.10e2 * t157 * t559 + 0.35e2 / 0.3e1 * t562 * t559 + 0.35e2 / 0.3e1 * t163 * t566 + 0.40e2 / 0.3e1 * t569 * t566 + 0.40e2 / 0.3e1 * t169 * t573 + 0.15e2 * t576 * t573 + 0.15e2 * t175 * t580 + 0.50e2 / 0.3e1 * t583 * t580 + 0.50e2 / 0.3e1 * t181 * t587 + 0.55e2 / 0.3e1 * t590 * t587 + 0.55e2 / 0.3e1 * t187 * t596
  t612 = t201 * t126
  t617 = t204 * t132
  t622 = t207 * t138
  t627 = t210 * t144
  t632 = t213 * t150
  t635 = 0.5e1 / 0.3e1 * t198 * tau0 * t519 + 0.5e1 / 0.3e1 * t199 * t523 + 0.10e2 / 0.3e1 * t612 * t523 + 0.10e2 / 0.3e1 * t202 * t530 + 0.5e1 * t617 * t530 + 0.5e1 * t205 * t537 + 0.20e2 / 0.3e1 * t622 * t537 + 0.20e2 / 0.3e1 * t208 * t544 + 0.25e2 / 0.3e1 * t627 * t544 + 0.25e2 / 0.3e1 * t211 * t551 + 0.10e2 * t632 * t551
  t638 = t216 * t156
  t643 = t219 * t162
  t648 = t222 * t168
  t653 = t225 * t174
  t658 = t228 * t180
  t663 = 0.10e2 * t214 * t559 + 0.35e2 / 0.3e1 * t638 * t559 + 0.35e2 / 0.3e1 * t217 * t566 + 0.40e2 / 0.3e1 * t643 * t566 + 0.40e2 / 0.3e1 * t220 * t573 + 0.15e2 * t648 * t573 + 0.15e2 * t223 * t580 + 0.50e2 / 0.3e1 * t653 * t580 + 0.50e2 / 0.3e1 * t226 * t587 + 0.55e2 / 0.3e1 * t658 * t587 + 0.55e2 / 0.3e1 * t229 * t596
  t671 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t416 * t234 - t425 - 0.3e1 / 0.8e1 * t26 * t27 * t502 * t233 - 0.3e1 / 0.8e1 * t26 * t99 * (-0.15766086240000000000000000000000000000000000000000e-1 * t509 * t104 * s0 * t513 * t191 + t117 * (t557 + t599) - 0.13717421124828532235939643347050754458161865569272e-1 * t105 * s0 * t513 * t194 * t231 + t196 * (t635 + t663)))
  t672 = -t412
  t673 = f.my_piecewise5(t14, 0, t10, 0, t672)
  t676 = f.my_piecewise3(t241, 0, 0.4e1 / 0.3e1 * t242 * t673)
  t683 = t245 * t421 * t302 * t404 / 0.8e1
  t684 = t258 * t257
  t685 = 0.1e1 / t684
  t688 = t34 * t430 * t251 / 0.54e2
  t689 = t250 ** 2
  t690 = 0.1e1 / t689
  t691 = t249 ** 2
  t692 = 0.1e1 / t691
  t693 = f.my_piecewise5(t40, 0, t38, 0, t672)
  t696 = f.my_piecewise3(t248, 0, t692 * t693 / 0.3e1)
  t701 = -t688 - t34 * t36 * t690 * t696 / 0.18e2
  t702 = f.my_piecewise3(t256, t701, 0)
  t705 = t261 * t257
  t706 = 0.1e1 / t705
  t709 = t261 * t684
  t710 = 0.1e1 / t709
  t714 = 0.1e1 / t267 / t257
  t718 = 0.1e1 / t267 / t684
  t722 = 0.1e1 / t267 / t705
  t726 = 0.1e1 / t267 / t709
  t730 = 0.1e1 / t279 / t257
  t734 = f.my_piecewise3(t256, 0, t701)
  t736 = t291 * t289
  t741 = 0.1e1 / t288 / t283
  t745 = t283 * t292
  t757 = f.my_piecewise3(t255, -t685 * t702 / 0.18e2 + t706 * t702 / 0.240e3 - t710 * t702 / 0.4480e4 + t714 * t702 / 0.103680e6 - t718 * t702 / 0.2838528e7 + t722 * t702 / 0.89456640e8 - t726 * t702 / 0.3185049600e10 + t730 * t702 / 0.126340300800e12, -0.8e1 / 0.3e1 * t734 * t298 - 0.8e1 / 0.3e1 * t283 * (-t736 * t734 + 0.2e1 * t734 * t295 + 0.2e1 * t283 * (t741 * t734 * t291 / 0.2e1 - 0.4e1 * t745 * t734 - t284 * t734 * t291)))
  t763 = f.my_piecewise3(t238, 0, -0.3e1 / 0.8e1 * t5 * t676 * t405 - t683 - 0.3e1 / 0.8e1 * t245 * t27 * t757 * t404)
  vrho_0_ = t237 + t408 + t6 * (t671 + t763)
  t766 = -t7 - t411
  t767 = f.my_piecewise5(t10, 0, t14, 0, t766)
  t770 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t767)
  t774 = f.my_piecewise5(t38, 0, t40, 0, t766)
  t777 = f.my_piecewise3(t43, 0, t437 * t774 / 0.3e1)
  t782 = -t433 - t34 * t36 * t435 * t777 / 0.18e2
  t783 = f.my_piecewise3(t51, t782, 0)
  t801 = f.my_piecewise3(t51, 0, t782)
  t820 = f.my_piecewise3(t50, -t427 * t783 / 0.18e2 + t451 * t783 / 0.240e3 - t455 * t783 / 0.4480e4 + t459 * t783 / 0.103680e6 - t463 * t783 / 0.2838528e7 + t467 * t783 / 0.89456640e8 - t471 * t783 / 0.3185049600e10 + t475 * t783 / 0.126340300800e12, -0.8e1 / 0.3e1 * t801 * t94 - 0.8e1 / 0.3e1 * t78 * (-t481 * t801 + 0.2e1 * t801 * t91 + 0.2e1 * t78 * (t486 * t801 * t87 / 0.2e1 - 0.4e1 * t490 * t801 - t80 * t801 * t87)))
  t826 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t770 * t234 - t425 - 0.3e1 / 0.8e1 * t26 * t27 * t820 * t233)
  t827 = -t766
  t828 = f.my_piecewise5(t14, 0, t10, 0, t827)
  t831 = f.my_piecewise3(t241, 0, 0.4e1 / 0.3e1 * t242 * t828)
  t835 = f.my_piecewise5(t40, 0, t38, 0, t827)
  t838 = f.my_piecewise3(t248, 0, t692 * t835 / 0.3e1)
  t843 = -t688 - t34 * t36 * t690 * t838 / 0.18e2
  t844 = f.my_piecewise3(t256, t843, 0)
  t862 = f.my_piecewise3(t256, 0, t843)
  t881 = f.my_piecewise3(t255, -t685 * t844 / 0.18e2 + t706 * t844 / 0.240e3 - t710 * t844 / 0.4480e4 + t714 * t844 / 0.103680e6 - t718 * t844 / 0.2838528e7 + t722 * t844 / 0.89456640e8 - t726 * t844 / 0.3185049600e10 + t730 * t844 / 0.126340300800e12, -0.8e1 / 0.3e1 * t862 * t298 - 0.8e1 / 0.3e1 * t283 * (-t736 * t862 + 0.2e1 * t862 * t295 + 0.2e1 * t283 * (t741 * t862 * t291 / 0.2e1 - 0.4e1 * t745 * t862 - t284 * t862 * t291)))
  t886 = t312 ** 2
  t888 = 0.1e1 / t886 * t100
  t892 = 0.1e1 / t306 / t304 / r1
  t898 = t308 * t322
  t902 = t327 * tau1 * t308
  t905 = t131 * t319
  t909 = t332 * tau1 * t308
  t912 = t137 * t324
  t916 = t337 * tau1 * t308
  t919 = t143 * t329
  t923 = t342 * tau1 * t308
  t926 = t149 * t334
  t930 = t347 * tau1 * t308
  t933 = t155 * t339
  t936 = 0.5e1 / 0.3e1 * t119 * tau1 * t898 + 0.5e1 / 0.3e1 * t320 * t902 + 0.10e2 / 0.3e1 * t905 * t902 + 0.10e2 / 0.3e1 * t325 * t909 + 0.5e1 * t912 * t909 + 0.5e1 * t330 * t916 + 0.20e2 / 0.3e1 * t919 * t916 + 0.20e2 / 0.3e1 * t335 * t923 + 0.25e2 / 0.3e1 * t926 * t923 + 0.25e2 / 0.3e1 * t340 * t930 + 0.10e2 * t933 * t930
  t938 = t352 * tau1 * t308
  t941 = t161 * t344
  t945 = t357 * tau1 * t308
  t948 = t167 * t349
  t952 = t362 * tau1 * t308
  t955 = t173 * t354
  t959 = t367 * tau1 * t308
  t962 = t179 * t359
  t966 = t372 * tau1 * t308
  t969 = t185 * t364
  t973 = 0.1e1 / t356 / t336
  t975 = t973 * tau1 * t308
  t978 = 0.10e2 * t345 * t938 + 0.35e2 / 0.3e1 * t941 * t938 + 0.35e2 / 0.3e1 * t350 * t945 + 0.40e2 / 0.3e1 * t948 * t945 + 0.40e2 / 0.3e1 * t355 * t952 + 0.15e2 * t955 * t952 + 0.15e2 * t360 * t959 + 0.50e2 / 0.3e1 * t962 * t959 + 0.50e2 / 0.3e1 * t365 * t966 + 0.55e2 / 0.3e1 * t969 * t966 + 0.55e2 / 0.3e1 * t370 * t975
  t991 = t201 * t319
  t996 = t204 * t324
  t1001 = t207 * t329
  t1006 = t210 * t334
  t1011 = t213 * t339
  t1014 = 0.5e1 / 0.3e1 * t198 * tau1 * t898 + 0.5e1 / 0.3e1 * t380 * t902 + 0.10e2 / 0.3e1 * t991 * t902 + 0.10e2 / 0.3e1 * t382 * t909 + 0.5e1 * t996 * t909 + 0.5e1 * t384 * t916 + 0.20e2 / 0.3e1 * t1001 * t916 + 0.20e2 / 0.3e1 * t386 * t923 + 0.25e2 / 0.3e1 * t1006 * t923 + 0.25e2 / 0.3e1 * t388 * t930 + 0.10e2 * t1011 * t930
  t1017 = t216 * t344
  t1022 = t219 * t349
  t1027 = t222 * t354
  t1032 = t225 * t359
  t1037 = t228 * t364
  t1042 = 0.10e2 * t390 * t938 + 0.35e2 / 0.3e1 * t1017 * t938 + 0.35e2 / 0.3e1 * t392 * t945 + 0.40e2 / 0.3e1 * t1022 * t945 + 0.40e2 / 0.3e1 * t394 * t952 + 0.15e2 * t1027 * t952 + 0.15e2 * t396 * t959 + 0.50e2 / 0.3e1 * t1032 * t959 + 0.50e2 / 0.3e1 * t398 * t966 + 0.55e2 / 0.3e1 * t1037 * t966 + 0.55e2 / 0.3e1 * t400 * t975
  t1050 = f.my_piecewise3(t238, 0, -0.3e1 / 0.8e1 * t5 * t831 * t405 - t683 - 0.3e1 / 0.8e1 * t245 * t27 * t881 * t404 - 0.3e1 / 0.8e1 * t245 * t303 * (-0.15766086240000000000000000000000000000000000000000e-1 * t888 * t104 * s2 * t892 * t374 + t315 * (t936 + t978) - 0.13717421124828532235939643347050754458161865569272e-1 * t105 * s2 * t892 * t377 * t402 + t379 * (t1014 + t1042)))
  vrho_1_ = t237 + t408 + t6 * (t826 + t1050)
  t1065 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t99 * (0.59122823400000000000000000000000000000000000000000e-2 * t509 * t104 * t110 * t191 + 0.51440329218106995884773662551440329218106995884772e-2 * t105 * t110 * t194 * t231))
  vsigma_0_ = t6 * t1065
  vsigma_1_ = 0.0e0
  t1078 = f.my_piecewise3(t238, 0, -0.3e1 / 0.8e1 * t245 * t303 * (0.59122823400000000000000000000000000000000000000000e-2 * t888 * t104 * t308 * t374 + 0.51440329218106995884773662551440329218106995884772e-2 * t105 * t308 * t377 * t402))
  vsigma_2_ = t6 * t1078
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t1081 = t135 * t124
  t1085 = t141 * t124
  t1090 = t147 * t124
  t1095 = t153 * t124
  t1100 = t159 * t124
  t1105 = -t119 * t124 * t129 - t127 * t1081 - 0.2e1 * t526 * t1081 - 0.2e1 * t133 * t1085 - 0.3e1 * t533 * t1085 - 0.3e1 * t139 * t1090 - 0.4e1 * t540 * t1090 - 0.4e1 * t145 * t1095 - 0.5e1 * t547 * t1095 - 0.5e1 * t151 * t1100 - 0.6e1 * t554 * t1100
  t1106 = t165 * t124
  t1111 = t171 * t124
  t1116 = t177 * t124
  t1121 = t183 * t124
  t1126 = t189 * t124
  t1131 = t594 * t124
  t1134 = -0.6e1 * t157 * t1106 - 0.7e1 * t562 * t1106 - 0.7e1 * t163 * t1111 - 0.8e1 * t569 * t1111 - 0.8e1 * t169 * t1116 - 0.9e1 * t576 * t1116 - 0.9e1 * t175 * t1121 - 0.10e2 * t583 * t1121 - 0.10e2 * t181 * t1126 - 0.11e2 * t590 * t1126 - 0.11e2 * t187 * t1131
  t1158 = -t198 * t124 * t129 - t199 * t1081 - 0.2e1 * t612 * t1081 - 0.2e1 * t202 * t1085 - 0.3e1 * t617 * t1085 - 0.3e1 * t205 * t1090 - 0.4e1 * t622 * t1090 - 0.4e1 * t208 * t1095 - 0.5e1 * t627 * t1095 - 0.5e1 * t211 * t1100 - 0.6e1 * t632 * t1100
  t1181 = -0.6e1 * t214 * t1106 - 0.7e1 * t638 * t1106 - 0.7e1 * t217 * t1111 - 0.8e1 * t643 * t1111 - 0.8e1 * t220 * t1116 - 0.9e1 * t648 * t1116 - 0.9e1 * t223 * t1121 - 0.10e2 * t653 * t1121 - 0.10e2 * t226 * t1126 - 0.11e2 * t658 * t1126 - 0.11e2 * t229 * t1131
  t1188 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t99 * (t117 * (t1105 + t1134) + t196 * (t1158 + t1181)))
  vtau_0_ = t6 * t1188
  t1191 = t327 * t317
  t1195 = t332 * t317
  t1200 = t337 * t317
  t1205 = t342 * t317
  t1210 = t347 * t317
  t1215 = -t119 * t317 * t322 - t320 * t1191 - 0.2e1 * t905 * t1191 - 0.2e1 * t325 * t1195 - 0.3e1 * t912 * t1195 - 0.3e1 * t330 * t1200 - 0.4e1 * t919 * t1200 - 0.4e1 * t335 * t1205 - 0.5e1 * t926 * t1205 - 0.5e1 * t340 * t1210 - 0.6e1 * t933 * t1210
  t1216 = t352 * t317
  t1221 = t357 * t317
  t1226 = t362 * t317
  t1231 = t367 * t317
  t1236 = t372 * t317
  t1241 = t973 * t317
  t1244 = -0.6e1 * t345 * t1216 - 0.7e1 * t941 * t1216 - 0.7e1 * t350 * t1221 - 0.8e1 * t948 * t1221 - 0.8e1 * t355 * t1226 - 0.9e1 * t955 * t1226 - 0.9e1 * t360 * t1231 - 0.10e2 * t962 * t1231 - 0.10e2 * t365 * t1236 - 0.11e2 * t969 * t1236 - 0.11e2 * t370 * t1241
  t1268 = -t198 * t317 * t322 - 0.4e1 * t1001 * t1200 - 0.5e1 * t1006 * t1205 - 0.6e1 * t1011 * t1210 - t380 * t1191 - 0.2e1 * t991 * t1191 - 0.2e1 * t382 * t1195 - 0.3e1 * t996 * t1195 - 0.3e1 * t384 * t1200 - 0.4e1 * t386 * t1205 - 0.5e1 * t388 * t1210
  t1291 = -0.7e1 * t1017 * t1216 - 0.8e1 * t1022 * t1221 - 0.9e1 * t1027 * t1226 - 0.10e2 * t1032 * t1231 - 0.11e2 * t1037 * t1236 - 0.6e1 * t390 * t1216 - 0.7e1 * t392 * t1221 - 0.8e1 * t394 * t1226 - 0.9e1 * t396 * t1231 - 0.10e2 * t398 * t1236 - 0.11e2 * t400 * t1241
  t1298 = f.my_piecewise3(t238, 0, -0.3e1 / 0.8e1 * t245 * t303 * (t315 * (t1215 + t1244) + t379 * (t1268 + t1291)))
  vtau_1_ = t6 * t1298
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  m11_f = lambda rs, z, x, u, t: attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3)) * m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, m11_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t12 = t11 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t12, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 9 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t26 = t21 * t24 * f.p.cam_omega
  t29 = f.my_piecewise3(t12, t13, t15)
  t30 = 0.1e1 / t29
  t33 = t26 * t3 / t19 * t30 / 0.18e2
  t34 = 0.135e1 <= t33
  t35 = 0.135e1 < t33
  t36 = f.my_piecewise3(t35, t33, 0.135e1)
  t37 = t36 ** 2
  t40 = t37 ** 2
  t43 = t40 * t37
  t46 = t40 ** 2
  t58 = t46 ** 2
  t62 = f.my_piecewise3(t35, 0.135e1, t33)
  t63 = jnp.sqrt(jnp.pi)
  t64 = 0.1e1 / t62
  t66 = jax.lax.erf(t64 / 0.2e1)
  t68 = t62 ** 2
  t69 = 0.1e1 / t68
  t71 = jnp.exp(-t69 / 0.4e1)
  t72 = t71 - 0.1e1
  t75 = t71 - 0.3e1 / 0.2e1 - 0.2e1 * t68 * t72
  t78 = 0.2e1 * t62 * t75 + t63 * t66
  t82 = f.my_piecewise3(t34, 0.1e1 / t37 / 0.36e2 - 0.1e1 / t40 / 0.960e3 + 0.1e1 / t43 / 0.26880e5 - 0.1e1 / t46 / 0.829440e6 + 0.1e1 / t46 / t37 / 0.28385280e8 - 0.1e1 / t46 / t40 / 0.1073479680e10 + 0.1e1 / t46 / t43 / 0.44590694400e11 - 0.1e1 / t58 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t62 * t78)
  t83 = t19 * t82
  t84 = 6 ** (0.1e1 / 0.3e1)
  t85 = jnp.pi ** 2
  t86 = t85 ** (0.1e1 / 0.3e1)
  t87 = t86 ** 2
  t88 = 0.1e1 / t87
  t89 = t84 * t88
  t90 = 2 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t92 = s0 * t91
  t93 = r0 ** 2
  t94 = t19 ** 2
  t96 = 0.1e1 / t94 / t93
  t98 = t89 * t92 * t96
  t100 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t98
  t103 = 0.18040e1 - 0.64641600e0 / t100
  t105 = params.a[1]
  t106 = t84 ** 2
  t108 = 0.3e1 / 0.10e2 * t106 * t87
  t109 = tau0 * t91
  t111 = 0.1e1 / t94 / r0
  t112 = t109 * t111
  t113 = t108 - t112
  t114 = t105 * t113
  t115 = t108 + t112
  t116 = 0.1e1 / t115
  t118 = params.a[2]
  t119 = t113 ** 2
  t120 = t118 * t119
  t121 = t115 ** 2
  t122 = 0.1e1 / t121
  t124 = params.a[3]
  t125 = t119 * t113
  t126 = t124 * t125
  t127 = t121 * t115
  t128 = 0.1e1 / t127
  t130 = params.a[4]
  t131 = t119 ** 2
  t132 = t130 * t131
  t133 = t121 ** 2
  t134 = 0.1e1 / t133
  t136 = params.a[5]
  t137 = t131 * t113
  t138 = t136 * t137
  t140 = 0.1e1 / t133 / t115
  t142 = params.a[6]
  t143 = t131 * t119
  t144 = t142 * t143
  t146 = 0.1e1 / t133 / t121
  t148 = params.a[7]
  t149 = t131 * t125
  t150 = t148 * t149
  t152 = 0.1e1 / t133 / t127
  t154 = params.a[8]
  t155 = t131 ** 2
  t156 = t154 * t155
  t157 = t133 ** 2
  t158 = 0.1e1 / t157
  t160 = params.a[9]
  t161 = t155 * t113
  t162 = t160 * t161
  t164 = 0.1e1 / t157 / t115
  t166 = params.a[10]
  t167 = t155 * t119
  t168 = t166 * t167
  t170 = 0.1e1 / t157 / t121
  t172 = params.a[11]
  t173 = t155 * t125
  t174 = t172 * t173
  t176 = 0.1e1 / t157 / t127
  t178 = t114 * t116 + t120 * t122 + t126 * t128 + t132 * t134 + t138 * t140 + t144 * t146 + t150 * t152 + t156 * t158 + t162 * t164 + t168 * t170 + t174 * t176 + params.a[0]
  t181 = jnp.exp(-0.93189002206715572255024750998986103655990934573863e-2 * t98)
  t183 = 0.1552e1 - 0.552e0 * t181
  t185 = params.b[1]
  t186 = t185 * t113
  t188 = params.b[2]
  t189 = t188 * t119
  t191 = params.b[3]
  t192 = t191 * t125
  t194 = params.b[4]
  t195 = t194 * t131
  t197 = params.b[5]
  t198 = t197 * t137
  t200 = params.b[6]
  t201 = t200 * t143
  t203 = params.b[7]
  t204 = t203 * t149
  t206 = params.b[8]
  t207 = t206 * t155
  t209 = params.b[9]
  t210 = t209 * t161
  t212 = params.b[10]
  t213 = t212 * t167
  t215 = params.b[11]
  t216 = t215 * t173
  t218 = t186 * t116 + t189 * t122 + t192 * t128 + t195 * t134 + t198 * t140 + t201 * t146 + t204 * t152 + t207 * t158 + t210 * t164 + t213 * t170 + t216 * t176 + params.b[0]
  t220 = t103 * t178 + t183 * t218
  t224 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t83 * t220)
  t230 = t37 * t36
  t237 = t26 * t3 / t19 / r0 * t30 / 0.54e2
  t238 = f.my_piecewise3(t35, -t237, 0)
  t241 = t40 * t36
  t245 = t40 * t230
  t270 = f.my_piecewise3(t35, 0, -t237)
  t293 = f.my_piecewise3(t34, -0.1e1 / t230 * t238 / 0.18e2 + 0.1e1 / t241 * t238 / 0.240e3 - 0.1e1 / t245 * t238 / 0.4480e4 + 0.1e1 / t46 / t36 * t238 / 0.103680e6 - 0.1e1 / t46 / t230 * t238 / 0.2838528e7 + 0.1e1 / t46 / t241 * t238 / 0.89456640e8 - 0.1e1 / t46 / t245 * t238 / 0.3185049600e10 + 0.1e1 / t58 / t36 * t238 / 0.126340300800e12, -0.8e1 / 0.3e1 * t270 * t78 - 0.8e1 / 0.3e1 * t62 * (-t71 * t69 * t270 + 0.2e1 * t270 * t75 + 0.2e1 * t62 * (0.1e1 / t68 / t62 * t270 * t71 / 0.2e1 - 0.4e1 * t62 * t72 * t270 - t64 * t270 * t71)))
  t298 = t100 ** 2
  t301 = 0.1e1 / t298 * t84 * t88
  t304 = 0.1e1 / t94 / t93 / r0
  t310 = t91 * t96
  t311 = t310 * t116
  t315 = t109 * t96
  t318 = t118 * t113
  t325 = t124 * t119
  t332 = t130 * t125
  t339 = t136 * t131
  t346 = t142 * t137
  t350 = 0.5e1 / 0.3e1 * t105 * tau0 * t311 + 0.5e1 / 0.3e1 * t114 * t122 * t315 + 0.10e2 / 0.3e1 * t318 * t122 * t315 + 0.10e2 / 0.3e1 * t120 * t128 * t315 + 0.5e1 * t325 * t128 * t315 + 0.5e1 * t126 * t134 * t315 + 0.20e2 / 0.3e1 * t332 * t134 * t315 + 0.20e2 / 0.3e1 * t132 * t140 * t315 + 0.25e2 / 0.3e1 * t339 * t140 * t315 + 0.25e2 / 0.3e1 * t138 * t146 * t315 + 0.10e2 * t346 * t146 * t315
  t354 = t148 * t143
  t361 = t154 * t149
  t368 = t160 * t155
  t375 = t166 * t161
  t382 = t172 * t167
  t387 = 0.1e1 / t157 / t133
  t391 = 0.10e2 * t144 * t152 * t315 + 0.35e2 / 0.3e1 * t354 * t152 * t315 + 0.35e2 / 0.3e1 * t150 * t158 * t315 + 0.40e2 / 0.3e1 * t361 * t158 * t315 + 0.40e2 / 0.3e1 * t156 * t164 * t315 + 0.15e2 * t368 * t164 * t315 + 0.15e2 * t162 * t170 * t315 + 0.50e2 / 0.3e1 * t375 * t170 * t315 + 0.50e2 / 0.3e1 * t168 * t176 * t315 + 0.55e2 / 0.3e1 * t382 * t176 * t315 + 0.55e2 / 0.3e1 * t174 * t387 * t315
  t406 = t188 * t113
  t413 = t191 * t119
  t420 = t194 * t125
  t427 = t197 * t131
  t434 = t200 * t137
  t438 = 0.5e1 / 0.3e1 * t185 * tau0 * t311 + 0.5e1 / 0.3e1 * t186 * t122 * t315 + 0.10e2 / 0.3e1 * t406 * t122 * t315 + 0.10e2 / 0.3e1 * t189 * t128 * t315 + 0.5e1 * t413 * t128 * t315 + 0.5e1 * t192 * t134 * t315 + 0.20e2 / 0.3e1 * t420 * t134 * t315 + 0.20e2 / 0.3e1 * t195 * t140 * t315 + 0.25e2 / 0.3e1 * t427 * t140 * t315 + 0.25e2 / 0.3e1 * t198 * t146 * t315 + 0.10e2 * t434 * t146 * t315
  t442 = t203 * t143
  t449 = t206 * t149
  t456 = t209 * t155
  t463 = t212 * t161
  t470 = t215 * t167
  t477 = 0.10e2 * t201 * t152 * t315 + 0.35e2 / 0.3e1 * t442 * t152 * t315 + 0.35e2 / 0.3e1 * t204 * t158 * t315 + 0.40e2 / 0.3e1 * t449 * t158 * t315 + 0.40e2 / 0.3e1 * t207 * t164 * t315 + 0.15e2 * t456 * t164 * t315 + 0.15e2 * t210 * t170 * t315 + 0.50e2 / 0.3e1 * t463 * t170 * t315 + 0.50e2 / 0.3e1 * t213 * t176 * t315 + 0.55e2 / 0.3e1 * t470 * t176 * t315 + 0.55e2 / 0.3e1 * t216 * t387 * t315
  t485 = f.my_piecewise3(t2, 0, -t18 / t94 * t82 * t220 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t293 * t220 - 0.3e1 / 0.8e1 * t18 * t83 * (-0.15766086240000000000000000000000000000000000000000e-1 * t301 * t92 * t304 * t178 + t103 * (t350 + t391) - 0.13717421124828532235939643347050754458161865569272e-1 * t89 * s0 * t91 * t304 * t181 * t218 + t183 * (t438 + t477)))
  vrho_0_ = 0.2e1 * r0 * t485 + 0.2e1 * t224
  t500 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t83 * (0.59122823400000000000000000000000000000000000000000e-2 * t301 * t310 * t178 + 0.51440329218106995884773662551440329218106995884772e-2 * t89 * t91 * t96 * t181 * t218))
  vsigma_0_ = 0.2e1 * r0 * t500
  vlapl_0_ = 0.0e0
  t503 = t111 * t116
  t506 = t122 * t91 * t111
  t511 = t128 * t91 * t111
  t517 = t134 * t91 * t111
  t523 = t140 * t91 * t111
  t529 = t146 * t91 * t111
  t534 = -t105 * t91 * t503 - t114 * t506 - 0.2e1 * t120 * t511 - 0.3e1 * t126 * t517 - 0.4e1 * t132 * t523 - 0.5e1 * t138 * t529 - 0.2e1 * t318 * t506 - 0.3e1 * t325 * t511 - 0.4e1 * t332 * t517 - 0.5e1 * t339 * t523 - 0.6e1 * t346 * t529
  t536 = t152 * t91 * t111
  t542 = t158 * t91 * t111
  t548 = t164 * t91 * t111
  t554 = t170 * t91 * t111
  t560 = t176 * t91 * t111
  t566 = t387 * t91 * t111
  t569 = -0.6e1 * t144 * t536 - 0.7e1 * t150 * t542 - 0.8e1 * t156 * t548 - 0.9e1 * t162 * t554 - 0.10e2 * t168 * t560 - 0.11e2 * t174 * t566 - 0.7e1 * t354 * t536 - 0.8e1 * t361 * t542 - 0.9e1 * t368 * t548 - 0.10e2 * t375 * t554 - 0.11e2 * t382 * t560
  t593 = -t185 * t91 * t503 - t186 * t506 - 0.2e1 * t189 * t511 - 0.3e1 * t192 * t517 - 0.4e1 * t195 * t523 - 0.5e1 * t198 * t529 - 0.2e1 * t406 * t506 - 0.3e1 * t413 * t511 - 0.4e1 * t420 * t517 - 0.5e1 * t427 * t523 - 0.6e1 * t434 * t529
  t616 = -0.6e1 * t201 * t536 - 0.7e1 * t204 * t542 - 0.8e1 * t207 * t548 - 0.9e1 * t210 * t554 - 0.10e2 * t213 * t560 - 0.11e2 * t216 * t566 - 0.7e1 * t442 * t536 - 0.8e1 * t449 * t542 - 0.9e1 * t456 * t548 - 0.10e2 * t463 * t554 - 0.11e2 * t470 * t560
  t623 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t83 * (t103 * (t534 + t569) + t183 * (t593 + t616)))
  vtau_0_ = 0.2e1 * r0 * t623
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t12 = t11 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t12, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = 9 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = t23 * t26 * f.p.cam_omega
  t31 = f.my_piecewise3(t12, t13, t15)
  t32 = 0.1e1 / t31
  t35 = t28 * t3 / t19 * t32 / 0.18e2
  t36 = 0.135e1 <= t35
  t37 = 0.135e1 < t35
  t38 = f.my_piecewise3(t37, t35, 0.135e1)
  t39 = t38 ** 2
  t42 = t39 ** 2
  t43 = 0.1e1 / t42
  t45 = t42 * t39
  t46 = 0.1e1 / t45
  t48 = t42 ** 2
  t49 = 0.1e1 / t48
  t52 = 0.1e1 / t48 / t39
  t55 = 0.1e1 / t48 / t42
  t58 = 0.1e1 / t48 / t45
  t60 = t48 ** 2
  t61 = 0.1e1 / t60
  t64 = f.my_piecewise3(t37, 0.135e1, t35)
  t65 = jnp.sqrt(jnp.pi)
  t66 = 0.1e1 / t64
  t68 = jax.lax.erf(t66 / 0.2e1)
  t70 = t64 ** 2
  t71 = 0.1e1 / t70
  t73 = jnp.exp(-t71 / 0.4e1)
  t74 = t73 - 0.1e1
  t77 = t73 - 0.3e1 / 0.2e1 - 0.2e1 * t70 * t74
  t80 = 0.2e1 * t64 * t77 + t65 * t68
  t84 = f.my_piecewise3(t36, 0.1e1 / t39 / 0.36e2 - t43 / 0.960e3 + t46 / 0.26880e5 - t49 / 0.829440e6 + t52 / 0.28385280e8 - t55 / 0.1073479680e10 + t58 / 0.44590694400e11 - t61 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t64 * t80)
  t85 = t21 * t84
  t86 = 6 ** (0.1e1 / 0.3e1)
  t87 = jnp.pi ** 2
  t88 = t87 ** (0.1e1 / 0.3e1)
  t89 = t88 ** 2
  t90 = 0.1e1 / t89
  t91 = t86 * t90
  t92 = 2 ** (0.1e1 / 0.3e1)
  t93 = t92 ** 2
  t94 = s0 * t93
  t95 = r0 ** 2
  t97 = 0.1e1 / t20 / t95
  t99 = t91 * t94 * t97
  t101 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t99
  t104 = 0.18040e1 - 0.64641600e0 / t101
  t106 = params.a[1]
  t107 = t86 ** 2
  t109 = 0.3e1 / 0.10e2 * t107 * t89
  t110 = tau0 * t93
  t112 = 0.1e1 / t20 / r0
  t113 = t110 * t112
  t114 = t109 - t113
  t115 = t106 * t114
  t116 = t109 + t113
  t117 = 0.1e1 / t116
  t119 = params.a[2]
  t120 = t114 ** 2
  t121 = t119 * t120
  t122 = t116 ** 2
  t123 = 0.1e1 / t122
  t125 = params.a[3]
  t126 = t120 * t114
  t127 = t125 * t126
  t128 = t122 * t116
  t129 = 0.1e1 / t128
  t131 = params.a[4]
  t132 = t120 ** 2
  t133 = t131 * t132
  t134 = t122 ** 2
  t135 = 0.1e1 / t134
  t137 = params.a[5]
  t138 = t132 * t114
  t139 = t137 * t138
  t140 = t134 * t116
  t141 = 0.1e1 / t140
  t143 = params.a[6]
  t144 = t132 * t120
  t145 = t143 * t144
  t147 = 0.1e1 / t134 / t122
  t149 = params.a[7]
  t150 = t132 * t126
  t151 = t149 * t150
  t153 = 0.1e1 / t134 / t128
  t155 = params.a[8]
  t156 = t132 ** 2
  t157 = t155 * t156
  t158 = t134 ** 2
  t159 = 0.1e1 / t158
  t161 = params.a[9]
  t162 = t156 * t114
  t163 = t161 * t162
  t165 = 0.1e1 / t158 / t116
  t167 = params.a[10]
  t168 = t156 * t120
  t169 = t167 * t168
  t171 = 0.1e1 / t158 / t122
  t173 = params.a[11]
  t174 = t156 * t126
  t175 = t173 * t174
  t177 = 0.1e1 / t158 / t128
  t179 = t115 * t117 + t121 * t123 + t127 * t129 + t133 * t135 + t139 * t141 + t145 * t147 + t151 * t153 + t157 * t159 + t163 * t165 + t169 * t171 + t175 * t177 + params.a[0]
  t182 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t99)
  t184 = 0.1552e1 - 0.552e0 * t182
  t186 = params.b[1]
  t187 = t186 * t114
  t189 = params.b[2]
  t190 = t189 * t120
  t192 = params.b[3]
  t193 = t192 * t126
  t195 = params.b[4]
  t196 = t195 * t132
  t198 = params.b[5]
  t199 = t198 * t138
  t201 = params.b[6]
  t202 = t201 * t144
  t204 = params.b[7]
  t205 = t204 * t150
  t207 = params.b[8]
  t208 = t207 * t156
  t210 = params.b[9]
  t211 = t210 * t162
  t213 = params.b[10]
  t214 = t213 * t168
  t216 = params.b[11]
  t217 = t216 * t174
  t219 = t187 * t117 + t190 * t123 + t193 * t129 + t196 * t135 + t199 * t141 + t202 * t147 + t205 * t153 + t208 * t159 + t211 * t165 + t214 * t171 + t217 * t177 + params.b[0]
  t221 = t104 * t179 + t184 * t219
  t225 = t39 * t38
  t226 = 0.1e1 / t225
  t232 = t28 * t3 / t19 / r0 * t32 / 0.54e2
  t233 = f.my_piecewise3(t37, -t232, 0)
  t236 = t42 * t38
  t237 = 0.1e1 / t236
  t240 = t42 * t225
  t241 = 0.1e1 / t240
  t245 = 0.1e1 / t48 / t38
  t249 = 0.1e1 / t48 / t225
  t253 = 0.1e1 / t48 / t236
  t257 = 0.1e1 / t48 / t240
  t261 = 0.1e1 / t60 / t38
  t265 = f.my_piecewise3(t37, 0, -t232)
  t267 = t73 * t71
  t272 = 0.1e1 / t70 / t64
  t276 = t64 * t74
  t281 = t272 * t265 * t73 / 0.2e1 - 0.4e1 * t276 * t265 - t66 * t265 * t73
  t284 = -t267 * t265 + 0.2e1 * t265 * t77 + 0.2e1 * t64 * t281
  t288 = f.my_piecewise3(t36, -t226 * t233 / 0.18e2 + t237 * t233 / 0.240e3 - t241 * t233 / 0.4480e4 + t245 * t233 / 0.103680e6 - t249 * t233 / 0.2838528e7 + t253 * t233 / 0.89456640e8 - t257 * t233 / 0.3185049600e10 + t261 * t233 / 0.126340300800e12, -0.8e1 / 0.3e1 * t265 * t80 - 0.8e1 / 0.3e1 * t64 * t284)
  t289 = t19 * t288
  t293 = t19 * t84
  t294 = t101 ** 2
  t297 = 0.1e1 / t294 * t86 * t90
  t298 = t95 * r0
  t300 = 0.1e1 / t20 / t298
  t305 = t106 * tau0
  t307 = t93 * t97 * t117
  t310 = t115 * t123
  t311 = t110 * t97
  t314 = t119 * t114
  t315 = t314 * t123
  t318 = t121 * t129
  t321 = t125 * t120
  t322 = t321 * t129
  t325 = t127 * t135
  t328 = t131 * t126
  t329 = t328 * t135
  t332 = t133 * t141
  t335 = t137 * t132
  t336 = t335 * t141
  t339 = t139 * t147
  t342 = t143 * t138
  t343 = t342 * t147
  t346 = 0.5e1 / 0.3e1 * t305 * t307 + 0.5e1 / 0.3e1 * t310 * t311 + 0.10e2 / 0.3e1 * t315 * t311 + 0.10e2 / 0.3e1 * t318 * t311 + 0.5e1 * t322 * t311 + 0.5e1 * t325 * t311 + 0.20e2 / 0.3e1 * t329 * t311 + 0.20e2 / 0.3e1 * t332 * t311 + 0.25e2 / 0.3e1 * t336 * t311 + 0.25e2 / 0.3e1 * t339 * t311 + 0.10e2 * t343 * t311
  t347 = t145 * t153
  t350 = t149 * t144
  t351 = t350 * t153
  t354 = t151 * t159
  t357 = t155 * t150
  t358 = t357 * t159
  t361 = t157 * t165
  t364 = t161 * t156
  t365 = t364 * t165
  t368 = t163 * t171
  t371 = t167 * t162
  t372 = t371 * t171
  t375 = t169 * t177
  t378 = t173 * t168
  t379 = t378 * t177
  t383 = 0.1e1 / t158 / t134
  t384 = t175 * t383
  t387 = 0.10e2 * t347 * t311 + 0.35e2 / 0.3e1 * t351 * t311 + 0.35e2 / 0.3e1 * t354 * t311 + 0.40e2 / 0.3e1 * t358 * t311 + 0.40e2 / 0.3e1 * t361 * t311 + 0.15e2 * t365 * t311 + 0.15e2 * t368 * t311 + 0.50e2 / 0.3e1 * t372 * t311 + 0.50e2 / 0.3e1 * t375 * t311 + 0.55e2 / 0.3e1 * t379 * t311 + 0.55e2 / 0.3e1 * t384 * t311
  t388 = t346 + t387
  t390 = t91 * s0
  t391 = t93 * t300
  t392 = t182 * t219
  t396 = t186 * tau0
  t399 = t187 * t123
  t402 = t189 * t114
  t403 = t402 * t123
  t406 = t190 * t129
  t409 = t192 * t120
  t410 = t409 * t129
  t413 = t193 * t135
  t416 = t195 * t126
  t417 = t416 * t135
  t420 = t196 * t141
  t423 = t198 * t132
  t424 = t423 * t141
  t427 = t199 * t147
  t430 = t201 * t138
  t431 = t430 * t147
  t434 = 0.5e1 / 0.3e1 * t396 * t307 + 0.5e1 / 0.3e1 * t399 * t311 + 0.10e2 / 0.3e1 * t403 * t311 + 0.10e2 / 0.3e1 * t406 * t311 + 0.5e1 * t410 * t311 + 0.5e1 * t413 * t311 + 0.20e2 / 0.3e1 * t417 * t311 + 0.20e2 / 0.3e1 * t420 * t311 + 0.25e2 / 0.3e1 * t424 * t311 + 0.25e2 / 0.3e1 * t427 * t311 + 0.10e2 * t431 * t311
  t435 = t202 * t153
  t438 = t204 * t144
  t439 = t438 * t153
  t442 = t205 * t159
  t445 = t207 * t150
  t446 = t445 * t159
  t449 = t208 * t165
  t452 = t210 * t156
  t453 = t452 * t165
  t456 = t211 * t171
  t459 = t213 * t162
  t460 = t459 * t171
  t463 = t214 * t177
  t466 = t216 * t168
  t467 = t466 * t177
  t470 = t217 * t383
  t473 = 0.10e2 * t435 * t311 + 0.35e2 / 0.3e1 * t439 * t311 + 0.35e2 / 0.3e1 * t442 * t311 + 0.40e2 / 0.3e1 * t446 * t311 + 0.40e2 / 0.3e1 * t449 * t311 + 0.15e2 * t453 * t311 + 0.15e2 * t456 * t311 + 0.50e2 / 0.3e1 * t460 * t311 + 0.50e2 / 0.3e1 * t463 * t311 + 0.55e2 / 0.3e1 * t467 * t311 + 0.55e2 / 0.3e1 * t470 * t311
  t474 = t434 + t473
  t476 = -0.15766086240000000000000000000000000000000000000000e-1 * t297 * t94 * t300 * t179 + t104 * t388 - 0.13717421124828532235939643347050754458161865569273e-1 * t390 * t391 * t392 + t184 * t474
  t481 = f.my_piecewise3(t2, 0, -t18 * t85 * t221 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t289 * t221 - 0.3e1 / 0.8e1 * t18 * t293 * t476)
  t494 = t233 ** 2
  t502 = 0.2e1 / 0.81e2 * t28 * t3 / t19 / t95 * t32
  t503 = f.my_piecewise3(t37, t502, 0)
  t536 = t43 * t494 / 0.6e1 - t226 * t503 / 0.18e2 - t46 * t494 / 0.48e2 + t237 * t503 / 0.240e3 + t49 * t494 / 0.640e3 - t241 * t503 / 0.4480e4 - t52 * t494 / 0.11520e5 + t245 * t503 / 0.103680e6 + t55 * t494 / 0.258048e6 - t249 * t503 / 0.2838528e7 - t58 * t494 / 0.6881280e7 + t253 * t503 / 0.89456640e8 + t61 * t494 / 0.212336640e9 - t257 * t503 / 0.3185049600e10 - 0.1e1 / t60 / t39 * t494 / 0.7431782400e10 + t261 * t503 / 0.126340300800e12
  t537 = f.my_piecewise3(t37, 0, t502)
  t542 = t70 ** 2
  t545 = t265 ** 2
  t584 = f.my_piecewise3(t36, t536, -0.8e1 / 0.3e1 * t537 * t80 - 0.16e2 / 0.3e1 * t265 * t284 - 0.8e1 / 0.3e1 * t64 * (-0.1e1 / t542 / t64 * t545 * t73 / 0.2e1 + 0.2e1 * t73 * t272 * t545 - t267 * t537 + 0.2e1 * t537 * t77 + 0.4e1 * t265 * t281 + 0.2e1 * t64 * (-0.2e1 / t542 * t545 * t73 + t272 * t537 * t73 / 0.2e1 + 0.1e1 / t542 / t70 * t545 * t73 / 0.4e1 - 0.4e1 * t545 * t74 - t71 * t545 * t73 - 0.4e1 * t276 * t537 - t66 * t537 * t73)))
  t596 = 0.1e1 / t88 / t87
  t598 = s0 ** 2
  t600 = t95 ** 2
  t603 = 0.1e1 / t19 / t600 / t298
  t609 = 0.1e1 / t20 / t600
  t619 = tau0 ** 2
  t623 = 0.1e1 / t19 / t600 / r0
  t624 = t619 * t92 * t623
  t638 = 0.1e1 / t158 / t140
  t668 = 0.10000e5 / 0.9e1 * t371 * t177 * t624 + 0.5500e4 / 0.9e1 * t169 * t383 * t624 + 0.5500e4 / 0.9e1 * t173 * t162 * t177 * t624 + 0.12100e5 / 0.9e1 * t378 * t383 * t624 + 0.2200e4 / 0.3e1 * t175 * t638 * t624 + 0.1600e4 / 0.9e1 * t328 * t141 * t624 + 0.1000e4 / 0.9e1 * t133 * t147 * t624 + 0.1000e4 / 0.9e1 * t137 * t126 * t141 * t624 + 0.2500e4 / 0.9e1 * t335 * t147 * t624 + 0.500e3 / 0.3e1 * t139 * t153 * t624 + 0.500e3 / 0.3e1 * t143 * t132 * t147 * t624 + 0.400e3 * t342 * t153 * t624 + 0.700e3 / 0.3e1 * t145 * t159 * t624
  t695 = t110 * t300
  t711 = 0.2800e4 / 0.9e1 * t151 * t165 * t624 + 0.100e3 / 0.9e1 * t115 * t129 * t624 + 0.400e3 / 0.9e1 * t314 * t129 * t624 + 0.100e3 / 0.3e1 * t121 * t135 * t624 + 0.100e3 / 0.3e1 * t125 * t114 * t129 * t624 + 0.100e3 * t321 * t135 * t624 + 0.200e3 / 0.3e1 * t127 * t141 * t624 + 0.200e3 / 0.3e1 * t131 * t120 * t135 * t624 - 0.80e2 / 0.9e1 * t318 * t695 - 0.40e2 / 0.3e1 * t322 * t695 + 0.700e3 / 0.3e1 * t149 * t138 * t153 * t624 + 0.4900e4 / 0.9e1 * t350 * t159 * t624 - 0.40e2 / 0.3e1 * t325 * t695 - 0.160e3 / 0.9e1 * t329 * t695
  t739 = -0.160e3 / 0.9e1 * t332 * t695 - 0.200e3 / 0.9e1 * t336 * t695 - 0.200e3 / 0.9e1 * t339 * t695 - 0.80e2 / 0.3e1 * t343 * t695 - 0.40e2 / 0.9e1 * t310 * t695 - 0.80e2 / 0.9e1 * t315 * t695 - 0.40e2 * t365 * t695 - 0.40e2 * t368 * t695 - 0.400e3 / 0.9e1 * t372 * t695 - 0.400e3 / 0.9e1 * t375 * t695 - 0.440e3 / 0.9e1 * t379 * t695 - 0.440e3 / 0.9e1 * t384 * t695 - 0.80e2 / 0.3e1 * t347 * t695
  t772 = t391 * t117
  t777 = t92 * t623 * t123
  t783 = -0.280e3 / 0.9e1 * t351 * t695 - 0.280e3 / 0.9e1 * t354 * t695 - 0.320e3 / 0.9e1 * t358 * t695 - 0.320e3 / 0.9e1 * t361 * t695 + 0.2800e4 / 0.9e1 * t155 * t144 * t159 * t624 + 0.6400e4 / 0.9e1 * t357 * t165 * t624 + 0.400e3 * t157 * t171 * t624 + 0.400e3 * t161 * t150 * t165 * t624 + 0.900e3 * t364 * t171 * t624 + 0.500e3 * t163 * t177 * t624 + 0.500e3 * t167 * t156 * t171 * t624 - 0.40e2 / 0.9e1 * t305 * t772 + 0.100e3 / 0.9e1 * t106 * t619 * t777 + 0.100e3 / 0.9e1 * t119 * t619 * t777
  t836 = 0.1000e4 / 0.9e1 * t198 * t126 * t141 * t624 + 0.2500e4 / 0.9e1 * t423 * t147 * t624 + 0.500e3 / 0.3e1 * t199 * t153 * t624 + 0.500e3 / 0.3e1 * t201 * t132 * t147 * t624 + 0.400e3 * t430 * t153 * t624 + 0.100e3 / 0.9e1 * t187 * t129 * t624 + 0.400e3 / 0.9e1 * t402 * t129 * t624 - 0.440e3 / 0.9e1 * t470 * t695 - 0.400e3 / 0.9e1 * t460 * t695 - 0.400e3 / 0.9e1 * t463 * t695 - 0.440e3 / 0.9e1 * t467 * t695 - 0.80e2 / 0.3e1 * t431 * t695 - 0.80e2 / 0.3e1 * t435 * t695
  t865 = -0.280e3 / 0.9e1 * t439 * t695 - 0.280e3 / 0.9e1 * t442 * t695 - 0.320e3 / 0.9e1 * t446 * t695 - 0.320e3 / 0.9e1 * t449 * t695 - 0.40e2 * t453 * t695 - 0.40e2 * t456 * t695 - 0.80e2 / 0.9e1 * t403 * t695 - 0.80e2 / 0.9e1 * t406 * t695 - 0.40e2 / 0.3e1 * t410 * t695 - 0.40e2 / 0.3e1 * t413 * t695 - 0.160e3 / 0.9e1 * t417 * t695 - 0.160e3 / 0.9e1 * t420 * t695 - 0.200e3 / 0.9e1 * t424 * t695 - 0.200e3 / 0.9e1 * t427 * t695
  t909 = -0.40e2 / 0.9e1 * t399 * t695 + 0.5500e4 / 0.9e1 * t214 * t383 * t624 + 0.5500e4 / 0.9e1 * t216 * t162 * t177 * t624 + 0.12100e5 / 0.9e1 * t466 * t383 * t624 + 0.2200e4 / 0.3e1 * t217 * t638 * t624 + 0.700e3 / 0.3e1 * t202 * t159 * t624 + 0.700e3 / 0.3e1 * t204 * t138 * t153 * t624 + 0.4900e4 / 0.9e1 * t438 * t159 * t624 + 0.2800e4 / 0.9e1 * t205 * t165 * t624 + 0.2800e4 / 0.9e1 * t207 * t144 * t159 * t624 + 0.6400e4 / 0.9e1 * t445 * t165 * t624 + 0.400e3 * t208 * t171 * t624 + 0.400e3 * t210 * t150 * t165 * t624
  t954 = 0.900e3 * t452 * t171 * t624 + 0.500e3 * t211 * t177 * t624 + 0.500e3 * t213 * t156 * t171 * t624 + 0.10000e5 / 0.9e1 * t459 * t177 * t624 + 0.100e3 / 0.3e1 * t190 * t135 * t624 + 0.100e3 / 0.3e1 * t192 * t114 * t129 * t624 + 0.100e3 * t409 * t135 * t624 + 0.200e3 / 0.3e1 * t193 * t141 * t624 + 0.200e3 / 0.3e1 * t195 * t120 * t135 * t624 + 0.1600e4 / 0.9e1 * t416 * t141 * t624 + 0.1000e4 / 0.9e1 * t196 * t147 * t624 - 0.40e2 / 0.9e1 * t396 * t772 + 0.100e3 / 0.9e1 * t186 * t619 * t777 + 0.100e3 / 0.9e1 * t189 * t619 * t777
  t963 = f.my_piecewise3(t2, 0, t18 * t112 * t84 * t221 / 0.12e2 - t18 * t21 * t288 * t221 / 0.4e1 - t18 * t85 * t476 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t19 * t584 * t221 - 0.3e1 / 0.4e1 * t18 * t289 * t476 - 0.3e1 / 0.8e1 * t18 * t293 * (-0.15381393735744000000000000000000000000000000000000e-2 / t294 / t101 * t107 * t596 * t598 * t92 * t603 * t179 + 0.57808982880000000000000000000000000000000000000000e-1 * t297 * t94 * t609 * t179 - 0.31532172480000000000000000000000000000000000000000e-1 * t297 * t94 * t300 * t388 + t104 * (t668 + t711 + t739 + t783) + 0.50297210791037951531778692272519433013260173754001e-1 * t390 * t93 * t609 * t392 - 0.68176681998511621219954093094822938202828301471506e-3 * t107 * t596 * t598 * t92 * t603 * t392 - 0.27434842249657064471879286694101508916323731138546e-1 * t390 * t391 * t182 * t474 + t184 * (t836 + t865 + t909 + t954)))
  v2rho2_0_ = 0.2e1 * r0 * t963 + 0.4e1 * t481
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t12 = t11 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t12, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = 9 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = t25 * t28 * f.p.cam_omega
  t33 = f.my_piecewise3(t12, t13, t15)
  t34 = 0.1e1 / t33
  t37 = t30 * t3 / t20 * t34 / 0.18e2
  t38 = 0.135e1 <= t37
  t39 = 0.135e1 < t37
  t40 = f.my_piecewise3(t39, t37, 0.135e1)
  t41 = t40 ** 2
  t44 = t41 ** 2
  t45 = 0.1e1 / t44
  t47 = t44 * t41
  t48 = 0.1e1 / t47
  t50 = t44 ** 2
  t51 = 0.1e1 / t50
  t54 = 0.1e1 / t50 / t41
  t57 = 0.1e1 / t50 / t44
  t60 = 0.1e1 / t50 / t47
  t62 = t50 ** 2
  t63 = 0.1e1 / t62
  t66 = f.my_piecewise3(t39, 0.135e1, t37)
  t67 = jnp.sqrt(jnp.pi)
  t68 = 0.1e1 / t66
  t70 = jnp.erf(t68 / 0.2e1)
  t72 = t66 ** 2
  t73 = 0.1e1 / t72
  t75 = jnp.exp(-t73 / 0.4e1)
  t76 = t75 - 0.1e1
  t79 = t75 - 0.3e1 / 0.2e1 - 0.2e1 * t72 * t76
  t82 = 0.2e1 * t66 * t79 + t67 * t70
  t86 = f.my_piecewise3(t38, 0.1e1 / t41 / 0.36e2 - t45 / 0.960e3 + t48 / 0.26880e5 - t51 / 0.829440e6 + t54 / 0.28385280e8 - t57 / 0.1073479680e10 + t60 / 0.44590694400e11 - t63 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t66 * t82)
  t87 = t23 * t86
  t88 = 6 ** (0.1e1 / 0.3e1)
  t89 = jnp.pi ** 2
  t90 = t89 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t92 = 0.1e1 / t91
  t93 = t88 * t92
  t94 = 2 ** (0.1e1 / 0.3e1)
  t95 = t94 ** 2
  t96 = s0 * t95
  t98 = t93 * t96 * t23
  t100 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t98
  t103 = 0.18040e1 - 0.64641600e0 / t100
  t105 = params.a[1]
  t106 = t88 ** 2
  t108 = 0.3e1 / 0.10e2 * t106 * t91
  t109 = tau0 * t95
  t111 = 0.1e1 / t21 / r0
  t112 = t109 * t111
  t113 = t108 - t112
  t114 = t105 * t113
  t115 = t108 + t112
  t116 = 0.1e1 / t115
  t118 = params.a[2]
  t119 = t113 ** 2
  t120 = t118 * t119
  t121 = t115 ** 2
  t122 = 0.1e1 / t121
  t124 = params.a[3]
  t125 = t119 * t113
  t126 = t124 * t125
  t127 = t121 * t115
  t128 = 0.1e1 / t127
  t130 = params.a[4]
  t131 = t119 ** 2
  t132 = t130 * t131
  t133 = t121 ** 2
  t134 = 0.1e1 / t133
  t136 = params.a[5]
  t137 = t131 * t113
  t138 = t136 * t137
  t139 = t133 * t115
  t140 = 0.1e1 / t139
  t142 = params.a[6]
  t143 = t131 * t119
  t144 = t142 * t143
  t145 = t133 * t121
  t146 = 0.1e1 / t145
  t148 = params.a[7]
  t149 = t131 * t125
  t150 = t148 * t149
  t151 = t133 * t127
  t152 = 0.1e1 / t151
  t154 = params.a[8]
  t155 = t131 ** 2
  t156 = t154 * t155
  t157 = t133 ** 2
  t158 = 0.1e1 / t157
  t160 = params.a[9]
  t161 = t155 * t113
  t162 = t160 * t161
  t164 = 0.1e1 / t157 / t115
  t166 = params.a[10]
  t167 = t155 * t119
  t168 = t166 * t167
  t170 = 0.1e1 / t157 / t121
  t172 = params.a[11]
  t173 = t155 * t125
  t174 = t172 * t173
  t176 = 0.1e1 / t157 / t127
  t178 = t114 * t116 + t120 * t122 + t126 * t128 + t132 * t134 + t138 * t140 + t144 * t146 + t150 * t152 + t156 * t158 + t162 * t164 + t168 * t170 + t174 * t176 + params.a[0]
  t181 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t98)
  t183 = 0.1552e1 - 0.552e0 * t181
  t185 = params.b[1]
  t186 = t185 * t113
  t188 = params.b[2]
  t189 = t188 * t119
  t191 = params.b[3]
  t192 = t191 * t125
  t194 = params.b[4]
  t195 = t194 * t131
  t197 = params.b[5]
  t198 = t197 * t137
  t200 = params.b[6]
  t201 = t200 * t143
  t203 = params.b[7]
  t204 = t203 * t149
  t206 = params.b[8]
  t207 = t206 * t155
  t209 = params.b[9]
  t210 = t209 * t161
  t212 = params.b[10]
  t213 = t212 * t167
  t215 = params.b[11]
  t216 = t215 * t173
  t218 = t186 * t116 + t189 * t122 + t192 * t128 + t195 * t134 + t198 * t140 + t201 * t146 + t204 * t152 + t207 * t158 + t210 * t164 + t213 * t170 + t216 * t176 + params.b[0]
  t220 = t103 * t178 + t183 * t218
  t224 = t41 * t40
  t225 = 0.1e1 / t224
  t231 = t30 * t3 / t20 / r0 * t34 / 0.54e2
  t232 = f.my_piecewise3(t39, -t231, 0)
  t235 = t44 * t40
  t236 = 0.1e1 / t235
  t239 = t44 * t224
  t240 = 0.1e1 / t239
  t244 = 0.1e1 / t50 / t40
  t248 = 0.1e1 / t50 / t224
  t252 = 0.1e1 / t50 / t235
  t256 = 0.1e1 / t50 / t239
  t260 = 0.1e1 / t62 / t40
  t264 = f.my_piecewise3(t39, 0, -t231)
  t266 = t75 * t73
  t270 = t72 * t66
  t271 = 0.1e1 / t270
  t275 = t66 * t76
  t280 = t271 * t264 * t75 / 0.2e1 - 0.4e1 * t275 * t264 - t68 * t264 * t75
  t283 = -t266 * t264 + 0.2e1 * t264 * t79 + 0.2e1 * t66 * t280
  t287 = f.my_piecewise3(t38, -t225 * t232 / 0.18e2 + t236 * t232 / 0.240e3 - t240 * t232 / 0.4480e4 + t244 * t232 / 0.103680e6 - t248 * t232 / 0.2838528e7 + t252 * t232 / 0.89456640e8 - t256 * t232 / 0.3185049600e10 + t260 * t232 / 0.126340300800e12, -0.8e1 / 0.3e1 * t264 * t82 - 0.8e1 / 0.3e1 * t66 * t283)
  t288 = t111 * t287
  t292 = t111 * t86
  t293 = t100 ** 2
  t296 = 0.1e1 / t293 * t88 * t92
  t297 = t19 * r0
  t299 = 0.1e1 / t21 / t297
  t304 = t105 * tau0
  t306 = t95 * t23 * t116
  t309 = t114 * t122
  t310 = t109 * t23
  t313 = t118 * t113
  t314 = t313 * t122
  t317 = t120 * t128
  t320 = t124 * t119
  t321 = t320 * t128
  t324 = t126 * t134
  t327 = t130 * t125
  t328 = t327 * t134
  t331 = t132 * t140
  t334 = t136 * t131
  t335 = t334 * t140
  t338 = t138 * t146
  t341 = t142 * t137
  t342 = t341 * t146
  t345 = 0.5e1 / 0.3e1 * t304 * t306 + 0.5e1 / 0.3e1 * t309 * t310 + 0.10e2 / 0.3e1 * t314 * t310 + 0.10e2 / 0.3e1 * t317 * t310 + 0.5e1 * t321 * t310 + 0.5e1 * t324 * t310 + 0.20e2 / 0.3e1 * t328 * t310 + 0.20e2 / 0.3e1 * t331 * t310 + 0.25e2 / 0.3e1 * t335 * t310 + 0.25e2 / 0.3e1 * t338 * t310 + 0.10e2 * t342 * t310
  t346 = t144 * t152
  t349 = t148 * t143
  t350 = t349 * t152
  t353 = t150 * t158
  t356 = t154 * t149
  t357 = t356 * t158
  t360 = t156 * t164
  t363 = t160 * t155
  t364 = t363 * t164
  t367 = t162 * t170
  t370 = t166 * t161
  t371 = t370 * t170
  t374 = t168 * t176
  t377 = t172 * t167
  t378 = t377 * t176
  t382 = 0.1e1 / t157 / t133
  t383 = t174 * t382
  t386 = 0.10e2 * t346 * t310 + 0.35e2 / 0.3e1 * t350 * t310 + 0.35e2 / 0.3e1 * t353 * t310 + 0.40e2 / 0.3e1 * t357 * t310 + 0.40e2 / 0.3e1 * t360 * t310 + 0.15e2 * t364 * t310 + 0.15e2 * t367 * t310 + 0.50e2 / 0.3e1 * t371 * t310 + 0.50e2 / 0.3e1 * t374 * t310 + 0.55e2 / 0.3e1 * t378 * t310 + 0.55e2 / 0.3e1 * t383 * t310
  t387 = t345 + t386
  t389 = t93 * s0
  t390 = t95 * t299
  t391 = t181 * t218
  t395 = t185 * tau0
  t398 = t186 * t122
  t401 = t188 * t113
  t402 = t401 * t122
  t405 = t189 * t128
  t408 = t191 * t119
  t409 = t408 * t128
  t412 = t192 * t134
  t415 = t194 * t125
  t416 = t415 * t134
  t419 = t195 * t140
  t422 = t197 * t131
  t423 = t422 * t140
  t426 = t198 * t146
  t429 = t200 * t137
  t430 = t429 * t146
  t433 = 0.5e1 / 0.3e1 * t395 * t306 + 0.5e1 / 0.3e1 * t398 * t310 + 0.10e2 / 0.3e1 * t402 * t310 + 0.10e2 / 0.3e1 * t405 * t310 + 0.5e1 * t409 * t310 + 0.5e1 * t412 * t310 + 0.20e2 / 0.3e1 * t416 * t310 + 0.20e2 / 0.3e1 * t419 * t310 + 0.25e2 / 0.3e1 * t423 * t310 + 0.25e2 / 0.3e1 * t426 * t310 + 0.10e2 * t430 * t310
  t434 = t201 * t152
  t437 = t203 * t143
  t438 = t437 * t152
  t441 = t204 * t158
  t444 = t206 * t149
  t445 = t444 * t158
  t448 = t207 * t164
  t451 = t209 * t155
  t452 = t451 * t164
  t455 = t210 * t170
  t458 = t212 * t161
  t459 = t458 * t170
  t462 = t213 * t176
  t465 = t215 * t167
  t466 = t465 * t176
  t469 = t216 * t382
  t472 = 0.10e2 * t434 * t310 + 0.35e2 / 0.3e1 * t438 * t310 + 0.35e2 / 0.3e1 * t441 * t310 + 0.40e2 / 0.3e1 * t445 * t310 + 0.40e2 / 0.3e1 * t448 * t310 + 0.15e2 * t452 * t310 + 0.15e2 * t455 * t310 + 0.50e2 / 0.3e1 * t459 * t310 + 0.50e2 / 0.3e1 * t462 * t310 + 0.55e2 / 0.3e1 * t466 * t310 + 0.55e2 / 0.3e1 * t469 * t310
  t473 = t433 + t472
  t475 = -0.15766086240000000000000000000000000000000000000000e-1 * t296 * t96 * t299 * t178 + t103 * t387 - 0.13717421124828532235939643347050754458161865569273e-1 * t389 * t390 * t391 + t183 * t473
  t479 = 0.1e1 / t21
  t480 = t232 ** 2
  t488 = 0.2e1 / 0.81e2 * t30 * t3 / t20 / t19 * t34
  t489 = f.my_piecewise3(t39, t488, 0)
  t517 = 0.1e1 / t62 / t41
  t522 = t45 * t480 / 0.6e1 - t225 * t489 / 0.18e2 - t48 * t480 / 0.48e2 + t236 * t489 / 0.240e3 + t51 * t480 / 0.640e3 - t240 * t489 / 0.4480e4 - t54 * t480 / 0.11520e5 + t244 * t489 / 0.103680e6 + t57 * t480 / 0.258048e6 - t248 * t489 / 0.2838528e7 - t60 * t480 / 0.6881280e7 + t252 * t489 / 0.89456640e8 + t63 * t480 / 0.212336640e9 - t256 * t489 / 0.3185049600e10 - t517 * t480 / 0.7431782400e10 + t260 * t489 / 0.126340300800e12
  t523 = f.my_piecewise3(t39, 0, t488)
  t528 = t72 ** 2
  t530 = 0.1e1 / t528 / t66
  t531 = t264 ** 2
  t532 = t530 * t531
  t535 = t75 * t271
  t543 = 0.1e1 / t528
  t551 = 0.1e1 / t528 / t72
  t552 = t551 * t531
  t563 = -0.2e1 * t543 * t531 * t75 + t271 * t523 * t75 / 0.2e1 + t552 * t75 / 0.4e1 - 0.4e1 * t531 * t76 - t73 * t531 * t75 - 0.4e1 * t275 * t523 - t68 * t523 * t75
  t566 = -t532 * t75 / 0.2e1 + 0.2e1 * t535 * t531 - t266 * t523 + 0.2e1 * t523 * t79 + 0.4e1 * t264 * t280 + 0.2e1 * t66 * t563
  t570 = f.my_piecewise3(t38, t522, -0.8e1 / 0.3e1 * t523 * t82 - 0.16e2 / 0.3e1 * t264 * t283 - 0.8e1 / 0.3e1 * t66 * t566)
  t571 = t479 * t570
  t575 = t479 * t287
  t579 = t479 * t86
  t584 = 0.1e1 / t90 / t89
  t585 = 0.1e1 / t293 / t100 * t106 * t584
  t586 = s0 ** 2
  t587 = t586 * t94
  t588 = t19 ** 2
  t591 = 0.1e1 / t20 / t588 / t297
  t597 = 0.1e1 / t21 / t588
  t606 = t130 * t119
  t607 = t606 * t134
  t608 = tau0 ** 2
  t609 = t608 * t94
  t610 = t588 * r0
  t612 = 0.1e1 / t20 / t610
  t613 = t609 * t612
  t616 = t327 * t140
  t619 = t132 * t146
  t622 = t136 * t125
  t623 = t622 * t140
  t626 = t334 * t146
  t629 = t138 * t152
  t632 = t142 * t131
  t633 = t632 * t146
  t636 = t341 * t152
  t639 = t144 * t158
  t642 = t148 * t137
  t643 = t642 * t152
  t646 = t349 * t158
  t649 = t150 * t164
  t652 = t114 * t128
  t655 = 0.200e3 / 0.3e1 * t607 * t613 + 0.1600e4 / 0.9e1 * t616 * t613 + 0.1000e4 / 0.9e1 * t619 * t613 + 0.1000e4 / 0.9e1 * t623 * t613 + 0.2500e4 / 0.9e1 * t626 * t613 + 0.500e3 / 0.3e1 * t629 * t613 + 0.500e3 / 0.3e1 * t633 * t613 + 0.400e3 * t636 * t613 + 0.700e3 / 0.3e1 * t639 * t613 + 0.700e3 / 0.3e1 * t643 * t613 + 0.4900e4 / 0.9e1 * t646 * t613 + 0.2800e4 / 0.9e1 * t649 * t613 + 0.100e3 / 0.9e1 * t652 * t613
  t656 = t313 * t128
  t659 = t120 * t134
  t662 = t124 * t113
  t663 = t662 * t128
  t666 = t320 * t134
  t669 = t126 * t140
  t672 = t109 * t299
  t691 = 0.400e3 / 0.9e1 * t656 * t613 + 0.100e3 / 0.3e1 * t659 * t613 + 0.100e3 / 0.3e1 * t663 * t613 + 0.100e3 * t666 * t613 + 0.200e3 / 0.3e1 * t669 * t613 - 0.80e2 / 0.9e1 * t317 * t672 - 0.40e2 / 0.3e1 * t321 * t672 - 0.40e2 / 0.3e1 * t324 * t672 - 0.160e3 / 0.9e1 * t328 * t672 - 0.160e3 / 0.9e1 * t331 * t672 - 0.200e3 / 0.9e1 * t335 * t672 - 0.200e3 / 0.9e1 * t338 * t672 - 0.80e2 / 0.3e1 * t342 * t672 - 0.40e2 / 0.9e1 * t309 * t672
  t717 = t390 * t116
  t720 = -0.80e2 / 0.9e1 * t314 * t672 - 0.40e2 * t364 * t672 - 0.40e2 * t367 * t672 - 0.400e3 / 0.9e1 * t371 * t672 - 0.400e3 / 0.9e1 * t374 * t672 - 0.440e3 / 0.9e1 * t378 * t672 - 0.440e3 / 0.9e1 * t383 * t672 - 0.80e2 / 0.3e1 * t346 * t672 - 0.280e3 / 0.9e1 * t350 * t672 - 0.280e3 / 0.9e1 * t353 * t672 - 0.320e3 / 0.9e1 * t357 * t672 - 0.320e3 / 0.9e1 * t360 * t672 - 0.40e2 / 0.9e1 * t304 * t717
  t721 = t105 * t608
  t723 = t94 * t612 * t122
  t726 = t118 * t608
  t729 = t370 * t176
  t732 = t168 * t382
  t735 = t172 * t161
  t736 = t735 * t176
  t739 = t377 * t382
  t743 = 0.1e1 / t157 / t139
  t744 = t174 * t743
  t747 = t154 * t143
  t748 = t747 * t158
  t751 = t356 * t164
  t754 = t156 * t170
  t757 = t160 * t149
  t758 = t757 * t164
  t761 = t363 * t170
  t764 = t162 * t176
  t767 = t166 * t155
  t768 = t767 * t170
  t771 = 0.100e3 / 0.9e1 * t721 * t723 + 0.100e3 / 0.9e1 * t726 * t723 + 0.10000e5 / 0.9e1 * t729 * t613 + 0.5500e4 / 0.9e1 * t732 * t613 + 0.5500e4 / 0.9e1 * t736 * t613 + 0.12100e5 / 0.9e1 * t739 * t613 + 0.2200e4 / 0.3e1 * t744 * t613 + 0.2800e4 / 0.9e1 * t748 * t613 + 0.6400e4 / 0.9e1 * t751 * t613 + 0.400e3 * t754 * t613 + 0.400e3 * t758 * t613 + 0.900e3 * t761 * t613 + 0.500e3 * t764 * t613 + 0.500e3 * t768 * t613
  t773 = t655 + t691 + t720 + t771
  t775 = t95 * t597
  t780 = t106 * t584 * t586
  t781 = t94 * t591
  t785 = t181 * t473
  t791 = t185 * t608
  t794 = t188 * t608
  t797 = t210 * t176
  t800 = t212 * t155
  t801 = t800 * t170
  t804 = t189 * t134
  t807 = t191 * t113
  t808 = t807 * t128
  t811 = t408 * t134
  t814 = t192 * t140
  t817 = t200 * t131
  t818 = t817 * t146
  t821 = t429 * t152
  t824 = t186 * t128
  t827 = t401 * t128
  t830 = -0.40e2 / 0.9e1 * t395 * t717 + 0.100e3 / 0.9e1 * t791 * t723 + 0.100e3 / 0.9e1 * t794 * t723 + 0.500e3 * t797 * t613 + 0.500e3 * t801 * t613 + 0.100e3 / 0.3e1 * t804 * t613 + 0.100e3 / 0.3e1 * t808 * t613 + 0.100e3 * t811 * t613 + 0.200e3 / 0.3e1 * t814 * t613 + 0.500e3 / 0.3e1 * t818 * t613 + 0.400e3 * t821 * t613 + 0.100e3 / 0.9e1 * t824 * t613 + 0.400e3 / 0.9e1 * t827 * t613
  t859 = -0.440e3 / 0.9e1 * t469 * t672 - 0.400e3 / 0.9e1 * t459 * t672 - 0.400e3 / 0.9e1 * t462 * t672 - 0.440e3 / 0.9e1 * t466 * t672 - 0.80e2 / 0.3e1 * t430 * t672 - 0.80e2 / 0.3e1 * t434 * t672 - 0.280e3 / 0.9e1 * t438 * t672 - 0.280e3 / 0.9e1 * t441 * t672 - 0.320e3 / 0.9e1 * t445 * t672 - 0.320e3 / 0.9e1 * t448 * t672 - 0.40e2 * t452 * t672 - 0.40e2 * t455 * t672 - 0.80e2 / 0.9e1 * t402 * t672 - 0.80e2 / 0.9e1 * t405 * t672
  t875 = t458 * t176
  t878 = t213 * t382
  t881 = t215 * t161
  t882 = t881 * t176
  t885 = t465 * t382
  t888 = t216 * t743
  t891 = t201 * t158
  t894 = -0.40e2 / 0.3e1 * t409 * t672 - 0.40e2 / 0.3e1 * t412 * t672 - 0.160e3 / 0.9e1 * t416 * t672 - 0.160e3 / 0.9e1 * t419 * t672 - 0.200e3 / 0.9e1 * t423 * t672 - 0.200e3 / 0.9e1 * t426 * t672 - 0.40e2 / 0.9e1 * t398 * t672 + 0.10000e5 / 0.9e1 * t875 * t613 + 0.5500e4 / 0.9e1 * t878 * t613 + 0.5500e4 / 0.9e1 * t882 * t613 + 0.12100e5 / 0.9e1 * t885 * t613 + 0.2200e4 / 0.3e1 * t888 * t613 + 0.700e3 / 0.3e1 * t891 * t613
  t895 = t203 * t137
  t896 = t895 * t152
  t899 = t437 * t158
  t902 = t204 * t164
  t905 = t206 * t143
  t906 = t905 * t158
  t909 = t444 * t164
  t912 = t207 * t170
  t915 = t209 * t149
  t916 = t915 * t164
  t919 = t451 * t170
  t922 = t194 * t119
  t923 = t922 * t134
  t926 = t415 * t140
  t929 = t195 * t146
  t932 = t197 * t125
  t933 = t932 * t140
  t936 = t422 * t146
  t939 = t198 * t152
  t942 = 0.700e3 / 0.3e1 * t896 * t613 + 0.4900e4 / 0.9e1 * t899 * t613 + 0.2800e4 / 0.9e1 * t902 * t613 + 0.2800e4 / 0.9e1 * t906 * t613 + 0.6400e4 / 0.9e1 * t909 * t613 + 0.400e3 * t912 * t613 + 0.400e3 * t916 * t613 + 0.900e3 * t919 * t613 + 0.200e3 / 0.3e1 * t923 * t613 + 0.1600e4 / 0.9e1 * t926 * t613 + 0.1000e4 / 0.9e1 * t929 * t613 + 0.1000e4 / 0.9e1 * t933 * t613 + 0.2500e4 / 0.9e1 * t936 * t613 + 0.500e3 / 0.3e1 * t939 * t613
  t944 = t830 + t859 + t894 + t942
  t946 = -0.15381393735744000000000000000000000000000000000000e-2 * t585 * t587 * t591 * t178 + 0.57808982880000000000000000000000000000000000000000e-1 * t296 * t96 * t597 * t178 - 0.31532172480000000000000000000000000000000000000000e-1 * t296 * t96 * t299 * t387 + t103 * t773 + 0.50297210791037951531778692272519433013260173754001e-1 * t389 * t775 * t391 - 0.68176681998511621219954093094822938202828301471506e-3 * t780 * t781 * t391 - 0.27434842249657064471879286694101508916323731138546e-1 * t389 * t390 * t785 + t183 * t944
  t950 = t480 * t232
  t953 = t45 * t232
  t958 = t48 * t232
  t963 = t51 * t232
  t968 = t54 * t232
  t973 = t57 * t232
  t978 = t60 * t232
  t981 = -0.2e1 / 0.3e1 * t236 * t950 + t953 * t489 / 0.2e1 + t240 * t950 / 0.8e1 - t958 * t489 / 0.16e2 - t244 * t950 / 0.80e2 + 0.3e1 / 0.640e3 * t963 * t489 + t248 * t950 / 0.1152e4 - t968 * t489 / 0.3840e4 - t252 * t950 / 0.21504e5 + t973 * t489 / 0.86016e5 + t256 * t950 / 0.491520e6 - t978 * t489 / 0.2293760e7
  t984 = t63 * t232
  t988 = 0.1e1 / t62 / t224
  t991 = t517 * t232
  t999 = 0.14e2 / 0.243e3 * t30 * t3 / t20 / t297 * t34
  t1000 = f.my_piecewise3(t39, -t999, 0)
  t1017 = -t260 * t950 / 0.13271040e8 + t984 * t489 / 0.70778880e8 + t988 * t950 / 0.412876800e9 - t991 * t489 / 0.2477260800e10 - t225 * t1000 / 0.18e2 + t236 * t1000 / 0.240e3 - t240 * t1000 / 0.4480e4 + t244 * t1000 / 0.103680e6 - t248 * t1000 / 0.2838528e7 + t252 * t1000 / 0.89456640e8 - t256 * t1000 / 0.3185049600e10 + t260 * t1000 / 0.126340300800e12
  t1019 = f.my_piecewise3(t39, 0, -t999)
  t1026 = t531 * t264
  t1030 = t530 * t264
  t1031 = t75 * t523
  t1034 = t528 ** 2
  t1035 = 0.1e1 / t1034
  t1039 = t75 * t543
  t1055 = t543 * t264
  t1059 = 0.1e1 / t528 / t270
  t1067 = t264 * t75
  t1071 = 0.1e1 / t1034 / t66
  t1075 = t264 * t76
  t1078 = t73 * t264
  t1085 = 0.15e2 / 0.2e1 * t530 * t1026 * t75 - 0.6e1 * t1055 * t1031 - 0.5e1 / 0.2e1 * t1059 * t1026 * t75 + t271 * t1019 * t75 / 0.2e1 + 0.3e1 / 0.4e1 * t551 * t523 * t1067 + t1071 * t1026 * t75 / 0.8e1 - 0.12e2 * t1075 * t523 - 0.3e1 * t1078 * t1031 - 0.4e1 * t275 * t1019 - t68 * t1019 * t75
  t1088 = 0.7e1 / 0.2e1 * t551 * t1026 * t75 - 0.3e1 / 0.2e1 * t1030 * t1031 - t1035 * t1026 * t75 / 0.4e1 - 0.6e1 * t1039 * t1026 + 0.6e1 * t535 * t264 * t523 - t266 * t1019 + 0.2e1 * t1019 * t79 + 0.6e1 * t523 * t280 + 0.6e1 * t264 * t563 + 0.2e1 * t66 * t1085
  t1092 = f.my_piecewise3(t38, t981 + t1017, -0.8e1 / 0.3e1 * t1019 * t82 - 0.8e1 * t523 * t283 - 0.8e1 * t264 * t566 - 0.8e1 / 0.3e1 * t66 * t1088)
  t1093 = t20 * t1092
  t1097 = t20 * t570
  t1101 = t20 * t287
  t1105 = t20 * t86
  t1106 = t293 ** 2
  t1108 = t89 ** 2
  t1109 = 0.1e1 / t1108
  t1110 = 0.1e1 / t1106 * t1109
  t1111 = t586 * s0
  t1112 = t588 ** 2
  t1114 = 0.1e1 / t1112 / t297
  t1115 = t1111 * t1114
  t1120 = 0.1e1 / t20 / t1112
  t1130 = 0.1e1 / t21 / t610
  t1143 = t608 * tau0
  t1144 = t105 * t1143
  t1145 = 0.1e1 / t1112
  t1146 = t1145 * t128
  t1149 = t118 * t1143
  t1152 = t124 * t1143
  t1155 = t109 * t597
  t1172 = 0.1000e4 / 0.9e1 * t1144 * t1146 + 0.2000e4 / 0.9e1 * t1149 * t1146 + 0.1000e4 / 0.9e1 * t1152 * t1146 + 0.3520e4 / 0.27e2 * t360 * t1155 + 0.880e3 / 0.27e2 * t314 * t1155 + 0.440e3 / 0.3e1 * t364 * t1155 + 0.440e3 / 0.3e1 * t367 * t1155 + 0.4400e4 / 0.27e2 * t371 * t1155 + 0.4400e4 / 0.27e2 * t374 * t1155 + 0.4840e4 / 0.27e2 * t378 * t1155 + 0.4840e4 / 0.27e2 * t383 * t1155
  t1193 = t588 * t19
  t1195 = 0.1e1 / t20 / t1193
  t1196 = t609 * t1195
  t1201 = 0.880e3 / 0.9e1 * t346 * t1155 + 0.880e3 / 0.27e2 * t317 * t1155 + 0.440e3 / 0.9e1 * t321 * t1155 + 0.440e3 / 0.9e1 * t324 * t1155 + 0.1760e4 / 0.27e2 * t328 * t1155 + 0.1760e4 / 0.27e2 * t331 * t1155 + 0.2200e4 / 0.27e2 * t335 * t1155 + 0.2200e4 / 0.27e2 * t338 * t1155 + 0.880e3 / 0.9e1 * t342 * t1155 + 0.440e3 / 0.27e2 * t309 * t1155 - 0.22400e5 / 0.9e1 * t649 * t1196 - 0.800e3 / 0.9e1 * t652 * t1196
  t1227 = -0.3200e4 / 0.9e1 * t656 * t1196 - 0.800e3 / 0.3e1 * t659 * t1196 - 0.800e3 / 0.3e1 * t663 * t1196 - 0.800e3 * t666 * t1196 - 0.1600e4 / 0.3e1 * t669 * t1196 - 0.5600e4 / 0.3e1 * t639 * t1196 - 0.5600e4 / 0.3e1 * t643 * t1196 - 0.39200e5 / 0.9e1 * t646 * t1196 - 0.22400e5 / 0.9e1 * t748 * t1196 - 0.51200e5 / 0.9e1 * t751 * t1196 - 0.3200e4 * t754 * t1196 - 0.3200e4 * t758 * t1196
  t1252 = -0.7200e4 * t761 * t1196 - 0.4000e4 * t764 * t1196 - 0.4000e4 * t768 * t1196 - 0.80000e5 / 0.9e1 * t729 * t1196 - 0.44000e5 / 0.9e1 * t732 * t1196 - 0.44000e5 / 0.9e1 * t736 * t1196 - 0.96800e5 / 0.9e1 * t739 * t1196 - 0.17600e5 / 0.3e1 * t744 * t1196 - 0.1600e4 / 0.3e1 * t607 * t1196 - 0.12800e5 / 0.9e1 * t616 * t1196 - 0.8000e4 / 0.9e1 * t619 * t1196 - 0.8000e4 / 0.9e1 * t623 * t1196
  t1269 = t134 * t1143
  t1270 = t1269 * t1145
  t1273 = t140 * t1143
  t1274 = t1273 * t1145
  t1277 = t146 * t1143
  t1278 = t1277 * t1145
  t1282 = t94 * t1195 * t122
  t1287 = -0.20000e5 / 0.9e1 * t626 * t1196 - 0.4000e4 / 0.3e1 * t629 * t1196 - 0.4000e4 / 0.3e1 * t633 * t1196 - 0.3200e4 * t636 * t1196 + 0.3080e4 / 0.27e2 * t350 * t1155 + 0.3080e4 / 0.27e2 * t353 * t1155 + 0.3520e4 / 0.27e2 * t357 * t1155 + 0.1000e4 * t662 * t1270 + 0.2000e4 * t320 * t1274 + 0.10000e5 / 0.9e1 * t126 * t1278 - 0.800e3 / 0.9e1 * t721 * t1282 - 0.800e3 / 0.9e1 * t726 * t1282
  t1288 = t743 * t1143
  t1289 = t1288 * t1145
  t1293 = 0.1e1 / t157 / t145
  t1294 = t1293 * t1143
  t1295 = t1294 * t1145
  t1298 = t154 * t137
  t1299 = t158 * t1143
  t1300 = t1299 * t1145
  t1303 = t164 * t1143
  t1304 = t1303 * t1145
  t1307 = t170 * t1143
  t1308 = t1307 * t1145
  t1311 = t176 * t1143
  t1312 = t1311 * t1145
  t1315 = t160 * t143
  t1322 = t382 * t1143
  t1323 = t1322 * t1145
  t1326 = t166 * t149
  t1331 = 0.242000e6 / 0.3e1 * t377 * t1289 + 0.286000e6 / 0.9e1 * t174 * t1295 + 0.56000e5 / 0.9e1 * t1298 * t1300 + 0.224000e6 / 0.9e1 * t747 * t1304 + 0.32000e5 * t356 * t1308 + 0.40000e5 / 0.3e1 * t156 * t1312 + 0.28000e5 / 0.3e1 * t1315 * t1304 + 0.36000e5 * t757 * t1308 + 0.45000e5 * t363 * t1312 + 0.55000e5 / 0.3e1 * t162 * t1323 + 0.40000e5 / 0.3e1 * t1326 * t1308 + 0.50000e5 * t767 * t1312
  t1337 = t172 * t155
  t1342 = t775 * t116
  t1345 = t130 * t113
  t1352 = t152 * t1143
  t1353 = t1352 * t1145
  t1356 = t136 * t119
  t1363 = 0.550000e6 / 0.9e1 * t370 * t1323 + 0.220000e6 / 0.9e1 * t168 * t1289 + 0.55000e5 / 0.3e1 * t1337 * t1312 + 0.605000e6 / 0.9e1 * t735 * t1323 + 0.440e3 / 0.27e2 * t304 * t1342 + 0.4000e4 / 0.9e1 * t1345 * t1270 + 0.8000e4 / 0.3e1 * t606 * t1274 + 0.40000e5 / 0.9e1 * t327 * t1278 + 0.20000e5 / 0.9e1 * t132 * t1353 + 0.10000e5 / 0.9e1 * t1356 * t1274 + 0.50000e5 / 0.9e1 * t622 * t1278 + 0.25000e5 / 0.3e1 * t334 * t1353
  t1366 = t142 * t125
  t1375 = t148 * t131
  t1390 = 0.35000e5 / 0.9e1 * t138 * t1300 + 0.20000e5 / 0.9e1 * t1366 * t1278 + 0.10000e5 * t632 * t1353 + 0.14000e5 * t341 * t1300 + 0.56000e5 / 0.9e1 * t144 * t1304 + 0.35000e5 / 0.9e1 * t1375 * t1353 + 0.49000e5 / 0.3e1 * t642 * t1300 + 0.196000e6 / 0.9e1 * t349 * t1304 + 0.28000e5 / 0.3e1 * t150 * t1308 + 0.1000e4 / 0.9e1 * t114 * t1270 + 0.2000e4 / 0.3e1 * t313 * t1270 + 0.4000e4 / 0.9e1 * t120 * t1274
  t1393 = t1172 + t1201 + t1227 + t1252 + t1287 + t1331 + t1363 + t1390
  t1395 = t95 * t1130
  t1399 = t94 * t1120
  t1406 = t1109 * t1111
  t1407 = t1114 * t181
  t1414 = t181 * t944
  t1420 = t209 * t143
  t1429 = t212 * t149
  t1440 = t194 * t113
  t1443 = 0.40000e5 / 0.3e1 * t207 * t1312 + 0.28000e5 / 0.3e1 * t1420 * t1304 + 0.36000e5 * t915 * t1308 + 0.45000e5 * t451 * t1312 + 0.55000e5 / 0.3e1 * t210 * t1323 + 0.40000e5 / 0.3e1 * t1429 * t1308 + 0.4000e4 / 0.9e1 * t189 * t1274 + 0.1000e4 * t807 * t1270 + 0.2000e4 * t408 * t1274 + 0.10000e5 / 0.9e1 * t192 * t1278 + 0.4000e4 / 0.9e1 * t1440 * t1270
  t1446 = t200 * t125
  t1467 = t197 * t119
  t1470 = 0.8000e4 / 0.3e1 * t922 * t1274 + 0.20000e5 / 0.9e1 * t1446 * t1278 + 0.10000e5 * t817 * t1353 + 0.14000e5 * t429 * t1300 + 0.1000e4 / 0.9e1 * t186 * t1270 + 0.2000e4 / 0.3e1 * t401 * t1270 - 0.800e3 / 0.9e1 * t791 * t1282 + 0.440e3 / 0.27e2 * t395 * t1342 - 0.800e3 / 0.9e1 * t794 * t1282 + 0.40000e5 / 0.9e1 * t415 * t1278 + 0.20000e5 / 0.9e1 * t195 * t1353 + 0.10000e5 / 0.9e1 * t1467 * t1274
  t1484 = t215 * t155
  t1495 = t203 * t131
  t1498 = 0.50000e5 / 0.9e1 * t932 * t1278 + 0.25000e5 / 0.3e1 * t422 * t1353 + 0.35000e5 / 0.9e1 * t198 * t1300 + 0.50000e5 * t800 * t1312 + 0.550000e6 / 0.9e1 * t458 * t1323 + 0.220000e6 / 0.9e1 * t213 * t1289 + 0.55000e5 / 0.3e1 * t1484 * t1312 + 0.605000e6 / 0.9e1 * t881 * t1323 + 0.242000e6 / 0.3e1 * t465 * t1289 + 0.286000e6 / 0.9e1 * t216 * t1295 + 0.56000e5 / 0.9e1 * t201 * t1304 + 0.35000e5 / 0.9e1 * t1495 * t1353
  t1505 = t206 * t137
  t1524 = 0.49000e5 / 0.3e1 * t895 * t1300 + 0.196000e6 / 0.9e1 * t437 * t1304 + 0.28000e5 / 0.3e1 * t204 * t1308 + 0.56000e5 / 0.9e1 * t1505 * t1300 + 0.224000e6 / 0.9e1 * t905 * t1304 + 0.32000e5 * t444 * t1308 - 0.4000e4 / 0.3e1 * t939 * t1196 - 0.5600e4 / 0.3e1 * t896 * t1196 - 0.39200e5 / 0.9e1 * t899 * t1196 - 0.22400e5 / 0.9e1 * t902 * t1196 - 0.22400e5 / 0.9e1 * t906 * t1196 - 0.51200e5 / 0.9e1 * t909 * t1196
  t1551 = -0.3200e4 * t912 * t1196 - 0.3200e4 * t916 * t1196 - 0.7200e4 * t919 * t1196 - 0.4000e4 * t797 * t1196 - 0.800e3 / 0.3e1 * t804 * t1196 - 0.96800e5 / 0.9e1 * t885 * t1196 - 0.17600e5 / 0.3e1 * t888 * t1196 - 0.4000e4 * t801 * t1196 - 0.80000e5 / 0.9e1 * t875 * t1196 - 0.44000e5 / 0.9e1 * t878 * t1196 - 0.44000e5 / 0.9e1 * t882 * t1196 - 0.5600e4 / 0.3e1 * t891 * t1196
  t1576 = 0.2200e4 / 0.27e2 * t426 * t1155 + 0.440e3 / 0.27e2 * t398 * t1155 + 0.440e3 / 0.3e1 * t455 * t1155 + 0.880e3 / 0.27e2 * t402 * t1155 + 0.880e3 / 0.27e2 * t405 * t1155 + 0.440e3 / 0.9e1 * t409 * t1155 - 0.4000e4 / 0.3e1 * t818 * t1196 - 0.3200e4 * t821 * t1196 - 0.800e3 / 0.9e1 * t824 * t1196 - 0.3200e4 / 0.9e1 * t827 * t1196 + 0.4840e4 / 0.27e2 * t469 * t1155 + 0.4400e4 / 0.27e2 * t459 * t1155
  t1602 = 0.440e3 / 0.9e1 * t412 * t1155 + 0.1760e4 / 0.27e2 * t416 * t1155 + 0.1760e4 / 0.27e2 * t419 * t1155 + 0.2200e4 / 0.27e2 * t423 * t1155 + 0.4400e4 / 0.27e2 * t462 * t1155 + 0.4840e4 / 0.27e2 * t466 * t1155 + 0.880e3 / 0.9e1 * t430 * t1155 + 0.880e3 / 0.9e1 * t434 * t1155 + 0.3080e4 / 0.27e2 * t438 * t1155 + 0.3080e4 / 0.27e2 * t441 * t1155 + 0.3520e4 / 0.27e2 * t445 * t1155 + 0.3520e4 / 0.27e2 * t448 * t1155
  t1621 = t188 * t1143
  t1624 = t191 * t1143
  t1627 = t185 * t1143
  t1630 = 0.440e3 / 0.3e1 * t452 * t1155 - 0.800e3 / 0.3e1 * t808 * t1196 - 0.800e3 * t811 * t1196 - 0.1600e4 / 0.3e1 * t814 * t1196 - 0.1600e4 / 0.3e1 * t923 * t1196 - 0.12800e5 / 0.9e1 * t926 * t1196 - 0.8000e4 / 0.9e1 * t929 * t1196 - 0.8000e4 / 0.9e1 * t933 * t1196 - 0.20000e5 / 0.9e1 * t936 * t1196 + 0.2000e4 / 0.9e1 * t1621 * t1146 + 0.1000e4 / 0.9e1 * t1624 * t1146 + 0.1000e4 / 0.9e1 * t1627 * t1146
  t1633 = t1443 + t1470 + t1498 + t1524 + t1551 + t1576 + t1602 + t1630
  t1635 = -0.13505478955732661760000000000000000000000000000000e-2 * t1110 * t1115 * t178 + 0.16919533109318400000000000000000000000000000000000e-1 * t585 * t587 * t1120 * t178 - 0.46144181207232000000000000000000000000000000000000e-2 * t585 * t587 * t591 * t387 - 0.26977525344000000000000000000000000000000000000000e0 * t296 * t96 * t1130 * t178 + 0.17342694864000000000000000000000000000000000000000e0 * t296 * t96 * t597 * t387 - 0.47298258720000000000000000000000000000000000000000e-1 * t296 * t96 * t299 * t773 + t103 * t1393 - 0.23472031702484377381496723060509068739521414418534e0 * t389 * t1395 * t391 + 0.74994350198362783341949502404305232023111131618657e-2 * t780 * t1399 * t391 + 0.15089163237311385459533607681755829903978052126200e0 * t389 * t775 * t785 - 0.20330614301458704962114299843389675613654291605984e-3 * t1406 * t1407 * t218 - 0.20453004599553486365986227928446881460848490441452e-2 * t780 * t781 * t785 - 0.41152263374485596707818930041152263374485596707819e-1 * t389 * t390 * t1414 + t183 * t1633
  t1640 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t87 * t220 + t18 * t288 * t220 / 0.4e1 + t18 * t292 * t475 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t571 * t220 - 0.3e1 / 0.4e1 * t18 * t575 * t475 - 0.3e1 / 0.8e1 * t18 * t579 * t946 - 0.3e1 / 0.8e1 * t18 * t1093 * t220 - 0.9e1 / 0.8e1 * t18 * t1097 * t475 - 0.9e1 / 0.8e1 * t18 * t1101 * t946 - 0.3e1 / 0.8e1 * t18 * t1105 * t1635)
  t1714 = t480 ** 2
  t1717 = t489 ** 2
  t1724 = -0.4e1 * t236 * t480 * t489 + 0.2e1 / 0.3e1 * t953 * t1000 + 0.3e1 / 0.4e1 * t240 * t480 * t489 - t958 * t1000 / 0.12e2 - 0.3e1 / 0.40e2 * t244 * t480 * t489 + t963 * t1000 / 0.160e3 + t248 * t480 * t489 / 0.192e3 - t968 * t1000 / 0.2880e4 - t252 * t480 * t489 / 0.3584e4 + t973 * t1000 / 0.64512e5 + t256 * t480 * t489 / 0.81920e5 - t978 * t1000 / 0.1720320e7 - t260 * t480 * t489 / 0.2211840e7 + t984 * t1000 / 0.53084160e8 + t988 * t480 * t489 / 0.68812800e8 - t991 * t1000 / 0.1857945600e10 + 0.9e1 / 0.80e2 * t54 * t1714 + 0.3e1 / 0.640e3 * t51 * t1717 - 0.11e2 / 0.1152e4 * t57 * t1714 - t54 * t1717 / 0.3840e4
  t1748 = 0.140e3 / 0.729e3 * t30 * t3 / t20 / t588 * t34
  t1749 = f.my_piecewise3(t39, t1748, 0)
  t1774 = 0.13e2 / 0.21504e5 * t60 * t1714 + t57 * t1717 / 0.86016e5 - t63 * t1714 / 0.32768e5 - t60 * t1717 / 0.2293760e7 + 0.17e2 / 0.13271040e8 * t517 * t1714 + t63 * t1717 / 0.70778880e8 - 0.19e2 / 0.412876800e9 / t62 / t44 * t1714 - t517 * t1717 / 0.2477260800e10 - t225 * t1749 / 0.18e2 + t236 * t1749 / 0.240e3 - t240 * t1749 / 0.4480e4 + t244 * t1749 / 0.103680e6 - t248 * t1749 / 0.2838528e7 + t252 * t1749 / 0.89456640e8 - t256 * t1749 / 0.3185049600e10 + t260 * t1749 / 0.126340300800e12 + 0.10e2 / 0.3e1 * t48 * t1714 + t45 * t1717 / 0.2e1 - 0.7e1 / 0.8e1 * t51 * t1714 - t48 * t1717 / 0.16e2
  t1776 = f.my_piecewise3(t39, 0, t1748)
  t1787 = t531 ** 2
  t1810 = t523 ** 2
  t1827 = t75 * t1019
  t1847 = 0.85e2 / 0.4e1 * t1035 * t1787 * t75 - 0.19e2 / 0.8e1 / t1034 / t72 * t1787 * t75 + t271 * t1776 * t75 / 0.2e1 + 0.1e1 / t1034 / t528 * t1787 * t75 / 0.16e2 - 0.12e2 * t1810 * t76 - 0.16e2 * t1075 * t1019 - 0.4e1 * t275 * t1776 - t68 * t1776 * t75 - 0.75e2 / 0.2e1 * t551 * t1787 * t75 + 0.45e2 * t532 * t1031 - 0.6e1 * t543 * t1810 * t75 - 0.8e1 * t1055 * t1827 - 0.15e2 * t1059 * t531 * t1031 + t551 * t1019 * t1067 + 0.3e1 / 0.4e1 * t551 * t1810 * t75 + 0.3e1 / 0.4e1 * t1071 * t523 * t531 * t75 - 0.3e1 * t73 * t1810 * t75 - 0.4e1 * t1078 * t1827
  t1883 = -0.1e1 / t1034 / t270 * t1787 * t75 / 0.8e1 - t266 * t1776 + 0.8e1 * t264 * t1085 + 0.2e1 * t66 * t1847 + 0.15e2 / 0.4e1 * t1071 * t1787 * t75 - 0.24e2 * t1059 * t1787 * t75 + 0.21e2 * t552 * t1031 - 0.3e1 / 0.2e1 * t530 * t1810 * t75 - 0.2e1 * t1030 * t1827 - 0.3e1 / 0.2e1 * t1035 * t531 * t1031 + 0.24e2 * t75 * t530 * t1787 - 0.36e2 * t1039 * t531 * t523 + 0.6e1 * t535 * t1810 + 0.8e1 * t535 * t264 * t1019 + 0.2e1 * t1776 * t79 + 0.8e1 * t1019 * t280 + 0.12e2 * t523 * t563
  t1887 = f.my_piecewise3(t38, t1724 + t1774, -0.8e1 / 0.3e1 * t1776 * t82 - 0.32e2 / 0.3e1 * t1019 * t283 - 0.16e2 * t523 * t566 - 0.32e2 / 0.3e1 * t264 * t1088 - 0.8e1 / 0.3e1 * t66 * t1883)
  t1903 = 0.1e1 / t21 / t1193
  t1922 = t608 ** 2
  t1925 = 0.1e1 / t21 / t1112 / t19
  t1927 = t1922 * t1925 * t95
  t1936 = t609 * t591
  t1945 = t109 * t1130
  t1968 = 0.100000e6 / 0.9e1 * t200 * t119 * t146 * t1927 + 0.800000e6 / 0.9e1 * t1446 * t152 * t1927 + 0.700000e6 / 0.3e1 * t817 * t158 * t1927 + 0.544000e6 / 0.81e2 * t933 * t1936 + 0.1360000e7 / 0.81e2 * t936 * t1936 + 0.54400e5 / 0.81e2 * t824 * t1936 + 0.217600e6 / 0.81e2 * t827 * t1936 - 0.67760e5 / 0.81e2 * t469 * t1945 - 0.43120e5 / 0.81e2 * t438 * t1945 - 0.43120e5 / 0.81e2 * t441 * t1945 - 0.49280e5 / 0.81e2 * t445 * t1945 - 0.49280e5 / 0.81e2 * t448 * t1945 - 0.6160e4 / 0.9e1 * t452 * t1945 + 0.54400e5 / 0.27e2 * t808 * t1936 - 0.6160e4 / 0.27e2 * t412 * t1945 + 0.272000e6 / 0.9e1 * t797 * t1936 + 0.54400e5 / 0.27e2 * t804 * t1936 + 0.1196800e7 / 0.27e2 * t888 * t1936
  t2018 = 0.272000e6 / 0.9e1 * t801 * t1936 + 0.217600e6 / 0.9e1 * t916 * t1936 + 0.54400e5 * t919 * t1936 - 0.30800e5 / 0.81e2 * t426 * t1945 - 0.6160e4 / 0.81e2 * t398 * t1945 - 0.6160e4 / 0.9e1 * t455 * t1945 - 0.12320e5 / 0.81e2 * t402 * t1945 + 0.20000e5 / 0.27e2 * t186 * t140 * t1927 + 0.160000e6 / 0.27e2 * t401 * t140 * t1927 + 0.400000e6 / 0.9e1 * t922 * t146 * t1927 + 0.1600000e7 / 0.27e2 * t415 * t152 * t1927 + 0.700000e6 / 0.27e2 * t195 * t158 * t1927 + 0.100000e6 / 0.27e2 * t197 * t113 * t140 * t1927 + 0.1000000e7 / 0.27e2 * t1467 * t146 * t1927 + 0.1200000e7 * t915 * t176 * t1927 + 0.1100000e7 * t451 * t382 * t1927 + 0.1100000e7 / 0.3e1 * t210 * t743 * t1927 + 0.1400000e7 / 0.9e1 * t212 * t143 * t170 * t1927
  t2035 = t1112 * r0
  t2036 = 0.1e1 / t2035
  t2037 = t1273 * t2036
  t2040 = t1277 * t2036
  t2043 = t1269 * t2036
  t2050 = t95 * t1925 * t134
  t2053 = t781 * t122
  t2056 = t1395 * t116
  t2061 = t1303 * t2036
  t2075 = 0.100000e6 / 0.27e2 * t189 * t146 * t1927 + 0.40000e5 / 0.3e1 * t807 * t140 * t1927 + 0.200000e6 / 0.9e1 * t408 * t146 * t1927 + 0.100000e6 / 0.9e1 * t192 * t152 * t1927 + 0.320000e6 / 0.27e2 * t1440 * t140 * t1927 - 0.32000e5 * t408 * t2037 - 0.160000e6 / 0.9e1 * t192 * t2040 - 0.64000e5 / 0.9e1 * t1440 * t2043 - 0.128000e6 / 0.3e1 * t922 * t2037 + 0.20000e5 / 0.27e2 * t194 * t1922 * t2050 + 0.54400e5 / 0.81e2 * t791 * t2053 - 0.6160e4 / 0.81e2 * t395 * t2056 + 0.54400e5 / 0.81e2 * t794 * t2053 - 0.896000e6 / 0.9e1 * t201 * t2061 + 0.20000e5 / 0.27e2 * t185 * t1922 * t2050 + 0.20000e5 / 0.9e1 * t188 * t1922 * t2050 + 0.20000e5 / 0.9e1 * t191 * t1922 * t2050 - 0.640000e6 / 0.9e1 * t415 * t2040
  t2076 = t1352 * t2036
  t2085 = t1299 * t2036
  t2094 = t1307 * t2036
  t2103 = t1311 * t2036
  t2112 = t1322 * t2036
  t2117 = -0.320000e6 / 0.9e1 * t195 * t2076 - 0.160000e6 / 0.9e1 * t1467 * t2037 - 0.800000e6 / 0.9e1 * t932 * t2040 - 0.400000e6 / 0.3e1 * t422 * t2076 - 0.560000e6 / 0.9e1 * t198 * t2085 - 0.560000e6 / 0.9e1 * t1495 * t2076 - 0.784000e6 / 0.3e1 * t895 * t2085 - 0.3136000e7 / 0.9e1 * t437 * t2061 - 0.448000e6 / 0.3e1 * t204 * t2094 - 0.896000e6 / 0.9e1 * t1505 * t2085 - 0.3584000e7 / 0.9e1 * t905 * t2061 - 0.512000e6 * t444 * t2094 - 0.640000e6 / 0.3e1 * t207 * t2103 - 0.448000e6 / 0.3e1 * t1420 * t2061 - 0.576000e6 * t915 * t2094 - 0.720000e6 * t451 * t2103 - 0.880000e6 / 0.3e1 * t210 * t2112 - 0.32000e5 / 0.3e1 * t401 * t2043
  t2124 = t1288 * t2036
  t2127 = t1294 * t2036
  t2150 = t2036 * t128
  t2160 = -0.64000e5 / 0.9e1 * t189 * t2037 - 0.9680000e7 / 0.9e1 * t881 * t2112 - 0.3872000e7 / 0.3e1 * t465 * t2124 - 0.4576000e7 / 0.9e1 * t216 * t2127 - 0.640000e6 / 0.3e1 * t1429 * t2094 - 0.800000e6 * t800 * t2103 - 0.8800000e7 / 0.9e1 * t458 * t2112 - 0.3520000e7 / 0.9e1 * t213 * t2124 - 0.880000e6 / 0.3e1 * t1484 * t2103 - 0.320000e6 / 0.9e1 * t1446 * t2040 - 0.160000e6 * t817 * t2076 - 0.224000e6 * t429 * t2085 - 0.16000e5 / 0.9e1 * t186 * t2043 - 0.16000e5 * t807 * t2043 - 0.16000e5 / 0.9e1 * t1624 * t2150 - 0.16000e5 / 0.9e1 * t1627 * t2150 - 0.32000e5 / 0.9e1 * t1621 * t2150 + 0.24200000e8 / 0.9e1 * t881 * t743 * t1927
  t2165 = 0.1e1 / t157 / t151
  t2218 = 0.62920000e8 / 0.27e2 * t465 * t1293 * t1927 + 0.20020000e8 / 0.27e2 * t216 * t2165 * t1927 + 0.2240000e7 / 0.9e1 * t429 * t164 * t1927 + 0.280000e6 / 0.3e1 * t201 * t170 * t1927 + 0.700000e6 / 0.27e2 * t203 * t125 * t152 * t1927 + 0.4900000e7 / 0.27e2 * t1495 * t158 * t1927 + 0.3920000e7 / 0.9e1 * t895 * t164 * t1927 + 0.3920000e7 / 0.9e1 * t437 * t170 * t1927 + 0.1400000e7 / 0.9e1 * t204 * t176 * t1927 + 0.1400000e7 / 0.27e2 * t206 * t131 * t158 * t1927 + 0.8960000e7 / 0.27e2 * t1505 * t164 * t1927 + 0.2240000e7 / 0.3e1 * t905 * t170 * t1927 + 0.6400000e7 / 0.9e1 * t444 * t176 * t1927 + 0.2200000e7 / 0.9e1 * t207 * t382 * t1927 + 0.280000e6 / 0.3e1 * t209 * t137 * t164 * t1927 + 0.560000e6 * t1420 * t170 * t1927 - 0.61600e5 / 0.81e2 * t459 * t1945 - 0.24640e5 / 0.81e2 * t416 * t1945
  t2266 = -0.24640e5 / 0.81e2 * t419 * t1945 - 0.30800e5 / 0.81e2 * t423 * t1945 - 0.61600e5 / 0.81e2 * t462 * t1945 - 0.67760e5 / 0.81e2 * t466 * t1945 - 0.12320e5 / 0.27e2 * t430 * t1945 - 0.12320e5 / 0.27e2 * t434 * t1945 + 0.272000e6 / 0.27e2 * t939 * t1936 - 0.12320e5 / 0.81e2 * t405 * t1945 - 0.6160e4 / 0.27e2 * t409 * t1945 + 0.1000000e7 / 0.9e1 * t932 * t152 * t1927 + 0.3500000e7 / 0.27e2 * t422 * t158 * t1927 + 0.1400000e7 / 0.27e2 * t198 * t164 * t1927 + 0.8000000e7 / 0.9e1 * t1429 * t176 * t1927 + 0.5500000e7 / 0.3e1 * t800 * t382 * t1927 + 0.44000000e8 / 0.27e2 * t458 * t743 * t1927 + 0.14300000e8 / 0.27e2 * t213 * t1293 * t1927 + 0.2200000e7 / 0.9e1 * t215 * t149 * t176 * t1927 + 0.12100000e8 / 0.9e1 * t1484 * t382 * t1927
  t2303 = 0.5440000e7 / 0.81e2 * t875 * t1936 + 0.2992000e7 / 0.81e2 * t878 * t1936 + 0.2992000e7 / 0.81e2 * t882 * t1936 + 0.6582400e7 / 0.81e2 * t885 * t1936 + 0.272000e6 / 0.27e2 * t818 * t1936 + 0.217600e6 / 0.9e1 * t821 * t1936 + 0.380800e6 / 0.27e2 * t891 * t1936 + 0.380800e6 / 0.27e2 * t896 * t1936 + 0.2665600e7 / 0.81e2 * t899 * t1936 + 0.1523200e7 / 0.81e2 * t902 * t1936 + 0.1523200e7 / 0.81e2 * t906 * t1936 + 0.3481600e7 / 0.81e2 * t909 * t1936 + 0.217600e6 / 0.9e1 * t912 * t1936 + 0.54400e5 / 0.9e1 * t811 * t1936 + 0.108800e6 / 0.27e2 * t814 * t1936 + 0.108800e6 / 0.27e2 * t923 * t1936 + 0.870400e6 / 0.81e2 * t926 * t1936 + 0.544000e6 / 0.81e2 * t929 * t1936
  t2316 = 0.1e1 / t20 / t2035
  t2322 = 0.1e1 / t1112 / t588
  t2330 = -0.54021915822930647040000000000000000000000000000000e-2 * t1110 * t1115 * t387 + 0.13300817964741147182848143067621805619062134837169e1 * t389 * t95 * t1903 * t391 + 0.34685389728000000000000000000000000000000000000000e0 * t296 * t96 * t597 * t773 - 0.63064344960000000000000000000000000000000000000000e-1 * t296 * t96 * t299 * t1393 + 0.15287264361600000000000000000000000000000000000000e1 * t296 * t96 * t1903 * t178 + t183 * (t1968 + t2018 + t2075 + t2117 + t2160 + t2218 + t2266 + t2303) - 0.54869684499314128943758573388203017832647462277092e-1 * t389 * t390 * t181 * t1633 - 0.93888126809937509525986892242036274958085657674134e0 * t389 * t1395 * t785 - 0.74161079640603196860372285710924062778409896822894e-1 * t780 * t94 * t2316 * t391 + 0.44727351463209150916651459655457286350039441533164e-2 * t1406 * t2322 * t181 * t218 - 0.81322457205834819848457199373558702454617166423936e-3 * t1406 * t1407 * t473
  t2334 = t586 ** 2
  t2337 = 0.1e1 / t21 / t1112 / t1193
  t2341 = t92 * t95
  t2419 = -0.64000e5 / 0.9e1 * t120 * t2037 - 0.16000e5 * t662 * t2043 - 0.32000e5 * t320 * t2037 - 0.6160e4 / 0.81e2 * t304 * t2056 + 0.20000e5 / 0.27e2 * t105 * t1922 * t2050 - 0.560000e6 / 0.9e1 * t138 * t2085 - 0.320000e6 / 0.9e1 * t1366 * t2040 - 0.160000e6 * t632 * t2076 + 0.54400e5 / 0.81e2 * t726 * t2053 + 0.20000e5 / 0.9e1 * t118 * t1922 * t2050 + 0.20000e5 / 0.9e1 * t124 * t1922 * t2050 - 0.160000e6 / 0.9e1 * t126 * t2040 - 0.32000e5 / 0.9e1 * t1149 * t2150 - 0.16000e5 / 0.9e1 * t1152 * t2150 - 0.16000e5 / 0.9e1 * t1144 * t2150 - 0.224000e6 * t341 * t2085 - 0.896000e6 / 0.9e1 * t144 * t2061 - 0.560000e6 / 0.9e1 * t1375 * t2076
  t2456 = -0.784000e6 / 0.3e1 * t642 * t2085 - 0.3136000e7 / 0.9e1 * t349 * t2061 - 0.896000e6 / 0.9e1 * t1298 * t2085 - 0.3584000e7 / 0.9e1 * t747 * t2061 - 0.512000e6 * t356 * t2094 - 0.640000e6 / 0.3e1 * t156 * t2103 - 0.448000e6 / 0.3e1 * t1315 * t2061 - 0.576000e6 * t757 * t2094 - 0.720000e6 * t363 * t2103 + 0.54400e5 / 0.81e2 * t721 * t2053 - 0.448000e6 / 0.3e1 * t150 * t2094 - 0.16000e5 / 0.9e1 * t114 * t2043 - 0.880000e6 / 0.3e1 * t162 * t2112 - 0.640000e6 / 0.3e1 * t1326 * t2094 - 0.800000e6 * t767 * t2103 - 0.8800000e7 / 0.9e1 * t370 * t2112 - 0.3520000e7 / 0.9e1 * t168 * t2124 - 0.880000e6 / 0.3e1 * t1337 * t2103
  t2502 = -0.9680000e7 / 0.9e1 * t735 * t2112 - 0.3872000e7 / 0.3e1 * t377 * t2124 - 0.4576000e7 / 0.9e1 * t174 * t2127 - 0.64000e5 / 0.9e1 * t1345 * t2043 - 0.128000e6 / 0.3e1 * t606 * t2037 - 0.640000e6 / 0.9e1 * t327 * t2040 - 0.320000e6 / 0.9e1 * t132 * t2076 - 0.160000e6 / 0.9e1 * t1356 * t2037 - 0.800000e6 / 0.9e1 * t622 * t2040 - 0.400000e6 / 0.3e1 * t334 * t2076 + 0.20000e5 / 0.27e2 * t130 * t1922 * t2050 - 0.32000e5 / 0.3e1 * t313 * t2043 + 0.3920000e7 / 0.9e1 * t349 * t170 * t1927 + 0.1600000e7 / 0.27e2 * t327 * t152 * t1927 + 0.700000e6 / 0.27e2 * t132 * t158 * t1927 + 0.100000e6 / 0.27e2 * t136 * t113 * t140 * t1927 + 0.1000000e7 / 0.27e2 * t1356 * t146 * t1927 + 0.1000000e7 / 0.9e1 * t622 * t152 * t1927
  t2544 = 0.3500000e7 / 0.27e2 * t334 * t158 * t1927 + 0.1400000e7 / 0.27e2 * t138 * t164 * t1927 + 0.272000e6 / 0.9e1 * t764 * t1936 + 0.272000e6 / 0.9e1 * t768 * t1936 + 0.5440000e7 / 0.81e2 * t729 * t1936 + 0.2992000e7 / 0.81e2 * t732 * t1936 + 0.2992000e7 / 0.81e2 * t736 * t1936 + 0.6582400e7 / 0.81e2 * t739 * t1936 - 0.6160e4 / 0.27e2 * t324 * t1945 - 0.24640e5 / 0.81e2 * t328 * t1945 - 0.24640e5 / 0.81e2 * t331 * t1945 - 0.30800e5 / 0.81e2 * t335 * t1945 + 0.5500000e7 / 0.3e1 * t767 * t382 * t1927 + 0.44000000e8 / 0.27e2 * t370 * t743 * t1927 + 0.14300000e8 / 0.27e2 * t168 * t1293 * t1927 + 0.1523200e7 / 0.81e2 * t649 * t1936 + 0.2665600e7 / 0.81e2 * t646 * t1936 + 0.1523200e7 / 0.81e2 * t748 * t1936
  t2588 = 0.3481600e7 / 0.81e2 * t751 * t1936 + 0.217600e6 / 0.9e1 * t754 * t1936 + 0.217600e6 / 0.9e1 * t758 * t1936 + 0.54400e5 * t761 * t1936 - 0.6160e4 / 0.27e2 * t321 * t1945 + 0.54400e5 / 0.27e2 * t659 * t1936 + 0.54400e5 / 0.27e2 * t663 * t1936 + 0.54400e5 / 0.9e1 * t666 * t1936 + 0.108800e6 / 0.27e2 * t669 * t1936 + 0.380800e6 / 0.27e2 * t639 * t1936 + 0.380800e6 / 0.27e2 * t643 * t1936 + 0.217600e6 / 0.81e2 * t656 * t1936 - 0.43120e5 / 0.81e2 * t350 * t1945 - 0.43120e5 / 0.81e2 * t353 * t1945 + 0.2200000e7 / 0.9e1 * t172 * t149 * t176 * t1927 + 0.12100000e8 / 0.9e1 * t1337 * t382 * t1927 + 0.320000e6 / 0.27e2 * t1345 * t140 * t1927 + 0.400000e6 / 0.9e1 * t606 * t146 * t1927
  t2637 = 0.2200000e7 / 0.9e1 * t156 * t382 * t1927 + 0.280000e6 / 0.3e1 * t160 * t137 * t164 * t1927 + 0.560000e6 * t1315 * t170 * t1927 + 0.1200000e7 * t757 * t176 * t1927 + 0.1100000e7 * t363 * t382 * t1927 + 0.1100000e7 / 0.3e1 * t162 * t743 * t1927 + 0.160000e6 / 0.27e2 * t313 * t140 * t1927 + 0.100000e6 / 0.27e2 * t120 * t146 * t1927 + 0.40000e5 / 0.3e1 * t662 * t140 * t1927 + 0.200000e6 / 0.9e1 * t320 * t146 * t1927 + 0.100000e6 / 0.9e1 * t126 * t152 * t1927 + 0.870400e6 / 0.81e2 * t616 * t1936 + 0.544000e6 / 0.81e2 * t619 * t1936 + 0.544000e6 / 0.81e2 * t623 * t1936 + 0.1360000e7 / 0.81e2 * t626 * t1936 + 0.272000e6 / 0.27e2 * t629 * t1936 + 0.272000e6 / 0.27e2 * t633 * t1936 + 0.217600e6 / 0.9e1 * t636 * t1936
  t2687 = 0.54400e5 / 0.81e2 * t652 * t1936 + 0.1400000e7 / 0.9e1 * t150 * t176 * t1927 + 0.20000e5 / 0.27e2 * t114 * t140 * t1927 + 0.100000e6 / 0.9e1 * t142 * t119 * t146 * t1927 + 0.800000e6 / 0.9e1 * t1366 * t152 * t1927 + 0.700000e6 / 0.3e1 * t632 * t158 * t1927 + 0.2240000e7 / 0.9e1 * t341 * t164 * t1927 + 0.280000e6 / 0.3e1 * t144 * t170 * t1927 + 0.700000e6 / 0.27e2 * t148 * t125 * t152 * t1927 + 0.4900000e7 / 0.27e2 * t1375 * t158 * t1927 + 0.3920000e7 / 0.9e1 * t642 * t164 * t1927 - 0.49280e5 / 0.81e2 * t357 * t1945 - 0.49280e5 / 0.81e2 * t360 * t1945 - 0.12320e5 / 0.81e2 * t314 * t1945 - 0.6160e4 / 0.9e1 * t364 * t1945 + 0.1196800e7 / 0.27e2 * t744 * t1936 - 0.6160e4 / 0.9e1 * t367 * t1945 - 0.61600e5 / 0.81e2 * t371 * t1945
  t2735 = -0.61600e5 / 0.81e2 * t374 * t1945 - 0.67760e5 / 0.81e2 * t378 * t1945 - 0.67760e5 / 0.81e2 * t383 * t1945 - 0.12320e5 / 0.27e2 * t346 * t1945 - 0.12320e5 / 0.81e2 * t317 * t1945 + 0.24200000e8 / 0.9e1 * t735 * t743 * t1927 + 0.62920000e8 / 0.27e2 * t377 * t1293 * t1927 + 0.20020000e8 / 0.27e2 * t174 * t2165 * t1927 + 0.1400000e7 / 0.27e2 * t154 * t131 * t158 * t1927 + 0.8960000e7 / 0.27e2 * t1298 * t164 * t1927 + 0.2240000e7 / 0.3e1 * t747 * t170 * t1927 + 0.6400000e7 / 0.9e1 * t356 * t176 * t1927 + 0.1400000e7 / 0.9e1 * t166 * t143 * t170 * t1927 + 0.8000000e7 / 0.9e1 * t1326 * t176 * t1927 + 0.108800e6 / 0.27e2 * t607 * t1936 - 0.30800e5 / 0.81e2 * t338 * t1945 - 0.12320e5 / 0.27e2 * t342 * t1945 - 0.6160e4 / 0.81e2 * t309 * t1945
  t2740 = -0.13175945269212784813056000000000000000000000000000e-3 / t1106 / t100 * t1109 * t2334 * t2337 * t178 * t88 * t2341 - 0.16731538296992640000000000000000000000000000000000e0 * t585 * t587 * t2316 * t178 - 0.92288362414464000000000000000000000000000000000000e-2 * t585 * t587 * t591 * t773 - 0.10791010137600000000000000000000000000000000000000e1 * t296 * t96 * t1130 * t387 - 0.40906009199106972731972455856893762921696980882904e-2 * t780 * t781 * t1414 + 0.67678132437273600000000000000000000000000000000000e-1 * t585 * t587 * t1120 * t387 + 0.29997740079345113336779800961722092809244452647462e-1 * t780 * t1399 * t785 + 0.30178326474622770919067215363511659807956104252400e0 * t389 * t775 * t1414 - 0.50522390960067158113442823809143147287465188579710e-5 * t1109 * t2334 * t2337 * t88 * t2341 * t391 + 0.29712053702611855872000000000000000000000000000000e-1 * t1110 * t1111 * t2322 * t178 + t103 * (t2419 + t2456 + t2502 + t2544 + t2588 + t2637 + t2687 + t2735)
  t2748 = t18 * t111 * t570 * t220 / 0.2e1 + t18 * t288 * t475 - 0.5e1 / 0.9e1 * t18 * t23 * t287 * t220 - 0.5e1 / 0.9e1 * t18 * t87 * t475 - t18 * t579 * t1635 / 0.2e1 - 0.3e1 / 0.2e1 * t18 * t575 * t946 - t18 * t479 * t1092 * t220 / 0.2e1 - 0.3e1 / 0.2e1 * t18 * t571 * t475 - 0.9e1 / 0.4e1 * t18 * t1097 * t946 - 0.3e1 / 0.2e1 * t18 * t1093 * t475 - 0.3e1 / 0.8e1 * t18 * t20 * t1887 * t220 + 0.10e2 / 0.27e2 * t18 * t299 * t86 * t220 - 0.3e1 / 0.2e1 * t18 * t1101 * t1635 - 0.3e1 / 0.8e1 * t18 * t1105 * (t2330 + t2740) + t18 * t292 * t946 / 0.2e1
  t2749 = f.my_piecewise3(t2, 0, t2748)
  v4rho4_0_ = 0.2e1 * r0 * t2749 + 0.8e1 * t1640

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 9 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = t33 * t36
  t38 = t37 * f.p.cam_omega
  t39 = 0.1e1 / t31
  t40 = t2 * t39
  t42 = 0.1e1 + t17 <= f.p.zeta_threshold
  t44 = 0.1e1 - t17 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t11, t44, t15, t17)
  t46 = 0.1e1 + t45
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t49 = t46 ** (0.1e1 / 0.3e1)
  t50 = f.my_piecewise3(t47, t48, t49)
  t51 = 0.1e1 / t50
  t54 = t38 * t40 * t51 / 0.18e2
  t55 = 0.135e1 <= t54
  t56 = 0.135e1 < t54
  t57 = f.my_piecewise3(t56, t54, 0.135e1)
  t58 = t57 ** 2
  t61 = t58 ** 2
  t62 = 0.1e1 / t61
  t64 = t61 * t58
  t65 = 0.1e1 / t64
  t67 = t61 ** 2
  t68 = 0.1e1 / t67
  t71 = 0.1e1 / t67 / t58
  t74 = 0.1e1 / t67 / t61
  t77 = 0.1e1 / t67 / t64
  t79 = t67 ** 2
  t80 = 0.1e1 / t79
  t83 = f.my_piecewise3(t56, 0.135e1, t54)
  t84 = jnp.sqrt(jnp.pi)
  t85 = 0.1e1 / t83
  t87 = jax.lax.erf(t85 / 0.2e1)
  t89 = t83 ** 2
  t90 = 0.1e1 / t89
  t92 = jnp.exp(-t90 / 0.4e1)
  t93 = t92 - 0.1e1
  t96 = t92 - 0.3e1 / 0.2e1 - 0.2e1 * t89 * t93
  t99 = 0.2e1 * t83 * t96 + t84 * t87
  t103 = f.my_piecewise3(t55, 0.1e1 / t58 / 0.36e2 - t62 / 0.960e3 + t65 / 0.26880e5 - t68 / 0.829440e6 + t71 / 0.28385280e8 - t74 / 0.1073479680e10 + t77 / 0.44590694400e11 - t80 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t83 * t99)
  t104 = t31 * t103
  t105 = 6 ** (0.1e1 / 0.3e1)
  t106 = jnp.pi ** 2
  t107 = t106 ** (0.1e1 / 0.3e1)
  t108 = t107 ** 2
  t109 = 0.1e1 / t108
  t110 = t105 * t109
  t111 = r0 ** 2
  t112 = r0 ** (0.1e1 / 0.3e1)
  t113 = t112 ** 2
  t115 = 0.1e1 / t113 / t111
  t117 = t110 * s0 * t115
  t119 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t117
  t122 = 0.18040e1 - 0.64641600e0 / t119
  t123 = params.a[0]
  t124 = params.a[1]
  t125 = t105 ** 2
  t127 = 0.3e1 / 0.10e2 * t125 * t108
  t130 = tau0 / t113 / r0
  t131 = t127 - t130
  t132 = t124 * t131
  t133 = t127 + t130
  t134 = 0.1e1 / t133
  t136 = params.a[2]
  t137 = t131 ** 2
  t138 = t136 * t137
  t139 = t133 ** 2
  t140 = 0.1e1 / t139
  t142 = params.a[3]
  t143 = t137 * t131
  t144 = t142 * t143
  t145 = t139 * t133
  t146 = 0.1e1 / t145
  t148 = params.a[4]
  t149 = t137 ** 2
  t150 = t148 * t149
  t151 = t139 ** 2
  t152 = 0.1e1 / t151
  t154 = params.a[5]
  t155 = t149 * t131
  t156 = t154 * t155
  t157 = t151 * t133
  t158 = 0.1e1 / t157
  t160 = params.a[6]
  t161 = t149 * t137
  t162 = t160 * t161
  t164 = 0.1e1 / t151 / t139
  t166 = params.a[7]
  t167 = t149 * t143
  t168 = t166 * t167
  t170 = 0.1e1 / t151 / t145
  t172 = params.a[8]
  t173 = t149 ** 2
  t174 = t172 * t173
  t175 = t151 ** 2
  t176 = 0.1e1 / t175
  t178 = params.a[9]
  t179 = t173 * t131
  t180 = t178 * t179
  t182 = 0.1e1 / t175 / t133
  t184 = params.a[10]
  t185 = t173 * t137
  t186 = t184 * t185
  t188 = 0.1e1 / t175 / t139
  t190 = params.a[11]
  t191 = t173 * t143
  t192 = t190 * t191
  t194 = 0.1e1 / t175 / t145
  t196 = t132 * t134 + t138 * t140 + t144 * t146 + t150 * t152 + t156 * t158 + t162 * t164 + t168 * t170 + t174 * t176 + t180 * t182 + t186 * t188 + t192 * t194 + t123
  t199 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t117)
  t201 = 0.1552e1 - 0.552e0 * t199
  t202 = params.b[0]
  t203 = params.b[1]
  t204 = t203 * t131
  t206 = params.b[2]
  t207 = t206 * t137
  t209 = params.b[3]
  t210 = t209 * t143
  t212 = params.b[4]
  t213 = t212 * t149
  t215 = params.b[5]
  t216 = t215 * t155
  t218 = params.b[6]
  t219 = t218 * t161
  t221 = params.b[7]
  t222 = t221 * t167
  t224 = params.b[8]
  t225 = t224 * t173
  t227 = params.b[9]
  t228 = t227 * t179
  t230 = params.b[10]
  t231 = t230 * t185
  t233 = params.b[11]
  t234 = t233 * t191
  t236 = t204 * t134 + t207 * t140 + t210 * t146 + t213 * t152 + t216 * t158 + t219 * t164 + t222 * t170 + t225 * t176 + t228 * t182 + t231 * t188 + t234 * t194 + t202
  t238 = t122 * t196 + t201 * t236
  t239 = t104 * t238
  t242 = t48 * f.p.zeta_threshold
  t244 = f.my_piecewise3(t20, t242, t21 * t19)
  t245 = t5 * t244
  t246 = t31 ** 2
  t247 = 0.1e1 / t246
  t248 = t247 * t103
  t249 = t248 * t238
  t251 = t245 * t249 / 0.8e1
  t252 = t58 * t57
  t253 = 0.1e1 / t252
  t256 = t2 / t31 / t6
  t259 = t38 * t256 * t51 / 0.54e2
  t260 = t50 ** 2
  t261 = 0.1e1 / t260
  t262 = t49 ** 2
  t263 = 0.1e1 / t262
  t264 = f.my_piecewise5(t42, 0, t44, 0, t25)
  t267 = f.my_piecewise3(t47, 0, t263 * t264 / 0.3e1)
  t268 = t261 * t267
  t272 = -t259 - t38 * t40 * t268 / 0.18e2
  t273 = f.my_piecewise3(t56, t272, 0)
  t276 = t61 * t57
  t277 = 0.1e1 / t276
  t280 = t61 * t252
  t281 = 0.1e1 / t280
  t285 = 0.1e1 / t67 / t57
  t289 = 0.1e1 / t67 / t252
  t293 = 0.1e1 / t67 / t276
  t297 = 0.1e1 / t67 / t280
  t301 = 0.1e1 / t79 / t57
  t305 = f.my_piecewise3(t56, 0, t272)
  t307 = t92 * t90
  t312 = 0.1e1 / t89 / t83
  t316 = t83 * t93
  t321 = t312 * t305 * t92 / 0.2e1 - 0.4e1 * t316 * t305 - t85 * t305 * t92
  t324 = -t307 * t305 + 0.2e1 * t305 * t96 + 0.2e1 * t83 * t321
  t328 = f.my_piecewise3(t55, -t253 * t273 / 0.18e2 + t277 * t273 / 0.240e3 - t281 * t273 / 0.4480e4 + t285 * t273 / 0.103680e6 - t289 * t273 / 0.2838528e7 + t293 * t273 / 0.89456640e8 - t297 * t273 / 0.3185049600e10 + t301 * t273 / 0.126340300800e12, -0.8e1 / 0.3e1 * t305 * t99 - 0.8e1 / 0.3e1 * t83 * t324)
  t329 = t31 * t328
  t330 = t329 * t238
  t333 = t119 ** 2
  t336 = 0.1e1 / t333 * t105 * t109
  t337 = t111 * r0
  t339 = 0.1e1 / t113 / t337
  t340 = s0 * t339
  t344 = t124 * tau0
  t345 = t115 * t134
  t348 = t140 * tau0
  t349 = t348 * t115
  t352 = t136 * t131
  t355 = t146 * tau0
  t356 = t355 * t115
  t359 = t142 * t137
  t362 = t152 * tau0
  t363 = t362 * t115
  t366 = t148 * t143
  t369 = t158 * tau0
  t370 = t369 * t115
  t373 = t154 * t149
  t376 = t164 * tau0
  t377 = t376 * t115
  t380 = t160 * t155
  t383 = 0.5e1 / 0.3e1 * t344 * t345 + 0.5e1 / 0.3e1 * t132 * t349 + 0.10e2 / 0.3e1 * t352 * t349 + 0.10e2 / 0.3e1 * t138 * t356 + 0.5e1 * t359 * t356 + 0.5e1 * t144 * t363 + 0.20e2 / 0.3e1 * t366 * t363 + 0.20e2 / 0.3e1 * t150 * t370 + 0.25e2 / 0.3e1 * t373 * t370 + 0.25e2 / 0.3e1 * t156 * t377 + 0.10e2 * t380 * t377
  t384 = t170 * tau0
  t385 = t384 * t115
  t388 = t166 * t161
  t391 = t176 * tau0
  t392 = t391 * t115
  t395 = t172 * t167
  t398 = t182 * tau0
  t399 = t398 * t115
  t402 = t178 * t173
  t405 = t188 * tau0
  t406 = t405 * t115
  t409 = t184 * t179
  t412 = t194 * tau0
  t413 = t412 * t115
  t416 = t190 * t185
  t420 = 0.1e1 / t175 / t151
  t421 = t420 * tau0
  t422 = t421 * t115
  t425 = 0.10e2 * t162 * t385 + 0.35e2 / 0.3e1 * t388 * t385 + 0.35e2 / 0.3e1 * t168 * t392 + 0.40e2 / 0.3e1 * t395 * t392 + 0.40e2 / 0.3e1 * t174 * t399 + 0.15e2 * t402 * t399 + 0.15e2 * t180 * t406 + 0.50e2 / 0.3e1 * t409 * t406 + 0.50e2 / 0.3e1 * t186 * t413 + 0.55e2 / 0.3e1 * t416 * t413 + 0.55e2 / 0.3e1 * t192 * t422
  t426 = t383 + t425
  t428 = t110 * s0
  t429 = t339 * t199
  t433 = t203 * tau0
  t438 = t206 * t131
  t443 = t209 * t137
  t448 = t212 * t143
  t453 = t215 * t149
  t458 = t218 * t155
  t461 = 0.5e1 / 0.3e1 * t433 * t345 + 0.5e1 / 0.3e1 * t204 * t349 + 0.10e2 / 0.3e1 * t438 * t349 + 0.10e2 / 0.3e1 * t207 * t356 + 0.5e1 * t443 * t356 + 0.5e1 * t210 * t363 + 0.20e2 / 0.3e1 * t448 * t363 + 0.20e2 / 0.3e1 * t213 * t370 + 0.25e2 / 0.3e1 * t453 * t370 + 0.25e2 / 0.3e1 * t216 * t377 + 0.10e2 * t458 * t377
  t464 = t221 * t161
  t469 = t224 * t167
  t474 = t227 * t173
  t479 = t230 * t179
  t484 = t233 * t185
  t489 = 0.10e2 * t219 * t385 + 0.35e2 / 0.3e1 * t464 * t385 + 0.35e2 / 0.3e1 * t222 * t392 + 0.40e2 / 0.3e1 * t469 * t392 + 0.40e2 / 0.3e1 * t225 * t399 + 0.15e2 * t474 * t399 + 0.15e2 * t228 * t406 + 0.50e2 / 0.3e1 * t479 * t406 + 0.50e2 / 0.3e1 * t231 * t413 + 0.55e2 / 0.3e1 * t484 * t413 + 0.55e2 / 0.3e1 * t234 * t422
  t490 = t461 + t489
  t492 = -0.15766086240000000000000000000000000000000000000000e-1 * t336 * t340 * t196 + t122 * t426 - 0.13717421124828532235939643347050754458161865569273e-1 * t428 * t429 * t236 + t201 * t490
  t493 = t104 * t492
  t497 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t239 - t251 - 0.3e1 / 0.8e1 * t245 * t330 - 0.3e1 / 0.8e1 * t245 * t493)
  t499 = r1 <= f.p.dens_threshold
  t500 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t501 = 0.1e1 + t500
  t502 = t501 <= f.p.zeta_threshold
  t503 = t501 ** (0.1e1 / 0.3e1)
  t504 = -t25
  t505 = f.my_piecewise5(t14, 0, t10, 0, t504)
  t508 = f.my_piecewise3(t502, 0, 0.4e1 / 0.3e1 * t503 * t505)
  t509 = t5 * t508
  t510 = f.my_piecewise5(t44, t11, t42, t15, -t17)
  t511 = 0.1e1 + t510
  t512 = t511 <= f.p.zeta_threshold
  t513 = t511 ** (0.1e1 / 0.3e1)
  t514 = f.my_piecewise3(t512, t48, t513)
  t515 = 0.1e1 / t514
  t518 = t38 * t40 * t515 / 0.18e2
  t519 = 0.135e1 <= t518
  t520 = 0.135e1 < t518
  t521 = f.my_piecewise3(t520, t518, 0.135e1)
  t522 = t521 ** 2
  t525 = t522 ** 2
  t526 = 0.1e1 / t525
  t528 = t525 * t522
  t529 = 0.1e1 / t528
  t531 = t525 ** 2
  t532 = 0.1e1 / t531
  t535 = 0.1e1 / t531 / t522
  t538 = 0.1e1 / t531 / t525
  t541 = 0.1e1 / t531 / t528
  t543 = t531 ** 2
  t544 = 0.1e1 / t543
  t547 = f.my_piecewise3(t520, 0.135e1, t518)
  t548 = 0.1e1 / t547
  t550 = jax.lax.erf(t548 / 0.2e1)
  t552 = t547 ** 2
  t553 = 0.1e1 / t552
  t555 = jnp.exp(-t553 / 0.4e1)
  t556 = t555 - 0.1e1
  t559 = t555 - 0.3e1 / 0.2e1 - 0.2e1 * t552 * t556
  t562 = 0.2e1 * t547 * t559 + t84 * t550
  t566 = f.my_piecewise3(t519, 0.1e1 / t522 / 0.36e2 - t526 / 0.960e3 + t529 / 0.26880e5 - t532 / 0.829440e6 + t535 / 0.28385280e8 - t538 / 0.1073479680e10 + t541 / 0.44590694400e11 - t544 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t547 * t562)
  t567 = t31 * t566
  t568 = r1 ** 2
  t569 = r1 ** (0.1e1 / 0.3e1)
  t570 = t569 ** 2
  t572 = 0.1e1 / t570 / t568
  t574 = t110 * s2 * t572
  t576 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t574
  t579 = 0.18040e1 - 0.64641600e0 / t576
  t582 = tau1 / t570 / r1
  t583 = t127 - t582
  t584 = t124 * t583
  t585 = t127 + t582
  t586 = 0.1e1 / t585
  t588 = t583 ** 2
  t589 = t136 * t588
  t590 = t585 ** 2
  t591 = 0.1e1 / t590
  t593 = t588 * t583
  t594 = t142 * t593
  t595 = t590 * t585
  t596 = 0.1e1 / t595
  t598 = t588 ** 2
  t599 = t148 * t598
  t600 = t590 ** 2
  t601 = 0.1e1 / t600
  t603 = t598 * t583
  t604 = t154 * t603
  t605 = t600 * t585
  t606 = 0.1e1 / t605
  t608 = t598 * t588
  t609 = t160 * t608
  t611 = 0.1e1 / t600 / t590
  t613 = t598 * t593
  t614 = t166 * t613
  t616 = 0.1e1 / t600 / t595
  t618 = t598 ** 2
  t619 = t172 * t618
  t620 = t600 ** 2
  t621 = 0.1e1 / t620
  t623 = t618 * t583
  t624 = t178 * t623
  t626 = 0.1e1 / t620 / t585
  t628 = t618 * t588
  t629 = t184 * t628
  t631 = 0.1e1 / t620 / t590
  t633 = t618 * t593
  t634 = t190 * t633
  t636 = 0.1e1 / t620 / t595
  t638 = t584 * t586 + t589 * t591 + t594 * t596 + t599 * t601 + t604 * t606 + t609 * t611 + t614 * t616 + t619 * t621 + t624 * t626 + t629 * t631 + t634 * t636 + t123
  t641 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t574)
  t643 = 0.1552e1 - 0.552e0 * t641
  t644 = t203 * t583
  t646 = t206 * t588
  t648 = t209 * t593
  t650 = t212 * t598
  t652 = t215 * t603
  t654 = t218 * t608
  t656 = t221 * t613
  t658 = t224 * t618
  t660 = t227 * t623
  t662 = t230 * t628
  t664 = t233 * t633
  t666 = t644 * t586 + t646 * t591 + t648 * t596 + t650 * t601 + t652 * t606 + t654 * t611 + t656 * t616 + t658 * t621 + t660 * t626 + t662 * t631 + t664 * t636 + t202
  t668 = t579 * t638 + t643 * t666
  t669 = t567 * t668
  t673 = f.my_piecewise3(t502, t242, t503 * t501)
  t674 = t5 * t673
  t675 = t247 * t566
  t676 = t675 * t668
  t678 = t674 * t676 / 0.8e1
  t679 = t522 * t521
  t680 = 0.1e1 / t679
  t683 = t38 * t256 * t515 / 0.54e2
  t684 = t514 ** 2
  t685 = 0.1e1 / t684
  t686 = t513 ** 2
  t687 = 0.1e1 / t686
  t688 = f.my_piecewise5(t44, 0, t42, 0, t504)
  t691 = f.my_piecewise3(t512, 0, t687 * t688 / 0.3e1)
  t692 = t685 * t691
  t696 = -t683 - t38 * t40 * t692 / 0.18e2
  t697 = f.my_piecewise3(t520, t696, 0)
  t700 = t525 * t521
  t701 = 0.1e1 / t700
  t704 = t525 * t679
  t705 = 0.1e1 / t704
  t709 = 0.1e1 / t531 / t521
  t713 = 0.1e1 / t531 / t679
  t717 = 0.1e1 / t531 / t700
  t721 = 0.1e1 / t531 / t704
  t725 = 0.1e1 / t543 / t521
  t729 = f.my_piecewise3(t520, 0, t696)
  t731 = t555 * t553
  t736 = 0.1e1 / t552 / t547
  t740 = t547 * t556
  t745 = t736 * t729 * t555 / 0.2e1 - 0.4e1 * t740 * t729 - t548 * t729 * t555
  t748 = 0.2e1 * t547 * t745 + 0.2e1 * t729 * t559 - t731 * t729
  t752 = f.my_piecewise3(t519, -t680 * t697 / 0.18e2 + t701 * t697 / 0.240e3 - t705 * t697 / 0.4480e4 + t709 * t697 / 0.103680e6 - t713 * t697 / 0.2838528e7 + t717 * t697 / 0.89456640e8 - t721 * t697 / 0.3185049600e10 + t725 * t697 / 0.126340300800e12, -0.8e1 / 0.3e1 * t547 * t748 - 0.8e1 / 0.3e1 * t729 * t562)
  t753 = t31 * t752
  t754 = t753 * t668
  t758 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t509 * t669 - t678 - 0.3e1 / 0.8e1 * t674 * t754)
  t760 = t21 ** 2
  t761 = 0.1e1 / t760
  t762 = t26 ** 2
  t767 = t16 / t22 / t6
  t769 = -0.2e1 * t23 + 0.2e1 * t767
  t770 = f.my_piecewise5(t10, 0, t14, 0, t769)
  t774 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t761 * t762 + 0.4e1 / 0.3e1 * t21 * t770)
  t778 = t30 * t249
  t785 = 0.1e1 / t246 / t6
  t789 = t245 * t785 * t103 * t238 / 0.12e2
  t792 = t245 * t247 * t328 * t238
  t795 = t245 * t248 * t492
  t797 = t273 ** 2
  t802 = t2 / t31 / t22
  t805 = 0.2e1 / 0.81e2 * t38 * t802 * t51
  t807 = t38 * t256 * t268
  t810 = 0.1e1 / t260 / t50
  t811 = t267 ** 2
  t817 = 0.1e1 / t262 / t46
  t818 = t264 ** 2
  t821 = f.my_piecewise5(t42, 0, t44, 0, t769)
  t825 = f.my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t817 * t818 + t263 * t821 / 0.3e1)
  t830 = t805 + t807 / 0.27e2 + t38 * t40 * t810 * t811 / 0.9e1 - t38 * t40 * t261 * t825 / 0.18e2
  t831 = f.my_piecewise3(t56, t830, 0)
  t859 = 0.1e1 / t79 / t58
  t864 = t62 * t797 / 0.6e1 - t253 * t831 / 0.18e2 - t65 * t797 / 0.48e2 + t277 * t831 / 0.240e3 + t68 * t797 / 0.640e3 - t281 * t831 / 0.4480e4 - t71 * t797 / 0.11520e5 + t285 * t831 / 0.103680e6 + t74 * t797 / 0.258048e6 - t289 * t831 / 0.2838528e7 - t77 * t797 / 0.6881280e7 + t293 * t831 / 0.89456640e8 + t80 * t797 / 0.212336640e9 - t297 * t831 / 0.3185049600e10 - t859 * t797 / 0.7431782400e10 + t301 * t831 / 0.126340300800e12
  t865 = f.my_piecewise3(t56, 0, t830)
  t870 = t89 ** 2
  t872 = 0.1e1 / t870 / t83
  t873 = t305 ** 2
  t877 = t92 * t312
  t885 = 0.1e1 / t870
  t893 = 0.1e1 / t870 / t89
  t912 = f.my_piecewise3(t55, t864, -0.8e1 / 0.3e1 * t865 * t99 - 0.16e2 / 0.3e1 * t305 * t324 - 0.8e1 / 0.3e1 * t83 * (-t872 * t873 * t92 / 0.2e1 + 0.2e1 * t877 * t873 - t307 * t865 + 0.2e1 * t865 * t96 + 0.4e1 * t305 * t321 + 0.2e1 * t83 * (-0.2e1 * t885 * t873 * t92 + t312 * t865 * t92 / 0.2e1 + t893 * t873 * t92 / 0.4e1 - 0.4e1 * t873 * t93 - t90 * t873 * t92 - 0.4e1 * t316 * t865 - t85 * t865 * t92)))
  t924 = 0.1e1 / t107 / t106
  t926 = s0 ** 2
  t927 = t111 ** 2
  t930 = 0.1e1 / t112 / t927 / t337
  t936 = 0.1e1 / t113 / t927
  t944 = tau0 ** 2
  t948 = 0.1e1 / t112 / t927 / r0
  t949 = t170 * t944 * t948
  t954 = t164 * t944 * t948
  t960 = t176 * t944 * t948
  t969 = t182 * t944 * t948
  t978 = t188 * t944 * t948
  t987 = t194 * t944 * t948
  t990 = 0.250e3 / 0.3e1 * t156 * t949 + 0.250e3 / 0.3e1 * t160 * t149 * t954 + 0.200e3 * t380 * t949 + 0.350e3 / 0.3e1 * t162 * t960 + 0.350e3 / 0.3e1 * t166 * t155 * t949 + 0.2450e4 / 0.9e1 * t388 * t960 + 0.1400e4 / 0.9e1 * t168 * t969 + 0.1400e4 / 0.9e1 * t172 * t161 * t960 + 0.3200e4 / 0.9e1 * t395 * t969 + 0.200e3 * t174 * t978 + 0.200e3 * t178 * t167 * t969 + 0.450e3 * t402 * t978 + 0.250e3 * t180 * t987
  t991 = t348 * t339
  t996 = t355 * t339
  t1001 = t362 * t339
  t1006 = t369 * t339
  t1011 = t376 * t339
  t1016 = t384 * t339
  t1021 = t391 * t339
  t1026 = -0.40e2 / 0.9e1 * t132 * t991 - 0.80e2 / 0.9e1 * t352 * t991 - 0.80e2 / 0.9e1 * t138 * t996 - 0.40e2 / 0.3e1 * t359 * t996 - 0.40e2 / 0.3e1 * t144 * t1001 - 0.160e3 / 0.9e1 * t366 * t1001 - 0.160e3 / 0.9e1 * t150 * t1006 - 0.200e3 / 0.9e1 * t373 * t1006 - 0.200e3 / 0.9e1 * t156 * t1011 - 0.80e2 / 0.3e1 * t380 * t1011 - 0.80e2 / 0.3e1 * t162 * t1016 - 0.280e3 / 0.9e1 * t388 * t1016 - 0.280e3 / 0.9e1 * t168 * t1021 - 0.320e3 / 0.9e1 * t395 * t1021
  t1028 = t398 * t339
  t1033 = t405 * t339
  t1038 = t412 * t339
  t1043 = t421 * t339
  t1047 = t146 * t944 * t948
  t1058 = t420 * t944 * t948
  t1064 = -0.320e3 / 0.9e1 * t174 * t1028 - 0.40e2 * t402 * t1028 - 0.40e2 * t180 * t1033 - 0.400e3 / 0.9e1 * t409 * t1033 - 0.400e3 / 0.9e1 * t186 * t1038 - 0.440e3 / 0.9e1 * t416 * t1038 - 0.440e3 / 0.9e1 * t192 * t1043 + 0.50e2 / 0.9e1 * t132 * t1047 + 0.200e3 / 0.9e1 * t352 * t1047 + 0.250e3 * t184 * t173 * t978 + 0.5000e4 / 0.9e1 * t409 * t987 + 0.2750e4 / 0.9e1 * t186 * t1058 + 0.2750e4 / 0.9e1 * t190 * t179 * t987
  t1070 = 0.1e1 / t175 / t157 * t944 * t948
  t1074 = t152 * t944 * t948
  t1083 = t158 * t944 * t948
  t1098 = t339 * t134
  t1102 = t948 * t140
  t1108 = 0.6050e4 / 0.9e1 * t416 * t1058 + 0.1100e4 / 0.3e1 * t192 * t1070 + 0.50e2 / 0.3e1 * t138 * t1074 + 0.50e2 / 0.3e1 * t142 * t131 * t1047 + 0.50e2 * t359 * t1074 + 0.100e3 / 0.3e1 * t144 * t1083 + 0.100e3 / 0.3e1 * t148 * t137 * t1074 + 0.800e3 / 0.9e1 * t366 * t1083 + 0.500e3 / 0.9e1 * t150 * t954 + 0.500e3 / 0.9e1 * t154 * t143 * t1083 + 0.1250e4 / 0.9e1 * t373 * t954 - 0.40e2 / 0.9e1 * t344 * t1098 + 0.50e2 / 0.9e1 * t124 * t944 * t1102 + 0.50e2 / 0.9e1 * t136 * t944 * t1102
  t1116 = t125 * t924
  t1154 = 0.100e3 / 0.3e1 * t212 * t137 * t1074 + 0.800e3 / 0.9e1 * t448 * t1083 + 0.500e3 / 0.9e1 * t213 * t954 + 0.500e3 / 0.9e1 * t215 * t143 * t1083 + 0.1250e4 / 0.9e1 * t453 * t954 + 0.250e3 / 0.3e1 * t216 * t949 + 0.250e3 / 0.3e1 * t218 * t149 * t954 + 0.200e3 * t458 * t949 + 0.50e2 / 0.9e1 * t204 * t1047 - 0.320e3 / 0.9e1 * t225 * t1028 - 0.40e2 * t474 * t1028 - 0.40e2 * t228 * t1033 - 0.400e3 / 0.9e1 * t479 * t1033
  t1186 = -0.400e3 / 0.9e1 * t231 * t1038 - 0.440e3 / 0.9e1 * t484 * t1038 - 0.440e3 / 0.9e1 * t234 * t1043 + 0.2750e4 / 0.9e1 * t231 * t1058 + 0.2750e4 / 0.9e1 * t233 * t179 * t987 + 0.6050e4 / 0.9e1 * t484 * t1058 + 0.1100e4 / 0.3e1 * t234 * t1070 + 0.350e3 / 0.3e1 * t219 * t960 + 0.350e3 / 0.3e1 * t221 * t155 * t949 + 0.2450e4 / 0.9e1 * t464 * t960 + 0.1400e4 / 0.9e1 * t222 * t969 + 0.1400e4 / 0.9e1 * t224 * t161 * t960 + 0.3200e4 / 0.9e1 * t469 * t969 + 0.200e3 * t225 * t978
  t1217 = 0.200e3 * t227 * t167 * t969 + 0.450e3 * t474 * t978 + 0.250e3 * t228 * t987 + 0.250e3 * t230 * t173 * t978 + 0.5000e4 / 0.9e1 * t479 * t987 + 0.50e2 / 0.3e1 * t207 * t1074 + 0.50e2 / 0.3e1 * t209 * t131 * t1047 + 0.50e2 * t443 * t1074 + 0.100e3 / 0.3e1 * t210 * t1083 - 0.40e2 / 0.3e1 * t443 * t996 - 0.40e2 / 0.3e1 * t210 * t1001 - 0.160e3 / 0.9e1 * t448 * t1001 - 0.160e3 / 0.9e1 * t213 * t1006
  t1248 = -0.200e3 / 0.9e1 * t453 * t1006 - 0.200e3 / 0.9e1 * t216 * t1011 - 0.80e2 / 0.3e1 * t458 * t1011 - 0.80e2 / 0.3e1 * t219 * t1016 - 0.280e3 / 0.9e1 * t464 * t1016 - 0.280e3 / 0.9e1 * t222 * t1021 - 0.320e3 / 0.9e1 * t469 * t1021 + 0.200e3 / 0.9e1 * t438 * t1047 - 0.40e2 / 0.9e1 * t204 * t991 - 0.80e2 / 0.9e1 * t438 * t991 - 0.80e2 / 0.9e1 * t207 * t996 + 0.50e2 / 0.9e1 * t203 * t944 * t1102 + 0.50e2 / 0.9e1 * t206 * t944 * t1102 - 0.40e2 / 0.9e1 * t433 * t1098
  t1257 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t774 * t239 - t778 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t330 - 0.3e1 / 0.4e1 * t30 * t493 + t789 - t792 / 0.4e1 - t795 / 0.4e1 - 0.3e1 / 0.8e1 * t245 * t31 * t912 * t238 - 0.3e1 / 0.4e1 * t245 * t329 * t492 - 0.3e1 / 0.8e1 * t245 * t104 * (-0.76906968678720000000000000000000000000000000000000e-3 / t333 / t119 * t125 * t924 * t926 * t930 * t196 + 0.57808982880000000000000000000000000000000000000000e-1 * t336 * s0 * t936 * t196 - 0.31532172480000000000000000000000000000000000000000e-1 * t336 * t340 * t426 + t122 * (t990 + t1026 + t1064 + t1108) + 0.50297210791037951531778692272519433013260173754001e-1 * t428 * t936 * t199 * t236 - 0.34088340999255810609977046547411469101414150735753e-3 * t1116 * t926 * t930 * t199 * t236 - 0.27434842249657064471879286694101508916323731138546e-1 * t428 * t429 * t490 + t201 * (t1154 + t1186 + t1217 + t1248)))
  t1258 = t503 ** 2
  t1259 = 0.1e1 / t1258
  t1260 = t505 ** 2
  t1263 = -t769
  t1264 = f.my_piecewise5(t14, 0, t10, 0, t1263)
  t1268 = f.my_piecewise3(t502, 0, 0.4e1 / 0.9e1 * t1259 * t1260 + 0.4e1 / 0.3e1 * t503 * t1264)
  t1272 = t509 * t676
  t1279 = t674 * t785 * t566 * t668 / 0.12e2
  t1282 = t674 * t247 * t752 * t668
  t1284 = t697 ** 2
  t1289 = 0.2e1 / 0.81e2 * t38 * t802 * t515
  t1291 = t38 * t256 * t692
  t1294 = 0.1e1 / t684 / t514
  t1295 = t691 ** 2
  t1301 = 0.1e1 / t686 / t511
  t1302 = t688 ** 2
  t1305 = f.my_piecewise5(t44, 0, t42, 0, t1263)
  t1309 = f.my_piecewise3(t512, 0, -0.2e1 / 0.9e1 * t1301 * t1302 + t687 * t1305 / 0.3e1)
  t1314 = t1289 + t1291 / 0.27e2 + t38 * t40 * t1294 * t1295 / 0.9e1 - t38 * t40 * t685 * t1309 / 0.18e2
  t1315 = f.my_piecewise3(t520, t1314, 0)
  t1343 = 0.1e1 / t543 / t522
  t1348 = t526 * t1284 / 0.6e1 - t680 * t1315 / 0.18e2 - t529 * t1284 / 0.48e2 + t701 * t1315 / 0.240e3 + t532 * t1284 / 0.640e3 - t705 * t1315 / 0.4480e4 - t535 * t1284 / 0.11520e5 + t709 * t1315 / 0.103680e6 + t538 * t1284 / 0.258048e6 - t713 * t1315 / 0.2838528e7 - t541 * t1284 / 0.6881280e7 + t717 * t1315 / 0.89456640e8 + t544 * t1284 / 0.212336640e9 - t721 * t1315 / 0.3185049600e10 - t1343 * t1284 / 0.7431782400e10 + t725 * t1315 / 0.126340300800e12
  t1349 = f.my_piecewise3(t520, 0, t1314)
  t1354 = t552 ** 2
  t1356 = 0.1e1 / t1354 / t547
  t1357 = t729 ** 2
  t1361 = t555 * t736
  t1369 = 0.1e1 / t1354
  t1377 = 0.1e1 / t1354 / t552
  t1396 = f.my_piecewise3(t519, t1348, -0.8e1 / 0.3e1 * t1349 * t562 - 0.16e2 / 0.3e1 * t729 * t748 - 0.8e1 / 0.3e1 * t547 * (-t1356 * t1357 * t555 / 0.2e1 + 0.2e1 * t1361 * t1357 - t731 * t1349 + 0.2e1 * t1349 * t559 + 0.4e1 * t729 * t745 + 0.2e1 * t547 * (-0.2e1 * t1369 * t1357 * t555 + t736 * t1349 * t555 / 0.2e1 + t1377 * t1357 * t555 / 0.4e1 - 0.4e1 * t1357 * t556 - t553 * t1357 * t555 - 0.4e1 * t740 * t1349 - t548 * t1349 * t555)))
  t1402 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t5 * t1268 * t669 - t1272 / 0.4e1 - 0.3e1 / 0.4e1 * t509 * t754 + t1279 - t1282 / 0.4e1 - 0.3e1 / 0.8e1 * t674 * t31 * t1396 * t668)
  d11 = 0.2e1 * t497 + 0.2e1 * t758 + t6 * (t1257 + t1402)
  t1405 = -t7 - t24
  t1406 = f.my_piecewise5(t10, 0, t14, 0, t1405)
  t1409 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t1406)
  t1410 = t5 * t1409
  t1413 = f.my_piecewise5(t42, 0, t44, 0, t1405)
  t1416 = f.my_piecewise3(t47, 0, t263 * t1413 / 0.3e1)
  t1417 = t261 * t1416
  t1421 = -t259 - t38 * t40 * t1417 / 0.18e2
  t1422 = f.my_piecewise3(t56, t1421, 0)
  t1440 = f.my_piecewise3(t56, 0, t1421)
  t1452 = t312 * t1440 * t92 / 0.2e1 - 0.4e1 * t316 * t1440 - t85 * t1440 * t92
  t1455 = -t307 * t1440 + 0.2e1 * t1440 * t96 + 0.2e1 * t83 * t1452
  t1459 = f.my_piecewise3(t55, -t253 * t1422 / 0.18e2 + t277 * t1422 / 0.240e3 - t281 * t1422 / 0.4480e4 + t285 * t1422 / 0.103680e6 - t289 * t1422 / 0.2838528e7 + t293 * t1422 / 0.89456640e8 - t297 * t1422 / 0.3185049600e10 + t301 * t1422 / 0.126340300800e12, -0.8e1 / 0.3e1 * t1440 * t99 - 0.8e1 / 0.3e1 * t83 * t1455)
  t1460 = t31 * t1459
  t1461 = t1460 * t238
  t1465 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t1410 * t239 - t251 - 0.3e1 / 0.8e1 * t245 * t1461)
  t1466 = -t1405
  t1467 = f.my_piecewise5(t14, 0, t10, 0, t1466)
  t1470 = f.my_piecewise3(t502, 0, 0.4e1 / 0.3e1 * t503 * t1467)
  t1471 = t5 * t1470
  t1474 = f.my_piecewise5(t44, 0, t42, 0, t1466)
  t1477 = f.my_piecewise3(t512, 0, t687 * t1474 / 0.3e1)
  t1478 = t685 * t1477
  t1482 = -t683 - t38 * t40 * t1478 / 0.18e2
  t1483 = f.my_piecewise3(t520, t1482, 0)
  t1501 = f.my_piecewise3(t520, 0, t1482)
  t1513 = t736 * t1501 * t555 / 0.2e1 - 0.4e1 * t740 * t1501 - t548 * t1501 * t555
  t1516 = 0.2e1 * t1501 * t559 - t731 * t1501 + 0.2e1 * t547 * t1513
  t1520 = f.my_piecewise3(t519, -t680 * t1483 / 0.18e2 + t701 * t1483 / 0.240e3 - t705 * t1483 / 0.4480e4 + t709 * t1483 / 0.103680e6 - t713 * t1483 / 0.2838528e7 + t717 * t1483 / 0.89456640e8 - t721 * t1483 / 0.3185049600e10 + t725 * t1483 / 0.126340300800e12, -0.8e1 / 0.3e1 * t1501 * t562 - 0.8e1 / 0.3e1 * t547 * t1516)
  t1521 = t31 * t1520
  t1522 = t1521 * t668
  t1525 = t576 ** 2
  t1528 = 0.1e1 / t1525 * t105 * t109
  t1529 = t568 * r1
  t1531 = 0.1e1 / t570 / t1529
  t1532 = s2 * t1531
  t1536 = t124 * tau1
  t1537 = t572 * t586
  t1540 = t591 * tau1
  t1541 = t1540 * t572
  t1544 = t136 * t583
  t1547 = t596 * tau1
  t1548 = t1547 * t572
  t1551 = t142 * t588
  t1554 = t601 * tau1
  t1555 = t1554 * t572
  t1558 = t148 * t593
  t1561 = t606 * tau1
  t1562 = t1561 * t572
  t1565 = t154 * t598
  t1568 = t611 * tau1
  t1569 = t1568 * t572
  t1572 = t160 * t603
  t1575 = 0.5e1 / 0.3e1 * t1536 * t1537 + 0.5e1 / 0.3e1 * t584 * t1541 + 0.10e2 / 0.3e1 * t1544 * t1541 + 0.10e2 / 0.3e1 * t589 * t1548 + 0.5e1 * t1551 * t1548 + 0.5e1 * t594 * t1555 + 0.20e2 / 0.3e1 * t1558 * t1555 + 0.20e2 / 0.3e1 * t599 * t1562 + 0.25e2 / 0.3e1 * t1565 * t1562 + 0.25e2 / 0.3e1 * t604 * t1569 + 0.10e2 * t1572 * t1569
  t1576 = t616 * tau1
  t1577 = t1576 * t572
  t1580 = t166 * t608
  t1583 = t621 * tau1
  t1584 = t1583 * t572
  t1587 = t172 * t613
  t1590 = t626 * tau1
  t1591 = t1590 * t572
  t1594 = t178 * t618
  t1597 = t631 * tau1
  t1598 = t1597 * t572
  t1601 = t184 * t623
  t1604 = t636 * tau1
  t1605 = t1604 * t572
  t1608 = t190 * t628
  t1612 = 0.1e1 / t620 / t600
  t1613 = t1612 * tau1
  t1614 = t1613 * t572
  t1617 = 0.10e2 * t609 * t1577 + 0.35e2 / 0.3e1 * t1580 * t1577 + 0.35e2 / 0.3e1 * t614 * t1584 + 0.40e2 / 0.3e1 * t1587 * t1584 + 0.40e2 / 0.3e1 * t619 * t1591 + 0.15e2 * t1594 * t1591 + 0.15e2 * t624 * t1598 + 0.50e2 / 0.3e1 * t1601 * t1598 + 0.50e2 / 0.3e1 * t629 * t1605 + 0.55e2 / 0.3e1 * t1608 * t1605 + 0.55e2 / 0.3e1 * t634 * t1614
  t1618 = t1575 + t1617
  t1620 = t110 * s2
  t1621 = t1531 * t641
  t1625 = t203 * tau1
  t1630 = t206 * t583
  t1635 = t209 * t588
  t1640 = t212 * t593
  t1645 = t215 * t598
  t1650 = t218 * t603
  t1653 = 0.5e1 / 0.3e1 * t1625 * t1537 + 0.5e1 / 0.3e1 * t644 * t1541 + 0.10e2 / 0.3e1 * t1630 * t1541 + 0.10e2 / 0.3e1 * t646 * t1548 + 0.5e1 * t1635 * t1548 + 0.5e1 * t648 * t1555 + 0.20e2 / 0.3e1 * t1640 * t1555 + 0.20e2 / 0.3e1 * t650 * t1562 + 0.25e2 / 0.3e1 * t1645 * t1562 + 0.25e2 / 0.3e1 * t652 * t1569 + 0.10e2 * t1650 * t1569
  t1656 = t221 * t608
  t1661 = t224 * t613
  t1666 = t227 * t618
  t1671 = t230 * t623
  t1676 = t233 * t628
  t1681 = 0.10e2 * t654 * t1577 + 0.35e2 / 0.3e1 * t1656 * t1577 + 0.35e2 / 0.3e1 * t656 * t1584 + 0.40e2 / 0.3e1 * t1661 * t1584 + 0.40e2 / 0.3e1 * t658 * t1591 + 0.15e2 * t1666 * t1591 + 0.15e2 * t660 * t1598 + 0.50e2 / 0.3e1 * t1671 * t1598 + 0.50e2 / 0.3e1 * t662 * t1605 + 0.55e2 / 0.3e1 * t1676 * t1605 + 0.55e2 / 0.3e1 * t664 * t1614
  t1682 = t1653 + t1681
  t1684 = -0.15766086240000000000000000000000000000000000000000e-1 * t1528 * t1532 * t638 + t579 * t1618 - 0.13717421124828532235939643347050754458161865569273e-1 * t1620 * t1621 * t666 + t643 * t1682
  t1685 = t567 * t1684
  t1689 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t1471 * t669 - t678 - 0.3e1 / 0.8e1 * t674 * t1522 - 0.3e1 / 0.8e1 * t674 * t1685)
  t1693 = 0.2e1 * t767
  t1694 = f.my_piecewise5(t10, 0, t14, 0, t1693)
  t1698 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t761 * t1406 * t26 + 0.4e1 / 0.3e1 * t21 * t1694)
  t1702 = t1410 * t249
  t1715 = t245 * t247 * t1459 * t238
  t1722 = t38 * t256 * t1417
  t1725 = t37 * f.p.cam_omega * t2
  t1734 = f.my_piecewise5(t42, 0, t44, 0, t1693)
  t1738 = f.my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t817 * t1413 * t264 + t263 * t1734 / 0.3e1)
  t1743 = t805 + t807 / 0.54e2 + t1722 / 0.54e2 + t1725 * t39 * t810 * t1416 * t267 / 0.9e1 - t38 * t40 * t261 * t1738 / 0.18e2
  t1744 = f.my_piecewise3(t56, t1743, 0)
  t1782 = t62 * t1422 * t273 / 0.6e1 - t253 * t1744 / 0.18e2 - t65 * t1422 * t273 / 0.48e2 + t277 * t1744 / 0.240e3 + t68 * t1422 * t273 / 0.640e3 - t281 * t1744 / 0.4480e4 - t71 * t1422 * t273 / 0.11520e5 + t285 * t1744 / 0.103680e6 + t74 * t1422 * t273 / 0.258048e6 - t289 * t1744 / 0.2838528e7 - t77 * t1422 * t273 / 0.6881280e7 + t293 * t1744 / 0.89456640e8 + t80 * t1422 * t273 / 0.212336640e9 - t297 * t1744 / 0.3185049600e10 - t859 * t1422 * t273 / 0.7431782400e10 + t301 * t1744 / 0.126340300800e12
  t1783 = f.my_piecewise3(t56, 0, t1743)
  t1788 = t92 * t1440
  t1802 = t92 * t305
  t1827 = f.my_piecewise3(t55, t1782, -0.8e1 / 0.3e1 * t1783 * t99 - 0.8e1 / 0.3e1 * t1440 * t324 - 0.8e1 / 0.3e1 * t305 * t1455 - 0.8e1 / 0.3e1 * t83 * (-t872 * t305 * t1788 / 0.2e1 + 0.2e1 * t877 * t1440 * t305 - t307 * t1783 + 0.2e1 * t1783 * t96 + 0.2e1 * t1440 * t321 + 0.2e1 * t305 * t1452 + 0.2e1 * t83 * (-0.2e1 * t885 * t1440 * t1802 + t312 * t1783 * t92 / 0.2e1 + t893 * t1440 * t1802 / 0.4e1 - 0.4e1 * t305 * t93 * t1440 - t90 * t305 * t1788 - 0.4e1 * t316 * t1783 - t85 * t1783 * t92)))
  t1835 = -0.3e1 / 0.8e1 * t5 * t1698 * t239 - t1702 / 0.8e1 - 0.3e1 / 0.8e1 * t1410 * t330 - 0.3e1 / 0.8e1 * t1410 * t493 - t778 / 0.8e1 + t789 - t792 / 0.8e1 - t795 / 0.8e1 - 0.3e1 / 0.8e1 * t30 * t1461 - t1715 / 0.8e1 - 0.3e1 / 0.8e1 * t245 * t31 * t1827 * t238 - 0.3e1 / 0.8e1 * t245 * t1460 * t492
  t1836 = f.my_piecewise3(t1, 0, t1835)
  t1840 = f.my_piecewise5(t14, 0, t10, 0, -t1693)
  t1844 = f.my_piecewise3(t502, 0, 0.4e1 / 0.9e1 * t1259 * t1467 * t505 + 0.4e1 / 0.3e1 * t503 * t1840)
  t1848 = t1471 * t676
  t1858 = t674 * t247 * t1520 * t668
  t1865 = t38 * t256 * t1478
  t1875 = f.my_piecewise5(t44, 0, t42, 0, -t1693)
  t1879 = f.my_piecewise3(t512, 0, -0.2e1 / 0.9e1 * t1301 * t1474 * t688 + t687 * t1875 / 0.3e1)
  t1884 = t1289 + t1291 / 0.54e2 + t1865 / 0.54e2 + t1725 * t39 * t1294 * t1477 * t691 / 0.9e1 - t38 * t40 * t685 * t1879 / 0.18e2
  t1885 = f.my_piecewise3(t520, t1884, 0)
  t1923 = t526 * t1483 * t697 / 0.6e1 - t680 * t1885 / 0.18e2 - t529 * t1483 * t697 / 0.48e2 + t701 * t1885 / 0.240e3 + t532 * t1483 * t697 / 0.640e3 - t705 * t1885 / 0.4480e4 - t535 * t1483 * t697 / 0.11520e5 + t709 * t1885 / 0.103680e6 + t538 * t1483 * t697 / 0.258048e6 - t713 * t1885 / 0.2838528e7 - t541 * t1483 * t697 / 0.6881280e7 + t717 * t1885 / 0.89456640e8 + t544 * t1483 * t697 / 0.212336640e9 - t721 * t1885 / 0.3185049600e10 - t1343 * t1483 * t697 / 0.7431782400e10 + t725 * t1885 / 0.126340300800e12
  t1924 = f.my_piecewise3(t520, 0, t1884)
  t1929 = t555 * t1501
  t1943 = t555 * t729
  t1968 = f.my_piecewise3(t519, t1923, -0.8e1 / 0.3e1 * t1924 * t562 - 0.8e1 / 0.3e1 * t1501 * t748 - 0.8e1 / 0.3e1 * t729 * t1516 - 0.8e1 / 0.3e1 * t547 * (-t1356 * t729 * t1929 / 0.2e1 + 0.2e1 * t1361 * t1501 * t729 - t731 * t1924 + 0.2e1 * t1924 * t559 + 0.2e1 * t1501 * t745 + 0.2e1 * t729 * t1513 + 0.2e1 * t547 * (-0.2e1 * t1369 * t1501 * t1943 + t736 * t1924 * t555 / 0.2e1 + t1377 * t1501 * t1943 / 0.4e1 - 0.4e1 * t729 * t556 * t1501 - t553 * t729 * t1929 - 0.4e1 * t740 * t1924 - t548 * t1924 * t555)))
  t1976 = t674 * t675 * t1684
  t1981 = -0.3e1 / 0.8e1 * t5 * t1844 * t669 - t1848 / 0.8e1 - 0.3e1 / 0.8e1 * t1471 * t754 - t1272 / 0.8e1 + t1279 - t1282 / 0.8e1 - 0.3e1 / 0.8e1 * t509 * t1522 - t1858 / 0.8e1 - 0.3e1 / 0.8e1 * t674 * t31 * t1968 * t668 - 0.3e1 / 0.8e1 * t509 * t1685 - t1976 / 0.8e1 - 0.3e1 / 0.8e1 * t674 * t753 * t1684
  t1982 = f.my_piecewise3(t499, 0, t1981)
  d12 = t497 + t758 + t1465 + t1689 + t6 * (t1836 + t1982)
  t1987 = t1406 ** 2
  t1991 = 0.2e1 * t23 + 0.2e1 * t767
  t1992 = f.my_piecewise5(t10, 0, t14, 0, t1991)
  t1996 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t761 * t1987 + 0.4e1 / 0.3e1 * t21 * t1992)
  t2004 = t1422 ** 2
  t2008 = t1416 ** 2
  t2013 = t1413 ** 2
  t2016 = f.my_piecewise5(t42, 0, t44, 0, t1991)
  t2020 = f.my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t817 * t2013 + t263 * t2016 / 0.3e1)
  t2025 = t805 + t1722 / 0.27e2 + t38 * t40 * t810 * t2008 / 0.9e1 - t38 * t40 * t261 * t2020 / 0.18e2
  t2026 = f.my_piecewise3(t56, t2025, 0)
  t2057 = t62 * t2004 / 0.6e1 - t253 * t2026 / 0.18e2 - t65 * t2004 / 0.48e2 + t277 * t2026 / 0.240e3 + t68 * t2004 / 0.640e3 - t281 * t2026 / 0.4480e4 - t71 * t2004 / 0.11520e5 + t285 * t2026 / 0.103680e6 + t74 * t2004 / 0.258048e6 - t289 * t2026 / 0.2838528e7 - t77 * t2004 / 0.6881280e7 + t293 * t2026 / 0.89456640e8 + t80 * t2004 / 0.212336640e9 - t297 * t2026 / 0.3185049600e10 - t859 * t2004 / 0.7431782400e10 + t301 * t2026 / 0.126340300800e12
  t2058 = f.my_piecewise3(t56, 0, t2025)
  t2063 = t1440 ** 2
  t2098 = f.my_piecewise3(t55, t2057, -0.8e1 / 0.3e1 * t2058 * t99 - 0.16e2 / 0.3e1 * t1440 * t1455 - 0.8e1 / 0.3e1 * t83 * (-t872 * t2063 * t92 / 0.2e1 + 0.2e1 * t877 * t2063 - t307 * t2058 + 0.2e1 * t2058 * t96 + 0.4e1 * t1440 * t1452 + 0.2e1 * t83 * (-0.2e1 * t885 * t2063 * t92 + t312 * t2058 * t92 / 0.2e1 + t893 * t2063 * t92 / 0.4e1 - 0.4e1 * t2063 * t93 - t90 * t2063 * t92 - 0.4e1 * t316 * t2058 - t85 * t2058 * t92)))
  t2104 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1996 * t239 - t1702 / 0.4e1 - 0.3e1 / 0.4e1 * t1410 * t1461 + t789 - t1715 / 0.4e1 - 0.3e1 / 0.8e1 * t245 * t31 * t2098 * t238)
  t2105 = t1467 ** 2
  t2108 = -t1991
  t2109 = f.my_piecewise5(t14, 0, t10, 0, t2108)
  t2113 = f.my_piecewise3(t502, 0, 0.4e1 / 0.9e1 * t1259 * t2105 + 0.4e1 / 0.3e1 * t503 * t2109)
  t2124 = t1483 ** 2
  t2128 = t1477 ** 2
  t2133 = t1474 ** 2
  t2136 = f.my_piecewise5(t44, 0, t42, 0, t2108)
  t2140 = f.my_piecewise3(t512, 0, -0.2e1 / 0.9e1 * t1301 * t2133 + t687 * t2136 / 0.3e1)
  t2145 = t1289 + t1865 / 0.27e2 + t38 * t40 * t1294 * t2128 / 0.9e1 - t38 * t40 * t685 * t2140 / 0.18e2
  t2146 = f.my_piecewise3(t520, t2145, 0)
  t2177 = t526 * t2124 / 0.6e1 - t680 * t2146 / 0.18e2 - t529 * t2124 / 0.48e2 + t701 * t2146 / 0.240e3 + t532 * t2124 / 0.640e3 - t705 * t2146 / 0.4480e4 - t535 * t2124 / 0.11520e5 + t709 * t2146 / 0.103680e6 + t538 * t2124 / 0.258048e6 - t713 * t2146 / 0.2838528e7 - t541 * t2124 / 0.6881280e7 + t717 * t2146 / 0.89456640e8 + t544 * t2124 / 0.212336640e9 - t721 * t2146 / 0.3185049600e10 - t1343 * t2124 / 0.7431782400e10 + t725 * t2146 / 0.126340300800e12
  t2178 = f.my_piecewise3(t520, 0, t2145)
  t2183 = t1501 ** 2
  t2218 = f.my_piecewise3(t519, t2177, -0.8e1 / 0.3e1 * t2178 * t562 - 0.16e2 / 0.3e1 * t1501 * t1516 - 0.8e1 / 0.3e1 * t547 * (-t1356 * t2183 * t555 / 0.2e1 + 0.2e1 * t1361 * t2183 - t731 * t2178 + 0.2e1 * t2178 * t559 + 0.4e1 * t1501 * t1513 + 0.2e1 * t547 * (-0.2e1 * t1369 * t2183 * t555 + t736 * t2178 * t555 / 0.2e1 + t1377 * t2183 * t555 / 0.4e1 - 0.4e1 * t2183 * t556 - t553 * t2183 * t555 - 0.4e1 * t740 * t2178 - t548 * t2178 * t555)))
  t2230 = s2 ** 2
  t2231 = t568 ** 2
  t2234 = 0.1e1 / t569 / t2231 / t1529
  t2240 = 0.1e1 / t570 / t2231
  t2248 = t1576 * t1531
  t2251 = tau1 ** 2
  t2255 = 0.1e1 / t569 / t2231 / r1
  t2256 = t1612 * t2251 * t2255
  t2260 = t611 * t2251 * t2255
  t2265 = t606 * t2251 * t2255
  t2271 = t616 * t2251 * t2255
  t2280 = t621 * t2251 * t2255
  t2289 = t626 * t2251 * t2255
  t2295 = -0.80e2 / 0.3e1 * t609 * t2248 + 0.2750e4 / 0.9e1 * t629 * t2256 + 0.500e3 / 0.9e1 * t599 * t2260 + 0.500e3 / 0.9e1 * t154 * t593 * t2265 + 0.1250e4 / 0.9e1 * t1565 * t2260 + 0.250e3 / 0.3e1 * t604 * t2271 + 0.250e3 / 0.3e1 * t160 * t598 * t2260 + 0.200e3 * t1572 * t2271 + 0.350e3 / 0.3e1 * t609 * t2280 + 0.350e3 / 0.3e1 * t166 * t603 * t2271 + 0.2450e4 / 0.9e1 * t1580 * t2280 + 0.1400e4 / 0.9e1 * t614 * t2289 + 0.1400e4 / 0.9e1 * t172 * t608 * t2280
  t2299 = t631 * t2251 * t2255
  t2311 = t601 * t2251 * t2255
  t2318 = t596 * t2251 * t2255
  t2323 = t1547 * t1531
  t2328 = t1554 * t1531
  t2335 = 0.3200e4 / 0.9e1 * t1587 * t2289 + 0.200e3 * t619 * t2299 + 0.200e3 * t178 * t613 * t2289 + 0.450e3 * t1594 * t2299 + 0.100e3 / 0.3e1 * t594 * t2265 + 0.100e3 / 0.3e1 * t148 * t588 * t2311 + 0.800e3 / 0.9e1 * t1558 * t2265 + 0.50e2 / 0.3e1 * t142 * t583 * t2318 + 0.50e2 * t1551 * t2311 - 0.80e2 / 0.9e1 * t589 * t2323 - 0.40e2 / 0.3e1 * t1551 * t2323 - 0.40e2 / 0.3e1 * t594 * t2328 + 0.50e2 / 0.9e1 * t584 * t2318 + 0.200e3 / 0.9e1 * t1544 * t2318
  t2339 = t1597 * t1531
  t2342 = t1540 * t1531
  t2349 = t1583 * t1531
  t2354 = t1590 * t1531
  t2359 = t1561 * t1531
  t2362 = t1568 * t1531
  t2369 = t636 * t2251 * t2255
  t2372 = 0.50e2 / 0.3e1 * t589 * t2311 - 0.40e2 * t624 * t2339 - 0.40e2 / 0.9e1 * t584 * t2342 - 0.80e2 / 0.9e1 * t1544 * t2342 - 0.280e3 / 0.9e1 * t1580 * t2248 - 0.280e3 / 0.9e1 * t614 * t2349 - 0.320e3 / 0.9e1 * t1587 * t2349 - 0.320e3 / 0.9e1 * t619 * t2354 - 0.40e2 * t1594 * t2354 - 0.200e3 / 0.9e1 * t1565 * t2359 - 0.200e3 / 0.9e1 * t604 * t2362 - 0.80e2 / 0.3e1 * t1572 * t2362 + 0.2750e4 / 0.9e1 * t190 * t623 * t2369
  t2378 = 0.1e1 / t620 / t605 * t2251 * t2255
  t2394 = t1604 * t1531
  t2399 = t1613 * t1531
  t2402 = t1531 * t586
  t2406 = t2255 * t591
  t2412 = 0.6050e4 / 0.9e1 * t1608 * t2256 + 0.1100e4 / 0.3e1 * t634 * t2378 - 0.160e3 / 0.9e1 * t1558 * t2328 - 0.160e3 / 0.9e1 * t599 * t2359 + 0.250e3 * t624 * t2369 + 0.250e3 * t184 * t618 * t2299 + 0.5000e4 / 0.9e1 * t1601 * t2369 - 0.400e3 / 0.9e1 * t1601 * t2339 - 0.400e3 / 0.9e1 * t629 * t2394 - 0.440e3 / 0.9e1 * t1608 * t2394 - 0.440e3 / 0.9e1 * t634 * t2399 - 0.40e2 / 0.9e1 * t1536 * t2402 + 0.50e2 / 0.9e1 * t124 * t2251 * t2406 + 0.50e2 / 0.9e1 * t136 * t2251 * t2406
  t2458 = 0.2750e4 / 0.9e1 * t233 * t623 * t2369 + 0.6050e4 / 0.9e1 * t1676 * t2256 + 0.1100e4 / 0.3e1 * t664 * t2378 + 0.500e3 / 0.9e1 * t650 * t2260 + 0.500e3 / 0.9e1 * t215 * t593 * t2265 + 0.1250e4 / 0.9e1 * t1645 * t2260 + 0.250e3 / 0.3e1 * t652 * t2271 + 0.250e3 / 0.3e1 * t218 * t598 * t2260 + 0.200e3 * t1650 * t2271 + 0.350e3 / 0.3e1 * t654 * t2280 + 0.350e3 / 0.3e1 * t221 * t603 * t2271 + 0.2450e4 / 0.9e1 * t1656 * t2280 + 0.1400e4 / 0.9e1 * t656 * t2289
  t2489 = 0.1400e4 / 0.9e1 * t224 * t608 * t2280 + 0.3200e4 / 0.9e1 * t1661 * t2289 + 0.200e3 * t658 * t2299 - 0.280e3 / 0.9e1 * t1656 * t2248 - 0.280e3 / 0.9e1 * t656 * t2349 - 0.320e3 / 0.9e1 * t1661 * t2349 - 0.320e3 / 0.9e1 * t658 * t2354 - 0.40e2 * t1666 * t2354 - 0.40e2 * t660 * t2339 - 0.400e3 / 0.9e1 * t1671 * t2339 - 0.400e3 / 0.9e1 * t662 * t2394 - 0.440e3 / 0.9e1 * t1676 * t2394 - 0.440e3 / 0.9e1 * t664 * t2399 + 0.200e3 * t227 * t613 * t2289
  t2519 = 0.450e3 * t1666 * t2299 + 0.50e2 / 0.9e1 * t644 * t2318 + 0.200e3 / 0.9e1 * t1630 * t2318 + 0.50e2 / 0.3e1 * t646 * t2311 + 0.50e2 / 0.3e1 * t209 * t583 * t2318 + 0.50e2 * t1635 * t2311 + 0.100e3 / 0.3e1 * t648 * t2265 + 0.100e3 / 0.3e1 * t212 * t588 * t2311 + 0.800e3 / 0.9e1 * t1640 * t2265 - 0.40e2 / 0.9e1 * t644 * t2342 - 0.80e2 / 0.9e1 * t1630 * t2342 - 0.80e2 / 0.9e1 * t646 * t2323 - 0.40e2 / 0.3e1 * t1635 * t2323
  t2551 = -0.40e2 / 0.3e1 * t648 * t2328 - 0.160e3 / 0.9e1 * t1640 * t2328 + 0.50e2 / 0.9e1 * t203 * t2251 * t2406 + 0.50e2 / 0.9e1 * t206 * t2251 * t2406 - 0.40e2 / 0.9e1 * t1625 * t2402 - 0.160e3 / 0.9e1 * t650 * t2359 - 0.200e3 / 0.9e1 * t1645 * t2359 - 0.200e3 / 0.9e1 * t652 * t2362 - 0.80e2 / 0.3e1 * t1650 * t2362 - 0.80e2 / 0.3e1 * t654 * t2248 + 0.250e3 * t660 * t2369 + 0.250e3 * t230 * t618 * t2299 + 0.5000e4 / 0.9e1 * t1671 * t2369 + 0.2750e4 / 0.9e1 * t662 * t2256
  t2560 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t5 * t2113 * t669 - t1848 / 0.4e1 - 0.3e1 / 0.4e1 * t1471 * t1522 - 0.3e1 / 0.4e1 * t1471 * t1685 + t1279 - t1858 / 0.4e1 - t1976 / 0.4e1 - 0.3e1 / 0.8e1 * t674 * t31 * t2218 * t668 - 0.3e1 / 0.4e1 * t674 * t1521 * t1684 - 0.3e1 / 0.8e1 * t674 * t567 * (-0.76906968678720000000000000000000000000000000000000e-3 / t1525 / t576 * t125 * t924 * t2230 * t2234 * t638 + 0.57808982880000000000000000000000000000000000000000e-1 * t1528 * s2 * t2240 * t638 - 0.31532172480000000000000000000000000000000000000000e-1 * t1528 * t1532 * t1618 + t579 * (t2295 + t2335 + t2372 + t2412) + 0.50297210791037951531778692272519433013260173754001e-1 * t1620 * t2240 * t641 * t666 - 0.34088340999255810609977046547411469101414150735753e-3 * t1116 * t2230 * t2234 * t641 * t666 - 0.27434842249657064471879286694101508916323731138546e-1 * t1620 * t1621 * t1682 + t643 * (t2458 + t2489 + t2519 + t2551)))
  d22 = 0.2e1 * t1465 + 0.2e1 * t1689 + t6 * (t2104 + t2560)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 9 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = t33 * t36
  t38 = t37 * f.p.cam_omega
  t39 = 0.1e1 / t31
  t40 = t2 * t39
  t42 = 0.1e1 + t17 <= f.p.zeta_threshold
  t44 = 0.1e1 - t17 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t11, t44, t15, t17)
  t46 = 0.1e1 + t45
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t49 = t46 ** (0.1e1 / 0.3e1)
  t50 = f.my_piecewise3(t47, t48, t49)
  t51 = 0.1e1 / t50
  t54 = t38 * t40 * t51 / 0.18e2
  t55 = 0.135e1 <= t54
  t56 = 0.135e1 < t54
  t57 = f.my_piecewise3(t56, t54, 0.135e1)
  t58 = t57 ** 2
  t61 = t58 ** 2
  t62 = 0.1e1 / t61
  t64 = t61 * t58
  t65 = 0.1e1 / t64
  t67 = t61 ** 2
  t68 = 0.1e1 / t67
  t71 = 0.1e1 / t67 / t58
  t74 = 0.1e1 / t67 / t61
  t77 = 0.1e1 / t67 / t64
  t79 = t67 ** 2
  t80 = 0.1e1 / t79
  t83 = f.my_piecewise3(t56, 0.135e1, t54)
  t84 = jnp.sqrt(jnp.pi)
  t85 = 0.1e1 / t83
  t87 = jax.lax.erf(t85 / 0.2e1)
  t89 = t83 ** 2
  t90 = 0.1e1 / t89
  t92 = jnp.exp(-t90 / 0.4e1)
  t93 = t92 - 0.1e1
  t96 = t92 - 0.3e1 / 0.2e1 - 0.2e1 * t89 * t93
  t99 = 0.2e1 * t83 * t96 + t84 * t87
  t103 = f.my_piecewise3(t55, 0.1e1 / t58 / 0.36e2 - t62 / 0.960e3 + t65 / 0.26880e5 - t68 / 0.829440e6 + t71 / 0.28385280e8 - t74 / 0.1073479680e10 + t77 / 0.44590694400e11 - t80 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t83 * t99)
  t104 = t31 * t103
  t105 = 6 ** (0.1e1 / 0.3e1)
  t106 = jnp.pi ** 2
  t107 = t106 ** (0.1e1 / 0.3e1)
  t108 = t107 ** 2
  t109 = 0.1e1 / t108
  t110 = t105 * t109
  t111 = r0 ** 2
  t112 = r0 ** (0.1e1 / 0.3e1)
  t113 = t112 ** 2
  t115 = 0.1e1 / t113 / t111
  t117 = t110 * s0 * t115
  t119 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t117
  t122 = 0.18040e1 - 0.64641600e0 / t119
  t123 = params.a[0]
  t124 = params.a[1]
  t125 = t105 ** 2
  t127 = 0.3e1 / 0.10e2 * t125 * t108
  t130 = tau0 / t113 / r0
  t131 = t127 - t130
  t132 = t124 * t131
  t133 = t127 + t130
  t134 = 0.1e1 / t133
  t136 = params.a[2]
  t137 = t131 ** 2
  t138 = t136 * t137
  t139 = t133 ** 2
  t140 = 0.1e1 / t139
  t142 = params.a[3]
  t143 = t137 * t131
  t144 = t142 * t143
  t145 = t139 * t133
  t146 = 0.1e1 / t145
  t148 = params.a[4]
  t149 = t137 ** 2
  t150 = t148 * t149
  t151 = t139 ** 2
  t152 = 0.1e1 / t151
  t154 = params.a[5]
  t155 = t149 * t131
  t156 = t154 * t155
  t157 = t151 * t133
  t158 = 0.1e1 / t157
  t160 = params.a[6]
  t161 = t149 * t137
  t162 = t160 * t161
  t164 = 0.1e1 / t151 / t139
  t166 = params.a[7]
  t167 = t149 * t143
  t168 = t166 * t167
  t170 = 0.1e1 / t151 / t145
  t172 = params.a[8]
  t173 = t149 ** 2
  t174 = t172 * t173
  t175 = t151 ** 2
  t176 = 0.1e1 / t175
  t178 = params.a[9]
  t179 = t173 * t131
  t180 = t178 * t179
  t182 = 0.1e1 / t175 / t133
  t184 = params.a[10]
  t185 = t173 * t137
  t186 = t184 * t185
  t188 = 0.1e1 / t175 / t139
  t190 = params.a[11]
  t191 = t173 * t143
  t192 = t190 * t191
  t194 = 0.1e1 / t175 / t145
  t196 = t132 * t134 + t138 * t140 + t144 * t146 + t150 * t152 + t156 * t158 + t162 * t164 + t168 * t170 + t174 * t176 + t180 * t182 + t186 * t188 + t192 * t194 + t123
  t199 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t117)
  t201 = 0.1552e1 - 0.552e0 * t199
  t202 = params.b[0]
  t203 = params.b[1]
  t204 = t203 * t131
  t206 = params.b[2]
  t207 = t206 * t137
  t209 = params.b[3]
  t210 = t209 * t143
  t212 = params.b[4]
  t213 = t212 * t149
  t215 = params.b[5]
  t216 = t215 * t155
  t218 = params.b[6]
  t219 = t218 * t161
  t221 = params.b[7]
  t222 = t221 * t167
  t224 = params.b[8]
  t225 = t224 * t173
  t227 = params.b[9]
  t228 = t227 * t179
  t230 = params.b[10]
  t231 = t230 * t185
  t233 = params.b[11]
  t234 = t233 * t191
  t236 = t204 * t134 + t207 * t140 + t210 * t146 + t213 * t152 + t216 * t158 + t219 * t164 + t222 * t170 + t225 * t176 + t228 * t182 + t231 * t188 + t234 * t194 + t202
  t238 = t122 * t196 + t201 * t236
  t239 = t104 * t238
  t242 = t48 * f.p.zeta_threshold
  t244 = f.my_piecewise3(t20, t242, t21 * t19)
  t245 = t5 * t244
  t246 = t31 ** 2
  t247 = 0.1e1 / t246
  t248 = t247 * t103
  t249 = t248 * t238
  t251 = t245 * t249 / 0.8e1
  t252 = t58 * t57
  t253 = 0.1e1 / t252
  t256 = t2 / t31 / t6
  t259 = t38 * t256 * t51 / 0.54e2
  t260 = t50 ** 2
  t261 = 0.1e1 / t260
  t262 = t49 ** 2
  t263 = 0.1e1 / t262
  t264 = f.my_piecewise5(t42, 0, t44, 0, t25)
  t267 = f.my_piecewise3(t47, 0, t263 * t264 / 0.3e1)
  t268 = t261 * t267
  t272 = -t259 - t38 * t40 * t268 / 0.18e2
  t273 = f.my_piecewise3(t56, t272, 0)
  t276 = t61 * t57
  t277 = 0.1e1 / t276
  t280 = t61 * t252
  t281 = 0.1e1 / t280
  t285 = 0.1e1 / t67 / t57
  t289 = 0.1e1 / t67 / t252
  t293 = 0.1e1 / t67 / t276
  t297 = 0.1e1 / t67 / t280
  t301 = 0.1e1 / t79 / t57
  t305 = f.my_piecewise3(t56, 0, t272)
  t307 = t92 * t90
  t312 = 0.1e1 / t89 / t83
  t316 = t83 * t93
  t321 = t312 * t305 * t92 / 0.2e1 - 0.4e1 * t316 * t305 - t85 * t305 * t92
  t324 = -t307 * t305 + 0.2e1 * t305 * t96 + 0.2e1 * t83 * t321
  t328 = f.my_piecewise3(t55, -t253 * t273 / 0.18e2 + t277 * t273 / 0.240e3 - t281 * t273 / 0.4480e4 + t285 * t273 / 0.103680e6 - t289 * t273 / 0.2838528e7 + t293 * t273 / 0.89456640e8 - t297 * t273 / 0.3185049600e10 + t301 * t273 / 0.126340300800e12, -0.8e1 / 0.3e1 * t305 * t99 - 0.8e1 / 0.3e1 * t83 * t324)
  t329 = t31 * t328
  t330 = t329 * t238
  t333 = t119 ** 2
  t336 = 0.1e1 / t333 * t105 * t109
  t337 = t111 * r0
  t339 = 0.1e1 / t113 / t337
  t340 = s0 * t339
  t344 = t124 * tau0
  t345 = t115 * t134
  t348 = t140 * tau0
  t349 = t348 * t115
  t352 = t136 * t131
  t355 = t146 * tau0
  t356 = t355 * t115
  t359 = t142 * t137
  t362 = t152 * tau0
  t363 = t362 * t115
  t366 = t148 * t143
  t369 = t158 * tau0
  t370 = t369 * t115
  t373 = t154 * t149
  t376 = t164 * tau0
  t377 = t376 * t115
  t380 = t160 * t155
  t383 = 0.5e1 / 0.3e1 * t344 * t345 + 0.5e1 / 0.3e1 * t132 * t349 + 0.10e2 / 0.3e1 * t352 * t349 + 0.10e2 / 0.3e1 * t138 * t356 + 0.5e1 * t359 * t356 + 0.5e1 * t144 * t363 + 0.20e2 / 0.3e1 * t366 * t363 + 0.20e2 / 0.3e1 * t150 * t370 + 0.25e2 / 0.3e1 * t373 * t370 + 0.25e2 / 0.3e1 * t156 * t377 + 0.10e2 * t380 * t377
  t384 = t170 * tau0
  t385 = t384 * t115
  t388 = t166 * t161
  t391 = t176 * tau0
  t392 = t391 * t115
  t395 = t172 * t167
  t398 = t182 * tau0
  t399 = t398 * t115
  t402 = t178 * t173
  t405 = t188 * tau0
  t406 = t405 * t115
  t409 = t184 * t179
  t412 = t194 * tau0
  t413 = t412 * t115
  t416 = t190 * t185
  t420 = 0.1e1 / t175 / t151
  t421 = t420 * tau0
  t422 = t421 * t115
  t425 = 0.10e2 * t162 * t385 + 0.35e2 / 0.3e1 * t388 * t385 + 0.35e2 / 0.3e1 * t168 * t392 + 0.40e2 / 0.3e1 * t395 * t392 + 0.40e2 / 0.3e1 * t174 * t399 + 0.15e2 * t402 * t399 + 0.15e2 * t180 * t406 + 0.50e2 / 0.3e1 * t409 * t406 + 0.50e2 / 0.3e1 * t186 * t413 + 0.55e2 / 0.3e1 * t416 * t413 + 0.55e2 / 0.3e1 * t192 * t422
  t426 = t383 + t425
  t428 = t110 * s0
  t429 = t339 * t199
  t433 = t203 * tau0
  t438 = t206 * t131
  t443 = t209 * t137
  t448 = t212 * t143
  t453 = t215 * t149
  t458 = t218 * t155
  t461 = 0.5e1 / 0.3e1 * t433 * t345 + 0.5e1 / 0.3e1 * t204 * t349 + 0.10e2 / 0.3e1 * t438 * t349 + 0.10e2 / 0.3e1 * t207 * t356 + 0.5e1 * t443 * t356 + 0.5e1 * t210 * t363 + 0.20e2 / 0.3e1 * t448 * t363 + 0.20e2 / 0.3e1 * t213 * t370 + 0.25e2 / 0.3e1 * t453 * t370 + 0.25e2 / 0.3e1 * t216 * t377 + 0.10e2 * t458 * t377
  t464 = t221 * t161
  t469 = t224 * t167
  t474 = t227 * t173
  t479 = t230 * t179
  t484 = t233 * t185
  t489 = 0.10e2 * t219 * t385 + 0.35e2 / 0.3e1 * t464 * t385 + 0.35e2 / 0.3e1 * t222 * t392 + 0.40e2 / 0.3e1 * t469 * t392 + 0.40e2 / 0.3e1 * t225 * t399 + 0.15e2 * t474 * t399 + 0.15e2 * t228 * t406 + 0.50e2 / 0.3e1 * t479 * t406 + 0.50e2 / 0.3e1 * t231 * t413 + 0.55e2 / 0.3e1 * t484 * t413 + 0.55e2 / 0.3e1 * t234 * t422
  t490 = t461 + t489
  t492 = -0.15766086240000000000000000000000000000000000000000e-1 * t336 * t340 * t196 + t122 * t426 - 0.13717421124828532235939643347050754458161865569273e-1 * t428 * t429 * t236 + t201 * t490
  t493 = t104 * t492
  t497 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t239 - t251 - 0.3e1 / 0.8e1 * t245 * t330 - 0.3e1 / 0.8e1 * t245 * t493)
  t499 = r1 <= f.p.dens_threshold
  t500 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t501 = 0.1e1 + t500
  t502 = t501 <= f.p.zeta_threshold
  t503 = t501 ** (0.1e1 / 0.3e1)
  t504 = -t25
  t505 = f.my_piecewise5(t14, 0, t10, 0, t504)
  t508 = f.my_piecewise3(t502, 0, 0.4e1 / 0.3e1 * t503 * t505)
  t509 = t5 * t508
  t510 = f.my_piecewise5(t44, t11, t42, t15, -t17)
  t511 = 0.1e1 + t510
  t512 = t511 <= f.p.zeta_threshold
  t513 = t511 ** (0.1e1 / 0.3e1)
  t514 = f.my_piecewise3(t512, t48, t513)
  t515 = 0.1e1 / t514
  t518 = t38 * t40 * t515 / 0.18e2
  t519 = 0.135e1 <= t518
  t520 = 0.135e1 < t518
  t521 = f.my_piecewise3(t520, t518, 0.135e1)
  t522 = t521 ** 2
  t525 = t522 ** 2
  t526 = 0.1e1 / t525
  t528 = t525 * t522
  t529 = 0.1e1 / t528
  t531 = t525 ** 2
  t532 = 0.1e1 / t531
  t535 = 0.1e1 / t531 / t522
  t538 = 0.1e1 / t531 / t525
  t541 = 0.1e1 / t531 / t528
  t543 = t531 ** 2
  t544 = 0.1e1 / t543
  t547 = f.my_piecewise3(t520, 0.135e1, t518)
  t548 = 0.1e1 / t547
  t550 = jax.lax.erf(t548 / 0.2e1)
  t552 = t547 ** 2
  t553 = 0.1e1 / t552
  t555 = jnp.exp(-t553 / 0.4e1)
  t556 = t555 - 0.1e1
  t559 = t555 - 0.3e1 / 0.2e1 - 0.2e1 * t552 * t556
  t562 = 0.2e1 * t547 * t559 + t84 * t550
  t566 = f.my_piecewise3(t519, 0.1e1 / t522 / 0.36e2 - t526 / 0.960e3 + t529 / 0.26880e5 - t532 / 0.829440e6 + t535 / 0.28385280e8 - t538 / 0.1073479680e10 + t541 / 0.44590694400e11 - t544 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t547 * t562)
  t567 = t31 * t566
  t568 = r1 ** 2
  t569 = r1 ** (0.1e1 / 0.3e1)
  t570 = t569 ** 2
  t572 = 0.1e1 / t570 / t568
  t574 = t110 * s2 * t572
  t576 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t574
  t579 = 0.18040e1 - 0.64641600e0 / t576
  t582 = tau1 / t570 / r1
  t583 = t127 - t582
  t584 = t124 * t583
  t585 = t127 + t582
  t586 = 0.1e1 / t585
  t588 = t583 ** 2
  t589 = t136 * t588
  t590 = t585 ** 2
  t591 = 0.1e1 / t590
  t593 = t588 * t583
  t594 = t142 * t593
  t595 = t590 * t585
  t596 = 0.1e1 / t595
  t598 = t588 ** 2
  t599 = t148 * t598
  t600 = t590 ** 2
  t601 = 0.1e1 / t600
  t603 = t598 * t583
  t604 = t154 * t603
  t605 = t600 * t585
  t606 = 0.1e1 / t605
  t608 = t598 * t588
  t609 = t160 * t608
  t611 = 0.1e1 / t600 / t590
  t613 = t598 * t593
  t614 = t166 * t613
  t616 = 0.1e1 / t600 / t595
  t618 = t598 ** 2
  t619 = t172 * t618
  t620 = t600 ** 2
  t621 = 0.1e1 / t620
  t623 = t618 * t583
  t624 = t178 * t623
  t626 = 0.1e1 / t620 / t585
  t628 = t618 * t588
  t629 = t184 * t628
  t631 = 0.1e1 / t620 / t590
  t633 = t618 * t593
  t634 = t190 * t633
  t636 = 0.1e1 / t620 / t595
  t638 = t584 * t586 + t589 * t591 + t594 * t596 + t599 * t601 + t604 * t606 + t609 * t611 + t614 * t616 + t619 * t621 + t624 * t626 + t629 * t631 + t634 * t636 + t123
  t641 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t574)
  t643 = 0.1552e1 - 0.552e0 * t641
  t644 = t203 * t583
  t646 = t206 * t588
  t648 = t209 * t593
  t650 = t212 * t598
  t652 = t215 * t603
  t654 = t218 * t608
  t656 = t221 * t613
  t658 = t224 * t618
  t660 = t227 * t623
  t662 = t230 * t628
  t664 = t233 * t633
  t666 = t644 * t586 + t646 * t591 + t648 * t596 + t650 * t601 + t652 * t606 + t654 * t611 + t656 * t616 + t658 * t621 + t660 * t626 + t662 * t631 + t664 * t636 + t202
  t668 = t579 * t638 + t643 * t666
  t669 = t567 * t668
  t673 = f.my_piecewise3(t502, t242, t503 * t501)
  t674 = t5 * t673
  t675 = t247 * t566
  t676 = t675 * t668
  t678 = t674 * t676 / 0.8e1
  t679 = t522 * t521
  t680 = 0.1e1 / t679
  t683 = t38 * t256 * t515 / 0.54e2
  t684 = t514 ** 2
  t685 = 0.1e1 / t684
  t686 = t513 ** 2
  t687 = 0.1e1 / t686
  t688 = f.my_piecewise5(t44, 0, t42, 0, t504)
  t691 = f.my_piecewise3(t512, 0, t687 * t688 / 0.3e1)
  t692 = t685 * t691
  t696 = -t683 - t38 * t40 * t692 / 0.18e2
  t697 = f.my_piecewise3(t520, t696, 0)
  t700 = t525 * t521
  t701 = 0.1e1 / t700
  t704 = t525 * t679
  t705 = 0.1e1 / t704
  t709 = 0.1e1 / t531 / t521
  t713 = 0.1e1 / t531 / t679
  t717 = 0.1e1 / t531 / t700
  t721 = 0.1e1 / t531 / t704
  t725 = 0.1e1 / t543 / t521
  t729 = f.my_piecewise3(t520, 0, t696)
  t731 = t555 * t553
  t736 = 0.1e1 / t552 / t547
  t740 = t547 * t556
  t745 = t736 * t729 * t555 / 0.2e1 - 0.4e1 * t740 * t729 - t548 * t729 * t555
  t748 = 0.2e1 * t547 * t745 + 0.2e1 * t729 * t559 - t731 * t729
  t752 = f.my_piecewise3(t519, -t680 * t697 / 0.18e2 + t701 * t697 / 0.240e3 - t705 * t697 / 0.4480e4 + t709 * t697 / 0.103680e6 - t713 * t697 / 0.2838528e7 + t717 * t697 / 0.89456640e8 - t721 * t697 / 0.3185049600e10 + t725 * t697 / 0.126340300800e12, -0.8e1 / 0.3e1 * t547 * t748 - 0.8e1 / 0.3e1 * t729 * t562)
  t753 = t31 * t752
  t754 = t753 * t668
  t758 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t509 * t669 - t678 - 0.3e1 / 0.8e1 * t674 * t754)
  t760 = t21 ** 2
  t761 = 0.1e1 / t760
  t762 = t26 ** 2
  t767 = t16 / t22 / t6
  t769 = -0.2e1 * t23 + 0.2e1 * t767
  t770 = f.my_piecewise5(t10, 0, t14, 0, t769)
  t774 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t761 * t762 + 0.4e1 / 0.3e1 * t21 * t770)
  t778 = t30 * t249
  t785 = 0.1e1 / t246 / t6
  t789 = t245 * t785 * t103 * t238 / 0.12e2
  t792 = t245 * t247 * t328 * t238
  t795 = t245 * t248 * t492
  t797 = t273 ** 2
  t802 = t2 / t31 / t22
  t805 = 0.2e1 / 0.81e2 * t38 * t802 * t51
  t807 = t38 * t256 * t268
  t810 = 0.1e1 / t260 / t50
  t811 = t267 ** 2
  t817 = 0.1e1 / t262 / t46
  t818 = t264 ** 2
  t821 = f.my_piecewise5(t42, 0, t44, 0, t769)
  t825 = f.my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t817 * t818 + t263 * t821 / 0.3e1)
  t830 = t805 + t807 / 0.27e2 + t38 * t40 * t810 * t811 / 0.9e1 - t38 * t40 * t261 * t825 / 0.18e2
  t831 = f.my_piecewise3(t56, t830, 0)
  t859 = 0.1e1 / t79 / t58
  t864 = t62 * t797 / 0.6e1 - t253 * t831 / 0.18e2 - t65 * t797 / 0.48e2 + t277 * t831 / 0.240e3 + t68 * t797 / 0.640e3 - t281 * t831 / 0.4480e4 - t71 * t797 / 0.11520e5 + t285 * t831 / 0.103680e6 + t74 * t797 / 0.258048e6 - t289 * t831 / 0.2838528e7 - t77 * t797 / 0.6881280e7 + t293 * t831 / 0.89456640e8 + t80 * t797 / 0.212336640e9 - t297 * t831 / 0.3185049600e10 - t859 * t797 / 0.7431782400e10 + t301 * t831 / 0.126340300800e12
  t865 = f.my_piecewise3(t56, 0, t830)
  t870 = t89 ** 2
  t872 = 0.1e1 / t870 / t83
  t873 = t305 ** 2
  t877 = t92 * t312
  t885 = 0.1e1 / t870
  t893 = 0.1e1 / t870 / t89
  t912 = f.my_piecewise3(t55, t864, -0.8e1 / 0.3e1 * t865 * t99 - 0.16e2 / 0.3e1 * t305 * t324 - 0.8e1 / 0.3e1 * t83 * (-t872 * t873 * t92 / 0.2e1 + 0.2e1 * t877 * t873 - t307 * t865 + 0.2e1 * t865 * t96 + 0.4e1 * t305 * t321 + 0.2e1 * t83 * (-0.2e1 * t885 * t873 * t92 + t312 * t865 * t92 / 0.2e1 + t893 * t873 * t92 / 0.4e1 - 0.4e1 * t873 * t93 - t90 * t873 * t92 - 0.4e1 * t316 * t865 - t85 * t865 * t92)))
  t924 = 0.1e1 / t107 / t106
  t926 = s0 ** 2
  t927 = t111 ** 2
  t930 = 0.1e1 / t112 / t927 / t337
  t936 = 0.1e1 / t113 / t927
  t944 = tau0 ** 2
  t948 = 0.1e1 / t112 / t927 / r0
  t949 = t176 * t944 * t948
  t953 = t182 * t944 * t948
  t962 = t188 * t944 * t948
  t971 = t194 * t944 * t948
  t974 = t348 * t339
  t979 = t355 * t339
  t984 = t362 * t339
  t987 = 0.2450e4 / 0.9e1 * t388 * t949 + 0.1400e4 / 0.9e1 * t168 * t953 + 0.1400e4 / 0.9e1 * t172 * t161 * t949 + 0.3200e4 / 0.9e1 * t395 * t953 + 0.200e3 * t174 * t962 + 0.200e3 * t178 * t167 * t953 + 0.450e3 * t402 * t962 + 0.250e3 * t180 * t971 - 0.40e2 / 0.9e1 * t132 * t974 - 0.80e2 / 0.9e1 * t352 * t974 - 0.80e2 / 0.9e1 * t138 * t979 - 0.40e2 / 0.3e1 * t359 * t979 - 0.40e2 / 0.3e1 * t144 * t984
  t990 = t369 * t339
  t995 = t376 * t339
  t1000 = t384 * t339
  t1005 = t391 * t339
  t1010 = t398 * t339
  t1015 = t405 * t339
  t1020 = t412 * t339
  t1023 = -0.160e3 / 0.9e1 * t366 * t984 - 0.160e3 / 0.9e1 * t150 * t990 - 0.200e3 / 0.9e1 * t373 * t990 - 0.200e3 / 0.9e1 * t156 * t995 - 0.80e2 / 0.3e1 * t380 * t995 - 0.80e2 / 0.3e1 * t162 * t1000 - 0.280e3 / 0.9e1 * t388 * t1000 - 0.280e3 / 0.9e1 * t168 * t1005 - 0.320e3 / 0.9e1 * t395 * t1005 - 0.320e3 / 0.9e1 * t174 * t1010 - 0.40e2 * t402 * t1010 - 0.40e2 * t180 * t1015 - 0.400e3 / 0.9e1 * t409 * t1015 - 0.400e3 / 0.9e1 * t186 * t1020
  t1027 = t421 * t339
  t1031 = t146 * t944 * t948
  t1042 = t420 * t944 * t948
  t1053 = 0.1e1 / t175 / t157 * t944 * t948
  t1057 = t152 * t944 * t948
  t1065 = -0.440e3 / 0.9e1 * t416 * t1020 - 0.440e3 / 0.9e1 * t192 * t1027 + 0.50e2 / 0.9e1 * t132 * t1031 + 0.200e3 / 0.9e1 * t352 * t1031 + 0.250e3 * t184 * t173 * t962 + 0.5000e4 / 0.9e1 * t409 * t971 + 0.2750e4 / 0.9e1 * t186 * t1042 + 0.2750e4 / 0.9e1 * t190 * t179 * t971 + 0.6050e4 / 0.9e1 * t416 * t1042 + 0.1100e4 / 0.3e1 * t192 * t1053 + 0.50e2 / 0.3e1 * t138 * t1057 + 0.50e2 / 0.3e1 * t142 * t131 * t1031 + 0.50e2 * t359 * t1057
  t1067 = t158 * t944 * t948
  t1076 = t164 * t944 * t948
  t1085 = t170 * t944 * t948
  t1098 = t339 * t134
  t1102 = t948 * t140
  t1108 = 0.100e3 / 0.3e1 * t144 * t1067 + 0.100e3 / 0.3e1 * t148 * t137 * t1057 + 0.800e3 / 0.9e1 * t366 * t1067 + 0.500e3 / 0.9e1 * t150 * t1076 + 0.500e3 / 0.9e1 * t154 * t143 * t1067 + 0.1250e4 / 0.9e1 * t373 * t1076 + 0.250e3 / 0.3e1 * t156 * t1085 + 0.250e3 / 0.3e1 * t160 * t149 * t1076 + 0.200e3 * t380 * t1085 + 0.350e3 / 0.3e1 * t162 * t949 + 0.350e3 / 0.3e1 * t166 * t155 * t1085 - 0.40e2 / 0.9e1 * t344 * t1098 + 0.50e2 / 0.9e1 * t124 * t944 * t1102 + 0.50e2 / 0.9e1 * t136 * t944 * t1102
  t1116 = t125 * t924
  t1153 = 0.250e3 / 0.3e1 * t216 * t1085 + 0.250e3 / 0.3e1 * t218 * t149 * t1076 + 0.200e3 * t458 * t1085 + 0.50e2 / 0.9e1 * t204 * t1031 - 0.40e2 * t474 * t1010 - 0.40e2 * t228 * t1015 - 0.400e3 / 0.9e1 * t479 * t1015 - 0.400e3 / 0.9e1 * t231 * t1020 - 0.440e3 / 0.9e1 * t484 * t1020 - 0.440e3 / 0.9e1 * t234 * t1027 + 0.2750e4 / 0.9e1 * t231 * t1042 + 0.2750e4 / 0.9e1 * t233 * t179 * t971 + 0.6050e4 / 0.9e1 * t484 * t1042
  t1186 = 0.1100e4 / 0.3e1 * t234 * t1053 + 0.350e3 / 0.3e1 * t219 * t949 + 0.350e3 / 0.3e1 * t221 * t155 * t1085 + 0.2450e4 / 0.9e1 * t464 * t949 + 0.1400e4 / 0.9e1 * t222 * t953 + 0.1400e4 / 0.9e1 * t224 * t161 * t949 + 0.3200e4 / 0.9e1 * t469 * t953 + 0.200e3 * t225 * t962 + 0.200e3 * t227 * t167 * t953 + 0.450e3 * t474 * t962 + 0.250e3 * t228 * t971 + 0.250e3 * t230 * t173 * t962 + 0.5000e4 / 0.9e1 * t479 * t971 + 0.50e2 / 0.3e1 * t207 * t1057
  t1215 = 0.50e2 / 0.3e1 * t209 * t131 * t1031 + 0.50e2 * t443 * t1057 + 0.100e3 / 0.3e1 * t210 * t1067 - 0.40e2 / 0.3e1 * t443 * t979 - 0.40e2 / 0.3e1 * t210 * t984 - 0.160e3 / 0.9e1 * t448 * t984 - 0.160e3 / 0.9e1 * t213 * t990 - 0.200e3 / 0.9e1 * t453 * t990 - 0.200e3 / 0.9e1 * t216 * t995 - 0.80e2 / 0.3e1 * t458 * t995 - 0.80e2 / 0.3e1 * t219 * t1000 - 0.280e3 / 0.9e1 * t464 * t1000 - 0.280e3 / 0.9e1 * t222 * t1005
  t1248 = -0.320e3 / 0.9e1 * t469 * t1005 + 0.200e3 / 0.9e1 * t438 * t1031 - 0.40e2 / 0.9e1 * t204 * t974 - 0.80e2 / 0.9e1 * t438 * t974 - 0.80e2 / 0.9e1 * t207 * t979 + 0.100e3 / 0.3e1 * t212 * t137 * t1057 + 0.800e3 / 0.9e1 * t448 * t1067 + 0.500e3 / 0.9e1 * t213 * t1076 + 0.500e3 / 0.9e1 * t215 * t143 * t1067 + 0.1250e4 / 0.9e1 * t453 * t1076 - 0.320e3 / 0.9e1 * t225 * t1010 + 0.50e2 / 0.9e1 * t203 * t944 * t1102 + 0.50e2 / 0.9e1 * t206 * t944 * t1102 - 0.40e2 / 0.9e1 * t433 * t1098
  t1257 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t774 * t239 - t778 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t330 - 0.3e1 / 0.4e1 * t30 * t493 + t789 - t792 / 0.4e1 - t795 / 0.4e1 - 0.3e1 / 0.8e1 * t245 * t31 * t912 * t238 - 0.3e1 / 0.4e1 * t245 * t329 * t492 - 0.3e1 / 0.8e1 * t245 * t104 * (-0.76906968678720000000000000000000000000000000000000e-3 / t333 / t119 * t125 * t924 * t926 * t930 * t196 + 0.57808982880000000000000000000000000000000000000000e-1 * t336 * s0 * t936 * t196 - 0.31532172480000000000000000000000000000000000000000e-1 * t336 * t340 * t426 + t122 * (t987 + t1023 + t1065 + t1108) + 0.50297210791037951531778692272519433013260173754001e-1 * t428 * t936 * t199 * t236 - 0.34088340999255810609977046547411469101414150735753e-3 * t1116 * t926 * t930 * t199 * t236 - 0.27434842249657064471879286694101508916323731138546e-1 * t428 * t429 * t490 + t201 * (t1153 + t1186 + t1215 + t1248)))
  t1258 = t503 ** 2
  t1259 = 0.1e1 / t1258
  t1260 = t505 ** 2
  t1263 = -t769
  t1264 = f.my_piecewise5(t14, 0, t10, 0, t1263)
  t1268 = f.my_piecewise3(t502, 0, 0.4e1 / 0.9e1 * t1259 * t1260 + 0.4e1 / 0.3e1 * t503 * t1264)
  t1272 = t509 * t676
  t1279 = t674 * t785 * t566 * t668 / 0.12e2
  t1282 = t674 * t247 * t752 * t668
  t1284 = t697 ** 2
  t1289 = 0.2e1 / 0.81e2 * t38 * t802 * t515
  t1291 = t38 * t256 * t692
  t1294 = 0.1e1 / t684 / t514
  t1295 = t691 ** 2
  t1301 = 0.1e1 / t686 / t511
  t1302 = t688 ** 2
  t1305 = f.my_piecewise5(t44, 0, t42, 0, t1263)
  t1309 = f.my_piecewise3(t512, 0, -0.2e1 / 0.9e1 * t1301 * t1302 + t687 * t1305 / 0.3e1)
  t1314 = t1289 + t1291 / 0.27e2 + t38 * t40 * t1294 * t1295 / 0.9e1 - t38 * t40 * t685 * t1309 / 0.18e2
  t1315 = f.my_piecewise3(t520, t1314, 0)
  t1343 = 0.1e1 / t543 / t522
  t1348 = t526 * t1284 / 0.6e1 - t680 * t1315 / 0.18e2 - t529 * t1284 / 0.48e2 + t701 * t1315 / 0.240e3 + t532 * t1284 / 0.640e3 - t705 * t1315 / 0.4480e4 - t535 * t1284 / 0.11520e5 + t709 * t1315 / 0.103680e6 + t538 * t1284 / 0.258048e6 - t713 * t1315 / 0.2838528e7 - t541 * t1284 / 0.6881280e7 + t717 * t1315 / 0.89456640e8 + t544 * t1284 / 0.212336640e9 - t721 * t1315 / 0.3185049600e10 - t1343 * t1284 / 0.7431782400e10 + t725 * t1315 / 0.126340300800e12
  t1349 = f.my_piecewise3(t520, 0, t1314)
  t1354 = t552 ** 2
  t1356 = 0.1e1 / t1354 / t547
  t1357 = t729 ** 2
  t1361 = t555 * t736
  t1369 = 0.1e1 / t1354
  t1377 = 0.1e1 / t1354 / t552
  t1396 = f.my_piecewise3(t519, t1348, -0.8e1 / 0.3e1 * t1349 * t562 - 0.16e2 / 0.3e1 * t729 * t748 - 0.8e1 / 0.3e1 * t547 * (-t1356 * t1357 * t555 / 0.2e1 + 0.2e1 * t1361 * t1357 - t731 * t1349 + 0.2e1 * t1349 * t559 + 0.4e1 * t729 * t745 + 0.2e1 * t547 * (-0.2e1 * t1369 * t1357 * t555 + t736 * t1349 * t555 / 0.2e1 + t1377 * t1357 * t555 / 0.4e1 - 0.4e1 * t1357 * t556 - t553 * t1357 * t555 - 0.4e1 * t740 * t1349 - t548 * t1349 * t555)))
  t1402 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t5 * t1268 * t669 - t1272 / 0.4e1 - 0.3e1 / 0.4e1 * t509 * t754 + t1279 - t1282 / 0.4e1 - 0.3e1 / 0.8e1 * t674 * t31 * t1396 * t668)
  d11 = 0.2e1 * t497 + 0.2e1 * t758 + t6 * (t1257 + t1402)
  t1405 = -t7 - t24
  t1406 = f.my_piecewise5(t10, 0, t14, 0, t1405)
  t1409 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t1406)
  t1410 = t5 * t1409
  t1413 = f.my_piecewise5(t42, 0, t44, 0, t1405)
  t1416 = f.my_piecewise3(t47, 0, t263 * t1413 / 0.3e1)
  t1417 = t261 * t1416
  t1421 = -t259 - t38 * t40 * t1417 / 0.18e2
  t1422 = f.my_piecewise3(t56, t1421, 0)
  t1440 = f.my_piecewise3(t56, 0, t1421)
  t1452 = t312 * t1440 * t92 / 0.2e1 - 0.4e1 * t316 * t1440 - t85 * t1440 * t92
  t1455 = -t307 * t1440 + 0.2e1 * t1440 * t96 + 0.2e1 * t83 * t1452
  t1459 = f.my_piecewise3(t55, -t253 * t1422 / 0.18e2 + t277 * t1422 / 0.240e3 - t281 * t1422 / 0.4480e4 + t285 * t1422 / 0.103680e6 - t289 * t1422 / 0.2838528e7 + t293 * t1422 / 0.89456640e8 - t297 * t1422 / 0.3185049600e10 + t301 * t1422 / 0.126340300800e12, -0.8e1 / 0.3e1 * t1440 * t99 - 0.8e1 / 0.3e1 * t83 * t1455)
  t1460 = t31 * t1459
  t1461 = t1460 * t238
  t1465 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t1410 * t239 - t251 - 0.3e1 / 0.8e1 * t245 * t1461)
  t1466 = -t1405
  t1467 = f.my_piecewise5(t14, 0, t10, 0, t1466)
  t1470 = f.my_piecewise3(t502, 0, 0.4e1 / 0.3e1 * t503 * t1467)
  t1471 = t5 * t1470
  t1474 = f.my_piecewise5(t44, 0, t42, 0, t1466)
  t1477 = f.my_piecewise3(t512, 0, t687 * t1474 / 0.3e1)
  t1478 = t685 * t1477
  t1482 = -t683 - t38 * t40 * t1478 / 0.18e2
  t1483 = f.my_piecewise3(t520, t1482, 0)
  t1501 = f.my_piecewise3(t520, 0, t1482)
  t1513 = t736 * t1501 * t555 / 0.2e1 - 0.4e1 * t740 * t1501 - t548 * t1501 * t555
  t1516 = 0.2e1 * t1501 * t559 - t731 * t1501 + 0.2e1 * t547 * t1513
  t1520 = f.my_piecewise3(t519, -t680 * t1483 / 0.18e2 + t701 * t1483 / 0.240e3 - t705 * t1483 / 0.4480e4 + t709 * t1483 / 0.103680e6 - t713 * t1483 / 0.2838528e7 + t717 * t1483 / 0.89456640e8 - t721 * t1483 / 0.3185049600e10 + t725 * t1483 / 0.126340300800e12, -0.8e1 / 0.3e1 * t1501 * t562 - 0.8e1 / 0.3e1 * t547 * t1516)
  t1521 = t31 * t1520
  t1522 = t1521 * t668
  t1525 = t576 ** 2
  t1528 = 0.1e1 / t1525 * t105 * t109
  t1529 = t568 * r1
  t1531 = 0.1e1 / t570 / t1529
  t1532 = s2 * t1531
  t1536 = t124 * tau1
  t1537 = t572 * t586
  t1540 = t591 * tau1
  t1541 = t1540 * t572
  t1544 = t136 * t583
  t1547 = t596 * tau1
  t1548 = t1547 * t572
  t1551 = t142 * t588
  t1554 = t601 * tau1
  t1555 = t1554 * t572
  t1558 = t148 * t593
  t1561 = t606 * tau1
  t1562 = t1561 * t572
  t1565 = t154 * t598
  t1568 = t611 * tau1
  t1569 = t1568 * t572
  t1572 = t160 * t603
  t1575 = 0.5e1 / 0.3e1 * t1536 * t1537 + 0.5e1 / 0.3e1 * t584 * t1541 + 0.10e2 / 0.3e1 * t1544 * t1541 + 0.10e2 / 0.3e1 * t589 * t1548 + 0.5e1 * t1551 * t1548 + 0.5e1 * t594 * t1555 + 0.20e2 / 0.3e1 * t1558 * t1555 + 0.20e2 / 0.3e1 * t599 * t1562 + 0.25e2 / 0.3e1 * t1565 * t1562 + 0.25e2 / 0.3e1 * t604 * t1569 + 0.10e2 * t1572 * t1569
  t1576 = t616 * tau1
  t1577 = t1576 * t572
  t1580 = t166 * t608
  t1583 = t621 * tau1
  t1584 = t1583 * t572
  t1587 = t172 * t613
  t1590 = t626 * tau1
  t1591 = t1590 * t572
  t1594 = t178 * t618
  t1597 = t631 * tau1
  t1598 = t1597 * t572
  t1601 = t184 * t623
  t1604 = t636 * tau1
  t1605 = t1604 * t572
  t1608 = t190 * t628
  t1612 = 0.1e1 / t620 / t600
  t1613 = t1612 * tau1
  t1614 = t1613 * t572
  t1617 = 0.10e2 * t609 * t1577 + 0.35e2 / 0.3e1 * t1580 * t1577 + 0.35e2 / 0.3e1 * t614 * t1584 + 0.40e2 / 0.3e1 * t1587 * t1584 + 0.40e2 / 0.3e1 * t619 * t1591 + 0.15e2 * t1594 * t1591 + 0.15e2 * t624 * t1598 + 0.50e2 / 0.3e1 * t1601 * t1598 + 0.50e2 / 0.3e1 * t629 * t1605 + 0.55e2 / 0.3e1 * t1608 * t1605 + 0.55e2 / 0.3e1 * t634 * t1614
  t1618 = t1575 + t1617
  t1620 = t110 * s2
  t1621 = t1531 * t641
  t1625 = t203 * tau1
  t1630 = t206 * t583
  t1635 = t209 * t588
  t1640 = t212 * t593
  t1645 = t215 * t598
  t1650 = t218 * t603
  t1653 = 0.5e1 / 0.3e1 * t1625 * t1537 + 0.5e1 / 0.3e1 * t644 * t1541 + 0.10e2 / 0.3e1 * t1630 * t1541 + 0.10e2 / 0.3e1 * t646 * t1548 + 0.5e1 * t1635 * t1548 + 0.5e1 * t648 * t1555 + 0.20e2 / 0.3e1 * t1640 * t1555 + 0.20e2 / 0.3e1 * t650 * t1562 + 0.25e2 / 0.3e1 * t1645 * t1562 + 0.25e2 / 0.3e1 * t652 * t1569 + 0.10e2 * t1650 * t1569
  t1656 = t221 * t608
  t1661 = t224 * t613
  t1666 = t227 * t618
  t1671 = t230 * t623
  t1676 = t233 * t628
  t1681 = 0.10e2 * t654 * t1577 + 0.35e2 / 0.3e1 * t1656 * t1577 + 0.35e2 / 0.3e1 * t656 * t1584 + 0.40e2 / 0.3e1 * t1661 * t1584 + 0.40e2 / 0.3e1 * t658 * t1591 + 0.15e2 * t1666 * t1591 + 0.15e2 * t660 * t1598 + 0.50e2 / 0.3e1 * t1671 * t1598 + 0.50e2 / 0.3e1 * t662 * t1605 + 0.55e2 / 0.3e1 * t1676 * t1605 + 0.55e2 / 0.3e1 * t664 * t1614
  t1682 = t1653 + t1681
  t1684 = -0.15766086240000000000000000000000000000000000000000e-1 * t1528 * t1532 * t638 + t579 * t1618 - 0.13717421124828532235939643347050754458161865569273e-1 * t1620 * t1621 * t666 + t643 * t1682
  t1685 = t567 * t1684
  t1689 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t1471 * t669 - t678 - 0.3e1 / 0.8e1 * t674 * t1522 - 0.3e1 / 0.8e1 * t674 * t1685)
  t1693 = 0.2e1 * t767
  t1694 = f.my_piecewise5(t10, 0, t14, 0, t1693)
  t1698 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t761 * t1406 * t26 + 0.4e1 / 0.3e1 * t21 * t1694)
  t1702 = t1410 * t249
  t1715 = t245 * t247 * t1459 * t238
  t1722 = t38 * t256 * t1417
  t1725 = t37 * f.p.cam_omega * t2
  t1734 = f.my_piecewise5(t42, 0, t44, 0, t1693)
  t1738 = f.my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t817 * t1413 * t264 + t263 * t1734 / 0.3e1)
  t1743 = t805 + t807 / 0.54e2 + t1722 / 0.54e2 + t1725 * t39 * t810 * t1416 * t267 / 0.9e1 - t38 * t40 * t261 * t1738 / 0.18e2
  t1744 = f.my_piecewise3(t56, t1743, 0)
  t1782 = t62 * t1422 * t273 / 0.6e1 - t253 * t1744 / 0.18e2 - t65 * t1422 * t273 / 0.48e2 + t277 * t1744 / 0.240e3 + t68 * t1422 * t273 / 0.640e3 - t281 * t1744 / 0.4480e4 - t71 * t1422 * t273 / 0.11520e5 + t285 * t1744 / 0.103680e6 + t74 * t1422 * t273 / 0.258048e6 - t289 * t1744 / 0.2838528e7 - t77 * t1422 * t273 / 0.6881280e7 + t293 * t1744 / 0.89456640e8 + t80 * t1422 * t273 / 0.212336640e9 - t297 * t1744 / 0.3185049600e10 - t859 * t1422 * t273 / 0.7431782400e10 + t301 * t1744 / 0.126340300800e12
  t1783 = f.my_piecewise3(t56, 0, t1743)
  t1788 = t92 * t1440
  t1802 = t92 * t305
  t1827 = f.my_piecewise3(t55, t1782, -0.8e1 / 0.3e1 * t1783 * t99 - 0.8e1 / 0.3e1 * t1440 * t324 - 0.8e1 / 0.3e1 * t305 * t1455 - 0.8e1 / 0.3e1 * t83 * (-t872 * t305 * t1788 / 0.2e1 + 0.2e1 * t877 * t1440 * t305 - t307 * t1783 + 0.2e1 * t1783 * t96 + 0.2e1 * t1440 * t321 + 0.2e1 * t305 * t1452 + 0.2e1 * t83 * (-0.2e1 * t885 * t1440 * t1802 + t312 * t1783 * t92 / 0.2e1 + t893 * t1440 * t1802 / 0.4e1 - 0.4e1 * t305 * t93 * t1440 - t90 * t305 * t1788 - 0.4e1 * t316 * t1783 - t85 * t1783 * t92)))
  t1835 = -0.3e1 / 0.8e1 * t5 * t1698 * t239 - t1702 / 0.8e1 - 0.3e1 / 0.8e1 * t1410 * t330 - 0.3e1 / 0.8e1 * t1410 * t493 - t778 / 0.8e1 + t789 - t792 / 0.8e1 - t795 / 0.8e1 - 0.3e1 / 0.8e1 * t30 * t1461 - t1715 / 0.8e1 - 0.3e1 / 0.8e1 * t245 * t31 * t1827 * t238 - 0.3e1 / 0.8e1 * t245 * t1460 * t492
  t1836 = f.my_piecewise3(t1, 0, t1835)
  t1840 = f.my_piecewise5(t14, 0, t10, 0, -t1693)
  t1844 = f.my_piecewise3(t502, 0, 0.4e1 / 0.9e1 * t1259 * t1467 * t505 + 0.4e1 / 0.3e1 * t503 * t1840)
  t1848 = t1471 * t676
  t1858 = t674 * t247 * t1520 * t668
  t1865 = t38 * t256 * t1478
  t1875 = f.my_piecewise5(t44, 0, t42, 0, -t1693)
  t1879 = f.my_piecewise3(t512, 0, -0.2e1 / 0.9e1 * t1301 * t1474 * t688 + t687 * t1875 / 0.3e1)
  t1884 = t1289 + t1291 / 0.54e2 + t1865 / 0.54e2 + t1725 * t39 * t1294 * t1477 * t691 / 0.9e1 - t38 * t40 * t685 * t1879 / 0.18e2
  t1885 = f.my_piecewise3(t520, t1884, 0)
  t1923 = t526 * t1483 * t697 / 0.6e1 - t680 * t1885 / 0.18e2 - t529 * t1483 * t697 / 0.48e2 + t701 * t1885 / 0.240e3 + t532 * t1483 * t697 / 0.640e3 - t705 * t1885 / 0.4480e4 - t535 * t1483 * t697 / 0.11520e5 + t709 * t1885 / 0.103680e6 + t538 * t1483 * t697 / 0.258048e6 - t713 * t1885 / 0.2838528e7 - t541 * t1483 * t697 / 0.6881280e7 + t717 * t1885 / 0.89456640e8 + t544 * t1483 * t697 / 0.212336640e9 - t721 * t1885 / 0.3185049600e10 - t1343 * t1483 * t697 / 0.7431782400e10 + t725 * t1885 / 0.126340300800e12
  t1924 = f.my_piecewise3(t520, 0, t1884)
  t1929 = t555 * t1501
  t1943 = t555 * t729
  t1968 = f.my_piecewise3(t519, t1923, -0.8e1 / 0.3e1 * t1924 * t562 - 0.8e1 / 0.3e1 * t1501 * t748 - 0.8e1 / 0.3e1 * t729 * t1516 - 0.8e1 / 0.3e1 * t547 * (-t1356 * t729 * t1929 / 0.2e1 + 0.2e1 * t1361 * t1501 * t729 - t731 * t1924 + 0.2e1 * t1924 * t559 + 0.2e1 * t1501 * t745 + 0.2e1 * t729 * t1513 + 0.2e1 * t547 * (-0.2e1 * t1369 * t1501 * t1943 + t736 * t1924 * t555 / 0.2e1 + t1377 * t1501 * t1943 / 0.4e1 - 0.4e1 * t729 * t556 * t1501 - t553 * t729 * t1929 - 0.4e1 * t740 * t1924 - t548 * t1924 * t555)))
  t1976 = t674 * t675 * t1684
  t1981 = -0.3e1 / 0.8e1 * t5 * t1844 * t669 - t1848 / 0.8e1 - 0.3e1 / 0.8e1 * t1471 * t754 - t1272 / 0.8e1 + t1279 - t1282 / 0.8e1 - 0.3e1 / 0.8e1 * t509 * t1522 - t1858 / 0.8e1 - 0.3e1 / 0.8e1 * t674 * t31 * t1968 * t668 - 0.3e1 / 0.8e1 * t509 * t1685 - t1976 / 0.8e1 - 0.3e1 / 0.8e1 * t674 * t753 * t1684
  t1982 = f.my_piecewise3(t499, 0, t1981)
  d12 = t497 + t758 + t1465 + t1689 + t6 * (t1836 + t1982)
  t1987 = t1406 ** 2
  t1991 = 0.2e1 * t23 + 0.2e1 * t767
  t1992 = f.my_piecewise5(t10, 0, t14, 0, t1991)
  t1996 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t761 * t1987 + 0.4e1 / 0.3e1 * t21 * t1992)
  t2004 = t1422 ** 2
  t2008 = t1416 ** 2
  t2013 = t1413 ** 2
  t2016 = f.my_piecewise5(t42, 0, t44, 0, t1991)
  t2020 = f.my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t817 * t2013 + t263 * t2016 / 0.3e1)
  t2025 = t805 + t1722 / 0.27e2 + t38 * t40 * t810 * t2008 / 0.9e1 - t38 * t40 * t261 * t2020 / 0.18e2
  t2026 = f.my_piecewise3(t56, t2025, 0)
  t2057 = t62 * t2004 / 0.6e1 - t253 * t2026 / 0.18e2 - t65 * t2004 / 0.48e2 + t277 * t2026 / 0.240e3 + t68 * t2004 / 0.640e3 - t281 * t2026 / 0.4480e4 - t71 * t2004 / 0.11520e5 + t285 * t2026 / 0.103680e6 + t74 * t2004 / 0.258048e6 - t289 * t2026 / 0.2838528e7 - t77 * t2004 / 0.6881280e7 + t293 * t2026 / 0.89456640e8 + t80 * t2004 / 0.212336640e9 - t297 * t2026 / 0.3185049600e10 - t859 * t2004 / 0.7431782400e10 + t301 * t2026 / 0.126340300800e12
  t2058 = f.my_piecewise3(t56, 0, t2025)
  t2063 = t1440 ** 2
  t2098 = f.my_piecewise3(t55, t2057, -0.8e1 / 0.3e1 * t2058 * t99 - 0.16e2 / 0.3e1 * t1440 * t1455 - 0.8e1 / 0.3e1 * t83 * (-t872 * t2063 * t92 / 0.2e1 + 0.2e1 * t877 * t2063 - t307 * t2058 + 0.2e1 * t2058 * t96 + 0.4e1 * t1440 * t1452 + 0.2e1 * t83 * (-0.2e1 * t885 * t2063 * t92 + t312 * t2058 * t92 / 0.2e1 + t893 * t2063 * t92 / 0.4e1 - 0.4e1 * t2063 * t93 - t90 * t2063 * t92 - 0.4e1 * t316 * t2058 - t85 * t2058 * t92)))
  t2104 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1996 * t239 - t1702 / 0.4e1 - 0.3e1 / 0.4e1 * t1410 * t1461 + t789 - t1715 / 0.4e1 - 0.3e1 / 0.8e1 * t245 * t31 * t2098 * t238)
  t2105 = t1467 ** 2
  t2108 = -t1991
  t2109 = f.my_piecewise5(t14, 0, t10, 0, t2108)
  t2113 = f.my_piecewise3(t502, 0, 0.4e1 / 0.9e1 * t1259 * t2105 + 0.4e1 / 0.3e1 * t503 * t2109)
  t2124 = t1483 ** 2
  t2128 = t1477 ** 2
  t2133 = t1474 ** 2
  t2136 = f.my_piecewise5(t44, 0, t42, 0, t2108)
  t2140 = f.my_piecewise3(t512, 0, -0.2e1 / 0.9e1 * t1301 * t2133 + t687 * t2136 / 0.3e1)
  t2145 = t1289 + t1865 / 0.27e2 + t38 * t40 * t1294 * t2128 / 0.9e1 - t38 * t40 * t685 * t2140 / 0.18e2
  t2146 = f.my_piecewise3(t520, t2145, 0)
  t2177 = t526 * t2124 / 0.6e1 - t680 * t2146 / 0.18e2 - t529 * t2124 / 0.48e2 + t701 * t2146 / 0.240e3 + t532 * t2124 / 0.640e3 - t705 * t2146 / 0.4480e4 - t535 * t2124 / 0.11520e5 + t709 * t2146 / 0.103680e6 + t538 * t2124 / 0.258048e6 - t713 * t2146 / 0.2838528e7 - t541 * t2124 / 0.6881280e7 + t717 * t2146 / 0.89456640e8 + t544 * t2124 / 0.212336640e9 - t721 * t2146 / 0.3185049600e10 - t1343 * t2124 / 0.7431782400e10 + t725 * t2146 / 0.126340300800e12
  t2178 = f.my_piecewise3(t520, 0, t2145)
  t2183 = t1501 ** 2
  t2218 = f.my_piecewise3(t519, t2177, -0.8e1 / 0.3e1 * t2178 * t562 - 0.16e2 / 0.3e1 * t1501 * t1516 - 0.8e1 / 0.3e1 * t547 * (-t1356 * t2183 * t555 / 0.2e1 + 0.2e1 * t1361 * t2183 - t731 * t2178 + 0.2e1 * t2178 * t559 + 0.4e1 * t1501 * t1513 + 0.2e1 * t547 * (-0.2e1 * t1369 * t2183 * t555 + t736 * t2178 * t555 / 0.2e1 + t1377 * t2183 * t555 / 0.4e1 - 0.4e1 * t2183 * t556 - t553 * t2183 * t555 - 0.4e1 * t740 * t2178 - t548 * t2178 * t555)))
  t2230 = s2 ** 2
  t2231 = t568 ** 2
  t2234 = 0.1e1 / t569 / t2231 / t1529
  t2240 = 0.1e1 / t570 / t2231
  t2248 = t1531 * t586
  t2251 = tau1 ** 2
  t2255 = 0.1e1 / t569 / t2231 / r1
  t2256 = t2255 * t591
  t2264 = t596 * t2251 * t2255
  t2268 = t601 * t2251 * t2255
  t2272 = t606 * t2251 * t2255
  t2275 = t1604 * t1531
  t2278 = t1540 * t1531
  t2283 = t1547 * t1531
  t2288 = t1554 * t1531
  t2293 = -0.40e2 / 0.9e1 * t1536 * t2248 + 0.50e2 / 0.9e1 * t124 * t2251 * t2256 + 0.50e2 / 0.9e1 * t136 * t2251 * t2256 + 0.50e2 / 0.3e1 * t142 * t583 * t2264 + 0.50e2 * t1551 * t2268 + 0.100e3 / 0.3e1 * t594 * t2272 - 0.400e3 / 0.9e1 * t629 * t2275 - 0.40e2 / 0.9e1 * t584 * t2278 - 0.80e2 / 0.9e1 * t1544 * t2278 - 0.80e2 / 0.9e1 * t589 * t2283 - 0.40e2 / 0.3e1 * t1551 * t2283 - 0.40e2 / 0.3e1 * t594 * t2288 - 0.160e3 / 0.9e1 * t1558 * t2288
  t2299 = t636 * t2251 * t2255
  t2304 = t1613 * t1531
  t2307 = t1561 * t1531
  t2312 = t1568 * t1531
  t2317 = t1576 * t1531
  t2322 = t1583 * t1531
  t2327 = t1590 * t1531
  t2330 = 0.200e3 / 0.9e1 * t1544 * t2264 + 0.50e2 / 0.3e1 * t589 * t2268 + 0.5000e4 / 0.9e1 * t1601 * t2299 - 0.440e3 / 0.9e1 * t1608 * t2275 - 0.440e3 / 0.9e1 * t634 * t2304 - 0.160e3 / 0.9e1 * t599 * t2307 - 0.200e3 / 0.9e1 * t1565 * t2307 - 0.200e3 / 0.9e1 * t604 * t2312 - 0.80e2 / 0.3e1 * t1572 * t2312 - 0.80e2 / 0.3e1 * t609 * t2317 - 0.280e3 / 0.9e1 * t1580 * t2317 - 0.280e3 / 0.9e1 * t614 * t2322 - 0.320e3 / 0.9e1 * t1587 * t2322 - 0.320e3 / 0.9e1 * t619 * t2327
  t2334 = t1597 * t1531
  t2340 = t631 * t2251 * t2255
  t2352 = t626 * t2251 * t2255
  t2356 = t621 * t2251 * t2255
  t2361 = t616 * t2251 * t2255
  t2371 = -0.40e2 * t1594 * t2327 - 0.40e2 * t624 * t2334 - 0.400e3 / 0.9e1 * t1601 * t2334 + 0.450e3 * t1594 * t2340 + 0.250e3 * t624 * t2299 + 0.250e3 * t184 * t618 * t2340 + 0.200e3 * t619 * t2340 + 0.200e3 * t178 * t613 * t2352 + 0.350e3 / 0.3e1 * t609 * t2356 + 0.350e3 / 0.3e1 * t166 * t603 * t2361 + 0.2450e4 / 0.9e1 * t1580 * t2356 + 0.1400e4 / 0.9e1 * t614 * t2352 + 0.1400e4 / 0.9e1 * t172 * t608 * t2356
  t2378 = t611 * t2251 * t2255
  t2386 = t1612 * t2251 * t2255
  t2397 = 0.1e1 / t620 / t605 * t2251 * t2255
  t2412 = 0.3200e4 / 0.9e1 * t1587 * t2352 + 0.250e3 / 0.3e1 * t604 * t2361 + 0.250e3 / 0.3e1 * t160 * t598 * t2378 + 0.200e3 * t1572 * t2361 + 0.1250e4 / 0.9e1 * t1565 * t2378 + 0.2750e4 / 0.9e1 * t629 * t2386 + 0.2750e4 / 0.9e1 * t190 * t623 * t2299 + 0.6050e4 / 0.9e1 * t1608 * t2386 + 0.1100e4 / 0.3e1 * t634 * t2397 + 0.100e3 / 0.3e1 * t148 * t588 * t2268 + 0.800e3 / 0.9e1 * t1558 * t2272 + 0.500e3 / 0.9e1 * t599 * t2378 + 0.500e3 / 0.9e1 * t154 * t593 * t2272 + 0.50e2 / 0.9e1 * t584 * t2264
  t2455 = -0.80e2 / 0.9e1 * t1630 * t2278 - 0.80e2 / 0.9e1 * t646 * t2283 - 0.40e2 / 0.3e1 * t1635 * t2283 - 0.40e2 / 0.3e1 * t648 * t2288 - 0.160e3 / 0.9e1 * t1640 * t2288 - 0.160e3 / 0.9e1 * t650 * t2307 - 0.200e3 / 0.9e1 * t1645 * t2307 - 0.200e3 / 0.9e1 * t652 * t2312 - 0.80e2 / 0.3e1 * t1650 * t2312 - 0.80e2 / 0.3e1 * t654 * t2317 - 0.280e3 / 0.9e1 * t1656 * t2317 - 0.280e3 / 0.9e1 * t656 * t2322 + 0.50e2 / 0.9e1 * t203 * t2251 * t2256
  t2488 = 0.50e2 / 0.9e1 * t206 * t2251 * t2256 - 0.40e2 / 0.9e1 * t1625 * t2248 - 0.40e2 / 0.9e1 * t644 * t2278 + 0.5000e4 / 0.9e1 * t1671 * t2299 + 0.2750e4 / 0.9e1 * t662 * t2386 + 0.2750e4 / 0.9e1 * t233 * t623 * t2299 + 0.6050e4 / 0.9e1 * t1676 * t2386 + 0.800e3 / 0.9e1 * t1640 * t2272 + 0.200e3 * t227 * t613 * t2352 + 0.450e3 * t1666 * t2340 + 0.250e3 * t660 * t2299 + 0.250e3 * t230 * t618 * t2340 + 0.1100e4 / 0.3e1 * t664 * t2397 + 0.500e3 / 0.9e1 * t650 * t2378
  t2520 = 0.500e3 / 0.9e1 * t215 * t593 * t2272 + 0.1250e4 / 0.9e1 * t1645 * t2378 + 0.250e3 / 0.3e1 * t652 * t2361 + 0.250e3 / 0.3e1 * t218 * t598 * t2378 + 0.200e3 * t1650 * t2361 + 0.350e3 / 0.3e1 * t654 * t2356 + 0.350e3 / 0.3e1 * t221 * t603 * t2361 + 0.2450e4 / 0.9e1 * t1656 * t2356 + 0.1400e4 / 0.9e1 * t656 * t2352 + 0.1400e4 / 0.9e1 * t224 * t608 * t2356 + 0.3200e4 / 0.9e1 * t1661 * t2352 + 0.200e3 * t658 * t2340 - 0.320e3 / 0.9e1 * t1661 * t2322
  t2551 = -0.320e3 / 0.9e1 * t658 * t2327 + 0.50e2 / 0.9e1 * t644 * t2264 + 0.200e3 / 0.9e1 * t1630 * t2264 + 0.50e2 / 0.3e1 * t646 * t2268 + 0.50e2 / 0.3e1 * t209 * t583 * t2264 + 0.50e2 * t1635 * t2268 + 0.100e3 / 0.3e1 * t648 * t2272 + 0.100e3 / 0.3e1 * t212 * t588 * t2268 - 0.40e2 * t1666 * t2327 - 0.40e2 * t660 * t2334 - 0.400e3 / 0.9e1 * t1671 * t2334 - 0.400e3 / 0.9e1 * t662 * t2275 - 0.440e3 / 0.9e1 * t1676 * t2275 - 0.440e3 / 0.9e1 * t664 * t2304
  t2560 = f.my_piecewise3(t499, 0, -0.3e1 / 0.8e1 * t5 * t2113 * t669 - t1848 / 0.4e1 - 0.3e1 / 0.4e1 * t1471 * t1522 - 0.3e1 / 0.4e1 * t1471 * t1685 + t1279 - t1858 / 0.4e1 - t1976 / 0.4e1 - 0.3e1 / 0.8e1 * t674 * t31 * t2218 * t668 - 0.3e1 / 0.4e1 * t674 * t1521 * t1684 - 0.3e1 / 0.8e1 * t674 * t567 * (-0.76906968678720000000000000000000000000000000000000e-3 / t1525 / t576 * t125 * t924 * t2230 * t2234 * t638 + 0.57808982880000000000000000000000000000000000000000e-1 * t1528 * s2 * t2240 * t638 - 0.31532172480000000000000000000000000000000000000000e-1 * t1528 * t1532 * t1618 + t579 * (t2293 + t2330 + t2371 + t2412) + 0.50297210791037951531778692272519433013260173754001e-1 * t1620 * t2240 * t641 * t666 - 0.34088340999255810609977046547411469101414150735753e-3 * t1116 * t2230 * t2234 * t641 * t666 - 0.27434842249657064471879286694101508916323731138546e-1 * t1620 * t1621 * t1682 + t643 * (t2455 + t2488 + t2520 + t2551)))
  d22 = 0.2e1 * t1465 + 0.2e1 * t1689 + t6 * (t2104 + t2560)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

