"""Generated from mgga_x_mbeefvdw.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_n = 5

  mbeef_coefs = [None, np.array([np.nan, 1.17114923, 0.115594371, -0.0532167416, -0.0201131648, 0.00141417107], dtype=np.float64), np.array([np.nan, -0.0676157938, 0.0453837246, -0.0222650139, 0.0192374554, 9.19317034e-07], dtype=np.float64), np.array([np.nan, 0.0148659502, 0.0318024096, -0.00521818079, 1.33707403e-07, -5.00749348e-07], dtype=np.float64), np.array([np.nan, 0.00140794142, -0.00608338264, -6.57949254e-07, -5.49909413e-08, 5.74317889e-08], dtype=np.float64), np.array([np.nan, 0.000141530486, -1.00478906e-07, 2.01895739e-07, 3.97324768e-09, -3.40722258e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeefvdw_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeefvdw_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_n = 5

  mbeef_coefs = [None, np.array([np.nan, 1.17114923, 0.115594371, -0.0532167416, -0.0201131648, 0.00141417107], dtype=np.float64), np.array([np.nan, -0.0676157938, 0.0453837246, -0.0222650139, 0.0192374554, 9.19317034e-07], dtype=np.float64), np.array([np.nan, 0.0148659502, 0.0318024096, -0.00521818079, 1.33707403e-07, -5.00749348e-07], dtype=np.float64), np.array([np.nan, 0.00140794142, -0.00608338264, -6.57949254e-07, -5.49909413e-08, 5.74317889e-08], dtype=np.float64), np.array([np.nan, 0.000141530486, -1.00478906e-07, 2.01895739e-07, 3.97324768e-09, -3.40722258e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeefvdw_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeefvdw_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_n = 5

  mbeef_coefs = [None, np.array([np.nan, 1.17114923, 0.115594371, -0.0532167416, -0.0201131648, 0.00141417107], dtype=np.float64), np.array([np.nan, -0.0676157938, 0.0453837246, -0.0222650139, 0.0192374554, 9.19317034e-07], dtype=np.float64), np.array([np.nan, 0.0148659502, 0.0318024096, -0.00521818079, 1.33707403e-07, -5.00749348e-07], dtype=np.float64), np.array([np.nan, 0.00140794142, -0.00608338264, -6.57949254e-07, -5.49909413e-08, 5.74317889e-08], dtype=np.float64), np.array([np.nan, 0.000141530486, -1.00478906e-07, 2.01895739e-07, 3.97324768e-09, -3.40722258e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeefvdw_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeefvdw_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = r0 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.1e1 / t29 / r0
  t33 = r0 ** 2
  t35 = 0.1e1 / t29 / t33
  t36 = s0 * t35
  t39 = 6 ** (0.1e1 / 0.3e1)
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t46 = 0.5e1 / 0.9e1 * (tau0 * t31 - t36 / 0.8e1) * t39 * t44
  t47 = 0.1e5 <= t46
  t48 = 0.1e5 < t46
  t49 = f.my_piecewise3(t48, t46, 0.1e5)
  t50 = t49 ** 2
  t54 = 0.1e1 / t50 / t49
  t55 = t50 ** 2
  t56 = 0.1e1 / t55
  t59 = f.my_piecewise3(t48, 0.1e5, t46)
  t60 = t59 ** 2
  t61 = 0.1e1 - t60
  t62 = t61 ** 2
  t63 = t62 * t61
  t64 = t60 * t59
  t65 = 0.1e1 + t64
  t67 = t64 * t65 + 0.1e1
  t68 = 0.1e1 / t67
  t70 = f.my_piecewise3(t47, 0.1e1 - 0.3e1 / t50 - t54 + 0.3e1 * t56, -t63 * t68)
  t71 = t70 ** 2
  t72 = t71 * t70
  t74 = t39 * t44
  t77 = 0.65124e1 + t74 * t36 / 0.24e2
  t78 = 0.1e1 / t77
  t80 = t74 * t36 * t78
  t82 = t80 / 0.12e2 - 0.1e1
  t83 = t82 ** 2
  t84 = t83 * t82
  t88 = t71 ** 2
  t90 = t83 ** 2
  t95 = -0.12777084675000000000000000000000000000000000000000e-8 - 0.14906598787500000000000000000000000000000000000000e-7 * t90 + 0.12777084675000000000000000000000000000000000000000e-7 * t83
  t98 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t88 - 0.15e2 / 0.4e1 * t71
  t102 = 0.21536920837500000000000000000000000000000000000000e-7 + 0.25126407643750000000000000000000000000000000000000e-6 * t90 - 0.21536920837500000000000000000000000000000000000000e-6 * t83
  t105 = 0.5e1 / 0.2e1 * t72 - 0.3e1 / 0.2e1 * t70
  t109 = -0.18778100550000000000000000000000000000000000000000e-6 - 0.21907783975000000000000000000000000000000000000000e-5 * t90 + 0.18778100550000000000000000000000000000000000000000e-5 * t83
  t111 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t71
  t115 = 0.34474388775000000000000000000000000000000000000000e-6 + 0.40220120237500000000000000000000000000000000000000e-5 * t90 - 0.34474388775000000000000000000000000000000000000000e-5 * t83
  t117 = 0.10451438955835000000000000000000000000000000000000e1 + 0.35198535500000000000000000000000000000000000000000e-2 * t72 - 0.50282912000000000000000000000000000000000000000000e-1 * t84 - 0.69727705930000000000000000000000000000000000000000e-1 * t70 + 0.21768185977500000000000000000000000000000000000000e-1 * t71 + 0.61919587625000000000000000000000000000000000000000e-3 * t88 + 0.61869984312500000000000000000000000000000000000000e-2 * t90 - 0.85128253912500000000000000000000000000000000000000e-1 * t83 + t95 * t98 + t102 * t105 + t109 * t111 + t115 * t70
  t120 = 0.99331192000000000000000000000000000000000000000000e-8 * t84 - 0.49665596000000000000000000000000000000000000000000e-9 * t80 + 0.59598715200000000000000000000000000000000000000000e-8
  t124 = -0.13747735325000000000000000000000000000000000000000e-6 * t84 + 0.68738676625000000000000000000000000000000000000000e-8 * t80 - 0.82486411950000000000000000000000000000000000000000e-7
  t128 = 0.33426850750000000000000000000000000000000000000000e-6 * t84 - 0.16713425375000000000000000000000000000000000000000e-7 * t80 + 0.20056110450000000000000000000000000000000000000000e-6
  t132 = 0.48093638500000000000000000000000000000000000000000e-1 * t84 - 0.24046819250000000000000000000000000000000000000000e-2 * t80 + 0.28856183100000000000000000000000000000000000000000e-1
  t135 = -0.10094786950000000000000000000000000000000000000000e-6 + 0.30284360850000000000000000000000000000000000000000e-6 * t83
  t138 = 0.32897462700000000000000000000000000000000000000000e-6 - 0.98692388100000000000000000000000000000000000000000e-6 * t83
  t141 = 0.26090903950000000000000000000000000000000000000000e-2 - 0.78272711850000000000000000000000000000000000000000e-2 * t83
  t144 = 0.37819770500000000000000000000000000000000000000000e-2 * t80 - 0.453837246e-1
  t147 = 0.26502008000000000000000000000000000000000000000000e-2 * t80 - 0.318024096e-1
  t150 = -0.50694855333333333333333333333333333333333333333333e-3 * t80 + 0.608338264e-2
  t153 = -0.83732421666666666666666666666666666666666666666667e-8 * t80 + 0.100478906e-6
  t156 = 0.11132506950000000000000000000000000000000000000000e-1 - 0.33397520850000000000000000000000000000000000000000e-1 * t83
  t159 = t120 * t98 + t124 * t105 + t128 * t111 + t132 * t70 + t135 * t98 + t138 * t105 + t141 * t111 + t144 * t70 + t147 * t111 + t150 * t105 + t153 * t98 + t156 * t70 + 0.12147009850000000000000000000000000000000000000000e-1 * t80
  t160 = t117 + t159
  t164 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t160)
  t165 = r1 <= f.p.dens_threshold
  t166 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t167 = 0.1e1 + t166
  t168 = t167 <= f.p.zeta_threshold
  t169 = t167 ** (0.1e1 / 0.3e1)
  t171 = f.my_piecewise3(t168, t22, t169 * t167)
  t172 = t171 * t26
  t173 = r1 ** 2
  t174 = r1 ** (0.1e1 / 0.3e1)
  t175 = t174 ** 2
  t177 = 0.1e1 / t175 / t173
  t178 = s2 * t177
  t181 = 0.65124e1 + t74 * t178 / 0.24e2
  t182 = 0.1e1 / t181
  t184 = t74 * t178 * t182
  t186 = t184 / 0.12e2 - 0.1e1
  t187 = t186 ** 2
  t188 = t187 ** 2
  t191 = -0.12777084675000000000000000000000000000000000000000e-8 - 0.14906598787500000000000000000000000000000000000000e-7 * t188 + 0.12777084675000000000000000000000000000000000000000e-7 * t187
  t193 = 0.1e1 / t175 / r1
  t199 = 0.5e1 / 0.9e1 * (tau1 * t193 - t178 / 0.8e1) * t39 * t44
  t200 = 0.1e5 <= t199
  t201 = 0.1e5 < t199
  t202 = f.my_piecewise3(t201, t199, 0.1e5)
  t203 = t202 ** 2
  t207 = 0.1e1 / t203 / t202
  t208 = t203 ** 2
  t209 = 0.1e1 / t208
  t212 = f.my_piecewise3(t201, 0.1e5, t199)
  t213 = t212 ** 2
  t214 = 0.1e1 - t213
  t215 = t214 ** 2
  t216 = t215 * t214
  t217 = t213 * t212
  t218 = 0.1e1 + t217
  t220 = t217 * t218 + 0.1e1
  t221 = 0.1e1 / t220
  t223 = f.my_piecewise3(t200, 0.1e1 - 0.3e1 / t203 - t207 + 0.3e1 * t209, -t216 * t221)
  t224 = t223 ** 2
  t225 = t224 ** 2
  t228 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t225 - 0.15e2 / 0.4e1 * t224
  t232 = 0.21536920837500000000000000000000000000000000000000e-7 + 0.25126407643750000000000000000000000000000000000000e-6 * t188 - 0.21536920837500000000000000000000000000000000000000e-6 * t187
  t233 = t224 * t223
  t236 = 0.5e1 / 0.2e1 * t233 - 0.3e1 / 0.2e1 * t223
  t240 = -0.18778100550000000000000000000000000000000000000000e-6 - 0.21907783975000000000000000000000000000000000000000e-5 * t188 + 0.18778100550000000000000000000000000000000000000000e-5 * t187
  t242 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t224
  t246 = 0.34474388775000000000000000000000000000000000000000e-6 + 0.40220120237500000000000000000000000000000000000000e-5 * t188 - 0.34474388775000000000000000000000000000000000000000e-5 * t187
  t248 = t187 * t186
  t251 = 0.99331192000000000000000000000000000000000000000000e-8 * t248 - 0.49665596000000000000000000000000000000000000000000e-9 * t184 + 0.59598715200000000000000000000000000000000000000000e-8
  t255 = -0.13747735325000000000000000000000000000000000000000e-6 * t248 + 0.68738676625000000000000000000000000000000000000000e-8 * t184 - 0.82486411950000000000000000000000000000000000000000e-7
  t259 = 0.33426850750000000000000000000000000000000000000000e-6 * t248 - 0.16713425375000000000000000000000000000000000000000e-7 * t184 + 0.20056110450000000000000000000000000000000000000000e-6
  t263 = 0.48093638500000000000000000000000000000000000000000e-1 * t248 - 0.24046819250000000000000000000000000000000000000000e-2 * t184 + 0.28856183100000000000000000000000000000000000000000e-1
  t266 = -0.10094786950000000000000000000000000000000000000000e-6 + 0.30284360850000000000000000000000000000000000000000e-6 * t187
  t269 = 0.32897462700000000000000000000000000000000000000000e-6 - 0.98692388100000000000000000000000000000000000000000e-6 * t187
  t272 = 0.26090903950000000000000000000000000000000000000000e-2 - 0.78272711850000000000000000000000000000000000000000e-2 * t187
  t274 = 0.10451438955835000000000000000000000000000000000000e1 + t191 * t228 + t232 * t236 + t240 * t242 + t246 * t223 + t251 * t228 + t255 * t236 + t259 * t242 + t263 * t223 + t266 * t228 + t269 * t236 + t272 * t242
  t276 = 0.11132506950000000000000000000000000000000000000000e-1 - 0.33397520850000000000000000000000000000000000000000e-1 * t187
  t279 = -0.83732421666666666666666666666666666666666666666667e-8 * t184 + 0.100478906e-6
  t282 = -0.50694855333333333333333333333333333333333333333333e-3 * t184 + 0.608338264e-2
  t285 = 0.26502008000000000000000000000000000000000000000000e-2 * t184 - 0.318024096e-1
  t288 = 0.37819770500000000000000000000000000000000000000000e-2 * t184 - 0.453837246e-1
  t298 = t276 * t223 + t279 * t228 + t282 * t236 + t285 * t242 + t288 * t223 - 0.50282912000000000000000000000000000000000000000000e-1 * t248 + 0.35198535500000000000000000000000000000000000000000e-2 * t233 - 0.69727705930000000000000000000000000000000000000000e-1 * t223 + 0.21768185977500000000000000000000000000000000000000e-1 * t224 + 0.61919587625000000000000000000000000000000000000000e-3 * t225 + 0.61869984312500000000000000000000000000000000000000e-2 * t188 - 0.85128253912500000000000000000000000000000000000000e-1 * t187 + 0.12147009850000000000000000000000000000000000000000e-1 * t184
  t299 = t274 + t298
  t303 = f.my_piecewise3(t165, 0, -0.3e1 / 0.8e1 * t5 * t172 * t299)
  t304 = t6 ** 2
  t306 = t16 / t304
  t307 = t7 - t306
  t308 = f.my_piecewise5(t10, 0, t14, 0, t307)
  t311 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t308)
  t316 = t26 ** 2
  t317 = 0.1e1 / t316
  t321 = t5 * t25 * t317 * t160 / 0.8e1
  t327 = s0 / t29 / t33 / r0
  t332 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t35 + t327 / 0.3e1) * t39 * t44
  t333 = f.my_piecewise3(t48, t332, 0)
  t339 = 0.1e1 / t55 / t49
  t343 = t62 * t68
  t344 = f.my_piecewise3(t48, 0, t332)
  t348 = t67 ** 2
  t350 = t63 / t348
  t351 = t60 * t65
  t353 = t60 ** 2
  t354 = t353 * t59
  t360 = f.my_piecewise3(t47, -0.12e2 * t339 * t333 + 0.6e1 * t54 * t333 + 0.3e1 * t56 * t333, 0.6e1 * t343 * t59 * t344 + t350 * (0.3e1 * t351 * t344 + 0.3e1 * t354 * t344))
  t363 = t74 * t327 * t78
  t365 = t39 ** 2
  t368 = t365 / t42 / t41
  t369 = s0 ** 2
  t370 = t33 ** 2
  t375 = t77 ** 2
  t376 = 0.1e1 / t375
  t378 = t368 * t369 / t28 / t370 / t33 * t376
  t380 = -0.2e1 / 0.9e1 * t363 + t378 / 0.108e3
  t381 = t82 * t380
  t388 = t141 * t70
  t391 = t147 * t70
  t394 = t109 * t70
  t397 = t128 * t70
  t403 = t71 * t360
  t406 = 0.15e2 / 0.2e1 * t403 - 0.3e1 / 0.2e1 * t360
  t413 = t72 * t360
  t415 = t70 * t360
  t417 = 0.35e2 / 0.2e1 * t413 - 0.15e2 / 0.2e1 * t415
  t434 = -0.69727705930000000000000000000000000000000000000000e-1 * t360 - 0.66795041700000000000000000000000000000000000000000e-1 * t381 * t70 - 0.19738477620000000000000000000000000000000000000000e-5 * t381 * t105 - 0.15654542370000000000000000000000000000000000000000e-1 * t381 * t111 + 0.3e1 * t388 * t360 + 0.3e1 * t391 * t360 + 0.3e1 * t394 * t360 + 0.3e1 * t397 * t360 + 0.60568721700000000000000000000000000000000000000000e-6 * t381 * t98 + t156 * t360 + t150 * t406 + 0.10559560650000000000000000000000000000000000000000e-1 * t403 + (0.22328645777777777777777777777777777777777777777778e-7 * t363 - 0.93036024074074074074074074074074074074074074074074e-9 * t378) * t98 + t153 * t417 + 0.24767835050000000000000000000000000000000000000000e-2 * t413 + 0.43536371955000000000000000000000000000000000000000e-1 * t415 + (-0.10085272133333333333333333333333333333333333333333e-1 * t363 + 0.42021967222222222222222222222222222222222222222222e-3 * t378) * t70 + t144 * t360 + (-0.70672021333333333333333333333333333333333333333333e-2 * t363 + 0.29446675555555555555555555555555555555555555555556e-3 * t378) * t111 + (0.13518628088888888888888888888888888888888888888889e-2 * t363 - 0.56327617037037037037037037037037037037037037037037e-4 * t378) * t105
  t436 = t83 * t380
  t450 = t84 * t380
  t487 = (0.29799357600000000000000000000000000000000000000000e-7 * t436 + 0.13244158933333333333333333333333333333333333333333e-8 * t363 - 0.55183995555555555555555555555555555555555555555556e-10 * t378) * t98 + t120 * t417 + (-0.41243205975000000000000000000000000000000000000000e-6 * t436 - 0.18330313766666666666666666666666666666666666666667e-7 * t363 + 0.76376307361111111111111111111111111111111111111111e-9 * t378) * t105 + t124 * t406 + (0.10050563057500000000000000000000000000000000000000e-5 * t450 - 0.43073841675000000000000000000000000000000000000000e-6 * t381) * t105 + t102 * t406 + (-0.87631135900000000000000000000000000000000000000000e-5 * t450 + 0.37556201100000000000000000000000000000000000000000e-5 * t381) * t111 + (-0.59626395150000000000000000000000000000000000000000e-7 * t450 + 0.25554169350000000000000000000000000000000000000000e-7 * t381) * t98 + t95 * t417 - 0.32392026266666666666666666666666666666666666666667e-1 * t363 + 0.13496677611111111111111111111111111111111111111111e-2 * t378
  t494 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t26 * t160 - t321 - 0.3e1 / 0.8e1 * t5 * t27 * (t434 + t138 * t406 + (0.10028055225000000000000000000000000000000000000000e-5 * t436 + 0.44569134333333333333333333333333333333333333333333e-7 * t363 - 0.18570472638888888888888888888888888888888888888889e-8 * t378) * t111 - 0.15084873600000000000000000000000000000000000000000e0 * t436 + (0.14428091550000000000000000000000000000000000000000e0 * t436 + 0.64124851333333333333333333333333333333333333333333e-2 * t363 - 0.26718688055555555555555555555555555555555555555556e-3 * t378) * t70 + t132 * t360 + t135 * t417 + (0.16088048095000000000000000000000000000000000000000e-4 * t450 - 0.68948777550000000000000000000000000000000000000000e-5 * t381) * t70 + 0.24747993725000000000000000000000000000000000000000e-1 * t450 - 0.17025650782500000000000000000000000000000000000000e0 * t381 + t115 * t360 + t487))
  t496 = f.my_piecewise5(t14, 0, t10, 0, -t307)
  t499 = f.my_piecewise3(t168, 0, 0.4e1 / 0.3e1 * t169 * t496)
  t507 = t5 * t171 * t317 * t299 / 0.8e1
  t509 = f.my_piecewise3(t165, 0, -0.3e1 / 0.8e1 * t5 * t499 * t26 * t299 - t507)
  vrho_0_ = t164 + t303 + t6 * (t494 + t509)
  t512 = -t7 - t306
  t513 = f.my_piecewise5(t10, 0, t14, 0, t512)
  t516 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t513)
  t522 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t516 * t26 * t160 - t321)
  t524 = f.my_piecewise5(t14, 0, t10, 0, -t512)
  t527 = f.my_piecewise3(t168, 0, 0.4e1 / 0.3e1 * t169 * t524)
  t535 = s2 / t175 / t173 / r1
  t537 = t74 * t535 * t182
  t545 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau1 * t177 + t535 / 0.3e1) * t39 * t44
  t546 = f.my_piecewise3(t201, t545, 0)
  t552 = 0.1e1 / t208 / t202
  t556 = t215 * t221
  t557 = f.my_piecewise3(t201, 0, t545)
  t561 = t220 ** 2
  t563 = t216 / t561
  t564 = t213 * t218
  t566 = t213 ** 2
  t567 = t566 * t212
  t573 = f.my_piecewise3(t200, 0.6e1 * t207 * t546 + 0.3e1 * t209 * t546 - 0.12e2 * t552 * t546, 0.6e1 * t556 * t212 * t557 + t563 * (0.3e1 * t564 * t557 + 0.3e1 * t567 * t557))
  t575 = s2 ** 2
  t576 = t173 ** 2
  t581 = t181 ** 2
  t582 = 0.1e1 / t581
  t584 = t368 * t575 / t174 / t576 / t173 * t582
  t588 = -0.2e1 / 0.9e1 * t537 + t584 / 0.108e3
  t589 = t186 * t588
  t594 = t272 * t223
  t599 = t285 * t223
  t602 = t259 * t223
  t607 = t240 * t223
  t623 = t233 * t573
  t625 = t223 * t573
  t627 = 0.35e2 / 0.2e1 * t623 - 0.15e2 / 0.2e1 * t625
  t635 = t224 * t573
  t638 = 0.15e2 / 0.2e1 * t635 - 0.3e1 / 0.2e1 * t573
  t640 = -0.32392026266666666666666666666666666666666666666667e-1 * t537 - 0.69727705930000000000000000000000000000000000000000e-1 * t573 + 0.13496677611111111111111111111111111111111111111111e-2 * t584 - 0.19738477620000000000000000000000000000000000000000e-5 * t589 * t236 - 0.15654542370000000000000000000000000000000000000000e-1 * t589 * t242 + 0.3e1 * t594 * t573 - 0.66795041700000000000000000000000000000000000000000e-1 * t589 * t223 + 0.3e1 * t599 * t573 + 0.3e1 * t602 * t573 + 0.60568721700000000000000000000000000000000000000000e-6 * t589 * t228 + 0.3e1 * t607 * t573 + (-0.70672021333333333333333333333333333333333333333333e-2 * t537 + 0.29446675555555555555555555555555555555555555555556e-3 * t584) * t242 + (-0.10085272133333333333333333333333333333333333333333e-1 * t537 + 0.42021967222222222222222222222222222222222222222222e-3 * t584) * t223 + t288 * t573 + (0.22328645777777777777777777777777777777777777777778e-7 * t537 - 0.93036024074074074074074074074074074074074074074074e-9 * t584) * t228 + t279 * t627 + 0.24767835050000000000000000000000000000000000000000e-2 * t623 + 0.43536371955000000000000000000000000000000000000000e-1 * t625 + (0.13518628088888888888888888888888888888888888888889e-2 * t537 - 0.56327617037037037037037037037037037037037037037037e-4 * t584) * t236 + t282 * t638
  t644 = t187 * t588
  t665 = t248 * t588
  t693 = (-0.87631135900000000000000000000000000000000000000000e-5 * t665 + 0.37556201100000000000000000000000000000000000000000e-5 * t589) * t242 + 0.24747993725000000000000000000000000000000000000000e-1 * t665 - 0.17025650782500000000000000000000000000000000000000e0 * t589 + (0.16088048095000000000000000000000000000000000000000e-4 * t665 - 0.68948777550000000000000000000000000000000000000000e-5 * t589) * t223 + t246 * t573 + (0.29799357600000000000000000000000000000000000000000e-7 * t644 + 0.13244158933333333333333333333333333333333333333333e-8 * t537 - 0.55183995555555555555555555555555555555555555555556e-10 * t584) * t228 + t251 * t627 + (-0.59626395150000000000000000000000000000000000000000e-7 * t665 + 0.25554169350000000000000000000000000000000000000000e-7 * t589) * t228 + t191 * t627 + (0.10050563057500000000000000000000000000000000000000e-5 * t665 - 0.43073841675000000000000000000000000000000000000000e-6 * t589) * t236 + t232 * t638
  t700 = f.my_piecewise3(t165, 0, -0.3e1 / 0.8e1 * t5 * t527 * t26 * t299 - t507 - 0.3e1 / 0.8e1 * t5 * t172 * (t640 + 0.10559560650000000000000000000000000000000000000000e-1 * t635 + t269 * t638 + t276 * t573 + (0.14428091550000000000000000000000000000000000000000e0 * t644 + 0.64124851333333333333333333333333333333333333333333e-2 * t537 - 0.26718688055555555555555555555555555555555555555556e-3 * t584) * t223 - 0.15084873600000000000000000000000000000000000000000e0 * t644 + t263 * t573 + t266 * t627 + (-0.41243205975000000000000000000000000000000000000000e-6 * t644 - 0.18330313766666666666666666666666666666666666666667e-7 * t537 + 0.76376307361111111111111111111111111111111111111111e-9 * t584) * t236 + t255 * t638 + (0.10028055225000000000000000000000000000000000000000e-5 * t644 + 0.44569134333333333333333333333333333333333333333333e-7 * t537 - 0.18570472638888888888888888888888888888888888888889e-8 * t584) * t242 + t693))
  vrho_1_ = t164 + t303 + t6 * (t522 + t700)
  t708 = t368 * s0 / t28 / t370 / r0 * t376
  t711 = 0.5e1 / 0.72e2 * t74 * t35
  t712 = f.my_piecewise3(t48, -t711, 0)
  t720 = f.my_piecewise3(t48, 0, -t711)
  t730 = f.my_piecewise3(t47, -0.12e2 * t339 * t712 + 0.6e1 * t54 * t712 + 0.3e1 * t56 * t712, 0.6e1 * t343 * t59 * t720 + t350 * (0.3e1 * t351 * t720 + 0.3e1 * t354 * t720))
  t735 = t74 * t35 * t78
  t738 = t735 / 0.12e2 - t708 / 0.288e3
  t739 = t82 * t738
  t764 = t71 * t730
  t767 = 0.15e2 / 0.2e1 * t764 - 0.3e1 / 0.2e1 * t730
  t774 = t72 * t730
  t776 = t70 * t730
  t778 = 0.35e2 / 0.2e1 * t774 - 0.15e2 / 0.2e1 * t776
  t782 = -0.50612541041666666666666666666666666666666666666667e-3 * t708 - 0.69727705930000000000000000000000000000000000000000e-1 * t730 + 0.3e1 * t391 * t730 - 0.66795041700000000000000000000000000000000000000000e-1 * t739 * t70 + 0.3e1 * t397 * t730 + 0.60568721700000000000000000000000000000000000000000e-6 * t739 * t98 - 0.19738477620000000000000000000000000000000000000000e-5 * t739 * t105 - 0.15654542370000000000000000000000000000000000000000e-1 * t739 * t111 + 0.3e1 * t388 * t730 + 0.3e1 * t394 * t730 + 0.12147009850000000000000000000000000000000000000000e-1 * t735 + t156 * t730 + (0.26502008000000000000000000000000000000000000000000e-2 * t735 - 0.11042503333333333333333333333333333333333333333333e-3 * t708) * t111 + (-0.50694855333333333333333333333333333333333333333333e-3 * t735 + 0.21122856388888888888888888888888888888888888888889e-4 * t708) * t105 + t150 * t767 + 0.10559560650000000000000000000000000000000000000000e-1 * t764 + (-0.83732421666666666666666666666666666666666666666667e-8 * t735 + 0.34888509027777777777777777777777777777777777777778e-9 * t708) * t98 + t153 * t778 + 0.24767835050000000000000000000000000000000000000000e-2 * t774 + 0.43536371955000000000000000000000000000000000000000e-1 * t776
  t788 = t83 * t738
  t810 = t84 * t738
  t838 = (-0.87631135900000000000000000000000000000000000000000e-5 * t810 + 0.37556201100000000000000000000000000000000000000000e-5 * t739) * t111 + 0.24747993725000000000000000000000000000000000000000e-1 * t810 - 0.17025650782500000000000000000000000000000000000000e0 * t739 + (0.16088048095000000000000000000000000000000000000000e-4 * t810 - 0.68948777550000000000000000000000000000000000000000e-5 * t739) * t70 + t115 * t730 + (0.29799357600000000000000000000000000000000000000000e-7 * t788 - 0.49665596000000000000000000000000000000000000000000e-9 * t735 + 0.20693998333333333333333333333333333333333333333333e-10 * t708) * t98 + t120 * t778 + (-0.59626395150000000000000000000000000000000000000000e-7 * t810 + 0.25554169350000000000000000000000000000000000000000e-7 * t739) * t98 + t95 * t778 + (0.10050563057500000000000000000000000000000000000000e-5 * t810 - 0.43073841675000000000000000000000000000000000000000e-6 * t739) * t105 + t102 * t767
  t844 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t782 + (0.37819770500000000000000000000000000000000000000000e-2 * t735 - 0.15758237708333333333333333333333333333333333333333e-3 * t708) * t70 + t144 * t730 + (0.14428091550000000000000000000000000000000000000000e0 * t788 - 0.24046819250000000000000000000000000000000000000000e-2 * t735 + 0.10019508020833333333333333333333333333333333333333e-3 * t708) * t70 - 0.15084873600000000000000000000000000000000000000000e0 * t788 + t132 * t730 + t135 * t778 + t138 * t767 + (-0.41243205975000000000000000000000000000000000000000e-6 * t788 + 0.68738676625000000000000000000000000000000000000000e-8 * t735 - 0.28641115260416666666666666666666666666666666666667e-9 * t708) * t105 + t124 * t767 + (0.10028055225000000000000000000000000000000000000000e-5 * t788 - 0.16713425375000000000000000000000000000000000000000e-7 * t735 + 0.69639272395833333333333333333333333333333333333333e-9 * t708) * t111 + t838))
  vsigma_0_ = t6 * t844
  vsigma_1_ = 0.0e0
  t850 = t368 * s2 / t174 / t576 / r1 * t582
  t853 = 0.5e1 / 0.72e2 * t74 * t177
  t854 = f.my_piecewise3(t201, -t853, 0)
  t862 = f.my_piecewise3(t201, 0, -t853)
  t872 = f.my_piecewise3(t200, 0.6e1 * t207 * t854 + 0.3e1 * t209 * t854 - 0.12e2 * t552 * t854, 0.6e1 * t556 * t212 * t862 + t563 * (0.3e1 * t564 * t862 + 0.3e1 * t567 * t862))
  t875 = t74 * t177 * t182
  t878 = t875 / 0.12e2 - t850 / 0.288e3
  t879 = t186 * t878
  t897 = t248 * t878
  t904 = t233 * t872
  t906 = t223 * t872
  t908 = 0.35e2 / 0.2e1 * t904 - 0.15e2 / 0.2e1 * t906
  t916 = t224 * t872
  t919 = 0.15e2 / 0.2e1 * t916 - 0.3e1 / 0.2e1 * t872
  t922 = -0.50612541041666666666666666666666666666666666666667e-3 * t850 - 0.69727705930000000000000000000000000000000000000000e-1 * t872 - 0.19738477620000000000000000000000000000000000000000e-5 * t879 * t236 - 0.15654542370000000000000000000000000000000000000000e-1 * t879 * t242 + 0.3e1 * t594 * t872 - 0.66795041700000000000000000000000000000000000000000e-1 * t879 * t223 + 0.3e1 * t599 * t872 + 0.3e1 * t602 * t872 + 0.60568721700000000000000000000000000000000000000000e-6 * t879 * t228 + 0.3e1 * t607 * t872 + 0.12147009850000000000000000000000000000000000000000e-1 * t875 + (-0.59626395150000000000000000000000000000000000000000e-7 * t897 + 0.25554169350000000000000000000000000000000000000000e-7 * t879) * t228 + 0.24747993725000000000000000000000000000000000000000e-1 * t897 - 0.17025650782500000000000000000000000000000000000000e0 * t879 + t191 * t908 + 0.24767835050000000000000000000000000000000000000000e-2 * t904 + 0.43536371955000000000000000000000000000000000000000e-1 * t906 + (0.10050563057500000000000000000000000000000000000000e-5 * t897 - 0.43073841675000000000000000000000000000000000000000e-6 * t879) * t236 + t232 * t919 + 0.10559560650000000000000000000000000000000000000000e-1 * t916
  t932 = t187 * t878
  t980 = t263 * t872 + t266 * t908 + t269 * t919 + t276 * t872 + (-0.83732421666666666666666666666666666666666666666667e-8 * t875 + 0.34888509027777777777777777777777777777777777777778e-9 * t850) * t228 + t279 * t908 + (-0.50694855333333333333333333333333333333333333333333e-3 * t875 + 0.21122856388888888888888888888888888888888888888889e-4 * t850) * t236 + t282 * t919 + (0.26502008000000000000000000000000000000000000000000e-2 * t875 - 0.11042503333333333333333333333333333333333333333333e-3 * t850) * t242 + (0.37819770500000000000000000000000000000000000000000e-2 * t875 - 0.15758237708333333333333333333333333333333333333333e-3 * t850) * t223 + t288 * t872
  t986 = f.my_piecewise3(t165, 0, -0.3e1 / 0.8e1 * t5 * t172 * (t922 + (-0.87631135900000000000000000000000000000000000000000e-5 * t897 + 0.37556201100000000000000000000000000000000000000000e-5 * t879) * t242 + (0.16088048095000000000000000000000000000000000000000e-4 * t897 - 0.68948777550000000000000000000000000000000000000000e-5 * t879) * t223 + t246 * t872 + (0.29799357600000000000000000000000000000000000000000e-7 * t932 - 0.49665596000000000000000000000000000000000000000000e-9 * t875 + 0.20693998333333333333333333333333333333333333333333e-10 * t850) * t228 - 0.15084873600000000000000000000000000000000000000000e0 * t932 + t251 * t908 + (-0.41243205975000000000000000000000000000000000000000e-6 * t932 + 0.68738676625000000000000000000000000000000000000000e-8 * t875 - 0.28641115260416666666666666666666666666666666666667e-9 * t850) * t236 + t255 * t919 + (0.10028055225000000000000000000000000000000000000000e-5 * t932 - 0.16713425375000000000000000000000000000000000000000e-7 * t875 + 0.69639272395833333333333333333333333333333333333333e-9 * t850) * t242 + (0.14428091550000000000000000000000000000000000000000e0 * t932 - 0.24046819250000000000000000000000000000000000000000e-2 * t875 + 0.10019508020833333333333333333333333333333333333333e-3 * t850) * t223 + t980))
  vsigma_2_ = t6 * t986
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t989 = 0.5e1 / 0.9e1 * t31 * t39 * t44
  t990 = f.my_piecewise3(t48, t989, 0)
  t998 = f.my_piecewise3(t48, 0, t989)
  t1008 = f.my_piecewise3(t47, -0.12e2 * t339 * t990 + 0.6e1 * t54 * t990 + 0.3e1 * t56 * t990, 0.6e1 * t343 * t59 * t998 + t350 * (0.3e1 * t351 * t998 + 0.3e1 * t354 * t998))
  t1009 = t72 * t1008
  t1011 = t70 * t1008
  t1013 = 0.35e2 / 0.2e1 * t1009 - 0.15e2 / 0.2e1 * t1011
  t1015 = t71 * t1008
  t1018 = 0.15e2 / 0.2e1 * t1015 - 0.3e1 / 0.2e1 * t1008
  t1042 = t95 * t1013 + t102 * t1018 + 0.3e1 * t394 * t1008 + t115 * t1008 + t120 * t1013 + t124 * t1018 + 0.3e1 * t397 * t1008 + t132 * t1008 + t135 * t1013 + t138 * t1018 + 0.3e1 * t388 * t1008 + 0.24767835050000000000000000000000000000000000000000e-2 * t1009 + t144 * t1008 + 0.3e1 * t391 * t1008 + t150 * t1018 + t153 * t1013 - 0.69727705930000000000000000000000000000000000000000e-1 * t1008 + 0.43536371955000000000000000000000000000000000000000e-1 * t1011 + t156 * t1008 + 0.10559560650000000000000000000000000000000000000000e-1 * t1015
  t1046 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1042)
  vtau_0_ = t6 * t1046
  t1049 = 0.5e1 / 0.9e1 * t193 * t39 * t44
  t1050 = f.my_piecewise3(t201, t1049, 0)
  t1058 = f.my_piecewise3(t201, 0, t1049)
  t1068 = f.my_piecewise3(t200, 0.6e1 * t207 * t1050 + 0.3e1 * t209 * t1050 - 0.12e2 * t552 * t1050, 0.6e1 * t556 * t212 * t1058 + t563 * (0.3e1 * t564 * t1058 + 0.3e1 * t567 * t1058))
  t1069 = t233 * t1068
  t1071 = t223 * t1068
  t1073 = 0.35e2 / 0.2e1 * t1069 - 0.15e2 / 0.2e1 * t1071
  t1075 = t224 * t1068
  t1078 = 0.15e2 / 0.2e1 * t1075 - 0.3e1 / 0.2e1 * t1068
  t1102 = t191 * t1073 + t232 * t1078 + 0.3e1 * t607 * t1068 + t246 * t1068 + t251 * t1073 + t255 * t1078 + 0.3e1 * t602 * t1068 + t263 * t1068 + t266 * t1073 + 0.24767835050000000000000000000000000000000000000000e-2 * t1069 + t269 * t1078 + 0.3e1 * t594 * t1068 + t276 * t1068 + t279 * t1073 + t282 * t1078 + 0.3e1 * t599 * t1068 + t288 * t1068 + 0.10559560650000000000000000000000000000000000000000e-1 * t1075 + 0.43536371955000000000000000000000000000000000000000e-1 * t1071 - 0.69727705930000000000000000000000000000000000000000e-1 * t1068
  t1106 = f.my_piecewise3(t165, 0, -0.3e1 / 0.8e1 * t5 * t172 * t1102)
  vtau_1_ = t6 * t1106
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_n = 5

  mbeef_coefs = [None, np.array([np.nan, 1.17114923, 0.115594371, -0.0532167416, -0.0201131648, 0.00141417107], dtype=np.float64), np.array([np.nan, -0.0676157938, 0.0453837246, -0.0222650139, 0.0192374554, 9.19317034e-07], dtype=np.float64), np.array([np.nan, 0.0148659502, 0.0318024096, -0.00521818079, 1.33707403e-07, -5.00749348e-07], dtype=np.float64), np.array([np.nan, 0.00140794142, -0.00608338264, -6.57949254e-07, -5.49909413e-08, 5.74317889e-08], dtype=np.float64), np.array([np.nan, 0.000141530486, -1.00478906e-07, 2.01895739e-07, 3.97324768e-09, -3.40722258e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeefvdw_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeefvdw_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 2 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = tau0 * t21
  t23 = t18 ** 2
  t25 = 0.1e1 / t23 / r0
  t27 = s0 * t21
  t28 = r0 ** 2
  t30 = 0.1e1 / t23 / t28
  t31 = t27 * t30
  t34 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t41 = 0.5e1 / 0.9e1 * (t22 * t25 - t31 / 0.8e1) * t34 * t39
  t42 = 0.1e5 <= t41
  t43 = 0.1e5 < t41
  t44 = f.my_piecewise3(t43, t41, 0.1e5)
  t45 = t44 ** 2
  t49 = 0.1e1 / t45 / t44
  t50 = t45 ** 2
  t51 = 0.1e1 / t50
  t54 = f.my_piecewise3(t43, 0.1e5, t41)
  t55 = t54 ** 2
  t56 = 0.1e1 - t55
  t57 = t56 ** 2
  t58 = t57 * t56
  t59 = t55 * t54
  t60 = 0.1e1 + t59
  t62 = t59 * t60 + 0.1e1
  t63 = 0.1e1 / t62
  t65 = f.my_piecewise3(t42, 0.1e1 - 0.3e1 / t45 - t49 + 0.3e1 * t51, -t58 * t63)
  t67 = t65 ** 2
  t68 = t67 ** 2
  t71 = t67 * t65
  t73 = t34 * t39
  t74 = t73 * s0
  t75 = t21 * t30
  t78 = 0.65124e1 + t73 * t31 / 0.24e2
  t79 = 0.1e1 / t78
  t80 = t75 * t79
  t81 = t74 * t80
  t83 = t81 / 0.12e2 - 0.1e1
  t84 = t83 ** 2
  t86 = t84 * t83
  t89 = 0.26090903950000000000000000000000000000000000000000e-2 - 0.78272711850000000000000000000000000000000000000000e-2 * t84
  t91 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t67
  t94 = 0.11132506950000000000000000000000000000000000000000e-1 - 0.33397520850000000000000000000000000000000000000000e-1 * t84
  t97 = -0.83732421666666666666666666666666666666666666666667e-8 * t81 + 0.100478906e-6
  t100 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t68 - 0.15e2 / 0.4e1 * t67
  t103 = -0.50694855333333333333333333333333333333333333333333e-3 * t81 + 0.608338264e-2
  t106 = 0.5e1 / 0.2e1 * t71 - 0.3e1 / 0.2e1 * t65
  t109 = 0.26502008000000000000000000000000000000000000000000e-2 * t81 - 0.318024096e-1
  t112 = 0.37819770500000000000000000000000000000000000000000e-2 * t81 - 0.453837246e-1
  t114 = -0.69727705930000000000000000000000000000000000000000e-1 * t65 + 0.61919587625000000000000000000000000000000000000000e-3 * t68 + 0.21768185977500000000000000000000000000000000000000e-1 * t67 + 0.35198535500000000000000000000000000000000000000000e-2 * t71 - 0.85128253912500000000000000000000000000000000000000e-1 * t84 - 0.50282912000000000000000000000000000000000000000000e-1 * t86 + t89 * t91 + t94 * t65 + t97 * t100 + t103 * t106 + t109 * t91 + t112 * t65
  t115 = t84 ** 2
  t118 = -0.12777084675000000000000000000000000000000000000000e-8 - 0.14906598787500000000000000000000000000000000000000e-7 * t115 + 0.12777084675000000000000000000000000000000000000000e-7 * t84
  t122 = 0.21536920837500000000000000000000000000000000000000e-7 + 0.25126407643750000000000000000000000000000000000000e-6 * t115 - 0.21536920837500000000000000000000000000000000000000e-6 * t84
  t126 = -0.18778100550000000000000000000000000000000000000000e-6 - 0.21907783975000000000000000000000000000000000000000e-5 * t115 + 0.18778100550000000000000000000000000000000000000000e-5 * t84
  t130 = 0.34474388775000000000000000000000000000000000000000e-6 + 0.40220120237500000000000000000000000000000000000000e-5 * t115 - 0.34474388775000000000000000000000000000000000000000e-5 * t84
  t134 = 0.99331192000000000000000000000000000000000000000000e-8 * t86 - 0.49665596000000000000000000000000000000000000000000e-9 * t81 + 0.59598715200000000000000000000000000000000000000000e-8
  t138 = -0.13747735325000000000000000000000000000000000000000e-6 * t86 + 0.68738676625000000000000000000000000000000000000000e-8 * t81 - 0.82486411950000000000000000000000000000000000000000e-7
  t142 = 0.33426850750000000000000000000000000000000000000000e-6 * t86 - 0.16713425375000000000000000000000000000000000000000e-7 * t81 + 0.20056110450000000000000000000000000000000000000000e-6
  t146 = 0.48093638500000000000000000000000000000000000000000e-1 * t86 - 0.24046819250000000000000000000000000000000000000000e-2 * t81 + 0.28856183100000000000000000000000000000000000000000e-1
  t149 = -0.10094786950000000000000000000000000000000000000000e-6 + 0.30284360850000000000000000000000000000000000000000e-6 * t84
  t152 = 0.32897462700000000000000000000000000000000000000000e-6 - 0.98692388100000000000000000000000000000000000000000e-6 * t84
  t156 = 0.10451438955835000000000000000000000000000000000000e1 + t118 * t100 + t122 * t106 + t126 * t91 + t130 * t65 + t134 * t100 + t138 * t106 + t142 * t91 + t146 * t65 + t149 * t100 + t152 * t106 + 0.61869984312500000000000000000000000000000000000000e-2 * t115 + 0.12147009850000000000000000000000000000000000000000e-1 * t81
  t157 = t114 + t156
  t161 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t157)
  t169 = 0.1e1 / t23 / t28 / r0
  t172 = t74 * t21 * t169 * t79
  t174 = t34 ** 2
  t177 = t174 / t37 / t36
  t178 = s0 ** 2
  t180 = t28 ** 2
  t185 = t78 ** 2
  t186 = 0.1e1 / t185
  t188 = t177 * t178 * t20 / t18 / t180 / t28 * t186
  t197 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t22 * t30 + t27 * t169 / 0.3e1) * t34 * t39
  t198 = f.my_piecewise3(t43, t197, 0)
  t204 = 0.1e1 / t50 / t44
  t208 = t57 * t63
  t209 = f.my_piecewise3(t43, 0, t197)
  t213 = t62 ** 2
  t215 = t58 / t213
  t216 = t55 * t60
  t218 = t55 ** 2
  t219 = t218 * t54
  t225 = f.my_piecewise3(t42, -0.12e2 * t204 * t198 + 0.6e1 * t49 * t198 + 0.3e1 * t51 * t198, 0.6e1 * t208 * t54 * t209 + t215 * (0.3e1 * t216 * t209 + 0.3e1 * t219 * t209))
  t241 = t71 * t225
  t243 = t65 * t225
  t245 = 0.35e2 / 0.2e1 * t241 - 0.15e2 / 0.2e1 * t243
  t253 = -0.2e1 / 0.9e1 * t172 + t188 / 0.54e2
  t254 = t84 * t253
  t260 = t67 * t225
  t263 = 0.15e2 / 0.2e1 * t260 - 0.3e1 / 0.2e1 * t225
  t266 = t86 * t253
  t268 = t83 * t253
  t287 = -0.32392026266666666666666666666666666666666666666667e-1 * t172 + 0.26993355222222222222222222222222222222222222222222e-2 * t188 - 0.69727705930000000000000000000000000000000000000000e-1 * t225 + (-0.70672021333333333333333333333333333333333333333333e-2 * t172 + 0.58893351111111111111111111111111111111111111111111e-3 * t188) * t91 + (-0.10085272133333333333333333333333333333333333333333e-1 * t172 + 0.84043934444444444444444444444444444444444444444444e-3 * t188) * t65 + t112 * t225 + t94 * t225 + (0.22328645777777777777777777777777777777777777777778e-7 * t172 - 0.18607204814814814814814814814814814814814814814815e-8 * t188) * t100 + t97 * t245 + (0.13518628088888888888888888888888888888888888888889e-2 * t172 - 0.11265523407407407407407407407407407407407407407407e-3 * t188) * t106 + (-0.41243205975000000000000000000000000000000000000000e-6 * t254 - 0.18330313766666666666666666666666666666666666666667e-7 * t172 + 0.15275261472222222222222222222222222222222222222222e-8 * t188) * t106 + t138 * t263 + t122 * t263 + (-0.87631135900000000000000000000000000000000000000000e-5 * t266 + 0.37556201100000000000000000000000000000000000000000e-5 * t268) * t91 + (0.16088048095000000000000000000000000000000000000000e-4 * t266 - 0.68948777550000000000000000000000000000000000000000e-5 * t268) * t65 + t130 * t225 + (-0.59626395150000000000000000000000000000000000000000e-7 * t266 + 0.25554169350000000000000000000000000000000000000000e-7 * t268) * t100 + t118 * t245 + (0.10050563057500000000000000000000000000000000000000e-5 * t266 - 0.43073841675000000000000000000000000000000000000000e-6 * t268) * t106 - 0.15084873600000000000000000000000000000000000000000e0 * t254
  t314 = t142 * t65
  t323 = t89 * t65
  t328 = t126 * t65
  t331 = t109 * t65
  t334 = t149 * t245 + (0.29799357600000000000000000000000000000000000000000e-7 * t254 + 0.13244158933333333333333333333333333333333333333333e-8 * t172 - 0.11036799111111111111111111111111111111111111111111e-9 * t188) * t100 + t134 * t245 + 0.3e1 * t314 * t225 + 0.60568721700000000000000000000000000000000000000000e-6 * t268 * t100 - 0.19738477620000000000000000000000000000000000000000e-5 * t268 * t106 - 0.15654542370000000000000000000000000000000000000000e-1 * t268 * t91 + 0.3e1 * t323 * t225 - 0.66795041700000000000000000000000000000000000000000e-1 * t268 * t65 + 0.3e1 * t328 * t225 + 0.3e1 * t331 * t225
  t341 = f.my_piecewise3(t2, 0, -t6 * t17 / t23 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t287 + 0.24747993725000000000000000000000000000000000000000e-1 * t266 - 0.17025650782500000000000000000000000000000000000000e0 * t268 + 0.10559560650000000000000000000000000000000000000000e-1 * t260 + t103 * t263 + t152 * t263 + (0.10028055225000000000000000000000000000000000000000e-5 * t254 + 0.44569134333333333333333333333333333333333333333333e-7 * t172 - 0.37140945277777777777777777777777777777777777777778e-8 * t188) * t91 + (0.14428091550000000000000000000000000000000000000000e0 * t254 + 0.64124851333333333333333333333333333333333333333333e-2 * t172 - 0.53437376111111111111111111111111111111111111111111e-3 * t188) * t65 + t146 * t225 + 0.24767835050000000000000000000000000000000000000000e-2 * t241 + 0.43536371955000000000000000000000000000000000000000e-1 * t243 + t334))
  vrho_0_ = 0.2e1 * r0 * t341 + 0.2e1 * t161
  t350 = t177 * s0 * t20 / t18 / t180 / r0 * t186
  t353 = 0.5e1 / 0.72e2 * t73 * t75
  t354 = f.my_piecewise3(t43, -t353, 0)
  t362 = f.my_piecewise3(t43, 0, -t353)
  t372 = f.my_piecewise3(t42, -0.12e2 * t204 * t354 + 0.6e1 * t49 * t354 + 0.3e1 * t51 * t354, 0.6e1 * t208 * t54 * t362 + t215 * (0.3e1 * t216 * t362 + 0.3e1 * t219 * t362))
  t374 = t73 * t80
  t377 = t374 / 0.12e2 - t350 / 0.144e3
  t378 = t84 * t377
  t385 = t71 * t372
  t387 = t65 * t372
  t389 = 0.35e2 / 0.2e1 * t385 - 0.15e2 / 0.2e1 * t387
  t396 = t67 * t372
  t399 = 0.15e2 / 0.2e1 * t396 - 0.3e1 / 0.2e1 * t372
  t406 = t86 * t377
  t408 = t83 * t377
  t439 = -0.10122508208333333333333333333333333333333333333333e-2 * t350 + t94 * t372 + (0.14428091550000000000000000000000000000000000000000e0 * t378 - 0.24046819250000000000000000000000000000000000000000e-2 * t374 + 0.20039016041666666666666666666666666666666666666667e-3 * t350) * t65 + t146 * t372 + t149 * t389 + (-0.41243205975000000000000000000000000000000000000000e-6 * t378 + 0.68738676625000000000000000000000000000000000000000e-8 * t374 - 0.57282230520833333333333333333333333333333333333333e-9 * t350) * t106 + t138 * t399 + (0.10028055225000000000000000000000000000000000000000e-5 * t378 - 0.16713425375000000000000000000000000000000000000000e-7 * t374 + 0.13927854479166666666666666666666666666666666666667e-8 * t350) * t91 + (-0.87631135900000000000000000000000000000000000000000e-5 * t406 + 0.37556201100000000000000000000000000000000000000000e-5 * t408) * t91 + (0.16088048095000000000000000000000000000000000000000e-4 * t406 - 0.68948777550000000000000000000000000000000000000000e-5 * t408) * t65 + t130 * t372 + (0.29799357600000000000000000000000000000000000000000e-7 * t378 - 0.49665596000000000000000000000000000000000000000000e-9 * t374 + 0.41387996666666666666666666666666666666666666666667e-10 * t350) * t100 + (0.10050563057500000000000000000000000000000000000000e-5 * t406 - 0.43073841675000000000000000000000000000000000000000e-6 * t408) * t106 + t122 * t399 + 0.10559560650000000000000000000000000000000000000000e-1 * t396 - 0.15084873600000000000000000000000000000000000000000e0 * t378 + (0.37819770500000000000000000000000000000000000000000e-2 * t374 - 0.31516475416666666666666666666666666666666666666667e-3 * t350) * t65 + t112 * t372 + (-0.83732421666666666666666666666666666666666666666667e-8 * t374 + 0.69777018055555555555555555555555555555555555555556e-9 * t350) * t100 + t97 * t389
  t479 = t118 * t389 + 0.12147009850000000000000000000000000000000000000000e-1 * t374 + 0.60568721700000000000000000000000000000000000000000e-6 * t408 * t100 - 0.19738477620000000000000000000000000000000000000000e-5 * t408 * t106 - 0.15654542370000000000000000000000000000000000000000e-1 * t408 * t91 + 0.3e1 * t323 * t372 - 0.66795041700000000000000000000000000000000000000000e-1 * t408 * t65 + 0.3e1 * t331 * t372 + 0.3e1 * t328 * t372 + 0.3e1 * t314 * t372 - 0.69727705930000000000000000000000000000000000000000e-1 * t372
  t485 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t439 + (-0.50694855333333333333333333333333333333333333333333e-3 * t374 + 0.42245712777777777777777777777777777777777777777777e-4 * t350) * t106 + t103 * t399 + (0.26502008000000000000000000000000000000000000000000e-2 * t374 - 0.22085006666666666666666666666666666666666666666667e-3 * t350) * t91 + t152 * t399 + t134 * t389 + 0.24767835050000000000000000000000000000000000000000e-2 * t385 + 0.43536371955000000000000000000000000000000000000000e-1 * t387 + (-0.59626395150000000000000000000000000000000000000000e-7 * t406 + 0.25554169350000000000000000000000000000000000000000e-7 * t408) * t100 + 0.24747993725000000000000000000000000000000000000000e-1 * t406 - 0.17025650782500000000000000000000000000000000000000e0 * t408 + t479))
  vsigma_0_ = 0.2e1 * r0 * t485
  vlapl_0_ = 0.0e0
  t489 = 0.5e1 / 0.9e1 * t21 * t25 * t73
  t490 = f.my_piecewise3(t43, t489, 0)
  t498 = f.my_piecewise3(t43, 0, t489)
  t508 = f.my_piecewise3(t42, -0.12e2 * t204 * t490 + 0.6e1 * t49 * t490 + 0.3e1 * t51 * t490, 0.6e1 * t208 * t54 * t498 + t215 * (0.3e1 * t216 * t498 + 0.3e1 * t219 * t498))
  t509 = t71 * t508
  t511 = t65 * t508
  t513 = 0.35e2 / 0.2e1 * t509 - 0.15e2 / 0.2e1 * t511
  t515 = t67 * t508
  t518 = 0.15e2 / 0.2e1 * t515 - 0.3e1 / 0.2e1 * t508
  t542 = t118 * t513 + t122 * t518 + 0.3e1 * t328 * t508 + t130 * t508 + t134 * t513 + t138 * t518 + 0.3e1 * t314 * t508 + t146 * t508 + t149 * t513 + t152 * t518 + 0.3e1 * t323 * t508 + t94 * t508 + t97 * t513 + t103 * t518 + 0.3e1 * t331 * t508 + t112 * t508 + 0.24767835050000000000000000000000000000000000000000e-2 * t509 + 0.10559560650000000000000000000000000000000000000000e-1 * t515 + 0.43536371955000000000000000000000000000000000000000e-1 * t511 - 0.69727705930000000000000000000000000000000000000000e-1 * t508
  t546 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t542)
  vtau_0_ = 0.2e1 * r0 * t546
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = tau0 * t23
  t26 = 0.1e1 / t19 / r0
  t28 = s0 * t23
  t29 = r0 ** 2
  t31 = 0.1e1 / t19 / t29
  t32 = t28 * t31
  t35 = 6 ** (0.1e1 / 0.3e1)
  t37 = jnp.pi ** 2
  t38 = t37 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t40 = 0.1e1 / t39
  t42 = 0.5e1 / 0.9e1 * (t24 * t26 - t32 / 0.8e1) * t35 * t40
  t43 = 0.1e5 <= t42
  t44 = 0.1e5 < t42
  t45 = f.my_piecewise3(t44, t42, 0.1e5)
  t46 = t45 ** 2
  t50 = 0.1e1 / t46 / t45
  t51 = t46 ** 2
  t52 = 0.1e1 / t51
  t55 = f.my_piecewise3(t44, 0.1e5, t42)
  t56 = t55 ** 2
  t57 = 0.1e1 - t56
  t58 = t57 ** 2
  t59 = t58 * t57
  t60 = t56 * t55
  t61 = 0.1e1 + t60
  t63 = t60 * t61 + 0.1e1
  t64 = 0.1e1 / t63
  t66 = f.my_piecewise3(t43, 0.1e1 - 0.3e1 / t46 - t50 + 0.3e1 * t52, -t59 * t64)
  t67 = t66 ** 2
  t69 = t35 * t40
  t70 = t69 * s0
  t74 = 0.65124e1 + t69 * t32 / 0.24e2
  t75 = 0.1e1 / t74
  t77 = t70 * t23 * t31 * t75
  t79 = t77 / 0.12e2 - 0.1e1
  t80 = t79 ** 2
  t81 = t80 * t79
  t84 = t80 ** 2
  t89 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t84 - 0.15e2 / 0.4e1 * t80
  t90 = t67 ** 2
  t93 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t90 - 0.15e2 / 0.4e1 * t67
  t96 = t79 * t66
  t99 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t67
  t102 = t67 * t66
  t105 = 0.5e1 / 0.2e1 * t102 - 0.3e1 / 0.2e1 * t66
  t111 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t80
  t112 = t111 * t66
  t116 = 0.21768185977500000000000000000000000000000000000000e-1 * t67 - 0.50282912000000000000000000000000000000000000000000e-1 * t81 - 0.69727705930000000000000000000000000000000000000000e-1 * t66 + 0.61869984312500000000000000000000000000000000000000e-2 * t84 + 0.12147009850000000000000000000000000000000000000000e-1 * t77 - 0.340722258e-8 * t89 * t93 + 0.453837246e-1 * t96 + 0.318024096e-1 * t79 * t99 - 0.608338264e-2 * t79 * t105 - 0.100478906e-6 * t79 * t93 - 0.222650139e-1 * t112 - 0.521818079e-2 * t111 * t99
  t123 = 0.5e1 / 0.2e1 * t81 - t77 / 0.8e1 + 0.3e1 / 0.2e1
  t124 = t123 * t66
  t132 = t89 * t66
  t141 = 0.10451438955835000000000000000000000000000000000000e1 - 0.657949254e-6 * t111 * t105 + 0.201895739e-6 * t111 * t93 + 0.192374554e-1 * t124 + 0.133707403e-6 * t123 * t99 - 0.549909413e-7 * t123 * t105 + 0.397324768e-8 * t123 * t93 + 0.919317034e-6 * t132 - 0.500749348e-6 * t89 * t99 + 0.574317889e-7 * t89 * t105 + 0.35198535500000000000000000000000000000000000000000e-2 * t102 - 0.85128253912500000000000000000000000000000000000000e-1 * t80 + 0.61919587625000000000000000000000000000000000000000e-3 * t90
  t142 = t116 + t141
  t146 = t17 * t18
  t147 = t29 * r0
  t149 = 0.1e1 / t19 / t147
  t152 = t70 * t23 * t149 * t75
  t154 = t35 ** 2
  t158 = s0 ** 2
  t159 = t154 / t38 / t37 * t158
  t160 = t29 ** 2
  t165 = t74 ** 2
  t166 = 0.1e1 / t165
  t168 = t159 * t22 / t18 / t160 / t29 * t166
  t170 = -0.2e1 / 0.9e1 * t152 + t168 / 0.54e2
  t171 = t79 * t170
  t187 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t24 * t31 + t28 * t149 / 0.3e1) * t35 * t40
  t188 = f.my_piecewise3(t44, t187, 0)
  t194 = 0.1e1 / t51 / t45
  t198 = t58 * t64
  t199 = f.my_piecewise3(t44, 0, t187)
  t200 = t55 * t199
  t203 = t63 ** 2
  t204 = 0.1e1 / t203
  t205 = t59 * t204
  t206 = t56 * t61
  t208 = t56 ** 2
  t209 = t208 * t55
  t212 = 0.3e1 * t206 * t199 + 0.3e1 * t209 * t199
  t215 = f.my_piecewise3(t43, -0.12e2 * t194 * t188 + 0.6e1 * t50 * t188 + 0.3e1 * t52 * t188, 0.6e1 * t198 * t200 + t205 * t212)
  t228 = t102 * t215
  t230 = t66 * t215
  t232 = 0.35e2 / 0.2e1 * t228 - 0.15e2 / 0.2e1 * t230
  t235 = t81 * t170
  t238 = 0.35e2 / 0.2e1 * t235 - 0.15e2 / 0.2e1 * t171
  t243 = t67 * t215
  t246 = 0.15e2 / 0.2e1 * t243 - 0.3e1 / 0.2e1 * t215
  t251 = t80 * t170
  t255 = 0.15e2 / 0.2e1 * t251 + t152 / 0.3e1 - t168 / 0.36e2
  t264 = -0.1973847762e-5 * t171 * t105 - 0.667950417e-1 * t171 * t66 + 0.605687217e-6 * t171 * t93 - 0.1565454237e-1 * t171 * t99 - 0.1565454237e-1 * t112 * t215 + 0.954072288e-1 * t96 * t215 - 0.1502248044e-5 * t132 * t215 + 0.401122209e-6 * t124 * t215 - 0.32392026266666666666666666666666666666666666666667e-1 * t152 + 0.26993355222222222222222222222222222222222222222222e-2 * t168 + 0.453837246e-1 * t79 * t215 + 0.397324768e-8 * t123 * t232 - 0.340722258e-8 * t238 * t93 + 0.574317889e-7 * t238 * t105 - 0.657949254e-6 * t111 * t246 + 0.919317034e-6 * t89 * t215 + 0.133707403e-6 * t255 * t99 + 0.201895739e-6 * t111 * t232 + 0.574317889e-7 * t89 * t246 + 0.318024096e-1 * t170 * t99
  t267 = t255 * t66
  t280 = t238 * t66
  t282 = t170 * t66
  t301 = 0.24767835050000000000000000000000000000000000000000e-2 * t228 + 0.43536371955000000000000000000000000000000000000000e-1 * t230 - 0.100478906e-6 * t79 * t232 - 0.340722258e-8 * t89 * t232 + 0.397324768e-8 * t255 * t93 - 0.17025650782500000000000000000000000000000000000000e0 * t171 + 0.24747993725000000000000000000000000000000000000000e-1 * t235 - 0.500749348e-6 * t238 * t99 - 0.15084873600000000000000000000000000000000000000000e0 * t251 - 0.549909413e-7 * t255 * t105 - 0.69727705930000000000000000000000000000000000000000e-1 * t215
  t303 = t264 - 0.222650139e-1 * t111 * t215 + 0.192374554e-1 * t267 + 0.10559560650000000000000000000000000000000000000000e-1 * t243 - 0.608338264e-2 * t79 * t246 - 0.549909413e-7 * t123 * t246 - 0.100478906e-6 * t170 * t93 - 0.608338264e-2 * t170 * t105 + 0.192374554e-1 * t123 * t215 + 0.919317034e-6 * t280 + 0.453837246e-1 * t282 + t301
  t308 = f.my_piecewise3(t2, 0, -t6 * t21 * t142 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t146 * t303)
  t322 = t159 * t22 / t18 / t160 / t147 * t166
  t325 = 0.1e1 / t19 / t160
  t328 = t70 * t23 * t325 * t75
  t330 = t170 ** 2
  t331 = t80 * t330
  t335 = t37 ** 2
  t339 = t160 ** 2
  t345 = 0.1e1 / t335 * t158 * s0 / t339 / t29 / t165 / t74
  t347 = 0.22e2 / 0.27e2 * t328 - t322 / 0.6e1 + 0.4e1 / 0.81e2 * t345
  t348 = t81 * t347
  t351 = t79 * t347
  t353 = 0.105e3 / 0.2e1 * t331 + 0.35e2 / 0.2e1 * t348 - 0.15e2 / 0.2e1 * t330 - 0.15e2 / 0.2e1 * t351
  t356 = t215 ** 2
  t357 = t67 * t356
  t359 = t188 ** 2
  t369 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * t24 * t149 - 0.11e2 / 0.9e1 * t28 * t325) * t35 * t40
  t370 = f.my_piecewise3(t44, t369, 0)
  t385 = t199 ** 2
  t395 = f.my_piecewise3(t44, 0, t369)
  t402 = t212 ** 2
  t417 = f.my_piecewise3(t43, -0.18e2 * t52 * t359 + 0.6e1 * t50 * t370 - 0.12e2 * t194 * t359 + 0.3e1 * t52 * t370 + 0.60e2 / t51 / t46 * t359 - 0.12e2 * t194 * t370, -0.24e2 * t57 * t64 * t56 * t385 - 0.12e2 * t58 * t204 * t200 * t212 + 0.6e1 * t198 * t385 + 0.6e1 * t198 * t55 * t395 - 0.2e1 * t59 / t203 / t63 * t402 + t205 * (0.6e1 * t55 * t61 * t385 + 0.3e1 * t206 * t395 + 0.24e2 * t208 * t385 + 0.3e1 * t209 * t395))
  t418 = t102 * t417
  t421 = t66 * t417
  t423 = 0.105e3 / 0.2e1 * t357 + 0.35e2 / 0.2e1 * t418 - 0.15e2 / 0.2e1 * t356 - 0.15e2 / 0.2e1 * t421
  t442 = t66 * t356
  t444 = t67 * t417
  t447 = 0.15e2 * t442 + 0.15e2 / 0.2e1 * t444 - 0.3e1 / 0.2e1 * t417
  t460 = -0.24294019700000000000000000000000000000000000000000e-1 * t322 + 0.11877076297777777777777777777777777777777777777778e0 * t328 + 0.919317034e-6 * t353 * t66 + 0.397324768e-8 * t123 * t423 + 0.574317889e-7 * t353 * t105 - 0.340722258e-8 * t353 * t93 - 0.1565454237e-1 * t330 * t99 - 0.1565454237e-1 * t111 * t356 + 0.954072288e-1 * t79 * t356 + 0.453837246e-1 * t79 * t417 + 0.907674492e-1 * t170 * t215 - 0.1216676528e-1 * t170 * t246 - 0.608338264e-2 * t79 * t447 + 0.453837246e-1 * t347 * t66 - 0.549909413e-7 * t123 * t447 + 0.919317034e-6 * t89 * t417 + 0.1838634068e-5 * t238 * t215 + 0.192374554e-1 * t123 * t417
  t473 = t79 * t330
  t475 = t80 * t347
  t480 = 0.15e2 * t473 + 0.15e2 / 0.2e1 * t475 - 0.11e2 / 0.9e1 * t328 + t322 / 0.4e1 - 0.2e1 / 0.27e2 * t345
  t504 = -0.608338264e-2 * t347 * t105 + 0.1148635778e-6 * t238 * t246 + 0.401122209e-6 * t123 * t356 - 0.1502248044e-5 * t89 * t356 + 0.605687217e-6 * t330 * t93 - 0.1973847762e-5 * t330 * t105 + 0.133707403e-6 * t480 * t99 - 0.200957812e-6 * t170 * t232 - 0.667950417e-1 * t330 * t66 + 0.71982280592592592592592592592592592592592592592592e-2 * t345 - 0.9392725422e-1 * t171 * t230 + 0.401122209e-6 * t124 * t417 - 0.1973847762e-5 * t351 * t105 + 0.605687217e-6 * t351 * t93 - 0.1565454237e-1 * t351 * t99 - 0.667950417e-1 * t351 * t66 - 0.3947695524e-5 * t171 * t246 + 0.954072288e-1 * t96 * t417
  t539 = -0.1502248044e-5 * t132 * t417 - 0.1565454237e-1 * t112 * t417 + 0.1211374434e-5 * t171 * t232 + 0.802244418e-6 * t267 * t215 - 0.3004496088e-5 * t280 * t215 + 0.1908144576e0 * t282 * t215 - 0.1335900834e0 * t171 * t215 + 0.192374554e-1 * t480 * t66 + 0.384749108e-1 * t255 * t215 + 0.397324768e-8 * t480 * t93 + 0.794649536e-8 * t255 * t232 + 0.574317889e-7 * t89 * t447 + 0.201895739e-6 * t111 * t423 - 0.681444516e-8 * t238 * t232 - 0.1099818826e-6 * t255 * t246 + 0.74243981175000000000000000000000000000000000000000e-1 * t331 + 0.24747993725000000000000000000000000000000000000000e-1 * t348 - 0.17025650782500000000000000000000000000000000000000e0 * t351
  t566 = -0.500749348e-6 * t353 * t99 - 0.549909413e-7 * t480 * t105 + 0.318024096e-1 * t347 * t99 - 0.222650139e-1 * t111 * t417 + 0.24767835050000000000000000000000000000000000000000e-2 * t418 + 0.43536371955000000000000000000000000000000000000000e-1 * t421 - 0.100478906e-6 * t79 * t423 - 0.100478906e-6 * t347 * t93 + 0.21119121300000000000000000000000000000000000000000e-1 * t442 + 0.10559560650000000000000000000000000000000000000000e-1 * t444 - 0.657949254e-6 * t111 * t447 - 0.30169747200000000000000000000000000000000000000000e0 * t473 - 0.15084873600000000000000000000000000000000000000000e0 * t475 - 0.340722258e-8 * t89 * t423 + 0.74303505150000000000000000000000000000000000000000e-2 * t357 + 0.43536371955000000000000000000000000000000000000000e-1 * t356 - 0.69727705930000000000000000000000000000000000000000e-1 * t417 - 0.17025650782500000000000000000000000000000000000000e0 * t330
  t573 = f.my_piecewise3(t2, 0, t6 * t17 * t26 * t142 / 0.12e2 - t6 * t21 * t303 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t146 * (t460 + t504 + t539 + t566))
  v2rho2_0_ = 0.2e1 * r0 * t573 + 0.4e1 * t308
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = t28 * s0
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t36 = s0 * t31
  t37 = t36 * t34
  t40 = 0.65124e1 + t28 * t37 / 0.24e2
  t41 = 0.1e1 / t40
  t43 = t29 * t31 * t34 * t41
  t45 = t43 / 0.12e2 - 0.1e1
  t46 = t45 ** 2
  t48 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t46
  t49 = tau0 * t31
  t55 = 0.5e1 / 0.9e1 * (t49 * t21 - t37 / 0.8e1) * t23 * t27
  t56 = 0.1e5 <= t55
  t57 = 0.1e5 < t55
  t58 = f.my_piecewise3(t57, t55, 0.1e5)
  t59 = t58 ** 2
  t62 = t59 * t58
  t63 = 0.1e1 / t62
  t64 = t59 ** 2
  t65 = 0.1e1 / t64
  t68 = f.my_piecewise3(t57, 0.1e5, t55)
  t69 = t68 ** 2
  t70 = 0.1e1 - t69
  t71 = t70 ** 2
  t72 = t71 * t70
  t73 = t69 * t68
  t74 = 0.1e1 + t73
  t76 = t73 * t74 + 0.1e1
  t77 = 0.1e1 / t76
  t79 = f.my_piecewise3(t56, 0.1e1 - 0.3e1 / t59 - t63 + 0.3e1 * t65, -t72 * t77)
  t80 = t79 ** 2
  t82 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t80
  t85 = t80 * t79
  t88 = 0.5e1 / 0.2e1 * t85 - 0.3e1 / 0.2e1 * t79
  t91 = t80 ** 2
  t94 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t91 - 0.15e2 / 0.4e1 * t80
  t99 = t46 ** 2
  t101 = t46 * t45
  t105 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t99 - 0.15e2 / 0.4e1 * t46
  t112 = t105 * t79
  t116 = 0.5e1 / 0.2e1 * t101 - t43 / 0.8e1 + 0.3e1 / 0.2e1
  t119 = -0.521818079e-2 * t48 * t82 - 0.657949254e-6 * t48 * t88 + 0.201895739e-6 * t48 * t94 - 0.69727705930000000000000000000000000000000000000000e-1 * t79 + 0.21768185977500000000000000000000000000000000000000e-1 * t80 + 0.61869984312500000000000000000000000000000000000000e-2 * t99 - 0.50282912000000000000000000000000000000000000000000e-1 * t101 - 0.340722258e-8 * t105 * t94 + 0.574317889e-7 * t105 * t88 - 0.500749348e-6 * t105 * t82 + 0.919317034e-6 * t112 + 0.397324768e-8 * t116 * t94
  t122 = t116 * t79
  t126 = t45 * t79
  t134 = t48 * t79
  t140 = 0.10451438955835000000000000000000000000000000000000e1 - 0.549909413e-7 * t116 * t88 + 0.192374554e-1 * t122 + 0.133707403e-6 * t116 * t82 + 0.453837246e-1 * t126 + 0.318024096e-1 * t45 * t82 - 0.608338264e-2 * t45 * t88 - 0.100478906e-6 * t45 * t94 - 0.222650139e-1 * t134 + 0.35198535500000000000000000000000000000000000000000e-2 * t85 + 0.12147009850000000000000000000000000000000000000000e-1 * t43 + 0.61919587625000000000000000000000000000000000000000e-3 * t91 - 0.85128253912500000000000000000000000000000000000000e-1 * t46
  t141 = t119 + t140
  t146 = t17 / t19
  t149 = t32 * r0
  t151 = 0.1e1 / t19 / t149
  t157 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t49 * t34 + t36 * t151 / 0.3e1) * t23 * t27
  t158 = f.my_piecewise3(t57, t157, 0)
  t161 = t65 * t158
  t164 = 0.1e1 / t64 / t58
  t165 = t164 * t158
  t168 = t71 * t77
  t169 = f.my_piecewise3(t57, 0, t157)
  t170 = t68 * t169
  t173 = t76 ** 2
  t174 = 0.1e1 / t173
  t175 = t72 * t174
  t176 = t69 * t74
  t178 = t69 ** 2
  t179 = t178 * t68
  t182 = 0.3e1 * t176 * t169 + 0.3e1 * t179 * t169
  t185 = f.my_piecewise3(t56, 0.6e1 * t63 * t158 + 0.3e1 * t161 - 0.12e2 * t165, 0.6e1 * t168 * t170 + t175 * t182)
  t186 = t48 * t185
  t190 = t29 * t31 * t151 * t41
  t192 = t23 ** 2
  t196 = s0 ** 2
  t197 = t192 / t25 / t24 * t196
  t198 = t32 ** 2
  t203 = t40 ** 2
  t204 = 0.1e1 / t203
  t206 = t197 * t30 / t18 / t198 / t32 * t204
  t208 = -0.2e1 / 0.9e1 * t190 + t206 / 0.54e2
  t209 = t208 * t94
  t211 = t45 * t185
  t213 = t85 * t185
  t215 = t79 * t185
  t217 = 0.35e2 / 0.2e1 * t213 - 0.15e2 / 0.2e1 * t215
  t220 = t46 * t208
  t224 = 0.15e2 / 0.2e1 * t220 + t190 / 0.3e1 - t206 / 0.36e2
  t227 = t224 * t79
  t231 = t80 * t185
  t234 = 0.15e2 / 0.2e1 * t231 - 0.3e1 / 0.2e1 * t185
  t239 = t101 * t208
  t241 = t45 * t208
  t243 = 0.35e2 / 0.2e1 * t239 - 0.15e2 / 0.2e1 * t241
  t256 = t105 * t185
  t260 = -0.222650139e-1 * t186 - 0.100478906e-6 * t209 + 0.453837246e-1 * t211 + 0.397324768e-8 * t116 * t217 + 0.397324768e-8 * t224 * t94 + 0.192374554e-1 * t227 - 0.100478906e-6 * t45 * t217 - 0.657949254e-6 * t48 * t234 - 0.549909413e-7 * t116 * t234 - 0.340722258e-8 * t243 * t94 - 0.15084873600000000000000000000000000000000000000000e0 * t220 + 0.133707403e-6 * t224 * t82 + 0.24747993725000000000000000000000000000000000000000e-1 * t239 - 0.17025650782500000000000000000000000000000000000000e0 * t241 + 0.574317889e-7 * t243 * t88 + 0.10559560650000000000000000000000000000000000000000e-1 * t231 - 0.608338264e-2 * t45 * t234 + 0.919317034e-6 * t256 + 0.24767835050000000000000000000000000000000000000000e-2 * t213 + 0.43536371955000000000000000000000000000000000000000e-1 * t215
  t283 = t208 * t88
  t285 = t208 * t79
  t287 = t116 * t185
  t293 = t208 * t82
  t299 = t243 * t79
  t301 = -0.1502248044e-5 * t112 * t185 - 0.1565454237e-1 * t241 * t82 - 0.608338264e-2 * t283 + 0.453837246e-1 * t285 + 0.192374554e-1 * t287 - 0.500749348e-6 * t243 * t82 + 0.574317889e-7 * t105 * t234 + 0.318024096e-1 * t293 - 0.340722258e-8 * t105 * t217 - 0.549909413e-7 * t224 * t88 + 0.919317034e-6 * t299
  t303 = t260 + 0.201895739e-6 * t48 * t217 - 0.69727705930000000000000000000000000000000000000000e-1 * t185 - 0.32392026266666666666666666666666666666666666666667e-1 * t190 + 0.26993355222222222222222222222222222222222222222222e-2 * t206 + 0.401122209e-6 * t122 * t185 + 0.954072288e-1 * t126 * t185 - 0.1565454237e-1 * t134 * t185 - 0.667950417e-1 * t241 * t79 + 0.605687217e-6 * t241 * t94 - 0.1973847762e-5 * t241 * t88 + t301
  t307 = t17 * t18
  t311 = 0.1e1 / t19 / t198
  t314 = t29 * t31 * t311 * t41
  t321 = t197 * t30 / t18 / t198 / t149 * t204
  t323 = t24 ** 2
  t324 = 0.1e1 / t323
  t326 = t324 * t196 * s0
  t327 = t198 ** 2
  t331 = 0.1e1 / t203 / t40
  t333 = t326 / t327 / t32 * t331
  t335 = 0.22e2 / 0.27e2 * t314 - t321 / 0.6e1 + 0.4e1 / 0.81e2 * t333
  t340 = t208 ** 2
  t341 = t46 * t340
  t343 = t101 * t335
  t345 = t45 * t335
  t351 = 0.105e3 / 0.2e1 * t341 + 0.35e2 / 0.2e1 * t343 - 0.15e2 / 0.2e1 * t340 - 0.15e2 / 0.2e1 * t345
  t354 = t185 ** 2
  t357 = t158 ** 2
  t367 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * t49 * t151 - 0.11e2 / 0.9e1 * t36 * t311) * t23 * t27
  t368 = f.my_piecewise3(t57, t367, 0)
  t376 = 0.1e1 / t64 / t59
  t382 = t70 * t77
  t383 = t169 ** 2
  t384 = t69 * t383
  t387 = t71 * t174
  t393 = f.my_piecewise3(t57, 0, t367)
  t394 = t68 * t393
  t398 = 0.1e1 / t173 / t76
  t399 = t72 * t398
  t400 = t182 ** 2
  t403 = t68 * t74
  t412 = 0.3e1 * t176 * t393 + 0.24e2 * t178 * t383 + 0.3e1 * t179 * t393 + 0.6e1 * t403 * t383
  t415 = f.my_piecewise3(t56, -0.12e2 * t164 * t357 - 0.12e2 * t164 * t368 + 0.60e2 * t376 * t357 - 0.18e2 * t65 * t357 + 0.6e1 * t63 * t368 + 0.3e1 * t65 * t368, -0.12e2 * t387 * t170 * t182 + 0.6e1 * t168 * t383 + 0.6e1 * t168 * t394 + t175 * t412 - 0.24e2 * t382 * t384 - 0.2e1 * t399 * t400)
  t419 = t79 * t354
  t421 = t80 * t415
  t424 = 0.15e2 * t419 + 0.15e2 / 0.2e1 * t421 - 0.3e1 / 0.2e1 * t415
  t427 = t80 * t354
  t429 = t85 * t415
  t432 = t79 * t415
  t434 = 0.105e3 / 0.2e1 * t427 + 0.35e2 / 0.2e1 * t429 - 0.15e2 / 0.2e1 * t354 - 0.15e2 / 0.2e1 * t432
  t449 = 0.794649536e-8 * t224 * t217 - 0.100478906e-6 * t335 * t94 - 0.1099818826e-6 * t224 * t234 + 0.74243981175000000000000000000000000000000000000000e-1 * t341 + 0.24747993725000000000000000000000000000000000000000e-1 * t343 - 0.17025650782500000000000000000000000000000000000000e0 * t345 - 0.340722258e-8 * t351 * t94 + 0.401122209e-6 * t116 * t354 - 0.69727705930000000000000000000000000000000000000000e-1 * t415 + 0.384749108e-1 * t224 * t185 - 0.608338264e-2 * t45 * t424 + 0.397324768e-8 * t116 * t434 + 0.574317889e-7 * t351 * t88 - 0.657949254e-6 * t48 * t424 - 0.1502248044e-5 * t105 * t354 + 0.954072288e-1 * t45 * t354 - 0.681444516e-8 * t243 * t217 - 0.608338264e-2 * t335 * t88
  t460 = t351 * t79
  t466 = t45 * t340
  t468 = t46 * t335
  t475 = 0.15e2 * t466 + 0.15e2 / 0.2e1 * t468 - 0.11e2 / 0.9e1 * t314 + t321 / 0.4e1 - 0.2e1 / 0.27e2 * t333
  t486 = 0.605687217e-6 * t340 * t94 - 0.549909413e-7 * t116 * t424 + 0.192374554e-1 * t116 * t415 + 0.1838634068e-5 * t243 * t185 + 0.201895739e-6 * t48 * t434 + 0.919317034e-6 * t460 - 0.1973847762e-5 * t340 * t88 - 0.222650139e-1 * t48 * t415 - 0.30169747200000000000000000000000000000000000000000e0 * t466 - 0.15084873600000000000000000000000000000000000000000e0 * t468 + 0.397324768e-8 * t475 * t94 + 0.74303505150000000000000000000000000000000000000000e-2 * t427 + 0.24767835050000000000000000000000000000000000000000e-2 * t429 + 0.43536371955000000000000000000000000000000000000000e-1 * t432 - 0.100478906e-6 * t45 * t434 + 0.21119121300000000000000000000000000000000000000000e-1 * t419 + 0.10559560650000000000000000000000000000000000000000e-1 * t421 - 0.17025650782500000000000000000000000000000000000000e0 * t340
  t490 = t475 * t79
  t498 = t340 * t79
  t522 = -0.500749348e-6 * t351 * t82 + 0.192374554e-1 * t490 - 0.340722258e-8 * t105 * t434 + 0.453837246e-1 * t45 * t415 - 0.1565454237e-1 * t340 * t82 - 0.667950417e-1 * t498 + 0.919317034e-6 * t105 * t415 + 0.907674492e-1 * t208 * t185 + 0.11877076297777777777777777777777777777777777777778e0 * t314 - 0.24294019700000000000000000000000000000000000000000e-1 * t321 + 0.954072288e-1 * t126 * t415 + 0.1908144576e0 * t285 * t185 + 0.1211374434e-5 * t241 * t217 - 0.3947695524e-5 * t241 * t234 - 0.1335900834e0 * t241 * t185 - 0.1565454237e-1 * t134 * t415 + 0.802244418e-6 * t227 * t185 - 0.667950417e-1 * t345 * t79
  t555 = t335 * t79
  t557 = 0.401122209e-6 * t122 * t415 - 0.1502248044e-5 * t112 * t415 - 0.1565454237e-1 * t345 * t82 + 0.605687217e-6 * t345 * t94 - 0.1973847762e-5 * t345 * t88 - 0.3004496088e-5 * t299 * t185 + 0.43536371955000000000000000000000000000000000000000e-1 * t354 + 0.71982280592592592592592592592592592592592592592592e-2 * t333 - 0.9392725422e-1 * t241 * t215 + 0.1148635778e-6 * t243 * t234 - 0.200957812e-6 * t208 * t217 - 0.1565454237e-1 * t48 * t354 - 0.1216676528e-1 * t208 * t234 + 0.133707403e-6 * t475 * t82 + 0.574317889e-7 * t105 * t424 - 0.549909413e-7 * t475 * t88 + 0.318024096e-1 * t335 * t82 + 0.453837246e-1 * t555
  t559 = t449 + t486 + t522 + t557
  t564 = f.my_piecewise3(t2, 0, t6 * t22 * t141 / 0.12e2 - t6 * t146 * t303 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t307 * t559)
  t576 = t340 * t208
  t577 = t45 * t576
  t579 = t198 * r0
  t581 = 0.1e1 / t19 / t579
  t584 = t29 * t31 * t581 * t41
  t590 = t197 * t30 / t18 / t327 * t204
  t595 = t326 / t327 / t149 * t331
  t597 = t196 ** 2
  t603 = t203 ** 2
  t608 = t324 * t597 / t19 / t327 / t579 / t603 * t23 * t27 * t31
  t610 = -0.308e3 / 0.81e2 * t584 + 0.341e3 / 0.243e3 * t590 - 0.76e2 / 0.81e2 * t595 + 0.4e1 / 0.243e3 * t608
  t611 = t101 * t610
  t613 = t208 * t335
  t615 = t45 * t610
  t618 = t220 * t335
  t623 = 0.105e3 * t577 + 0.315e3 / 0.2e1 * t618 + 0.35e2 / 0.2e1 * t611 - 0.45e2 / 0.2e1 * t613 - 0.15e2 / 0.2e1 * t615
  t632 = t421 * t185
  t634 = t241 * t335
  t640 = 0.14848796235000000000000000000000000000000000000000e0 * t577 + 0.24747993725000000000000000000000000000000000000000e-1 * t611 - 0.51076952347500000000000000000000000000000000000000e0 * t613 - 0.17025650782500000000000000000000000000000000000000e0 * t615 - 0.500749348e-6 * t623 * t82 - 0.1825014792e-1 * t208 * t424 + 0.318024096e-1 * t610 * t82 - 0.667950417e-1 * t615 * t79 + 0.22291051545000000000000000000000000000000000000000e-1 * t632 - 0.90509241600000000000000000000000000000000000000000e0 * t634 + 0.1817061651e-5 * t241 * t434 - 0.4696362711e-1 * t293 * t335
  t641 = t215 * t415
  t649 = t357 * t158
  t661 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * t49 * t311 + 0.154e3 / 0.27e2 * t36 * t581) * t23 * t27
  t662 = f.my_piecewise3(t57, t661, 0)
  t681 = t383 * t169
  t682 = t73 * t681
  t709 = t169 * t393
  t712 = f.my_piecewise3(t57, 0, t661)
  t716 = t173 ** 2
  t739 = 0.48e2 * t682 * t77 + 0.72e2 * t70 * t174 * t384 * t182 - 0.72e2 * t382 * t68 * t681 - 0.72e2 * t382 * t69 * t169 * t393 + 0.36e2 * t71 * t398 * t170 * t400 - 0.18e2 * t387 * t383 * t182 - 0.18e2 * t387 * t394 * t182 - 0.18e2 * t387 * t170 * t412 + 0.18e2 * t168 * t709 + 0.6e1 * t168 * t68 * t712 + 0.6e1 * t72 / t716 * t400 * t182 - 0.6e1 * t399 * t182 * t412 + t175 * (0.72e2 * t178 * t169 * t393 + 0.3e1 * t176 * t712 + 0.3e1 * t179 * t712 + 0.18e2 * t403 * t709 + 0.6e1 * t681 * t74 + 0.114e3 * t682)
  t740 = f.my_piecewise3(t56, 0.72e2 * t164 * t649 - 0.54e2 * t161 * t368 + 0.6e1 * t63 * t662 + 0.60e2 * t376 * t649 - 0.36e2 * t165 * t368 + 0.3e1 * t65 * t662 - 0.360e3 / t64 / t62 * t649 + 0.180e3 * t376 * t158 * t368 - 0.12e2 * t164 * t662, t739)
  t746 = t354 * t185
  t747 = t79 * t746
  t750 = t85 * t740
  t752 = t185 * t415
  t754 = t79 * t740
  t756 = 0.105e3 * t747 + 0.315e3 / 0.2e1 * t632 + 0.35e2 / 0.2e1 * t750 - 0.45e2 / 0.2e1 * t752 - 0.15e2 / 0.2e1 * t754
  t769 = 0.63357363900000000000000000000000000000000000000000e-1 * t641 - 0.4696362711e-1 * t186 * t415 + 0.1817061651e-5 * t209 * t335 + 0.2862216864e0 * t285 * t415 - 0.1565454237e-1 * t134 * t740 - 0.13676633312592592592592592592592592592592592592592e0 * t595 + 0.1722953667e-6 * t243 * t424 - 0.340722258e-8 * t105 * t756 + 0.1817061651e-5 * t340 * t217 - 0.301436718e-6 * t335 * t217 - 0.2003851251e0 * t340 * t185 + 0.453837246e-1 * t45 * t740 - 0.100478906e-6 * t610 * t94
  t789 = t46 * t610
  t791 = -0.1022166774e-7 * t243 * t434 + 0.919317034e-6 * t105 * t740 + 0.192374554e-1 * t116 * t740 - 0.4506744132e-5 * t243 * t354 - 0.1825014792e-1 * t335 * t234 + 0.14860701030000000000000000000000000000000000000000e-1 * t747 + 0.24767835050000000000000000000000000000000000000000e-2 * t750 + 0.13060911586500000000000000000000000000000000000000e0 * t752 + 0.43536371955000000000000000000000000000000000000000e-1 * t754 - 0.100478906e-6 * t45 * t756 + 0.919317034e-6 * t623 * t79 - 0.15084873600000000000000000000000000000000000000000e0 * t789
  t799 = 0.15e2 * t576 + 0.45e2 * t634 + 0.15e2 / 0.2e1 * t789 + 0.154e3 / 0.27e2 * t584 - 0.341e3 / 0.162e3 * t590 + 0.38e2 / 0.27e2 * t595 - 0.2e1 / 0.81e2 * t608
  t806 = t80 * t740
  t812 = 0.15e2 * t746 + 0.45e2 * t641 + 0.15e2 / 0.2e1 * t806 - 0.3e1 / 0.2e1 * t740
  t828 = -0.549909413e-7 * t799 * t88 + 0.453837246e-1 * t610 * t79 - 0.1649728239e-6 * t475 * t234 + 0.10559560650000000000000000000000000000000000000000e-1 * t806 - 0.657949254e-6 * t48 * t812 + 0.133707403e-6 * t799 * t82 - 0.69727705930000000000000000000000000000000000000000e-1 * t740 + 0.23994093530864197530864197530864197530864197530864e-2 * t608 - 0.222650139e-1 * t48 * t740 + 0.577123662e-1 * t475 * t185 + 0.574317889e-7 * t105 * t812 + 0.2862216864e0 * t555 * t185 + 0.22273194352500000000000000000000000000000000000000e0 * t618
  t852 = -0.5921543286e-5 * t241 * t424 + 0.1203366627e-5 * t287 * t415 - 0.30169747200000000000000000000000000000000000000000e0 * t576 - 0.55426356056296296296296296296296296296296296296297e0 * t584 + 0.20454964735061728395061728395061728395061728395062e0 * t590 + 0.1722953667e-6 * t351 * t234 + 0.1361511738e0 * t208 * t415 + 0.1361511738e0 * t335 * t185 - 0.5921543286e-5 * t340 * t234 + 0.1191974304e-7 * t224 * t434 - 0.14089088133e0 * t241 * t432 - 0.14089088133e0 * t345 * t215
  t878 = -0.1502248044e-5 * t112 * t740 - 0.5921543286e-5 * t345 * t234 - 0.14089088133e0 * t498 * t185 + 0.401122209e-6 * t122 * t740 + 0.1203366627e-5 * t227 * t415 + 0.2862216864e0 * t211 * t415 - 0.1973847762e-5 * t615 * t88 - 0.2003851251e0 * t345 * t185 + 0.21119121300000000000000000000000000000000000000000e-1 * t746 + 0.1203366627e-5 * t224 * t354 + 0.577123662e-1 * t224 * t415 + 0.397324768e-8 * t799 * t94 + 0.1191974304e-7 * t475 * t217
  t906 = 0.397324768e-8 * t116 * t756 + 0.201895739e-6 * t48 * t756 - 0.608338264e-2 * t45 * t812 - 0.549909413e-7 * t116 * t812 - 0.608338264e-2 * t610 * t88 - 0.1649728239e-6 * t224 * t424 - 0.1022166774e-7 * t351 * t217 + 0.1203366627e-5 * t490 * t185 - 0.5921543286e-5 * t283 * t335 - 0.4506744132e-5 * t256 * t415 + 0.1817061651e-5 * t345 * t217 - 0.4506744132e-5 * t460 * t185 - 0.1565454237e-1 * t615 * t82
  t933 = -0.2003851251e0 * t241 * t415 - 0.2003851251e0 * t285 * t335 - 0.14089088133e0 * t241 * t354 - 0.4506744132e-5 * t299 * t415 + 0.605687217e-6 * t615 * t94 + 0.954072288e-1 * t126 * t740 + 0.574317889e-7 * t623 * t88 + 0.192374554e-1 * t799 * t79 + 0.2757951102e-5 * t351 * t185 - 0.340722258e-8 * t623 * t94 + 0.2862216864e0 * t208 * t354 - 0.301436718e-6 * t208 * t434 + 0.2757951102e-5 * t243 * t415
  t941 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t141 + t6 * t22 * t303 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t146 * t559 - 0.3e1 / 0.8e1 * t6 * t307 * (t640 + t769 + t791 + t828 + t852 + t878 + t906 + t933))
  v3rho3_0_ = 0.2e1 * r0 * t941 + 0.6e1 * t564

  res = {'v3rho3': v3rho3_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t37 = r0 ** 2
  t39 = 0.1e1 / t33 / t37
  t40 = s0 * t39
  t43 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t50 = 0.5e1 / 0.9e1 * (tau0 / t33 / r0 - t40 / 0.8e1) * t43 * t48
  t51 = 0.1e5 <= t50
  t52 = 0.1e5 < t50
  t53 = f.my_piecewise3(t52, t50, 0.1e5)
  t54 = t53 ** 2
  t58 = 0.1e1 / t54 / t53
  t59 = t54 ** 2
  t60 = 0.1e1 / t59
  t63 = f.my_piecewise3(t52, 0.1e5, t50)
  t64 = t63 ** 2
  t65 = 0.1e1 - t64
  t66 = t65 ** 2
  t67 = t66 * t65
  t68 = t64 * t63
  t69 = 0.1e1 + t68
  t71 = t68 * t69 + 0.1e1
  t72 = 0.1e1 / t71
  t74 = f.my_piecewise3(t51, 0.1e1 - 0.3e1 / t54 - t58 + 0.3e1 * t60, -t67 * t72)
  t75 = t74 ** 2
  t76 = t75 * t74
  t78 = t43 * t48
  t81 = 0.65124e1 + t78 * t40 / 0.24e2
  t82 = 0.1e1 / t81
  t84 = t78 * t40 * t82
  t87 = t84 / 0.12e2 - 0.1e1
  t88 = t87 ** 2
  t89 = t88 ** 2
  t92 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t89 - 0.15e2 / 0.4e1 * t88
  t93 = t75 ** 2
  t96 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t93 - 0.15e2 / 0.4e1 * t75
  t99 = t87 * t74
  t102 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t75
  t107 = 0.5e1 / 0.2e1 * t76 - 0.3e1 / 0.2e1 * t74
  t113 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t88
  t114 = t113 * t74
  t122 = t88 * t87
  t125 = 0.5e1 / 0.2e1 * t122 - t84 / 0.8e1 + 0.3e1 / 0.2e1
  t126 = t125 * t74
  t128 = 0.35198535500000000000000000000000000000000000000000e-2 * t76 + 0.12147009850000000000000000000000000000000000000000e-1 * t84 - 0.340722258e-8 * t92 * t96 + 0.453837246e-1 * t99 + 0.318024096e-1 * t87 * t102 - 0.608338264e-2 * t87 * t107 - 0.100478906e-6 * t87 * t96 - 0.222650139e-1 * t114 - 0.521818079e-2 * t113 * t102 - 0.657949254e-6 * t113 * t107 + 0.201895739e-6 * t113 * t96 + 0.192374554e-1 * t126
  t135 = t92 * t74
  t147 = 0.10451438955835000000000000000000000000000000000000e1 + 0.133707403e-6 * t125 * t102 - 0.549909413e-7 * t125 * t107 + 0.397324768e-8 * t125 * t96 + 0.919317034e-6 * t135 - 0.500749348e-6 * t92 * t102 + 0.574317889e-7 * t92 * t107 + 0.61919587625000000000000000000000000000000000000000e-3 * t93 + 0.61869984312500000000000000000000000000000000000000e-2 * t89 - 0.69727705930000000000000000000000000000000000000000e-1 * t74 - 0.50282912000000000000000000000000000000000000000000e-1 * t122 - 0.85128253912500000000000000000000000000000000000000e-1 * t88 + 0.21768185977500000000000000000000000000000000000000e-1 * t75
  t148 = t128 + t147
  t152 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t153 = t152 * f.p.zeta_threshold
  t155 = f.my_piecewise3(t20, t153, t21 * t19)
  t156 = t30 ** 2
  t157 = 0.1e1 / t156
  t158 = t155 * t157
  t161 = t5 * t158 * t148 / 0.8e1
  t162 = t155 * t30
  t165 = t37 * r0
  t167 = 0.1e1 / t33 / t165
  t168 = s0 * t167
  t173 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t39 + t168 / 0.3e1) * t43 * t48
  t174 = f.my_piecewise3(t52, t173, 0)
  t180 = 0.1e1 / t59 / t53
  t184 = t66 * t72
  t185 = f.my_piecewise3(t52, 0, t173)
  t186 = t63 * t185
  t189 = t71 ** 2
  t190 = 0.1e1 / t189
  t191 = t67 * t190
  t192 = t64 * t69
  t194 = t64 ** 2
  t195 = t194 * t63
  t198 = 0.3e1 * t192 * t185 + 0.3e1 * t195 * t185
  t201 = f.my_piecewise3(t51, -0.12e2 * t180 * t174 + 0.6e1 * t58 * t174 + 0.3e1 * t60 * t174, 0.6e1 * t184 * t186 + t191 * t198)
  t206 = t78 * t168 * t82
  t208 = t43 ** 2
  t211 = t208 / t46 / t45
  t212 = s0 ** 2
  t213 = t37 ** 2
  t218 = t81 ** 2
  t219 = 0.1e1 / t218
  t221 = t211 * t212 / t32 / t213 / t37 * t219
  t223 = -0.2e1 / 0.9e1 * t206 + t221 / 0.108e3
  t224 = t87 * t223
  t229 = t88 * t223
  t234 = 0.15e2 / 0.2e1 * t229 + t206 / 0.3e1 - t221 / 0.72e2
  t237 = t75 * t201
  t241 = 0.15e2 / 0.2e1 * t237 - 0.3e1 / 0.2e1 * t201
  t244 = t76 * t201
  t246 = t74 * t201
  t250 = 0.35e2 / 0.2e1 * t244 - 0.15e2 / 0.2e1 * t246
  t253 = t122 * t223
  t258 = 0.35e2 / 0.2e1 * t253 - 0.15e2 / 0.2e1 * t224
  t261 = t223 * t74
  t267 = t234 * t74
  t271 = t258 * t74
  t273 = -0.69727705930000000000000000000000000000000000000000e-1 * t201 + 0.401122209e-6 * t126 * t201 - 0.1565454237e-1 * t224 * t102 - 0.1973847762e-5 * t224 * t107 - 0.15084873600000000000000000000000000000000000000000e0 * t229 + 0.397324768e-8 * t234 * t96 + 0.10559560650000000000000000000000000000000000000000e-1 * t237 - 0.608338264e-2 * t87 * t241 + 0.24767835050000000000000000000000000000000000000000e-2 * t244 + 0.43536371955000000000000000000000000000000000000000e-1 * t246 + 0.397324768e-8 * t125 * t250 + 0.24747993725000000000000000000000000000000000000000e-1 * t253 - 0.17025650782500000000000000000000000000000000000000e0 * t224 + 0.574317889e-7 * t258 * t107 + 0.453837246e-1 * t261 + 0.133707403e-6 * t234 * t102 - 0.340722258e-8 * t258 * t96 + 0.192374554e-1 * t267 + 0.192374554e-1 * t125 * t201 + 0.919317034e-6 * t271
  t315 = 0.605687217e-6 * t224 * t96 - 0.1565454237e-1 * t114 * t201 + 0.954072288e-1 * t99 * t201 - 0.667950417e-1 * t224 * t74 - 0.1502248044e-5 * t135 * t201 + 0.13496677611111111111111111111111111111111111111111e-2 * t221 - 0.100478906e-6 * t223 * t96 + 0.453837246e-1 * t87 * t201 - 0.100478906e-6 * t87 * t250 - 0.500749348e-6 * t258 * t102 - 0.32392026266666666666666666666666666666666666666667e-1 * t206
  t317 = t273 + 0.574317889e-7 * t92 * t241 - 0.549909413e-7 * t125 * t241 + 0.318024096e-1 * t223 * t102 - 0.608338264e-2 * t223 * t107 - 0.222650139e-1 * t113 * t201 - 0.657949254e-6 * t113 * t241 - 0.340722258e-8 * t92 * t250 - 0.549909413e-7 * t234 * t107 + 0.201895739e-6 * t113 * t250 + 0.919317034e-6 * t92 * t201 + t315
  t322 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t148 - t161 - 0.3e1 / 0.8e1 * t5 * t162 * t317)
  t324 = r1 <= f.p.dens_threshold
  t325 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t326 = 0.1e1 + t325
  t327 = t326 <= f.p.zeta_threshold
  t328 = t326 ** (0.1e1 / 0.3e1)
  t330 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t333 = f.my_piecewise3(t327, 0, 0.4e1 / 0.3e1 * t328 * t330)
  t334 = t333 * t30
  t335 = r1 ** (0.1e1 / 0.3e1)
  t336 = t335 ** 2
  t340 = r1 ** 2
  t342 = 0.1e1 / t336 / t340
  t343 = s2 * t342
  t348 = 0.5e1 / 0.9e1 * (tau1 / t336 / r1 - t343 / 0.8e1) * t43 * t48
  t349 = 0.1e5 <= t348
  t350 = 0.1e5 < t348
  t351 = f.my_piecewise3(t350, t348, 0.1e5)
  t352 = t351 ** 2
  t356 = 0.1e1 / t352 / t351
  t357 = t352 ** 2
  t358 = 0.1e1 / t357
  t361 = f.my_piecewise3(t350, 0.1e5, t348)
  t362 = t361 ** 2
  t363 = 0.1e1 - t362
  t364 = t363 ** 2
  t365 = t364 * t363
  t366 = t362 * t361
  t367 = 0.1e1 + t366
  t369 = t366 * t367 + 0.1e1
  t370 = 0.1e1 / t369
  t372 = f.my_piecewise3(t349, 0.1e1 - 0.3e1 / t352 - t356 + 0.3e1 * t358, -t365 * t370)
  t373 = t372 ** 2
  t374 = t373 * t372
  t376 = t373 ** 2
  t380 = 0.65124e1 + t78 * t343 / 0.24e2
  t381 = 0.1e1 / t380
  t383 = t78 * t343 * t381
  t385 = t383 / 0.12e2 - 0.1e1
  t386 = t385 ** 2
  t388 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t386
  t391 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t376 - 0.15e2 / 0.4e1 * t373
  t396 = 0.5e1 / 0.2e1 * t374 - 0.3e1 / 0.2e1 * t372
  t399 = t388 * t372
  t402 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t373
  t411 = t385 * t372
  t413 = t386 ** 2
  t416 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t413 - 0.15e2 / 0.4e1 * t386
  t421 = 0.35198535500000000000000000000000000000000000000000e-2 * t374 + 0.61919587625000000000000000000000000000000000000000e-3 * t376 + 0.201895739e-6 * t388 * t391 - 0.657949254e-6 * t388 * t396 - 0.222650139e-1 * t399 - 0.521818079e-2 * t388 * t402 - 0.100478906e-6 * t385 * t391 + 0.318024096e-1 * t385 * t402 - 0.608338264e-2 * t385 * t396 + 0.453837246e-1 * t411 - 0.340722258e-8 * t416 * t391 + 0.574317889e-7 * t416 * t396
  t422 = t416 * t372
  t426 = t386 * t385
  t429 = 0.5e1 / 0.2e1 * t426 - t383 / 0.8e1 + 0.3e1 / 0.2e1
  t434 = t429 * t372
  t444 = 0.10451438955835000000000000000000000000000000000000e1 + 0.919317034e-6 * t422 - 0.500749348e-6 * t416 * t402 + 0.397324768e-8 * t429 * t391 - 0.549909413e-7 * t429 * t396 + 0.192374554e-1 * t434 + 0.133707403e-6 * t429 * t402 - 0.50282912000000000000000000000000000000000000000000e-1 * t426 + 0.12147009850000000000000000000000000000000000000000e-1 * t383 - 0.69727705930000000000000000000000000000000000000000e-1 * t372 + 0.21768185977500000000000000000000000000000000000000e-1 * t373 + 0.61869984312500000000000000000000000000000000000000e-2 * t413 - 0.85128253912500000000000000000000000000000000000000e-1 * t386
  t445 = t421 + t444
  t450 = f.my_piecewise3(t327, t153, t328 * t326)
  t451 = t450 * t157
  t454 = t5 * t451 * t445 / 0.8e1
  t456 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t334 * t445 - t454)
  t458 = t21 ** 2
  t459 = 0.1e1 / t458
  t460 = t26 ** 2
  t465 = t16 / t22 / t6
  t467 = -0.2e1 * t23 + 0.2e1 * t465
  t468 = f.my_piecewise5(t10, 0, t14, 0, t467)
  t472 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t459 * t460 + 0.4e1 / 0.3e1 * t21 * t468)
  t479 = t5 * t29 * t157 * t148
  t485 = 0.1e1 / t156 / t6
  t489 = t5 * t155 * t485 * t148 / 0.12e2
  t491 = t5 * t158 * t317
  t497 = s0 / t33 / t213
  t499 = t78 * t497 * t82
  t506 = t211 * t212 / t32 / t213 / t165 * t219
  t508 = t45 ** 2
  t509 = 0.1e1 / t508
  t512 = t213 ** 2
  t518 = t509 * t212 * s0 / t512 / t37 / t218 / t81
  t520 = 0.22e2 / 0.27e2 * t499 - t506 / 0.12e2 + t518 / 0.81e2
  t525 = t223 ** 2
  t526 = t87 * t525
  t528 = t88 * t520
  t533 = 0.15e2 * t526 + 0.15e2 / 0.2e1 * t528 - 0.11e2 / 0.9e1 * t499 + t506 / 0.8e1 - t518 / 0.54e2
  t536 = t201 ** 2
  t541 = t88 * t525
  t543 = t122 * t520
  t546 = t87 * t520
  t548 = 0.105e3 / 0.2e1 * t541 + 0.35e2 / 0.2e1 * t543 - 0.15e2 / 0.2e1 * t525 - 0.15e2 / 0.2e1 * t546
  t553 = t74 * t536
  t555 = t174 ** 2
  t564 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t167 - 0.11e2 / 0.9e1 * t497) * t43 * t48
  t565 = f.my_piecewise3(t52, t564, 0)
  t580 = t185 ** 2
  t590 = f.my_piecewise3(t52, 0, t564)
  t597 = t198 ** 2
  t612 = f.my_piecewise3(t51, -0.18e2 * t60 * t555 + 0.6e1 * t58 * t565 - 0.12e2 * t180 * t555 + 0.3e1 * t60 * t565 + 0.60e2 / t59 / t54 * t555 - 0.12e2 * t180 * t565, -0.24e2 * t65 * t72 * t64 * t580 - 0.12e2 * t66 * t190 * t186 * t198 + 0.6e1 * t184 * t580 + 0.6e1 * t184 * t63 * t590 - 0.2e1 * t67 / t189 / t71 * t597 + t191 * (0.6e1 * t63 * t69 * t580 + 0.3e1 * t192 * t590 + 0.24e2 * t194 * t580 + 0.3e1 * t195 * t590))
  t613 = t75 * t612
  t616 = 0.15e2 * t553 + 0.15e2 / 0.2e1 * t613 - 0.3e1 / 0.2e1 * t612
  t633 = 0.794649536e-8 * t234 * t250 + 0.318024096e-1 * t520 * t102 - 0.9392725422e-1 * t224 * t246 - 0.549909413e-7 * t533 * t107 + 0.401122209e-6 * t125 * t536 + 0.133707403e-6 * t533 * t102 + 0.919317034e-6 * t548 * t74 + 0.192374554e-1 * t533 * t74 + 0.574317889e-7 * t92 * t616 - 0.69727705930000000000000000000000000000000000000000e-1 * t612 + 0.17995570148148148148148148148148148148148148148148e-2 * t518 - 0.30169747200000000000000000000000000000000000000000e0 * t526 - 0.15084873600000000000000000000000000000000000000000e0 * t528 + 0.397324768e-8 * t533 * t96 - 0.667950417e-1 * t525 * t74 - 0.1565454237e-1 * t113 * t536 - 0.1502248044e-5 * t92 * t536 - 0.200957812e-6 * t223 * t250
  t634 = t75 * t536
  t636 = t76 * t612
  t639 = t74 * t612
  t641 = 0.105e3 / 0.2e1 * t634 + 0.35e2 / 0.2e1 * t636 - 0.15e2 / 0.2e1 * t536 - 0.15e2 / 0.2e1 * t639
  t675 = -0.100478906e-6 * t87 * t641 - 0.1099818826e-6 * t234 * t241 + 0.453837246e-1 * t87 * t612 + 0.907674492e-1 * t223 * t201 + 0.574317889e-7 * t548 * t107 + 0.192374554e-1 * t125 * t612 + 0.10559560650000000000000000000000000000000000000000e-1 * t613 + 0.21119121300000000000000000000000000000000000000000e-1 * t553 - 0.657949254e-6 * t113 * t616 - 0.608338264e-2 * t87 * t616 + 0.384749108e-1 * t234 * t201 - 0.1565454237e-1 * t525 * t102 - 0.1973847762e-5 * t525 * t107 - 0.17025650782500000000000000000000000000000000000000e0 * t525 + 0.605687217e-6 * t546 * t96 - 0.1565454237e-1 * t114 * t612 + 0.1908144576e0 * t261 * t201 - 0.3004496088e-5 * t271 * t201
  t710 = -0.1335900834e0 * t224 * t201 - 0.1973847762e-5 * t546 * t107 - 0.1565454237e-1 * t546 * t102 - 0.3947695524e-5 * t224 * t241 - 0.500749348e-6 * t548 * t102 - 0.1216676528e-1 * t223 * t241 + 0.954072288e-1 * t87 * t536 + 0.605687217e-6 * t525 * t96 - 0.549909413e-7 * t125 * t616 + 0.1148635778e-6 * t258 * t241 - 0.100478906e-6 * t520 * t96 + 0.397324768e-8 * t125 * t641 - 0.608338264e-2 * t520 * t107 + 0.453837246e-1 * t520 * t74 - 0.681444516e-8 * t258 * t250 - 0.12147009850000000000000000000000000000000000000000e-1 * t506 + 0.11877076297777777777777777777777777777777777777778e0 * t499 + 0.24767835050000000000000000000000000000000000000000e-2 * t636
  t741 = 0.43536371955000000000000000000000000000000000000000e-1 * t639 - 0.340722258e-8 * t92 * t641 + 0.201895739e-6 * t113 * t641 + 0.919317034e-6 * t92 * t612 + 0.1838634068e-5 * t258 * t201 - 0.222650139e-1 * t113 * t612 + 0.74243981175000000000000000000000000000000000000000e-1 * t541 + 0.24747993725000000000000000000000000000000000000000e-1 * t543 - 0.17025650782500000000000000000000000000000000000000e0 * t546 - 0.340722258e-8 * t548 * t96 + 0.74303505150000000000000000000000000000000000000000e-2 * t634 + 0.802244418e-6 * t267 * t201 - 0.667950417e-1 * t546 * t74 + 0.401122209e-6 * t126 * t612 + 0.954072288e-1 * t99 * t612 + 0.1211374434e-5 * t224 * t250 - 0.1502248044e-5 * t135 * t612 + 0.43536371955000000000000000000000000000000000000000e-1 * t536
  t748 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t472 * t30 * t148 - t479 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t317 + t489 - t491 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t162 * (t633 + t675 + t710 + t741))
  t749 = t328 ** 2
  t750 = 0.1e1 / t749
  t751 = t330 ** 2
  t755 = f.my_piecewise5(t14, 0, t10, 0, -t467)
  t759 = f.my_piecewise3(t327, 0, 0.4e1 / 0.9e1 * t750 * t751 + 0.4e1 / 0.3e1 * t328 * t755)
  t766 = t5 * t333 * t157 * t445
  t771 = t5 * t450 * t485 * t445 / 0.12e2
  t773 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t759 * t30 * t445 - t766 / 0.4e1 + t771)
  d11 = 0.2e1 * t322 + 0.2e1 * t456 + t6 * (t748 + t773)
  t776 = -t7 - t24
  t777 = f.my_piecewise5(t10, 0, t14, 0, t776)
  t780 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t777)
  t781 = t780 * t30
  t786 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t781 * t148 - t161)
  t788 = f.my_piecewise5(t14, 0, t10, 0, -t776)
  t791 = f.my_piecewise3(t327, 0, 0.4e1 / 0.3e1 * t328 * t788)
  t792 = t791 * t30
  t796 = t450 * t30
  t799 = t340 * r1
  t801 = 0.1e1 / t336 / t799
  t802 = s2 * t801
  t807 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau1 * t342 + t802 / 0.3e1) * t43 * t48
  t808 = f.my_piecewise3(t350, t807, 0)
  t814 = 0.1e1 / t357 / t351
  t818 = t364 * t370
  t819 = f.my_piecewise3(t350, 0, t807)
  t820 = t361 * t819
  t823 = t369 ** 2
  t824 = 0.1e1 / t823
  t825 = t365 * t824
  t826 = t362 * t367
  t828 = t362 ** 2
  t829 = t828 * t361
  t832 = 0.3e1 * t826 * t819 + 0.3e1 * t829 * t819
  t835 = f.my_piecewise3(t349, 0.6e1 * t356 * t808 + 0.3e1 * t358 * t808 - 0.12e2 * t814 * t808, 0.6e1 * t818 * t820 + t825 * t832)
  t836 = t374 * t835
  t838 = t372 * t835
  t840 = 0.35e2 / 0.2e1 * t836 - 0.15e2 / 0.2e1 * t838
  t844 = t78 * t802 * t381
  t846 = s2 ** 2
  t847 = t340 ** 2
  t852 = t380 ** 2
  t853 = 0.1e1 / t852
  t855 = t211 * t846 / t335 / t847 / t340 * t853
  t857 = -0.2e1 / 0.9e1 * t844 + t855 / 0.108e3
  t862 = t386 * t857
  t866 = 0.15e2 / 0.2e1 * t862 + t844 / 0.3e1 - t855 / 0.72e2
  t869 = t373 * t835
  t872 = 0.15e2 / 0.2e1 * t869 - 0.3e1 / 0.2e1 * t835
  t875 = t426 * t857
  t877 = t385 * t857
  t879 = 0.35e2 / 0.2e1 * t875 - 0.15e2 / 0.2e1 * t877
  t882 = t866 * t372
  t890 = t879 * t372
  t907 = 0.397324768e-8 * t429 * t840 - 0.100478906e-6 * t857 * t391 - 0.100478906e-6 * t385 * t840 + 0.397324768e-8 * t866 * t391 + 0.574317889e-7 * t416 * t872 - 0.340722258e-8 * t879 * t391 + 0.192374554e-1 * t882 - 0.657949254e-6 * t388 * t872 - 0.340722258e-8 * t416 * t840 + 0.24747993725000000000000000000000000000000000000000e-1 * t875 - 0.17025650782500000000000000000000000000000000000000e0 * t877 + 0.919317034e-6 * t890 + 0.574317889e-7 * t879 * t396 - 0.500749348e-6 * t879 * t402 - 0.608338264e-2 * t385 * t872 + 0.919317034e-6 * t416 * t835 - 0.549909413e-7 * t866 * t396 - 0.222650139e-1 * t388 * t835 - 0.69727705930000000000000000000000000000000000000000e-1 * t835 - 0.667950417e-1 * t877 * t372
  t924 = t857 * t372
  t945 = 0.453837246e-1 * t385 * t835 - 0.15084873600000000000000000000000000000000000000000e0 * t862 + 0.133707403e-6 * t866 * t402 + 0.318024096e-1 * t857 * t402 - 0.608338264e-2 * t857 * t396 + 0.192374554e-1 * t429 * t835 + 0.10559560650000000000000000000000000000000000000000e-1 * t869 - 0.549909413e-7 * t429 * t872 + 0.43536371955000000000000000000000000000000000000000e-1 * t838 + 0.24767835050000000000000000000000000000000000000000e-2 * t836 + 0.201895739e-6 * t388 * t840
  t947 = t907 - 0.32392026266666666666666666666666666666666666666667e-1 * t844 + 0.13496677611111111111111111111111111111111111111111e-2 * t855 - 0.1565454237e-1 * t877 * t402 + 0.605687217e-6 * t877 * t391 - 0.1565454237e-1 * t399 * t835 + 0.401122209e-6 * t434 * t835 + 0.954072288e-1 * t411 * t835 - 0.1973847762e-5 * t877 * t396 - 0.1502248044e-5 * t422 * t835 + 0.453837246e-1 * t924 + t945
  t952 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t792 * t445 - t454 - 0.3e1 / 0.8e1 * t5 * t796 * t947)
  t956 = 0.2e1 * t465
  t957 = f.my_piecewise5(t10, 0, t14, 0, t956)
  t961 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t459 * t777 * t26 + 0.4e1 / 0.3e1 * t21 * t957)
  t968 = t5 * t780 * t157 * t148
  t976 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t961 * t30 * t148 - t968 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t781 * t317 - t479 / 0.8e1 + t489 - t491 / 0.8e1)
  t980 = f.my_piecewise5(t14, 0, t10, 0, -t956)
  t984 = f.my_piecewise3(t327, 0, 0.4e1 / 0.9e1 * t750 * t788 * t330 + 0.4e1 / 0.3e1 * t328 * t980)
  t991 = t5 * t791 * t157 * t445
  t998 = t5 * t451 * t947
  t1001 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t984 * t30 * t445 - t991 / 0.8e1 - t766 / 0.8e1 + t771 - 0.3e1 / 0.8e1 * t5 * t334 * t947 - t998 / 0.8e1)
  d12 = t322 + t456 + t786 + t952 + t6 * (t976 + t1001)
  t1006 = t777 ** 2
  t1010 = 0.2e1 * t23 + 0.2e1 * t465
  t1011 = f.my_piecewise5(t10, 0, t14, 0, t1010)
  t1015 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t459 * t1006 + 0.4e1 / 0.3e1 * t21 * t1011)
  t1022 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1015 * t30 * t148 - t968 / 0.4e1 + t489)
  t1023 = t788 ** 2
  t1027 = f.my_piecewise5(t14, 0, t10, 0, -t1010)
  t1031 = f.my_piecewise3(t327, 0, 0.4e1 / 0.9e1 * t750 * t1023 + 0.4e1 / 0.3e1 * t328 * t1027)
  t1041 = t808 ** 2
  t1048 = s2 / t336 / t847
  t1053 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau1 * t801 - 0.11e2 / 0.9e1 * t1048) * t43 * t48
  t1054 = f.my_piecewise3(t350, t1053, 0)
  t1069 = t819 ** 2
  t1079 = f.my_piecewise3(t350, 0, t1053)
  t1086 = t832 ** 2
  t1101 = f.my_piecewise3(t349, -0.18e2 * t358 * t1041 + 0.6e1 * t356 * t1054 - 0.12e2 * t814 * t1041 + 0.3e1 * t358 * t1054 + 0.60e2 / t357 / t352 * t1041 - 0.12e2 * t814 * t1054, -0.24e2 * t363 * t370 * t362 * t1069 - 0.12e2 * t364 * t824 * t820 * t832 + 0.6e1 * t818 * t1069 + 0.6e1 * t818 * t361 * t1079 - 0.2e1 * t365 / t823 / t369 * t1086 + t825 * (0.6e1 * t361 * t367 * t1069 + 0.24e2 * t828 * t1069 + 0.3e1 * t826 * t1079 + 0.3e1 * t829 * t1079))
  t1103 = t857 ** 2
  t1106 = t78 * t1048 * t381
  t1113 = t211 * t846 / t335 / t847 / t799 * t853
  t1117 = t847 ** 2
  t1123 = t509 * t846 * s2 / t1117 / t340 / t852 / t380
  t1125 = 0.22e2 / 0.27e2 * t1106 - t1113 / 0.12e2 + t1123 / 0.81e2
  t1128 = t835 ** 2
  t1131 = t386 * t1103
  t1133 = t426 * t1125
  t1136 = t385 * t1125
  t1138 = 0.105e3 / 0.2e1 * t1131 + 0.35e2 / 0.2e1 * t1133 - 0.15e2 / 0.2e1 * t1103 - 0.15e2 / 0.2e1 * t1136
  t1151 = t373 * t1128
  t1153 = t374 * t1101
  t1156 = t372 * t1101
  t1158 = 0.105e3 / 0.2e1 * t1151 + 0.35e2 / 0.2e1 * t1153 - 0.15e2 / 0.2e1 * t1128 - 0.15e2 / 0.2e1 * t1156
  t1165 = t385 * t1103
  t1167 = t386 * t1125
  t1172 = 0.15e2 * t1165 + 0.15e2 / 0.2e1 * t1167 - 0.11e2 / 0.9e1 * t1106 + t1113 / 0.8e1 - t1123 / 0.54e2
  t1183 = -0.69727705930000000000000000000000000000000000000000e-1 * t1101 - 0.17025650782500000000000000000000000000000000000000e0 * t1103 + 0.453837246e-1 * t1125 * t372 + 0.954072288e-1 * t385 * t1128 - 0.340722258e-8 * t1138 * t391 - 0.1565454237e-1 * t1103 * t402 - 0.667950417e-1 * t1103 * t372 - 0.1216676528e-1 * t857 * t872 + 0.605687217e-6 * t1103 * t391 + 0.192374554e-1 * t429 * t1101 - 0.340722258e-8 * t416 * t1158 - 0.1565454237e-1 * t388 * t1128 + 0.574317889e-7 * t1138 * t396 + 0.192374554e-1 * t1172 * t372 - 0.1973847762e-5 * t1103 * t396 - 0.681444516e-8 * t879 * t840 - 0.549909413e-7 * t1172 * t396 + 0.1838634068e-5 * t879 * t835
  t1194 = t372 * t1128
  t1196 = t373 * t1101
  t1199 = 0.15e2 * t1194 + 0.15e2 / 0.2e1 * t1196 - 0.3e1 / 0.2e1 * t1101
  t1222 = 0.43536371955000000000000000000000000000000000000000e-1 * t1128 - 0.9392725422e-1 * t877 * t838 + 0.17995570148148148148148148148148148148148148148148e-2 * t1123 + 0.401122209e-6 * t429 * t1128 + 0.11877076297777777777777777777777777777777777777778e0 * t1106 - 0.12147009850000000000000000000000000000000000000000e-1 * t1113 + 0.201895739e-6 * t388 * t1158 - 0.657949254e-6 * t388 * t1199 - 0.1099818826e-6 * t866 * t872 - 0.100478906e-6 * t1125 * t391 + 0.397324768e-8 * t1172 * t391 - 0.608338264e-2 * t1125 * t396 + 0.907674492e-1 * t857 * t835 - 0.200957812e-6 * t857 * t840 + 0.1148635778e-6 * t879 * t872 + 0.919317034e-6 * t1138 * t372 + 0.384749108e-1 * t866 * t835 + 0.919317034e-6 * t416 * t1101
  t1250 = 0.74303505150000000000000000000000000000000000000000e-2 * t1151 + 0.24767835050000000000000000000000000000000000000000e-2 * t1153 + 0.43536371955000000000000000000000000000000000000000e-1 * t1156 - 0.100478906e-6 * t385 * t1158 + 0.397324768e-8 * t429 * t1158 + 0.21119121300000000000000000000000000000000000000000e-1 * t1194 - 0.549909413e-7 * t429 * t1199 - 0.1502248044e-5 * t416 * t1128 + 0.74243981175000000000000000000000000000000000000000e-1 * t1131 + 0.24747993725000000000000000000000000000000000000000e-1 * t1133 - 0.17025650782500000000000000000000000000000000000000e0 * t1136 - 0.500749348e-6 * t1138 * t402 + 0.453837246e-1 * t385 * t1101 + 0.10559560650000000000000000000000000000000000000000e-1 * t1196 - 0.30169747200000000000000000000000000000000000000000e0 * t1165 - 0.15084873600000000000000000000000000000000000000000e0 * t1167 + 0.133707403e-6 * t1172 * t402 - 0.222650139e-1 * t388 * t1101
  t1287 = 0.574317889e-7 * t416 * t1199 + 0.318024096e-1 * t1125 * t402 - 0.608338264e-2 * t385 * t1199 + 0.794649536e-8 * t866 * t840 + 0.401122209e-6 * t434 * t1101 - 0.1973847762e-5 * t1136 * t396 - 0.3004496088e-5 * t890 * t835 + 0.605687217e-6 * t1136 * t391 - 0.667950417e-1 * t1136 * t372 + 0.954072288e-1 * t411 * t1101 - 0.1565454237e-1 * t1136 * t402 - 0.1565454237e-1 * t399 * t1101 - 0.3947695524e-5 * t877 * t872 + 0.1211374434e-5 * t877 * t840 + 0.802244418e-6 * t882 * t835 + 0.1908144576e0 * t924 * t835 - 0.1335900834e0 * t877 * t835 - 0.1502248044e-5 * t422 * t1101
  t1294 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t1031 * t30 * t445 - t991 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t792 * t947 + t771 - t998 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t796 * (t1183 + t1222 + t1250 + t1287))
  d22 = 0.2e1 * t786 + 0.2e1 * t952 + t6 * (t1022 + t1294)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t55 = s0 * t54
  t58 = 0.65124e1 + t49 * t55 / 0.24e2
  t59 = 0.1e1 / t58
  t61 = t49 * t55 * t59
  t63 = t61 / 0.12e2 - 0.1e1
  t64 = t63 ** 2
  t66 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t64
  t74 = 0.5e1 / 0.9e1 * (tau0 / t52 / r0 - t55 / 0.8e1) * t44 * t48
  t75 = 0.1e5 <= t74
  t76 = 0.1e5 < t74
  t77 = f.my_piecewise3(t76, t74, 0.1e5)
  t78 = t77 ** 2
  t81 = t78 * t77
  t82 = 0.1e1 / t81
  t83 = t78 ** 2
  t84 = 0.1e1 / t83
  t87 = f.my_piecewise3(t76, 0.1e5, t74)
  t88 = t87 ** 2
  t89 = 0.1e1 - t88
  t90 = t89 ** 2
  t91 = t90 * t89
  t92 = t88 * t87
  t93 = 0.1e1 + t92
  t95 = t92 * t93 + 0.1e1
  t96 = 0.1e1 / t95
  t98 = f.my_piecewise3(t75, 0.1e1 - 0.3e1 / t78 - t82 + 0.3e1 * t84, -t91 * t96)
  t99 = t98 ** 2
  t101 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t99
  t104 = t99 * t98
  t107 = 0.5e1 / 0.2e1 * t104 - 0.3e1 / 0.2e1 * t98
  t110 = t99 ** 2
  t113 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t110 - 0.15e2 / 0.4e1 * t99
  t116 = t64 * t63
  t119 = 0.5e1 / 0.2e1 * t116 - t61 / 0.8e1 + 0.3e1 / 0.2e1
  t120 = t119 * t98
  t128 = t64 ** 2
  t131 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t128 - 0.15e2 / 0.4e1 * t64
  t132 = t131 * t98
  t140 = t63 * t98
  t142 = -0.521818079e-2 * t66 * t101 - 0.657949254e-6 * t66 * t107 + 0.201895739e-6 * t66 * t113 + 0.192374554e-1 * t120 + 0.133707403e-6 * t119 * t101 - 0.549909413e-7 * t119 * t107 + 0.397324768e-8 * t119 * t113 + 0.919317034e-6 * t132 - 0.500749348e-6 * t131 * t101 + 0.574317889e-7 * t131 * t107 - 0.340722258e-8 * t131 * t113 + 0.453837246e-1 * t140
  t149 = t66 * t98
  t159 = 0.10451438955835000000000000000000000000000000000000e1 + 0.318024096e-1 * t63 * t101 - 0.608338264e-2 * t63 * t107 - 0.100478906e-6 * t63 * t113 - 0.222650139e-1 * t149 - 0.50282912000000000000000000000000000000000000000000e-1 * t116 - 0.85128253912500000000000000000000000000000000000000e-1 * t64 + 0.61869984312500000000000000000000000000000000000000e-2 * t128 + 0.61919587625000000000000000000000000000000000000000e-3 * t110 + 0.12147009850000000000000000000000000000000000000000e-1 * t61 + 0.35198535500000000000000000000000000000000000000000e-2 * t104 - 0.69727705930000000000000000000000000000000000000000e-1 * t98 + 0.21768185977500000000000000000000000000000000000000e-1 * t99
  t160 = t142 + t159
  t166 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t167 = t42 ** 2
  t168 = 0.1e1 / t167
  t169 = t166 * t168
  t173 = t166 * t42
  t176 = t50 * r0
  t178 = 0.1e1 / t52 / t176
  t179 = s0 * t178
  t184 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t54 + t179 / 0.3e1) * t44 * t48
  t185 = f.my_piecewise3(t76, t184, 0)
  t188 = t84 * t185
  t191 = 0.1e1 / t83 / t77
  t192 = t191 * t185
  t195 = t90 * t96
  t196 = f.my_piecewise3(t76, 0, t184)
  t197 = t87 * t196
  t200 = t95 ** 2
  t201 = 0.1e1 / t200
  t202 = t91 * t201
  t203 = t88 * t93
  t205 = t88 ** 2
  t206 = t205 * t87
  t209 = 0.3e1 * t203 * t196 + 0.3e1 * t206 * t196
  t212 = f.my_piecewise3(t75, 0.6e1 * t82 * t185 + 0.3e1 * t188 - 0.12e2 * t192, 0.6e1 * t195 * t197 + t202 * t209)
  t213 = t104 * t212
  t215 = t98 * t212
  t217 = 0.35e2 / 0.2e1 * t213 - 0.15e2 / 0.2e1 * t215
  t221 = t49 * t179 * t59
  t223 = t44 ** 2
  t226 = t223 / t46 / t45
  t227 = s0 ** 2
  t228 = t50 ** 2
  t233 = t58 ** 2
  t234 = 0.1e1 / t233
  t236 = t226 * t227 / t51 / t228 / t50 * t234
  t238 = -0.2e1 / 0.9e1 * t221 + t236 / 0.108e3
  t239 = t63 * t238
  t258 = t99 * t212
  t261 = 0.15e2 / 0.2e1 * t258 - 0.3e1 / 0.2e1 * t212
  t264 = t64 * t238
  t268 = 0.15e2 / 0.2e1 * t264 + t221 / 0.3e1 - t236 / 0.72e2
  t269 = t268 * t98
  t275 = t131 * t212
  t277 = t116 * t238
  t280 = 0.35e2 / 0.2e1 * t277 - 0.15e2 / 0.2e1 * t239
  t286 = t119 * t212
  t288 = -0.340722258e-8 * t131 * t217 - 0.667950417e-1 * t239 * t98 + 0.605687217e-6 * t239 * t113 + 0.954072288e-1 * t140 * t212 + 0.401122209e-6 * t120 * t212 - 0.1502248044e-5 * t132 * t212 - 0.1565454237e-1 * t149 * t212 - 0.1565454237e-1 * t239 * t101 - 0.1973847762e-5 * t239 * t107 - 0.32392026266666666666666666666666666666666666666667e-1 * t221 + 0.13496677611111111111111111111111111111111111111111e-2 * t236 - 0.549909413e-7 * t119 * t261 + 0.192374554e-1 * t269 - 0.608338264e-2 * t63 * t261 + 0.397324768e-8 * t268 * t113 + 0.919317034e-6 * t275 + 0.574317889e-7 * t280 * t107 - 0.500749348e-6 * t280 * t101 - 0.69727705930000000000000000000000000000000000000000e-1 * t212 + 0.192374554e-1 * t286
  t291 = t280 * t98
  t293 = t238 * t98
  t300 = t238 * t101
  t312 = t238 * t107
  t318 = t63 * t212
  t324 = t66 * t212
  t326 = -0.100478906e-6 * t238 * t113 - 0.657949254e-6 * t66 * t261 - 0.549909413e-7 * t268 * t107 - 0.608338264e-2 * t312 + 0.24767835050000000000000000000000000000000000000000e-2 * t213 + 0.43536371955000000000000000000000000000000000000000e-1 * t215 - 0.100478906e-6 * t63 * t217 + 0.453837246e-1 * t318 + 0.397324768e-8 * t119 * t217 + 0.201895739e-6 * t66 * t217 - 0.222650139e-1 * t324
  t328 = t288 + 0.24747993725000000000000000000000000000000000000000e-1 * t277 - 0.17025650782500000000000000000000000000000000000000e0 * t239 + 0.919317034e-6 * t291 + 0.453837246e-1 * t293 - 0.15084873600000000000000000000000000000000000000000e0 * t264 + 0.133707403e-6 * t268 * t101 - 0.340722258e-8 * t280 * t113 + 0.318024096e-1 * t300 + 0.10559560650000000000000000000000000000000000000000e-1 * t258 + 0.574317889e-7 * t131 * t261 + t326
  t332 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t333 = t332 * f.p.zeta_threshold
  t335 = f.my_piecewise3(t20, t333, t21 * t19)
  t337 = 0.1e1 / t167 / t6
  t338 = t335 * t337
  t342 = t335 * t168
  t346 = t335 * t42
  t347 = t212 ** 2
  t350 = t99 * t347
  t352 = t185 ** 2
  t358 = 0.1e1 / t52 / t228
  t359 = s0 * t358
  t364 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t178 - 0.11e2 / 0.9e1 * t359) * t44 * t48
  t365 = f.my_piecewise3(t76, t364, 0)
  t373 = 0.1e1 / t83 / t78
  t379 = t89 * t96
  t380 = t196 ** 2
  t381 = t88 * t380
  t384 = t90 * t201
  t390 = f.my_piecewise3(t76, 0, t364)
  t391 = t87 * t390
  t395 = 0.1e1 / t200 / t95
  t396 = t91 * t395
  t397 = t209 ** 2
  t400 = t87 * t93
  t409 = 0.3e1 * t203 * t390 + 0.24e2 * t205 * t380 + 0.3e1 * t206 * t390 + 0.6e1 * t400 * t380
  t412 = f.my_piecewise3(t75, -0.12e2 * t191 * t352 - 0.12e2 * t191 * t365 + 0.60e2 * t373 * t352 - 0.18e2 * t84 * t352 + 0.6e1 * t82 * t365 + 0.3e1 * t84 * t365, -0.12e2 * t384 * t197 * t209 + 0.6e1 * t195 * t380 + 0.6e1 * t195 * t391 + t202 * t409 - 0.24e2 * t379 * t381 - 0.2e1 * t396 * t397)
  t413 = t104 * t412
  t416 = t98 * t412
  t418 = 0.105e3 / 0.2e1 * t350 + 0.35e2 / 0.2e1 * t413 - 0.15e2 / 0.2e1 * t347 - 0.15e2 / 0.2e1 * t416
  t422 = t49 * t359 * t59
  t429 = t226 * t227 / t51 / t228 / t176 * t234
  t431 = t45 ** 2
  t432 = 0.1e1 / t431
  t434 = t432 * t227 * s0
  t435 = t228 ** 2
  t439 = 0.1e1 / t233 / t58
  t441 = t434 / t435 / t50 * t439
  t443 = 0.22e2 / 0.27e2 * t422 - t429 / 0.12e2 + t441 / 0.81e2
  t450 = t238 ** 2
  t463 = t64 * t450
  t465 = t116 * t443
  t467 = t63 * t443
  t473 = 0.105e3 / 0.2e1 * t463 + 0.35e2 / 0.2e1 * t465 - 0.15e2 / 0.2e1 * t450 - 0.15e2 / 0.2e1 * t467
  t474 = t473 * t98
  t480 = 0.401122209e-6 * t119 * t347 + 0.201895739e-6 * t66 * t418 + 0.318024096e-1 * t443 * t101 - 0.200957812e-6 * t238 * t217 + 0.1838634068e-5 * t280 * t212 - 0.1565454237e-1 * t450 * t101 - 0.340722258e-8 * t131 * t418 + 0.397324768e-8 * t119 * t418 + 0.453837246e-1 * t63 * t412 - 0.100478906e-6 * t443 * t113 - 0.69727705930000000000000000000000000000000000000000e-1 * t412 - 0.17025650782500000000000000000000000000000000000000e0 * t450 + 0.74243981175000000000000000000000000000000000000000e-1 * t463 + 0.24747993725000000000000000000000000000000000000000e-1 * t465 - 0.17025650782500000000000000000000000000000000000000e0 * t467 + 0.919317034e-6 * t474 - 0.1216676528e-1 * t238 * t261 + 0.1148635778e-6 * t280 * t261
  t487 = t63 * t450
  t489 = t64 * t443
  t496 = 0.15e2 * t487 + 0.15e2 / 0.2e1 * t489 - 0.11e2 / 0.9e1 * t422 + t429 / 0.8e1 - t441 / 0.54e2
  t501 = t98 * t347
  t503 = t99 * t412
  t506 = 0.15e2 * t501 + 0.15e2 / 0.2e1 * t503 - 0.3e1 / 0.2e1 * t412
  t527 = -0.222650139e-1 * t66 * t412 - 0.608338264e-2 * t443 * t107 + 0.574317889e-7 * t473 * t107 - 0.30169747200000000000000000000000000000000000000000e0 * t487 - 0.15084873600000000000000000000000000000000000000000e0 * t489 + 0.133707403e-6 * t496 * t101 - 0.1502248044e-5 * t131 * t347 - 0.549909413e-7 * t119 * t506 + 0.24767835050000000000000000000000000000000000000000e-2 * t413 - 0.1973847762e-5 * t450 * t107 + 0.74303505150000000000000000000000000000000000000000e-2 * t350 - 0.549909413e-7 * t496 * t107 - 0.681444516e-8 * t280 * t217 - 0.1099818826e-6 * t268 * t261 + 0.397324768e-8 * t496 * t113 - 0.100478906e-6 * t63 * t418 - 0.657949254e-6 * t66 * t506 + 0.907674492e-1 * t238 * t212
  t533 = t443 * t98
  t564 = -0.1565454237e-1 * t66 * t347 + 0.794649536e-8 * t268 * t217 + 0.453837246e-1 * t533 - 0.3004496088e-5 * t291 * t212 - 0.1502248044e-5 * t132 * t412 - 0.1565454237e-1 * t149 * t412 + 0.1908144576e0 * t293 * t212 + 0.605687217e-6 * t467 * t113 + 0.401122209e-6 * t120 * t412 - 0.1335900834e0 * t239 * t212 - 0.1973847762e-5 * t467 * t107 - 0.1565454237e-1 * t467 * t101 + 0.954072288e-1 * t140 * t412 + 0.1211374434e-5 * t239 * t217 - 0.667950417e-1 * t467 * t98 - 0.3947695524e-5 * t239 * t261 + 0.802244418e-6 * t269 * t212 + 0.11877076297777777777777777777777777777777777777778e0 * t422
  t570 = t496 * t98
  t575 = t450 * t98
  t595 = -0.12147009850000000000000000000000000000000000000000e-1 * t429 + 0.605687217e-6 * t450 * t113 + 0.954072288e-1 * t63 * t347 + 0.192374554e-1 * t570 + 0.43536371955000000000000000000000000000000000000000e-1 * t347 - 0.9392725422e-1 * t239 * t215 - 0.667950417e-1 * t575 + 0.21119121300000000000000000000000000000000000000000e-1 * t501 + 0.10559560650000000000000000000000000000000000000000e-1 * t503 + 0.574317889e-7 * t131 * t506 + 0.17995570148148148148148148148148148148148148148148e-2 * t441 - 0.340722258e-8 * t473 * t113 + 0.919317034e-6 * t131 * t412 - 0.608338264e-2 * t63 * t506 + 0.192374554e-1 * t119 * t412 + 0.43536371955000000000000000000000000000000000000000e-1 * t416 - 0.500749348e-6 * t473 * t101 + 0.384749108e-1 * t268 * t212
  t597 = t480 + t527 + t564 + t595
  t602 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t160 - t5 * t169 * t160 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t173 * t328 + t5 * t338 * t160 / 0.12e2 - t5 * t342 * t328 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t346 * t597)
  t604 = r1 <= f.p.dens_threshold
  t605 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t606 = 0.1e1 + t605
  t607 = t606 <= f.p.zeta_threshold
  t608 = t606 ** (0.1e1 / 0.3e1)
  t609 = t608 ** 2
  t610 = 0.1e1 / t609
  t612 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t613 = t612 ** 2
  t617 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t621 = f.my_piecewise3(t607, 0, 0.4e1 / 0.9e1 * t610 * t613 + 0.4e1 / 0.3e1 * t608 * t617)
  t623 = r1 ** (0.1e1 / 0.3e1)
  t624 = t623 ** 2
  t628 = r1 ** 2
  t631 = s2 / t624 / t628
  t636 = 0.5e1 / 0.9e1 * (tau1 / t624 / r1 - t631 / 0.8e1) * t44 * t48
  t638 = 0.1e5 < t636
  t639 = f.my_piecewise3(t638, t636, 0.1e5)
  t640 = t639 ** 2
  t645 = t640 ** 2
  t649 = f.my_piecewise3(t638, 0.1e5, t636)
  t650 = t649 ** 2
  t651 = 0.1e1 - t650
  t652 = t651 ** 2
  t654 = t650 * t649
  t660 = f.my_piecewise3(0.1e5 <= t636, 0.1e1 - 0.3e1 / t640 - 0.1e1 / t640 / t639 + 0.3e1 / t645, -t652 * t651 / (0.1e1 + t654 * (0.1e1 + t654)))
  t661 = t660 ** 2
  t662 = t661 ** 2
  t669 = t49 * t631 / (0.65124e1 + t49 * t631 / 0.24e2)
  t671 = t669 / 0.12e2 - 0.1e1
  t672 = t671 ** 2
  t673 = t672 * t671
  t677 = 0.5e1 / 0.2e1 * t673 - t669 / 0.8e1 + 0.3e1 / 0.2e1
  t679 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t661
  t683 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t672
  t686 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t662 - 0.15e2 / 0.4e1 * t661
  t689 = t661 * t660
  t692 = 0.5e1 / 0.2e1 * t689 - 0.3e1 / 0.2e1 * t660
  t707 = t672 ** 2
  t710 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t707 - 0.15e2 / 0.4e1 * t672
  t713 = 0.61919587625000000000000000000000000000000000000000e-3 * t662 - 0.50282912000000000000000000000000000000000000000000e-1 * t673 + 0.133707403e-6 * t677 * t679 + 0.201895739e-6 * t683 * t686 - 0.657949254e-6 * t683 * t692 - 0.222650139e-1 * t683 * t660 - 0.521818079e-2 * t683 * t679 - 0.100478906e-6 * t671 * t686 + 0.318024096e-1 * t671 * t679 - 0.608338264e-2 * t671 * t692 + 0.453837246e-1 * t671 * t660 - 0.340722258e-8 * t710 * t686
  t732 = 0.10451438955835000000000000000000000000000000000000e1 + 0.574317889e-7 * t710 * t692 + 0.919317034e-6 * t710 * t660 - 0.500749348e-6 * t710 * t679 + 0.397324768e-8 * t677 * t686 - 0.549909413e-7 * t677 * t692 + 0.192374554e-1 * t677 * t660 - 0.85128253912500000000000000000000000000000000000000e-1 * t672 + 0.35198535500000000000000000000000000000000000000000e-2 * t689 - 0.69727705930000000000000000000000000000000000000000e-1 * t660 + 0.21768185977500000000000000000000000000000000000000e-1 * t661 + 0.12147009850000000000000000000000000000000000000000e-1 * t669 + 0.61869984312500000000000000000000000000000000000000e-2 * t707
  t733 = t713 + t732
  t739 = f.my_piecewise3(t607, 0, 0.4e1 / 0.3e1 * t608 * t612)
  t745 = f.my_piecewise3(t607, t333, t608 * t606)
  t751 = f.my_piecewise3(t604, 0, -0.3e1 / 0.8e1 * t5 * t621 * t42 * t733 - t5 * t739 * t168 * t733 / 0.4e1 + t5 * t745 * t337 * t733 / 0.12e2)
  t761 = t24 ** 2
  t765 = 0.6e1 * t33 - 0.6e1 * t16 / t761
  t766 = f.my_piecewise5(t10, 0, t14, 0, t765)
  t770 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t766)
  t793 = 0.1e1 / t167 / t24
  t810 = t352 * t185
  t817 = t228 * r0
  t820 = s0 / t52 / t817
  t825 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * tau0 * t358 + 0.154e3 / 0.27e2 * t820) * t44 * t48
  t826 = f.my_piecewise3(t76, t825, 0)
  t845 = t380 * t196
  t846 = t92 * t845
  t873 = t196 * t390
  t876 = f.my_piecewise3(t76, 0, t825)
  t880 = t200 ** 2
  t903 = 0.48e2 * t846 * t96 + 0.72e2 * t89 * t201 * t381 * t209 - 0.72e2 * t379 * t87 * t845 - 0.72e2 * t379 * t88 * t196 * t390 + 0.36e2 * t90 * t395 * t197 * t397 - 0.18e2 * t384 * t380 * t209 - 0.18e2 * t384 * t391 * t209 - 0.18e2 * t384 * t197 * t409 + 0.18e2 * t195 * t873 + 0.6e1 * t195 * t87 * t876 + 0.6e1 * t91 / t880 * t397 * t209 - 0.6e1 * t396 * t209 * t409 + t202 * (0.72e2 * t205 * t196 * t390 + 0.3e1 * t203 * t876 + 0.3e1 * t206 * t876 + 0.18e2 * t400 * t873 + 0.6e1 * t845 * t93 + 0.114e3 * t846)
  t904 = f.my_piecewise3(t75, 0.72e2 * t191 * t810 - 0.54e2 * t188 * t365 + 0.6e1 * t82 * t826 + 0.60e2 * t373 * t810 - 0.36e2 * t192 * t365 + 0.3e1 * t84 * t826 - 0.360e3 / t83 / t81 * t810 + 0.180e3 * t373 * t185 * t365 - 0.12e2 * t191 * t826, t903)
  t911 = t450 * t238
  t912 = t63 * t911
  t914 = t264 * t443
  t917 = t49 * t820 * t59
  t923 = t226 * t227 / t51 / t435 * t234
  t928 = t434 / t435 / t176 * t439
  t930 = t227 ** 2
  t936 = t233 ** 2
  t940 = t432 * t930 / t52 / t435 / t817 / t936 * t44 * t48
  t942 = -0.308e3 / 0.81e2 * t917 + 0.341e3 / 0.486e3 * t923 - 0.19e2 / 0.81e2 * t928 + t940 / 0.243e3
  t943 = t116 * t942
  t945 = t238 * t443
  t947 = t63 * t942
  t949 = 0.105e3 * t912 + 0.315e3 / 0.2e1 * t914 + 0.35e2 / 0.2e1 * t943 - 0.45e2 / 0.2e1 * t945 - 0.15e2 / 0.2e1 * t947
  t952 = t99 * t904
  t954 = t347 * t212
  t956 = t416 * t212
  t960 = 0.15e2 * t954 + 0.45e2 * t956 + 0.15e2 / 0.2e1 * t952 - 0.3e1 / 0.2e1 * t904
  t967 = t98 * t954
  t969 = t258 * t412
  t971 = t104 * t904
  t973 = t212 * t412
  t975 = t98 * t904
  t977 = 0.105e3 * t967 + 0.315e3 / 0.2e1 * t969 + 0.35e2 / 0.2e1 * t971 - 0.45e2 / 0.2e1 * t973 - 0.15e2 / 0.2e1 * t975
  t980 = -0.14089088133e0 * t575 * t212 - 0.5921543286e-5 * t312 * t443 + 0.2862216864e0 * t293 * t412 + 0.401122209e-6 * t120 * t904 - 0.4506744132e-5 * t474 * t212 - 0.5921543286e-5 * t239 * t506 - 0.340722258e-8 * t949 * t113 + 0.10559560650000000000000000000000000000000000000000e-1 * t952 + 0.574317889e-7 * t131 * t960 + 0.318024096e-1 * t942 * t101 + 0.1361511738e0 * t238 * t412 - 0.100478906e-6 * t63 * t977
  t992 = t239 * t443
  t994 = t64 * t942
  t1000 = 0.15e2 * t911 + 0.45e2 * t992 + 0.15e2 / 0.2e1 * t994 + 0.154e3 / 0.27e2 * t917 - 0.341e3 / 0.324e3 * t923 + 0.19e2 / 0.54e2 * t928 - t940 / 0.162e3
  t1015 = 0.453837246e-1 * t63 * t904 + 0.192374554e-1 * t119 * t904 + 0.2757951102e-5 * t280 * t412 - 0.2003851251e0 * t450 * t212 - 0.222650139e-1 * t66 * t904 - 0.549909413e-7 * t1000 * t107 + 0.2862216864e0 * t238 * t347 + 0.192374554e-1 * t1000 * t98 + 0.1722953667e-6 * t280 * t506 - 0.69727705930000000000000000000000000000000000000000e-1 * t904 + 0.59985233827160493827160493827160493827160493827160e-3 * t940 + 0.574317889e-7 * t949 * t107 + 0.1203366627e-5 * t268 * t347
  t1041 = -0.1022166774e-7 * t473 * t217 - 0.500749348e-6 * t949 * t101 - 0.1825014792e-1 * t238 * t506 + 0.577123662e-1 * t496 * t212 - 0.1973847762e-5 * t947 * t107 - 0.5921543286e-5 * t467 * t261 + 0.1817061651e-5 * t239 * t418 + 0.1203366627e-5 * t286 * t412 + 0.1203366627e-5 * t570 * t212 + 0.1817061651e-5 * t467 * t217 + 0.954072288e-1 * t140 * t904 - 0.2003851251e0 * t239 * t412
  t1065 = 0.63357363900000000000000000000000000000000000000000e-1 * t956 - 0.4696362711e-1 * t300 * t443 - 0.55426356056296296296296296296296296296296296296297e0 * t917 + 0.10227482367530864197530864197530864197530864197531e0 * t923 - 0.657949254e-6 * t66 * t960 + 0.919317034e-6 * t131 * t904 - 0.1825014792e-1 * t443 * t261 - 0.301436718e-6 * t443 * t217 - 0.608338264e-2 * t63 * t960 - 0.608338264e-2 * t942 * t107 + 0.133707403e-6 * t1000 * t101 - 0.1649728239e-6 * t496 * t261 - 0.1649728239e-6 * t268 * t506
  t1089 = 0.24767835050000000000000000000000000000000000000000e-2 * t971 + 0.13060911586500000000000000000000000000000000000000e0 * t973 + 0.43536371955000000000000000000000000000000000000000e-1 * t975 + 0.201895739e-6 * t66 * t977 + 0.1361511738e0 * t443 * t212 - 0.14089088133e0 * t467 * t215 - 0.14089088133e0 * t239 * t416 - 0.1565454237e-1 * t947 * t101 - 0.1565454237e-1 * t149 * t904 + 0.2862216864e0 * t533 * t212 - 0.667950417e-1 * t947 * t98 - 0.2003851251e0 * t467 * t212
  t1110 = -0.4506744132e-5 * t291 * t412 + 0.2862216864e0 * t318 * t412 - 0.4506744132e-5 * t275 * t412 - 0.4696362711e-1 * t324 * t412 + 0.577123662e-1 * t268 * t412 - 0.15084873600000000000000000000000000000000000000000e0 * t994 + 0.397324768e-8 * t1000 * t113 + 0.14860701030000000000000000000000000000000000000000e-1 * t967 - 0.2003851251e0 * t293 * t443 + 0.22273194352500000000000000000000000000000000000000e0 * t914 - 0.34191583281481481481481481481481481481481481481481e-1 * t928 - 0.30169747200000000000000000000000000000000000000000e0 * t911 - 0.90509241600000000000000000000000000000000000000000e0 * t992
  t1132 = 0.22291051545000000000000000000000000000000000000000e-1 * t969 + 0.21119121300000000000000000000000000000000000000000e-1 * t954 - 0.1022166774e-7 * t280 * t418 + 0.1191974304e-7 * t496 * t217 + 0.453837246e-1 * t942 * t98 + 0.1191974304e-7 * t268 * t418 - 0.4506744132e-5 * t280 * t347 - 0.100478906e-6 * t942 * t113 + 0.14848796235000000000000000000000000000000000000000e0 * t912 + 0.24747993725000000000000000000000000000000000000000e-1 * t943 - 0.51076952347500000000000000000000000000000000000000e0 * t945 - 0.17025650782500000000000000000000000000000000000000e0 * t947 + 0.919317034e-6 * t949 * t98
  t1159 = 0.1817061651e-5 * t450 * t217 + 0.1722953667e-6 * t473 * t261 + 0.397324768e-8 * t119 * t977 - 0.549909413e-7 * t119 * t960 - 0.301436718e-6 * t238 * t418 - 0.5921543286e-5 * t450 * t261 + 0.2757951102e-5 * t473 * t212 - 0.340722258e-8 * t131 * t977 + 0.1817061651e-5 * t945 * t113 + 0.605687217e-6 * t947 * t113 - 0.14089088133e0 * t239 * t347 - 0.1502248044e-5 * t132 * t904 + 0.1203366627e-5 * t269 * t412
  t1167 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t770 * t42 * t160 - 0.3e1 / 0.8e1 * t5 * t41 * t168 * t160 - 0.9e1 / 0.8e1 * t5 * t43 * t328 + t5 * t166 * t337 * t160 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t169 * t328 - 0.9e1 / 0.8e1 * t5 * t173 * t597 - 0.5e1 / 0.36e2 * t5 * t335 * t793 * t160 + t5 * t338 * t328 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t342 * t597 - 0.3e1 / 0.8e1 * t5 * t346 * (t980 + t1015 + t1041 + t1065 + t1089 + t1110 + t1132 + t1159))
  t1177 = f.my_piecewise5(t14, 0, t10, 0, -t765)
  t1181 = f.my_piecewise3(t607, 0, -0.8e1 / 0.27e2 / t609 / t606 * t613 * t612 + 0.4e1 / 0.3e1 * t610 * t612 * t617 + 0.4e1 / 0.3e1 * t608 * t1177)
  t1199 = f.my_piecewise3(t604, 0, -0.3e1 / 0.8e1 * t5 * t1181 * t42 * t733 - 0.3e1 / 0.8e1 * t5 * t621 * t168 * t733 + t5 * t739 * t337 * t733 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t745 * t793 * t733)
  d111 = 0.3e1 * t602 + 0.3e1 * t751 + t6 * (t1167 + t1199)

  res = {'v3rho3': d111}
  return res
