"""Generated from mgga_x_vt84.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_mu = MU_GE

  params_b = 0.4

  params_c = 2.14951

  params_e = 1.987

  vt84_gamma = 2.3e-05

  tpss_ff = lambda z=None: 3

  tpss_p = lambda x: X2S ** 2 * x ** 2

  tpss_z = lambda x, t: x ** 2 / (8 * t)

  tpss_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tpss_kappa = lambda x=None, t=None: 1 / (vt84_gamma / params_mu ** 2 + vt84_gamma / params_mu + 1)

  tpss_fxden = lambda x: (1 + jnp.sqrt(params_e) * tpss_p(x)) ** 2

  tpss_qb = lambda x, t: 9 / 20 * (tpss_alpha(x, t) - 1) / jnp.sqrt(1 + params_b * tpss_alpha(x, t) * (tpss_alpha(x, t) - 1)) + 2 * tpss_p(x) / 3

  tpss_fxnum = lambda x, t: +(MU_GE + params_c * tpss_z(x, t) ** tpss_ff(tpss_z(x, t)) / (1 + tpss_z(x, t) ** 2) ** 2) * tpss_p(x) + 146 / 2025 * tpss_qb(x, t) ** 2 - 73 / 405 * tpss_qb(x, t) * jnp.sqrt(1 / 2 * (9 / 25 * tpss_z(x, t) ** 2 + tpss_p(x) ** 2)) + MU_GE ** 2 / tpss_kappa(x, t) * tpss_p(x) ** 2 + 2 * jnp.sqrt(params_e) * MU_GE * 9 / 25 * tpss_z(x, t) ** 2 + params_e * params_mu * tpss_p(x) ** 3

  tpss_fx = lambda x, t: tpss_fxnum(x, t) / tpss_fxden(x)

  vt84_f = lambda x, u, t: 1 + tpss_fx(x, t) * jnp.exp(-vt84_gamma * tpss_fx(x, t) / params_mu) / (1 + tpss_fx(x, t)) + (1 - jnp.exp(-vt84_gamma * tpss_fx(x, t) ** 2 / params_mu ** 2)) * (params_mu / tpss_fx(x, t) - 1)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, vt84_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_mu = MU_GE

  params_b = 0.4

  params_c = 2.14951

  params_e = 1.987

  vt84_gamma = 2.3e-05

  tpss_ff = lambda z=None: 3

  tpss_p = lambda x: X2S ** 2 * x ** 2

  tpss_z = lambda x, t: x ** 2 / (8 * t)

  tpss_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tpss_kappa = lambda x=None, t=None: 1 / (vt84_gamma / params_mu ** 2 + vt84_gamma / params_mu + 1)

  tpss_fxden = lambda x: (1 + jnp.sqrt(params_e) * tpss_p(x)) ** 2

  tpss_qb = lambda x, t: 9 / 20 * (tpss_alpha(x, t) - 1) / jnp.sqrt(1 + params_b * tpss_alpha(x, t) * (tpss_alpha(x, t) - 1)) + 2 * tpss_p(x) / 3

  tpss_fxnum = lambda x, t: +(MU_GE + params_c * tpss_z(x, t) ** tpss_ff(tpss_z(x, t)) / (1 + tpss_z(x, t) ** 2) ** 2) * tpss_p(x) + 146 / 2025 * tpss_qb(x, t) ** 2 - 73 / 405 * tpss_qb(x, t) * jnp.sqrt(1 / 2 * (9 / 25 * tpss_z(x, t) ** 2 + tpss_p(x) ** 2)) + MU_GE ** 2 / tpss_kappa(x, t) * tpss_p(x) ** 2 + 2 * jnp.sqrt(params_e) * MU_GE * 9 / 25 * tpss_z(x, t) ** 2 + params_e * params_mu * tpss_p(x) ** 3

  tpss_fx = lambda x, t: tpss_fxnum(x, t) / tpss_fxden(x)

  vt84_f = lambda x, u, t: 1 + tpss_fx(x, t) * jnp.exp(-vt84_gamma * tpss_fx(x, t) / params_mu) / (1 + tpss_fx(x, t)) + (1 - jnp.exp(-vt84_gamma * tpss_fx(x, t) ** 2 / params_mu ** 2)) * (params_mu / tpss_fx(x, t) - 1)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, vt84_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_mu = MU_GE

  params_b = 0.4

  params_c = 2.14951

  params_e = 1.987

  vt84_gamma = 2.3e-05

  tpss_ff = lambda z=None: 3

  tpss_p = lambda x: X2S ** 2 * x ** 2

  tpss_z = lambda x, t: x ** 2 / (8 * t)

  tpss_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tpss_kappa = lambda x=None, t=None: 1 / (vt84_gamma / params_mu ** 2 + vt84_gamma / params_mu + 1)

  tpss_fxden = lambda x: (1 + jnp.sqrt(params_e) * tpss_p(x)) ** 2

  tpss_qb = lambda x, t: 9 / 20 * (tpss_alpha(x, t) - 1) / jnp.sqrt(1 + params_b * tpss_alpha(x, t) * (tpss_alpha(x, t) - 1)) + 2 * tpss_p(x) / 3

  tpss_fxnum = lambda x, t: +(MU_GE + params_c * tpss_z(x, t) ** tpss_ff(tpss_z(x, t)) / (1 + tpss_z(x, t) ** 2) ** 2) * tpss_p(x) + 146 / 2025 * tpss_qb(x, t) ** 2 - 73 / 405 * tpss_qb(x, t) * jnp.sqrt(1 / 2 * (9 / 25 * tpss_z(x, t) ** 2 + tpss_p(x) ** 2)) + MU_GE ** 2 / tpss_kappa(x, t) * tpss_p(x) ** 2 + 2 * jnp.sqrt(params_e) * MU_GE * 9 / 25 * tpss_z(x, t) ** 2 + params_e * params_mu * tpss_p(x) ** 3

  tpss_fx = lambda x, t: tpss_fxnum(x, t) / tpss_fxden(x)

  vt84_f = lambda x, u, t: 1 + tpss_fx(x, t) * jnp.exp(-vt84_gamma * tpss_fx(x, t) / params_mu) / (1 + tpss_fx(x, t)) + (1 - jnp.exp(-vt84_gamma * tpss_fx(x, t) ** 2 / params_mu ** 2)) * (params_mu / tpss_fx(x, t) - 1)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, vt84_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = s0 ** 2
  t29 = t28 * s0
  t30 = r0 ** 2
  t31 = t30 * r0
  t32 = 0.1e1 / t31
  t33 = t29 * t32
  t34 = tau0 ** 2
  t36 = 0.1e1 / t34 / tau0
  t37 = 0.1e1 / t30
  t38 = t28 * t37
  t39 = 0.1e1 / t34
  t40 = t38 * t39
  t42 = 0.1e1 + t40 / 0.64e2
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = t36 * t44
  t49 = 6 ** (0.1e1 / 0.3e1)
  t50 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t33 * t45) * t49
  t51 = jnp.pi ** 2
  t52 = t51 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t54 = 0.1e1 / t53
  t55 = t54 * s0
  t56 = r0 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t59 = 0.1e1 / t57 / t30
  t60 = t55 * t59
  t64 = 0.1e1 / t57 / r0
  t66 = s0 * t59
  t68 = tau0 * t64 - t66 / 0.8e1
  t69 = t68 * t49
  t70 = t69 * t54
  t72 = t70 / 0.4e1 - 0.9e1 / 0.20e2
  t75 = t54 * (0.5e1 / 0.9e1 * t70 - 0.1e1)
  t78 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t69 * t75
  t79 = jnp.sqrt(t78)
  t80 = 0.1e1 / t79
  t81 = t72 * t80
  t82 = t49 * t54
  t83 = t82 * t66
  t85 = t81 + t83 / 0.36e2
  t86 = t85 ** 2
  t90 = 0.73e2 / 0.405e3 * t81 + 0.73e2 / 0.14580e5 * t83
  t92 = t49 ** 2
  t94 = 0.1e1 / t52 / t51
  t95 = t92 * t94
  t96 = t30 ** 2
  t97 = t96 * r0
  t99 = 0.1e1 / t56 / t97
  t101 = t95 * t28 * t99
  t104 = jnp.sqrt(0.162e3 * t40 + 0.50e2 * t101)
  t109 = t51 ** 2
  t110 = 0.1e1 / t109
  t111 = t110 * t29
  t112 = t96 ** 2
  t113 = 0.1e1 / t112
  t116 = t50 * t60 / 0.24e2 + 0.146e3 / 0.2025e4 * t86 - t90 * t104 / 0.240e3 + 0.26505934954444613795322528747311554810411691984623e-4 * t101 + 0.19577914932045745128340760441650611428917366896281e-2 * t40 + 0.10647076474622770919067215363511659807956104252401e-3 * t111 * t113
  t118 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t83
  t119 = t118 ** 2
  t120 = 0.1e1 / t119
  t121 = t116 * t120
  t123 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t121)
  t124 = 0.1e1 + t121
  t125 = 0.1e1 / t124
  t126 = t123 * t125
  t128 = t116 ** 2
  t129 = t119 ** 2
  t130 = 0.1e1 / t129
  t133 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t128 * t130)
  t134 = 0.1e1 - t133
  t135 = 0.1e1 / t116
  t138 = 0.10e2 / 0.81e2 * t135 * t119 - 0.1e1
  t140 = t121 * t126 + t134 * t138 + 0.1e1
  t144 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t140)
  t145 = r1 <= f.p.dens_threshold
  t146 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t147 = 0.1e1 + t146
  t148 = t147 <= f.p.zeta_threshold
  t149 = t147 ** (0.1e1 / 0.3e1)
  t151 = f.my_piecewise3(t148, t22, t149 * t147)
  t152 = t151 * t26
  t153 = s2 ** 2
  t154 = t153 * s2
  t155 = r1 ** 2
  t156 = t155 * r1
  t157 = 0.1e1 / t156
  t158 = t154 * t157
  t159 = tau1 ** 2
  t161 = 0.1e1 / t159 / tau1
  t162 = 0.1e1 / t155
  t163 = t153 * t162
  t164 = 0.1e1 / t159
  t165 = t163 * t164
  t167 = 0.1e1 + t165 / 0.64e2
  t168 = t167 ** 2
  t169 = 0.1e1 / t168
  t170 = t161 * t169
  t174 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t158 * t170) * t49
  t175 = t54 * s2
  t176 = r1 ** (0.1e1 / 0.3e1)
  t177 = t176 ** 2
  t179 = 0.1e1 / t177 / t155
  t180 = t175 * t179
  t184 = 0.1e1 / t177 / r1
  t186 = s2 * t179
  t188 = tau1 * t184 - t186 / 0.8e1
  t189 = t188 * t49
  t190 = t189 * t54
  t192 = t190 / 0.4e1 - 0.9e1 / 0.20e2
  t195 = t54 * (0.5e1 / 0.9e1 * t190 - 0.1e1)
  t198 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t189 * t195
  t199 = jnp.sqrt(t198)
  t200 = 0.1e1 / t199
  t201 = t192 * t200
  t202 = t82 * t186
  t204 = t201 + t202 / 0.36e2
  t205 = t204 ** 2
  t209 = 0.73e2 / 0.405e3 * t201 + 0.73e2 / 0.14580e5 * t202
  t211 = t155 ** 2
  t212 = t211 * r1
  t214 = 0.1e1 / t176 / t212
  t216 = t95 * t153 * t214
  t219 = jnp.sqrt(0.162e3 * t165 + 0.50e2 * t216)
  t224 = t110 * t154
  t225 = t211 ** 2
  t226 = 0.1e1 / t225
  t229 = t174 * t180 / 0.24e2 + 0.146e3 / 0.2025e4 * t205 - t209 * t219 / 0.240e3 + 0.26505934954444613795322528747311554810411691984623e-4 * t216 + 0.19577914932045745128340760441650611428917366896281e-2 * t165 + 0.10647076474622770919067215363511659807956104252401e-3 * t224 * t226
  t231 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t202
  t232 = t231 ** 2
  t233 = 0.1e1 / t232
  t234 = t229 * t233
  t236 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t234)
  t237 = 0.1e1 + t234
  t238 = 0.1e1 / t237
  t239 = t236 * t238
  t241 = t229 ** 2
  t242 = t232 ** 2
  t243 = 0.1e1 / t242
  t246 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t241 * t243)
  t247 = 0.1e1 - t246
  t248 = 0.1e1 / t229
  t251 = 0.10e2 / 0.81e2 * t248 * t232 - 0.1e1
  t253 = t234 * t239 + t247 * t251 + 0.1e1
  t257 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t152 * t253)
  t258 = t6 ** 2
  t260 = t16 / t258
  t261 = t7 - t260
  t262 = f.my_piecewise5(t10, 0, t14, 0, t261)
  t265 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t262)
  t270 = t26 ** 2
  t271 = 0.1e1 / t270
  t275 = t5 * t25 * t271 * t140 / 0.8e1
  t280 = t28 ** 2
  t281 = t280 * s0
  t282 = t96 * t30
  t285 = t34 ** 2
  t289 = 0.1e1 / t43 / t42
  t290 = 0.1e1 / t285 / tau0 * t289
  t298 = 0.1e1 / t57 / t31
  t299 = t55 * t298
  t304 = s0 * t298
  t306 = -0.5e1 / 0.3e1 * tau0 * t59 + t304 / 0.3e1
  t307 = t306 * t49
  t308 = t54 * t80
  t309 = t307 * t308
  t313 = t72 / t79 / t78
  t316 = t68 * t92
  t321 = t313 * (0.22222222222222222222222222222222222222222222222222e0 * t307 * t75 + 0.12345679012345679012345679012345679012345679012346e0 * t316 * t94 * t306)
  t323 = t82 * t304
  t335 = t90 / t104
  t336 = t28 * t32
  t337 = t336 * t39
  t342 = t95 * t28 / t56 / t282
  t353 = (-0.12594785156250000000000000000000000000000000000000e-1 * t29 / t96 * t45 + 0.26239135742187500000000000000000000000000000000000e-3 * t281 / t282 * t290) * t49 * t60 / 0.24e2 - t50 * t299 / 0.9e1 + 0.292e3 / 0.2025e4 * t85 * (t309 / 0.4e1 - t321 / 0.2e1 - 0.2e1 / 0.27e2 * t323) - (0.73e2 / 0.1620e4 * t309 - 0.73e2 / 0.810e3 * t321 - 0.146e3 / 0.10935e5 * t323) * t104 / 0.240e3 - t335 * (-0.324e3 * t337 - 0.800e3 / 0.3e1 * t342) / 0.480e3 - 0.14136498642370460690838681998566162565552902391799e-3 * t342 - 0.39155829864091490256681520883301222857834733792562e-2 * t337 - 0.85176611796982167352537722908093278463648834019208e-3 * t111 / t112 / r0
  t354 = t353 * t120
  t358 = t116 / t119 / t118
  t364 = t358 * t49 * t299
  t370 = t124 ** 2
  t372 = t123 / t370
  t377 = t116 * t130
  t382 = t128 / t129 / t118
  t389 = 0.1e1 / t128
  t390 = t389 * t119
  t393 = t135 * t118
  t404 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t265 * t26 * t140 - t275 - 0.3e1 / 0.8e1 * t5 * t27 * (t354 * t126 + 0.31324663891273192205345216706640978286267787034050e0 * t358 * t126 * t323 + t121 * (-0.18630000000000000000000000000000000000000000000000e-3 * t354 - 0.58357848829441957078558138724472142547316887244435e-4 * t364) * t123 * t125 - t121 * t372 * (t354 + 0.31324663891273192205345216706640978286267787034050e0 * t364) - (-0.30180600000000000000000000000000000000000000000000e-2 * t377 * t353 - 0.94539715103695970467264184733644870926653357335985e-3 * t382 * t49 * t299) * t133 * t138 + t134 * (-0.10e2 / 0.81e2 * t390 * t353 - 0.38672424557127397784376810748939479365762700042037e-1 * t393 * t49 * t299)))
  t406 = f.my_piecewise5(t14, 0, t10, 0, -t261)
  t409 = f.my_piecewise3(t148, 0, 0.4e1 / 0.3e1 * t149 * t406)
  t417 = t5 * t151 * t271 * t253 / 0.8e1
  t419 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t409 * t26 * t253 - t417)
  vrho_0_ = t144 + t257 + t6 * (t404 + t419)
  t422 = -t7 - t260
  t423 = f.my_piecewise5(t10, 0, t14, 0, t422)
  t426 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t423)
  t432 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t426 * t26 * t140 - t275)
  t434 = f.my_piecewise5(t14, 0, t10, 0, -t422)
  t437 = f.my_piecewise3(t148, 0, 0.4e1 / 0.3e1 * t149 * t434)
  t446 = t153 ** 2
  t447 = t446 * s2
  t448 = t211 * t155
  t451 = t159 ** 2
  t455 = 0.1e1 / t168 / t167
  t456 = 0.1e1 / t451 / tau1 * t455
  t464 = 0.1e1 / t177 / t156
  t465 = t175 * t464
  t470 = s2 * t464
  t472 = -0.5e1 / 0.3e1 * tau1 * t179 + t470 / 0.3e1
  t473 = t472 * t49
  t474 = t54 * t200
  t475 = t473 * t474
  t479 = t192 / t199 / t198
  t482 = t188 * t92
  t487 = t479 * (0.22222222222222222222222222222222222222222222222222e0 * t473 * t195 + 0.12345679012345679012345679012345679012345679012346e0 * t482 * t94 * t472)
  t489 = t82 * t470
  t501 = t209 / t219
  t502 = t153 * t157
  t503 = t502 * t164
  t508 = t95 * t153 / t176 / t448
  t519 = (-0.12594785156250000000000000000000000000000000000000e-1 * t154 / t211 * t170 + 0.26239135742187500000000000000000000000000000000000e-3 * t447 / t448 * t456) * t49 * t180 / 0.24e2 - t174 * t465 / 0.9e1 + 0.292e3 / 0.2025e4 * t204 * (t475 / 0.4e1 - t487 / 0.2e1 - 0.2e1 / 0.27e2 * t489) - (0.73e2 / 0.1620e4 * t475 - 0.73e2 / 0.810e3 * t487 - 0.146e3 / 0.10935e5 * t489) * t219 / 0.240e3 - t501 * (-0.324e3 * t503 - 0.800e3 / 0.3e1 * t508) / 0.480e3 - 0.14136498642370460690838681998566162565552902391799e-3 * t508 - 0.39155829864091490256681520883301222857834733792562e-2 * t503 - 0.85176611796982167352537722908093278463648834019208e-3 * t224 / t225 / r1
  t520 = t519 * t233
  t524 = t229 / t232 / t231
  t530 = t524 * t49 * t465
  t536 = t237 ** 2
  t538 = t236 / t536
  t543 = t229 * t243
  t548 = t241 / t242 / t231
  t555 = 0.1e1 / t241
  t556 = t555 * t232
  t559 = t248 * t231
  t570 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t437 * t26 * t253 - t417 - 0.3e1 / 0.8e1 * t5 * t152 * (t520 * t239 + 0.31324663891273192205345216706640978286267787034050e0 * t524 * t239 * t489 + t234 * (-0.18630000000000000000000000000000000000000000000000e-3 * t520 - 0.58357848829441957078558138724472142547316887244435e-4 * t530) * t236 * t238 - t234 * t538 * (t520 + 0.31324663891273192205345216706640978286267787034050e0 * t530) - (-0.30180600000000000000000000000000000000000000000000e-2 * t543 * t519 - 0.94539715103695970467264184733644870926653357335985e-3 * t548 * t49 * t465) * t246 * t251 + t247 * (-0.10e2 / 0.81e2 * t556 * t519 - 0.38672424557127397784376810748939479365762700042037e-1 * t559 * t49 * t465)))
  vrho_1_ = t144 + t257 + t6 * (t432 + t570)
  t575 = 0.1e1 / t97
  t586 = t59 * t49
  t587 = t586 * t308
  t595 = t313 * (-0.27777777777777777777777777777777777777777777777778e-1 * t586 * t75 - 0.15432098765432098765432098765432098765432098765432e-1 * t316 * t94 * t59)
  t597 = t586 * t54
  t609 = s0 * t37 * t39
  t612 = t95 * s0 * t99
  t622 = (0.12594785156250000000000000000000000000000000000000e-1 * t336 * t45 - 0.26239135742187500000000000000000000000000000000000e-3 * t280 * t575 * t290) * t49 * t60 / 0.24e2 + t50 * t54 * t59 / 0.24e2 + 0.292e3 / 0.2025e4 * t85 * (-t587 / 0.32e2 - t595 / 0.2e1 + t597 / 0.36e2) - (-0.73e2 / 0.12960e5 * t587 - 0.73e2 / 0.810e3 * t595 + 0.73e2 / 0.14580e5 * t597) * t104 / 0.240e3 - t335 * (0.324e3 * t609 + 0.100e3 * t612) / 0.480e3 + 0.53011869908889227590645057494623109620823383969246e-4 * t612 + 0.39155829864091490256681520883301222857834733792562e-2 * t609 + 0.31941229423868312757201646090534979423868312757203e-3 * t110 * t28 * t113
  t623 = t622 * t120
  t631 = t358 * t597
  t658 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t623 * t126 - 0.11746748959227447077004456264990366857350420137768e0 * t358 * t123 * t125 * t59 * t82 + t121 * (-0.18630000000000000000000000000000000000000000000000e-3 * t623 + 0.21884193311040733904459302021677053455243832716662e-4 * t631) * t123 * t125 - t121 * t372 * (t623 - 0.11746748959227447077004456264990366857350420137768e0 * t631) - (-0.30180600000000000000000000000000000000000000000000e-2 * t377 * t622 + 0.35452393163885988925224069275116826597495009000994e-3 * t382 * t597) * t133 * t138 + t134 * (-0.10e2 / 0.81e2 * t390 * t622 + 0.14502159208922774169141304030852304762161012515763e-1 * t393 * t597)))
  vsigma_0_ = t6 * t658
  vsigma_1_ = 0.0e0
  t661 = 0.1e1 / t212
  t672 = t179 * t49
  t673 = t672 * t474
  t681 = t479 * (-0.27777777777777777777777777777777777777777777777778e-1 * t672 * t195 - 0.15432098765432098765432098765432098765432098765432e-1 * t482 * t94 * t179)
  t683 = t672 * t54
  t695 = s2 * t162 * t164
  t698 = t95 * s2 * t214
  t708 = (0.12594785156250000000000000000000000000000000000000e-1 * t502 * t170 - 0.26239135742187500000000000000000000000000000000000e-3 * t446 * t661 * t456) * t49 * t180 / 0.24e2 + t174 * t54 * t179 / 0.24e2 + 0.292e3 / 0.2025e4 * t204 * (-t673 / 0.32e2 - t681 / 0.2e1 + t683 / 0.36e2) - (-0.73e2 / 0.12960e5 * t673 - 0.73e2 / 0.810e3 * t681 + 0.73e2 / 0.14580e5 * t683) * t219 / 0.240e3 - t501 * (0.324e3 * t695 + 0.100e3 * t698) / 0.480e3 + 0.53011869908889227590645057494623109620823383969246e-4 * t698 + 0.39155829864091490256681520883301222857834733792562e-2 * t695 + 0.31941229423868312757201646090534979423868312757203e-3 * t110 * t153 * t226
  t709 = t708 * t233
  t717 = t524 * t683
  t744 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t152 * (t709 * t239 - 0.11746748959227447077004456264990366857350420137768e0 * t524 * t236 * t238 * t179 * t82 + t234 * (-0.18630000000000000000000000000000000000000000000000e-3 * t709 + 0.21884193311040733904459302021677053455243832716662e-4 * t717) * t236 * t238 - t234 * t538 * (t709 - 0.11746748959227447077004456264990366857350420137768e0 * t717) - (-0.30180600000000000000000000000000000000000000000000e-2 * t543 * t708 + 0.35452393163885988925224069275116826597495009000994e-3 * t548 * t683) * t246 * t251 + t247 * (-0.10e2 / 0.81e2 * t556 * t708 + 0.14502159208922774169141304030852304762161012515763e-1 * t559 * t683)))
  vsigma_2_ = t6 * t744
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t759 = t64 * t49
  t760 = t759 * t308
  t768 = t313 * (0.22222222222222222222222222222222222222222222222222e0 * t759 * t75 + 0.12345679012345679012345679012345679012345679012346e0 * t316 * t94 * t64)
  t778 = t38 * t36
  t782 = (-0.12594785156250000000000000000000000000000000000000e-1 * t33 / t285 * t44 + 0.26239135742187500000000000000000000000000000000000e-3 * t281 * t575 / t285 / t34 * t289) * t49 * t60 / 0.24e2 + 0.292e3 / 0.2025e4 * t85 * (t760 / 0.4e1 - t768 / 0.2e1) - (0.73e2 / 0.1620e4 * t760 - 0.73e2 / 0.810e3 * t768) * t104 / 0.240e3 + 0.27e2 / 0.40e2 * t335 * t778 - 0.39155829864091490256681520883301222857834733792562e-2 * t778
  t803 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t782 * t120 * t126 - 0.18630000000000000000000000000000000000000000000000e-3 * t377 * t782 * t123 * t125 - t377 * t372 * t782 + 0.30180600000000000000000000000000000000000000000000e-2 * t377 * t782 * t133 * t138 - 0.10e2 / 0.81e2 * t134 * t389 * t119 * t782))
  vtau_0_ = t6 * t803
  t818 = t184 * t49
  t819 = t818 * t474
  t827 = t479 * (0.22222222222222222222222222222222222222222222222222e0 * t818 * t195 + 0.12345679012345679012345679012345679012345679012346e0 * t482 * t94 * t184)
  t837 = t163 * t161
  t841 = (-0.12594785156250000000000000000000000000000000000000e-1 * t158 / t451 * t169 + 0.26239135742187500000000000000000000000000000000000e-3 * t447 * t661 / t451 / t159 * t455) * t49 * t180 / 0.24e2 + 0.292e3 / 0.2025e4 * t204 * (t819 / 0.4e1 - t827 / 0.2e1) - (0.73e2 / 0.1620e4 * t819 - 0.73e2 / 0.810e3 * t827) * t219 / 0.240e3 + 0.27e2 / 0.40e2 * t501 * t837 - 0.39155829864091490256681520883301222857834733792562e-2 * t837
  t862 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t152 * (t841 * t233 * t239 - 0.18630000000000000000000000000000000000000000000000e-3 * t543 * t841 * t236 * t238 - t543 * t538 * t841 + 0.30180600000000000000000000000000000000000000000000e-2 * t543 * t841 * t246 * t251 - 0.10e2 / 0.81e2 * t247 * t555 * t232 * t841))
  vtau_1_ = t6 * t862
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_mu = MU_GE

  params_b = 0.4

  params_c = 2.14951

  params_e = 1.987

  vt84_gamma = 2.3e-05

  tpss_ff = lambda z=None: 3

  tpss_p = lambda x: X2S ** 2 * x ** 2

  tpss_z = lambda x, t: x ** 2 / (8 * t)

  tpss_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tpss_kappa = lambda x=None, t=None: 1 / (vt84_gamma / params_mu ** 2 + vt84_gamma / params_mu + 1)

  tpss_fxden = lambda x: (1 + jnp.sqrt(params_e) * tpss_p(x)) ** 2

  tpss_qb = lambda x, t: 9 / 20 * (tpss_alpha(x, t) - 1) / jnp.sqrt(1 + params_b * tpss_alpha(x, t) * (tpss_alpha(x, t) - 1)) + 2 * tpss_p(x) / 3

  tpss_fxnum = lambda x, t: +(MU_GE + params_c * tpss_z(x, t) ** tpss_ff(tpss_z(x, t)) / (1 + tpss_z(x, t) ** 2) ** 2) * tpss_p(x) + 146 / 2025 * tpss_qb(x, t) ** 2 - 73 / 405 * tpss_qb(x, t) * jnp.sqrt(1 / 2 * (9 / 25 * tpss_z(x, t) ** 2 + tpss_p(x) ** 2)) + MU_GE ** 2 / tpss_kappa(x, t) * tpss_p(x) ** 2 + 2 * jnp.sqrt(params_e) * MU_GE * 9 / 25 * tpss_z(x, t) ** 2 + params_e * params_mu * tpss_p(x) ** 3

  tpss_fx = lambda x, t: tpss_fxnum(x, t) / tpss_fxden(x)

  vt84_f = lambda x, u, t: 1 + tpss_fx(x, t) * jnp.exp(-vt84_gamma * tpss_fx(x, t) / params_mu) / (1 + tpss_fx(x, t)) + (1 - jnp.exp(-vt84_gamma * tpss_fx(x, t) ** 2 / params_mu ** 2)) * (params_mu / tpss_fx(x, t) - 1)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, vt84_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = s0 ** 2
  t21 = t20 * s0
  t22 = r0 ** 2
  t23 = t22 * r0
  t24 = 0.1e1 / t23
  t25 = t21 * t24
  t26 = tau0 ** 2
  t28 = 0.1e1 / t26 / tau0
  t29 = 0.1e1 / t22
  t30 = t20 * t29
  t31 = 0.1e1 / t26
  t32 = t30 * t31
  t34 = 0.1e1 + t32 / 0.64e2
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t28 * t36
  t41 = 6 ** (0.1e1 / 0.3e1)
  t42 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t25 * t37) * t41
  t43 = jnp.pi ** 2
  t44 = t43 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t46 = 0.1e1 / t45
  t47 = t42 * t46
  t48 = 2 ** (0.1e1 / 0.3e1)
  t49 = t48 ** 2
  t50 = s0 * t49
  t51 = t18 ** 2
  t53 = 0.1e1 / t51 / t22
  t54 = t50 * t53
  t57 = tau0 * t49
  t59 = 0.1e1 / t51 / r0
  t62 = t57 * t59 - t54 / 0.8e1
  t63 = t62 * t41
  t64 = t63 * t46
  t66 = t64 / 0.4e1 - 0.9e1 / 0.20e2
  t68 = 0.5e1 / 0.9e1 * t64 - 0.1e1
  t69 = t46 * t68
  t72 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t63 * t69
  t73 = jnp.sqrt(t72)
  t74 = 0.1e1 / t73
  t75 = t66 * t74
  t76 = t41 * t46
  t77 = t76 * t54
  t79 = t75 + t77 / 0.36e2
  t80 = t79 ** 2
  t84 = 0.73e2 / 0.405e3 * t75 + 0.73e2 / 0.14580e5 * t77
  t86 = t41 ** 2
  t88 = 0.1e1 / t44 / t43
  t89 = t86 * t88
  t90 = t20 * t48
  t91 = t22 ** 2
  t92 = t91 * r0
  t94 = 0.1e1 / t18 / t92
  t96 = t89 * t90 * t94
  t99 = jnp.sqrt(0.162e3 * t32 + 0.100e3 * t96)
  t104 = t43 ** 2
  t105 = 0.1e1 / t104
  t106 = t105 * t21
  t107 = t91 ** 2
  t108 = 0.1e1 / t107
  t111 = t47 * t54 / 0.24e2 + 0.146e3 / 0.2025e4 * t80 - t84 * t99 / 0.240e3 + 0.53011869908889227590645057494623109620823383969247e-4 * t96 + 0.19577914932045745128340760441650611428917366896281e-2 * t32 + 0.42588305898491083676268861454046639231824417009602e-3 * t106 * t108
  t113 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t77
  t114 = t113 ** 2
  t115 = 0.1e1 / t114
  t116 = t111 * t115
  t118 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t116)
  t119 = 0.1e1 + t116
  t120 = 0.1e1 / t119
  t121 = t118 * t120
  t123 = t111 ** 2
  t124 = t114 ** 2
  t125 = 0.1e1 / t124
  t128 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t123 * t125)
  t129 = 0.1e1 - t128
  t130 = 0.1e1 / t111
  t133 = 0.10e2 / 0.81e2 * t130 * t114 - 0.1e1
  t135 = t116 * t121 + t129 * t133 + 0.1e1
  t139 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t135)
  t149 = t20 ** 2
  t150 = t149 * s0
  t151 = t91 * t22
  t154 = t26 ** 2
  t158 = 0.1e1 / t35 / t34
  t159 = 0.1e1 / t154 / tau0 * t158
  t168 = 0.1e1 / t51 / t23
  t169 = t50 * t168
  t175 = -0.5e1 / 0.3e1 * t57 * t53 + t169 / 0.3e1
  t176 = t175 * t41
  t178 = t176 * t46 * t74
  t182 = t66 / t73 / t72
  t185 = t62 * t86
  t190 = t182 * (0.22222222222222222222222222222222222222222222222222e0 * t176 * t69 + 0.12345679012345679012345679012345679012345679012346e0 * t185 * t88 * t175)
  t192 = t76 * t169
  t204 = t84 / t99
  t205 = t20 * t24
  t206 = t205 * t31
  t211 = t89 * t90 / t18 / t151
  t222 = (-0.12594785156250000000000000000000000000000000000000e-1 * t21 / t91 * t37 + 0.26239135742187500000000000000000000000000000000000e-3 * t150 / t151 * t159) * t41 * t46 * t54 / 0.24e2 - t47 * t169 / 0.9e1 + 0.292e3 / 0.2025e4 * t79 * (t178 / 0.4e1 - t190 / 0.2e1 - 0.2e1 / 0.27e2 * t192) - (0.73e2 / 0.1620e4 * t178 - 0.73e2 / 0.810e3 * t190 - 0.146e3 / 0.10935e5 * t192) * t99 / 0.240e3 - t204 * (-0.324e3 * t206 - 0.1600e4 / 0.3e1 * t211) / 0.480e3 - 0.28272997284740921381677363997132325131105804783598e-3 * t211 - 0.39155829864091490256681520883301222857834733792562e-2 * t206 - 0.34070644718792866941015089163237311385459533607682e-2 * t106 / t107 / r0
  t223 = t222 * t115
  t227 = t111 / t114 / t113
  t228 = t227 * t121
  t235 = t46 * s0 * t49 * t168
  t236 = t227 * t41 * t235
  t242 = t119 ** 2
  t244 = t118 / t242
  t249 = t111 * t125
  t254 = t123 / t124 / t113
  t261 = 0.1e1 / t123
  t262 = t261 * t114
  t265 = t130 * t113
  t276 = f.my_piecewise3(t2, 0, -t6 * t17 / t51 * t135 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t223 * t121 + 0.31324663891273192205345216706640978286267787034050e0 * t228 * t192 + t116 * (-0.18630000000000000000000000000000000000000000000000e-3 * t223 - 0.58357848829441957078558138724472142547316887244435e-4 * t236) * t118 * t120 - t116 * t244 * (t223 + 0.31324663891273192205345216706640978286267787034050e0 * t236) - (-0.30180600000000000000000000000000000000000000000000e-2 * t249 * t222 - 0.94539715103695970467264184733644870926653357335985e-3 * t254 * t41 * t235) * t128 * t133 + t129 * (-0.10e2 / 0.81e2 * t262 * t222 - 0.38672424557127397784376810748939479365762700042037e-1 * t265 * t41 * t235)))
  vrho_0_ = 0.2e1 * r0 * t276 + 0.2e1 * t139
  t281 = 0.1e1 / t92
  t294 = t49 * t53
  t295 = t76 * t74
  t296 = t294 * t295
  t298 = t76 * t68
  t301 = t88 * t49
  t306 = t182 * (-0.27777777777777777777777777777777777777777777777778e-1 * t294 * t298 - 0.15432098765432098765432098765432098765432098765432e-1 * t185 * t301 * t53)
  t308 = t294 * t76
  t320 = s0 * t29 * t31
  t324 = t89 * s0 * t48 * t94
  t334 = (0.12594785156250000000000000000000000000000000000000e-1 * t205 * t37 - 0.26239135742187500000000000000000000000000000000000e-3 * t149 * t281 * t159) * t41 * t46 * t54 / 0.24e2 + t42 * t46 * t49 * t53 / 0.24e2 + 0.292e3 / 0.2025e4 * t79 * (-t296 / 0.32e2 - t306 / 0.2e1 + t308 / 0.36e2) - (-0.73e2 / 0.12960e5 * t296 - 0.73e2 / 0.810e3 * t306 + 0.73e2 / 0.14580e5 * t308) * t99 / 0.240e3 - t204 * (0.324e3 * t320 + 0.200e3 * t324) / 0.480e3 + 0.10602373981777845518129011498924621924164676793849e-3 * t324 + 0.39155829864091490256681520883301222857834733792562e-2 * t320 + 0.12776491769547325102880658436213991769547325102881e-2 * t105 * t20 * t108
  t335 = t334 * t115
  t342 = t53 * t41 * t46
  t343 = t227 * t49 * t342
  t372 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t335 * t121 - 0.11746748959227447077004456264990366857350420137768e0 * t228 * t308 + t116 * (-0.18630000000000000000000000000000000000000000000000e-3 * t335 + 0.21884193311040733904459302021677053455243832716662e-4 * t343) * t118 * t120 - t116 * t244 * (t335 - 0.11746748959227447077004456264990366857350420137768e0 * t343) - (-0.30180600000000000000000000000000000000000000000000e-2 * t249 * t334 + 0.35452393163885988925224069275116826597495009000994e-3 * t254 * t49 * t342) * t128 * t133 + t129 * (-0.10e2 / 0.81e2 * t262 * t334 + 0.14502159208922774169141304030852304762161012515763e-1 * t265 * t49 * t342)))
  vsigma_0_ = 0.2e1 * r0 * t372
  vlapl_0_ = 0.0e0
  t389 = t49 * t59
  t390 = t389 * t295
  t398 = t182 * (0.22222222222222222222222222222222222222222222222222e0 * t389 * t298 + 0.12345679012345679012345679012345679012345679012346e0 * t185 * t301 * t59)
  t408 = t30 * t28
  t412 = (-0.12594785156250000000000000000000000000000000000000e-1 * t25 / t154 * t36 + 0.26239135742187500000000000000000000000000000000000e-3 * t150 * t281 / t154 / t26 * t158) * t41 * t46 * t54 / 0.24e2 + 0.292e3 / 0.2025e4 * t79 * (t390 / 0.4e1 - t398 / 0.2e1) - (0.73e2 / 0.1620e4 * t390 - 0.73e2 / 0.810e3 * t398) * t99 / 0.240e3 + 0.27e2 / 0.40e2 * t204 * t408 - 0.39155829864091490256681520883301222857834733792562e-2 * t408
  t433 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t412 * t115 * t121 - 0.18630000000000000000000000000000000000000000000000e-3 * t249 * t412 * t118 * t120 - t249 * t244 * t412 + 0.30180600000000000000000000000000000000000000000000e-2 * t249 * t412 * t128 * t133 - 0.10e2 / 0.81e2 * t129 * t261 * t114 * t412))
  vtau_0_ = 0.2e1 * r0 * t433
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = s0 ** 2
  t23 = t22 * s0
  t24 = r0 ** 2
  t25 = t24 * r0
  t26 = 0.1e1 / t25
  t28 = tau0 ** 2
  t29 = t28 * tau0
  t33 = 0.1e1 / t28
  t34 = t22 / t24 * t33
  t36 = 0.1e1 + t34 / 0.64e2
  t37 = t36 ** 2
  t39 = 0.1e1 / t29 / t37
  t43 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t23 * t26 * t39) * t43 * t48
  t50 = 2 ** (0.1e1 / 0.3e1)
  t51 = t50 ** 2
  t52 = s0 * t51
  t54 = 0.1e1 / t19 / t24
  t55 = t52 * t54
  t58 = tau0 * t51
  t60 = 0.1e1 / t19 / r0
  t63 = t58 * t60 - t55 / 0.8e1
  t64 = t63 * t43
  t67 = 0.5e1 / 0.9e1 * t64 * t48 - 0.1e1
  t68 = t48 * t67
  t71 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t64 * t68
  t72 = jnp.sqrt(t71)
  t73 = 0.1e1 / t72
  t76 = t43 * t48
  t77 = t76 * t55
  t79 = 0.9e1 / 0.20e2 * t67 * t73 + t77 / 0.36e2
  t80 = t79 ** 2
  t83 = t43 ** 2
  t85 = 0.1e1 / t46 / t45
  t86 = t83 * t85
  t87 = t22 * t50
  t88 = t24 ** 2
  t89 = t88 * r0
  t93 = t86 * t87 / t18 / t89
  t95 = 0.162e3 * t34 + 0.100e3 * t93
  t96 = jnp.sqrt(t95)
  t101 = t45 ** 2
  t103 = 0.1e1 / t101 * t23
  t104 = t88 ** 2
  t108 = t49 * t55 / 0.24e2 + 0.146e3 / 0.2025e4 * t80 - 0.73e2 / 0.97200e5 * t79 * t96 + 0.53011869908889227590645057494623109620823383969246e-4 * t93 + 0.19577914932045745128340760441650611428917366896280e-2 * t34 + 0.42588305898491083676268861454046639231824417009604e-3 * t103 / t104
  t110 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t77
  t111 = t110 ** 2
  t112 = 0.1e1 / t111
  t113 = t108 * t112
  t115 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t113)
  t116 = 0.1e1 + t113
  t117 = 0.1e1 / t116
  t118 = t115 * t117
  t120 = t108 ** 2
  t121 = t111 ** 2
  t122 = 0.1e1 / t121
  t125 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t120 * t122)
  t126 = 0.1e1 - t125
  t127 = 0.1e1 / t108
  t130 = 0.10e2 / 0.81e2 * t127 * t111 - 0.1e1
  t132 = t113 * t118 + t126 * t130 + 0.1e1
  t136 = t17 * t18
  t137 = 0.1e1 / t88
  t141 = t22 ** 2
  t142 = t141 * s0
  t143 = t88 * t24
  t146 = t28 ** 2
  t151 = 0.1e1 / t146 / tau0 / t37 / t36
  t156 = (-0.12594785156250000000000000000000000000000000000000e-1 * t23 * t137 * t39 + 0.26239135742187500000000000000000000000000000000000e-3 * t142 / t143 * t151) * t43 * t48
  t160 = 0.1e1 / t19 / t25
  t161 = t52 * t160
  t167 = -0.5e1 / 0.3e1 * t58 * t54 + t161 / 0.3e1
  t168 = t167 * t43
  t169 = t48 * t73
  t173 = 0.1e1 / t72 / t71
  t174 = t67 * t173
  t177 = t63 * t83
  t181 = 0.22222222222222222222222222222222222222222222222222e0 * t168 * t68 + 0.12345679012345679012345679012345679012345679012346e0 * t177 * t85 * t167
  t184 = t76 * t161
  t186 = t168 * t169 / 0.4e1 - 0.9e1 / 0.40e2 * t174 * t181 - 0.2e1 / 0.27e2 * t184
  t191 = 0.1e1 / t96
  t192 = t79 * t191
  t194 = t22 * t26 * t33
  t199 = t86 * t87 / t18 / t143
  t201 = -0.324e3 * t194 - 0.1600e4 / 0.3e1 * t199
  t207 = 0.1e1 / t104 / r0
  t210 = t156 * t55 / 0.24e2 - t49 * t161 / 0.9e1 + 0.292e3 / 0.2025e4 * t79 * t186 - 0.73e2 / 0.97200e5 * t186 * t96 - 0.73e2 / 0.194400e6 * t192 * t201 - 0.28272997284740921381677363997132325131105804783598e-3 * t199 - 0.39155829864091490256681520883301222857834733792560e-2 * t194 - 0.34070644718792866941015089163237311385459533607683e-2 * t103 * t207
  t211 = t210 * t112
  t214 = 0.1e1 / t111 / t110
  t215 = t108 * t214
  t216 = t215 * t118
  t220 = t215 * t43
  t221 = t48 * s0
  t222 = t51 * t160
  t223 = t221 * t222
  t224 = t220 * t223
  t226 = -0.18630000000000000000000000000000000000000000000000e-3 * t211 - 0.58357848829441957078558138724472142547316887244435e-4 * t224
  t228 = t226 * t115 * t117
  t230 = t116 ** 2
  t232 = t115 / t230
  t234 = t211 + 0.31324663891273192205345216706640978286267787034050e0 * t224
  t235 = t232 * t234
  t237 = t108 * t122
  t241 = 0.1e1 / t121 / t110
  t243 = t120 * t241 * t43
  t246 = -0.30180600000000000000000000000000000000000000000000e-2 * t237 * t210 - 0.94539715103695970467264184733644870926653357335985e-3 * t243 * t223
  t247 = t246 * t125
  t249 = 0.1e1 / t120
  t250 = t249 * t111
  t254 = t127 * t110 * t43
  t257 = -0.10e2 / 0.81e2 * t250 * t210 - 0.38672424557127397784376810748939479365762700042037e-1 * t254 * t223
  t259 = t211 * t118 + 0.31324663891273192205345216706640978286267787034050e0 * t216 * t184 + t113 * t228 - t113 * t235 - t247 * t130 + t126 * t257
  t264 = f.my_piecewise3(t2, 0, -t6 * t21 * t132 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t136 * t259)
  t277 = t88 * t25
  t286 = t37 ** 2
  t299 = 0.1e1 / t19 / t88
  t300 = t52 * t299
  t303 = t186 ** 2
  t308 = 0.40e2 / 0.9e1 * t58 * t160 - 0.11e2 / 0.9e1 * t300
  t309 = t308 * t43
  t316 = t71 ** 2
  t320 = t181 ** 2
  t325 = t167 ** 2
  t335 = t76 * t300
  t337 = t309 * t169 / 0.4e1 - t168 * t48 * t173 * t181 / 0.4e1 + 0.27e2 / 0.80e2 * t67 / t72 / t316 * t320 - 0.9e1 / 0.40e2 * t174 * (0.22222222222222222222222222222222222222222222222222e0 * t309 * t68 + 0.24691358024691358024691358024691358024691358024692e0 * t325 * t83 * t85 + 0.12345679012345679012345679012345679012345679012346e0 * t177 * t85 * t308) + 0.22e2 / 0.81e2 * t335
  t348 = t201 ** 2
  t352 = t22 * t137 * t33
  t355 = 0.1e1 / t18 / t277
  t356 = t87 * t355
  t357 = t86 * t356
  t368 = (0.50379140625000000000000000000000000000000000000000e-1 * t23 / t89 * t39 - 0.23615222167968750000000000000000000000000000000000e-2 * t142 / t277 * t151 + 0.24599189758300781250000000000000000000000000000000e-4 * t141 * t23 * t207 / t146 / t29 / t286) * t43 * t48 * t55 / 0.24e2 - 0.2e1 / 0.9e1 * t156 * t161 + 0.11e2 / 0.27e2 * t49 * t300 + 0.292e3 / 0.2025e4 * t303 + 0.292e3 / 0.2025e4 * t79 * t337 - 0.73e2 / 0.97200e5 * t337 * t96 - 0.73e2 / 0.97200e5 * t186 * t191 * t201 + 0.73e2 / 0.388800e6 * t79 / t96 / t95 * t348 - 0.73e2 / 0.194400e6 * t192 * (0.972e3 * t352 + 0.30400e5 / 0.9e1 * t357) + 0.17906231613669250208395663864850472583033676362945e-2 * t357 + 0.11746748959227447077004456264990366857350420137768e-1 * t352 + 0.30663580246913580246913580246913580246913580246915e-1 * t103 / t104 / t24
  t369 = t368 * t112
  t371 = t210 * t214
  t395 = t371 * t43 * t223
  t400 = t85 * t22 * t50 * t355
  t401 = t237 * t83 * t400
  t404 = t221 * t51 * t299
  t405 = t220 * t404
  t411 = t226 ** 2
  t421 = t234 ** 2
  t431 = t210 ** 2
  t435 = t210 * t43
  t452 = t246 ** 2
  t476 = t369 * t118 + 0.62649327782546384410690433413281956572535574068100e0 * t371 * t118 * t184 + 0.2e1 * t211 * t228 - 0.2e1 * t211 * t235 + 0.29437037037037037037037037037037037037037037037038e0 * t237 * t118 * t357 + 0.62649327782546384410690433413281956572535574068100e0 * t215 * t228 * t184 - 0.62649327782546384410690433413281956572535574068100e0 * t215 * t232 * t43 * t221 * t222 * t234 - 0.11485710093466837141959912792435025371631521912485e1 * t216 * t335 + t113 * (-0.18630000000000000000000000000000000000000000000000e-3 * t369 - 0.11671569765888391415711627744894428509463377448887e-3 * t395 - 0.54841200000000000000000000000000000000000000000002e-4 * t401 + 0.21397877904128717595471317532306452267349525322960e-3 * t405) * t115 * t117 + t113 * t411 * t115 * t117 - 0.2e1 * t113 * t226 * t235 + 0.2e1 * t113 * t115 / t230 / t116 * t421 - t113 * t232 * (t369 + 0.62649327782546384410690433413281956572535574068100e0 * t395 + 0.29437037037037037037037037037037037037037037037038e0 * t401 - 0.11485710093466837141959912792435025371631521912485e1 * t405) - (-0.30180600000000000000000000000000000000000000000000e-2 * t431 * t122 - 0.37815886041478388186905673893457948370661342934394e-2 * t108 * t241 * t435 * t223 - 0.30180600000000000000000000000000000000000000000000e-2 * t237 * t368 - 0.14807124000000000000000000000000000000000000000001e-2 * t120 / t121 / t111 * t83 * t400 + 0.34664562204688522504663534402336452673106231023195e-2 * t243 * t404) * t125 * t130 - t452 * t125 * t130 - 0.2e1 * t247 * t257 + t126 * (0.20e2 / 0.81e2 / t120 / t108 * t111 * t431 + 0.77344849114254795568753621497878958731525400084074e-1 * t249 * t110 * t435 * t223 - 0.10e2 / 0.81e2 * t250 * t368 + 0.12114007011126352690138698369151044048163389727176e-1 * t127 * t83 * t85 * t356 + 0.14179889004280045854271497274611142434112990015414e0 * t254 * t404)
  t481 = f.my_piecewise3(t2, 0, t6 * t17 * t60 * t132 / 0.12e2 - t6 * t21 * t259 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t136 * t476)
  v2rho2_0_ = 0.2e1 * r0 * t481 + 0.4e1 * t264
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = s0 ** 2
  t24 = t23 * s0
  t25 = r0 ** 2
  t26 = t25 * r0
  t27 = 0.1e1 / t26
  t29 = tau0 ** 2
  t30 = t29 * tau0
  t34 = 0.1e1 / t29
  t35 = t23 / t25 * t34
  t37 = 0.1e1 + t35 / 0.64e2
  t38 = t37 ** 2
  t40 = 0.1e1 / t30 / t38
  t44 = 6 ** (0.1e1 / 0.3e1)
  t46 = jnp.pi ** 2
  t47 = t46 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t50 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t24 * t27 * t40) * t44 * t49
  t51 = 2 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t53 = s0 * t52
  t55 = 0.1e1 / t19 / t25
  t56 = t53 * t55
  t59 = tau0 * t52
  t62 = t59 * t21 - t56 / 0.8e1
  t63 = t62 * t44
  t66 = 0.5e1 / 0.9e1 * t63 * t49 - 0.1e1
  t67 = t49 * t66
  t70 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t63 * t67
  t71 = jnp.sqrt(t70)
  t72 = 0.1e1 / t71
  t75 = t44 * t49
  t76 = t75 * t56
  t78 = 0.9e1 / 0.20e2 * t66 * t72 + t76 / 0.36e2
  t79 = t78 ** 2
  t82 = t44 ** 2
  t84 = 0.1e1 / t47 / t46
  t85 = t82 * t84
  t86 = t23 * t51
  t87 = t25 ** 2
  t88 = t87 * r0
  t92 = t85 * t86 / t18 / t88
  t94 = 0.162e3 * t35 + 0.100e3 * t92
  t95 = jnp.sqrt(t94)
  t100 = t46 ** 2
  t101 = 0.1e1 / t100
  t102 = t101 * t24
  t103 = t87 ** 2
  t104 = 0.1e1 / t103
  t107 = t50 * t56 / 0.24e2 + 0.146e3 / 0.2025e4 * t79 - 0.73e2 / 0.97200e5 * t78 * t95 + 0.53011869908889227590645057494623109620823383969246e-4 * t92 + 0.19577914932045745128340760441650611428917366896280e-2 * t35 + 0.42588305898491083676268861454046639231824417009604e-3 * t102 * t104
  t109 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t76
  t110 = t109 ** 2
  t111 = 0.1e1 / t110
  t112 = t107 * t111
  t114 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t112)
  t115 = 0.1e1 + t112
  t116 = 0.1e1 / t115
  t117 = t114 * t116
  t119 = t107 ** 2
  t120 = t110 ** 2
  t121 = 0.1e1 / t120
  t124 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t119 * t121)
  t125 = 0.1e1 - t124
  t126 = 0.1e1 / t107
  t129 = 0.10e2 / 0.81e2 * t126 * t110 - 0.1e1
  t131 = t112 * t117 + t125 * t129 + 0.1e1
  t136 = t17 / t19
  t137 = 0.1e1 / t87
  t141 = t23 ** 2
  t142 = t141 * s0
  t143 = t87 * t25
  t144 = 0.1e1 / t143
  t146 = t29 ** 2
  t151 = 0.1e1 / t146 / tau0 / t38 / t37
  t156 = (-0.12594785156250000000000000000000000000000000000000e-1 * t24 * t137 * t40 + 0.26239135742187500000000000000000000000000000000000e-3 * t142 * t144 * t151) * t44 * t49
  t160 = 0.1e1 / t19 / t26
  t161 = t53 * t160
  t167 = -0.5e1 / 0.3e1 * t59 * t55 + t161 / 0.3e1
  t168 = t167 * t44
  t169 = t49 * t72
  t173 = 0.1e1 / t71 / t70
  t174 = t66 * t173
  t177 = t62 * t82
  t178 = t84 * t167
  t181 = 0.22222222222222222222222222222222222222222222222222e0 * t168 * t67 + 0.12345679012345679012345679012345679012345679012346e0 * t177 * t178
  t184 = t75 * t161
  t186 = t168 * t169 / 0.4e1 - 0.9e1 / 0.40e2 * t174 * t181 - 0.2e1 / 0.27e2 * t184
  t191 = 0.1e1 / t95
  t192 = t78 * t191
  t194 = t23 * t27 * t34
  t199 = t85 * t86 / t18 / t143
  t201 = -0.324e3 * t194 - 0.1600e4 / 0.3e1 * t199
  t207 = 0.1e1 / t103 / r0
  t210 = t156 * t56 / 0.24e2 - t50 * t161 / 0.9e1 + 0.292e3 / 0.2025e4 * t78 * t186 - 0.73e2 / 0.97200e5 * t186 * t95 - 0.73e2 / 0.194400e6 * t192 * t201 - 0.28272997284740921381677363997132325131105804783598e-3 * t199 - 0.39155829864091490256681520883301222857834733792560e-2 * t194 - 0.34070644718792866941015089163237311385459533607683e-2 * t102 * t207
  t211 = t210 * t111
  t213 = t110 * t109
  t214 = 0.1e1 / t213
  t215 = t107 * t214
  t216 = t215 * t117
  t220 = t215 * t44
  t221 = t49 * s0
  t222 = t52 * t160
  t223 = t221 * t222
  t224 = t220 * t223
  t226 = -0.18630000000000000000000000000000000000000000000000e-3 * t211 - 0.58357848829441957078558138724472142547316887244435e-4 * t224
  t227 = t226 * t114
  t228 = t227 * t116
  t230 = t115 ** 2
  t231 = 0.1e1 / t230
  t232 = t114 * t231
  t234 = t211 + 0.31324663891273192205345216706640978286267787034050e0 * t224
  t235 = t232 * t234
  t237 = t107 * t121
  t241 = 0.1e1 / t120 / t109
  t243 = t119 * t241 * t44
  t246 = -0.30180600000000000000000000000000000000000000000000e-2 * t237 * t210 - 0.94539715103695970467264184733644870926653357335985e-3 * t243 * t223
  t247 = t246 * t124
  t249 = 0.1e1 / t119
  t250 = t249 * t110
  t254 = t126 * t109 * t44
  t257 = -0.10e2 / 0.81e2 * t250 * t210 - 0.38672424557127397784376810748939479365762700042037e-1 * t254 * t223
  t259 = t211 * t117 + 0.31324663891273192205345216706640978286267787034050e0 * t216 * t184 + t112 * t228 - t112 * t235 - t247 * t129 + t125 * t257
  t263 = t17 * t18
  t264 = 0.1e1 / t88
  t268 = t87 * t26
  t273 = t141 * t24
  t277 = t38 ** 2
  t279 = 0.1e1 / t146 / t30 / t277
  t284 = (0.50379140625000000000000000000000000000000000000000e-1 * t24 * t264 * t40 - 0.23615222167968750000000000000000000000000000000000e-2 * t142 / t268 * t151 + 0.24599189758300781250000000000000000000000000000000e-4 * t273 * t207 * t279) * t44 * t49
  t290 = 0.1e1 / t19 / t87
  t291 = t53 * t290
  t294 = t186 ** 2
  t299 = 0.40e2 / 0.9e1 * t59 * t160 - 0.11e2 / 0.9e1 * t291
  t300 = t299 * t44
  t303 = t49 * t173
  t304 = t303 * t181
  t307 = t70 ** 2
  t309 = 0.1e1 / t71 / t307
  t310 = t66 * t309
  t311 = t181 ** 2
  t316 = t167 ** 2
  t323 = 0.22222222222222222222222222222222222222222222222222e0 * t300 * t67 + 0.24691358024691358024691358024691358024691358024692e0 * t316 * t82 * t84 + 0.12345679012345679012345679012345679012345679012346e0 * t177 * t84 * t299
  t326 = t75 * t291
  t328 = t300 * t169 / 0.4e1 - t168 * t304 / 0.4e1 + 0.27e2 / 0.80e2 * t310 * t311 - 0.9e1 / 0.40e2 * t174 * t323 + 0.22e2 / 0.81e2 * t326
  t333 = t186 * t191
  t337 = 0.1e1 / t95 / t94
  t338 = t78 * t337
  t339 = t201 ** 2
  t343 = t23 * t137 * t34
  t346 = 0.1e1 / t18 / t268
  t347 = t86 * t346
  t348 = t85 * t347
  t350 = 0.972e3 * t343 + 0.30400e5 / 0.9e1 * t348
  t356 = 0.1e1 / t103 / t25
  t359 = t284 * t56 / 0.24e2 - 0.2e1 / 0.9e1 * t156 * t161 + 0.11e2 / 0.27e2 * t50 * t291 + 0.292e3 / 0.2025e4 * t294 + 0.292e3 / 0.2025e4 * t78 * t328 - 0.73e2 / 0.97200e5 * t328 * t95 - 0.73e2 / 0.97200e5 * t333 * t201 + 0.73e2 / 0.388800e6 * t338 * t339 - 0.73e2 / 0.194400e6 * t192 * t350 + 0.17906231613669250208395663864850472583033676362945e-2 * t348 + 0.11746748959227447077004456264990366857350420137768e-1 * t343 + 0.30663580246913580246913580246913580246913580246915e-1 * t102 * t356
  t360 = t359 * t111
  t362 = t210 * t214
  t363 = t362 * t117
  t370 = t237 * t117
  t373 = t215 * t228
  t376 = t232 * t44
  t377 = t215 * t376
  t378 = t222 * t234
  t379 = t221 * t378
  t385 = t362 * t44
  t386 = t385 * t223
  t388 = t237 * t82
  t389 = t84 * t23
  t390 = t51 * t346
  t391 = t389 * t390
  t392 = t388 * t391
  t394 = t52 * t290
  t395 = t221 * t394
  t396 = t220 * t395
  t398 = -0.18630000000000000000000000000000000000000000000000e-3 * t360 - 0.11671569765888391415711627744894428509463377448887e-3 * t386 - 0.54841200000000000000000000000000000000000000000002e-4 * t392 + 0.21397877904128717595471317532306452267349525322960e-3 * t396
  t400 = t398 * t114 * t116
  t402 = t226 ** 2
  t404 = t402 * t114 * t116
  t406 = t112 * t226
  t410 = 0.1e1 / t230 / t115
  t411 = t114 * t410
  t412 = t234 ** 2
  t413 = t411 * t412
  t419 = t360 + 0.62649327782546384410690433413281956572535574068100e0 * t386 + 0.29437037037037037037037037037037037037037037037038e0 * t392 - 0.11485710093466837141959912792435025371631521912485e1 * t396
  t420 = t232 * t419
  t422 = t210 ** 2
  t425 = t107 * t241
  t426 = t210 * t44
  t427 = t425 * t426
  t433 = 0.1e1 / t120 / t110
  t435 = t119 * t433 * t82
  t440 = -0.30180600000000000000000000000000000000000000000000e-2 * t422 * t121 - 0.37815886041478388186905673893457948370661342934394e-2 * t427 * t223 - 0.30180600000000000000000000000000000000000000000000e-2 * t237 * t359 - 0.14807124000000000000000000000000000000000000000001e-2 * t435 * t391 + 0.34664562204688522504663534402336452673106231023195e-2 * t243 * t395
  t441 = t440 * t124
  t443 = t246 ** 2
  t444 = t443 * t124
  t449 = 0.1e1 / t119 / t107
  t450 = t449 * t110
  t453 = t249 * t109
  t454 = t453 * t426
  t460 = t126 * t82 * t84
  t465 = 0.20e2 / 0.81e2 * t450 * t422 + 0.77344849114254795568753621497878958731525400084074e-1 * t454 * t223 - 0.10e2 / 0.81e2 * t250 * t359 + 0.12114007011126352690138698369151044048163389727176e-1 * t460 * t347 + 0.14179889004280045854271497274611142434112990015414e0 * t254 * t395
  t467 = t360 * t117 + 0.62649327782546384410690433413281956572535574068100e0 * t363 * t184 + 0.2e1 * t211 * t228 - 0.2e1 * t211 * t235 + 0.29437037037037037037037037037037037037037037037038e0 * t370 * t348 + 0.62649327782546384410690433413281956572535574068100e0 * t373 * t184 - 0.62649327782546384410690433413281956572535574068100e0 * t377 * t379 - 0.11485710093466837141959912792435025371631521912485e1 * t216 * t326 + t112 * t400 + t112 * t404 - 0.2e1 * t406 * t235 + 0.2e1 * t112 * t413 - t112 * t420 - t441 * t129 - t444 * t129 - 0.2e1 * t247 * t257 + t125 * t465
  t472 = f.my_piecewise3(t2, 0, t6 * t22 * t131 / 0.12e2 - t6 * t136 * t259 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t263 * t467)
  t487 = 0.1e1 / t103 / t26
  t498 = t359 * t214
  t502 = t210 * t121
  t507 = 0.1e1 / t18 / t103
  t508 = t86 * t507
  t509 = t85 * t508
  t513 = 0.1e1 / t19 / t88
  t514 = t53 * t513
  t515 = t75 * t514
  t520 = t230 ** 2
  t537 = t141 ** 2
  t542 = t146 ** 2
  t566 = -0.440e3 / 0.27e2 * t59 * t290 + 0.154e3 / 0.27e2 * t514
  t567 = t566 * t44
  t601 = t567 * t169 / 0.4e1 - 0.3e1 / 0.8e1 * t300 * t304 + 0.9e1 / 0.16e2 * t168 * t49 * t309 * t311 - 0.3e1 / 0.8e1 * t168 * t303 * t323 - 0.27e2 / 0.32e2 * t66 / t71 / t307 / t70 * t311 * t181 + 0.81e2 / 0.80e2 * t310 * t181 * t323 - 0.9e1 / 0.40e2 * t174 * (0.22222222222222222222222222222222222222222222222222e0 * t567 * t67 + 0.74074074074074074074074074074074074074074074074076e0 * t299 * t82 * t178 + 0.12345679012345679012345679012345679012345679012346e0 * t177 * t84 * t566) - 0.308e3 / 0.243e3 * t515
  t614 = t94 ** 2
  t625 = t23 * t264 * t34
  t633 = t102 * t487
  t635 = (-0.25189570312500000000000000000000000000000000000000e0 * t24 * t144 * t40 + 0.19679351806640625000000000000000000000000000000000e-1 * t142 * t104 * t151 - 0.44278541564941406250000000000000000000000000000000e-3 * t273 * t356 * t279 + 0.30748987197875976562500000000000000000000000000000e-5 * t537 * s0 / t103 / t87 / t542 / tau0 / t277 / t37) * t44 * t49 * t56 / 0.24e2 - t284 * t161 / 0.3e1 + 0.11e2 / 0.9e1 * t156 * t291 - 0.154e3 / 0.81e2 * t50 * t514 + 0.292e3 / 0.675e3 * t186 * t328 + 0.292e3 / 0.2025e4 * t78 * t601 - 0.73e2 / 0.97200e5 * t601 * t95 - 0.73e2 / 0.64800e5 * t328 * t191 * t201 + 0.73e2 / 0.129600e6 * t186 * t337 * t339 - 0.73e2 / 0.64800e5 * t333 * t350 - 0.73e2 / 0.259200e6 * t78 / t95 / t614 * t339 * t201 + 0.73e2 / 0.129600e6 * t338 * t201 * t350 - 0.73e2 / 0.194400e6 * t192 * (-0.3888e4 * t625 - 0.668800e6 / 0.27e2 * t509) - 0.13131236516690783486156820167557013227558029332826e-1 * t509 - 0.46986995836909788308017825059961467429401680551072e-1 * t625 - 0.30663580246913580246913580246913580246913580246915e0 * t633
  t636 = t635 * t111
  t639 = t498 * t44 * t223
  t642 = t502 * t82 * t391
  t644 = t385 * t395
  t646 = t425 * t633
  t649 = t389 * t51 * t507
  t650 = t388 * t649
  t653 = t221 * t52 * t513
  t654 = t220 * t653
  t698 = t359 * t44
  t718 = t112 * t398
  t721 = t112 * (-0.18630000000000000000000000000000000000000000000000e-3 * t636 - 0.17507354648832587123567441617341642764195066173330e-3 * t639 - 0.16452360000000000000000000000000000000000000000000e-3 * t642 + 0.64193633712386152786413952596919356802048575968879e-3 * t644 - 0.41229171777458193320922674362853741241428855095003e-3 * t646 + 0.60325320000000000000000000000000000000000000000002e-3 * t650 - 0.99856763552600682112199481817430110580964451507147e-3 * t654) * t114 * t116 - 0.3e1 * t112 * t402 * t235 - 0.3e1 * t406 * t420 - 0.6e1 * t211 * t226 * t235 + 0.6e1 * t112 * t114 * t410 * t234 * t419 + 0.6e1 * t406 * t413 + t636 * t117 + 0.6e1 * t211 * t413 - t112 * t232 * (t636 + 0.93973991673819576616035650119922934858803361102150e0 * t639 + 0.88311111111111111111111111111111111111111111111115e0 * t642 - 0.34457130280400511425879738377305076114894565737455e1 * t644 + 0.22130526987363496146496336211945110703933899675257e1 * t646 - 0.32380740740740740740740740740740740740740740740742e1 * t650 + 0.53599980436178573329146259698030118400947102258263e1 * t654) - (-0.90541800000000000000000000000000000000000000000000e-2 * t502 * t359 - 0.56723829062217582280358510840186922555992014401591e-2 * t422 * t241 * t44 * t223 - 0.88842744000000000000000000000000000000000000000005e-2 * t107 * t433 * t210 * t82 * t391 - 0.56723829062217582280358510840186922555992014401591e-2 * t425 * t698 * t223 + 0.20798737322813113502798120641401871603863738613917e-1 * t427 * t395 - 0.30180600000000000000000000000000000000000000000000e-2 * t237 * t635 - 0.16697814569870568294973683116955765202778686313477e-1 * t119 / t120 / t213 * t633 + 0.16287836400000000000000000000000000000000000000001e-1 * t435 * t649 - 0.16176795695521310502176316054423677914116241144158e-1 * t243 * t653) * t124 * t129 - 0.3e1 * t718 * t235
  t725 = t119 ** 2
  t823 = 0.93973991673819576616035650119922934858803361102150e0 * t215 * t404 * t184 + 0.18794798334763915323207130023984586971760672220430e1 * t215 * t411 * t44 * t221 * t222 * t412 + 0.34457130280400511425879738377305076114894565737455e1 * t377 * t221 * t394 * t234 - 0.3e1 * t211 * t420 + 0.3e1 * t211 * t404 + t112 * t402 * t226 * t114 * t116 - 0.3e1 * t440 * t246 * t124 * t129 - 0.3e1 * t444 * t257 - 0.3e1 * t441 * t257 - 0.18794798334763915323207130023984586971760672220430e1 * t215 * t227 * t231 * t75 * s0 * t378 - t443 * t246 * t124 * t129
  t830 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t55 * t131 + t6 * t22 * t259 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t136 * t467 - 0.3e1 / 0.8e1 * t6 * t263 * (0.22130526987363496146496336211945110703933899675257e1 * t425 * t114 * t116 * t101 * t24 * t487 - 0.3e1 * t247 * t465 + 0.3e1 * t360 * t228 + 0.3e1 * t211 * t400 + 0.93973991673819576616035650119922934858803361102150e0 * t498 * t117 * t184 + 0.88311111111111111111111111111111111111111111111115e0 * t502 * t117 * t348 - 0.32380740740740740740740740740740740740740740740742e1 * t370 * t509 + 0.53599980436178573329146259698030118400947102258263e1 * t216 * t515 - 0.34457130280400511425879738377305076114894565737455e1 * t363 * t326 - 0.6e1 * t112 * t114 / t520 * t412 * t234 + t721 - 0.3e1 * t360 * t235 + t125 * (-0.20e2 / 0.27e2 / t725 * t110 * t422 * t210 - 0.23203454734276438670626086449363687619457620025222e0 * t449 * t109 * t422 * t44 * t223 + 0.20e2 / 0.27e2 * t450 * t210 * t359 - 0.36342021033379058070416095107453132144490169181529e-1 * t249 * t82 * t84 * t86 * t346 * t210 + 0.11601727367138219335313043224681843809728810012611e0 * t453 * t698 * t223 - 0.42539667012840137562814491823833427302338970046241e0 * t454 * t395 - 0.10e2 / 0.81e2 * t250 * t635 - 0.13325407712238987959152568206066148452979728699894e0 * t460 * t508 - 0.66172815353306880653266987281518664692527286738599e0 * t254 * t653) + 0.3e1 * t718 * t228 + 0.88311111111111111111111111111111111111111111111115e0 * t237 * t228 * t348 + 0.93973991673819576616035650119922934858803361102150e0 * t215 * t400 * t184 - 0.93973991673819576616035650119922934858803361102150e0 * t377 * t221 * t222 * t419 - 0.18794798334763915323207130023984586971760672220430e1 * t362 * t376 * t379 + 0.18794798334763915323207130023984586971760672220430e1 * t362 * t228 * t184 - 0.88311111111111111111111111111111111111111111111115e0 * t237 * t232 * t82 * t389 * t390 * t234 - 0.34457130280400511425879738377305076114894565737455e1 * t373 * t326 + t823))
  v3rho3_0_ = 0.2e1 * r0 * t830 + 0.6e1 * t472

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = s0 ** 2
  t25 = t24 * s0
  t26 = t18 * r0
  t27 = 0.1e1 / t26
  t29 = tau0 ** 2
  t30 = t29 * tau0
  t34 = 0.1e1 / t29
  t35 = t24 / t18 * t34
  t37 = 0.1e1 + t35 / 0.64e2
  t38 = t37 ** 2
  t40 = 0.1e1 / t30 / t38
  t44 = 6 ** (0.1e1 / 0.3e1)
  t46 = jnp.pi ** 2
  t47 = t46 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t50 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t25 * t27 * t40) * t44 * t49
  t51 = 2 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t53 = s0 * t52
  t54 = t53 * t22
  t57 = tau0 * t52
  t59 = 0.1e1 / t20 / r0
  t62 = t57 * t59 - t54 / 0.8e1
  t63 = t62 * t44
  t66 = 0.5e1 / 0.9e1 * t63 * t49 - 0.1e1
  t67 = t49 * t66
  t70 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t63 * t67
  t71 = jnp.sqrt(t70)
  t72 = 0.1e1 / t71
  t75 = t44 * t49
  t76 = t75 * t54
  t78 = 0.9e1 / 0.20e2 * t66 * t72 + t76 / 0.36e2
  t79 = t78 ** 2
  t82 = t44 ** 2
  t84 = 0.1e1 / t47 / t46
  t85 = t82 * t84
  t86 = t24 * t51
  t87 = t18 ** 2
  t88 = t87 * r0
  t92 = t85 * t86 / t19 / t88
  t94 = 0.162e3 * t35 + 0.100e3 * t92
  t95 = jnp.sqrt(t94)
  t100 = t46 ** 2
  t101 = 0.1e1 / t100
  t102 = t101 * t25
  t103 = t87 ** 2
  t104 = 0.1e1 / t103
  t107 = t50 * t54 / 0.24e2 + 0.146e3 / 0.2025e4 * t79 - 0.73e2 / 0.97200e5 * t78 * t95 + 0.53011869908889227590645057494623109620823383969246e-4 * t92 + 0.19577914932045745128340760441650611428917366896280e-2 * t35 + 0.42588305898491083676268861454046639231824417009604e-3 * t102 * t104
  t109 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t76
  t110 = t109 ** 2
  t111 = 0.1e1 / t110
  t112 = t107 * t111
  t114 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t112)
  t115 = 0.1e1 + t112
  t116 = 0.1e1 / t115
  t117 = t114 * t116
  t119 = t107 ** 2
  t120 = t110 ** 2
  t121 = 0.1e1 / t120
  t124 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t119 * t121)
  t125 = 0.1e1 - t124
  t126 = 0.1e1 / t107
  t129 = 0.10e2 / 0.81e2 * t126 * t110 - 0.1e1
  t131 = t112 * t117 + t125 * t129 + 0.1e1
  t135 = t17 * t59
  t136 = 0.1e1 / t87
  t140 = t24 ** 2
  t141 = t140 * s0
  t142 = t87 * t18
  t143 = 0.1e1 / t142
  t145 = t29 ** 2
  t150 = 0.1e1 / t145 / tau0 / t38 / t37
  t155 = (-0.12594785156250000000000000000000000000000000000000e-1 * t25 * t136 * t40 + 0.26239135742187500000000000000000000000000000000000e-3 * t141 * t143 * t150) * t44 * t49
  t159 = 0.1e1 / t20 / t26
  t160 = t53 * t159
  t166 = -0.5e1 / 0.3e1 * t57 * t22 + t160 / 0.3e1
  t167 = t166 * t44
  t168 = t49 * t72
  t172 = 0.1e1 / t71 / t70
  t173 = t66 * t172
  t176 = t62 * t82
  t177 = t84 * t166
  t180 = 0.22222222222222222222222222222222222222222222222222e0 * t167 * t67 + 0.12345679012345679012345679012345679012345679012346e0 * t176 * t177
  t183 = t75 * t160
  t185 = t167 * t168 / 0.4e1 - 0.9e1 / 0.40e2 * t173 * t180 - 0.2e1 / 0.27e2 * t183
  t190 = 0.1e1 / t95
  t191 = t78 * t190
  t193 = t24 * t27 * t34
  t198 = t85 * t86 / t19 / t142
  t200 = -0.324e3 * t193 - 0.1600e4 / 0.3e1 * t198
  t205 = t103 * r0
  t206 = 0.1e1 / t205
  t209 = t155 * t54 / 0.24e2 - t50 * t160 / 0.9e1 + 0.292e3 / 0.2025e4 * t78 * t185 - 0.73e2 / 0.97200e5 * t185 * t95 - 0.73e2 / 0.194400e6 * t191 * t200 - 0.28272997284740921381677363997132325131105804783598e-3 * t198 - 0.39155829864091490256681520883301222857834733792560e-2 * t193 - 0.34070644718792866941015089163237311385459533607683e-2 * t102 * t206
  t210 = t209 * t111
  t212 = t110 * t109
  t213 = 0.1e1 / t212
  t214 = t107 * t213
  t215 = t214 * t117
  t219 = t214 * t44
  t220 = t49 * s0
  t221 = t52 * t159
  t222 = t220 * t221
  t223 = t219 * t222
  t225 = -0.18630000000000000000000000000000000000000000000000e-3 * t210 - 0.58357848829441957078558138724472142547316887244435e-4 * t223
  t226 = t225 * t114
  t227 = t226 * t116
  t229 = t115 ** 2
  t230 = 0.1e1 / t229
  t231 = t114 * t230
  t233 = t210 + 0.31324663891273192205345216706640978286267787034050e0 * t223
  t234 = t231 * t233
  t236 = t107 * t121
  t240 = 0.1e1 / t120 / t109
  t242 = t119 * t240 * t44
  t245 = -0.30180600000000000000000000000000000000000000000000e-2 * t236 * t209 - 0.94539715103695970467264184733644870926653357335985e-3 * t242 * t222
  t246 = t245 * t124
  t248 = 0.1e1 / t119
  t249 = t248 * t110
  t253 = t126 * t109 * t44
  t256 = -0.10e2 / 0.81e2 * t249 * t209 - 0.38672424557127397784376810748939479365762700042037e-1 * t253 * t222
  t258 = t210 * t117 + 0.31324663891273192205345216706640978286267787034050e0 * t215 * t183 + t112 * t227 - t112 * t234 - t246 * t129 + t125 * t256
  t263 = t17 / t20
  t264 = 0.1e1 / t88
  t268 = t87 * t26
  t269 = 0.1e1 / t268
  t273 = t140 * t25
  t277 = t38 ** 2
  t279 = 0.1e1 / t145 / t30 / t277
  t284 = (0.50379140625000000000000000000000000000000000000000e-1 * t25 * t264 * t40 - 0.23615222167968750000000000000000000000000000000000e-2 * t141 * t269 * t150 + 0.24599189758300781250000000000000000000000000000000e-4 * t273 * t206 * t279) * t44 * t49
  t290 = 0.1e1 / t20 / t87
  t291 = t53 * t290
  t294 = t185 ** 2
  t299 = 0.40e2 / 0.9e1 * t57 * t159 - 0.11e2 / 0.9e1 * t291
  t300 = t299 * t44
  t303 = t49 * t172
  t304 = t303 * t180
  t307 = t70 ** 2
  t309 = 0.1e1 / t71 / t307
  t310 = t66 * t309
  t311 = t180 ** 2
  t316 = t166 ** 2
  t323 = 0.22222222222222222222222222222222222222222222222222e0 * t300 * t67 + 0.24691358024691358024691358024691358024691358024692e0 * t316 * t82 * t84 + 0.12345679012345679012345679012345679012345679012346e0 * t176 * t84 * t299
  t326 = t75 * t291
  t328 = t300 * t168 / 0.4e1 - t167 * t304 / 0.4e1 + 0.27e2 / 0.80e2 * t310 * t311 - 0.9e1 / 0.40e2 * t173 * t323 + 0.22e2 / 0.81e2 * t326
  t333 = t185 * t190
  t337 = 0.1e1 / t95 / t94
  t338 = t78 * t337
  t339 = t200 ** 2
  t343 = t24 * t136 * t34
  t346 = 0.1e1 / t19 / t268
  t347 = t86 * t346
  t348 = t85 * t347
  t350 = 0.972e3 * t343 + 0.30400e5 / 0.9e1 * t348
  t356 = 0.1e1 / t103 / t18
  t359 = t284 * t54 / 0.24e2 - 0.2e1 / 0.9e1 * t155 * t160 + 0.11e2 / 0.27e2 * t50 * t291 + 0.292e3 / 0.2025e4 * t294 + 0.292e3 / 0.2025e4 * t78 * t328 - 0.73e2 / 0.97200e5 * t328 * t95 - 0.73e2 / 0.97200e5 * t333 * t200 + 0.73e2 / 0.388800e6 * t338 * t339 - 0.73e2 / 0.194400e6 * t191 * t350 + 0.17906231613669250208395663864850472583033676362945e-2 * t348 + 0.11746748959227447077004456264990366857350420137768e-1 * t343 + 0.30663580246913580246913580246913580246913580246915e-1 * t102 * t356
  t360 = t359 * t111
  t362 = t209 * t213
  t363 = t362 * t117
  t370 = t236 * t117
  t373 = t214 * t227
  t376 = t231 * t44
  t377 = t214 * t376
  t378 = t221 * t233
  t379 = t220 * t378
  t385 = t362 * t44
  t386 = t385 * t222
  t388 = t236 * t82
  t389 = t84 * t24
  t390 = t51 * t346
  t391 = t389 * t390
  t392 = t388 * t391
  t394 = t52 * t290
  t395 = t220 * t394
  t396 = t219 * t395
  t398 = -0.18630000000000000000000000000000000000000000000000e-3 * t360 - 0.11671569765888391415711627744894428509463377448887e-3 * t386 - 0.54841200000000000000000000000000000000000000000002e-4 * t392 + 0.21397877904128717595471317532306452267349525322960e-3 * t396
  t399 = t398 * t114
  t400 = t399 * t116
  t402 = t225 ** 2
  t403 = t402 * t114
  t404 = t403 * t116
  t406 = t112 * t225
  t410 = 0.1e1 / t229 / t115
  t411 = t114 * t410
  t412 = t233 ** 2
  t413 = t411 * t412
  t419 = t360 + 0.62649327782546384410690433413281956572535574068100e0 * t386 + 0.29437037037037037037037037037037037037037037037038e0 * t392 - 0.11485710093466837141959912792435025371631521912485e1 * t396
  t420 = t231 * t419
  t422 = t209 ** 2
  t425 = t107 * t240
  t426 = t209 * t44
  t427 = t425 * t426
  t433 = 0.1e1 / t120 / t110
  t435 = t119 * t433 * t82
  t440 = -0.30180600000000000000000000000000000000000000000000e-2 * t422 * t121 - 0.37815886041478388186905673893457948370661342934394e-2 * t427 * t222 - 0.30180600000000000000000000000000000000000000000000e-2 * t236 * t359 - 0.14807124000000000000000000000000000000000000000001e-2 * t435 * t391 + 0.34664562204688522504663534402336452673106231023195e-2 * t242 * t395
  t441 = t440 * t124
  t443 = t245 ** 2
  t444 = t443 * t124
  t449 = 0.1e1 / t119 / t107
  t450 = t449 * t110
  t453 = t248 * t109
  t454 = t453 * t426
  t460 = t126 * t82 * t84
  t465 = 0.20e2 / 0.81e2 * t450 * t422 + 0.77344849114254795568753621497878958731525400084074e-1 * t454 * t222 - 0.10e2 / 0.81e2 * t249 * t359 + 0.12114007011126352690138698369151044048163389727176e-1 * t460 * t347 + 0.14179889004280045854271497274611142434112990015414e0 * t253 * t395
  t467 = t360 * t117 + 0.62649327782546384410690433413281956572535574068100e0 * t363 * t183 + 0.2e1 * t210 * t227 - 0.2e1 * t210 * t234 + 0.29437037037037037037037037037037037037037037037038e0 * t370 * t348 + 0.62649327782546384410690433413281956572535574068100e0 * t373 * t183 - 0.62649327782546384410690433413281956572535574068100e0 * t377 * t379 - 0.11485710093466837141959912792435025371631521912485e1 * t215 * t326 + t112 * t400 + t112 * t404 - 0.2e1 * t406 * t234 + 0.2e1 * t112 * t413 - t112 * t420 - t441 * t129 - t444 * t129 - 0.2e1 * t246 * t256 + t125 * t465
  t471 = t17 * t19
  t472 = t210 * t225
  t484 = t140 ** 2
  t485 = t484 * s0
  t487 = 0.1e1 / t103 / t87
  t489 = t145 ** 2
  t494 = 0.1e1 / t489 / tau0 / t277 / t37
  t499 = (-0.25189570312500000000000000000000000000000000000000e0 * t25 * t143 * t40 + 0.19679351806640625000000000000000000000000000000000e-1 * t141 * t104 * t150 - 0.44278541564941406250000000000000000000000000000000e-3 * t273 * t356 * t279 + 0.30748987197875976562500000000000000000000000000000e-5 * t485 * t487 * t494) * t44 * t49
  t507 = 0.1e1 / t20 / t88
  t508 = t53 * t507
  t516 = -0.440e3 / 0.27e2 * t57 * t290 + 0.154e3 / 0.27e2 * t508
  t517 = t516 * t44
  t523 = t49 * t309 * t311
  t526 = t303 * t323
  t531 = 0.1e1 / t71 / t307 / t70
  t532 = t66 * t531
  t533 = t311 * t180
  t547 = 0.22222222222222222222222222222222222222222222222222e0 * t517 * t67 + 0.74074074074074074074074074074074074074074074074076e0 * t299 * t82 * t177 + 0.12345679012345679012345679012345679012345679012346e0 * t176 * t84 * t516
  t550 = t75 * t508
  t552 = t517 * t168 / 0.4e1 - 0.3e1 / 0.8e1 * t300 * t304 + 0.9e1 / 0.16e2 * t167 * t523 - 0.3e1 / 0.8e1 * t167 * t526 - 0.27e2 / 0.32e2 * t532 * t533 + 0.81e2 / 0.80e2 * t310 * t180 * t323 - 0.9e1 / 0.40e2 * t173 * t547 - 0.308e3 / 0.243e3 * t550
  t557 = t328 * t190
  t560 = t185 * t337
  t565 = t94 ** 2
  t567 = 0.1e1 / t95 / t565
  t568 = t78 * t567
  t569 = t339 * t200
  t572 = t200 * t350
  t576 = t24 * t264 * t34
  t579 = 0.1e1 / t19 / t103
  t580 = t86 * t579
  t581 = t85 * t580
  t583 = -0.3888e4 * t576 - 0.668800e6 / 0.27e2 * t581
  t589 = 0.1e1 / t103 / t26
  t590 = t102 * t589
  t592 = t499 * t54 / 0.24e2 - t284 * t160 / 0.3e1 + 0.11e2 / 0.9e1 * t155 * t291 - 0.154e3 / 0.81e2 * t50 * t508 + 0.292e3 / 0.675e3 * t185 * t328 + 0.292e3 / 0.2025e4 * t78 * t552 - 0.73e2 / 0.97200e5 * t552 * t95 - 0.73e2 / 0.64800e5 * t557 * t200 + 0.73e2 / 0.129600e6 * t560 * t339 - 0.73e2 / 0.64800e5 * t333 * t350 - 0.73e2 / 0.259200e6 * t568 * t569 + 0.73e2 / 0.129600e6 * t338 * t572 - 0.73e2 / 0.194400e6 * t191 * t583 - 0.13131236516690783486156820167557013227558029332826e-1 * t581 - 0.46986995836909788308017825059961467429401680551072e-1 * t576 - 0.30663580246913580246913580246913580246913580246915e0 * t590
  t593 = t592 * t111
  t599 = t209 * t121
  t603 = t422 * t240 * t44
  t606 = t107 * t433
  t608 = t606 * t209 * t82
  t611 = t359 * t44
  t612 = t425 * t611
  t620 = 0.1e1 / t120 / t212
  t621 = t119 * t620
  t624 = t51 * t579
  t625 = t389 * t624
  t628 = t52 * t507
  t629 = t220 * t628
  t632 = -0.90541800000000000000000000000000000000000000000000e-2 * t599 * t359 - 0.56723829062217582280358510840186922555992014401591e-2 * t603 * t222 - 0.88842744000000000000000000000000000000000000000005e-2 * t608 * t391 - 0.56723829062217582280358510840186922555992014401591e-2 * t612 * t222 + 0.20798737322813113502798120641401871603863738613917e-1 * t427 * t395 - 0.30180600000000000000000000000000000000000000000000e-2 * t236 * t592 - 0.16697814569870568294973683116955765202778686313477e-1 * t621 * t590 + 0.16287836400000000000000000000000000000000000000001e-1 * t435 * t625 - 0.16176795695521310502176316054423677914116241144158e-1 * t242 * t629
  t633 = t632 * t124
  t641 = t359 * t213
  t642 = t641 * t44
  t643 = t642 * t222
  t645 = t599 * t82
  t646 = t645 * t391
  t648 = t385 * t395
  t650 = t425 * t590
  t652 = t388 * t625
  t654 = t219 * t629
  t656 = t593 + 0.93973991673819576616035650119922934858803361102150e0 * t643 + 0.88311111111111111111111111111111111111111111111115e0 * t646 - 0.34457130280400511425879738377305076114894565737455e1 * t648 + 0.22130526987363496146496336211945110703933899675257e1 * t650 - 0.32380740740740740740740740740740740740740740740742e1 * t652 + 0.53599980436178573329146259698030118400947102258263e1 * t654
  t657 = t231 * t656
  t659 = t112 * t114
  t661 = t410 * t233 * t419
  t665 = t112 * t402
  t668 = t440 * t245
  t669 = t124 * t129
  t681 = -0.18630000000000000000000000000000000000000000000000e-3 * t593 - 0.17507354648832587123567441617341642764195066173330e-3 * t643 - 0.16452360000000000000000000000000000000000000000000e-3 * t646 + 0.64193633712386152786413952596919356802048575968879e-3 * t648 - 0.41229171777458193320922674362853741241428855095003e-3 * t650 + 0.60325320000000000000000000000000000000000000000002e-3 * t652 - 0.99856763552600682112199481817430110580964451507147e-3 * t654
  t683 = t681 * t114 * t116
  t691 = t112 * t398
  t700 = -0.3e1 * t665 * t234 - 0.3e1 * t668 * t669 - 0.3e1 * t444 * t256 + t112 * t683 - 0.3e1 * t441 * t256 + 0.3e1 * t360 * t227 - 0.3e1 * t246 * t465 + 0.3e1 * t691 * t227 - 0.3e1 * t360 * t234 + 0.53599980436178573329146259698030118400947102258263e1 * t215 * t550 - 0.34457130280400511425879738377305076114894565737455e1 * t363 * t326
  t702 = t641 * t117
  t705 = t599 * t117
  t711 = t443 * t245 * t124
  t713 = t236 * t227
  t716 = t214 * t400
  t719 = t221 * t419
  t720 = t220 * t719
  t723 = t362 * t376
  t726 = t362 * t227
  t729 = t231 * t82
  t730 = t236 * t729
  t731 = t390 * t233
  t732 = t389 * t731
  t738 = t214 * t404
  t741 = t411 * t44
  t742 = t214 * t741
  t743 = t221 * t412
  t744 = t220 * t743
  t747 = t394 * t233
  t748 = t220 * t747
  t751 = t425 * t114
  t752 = t116 * t101
  t754 = t752 * t25 * t589
  t757 = t229 ** 2
  t758 = 0.1e1 / t757
  t759 = t114 * t758
  t760 = t412 * t233
  t761 = t759 * t760
  t764 = t402 * t225
  t766 = t764 * t114 * t116
  t772 = t226 * t230
  t773 = t214 * t772
  t774 = t75 * s0
  t775 = t774 * t378
  t778 = t119 ** 2
  t779 = 0.1e1 / t778
  t780 = t779 * t110
  t781 = t422 * t209
  t784 = t449 * t109
  t786 = t784 * t422 * t44
  t793 = t248 * t82 * t84
  t798 = t453 * t611
  t809 = -0.20e2 / 0.27e2 * t780 * t781 - 0.23203454734276438670626086449363687619457620025222e0 * t786 * t222 + 0.20e2 / 0.27e2 * t450 * t209 * t359 - 0.36342021033379058070416095107453132144490169181529e-1 * t793 * t86 * t346 * t209 + 0.11601727367138219335313043224681843809728810012611e0 * t798 * t222 - 0.42539667012840137562814491823833427302338970046241e0 * t454 * t395 - 0.10e2 / 0.81e2 * t249 * t592 - 0.13325407712238987959152568206066148452979728699894e0 * t460 * t580 - 0.66172815353306880653266987281518664692527286738599e0 * t253 * t629
  t811 = -0.34457130280400511425879738377305076114894565737455e1 * t373 * t326 + 0.93973991673819576616035650119922934858803361102150e0 * t738 * t183 + 0.18794798334763915323207130023984586971760672220430e1 * t742 * t744 + 0.34457130280400511425879738377305076114894565737455e1 * t377 * t748 + 0.22130526987363496146496336211945110703933899675257e1 * t751 * t754 - 0.6e1 * t112 * t761 + t112 * t766 - 0.3e1 * t406 * t420 - 0.3e1 * t691 * t234 - 0.18794798334763915323207130023984586971760672220430e1 * t773 * t775 + t125 * t809
  t813 = -0.6e1 * t472 * t234 + t593 * t117 - 0.32380740740740740740740740740740740740740740740742e1 * t370 * t581 + 0.6e1 * t210 * t413 - t633 * t129 + 0.3e1 * t210 * t404 - 0.3e1 * t210 * t420 + 0.6e1 * t406 * t413 - t112 * t657 + 0.6e1 * t659 * t661 + t700 + 0.93973991673819576616035650119922934858803361102150e0 * t702 * t183 + 0.88311111111111111111111111111111111111111111111115e0 * t705 * t348 + 0.3e1 * t210 * t400 - t711 * t129 + 0.88311111111111111111111111111111111111111111111115e0 * t713 * t348 + 0.93973991673819576616035650119922934858803361102150e0 * t716 * t183 - 0.93973991673819576616035650119922934858803361102150e0 * t377 * t720 - 0.18794798334763915323207130023984586971760672220430e1 * t723 * t379 + 0.18794798334763915323207130023984586971760672220430e1 * t726 * t183 - 0.88311111111111111111111111111111111111111111111115e0 * t730 * t732 + t811
  t818 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t131 + t6 * t135 * t258 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t263 * t467 - 0.3e1 / 0.8e1 * t6 * t471 * t813)
  t869 = 0.12e2 * t691 * t413 - 0.4e1 * t210 * t657 + 0.21439992174471429331658503879212047360378840903305e2 * t373 * t550 - 0.68914260560801022851759476754610152229789131474910e1 * t738 * t326 + 0.12529865556509276882138086682656391314507114813620e1 * t214 * t766 * t183 - 0.75179193339055661292828520095938347887042688881720e1 * t214 * t759 * t44 * t220 * t221 * t760 - 0.13782852112160204570351895350922030445957826294982e2 * t742 * t220 * t394 * t412 - 0.21439992174471429331658503879212047360378840903305e2 * t377 * t220 * t628 * t233 - 0.12e2 * t668 * t124 * t256 - 0.4e1 * t632 * t245 * t669 - 0.24e2 * t210 * t761 + 0.88522107949453984585985344847780442815735598701028e1 * t425 * t226 * t754
  t872 = t210 * t398
  t879 = t402 ** 2
  t883 = t398 ** 2
  t901 = 0.1e1 / t20 / t142
  t902 = t53 * t901
  t906 = t24 * t143 * t34
  t909 = 0.1e1 / t19 / t205
  t910 = t86 * t909
  t911 = t85 * t910
  t917 = t102 * t487
  t956 = -0.4e1 / 0.9e1 * t499 * t160 + 0.22e2 / 0.9e1 * t284 * t291 - 0.616e3 / 0.81e2 * t155 * t508 + 0.2618e4 / 0.243e3 * t50 * t902 - 0.73e2 / 0.194400e6 * t191 * (0.19440e5 * t906 + 0.16720000e8 / 0.81e2 * t911) + 0.23493497918454894154008912529980733714700840275536e0 * t906 + 0.33729938271604938271604938271604938271604938271606e1 * t917 - 0.73e2 / 0.48600e5 * t333 * t583 - 0.73e2 / 0.32400e5 * t557 * t350 - 0.73e2 / 0.48600e5 * t552 * t190 * t200 + (0.15113742187500000000000000000000000000000000000000e1 * t25 * t269 * t40 - 0.17317829589843750000000000000000000000000000000000e0 * t141 * t206 * t150 + 0.62727933883666992187500000000000000000000000000000e-2 * t273 * t589 * t279 - 0.92246961593627929687500000000000000000000000000000e-4 * t485 / t103 / t88 * t494 + 0.48045292496681213378906250000000000000000000000000e-6 * t484 * t25 / t103 / t268 / t489 / t30 / t277 / t38) * t44 * t49 * t54 / 0.24e2
  t960 = t350 ** 2
  t975 = t339 ** 2
  t982 = t328 ** 2
  t989 = 0.6160e4 / 0.81e2 * t57 * t507 - 0.2618e4 / 0.81e2 * t902
  t990 = t989 * t44
  t1011 = t307 ** 2
  t1015 = t311 ** 2
  t1021 = t323 ** 2
  t1032 = t299 ** 2
  t1042 = t75 * t902
  t1044 = t990 * t168 / 0.4e1 - t517 * t304 / 0.2e1 + 0.9e1 / 0.8e1 * t300 * t523 - 0.3e1 / 0.4e1 * t300 * t526 - 0.15e2 / 0.8e1 * t167 * t49 * t531 * t533 + 0.9e1 / 0.4e1 * t167 * t49 * t309 * t180 * t323 - t167 * t303 * t547 / 0.2e1 + 0.189e3 / 0.64e2 * t66 / t71 / t1011 * t1015 - 0.81e2 / 0.16e2 * t532 * t311 * t323 + 0.81e2 / 0.80e2 * t310 * t1021 + 0.27e2 / 0.20e2 * t310 * t180 * t547 - 0.9e1 / 0.40e2 * t173 * (0.22222222222222222222222222222222222222222222222222e0 * t990 * t67 + 0.98765432098765432098765432098765432098765432098768e0 * t516 * t82 * t177 + 0.74074074074074074074074074074074074074074074074076e0 * t1032 * t82 * t84 + 0.12345679012345679012345679012345679012345679012346e0 * t176 * t84 * t989) + 0.5236e4 / 0.729e3 * t1042
  t1049 = -0.73e2 / 0.43200e5 * t568 * t339 * t350 + 0.73e2 / 0.129600e6 * t338 * t960 + 0.73e2 / 0.97200e5 * t338 * t200 * t583 - 0.73e2 / 0.64800e5 * t185 * t567 * t569 + 0.73e2 / 0.32400e5 * t560 * t572 + 0.73e2 / 0.103680e6 * t78 / t95 / t565 / t94 * t975 + 0.73e2 / 0.64800e5 * t328 * t337 * t339 + 0.10942697097242319571797350139630844356298357777355e0 * t911 + 0.292e3 / 0.675e3 * t982 + 0.1168e4 / 0.2025e4 * t185 * t552 + 0.292e3 / 0.2025e4 * t78 * t1044 - 0.73e2 / 0.97200e5 * t1044 * t95
  t1050 = t956 + t1049
  t1051 = t1050 * t111
  t1052 = t592 * t213
  t1054 = t1052 * t44 * t222
  t1056 = t359 * t121
  t1058 = t1056 * t82 * t391
  t1060 = t642 * t395
  t1062 = t209 * t240
  t1063 = t1062 * t590
  t1065 = t645 * t625
  t1067 = t385 * t629
  t1069 = t101 * t140
  t1073 = 0.1e1 / t20 / t103 / t142
  t1076 = t1073 * t44 * t49 * t52
  t1077 = t606 * t1069 * t1076
  t1079 = t425 * t917
  t1082 = t389 * t51 * t909
  t1083 = t388 * t1082
  t1086 = t220 * t52 * t901
  t1087 = t219 * t1086
  t1089 = t1051 + 0.12529865556509276882138086682656391314507114813620e1 * t1054 + 0.17662222222222222222222222222222222222222222222223e1 * t1058 - 0.68914260560801022851759476754610152229789131474910e1 * t1060 + 0.88522107949453984585985344847780442815735598701028e1 * t1063 - 0.12952296296296296296296296296296296296296296296297e2 * t1065 + 0.21439992174471429331658503879212047360378840903305e2 * t1067 + 0.17330782990397805212620027434842249657064471879288e1 * t1077 - 0.48687159372199691522291939666279243548654579285565e2 * t1079 + 0.32020954732510288065843621399176954732510288065845e2 * t1083 - 0.30373322247167858219849547162217067093870024613016e2 * t1087
  t1103 = -0.18630000000000000000000000000000000000000000000000e-3 * t1051 - 0.23343139531776782831423255489788857018926754897774e-3 * t1054 - 0.32904720000000000000000000000000000000000000000000e-3 * t1058 + 0.12838726742477230557282790519383871360409715193776e-2 * t1060 - 0.16491668710983277328369069745141496496571542038001e-2 * t1063 + 0.24130128000000000000000000000000000000000000000000e-2 * t1065 - 0.39942705421040272844879792726972044232385780602859e-2 * t1067 - 0.32287248711111111111111111111111111111111111111113e-3 * t1077 + 0.90704177910408025306029883598278230731143481209007e-2 * t1079 - 0.59655038666666666666666666666666666666666666666669e-2 * t1083 + 0.56585499346473719863579706363210395995879855854050e-2 * t1087
  t1111 = t112 * t1103 * t114 * t116 + t112 * t879 * t114 * t116 + 0.3e1 * t112 * t883 * t114 * t116 - 0.36e2 * t659 * t758 * t412 * t419 - t112 * t231 * t1089 + 0.12e2 * t872 * t227 - 0.12e2 * t872 * t234 + 0.6e1 * t360 * t400 - 0.4e1 * t406 * t657 + 0.12e2 * t665 * t413 - 0.6e1 * t665 * t420 - 0.6e1 * t691 * t420
  t1115 = t419 ** 2
  t1123 = t112 * t681
  t1138 = t412 ** 2
  t1150 = 0.4e1 * t210 * t683 + 0.6e1 * t112 * t411 * t1115 - 0.4e1 * t711 * t256 - 0.12e2 * t472 * t420 + 0.4e1 * t1123 * t227 + 0.8e1 * t659 * t410 * t656 * t233 - 0.4e1 * t112 * t764 * t234 + 0.12e2 * t360 * t413 + 0.24e2 * t112 * t114 / t757 / t115 * t1138 + 0.4e1 * t210 * t766 + 0.24e2 * t210 * t114 * t661 - 0.6e1 * t440 * t443 * t669
  t1160 = t359 ** 2
  t1163 = t120 ** 2
  t1189 = t592 * t44
  t1206 = -0.90541800000000000000000000000000000000000000000000e-2 * t1160 * t121 - 0.18306870019200000000000000000000000000000000000003e-1 * t119 / t1163 * t1069 * t1076 - 0.16106860440000000000000000000000000000000000000001e0 * t435 * t1082 + 0.91668508941287426178999124308400841513325366483562e-1 * t242 * t1086 + 0.36735192053715250248942102857302683446113109889649e0 * t621 * t917 + 0.13030269120000000000000000000000000000000000000001e0 * t608 * t625 + 0.41597474645626227005596241282803743207727477227834e-1 * t612 * t395 - 0.12941436556417048401741052843538942331292992915326e0 * t427 * t629 + 0.41597474645626227005596241282803743207727477227834e-1 * t603 * t395 - 0.17768548800000000000000000000000000000000000000001e-1 * t606 * t359 * t82 * t391 - 0.30180600000000000000000000000000000000000000000000e-2 * t236 * t1050 - 0.75631772082956776373811347786915896741322685868788e-2 * t425 * t1189 * t222 - 0.22689531624887032912143404336074769022396805760636e-1 * t1062 * t611 * t222 - 0.13358251655896454635978946493564612162222949050781e0 * t107 * t620 * t209 * t590 - 0.12072240000000000000000000000000000000000000000000e-1 * t599 * t592 - 0.17768548800000000000000000000000000000000000000001e-1 * t422 * t433 * t82 * t391
  t1222 = t1051 * t117 - 0.4e1 * t1123 * t234 - 0.4e1 * t246 * t809 - 0.6e1 * t441 * t465 + 0.6e1 * t360 * t404 - t1206 * t124 * t129 - 0.24e2 * t406 * t761 + 0.21439992174471429331658503879212047360378840903305e2 * t363 * t550 - 0.68914260560801022851759476754610152229789131474910e1 * t702 * t326 + 0.12529865556509276882138086682656391314507114813620e1 * t1052 * t117 * t183 + 0.32020954732510288065843621399176954732510288065845e2 * t370 * t911 - 0.30373322247167858219849547162217067093870024613016e2 * t215 * t1042
  t1230 = t440 ** 2
  t1261 = 0.17662222222222222222222222222222222222222222222223e1 * t1056 * t117 * t348 - 0.12952296296296296296296296296296296296296296296297e2 * t705 * t581 - 0.3e1 * t1230 * t124 * t129 - 0.4e1 * t593 * t234 + 0.35324444444444444444444444444444444444444444444446e1 * t599 * t227 * t348 + 0.17662222222222222222222222222222222222222222222223e1 * t236 * t400 * t348 + 0.37589596669527830646414260047969173943521344440860e1 * t362 * t400 * t183 + 0.12529865556509276882138086682656391314507114813620e1 * t214 * t683 * t183 - 0.37589596669527830646414260047969173943521344440860e1 * t723 * t720 - 0.12e2 * t691 * t226 * t230 * t233 + 0.88522107949453984585985344847780442815735598701028e1 * t1062 * t114 * t754 + 0.24e2 * t406 * t411 * t233 * t419
  t1301 = 0.4e1 * t593 * t227 - 0.6e1 * t360 * t420 - 0.12529865556509276882138086682656391314507114813620e1 * t377 * t220 * t221 * t656 - 0.17662222222222222222222222222222222222222222222223e1 * t730 * t389 * t390 * t419 - 0.37589596669527830646414260047969173943521344440860e1 * t641 * t376 * t379 - 0.35324444444444444444444444444444444444444444444446e1 * t599 * t729 * t732 + 0.37589596669527830646414260047969173943521344440860e1 * t641 * t227 * t183 + 0.17330782990397805212620027434842249657064471879288e1 * t606 * t117 * t101 * t140 * t1073 * t75 * t52 - 0.12952296296296296296296296296296296296296296296297e2 * t713 * t581 + 0.17662222222222222222222222222222222222222222222223e1 * t236 * t404 * t348 - 0.68914260560801022851759476754610152229789131474910e1 * t716 * t326 + 0.68914260560801022851759476754610152229789131474910e1 * t377 * t220 * t394 * t419
  t1323 = t443 ** 2
  t1383 = t422 ** 2
  t1389 = 0.37497928700207232370184626126193909992432129151873e1 * t253 * t1086 + 0.14536808413351623228166438042981252857796067672612e0 * t449 * t82 * t84 * t86 * t346 * t422 + 0.53301630848955951836610272824264593811918914799576e0 * t793 * t86 * t579 * t209 + 0.15468969822850959113750724299575791746305080016815e0 * t453 * t1189 * t222 + 0.20e2 / 0.27e2 * t450 * t1160 + 0.92813818937105754682504345797454750477830480100888e0 * t779 * t109 * t781 * t44 * t222 - 0.72684042066758116140832190214906264288980338363057e-1 * t793 * t86 * t346 * t359 - 0.10e2 / 0.81e2 * t249 * t1050 + 0.26469126141322752261306794912607465877010914695439e1 * t454 * t629 - 0.92813818937105754682504345797454750477830480100888e0 * t784 * t426 * t220 * t221 * t359 + 0.17015866805136055025125796729533370920935588018496e1 * t786 * t395 - 0.85079334025680275125628983647666854604677940092481e0 * t798 * t395 + 0.13177347626547443648495317448220969025724398381006e1 * t460 * t910 + 0.80e2 / 0.81e2 * t450 * t209 * t592 + 0.80e2 / 0.27e2 / t778 / t107 * t110 * t1383 - 0.40e2 / 0.9e1 * t780 * t422 * t359
  t1395 = 0.75179193339055661292828520095938347887042688881720e1 * t362 * t741 * t744 + 0.13782852112160204570351895350922030445957826294982e2 * t723 * t748 - 0.13782852112160204570351895350922030445957826294982e2 * t726 * t326 + 0.37589596669527830646414260047969173943521344440860e1 * t362 * t404 * t183 + 0.35324444444444444444444444444444444444444444444446e1 * t236 * t411 * t82 * t389 * t390 * t412 + 0.12952296296296296296296296296296296296296296296297e2 * t730 * t389 * t624 * t233 - t1323 * t124 * t129 - 0.88522107949453984585985344847780442815735598701028e1 * t425 * t231 * t102 * t589 * t233 - 0.6e1 * t444 * t465 - 0.12e2 * t360 * t225 * t234 + t125 * t1389 - 0.48687159372199691522291939666279243548654579285565e2 * t751 * t752 * t25 * t487
  t1446 = 0.6e1 * t691 * t404 + 0.24e2 * t472 * t413 - 0.12e2 * t210 * t402 * t234 - 0.35324444444444444444444444444444444444444444444446e1 * t236 * t772 * t85 * t24 * t731 - 0.37589596669527830646414260047969173943521344440860e1 * t214 * t399 * t230 * t775 + 0.37589596669527830646414260047969173943521344440860e1 * t214 * t398 * t225 * t114 * t116 * t44 * t49 * t160 + 0.75179193339055661292828520095938347887042688881720e1 * t742 * t220 * t52 * t159 * t419 * t233 - 0.37589596669527830646414260047969173943521344440860e1 * t773 * t774 * t719 - 0.75179193339055661292828520095938347887042688881720e1 * t362 * t772 * t775 + 0.13782852112160204570351895350922030445957826294982e2 * t773 * t774 * t747 - 0.37589596669527830646414260047969173943521344440860e1 * t214 * t403 * t230 * t775 + 0.75179193339055661292828520095938347887042688881720e1 * t214 * t226 * t410 * t774 * t743 - 0.4e1 * t633 * t256
  t1454 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t159 * t131 - 0.5e1 / 0.9e1 * t6 * t23 * t258 + t6 * t135 * t467 / 0.2e1 - t6 * t263 * t813 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t471 * (t869 + t1111 + t1150 + t1222 + t1261 + t1301 + t1395 + t1446))
  v4rho4_0_ = 0.2e1 * r0 * t1454 + 0.8e1 * t818

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = s0 ** 2
  t33 = t32 * s0
  t34 = r0 ** 2
  t35 = t34 * r0
  t36 = 0.1e1 / t35
  t38 = tau0 ** 2
  t39 = t38 * tau0
  t43 = 0.1e1 / t38
  t44 = t32 / t34 * t43
  t46 = 0.1e1 + t44 / 0.64e2
  t47 = t46 ** 2
  t49 = 0.1e1 / t39 / t47
  t53 = 6 ** (0.1e1 / 0.3e1)
  t54 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t33 * t36 * t49) * t53
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t58 * s0
  t60 = r0 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t63 = 0.1e1 / t61 / t34
  t64 = t59 * t63
  t70 = s0 * t63
  t72 = tau0 / t61 / r0 - t70 / 0.8e1
  t73 = t72 * t53
  t76 = 0.5e1 / 0.9e1 * t73 * t58 - 0.1e1
  t77 = t58 * t76
  t80 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t73 * t77
  t81 = jnp.sqrt(t80)
  t82 = 0.1e1 / t81
  t85 = t53 * t58
  t86 = t85 * t70
  t88 = 0.9e1 / 0.20e2 * t76 * t82 + t86 / 0.36e2
  t89 = t88 ** 2
  t92 = t53 ** 2
  t94 = 0.1e1 / t56 / t55
  t95 = t92 * t94
  t96 = t34 ** 2
  t97 = t96 * r0
  t101 = t95 * t32 / t60 / t97
  t103 = 0.162e3 * t44 + 0.50e2 * t101
  t104 = jnp.sqrt(t103)
  t109 = t55 ** 2
  t110 = 0.1e1 / t109
  t111 = t110 * t33
  t112 = t96 ** 2
  t116 = t54 * t64 / 0.24e2 + 0.146e3 / 0.2025e4 * t89 - 0.73e2 / 0.97200e5 * t88 * t104 + 0.26505934954444613795322528747311554810411691984623e-4 * t101 + 0.19577914932045745128340760441650611428917366896280e-2 * t44 + 0.10647076474622770919067215363511659807956104252401e-3 * t111 / t112
  t118 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t86
  t119 = t118 ** 2
  t120 = 0.1e1 / t119
  t121 = t116 * t120
  t123 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t121)
  t124 = 0.1e1 + t121
  t125 = 0.1e1 / t124
  t126 = t123 * t125
  t128 = t116 ** 2
  t129 = t119 ** 2
  t130 = 0.1e1 / t129
  t133 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t128 * t130)
  t134 = 0.1e1 - t133
  t135 = 0.1e1 / t116
  t138 = 0.10e2 / 0.81e2 * t135 * t119 - 0.1e1
  t140 = t121 * t126 + t134 * t138 + 0.1e1
  t144 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t145 = t144 * f.p.zeta_threshold
  t147 = f.my_piecewise3(t20, t145, t21 * t19)
  t148 = t30 ** 2
  t149 = 0.1e1 / t148
  t150 = t147 * t149
  t153 = t5 * t150 * t140 / 0.8e1
  t154 = t147 * t30
  t155 = 0.1e1 / t96
  t159 = t32 ** 2
  t160 = t159 * s0
  t161 = t96 * t34
  t164 = t38 ** 2
  t169 = 0.1e1 / t164 / tau0 / t47 / t46
  t173 = (-0.12594785156250000000000000000000000000000000000000e-1 * t33 * t155 * t49 + 0.26239135742187500000000000000000000000000000000000e-3 * t160 / t161 * t169) * t53
  t177 = 0.1e1 / t61 / t35
  t178 = t59 * t177
  t183 = s0 * t177
  t185 = -0.5e1 / 0.3e1 * tau0 * t63 + t183 / 0.3e1
  t186 = t185 * t53
  t187 = t58 * t82
  t191 = 0.1e1 / t81 / t80
  t192 = t76 * t191
  t195 = t72 * t92
  t199 = 0.22222222222222222222222222222222222222222222222222e0 * t186 * t77 + 0.12345679012345679012345679012345679012345679012346e0 * t195 * t94 * t185
  t202 = t85 * t183
  t204 = t186 * t187 / 0.4e1 - 0.9e1 / 0.40e2 * t192 * t199 - 0.2e1 / 0.27e2 * t202
  t209 = 0.1e1 / t104
  t210 = t88 * t209
  t212 = t32 * t36 * t43
  t217 = t95 * t32 / t60 / t161
  t219 = -0.324e3 * t212 - 0.800e3 / 0.3e1 * t217
  t225 = 0.1e1 / t112 / r0
  t228 = t173 * t64 / 0.24e2 - t54 * t178 / 0.9e1 + 0.292e3 / 0.2025e4 * t88 * t204 - 0.73e2 / 0.97200e5 * t204 * t104 - 0.73e2 / 0.194400e6 * t210 * t219 - 0.14136498642370460690838681998566162565552902391799e-3 * t217 - 0.39155829864091490256681520883301222857834733792560e-2 * t212 - 0.85176611796982167352537722908093278463648834019208e-3 * t111 * t225
  t229 = t228 * t120
  t232 = 0.1e1 / t119 / t118
  t233 = t116 * t232
  t234 = t233 * t126
  t238 = t233 * t53
  t239 = t238 * t178
  t241 = -0.18630000000000000000000000000000000000000000000000e-3 * t229 - 0.58357848829441957078558138724472142547316887244435e-4 * t239
  t242 = t241 * t123
  t243 = t242 * t125
  t245 = t124 ** 2
  t247 = t123 / t245
  t249 = t229 + 0.31324663891273192205345216706640978286267787034050e0 * t239
  t250 = t247 * t249
  t252 = t116 * t130
  t256 = 0.1e1 / t129 / t118
  t258 = t128 * t256 * t53
  t261 = -0.30180600000000000000000000000000000000000000000000e-2 * t252 * t228 - 0.94539715103695970467264184733644870926653357335985e-3 * t258 * t178
  t262 = t261 * t133
  t264 = 0.1e1 / t128
  t265 = t264 * t119
  t269 = t135 * t118 * t53
  t272 = -0.10e2 / 0.81e2 * t265 * t228 - 0.38672424557127397784376810748939479365762700042037e-1 * t269 * t178
  t274 = t229 * t126 + 0.31324663891273192205345216706640978286267787034050e0 * t234 * t202 + t121 * t243 - t121 * t250 - t262 * t138 + t134 * t272
  t279 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t140 - t153 - 0.3e1 / 0.8e1 * t5 * t154 * t274)
  t281 = r1 <= f.p.dens_threshold
  t282 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t283 = 0.1e1 + t282
  t284 = t283 <= f.p.zeta_threshold
  t285 = t283 ** (0.1e1 / 0.3e1)
  t287 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t290 = f.my_piecewise3(t284, 0, 0.4e1 / 0.3e1 * t285 * t287)
  t291 = t290 * t30
  t292 = s2 ** 2
  t293 = t292 * s2
  t294 = r1 ** 2
  t295 = t294 * r1
  t296 = 0.1e1 / t295
  t298 = tau1 ** 2
  t299 = t298 * tau1
  t303 = 0.1e1 / t298
  t304 = t292 / t294 * t303
  t306 = 0.1e1 + t304 / 0.64e2
  t307 = t306 ** 2
  t309 = 0.1e1 / t299 / t307
  t313 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t293 * t296 * t309) * t53
  t314 = t58 * s2
  t315 = r1 ** (0.1e1 / 0.3e1)
  t316 = t315 ** 2
  t318 = 0.1e1 / t316 / t294
  t319 = t314 * t318
  t325 = s2 * t318
  t327 = tau1 / t316 / r1 - t325 / 0.8e1
  t328 = t327 * t53
  t331 = 0.5e1 / 0.9e1 * t328 * t58 - 0.1e1
  t332 = t58 * t331
  t335 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t328 * t332
  t336 = jnp.sqrt(t335)
  t337 = 0.1e1 / t336
  t340 = t85 * t325
  t342 = 0.9e1 / 0.20e2 * t331 * t337 + t340 / 0.36e2
  t343 = t342 ** 2
  t346 = t294 ** 2
  t347 = t346 * r1
  t351 = t95 * t292 / t315 / t347
  t353 = 0.162e3 * t304 + 0.50e2 * t351
  t354 = jnp.sqrt(t353)
  t359 = t110 * t293
  t360 = t346 ** 2
  t364 = t313 * t319 / 0.24e2 + 0.146e3 / 0.2025e4 * t343 - 0.73e2 / 0.97200e5 * t342 * t354 + 0.26505934954444613795322528747311554810411691984623e-4 * t351 + 0.19577914932045745128340760441650611428917366896280e-2 * t304 + 0.10647076474622770919067215363511659807956104252401e-3 * t359 / t360
  t366 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t340
  t367 = t366 ** 2
  t368 = 0.1e1 / t367
  t369 = t364 * t368
  t371 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t369)
  t372 = 0.1e1 + t369
  t373 = 0.1e1 / t372
  t374 = t371 * t373
  t376 = t364 ** 2
  t377 = t367 ** 2
  t378 = 0.1e1 / t377
  t381 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t376 * t378)
  t382 = 0.1e1 - t381
  t383 = 0.1e1 / t364
  t386 = 0.10e2 / 0.81e2 * t383 * t367 - 0.1e1
  t388 = t369 * t374 + t382 * t386 + 0.1e1
  t393 = f.my_piecewise3(t284, t145, t285 * t283)
  t394 = t393 * t149
  t397 = t5 * t394 * t388 / 0.8e1
  t399 = f.my_piecewise3(t281, 0, -0.3e1 / 0.8e1 * t5 * t291 * t388 - t397)
  t401 = t21 ** 2
  t402 = 0.1e1 / t401
  t403 = t26 ** 2
  t408 = t16 / t22 / t6
  t410 = -0.2e1 * t23 + 0.2e1 * t408
  t411 = f.my_piecewise5(t10, 0, t14, 0, t410)
  t415 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t402 * t403 + 0.4e1 / 0.3e1 * t21 * t411)
  t422 = t5 * t29 * t149 * t140
  t428 = 0.1e1 / t148 / t6
  t432 = t5 * t147 * t428 * t140 / 0.12e2
  t434 = t5 * t150 * t274
  t440 = t96 * t35
  t449 = t47 ** 2
  t461 = 0.1e1 / t61 / t96
  t462 = t59 * t461
  t465 = t204 ** 2
  t469 = s0 * t461
  t471 = 0.40e2 / 0.9e1 * tau0 * t177 - 0.11e2 / 0.9e1 * t469
  t472 = t471 * t53
  t479 = t80 ** 2
  t483 = t199 ** 2
  t488 = t185 ** 2
  t498 = t85 * t469
  t500 = t472 * t187 / 0.4e1 - t186 * t58 * t191 * t199 / 0.4e1 + 0.27e2 / 0.80e2 * t76 / t81 / t479 * t483 - 0.9e1 / 0.40e2 * t192 * (0.22222222222222222222222222222222222222222222222222e0 * t472 * t77 + 0.24691358024691358024691358024691358024691358024692e0 * t488 * t92 * t94 + 0.12345679012345679012345679012345679012345679012346e0 * t195 * t94 * t471) + 0.22e2 / 0.81e2 * t498
  t511 = t219 ** 2
  t515 = t32 * t155 * t43
  t518 = 0.1e1 / t60 / t440
  t520 = t95 * t32 * t518
  t531 = (0.50379140625000000000000000000000000000000000000000e-1 * t33 / t97 * t49 - 0.23615222167968750000000000000000000000000000000000e-2 * t160 / t440 * t169 + 0.24599189758300781250000000000000000000000000000000e-4 * t159 * t33 * t225 / t164 / t39 / t449) * t53 * t64 / 0.24e2 - 0.2e1 / 0.9e1 * t173 * t178 + 0.11e2 / 0.27e2 * t54 * t462 + 0.292e3 / 0.2025e4 * t465 + 0.292e3 / 0.2025e4 * t88 * t500 - 0.73e2 / 0.97200e5 * t500 * t104 - 0.73e2 / 0.97200e5 * t204 * t209 * t219 + 0.73e2 / 0.388800e6 * t88 / t104 / t103 * t511 - 0.73e2 / 0.194400e6 * t210 * (0.972e3 * t515 + 0.15200e5 / 0.9e1 * t520) + 0.89531158068346251041978319324252362915168381814727e-3 * t520 + 0.11746748959227447077004456264990366857350420137768e-1 * t515 + 0.76658950617283950617283950617283950617283950617287e-2 * t111 / t112 / t34
  t532 = t531 * t120
  t534 = t228 * t232
  t559 = t534 * t53 * t178
  t563 = t94 * t32 * t518
  t564 = t252 * t92 * t563
  t566 = t238 * t462
  t572 = t241 ** 2
  t582 = t249 ** 2
  t592 = t228 ** 2
  t612 = t261 ** 2
  t635 = t532 * t126 + 0.62649327782546384410690433413281956572535574068100e0 * t534 * t126 * t202 + 0.2e1 * t229 * t243 - 0.2e1 * t229 * t250 + 0.14718518518518518518518518518518518518518518518519e0 * t252 * t126 * t520 + 0.62649327782546384410690433413281956572535574068100e0 * t233 * t242 * t125 * t53 * t178 - 0.62649327782546384410690433413281956572535574068100e0 * t233 * t247 * t85 * t183 * t249 - 0.11485710093466837141959912792435025371631521912485e1 * t234 * t498 + t121 * (-0.18630000000000000000000000000000000000000000000000e-3 * t532 - 0.11671569765888391415711627744894428509463377448887e-3 * t559 - 0.27420600000000000000000000000000000000000000000001e-4 * t564 + 0.21397877904128717595471317532306452267349525322960e-3 * t566) * t123 * t125 + t121 * t572 * t123 * t125 - 0.2e1 * t121 * t241 * t250 + 0.2e1 * t121 * t123 / t245 / t124 * t582 - t121 * t247 * (t532 + 0.62649327782546384410690433413281956572535574068100e0 * t559 + 0.14718518518518518518518518518518518518518518518519e0 * t564 - 0.11485710093466837141959912792435025371631521912485e1 * t566) - (-0.30180600000000000000000000000000000000000000000000e-2 * t592 * t130 - 0.37815886041478388186905673893457948370661342934394e-2 * t116 * t256 * t228 * t202 - 0.30180600000000000000000000000000000000000000000000e-2 * t252 * t531 - 0.74035620000000000000000000000000000000000000000003e-3 * t128 / t129 / t119 * t92 * t563 + 0.34664562204688522504663534402336452673106231023195e-2 * t258 * t462) * t133 * t138 - t612 * t133 * t138 - 0.2e1 * t262 * t272 + t134 * (0.20e2 / 0.81e2 / t128 / t116 * t119 * t592 + 0.77344849114254795568753621497878958731525400084074e-1 * t264 * t118 * t228 * t202 - 0.10e2 / 0.81e2 * t265 * t531 + 0.60570035055631763450693491845755220240816948635881e-2 * t135 * t92 * t563 + 0.14179889004280045854271497274611142434112990015414e0 * t269 * t462)
  t640 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t415 * t30 * t140 - t422 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t274 + t432 - t434 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t154 * t635)
  t641 = t285 ** 2
  t642 = 0.1e1 / t641
  t643 = t287 ** 2
  t647 = f.my_piecewise5(t14, 0, t10, 0, -t410)
  t651 = f.my_piecewise3(t284, 0, 0.4e1 / 0.9e1 * t642 * t643 + 0.4e1 / 0.3e1 * t285 * t647)
  t658 = t5 * t290 * t149 * t388
  t663 = t5 * t393 * t428 * t388 / 0.12e2
  t665 = f.my_piecewise3(t281, 0, -0.3e1 / 0.8e1 * t5 * t651 * t30 * t388 - t658 / 0.4e1 + t663)
  d11 = 0.2e1 * t279 + 0.2e1 * t399 + t6 * (t640 + t665)
  t668 = -t7 - t24
  t669 = f.my_piecewise5(t10, 0, t14, 0, t668)
  t672 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t669)
  t673 = t672 * t30
  t678 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t673 * t140 - t153)
  t680 = f.my_piecewise5(t14, 0, t10, 0, -t668)
  t683 = f.my_piecewise3(t284, 0, 0.4e1 / 0.3e1 * t285 * t680)
  t684 = t683 * t30
  t688 = t393 * t30
  t689 = 0.1e1 / t346
  t693 = t292 ** 2
  t694 = t693 * s2
  t695 = t346 * t294
  t698 = t298 ** 2
  t703 = 0.1e1 / t698 / tau1 / t307 / t306
  t707 = (-0.12594785156250000000000000000000000000000000000000e-1 * t293 * t689 * t309 + 0.26239135742187500000000000000000000000000000000000e-3 * t694 / t695 * t703) * t53
  t711 = 0.1e1 / t316 / t295
  t712 = t314 * t711
  t717 = s2 * t711
  t719 = -0.5e1 / 0.3e1 * tau1 * t318 + t717 / 0.3e1
  t720 = t719 * t53
  t721 = t58 * t337
  t725 = 0.1e1 / t336 / t335
  t726 = t331 * t725
  t729 = t327 * t92
  t733 = 0.22222222222222222222222222222222222222222222222222e0 * t720 * t332 + 0.12345679012345679012345679012345679012345679012346e0 * t729 * t94 * t719
  t736 = t85 * t717
  t738 = t720 * t721 / 0.4e1 - 0.9e1 / 0.40e2 * t726 * t733 - 0.2e1 / 0.27e2 * t736
  t743 = 0.1e1 / t354
  t744 = t342 * t743
  t746 = t292 * t296 * t303
  t751 = t95 * t292 / t315 / t695
  t753 = -0.324e3 * t746 - 0.800e3 / 0.3e1 * t751
  t759 = 0.1e1 / t360 / r1
  t762 = t707 * t319 / 0.24e2 - t313 * t712 / 0.9e1 + 0.292e3 / 0.2025e4 * t342 * t738 - 0.73e2 / 0.97200e5 * t738 * t354 - 0.73e2 / 0.194400e6 * t744 * t753 - 0.14136498642370460690838681998566162565552902391799e-3 * t751 - 0.39155829864091490256681520883301222857834733792560e-2 * t746 - 0.85176611796982167352537722908093278463648834019208e-3 * t359 * t759
  t763 = t762 * t368
  t766 = 0.1e1 / t367 / t366
  t767 = t364 * t766
  t768 = t767 * t374
  t772 = t767 * t53
  t773 = t772 * t712
  t775 = -0.18630000000000000000000000000000000000000000000000e-3 * t763 - 0.58357848829441957078558138724472142547316887244435e-4 * t773
  t776 = t775 * t371
  t777 = t776 * t373
  t779 = t372 ** 2
  t781 = t371 / t779
  t783 = t763 + 0.31324663891273192205345216706640978286267787034050e0 * t773
  t784 = t781 * t783
  t786 = t364 * t378
  t790 = 0.1e1 / t377 / t366
  t792 = t376 * t790 * t53
  t795 = -0.30180600000000000000000000000000000000000000000000e-2 * t786 * t762 - 0.94539715103695970467264184733644870926653357335985e-3 * t792 * t712
  t796 = t795 * t381
  t798 = 0.1e1 / t376
  t799 = t798 * t367
  t803 = t383 * t366 * t53
  t806 = -0.10e2 / 0.81e2 * t799 * t762 - 0.38672424557127397784376810748939479365762700042037e-1 * t803 * t712
  t808 = t763 * t374 + 0.31324663891273192205345216706640978286267787034050e0 * t768 * t736 + t369 * t777 - t369 * t784 - t796 * t386 + t382 * t806
  t813 = f.my_piecewise3(t281, 0, -0.3e1 / 0.8e1 * t5 * t684 * t388 - t397 - 0.3e1 / 0.8e1 * t5 * t688 * t808)
  t817 = 0.2e1 * t408
  t818 = f.my_piecewise5(t10, 0, t14, 0, t817)
  t822 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t402 * t669 * t26 + 0.4e1 / 0.3e1 * t21 * t818)
  t829 = t5 * t672 * t149 * t140
  t837 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t822 * t30 * t140 - t829 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t673 * t274 - t422 / 0.8e1 + t432 - t434 / 0.8e1)
  t841 = f.my_piecewise5(t14, 0, t10, 0, -t817)
  t845 = f.my_piecewise3(t284, 0, 0.4e1 / 0.9e1 * t642 * t680 * t287 + 0.4e1 / 0.3e1 * t285 * t841)
  t852 = t5 * t683 * t149 * t388
  t859 = t5 * t394 * t808
  t862 = f.my_piecewise3(t281, 0, -0.3e1 / 0.8e1 * t5 * t845 * t30 * t388 - t852 / 0.8e1 - t658 / 0.8e1 + t663 - 0.3e1 / 0.8e1 * t5 * t291 * t808 - t859 / 0.8e1)
  d12 = t279 + t399 + t678 + t813 + t6 * (t837 + t862)
  t867 = t669 ** 2
  t871 = 0.2e1 * t23 + 0.2e1 * t408
  t872 = f.my_piecewise5(t10, 0, t14, 0, t871)
  t876 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t402 * t867 + 0.4e1 / 0.3e1 * t21 * t872)
  t883 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t876 * t30 * t140 - t829 / 0.4e1 + t432)
  t884 = t680 ** 2
  t888 = f.my_piecewise5(t14, 0, t10, 0, -t871)
  t892 = f.my_piecewise3(t284, 0, 0.4e1 / 0.9e1 * t642 * t884 + 0.4e1 / 0.3e1 * t285 * t888)
  t906 = t346 * t295
  t915 = t307 ** 2
  t927 = 0.1e1 / t316 / t346
  t928 = t314 * t927
  t931 = t738 ** 2
  t935 = s2 * t927
  t937 = 0.40e2 / 0.9e1 * tau1 * t711 - 0.11e2 / 0.9e1 * t935
  t938 = t937 * t53
  t945 = t335 ** 2
  t949 = t733 ** 2
  t954 = t719 ** 2
  t964 = t85 * t935
  t966 = t938 * t721 / 0.4e1 - t720 * t58 * t725 * t733 / 0.4e1 + 0.27e2 / 0.80e2 * t331 / t336 / t945 * t949 - 0.9e1 / 0.40e2 * t726 * (0.22222222222222222222222222222222222222222222222222e0 * t938 * t332 + 0.24691358024691358024691358024691358024691358024692e0 * t954 * t92 * t94 + 0.12345679012345679012345679012345679012345679012346e0 * t729 * t94 * t937) + 0.22e2 / 0.81e2 * t964
  t977 = t753 ** 2
  t981 = t292 * t689 * t303
  t984 = 0.1e1 / t315 / t906
  t986 = t95 * t292 * t984
  t997 = (0.50379140625000000000000000000000000000000000000000e-1 * t293 / t347 * t309 - 0.23615222167968750000000000000000000000000000000000e-2 * t694 / t906 * t703 + 0.24599189758300781250000000000000000000000000000000e-4 * t693 * t293 * t759 / t698 / t299 / t915) * t53 * t319 / 0.24e2 - 0.2e1 / 0.9e1 * t707 * t712 + 0.11e2 / 0.27e2 * t313 * t928 + 0.292e3 / 0.2025e4 * t931 + 0.292e3 / 0.2025e4 * t342 * t966 - 0.73e2 / 0.97200e5 * t966 * t354 - 0.73e2 / 0.97200e5 * t738 * t743 * t753 + 0.73e2 / 0.388800e6 * t342 / t354 / t353 * t977 - 0.73e2 / 0.194400e6 * t744 * (0.972e3 * t981 + 0.15200e5 / 0.9e1 * t986) + 0.89531158068346251041978319324252362915168381814727e-3 * t986 + 0.11746748959227447077004456264990366857350420137768e-1 * t981 + 0.76658950617283950617283950617283950617283950617287e-2 * t359 / t360 / t294
  t998 = t997 * t368
  t1000 = t762 * t766
  t1025 = t1000 * t53 * t712
  t1029 = t94 * t292 * t984
  t1030 = t786 * t92 * t1029
  t1032 = t772 * t928
  t1038 = t775 ** 2
  t1048 = t783 ** 2
  t1058 = t762 ** 2
  t1078 = t795 ** 2
  t1101 = t998 * t374 + 0.62649327782546384410690433413281956572535574068100e0 * t1000 * t374 * t736 + 0.2e1 * t763 * t777 - 0.2e1 * t763 * t784 + 0.14718518518518518518518518518518518518518518518519e0 * t786 * t374 * t986 + 0.62649327782546384410690433413281956572535574068100e0 * t767 * t776 * t373 * t53 * t712 - 0.62649327782546384410690433413281956572535574068100e0 * t767 * t781 * t85 * t717 * t783 - 0.11485710093466837141959912792435025371631521912485e1 * t768 * t964 + t369 * (-0.18630000000000000000000000000000000000000000000000e-3 * t998 - 0.11671569765888391415711627744894428509463377448887e-3 * t1025 - 0.27420600000000000000000000000000000000000000000001e-4 * t1030 + 0.21397877904128717595471317532306452267349525322960e-3 * t1032) * t371 * t373 + t369 * t1038 * t371 * t373 - 0.2e1 * t369 * t775 * t784 + 0.2e1 * t369 * t371 / t779 / t372 * t1048 - t369 * t781 * (t998 + 0.62649327782546384410690433413281956572535574068100e0 * t1025 + 0.14718518518518518518518518518518518518518518518519e0 * t1030 - 0.11485710093466837141959912792435025371631521912485e1 * t1032) - (-0.30180600000000000000000000000000000000000000000000e-2 * t1058 * t378 - 0.37815886041478388186905673893457948370661342934394e-2 * t364 * t790 * t762 * t736 - 0.30180600000000000000000000000000000000000000000000e-2 * t786 * t997 - 0.74035620000000000000000000000000000000000000000003e-3 * t376 / t377 / t367 * t92 * t1029 + 0.34664562204688522504663534402336452673106231023195e-2 * t792 * t928) * t381 * t386 - t1078 * t381 * t386 - 0.2e1 * t796 * t806 + t382 * (0.20e2 / 0.81e2 / t376 / t364 * t367 * t1058 + 0.77344849114254795568753621497878958731525400084074e-1 * t798 * t366 * t762 * t736 - 0.10e2 / 0.81e2 * t799 * t997 + 0.60570035055631763450693491845755220240816948635881e-2 * t383 * t92 * t1029 + 0.14179889004280045854271497274611142434112990015414e0 * t803 * t928)
  t1106 = f.my_piecewise3(t281, 0, -0.3e1 / 0.8e1 * t5 * t892 * t30 * t388 - t852 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t684 * t808 + t663 - t859 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t688 * t1101)
  d22 = 0.2e1 * t678 + 0.2e1 * t813 + t6 * (t883 + t1106)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = s0 ** 2
  t45 = t44 * s0
  t46 = r0 ** 2
  t47 = t46 * r0
  t48 = 0.1e1 / t47
  t50 = tau0 ** 2
  t51 = t50 * tau0
  t55 = 0.1e1 / t50
  t56 = t44 / t46 * t55
  t58 = 0.1e1 + t56 / 0.64e2
  t59 = t58 ** 2
  t61 = 0.1e1 / t51 / t59
  t65 = 6 ** (0.1e1 / 0.3e1)
  t66 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t45 * t48 * t61) * t65
  t67 = jnp.pi ** 2
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = t70 * s0
  t72 = r0 ** (0.1e1 / 0.3e1)
  t73 = t72 ** 2
  t75 = 0.1e1 / t73 / t46
  t76 = t71 * t75
  t82 = s0 * t75
  t84 = tau0 / t73 / r0 - t82 / 0.8e1
  t85 = t84 * t65
  t88 = 0.5e1 / 0.9e1 * t85 * t70 - 0.1e1
  t89 = t70 * t88
  t92 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t85 * t89
  t93 = jnp.sqrt(t92)
  t94 = 0.1e1 / t93
  t97 = t65 * t70
  t98 = t97 * t82
  t100 = 0.9e1 / 0.20e2 * t88 * t94 + t98 / 0.36e2
  t101 = t100 ** 2
  t104 = t65 ** 2
  t106 = 0.1e1 / t68 / t67
  t107 = t104 * t106
  t108 = t46 ** 2
  t109 = t108 * r0
  t113 = t107 * t44 / t72 / t109
  t115 = 0.162e3 * t56 + 0.50e2 * t113
  t116 = jnp.sqrt(t115)
  t121 = t67 ** 2
  t122 = 0.1e1 / t121
  t123 = t122 * t45
  t124 = t108 ** 2
  t125 = 0.1e1 / t124
  t128 = t66 * t76 / 0.24e2 + 0.146e3 / 0.2025e4 * t101 - 0.73e2 / 0.97200e5 * t100 * t116 + 0.26505934954444613795322528747311554810411691984623e-4 * t113 + 0.19577914932045745128340760441650611428917366896280e-2 * t56 + 0.10647076474622770919067215363511659807956104252401e-3 * t123 * t125
  t130 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t98
  t131 = t130 ** 2
  t132 = 0.1e1 / t131
  t133 = t128 * t132
  t135 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t133)
  t136 = 0.1e1 + t133
  t137 = 0.1e1 / t136
  t138 = t135 * t137
  t140 = t128 ** 2
  t141 = t131 ** 2
  t142 = 0.1e1 / t141
  t145 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t140 * t142)
  t146 = 0.1e1 - t145
  t147 = 0.1e1 / t128
  t150 = 0.10e2 / 0.81e2 * t147 * t131 - 0.1e1
  t152 = t133 * t138 + t146 * t150 + 0.1e1
  t158 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t159 = t42 ** 2
  t160 = 0.1e1 / t159
  t161 = t158 * t160
  t165 = t158 * t42
  t166 = 0.1e1 / t108
  t170 = t44 ** 2
  t171 = t170 * s0
  t172 = t108 * t46
  t173 = 0.1e1 / t172
  t175 = t50 ** 2
  t180 = 0.1e1 / t175 / tau0 / t59 / t58
  t184 = (-0.12594785156250000000000000000000000000000000000000e-1 * t45 * t166 * t61 + 0.26239135742187500000000000000000000000000000000000e-3 * t171 * t173 * t180) * t65
  t188 = 0.1e1 / t73 / t47
  t189 = t71 * t188
  t194 = s0 * t188
  t196 = -0.5e1 / 0.3e1 * tau0 * t75 + t194 / 0.3e1
  t197 = t196 * t65
  t198 = t70 * t94
  t202 = 0.1e1 / t93 / t92
  t203 = t88 * t202
  t206 = t84 * t104
  t207 = t106 * t196
  t210 = 0.22222222222222222222222222222222222222222222222222e0 * t197 * t89 + 0.12345679012345679012345679012345679012345679012346e0 * t206 * t207
  t213 = t97 * t194
  t215 = t197 * t198 / 0.4e1 - 0.9e1 / 0.40e2 * t203 * t210 - 0.2e1 / 0.27e2 * t213
  t220 = 0.1e1 / t116
  t221 = t100 * t220
  t223 = t44 * t48 * t55
  t228 = t107 * t44 / t72 / t172
  t230 = -0.324e3 * t223 - 0.800e3 / 0.3e1 * t228
  t236 = 0.1e1 / t124 / r0
  t239 = t184 * t76 / 0.24e2 - t66 * t189 / 0.9e1 + 0.292e3 / 0.2025e4 * t100 * t215 - 0.73e2 / 0.97200e5 * t215 * t116 - 0.73e2 / 0.194400e6 * t221 * t230 - 0.14136498642370460690838681998566162565552902391799e-3 * t228 - 0.39155829864091490256681520883301222857834733792560e-2 * t223 - 0.85176611796982167352537722908093278463648834019208e-3 * t123 * t236
  t240 = t239 * t132
  t242 = t131 * t130
  t243 = 0.1e1 / t242
  t244 = t128 * t243
  t245 = t244 * t138
  t249 = t244 * t65
  t250 = t249 * t189
  t252 = -0.18630000000000000000000000000000000000000000000000e-3 * t240 - 0.58357848829441957078558138724472142547316887244435e-4 * t250
  t253 = t252 * t135
  t254 = t253 * t137
  t256 = t136 ** 2
  t257 = 0.1e1 / t256
  t258 = t135 * t257
  t260 = t240 + 0.31324663891273192205345216706640978286267787034050e0 * t250
  t261 = t258 * t260
  t263 = t128 * t142
  t267 = 0.1e1 / t141 / t130
  t269 = t140 * t267 * t65
  t272 = -0.30180600000000000000000000000000000000000000000000e-2 * t263 * t239 - 0.94539715103695970467264184733644870926653357335985e-3 * t269 * t189
  t273 = t272 * t145
  t275 = 0.1e1 / t140
  t276 = t275 * t131
  t280 = t147 * t130 * t65
  t283 = -0.10e2 / 0.81e2 * t276 * t239 - 0.38672424557127397784376810748939479365762700042037e-1 * t280 * t189
  t285 = t240 * t138 + 0.31324663891273192205345216706640978286267787034050e0 * t245 * t213 + t133 * t254 - t133 * t261 - t273 * t150 + t146 * t283
  t289 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t290 = t289 * f.p.zeta_threshold
  t292 = f.my_piecewise3(t20, t290, t21 * t19)
  t294 = 0.1e1 / t159 / t6
  t295 = t292 * t294
  t299 = t292 * t160
  t303 = t292 * t42
  t304 = 0.1e1 / t109
  t308 = t108 * t47
  t313 = t170 * t45
  t317 = t59 ** 2
  t319 = 0.1e1 / t175 / t51 / t317
  t323 = (0.50379140625000000000000000000000000000000000000000e-1 * t45 * t304 * t61 - 0.23615222167968750000000000000000000000000000000000e-2 * t171 / t308 * t180 + 0.24599189758300781250000000000000000000000000000000e-4 * t313 * t236 * t319) * t65
  t329 = 0.1e1 / t73 / t108
  t330 = t71 * t329
  t333 = t215 ** 2
  t337 = s0 * t329
  t339 = 0.40e2 / 0.9e1 * tau0 * t188 - 0.11e2 / 0.9e1 * t337
  t340 = t339 * t65
  t343 = t70 * t202
  t344 = t343 * t210
  t347 = t92 ** 2
  t349 = 0.1e1 / t93 / t347
  t350 = t88 * t349
  t351 = t210 ** 2
  t356 = t196 ** 2
  t363 = 0.22222222222222222222222222222222222222222222222222e0 * t340 * t89 + 0.24691358024691358024691358024691358024691358024692e0 * t356 * t104 * t106 + 0.12345679012345679012345679012345679012345679012346e0 * t206 * t106 * t339
  t366 = t97 * t337
  t368 = t340 * t198 / 0.4e1 - t197 * t344 / 0.4e1 + 0.27e2 / 0.80e2 * t350 * t351 - 0.9e1 / 0.40e2 * t203 * t363 + 0.22e2 / 0.81e2 * t366
  t373 = t215 * t220
  t377 = 0.1e1 / t116 / t115
  t378 = t100 * t377
  t379 = t230 ** 2
  t383 = t44 * t166 * t55
  t386 = 0.1e1 / t72 / t308
  t387 = t44 * t386
  t388 = t107 * t387
  t390 = 0.972e3 * t383 + 0.15200e5 / 0.9e1 * t388
  t396 = 0.1e1 / t124 / t46
  t399 = t323 * t76 / 0.24e2 - 0.2e1 / 0.9e1 * t184 * t189 + 0.11e2 / 0.27e2 * t66 * t330 + 0.292e3 / 0.2025e4 * t333 + 0.292e3 / 0.2025e4 * t100 * t368 - 0.73e2 / 0.97200e5 * t368 * t116 - 0.73e2 / 0.97200e5 * t373 * t230 + 0.73e2 / 0.388800e6 * t378 * t379 - 0.73e2 / 0.194400e6 * t221 * t390 + 0.89531158068346251041978319324252362915168381814727e-3 * t388 + 0.11746748959227447077004456264990366857350420137768e-1 * t383 + 0.76658950617283950617283950617283950617283950617287e-2 * t123 * t396
  t400 = t399 * t132
  t402 = t239 * t243
  t403 = t402 * t138
  t410 = t263 * t138
  t413 = t244 * t253
  t414 = t137 * t65
  t415 = t414 * t189
  t418 = t244 * t258
  t420 = t97 * t194 * t260
  t426 = t402 * t65
  t427 = t426 * t189
  t429 = t263 * t104
  t430 = t106 * t44
  t431 = t430 * t386
  t432 = t429 * t431
  t434 = t249 * t330
  t436 = -0.18630000000000000000000000000000000000000000000000e-3 * t400 - 0.11671569765888391415711627744894428509463377448887e-3 * t427 - 0.27420600000000000000000000000000000000000000000001e-4 * t432 + 0.21397877904128717595471317532306452267349525322960e-3 * t434
  t437 = t436 * t135
  t438 = t437 * t137
  t440 = t252 ** 2
  t441 = t440 * t135
  t442 = t441 * t137
  t444 = t133 * t252
  t448 = 0.1e1 / t256 / t136
  t449 = t135 * t448
  t450 = t260 ** 2
  t451 = t449 * t450
  t457 = t400 + 0.62649327782546384410690433413281956572535574068100e0 * t427 + 0.14718518518518518518518518518518518518518518518519e0 * t432 - 0.11485710093466837141959912792435025371631521912485e1 * t434
  t458 = t258 * t457
  t460 = t239 ** 2
  t463 = t128 * t267
  t464 = t463 * t239
  t470 = 0.1e1 / t141 / t131
  t472 = t140 * t470 * t104
  t477 = -0.30180600000000000000000000000000000000000000000000e-2 * t460 * t142 - 0.37815886041478388186905673893457948370661342934394e-2 * t464 * t213 - 0.30180600000000000000000000000000000000000000000000e-2 * t263 * t399 - 0.74035620000000000000000000000000000000000000000003e-3 * t472 * t431 + 0.34664562204688522504663534402336452673106231023195e-2 * t269 * t330
  t478 = t477 * t145
  t480 = t272 ** 2
  t481 = t480 * t145
  t486 = 0.1e1 / t140 / t128
  t487 = t486 * t131
  t490 = t275 * t130
  t491 = t490 * t239
  t496 = t147 * t104
  t501 = 0.20e2 / 0.81e2 * t487 * t460 + 0.77344849114254795568753621497878958731525400084074e-1 * t491 * t213 - 0.10e2 / 0.81e2 * t276 * t399 + 0.60570035055631763450693491845755220240816948635881e-2 * t496 * t431 + 0.14179889004280045854271497274611142434112990015414e0 * t280 * t330
  t503 = t400 * t138 + 0.62649327782546384410690433413281956572535574068100e0 * t403 * t213 + 0.2e1 * t240 * t254 - 0.2e1 * t240 * t261 + 0.14718518518518518518518518518518518518518518518519e0 * t410 * t388 + 0.62649327782546384410690433413281956572535574068100e0 * t413 * t415 - 0.62649327782546384410690433413281956572535574068100e0 * t418 * t420 - 0.11485710093466837141959912792435025371631521912485e1 * t245 * t366 + t133 * t438 + t133 * t442 - 0.2e1 * t444 * t261 + 0.2e1 * t133 * t451 - t133 * t458 - t478 * t150 - t481 * t150 - 0.2e1 * t273 * t283 + t146 * t501
  t508 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t152 - t5 * t161 * t152 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t165 * t285 + t5 * t295 * t152 / 0.12e2 - t5 * t299 * t285 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t303 * t503)
  t510 = r1 <= f.p.dens_threshold
  t511 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t512 = 0.1e1 + t511
  t513 = t512 <= f.p.zeta_threshold
  t514 = t512 ** (0.1e1 / 0.3e1)
  t515 = t514 ** 2
  t516 = 0.1e1 / t515
  t518 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t519 = t518 ** 2
  t523 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t527 = f.my_piecewise3(t513, 0, 0.4e1 / 0.9e1 * t516 * t519 + 0.4e1 / 0.3e1 * t514 * t523)
  t529 = s2 ** 2
  t530 = t529 * s2
  t531 = r1 ** 2
  t535 = tau1 ** 2
  t541 = t529 / t531 / t535
  t544 = (0.1e1 + t541 / 0.64e2) ** 2
  t552 = r1 ** (0.1e1 / 0.3e1)
  t553 = t552 ** 2
  t555 = 0.1e1 / t553 / t531
  t562 = s2 * t555
  t565 = (tau1 / t553 / r1 - t562 / 0.8e1) * t65
  t568 = 0.5e1 / 0.9e1 * t565 * t70 - 0.1e1
  t573 = jnp.sqrt(0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t565 * t70 * t568)
  t577 = t97 * t562
  t579 = 0.9e1 / 0.20e2 * t568 / t573 + t577 / 0.36e2
  t580 = t579 ** 2
  t583 = t531 ** 2
  t588 = t107 * t529 / t552 / t583 / r1
  t591 = jnp.sqrt(0.162e3 * t541 + 0.50e2 * t588)
  t597 = t583 ** 2
  t601 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t530 / t531 / r1 / t535 / tau1 / t544) * t65 * t70 * s2 * t555 / 0.24e2 + 0.146e3 / 0.2025e4 * t580 - 0.73e2 / 0.97200e5 * t579 * t591 + 0.26505934954444613795322528747311554810411691984623e-4 * t588 + 0.19577914932045745128340760441650611428917366896280e-2 * t541 + 0.10647076474622770919067215363511659807956104252401e-3 * t122 * t530 / t597
  t604 = (0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t577) ** 2
  t606 = t601 / t604
  t608 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t606)
  t613 = t601 ** 2
  t614 = t604 ** 2
  t618 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t613 / t614)
  t625 = 0.1e1 + t606 * t608 / (0.1e1 + t606) + (0.1e1 - t618) * (0.10e2 / 0.81e2 / t601 * t604 - 0.1e1)
  t631 = f.my_piecewise3(t513, 0, 0.4e1 / 0.3e1 * t514 * t518)
  t637 = f.my_piecewise3(t513, t290, t514 * t512)
  t643 = f.my_piecewise3(t510, 0, -0.3e1 / 0.8e1 * t5 * t527 * t42 * t625 - t5 * t631 * t160 * t625 / 0.4e1 + t5 * t637 * t294 * t625 / 0.12e2)
  t653 = t24 ** 2
  t657 = 0.6e1 * t33 - 0.6e1 * t16 / t653
  t658 = f.my_piecewise5(t10, 0, t14, 0, t657)
  t662 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t658)
  t685 = 0.1e1 / t159 / t24
  t709 = t256 ** 2
  t722 = t133 * t436
  t743 = t170 ** 2
  t748 = t175 ** 2
  t765 = 0.1e1 / t73 / t109
  t766 = t71 * t765
  t773 = s0 * t765
  t775 = -0.440e3 / 0.27e2 * tau0 * t329 + 0.154e3 / 0.27e2 * t773
  t776 = t775 * t65
  t809 = t97 * t773
  t811 = t776 * t198 / 0.4e1 - 0.3e1 / 0.8e1 * t340 * t344 + 0.9e1 / 0.16e2 * t197 * t70 * t349 * t351 - 0.3e1 / 0.8e1 * t197 * t343 * t363 - 0.27e2 / 0.32e2 * t88 / t93 / t347 / t92 * t351 * t210 + 0.81e2 / 0.80e2 * t350 * t210 * t363 - 0.9e1 / 0.40e2 * t203 * (0.22222222222222222222222222222222222222222222222222e0 * t776 * t89 + 0.74074074074074074074074074074074074074074074074076e0 * t339 * t104 * t207 + 0.12345679012345679012345679012345679012345679012346e0 * t206 * t106 * t775) - 0.308e3 / 0.243e3 * t809
  t824 = t115 ** 2
  t835 = t44 * t304 * t55
  t838 = 0.1e1 / t72 / t124
  t840 = t107 * t44 * t838
  t848 = 0.1e1 / t124 / t47
  t849 = t123 * t848
  t851 = (-0.25189570312500000000000000000000000000000000000000e0 * t45 * t173 * t61 + 0.19679351806640625000000000000000000000000000000000e-1 * t171 * t125 * t180 - 0.44278541564941406250000000000000000000000000000000e-3 * t313 * t396 * t319 + 0.30748987197875976562500000000000000000000000000000e-5 * t743 * s0 / t124 / t108 / t748 / tau0 / t317 / t58) * t65 * t76 / 0.24e2 - t323 * t189 / 0.3e1 + 0.11e2 / 0.9e1 * t184 * t330 - 0.154e3 / 0.81e2 * t66 * t766 + 0.292e3 / 0.675e3 * t215 * t368 + 0.292e3 / 0.2025e4 * t100 * t811 - 0.73e2 / 0.97200e5 * t811 * t116 - 0.73e2 / 0.64800e5 * t368 * t220 * t230 + 0.73e2 / 0.129600e6 * t215 * t377 * t379 - 0.73e2 / 0.64800e5 * t373 * t390 - 0.73e2 / 0.259200e6 * t100 / t116 / t824 * t379 * t230 + 0.73e2 / 0.129600e6 * t378 * t230 * t390 - 0.73e2 / 0.194400e6 * t221 * (-0.3888e4 * t835 - 0.334400e6 / 0.27e2 * t840) - 0.65656182583453917430784100837785066137790146664133e-2 * t840 - 0.46986995836909788308017825059961467429401680551072e-1 * t835 - 0.76658950617283950617283950617283950617283950617287e-1 * t849
  t852 = t851 * t132
  t853 = t399 * t243
  t855 = t853 * t65 * t189
  t857 = t239 * t142
  t859 = t857 * t104 * t431
  t861 = t426 * t330
  t863 = t463 * t849
  t865 = t430 * t838
  t866 = t429 * t865
  t868 = t249 * t766
  t931 = -t480 * t272 * t145 * t150 - t133 * t258 * (t852 + 0.93973991673819576616035650119922934858803361102150e0 * t855 + 0.44155555555555555555555555555555555555555555555557e0 * t859 - 0.34457130280400511425879738377305076114894565737455e1 * t861 + 0.55326317468408740366240840529862776759834749188142e0 * t863 - 0.16190370370370370370370370370370370370370370370371e1 * t866 + 0.53599980436178573329146259698030118400947102258263e1 * t868) + 0.55326317468408740366240840529862776759834749188142e0 * t463 * t135 * t137 * t122 * t45 * t848 - 0.3e1 * t133 * t440 * t261 - 0.3e1 * t444 * t458 + t852 * t138 - 0.3e1 * t481 * t283 + 0.6e1 * t444 * t451 - (-0.90541800000000000000000000000000000000000000000000e-2 * t857 * t399 - 0.56723829062217582280358510840186922555992014401591e-2 * t460 * t267 * t65 * t189 - 0.44421372000000000000000000000000000000000000000002e-2 * t128 * t470 * t239 * t388 - 0.56723829062217582280358510840186922555992014401591e-2 * t463 * t399 * t213 + 0.20798737322813113502798120641401871603863738613917e-1 * t464 * t366 - 0.30180600000000000000000000000000000000000000000000e-2 * t263 * t851 - 0.41744536424676420737434207792389413006946715783691e-2 * t140 / t141 / t242 * t849 + 0.81439182000000000000000000000000000000000000000004e-2 * t472 * t865 - 0.16176795695521310502176316054423677914116241144158e-1 * t269 * t766) * t145 * t150 + 0.3e1 * t400 * t254 + t133 * (-0.18630000000000000000000000000000000000000000000000e-3 * t852 - 0.17507354648832587123567441617341642764195066173330e-3 * t855 - 0.82261800000000000000000000000000000000000000000003e-4 * t859 + 0.64193633712386152786413952596919356802048575968879e-3 * t861 - 0.10307292944364548330230668590713435310357213773751e-3 * t863 + 0.30162660000000000000000000000000000000000000000002e-3 * t866 - 0.99856763552600682112199481817430110580964451507147e-3 * t868) * t135 * t137
  t996 = t140 ** 2
  t1027 = -0.34457130280400511425879738377305076114894565737455e1 * t413 * t414 * t330 + 0.93973991673819576616035650119922934858803361102150e0 * t244 * t441 * t415 + 0.18794798334763915323207130023984586971760672220430e1 * t244 * t449 * t97 * t194 * t450 + 0.34457130280400511425879738377305076114894565737455e1 * t418 * t97 * t337 * t260 - 0.18794798334763915323207130023984586971760672220430e1 * t402 * t258 * t420 + 0.18794798334763915323207130023984586971760672220430e1 * t402 * t253 * t415 - 0.44155555555555555555555555555555555555555555555557e0 * t263 * t258 * t107 * t387 * t260 + 0.44155555555555555555555555555555555555555555555557e0 * t263 * t253 * t137 * t104 * t431 + 0.93973991673819576616035650119922934858803361102150e0 * t244 * t437 * t415 - 0.93973991673819576616035650119922934858803361102150e0 * t418 * t97 * t194 * t457 + t146 * (-0.20e2 / 0.27e2 / t996 * t131 * t460 * t239 - 0.23203454734276438670626086449363687619457620025222e0 * t486 * t130 * t460 * t213 + 0.20e2 / 0.27e2 * t487 * t239 * t399 - 0.18171010516689529035208047553726566072245084590764e-1 * t275 * t104 * t106 * t387 * t239 + 0.11601727367138219335313043224681843809728810012611e0 * t490 * t399 * t213 - 0.42539667012840137562814491823833427302338970046241e0 * t491 * t366 - 0.10e2 / 0.81e2 * t276 * t851 - 0.66627038561194939795762841030330742264898643499470e-1 * t496 * t865 - 0.66172815353306880653266987281518664692527286738599e0 * t280 * t766)
  t1034 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t662 * t42 * t152 - 0.3e1 / 0.8e1 * t5 * t41 * t160 * t152 - 0.9e1 / 0.8e1 * t5 * t43 * t285 + t5 * t158 * t294 * t152 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t161 * t285 - 0.9e1 / 0.8e1 * t5 * t165 * t503 - 0.5e1 / 0.36e2 * t5 * t292 * t685 * t152 + t5 * t295 * t285 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t299 * t503 - 0.3e1 / 0.8e1 * t5 * t303 * (0.3e1 * t240 * t438 - 0.3e1 * t478 * t283 - 0.3e1 * t477 * t272 * t145 * t150 + 0.6e1 * t133 * t135 * t448 * t260 * t457 - 0.6e1 * t133 * t135 / t709 * t450 * t260 - 0.3e1 * t400 * t261 + t133 * t440 * t252 * t135 * t137 + 0.3e1 * t722 * t254 - 0.6e1 * t240 * t252 * t261 - 0.3e1 * t722 * t261 + t931 - 0.18794798334763915323207130023984586971760672220430e1 * t244 * t253 * t257 * t420 + 0.3e1 * t240 * t442 - 0.3e1 * t273 * t501 + 0.6e1 * t240 * t451 - 0.3e1 * t240 * t458 - 0.16190370370370370370370370370370370370370370370371e1 * t410 * t840 + 0.53599980436178573329146259698030118400947102258263e1 * t245 * t809 - 0.34457130280400511425879738377305076114894565737455e1 * t403 * t366 + 0.44155555555555555555555555555555555555555555555557e0 * t857 * t138 * t388 + 0.93973991673819576616035650119922934858803361102150e0 * t853 * t138 * t213 + t1027))
  t1044 = f.my_piecewise5(t14, 0, t10, 0, -t657)
  t1048 = f.my_piecewise3(t513, 0, -0.8e1 / 0.27e2 / t515 / t512 * t519 * t518 + 0.4e1 / 0.3e1 * t516 * t518 * t523 + 0.4e1 / 0.3e1 * t514 * t1044)
  t1066 = f.my_piecewise3(t510, 0, -0.3e1 / 0.8e1 * t5 * t1048 * t42 * t625 - 0.3e1 / 0.8e1 * t5 * t527 * t160 * t625 + t5 * t631 * t294 * t625 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t637 * t685 * t625)
  d111 = 0.3e1 * t508 + 0.3e1 * t643 + t6 * (t1034 + t1066)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = s0 ** 2
  t57 = t56 * s0
  t58 = r0 ** 2
  t59 = t58 * r0
  t60 = 0.1e1 / t59
  t62 = tau0 ** 2
  t63 = t62 * tau0
  t67 = 0.1e1 / t62
  t68 = t56 / t58 * t67
  t70 = 0.1e1 + t68 / 0.64e2
  t71 = t70 ** 2
  t73 = 0.1e1 / t63 / t71
  t77 = 6 ** (0.1e1 / 0.3e1)
  t78 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t57 * t60 * t73) * t77
  t79 = jnp.pi ** 2
  t80 = t79 ** (0.1e1 / 0.3e1)
  t81 = t80 ** 2
  t82 = 0.1e1 / t81
  t83 = t82 * s0
  t84 = r0 ** (0.1e1 / 0.3e1)
  t85 = t84 ** 2
  t87 = 0.1e1 / t85 / t58
  t88 = t83 * t87
  t94 = s0 * t87
  t96 = tau0 / t85 / r0 - t94 / 0.8e1
  t97 = t96 * t77
  t100 = 0.5e1 / 0.9e1 * t97 * t82 - 0.1e1
  t101 = t82 * t100
  t104 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t97 * t101
  t105 = jnp.sqrt(t104)
  t106 = 0.1e1 / t105
  t109 = t77 * t82
  t110 = t109 * t94
  t112 = 0.9e1 / 0.20e2 * t100 * t106 + t110 / 0.36e2
  t113 = t112 ** 2
  t116 = t77 ** 2
  t118 = 0.1e1 / t80 / t79
  t119 = t116 * t118
  t120 = t58 ** 2
  t121 = t120 * r0
  t125 = t119 * t56 / t84 / t121
  t127 = 0.162e3 * t68 + 0.50e2 * t125
  t128 = jnp.sqrt(t127)
  t133 = t79 ** 2
  t134 = 0.1e1 / t133
  t135 = t134 * t57
  t136 = t120 ** 2
  t137 = 0.1e1 / t136
  t140 = t78 * t88 / 0.24e2 + 0.146e3 / 0.2025e4 * t113 - 0.73e2 / 0.97200e5 * t112 * t128 + 0.26505934954444613795322528747311554810411691984623e-4 * t125 + 0.19577914932045745128340760441650611428917366896280e-2 * t68 + 0.10647076474622770919067215363511659807956104252401e-3 * t135 * t137
  t142 = 0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t110
  t143 = t142 ** 2
  t144 = 0.1e1 / t143
  t145 = t140 * t144
  t147 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t145)
  t148 = 0.1e1 + t145
  t149 = 0.1e1 / t148
  t150 = t147 * t149
  t152 = t140 ** 2
  t153 = t143 ** 2
  t154 = 0.1e1 / t153
  t157 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t152 * t154)
  t158 = 0.1e1 - t157
  t159 = 0.1e1 / t140
  t162 = 0.10e2 / 0.81e2 * t159 * t143 - 0.1e1
  t164 = t145 * t150 + t158 * t162 + 0.1e1
  t173 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t174 = t54 ** 2
  t175 = 0.1e1 / t174
  t176 = t173 * t175
  t180 = t173 * t54
  t181 = 0.1e1 / t120
  t185 = t56 ** 2
  t186 = t185 * s0
  t187 = t120 * t58
  t188 = 0.1e1 / t187
  t190 = t62 ** 2
  t195 = 0.1e1 / t190 / tau0 / t71 / t70
  t199 = (-0.12594785156250000000000000000000000000000000000000e-1 * t57 * t181 * t73 + 0.26239135742187500000000000000000000000000000000000e-3 * t186 * t188 * t195) * t77
  t203 = 0.1e1 / t85 / t59
  t204 = t83 * t203
  t209 = s0 * t203
  t211 = -0.5e1 / 0.3e1 * tau0 * t87 + t209 / 0.3e1
  t212 = t211 * t77
  t213 = t82 * t106
  t217 = 0.1e1 / t105 / t104
  t218 = t100 * t217
  t221 = t96 * t116
  t222 = t118 * t211
  t225 = 0.22222222222222222222222222222222222222222222222222e0 * t212 * t101 + 0.12345679012345679012345679012345679012345679012346e0 * t221 * t222
  t228 = t109 * t209
  t230 = t212 * t213 / 0.4e1 - 0.9e1 / 0.40e2 * t218 * t225 - 0.2e1 / 0.27e2 * t228
  t235 = 0.1e1 / t128
  t236 = t112 * t235
  t238 = t56 * t60 * t67
  t243 = t119 * t56 / t84 / t187
  t245 = -0.324e3 * t238 - 0.800e3 / 0.3e1 * t243
  t250 = t136 * r0
  t251 = 0.1e1 / t250
  t254 = t199 * t88 / 0.24e2 - t78 * t204 / 0.9e1 + 0.292e3 / 0.2025e4 * t112 * t230 - 0.73e2 / 0.97200e5 * t230 * t128 - 0.73e2 / 0.194400e6 * t236 * t245 - 0.14136498642370460690838681998566162565552902391799e-3 * t243 - 0.39155829864091490256681520883301222857834733792560e-2 * t238 - 0.85176611796982167352537722908093278463648834019208e-3 * t135 * t251
  t255 = t254 * t144
  t257 = t143 * t142
  t258 = 0.1e1 / t257
  t259 = t140 * t258
  t260 = t259 * t150
  t264 = t259 * t77
  t265 = t264 * t204
  t267 = -0.18630000000000000000000000000000000000000000000000e-3 * t255 - 0.58357848829441957078558138724472142547316887244435e-4 * t265
  t268 = t267 * t147
  t269 = t268 * t149
  t271 = t148 ** 2
  t272 = 0.1e1 / t271
  t273 = t147 * t272
  t275 = t255 + 0.31324663891273192205345216706640978286267787034050e0 * t265
  t276 = t273 * t275
  t278 = t140 * t154
  t282 = 0.1e1 / t153 / t142
  t284 = t152 * t282 * t77
  t287 = -0.30180600000000000000000000000000000000000000000000e-2 * t278 * t254 - 0.94539715103695970467264184733644870926653357335985e-3 * t284 * t204
  t288 = t287 * t157
  t290 = 0.1e1 / t152
  t291 = t290 * t143
  t295 = t159 * t142 * t77
  t298 = -0.10e2 / 0.81e2 * t291 * t254 - 0.38672424557127397784376810748939479365762700042037e-1 * t295 * t204
  t300 = t255 * t150 + 0.31324663891273192205345216706640978286267787034050e0 * t260 * t228 + t145 * t269 - t145 * t276 - t288 * t162 + t158 * t298
  t306 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t308 = 0.1e1 / t174 / t6
  t309 = t306 * t308
  t313 = t306 * t175
  t317 = t306 * t54
  t318 = 0.1e1 / t121
  t322 = t120 * t59
  t323 = 0.1e1 / t322
  t327 = t185 * t57
  t331 = t71 ** 2
  t333 = 0.1e1 / t190 / t63 / t331
  t337 = (0.50379140625000000000000000000000000000000000000000e-1 * t57 * t318 * t73 - 0.23615222167968750000000000000000000000000000000000e-2 * t186 * t323 * t195 + 0.24599189758300781250000000000000000000000000000000e-4 * t327 * t251 * t333) * t77
  t343 = 0.1e1 / t85 / t120
  t344 = t83 * t343
  t347 = t230 ** 2
  t351 = s0 * t343
  t353 = 0.40e2 / 0.9e1 * tau0 * t203 - 0.11e2 / 0.9e1 * t351
  t354 = t353 * t77
  t357 = t82 * t217
  t358 = t357 * t225
  t361 = t104 ** 2
  t363 = 0.1e1 / t105 / t361
  t364 = t100 * t363
  t365 = t225 ** 2
  t370 = t211 ** 2
  t377 = 0.22222222222222222222222222222222222222222222222222e0 * t354 * t101 + 0.24691358024691358024691358024691358024691358024692e0 * t370 * t116 * t118 + 0.12345679012345679012345679012345679012345679012346e0 * t221 * t118 * t353
  t380 = t109 * t351
  t382 = t354 * t213 / 0.4e1 - t212 * t358 / 0.4e1 + 0.27e2 / 0.80e2 * t364 * t365 - 0.9e1 / 0.40e2 * t218 * t377 + 0.22e2 / 0.81e2 * t380
  t387 = t230 * t235
  t391 = 0.1e1 / t128 / t127
  t392 = t112 * t391
  t393 = t245 ** 2
  t397 = t56 * t181 * t67
  t400 = 0.1e1 / t84 / t322
  t401 = t56 * t400
  t402 = t119 * t401
  t404 = 0.972e3 * t397 + 0.15200e5 / 0.9e1 * t402
  t410 = 0.1e1 / t136 / t58
  t413 = t337 * t88 / 0.24e2 - 0.2e1 / 0.9e1 * t199 * t204 + 0.11e2 / 0.27e2 * t78 * t344 + 0.292e3 / 0.2025e4 * t347 + 0.292e3 / 0.2025e4 * t112 * t382 - 0.73e2 / 0.97200e5 * t382 * t128 - 0.73e2 / 0.97200e5 * t387 * t245 + 0.73e2 / 0.388800e6 * t392 * t393 - 0.73e2 / 0.194400e6 * t236 * t404 + 0.89531158068346251041978319324252362915168381814727e-3 * t402 + 0.11746748959227447077004456264990366857350420137768e-1 * t397 + 0.76658950617283950617283950617283950617283950617287e-2 * t135 * t410
  t414 = t413 * t144
  t416 = t254 * t258
  t417 = t416 * t150
  t424 = t278 * t150
  t427 = t259 * t268
  t428 = t149 * t77
  t429 = t428 * t204
  t432 = t259 * t273
  t434 = t109 * t209 * t275
  t440 = t416 * t77
  t441 = t440 * t204
  t443 = t278 * t116
  t444 = t118 * t56
  t445 = t444 * t400
  t446 = t443 * t445
  t448 = t264 * t344
  t450 = -0.18630000000000000000000000000000000000000000000000e-3 * t414 - 0.11671569765888391415711627744894428509463377448887e-3 * t441 - 0.27420600000000000000000000000000000000000000000001e-4 * t446 + 0.21397877904128717595471317532306452267349525322960e-3 * t448
  t451 = t450 * t147
  t452 = t451 * t149
  t454 = t267 ** 2
  t455 = t454 * t147
  t456 = t455 * t149
  t458 = t145 * t267
  t462 = 0.1e1 / t271 / t148
  t463 = t147 * t462
  t464 = t275 ** 2
  t465 = t463 * t464
  t471 = t414 + 0.62649327782546384410690433413281956572535574068100e0 * t441 + 0.14718518518518518518518518518518518518518518518519e0 * t446 - 0.11485710093466837141959912792435025371631521912485e1 * t448
  t472 = t273 * t471
  t474 = t254 ** 2
  t477 = t140 * t282
  t478 = t477 * t254
  t484 = 0.1e1 / t153 / t143
  t486 = t152 * t484 * t116
  t491 = -0.30180600000000000000000000000000000000000000000000e-2 * t474 * t154 - 0.37815886041478388186905673893457948370661342934394e-2 * t478 * t228 - 0.30180600000000000000000000000000000000000000000000e-2 * t278 * t413 - 0.74035620000000000000000000000000000000000000000003e-3 * t486 * t445 + 0.34664562204688522504663534402336452673106231023195e-2 * t284 * t344
  t492 = t491 * t157
  t494 = t287 ** 2
  t495 = t494 * t157
  t500 = 0.1e1 / t152 / t140
  t501 = t500 * t143
  t504 = t290 * t142
  t505 = t504 * t254
  t510 = t159 * t116
  t515 = 0.20e2 / 0.81e2 * t501 * t474 + 0.77344849114254795568753621497878958731525400084074e-1 * t505 * t228 - 0.10e2 / 0.81e2 * t291 * t413 + 0.60570035055631763450693491845755220240816948635881e-2 * t510 * t445 + 0.14179889004280045854271497274611142434112990015414e0 * t295 * t344
  t517 = t414 * t150 + 0.62649327782546384410690433413281956572535574068100e0 * t417 * t228 + 0.2e1 * t255 * t269 - 0.2e1 * t255 * t276 + 0.14718518518518518518518518518518518518518518518519e0 * t424 * t402 + 0.62649327782546384410690433413281956572535574068100e0 * t427 * t429 - 0.62649327782546384410690433413281956572535574068100e0 * t432 * t434 - 0.11485710093466837141959912792435025371631521912485e1 * t260 * t380 + t145 * t452 + t145 * t456 - 0.2e1 * t458 * t276 + 0.2e1 * t145 * t465 - t145 * t472 - t492 * t162 - t495 * t162 - 0.2e1 * t288 * t298 + t158 * t515
  t521 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t522 = t521 * f.p.zeta_threshold
  t524 = f.my_piecewise3(t20, t522, t21 * t19)
  t526 = 0.1e1 / t174 / t25
  t527 = t524 * t526
  t531 = t524 * t308
  t535 = t524 * t175
  t539 = t524 * t54
  t548 = t145 * t450
  t555 = t477 * t147
  t556 = t149 * t134
  t558 = 0.1e1 / t136 / t59
  t560 = t556 * t57 * t558
  t568 = t145 * t147
  t570 = t462 * t275 * t471
  t582 = t185 ** 2
  t583 = t582 * s0
  t585 = 0.1e1 / t136 / t120
  t587 = t190 ** 2
  t592 = 0.1e1 / t587 / tau0 / t331 / t70
  t596 = (-0.25189570312500000000000000000000000000000000000000e0 * t57 * t188 * t73 + 0.19679351806640625000000000000000000000000000000000e-1 * t186 * t137 * t195 - 0.44278541564941406250000000000000000000000000000000e-3 * t327 * t410 * t333 + 0.30748987197875976562500000000000000000000000000000e-5 * t583 * t585 * t592) * t77
  t604 = 0.1e1 / t85 / t121
  t605 = t83 * t604
  t612 = s0 * t604
  t614 = -0.440e3 / 0.27e2 * tau0 * t343 + 0.154e3 / 0.27e2 * t612
  t615 = t614 * t77
  t621 = t82 * t363 * t365
  t624 = t357 * t377
  t629 = 0.1e1 / t105 / t361 / t104
  t630 = t100 * t629
  t631 = t365 * t225
  t645 = 0.22222222222222222222222222222222222222222222222222e0 * t615 * t101 + 0.74074074074074074074074074074074074074074074074076e0 * t353 * t116 * t222 + 0.12345679012345679012345679012345679012345679012346e0 * t221 * t118 * t614
  t648 = t109 * t612
  t650 = t615 * t213 / 0.4e1 - 0.3e1 / 0.8e1 * t354 * t358 + 0.9e1 / 0.16e2 * t212 * t621 - 0.3e1 / 0.8e1 * t212 * t624 - 0.27e2 / 0.32e2 * t630 * t631 + 0.81e2 / 0.80e2 * t364 * t225 * t377 - 0.9e1 / 0.40e2 * t218 * t645 - 0.308e3 / 0.243e3 * t648
  t655 = t382 * t235
  t658 = t230 * t391
  t663 = t127 ** 2
  t665 = 0.1e1 / t128 / t663
  t666 = t112 * t665
  t667 = t393 * t245
  t670 = t245 * t404
  t674 = t56 * t318 * t67
  t677 = 0.1e1 / t84 / t136
  t678 = t56 * t677
  t679 = t119 * t678
  t681 = -0.3888e4 * t674 - 0.334400e6 / 0.27e2 * t679
  t686 = t135 * t558
  t688 = t596 * t88 / 0.24e2 - t337 * t204 / 0.3e1 + 0.11e2 / 0.9e1 * t199 * t344 - 0.154e3 / 0.81e2 * t78 * t605 + 0.292e3 / 0.675e3 * t230 * t382 + 0.292e3 / 0.2025e4 * t112 * t650 - 0.73e2 / 0.97200e5 * t650 * t128 - 0.73e2 / 0.64800e5 * t655 * t245 + 0.73e2 / 0.129600e6 * t658 * t393 - 0.73e2 / 0.64800e5 * t387 * t404 - 0.73e2 / 0.259200e6 * t666 * t667 + 0.73e2 / 0.129600e6 * t392 * t670 - 0.73e2 / 0.194400e6 * t236 * t681 - 0.65656182583453917430784100837785066137790146664133e-2 * t679 - 0.46986995836909788308017825059961467429401680551072e-1 * t674 - 0.76658950617283950617283950617283950617283950617287e-1 * t686
  t689 = t688 * t144
  t693 = t454 * t267
  t694 = t693 * t147
  t695 = t694 * t149
  t698 = t494 * t287 * t157
  t700 = t271 ** 2
  t701 = 0.1e1 / t700
  t702 = t147 * t701
  t703 = t464 * t275
  t704 = t702 * t703
  t709 = t491 * t287
  t710 = t157 * t162
  t713 = t413 * t258
  t714 = t713 * t77
  t715 = t714 * t204
  t717 = t254 * t154
  t718 = t717 * t116
  t719 = t718 * t445
  t721 = t440 * t344
  t723 = t477 * t686
  t725 = t444 * t677
  t726 = t443 * t725
  t728 = t264 * t605
  t730 = t689 + 0.93973991673819576616035650119922934858803361102150e0 * t715 + 0.44155555555555555555555555555555555555555555555557e0 * t719 - 0.34457130280400511425879738377305076114894565737455e1 * t721 + 0.55326317468408740366240840529862776759834749188142e0 * t723 - 0.16190370370370370370370370370370370370370370370371e1 * t726 + 0.53599980436178573329146259698030118400947102258263e1 * t728
  t731 = t273 * t730
  t740 = -0.18630000000000000000000000000000000000000000000000e-3 * t689 - 0.17507354648832587123567441617341642764195066173330e-3 * t715 - 0.82261800000000000000000000000000000000000000000003e-4 * t719 + 0.64193633712386152786413952596919356802048575968879e-3 * t721 - 0.10307292944364548330230668590713435310357213773751e-3 * t723 + 0.30162660000000000000000000000000000000000000000002e-3 * t726 - 0.99856763552600682112199481817430110580964451507147e-3 * t728
  t741 = t740 * t147
  t742 = t741 * t149
  t746 = t145 * t695 - 0.6e1 * t145 * t704 - t145 * t731 + t145 * t742 + t689 * t150 - t698 * t162 + 0.6e1 * t255 * t465 + 0.3e1 * t414 * t269 + 0.6e1 * t458 * t465 + 0.6e1 * t568 * t570 - 0.3e1 * t709 * t710
  t748 = t255 * t267
  t757 = t713 * t150
  t760 = t717 * t150
  t763 = t268 * t272
  t764 = t259 * t763
  t770 = t474 * t282 * t77
  t773 = t140 * t484
  t774 = t773 * t254
  t777 = t477 * t413
  t785 = 0.1e1 / t153 / t257
  t786 = t152 * t785
  t793 = -0.90541800000000000000000000000000000000000000000000e-2 * t717 * t413 - 0.56723829062217582280358510840186922555992014401591e-2 * t770 * t204 - 0.44421372000000000000000000000000000000000000000002e-2 * t774 * t402 - 0.56723829062217582280358510840186922555992014401591e-2 * t777 * t228 + 0.20798737322813113502798120641401871603863738613917e-1 * t478 * t380 - 0.30180600000000000000000000000000000000000000000000e-2 * t278 * t688 - 0.41744536424676420737434207792389413006946715783691e-2 * t786 * t686 + 0.81439182000000000000000000000000000000000000000004e-2 * t486 * t725 - 0.16176795695521310502176316054423677914116241144158e-1 * t284 * t605
  t794 = t793 * t157
  t796 = t278 * t268
  t797 = t149 * t116
  t798 = t797 * t445
  t801 = t259 * t451
  t806 = t109 * t209 * t471
  t811 = t145 * t454
  t814 = t428 * t344
  t817 = t259 * t455
  t820 = t259 * t463
  t822 = t109 * t209 * t464
  t826 = t109 * t351 * t275
  t829 = t416 * t273
  t832 = t416 * t268
  t835 = t278 * t273
  t837 = t119 * t401 * t275
  t840 = t152 ** 2
  t841 = 0.1e1 / t840
  t842 = t841 * t143
  t843 = t474 * t254
  t846 = t500 * t142
  t847 = t846 * t474
  t854 = t290 * t116 * t118
  t858 = t504 * t413
  t869 = -0.20e2 / 0.27e2 * t842 * t843 - 0.23203454734276438670626086449363687619457620025222e0 * t847 * t228 + 0.20e2 / 0.27e2 * t501 * t254 * t413 - 0.18171010516689529035208047553726566072245084590764e-1 * t854 * t401 * t254 + 0.11601727367138219335313043224681843809728810012611e0 * t858 * t228 - 0.42539667012840137562814491823833427302338970046241e0 * t505 * t380 - 0.10e2 / 0.81e2 * t291 * t688 - 0.66627038561194939795762841030330742264898643499470e-1 * t510 * t725 - 0.66172815353306880653266987281518664692527286738599e0 * t295 * t605
  t871 = -0.93973991673819576616035650119922934858803361102150e0 * t432 * t806 - 0.3e1 * t288 * t515 - 0.3e1 * t811 * t276 - 0.34457130280400511425879738377305076114894565737455e1 * t427 * t814 + 0.93973991673819576616035650119922934858803361102150e0 * t817 * t429 + 0.18794798334763915323207130023984586971760672220430e1 * t820 * t822 + 0.34457130280400511425879738377305076114894565737455e1 * t432 * t826 - 0.18794798334763915323207130023984586971760672220430e1 * t829 * t434 + 0.18794798334763915323207130023984586971760672220430e1 * t832 * t429 - 0.44155555555555555555555555555555555555555555555557e0 * t835 * t837 + t158 * t869
  t873 = -0.3e1 * t495 * t298 - 0.3e1 * t458 * t472 - 0.3e1 * t255 * t472 - 0.3e1 * t492 * t298 - 0.3e1 * t548 * t276 + 0.3e1 * t255 * t456 - 0.3e1 * t414 * t276 + 0.55326317468408740366240840529862776759834749188142e0 * t555 * t560 + 0.3e1 * t255 * t452 + 0.3e1 * t548 * t269 + t746 - 0.6e1 * t748 * t276 - 0.34457130280400511425879738377305076114894565737455e1 * t417 * t380 - 0.16190370370370370370370370370370370370370370370371e1 * t424 * t679 + 0.53599980436178573329146259698030118400947102258263e1 * t260 * t648 + 0.93973991673819576616035650119922934858803361102150e0 * t757 * t228 + 0.44155555555555555555555555555555555555555555555557e0 * t760 * t402 - 0.18794798334763915323207130023984586971760672220430e1 * t764 * t434 - t794 * t162 + 0.44155555555555555555555555555555555555555555555557e0 * t796 * t798 + 0.93973991673819576616035650119922934858803361102150e0 * t801 * t429 + t871
  t878 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t164 - 0.3e1 / 0.8e1 * t5 * t176 * t164 - 0.9e1 / 0.8e1 * t5 * t180 * t300 + t5 * t309 * t164 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t313 * t300 - 0.9e1 / 0.8e1 * t5 * t317 * t517 - 0.5e1 / 0.36e2 * t5 * t527 * t164 + t5 * t531 * t300 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t535 * t517 - 0.3e1 / 0.8e1 * t5 * t539 * t873)
  t880 = r1 <= f.p.dens_threshold
  t881 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t882 = 0.1e1 + t881
  t883 = t882 <= f.p.zeta_threshold
  t884 = t882 ** (0.1e1 / 0.3e1)
  t885 = t884 ** 2
  t887 = 0.1e1 / t885 / t882
  t889 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t890 = t889 ** 2
  t894 = 0.1e1 / t885
  t895 = t894 * t889
  t897 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t901 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t905 = f.my_piecewise3(t883, 0, -0.8e1 / 0.27e2 * t887 * t890 * t889 + 0.4e1 / 0.3e1 * t895 * t897 + 0.4e1 / 0.3e1 * t884 * t901)
  t907 = s2 ** 2
  t908 = t907 * s2
  t909 = r1 ** 2
  t913 = tau1 ** 2
  t919 = t907 / t909 / t913
  t922 = (0.1e1 + t919 / 0.64e2) ** 2
  t930 = r1 ** (0.1e1 / 0.3e1)
  t931 = t930 ** 2
  t933 = 0.1e1 / t931 / t909
  t940 = s2 * t933
  t943 = (tau1 / t931 / r1 - t940 / 0.8e1) * t77
  t946 = 0.5e1 / 0.9e1 * t943 * t82 - 0.1e1
  t951 = jnp.sqrt(0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t943 * t82 * t946)
  t955 = t109 * t940
  t957 = 0.9e1 / 0.20e2 * t946 / t951 + t955 / 0.36e2
  t958 = t957 ** 2
  t961 = t909 ** 2
  t966 = t119 * t907 / t930 / t961 / r1
  t969 = jnp.sqrt(0.162e3 * t919 + 0.50e2 * t966)
  t975 = t961 ** 2
  t979 = (0.10e2 / 0.81e2 + 0.41982617187500000000000000000000000000000000000000e-2 * t908 / t909 / r1 / t913 / tau1 / t922) * t77 * t82 * s2 * t933 / 0.24e2 + 0.146e3 / 0.2025e4 * t958 - 0.73e2 / 0.97200e5 * t957 * t969 + 0.26505934954444613795322528747311554810411691984623e-4 * t966 + 0.19577914932045745128340760441650611428917366896280e-2 * t919 + 0.10647076474622770919067215363511659807956104252401e-3 * t134 * t908 / t975
  t982 = (0.1e1 + 0.58733744796137235385022281324951834286752100688842e-1 * t955) ** 2
  t984 = t979 / t982
  t986 = jnp.exp(-0.18630000000000000000000000000000000000000000000000e-3 * t984)
  t991 = t979 ** 2
  t992 = t982 ** 2
  t996 = jnp.exp(-0.15090300000000000000000000000000000000000000000000e-2 * t991 / t992)
  t1003 = 0.1e1 + t984 * t986 / (0.1e1 + t984) + (0.1e1 - t996) * (0.10e2 / 0.81e2 / t979 * t982 - 0.1e1)
  t1012 = f.my_piecewise3(t883, 0, 0.4e1 / 0.9e1 * t894 * t890 + 0.4e1 / 0.3e1 * t884 * t897)
  t1019 = f.my_piecewise3(t883, 0, 0.4e1 / 0.3e1 * t884 * t889)
  t1025 = f.my_piecewise3(t883, t522, t884 * t882)
  t1031 = f.my_piecewise3(t880, 0, -0.3e1 / 0.8e1 * t5 * t905 * t54 * t1003 - 0.3e1 / 0.8e1 * t5 * t1012 * t175 * t1003 + t5 * t1019 * t308 * t1003 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t1025 * t526 * t1003)
  t1046 = 0.1e1 / t174 / t36
  t1060 = t19 ** 2
  t1063 = t30 ** 2
  t1069 = t41 ** 2
  t1078 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t1079 = f.my_piecewise5(t10, 0, t14, 0, t1078)
  t1083 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t1060 * t1063 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t1069 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t1079)
  t1110 = t494 ** 2
  t1121 = t254 * t282
  t1133 = 0.24e2 * t748 * t465 - 0.12e2 * t255 * t454 * t276 + 0.24e2 * t255 * t147 * t570 + 0.12e2 * t548 * t465 + 0.12e2 * t748 * t452 - t1110 * t157 * t162 - 0.12e2 * t548 * t268 * t272 * t275 + 0.24e2 * t458 * t463 * t275 * t471 + 0.22130526987363496146496336211945110703933899675257e1 * t1121 * t147 * t560 - 0.12171789843049922880572984916569810887163644821391e2 * t555 * t556 * t57 * t585 - 0.4e1 * t689 * t276 - 0.12e2 * t748 * t472
  t1140 = t491 ** 2
  t1144 = t382 ** 2
  t1150 = t393 ** 2
  t1175 = 0.292e3 / 0.675e3 * t1144 + 0.73e2 / 0.103680e6 * t112 / t128 / t663 / t127 * t1150 - 0.73e2 / 0.43200e5 * t666 * t393 * t404 - 0.4e1 / 0.9e1 * t596 * t204 + 0.22e2 / 0.9e1 * t337 * t344 + 0.73e2 / 0.64800e5 * t382 * t391 * t393 - 0.73e2 / 0.64800e5 * t230 * t665 * t667 + 0.73e2 / 0.32400e5 * t658 * t670 - 0.73e2 / 0.48600e5 * t650 * t235 * t245 - 0.73e2 / 0.32400e5 * t655 * t404 - 0.73e2 / 0.48600e5 * t387 * t681
  t1179 = 0.1e1 / t85 / t187
  t1180 = s0 * t1179
  t1182 = 0.6160e4 / 0.81e2 * tau0 * t604 - 0.2618e4 / 0.81e2 * t1180
  t1183 = t1182 * t77
  t1204 = t361 ** 2
  t1208 = t365 ** 2
  t1214 = t377 ** 2
  t1225 = t353 ** 2
  t1235 = t109 * t1180
  t1237 = t1183 * t213 / 0.4e1 - t615 * t358 / 0.2e1 + 0.9e1 / 0.8e1 * t354 * t621 - 0.3e1 / 0.4e1 * t354 * t624 - 0.15e2 / 0.8e1 * t212 * t82 * t629 * t631 + 0.9e1 / 0.4e1 * t212 * t82 * t363 * t225 * t377 - t212 * t357 * t645 / 0.2e1 + 0.189e3 / 0.64e2 * t100 / t105 / t1204 * t1208 - 0.81e2 / 0.16e2 * t630 * t365 * t377 + 0.81e2 / 0.80e2 * t364 * t1214 + 0.27e2 / 0.20e2 * t364 * t225 * t645 - 0.9e1 / 0.40e2 * t218 * (0.22222222222222222222222222222222222222222222222222e0 * t1183 * t101 + 0.98765432098765432098765432098765432098765432098768e0 * t614 * t116 * t222 + 0.74074074074074074074074074074074074074074074074076e0 * t1225 * t116 * t118 + 0.12345679012345679012345679012345679012345679012346e0 * t221 * t118 * t1182) + 0.5236e4 / 0.729e3 * t1235
  t1242 = t83 * t1179
  t1276 = t404 ** 2
  t1283 = 0.1e1 / t84 / t250
  t1285 = t119 * t56 * t1283
  t1288 = t56 * t188 * t67
  t1295 = t135 * t585
  t1299 = -0.73e2 / 0.97200e5 * t1237 * t128 - 0.616e3 / 0.81e2 * t199 * t605 + 0.2618e4 / 0.243e3 * t78 * t1242 + 0.1168e4 / 0.2025e4 * t230 * t650 + (0.15113742187500000000000000000000000000000000000000e1 * t57 * t323 * t73 - 0.17317829589843750000000000000000000000000000000000e0 * t186 * t251 * t195 + 0.62727933883666992187500000000000000000000000000000e-2 * t327 * t558 * t333 - 0.92246961593627929687500000000000000000000000000000e-4 * t583 / t136 / t121 * t592 + 0.48045292496681213378906250000000000000000000000000e-6 * t582 * t57 / t136 / t322 / t587 / t63 / t331 / t71) * t77 * t88 / 0.24e2 + 0.73e2 / 0.129600e6 * t392 * t1276 + 0.73e2 / 0.97200e5 * t392 * t245 * t681 + 0.54713485486211597858986750698154221781491788886777e-1 * t1285 - 0.73e2 / 0.194400e6 * t236 * (0.19440e5 * t1288 + 0.8360000e7 / 0.81e2 * t1285) + 0.23493497918454894154008912529980733714700840275536e0 * t1288 + 0.84324845679012345679012345679012345679012345679016e0 * t1295 + 0.292e3 / 0.2025e4 * t112 * t1237
  t1300 = t1175 + t1299
  t1301 = t1300 * t144
  t1307 = t450 ** 2
  t1325 = t413 ** 2
  t1343 = t153 ** 2
  t1349 = 0.1e1 / t85 / t136 / t187
  t1351 = t185 * t1349 * t109
  t1354 = t444 * t1283
  t1369 = -0.12941436556417048401741052843538942331292992915326e0 * t478 * t648 + 0.65151345600000000000000000000000000000000000000003e-1 * t774 * t679 + 0.41597474645626227005596241282803743207727477227834e-1 * t777 * t380 - 0.90541800000000000000000000000000000000000000000000e-2 * t1325 * t154 - 0.88842744000000000000000000000000000000000000000004e-2 * t474 * t484 * t116 * t445 + 0.41597474645626227005596241282803743207727477227834e-1 * t770 * t344 - 0.88842744000000000000000000000000000000000000000004e-2 * t773 * t413 * t402 - 0.75631772082956776373811347786915896741322685868788e-2 * t477 * t688 * t228 - 0.22689531624887032912143404336074769022396805760636e-1 * t1121 * t413 * t228 - 0.45767175048000000000000000000000000000000000000006e-2 * t152 / t1343 * t134 * t1351 - 0.80534302200000000000000000000000000000000000000004e-1 * t486 * t1354 + 0.91668508941287426178999124308400841513325366483562e-1 * t284 * t1242 + 0.91837980134288125622355257143256708615282774724121e-1 * t786 * t1295 - 0.33395629139741136589947366233911530405557372626953e-1 * t140 * t785 * t254 * t686 - 0.30180600000000000000000000000000000000000000000000e-2 * t278 * t1300 - 0.12072240000000000000000000000000000000000000000000e-1 * t717 * t688
  t1372 = 0.3e1 * t145 * t1307 * t147 * t149 - 0.3e1 * t1140 * t157 * t162 - t1369 * t157 * t162 - 0.4e1 * t793 * t287 * t710 + t1301 * t150 + 0.4e1 * t255 * t695 - 0.4e1 * t288 * t869 - 0.6e1 * t414 * t472 + 0.6e1 * t811 * t452 - 0.24e2 * t458 * t704 - 0.6e1 * t548 * t472 - 0.6e1 * t495 * t515
  t1385 = t454 ** 2
  t1389 = t688 * t258
  t1391 = t1389 * t77 * t204
  t1393 = t413 * t154
  t1395 = t1393 * t116 * t445
  t1397 = t714 * t344
  t1399 = t1121 * t686
  t1401 = t718 * t725
  t1403 = t440 * t605
  t1406 = t773 * t134 * t1351
  t1408 = t477 * t1295
  t1410 = t443 * t1354
  t1412 = t264 * t1242
  t1414 = t1301 + 0.12529865556509276882138086682656391314507114813620e1 * t1391 + 0.88311111111111111111111111111111111111111111111114e0 * t1395 - 0.68914260560801022851759476754610152229789131474910e1 * t1397 + 0.22130526987363496146496336211945110703933899675257e1 * t1399 - 0.64761481481481481481481481481481481481481481481484e1 * t1401 + 0.21439992174471429331658503879212047360378840903305e2 * t1403 + 0.43326957475994513031550068587105624142661179698220e0 * t1406 - 0.12171789843049922880572984916569810887163644821391e2 * t1408 + 0.16010477366255144032921810699588477366255144032922e2 * t1410 - 0.30373322247167858219849547162217067093870024613016e2 * t1412
  t1421 = t471 ** 2
  t1434 = t145 * t1385 * t147 * t149 + 0.8e1 * t568 * t462 * t730 * t275 - 0.36e2 * t568 * t701 * t464 * t471 - t145 * t273 * t1414 + 0.6e1 * t145 * t463 * t1421 - 0.12e2 * t255 * t450 * t276 - 0.12e2 * t414 * t267 * t276 - 0.4e1 * t255 * t731 + 0.4e1 * t689 * t269 + 0.6e1 * t414 * t452 + 0.12e2 * t414 * t465 - 0.6e1 * t811 * t472
  t1441 = t464 ** 2
  t1465 = -0.18630000000000000000000000000000000000000000000000e-3 * t1301 - 0.23343139531776782831423255489788857018926754897774e-3 * t1391 - 0.16452360000000000000000000000000000000000000000000e-3 * t1395 + 0.12838726742477230557282790519383871360409715193776e-2 * t1397 - 0.41229171777458193320922674362853741241428855095003e-3 * t1399 + 0.12065064000000000000000000000000000000000000000000e-2 * t1401 - 0.39942705421040272844879792726972044232385780602859e-2 * t1403 - 0.80718121777777777777777777777777777777777777777786e-4 * t1406 + 0.22676044477602006326507470899569557682785870302252e-2 * t1408 - 0.29827519333333333333333333333333333333333333333336e-2 * t1410 + 0.56585499346473719863579706363210395995879855854050e-2 * t1412
  t1504 = t474 ** 2
  t1519 = -0.10e2 / 0.81e2 * t291 * t1300 + 0.92813818937105754682504345797454750477830480100888e0 * t841 * t142 * t843 * t228 + 0.37497928700207232370184626126193909992432129151873e1 * t295 * t1242 + 0.20e2 / 0.27e2 * t501 * t1325 + 0.26469126141322752261306794912607465877010914695439e1 * t505 * t648 + 0.72684042066758116140832190214906264288980338363056e-1 * t500 * t116 * t118 * t401 * t474 - 0.36342021033379058070416095107453132144490169181528e-1 * t854 * t401 * t413 + 0.65886738132737218242476587241104845128621991905032e0 * t510 * t1354 - 0.85079334025680275125628983647666854604677940092481e0 * t858 * t380 - 0.92813818937105754682504345797454750477830480100888e0 * t846 * t254 * t77 * t83 * t203 * t413 + 0.17015866805136055025125796729533370920935588018496e1 * t847 * t380 + 0.80e2 / 0.27e2 / t840 / t140 * t143 * t1504 + 0.26650815424477975918305136412132296905959457399788e0 * t854 * t678 * t254 + 0.15468969822850959113750724299575791746305080016815e0 * t504 * t688 * t228 - 0.40e2 / 0.9e1 * t842 * t474 * t413 + 0.80e2 / 0.81e2 * t501 * t254 * t688
  t1534 = -0.12e2 * t709 * t157 * t298 + 0.24e2 * t145 * t147 / t700 / t148 * t1441 + 0.12e2 * t811 * t465 - 0.4e1 * t145 * t693 * t276 + 0.6e1 * t414 * t456 - 0.24e2 * t255 * t704 + t145 * t1465 * t147 * t149 + t158 * t1519 - 0.30373322247167858219849547162217067093870024613016e2 * t260 * t1235 + 0.88311111111111111111111111111111111111111111111114e0 * t1393 * t150 * t402 + 0.12529865556509276882138086682656391314507114813620e1 * t1389 * t150 * t228 - 0.22130526987363496146496336211945110703933899675257e1 * t477 * t273 * t135 * t558 * t275
  t1548 = t145 * t740
  t1571 = 0.22130526987363496146496336211945110703933899675257e1 * t477 * t268 * t560 - 0.68914260560801022851759476754610152229789131474910e1 * t757 * t380 - 0.64761481481481481481481481481481481481481481481484e1 * t760 * t679 + 0.21439992174471429331658503879212047360378840903305e2 * t417 * t648 + 0.16010477366255144032921810699588477366255144032922e2 * t424 * t1285 - 0.4e1 * t1548 * t276 - 0.6e1 * t492 * t515 + 0.37589596669527830646414260047969173943521344440860e1 * t259 * t450 * t267 * t147 * t429 + 0.75179193339055661292828520095938347887042688881720e1 * t259 * t463 * t275 * t806 - 0.75179193339055661292828520095938347887042688881720e1 * t416 * t763 * t434 - 0.37589596669527830646414260047969173943521344440860e1 * t259 * t451 * t272 * t434 - 0.37589596669527830646414260047969173943521344440860e1 * t764 * t806
  t1609 = 0.75179193339055661292828520095938347887042688881720e1 * t259 * t268 * t462 * t822 + 0.13782852112160204570351895350922030445957826294982e2 * t764 * t826 - 0.37589596669527830646414260047969173943521344440860e1 * t259 * t455 * t272 * t434 - 0.17662222222222222222222222222222222222222222222223e1 * t278 * t763 * t837 - 0.6e1 * t491 * t494 * t710 + 0.4e1 * t255 * t742 - 0.4e1 * t794 * t298 + 0.12529865556509276882138086682656391314507114813620e1 * t259 * t694 * t429 - 0.68914260560801022851759476754610152229789131474910e1 * t801 * t814 + 0.88311111111111111111111111111111111111111111111114e0 * t278 * t455 * t798 + 0.17662222222222222222222222222222222222222222222223e1 * t278 * t463 * t119 * t401 * t464 + 0.68914260560801022851759476754610152229789131474910e1 * t432 * t109 * t351 * t471
  t1650 = -0.88311111111111111111111111111111111111111111111114e0 * t835 * t119 * t401 * t471 - 0.4e1 * t698 * t298 - 0.4e1 * t458 * t731 + 0.4e1 * t1548 * t269 - 0.13782852112160204570351895350922030445957826294982e2 * t820 * t109 * t351 * t464 - 0.68914260560801022851759476754610152229789131474910e1 * t817 * t814 + 0.88311111111111111111111111111111111111111111111114e0 * t278 * t451 * t798 + 0.37589596669527830646414260047969173943521344440860e1 * t713 * t268 * t429 - 0.37589596669527830646414260047969173943521344440860e1 * t713 * t273 * t434 + 0.37589596669527830646414260047969173943521344440860e1 * t416 * t455 * t429 + 0.43326957475994513031550068587105624142661179698220e0 * t773 * t150 * t134 * t185 * t1349 * t77 * t82 - 0.12529865556509276882138086682656391314507114813620e1 * t432 * t730 * t77 * t204
  t1691 = 0.13782852112160204570351895350922030445957826294982e2 * t829 * t826 - 0.13782852112160204570351895350922030445957826294982e2 * t832 * t814 + 0.64761481481481481481481481481481481481481481481484e1 * t835 * t119 * t678 * t275 - 0.64761481481481481481481481481481481481481481481484e1 * t796 * t797 * t725 - 0.21439992174471429331658503879212047360378840903305e2 * t432 * t109 * t612 * t275 + 0.21439992174471429331658503879212047360378840903305e2 * t427 * t428 * t605 - 0.17662222222222222222222222222222222222222222222223e1 * t717 * t273 * t837 + 0.17662222222222222222222222222222222222222222222223e1 * t717 * t268 * t798 + 0.75179193339055661292828520095938347887042688881720e1 * t416 * t463 * t822 + 0.12529865556509276882138086682656391314507114813620e1 * t259 * t741 * t429 + 0.37589596669527830646414260047969173943521344440860e1 * t416 * t451 * t429 - 0.37589596669527830646414260047969173943521344440860e1 * t829 * t806 - 0.75179193339055661292828520095938347887042688881720e1 * t259 * t702 * t703 * t77 * t204
  t1705 = -0.5e1 / 0.9e1 * t5 * t306 * t526 * t164 - 0.9e1 / 0.4e1 * t5 * t180 * t517 + t5 * t309 * t300 - 0.5e1 / 0.9e1 * t5 * t527 * t300 + 0.10e2 / 0.27e2 * t5 * t524 * t1046 * t164 - 0.3e1 / 0.2e1 * t5 * t313 * t517 + t5 * t531 * t517 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t317 * t873 - 0.3e1 / 0.8e1 * t5 * t1083 * t54 * t164 - 0.3e1 / 0.2e1 * t5 * t55 * t300 - t5 * t53 * t175 * t164 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t176 * t300 - 0.3e1 / 0.8e1 * t5 * t539 * (t1133 + t1372 + t1434 + t1534 + t1571 + t1609 + t1650 + t1691) - t5 * t535 * t873 / 0.2e1 + t5 * t173 * t308 * t164 / 0.2e1
  t1706 = f.my_piecewise3(t1, 0, t1705)
  t1707 = t882 ** 2
  t1710 = t890 ** 2
  t1716 = t897 ** 2
  t1722 = f.my_piecewise5(t14, 0, t10, 0, -t1078)
  t1726 = f.my_piecewise3(t883, 0, 0.40e2 / 0.81e2 / t885 / t1707 * t1710 - 0.16e2 / 0.9e1 * t887 * t890 * t897 + 0.4e1 / 0.3e1 * t894 * t1716 + 0.16e2 / 0.9e1 * t895 * t901 + 0.4e1 / 0.3e1 * t884 * t1722)
  t1748 = f.my_piecewise3(t880, 0, -0.3e1 / 0.8e1 * t5 * t1726 * t54 * t1003 - t5 * t905 * t175 * t1003 / 0.2e1 + t5 * t1012 * t308 * t1003 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t1019 * t526 * t1003 + 0.10e2 / 0.27e2 * t5 * t1025 * t1046 * t1003)
  d1111 = 0.4e1 * t878 + 0.4e1 * t1031 + t6 * (t1706 + t1748)

  res = {'v4rho4': d1111}
  return res
