"""Generated from gga_c_lm.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_lm_f_raw = params.lm_f
  if isinstance(params_lm_f_raw, (str, bytes, dict)):
    params_lm_f = params_lm_f_raw
  else:
    try:
      params_lm_f_seq = list(params_lm_f_raw)
    except TypeError:
      params_lm_f = params_lm_f_raw
    else:
      params_lm_f_seq = np.asarray(params_lm_f_seq, dtype=np.float64)
      params_lm_f = np.concatenate((np.array([np.nan], dtype=np.float64), params_lm_f_seq))

  params_hl_r = np.array([np.nan, 30, 75.0], dtype=np.float64)

  params_hl_c = np.array([np.nan, 0.0252, 0.0127], dtype=np.float64)

  lm_J = jnp.pi / (16 * (3 * jnp.pi ** 2) ** (4 / 3))

  lm_d = lambda z: jnp.sqrt(f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3)) / jnp.sqrt(2)

  lm_F = 2 * jnp.sqrt(3) * params_lm_f / (2 * (3 / jnp.pi) ** (1 / 6))

  lm_t1 = lambda z, xs0, xs1: -7 / (9 * 2 ** (5 / 3)) * (xs0 ** 2 * f.opz_pow_n(z, 4 / 3) + xs1 ** 2 * f.opz_pow_n(-z, 4 / 3))

  hl_xx = lambda k, rs: rs / params_hl_r[k]

  lm_t2 = lambda rs, z, xt: 2 / lm_d(z) * jnp.exp(-lm_F * xt * f.n_total(rs) ** (1 / 6)) * xt ** 2

  hl_f0 = lambda k, rs: -params_hl_c[k] * ((1 + hl_xx(k, rs) ** 3) * jnp.log(1 + 1 / hl_xx(k, rs)) - hl_xx(k, rs) ** 2 + 1 / 2 * hl_xx(k, rs) - 1 / 3)

  hl_f = lambda rs, zeta: hl_f0(1, rs) + f.f_zeta(zeta) * (hl_f0(2, rs) - hl_f0(1, rs))

  functional_body = lambda rs, z, xt, xs0, xs1: +hl_f(rs, z) + lm_J * (lm_t1(z, xs0, xs1) + lm_t2(rs, z, xt)) * f.n_total(rs) ** (1 / 3)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_lm_f_raw = params.lm_f
  if isinstance(params_lm_f_raw, (str, bytes, dict)):
    params_lm_f = params_lm_f_raw
  else:
    try:
      params_lm_f_seq = list(params_lm_f_raw)
    except TypeError:
      params_lm_f = params_lm_f_raw
    else:
      params_lm_f_seq = np.asarray(params_lm_f_seq, dtype=np.float64)
      params_lm_f = np.concatenate((np.array([np.nan], dtype=np.float64), params_lm_f_seq))

  params_hl_r = np.array([np.nan, 30, 75.0], dtype=np.float64)

  params_hl_c = np.array([np.nan, 0.0252, 0.0127], dtype=np.float64)

  lm_J = jnp.pi / (16 * (3 * jnp.pi ** 2) ** (4 / 3))

  lm_d = lambda z: jnp.sqrt(f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3)) / jnp.sqrt(2)

  lm_F = 2 * jnp.sqrt(3) * params_lm_f / (2 * (3 / jnp.pi) ** (1 / 6))

  lm_t1 = lambda z, xs0, xs1: -7 / (9 * 2 ** (5 / 3)) * (xs0 ** 2 * f.opz_pow_n(z, 4 / 3) + xs1 ** 2 * f.opz_pow_n(-z, 4 / 3))

  hl_xx = lambda k, rs: rs / params_hl_r[k]

  lm_t2 = lambda rs, z, xt: 2 / lm_d(z) * jnp.exp(-lm_F * xt * f.n_total(rs) ** (1 / 6)) * xt ** 2

  hl_f0 = lambda k, rs: -params_hl_c[k] * ((1 + hl_xx(k, rs) ** 3) * jnp.log(1 + 1 / hl_xx(k, rs)) - hl_xx(k, rs) ** 2 + 1 / 2 * hl_xx(k, rs) - 1 / 3)

  hl_f = lambda rs, zeta: hl_f0(1, rs) + f.f_zeta(zeta) * (hl_f0(2, rs) - hl_f0(1, rs))

  functional_body = lambda rs, z, xt, xs0, xs1: +hl_f(rs, z) + lm_J * (lm_t1(z, xs0, xs1) + lm_t2(rs, z, xt)) * f.n_total(rs) ** (1 / 3)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_lm_f_raw = params.lm_f
  if isinstance(params_lm_f_raw, (str, bytes, dict)):
    params_lm_f = params_lm_f_raw
  else:
    try:
      params_lm_f_seq = list(params_lm_f_raw)
    except TypeError:
      params_lm_f = params_lm_f_raw
    else:
      params_lm_f_seq = np.asarray(params_lm_f_seq, dtype=np.float64)
      params_lm_f = np.concatenate((np.array([np.nan], dtype=np.float64), params_lm_f_seq))

  params_hl_r = np.array([np.nan, 30, 75.0], dtype=np.float64)

  params_hl_c = np.array([np.nan, 0.0252, 0.0127], dtype=np.float64)

  lm_J = jnp.pi / (16 * (3 * jnp.pi ** 2) ** (4 / 3))

  lm_d = lambda z: jnp.sqrt(f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3)) / jnp.sqrt(2)

  lm_F = 2 * jnp.sqrt(3) * params_lm_f / (2 * (3 / jnp.pi) ** (1 / 6))

  lm_t1 = lambda z, xs0, xs1: -7 / (9 * 2 ** (5 / 3)) * (xs0 ** 2 * f.opz_pow_n(z, 4 / 3) + xs1 ** 2 * f.opz_pow_n(-z, 4 / 3))

  hl_xx = lambda k, rs: rs / params_hl_r[k]

  lm_t2 = lambda rs, z, xt: 2 / lm_d(z) * jnp.exp(-lm_F * xt * f.n_total(rs) ** (1 / 6)) * xt ** 2

  hl_f0 = lambda k, rs: -params_hl_c[k] * ((1 + hl_xx(k, rs) ** 3) * jnp.log(1 + 1 / hl_xx(k, rs)) - hl_xx(k, rs) ** 2 + 1 / 2 * hl_xx(k, rs) - 1 / 3)

  hl_f = lambda rs, zeta: hl_f0(1, rs) + f.f_zeta(zeta) * (hl_f0(2, rs) - hl_f0(1, rs))

  functional_body = lambda rs, z, xt, xs0, xs1: +hl_f(rs, z) + lm_J * (lm_t1(z, xs0, xs1) + lm_t2(rs, z, xt)) * f.n_total(rs) ** (1 / 3)

  t1 = 0.1e1 / jnp.pi
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t6 = 0.1e1 + t4 / 0.36000e5
  t7 = 3 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t1 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t9
  t12 = 4 ** (0.1e1 / 0.3e1)
  t13 = t2 ** (0.1e1 / 0.3e1)
  t15 = t8 * t10 * t12 * t13
  t17 = 0.1e1 + 0.10e2 * t15
  t18 = jnp.log(t17)
  t20 = 0.252e-1 * t6 * t18
  t21 = t9 ** 2
  t22 = t8 * t21
  t23 = t13 ** 2
  t24 = 0.1e1 / t23
  t25 = t12 * t24
  t26 = t22 * t25
  t27 = 0.70000000000000000000000000000000000000000000000000e-5 * t26
  t28 = t7 * t9
  t29 = t12 ** 2
  t32 = t28 * t29 / t13
  t33 = 0.10500000000000000000000000000000000000000000000000e-3 * t32
  t34 = r0 - r1
  t35 = t34 * t3
  t36 = 0.1e1 + t35
  t37 = t36 <= f.p.zeta_threshold
  t38 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t39 = t38 * f.p.zeta_threshold
  t40 = t36 ** (0.1e1 / 0.3e1)
  t42 = f.my_piecewise3(t37, t39, t40 * t36)
  t43 = 0.1e1 - t35
  t44 = t43 <= f.p.zeta_threshold
  t45 = t43 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t44, t39, t45 * t43)
  t49 = 2 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / (0.2e1 * t49 - 0.2e1)
  t53 = (t42 + t47 - 0.2e1) * t52
  t55 = 0.1e1 + 0.17777777777777777777777777777777777777777777777776e-5 * t4
  t57 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t15
  t58 = jnp.log(t57)
  t63 = -0.127e-1 * t55 * t58 - 0.64355555555555555555555555555555555555555555555556e-5 * t26 + 0.83833333333333333333333333333333333333333333333334e-4 * t32 - 0.41666666666666666666666666666666666666666666666667e-2 + t20
  t64 = t53 * t63
  t65 = jnp.pi * t8
  t66 = jnp.pi ** 2
  t67 = t66 ** (0.1e1 / 0.3e1)
  t69 = 0.1e1 / t67 / t66
  t70 = r0 ** 2
  t71 = r0 ** (0.1e1 / 0.3e1)
  t72 = t71 ** 2
  t74 = 0.1e1 / t72 / t70
  t75 = s0 * t74
  t77 = r1 ** 2
  t78 = r1 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / t77
  t82 = s2 * t81
  t87 = t38 ** 2
  t88 = t87 * f.p.zeta_threshold
  t89 = t40 ** 2
  t91 = f.my_piecewise3(t37, t88, t89 * t36)
  t92 = t45 ** 2
  t94 = f.my_piecewise3(t44, t88, t92 * t43)
  t95 = t91 + t94
  t96 = jnp.sqrt(t95)
  t98 = jnp.sqrt(0.2e1)
  t99 = 0.1e1 / t96 * t98
  t100 = t7 * params.lm_f
  t101 = t1 ** (0.1e1 / 0.6e1)
  t102 = 0.1e1 / t101
  t104 = s0 + 0.2e1 * s1 + s2
  t105 = jnp.sqrt(t104)
  t106 = t102 * t105
  t107 = t2 ** (0.1e1 / 0.6e1)
  t112 = jnp.exp(-t100 * t106 / t107 / t2)
  t113 = t112 * t104
  t114 = t2 ** 2
  t116 = 0.1e1 / t23 / t114
  t121 = t69 * (-0.7e1 / 0.36e2 * t49 * (t75 * t42 + t82 * t47) + 0.2e1 * t99 * t113 * t116)
  t124 = t65 * t121 * t13 / 0.144e3
  t125 = 0.1e1 / t114
  t126 = t1 * t125
  t128 = 0.70000000000000000000000000000000000000000000000000e-6 * t126 * t18
  t134 = 0.84000000000000000000000000000000000000000000000000e-1 * t6 * t8 * t10 * t25 / t17
  t138 = t22 * t12 / t23 / t2
  t139 = 0.46666666666666666666666666666666666666666666666667e-5 * t138
  t140 = t13 * t2
  t143 = t28 * t29 / t140
  t144 = 0.35000000000000000000000000000000000000000000000000e-4 * t143
  t145 = t34 * t125
  t146 = t3 - t145
  t149 = f.my_piecewise3(t37, 0, 0.4e1 / 0.3e1 * t40 * t146)
  t150 = -t146
  t153 = f.my_piecewise3(t44, 0, 0.4e1 / 0.3e1 * t45 * t150)
  t168 = t53 * (0.22577777777777777777777777777777777777777777777776e-7 * t126 * t58 - 0.10583333333333333333333333333333333333333333333333e0 * t55 * t8 * t10 * t25 / t57 + 0.42903703703703703703703703703703703703703703703704e-5 * t138 - 0.27944444444444444444444444444444444444444444444445e-4 * t143 - t128 + t134)
  t183 = 0.1e1 / t96 / t95 * t98 * t112
  t184 = t104 * t116
  t187 = f.my_piecewise3(t37, 0, 0.5e1 / 0.3e1 * t89 * t146)
  t190 = f.my_piecewise3(t44, 0, 0.5e1 / 0.3e1 * t92 * t150)
  t194 = t99 * t100
  t197 = t114 ** 2
  t198 = t107 ** 2
  t199 = t198 ** 2
  t200 = t199 * t107
  t206 = 0.7e1 / 0.3e1 * t194 * t102 * t105 * t104 / t200 / t197 * t112
  t207 = t114 * t2
  t212 = 0.16e2 / 0.3e1 * t99 * t113 / t23 / t207
  t220 = t65 * t121 * t24 / 0.432e3
  vrho_0_ = -t20 + t27 - t33 + 0.84000000000000000000000000000000000000000000000000e-2 + t64 + t124 + t2 * (t128 - t134 - t139 + t144 + (t149 + t153) * t52 * t63 + t168 + t65 * t69 * (-0.7e1 / 0.36e2 * t49 * (-0.8e1 / 0.3e1 * s0 / t72 / t70 / r0 * t42 + t75 * t149 + t82 * t153) - t183 * t184 * (t187 + t190) + t206 - t212) * t13 / 0.144e3 + t220)
  t223 = -t3 - t145
  t226 = f.my_piecewise3(t37, 0, 0.4e1 / 0.3e1 * t40 * t223)
  t227 = -t223
  t230 = f.my_piecewise3(t44, 0, 0.4e1 / 0.3e1 * t45 * t227)
  t247 = f.my_piecewise3(t37, 0, 0.5e1 / 0.3e1 * t89 * t223)
  t250 = f.my_piecewise3(t44, 0, 0.5e1 / 0.3e1 * t92 * t227)
  vrho_1_ = -t20 + t27 - t33 + 0.84000000000000000000000000000000000000000000000000e-2 + t64 + t124 + t2 * (t128 - t134 - t139 + t144 + (t226 + t230) * t52 * t63 + t168 + t65 * t69 * (-0.7e1 / 0.36e2 * t49 * (t75 * t226 - 0.8e1 / 0.3e1 * s2 / t79 / t77 / r1 * t47 + t82 * t230) - t183 * t184 * (t247 + t250) + t206 - t212) * t13 / 0.144e3 + t220)
  t261 = t140 * jnp.pi
  t262 = t8 * t69
  t270 = t194 * t106 / t200 / t207 * t112
  t272 = t99 * t112 * t116
  t273 = 0.2e1 * t272
  vsigma_0_ = t261 * t262 * (-0.7e1 / 0.36e2 * t49 * t74 * t42 - t270 + t273) / 0.144e3
  vsigma_1_ = t261 * t262 * (-0.2e1 * t270 + 0.4e1 * t272) / 0.144e3
  vsigma_2_ = t261 * t262 * (-0.7e1 / 0.36e2 * t49 * t81 * t47 - t270 + t273) / 0.144e3
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_lm_f_raw = params.lm_f
  if isinstance(params_lm_f_raw, (str, bytes, dict)):
    params_lm_f = params_lm_f_raw
  else:
    try:
      params_lm_f_seq = list(params_lm_f_raw)
    except TypeError:
      params_lm_f = params_lm_f_raw
    else:
      params_lm_f_seq = np.asarray(params_lm_f_seq, dtype=np.float64)
      params_lm_f = np.concatenate((np.array([np.nan], dtype=np.float64), params_lm_f_seq))

  params_hl_r = np.array([np.nan, 30, 75.0], dtype=np.float64)

  params_hl_c = np.array([np.nan, 0.0252, 0.0127], dtype=np.float64)

  lm_J = jnp.pi / (16 * (3 * jnp.pi ** 2) ** (4 / 3))

  lm_d = lambda z: jnp.sqrt(f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3)) / jnp.sqrt(2)

  lm_F = 2 * jnp.sqrt(3) * params_lm_f / (2 * (3 / jnp.pi) ** (1 / 6))

  lm_t1 = lambda z, xs0, xs1: -7 / (9 * 2 ** (5 / 3)) * (xs0 ** 2 * f.opz_pow_n(z, 4 / 3) + xs1 ** 2 * f.opz_pow_n(-z, 4 / 3))

  hl_xx = lambda k, rs: rs / params_hl_r[k]

  lm_t2 = lambda rs, z, xt: 2 / lm_d(z) * jnp.exp(-lm_F * xt * f.n_total(rs) ** (1 / 6)) * xt ** 2

  hl_f0 = lambda k, rs: -params_hl_c[k] * ((1 + hl_xx(k, rs) ** 3) * jnp.log(1 + 1 / hl_xx(k, rs)) - hl_xx(k, rs) ** 2 + 1 / 2 * hl_xx(k, rs) - 1 / 3)

  hl_f = lambda rs, zeta: hl_f0(1, rs) + f.f_zeta(zeta) * (hl_f0(2, rs) - hl_f0(1, rs))

  functional_body = lambda rs, z, xt, xs0, xs1: +hl_f(rs, z) + lm_J * (lm_t1(z, xs0, xs1) + lm_t2(rs, z, xt)) * f.n_total(rs) ** (1 / 3)

  t1 = 0.1e1 / jnp.pi
  t3 = t1 / r0
  t5 = 0.1e1 + t3 / 0.36000e5
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = r0 ** (0.1e1 / 0.3e1)
  t14 = t7 * t9 * t11 * t12
  t16 = 0.1e1 + 0.10e2 * t14
  t17 = jnp.log(t16)
  t19 = 0.252e-1 * t5 * t17
  t20 = t8 ** 2
  t21 = t7 * t20
  t22 = t12 ** 2
  t23 = 0.1e1 / t22
  t24 = t11 * t23
  t25 = t21 * t24
  t27 = t6 * t8
  t28 = t11 ** 2
  t31 = t27 * t28 / t12
  t33 = 0.1e1 <= f.p.zeta_threshold
  t34 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t36 = f.my_piecewise3(t33, t34 * f.p.zeta_threshold, 1)
  t39 = 2 ** (0.1e1 / 0.3e1)
  t43 = (0.2e1 * t36 - 0.2e1) / (0.2e1 * t39 - 0.2e1)
  t45 = 0.1e1 + 0.17777777777777777777777777777777777777777777777776e-5 * t3
  t47 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t14
  t48 = jnp.log(t47)
  t55 = jnp.pi * t7
  t56 = jnp.pi ** 2
  t57 = t56 ** (0.1e1 / 0.3e1)
  t59 = 0.1e1 / t57 / t56
  t60 = r0 ** 2
  t62 = 0.1e1 / t22 / t60
  t63 = s0 * t62
  t66 = t34 ** 2
  t68 = f.my_piecewise3(t33, t66 * f.p.zeta_threshold, 1)
  t69 = jnp.sqrt(t68)
  t70 = 0.1e1 / t69
  t72 = t1 ** (0.1e1 / 0.6e1)
  t73 = 0.1e1 / t72
  t74 = jnp.sqrt(s0)
  t75 = t73 * t74
  t76 = r0 ** (0.1e1 / 0.6e1)
  t81 = jnp.exp(-t6 * params.lm_f * t75 / t76 / r0)
  t82 = t70 * t81
  t86 = t59 * (-0.7e1 / 0.9e1 * t63 * t36 + 0.2e1 * t82 * t63)
  t91 = t1 / t60
  t93 = 0.70000000000000000000000000000000000000000000000000e-6 * t91 * t17
  t99 = 0.84000000000000000000000000000000000000000000000000e-1 * t5 * t7 * t9 * t24 / t16
  t103 = t21 * t11 / t22 / r0
  t105 = t12 * r0
  t108 = t27 * t28 / t105
  t122 = t60 * r0
  t125 = s0 / t22 / t122
  t129 = t70 * t6 * params.lm_f
  t132 = t60 ** 2
  t133 = t76 ** 2
  t134 = t133 ** 2
  t135 = t134 * t76
  vrho_0_ = -t19 + 0.70000000000000000000000000000000000000000000000000e-5 * t25 - 0.10500000000000000000000000000000000000000000000000e-3 * t31 + 0.84000000000000000000000000000000000000000000000000e-2 + t43 * (-0.127e-1 * t45 * t48 - 0.64355555555555555555555555555555555555555555555556e-5 * t25 + 0.83833333333333333333333333333333333333333333333334e-4 * t31 - 0.41666666666666666666666666666666666666666666666667e-2 + t19) + t55 * t86 * t12 / 0.144e3 + r0 * (t93 - t99 - 0.46666666666666666666666666666666666666666666666667e-5 * t103 + 0.35000000000000000000000000000000000000000000000000e-4 * t108 + t43 * (0.22577777777777777777777777777777777777777777777776e-7 * t91 * t48 - 0.10583333333333333333333333333333333333333333333333e0 * t45 * t7 * t9 * t24 / t47 + 0.42903703703703703703703703703703703703703703703704e-5 * t103 - 0.27944444444444444444444444444444444444444444444445e-4 * t108 - t93 + t99) + t55 * t59 * (0.56e2 / 0.27e2 * t125 * t36 + 0.7e1 / 0.3e1 * t129 * t73 * t74 * s0 / t135 / t132 * t81 - 0.16e2 / 0.3e1 * t82 * t125) * t12 / 0.144e3 + t55 * t86 * t23 / 0.432e3)
  vsigma_0_ = t105 * jnp.pi * t7 * t59 * (-0.7e1 / 0.9e1 * t62 * t36 - t129 * t75 / t135 / t122 * t81 + 0.2e1 * t82 * t62) / 0.144e3
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 / jnp.pi
  t2 = r0 ** 2
  t4 = t1 / t2
  t5 = 3 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = r0 ** (0.1e1 / 0.3e1)
  t13 = t6 * t8 * t10 * t11
  t15 = 0.1e1 + 0.10e2 * t13
  t16 = jnp.log(t15)
  t17 = t4 * t16
  t20 = t1 / r0
  t22 = 0.1e1 + t20 / 0.36000e5
  t24 = t22 * t6 * t8
  t25 = t11 ** 2
  t26 = 0.1e1 / t25
  t27 = t10 * t26
  t28 = 0.1e1 / t15
  t30 = t24 * t27 * t28
  t32 = t7 ** 2
  t33 = t6 * t32
  t35 = 0.1e1 / t25 / r0
  t36 = t10 * t35
  t37 = t33 * t36
  t39 = t5 * t7
  t40 = t10 ** 2
  t41 = t11 * r0
  t43 = t40 / t41
  t44 = t39 * t43
  t46 = 0.1e1 <= f.p.zeta_threshold
  t47 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t49 = f.my_piecewise3(t46, t47 * f.p.zeta_threshold, 1)
  t52 = 2 ** (0.1e1 / 0.3e1)
  t56 = (0.2e1 * t49 - 0.2e1) / (0.2e1 * t52 - 0.2e1)
  t58 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t13
  t59 = jnp.log(t58)
  t63 = 0.1e1 + 0.17777777777777777777777777777777777777777777777778e-5 * t20
  t65 = t63 * t6 * t8
  t66 = 0.1e1 / t58
  t77 = jnp.pi * t6
  t78 = jnp.pi ** 2
  t79 = t78 ** (0.1e1 / 0.3e1)
  t81 = 0.1e1 / t79 / t78
  t82 = t2 * r0
  t84 = 0.1e1 / t25 / t82
  t85 = s0 * t84
  t88 = t47 ** 2
  t90 = f.my_piecewise3(t46, t88 * f.p.zeta_threshold, 1)
  t91 = jnp.sqrt(t90)
  t92 = 0.1e1 / t91
  t94 = t92 * t5 * params.lm_f
  t95 = t1 ** (0.1e1 / 0.6e1)
  t96 = 0.1e1 / t95
  t97 = jnp.sqrt(s0)
  t99 = t96 * t97 * s0
  t100 = t2 ** 2
  t101 = r0 ** (0.1e1 / 0.6e1)
  t102 = t101 ** 2
  t103 = t102 ** 2
  t104 = t103 * t101
  t108 = t96 * t97
  t113 = jnp.exp(-t5 * params.lm_f * t108 / t101 / r0)
  t114 = 0.1e1 / t104 / t100 * t113
  t118 = t92 * t113
  t122 = t81 * (0.56e2 / 0.27e2 * t85 * t49 + 0.7e1 / 0.3e1 * t94 * t99 * t114 - 0.16e2 / 0.3e1 * t118 * t85)
  t127 = 0.1e1 / t25 / t2
  t128 = s0 * t127
  t134 = t81 * (-0.7e1 / 0.9e1 * t128 * t49 + 0.2e1 * t118 * t128)
  t139 = t1 / t82
  t141 = 0.14000000000000000000000000000000000000000000000000e-5 * t139 * t16
  t143 = t1 * t127 * t6
  t144 = t8 * t10
  t147 = 0.46666666666666666666666666666666666666666666666666e-5 * t143 * t144 * t28
  t150 = 0.56000000000000000000000000000000000000000000000000e-1 * t24 * t36 * t28
  t152 = 0.1e1 / t32
  t154 = t15 ** 2
  t158 = 0.84000000000000000000000000000000000000000000000000e0 * t22 * t5 * t152 * t43 / t154
  t160 = t33 * t10 * t127
  t165 = t39 * t40 / t11 / t2
  t177 = t58 ** 2
  t188 = s0 / t25 / t100
  t191 = t100 * r0
  t199 = params.lm_f ** 2
  t200 = t92 * t6 * t199
  t201 = s0 ** 2
  v2rho2_0_ = 0.14000000000000000000000000000000000000000000000000e-5 * t17 - 0.16800000000000000000000000000000000000000000000000e0 * t30 - 0.93333333333333333333333333333333333333333333333334e-5 * t37 + 0.70000000000000000000000000000000000000000000000000e-4 * t44 + 0.2e1 * t56 * (0.22577777777777777777777777777777777777777777777778e-7 * t4 * t59 - 0.10583333333333333333333333333333333333333333333333e0 * t65 * t27 * t66 + 0.42903703703703703703703703703703703703703703703704e-5 * t37 - 0.27944444444444444444444444444444444444444444444445e-4 * t44 - 0.70000000000000000000000000000000000000000000000000e-6 * t17 + 0.84000000000000000000000000000000000000000000000000e-1 * t30) + t77 * t122 * t11 / 0.72e2 + t77 * t134 * t26 / 0.216e3 + r0 * (-t141 + t147 + t150 + t158 + 0.77777777777777777777777777777777777777777777777778e-5 * t160 - 0.46666666666666666666666666666666666666666666666667e-4 * t165 + t56 * (-0.45155555555555555555555555555555555555555555555556e-7 * t139 * t59 + 0.37629629629629629629629629629629629629629629629629e-6 * t143 * t144 * t66 + 0.70555555555555555555555555555555555555555555555553e-1 * t65 * t36 * t66 + 0.26458333333333333333333333333333333333333333333332e1 * t63 * t5 * t152 * t43 / t177 - 0.71506172839506172839506172839506172839506172839507e-5 * t160 + 0.37259259259259259259259259259259259259259259259260e-4 * t165 + t141 - t147 - t150 - t158) + t77 * t81 * (-0.616e3 / 0.81e2 * t188 * t49 - 0.35e2 / 0.2e1 * t94 * t99 / t104 / t191 * t113 + 0.49e2 / 0.18e2 * t200 * t8 * t201 / t100 / t82 * t113 + 0.176e3 / 0.9e1 * t118 * t188) * t11 / 0.144e3 + t77 * t122 * t26 / 0.216e3 - t77 * t134 * t35 / 0.648e3)
  t225 = t6 * t81
  t230 = 0.1e1 / t104 / t82 * t113
  t239 = t41 * jnp.pi
  v2rhosigma_0_ = t11 * jnp.pi * t225 * (-0.7e1 / 0.9e1 * t127 * t49 - t94 * t108 * t230 + 0.2e1 * t118 * t127) / 0.108e3 + t239 * t225 * (0.56e2 / 0.27e2 * t84 * t49 + 0.37e2 / 0.6e1 * t94 * t108 * t114 - 0.7e1 / 0.6e1 * t200 * t8 * s0 / t100 / t2 * t113 - 0.16e2 / 0.3e1 * t118 * t84) / 0.144e3
  v2sigma2_0_ = t239 * t225 * (-0.3e1 / 0.2e1 * t94 * t96 / t97 * t230 + t200 * t8 / t191 * t113 / 0.2e1) / 0.144e3
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 / jnp.pi
  t2 = r0 ** 2
  t3 = t2 * r0
  t5 = t1 / t3
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = r0 ** (0.1e1 / 0.3e1)
  t14 = t7 * t9 * t11 * t12
  t16 = 0.1e1 + 0.10e2 * t14
  t17 = jnp.log(t16)
  t18 = t5 * t17
  t20 = t12 ** 2
  t22 = 0.1e1 / t20 / t2
  t24 = t1 * t22 * t7
  t25 = t9 * t11
  t26 = 0.1e1 / t16
  t27 = t25 * t26
  t28 = t24 * t27
  t31 = t1 / r0
  t33 = 0.1e1 + t31 / 0.36000e5
  t35 = t33 * t7 * t9
  t37 = 0.1e1 / t20 / r0
  t38 = t11 * t37
  t40 = t35 * t38 * t26
  t43 = t8 ** 2
  t44 = 0.1e1 / t43
  t45 = t33 * t6 * t44
  t46 = t11 ** 2
  t49 = t46 / t12 / r0
  t50 = t16 ** 2
  t51 = 0.1e1 / t50
  t53 = t45 * t49 * t51
  t55 = t7 * t43
  t56 = t11 * t22
  t57 = t55 * t56
  t59 = t6 * t8
  t62 = t46 / t12 / t2
  t63 = t59 * t62
  t65 = 0.1e1 <= f.p.zeta_threshold
  t66 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t65, t66 * f.p.zeta_threshold, 1)
  t71 = 2 ** (0.1e1 / 0.3e1)
  t75 = (0.2e1 * t68 - 0.2e1) / (0.2e1 * t71 - 0.2e1)
  t77 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t14
  t78 = jnp.log(t77)
  t81 = 0.1e1 / t77
  t82 = t25 * t81
  t86 = 0.1e1 + 0.17777777777777777777777777777777777777777777777778e-5 * t31
  t88 = t86 * t7 * t9
  t93 = t86 * t6 * t44
  t94 = t77 ** 2
  t95 = 0.1e1 / t94
  t108 = jnp.pi * t7
  t109 = jnp.pi ** 2
  t110 = t109 ** (0.1e1 / 0.3e1)
  t112 = 0.1e1 / t110 / t109
  t113 = t2 ** 2
  t116 = s0 / t20 / t113
  t119 = t66 ** 2
  t121 = f.my_piecewise3(t65, t119 * f.p.zeta_threshold, 1)
  t122 = jnp.sqrt(t121)
  t123 = 0.1e1 / t122
  t125 = t123 * t6 * params.lm_f
  t126 = t1 ** (0.1e1 / 0.6e1)
  t127 = 0.1e1 / t126
  t128 = jnp.sqrt(s0)
  t130 = t127 * t128 * s0
  t131 = t113 * r0
  t132 = r0 ** (0.1e1 / 0.6e1)
  t133 = t132 ** 2
  t134 = t133 ** 2
  t135 = t134 * t132
  t144 = jnp.exp(-t6 * params.lm_f * t127 * t128 / t132 / r0)
  t150 = params.lm_f ** 2
  t151 = t123 * t7 * t150
  t152 = s0 ** 2
  t153 = t9 * t152
  t160 = t123 * t144
  t164 = t112 * (-0.616e3 / 0.81e2 * t116 * t68 - 0.35e2 / 0.2e1 * t125 * t130 / t135 / t131 * t144 + 0.49e2 / 0.18e2 * t151 * t153 / t113 / t3 * t144 + 0.176e3 / 0.9e1 * t160 * t116)
  t169 = 0.1e1 / t20 / t3
  t170 = s0 * t169
  t182 = t112 * (0.56e2 / 0.27e2 * t170 * t68 + 0.7e1 / 0.3e1 * t125 * t130 / t135 / t113 * t144 - 0.16e2 / 0.3e1 * t160 * t170)
  t183 = 0.1e1 / t20
  t187 = s0 * t22
  t193 = t112 * (-0.7e1 / 0.9e1 * t187 * t68 + 0.2e1 * t160 * t187)
  t198 = t1 / t113
  t200 = 0.42000000000000000000000000000000000000000000000000e-5 * t198 * t17
  t202 = t1 * t169 * t7
  t204 = 0.18666666666666666666666666666666666666666666666666e-4 * t202 * t27
  t206 = 0.1e1 / t12 / t3
  t208 = t1 * t206 * t6
  t209 = t44 * t46
  t212 = 0.69999999999999999999999999999999999999999999999999e-4 * t208 * t209 * t51
  t215 = 0.93333333333333333333333333333333333333333333333334e-1 * t35 * t56 * t26
  t218 = 0.16800000000000000000000000000000000000000000000000e1 * t45 * t62 * t51
  t220 = 0.1e1 / t2
  t225 = 0.67200000000000000000000000000000000000000000000000e2 * t33 * jnp.pi * t220 / t50 / t16
  t227 = t55 * t11 * t169
  t230 = t59 * t46 * t206
  t253 = 0.13546666666666666666666666666666666666666666666667e-6 * t198 * t78 - 0.15051851851851851851851851851851851851851851851851e-5 * t202 * t82 - 0.14111111111111111111111111111111111111111111111111e-4 * t208 * t209 * t95 - 0.11759259259259259259259259259259259259259259259259e0 * t88 * t56 * t81 - 0.52916666666666666666666666666666666666666666666664e1 * t93 * t62 * t95 - 0.52916666666666666666666666666666666666666666666664e3 * t86 * jnp.pi * t220 / t94 / t77 + 0.19068312757201646090534979423868312757201646090535e-4 * t227 - 0.86938271604938271604938271604938271604938271604940e-4 * t230 - t200 + t204 + t212 + t215 + t218 + t225
  t257 = s0 / t20 / t131
  t267 = t113 ** 2
  t275 = jnp.sqrt(t1)
  t302 = t200 - t204 - t212 - t215 - t218 - t225 - 0.20740740740740740740740740740740740740740740740741e-4 * t227 + 0.10888888888888888888888888888888888888888888888889e-3 * t230 + t75 * t253 + t108 * t112 * (0.8624e4 / 0.243e3 * t257 * t68 + 0.13489e5 / 0.108e3 * t125 * t130 / t135 / t113 / t2 * t144 - 0.1421e4 / 0.36e2 * t151 * t153 / t267 * t144 + 0.343e3 / 0.36e2 * t123 * t150 * params.lm_f / t275 * t128 * t152 / t132 / t267 / r0 * t144 - 0.2464e4 / 0.27e2 * t160 * t257) * t12 / 0.144e3 + t108 * t164 * t183 / 0.144e3 - t108 * t182 * t37 / 0.216e3 + 0.5e1 / 0.1944e4 * t108 * t193 * t22
  v3rho3_0_ = -0.42000000000000000000000000000000000000000000000000e-5 * t18 + 0.14000000000000000000000000000000000000000000000000e-4 * t28 + 0.16800000000000000000000000000000000000000000000000e0 * t40 + 0.25200000000000000000000000000000000000000000000000e1 * t53 + 0.23333333333333333333333333333333333333333333333334e-4 * t57 - 0.14000000000000000000000000000000000000000000000000e-3 * t63 + 0.3e1 * t75 * (-0.45155555555555555555555555555555555555555555555556e-7 * t5 * t78 + 0.37629629629629629629629629629629629629629629629629e-6 * t24 * t82 + 0.70555555555555555555555555555555555555555555555553e-1 * t88 * t38 * t81 + 0.26458333333333333333333333333333333333333333333332e1 * t93 * t49 * t95 - 0.71506172839506172839506172839506172839506172839507e-5 * t57 + 0.37259259259259259259259259259259259259259259259260e-4 * t63 + 0.14000000000000000000000000000000000000000000000000e-5 * t18 - 0.46666666666666666666666666666666666666666666666666e-5 * t28 - 0.56000000000000000000000000000000000000000000000000e-1 * t40 - 0.84000000000000000000000000000000000000000000000000e0 * t53) + t108 * t164 * t12 / 0.48e2 + t108 * t182 * t183 / 0.72e2 - t108 * t193 * t37 / 0.216e3 + r0 * t302

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = jnp.pi * t2
  t4 = jnp.pi ** 2
  t5 = t4 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / t5 / t4
  t8 = r0 ** 2
  t9 = t8 ** 2
  t10 = t9 * t8
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t15 = s0 / t12 / t10
  t16 = 0.1e1 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t16, t17 * f.p.zeta_threshold, 1)
  t22 = t17 ** 2
  t24 = f.my_piecewise3(t16, t22 * f.p.zeta_threshold, 1)
  t25 = jnp.sqrt(t24)
  t26 = 0.1e1 / t25
  t28 = t26 * t1 * params.lm_f
  t29 = 0.1e1 / jnp.pi
  t30 = t29 ** (0.1e1 / 0.6e1)
  t31 = 0.1e1 / t30
  t32 = jnp.sqrt(s0)
  t34 = t31 * t32 * s0
  t35 = t8 * r0
  t36 = t9 * t35
  t37 = r0 ** (0.1e1 / 0.6e1)
  t38 = t37 ** 2
  t39 = t38 ** 2
  t40 = t39 * t37
  t49 = jnp.exp(-t1 * params.lm_f * t31 * t32 / t37 / r0)
  t55 = params.lm_f ** 2
  t56 = t26 * t2 * t55
  t57 = t29 ** (0.1e1 / 0.3e1)
  t58 = 0.1e1 / t57
  t59 = s0 ** 2
  t60 = t58 * t59
  t61 = t9 ** 2
  t62 = t61 * r0
  t70 = jnp.sqrt(t29)
  t72 = t26 * t55 * params.lm_f / t70
  t73 = t32 * t59
  t81 = t55 ** 2
  t83 = t57 ** 2
  t84 = 0.1e1 / t83
  t95 = t26 * t49
  t103 = 0.1e1 / t9
  t105 = 4 ** (0.1e1 / 0.3e1)
  t107 = t2 * t58 * t105 * t11
  t109 = 0.1e1 + 0.10e2 * t107
  t110 = t109 ** 2
  t112 = 0.1e1 / t110 / t109
  t114 = 0.74666666666666666666666666666666666666666666666666e-2 * t103 * t112
  t115 = t9 * r0
  t117 = t29 / t115
  t118 = jnp.log(t109)
  t120 = 0.16800000000000000000000000000000000000000000000000e-4 * t117 * t118
  t122 = t29 / r0
  t124 = 0.1e1 + t122 / 0.36000e5
  t125 = t124 * jnp.pi
  t126 = 0.1e1 / t35
  t129 = 0.26880000000000000000000000000000000000000000000000e3 * t125 * t126 * t112
  t130 = t2 * t83
  t132 = 0.1e1 / t12 / t9
  t134 = t130 * t105 * t132
  t136 = t1 * t57
  t137 = t105 ** 2
  t139 = 0.1e1 / t11 / t9
  t141 = t136 * t137 * t139
  t145 = 2 ** (0.1e1 / 0.3e1)
  t149 = (0.2e1 * t19 - 0.2e1) / (0.2e1 * t145 - 0.2e1)
  t151 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t107
  t152 = t151 ** 2
  t154 = 0.1e1 / t152 / t151
  t157 = jnp.log(t151)
  t161 = 0.1e1 + 0.17777777777777777777777777777777777777777777777778e-5 * t122
  t162 = t161 * jnp.pi
  t169 = t29 * t132 * t2
  t170 = t58 * t105
  t171 = 0.1e1 / t109
  t172 = t170 * t171
  t174 = 0.85037037037037037037037037037037037037037037037035e-4 * t169 * t172
  t176 = t29 * t139 * t1
  t177 = t84 * t137
  t178 = 0.1e1 / t110
  t179 = t177 * t178
  t181 = 0.46666666666666666666666666666666666666666666666666e-3 * t176 * t179
  t183 = t124 * t1 * t84
  t185 = 0.1e1 / t11 / t35
  t186 = t137 * t185
  t189 = 0.48533333333333333333333333333333333333333333333333e1 * t183 * t186 * t178
  t190 = 0.1e1 / t151
  t191 = t170 * t190
  t194 = 0.1e1 / t152
  t195 = t177 * t194
  t199 = t161 * t1 * t84
  t204 = t124 * t2 * t58
  t206 = 0.1e1 / t12 / t35
  t207 = t105 * t206
  t210 = 0.24888888888888888888888888888888888888888888888889e0 * t204 * t207 * t171
  t212 = 0.1e1 / t12 / t8
  t214 = t110 ** 2
  t219 = 0.67200000000000000000000000000000000000000000000000e3 * t125 * t212 / t214 * t2 * t170
  t221 = t161 * t2 * t58
  t226 = t152 ** 2
  t232 = -t114 + 0.37629629629629629629629629629629629629629629629629e-2 * t103 * t154 + t120 - t129 - 0.54186666666666666666666666666666666666666666666668e-6 * t117 * t157 + 0.21166666666666666666666666666666666666666666666666e4 * t162 * t126 * t154 - 0.69917146776406035665294924554183813443072702331962e-4 * t134 + 0.28979423868312757201646090534979423868312757201647e-3 * t141 - t174 - t181 - t189 + 0.68569547325102880658436213991769547325102880658433e-5 * t169 * t191 + 0.94074074074074074074074074074074074074074074074072e-4 * t176 * t195 + 0.15287037037037037037037037037037037037037037037037e2 * t199 * t186 * t194 - t210 - t219 + 0.31358024691358024691358024691358024691358024691357e0 * t221 * t207 * t190 + 0.13229166666666666666666666666666666666666666666666e5 * t162 * t212 / t226 * t2 * t170
  t236 = s0 / t12 / t115
  t259 = t7 * (0.8624e4 / 0.243e3 * t236 * t19 + 0.13489e5 / 0.108e3 * t28 * t34 / t40 / t10 * t49 - 0.1421e4 / 0.36e2 * t56 * t60 / t61 * t49 + 0.343e3 / 0.36e2 * t72 * t73 / t37 / t62 * t49 - 0.2464e4 / 0.27e2 * t95 * t236)
  t260 = 0.1e1 / t12
  t264 = s0 * t132
  t281 = t7 * (-0.616e3 / 0.81e2 * t264 * t19 - 0.35e2 / 0.2e1 * t28 * t34 / t40 / t115 * t49 + 0.49e2 / 0.18e2 * t56 * t60 / t36 * t49 + 0.176e3 / 0.9e1 * t95 * t264)
  t283 = 0.1e1 / t12 / r0
  t287 = s0 * t206
  t299 = t7 * (0.56e2 / 0.27e2 * t287 * t19 + 0.7e1 / 0.3e1 * t28 * t34 / t40 / t9 * t49 - 0.16e2 / 0.3e1 * t95 * t287)
  t303 = s0 * t212
  t309 = t7 * (-0.7e1 / 0.9e1 * t303 * t19 + 0.2e1 * t95 * t303)
  t313 = t3 * t7 * (-0.146608e6 / 0.729e3 * t15 * t19 - 0.207347e6 / 0.216e3 * t28 * t34 / t40 / t36 * t49 + 0.299047e6 / 0.648e3 * t56 * t60 / t62 * t49 - 0.24353e5 / 0.108e3 * t72 * t73 / t37 / t61 / t8 * t49 + 0.2401e4 / 0.216e3 * t26 * t81 * t84 * t59 * s0 / t11 / t61 / t35 * t1 * t49 + 0.41888e5 / 0.81e2 * t95 * t15) * t11 / 0.144e3 + t114 - t120 + t129 + 0.76049382716049382716049382716049382716049382716050e-4 * t134 - 0.36296296296296296296296296296296296296296296296297e-3 * t141 + t149 * t232 + t174 + t181 + t189 + t3 * t259 * t260 / 0.108e3 - t3 * t281 * t283 / 0.108e3 + 0.5e1 / 0.486e3 * t3 * t299 * t212 - 0.5e1 / 0.729e3 * t3 * t309 * t206 + t210 + t219
  t315 = t29 * t103
  t316 = t315 * t118
  t321 = t29 * t206 * t2
  t325 = t29 * t185 * t1
  t328 = t105 * t212
  t334 = t137 / t11 / t8
  t338 = 0.1e1 / t8
  t342 = t130 * t207
  t344 = t136 * t186
  t347 = t321 * t172
  t349 = t325 * t179
  t352 = t204 * t328 * t171
  t355 = t183 * t334 * t178
  t358 = t125 * t338 * t112
  t360 = 0.13546666666666666666666666666666666666666666666667e-6 * t315 * t157 - 0.15051851851851851851851851851851851851851851851851e-5 * t321 * t191 - 0.14111111111111111111111111111111111111111111111111e-4 * t325 * t195 - 0.11759259259259259259259259259259259259259259259259e0 * t221 * t328 * t190 - 0.52916666666666666666666666666666666666666666666664e1 * t199 * t334 * t194 - 0.52916666666666666666666666666666666666666666666664e3 * t162 * t338 * t154 + 0.19068312757201646090534979423868312757201646090535e-4 * t342 - 0.86938271604938271604938271604938271604938271604940e-4 * t344 - 0.42000000000000000000000000000000000000000000000000e-5 * t316 + 0.18666666666666666666666666666666666666666666666666e-4 * t347 + 0.69999999999999999999999999999999999999999999999999e-4 * t349 + 0.93333333333333333333333333333333333333333333333334e-1 * t352 + 0.16800000000000000000000000000000000000000000000000e1 * t355 + 0.67200000000000000000000000000000000000000000000000e2 * t358
  v4rho4_0_ = r0 * t313 + 0.16800000000000000000000000000000000000000000000000e-4 * t316 + 0.4e1 * t149 * t360 + t3 * t259 * t11 / 0.36e2 + t3 * t281 * t260 / 0.36e2 - t3 * t299 * t283 / 0.54e2 + 0.5e1 / 0.486e3 * t3 * t309 * t212 - 0.26880000000000000000000000000000000000000000000000e3 * t358 - 0.82962962962962962962962962962962962962962962962965e-4 * t342 + 0.43555555555555555555555555555555555555555555555556e-3 * t344 - 0.74666666666666666666666666666666666666666666666666e-4 * t347 - 0.28000000000000000000000000000000000000000000000000e-3 * t349 - 0.37333333333333333333333333333333333333333333333333e0 * t352 - 0.67200000000000000000000000000000000000000000000000e1 * t355

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 0.1e1 / jnp.pi
  t2 = r0 + r1
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = t1 * t4
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t2 ** (0.1e1 / 0.3e1)
  t14 = t7 * t9 * t11 * t12
  t16 = 0.1e1 + 0.10e2 * t14
  t17 = jnp.log(t16)
  t18 = t5 * t17
  t19 = 0.14000000000000000000000000000000000000000000000000e-5 * t18
  t20 = 0.1e1 / t2
  t21 = t1 * t20
  t23 = 0.1e1 + t21 / 0.36000e5
  t25 = t23 * t7 * t9
  t26 = t12 ** 2
  t27 = 0.1e1 / t26
  t28 = t11 * t27
  t29 = 0.1e1 / t16
  t31 = t25 * t28 * t29
  t32 = 0.16800000000000000000000000000000000000000000000000e0 * t31
  t33 = t8 ** 2
  t34 = t7 * t33
  t36 = 0.1e1 / t26 / t2
  t37 = t11 * t36
  t38 = t34 * t37
  t39 = 0.93333333333333333333333333333333333333333333333334e-5 * t38
  t40 = t6 * t8
  t41 = t11 ** 2
  t44 = t41 / t12 / t2
  t45 = t40 * t44
  t46 = 0.70000000000000000000000000000000000000000000000000e-4 * t45
  t47 = r0 - r1
  t48 = t47 * t20
  t49 = 0.1e1 + t48
  t50 = t49 <= f.p.zeta_threshold
  t51 = t49 ** (0.1e1 / 0.3e1)
  t52 = t47 * t4
  t53 = t20 - t52
  t56 = f.my_piecewise3(t50, 0, 0.4e1 / 0.3e1 * t51 * t53)
  t57 = 0.1e1 - t48
  t58 = t57 <= f.p.zeta_threshold
  t59 = t57 ** (0.1e1 / 0.3e1)
  t60 = -t53
  t63 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t60)
  t65 = 2 ** (0.1e1 / 0.3e1)
  t68 = 0.1e1 / (0.2e1 * t65 - 0.2e1)
  t69 = (t56 + t63) * t68
  t71 = 0.1e1 + 0.17777777777777777777777777777777777777777777777778e-5 * t21
  t73 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t14
  t74 = jnp.log(t73)
  t85 = -0.127e-1 * t71 * t74 - 0.64355555555555555555555555555555555555555555555556e-5 * t34 * t28 + 0.83833333333333333333333333333333333333333333333334e-4 * t40 * t41 / t12 - 0.41666666666666666666666666666666666666666666666667e-2 + 0.252e-1 * t23 * t17
  t86 = t69 * t85
  t88 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t89 = t88 * f.p.zeta_threshold
  t91 = f.my_piecewise3(t50, t89, t51 * t49)
  t93 = f.my_piecewise3(t58, t89, t59 * t57)
  t95 = (t91 + t93 - 0.2e1) * t68
  t99 = t71 * t7 * t9
  t100 = 0.1e1 / t73
  t108 = 0.22577777777777777777777777777777777777777777777778e-7 * t5 * t74 - 0.10583333333333333333333333333333333333333333333333e0 * t99 * t28 * t100 + 0.42903703703703703703703703703703703703703703703704e-5 * t38 - 0.27944444444444444444444444444444444444444444444445e-4 * t45 - 0.70000000000000000000000000000000000000000000000000e-6 * t18 + 0.84000000000000000000000000000000000000000000000000e-1 * t31
  t110 = 0.2e1 * t95 * t108
  t111 = jnp.pi * t7
  t112 = jnp.pi ** 2
  t113 = t112 ** (0.1e1 / 0.3e1)
  t115 = 0.1e1 / t113 / t112
  t116 = r0 ** 2
  t118 = r0 ** (0.1e1 / 0.3e1)
  t119 = t118 ** 2
  t122 = s0 / t119 / t116 / r0
  t127 = s0 / t119 / t116
  t129 = r1 ** 2
  t130 = r1 ** (0.1e1 / 0.3e1)
  t131 = t130 ** 2
  t134 = s2 / t131 / t129
  t139 = t88 ** 2
  t140 = t139 * f.p.zeta_threshold
  t141 = t51 ** 2
  t143 = f.my_piecewise3(t50, t140, t141 * t49)
  t144 = t59 ** 2
  t146 = f.my_piecewise3(t58, t140, t144 * t57)
  t147 = t143 + t146
  t148 = jnp.sqrt(t147)
  t151 = jnp.sqrt(0.2e1)
  t152 = 0.1e1 / t148 / t147 * t151
  t153 = t6 * params.lm_f
  t154 = t1 ** (0.1e1 / 0.6e1)
  t155 = 0.1e1 / t154
  t157 = s0 + 0.2e1 * s1 + s2
  t158 = jnp.sqrt(t157)
  t160 = t2 ** (0.1e1 / 0.6e1)
  t165 = jnp.exp(-t153 * t155 * t158 / t160 / t2)
  t166 = t152 * t165
  t168 = 0.1e1 / t26 / t3
  t169 = t157 * t168
  t172 = f.my_piecewise3(t50, 0, 0.5e1 / 0.3e1 * t141 * t53)
  t175 = f.my_piecewise3(t58, 0, 0.5e1 / 0.3e1 * t144 * t60)
  t176 = t172 + t175
  t180 = 0.1e1 / t148 * t151
  t181 = t180 * t153
  t183 = t155 * t158 * t157
  t184 = t3 ** 2
  t185 = t160 ** 2
  t186 = t185 ** 2
  t187 = t186 * t160
  t190 = 0.1e1 / t187 / t184 * t165
  t193 = 0.7e1 / 0.3e1 * t181 * t183 * t190
  t194 = t165 * t157
  t195 = t3 * t2
  t197 = 0.1e1 / t26 / t195
  t200 = 0.16e2 / 0.3e1 * t180 * t194 * t197
  t202 = t115 * (-0.7e1 / 0.36e2 * t65 * (-0.8e1 / 0.3e1 * t122 * t91 + t127 * t56 + t134 * t63) - t166 * t169 * t176 + t193 - t200)
  t204 = t111 * t202 * t12
  t215 = t115 * (-0.7e1 / 0.36e2 * t65 * (t127 * t91 + t134 * t93) + 0.2e1 * t180 * t194 * t168)
  t218 = t111 * t215 * t27 / 0.216e3
  t219 = 0.1e1 / t195
  t220 = t1 * t219
  t222 = 0.14000000000000000000000000000000000000000000000000e-5 * t220 * t17
  t224 = t1 * t168 * t7
  t225 = t9 * t11
  t228 = 0.46666666666666666666666666666666666666666666666666e-5 * t224 * t225 * t29
  t231 = 0.56000000000000000000000000000000000000000000000000e-1 * t25 * t37 * t29
  t233 = 0.1e1 / t33
  t235 = t16 ** 2
  t239 = 0.84000000000000000000000000000000000000000000000000e0 * t23 * t6 * t233 * t44 / t235
  t241 = t34 * t11 * t168
  t242 = 0.77777777777777777777777777777777777777777777777778e-5 * t241
  t246 = t40 * t41 / t12 / t3
  t247 = 0.46666666666666666666666666666666666666666666666667e-4 * t246
  t248 = 0.1e1 / t141
  t249 = t53 ** 2
  t252 = t47 * t219
  t254 = -0.2e1 * t4 + 0.2e1 * t252
  t258 = f.my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t248 * t249 + 0.4e1 / 0.3e1 * t51 * t254)
  t259 = 0.1e1 / t144
  t260 = t60 ** 2
  t263 = -t254
  t267 = f.my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t259 * t260 + 0.4e1 / 0.3e1 * t59 * t263)
  t271 = t69 * t108
  t283 = t73 ** 2
  t291 = t95 * (-0.45155555555555555555555555555555555555555555555556e-7 * t220 * t74 + 0.37629629629629629629629629629629629629629629629629e-6 * t224 * t225 * t100 + 0.70555555555555555555555555555555555555555555555553e-1 * t99 * t37 * t100 + 0.26458333333333333333333333333333333333333333333332e1 * t71 * t6 * t233 * t44 / t283 - 0.71506172839506172839506172839506172839506172839507e-5 * t241 + 0.37259259259259259259259259259259259259259259259260e-4 * t246 + t222 - t228 - t231 - t239)
  t292 = t116 ** 2
  t305 = t147 ** 2
  t309 = 0.1e1 / t148 / t305 * t151 * t165
  t310 = t176 ** 2
  t314 = t152 * t153
  t317 = t314 * t183 * t190 * t176
  t319 = t157 * t197
  t321 = t166 * t319 * t176
  t323 = 0.1e1 / t51
  t329 = f.my_piecewise3(t50, 0, 0.10e2 / 0.9e1 * t323 * t249 + 0.5e1 / 0.3e1 * t141 * t254)
  t330 = 0.1e1 / t59
  t336 = f.my_piecewise3(t58, 0, 0.10e2 / 0.9e1 * t330 * t260 + 0.5e1 / 0.3e1 * t144 * t263)
  t346 = 0.35e2 / 0.2e1 * t181 * t183 / t187 / t184 / t2 * t165
  t347 = params.lm_f ** 2
  t350 = t157 ** 2
  t357 = 0.49e2 / 0.18e2 * t180 * t7 * t347 * t9 * t350 / t184 / t195 * t165
  t362 = 0.176e3 / 0.9e1 * t180 * t194 / t26 / t184
  t369 = t111 * t202 * t27
  t373 = t111 * t215 * t36 / 0.648e3
  t374 = -t222 + t228 + t231 + t239 + t242 - t247 + (t258 + t267) * t68 * t85 + 0.2e1 * t271 + t291 + t111 * t115 * (-0.7e1 / 0.36e2 * t65 * (0.88e2 / 0.9e1 * s0 / t119 / t292 * t91 - 0.16e2 / 0.3e1 * t122 * t56 + t127 * t258 + t134 * t267) + 0.3e1 / 0.2e1 * t309 * t169 * t310 - 0.7e1 / 0.3e1 * t317 + 0.16e2 / 0.3e1 * t321 - t166 * t169 * (t329 + t336) - t346 + t357 + t362) * t12 / 0.144e3 + t369 / 0.216e3 - t373
  d11 = t19 - t32 - t39 + t46 + 0.2e1 * t86 + t110 + t204 / 0.72e2 + t218 + t2 * t374
  t377 = -t20 - t52
  t380 = f.my_piecewise3(t50, 0, 0.4e1 / 0.3e1 * t51 * t377)
  t381 = -t377
  t384 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t59 * t381)
  t386 = (t380 + t384) * t68
  t387 = t386 * t85
  t392 = s2 / t131 / t129 / r1
  t401 = f.my_piecewise3(t50, 0, 0.5e1 / 0.3e1 * t141 * t377)
  t404 = f.my_piecewise3(t58, 0, 0.5e1 / 0.3e1 * t144 * t381)
  t405 = t401 + t404
  t409 = t115 * (-0.7e1 / 0.36e2 * t65 * (t127 * t380 - 0.8e1 / 0.3e1 * t392 * t93 + t134 * t384) - t166 * t169 * t405 + t193 - t200)
  t411 = t111 * t409 * t12
  t420 = f.my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t248 * t377 * t53 + 0.8e1 / 0.3e1 * t51 * t47 * t219)
  t428 = f.my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t259 * t381 * t60 - 0.8e1 / 0.3e1 * t59 * t47 * t219)
  t432 = t386 * t108
  t448 = t314 * t183 * t190 * t405
  t451 = t166 * t319 * t405
  t460 = f.my_piecewise3(t50, 0, 0.10e2 / 0.9e1 * t323 * t377 * t53 + 0.10e2 / 0.3e1 * t141 * t47 * t219)
  t468 = f.my_piecewise3(t58, 0, 0.10e2 / 0.9e1 * t330 * t381 * t60 - 0.10e2 / 0.3e1 * t144 * t47 * t219)
  t480 = t111 * t409 * t27
  t483 = -t222 + t228 + t231 + t239 + t242 - t247 + (t420 + t428) * t68 * t85 + t432 + t271 + t291 + t111 * t115 * (-0.7e1 / 0.36e2 * t65 * (-0.8e1 / 0.3e1 * t122 * t380 + t127 * t420 - 0.8e1 / 0.3e1 * t392 * t63 + t134 * t428) + 0.3e1 / 0.2e1 * t309 * t169 * t405 * t176 - 0.7e1 / 0.6e1 * t448 + 0.8e1 / 0.3e1 * t451 - t166 * t169 * (t460 + t468) - 0.7e1 / 0.6e1 * t317 - t346 + t357 + 0.8e1 / 0.3e1 * t321 + t362) * t12 / 0.144e3 + t480 / 0.432e3 + t369 / 0.432e3 - t373
  d12 = t19 - t32 - t39 + t46 + t86 + t110 + t204 / 0.144e3 + t218 + t387 + t411 / 0.144e3 + t2 * t483
  t487 = t377 ** 2
  t491 = 0.2e1 * t4 + 0.2e1 * t252
  t495 = f.my_piecewise3(t50, 0, 0.4e1 / 0.9e1 * t248 * t487 + 0.4e1 / 0.3e1 * t51 * t491)
  t496 = t381 ** 2
  t499 = -t491
  t503 = f.my_piecewise3(t58, 0, 0.4e1 / 0.9e1 * t259 * t496 + 0.4e1 / 0.3e1 * t59 * t499)
  t509 = t129 ** 2
  t521 = t405 ** 2
  t532 = f.my_piecewise3(t50, 0, 0.10e2 / 0.9e1 * t323 * t487 + 0.5e1 / 0.3e1 * t141 * t491)
  t538 = f.my_piecewise3(t58, 0, 0.10e2 / 0.9e1 * t330 * t496 + 0.5e1 / 0.3e1 * t144 * t499)
  t548 = -t222 + t228 + t231 + t239 + t242 - t247 + (t495 + t503) * t68 * t85 + 0.2e1 * t432 + t291 + t111 * t115 * (-0.7e1 / 0.36e2 * t65 * (t127 * t495 + 0.88e2 / 0.9e1 * s2 / t131 / t509 * t93 - 0.16e2 / 0.3e1 * t392 * t384 + t134 * t503) + 0.3e1 / 0.2e1 * t309 * t169 * t521 - 0.7e1 / 0.3e1 * t448 + 0.16e2 / 0.3e1 * t451 - t166 * t169 * (t532 + t538) - t346 + t357 + t362) * t12 / 0.144e3 + t480 / 0.216e3 - t373
  d22 = t19 - t32 - t39 + t46 + 0.2e1 * t387 + t110 + t411 / 0.72e2 + t218 + t2 * t548
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = jnp.pi * t2
  t4 = jnp.pi ** 2
  t5 = t4 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / t5 / t4
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = r0 ** 2
  t10 = r0 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t14 = s0 / t11 / t9
  t15 = r0 - r1
  t16 = r0 + r1
  t17 = 0.1e1 / t16
  t18 = t15 * t17
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t24 = t23 * t19
  t25 = f.my_piecewise3(t20, t22, t24)
  t27 = r1 ** 2
  t28 = r1 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t32 = s2 / t29 / t27
  t33 = 0.1e1 - t18
  t34 = t33 <= f.p.zeta_threshold
  t35 = t33 ** (0.1e1 / 0.3e1)
  t36 = t35 * t33
  t37 = f.my_piecewise3(t34, t22, t36)
  t42 = t21 ** 2
  t43 = t42 * f.p.zeta_threshold
  t44 = t23 ** 2
  t45 = t44 * t19
  t46 = f.my_piecewise3(t20, t43, t45)
  t47 = t35 ** 2
  t48 = t47 * t33
  t49 = f.my_piecewise3(t34, t43, t48)
  t50 = t46 + t49
  t51 = jnp.sqrt(t50)
  t53 = jnp.sqrt(0.2e1)
  t54 = 0.1e1 / t51 * t53
  t55 = t1 * params.lm_f
  t56 = 0.1e1 / jnp.pi
  t57 = t56 ** (0.1e1 / 0.6e1)
  t58 = 0.1e1 / t57
  t60 = s0 + 0.2e1 * s1 + s2
  t61 = jnp.sqrt(t60)
  t63 = t16 ** (0.1e1 / 0.6e1)
  t68 = jnp.exp(-t55 * t58 * t61 / t63 / t16)
  t69 = t68 * t60
  t70 = t16 ** 2
  t71 = t16 ** (0.1e1 / 0.3e1)
  t72 = t71 ** 2
  t74 = 0.1e1 / t72 / t70
  t79 = t7 * (-0.7e1 / 0.36e2 * t8 * (t14 * t25 + t32 * t37) + 0.2e1 * t54 * t69 * t74)
  t81 = 0.1e1 / t72 / t16
  t85 = t70 ** 2
  t86 = 0.1e1 / t85
  t87 = t56 * t86
  t88 = t56 ** (0.1e1 / 0.3e1)
  t89 = 0.1e1 / t88
  t91 = 4 ** (0.1e1 / 0.3e1)
  t93 = t2 * t89 * t91 * t71
  t95 = 0.1e1 + 0.10e2 * t93
  t96 = jnp.log(t95)
  t98 = 0.42000000000000000000000000000000000000000000000000e-5 * t87 * t96
  t99 = t70 * t16
  t101 = 0.1e1 / t72 / t99
  t103 = t56 * t101 * t2
  t104 = t89 * t91
  t105 = 0.1e1 / t95
  t106 = t104 * t105
  t108 = 0.18666666666666666666666666666666666666666666666666e-4 * t103 * t106
  t110 = 0.1e1 / t71 / t99
  t112 = t56 * t110 * t1
  t113 = t88 ** 2
  t114 = 0.1e1 / t113
  t115 = t91 ** 2
  t116 = t114 * t115
  t117 = t95 ** 2
  t118 = 0.1e1 / t117
  t121 = 0.69999999999999999999999999999999999999999999999999e-4 * t112 * t116 * t118
  t122 = t56 * t17
  t124 = 0.1e1 + t122 / 0.36000e5
  t126 = t124 * t2 * t89
  t127 = t91 * t74
  t130 = 0.93333333333333333333333333333333333333333333333334e-1 * t126 * t127 * t105
  t132 = t124 * t1 * t114
  t135 = t115 / t71 / t70
  t138 = 0.16800000000000000000000000000000000000000000000000e1 * t132 * t135 * t118
  t140 = 0.1e1 / t70
  t145 = 0.67200000000000000000000000000000000000000000000000e2 * t124 * jnp.pi * t140 / t117 / t95
  t146 = t2 * t113
  t148 = t146 * t91 * t101
  t150 = t1 * t88
  t152 = t150 * t115 * t110
  t156 = -t15 * t140 + t17
  t157 = t156 ** 2
  t158 = t157 * t156
  t161 = 0.1e1 / t44
  t163 = 0.1e1 / t99
  t166 = 0.2e1 * t15 * t163 - 0.2e1 * t140
  t171 = -0.6e1 * t15 * t86 + 0.6e1 * t163
  t175 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t45 * t158 + 0.4e1 / 0.3e1 * t161 * t156 * t166 + 0.4e1 / 0.3e1 * t23 * t171)
  t177 = -t156
  t178 = t177 ** 2
  t179 = t178 * t177
  t182 = 0.1e1 / t47
  t184 = -t166
  t187 = -t171
  t191 = f.my_piecewise3(t34, 0, -0.8e1 / 0.27e2 / t48 * t179 + 0.4e1 / 0.3e1 * t182 * t177 * t184 + 0.4e1 / 0.3e1 * t35 * t187)
  t195 = 0.1e1 / (0.2e1 * t8 - 0.2e1)
  t198 = 0.1e1 + 0.17777777777777777777777777777777777777777777777778e-5 * t122
  t200 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t93
  t201 = jnp.log(t200)
  t204 = 0.1e1 / t72
  t205 = t91 * t204
  t214 = -0.127e-1 * t198 * t201 - 0.64355555555555555555555555555555555555555555555556e-5 * t146 * t205 + 0.83833333333333333333333333333333333333333333333334e-4 * t150 * t115 / t71 - 0.41666666666666666666666666666666666666666666666667e-2 + 0.252e-1 * t124 * t96
  t221 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t161 * t157 + 0.4e1 / 0.3e1 * t23 * t166)
  t227 = f.my_piecewise3(t34, 0, 0.4e1 / 0.9e1 * t182 * t178 + 0.4e1 / 0.3e1 * t35 * t184)
  t229 = (t221 + t227) * t195
  t230 = t56 * t140
  t234 = t198 * t2 * t89
  t235 = 0.1e1 / t200
  t239 = t91 * t81
  t244 = t115 / t71 / t16
  t252 = 0.22577777777777777777777777777777777777777777777778e-7 * t230 * t201 - 0.10583333333333333333333333333333333333333333333333e0 * t234 * t205 * t235 + 0.42903703703703703703703703703703703703703703703704e-5 * t146 * t239 - 0.27944444444444444444444444444444444444444444444445e-4 * t150 * t244 - 0.70000000000000000000000000000000000000000000000000e-6 * t230 * t96 + 0.84000000000000000000000000000000000000000000000000e-1 * t126 * t205 * t105
  t257 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t156)
  t260 = f.my_piecewise3(t34, 0, 0.4e1 / 0.3e1 * t35 * t177)
  t262 = (t257 + t260) * t195
  t263 = t56 * t163
  t267 = t56 * t74 * t2
  t268 = t104 * t235
  t275 = t198 * t1 * t114
  t276 = t200 ** 2
  t277 = 0.1e1 / t276
  t281 = t146 * t127
  t283 = t150 * t135
  t285 = t263 * t96
  t287 = t267 * t106
  t290 = t126 * t239 * t105
  t293 = t132 * t244 * t118
  t295 = -0.45155555555555555555555555555555555555555555555556e-7 * t263 * t201 + 0.37629629629629629629629629629629629629629629629629e-6 * t267 * t268 + 0.70555555555555555555555555555555555555555555555553e-1 * t234 * t239 * t235 + 0.26458333333333333333333333333333333333333333333332e1 * t275 * t244 * t277 - 0.71506172839506172839506172839506172839506172839507e-5 * t281 + 0.37259259259259259259259259259259259259259259259260e-4 * t283 + 0.14000000000000000000000000000000000000000000000000e-5 * t285 - 0.46666666666666666666666666666666666666666666666666e-5 * t287 - 0.56000000000000000000000000000000000000000000000000e-1 * t290 - 0.84000000000000000000000000000000000000000000000000e0 * t293
  t299 = (t25 + t37 - 0.2e1) * t195
  t321 = 0.13546666666666666666666666666666666666666666666667e-6 * t87 * t201 - 0.15051851851851851851851851851851851851851851851851e-5 * t103 * t268 - 0.14111111111111111111111111111111111111111111111111e-4 * t112 * t116 * t277 - 0.11759259259259259259259259259259259259259259259259e0 * t234 * t127 * t235 - 0.52916666666666666666666666666666666666666666666664e1 * t275 * t135 * t277 - 0.52916666666666666666666666666666666666666666666664e3 * t198 * jnp.pi * t140 / t276 / t200 + 0.19068312757201646090534979423868312757201646090535e-4 * t148 - 0.86938271604938271604938271604938271604938271604940e-4 * t152 - t98 + t108 + t121 + t130 + t138 + t145
  t323 = t50 ** 2
  t326 = 0.1e1 / t51 / t323 * t53
  t329 = t58 * t61 * t60
  t330 = t63 ** 2
  t331 = t330 ** 2
  t332 = t331 * t63
  t335 = 0.1e1 / t332 / t85 * t68
  t338 = f.my_piecewise3(t20, 0, 0.5e1 / 0.3e1 * t44 * t156)
  t341 = f.my_piecewise3(t34, 0, 0.5e1 / 0.3e1 * t47 * t177)
  t342 = t338 + t341
  t343 = t342 ** 2
  t350 = 0.1e1 / t51 / t50 * t53
  t351 = t350 * t55
  t352 = 0.1e1 / t23
  t358 = f.my_piecewise3(t20, 0, 0.10e2 / 0.9e1 * t352 * t157 + 0.5e1 / 0.3e1 * t44 * t166)
  t359 = 0.1e1 / t35
  t365 = f.my_piecewise3(t34, 0, 0.10e2 / 0.9e1 * t359 * t178 + 0.5e1 / 0.3e1 * t47 * t184)
  t366 = t358 + t365
  t371 = params.lm_f ** 2
  t372 = t2 * t371
  t374 = t60 ** 2
  t375 = t89 * t374
  t378 = 0.1e1 / t85 / t99 * t68
  t383 = t54 * t55
  t391 = t9 ** 2
  t400 = s0 / t11 / t391
  t406 = s0 / t11 / t9 / r0
  t416 = jnp.sqrt(t56)
  t420 = t85 ** 2
  t433 = t60 * t74
  t438 = t326 * t68
  t439 = t60 * t101
  t447 = t350 * t68
  t449 = 0.1e1 / t72 / t85
  t454 = t85 * t16
  t457 = 0.1e1 / t332 / t454 * t68
  t474 = f.my_piecewise3(t20, 0, -0.10e2 / 0.27e2 / t24 * t158 + 0.10e2 / 0.3e1 * t352 * t156 * t166 + 0.5e1 / 0.3e1 * t44 * t171)
  t484 = f.my_piecewise3(t34, 0, -0.10e2 / 0.27e2 / t36 * t179 + 0.10e2 / 0.3e1 * t359 * t177 * t184 + 0.5e1 / 0.3e1 * t47 * t187)
  t493 = t54 * t372
  t499 = 0.21e2 / 0.4e1 * t326 * t55 * t329 * t335 * t343 - 0.7e1 / 0.2e1 * t351 * t329 * t335 * t366 - 0.49e2 / 0.12e2 * t350 * t372 * t375 * t378 * t342 + 0.13489e5 / 0.108e3 * t383 * t329 / t332 / t85 / t70 * t68 - 0.7e1 / 0.36e2 * t8 * (-0.1232e4 / 0.27e2 * s0 / t11 / t391 / r0 * t25 + 0.88e2 / 0.3e1 * t400 * t257 - 0.8e1 * t406 * t221 + t14 * t175 + t32 * t191) + 0.343e3 / 0.36e2 * t54 * t371 * params.lm_f / t416 * t61 * t374 / t63 / t420 / t16 * t68 - 0.15e2 / 0.4e1 / t51 / t323 / t50 * t53 * t68 * t433 * t343 * t342 - 0.12e2 * t438 * t439 * t343 + 0.9e1 / 0.2e1 * t438 * t433 * t342 * t366 - 0.88e2 / 0.3e1 * t447 * t60 * t449 * t342 + 0.105e3 / 0.4e1 * t351 * t329 * t457 * t342 + 0.8e1 * t447 * t439 * t366 - t447 * t433 * (t474 + t484) - 0.2464e4 / 0.27e2 * t54 * t69 / t72 / t454 - 0.1421e4 / 0.36e2 * t493 * t375 / t420 * t68
  t535 = t7 * (-0.7e1 / 0.36e2 * t8 * (0.88e2 / 0.9e1 * t400 * t25 - 0.16e2 / 0.3e1 * t406 * t257 + t14 * t221 + t32 * t227) + 0.3e1 / 0.2e1 * t438 * t433 * t343 - 0.7e1 / 0.3e1 * t351 * t329 * t335 * t342 + 0.16e2 / 0.3e1 * t447 * t439 * t342 - t447 * t433 * t366 - 0.35e2 / 0.2e1 * t383 * t329 * t457 + 0.49e2 / 0.18e2 * t493 * t375 * t378 + 0.176e3 / 0.9e1 * t54 * t69 * t449)
  t555 = t7 * (-0.7e1 / 0.36e2 * t8 * (-0.8e1 / 0.3e1 * t406 * t25 + t14 * t257 + t32 * t260) - t447 * t433 * t342 + 0.7e1 / 0.3e1 * t383 * t329 * t335 - 0.16e2 / 0.3e1 * t54 * t69 * t101)
  t562 = t98 - t108 - t121 - t130 - t138 - t145 - 0.20740740740740740740740740740740740740740740740741e-4 * t148 + 0.10888888888888888888888888888888888888888888888889e-3 * t152 + (t175 + t191) * t195 * t214 + 0.3e1 * t229 * t252 + 0.3e1 * t262 * t295 + t299 * t321 + t3 * t7 * t499 * t71 / 0.144e3 + t3 * t535 * t204 / 0.144e3 - t3 * t555 * t81 / 0.216e3 + 0.5e1 / 0.1944e4 * t3 * t79 * t74
  d111 = -t3 * t79 * t81 / 0.216e3 + t16 * t562 + t3 * t535 * t71 / 0.48e2 + t3 * t555 * t204 / 0.72e2 + 0.23333333333333333333333333333333333333333333333334e-4 * t281 - 0.14000000000000000000000000000000000000000000000000e-3 * t283 + 0.14000000000000000000000000000000000000000000000000e-4 * t287 + 0.16800000000000000000000000000000000000000000000000e0 * t290 + 0.25200000000000000000000000000000000000000000000000e1 * t293 - 0.42000000000000000000000000000000000000000000000000e-5 * t285 + 0.3e1 * t229 * t214 + 0.6e1 * t262 * t252 + 0.3e1 * t299 * t295

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi * t3
  t5 = jnp.pi ** 2
  t6 = t5 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t6 / t5
  t9 = 2 ** (0.1e1 / 0.3e1)
  t10 = r0 ** 2
  t11 = t10 ** 2
  t12 = r0 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t16 = s0 / t13 / t11
  t17 = r0 - r1
  t18 = 0.1e1 / t1
  t19 = t17 * t18
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 * f.p.zeta_threshold
  t24 = t20 ** (0.1e1 / 0.3e1)
  t25 = t24 * t20
  t26 = f.my_piecewise3(t21, t23, t25)
  t32 = s0 / t13 / t10 / r0
  t33 = t1 ** 2
  t34 = 0.1e1 / t33
  t36 = -t17 * t34 + t18
  t39 = f.my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t36)
  t44 = s0 / t13 / t10
  t45 = t24 ** 2
  t46 = 0.1e1 / t45
  t47 = t36 ** 2
  t50 = t33 * t1
  t51 = 0.1e1 / t50
  t54 = 0.2e1 * t17 * t51 - 0.2e1 * t34
  t58 = f.my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t46 * t47 + 0.4e1 / 0.3e1 * t24 * t54)
  t60 = r1 ** 2
  t61 = r1 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t65 = s2 / t62 / t60
  t66 = 0.1e1 - t19
  t67 = t66 <= f.p.zeta_threshold
  t68 = t66 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = -t36
  t72 = t71 ** 2
  t75 = -t54
  t79 = f.my_piecewise3(t67, 0, 0.4e1 / 0.9e1 * t70 * t72 + 0.4e1 / 0.3e1 * t68 * t75)
  t84 = t22 ** 2
  t85 = t84 * f.p.zeta_threshold
  t86 = t45 * t20
  t87 = f.my_piecewise3(t21, t85, t86)
  t88 = t69 * t66
  t89 = f.my_piecewise3(t67, t85, t88)
  t90 = t87 + t89
  t91 = t90 ** 2
  t92 = jnp.sqrt(t90)
  t95 = jnp.sqrt(0.2e1)
  t96 = 0.1e1 / t92 / t91 * t95
  t97 = t2 * params.lm_f
  t98 = 0.1e1 / jnp.pi
  t99 = t98 ** (0.1e1 / 0.6e1)
  t100 = 0.1e1 / t99
  t102 = s0 + 0.2e1 * s1 + s2
  t103 = jnp.sqrt(t102)
  t105 = t1 ** (0.1e1 / 0.6e1)
  t110 = jnp.exp(-t97 * t100 * t103 / t105 / t1)
  t111 = t96 * t110
  t112 = t1 ** (0.1e1 / 0.3e1)
  t113 = t112 ** 2
  t115 = 0.1e1 / t113 / t33
  t116 = t102 * t115
  t119 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t45 * t36)
  t122 = f.my_piecewise3(t67, 0, 0.5e1 / 0.3e1 * t69 * t71)
  t123 = t119 + t122
  t124 = t123 ** 2
  t130 = 0.1e1 / t92 / t90 * t95
  t131 = t130 * t97
  t132 = t103 * t102
  t133 = t100 * t132
  t134 = t33 ** 2
  t135 = t105 ** 2
  t136 = t135 ** 2
  t137 = t136 * t105
  t139 = 0.1e1 / t137 / t134
  t140 = t139 * t110
  t145 = t130 * t110
  t147 = 0.1e1 / t113 / t50
  t148 = t102 * t147
  t152 = 0.1e1 / t24
  t158 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t152 * t47 + 0.5e1 / 0.3e1 * t45 * t54)
  t159 = 0.1e1 / t68
  t165 = f.my_piecewise3(t67, 0, 0.10e2 / 0.9e1 * t159 * t72 + 0.5e1 / 0.3e1 * t69 * t75)
  t166 = t158 + t165
  t170 = 0.1e1 / t92 * t95
  t171 = t170 * t97
  t172 = t134 * t1
  t175 = 0.1e1 / t137 / t172 * t110
  t179 = params.lm_f ** 2
  t180 = t3 * t179
  t181 = t170 * t180
  t182 = t98 ** (0.1e1 / 0.3e1)
  t183 = 0.1e1 / t182
  t184 = t102 ** 2
  t185 = t183 * t184
  t186 = t134 * t50
  t188 = 0.1e1 / t186 * t110
  t192 = t110 * t102
  t194 = 0.1e1 / t113 / t134
  t199 = t8 * (-0.7e1 / 0.36e2 * t9 * (0.88e2 / 0.9e1 * t16 * t26 - 0.16e2 / 0.3e1 * t32 * t39 + t44 * t58 + t65 * t79) + 0.3e1 / 0.2e1 * t111 * t116 * t124 - 0.7e1 / 0.3e1 * t131 * t133 * t140 * t123 + 0.16e2 / 0.3e1 * t145 * t148 * t123 - t145 * t116 * t166 - 0.35e2 / 0.2e1 * t171 * t133 * t175 + 0.49e2 / 0.18e2 * t181 * t185 * t188 + 0.176e3 / 0.9e1 * t170 * t192 * t194)
  t201 = 0.1e1 / t113 / t1
  t210 = f.my_piecewise3(t67, 0, 0.4e1 / 0.3e1 * t68 * t71)
  t224 = t8 * (-0.7e1 / 0.36e2 * t9 * (-0.8e1 / 0.3e1 * t32 * t26 + t44 * t39 + t65 * t210) - t145 * t116 * t123 + 0.7e1 / 0.3e1 * t171 * t133 * t140 - 0.16e2 / 0.3e1 * t170 * t192 * t147)
  t229 = t68 * t66
  t230 = f.my_piecewise3(t67, t23, t229)
  t239 = t8 * (-0.7e1 / 0.36e2 * t9 * (t65 * t230 + t44 * t26) + 0.2e1 * t170 * t192 * t115)
  t243 = t96 * t97
  t252 = t130 * t180
  t257 = t134 * t33
  t260 = 0.1e1 / t137 / t257 * t110
  t267 = s0 / t13 / t11 / r0
  t274 = 0.1e1 / t86
  t275 = t47 * t36
  t278 = t46 * t36
  t281 = 0.1e1 / t134
  t284 = -0.6e1 * t17 * t281 + 0.6e1 * t51
  t288 = f.my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t274 * t275 + 0.4e1 / 0.3e1 * t278 * t54 + 0.4e1 / 0.3e1 * t24 * t284)
  t290 = 0.1e1 / t88
  t291 = t72 * t71
  t294 = t70 * t71
  t297 = -t284
  t301 = f.my_piecewise3(t67, 0, -0.8e1 / 0.27e2 * t290 * t291 + 0.4e1 / 0.3e1 * t294 * t75 + 0.4e1 / 0.3e1 * t68 * t297)
  t306 = t179 * params.lm_f
  t307 = t170 * t306
  t308 = jnp.sqrt(t98)
  t309 = 0.1e1 / t308
  t310 = t103 * t184
  t311 = t309 * t310
  t312 = t134 ** 2
  t313 = t312 * t1
  t315 = 0.1e1 / t105 / t313
  t323 = 0.1e1 / t92 / t91 / t90 * t95
  t324 = t323 * t110
  t325 = t124 * t123
  t332 = t123 * t166
  t336 = t102 * t194
  t347 = 0.1e1 / t25
  t350 = t152 * t36
  t356 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t347 * t275 + 0.10e2 / 0.3e1 * t350 * t54 + 0.5e1 / 0.3e1 * t45 * t284)
  t357 = 0.1e1 / t229
  t360 = t159 * t71
  t366 = f.my_piecewise3(t67, 0, -0.10e2 / 0.27e2 * t357 * t291 + 0.10e2 / 0.3e1 * t360 * t75 + 0.5e1 / 0.3e1 * t69 * t297)
  t367 = t356 + t366
  t371 = 0.1e1 / t113 / t172
  t376 = 0.1e1 / t312 * t110
  t380 = 0.21e2 / 0.4e1 * t243 * t133 * t140 * t124 - 0.7e1 / 0.2e1 * t131 * t133 * t140 * t166 - 0.49e2 / 0.12e2 * t252 * t185 * t188 * t123 + 0.13489e5 / 0.108e3 * t171 * t133 * t260 - 0.7e1 / 0.36e2 * t9 * (-0.1232e4 / 0.27e2 * t267 * t26 + 0.88e2 / 0.3e1 * t16 * t39 - 0.8e1 * t32 * t58 + t44 * t288 + t65 * t301) + 0.343e3 / 0.36e2 * t307 * t311 * t315 * t110 - 0.15e2 / 0.4e1 * t324 * t116 * t325 - 0.12e2 * t111 * t148 * t124 + 0.9e1 / 0.2e1 * t111 * t116 * t332 - 0.88e2 / 0.3e1 * t145 * t336 * t123 + 0.105e3 / 0.4e1 * t131 * t133 * t175 * t123 + 0.8e1 * t145 * t148 * t166 - t145 * t116 * t367 - 0.2464e4 / 0.27e2 * t170 * t192 * t371 - 0.1421e4 / 0.36e2 * t181 * t185 * t376
  t381 = t8 * t380
  t382 = 0.1e1 / t113
  t387 = 4 ** (0.1e1 / 0.3e1)
  t389 = t3 * t183 * t387 * t112
  t391 = 0.1e1 + 0.10e2 * t389
  t392 = t391 ** 2
  t394 = 0.1e1 / t392 / t391
  t396 = 0.74666666666666666666666666666666666666666666666666e-2 * t281 * t394
  t400 = 0.1e1 / (0.2e1 * t9 - 0.2e1)
  t401 = (t26 + t230 - 0.2e1) * t400
  t402 = 0.1e1 / t172
  t403 = t98 * t402
  t405 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e2 * t389
  t406 = jnp.log(t405)
  t409 = t98 * t18
  t411 = 0.1e1 + 0.17777777777777777777777777777777777777777777777778e-5 * t409
  t412 = t411 * jnp.pi
  t413 = t405 ** 2
  t415 = 0.1e1 / t413 / t405
  t421 = t182 ** 2
  t422 = t3 * t421
  t424 = t422 * t387 * t194
  t426 = t2 * t182
  t427 = t387 ** 2
  t429 = 0.1e1 / t112 / t134
  t431 = t426 * t427 * t429
  t434 = t411 * t3 * t183
  t435 = t387 * t147
  t436 = 0.1e1 / t405
  t441 = t413 ** 2
  t444 = t183 * t387
  t449 = 0.1e1 + t409 / 0.36000e5
  t450 = t449 * jnp.pi
  t452 = t392 ** 2
  t457 = 0.67200000000000000000000000000000000000000000000000e3 * t450 * t115 / t452 * t3 * t444
  t459 = t449 * t3 * t183
  t460 = 0.1e1 / t391
  t463 = 0.24888888888888888888888888888888888888888888888889e0 * t459 * t435 * t460
  t465 = t98 * t194 * t3
  t466 = t444 * t436
  t470 = t98 * t429 * t2
  t471 = 0.1e1 / t421
  t472 = t471 * t427
  t473 = 0.1e1 / t413
  t474 = t472 * t473
  t477 = jnp.log(t391)
  t479 = 0.16800000000000000000000000000000000000000000000000e-4 * t403 * t477
  t482 = 0.26880000000000000000000000000000000000000000000000e3 * t450 * t51 * t394
  t484 = t411 * t2 * t471
  t486 = 0.1e1 / t112 / t50
  t487 = t427 * t486
  t491 = t444 * t460
  t493 = 0.85037037037037037037037037037037037037037037037035e-4 * t465 * t491
  t494 = 0.1e1 / t392
  t495 = t472 * t494
  t497 = 0.46666666666666666666666666666666666666666666666666e-3 * t470 * t495
  t499 = t449 * t2 * t471
  t502 = 0.48533333333333333333333333333333333333333333333333e1 * t499 * t487 * t494
  t503 = -0.54186666666666666666666666666666666666666666666668e-6 * t403 * t406 + 0.21166666666666666666666666666666666666666666666666e4 * t412 * t51 * t415 + 0.37629629629629629629629629629629629629629629629629e-2 * t281 * t415 - t396 - 0.69917146776406035665294924554183813443072702331962e-4 * t424 + 0.28979423868312757201646090534979423868312757201647e-3 * t431 + 0.31358024691358024691358024691358024691358024691357e0 * t434 * t435 * t436 + 0.13229166666666666666666666666666666666666666666666e5 * t412 * t115 / t441 * t3 * t444 - t457 - t463 + 0.68569547325102880658436213991769547325102880658433e-5 * t465 * t466 + 0.94074074074074074074074074074074074074074074074072e-4 * t470 * t474 + t479 - t482 + 0.15287037037037037037037037037037037037037037037037e2 * t484 * t487 * t473 - t493 - t497 - t502
  t506 = (t39 + t210) * t400
  t507 = t98 * t281
  t511 = t98 * t147 * t3
  t515 = t98 * t486 * t2
  t518 = t387 * t115
  t524 = t427 / t112 / t33
  t531 = t422 * t435
  t533 = t426 * t487
  t535 = t507 * t477
  t537 = t511 * t491
  t539 = t515 * t495
  t542 = t459 * t518 * t460
  t545 = t499 * t524 * t494
  t548 = t450 * t34 * t394
  t550 = 0.13546666666666666666666666666666666666666666666667e-6 * t507 * t406 - 0.15051851851851851851851851851851851851851851851851e-5 * t511 * t466 - 0.14111111111111111111111111111111111111111111111111e-4 * t515 * t474 - 0.11759259259259259259259259259259259259259259259259e0 * t434 * t518 * t436 - 0.52916666666666666666666666666666666666666666666664e1 * t484 * t524 * t473 - 0.52916666666666666666666666666666666666666666666664e3 * t412 * t34 * t415 + 0.19068312757201646090534979423868312757201646090535e-4 * t531 - 0.86938271604938271604938271604938271604938271604940e-4 * t533 - 0.42000000000000000000000000000000000000000000000000e-5 * t535 + 0.18666666666666666666666666666666666666666666666666e-4 * t537 + 0.69999999999999999999999999999999999999999999999999e-4 * t539 + 0.93333333333333333333333333333333333333333333333334e-1 * t542 + 0.16800000000000000000000000000000000000000000000000e1 * t545 + 0.67200000000000000000000000000000000000000000000000e2 * t548
  t554 = (t288 + t301) * t400
  t555 = t98 * t34
  t558 = t387 * t382
  t562 = t387 * t201
  t567 = t427 / t112 / t1
  t575 = 0.22577777777777777777777777777777777777777777777778e-7 * t555 * t406 - 0.10583333333333333333333333333333333333333333333333e0 * t434 * t558 * t436 + 0.42903703703703703703703703703703703703703703703704e-5 * t422 * t562 - 0.27944444444444444444444444444444444444444444444445e-4 * t426 * t567 - 0.70000000000000000000000000000000000000000000000000e-6 * t555 * t477 + 0.84000000000000000000000000000000000000000000000000e-1 * t459 * t558 * t460
  t579 = (t58 + t79) * t400
  t580 = t98 * t51
  t584 = t98 * t115 * t3
  t607 = -0.45155555555555555555555555555555555555555555555556e-7 * t580 * t406 + 0.37629629629629629629629629629629629629629629629629e-6 * t584 * t466 + 0.70555555555555555555555555555555555555555555555553e-1 * t434 * t562 * t436 + 0.26458333333333333333333333333333333333333333333332e1 * t484 * t567 * t473 - 0.71506172839506172839506172839506172839506172839507e-5 * t422 * t518 + 0.37259259259259259259259259259259259259259259259260e-4 * t426 * t524 + 0.14000000000000000000000000000000000000000000000000e-5 * t580 * t477 - 0.46666666666666666666666666666666666666666666666666e-5 * t584 * t491 - 0.56000000000000000000000000000000000000000000000000e-1 * t459 * t562 * t460 - 0.84000000000000000000000000000000000000000000000000e0 * t499 * t567 * t494
  t610 = t20 ** 2
  t613 = t47 ** 2
  t619 = t54 ** 2
  t626 = 0.24e2 * t17 * t402 - 0.24e2 * t281
  t630 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t45 / t610 * t613 - 0.16e2 / 0.9e1 * t274 * t47 * t54 + 0.4e1 / 0.3e1 * t46 * t619 + 0.16e2 / 0.9e1 * t278 * t284 + 0.4e1 / 0.3e1 * t24 * t626)
  t631 = t66 ** 2
  t634 = t72 ** 2
  t640 = t75 ** 2
  t645 = -t626
  t649 = f.my_piecewise3(t67, 0, 0.40e2 / 0.81e2 / t69 / t631 * t634 - 0.16e2 / 0.9e1 * t290 * t72 * t75 + 0.4e1 / 0.3e1 * t70 * t640 + 0.16e2 / 0.9e1 * t294 * t297 + 0.4e1 / 0.3e1 * t68 * t645)
  t662 = -0.127e-1 * t411 * t406 - 0.64355555555555555555555555555555555555555555555556e-5 * t422 * t558 + 0.83833333333333333333333333333333333333333333333334e-4 * t426 * t427 / t112 - 0.41666666666666666666666666666666666666666666666667e-2 + 0.252e-1 * t449 * t477
  t686 = t179 ** 2
  t707 = t110 * t123
  t754 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t24 / t610 * t613 - 0.20e2 / 0.9e1 * t347 * t47 * t54 + 0.10e2 / 0.3e1 * t152 * t619 + 0.40e2 / 0.9e1 * t350 * t284 + 0.5e1 / 0.3e1 * t45 * t626)
  t769 = f.my_piecewise3(t67, 0, 0.40e2 / 0.81e2 / t68 / t631 * t634 - 0.20e2 / 0.9e1 * t357 * t72 * t75 + 0.10e2 / 0.3e1 * t159 * t640 + 0.40e2 / 0.9e1 * t360 * t297 + 0.5e1 / 0.3e1 * t69 * t645)
  t773 = -0.7e1 / 0.36e2 * t9 * (0.20944e5 / 0.81e2 * s0 / t13 / t11 / t10 * t26 - 0.4928e4 / 0.27e2 * t267 * t39 + 0.176e3 / 0.3e1 * t16 * t58 - 0.32e2 / 0.3e1 * t32 * t288 + t44 * t630 + t65 * t649) + 0.299047e6 / 0.648e3 * t181 * t185 / t313 * t110 + 0.2401e4 / 0.216e3 * t170 * t686 * t471 * t184 * t102 / t112 / t312 / t50 * t2 * t110 - 0.207347e6 / 0.216e3 * t171 * t133 / t137 / t186 * t110 - 0.343e3 / 0.18e2 * t130 * t306 * t309 * t310 * t315 * t707 + 0.41888e5 / 0.81e2 * t170 * t192 / t113 / t257 + 0.6e1 * t111 * t116 * t123 * t367 - 0.24353e5 / 0.108e3 * t307 * t311 / t105 / t312 / t33 * t110 - 0.45e2 / 0.2e1 * t324 * t116 * t124 * t166 - 0.48e2 * t111 * t148 * t332 - 0.176e3 / 0.3e1 * t145 * t336 * t166 + 0.32e2 / 0.3e1 * t145 * t148 * t367 - t145 * t116 * (t754 + t769)
  t774 = t91 ** 2
  t779 = t124 ** 2
  t789 = t166 ** 2
  t838 = 0.105e3 / 0.8e1 / t92 / t774 * t95 * t110 * t116 * t779 + 0.40e2 * t324 * t148 * t325 + 0.88e2 * t111 * t336 * t124 + 0.9e1 / 0.2e1 * t111 * t116 * t789 + 0.4928e4 / 0.27e2 * t145 * t102 * t371 * t123 + 0.21e2 * t96 * t97 * t100 * t132 * t139 * t707 * t166 + 0.105e3 / 0.2e1 * t131 * t133 * t175 * t166 + 0.1421e4 / 0.18e2 * t252 * t185 * t376 * t123 - 0.35e2 / 0.2e1 * t323 * t97 * t133 * t140 * t325 - 0.315e3 / 0.4e1 * t243 * t133 * t175 * t124 - 0.13489e5 / 0.54e2 * t131 * t133 * t260 * t123 + 0.49e2 / 0.4e1 * t96 * t180 * t185 * t188 * t124 - 0.14e2 / 0.3e1 * t131 * t133 * t140 * t367 - 0.49e2 / 0.6e1 * t252 * t185 * t188 * t166
  t846 = -t4 * t199 * t201 / 0.108e3 + 0.5e1 / 0.486e3 * t4 * t224 * t115 - 0.5e1 / 0.729e3 * t4 * t239 * t147 + t4 * t381 * t382 / 0.108e3 + t396 + t401 * t503 + 0.4e1 * t506 * t550 + 0.4e1 * t554 * t575 + 0.6e1 * t579 * t607 + (t630 + t649) * t400 * t662 + t4 * t8 * (t773 + t838) * t112 / 0.144e3 + 0.76049382716049382716049382716049382716049382716050e-4 * t424 - 0.36296296296296296296296296296296296296296296296297e-3 * t431 + t457 + t463 - t479 + t482 + t493 + t497 + t502
  d1111 = t1 * t846 + 0.4e1 * t401 * t550 + 0.12e2 * t506 * t607 + t4 * t381 * t112 / 0.36e2 + t4 * t199 * t382 / 0.36e2 - t4 * t224 * t201 / 0.54e2 + 0.5e1 / 0.486e3 * t4 * t239 * t115 - 0.26880000000000000000000000000000000000000000000000e3 * t548 - 0.82962962962962962962962962962962962962962962962965e-4 * t531 + 0.43555555555555555555555555555555555555555555555556e-3 * t533 + 0.4e1 * t554 * t662 + 0.16800000000000000000000000000000000000000000000000e-4 * t535 + 0.12e2 * t579 * t575 - 0.74666666666666666666666666666666666666666666666666e-4 * t537 - 0.28000000000000000000000000000000000000000000000000e-3 * t539 - 0.37333333333333333333333333333333333333333333333333e0 * t542 - 0.67200000000000000000000000000000000000000000000000e1 * t545

  res = {'v4rho4': d1111}
  return res
