"""Generated from gga_c_sogga11.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_sogga11_a_raw = params.sogga11_a
  if isinstance(params_sogga11_a_raw, (str, bytes, dict)):
    params_sogga11_a = params_sogga11_a_raw
  else:
    try:
      params_sogga11_a_seq = list(params_sogga11_a_raw)
    except TypeError:
      params_sogga11_a = params_sogga11_a_raw
    else:
      params_sogga11_a_seq = np.asarray(params_sogga11_a_seq, dtype=np.float64)
      params_sogga11_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_a_seq))
  params_sogga11_b_raw = params.sogga11_b
  if isinstance(params_sogga11_b_raw, (str, bytes, dict)):
    params_sogga11_b = params_sogga11_b_raw
  else:
    try:
      params_sogga11_b_seq = list(params_sogga11_b_raw)
    except TypeError:
      params_sogga11_b = params_sogga11_b_raw
    else:
      params_sogga11_b_seq = np.asarray(params_sogga11_b_seq, dtype=np.float64)
      params_sogga11_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_b_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = 15.75592 * 0.004235

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  malpha = mbeta / (16 * 2 ** (2 / 3))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  sogga11_yy = lambda rs, z, xt: -malpha * f.mphi(z) * xt ** 2 / (rs * f_pw(rs, z))

  sogga11_f0 = lambda rs, z, xt: 1 - 1 / (1 + sogga11_yy(rs, z, xt))

  sogga11_f1 = lambda rs, z, xt: 1 - jnp.exp(-sogga11_yy(rs, z, xt))

  sogga11_t0 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_a[i] * sogga11_f0(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_t1 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_b[i] * sogga11_f1(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_f = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) * (sogga11_t0(rs, z, xt) + sogga11_t1(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: sogga11_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_sogga11_a_raw = params.sogga11_a
  if isinstance(params_sogga11_a_raw, (str, bytes, dict)):
    params_sogga11_a = params_sogga11_a_raw
  else:
    try:
      params_sogga11_a_seq = list(params_sogga11_a_raw)
    except TypeError:
      params_sogga11_a = params_sogga11_a_raw
    else:
      params_sogga11_a_seq = np.asarray(params_sogga11_a_seq, dtype=np.float64)
      params_sogga11_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_a_seq))
  params_sogga11_b_raw = params.sogga11_b
  if isinstance(params_sogga11_b_raw, (str, bytes, dict)):
    params_sogga11_b = params_sogga11_b_raw
  else:
    try:
      params_sogga11_b_seq = list(params_sogga11_b_raw)
    except TypeError:
      params_sogga11_b = params_sogga11_b_raw
    else:
      params_sogga11_b_seq = np.asarray(params_sogga11_b_seq, dtype=np.float64)
      params_sogga11_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_b_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = 15.75592 * 0.004235

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  malpha = mbeta / (16 * 2 ** (2 / 3))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  sogga11_yy = lambda rs, z, xt: -malpha * f.mphi(z) * xt ** 2 / (rs * f_pw(rs, z))

  sogga11_f0 = lambda rs, z, xt: 1 - 1 / (1 + sogga11_yy(rs, z, xt))

  sogga11_f1 = lambda rs, z, xt: 1 - jnp.exp(-sogga11_yy(rs, z, xt))

  sogga11_t0 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_a[i] * sogga11_f0(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_t1 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_b[i] * sogga11_f1(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_f = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) * (sogga11_t0(rs, z, xt) + sogga11_t1(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: sogga11_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_sogga11_a_raw = params.sogga11_a
  if isinstance(params_sogga11_a_raw, (str, bytes, dict)):
    params_sogga11_a = params_sogga11_a_raw
  else:
    try:
      params_sogga11_a_seq = list(params_sogga11_a_raw)
    except TypeError:
      params_sogga11_a = params_sogga11_a_raw
    else:
      params_sogga11_a_seq = np.asarray(params_sogga11_a_seq, dtype=np.float64)
      params_sogga11_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_a_seq))
  params_sogga11_b_raw = params.sogga11_b
  if isinstance(params_sogga11_b_raw, (str, bytes, dict)):
    params_sogga11_b = params_sogga11_b_raw
  else:
    try:
      params_sogga11_b_seq = list(params_sogga11_b_raw)
    except TypeError:
      params_sogga11_b = params_sogga11_b_raw
    else:
      params_sogga11_b_seq = np.asarray(params_sogga11_b_seq, dtype=np.float64)
      params_sogga11_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_b_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = 15.75592 * 0.004235

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  malpha = mbeta / (16 * 2 ** (2 / 3))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  sogga11_yy = lambda rs, z, xt: -malpha * f.mphi(z) * xt ** 2 / (rs * f_pw(rs, z))

  sogga11_f0 = lambda rs, z, xt: 1 - 1 / (1 + sogga11_yy(rs, z, xt))

  sogga11_f1 = lambda rs, z, xt: 1 - jnp.exp(-sogga11_yy(rs, z, xt))

  sogga11_t0 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_a[i] * sogga11_f0(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_t1 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_b[i] * sogga11_f1(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_f = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) * (sogga11_t0(rs, z, xt) + sogga11_t1(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: sogga11_f(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t87 = -t31 + t38 * t83 + 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t89 = params.sogga11_a[1]
  t90 = t43 ** 2
  t91 = t45 ** 2
  t92 = f.my_piecewise3(t42, t90, t91)
  t93 = t50 ** 2
  t94 = f.my_piecewise3(t49, t90, t93)
  t96 = t92 / 0.2e1 + t94 / 0.2e1
  t97 = t54 * t96
  t99 = s0 + 0.2e1 * s1 + s2
  t101 = 0.1e1 / t8 / t35
  t102 = t99 * t101
  t103 = t97 * t102
  t104 = 0.1e1 / t3
  t105 = t19 * t104
  t106 = 0.1e1 / t87
  t107 = t5 * t106
  t108 = t105 * t107
  t110 = 0.69506584583333333333333333333333333333333333333333e-3 * t103 * t108
  t111 = 0.1e1 - t110
  t113 = 0.1e1 - 0.1e1 / t111
  t115 = params.sogga11_a[2]
  t116 = t113 ** 2
  t118 = params.sogga11_a[3]
  t119 = t116 * t113
  t121 = params.sogga11_a[4]
  t122 = t116 ** 2
  t124 = params.sogga11_a[5]
  t128 = params.sogga11_b[1]
  t129 = jnp.exp(t110)
  t130 = 0.1e1 - t129
  t132 = params.sogga11_b[2]
  t133 = t130 ** 2
  t135 = params.sogga11_b[3]
  t136 = t133 * t130
  t138 = params.sogga11_b[4]
  t139 = t133 ** 2
  t141 = params.sogga11_b[5]
  t144 = t124 * t122 * t113 + t141 * t139 * t130 + t89 * t113 + t115 * t116 + t118 * t119 + t121 * t122 + t128 * t130 + t132 * t133 + t135 * t136 + t138 * t139 + params.sogga11_a[0] + params.sogga11_b[0]
  t145 = t87 * t144
  t147 = 0.1e1 / t8 / t7
  t148 = t6 * t147
  t151 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t148 * t30
  t152 = t27 ** 2
  t157 = t3 * t6
  t158 = t157 * t147
  t159 = 0.1e1 / t14 * t1 * t158
  t161 = t4 * t148
  t163 = t11 ** 0.5e0
  t165 = t163 * t1 * t158
  t170 = t21 * t5 / t22 / t7
  t175 = t13 / t152 * (-0.39359271665000000000000000000000000000000000000000e-1 * t159 - 0.18590165886666666666666666666666666666666666666667e-1 * t161 - 0.63665980925000000000000000000000000000000000000000e-2 * t165 - 0.51086165526666666666666666666666666666666666666667e-2 * t170) / t29
  t179 = 0.4e1 * t33 * t32 * t37 * t83
  t184 = 0.4e1 * t34 / t36 / t7 * t83
  t186 = t32 / t35
  t187 = t39 - t186
  t190 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t187)
  t191 = -t187
  t194 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t191)
  t196 = (t190 + t194) * t57
  t202 = t65 ** 2
  t216 = t76 ** 2
  t217 = 0.1e1 / t216
  t223 = -0.29149603883333333333333333333333333333333333333333e-1 * t159 - 0.10197154565000000000000000000000000000000000000000e-1 * t161 - 0.18581078242500000000000000000000000000000000000000e-2 * t165 - 0.27959640330000000000000000000000000000000000000000e-2 * t170
  t224 = 0.1e1 / t78
  t230 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t148 * t68 + t60 / t202 * (-0.36580540352500000000000000000000000000000000000000e-1 * t159 - 0.16057569282500000000000000000000000000000000000000e-1 * t161 - 0.65410946462500000000000000000000000000000000000000e-2 * t165 - 0.32394954865000000000000000000000000000000000000000e-2 * t170) / t67 - t151 - t175 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t148 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t217 * t223 * t224)
  t237 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t157 * t147 * t79
  t242 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t217 * t223 * t224
  t243 = t151 + t175 + t179 - t184 + t38 * t196 * t82 + t230 + 0.58482236226346462072622386637590534819724553404281e0 * t196 * t80 - t237 - t242
  t246 = t7 * t87
  t247 = t111 ** 2
  t248 = 0.1e1 / t247
  t249 = t89 * t248
  t250 = 0.1e1 / t45
  t253 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t250 * t187)
  t254 = 0.1e1 / t50
  t257 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t254 * t191)
  t270 = 0.16218203069444444444444444444444444444444444444444e-2 * t97 * t99 / t8 / t35 / t7 * t108
  t271 = t87 ** 2
  t273 = t5 / t271
  t278 = -0.69506584583333333333333333333333333333333333333333e-3 * t54 * (t253 / 0.2e1 + t257 / 0.2e1) * t102 * t108 + t270 + 0.69506584583333333333333333333333333333333333333333e-3 * t103 * t105 * t273 * t243
  t280 = t115 * t113
  t281 = t248 * t278
  t284 = t118 * t116
  t287 = t121 * t119
  t290 = t124 * t122
  t293 = -t278
  t296 = t132 * t130
  t297 = t293 * t129
  t300 = t135 * t133
  t303 = t138 * t136
  t306 = t141 * t139
  vrho_0_ = t145 + t7 * t243 * t144 + t246 * (-t128 * t293 * t129 + t249 * t278 + 0.2e1 * t280 * t281 + 0.3e1 * t284 * t281 + 0.4e1 * t287 * t281 + 0.5e1 * t290 * t281 - 0.2e1 * t296 * t297 - 0.3e1 * t300 * t297 - 0.4e1 * t303 * t297 - 0.5e1 * t306 * t297)
  t311 = -t39 - t186
  t314 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t311)
  t315 = -t311
  t318 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t315)
  t320 = (t314 + t318) * t57
  t325 = t151 + t175 - t179 - t184 + t38 * t320 * t82 + t230 + 0.58482236226346462072622386637590534819724553404281e0 * t320 * t80 - t237 - t242
  t330 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t250 * t311)
  t333 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t254 * t315)
  t344 = -0.69506584583333333333333333333333333333333333333333e-3 * t54 * (t330 / 0.2e1 + t333 / 0.2e1) * t102 * t108 + t270 + 0.69506584583333333333333333333333333333333333333333e-3 * t103 * t105 * t273 * t325
  t346 = t248 * t344
  t355 = -t344
  t358 = t355 * t129
  vrho_1_ = t145 + t7 * t325 * t144 + t246 * (-t128 * t355 * t129 + t249 * t344 + 0.2e1 * t280 * t346 + 0.3e1 * t284 * t346 + 0.4e1 * t287 * t346 + 0.5e1 * t290 * t346 - 0.2e1 * t296 * t358 - 0.3e1 * t300 * t358 - 0.4e1 * t303 * t358 - 0.5e1 * t306 * t358)
  t373 = t101 * t19 * t104 * t5 * t106
  t374 = t249 * t97 * t373
  t377 = t248 * t54 * t96
  t379 = t280 * t377 * t373
  t382 = t284 * t377 * t373
  t385 = t287 * t377 * t373
  t388 = t290 * t377 * t373
  t394 = t105 * t107 * t129
  t395 = t128 * t54 * t96 * t101 * t394
  t397 = t97 * t101
  t399 = t296 * t397 * t394
  t402 = t300 * t397 * t394
  t405 = t303 * t397 * t394
  t408 = t306 * t397 * t394
  vsigma_0_ = t246 * (-0.69506584583333333333333333333333333333333333333333e-3 * t374 - 0.13901316916666666666666666666666666666666666666667e-2 * t379 - 0.20851975375000000000000000000000000000000000000000e-2 * t382 - 0.27802633833333333333333333333333333333333333333333e-2 * t385 - 0.34753292291666666666666666666666666666666666666666e-2 * t388 - 0.69506584583333333333333333333333333333333333333333e-3 * t395 - 0.13901316916666666666666666666666666666666666666667e-2 * t399 - 0.20851975375000000000000000000000000000000000000000e-2 * t402 - 0.27802633833333333333333333333333333333333333333333e-2 * t405 - 0.34753292291666666666666666666666666666666666666666e-2 * t408)
  vsigma_1_ = t246 * (-0.13901316916666666666666666666666666666666666666667e-2 * t374 - 0.27802633833333333333333333333333333333333333333334e-2 * t379 - 0.41703950750000000000000000000000000000000000000001e-2 * t382 - 0.55605267666666666666666666666666666666666666666668e-2 * t385 - 0.69506584583333333333333333333333333333333333333335e-2 * t388 - 0.13901316916666666666666666666666666666666666666667e-2 * t395 - 0.27802633833333333333333333333333333333333333333334e-2 * t399 - 0.41703950750000000000000000000000000000000000000001e-2 * t402 - 0.55605267666666666666666666666666666666666666666668e-2 * t405 - 0.69506584583333333333333333333333333333333333333335e-2 * t408)
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_sogga11_a_raw = params.sogga11_a
  if isinstance(params_sogga11_a_raw, (str, bytes, dict)):
    params_sogga11_a = params_sogga11_a_raw
  else:
    try:
      params_sogga11_a_seq = list(params_sogga11_a_raw)
    except TypeError:
      params_sogga11_a = params_sogga11_a_raw
    else:
      params_sogga11_a_seq = np.asarray(params_sogga11_a_seq, dtype=np.float64)
      params_sogga11_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_a_seq))
  params_sogga11_b_raw = params.sogga11_b
  if isinstance(params_sogga11_b_raw, (str, bytes, dict)):
    params_sogga11_b = params_sogga11_b_raw
  else:
    try:
      params_sogga11_b_seq = list(params_sogga11_b_raw)
    except TypeError:
      params_sogga11_b = params_sogga11_b_raw
    else:
      params_sogga11_b_seq = np.asarray(params_sogga11_b_seq, dtype=np.float64)
      params_sogga11_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_sogga11_b_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = 15.75592 * 0.004235

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  malpha = mbeta / (16 * 2 ** (2 / 3))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  sogga11_yy = lambda rs, z, xt: -malpha * f.mphi(z) * xt ** 2 / (rs * f_pw(rs, z))

  sogga11_f0 = lambda rs, z, xt: 1 - 1 / (1 + sogga11_yy(rs, z, xt))

  sogga11_f1 = lambda rs, z, xt: 1 - jnp.exp(-sogga11_yy(rs, z, xt))

  sogga11_t0 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_a[i] * sogga11_f0(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_t1 = lambda rs, z, xt: jnp.sum(jnp.array([params_sogga11_b[i] * sogga11_f1(rs, z, xt) ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  sogga11_f = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) * (sogga11_t0(rs, z, xt) + sogga11_t1(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: sogga11_f(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t55 = -t12 * t29 + 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t57 = params.sogga11_a[1]
  t58 = t32 ** 2
  t59 = f.my_piecewise3(t31, t58, 1)
  t60 = t37 * t59
  t61 = r0 ** 2
  t63 = 0.1e1 / t7 / t61
  t65 = t60 * s0 * t63
  t66 = 0.1e1 / t3
  t67 = t18 * t66
  t68 = 0.1e1 / t55
  t69 = t5 * t68
  t70 = t67 * t69
  t72 = 0.69506584583333333333333333333333333333333333333333e-3 * t65 * t70
  t73 = 0.1e1 - t72
  t75 = 0.1e1 - 0.1e1 / t73
  t77 = params.sogga11_a[2]
  t78 = t75 ** 2
  t80 = params.sogga11_a[3]
  t81 = t78 * t75
  t83 = params.sogga11_a[4]
  t84 = t78 ** 2
  t86 = params.sogga11_a[5]
  t90 = params.sogga11_b[1]
  t91 = jnp.exp(t72)
  t92 = 0.1e1 - t91
  t94 = params.sogga11_b[2]
  t95 = t92 ** 2
  t97 = params.sogga11_b[3]
  t98 = t95 * t92
  t100 = params.sogga11_b[4]
  t101 = t95 ** 2
  t103 = params.sogga11_b[5]
  t106 = t103 * t101 * t92 + t86 * t84 * t75 + t100 * t101 + t57 * t75 + t77 * t78 + t80 * t81 + t83 * t84 + t90 * t92 + t94 * t95 + t97 * t98 + params.sogga11_a[0] + params.sogga11_b[0]
  t109 = 0.1e1 / t7 / r0
  t110 = t6 * t109
  t114 = t26 ** 2
  t119 = t3 * t6
  t120 = t119 * t109
  t121 = 0.1e1 / t13 * t1 * t120
  t123 = t4 * t110
  t125 = t10 ** 0.5e0
  t127 = t125 * t1 * t120
  t132 = t20 * t5 / t21 / r0
  t144 = t48 ** 2
  t156 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t110 * t29 + t12 / t114 * (-0.39359271665000000000000000000000000000000000000000e-1 * t121 - 0.18590165886666666666666666666666666666666666666667e-1 * t123 - 0.63665980925000000000000000000000000000000000000000e-2 * t127 - 0.51086165526666666666666666666666666666666666666667e-2 * t132) / t28 - 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t119 * t109 * t51 - 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t144 * (-0.29149603883333333333333333333333333333333333333333e-1 * t121 - 0.10197154565000000000000000000000000000000000000000e-1 * t123 - 0.18581078242500000000000000000000000000000000000000e-2 * t127 - 0.27959640330000000000000000000000000000000000000000e-2 * t132) / t50
  t159 = r0 * t55
  t160 = t73 ** 2
  t161 = 0.1e1 / t160
  t162 = t57 * t161
  t170 = t55 ** 2
  t177 = 0.16218203069444444444444444444444444444444444444444e-2 * t60 * s0 / t7 / t61 / r0 * t70 + 0.69506584583333333333333333333333333333333333333333e-3 * t65 * t67 * t5 / t170 * t156
  t179 = t77 * t75
  t180 = t161 * t177
  t183 = t80 * t78
  t186 = t83 * t81
  t189 = t86 * t84
  t192 = -t177
  t195 = t94 * t92
  t196 = t192 * t91
  t199 = t97 * t95
  t202 = t100 * t98
  t205 = t103 * t101
  vrho_0_ = t55 * t106 + r0 * t156 * t106 + t159 * (-t90 * t192 * t91 + t162 * t177 + 0.2e1 * t179 * t180 + 0.3e1 * t183 * t180 + 0.4e1 * t186 * t180 + 0.5e1 * t189 * t180 - 0.2e1 * t195 * t196 - 0.3e1 * t199 * t196 - 0.4e1 * t202 * t196 - 0.5e1 * t205 * t196)
  t214 = t63 * t18 * t66 * t5 * t68
  t218 = t161 * t37 * t59
  t235 = t67 * t69 * t91
  t238 = t60 * t63
  vsigma_0_ = t159 * (-0.69506584583333333333333333333333333333333333333333e-3 * t162 * t60 * t214 - 0.13901316916666666666666666666666666666666666666667e-2 * t179 * t218 * t214 - 0.20851975375000000000000000000000000000000000000000e-2 * t183 * t218 * t214 - 0.27802633833333333333333333333333333333333333333333e-2 * t186 * t218 * t214 - 0.34753292291666666666666666666666666666666666666666e-2 * t189 * t218 * t214 - 0.69506584583333333333333333333333333333333333333333e-3 * t90 * t37 * t59 * t63 * t235 - 0.13901316916666666666666666666666666666666666666667e-2 * t195 * t238 * t235 - 0.20851975375000000000000000000000000000000000000000e-2 * t199 * t238 * t235 - 0.27802633833333333333333333333333333333333333333333e-2 * t202 * t238 * t235 - 0.34753292291666666666666666666666666666666666666666e-2 * t205 * t238 * t235)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t102 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t10 * t31 + 0.10000000000000000000000000000000000000000000000000e1 * t39 * t59 - 0.18311447306006545054854346104378990962041954983034e-3 * t73 * t42 * t9 * t82 - 0.58482236226346462072622386637590534819724553404280e0 * t89 * t99
  t104 = params.sogga11_a[1]
  t105 = t63 ** 2
  t106 = f.my_piecewise3(t62, t105, 1)
  t107 = t68 * t106
  t108 = r0 ** 2
  t110 = 0.1e1 / t7 / t108
  t112 = t107 * s0 * t110
  t113 = 0.1e1 / t3
  t114 = t19 * t113
  t120 = -0.621814e-1 * t36 * t31 + 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t121 = 0.1e1 / t120
  t122 = t5 * t121
  t123 = t114 * t122
  t125 = 0.69506584583333333333333333333333333333333333333332e-3 * t112 * t123
  t126 = 0.1e1 - t125
  t128 = 0.1e1 - 0.1e1 / t126
  t130 = params.sogga11_a[2]
  t131 = t128 ** 2
  t133 = params.sogga11_a[3]
  t134 = t131 * t128
  t136 = params.sogga11_a[4]
  t137 = t131 ** 2
  t139 = params.sogga11_a[5]
  t143 = params.sogga11_b[1]
  t144 = jnp.exp(t125)
  t145 = 0.1e1 - t144
  t147 = params.sogga11_b[2]
  t148 = t145 ** 2
  t150 = params.sogga11_b[3]
  t151 = t148 * t145
  t153 = params.sogga11_b[4]
  t154 = t148 ** 2
  t156 = params.sogga11_b[5]
  t159 = t139 * t137 * t128 + t156 * t154 * t145 + t104 * t128 + t130 * t131 + t133 * t134 + t136 * t137 + t143 * t145 + t147 * t148 + t150 * t151 + t153 * t154 + params.sogga11_a[0] + params.sogga11_b[0]
  t162 = t126 ** 2
  t163 = 0.1e1 / t162
  t164 = t104 * t163
  t167 = 0.1e1 / t7 / t108 / r0
  t169 = t107 * s0 * t167
  t172 = t120 ** 2
  t173 = 0.1e1 / t172
  t174 = t5 * t173
  t175 = t174 * t102
  t176 = t114 * t175
  t179 = 0.16218203069444444444444444444444444444444444444444e-2 * t169 * t123 + 0.69506584583333333333333333333333333333333333333332e-3 * t112 * t176
  t181 = t130 * t128
  t182 = t163 * t179
  t185 = t133 * t131
  t188 = t136 * t134
  t191 = t139 * t137
  t194 = -t179
  t197 = t147 * t145
  t198 = t194 * t144
  t201 = t150 * t148
  t204 = t153 * t151
  t207 = t156 * t154
  t210 = -t143 * t194 * t144 + t164 * t179 + 0.2e1 * t181 * t182 + 0.3e1 * t185 * t182 + 0.4e1 * t188 * t182 + 0.5e1 * t191 * t182 - 0.2e1 * t197 * t198 - 0.3e1 * t201 * t198 - 0.4e1 * t204 * t198 - 0.5e1 * t207 * t198
  t213 = t6 * t110
  t225 = t57 ** 2
  t234 = 0.1e1 / t22 / t108
  t235 = t20 * t5 * t234
  t236 = 0.1e1 / t14 / t13 * t19 * t235
  t238 = t42 * t110
  t239 = t41 * t238
  t241 = t4 * t213
  t243 = t13 ** (-0.5e0)
  t245 = t243 * t19 * t235
  t247 = t49 * t238
  t250 = t21 * t5 * t234
  t256 = t37 ** 2
  t259 = t30 ** 2
  t274 = t96 ** 2
  t290 = t90 ** 2
  t293 = t81 ** 2
  t298 = -0.14764627977777777777777777777777777777777777777777e-2 * t4 * t213 * t31 - 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t6 * t9 * t38 * t59 - 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t225 * t58 + 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t236 + 0.84396666666666666666666666666666666666666666666666e0 * t239 + 0.39862222222222222222222222222222222222222222222223e0 * t241 + 0.68258333333333333333333333333333333333333333333333e-1 * t245 + 0.13651666666666666666666666666666666666666666666667e0 * t247 + 0.13692777777777777777777777777777777777777777777778e0 * t250) * t58 + 0.16081979498692535066756296899072713062105388428051e2 * t36 / t256 * t225 / t259 + 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t110 * t82 + 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99 + 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t274 * t98 - 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t236 + 0.11507777777777777777777777777777777777777777777778e1 * t239 + 0.40256666666666666666666666666666666666666666666667e0 * t241 + 0.36677500000000000000000000000000000000000000000000e-1 * t245 + 0.73355000000000000000000000000000000000000000000000e-1 * t247 + 0.13797500000000000000000000000000000000000000000000e0 * t250) * t98 - 0.17315859105681463759666483083807725165579399831905e2 * t89 / t290 * t274 / t293
  t301 = r0 * t102
  t304 = r0 * t120
  t305 = t108 ** 2
  t317 = t102 ** 2
  t326 = -0.54060676898148148148148148148148148148148148148147e-2 * t107 * s0 / t7 / t305 * t123 - 0.32436406138888888888888888888888888888888888888888e-2 * t169 * t176 - 0.13901316916666666666666666666666666666666666666666e-2 * t112 * t114 * t5 / t172 / t120 * t317 + 0.69506584583333333333333333333333333333333333333332e-3 * t112 * t114 * t174 * t298
  t327 = t163 * t326
  t334 = t136 * t131
  t335 = t162 ** 2
  t336 = 0.1e1 / t335
  t337 = t179 ** 2
  t338 = t336 * t337
  t341 = t133 * t128
  t345 = 0.1e1 / t162 / t126
  t346 = t345 * t337
  t353 = t156 * t151
  t354 = t194 ** 2
  t355 = t144 ** 2
  t356 = t354 * t355
  t359 = t354 * t144
  t364 = -t326
  t365 = t364 * t144
  t372 = 0.2e1 * t181 * t327 - 0.4e1 * t181 * t346 + 0.3e1 * t185 * t327 - 0.6e1 * t185 * t346 + 0.4e1 * t188 * t327 - 0.8e1 * t188 * t346 - 0.2e1 * t197 * t359 - 0.3e1 * t201 * t359 - 0.3e1 * t201 * t365 - 0.4e1 * t204 * t359 - 0.5e1 * t207 * t359 + 0.12e2 * t334 * t338 + 0.6e1 * t341 * t338 + 0.20e2 * t353 * t356
  t373 = t139 * t134
  t376 = t150 * t145
  t383 = t153 * t148
  t393 = t130 * t336
  t396 = t104 * t345
  t406 = -t143 * t354 * t144 - t143 * t364 * t144 + 0.2e1 * t147 * t354 * t355 + t164 * t326 + 0.5e1 * t191 * t327 - 0.10e2 * t191 * t346 - 0.2e1 * t197 * t365 - 0.4e1 * t204 * t365 - 0.5e1 * t207 * t365 + 0.2e1 * t393 * t337 - 0.2e1 * t396 * t337 + 0.20e2 * t373 * t338 + 0.6e1 * t376 * t356 + 0.12e2 * t383 * t356
  v2rho2_0_ = 0.2e1 * t102 * t159 + 0.2e1 * t120 * t210 + r0 * t298 * t159 + 0.2e1 * t301 * t210 + t304 * (t372 + t406)
  t409 = t164 * t107
  t410 = t110 * t19
  t411 = t113 * t5
  t412 = t411 * t121
  t413 = t410 * t412
  t417 = t163 * t68 * t106
  t418 = t181 * t417
  t421 = t185 * t417
  t424 = t188 * t417
  t427 = t191 * t417
  t430 = t143 * t68
  t431 = t106 * t110
  t434 = t114 * t122 * t144
  t437 = t107 * t110
  t438 = t197 * t437
  t441 = t201 * t437
  t444 = t204 * t437
  t447 = t207 * t437
  t450 = -0.69506584583333333333333333333333333333333333333332e-3 * t409 * t413 - 0.13901316916666666666666666666666666666666666666666e-2 * t418 * t413 - 0.20851975375000000000000000000000000000000000000000e-2 * t421 * t413 - 0.27802633833333333333333333333333333333333333333333e-2 * t424 * t413 - 0.34753292291666666666666666666666666666666666666666e-2 * t427 * t413 - 0.69506584583333333333333333333333333333333333333332e-3 * t430 * t431 * t434 - 0.13901316916666666666666666666666666666666666666666e-2 * t438 * t434 - 0.20851975375000000000000000000000000000000000000000e-2 * t441 * t434 - 0.27802633833333333333333333333333333333333333333333e-2 * t444 * t434 - 0.34753292291666666666666666666666666666666666666666e-2 * t447 * t434
  t454 = t114 * t5
  t457 = t454 * t121 * t355 * t194
  t461 = t121 * t194 * t144
  t462 = t454 * t461
  t465 = t410 * t113
  t466 = t465 * t175
  t470 = t345 * t68 * t106
  t472 = t122 * t179
  t473 = t465 * t472
  t492 = t336 * t68 * t106
  t503 = t173 * t144 * t102
  t504 = t454 * t503
  t519 = 0.41703950750000000000000000000000000000000000000000e-2 * t376 * t437 * t457 - 0.20851975375000000000000000000000000000000000000000e-2 * t441 * t462 + 0.20851975375000000000000000000000000000000000000000e-2 * t421 * t466 + 0.55605267666666666666666666666666666666666666666666e-2 * t188 * t470 * t473 + 0.27802633833333333333333333333333333333333333333333e-2 * t424 * t466 + 0.69506584583333333333333333333333333333333333333332e-2 * t191 * t470 * t473 + 0.34753292291666666666666666666666666666666666666666e-2 * t427 * t466 + 0.27802633833333333333333333333333333333333333333332e-2 * t181 * t470 * t473 + 0.13901316916666666666666666666666666666666666666666e-2 * t418 * t466 + 0.41703950750000000000000000000000000000000000000000e-2 * t185 * t470 * t473 - 0.41703950750000000000000000000000000000000000000000e-2 * t341 * t492 * t473 - 0.83407901499999999999999999999999999999999999999999e-2 * t334 * t492 * t473 - 0.13901316916666666666666666666666666666666666666666e-1 * t373 * t492 * t473 + 0.27802633833333333333333333333333333333333333333333e-2 * t444 * t504 + 0.83407901499999999999999999999999999999999999999999e-2 * t383 * t437 * t457 - 0.27802633833333333333333333333333333333333333333333e-2 * t444 * t462 + 0.34753292291666666666666666666666666666666666666666e-2 * t447 * t504 + 0.13901316916666666666666666666666666666666666666666e-1 * t353 * t437 * t457 - 0.34753292291666666666666666666666666666666666666666e-2 * t447 * t462
  t527 = t167 * t19 * t412
  t538 = t430 * t431 * t19
  t558 = t107 * t167
  t581 = 0.13901316916666666666666666666666666666666666666666e-2 * t438 * t504 - 0.13901316916666666666666666666666666666666666666666e-2 * t438 * t462 + 0.20851975375000000000000000000000000000000000000000e-2 * t441 * t504 + 0.32436406138888888888888888888888888888888888888887e-2 * t418 * t527 - 0.13901316916666666666666666666666666666666666666666e-2 * t393 * t179 * t68 * t106 * t413 + 0.48654609208333333333333333333333333333333333333333e-2 * t421 * t527 - 0.69506584583333333333333333333333333333333333333332e-3 * t538 * t411 * t461 + 0.13901316916666666666666666666666666666666666666666e-2 * t147 * t194 * t355 * t68 * t106 * t413 + 0.69506584583333333333333333333333333333333333333332e-3 * t538 * t411 * t503 + 0.69506584583333333333333333333333333333333333333332e-3 * t164 * t437 * t176 + 0.13901316916666666666666666666666666666666666666666e-2 * t396 * t437 * t114 * t472 + 0.81091015347222222222222222222222222222222222222221e-2 * t207 * t558 * t434 + 0.32436406138888888888888888888888888888888888888887e-2 * t197 * t558 * t434 + 0.48654609208333333333333333333333333333333333333333e-2 * t201 * t558 * t434 + 0.64872812277777777777777777777777777777777777777777e-2 * t204 * t558 * t434 + 0.64872812277777777777777777777777777777777777777777e-2 * t424 * t527 + 0.81091015347222222222222222222222222222222222222221e-2 * t427 * t527 + 0.16218203069444444444444444444444444444444444444444e-2 * t430 * t106 * t167 * t434 + 0.16218203069444444444444444444444444444444444444444e-2 * t409 * t527
  v2rhosigma_0_ = t120 * t450 + t301 * t450 + t304 * (t519 + t581)
  t584 = t68 ** 2
  t585 = t106 ** 2
  t586 = t584 * t585
  t589 = 0.1e1 / t22 / t305
  t591 = 0.1e1 / t20
  t594 = t589 * t1 * t591 * t6 * t173
  t601 = t345 * t584 * t585
  t606 = t336 * t584 * t585
  t626 = t585 * t589
  t628 = t1 * t591
  t629 = t6 * t173
  t631 = t628 * t629 * t144
  t637 = t628 * t629 * t355
  t640 = t586 * t589
  t662 = -0.28986991802640426041666666666666666666666666666666e-5 * t396 * t586 * t594 + 0.28986991802640426041666666666666666666666666666665e-5 * t393 * t586 * t594 - 0.57973983605280852083333333333333333333333333333331e-5 * t181 * t601 * t594 + 0.86960975407921278125000000000000000000000000000000e-5 * t341 * t606 * t594 - 0.86960975407921278125000000000000000000000000000000e-5 * t185 * t601 * t594 + 0.17392195081584255625000000000000000000000000000000e-4 * t334 * t606 * t594 - 0.11594796721056170416666666666666666666666666666667e-4 * t188 * t601 * t594 + 0.28986991802640426041666666666666666666666666666666e-4 * t373 * t606 * t594 - 0.14493495901320213020833333333333333333333333333333e-4 * t191 * t601 * t594 - 0.14493495901320213020833333333333333333333333333333e-5 * t143 * t584 * t626 * t631 + 0.28986991802640426041666666666666666666666666666665e-5 * t147 * t584 * t626 * t637 - 0.28986991802640426041666666666666666666666666666665e-5 * t197 * t640 * t631 + 0.86960975407921278125000000000000000000000000000000e-5 * t376 * t640 * t637 - 0.43480487703960639062500000000000000000000000000000e-5 * t201 * t640 * t631 + 0.17392195081584255625000000000000000000000000000000e-4 * t383 * t640 * t637 - 0.57973983605280852083333333333333333333333333333333e-5 * t204 * t640 * t631 + 0.28986991802640426041666666666666666666666666666666e-4 * t353 * t640 * t637 - 0.72467479506601065104166666666666666666666666666665e-5 * t207 * t640 * t631
  v2sigma2_0_ = t304 * t662
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t36 = t4 * t6
  t38 = 0.1e1 / t8 / r0
  t39 = t28 ** 2
  t40 = 0.1e1 / t39
  t41 = t38 * t40
  t43 = 0.1e1 / t15 * t1
  t44 = t3 * t6
  t45 = t44 * t38
  t46 = t43 * t45
  t48 = t6 * t38
  t49 = t4 * t48
  t51 = t14 ** 0.5e0
  t52 = t51 * t1
  t53 = t52 * t45
  t58 = t22 * t5 / t23 / r0
  t60 = -0.63297500000000000000000000000000000000000000000000e0 * t46 - 0.29896666666666666666666666666666666666666666666667e0 * t49 - 0.10238750000000000000000000000000000000000000000000e0 * t53 - 0.82156666666666666666666666666666666666666666666667e-1 * t58
  t61 = 0.1e1 / t31
  t62 = t60 * t61
  t67 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t69 = 0.1e1 / t39 / t28
  t70 = t67 * t69
  t71 = t60 ** 2
  t72 = t71 * t61
  t75 = t67 * t40
  t78 = 0.1e1 / t15 / t14 * t20
  t79 = t21 * t5
  t81 = 0.1e1 / t23 / t7
  t82 = t79 * t81
  t83 = t78 * t82
  t85 = t44 * t10
  t86 = t43 * t85
  t88 = t4 * t11
  t90 = t14 ** (-0.5e0)
  t91 = t90 * t20
  t92 = t91 * t82
  t94 = t52 * t85
  t97 = t22 * t5 * t81
  t99 = -0.42198333333333333333333333333333333333333333333333e0 * t83 + 0.84396666666666666666666666666666666666666666666666e0 * t86 + 0.39862222222222222222222222222222222222222222222223e0 * t88 + 0.68258333333333333333333333333333333333333333333333e-1 * t92 + 0.13651666666666666666666666666666666666666666666667e0 * t94 + 0.13692777777777777777777777777777777777777777777778e0 * t97
  t100 = t99 * t61
  t103 = t39 ** 2
  t104 = 0.1e1 / t103
  t105 = t67 * t104
  t106 = t31 ** 2
  t107 = 0.1e1 / t106
  t108 = t71 * t107
  t111 = 0.1e1 <= f.p.zeta_threshold
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t114 = f.my_piecewise3(t111, t112 * f.p.zeta_threshold, 1)
  t117 = 2 ** (0.1e1 / 0.3e1)
  t121 = (0.2e1 * t114 - 0.2e1) / (0.2e1 * t117 - 0.2e1)
  t122 = t121 * t1
  t127 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t130 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t127
  t131 = jnp.log(t130)
  t136 = t121 * t4
  t137 = t127 ** 2
  t138 = 0.1e1 / t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t46 - 0.30192500000000000000000000000000000000000000000000e0 * t49 - 0.55016250000000000000000000000000000000000000000000e-1 * t53 - 0.82785000000000000000000000000000000000000000000000e-1 * t58
  t145 = 0.1e1 / t130
  t146 = t138 * t143 * t145
  t151 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t152 = t121 * t151
  t154 = 0.1e1 / t137 / t127
  t155 = t143 ** 2
  t157 = t154 * t155 * t145
  t166 = -0.57538888888888888888888888888888888888888888888889e0 * t83 + 0.11507777777777777777777777777777777777777777777778e1 * t86 + 0.40256666666666666666666666666666666666666666666667e0 * t88 + 0.36677500000000000000000000000000000000000000000000e-1 * t92 + 0.73355000000000000000000000000000000000000000000000e-1 * t94 + 0.13797500000000000000000000000000000000000000000000e0 * t97
  t168 = t138 * t166 * t145
  t171 = t137 ** 2
  t172 = 0.1e1 / t171
  t174 = t130 ** 2
  t175 = 0.1e1 / t174
  t176 = t172 * t155 * t175
  t179 = -0.14764627977777777777777777777777777777777777777777e-2 * t4 * t11 * t32 - 0.35616666666666666666666666666666666666666666666666e-1 * t36 * t41 * t62 - 0.20000000000000000000000000000000000000000000000000e1 * t70 * t72 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t100 + 0.16081979498692535066756296899072713062105388428051e2 * t105 * t108 + 0.24415263074675393406472461472505321282722606644045e-3 * t122 * t44 * t10 * t131 + 0.10843581300301739842632067522386578331157260943710e-1 * t136 * t48 * t146 + 0.11696447245269292414524477327518106963944910680856e1 * t152 * t157 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t168 - 0.17315859105681463759666483083807725165579399831905e2 * t152 * t176
  t181 = params.sogga11_a[1]
  t182 = t112 ** 2
  t183 = f.my_piecewise3(t111, t182, 1)
  t184 = t117 * t183
  t185 = s0 * t10
  t186 = t184 * t185
  t187 = 0.1e1 / t3
  t188 = t20 * t187
  t194 = -0.621814e-1 * t67 * t32 + 0.19751673498613801407483339618206552048944131217655e-1 * t121 * t151 * t131
  t197 = t188 * t5 / t194
  t199 = 0.69506584583333333333333333333333333333333333333332e-3 * t186 * t197
  t200 = 0.1e1 - t199
  t202 = 0.1e1 - 0.1e1 / t200
  t204 = params.sogga11_a[2]
  t205 = t202 ** 2
  t207 = params.sogga11_a[3]
  t208 = t205 * t202
  t210 = params.sogga11_a[4]
  t211 = t205 ** 2
  t213 = params.sogga11_a[5]
  t217 = params.sogga11_b[1]
  t218 = jnp.exp(t199)
  t219 = 0.1e1 - t218
  t221 = params.sogga11_b[2]
  t222 = t219 ** 2
  t224 = params.sogga11_b[3]
  t225 = t222 * t219
  t227 = params.sogga11_b[4]
  t228 = t222 ** 2
  t230 = params.sogga11_b[5]
  t233 = t213 * t211 * t202 + t230 * t228 * t219 + t181 * t202 + t204 * t205 + t207 * t208 + t210 * t211 + t217 * t219 + t221 * t222 + t224 * t225 + t227 * t228 + params.sogga11_a[0] + params.sogga11_b[0]
  t247 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t48 * t32 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t62 - 0.18311447306006545054854346104378990962041954983034e-3 * t122 * t44 * t38 * t131 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t146
  t248 = t200 ** 2
  t249 = 0.1e1 / t248
  t250 = t181 * t249
  t251 = t7 * r0
  t253 = 0.1e1 / t8 / t251
  t255 = t184 * s0 * t253
  t258 = t194 ** 2
  t260 = t5 / t258
  t262 = t188 * t260 * t247
  t265 = 0.16218203069444444444444444444444444444444444444444e-2 * t255 * t197 + 0.69506584583333333333333333333333333333333333333332e-3 * t186 * t262
  t267 = t204 * t202
  t268 = t249 * t265
  t271 = t207 * t205
  t274 = t210 * t208
  t277 = t213 * t211
  t280 = -t265
  t281 = t217 * t280
  t283 = t221 * t219
  t284 = t280 * t218
  t287 = t224 * t222
  t290 = t227 * t225
  t293 = t230 * t228
  t296 = -t281 * t218 + t250 * t265 + 0.2e1 * t267 * t268 + 0.3e1 * t271 * t268 + 0.4e1 * t274 * t268 + 0.5e1 * t277 * t268 - 0.2e1 * t283 * t284 - 0.3e1 * t287 * t284 - 0.4e1 * t290 * t284 - 0.5e1 * t293 * t284
  t299 = t7 ** 2
  t303 = t184 * s0 / t8 / t299
  t309 = 0.1e1 / t258 / t194
  t311 = t247 ** 2
  t313 = t188 * t5 * t309 * t311
  t317 = t188 * t260 * t179
  t320 = 0.54060676898148148148148148148148148148148148148147e-2 * t303 * t197 + 0.32436406138888888888888888888888888888888888888888e-2 * t255 * t262 + 0.13901316916666666666666666666666666666666666666666e-2 * t186 * t313 - 0.69506584583333333333333333333333333333333333333332e-3 * t186 * t317
  t321 = t320 * t218
  t324 = t280 ** 2
  t325 = t324 * t218
  t328 = t230 * t225
  t329 = t218 ** 2
  t330 = t324 * t329
  t335 = -t320
  t336 = t249 * t335
  t347 = t227 * t222
  t350 = t213 * t208
  t351 = t248 ** 2
  t352 = 0.1e1 / t351
  t353 = t265 ** 2
  t354 = t352 * t353
  t360 = 0.1e1 / t248 / t200
  t361 = t181 * t360
  t365 = t250 * t335 + 0.4e1 * t274 * t336 + 0.5e1 * t277 * t336 - 0.2e1 * t283 * t325 - 0.3e1 * t287 * t321 - 0.3e1 * t287 * t325 - 0.4e1 * t290 * t321 - 0.4e1 * t290 * t325 - 0.5e1 * t293 * t321 - 0.5e1 * t293 * t325 + 0.20e2 * t328 * t330 + 0.12e2 * t347 * t330 + 0.20e2 * t350 * t354 - 0.2e1 * t361 * t353
  t366 = t360 * t353
  t378 = t204 * t352
  t389 = t224 * t219
  t392 = t210 * t205
  t395 = t207 * t202
  t400 = -t217 * t320 * t218 - t217 * t324 * t218 + 0.2e1 * t221 * t324 * t329 + 0.2e1 * t267 * t336 - 0.4e1 * t267 * t366 + 0.3e1 * t271 * t336 - 0.6e1 * t271 * t366 - 0.8e1 * t274 * t366 - 0.10e2 * t277 * t366 - 0.2e1 * t283 * t321 + 0.6e1 * t389 * t330 + 0.2e1 * t378 * t353 + 0.12e2 * t392 * t354 + 0.6e1 * t395 * t354
  t401 = t365 + t400
  t407 = t71 * t60
  t415 = 0.1e1 / t299
  t416 = 0.1e1 / t15 / t26 * t2 * t415 / 0.4e1
  t419 = 0.1e1 / t23 / t251
  t420 = t79 * t419
  t421 = t78 * t420
  t423 = t44 * t253
  t424 = t43 * t423
  t426 = t6 * t253
  t427 = t4 * t426
  t429 = t14 ** (-0.15e1)
  t431 = t429 * t2 * t415
  t433 = t91 * t420
  t435 = t52 * t423
  t438 = t22 * t5 * t419
  t473 = t155 * t143
  t480 = -0.96491876992155210400537781394436278372632330568306e2 * t67 / t103 / t28 * t407 * t107 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * (-0.25319000000000000000000000000000000000000000000000e1 * t416 + 0.16879333333333333333333333333333333333333333333333e1 * t421 - 0.19692555555555555555555555555555555555555555555555e1 * t424 - 0.93011851851851851851851851851851851851851851851854e0 * t427 + 0.13651666666666666666666666666666666666666666666667e0 * t431 - 0.27303333333333333333333333333333333333333333333333e0 * t433 - 0.31853888888888888888888888888888888888888888888890e0 * t435 - 0.36514074074074074074074074074074074074074074074075e0 * t438) * t61 + 0.71233333333333333333333333333333333333333333333331e-1 * t36 * t10 * t40 * t62 - 0.53424999999999999999999999999999999999999999999999e-1 * t36 * t41 * t100 - 0.85917975471764868594145516183295969534298037676861e0 * t36 * t38 * t104 * t108 - 0.21687162600603479685264135044773156662314521887420e-1 * t136 * t11 * t146 + 0.16265371950452609763948101283579867496735891415565e-1 * t136 * t48 * t168 + 0.48159733137676571081572406076840235616767705782485e0 * t136 * t48 * t176 + 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t426 * t32 + 0.48245938496077605200268890697218139186316165284153e2 * t105 * t99 * t107 * t60 - 0.10254018858216406658218194626490193680059335835414e4 * t152 / t171 / t137 * t473 / t174 / t130
  t539 = -0.51947577317044391278999449251423175496738199495715e2 * t152 * t172 * t166 * t175 * t143 - 0.35089341735807877243573431982554320891834732042568e1 * t152 * t172 * t473 * t145 + 0.35089341735807877243573431982554320891834732042568e1 * t152 * t154 * t143 * t145 * t166 + 0.10389515463408878255799889850284635099347639899143e3 * t152 / t171 / t127 * t473 * t175 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t138 * (-0.34523333333333333333333333333333333333333333333333e1 * t416 + 0.23015555555555555555555555555555555555555555555556e1 * t421 - 0.26851481481481481481481481481481481481481481481482e1 * t424 - 0.93932222222222222222222222222222222222222222222223e0 * t427 + 0.73355000000000000000000000000000000000000000000000e-1 * t431 - 0.14671000000000000000000000000000000000000000000000e0 * t433 - 0.17116166666666666666666666666666666666666666666667e0 * t435 - 0.36793333333333333333333333333333333333333333333333e0 * t438) * t145 + 0.60000000000000000000000000000000000000000000000000e1 * t105 * t407 * t61 - 0.60000000000000000000000000000000000000000000000000e1 * t70 * t62 * t99 - 0.32530743900905219527896202567159734993471782831130e-1 * t136 * t48 * t157 + 0.51726012919273400298984252201052768390886626637712e3 * t67 / t103 / t39 * t407 / t106 / t31 + 0.10685000000000000000000000000000000000000000000000e0 * t36 * t38 * t69 * t72 - 0.56968947174242584615102410102512416326352748836105e-3 * t122 * t44 * t253 * t131
  t540 = t480 + t539
  t551 = t329 * t320
  t555 = t352 * t265 * t335
  t560 = t324 * t280
  t561 = t560 * t218
  t564 = t353 * t265
  t565 = t352 * t564
  t568 = t560 * t329
  t572 = t329 * t218
  t573 = t560 * t572
  t579 = 0.1e1 / t351 / t200
  t580 = t579 * t564
  t603 = t258 ** 2
  t623 = -0.23426293322530864197530864197530864197530864197530e-1 * t184 * s0 / t8 / t299 / r0 * t197 - 0.16218203069444444444444444444444444444444444444444e-1 * t303 * t262 - 0.97309218416666666666666666666666666666666666666663e-2 * t255 * t313 + 0.48654609208333333333333333333333333333333333333332e-2 * t255 * t317 - 0.41703950749999999999999999999999999999999999999998e-2 * t186 * t188 * t5 / t603 * t311 * t247 + 0.41703950749999999999999999999999999999999999999998e-2 * t184 * t185 * t20 * t187 * t5 * t309 * t247 * t179 - 0.69506584583333333333333333333333333333333333333332e-3 * t186 * t188 * t260 * t540
  t624 = t623 * t218
  t627 = -0.24e2 * t227 * t219 * t573 + 0.6e1 * t221 * t280 * t551 - 0.60e2 * t230 * t222 * t573 + 0.12e2 * t267 * t565 + 0.18e2 * t271 * t565 - 0.2e1 * t283 * t624 - 0.4e1 * t290 * t561 - 0.5e1 * t293 * t561 + 0.60e2 * t328 * t568 - 0.120e3 * t350 * t580 + 0.18e2 * t389 * t568 + 0.36e2 * t392 * t555 + 0.18e2 * t395 * t555
  t630 = t551 * t280
  t633 = t284 * t320
  t637 = t360 * t265 * t335
  t640 = t265 * t335
  t653 = 0.1e1 / t351 / t248
  t654 = t653 * t564
  t663 = 0.60e2 * t213 * t205 * t654 + 0.24e2 * t274 * t565 - 0.24e2 * t274 * t637 + 0.30e2 * t277 * t565 - 0.3e1 * t281 * t321 - 0.6e1 * t283 * t633 - 0.9e1 * t287 * t633 - 0.4e1 * t290 * t624 + 0.60e2 * t328 * t630 - 0.6e1 * t361 * t640 + 0.6e1 * t378 * t640 + 0.18e2 * t389 * t630 - 0.72e2 * t392 * t580
  t673 = -t623
  t674 = t249 * t673
  t693 = -0.12e2 * t204 * t579 * t564 + t250 * t673 - 0.18e2 * t271 * t637 + 0.3e1 * t271 * t674 + 0.4e1 * t274 * t674 - 0.30e2 * t277 * t637 + 0.5e1 * t277 * t674 - 0.3e1 * t287 * t624 - 0.12e2 * t290 * t633 - 0.5e1 * t293 * t624 + 0.36e2 * t347 * t568 + 0.60e2 * t350 * t555 - 0.36e2 * t395 * t580
  t725 = 0.6e1 * t181 * t352 * t564 + 0.24e2 * t210 * t202 * t654 + 0.6e1 * t207 * t653 * t564 - t217 * t560 * t218 - t217 * t623 * t218 + 0.6e1 * t221 * t560 * t329 - 0.6e1 * t224 * t560 * t572 - 0.12e2 * t267 * t637 + 0.2e1 * t267 * t674 - 0.2e1 * t283 * t561 - 0.3e1 * t287 * t561 - 0.15e2 * t293 * t633 + 0.36e2 * t347 * t630
  v3rho3_0_ = 0.3e1 * t179 * t233 + 0.6e1 * t247 * t296 + 0.3e1 * t194 * t401 + r0 * t540 * t233 + 0.3e1 * r0 * t179 * t296 + 0.3e1 * r0 * t247 * t401 + r0 * t194 * (t627 + t663 + t693 + t725)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = r0 ** 2
  t9 = r0 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t14 = t4 * t6 / t9
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t9 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t31 = t11 * t30
  t33 = 0.1e1 / t15 * t1
  t34 = t3 * t6
  t36 = 0.1e1 / t9 / r0
  t37 = t34 * t36
  t38 = t33 * t37
  t40 = t6 * t36
  t41 = t4 * t40
  t43 = t14 ** 0.5e0
  t44 = t43 * t1
  t45 = t44 * t37
  t50 = t22 * t5 / t23 / r0
  t52 = -0.63297500000000000000000000000000000000000000000000e0 * t38 - 0.29896666666666666666666666666666666666666666666667e0 * t41 - 0.10238750000000000000000000000000000000000000000000e0 * t45 - 0.82156666666666666666666666666666666666666666666667e-1 * t50
  t55 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t56 = 0.1e1 / t55
  t57 = t52 * t56
  t61 = t36 * t30
  t64 = 0.1e1 / t15 / t14 * t20
  t65 = t21 * t5
  t67 = 0.1e1 / t23 / t8
  t68 = t65 * t67
  t69 = t64 * t68
  t71 = t34 * t11
  t72 = t33 * t71
  t74 = t6 * t11
  t75 = t4 * t74
  t77 = t14 ** (-0.5e0)
  t78 = t77 * t20
  t79 = t78 * t68
  t81 = t44 * t71
  t84 = t22 * t5 * t67
  t86 = -0.42198333333333333333333333333333333333333333333333e0 * t69 + 0.84396666666666666666666666666666666666666666666666e0 * t72 + 0.39862222222222222222222222222222222222222222222223e0 * t75 + 0.68258333333333333333333333333333333333333333333333e-1 * t79 + 0.13651666666666666666666666666666666666666666666667e0 * t81 + 0.13692777777777777777777777777777777777777777777778e0 * t84
  t87 = t86 * t56
  t91 = t29 ** 2
  t92 = 0.1e1 / t91
  t93 = t36 * t92
  t94 = t52 ** 2
  t95 = t55 ** 2
  t96 = 0.1e1 / t95
  t97 = t94 * t96
  t101 = 0.1e1 <= f.p.zeta_threshold
  t102 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t104 = f.my_piecewise3(t101, t102 * f.p.zeta_threshold, 1)
  t107 = 2 ** (0.1e1 / 0.3e1)
  t111 = (0.2e1 * t104 - 0.2e1) / (0.2e1 * t107 - 0.2e1)
  t112 = t111 * t4
  t117 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t118 = t117 ** 2
  t119 = 0.1e1 / t118
  t124 = -0.86308333333333333333333333333333333333333333333334e0 * t38 - 0.30192500000000000000000000000000000000000000000000e0 * t41 - 0.55016250000000000000000000000000000000000000000000e-1 * t45 - 0.82785000000000000000000000000000000000000000000000e-1 * t50
  t128 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t117
  t129 = 0.1e1 / t128
  t130 = t119 * t124 * t129
  t140 = -0.57538888888888888888888888888888888888888888888889e0 * t69 + 0.11507777777777777777777777777777777777777777777778e1 * t72 + 0.40256666666666666666666666666666666666666666666667e0 * t75 + 0.36677500000000000000000000000000000000000000000000e-1 * t79 + 0.73355000000000000000000000000000000000000000000000e-1 * t81 + 0.13797500000000000000000000000000000000000000000000e0 * t84
  t142 = t119 * t140 * t129
  t146 = t118 ** 2
  t147 = 0.1e1 / t146
  t148 = t124 ** 2
  t149 = t147 * t148
  t150 = t128 ** 2
  t151 = 0.1e1 / t150
  t152 = t149 * t151
  t157 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t159 = 0.1e1 / t91 / t29
  t160 = t157 * t159
  t161 = t94 * t52
  t163 = 0.1e1 / t95 / t55
  t164 = t161 * t163
  t167 = t157 * t92
  t168 = t86 * t96
  t173 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t174 = t111 * t173
  t176 = 0.1e1 / t146 / t118
  t177 = t148 * t124
  t180 = 0.1e1 / t150 / t128
  t181 = t176 * t177 * t180
  t184 = t118 * t117
  t185 = 0.1e1 / t184
  t187 = t185 * t148 * t129
  t192 = 0.1e1 / t91 / t28
  t193 = t157 * t192
  t194 = t161 * t96
  t197 = 0.71233333333333333333333333333333333333333333333331e-1 * t7 * t31 * t57 - 0.53424999999999999999999999999999999999999999999999e-1 * t7 * t61 * t87 - 0.85917975471764868594145516183295969534298037676861e0 * t7 * t93 * t97 - 0.21687162600603479685264135044773156662314521887420e-1 * t112 * t74 * t130 + 0.16265371950452609763948101283579867496735891415565e-1 * t112 * t40 * t142 + 0.48159733137676571081572406076840235616767705782485e0 * t112 * t40 * t152 + 0.51726012919273400298984252201052768390886626637712e3 * t160 * t164 + 0.48245938496077605200268890697218139186316165284153e2 * t167 * t168 * t52 - 0.10254018858216406658218194626490193680059335835414e4 * t174 * t181 - 0.32530743900905219527896202567159734993471782831130e-1 * t112 * t40 * t187 - 0.96491876992155210400537781394436278372632330568306e2 * t193 * t194
  t198 = t157 * t30
  t202 = 0.1e1 / t15 / t26 * t2 / 0.4e1
  t203 = t8 ** 2
  t204 = 0.1e1 / t203
  t205 = t202 * t204
  t207 = t8 * r0
  t209 = 0.1e1 / t23 / t207
  t210 = t65 * t209
  t211 = t64 * t210
  t214 = 0.1e1 / t9 / t207
  t215 = t34 * t214
  t216 = t33 * t215
  t218 = t6 * t214
  t219 = t4 * t218
  t221 = t14 ** (-0.15e1)
  t222 = t221 * t2
  t223 = t222 * t204
  t225 = t78 * t210
  t227 = t44 * t215
  t230 = t22 * t5 * t209
  t232 = -0.25319000000000000000000000000000000000000000000000e1 * t205 + 0.16879333333333333333333333333333333333333333333333e1 * t211 - 0.19692555555555555555555555555555555555555555555555e1 * t216 - 0.93011851851851851851851851851851851851851851851854e0 * t219 + 0.13651666666666666666666666666666666666666666666667e0 * t223 - 0.27303333333333333333333333333333333333333333333333e0 * t225 - 0.31853888888888888888888888888888888888888888888890e0 * t227 - 0.36514074074074074074074074074074074074074074074075e0 * t230
  t233 = t232 * t56
  t236 = t161 * t56
  t239 = t29 * t28
  t240 = 0.1e1 / t239
  t241 = t157 * t240
  t246 = 0.1e1 / t146 / t117
  t248 = t246 * t177 * t151
  t259 = -0.34523333333333333333333333333333333333333333333333e1 * t205 + 0.23015555555555555555555555555555555555555555555556e1 * t211 - 0.26851481481481481481481481481481481481481481481482e1 * t216 - 0.93932222222222222222222222222222222222222222222223e0 * t219 + 0.73355000000000000000000000000000000000000000000000e-1 * t223 - 0.14671000000000000000000000000000000000000000000000e0 * t225 - 0.17116166666666666666666666666666666666666666666667e0 * t227 - 0.36793333333333333333333333333333333333333333333333e0 * t230
  t261 = t119 * t259 * t129
  t265 = t151 * t124
  t270 = t147 * t177 * t129
  t274 = t129 * t140
  t278 = jnp.log(t55)
  t283 = t94 * t56
  t287 = t111 * t1
  t288 = jnp.log(t128)
  t293 = 0.10000000000000000000000000000000000000000000000000e1 * t198 * t233 + 0.60000000000000000000000000000000000000000000000000e1 * t167 * t236 - 0.60000000000000000000000000000000000000000000000000e1 * t241 * t57 * t86 + 0.10389515463408878255799889850284635099347639899143e3 * t174 * t248 - 0.58482236226346462072622386637590534819724553404280e0 * t174 * t261 - 0.51947577317044391278999449251423175496738199495715e2 * t174 * t147 * t140 * t265 - 0.35089341735807877243573431982554320891834732042568e1 * t174 * t270 + 0.35089341735807877243573431982554320891834732042568e1 * t174 * t185 * t124 * t274 + 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t218 * t278 + 0.10685000000000000000000000000000000000000000000000e0 * t7 * t36 * t240 * t283 - 0.56968947174242584615102410102512416326352748836105e-3 * t287 * t34 * t214 * t288
  t294 = t197 + t293
  t296 = params.sogga11_a[1]
  t297 = t102 ** 2
  t298 = f.my_piecewise3(t101, t297, 1)
  t299 = t107 * t298
  t300 = s0 * t11
  t301 = t299 * t300
  t302 = 0.1e1 / t3
  t303 = t20 * t302
  t309 = -0.621814e-1 * t157 * t278 + 0.19751673498613801407483339618206552048944131217655e-1 * t111 * t173 * t288
  t312 = t303 * t5 / t309
  t314 = 0.69506584583333333333333333333333333333333333333332e-3 * t301 * t312
  t315 = 0.1e1 - t314
  t317 = 0.1e1 - 0.1e1 / t315
  t319 = params.sogga11_a[2]
  t320 = t317 ** 2
  t322 = params.sogga11_a[3]
  t323 = t320 * t317
  t325 = params.sogga11_a[4]
  t326 = t320 ** 2
  t328 = params.sogga11_a[5]
  t332 = params.sogga11_b[1]
  t333 = jnp.exp(t314)
  t334 = 0.1e1 - t333
  t336 = params.sogga11_b[2]
  t337 = t334 ** 2
  t339 = params.sogga11_b[3]
  t340 = t337 * t334
  t342 = params.sogga11_b[4]
  t343 = t337 ** 2
  t345 = params.sogga11_b[5]
  t348 = t328 * t326 * t317 + t345 * t343 * t334 + t296 * t317 + t319 * t320 + t322 * t323 + t325 * t326 + t332 * t334 + t336 * t337 + t339 * t340 + t342 * t343 + params.sogga11_a[0] + params.sogga11_b[0]
  t376 = -0.14764627977777777777777777777777777777777777777777e-2 * t4 * t74 * t278 - 0.35616666666666666666666666666666666666666666666666e-1 * t7 * t61 * t57 - 0.20000000000000000000000000000000000000000000000000e1 * t241 * t283 + 0.10000000000000000000000000000000000000000000000000e1 * t198 * t87 + 0.16081979498692535066756296899072713062105388428051e2 * t167 * t97 + 0.24415263074675393406472461472505321282722606644045e-3 * t287 * t34 * t11 * t288 + 0.10843581300301739842632067522386578331157260943710e-1 * t112 * t40 * t130 + 0.11696447245269292414524477327518106963944910680856e1 * t174 * t187 - 0.58482236226346462072622386637590534819724553404280e0 * t174 * t142 - 0.17315859105681463759666483083807725165579399831905e2 * t174 * t152
  t377 = t315 ** 2
  t378 = 0.1e1 / t377
  t379 = t296 * t378
  t380 = s0 * t214
  t381 = t299 * t380
  t384 = t309 ** 2
  t386 = t5 / t384
  t398 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t40 * t278 + 0.10000000000000000000000000000000000000000000000000e1 * t198 * t57 - 0.18311447306006545054854346104378990962041954983034e-3 * t287 * t34 * t36 * t288 - 0.58482236226346462072622386637590534819724553404280e0 * t174 * t130
  t400 = t303 * t386 * t398
  t403 = 0.16218203069444444444444444444444444444444444444444e-2 * t381 * t312 + 0.69506584583333333333333333333333333333333333333332e-3 * t301 * t400
  t405 = t319 * t317
  t406 = t378 * t403
  t409 = t322 * t320
  t412 = t325 * t323
  t415 = t328 * t326
  t418 = -t403
  t419 = t332 * t418
  t421 = t336 * t334
  t422 = t418 * t333
  t425 = t339 * t337
  t428 = t342 * t340
  t431 = t345 * t343
  t434 = -t419 * t333 + t379 * t403 + 0.2e1 * t405 * t406 + 0.3e1 * t409 * t406 + 0.4e1 * t412 * t406 + 0.5e1 * t415 * t406 - 0.2e1 * t421 * t422 - 0.3e1 * t425 * t422 - 0.4e1 * t428 * t422 - 0.5e1 * t431 * t422
  t438 = 0.1e1 / t9 / t203
  t440 = t299 * s0 * t438
  t446 = 0.1e1 / t384 / t309
  t447 = t5 * t446
  t448 = t398 ** 2
  t450 = t303 * t447 * t448
  t454 = t303 * t386 * t376
  t457 = 0.54060676898148148148148148148148148148148148148147e-2 * t440 * t312 + 0.32436406138888888888888888888888888888888888888888e-2 * t381 * t400 + 0.13901316916666666666666666666666666666666666666666e-2 * t301 * t450 - 0.69506584583333333333333333333333333333333333333332e-3 * t301 * t454
  t458 = t457 * t333
  t463 = t418 ** 2
  t464 = t463 * t333
  t469 = t377 * t315
  t470 = 0.1e1 / t469
  t471 = t403 ** 2
  t472 = t470 * t471
  t475 = -t457
  t476 = t378 * t475
  t487 = t322 * t317
  t488 = t377 ** 2
  t489 = 0.1e1 / t488
  t490 = t489 * t471
  t497 = t342 * t337
  t498 = t333 ** 2
  t499 = t463 * t498
  t502 = -0.4e1 * t405 * t472 + 0.2e1 * t405 * t476 - 0.6e1 * t409 * t472 - 0.8e1 * t412 * t472 + 0.5e1 * t415 * t476 - 0.2e1 * t421 * t464 - 0.3e1 * t425 * t458 - 0.3e1 * t425 * t464 - 0.4e1 * t428 * t458 - 0.4e1 * t428 * t464 - 0.5e1 * t431 * t458 - 0.5e1 * t431 * t464 + 0.6e1 * t487 * t490 + 0.12e2 * t497 * t499
  t503 = t339 * t334
  t510 = t328 * t323
  t513 = t345 * t340
  t518 = t332 * t463
  t520 = t336 * t463
  t525 = t319 * t489
  t528 = t296 * t470
  t532 = t325 * t320
  t537 = -t332 * t457 * t333 - t518 * t333 + t379 * t475 + 0.3e1 * t409 * t476 + 0.4e1 * t412 * t476 - 0.10e2 * t415 * t472 - 0.2e1 * t421 * t458 + 0.2e1 * t525 * t471 - 0.2e1 * t528 * t471 + 0.20e2 * t510 * t490 + 0.12e2 * t532 * t490 + 0.2e1 * t520 * t498 + 0.6e1 * t503 * t499 + 0.20e2 * t513 * t499
  t538 = t502 + t537
  t542 = 0.1e1 / t488 / t315
  t543 = t471 * t403
  t544 = t542 * t543
  t547 = t403 * t475
  t551 = t457 * t418 * t333
  t554 = t345 * t337
  t555 = t463 * t418
  t556 = t498 * t333
  t557 = t555 * t556
  t560 = t555 * t498
  t563 = t328 * t320
  t565 = 0.1e1 / t488 / t377
  t566 = t565 * t543
  t569 = t336 * t418
  t570 = t498 * t457
  t573 = t203 * r0
  t575 = 0.1e1 / t9 / t573
  t577 = t299 * s0 * t575
  t586 = t384 ** 2
  t587 = 0.1e1 / t586
  t591 = t303 * t5 * t587 * t448 * t398
  t595 = t299 * t300 * t20
  t596 = t302 * t5
  t597 = t446 * t398
  t599 = t596 * t597 * t376
  t603 = t303 * t386 * t294
  t606 = -0.23426293322530864197530864197530864197530864197530e-1 * t577 * t312 - 0.16218203069444444444444444444444444444444444444444e-1 * t440 * t400 - 0.97309218416666666666666666666666666666666666666663e-2 * t381 * t450 + 0.48654609208333333333333333333333333333333333333332e-2 * t381 * t454 - 0.41703950749999999999999999999999999999999999999998e-2 * t301 * t591 + 0.41703950749999999999999999999999999999999999999998e-2 * t595 * t599 - 0.69506584583333333333333333333333333333333333333332e-3 * t301 * t603
  t607 = t606 * t333
  t612 = -t606
  t613 = t378 * t612
  t617 = t470 * t403 * t475
  t620 = t555 * t333
  t625 = 0.4e1 * t412 * t613 - 0.30e2 * t415 * t617 - 0.2e1 * t421 * t607 - 0.2e1 * t421 * t620 - 0.4e1 * t428 * t620 - 0.15e2 * t431 * t551 - 0.5e1 * t431 * t607 - 0.36e2 * t487 * t544 + 0.36e2 * t497 * t560 - 0.6e1 * t528 * t547 - 0.60e2 * t554 * t557 + 0.60e2 * t563 * t566 + 0.6e1 * t569 * t570
  t630 = t489 * t543
  t633 = t342 * t334
  t649 = t489 * t403 * t475
  t652 = t325 * t317
  t657 = -0.12e2 * t405 * t617 + 0.3e1 * t409 * t613 - 0.18e2 * t409 * t617 + 0.24e2 * t412 * t630 + 0.30e2 * t415 * t630 - 0.12e2 * t428 * t551 - 0.5e1 * t431 * t620 + 0.18e2 * t487 * t649 - 0.120e3 * t510 * t544 + 0.60e2 * t513 * t560 + 0.6e1 * t525 * t547 - 0.24e2 * t633 * t557 + 0.24e2 * t652 * t566
  t662 = t418 * t498 * t457
  t687 = 0.2e1 * t405 * t613 + 0.18e2 * t409 * t630 - 0.24e2 * t412 * t617 + 0.5e1 * t415 * t613 - 0.3e1 * t419 * t458 - 0.6e1 * t421 * t551 - 0.3e1 * t425 * t607 - 0.4e1 * t428 * t607 + 0.18e2 * t503 * t560 + 0.18e2 * t503 * t662 + 0.60e2 * t513 * t662 - 0.72e2 * t532 * t544 + 0.36e2 * t532 * t649
  t694 = t296 * t489
  t703 = t322 * t565
  t708 = t319 * t542
  t711 = t332 * t606
  t718 = -t332 * t555 * t333 + 0.6e1 * t336 * t555 * t498 - 0.6e1 * t339 * t555 * t556 - t711 * t333 + t379 * t612 + 0.12e2 * t405 * t630 - 0.9e1 * t425 * t551 - 0.3e1 * t425 * t620 + 0.36e2 * t497 * t662 + 0.60e2 * t510 * t649 + 0.6e1 * t694 * t543 + 0.6e1 * t703 * t543 - 0.12e2 * t708 * t543
  t720 = t625 + t657 + t687 + t718
  t734 = t86 ** 2
  t763 = -0.57895126195293126240322668836661767023579398340984e3 * t193 * t168 * t94 + 0.64327917994770140267025187596290852248421553712204e2 * t167 * t232 * t96 * t52 + 0.31035607751564040179390551320631661034531975982628e4 * t160 * t94 * t163 * t86 + 0.48245938496077605200268890697218139186316165284153e2 * t167 * t734 * t96 - 0.42740000000000000000000000000000000000000000000000e0 * t7 * t93 * t236 + 0.18989649058080861538367470034170805442117582945368e-2 * t287 * t34 * t438 * t288 - 0.71233333333333333333333333333333333333333333333332e-1 * t7 * t61 * t233 - 0.36846163202829085479643115651216588683774907041596e2 * t7 * t36 * t159 * t164 - 0.22161481481481481481481481481481481481481481481481e0 * t7 * t214 * t30 * t57 - 0.28493333333333333333333333333333333333333333333333e0 * t7 * t11 * t240 * t283 - 0.21053605041484726346144059189532592535100839225540e2 * t174 * t149 * t274
  t774 = t151 * t140
  t797 = t94 ** 2
  t801 = t91 ** 2
  t804 = t95 ** 2
  t809 = t6 * t438
  t819 = 0.68734380377411894875316412946636775627438430141488e1 * t7 * t36 * t192 * t194 - 0.61524113149298439949309167758941162080356015012483e4 * t174 * t176 * t148 * t180 * t140 + 0.62337092780453269534799339101707810596085839394858e3 * t174 * t246 * t148 * t774 + 0.46785788981077169658097909310072427855779642723424e1 * t174 * t185 * t259 * t129 * t124 - 0.69263436422725855038665932335230900662317599327620e2 * t174 * t147 * t259 * t265 + 0.14246666666666666666666666666666666666666666666666e0 * t7 * t31 * t87 + 0.22911460125803964958438804315545591875812810047162e1 * t7 * t11 * t92 * t97 - 0.62071215503128080358781102641263322069063951965254e4 * t157 / t91 / t239 * t797 * t163 + 0.24955700379505800914252936827276051226357058527653e5 * t157 / t801 * t797 / t804 - 0.11483599538271604938271604938271604938271604938271e-1 * t4 * t809 * t278 - 0.80000000000000000000000000000000000000000000000000e1 * t241 * t233 * t52 + 0.36000000000000000000000000000000000000000000000000e2 * t167 * t283 * t86
  t821 = t140 ** 2
  t826 = t148 ** 2
  t831 = t146 ** 2
  t834 = t150 ** 2
  t866 = -0.51947577317044391278999449251423175496738199495715e2 * t174 * t147 * t821 * t151 + 0.14035736694323150897429372793021728356733892817027e2 * t174 * t246 * t826 * t129 - 0.91082604192152556048340974007871726131433263376469e5 * t174 / t831 * t826 / t834 + 0.12304822629859687989861833551788232416071203002497e5 * t174 / t146 / t184 * t826 * t180 + 0.13012297560362087811158481026863893997388713132452e0 * t112 * t40 * t270 + 0.21687162600603479685264135044773156662314521887420e-1 * t112 * t40 * t261 + 0.38025319932552508024225805073234468230220037056326e2 * t112 * t40 * t181 + 0.67471172535210825687488420139294265171645179205307e-1 * t112 * t218 * t130 + 0.86748650402413918741056540179092626649258087549680e-1 * t112 * t74 * t187 - 0.38527786510141256865257924861472188493414164625988e1 * t112 * t40 * t248 - 0.43374325201206959370528270089546313324629043774840e-1 * t112 * t74 * t142
  t870 = t111 * t7
  t896 = 0.1e1 / t15 * r0 * t575 * t7 / 0.48e2
  t898 = 0.1e1 / t573
  t899 = t202 * t898
  t902 = 0.1e1 / t23 / t203
  t903 = t65 * t902
  t904 = t64 * t903
  t906 = t34 * t438
  t907 = t33 * t906
  t909 = t4 * t809
  t911 = t14 ** (-0.25e1)
  t914 = t911 * t2 * t575 * t7
  t916 = t222 * t898
  t918 = t78 * t903
  t920 = t44 * t906
  t923 = t22 * t5 * t902
  t962 = -0.12842595503380418955085974953824062831138054875329e1 * t112 * t74 * t152 - 0.13012297560362087811158481026863893997388713132452e0 * t870 * t36 * t185 * t274 * t124 + 0.19263893255070628432628962430736094246707082312995e1 * t870 * t36 * t147 * t774 * t124 + 0.35089341735807877243573431982554320891834732042568e1 * t174 * t185 * t821 * t129 - 0.62337092780453269534799339101707810596085839394858e3 * t174 * t176 * t826 * t151 - 0.58482236226346462072622386637590534819724553404280e0 * t174 * t119 * (-0.28769444444444444444444444444444444444444444444444e1 * t896 + 0.27618666666666666666666666666666666666666666666667e2 * t899 - 0.10229135802469135802469135802469135802469135802469e2 * t904 + 0.89504938271604938271604938271604938271604938271607e1 * t907 + 0.31310740740740740740740740740740740740740740740741e1 * t909 + 0.36677500000000000000000000000000000000000000000000e-1 * t914 - 0.58684000000000000000000000000000000000000000000000e0 * t916 + 0.65204444444444444444444444444444444444444444444445e0 * t918 + 0.57053888888888888888888888888888888888888888888890e0 * t920 + 0.13490888888888888888888888888888888888888888888889e1 * t923) * t129 + 0.10000000000000000000000000000000000000000000000000e1 * t198 * (-0.21099166666666666666666666666666666666666666666667e1 * t896 + 0.20255200000000000000000000000000000000000000000000e2 * t899 - 0.75019259259259259259259259259259259259259259259258e1 * t904 + 0.65641851851851851851851851851851851851851851851850e1 * t907 + 0.31003950617283950617283950617283950617283950617285e1 * t909 + 0.68258333333333333333333333333333333333333333333335e-1 * t914 - 0.10921333333333333333333333333333333333333333333333e1 * t916 + 0.12134814814814814814814814814814814814814814814815e1 * t918 + 0.10617962962962962962962962962962962962962962962963e1 * t920 + 0.13388493827160493827160493827160493827160493827161e1 * t923) * t56 - 0.60000000000000000000000000000000000000000000000000e1 * t241 * t734 * t56 + 0.57895126195293126240322668836661767023579398340984e3 * t160 * t797 * t96 - 0.24000000000000000000000000000000000000000000000000e2 * t193 * t797 * t56 + 0.42740000000000000000000000000000000000000000000000e0 * t41 * t240 * t86 * t57 - 0.34367190188705947437658206473318387813719215070744e1 * t41 * t92 * t86 * t96 * t52
  t964 = t763 + t819 + t866 + t962
  t978 = t606 * t418 * t333
  t981 = t606 * t498
  t982 = t981 * t418
  t1009 = t448 ** 2
  t1019 = t376 ** 2
  t1032 = -0.12494023105349794238683127572016460905349794238683e0 * t299 * s0 / t9 / t203 / t8 * t312 - 0.93705173290123456790123456790123456790123456790121e-1 * t577 * t400 - 0.64872812277777777777777777777777777777777777777776e-1 * t440 * t450 + 0.32436406138888888888888888888888888888888888888888e-1 * t440 * t454 - 0.38923687366666666666666666666666666666666666666665e-1 * t381 * t591 + 0.38923687366666666666666666666666666666666666666665e-1 * t299 * t380 * t20 * t599 - 0.64872812277777777777777777777777777777777777777776e-2 * t381 * t603 - 0.16681580299999999999999999999999999999999999999999e-1 * t301 * t303 * t5 / t586 / t309 * t1009 + 0.25022370449999999999999999999999999999999999999998e-1 * t595 * t596 * t587 * t448 * t376 - 0.41703950749999999999999999999999999999999999999998e-2 * t301 * t303 * t447 * t1019 - 0.55605267666666666666666666666666666666666666666664e-2 * t595 * t596 * t597 * t294 + 0.69506584583333333333333333333333333333333333333332e-3 * t301 * t303 * t386 * t964
  t1033 = t378 * t1032
  t1037 = 0.1e1 / t488 / t469
  t1038 = t471 ** 2
  t1039 = t1037 * t1038
  t1042 = t565 * t1038
  t1045 = t457 ** 2
  t1046 = t1045 * t333
  t1049 = t475 ** 2
  t1050 = t489 * t1049
  t1053 = t1045 * t498
  t1060 = t463 ** 2
  t1061 = t1060 * t333
  t1064 = t1060 * t498
  t1067 = 0.4e1 * t412 * t1033 - 0.720e3 * t563 * t1039 + 0.432e3 * t532 * t1042 - 0.15e2 * t431 * t1046 + 0.18e2 * t487 * t1050 + 0.60e2 * t510 * t1050 + 0.60e2 * t513 * t1053 - 0.2e1 * t421 * t1061 + 0.140e3 * t513 * t1064 - 0.20e2 * t431 * t978 - 0.6e1 * t518 * t458 + 0.24e2 * t503 * t982
  t1070 = t471 * t475
  t1073 = t1060 * t556
  t1076 = t542 * t1038
  t1079 = t470 * t1049
  t1084 = -t1032
  t1085 = t1084 * t333
  t1089 = t542 * t471 * t475
  t1095 = t470 * t612 * t403
  t1100 = t490 * t475
  t1103 = 0.3e1 * t409 * t1033 + 0.36e2 * t703 * t1070 - 0.360e3 * t554 * t1073 - 0.120e3 * t415 * t1076 - 0.12e2 * t405 * t1079 - 0.24e2 * t412 * t1079 - 0.5e1 * t431 * t1085 - 0.432e3 * t532 * t1089 - 0.32e2 * t412 * t1095 - 0.40e2 * t415 * t1095 + 0.180e3 * t415 * t1100 + 0.8e1 * t569 * t981
  t1112 = t463 * t556 * t457
  t1115 = t464 * t457
  t1125 = t498 ** 2
  t1136 = -0.72e2 * t322 * t1037 * t1038 - 0.24e2 * t296 * t542 * t1038 + 0.24e2 * t342 * t1060 * t1125 + 0.720e3 * t510 * t1042 + 0.6e1 * t525 * t1049 - 0.5e1 * t431 * t1061 + 0.36e2 * t694 * t1070 - 0.96e2 * t412 * t1076 - 0.18e2 * t409 * t1079 - 0.24e2 * t409 * t1095 - 0.144e3 * t633 * t1112 - 0.18e2 * t425 * t1115
  t1140 = t488 ** 2
  t1141 = 0.1e1 / t1140
  t1151 = t403 * t612
  t1169 = 0.24e2 * t325 * t1141 * t1038 - 0.3e1 * t332 * t1045 * t333 + 0.14e2 * t336 * t1060 * t498 - 0.36e2 * t339 * t1060 * t556 - t332 * t1084 * t333 + t379 * t1032 - 0.144e3 * t633 * t1073 - 0.3e1 * t425 * t1085 - 0.16e2 * t405 * t1095 + 0.144e3 * t412 * t1100 - 0.30e2 * t431 * t1115 + 0.8e1 * t525 * t1151 - 0.8e1 * t421 * t978
  t1187 = t457 * t463 * t498
  t1201 = t489 * t612 * t403
  t1204 = 0.120e3 * t345 * t334 * t1060 * t1125 + 0.72e2 * t319 * t565 * t1038 + 0.6e1 * t336 * t1045 * t498 - t332 * t1060 * t333 - 0.6e1 * t528 * t1049 + 0.42e2 * t503 * t1064 - 0.4e1 * t428 * t1085 - 0.216e3 * t487 * t1089 + 0.216e3 * t497 * t1187 + 0.360e3 * t513 * t1187 + 0.80e2 * t510 * t1201 + 0.80e2 * t513 * t982
  t1230 = t565 * t471 * t475
  t1233 = -0.36e2 * t339 * t463 * t556 * t457 - 0.288e3 * t652 * t1039 + 0.36e2 * t497 * t1053 - 0.3e1 * t425 * t1061 - 0.72e2 * t409 * t1076 - 0.2e1 * t421 * t1085 - 0.12e2 * t421 * t1115 + 0.108e3 * t503 * t1187 + 0.24e2 * t487 * t1201 + 0.144e3 * t652 * t1230 - 0.12e2 * t425 * t978 + 0.36e2 * t520 * t570
  t1259 = 0.2e1 * t405 * t1033 + 0.5e1 * t415 * t1033 - 0.6e1 * t421 * t1046 - 0.9e1 * t425 * t1046 + 0.84e2 * t497 * t1064 - 0.72e2 * t708 * t1070 - 0.48e2 * t405 * t1076 + 0.72e2 * t405 * t1100 + 0.108e3 * t409 * t1100 - 0.360e3 * t554 * t1112 + 0.48e2 * t532 * t1201 - 0.4e1 * t711 * t422
  t1288 = 0.120e3 * t328 * t317 * t1141 * t1038 + 0.216e3 * t487 * t1042 - 0.12e2 * t428 * t1046 + 0.36e2 * t532 * t1050 + 0.18e2 * t503 * t1053 - 0.4e1 * t428 * t1061 - 0.30e2 * t415 * t1079 - 0.720e3 * t510 * t1089 - 0.24e2 * t428 * t1115 - 0.8e1 * t528 * t1151 + 0.360e3 * t563 * t1230 - 0.16e2 * t428 * t978 + 0.48e2 * t497 * t982
  v4rho4_0_ = 0.4e1 * t294 * t348 + 0.12e2 * t376 * t434 + 0.12e2 * t398 * t538 + 0.4e1 * t309 * t720 + r0 * t964 * t348 + 0.4e1 * r0 * t294 * t434 + 0.6e1 * r0 * t376 * t538 + 0.4e1 * r0 * t398 * t720 + r0 * t309 * (t1067 + t1103 + t1136 + t1169 + t1204 + t1233 + t1259 + t1288)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t35 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t11 * t32
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t42 = 0.1e1 / t15 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t56 = t22 * t5 / t23 / t7
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t62 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * t60
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t77 = t76 * t72
  t78 = f.my_piecewise3(t73, t75, t77)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t82 = t81 * t79
  t83 = f.my_piecewise3(t80, t75, t82)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.621814e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.3109070e-1 * t91 * t100 + t104 - 0.19751673498613801407483339618206552048944131217655e-1 * t116
  t119 = t89 * t118
  t121 = 0.4e1 * t69 * t119
  t122 = t64 ** 2
  t124 = 0.1e1 / t67 / t7
  t125 = t122 * t124
  t127 = 0.4e1 * t125 * t119
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t146 = t96 ** 2
  t147 = 0.1e1 / t146
  t148 = t91 * t147
  t153 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t154 = 0.1e1 / t99
  t155 = t153 * t154
  t161 = t111 ** 2
  t162 = 0.1e1 / t161
  t163 = t106 * t162
  t168 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t169 = 0.1e1 / t114
  t170 = t168 * t169
  t173 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t11 * t100 + 0.10000000000000000000000000000000000000000000000000e1 * t148 * t155 - t35 - t62 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t11 * t115 + 0.58482236226346462072622386637590534819724553404280e0 * t163 * t170
  t174 = t89 * t173
  t175 = t128 * t174
  t178 = t89 * t1
  t180 = t43 * t10 * t115
  t182 = 0.18311447306006545054854346104378990962041954983034e-3 * t178 * t180
  t183 = t89 * t106
  t185 = t162 * t168 * t169
  t187 = 0.58482236226346462072622386637590534819724553404280e0 * t183 * t185
  t188 = t35 + t62 + t121 - t127 + t128 * t141 + t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t140 * t116 - t182 - t187
  t190 = params.sogga11_a[1]
  t191 = t74 ** 2
  t192 = t76 ** 2
  t193 = f.my_piecewise3(t73, t191, t192)
  t194 = t81 ** 2
  t195 = f.my_piecewise3(t80, t191, t194)
  t198 = t85 * (t193 / 0.2e1 + t195 / 0.2e1)
  t200 = s0 + 0.2e1 * s1 + s2
  t202 = 0.1e1 / t8 / t66
  t203 = t200 * t202
  t204 = t198 * t203
  t205 = 0.1e1 / t3
  t206 = t20 * t205
  t210 = -t104 + t128 * t119 + 0.19751673498613801407483339618206552048944131217655e-1 * t89 * t116
  t213 = t206 * t5 / t210
  t215 = 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t213
  t216 = 0.1e1 - t215
  t218 = 0.1e1 - 0.1e1 / t216
  t220 = params.sogga11_a[2]
  t221 = t218 ** 2
  t223 = params.sogga11_a[3]
  t224 = t221 * t218
  t226 = params.sogga11_a[4]
  t227 = t221 ** 2
  t229 = params.sogga11_a[5]
  t233 = params.sogga11_b[1]
  t234 = jnp.exp(t215)
  t235 = 0.1e1 - t234
  t237 = params.sogga11_b[2]
  t238 = t235 ** 2
  t240 = params.sogga11_b[3]
  t241 = t238 * t235
  t243 = params.sogga11_b[4]
  t244 = t238 ** 2
  t246 = params.sogga11_b[5]
  t249 = t229 * t227 * t218 + t246 * t244 * t235 + t190 * t218 + t220 * t221 + t223 * t224 + t226 * t227 + t233 * t235 + t237 * t238 + t240 * t241 + t243 * t244 + params.sogga11_a[0] + params.sogga11_b[0]
  t250 = t188 * t249
  t252 = t216 ** 2
  t253 = 0.1e1 / t252
  t254 = t190 * t253
  t255 = 0.1e1 / t76
  t258 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t255 * t131)
  t259 = 0.1e1 / t81
  t262 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t259 * t135)
  t265 = t85 * (t258 / 0.2e1 + t262 / 0.2e1)
  t266 = t265 * t203
  t269 = t66 * t7
  t272 = t200 / t8 / t269
  t273 = t198 * t272
  t275 = 0.16218203069444444444444444444444444444444444444444e-2 * t273 * t213
  t276 = t210 ** 2
  t278 = t5 / t276
  t280 = t206 * t278 * t188
  t283 = -0.69506584583333333333333333333333333333333333333332e-3 * t266 * t213 + t275 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t280
  t285 = t220 * t218
  t286 = t253 * t283
  t289 = t223 * t221
  t292 = t226 * t224
  t295 = t229 * t227
  t298 = -t283
  t301 = t237 * t235
  t302 = t298 * t234
  t305 = t240 * t238
  t308 = t243 * t241
  t311 = t246 * t244
  t314 = -t233 * t298 * t234 + t254 * t283 + 0.2e1 * t285 * t286 + 0.3e1 * t289 * t286 + 0.4e1 * t292 * t286 + 0.5e1 * t295 * t286 - 0.2e1 * t301 * t302 - 0.3e1 * t305 * t302 - 0.4e1 * t308 * t302 - 0.5e1 * t311 * t302
  t315 = t210 * t314
  t317 = t161 ** 2
  t318 = 0.1e1 / t317
  t319 = t168 ** 2
  t321 = t114 ** 2
  t322 = 0.1e1 / t321
  t325 = 0.17315859105681463759666483083807725165579399831905e2 * t183 * t318 * t319 * t322
  t327 = t140 * t106 * t185
  t334 = 0.1e1 / t23 / t66
  t335 = t21 * t5 * t334
  t336 = 0.1e1 / t15 / t14 * t20 * t335
  t338 = t43 * t202
  t339 = t42 * t338
  t341 = t6 * t202
  t342 = t4 * t341
  t344 = t14 ** (-0.5e0)
  t346 = t344 * t20 * t335
  t348 = t50 * t338
  t351 = t22 * t5 * t334
  t353 = -0.57538888888888888888888888888888888888888888888889e0 * t336 + 0.11507777777777777777777777777777777777777777777778e1 * t339 + 0.40256666666666666666666666666666666666666666666667e0 * t342 + 0.36677500000000000000000000000000000000000000000000e-1 * t346 + 0.73355000000000000000000000000000000000000000000000e-1 * t348 + 0.13797500000000000000000000000000000000000000000000e0 * t351
  t357 = 0.58482236226346462072622386637590534819724553404280e0 * t183 * t162 * t353 * t169
  t361 = t4 * t6
  t369 = t153 ** 2
  t383 = t146 ** 2
  t386 = t99 ** 2
  t393 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t341 * t32
  t397 = 0.35616666666666666666666666666666666666666666666666e-1 * t361 * t10 * t39 * t60
  t401 = t58 ** 2
  t404 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t401 * t59
  t414 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t336 + 0.84396666666666666666666666666666666666666666666666e0 * t339 + 0.39862222222222222222222222222222222222222222222223e0 * t342 + 0.68258333333333333333333333333333333333333333333333e-1 * t346 + 0.13651666666666666666666666666666666666666666666667e0 * t348 + 0.13692777777777777777777777777777777777777777777778e0 * t351) * t59
  t415 = t38 ** 2
  t418 = t31 ** 2
  t422 = 0.16081979498692535066756296899072713062105388428051e2 * t37 / t415 * t401 / t418
  t431 = 0.1e1 / t161 / t111
  t443 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t341 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t361 * t10 * t147 * t155 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t146 / t96 * t369 * t154 + 0.10000000000000000000000000000000000000000000000000e1 * t148 * (-0.78438333333333333333333333333333333333333333333333e0 * t336 + 0.15687666666666666666666666666666666666666666666667e1 * t339 + 0.68863333333333333333333333333333333333333333333333e0 * t342 + 0.14025833333333333333333333333333333333333333333333e0 * t346 + 0.28051666666666666666666666666666666666666666666667e0 * t348 + 0.17365833333333333333333333333333333333333333333333e0 * t351) * t154 + 0.32163958997385070133512593798145426124210776856102e2 * t91 / t383 * t369 / t386 + t393 + t397 + t404 - t414 - t422 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t341 * t115 - 0.10843581300301739842632067522386578331157260943710e-1 * t361 * t10 * t162 * t170 - 0.11696447245269292414524477327518106963944910680856e1 * t106 * t431 * t319 * t169 + 0.58482236226346462072622386637590534819724553404280e0 * t163 * t353 * t169 + 0.17315859105681463759666483083807725165579399831905e2 * t106 * t318 * t319 * t322
  t445 = t128 * t89 * t443
  t446 = 0.1e1 / t192
  t447 = t131 ** 2
  t450 = 0.1e1 / t269
  t451 = t63 * t450
  t453 = -0.2e1 * t129 + 0.2e1 * t451
  t457 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t446 * t447 + 0.4e1 / 0.3e1 * t76 * t453)
  t458 = 0.1e1 / t194
  t459 = t135 ** 2
  t462 = -t453
  t466 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t458 * t459 + 0.4e1 / 0.3e1 * t81 * t462)
  t468 = (t457 + t466) * t88
  t472 = t128 * t140 * t173
  t474 = t125 * t141
  t477 = 0.8e1 * t125 * t174
  t478 = t69 * t141
  t481 = 0.8e1 * t69 * t174
  t482 = -t325 - 0.11696447245269292414524477327518106963944910680856e1 * t327 - t357 + t445 + t128 * t468 * t118 + 0.2e1 * t472 - 0.8e1 * t474 - t477 + 0.8e1 * t478 + t481 - t404
  t487 = 0.20e2 * t122 / t67 / t66 * t119
  t490 = 0.12e2 * t64 * t68 * t119
  t493 = 0.32e2 * t65 * t124 * t119
  t495 = t140 * t1 * t180
  t500 = 0.11696447245269292414524477327518106963944910680856e1 * t183 * t431 * t319 * t169
  t504 = 0.10843581300301739842632067522386578331157260943710e-1 * t89 * t4 * t11 * t185
  t508 = 0.24415263074675393406472461472505321282722606644045e-3 * t178 * t43 * t202 * t115
  t511 = t487 + t490 - t493 - t393 + t414 + t422 - 0.36622894612013090109708692208757981924083909966068e-3 * t495 + t500 - t397 + t504 + t508 + 0.19751673498613801407483339618206552048944131217655e-1 * t468 * t116
  t512 = t482 + t511
  t515 = t7 * t188
  t518 = t7 * t210
  t519 = 0.1e1 / t77
  t525 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t519 * t447 + 0.2e1 / 0.3e1 * t255 * t453)
  t526 = 0.1e1 / t82
  t532 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t526 * t459 + 0.2e1 / 0.3e1 * t259 * t462)
  t540 = t265 * t272 * t213
  t549 = 0.54060676898148148148148148148148148148148148148147e-2 * t198 * t200 / t8 / t67 * t213
  t550 = t273 * t280
  t553 = 0.1e1 / t276 / t210
  t554 = t5 * t553
  t555 = t188 ** 2
  t564 = -0.69506584583333333333333333333333333333333333333332e-3 * t85 * (t525 / 0.2e1 + t532 / 0.2e1) * t203 * t213 + 0.32436406138888888888888888888888888888888888888888e-2 * t540 + 0.13901316916666666666666666666666666666666666666666e-2 * t266 * t280 - t549 - 0.32436406138888888888888888888888888888888888888888e-2 * t550 - 0.13901316916666666666666666666666666666666666666666e-2 * t204 * t206 * t554 * t555 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t206 * t278 * t512
  t565 = t253 * t564
  t569 = 0.1e1 / t252 / t216
  t570 = t283 ** 2
  t571 = t569 * t570
  t574 = -t564
  t575 = t574 * t234
  t578 = t246 * t241
  t579 = t298 ** 2
  t580 = t234 ** 2
  t581 = t579 * t580
  t588 = t240 * t235
  t591 = t190 * t569
  t594 = t229 * t224
  t595 = t252 ** 2
  t596 = 0.1e1 / t595
  t597 = t596 * t570
  t600 = t223 * t218
  t603 = t226 * t221
  t612 = -t233 * t579 * t234 + 0.3e1 * t289 * t565 - 0.8e1 * t292 * t571 + 0.5e1 * t295 * t565 - 0.10e2 * t295 * t571 - 0.2e1 * t301 * t575 - 0.4e1 * t308 * t575 - 0.5e1 * t311 * t575 - 0.2e1 * t591 * t570 + 0.20e2 * t578 * t581 + 0.6e1 * t588 * t581 + 0.20e2 * t594 * t597 + 0.6e1 * t600 * t597 + 0.12e2 * t603 * t597
  t613 = t220 * t596
  t621 = t579 * t234
  t640 = t243 * t238
  t644 = -t233 * t574 * t234 + 0.2e1 * t237 * t579 * t580 + t254 * t564 + 0.2e1 * t285 * t565 - 0.4e1 * t285 * t571 - 0.6e1 * t289 * t571 + 0.4e1 * t292 * t565 - 0.2e1 * t301 * t621 - 0.3e1 * t305 * t575 - 0.3e1 * t305 * t621 - 0.4e1 * t308 * t621 - 0.5e1 * t311 * t621 + 0.2e1 * t613 * t570 + 0.12e2 * t640 * t581
  d11 = 0.2e1 * t250 + 0.2e1 * t315 + t7 * t512 * t249 + 0.2e1 * t515 * t314 + t518 * (t612 + t644)
  t647 = -t70 - t130
  t650 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t647)
  t651 = -t647
  t654 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t651)
  t656 = (t650 + t654) * t88
  t657 = t656 * t118
  t661 = t35 + t62 - t121 - t127 + t128 * t657 + t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t656 * t116 - t182 - t187
  t662 = t661 * t249
  t663 = t69 * t657
  t665 = t125 * t657
  t674 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t446 * t647 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t450)
  t682 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t458 * t651 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t450)
  t684 = (t674 + t682) * t88
  t688 = t128 * t656 * t173
  t691 = t656 * t106 * t185
  t694 = 0.4e1 * t663 - 0.4e1 * t665 + t128 * t684 * t118 + t688 - t477 - 0.4e1 * t478 - t404 - t357 - 0.58482236226346462072622386637590534819724553404280e0 * t691 + t414 + t422 - t397 - 0.18311447306006545054854346104378990962041954983034e-3 * t495
  t696 = t656 * t1 * t180
  t702 = t508 + t487 - t490 + t500 - 0.18311447306006545054854346104378990962041954983034e-3 * t696 - t393 - t325 - 0.58482236226346462072622386637590534819724553404280e0 * t327 + t445 + t504 + 0.19751673498613801407483339618206552048944131217655e-1 * t684 * t116 + t472 - 0.4e1 * t474
  t703 = t694 + t702
  t706 = t7 * t661
  t710 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t255 * t647)
  t713 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t259 * t651)
  t716 = t85 * (t710 / 0.2e1 + t713 / 0.2e1)
  t717 = t716 * t203
  t721 = t206 * t278 * t661
  t724 = -0.69506584583333333333333333333333333333333333333332e-3 * t717 * t213 + t275 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t721
  t726 = t253 * t724
  t735 = -t724
  t736 = t233 * t735
  t738 = t735 * t234
  t747 = -t736 * t234 + t254 * t724 + 0.2e1 * t285 * t726 + 0.3e1 * t289 * t726 + 0.4e1 * t292 * t726 + 0.5e1 * t295 * t726 - 0.2e1 * t301 * t738 - 0.3e1 * t305 * t738 - 0.4e1 * t308 * t738 - 0.5e1 * t311 * t738
  t748 = t210 * t747
  t757 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t519 * t647 * t131 + 0.4e1 / 0.3e1 * t255 * t63 * t450)
  t765 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t526 * t651 * t135 - 0.4e1 / 0.3e1 * t259 * t63 * t450)
  t773 = t716 * t272 * t213
  t781 = t273 * t721
  t795 = 0.69506584583333333333333333333333333333333333333332e-3 * t85 * (t757 / 0.2e1 + t765 / 0.2e1) * t203 * t213 - 0.16218203069444444444444444444444444444444444444444e-2 * t773 - 0.69506584583333333333333333333333333333333333333332e-3 * t717 * t280 - 0.16218203069444444444444444444444444444444444444444e-2 * t540 + t549 + 0.16218203069444444444444444444444444444444444444444e-2 * t550 - 0.69506584583333333333333333333333333333333333333332e-3 * t266 * t721 + 0.16218203069444444444444444444444444444444444444444e-2 * t781 + 0.13901316916666666666666666666666666666666666666666e-2 * t198 * t203 * t20 * t205 * t5 * t553 * t661 * t188 - 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t206 * t278 * t703
  t796 = t795 * t234
  t799 = -t795
  t800 = t253 * t799
  t804 = t569 * t724 * t283
  t812 = t596 * t724 * t283
  t815 = t735 * t580
  t816 = t815 * t298
  t829 = t735 * t298 * t234
  t835 = -t233 * t795 * t234 + 0.2e1 * t237 * t298 * t815 + t254 * t799 - 0.4e1 * t285 * t804 + 0.3e1 * t289 * t800 - 0.6e1 * t289 * t804 + 0.5e1 * t295 * t800 - 0.2e1 * t301 * t829 - 0.3e1 * t305 * t796 - 0.4e1 * t308 * t796 + 0.6e1 * t588 * t816 + 0.20e2 * t594 * t812 + 0.6e1 * t600 * t812 + 0.12e2 * t640 * t816
  t838 = t283 * t724
  t864 = 0.2e1 * t285 * t800 + 0.4e1 * t292 * t800 - 0.8e1 * t292 * t804 - 0.10e2 * t295 * t804 - 0.2e1 * t301 * t796 - t736 * t302 - 0.3e1 * t305 * t829 - 0.4e1 * t308 * t829 - 0.5e1 * t311 * t796 - 0.5e1 * t311 * t829 + 0.20e2 * t578 * t816 - 0.2e1 * t591 * t838 + 0.12e2 * t603 * t812 + 0.2e1 * t613 * t838
  d12 = t250 + t315 + t662 + t7 * t703 * t249 + t706 * t314 + t748 + t515 * t747 + t518 * (t835 + t864)
  t871 = -t393 + t508 - t404 + t490 - 0.8e1 * t665 - t477 - t357 - t325 + t493 - 0.36622894612013090109708692208757981924083909966068e-3 * t696 + t500
  t874 = t647 ** 2
  t878 = 0.2e1 * t129 + 0.2e1 * t451
  t882 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t446 * t874 + 0.4e1 / 0.3e1 * t76 * t878)
  t883 = t651 ** 2
  t886 = -t878
  t890 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t458 * t883 + 0.4e1 / 0.3e1 * t81 * t886)
  t892 = (t882 + t890) * t88
  t898 = -0.11696447245269292414524477327518106963944910680856e1 * t691 + t445 + t422 - t397 + t414 + t487 - 0.8e1 * t663 - t481 + 0.19751673498613801407483339618206552048944131217655e-1 * t892 * t116 + t504 + t128 * t892 * t118 + 0.2e1 * t688
  t899 = t871 + t898
  t904 = t724 ** 2
  t907 = t735 ** 2
  t915 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t519 * t874 + 0.2e1 / 0.3e1 * t255 * t878)
  t921 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t526 * t883 + 0.2e1 / 0.3e1 * t259 * t886)
  t932 = t661 ** 2
  t941 = -0.69506584583333333333333333333333333333333333333332e-3 * t85 * (t915 / 0.2e1 + t921 / 0.2e1) * t203 * t213 + 0.32436406138888888888888888888888888888888888888888e-2 * t773 + 0.13901316916666666666666666666666666666666666666666e-2 * t717 * t721 - t549 - 0.32436406138888888888888888888888888888888888888888e-2 * t781 - 0.13901316916666666666666666666666666666666666666666e-2 * t204 * t206 * t554 * t932 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t206 * t278 * t899
  t943 = t569 * t904
  t946 = t253 * t941
  t949 = t907 * t234
  t952 = t907 * t580
  t955 = t596 * t904
  t970 = -t233 * t907 * t234 + t254 * t941 - 0.4e1 * t285 * t943 - 0.6e1 * t289 * t943 + 0.3e1 * t289 * t946 - 0.10e2 * t295 * t943 + 0.5e1 * t295 * t946 - 0.2e1 * t301 * t949 - 0.3e1 * t305 * t949 + 0.20e2 * t578 * t952 + 0.6e1 * t588 * t952 + 0.6e1 * t600 * t955 + 0.12e2 * t603 * t955 + 0.2e1 * t613 * t904
  t971 = -t941
  t972 = t971 * t234
  t1002 = -t233 * t971 * t234 + 0.2e1 * t237 * t907 * t580 + 0.2e1 * t285 * t946 - 0.8e1 * t292 * t943 + 0.4e1 * t292 * t946 - 0.2e1 * t301 * t972 - 0.3e1 * t305 * t972 - 0.4e1 * t308 * t949 - 0.4e1 * t308 * t972 - 0.5e1 * t311 * t949 - 0.5e1 * t311 * t972 - 0.2e1 * t591 * t904 + 0.20e2 * t594 * t955 + 0.12e2 * t640 * t952
  d22 = 0.2e1 * t662 + 0.2e1 * t748 + t7 * t899 * t249 + 0.2e1 * t706 * t747 + t518 * (t970 + t1002)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t35 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t11 * t32
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t42 = 0.1e1 / t15 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t56 = t22 * t5 / t23 / t7
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t62 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * t60
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t77 = t76 * t72
  t78 = f.my_piecewise3(t73, t75, t77)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t82 = t81 * t79
  t83 = f.my_piecewise3(t80, t75, t82)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.621814e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.3109070e-1 * t91 * t100 + t104 - 0.19751673498613801407483339618206552048944131217655e-1 * t116
  t119 = t89 * t118
  t121 = 0.4e1 * t69 * t119
  t122 = t64 ** 2
  t124 = 0.1e1 / t67 / t7
  t125 = t122 * t124
  t127 = 0.4e1 * t125 * t119
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t146 = t96 ** 2
  t147 = 0.1e1 / t146
  t148 = t91 * t147
  t153 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t154 = 0.1e1 / t99
  t155 = t153 * t154
  t161 = t111 ** 2
  t162 = 0.1e1 / t161
  t163 = t106 * t162
  t168 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t169 = 0.1e1 / t114
  t170 = t168 * t169
  t173 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t11 * t100 + 0.10000000000000000000000000000000000000000000000000e1 * t148 * t155 - t35 - t62 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t11 * t115 + 0.58482236226346462072622386637590534819724553404280e0 * t163 * t170
  t174 = t89 * t173
  t175 = t128 * t174
  t178 = t89 * t1
  t180 = t43 * t10 * t115
  t182 = 0.18311447306006545054854346104378990962041954983034e-3 * t178 * t180
  t183 = t89 * t106
  t185 = t162 * t168 * t169
  t187 = 0.58482236226346462072622386637590534819724553404280e0 * t183 * t185
  t188 = t35 + t62 + t121 - t127 + t128 * t141 + t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t140 * t116 - t182 - t187
  t190 = params.sogga11_a[1]
  t191 = t74 ** 2
  t192 = t76 ** 2
  t193 = f.my_piecewise3(t73, t191, t192)
  t194 = t81 ** 2
  t195 = f.my_piecewise3(t80, t191, t194)
  t198 = t85 * (t193 / 0.2e1 + t195 / 0.2e1)
  t200 = s0 + 0.2e1 * s1 + s2
  t202 = 0.1e1 / t8 / t66
  t203 = t200 * t202
  t204 = t198 * t203
  t205 = 0.1e1 / t3
  t206 = t20 * t205
  t210 = -t104 + t128 * t119 + 0.19751673498613801407483339618206552048944131217655e-1 * t89 * t116
  t213 = t206 * t5 / t210
  t215 = 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t213
  t216 = 0.1e1 - t215
  t218 = 0.1e1 - 0.1e1 / t216
  t220 = params.sogga11_a[2]
  t221 = t218 ** 2
  t223 = params.sogga11_a[3]
  t224 = t221 * t218
  t226 = params.sogga11_a[4]
  t227 = t221 ** 2
  t229 = params.sogga11_a[5]
  t233 = params.sogga11_b[1]
  t234 = jnp.exp(t215)
  t235 = 0.1e1 - t234
  t237 = params.sogga11_b[2]
  t238 = t235 ** 2
  t240 = params.sogga11_b[3]
  t241 = t238 * t235
  t243 = params.sogga11_b[4]
  t244 = t238 ** 2
  t246 = params.sogga11_b[5]
  t249 = t229 * t227 * t218 + t246 * t244 * t235 + t190 * t218 + t220 * t221 + t223 * t224 + t226 * t227 + t233 * t235 + t237 * t238 + t240 * t241 + t243 * t244 + params.sogga11_a[0] + params.sogga11_b[0]
  t250 = t188 * t249
  t252 = t216 ** 2
  t253 = 0.1e1 / t252
  t254 = t190 * t253
  t255 = 0.1e1 / t76
  t258 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t255 * t131)
  t259 = 0.1e1 / t81
  t262 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t259 * t135)
  t265 = t85 * (t258 / 0.2e1 + t262 / 0.2e1)
  t266 = t265 * t203
  t269 = t66 * t7
  t272 = t200 / t8 / t269
  t273 = t198 * t272
  t275 = 0.16218203069444444444444444444444444444444444444444e-2 * t273 * t213
  t276 = t210 ** 2
  t278 = t5 / t276
  t280 = t206 * t278 * t188
  t283 = -0.69506584583333333333333333333333333333333333333332e-3 * t266 * t213 + t275 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t280
  t285 = t220 * t218
  t286 = t253 * t283
  t289 = t223 * t221
  t292 = t226 * t224
  t295 = t229 * t227
  t298 = -t283
  t301 = t237 * t235
  t302 = t298 * t234
  t305 = t240 * t238
  t308 = t243 * t241
  t311 = t246 * t244
  t314 = -t233 * t298 * t234 + t254 * t283 + 0.2e1 * t285 * t286 + 0.3e1 * t289 * t286 + 0.4e1 * t292 * t286 + 0.5e1 * t295 * t286 - 0.2e1 * t301 * t302 - 0.3e1 * t305 * t302 - 0.4e1 * t308 * t302 - 0.5e1 * t311 * t302
  t315 = t210 * t314
  t317 = t6 * t202
  t321 = t4 * t6
  t329 = t153 ** 2
  t338 = 0.1e1 / t23 / t66
  t339 = t21 * t5 * t338
  t340 = 0.1e1 / t15 / t14 * t20 * t339
  t342 = t43 * t202
  t343 = t42 * t342
  t345 = t4 * t317
  t347 = t14 ** (-0.5e0)
  t349 = t347 * t20 * t339
  t351 = t50 * t342
  t354 = t22 * t5 * t338
  t360 = t146 ** 2
  t363 = t99 ** 2
  t370 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t317 * t32
  t374 = 0.35616666666666666666666666666666666666666666666666e-1 * t321 * t10 * t39 * t60
  t378 = t58 ** 2
  t381 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t378 * t59
  t391 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t340 + 0.84396666666666666666666666666666666666666666666666e0 * t343 + 0.39862222222222222222222222222222222222222222222223e0 * t345 + 0.68258333333333333333333333333333333333333333333333e-1 * t349 + 0.13651666666666666666666666666666666666666666666667e0 * t351 + 0.13692777777777777777777777777777777777777777777778e0 * t354) * t59
  t392 = t38 ** 2
  t395 = t31 ** 2
  t399 = 0.16081979498692535066756296899072713062105388428051e2 * t37 / t392 * t378 / t395
  t408 = 0.1e1 / t161 / t111
  t410 = t168 ** 2
  t420 = -0.57538888888888888888888888888888888888888888888889e0 * t340 + 0.11507777777777777777777777777777777777777777777778e1 * t343 + 0.40256666666666666666666666666666666666666666666667e0 * t345 + 0.36677500000000000000000000000000000000000000000000e-1 * t349 + 0.73355000000000000000000000000000000000000000000000e-1 * t351 + 0.13797500000000000000000000000000000000000000000000e0 * t354
  t424 = t161 ** 2
  t425 = 0.1e1 / t424
  t427 = t114 ** 2
  t428 = 0.1e1 / t427
  t432 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t317 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t321 * t10 * t147 * t155 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t146 / t96 * t329 * t154 + 0.10000000000000000000000000000000000000000000000000e1 * t148 * (-0.78438333333333333333333333333333333333333333333333e0 * t340 + 0.15687666666666666666666666666666666666666666666667e1 * t343 + 0.68863333333333333333333333333333333333333333333333e0 * t345 + 0.14025833333333333333333333333333333333333333333333e0 * t349 + 0.28051666666666666666666666666666666666666666666667e0 * t351 + 0.17365833333333333333333333333333333333333333333333e0 * t354) * t154 + 0.32163958997385070133512593798145426124210776856102e2 * t91 / t360 * t329 / t363 + t370 + t374 + t381 - t391 - t399 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t317 * t115 - 0.10843581300301739842632067522386578331157260943710e-1 * t321 * t10 * t162 * t170 - 0.11696447245269292414524477327518106963944910680856e1 * t106 * t408 * t410 * t169 + 0.58482236226346462072622386637590534819724553404280e0 * t163 * t420 * t169 + 0.17315859105681463759666483083807725165579399831905e2 * t106 * t425 * t410 * t428
  t434 = t128 * t89 * t432
  t435 = 0.1e1 / t192
  t436 = t131 ** 2
  t439 = 0.1e1 / t269
  t440 = t63 * t439
  t442 = -0.2e1 * t129 + 0.2e1 * t440
  t446 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t435 * t436 + 0.4e1 / 0.3e1 * t76 * t442)
  t447 = 0.1e1 / t194
  t448 = t135 ** 2
  t451 = -t442
  t455 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t447 * t448 + 0.4e1 / 0.3e1 * t81 * t451)
  t457 = (t446 + t455) * t88
  t461 = t128 * t140 * t173
  t463 = t125 * t141
  t466 = 0.8e1 * t125 * t174
  t467 = t69 * t141
  t470 = 0.8e1 * t69 * t174
  t475 = 0.20e2 * t122 / t67 / t66 * t119
  t478 = 0.12e2 * t64 * t68 * t119
  t481 = 0.32e2 * t65 * t124 * t119
  t482 = t128 * t457 * t118 - t381 + t434 + 0.2e1 * t461 - 0.8e1 * t463 - t466 + 0.8e1 * t467 + t470 + t475 + t478 - t481
  t484 = t140 * t1 * t180
  t489 = 0.11696447245269292414524477327518106963944910680856e1 * t183 * t408 * t410 * t169
  t493 = 0.10843581300301739842632067522386578331157260943710e-1 * t89 * t4 * t11 * t185
  t499 = 0.17315859105681463759666483083807725165579399831905e2 * t183 * t425 * t410 * t428
  t501 = t140 * t106 * t185
  t506 = 0.58482236226346462072622386637590534819724553404280e0 * t183 * t162 * t420 * t169
  t510 = 0.24415263074675393406472461472505321282722606644045e-3 * t178 * t43 * t202 * t115
  t511 = -t370 + t391 + t399 - 0.36622894612013090109708692208757981924083909966068e-3 * t484 + t489 - t374 + t493 + 0.19751673498613801407483339618206552048944131217655e-1 * t457 * t116 - t499 - 0.11696447245269292414524477327518106963944910680856e1 * t501 - t506 + t510
  t512 = t482 + t511
  t515 = t7 * t188
  t518 = t7 * t210
  t519 = 0.1e1 / t77
  t525 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t519 * t436 + 0.2e1 / 0.3e1 * t255 * t442)
  t526 = 0.1e1 / t82
  t532 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t526 * t448 + 0.2e1 / 0.3e1 * t259 * t451)
  t540 = t265 * t272 * t213
  t549 = 0.54060676898148148148148148148148148148148148148147e-2 * t198 * t200 / t8 / t67 * t213
  t550 = t273 * t280
  t553 = 0.1e1 / t276 / t210
  t554 = t5 * t553
  t555 = t188 ** 2
  t564 = 0.69506584583333333333333333333333333333333333333332e-3 * t85 * (t525 / 0.2e1 + t532 / 0.2e1) * t203 * t213 - 0.32436406138888888888888888888888888888888888888888e-2 * t540 - 0.13901316916666666666666666666666666666666666666666e-2 * t266 * t280 + t549 + 0.32436406138888888888888888888888888888888888888888e-2 * t550 + 0.13901316916666666666666666666666666666666666666666e-2 * t204 * t206 * t554 * t555 - 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t206 * t278 * t512
  t565 = t564 * t234
  t568 = -t564
  t569 = t253 * t568
  t572 = t226 * t221
  t573 = t252 ** 2
  t574 = 0.1e1 / t573
  t575 = t283 ** 2
  t576 = t574 * t575
  t580 = 0.1e1 / t252 / t216
  t581 = t580 * t575
  t584 = t240 * t235
  t585 = t298 ** 2
  t586 = t234 ** 2
  t587 = t585 * t586
  t590 = t585 * t234
  t605 = t246 * t241
  t608 = t243 * t238
  t611 = -0.4e1 * t285 * t581 + 0.3e1 * t289 * t569 - 0.8e1 * t292 * t581 - 0.10e2 * t295 * t581 - 0.2e1 * t301 * t565 - 0.2e1 * t301 * t590 - 0.3e1 * t305 * t590 - 0.4e1 * t308 * t590 - 0.5e1 * t311 * t565 - 0.5e1 * t311 * t590 + 0.12e2 * t572 * t576 + 0.6e1 * t584 * t587 + 0.20e2 * t605 * t587 + 0.12e2 * t608 * t587
  t618 = t229 * t224
  t628 = t220 * t574
  t631 = t223 * t218
  t635 = t190 * t580
  t644 = -t233 * t564 * t234 - t233 * t585 * t234 + 0.2e1 * t237 * t585 * t586 + t254 * t568 + 0.2e1 * t285 * t569 - 0.6e1 * t289 * t581 + 0.4e1 * t292 * t569 + 0.5e1 * t295 * t569 - 0.3e1 * t305 * t565 - 0.4e1 * t308 * t565 + 0.2e1 * t628 * t575 - 0.2e1 * t635 * t575 + 0.20e2 * t618 * t576 + 0.6e1 * t631 * t576
  d11 = 0.2e1 * t250 + 0.2e1 * t315 + t7 * t512 * t249 + 0.2e1 * t515 * t314 + t518 * (t611 + t644)
  t647 = -t70 - t130
  t650 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t647)
  t651 = -t647
  t654 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t651)
  t656 = (t650 + t654) * t88
  t657 = t656 * t118
  t661 = t35 + t62 - t121 - t127 + t128 * t657 + t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t656 * t116 - t182 - t187
  t662 = t661 * t249
  t671 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t435 * t647 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t439)
  t679 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t447 * t651 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t439)
  t681 = (t671 + t679) * t88
  t685 = t128 * t656 * t173
  t687 = -t466 - 0.4e1 * t467 + t399 + t128 * t681 * t118 + t685 - t381 + t391 - t374 - 0.18311447306006545054854346104378990962041954983034e-3 * t484 + t510 - t370 + t489 - t499
  t691 = t656 * t106 * t185
  t694 = t656 * t1 * t180
  t698 = t69 * t657
  t700 = t125 * t657
  t702 = -0.58482236226346462072622386637590534819724553404280e0 * t501 - t506 + t434 + t461 - 0.4e1 * t463 + t493 - 0.58482236226346462072622386637590534819724553404280e0 * t691 + t475 - t478 - 0.18311447306006545054854346104378990962041954983034e-3 * t694 + 0.19751673498613801407483339618206552048944131217655e-1 * t681 * t116 + 0.4e1 * t698 - 0.4e1 * t700
  t703 = t687 + t702
  t706 = t7 * t661
  t710 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t255 * t647)
  t713 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t259 * t651)
  t716 = t85 * (t710 / 0.2e1 + t713 / 0.2e1)
  t717 = t716 * t203
  t721 = t206 * t278 * t661
  t724 = -0.69506584583333333333333333333333333333333333333332e-3 * t717 * t213 + t275 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t721
  t726 = t253 * t724
  t735 = -t724
  t736 = t233 * t735
  t738 = t735 * t234
  t747 = -t736 * t234 + t254 * t724 + 0.2e1 * t285 * t726 + 0.3e1 * t289 * t726 + 0.4e1 * t292 * t726 + 0.5e1 * t295 * t726 - 0.2e1 * t301 * t738 - 0.3e1 * t305 * t738 - 0.4e1 * t308 * t738 - 0.5e1 * t311 * t738
  t748 = t210 * t747
  t750 = t724 * t283
  t754 = t574 * t724 * t283
  t759 = t735 * t586
  t760 = t759 * t298
  t770 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t519 * t647 * t131 + 0.4e1 / 0.3e1 * t255 * t63 * t439)
  t778 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t526 * t651 * t135 - 0.4e1 / 0.3e1 * t259 * t63 * t439)
  t786 = t716 * t272 * t213
  t794 = t273 * t721
  t808 = -0.69506584583333333333333333333333333333333333333332e-3 * t85 * (t770 / 0.2e1 + t778 / 0.2e1) * t203 * t213 + 0.16218203069444444444444444444444444444444444444444e-2 * t786 + 0.69506584583333333333333333333333333333333333333332e-3 * t717 * t280 + 0.16218203069444444444444444444444444444444444444444e-2 * t540 - t549 - 0.16218203069444444444444444444444444444444444444444e-2 * t550 + 0.69506584583333333333333333333333333333333333333332e-3 * t266 * t721 - 0.16218203069444444444444444444444444444444444444444e-2 * t794 - 0.13901316916666666666666666666666666666666666666666e-2 * t198 * t203 * t20 * t205 * t5 * t553 * t661 * t188 + 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t206 * t278 * t703
  t809 = t253 * t808
  t813 = t735 * t298 * t234
  t819 = t580 * t724 * t283
  t826 = -t808
  t827 = t826 * t234
  t836 = -0.4e1 * t285 * t819 + 0.3e1 * t289 * t809 - 0.6e1 * t289 * t819 - 0.8e1 * t292 * t819 + 0.5e1 * t295 * t809 - 0.10e2 * t295 * t819 - 0.2e1 * t301 * t813 - 0.2e1 * t301 * t827 - 0.5e1 * t311 * t813 + 0.12e2 * t572 * t754 + 0.6e1 * t584 * t760 + 0.20e2 * t605 * t760 + 0.2e1 * t628 * t750 - 0.2e1 * t635 * t750
  t864 = -t233 * t826 * t234 + 0.2e1 * t237 * t298 * t759 + t254 * t808 + 0.2e1 * t285 * t809 + 0.4e1 * t292 * t809 - t736 * t302 - 0.3e1 * t305 * t813 - 0.3e1 * t305 * t827 - 0.4e1 * t308 * t813 - 0.4e1 * t308 * t827 - 0.5e1 * t311 * t827 + 0.12e2 * t608 * t760 + 0.20e2 * t618 * t754 + 0.6e1 * t631 * t754
  d12 = t250 + t315 + t662 + t7 * t703 * t249 + t706 * t314 + t748 + t515 * t747 + t518 * (t836 + t864)
  t870 = t647 ** 2
  t874 = 0.2e1 * t129 + 0.2e1 * t440
  t878 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t435 * t870 + 0.4e1 / 0.3e1 * t76 * t874)
  t879 = t651 ** 2
  t882 = -t874
  t886 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t447 * t879 + 0.4e1 / 0.3e1 * t81 * t882)
  t888 = (t878 + t886) * t88
  t892 = t478 - 0.8e1 * t700 - t466 + 0.19751673498613801407483339618206552048944131217655e-1 * t888 * t116 - 0.8e1 * t698 - t470 - t381 - t506 - t499 - t374 - t370
  t898 = t475 + t481 - 0.11696447245269292414524477327518106963944910680856e1 * t691 + t391 + t399 + t493 - 0.36622894612013090109708692208757981924083909966068e-3 * t694 + t489 + t434 + t128 * t888 * t118 + 0.2e1 * t685 + t510
  t899 = t892 + t898
  t904 = t724 ** 2
  t907 = t574 * t904
  t915 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t519 * t870 + 0.2e1 / 0.3e1 * t255 * t874)
  t921 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t526 * t879 + 0.2e1 / 0.3e1 * t259 * t882)
  t932 = t661 ** 2
  t941 = 0.69506584583333333333333333333333333333333333333332e-3 * t85 * (t915 / 0.2e1 + t921 / 0.2e1) * t203 * t213 - 0.32436406138888888888888888888888888888888888888888e-2 * t786 - 0.13901316916666666666666666666666666666666666666666e-2 * t717 * t721 + t549 + 0.32436406138888888888888888888888888888888888888888e-2 * t794 + 0.13901316916666666666666666666666666666666666666666e-2 * t204 * t206 * t554 * t932 - 0.69506584583333333333333333333333333333333333333332e-3 * t204 * t206 * t278 * t899
  t942 = t941 * t234
  t945 = -t941
  t946 = t253 * t945
  t949 = t735 ** 2
  t950 = t949 * t234
  t957 = t949 * t586
  t960 = t580 * t904
  t973 = -0.4e1 * t285 * t960 + 0.4e1 * t292 * t946 - 0.8e1 * t292 * t960 - 0.10e2 * t295 * t960 - 0.2e1 * t301 * t942 - 0.3e1 * t305 * t950 - 0.4e1 * t308 * t950 - 0.5e1 * t311 * t942 + 0.12e2 * t572 * t907 + 0.6e1 * t584 * t957 + 0.20e2 * t605 * t957 + 0.20e2 * t618 * t907 + 0.6e1 * t631 * t907 - 0.2e1 * t635 * t904
  t1002 = -t233 * t941 * t234 - t233 * t949 * t234 + 0.2e1 * t237 * t949 * t586 + t254 * t945 + 0.2e1 * t285 * t946 + 0.3e1 * t289 * t946 - 0.6e1 * t289 * t960 + 0.5e1 * t295 * t946 - 0.2e1 * t301 * t950 - 0.3e1 * t305 * t942 - 0.4e1 * t308 * t942 - 0.5e1 * t311 * t950 + 0.12e2 * t608 * t957 + 0.2e1 * t628 * t904
  d22 = 0.2e1 * t662 + 0.2e1 * t748 + t7 * t899 * t249 + 0.2e1 * t706 * t747 + t518 * (t973 + t1002)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

