"""Generated from gga_c_w94.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a = -1

  b = 11.8

  c = 0.15067

  d = 0.01102 / f.RS_FACTOR

  f_num = lambda z: a * jnp.sqrt(1 - jnp.maximum(jnp.abs(z), 1e-10) ** (5 / 3))

  f_den = lambda rs, xt: b + c * xt ** (51 / 16) + d * xt ** 2 * rs + rs

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_num(z) / f_den(rs, xt)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a = -1

  b = 11.8

  c = 0.15067

  d = 0.01102 / f.RS_FACTOR

  f_num = lambda z=None: a

  f_den = lambda rs, xt: b + c * xt ** (51 / 16) + d * xt ** 2 * rs + rs

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_num(z) / f_den(rs, xt)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a = -1

  b = 11.8

  c = 0.15067

  d = 0.01102 / f.RS_FACTOR

  f_num = lambda z: a * jnp.sqrt(1 - jnp.maximum(jnp.abs(z), 1e-10) ** (5 / 3))

  f_den = lambda rs, xt: b + c * xt ** (51 / 16) + d * xt ** 2 * rs + rs

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_num(z) / f_den(rs, xt)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.0e0 < t4
  t6 = f.my_piecewise3(t5, t4, -t4)
  t7 = 0.1e-9 < t6
  t8 = f.my_piecewise3(t7, t6, 0.1e-9)
  t9 = t8 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t13 = jnp.sqrt(-t10 * t8 + 0.1e1)
  t15 = s0 + 0.2e1 * s1 + s2
  t16 = jnp.sqrt(t15)
  t18 = t2 ** 2
  t19 = t18 ** 2
  t20 = 0.1e1 / t19
  t22 = t2 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t2
  t26 = (t16 * t24) ** (0.1e1 / 0.16e2)
  t27 = t26 ** 2
  t28 = t27 * t26
  t32 = 0.1e1 / t18 / t2
  t35 = 3 ** (0.1e1 / 0.3e1)
  t37 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t38 = t35 * t37
  t39 = 4 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t45 = 0.118e2 + 0.150670e0 * t28 * t16 * t15 * t20 + 0.11020000000000000000000000000000000000000000000000e-1 * t15 * t32 + t38 * t40 / t22 / 0.4e1
  t46 = 0.1e1 / t45
  t47 = t13 * t46
  t49 = t2 / t13
  t50 = t46 * t10
  t52 = t1 / t18
  t53 = t3 - t52
  t55 = f.my_piecewise3(t5, t53, -t53)
  t56 = f.my_piecewise3(t7, t55, 0)
  t60 = t2 * t13
  t61 = t45 ** 2
  t62 = 0.1e1 / t61
  t63 = t22 ** 2
  t67 = t28 * t15 / t63 / t18
  t80 = t60 * t62 * (-0.64034750000000000000000000000000000000000000000000e0 * t67 * t16 / t22 / t18 - 0.33060000000000000000000000000000000000000000000000e-1 * t15 * t20 - t38 * t40 * t24 / 0.12e2)
  vrho_0_ = -t47 + 0.5e1 / 0.6e1 * t49 * t50 * t56 + t80
  t81 = -t3 - t52
  t83 = f.my_piecewise3(t5, t81, -t81)
  t84 = f.my_piecewise3(t7, t83, 0)
  vrho_1_ = -t47 + 0.5e1 / 0.6e1 * t49 * t50 * t84 + t80
  t90 = t67 / t16 * t24
  vsigma_0_ = t60 * t62 * (0.24013031250000000000000000000000000000000000000000e0 * t90 + 0.11020000000000000000000000000000000000000000000000e-1 * t32)
  vsigma_1_ = t60 * t62 * (0.48026062500000000000000000000000000000000000000000e0 * t90 + 0.22040000000000000000000000000000000000000000000000e-1 * t32)
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a = -1

  b = 11.8

  c = 0.15067

  d = 0.01102 / f.RS_FACTOR

  f_num = lambda z=None: a

  f_den = lambda rs, xt: b + c * xt ** (51 / 16) + d * xt ** 2 * rs + rs

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_num(z) / f_den(rs, xt)

  t2 = f.my_piecewise3(0 < 0, 0, 0)
  t4 = f.my_piecewise3(0.1e-9 < t2, t2, 0.1e-9)
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = jnp.sqrt(-t6 * t4 + 0.1e1)
  t10 = jnp.sqrt(s0)
  t12 = r0 ** 2
  t13 = t12 ** 2
  t14 = 0.1e1 / t13
  t16 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t16 / r0
  t20 = (t10 * t18) ** (0.1e1 / 0.16e2)
  t21 = t20 ** 2
  t22 = t21 * t20
  t26 = 0.1e1 / t12 / r0
  t29 = 3 ** (0.1e1 / 0.3e1)
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = t29 * t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t39 = 0.118e2 + 0.150670e0 * t22 * t10 * s0 * t14 + 0.11020000000000000000000000000000000000000000000000e-1 * s0 * t26 + t32 * t34 / t16 / 0.4e1
  t42 = r0 * t9
  t43 = t39 ** 2
  t44 = 0.1e1 / t43
  t45 = t16 ** 2
  t49 = t22 * s0 / t45 / t12
  vrho_0_ = -t9 / t39 + t42 * t44 * (-0.64034750000000000000000000000000000000000000000000e0 * t49 * t10 / t16 / t12 - 0.33060000000000000000000000000000000000000000000000e-1 * s0 * t14 - t32 * t34 * t18 / 0.12e2)
  vsigma_0_ = t42 * t44 * (0.24013031250000000000000000000000000000000000000000e0 * t49 / t10 * t18 + 0.11020000000000000000000000000000000000000000000000e-1 * t26)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = f.my_piecewise3(0 < 0, 0, 0)
  t4 = f.my_piecewise3(0.1e-9 < t2, t2, 0.1e-9)
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = jnp.sqrt(-t6 * t4 + 0.1e1)
  t10 = jnp.sqrt(s0)
  t11 = t10 * s0
  t12 = r0 ** 2
  t13 = t12 ** 2
  t14 = 0.1e1 / t13
  t16 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t16 / r0
  t19 = t10 * t18
  t20 = t19 ** (0.1e1 / 0.16e2)
  t21 = t20 ** 2
  t22 = t21 * t20
  t25 = t12 * r0
  t26 = 0.1e1 / t25
  t29 = 3 ** (0.1e1 / 0.3e1)
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = t29 * t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t39 = 0.118e2 + 0.150670e0 * t22 * t11 * t14 + 0.11020000000000000000000000000000000000000000000000e-1 * s0 * t26 + t32 * t34 / t16 / 0.4e1
  t40 = t39 ** 2
  t41 = 0.1e1 / t40
  t42 = t9 * t41
  t43 = t16 ** 2
  t45 = 0.1e1 / t43 / t12
  t47 = t22 * s0 * t45
  t48 = t47 * t10
  t50 = 0.1e1 / t16 / t12
  t58 = -0.64034750000000000000000000000000000000000000000000e0 * t48 * t50 - 0.33060000000000000000000000000000000000000000000000e-1 * s0 * t14 - t32 * t34 * t18 / 0.12e2
  t61 = r0 * t9
  t63 = 0.1e1 / t40 / t39
  t64 = t58 ** 2
  t68 = t22 * t19
  v2rho2_0_ = 0.2e1 * t42 * t58 - 0.2e1 * t61 * t63 * t64 + t61 * t41 * (0.18676802083333333333333333333333333333333333333333e1 * t68 * s0 / t43 / t13 + 0.14941441666666666666666666666666666666666666666667e1 * t48 / t16 / t25 + 0.13224000000000000000000000000000000000000000000000e0 * s0 / t13 / r0 + t32 * t34 * t50 / 0.9e1)
  t89 = t47 / t10
  t93 = 0.24013031250000000000000000000000000000000000000000e0 * t89 * t18 + 0.11020000000000000000000000000000000000000000000000e-1 * t26
  v2rhosigma_0_ = t42 * t93 - 0.2e1 * t61 * t63 * t93 * t58 + t61 * t41 * (-0.70038007812500000000000000000000000000000000000000e0 * t68 / t43 / t25 - 0.32017375000000000000000000000000000000000000000000e0 * t89 * t50 - 0.33060000000000000000000000000000000000000000000000e-1 * t14)
  t109 = t93 ** 2
  v2sigma2_0_ = -0.2e1 * t61 * t63 * t109 + t61 * t41 * (0.26264252929687500000000000000000000000000000000000e0 * t68 / s0 * t45 - 0.12006515625000000000000000000000000000000000000000e0 * t47 / t11 * t18)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.my_piecewise3(0 < 0, 0, 0)
  t4 = f.my_piecewise3(0.1e-9 < t2, t2, 0.1e-9)
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = jnp.sqrt(-t6 * t4 + 0.1e1)
  t10 = jnp.sqrt(s0)
  t11 = t10 * s0
  t12 = r0 ** 2
  t13 = t12 ** 2
  t14 = 0.1e1 / t13
  t16 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t16 / r0
  t19 = t10 * t18
  t20 = t19 ** (0.1e1 / 0.16e2)
  t21 = t20 ** 2
  t22 = t21 * t20
  t25 = t12 * r0
  t29 = 3 ** (0.1e1 / 0.3e1)
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = t29 * t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t39 = 0.118e2 + 0.150670e0 * t22 * t11 * t14 + 0.11020000000000000000000000000000000000000000000000e-1 * s0 / t25 + t32 * t34 / t16 / 0.4e1
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t39
  t44 = t16 ** 2
  t49 = t22 * s0 / t44 / t12 * t10
  t51 = 0.1e1 / t16 / t12
  t59 = -0.64034750000000000000000000000000000000000000000000e0 * t49 * t51 - 0.33060000000000000000000000000000000000000000000000e-1 * s0 * t14 - t32 * t34 * t18 / 0.12e2
  t60 = t59 ** 2
  t63 = 0.1e1 / t40
  t66 = t22 * t19 * s0
  t72 = 0.1e1 / t16 / t25
  t75 = t13 * r0
  t82 = 0.18676802083333333333333333333333333333333333333333e1 * t66 / t44 / t13 + 0.14941441666666666666666666666666666666666666666667e1 * t49 * t72 + 0.13224000000000000000000000000000000000000000000000e0 * s0 / t75 + t32 * t34 * t51 / 0.9e1
  t85 = r0 * t9
  t86 = t40 ** 2
  v3rho3_0_ = -0.6e1 * t9 * t42 * t60 + 0.3e1 * t9 * t63 * t82 + 0.6e1 * t85 / t86 * t60 * t59 - 0.6e1 * t85 * t42 * t59 * t82 + t85 * t63 * (-0.29571603298611111111111111111111111111111111111111e1 * t22 * t11 / t13 / t25 - 0.13073761458333333333333333333333333333333333333333e2 * t66 / t44 / t75 - 0.49804805555555555555555555555555555555555555555557e1 * t49 / t16 / t13 - 0.66120000000000000000000000000000000000000000000000e0 * s0 / t13 / t12 - 0.7e1 / 0.27e2 * t32 * t34 * t72)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.my_piecewise3(0 < 0, 0, 0)
  t4 = f.my_piecewise3(0.1e-9 < t2, t2, 0.1e-9)
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = jnp.sqrt(-t6 * t4 + 0.1e1)
  t10 = jnp.sqrt(s0)
  t11 = t10 * s0
  t12 = r0 ** 2
  t13 = t12 ** 2
  t14 = 0.1e1 / t13
  t16 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t16 / r0
  t19 = t10 * t18
  t20 = t19 ** (0.1e1 / 0.16e2)
  t21 = t20 ** 2
  t22 = t21 * t20
  t25 = t12 * r0
  t29 = 3 ** (0.1e1 / 0.3e1)
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = t29 * t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t39 = 0.118e2 + 0.150670e0 * t22 * t11 * t14 + 0.11020000000000000000000000000000000000000000000000e-1 * s0 / t25 + t32 * t34 / t16 / 0.4e1
  t40 = t39 ** 2
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t44 = t16 ** 2
  t49 = t22 * s0 / t44 / t12 * t10
  t51 = 0.1e1 / t16 / t12
  t59 = -0.64034750000000000000000000000000000000000000000000e0 * t49 * t51 - 0.33060000000000000000000000000000000000000000000000e-1 * s0 * t14 - t32 * t34 * t18 / 0.12e2
  t60 = t59 ** 2
  t65 = 0.1e1 / t40 / t39
  t68 = t22 * t19 * s0
  t74 = 0.1e1 / t16 / t25
  t77 = t13 * r0
  t84 = 0.18676802083333333333333333333333333333333333333333e1 * t68 / t44 / t13 + 0.14941441666666666666666666666666666666666666666667e1 * t49 * t74 + 0.13224000000000000000000000000000000000000000000000e0 * s0 / t77 + t32 * t34 * t51 / 0.9e1
  t88 = 0.1e1 / t40
  t90 = t22 * t11
  t92 = 0.1e1 / t13 / t25
  t100 = 0.1e1 / t16 / t13
  t103 = t13 * t12
  t110 = -0.29571603298611111111111111111111111111111111111111e1 * t90 * t92 - 0.13073761458333333333333333333333333333333333333333e2 * t68 / t44 / t77 - 0.49804805555555555555555555555555555555555555555557e1 * t49 * t100 - 0.66120000000000000000000000000000000000000000000000e0 * s0 / t103 - 0.7e1 / 0.27e2 * t32 * t34 * t74
  t113 = r0 * t9
  t116 = t60 ** 2
  t124 = t84 ** 2
  t132 = t21 ** 2
  t134 = t132 ** 2
  t137 = s0 ** 2
  t139 = t13 ** 2
  v4rho4_0_ = 0.24e2 * t9 * t42 * t60 * t59 - 0.24e2 * t9 * t65 * t59 * t84 + 0.4e1 * t9 * t88 * t110 - 0.24e2 * t113 / t41 / t39 * t116 + 0.36e2 * t113 * t42 * t60 * t84 - 0.6e1 * t113 * t65 * t124 - 0.8e1 * t113 * t65 * t59 * t110 + t113 * t88 * (0.73929008246527777777777777777777777777777777777778e0 / t134 / t132 / t20 * t137 / t16 / t139 / r0 + 0.41400244618055555555555555555555555555555555555555e2 * t90 / t139 + 0.88611049884259259259259259259259259259259259259258e2 * t68 / t44 / t103 + 0.21582082407407407407407407407407407407407407407408e2 * t49 / t16 / t77 + 0.39672000000000000000000000000000000000000000000000e1 * s0 * t92 + 0.70e2 / 0.81e2 * t32 * t34 * t100)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.0e0 < t4
  t6 = f.my_piecewise3(t5, t4, -t4)
  t7 = 0.1e-9 < t6
  t8 = f.my_piecewise3(t7, t6, 0.1e-9)
  t9 = t8 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t12 = -t10 * t8 + 0.1e1
  t13 = jnp.sqrt(t12)
  t14 = 0.1e1 / t13
  t16 = s0 + 0.2e1 * s1 + s2
  t17 = jnp.sqrt(t16)
  t19 = t2 ** 2
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t23 = t2 ** (0.1e1 / 0.3e1)
  t25 = 0.1e1 / t23 / t2
  t26 = t17 * t25
  t27 = t26 ** (0.1e1 / 0.16e2)
  t28 = t27 ** 2
  t29 = t28 * t27
  t32 = t19 * t2
  t33 = 0.1e1 / t32
  t36 = 3 ** (0.1e1 / 0.3e1)
  t38 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t39 = t36 * t38
  t40 = 4 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t46 = 0.118e2 + 0.150670e0 * t29 * t17 * t16 * t21 + 0.11020000000000000000000000000000000000000000000000e-1 * t16 * t33 + t39 * t41 / t23 / 0.4e1
  t47 = 0.1e1 / t46
  t48 = t14 * t47
  t49 = 0.1e1 / t19
  t50 = t1 * t49
  t51 = t3 - t50
  t53 = f.my_piecewise3(t5, t51, -t51)
  t54 = f.my_piecewise3(t7, t53, 0)
  t55 = t10 * t54
  t56 = t48 * t55
  t58 = t46 ** 2
  t59 = 0.1e1 / t58
  t61 = t23 ** 2
  t66 = t29 * t16 / t61 / t19 * t17
  t68 = 0.1e1 / t23 / t19
  t76 = -0.64034750000000000000000000000000000000000000000000e0 * t66 * t68 - 0.33060000000000000000000000000000000000000000000000e-1 * t16 * t21 - t39 * t41 * t25 / 0.12e2
  t78 = 0.2e1 * t13 * t59 * t76
  t81 = t2 / t13 / t12
  t82 = t9 * t8
  t83 = t47 * t82
  t84 = t54 ** 2
  t88 = t2 * t14
  t89 = t88 * t59
  t91 = t89 * t55 * t76
  t93 = 0.1e1 / t9
  t94 = t47 * t93
  t98 = t47 * t10
  t99 = t1 * t33
  t101 = -0.2e1 * t49 + 0.2e1 * t99
  t103 = f.my_piecewise3(t5, t101, -t101)
  t104 = f.my_piecewise3(t7, t103, 0)
  t108 = t2 * t13
  t111 = t76 ** 2
  t114 = 0.2e1 * t108 / t58 / t46 * t111
  t134 = t108 * t59 * (0.18676802083333333333333333333333333333333333333333e1 * t29 * t26 * t16 / t61 / t20 + 0.14941441666666666666666666666666666666666666666667e1 * t66 / t23 / t32 + 0.13224000000000000000000000000000000000000000000000e0 * t16 / t20 / t2 + t39 * t41 * t68 / 0.9e1)
  d11 = 0.5e1 / 0.3e1 * t56 + t78 + 0.25e2 / 0.36e2 * t81 * t83 * t84 - 0.5e1 / 0.3e1 * t91 + 0.5e1 / 0.9e1 * t88 * t94 * t84 + 0.5e1 / 0.6e1 * t88 * t98 * t104 - t114 + t134
  t136 = -t3 - t50
  t138 = f.my_piecewise3(t5, t136, -t136)
  t139 = f.my_piecewise3(t7, t138, 0)
  t140 = t10 * t139
  t141 = t48 * t140
  t149 = t89 * t140 * t76
  t156 = 0.2e1 * t99
  t157 = f.my_piecewise3(t5, t156, -t156)
  t158 = f.my_piecewise3(t7, t157, 0)
  d12 = 0.5e1 / 0.6e1 * t56 + t78 + 0.5e1 / 0.6e1 * t141 + 0.25e2 / 0.36e2 * t81 * t47 * t82 * t139 * t54 - 0.5e1 / 0.6e1 * t149 + 0.5e1 / 0.9e1 * t88 * t47 * t93 * t139 * t54 + 0.5e1 / 0.6e1 * t88 * t98 * t158 - 0.5e1 / 0.6e1 * t91 - t114 + t134
  t164 = t139 ** 2
  t173 = 0.2e1 * t49 + 0.2e1 * t99
  t175 = f.my_piecewise3(t5, t173, -t173)
  t176 = f.my_piecewise3(t7, t175, 0)
  d22 = 0.5e1 / 0.3e1 * t141 + t78 + 0.25e2 / 0.36e2 * t81 * t83 * t164 - 0.5e1 / 0.3e1 * t149 + 0.5e1 / 0.9e1 * t88 * t94 * t164 + 0.5e1 / 0.6e1 * t88 * t98 * t176 - t114 + t134
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = r0 - r1
  t3 = 0.1e1 / t1
  t4 = t2 * t3
  t5 = 0.0e0 < t4
  t6 = f.my_piecewise3(t5, t4, -t4)
  t7 = 0.1e-9 < t6
  t8 = f.my_piecewise3(t7, t6, 0.1e-9)
  t9 = t8 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t12 = -t10 * t8 + 0.1e1
  t13 = jnp.sqrt(t12)
  t14 = 0.1e1 / t13
  t15 = t1 * t14
  t17 = s0 + 0.2e1 * s1 + s2
  t18 = jnp.sqrt(t17)
  t19 = t18 * t17
  t20 = t1 ** 2
  t21 = t20 ** 2
  t22 = 0.1e1 / t21
  t24 = t1 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t24 / t1
  t27 = t18 * t26
  t28 = t27 ** (0.1e1 / 0.16e2)
  t29 = t28 ** 2
  t30 = t29 * t28
  t33 = t20 * t1
  t34 = 0.1e1 / t33
  t37 = 3 ** (0.1e1 / 0.3e1)
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t40 = t37 * t39
  t41 = 4 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t47 = 0.118e2 + 0.150670e0 * t30 * t19 * t22 + 0.11020000000000000000000000000000000000000000000000e-1 * t17 * t34 + t40 * t42 / t24 / 0.4e1
  t48 = t47 ** 2
  t50 = 0.1e1 / t48 / t47
  t52 = 0.1e1 / t20
  t54 = -t2 * t52 + t3
  t56 = f.my_piecewise3(t5, t54, -t54)
  t57 = f.my_piecewise3(t7, t56, 0)
  t58 = t10 * t57
  t59 = t24 ** 2
  t64 = t30 * t17 / t59 / t20 * t18
  t66 = 0.1e1 / t24 / t20
  t74 = -0.64034750000000000000000000000000000000000000000000e0 * t64 * t66 - 0.33060000000000000000000000000000000000000000000000e-1 * t17 * t22 - t40 * t42 * t26 / 0.12e2
  t75 = t74 ** 2
  t79 = 0.1e1 / t48
  t80 = t15 * t79
  t81 = 0.1e1 / t9
  t82 = t57 ** 2
  t83 = t81 * t82
  t89 = t30 * t27 * t17
  t95 = 0.1e1 / t24 / t33
  t98 = t21 * t1
  t105 = 0.18676802083333333333333333333333333333333333333333e1 * t89 / t59 / t21 + 0.14941441666666666666666666666666666666666666666667e1 * t64 * t95 + 0.13224000000000000000000000000000000000000000000000e0 * t17 / t98 + t40 * t42 * t66 / 0.9e1
  t112 = 0.1e1 / t47
  t113 = t14 * t112
  t116 = t12 ** 2
  t120 = t8 ** 2
  t122 = t82 * t57
  t129 = -0.6e1 * t2 * t22 + 0.6e1 * t34
  t131 = f.my_piecewise3(t5, t129, -t129)
  t132 = f.my_piecewise3(t7, t131, 0)
  t136 = t1 * t13
  t137 = t48 ** 2
  t149 = 0.2e1 * t2 * t34 - 0.2e1 * t52
  t151 = f.my_piecewise3(t5, t149, -t149)
  t152 = f.my_piecewise3(t7, t151, 0)
  t153 = t10 * t152
  t157 = 0.1e1 / t13 / t12
  t159 = t9 * t8
  t160 = t159 * t82
  t189 = t1 * t157
  d111 = 0.5e1 * t15 * t50 * t58 * t75 - 0.5e1 / 0.3e1 * t80 * t83 * t74 + 0.3e1 * t13 * t79 * t105 - 0.5e1 * t14 * t79 * t58 * t74 + 0.5e1 / 0.3e1 * t113 * t83 + 0.125e3 / 0.72e2 * t1 / t13 / t116 * t112 * t120 * t122 + 0.5e1 / 0.6e1 * t15 * t112 * t10 * t132 + 0.6e1 * t136 / t137 * t75 * t74 - 0.6e1 * t136 * t50 * t74 * t105 + 0.5e1 / 0.2e1 * t113 * t153 + 0.25e2 / 0.12e2 * t157 * t112 * t160 - 0.6e1 * t13 * t50 * t75 + t136 * t79 * (-0.29571603298611111111111111111111111111111111111111e1 * t30 * t19 / t21 / t33 - 0.13073761458333333333333333333333333333333333333333e2 * t89 / t59 / t98 - 0.49804805555555555555555555555555555555555555555557e1 * t64 / t24 / t21 - 0.66120000000000000000000000000000000000000000000000e0 * t17 / t21 / t20 - 0.7e1 / 0.27e2 * t40 * t42 * t95) - 0.25e2 / 0.12e2 * t189 * t79 * t160 * t74 + 0.25e2 / 0.18e2 * t189 * t112 * t9 * t122 + 0.25e2 / 0.12e2 * t189 * t112 * t159 * t57 * t152 - 0.5e1 / 0.2e1 * t80 * t153 * t74 - 0.5e1 / 0.2e1 * t80 * t58 * t105 - 0.5e1 / 0.27e2 * t15 * t112 / t159 * t122 + 0.5e1 / 0.3e1 * t15 * t112 * t81 * t57 * t152

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.0e0 < t4
  t6 = f.my_piecewise3(t5, t4, -t4)
  t7 = 0.1e-9 < t6
  t8 = f.my_piecewise3(t7, t6, 0.1e-9)
  t9 = t8 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t12 = -t10 * t8 + 0.1e1
  t13 = jnp.sqrt(t12)
  t14 = 0.1e1 / t13
  t16 = s0 + 0.2e1 * s1 + s2
  t17 = jnp.sqrt(t16)
  t18 = t17 * t16
  t19 = t2 ** 2
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t23 = t2 ** (0.1e1 / 0.3e1)
  t25 = 0.1e1 / t23 / t2
  t26 = t17 * t25
  t27 = t26 ** (0.1e1 / 0.16e2)
  t28 = t27 ** 2
  t29 = t28 * t27
  t32 = t19 * t2
  t33 = 0.1e1 / t32
  t36 = 3 ** (0.1e1 / 0.3e1)
  t38 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t39 = t36 * t38
  t40 = 4 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t46 = 0.118e2 + 0.150670e0 * t29 * t18 * t21 + 0.11020000000000000000000000000000000000000000000000e-1 * t16 * t33 + t39 * t41 / t23 / 0.4e1
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t14 * t48
  t51 = t29 * t26 * t16
  t52 = t23 ** 2
  t61 = t29 * t16 / t52 / t19 * t17
  t63 = 0.1e1 / t23 / t32
  t66 = t20 * t2
  t67 = 0.1e1 / t66
  t71 = 0.1e1 / t23 / t19
  t75 = 0.18676802083333333333333333333333333333333333333333e1 * t51 / t52 / t20 + 0.14941441666666666666666666666666666666666666666667e1 * t61 * t63 + 0.13224000000000000000000000000000000000000000000000e0 * t16 * t67 + t39 * t41 * t71 / 0.9e1
  t77 = 0.1e1 / t19
  t79 = -t1 * t77 + t3
  t81 = f.my_piecewise3(t5, t79, -t79)
  t82 = f.my_piecewise3(t7, t81, 0)
  t88 = 0.2e1 * t1 * t33 - 0.2e1 * t77
  t90 = f.my_piecewise3(t5, t88, -t88)
  t91 = f.my_piecewise3(t7, t90, 0)
  t92 = t10 * t91
  t100 = -0.64034750000000000000000000000000000000000000000000e0 * t61 * t71 - 0.33060000000000000000000000000000000000000000000000e-1 * t16 * t21 - t39 * t41 * t25 / 0.12e2
  t105 = 0.1e1 / t13 / t12
  t107 = t9 * t8
  t108 = t82 ** 2
  t109 = t107 * t108
  t113 = 0.1e1 / t46
  t114 = t14 * t113
  t115 = 0.1e1 / t9
  t116 = t115 * t82
  t120 = t12 ** 2
  t125 = t8 ** 2
  t128 = t108 ** 2
  t132 = t2 * t14
  t136 = 0.24e2 * t1 * t67 - 0.24e2 * t21
  t138 = f.my_piecewise3(t5, t136, -t136)
  t139 = f.my_piecewise3(t7, t138, 0)
  t143 = t2 * t13
  t144 = t47 ** 2
  t145 = 0.1e1 / t144
  t146 = t100 ** 2
  t152 = 0.1e1 / t47 / t46
  t154 = t10 * t82
  t158 = t115 * t108
  t163 = 0.1e1 / t13 / t120
  t164 = t2 * t163
  t169 = t2 * t105
  t175 = -0.10e2 * t49 * t75 * t10 * t82 - 0.10e2 * t49 * t92 * t100 - 0.25e2 / 0.3e1 * t105 * t48 * t109 * t100 + 0.20e2 / 0.3e1 * t114 * t116 * t91 + 0.3125e4 / 0.432e3 * t2 / t13 / t120 / t12 * t113 * t10 * t125 * t128 + 0.5e1 / 0.6e1 * t132 * t113 * t10 * t139 + 0.36e2 * t143 * t145 * t146 * t75 + 0.20e2 * t14 * t152 * t154 * t146 - 0.20e2 / 0.3e1 * t49 * t158 * t100 + 0.125e3 / 0.18e2 * t164 * t113 * t8 * t128 + 0.25e2 / 0.81e2 * t169 * t113 / t10 * t128
  t177 = t91 ** 2
  t192 = t29 * t18
  t194 = 0.1e1 / t20 / t32
  t202 = 0.1e1 / t23 / t20
  t205 = t20 * t19
  t212 = -0.29571603298611111111111111111111111111111111111111e1 * t192 * t194 - 0.13073761458333333333333333333333333333333333333333e2 * t51 / t52 / t66 - 0.49804805555555555555555555555555555555555555555557e1 * t61 * t202 - 0.66120000000000000000000000000000000000000000000000e0 * t16 / t205 - 0.7e1 / 0.27e2 * t39 * t41 * t63
  t216 = t105 * t113
  t222 = t146 * t100
  t228 = 0.1e1 / t107
  t229 = t108 * t82
  t230 = t228 * t229
  t234 = t125 * t229
  t239 = -0.6e1 * t1 * t21 + 0.6e1 * t33
  t241 = f.my_piecewise3(t5, t239, -t239)
  t242 = f.my_piecewise3(t7, t241, 0)
  t243 = t10 * t242
  t248 = t146 ** 2
  t252 = t75 ** 2
  t256 = 0.25e2 / 0.12e2 * t169 * t113 * t107 * t177 + 0.20e2 / 0.81e2 * t132 * t113 / t9 / t125 * t128 + 0.5e1 / 0.3e1 * t132 * t113 * t115 * t177 - 0.8e1 * t143 * t152 * t100 * t212 + 0.25e2 / 0.3e1 * t216 * t107 * t91 * t82 + 0.24e2 * t13 * t145 * t222 + 0.4e1 * t13 * t48 * t212 - 0.20e2 / 0.27e2 * t114 * t230 + 0.125e3 / 0.18e2 * t163 * t113 * t234 + 0.10e2 / 0.3e1 * t114 * t243 - 0.24e2 * t143 / t144 / t46 * t248 - 0.6e1 * t143 * t152 * t252
  t259 = t75 * t100
  t262 = t9 * t229
  t265 = t28 ** 2
  t267 = t265 ** 2
  t270 = t16 ** 2
  t272 = t20 ** 2
  t297 = t132 * t152
  t301 = t132 * t48
  t302 = t100 * t91
  t306 = t169 * t48
  t328 = -0.24e2 * t13 * t152 * t259 + 0.50e2 / 0.9e1 * t216 * t262 + t143 * t48 * (0.73929008246527777777777777777777777777777777777778e0 / t267 / t265 / t27 * t270 / t23 / t272 / t2 + 0.41400244618055555555555555555555555555555555555555e2 * t192 / t272 + 0.88611049884259259259259259259259259259259259259258e2 * t51 / t52 / t205 + 0.21582082407407407407407407407407407407407407407408e2 * t61 / t23 / t66 + 0.39672000000000000000000000000000000000000000000000e1 * t16 * t194 + 0.70e2 / 0.81e2 * t39 * t41 * t202) + 0.20e2 * t297 * t154 * t259 - 0.20e2 / 0.3e1 * t301 * t116 * t302 - 0.25e2 / 0.3e1 * t306 * t107 * t82 * t302 + 0.20e2 / 0.27e2 * t301 * t230 * t100 - 0.20e2 * t132 * t145 * t154 * t222 + 0.20e2 / 0.3e1 * t297 * t158 * t146 + 0.10e2 * t297 * t92 * t146 + 0.25e2 / 0.3e1 * t169 * t152 * t109 * t146
  t347 = t132 * t113
  t352 = t169 * t113
  t375 = -0.10e2 / 0.3e1 * t301 * t158 * t75 - 0.50e2 / 0.9e1 * t306 * t262 * t100 - 0.125e3 / 0.18e2 * t164 * t48 * t234 * t100 + 0.125e3 / 0.12e2 * t164 * t113 * t125 * t108 * t91 - 0.10e2 / 0.3e1 * t301 * t243 * t100 + 0.20e2 / 0.9e1 * t347 * t115 * t242 * t82 + 0.25e2 / 0.9e1 * t352 * t107 * t242 * t82 - 0.10e2 / 0.3e1 * t301 * t212 * t10 * t82 - 0.25e2 / 0.6e1 * t306 * t109 * t75 + 0.25e2 / 0.3e1 * t352 * t9 * t108 * t91 - 0.5e1 * t301 * t92 * t75 - 0.10e2 / 0.9e1 * t347 * t228 * t108 * t91
  d1111 = t175 + t256 + t328 + t375

  res = {'v4rho4': d1111}
  return res
