"""Generated from gga_x_2d_b86_mgc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  _2d_b86_mgc_beta = 0.003317

  _2d_b86_mgc_gamma = 0.008323

  _2d_b86_mgc_f = lambda x: 1 + _2d_b86_mgc_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b86_mgc_gamma * x ** 2) ** (3 / 4)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_mgc_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  _2d_b86_mgc_beta = 0.003317

  _2d_b86_mgc_gamma = 0.008323

  _2d_b86_mgc_f = lambda x: 1 + _2d_b86_mgc_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b86_mgc_gamma * x ** 2) ** (3 / 4)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_mgc_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  _2d_b86_mgc_beta = 0.003317

  _2d_b86_mgc_gamma = 0.008323

  _2d_b86_mgc_f = lambda x: 1 + _2d_b86_mgc_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b86_mgc_gamma * x ** 2) ** (3 / 4)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_mgc_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = jnp.sqrt(jnp.pi)
  t29 = t28 * s0
  t30 = r0 ** 2
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / t30
  t37 = 0.1e1 + 0.8323e-2 * s0 * t34
  t38 = t37 ** (0.1e1 / 0.4e1)
  t39 = t38 ** 2
  t40 = t39 * t38
  t41 = 0.1e1 / t40
  t45 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t29 * t34 * t41
  t49 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t45)
  t50 = r1 <= f.p.dens_threshold
  t51 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t52 = 0.1e1 + t51
  t53 = t52 <= f.p.zeta_threshold
  t54 = t52 ** (0.1e1 / 0.3e1)
  t56 = f.my_piecewise3(t53, t22, t54 * t52)
  t57 = t56 * t26
  t58 = t28 * s2
  t59 = r1 ** 2
  t60 = r1 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t63 = 0.1e1 / t61 / t59
  t66 = 0.1e1 + 0.8323e-2 * s2 * t63
  t67 = t66 ** (0.1e1 / 0.4e1)
  t68 = t67 ** 2
  t69 = t68 * t67
  t70 = 0.1e1 / t69
  t74 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t58 * t63 * t70
  t78 = f.my_piecewise3(t50, 0, -0.3e1 / 0.8e1 * t5 * t57 * t74)
  t79 = t6 ** 2
  t81 = t16 / t79
  t82 = t7 - t81
  t83 = f.my_piecewise5(t10, 0, t14, 0, t82)
  t86 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t83)
  t91 = t26 ** 2
  t92 = 0.1e1 / t91
  t96 = t5 * t25 * t92 * t45 / 0.8e1
  t103 = s0 ** 2
  t105 = t30 ** 2
  t110 = 0.1e1 / t40 / t37
  t119 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t86 * t26 * t45 - t96 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.33170000000000000000000000000000000000000000000000e-2 * t29 / t32 / t30 / r0 * t41 + 0.20705543250000000000000000000000000000000000000000e-4 * t28 * t103 / t31 / t105 / t30 * t110))
  t121 = f.my_piecewise5(t14, 0, t10, 0, -t82)
  t124 = f.my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t121)
  t132 = t5 * t56 * t92 * t74 / 0.8e1
  t134 = f.my_piecewise3(t50, 0, -0.3e1 / 0.8e1 * t5 * t124 * t26 * t74 - t132)
  vrho_0_ = t49 + t78 + t6 * (t119 + t134)
  t137 = -t7 - t81
  t138 = f.my_piecewise5(t10, 0, t14, 0, t137)
  t141 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t138)
  t147 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t141 * t26 * t45 - t96)
  t149 = f.my_piecewise5(t14, 0, t10, 0, -t137)
  t152 = f.my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t149)
  t163 = s2 ** 2
  t165 = t59 ** 2
  t170 = 0.1e1 / t69 / t66
  t179 = f.my_piecewise3(t50, 0, -0.3e1 / 0.8e1 * t5 * t152 * t26 * t74 - t132 - 0.3e1 / 0.8e1 * t5 * t57 * (-0.33170000000000000000000000000000000000000000000000e-2 * t58 / t61 / t59 / r1 * t70 + 0.20705543250000000000000000000000000000000000000000e-4 * t28 * t163 / t60 / t165 / t59 * t170))
  vrho_1_ = t49 + t78 + t6 * (t147 + t179)
  t195 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.12438750000000000000000000000000000000000000000000e-2 * t28 * t34 * t41 - 0.77645787187500000000000000000000000000000000000000e-5 * t29 / t31 / t105 / r0 * t110))
  vsigma_0_ = t6 * t195
  vsigma_1_ = 0.0e0
  t209 = f.my_piecewise3(t50, 0, -0.3e1 / 0.8e1 * t5 * t57 * (0.12438750000000000000000000000000000000000000000000e-2 * t28 * t63 * t70 - 0.77645787187500000000000000000000000000000000000000e-5 * t58 / t60 / t165 / r1 * t170))
  vsigma_2_ = t6 * t209
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  _2d_b86_mgc_beta = 0.003317

  _2d_b86_mgc_gamma = 0.008323

  _2d_b86_mgc_f = lambda x: 1 + _2d_b86_mgc_beta / X_FACTOR_2D_C * x ** 2 / (1 + _2d_b86_mgc_gamma * x ** 2) ** (3 / 4)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_mgc_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = jnp.sqrt(jnp.pi)
  t21 = t20 * s0
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = r0 ** 2
  t25 = t18 ** 2
  t27 = 0.1e1 / t25 / t24
  t32 = 0.1e1 + 0.8323e-2 * s0 * t23 * t27
  t33 = t32 ** (0.1e1 / 0.4e1)
  t34 = t33 ** 2
  t35 = t34 * t33
  t36 = 0.1e1 / t35
  t40 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t21 * t23 * t27 * t36
  t44 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t40)
  t57 = s0 ** 2
  t59 = t24 ** 2
  t65 = 0.1e1 / t35 / t32
  t74 = f.my_piecewise3(t2, 0, -t6 * t17 / t25 * t40 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.33170000000000000000000000000000000000000000000000e-2 * t21 * t23 / t25 / t24 / r0 * t36 + 0.41411086500000000000000000000000000000000000000000e-4 * t20 * t57 * t22 / t18 / t59 / t24 * t65))
  vrho_0_ = 0.2e1 * r0 * t74 + 0.2e1 * t44
  t92 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.12438750000000000000000000000000000000000000000000e-2 * t20 * t23 * t27 * t36 - 0.15529157437500000000000000000000000000000000000000e-4 * t21 * t22 / t18 / t59 / r0 * t65))
  vsigma_0_ = 0.2e1 * r0 * t92
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = jnp.sqrt(jnp.pi)
  t23 = t22 * s0
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = r0 ** 2
  t28 = 0.1e1 / t19 / t26
  t33 = 0.1e1 + 0.8323e-2 * s0 * t25 * t28
  t34 = t33 ** (0.1e1 / 0.4e1)
  t35 = t34 ** 2
  t36 = t35 * t34
  t37 = 0.1e1 / t36
  t41 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t23 * t25 * t28 * t37
  t45 = t17 * t18
  t46 = t26 * r0
  t48 = 0.1e1 / t19 / t46
  t53 = s0 ** 2
  t54 = t22 * t53
  t55 = t26 ** 2
  t58 = 0.1e1 / t18 / t55 / t26
  t61 = 0.1e1 / t36 / t33
  t65 = -0.33170000000000000000000000000000000000000000000000e-2 * t23 * t25 * t48 * t37 + 0.41411086500000000000000000000000000000000000000000e-4 * t54 * t24 * t58 * t61
  t70 = f.my_piecewise3(t2, 0, -t6 * t21 * t41 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t45 * t65)
  t96 = t55 ** 2
  t99 = t33 ** 2
  t101 = 0.1e1 / t36 / t99
  t110 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t41 / 0.12e2 - t6 * t21 * t65 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t45 * (0.12162333333333333333333333333333333333333333333333e-1 * t23 * t25 / t19 / t55 * t37 - 0.37269977850000000000000000000000000000000000000000e-3 * t54 * t24 / t18 / t55 / t46 * t61 + 0.32168684141020000000000000000000000000000000000000e-5 * t22 * t53 * s0 / t96 / t26 * t101))
  v2rho2_0_ = 0.2e1 * r0 * t110 + 0.4e1 * t70
  t113 = t22 * t25
  t119 = 0.1e1 / t18 / t55 / r0
  t124 = 0.12438750000000000000000000000000000000000000000000e-2 * t113 * t28 * t37 - 0.15529157437500000000000000000000000000000000000000e-4 * t23 * t24 * t119 * t61
  t128 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t45 * t124)
  t135 = t22 * t24
  t150 = f.my_piecewise3(t2, 0, -t6 * t21 * t124 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t45 * (-0.33170000000000000000000000000000000000000000000000e-2 * t113 * t48 * t37 + 0.12423325950000000000000000000000000000000000000000e-3 * t135 * t58 * t61 * s0 - 0.12063256552882500000000000000000000000000000000000e-5 * t54 / t96 / r0 * t101))
  v2rhosigma_0_ = 0.2e1 * r0 * t150 + 0.2e1 * t128
  t164 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t45 * (-0.31058314875000000000000000000000000000000000000000e-4 * t135 * t119 * t61 + 0.45237212073309375000000000000000000000000000000000e-6 * t23 / t96 * t101))
  v2sigma2_0_ = 0.2e1 * r0 * t164
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = jnp.sqrt(jnp.pi)
  t24 = t23 * s0
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = r0 ** 2
  t29 = 0.1e1 / t19 / t27
  t34 = 0.1e1 + 0.8323e-2 * s0 * t26 * t29
  t35 = t34 ** (0.1e1 / 0.4e1)
  t36 = t35 ** 2
  t37 = t36 * t35
  t38 = 0.1e1 / t37
  t42 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t24 * t26 * t29 * t38
  t47 = t17 / t19
  t48 = t27 * r0
  t55 = s0 ** 2
  t56 = t23 * t55
  t57 = t27 ** 2
  t63 = 0.1e1 / t37 / t34
  t67 = -0.33170000000000000000000000000000000000000000000000e-2 * t24 * t26 / t19 / t48 * t38 + 0.41411086500000000000000000000000000000000000000000e-4 * t56 * t25 / t18 / t57 / t27 * t63
  t71 = t17 * t18
  t86 = t23 * t55 * s0
  t87 = t57 ** 2
  t90 = t34 ** 2
  t92 = 0.1e1 / t37 / t90
  t96 = 0.12162333333333333333333333333333333333333333333333e-1 * t24 * t26 / t19 / t57 * t38 - 0.37269977850000000000000000000000000000000000000000e-3 * t56 * t25 / t18 / t57 / t48 * t63 + 0.32168684141020000000000000000000000000000000000000e-5 * t86 / t87 / t27 * t92
  t101 = f.my_piecewise3(t2, 0, t6 * t22 * t42 / 0.12e2 - t6 * t47 * t67 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t71 * t96)
  t113 = t57 * r0
  t131 = t55 ** 2
  t148 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t29 * t42 + t6 * t22 * t67 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t47 * t96 - 0.3e1 / 0.8e1 * t6 * t71 * (-0.56757555555555555555555555555555555555555555555554e-1 * t24 * t26 / t19 / t113 * t38 + 0.31380401103333333333333333333333333333333333333333e-2 * t56 * t25 / t18 / t87 * t63 - 0.61120499867938000000000000000000000000000000000000e-4 * t86 / t87 / t48 * t92 + 0.19634263594418693733333333333333333333333333333334e-6 * t23 * t131 / t19 / t87 / t113 / t37 / t90 / t34 * t26))
  v3rho3_0_ = 0.2e1 * r0 * t148 + 0.6e1 * t101

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = jnp.sqrt(jnp.pi)
  t25 = t24 * s0
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t32 = 0.1e1 + 0.8323e-2 * s0 * t27 * t22
  t33 = t32 ** (0.1e1 / 0.4e1)
  t34 = t33 ** 2
  t35 = t34 * t33
  t36 = 0.1e1 / t35
  t40 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t25 * t27 * t22 * t36
  t46 = t17 / t20 / r0
  t47 = t18 * r0
  t49 = 0.1e1 / t20 / t47
  t54 = s0 ** 2
  t55 = t24 * t54
  t56 = t18 ** 2
  t57 = t56 * t18
  t62 = 0.1e1 / t35 / t32
  t66 = -0.33170000000000000000000000000000000000000000000000e-2 * t25 * t27 * t49 * t36 + 0.41411086500000000000000000000000000000000000000000e-4 * t55 * t26 / t19 / t57 * t62
  t71 = t17 / t20
  t86 = t24 * t54 * s0
  t87 = t56 ** 2
  t90 = t32 ** 2
  t92 = 0.1e1 / t35 / t90
  t96 = 0.12162333333333333333333333333333333333333333333333e-1 * t25 * t27 / t20 / t56 * t36 - 0.37269977850000000000000000000000000000000000000000e-3 * t55 * t26 / t19 / t56 / t47 * t62 + 0.32168684141020000000000000000000000000000000000000e-5 * t86 / t87 / t18 * t92
  t100 = t17 * t19
  t101 = t56 * r0
  t119 = t54 ** 2
  t120 = t24 * t119
  t126 = 0.1e1 / t35 / t90 / t32
  t131 = -0.56757555555555555555555555555555555555555555555554e-1 * t25 * t27 / t20 / t101 * t36 + 0.31380401103333333333333333333333333333333333333333e-2 * t55 * t26 / t19 / t87 * t62 - 0.61120499867938000000000000000000000000000000000000e-4 * t86 / t87 / t47 * t92 + 0.19634263594418693733333333333333333333333333333334e-6 * t120 / t20 / t87 / t101 * t126 * t27
  t136 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t40 + t6 * t46 * t66 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t71 * t96 - 0.3e1 / 0.8e1 * t6 * t100 * t131)
  t178 = t87 ** 2
  t182 = t90 ** 2
  t194 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t49 * t40 - 0.5e1 / 0.9e1 * t6 * t23 * t66 + t6 * t46 * t96 / 0.2e1 - t6 * t71 * t131 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t100 * (0.32162614814814814814814814814814814814814814814814e0 * t25 * t27 / t20 / t57 * t36 - 0.28039906792333333333333333333333333333333333333332e-1 * t55 * t26 / t19 / t87 / r0 * t62 + 0.91609263837149177777777777777777777777777777777778e-3 * t86 / t87 / t56 * t92 - 0.64138594408434399528888888888888888888888888888891e-5 * t120 / t20 / t87 / t57 * t126 * t27 + 0.32683195179269357588506666666666666666666666666668e-7 * t24 * t119 * s0 / t19 / t178 / r0 / t35 / t182 * t26))
  v4rho4_0_ = 0.2e1 * r0 * t194 + 0.8e1 * t136

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = jnp.sqrt(jnp.pi)
  t33 = t32 * s0
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t41 = 0.1e1 + 0.8323e-2 * s0 * t38
  t42 = t41 ** (0.1e1 / 0.4e1)
  t43 = t42 ** 2
  t44 = t43 * t42
  t45 = 0.1e1 / t44
  t49 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t33 * t38 * t45
  t53 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t54 = t53 * f.p.zeta_threshold
  t56 = f.my_piecewise3(t20, t54, t21 * t19)
  t57 = t30 ** 2
  t58 = 0.1e1 / t57
  t59 = t56 * t58
  t62 = t5 * t59 * t49 / 0.8e1
  t63 = t56 * t30
  t64 = t34 * r0
  t70 = s0 ** 2
  t71 = t32 * t70
  t72 = t34 ** 2
  t77 = 0.1e1 / t44 / t41
  t81 = -0.33170000000000000000000000000000000000000000000000e-2 * t33 / t36 / t64 * t45 + 0.20705543250000000000000000000000000000000000000000e-4 * t71 / t35 / t72 / t34 * t77
  t86 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t49 - t62 - 0.3e1 / 0.8e1 * t5 * t63 * t81)
  t88 = r1 <= f.p.dens_threshold
  t89 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t90 = 0.1e1 + t89
  t91 = t90 <= f.p.zeta_threshold
  t92 = t90 ** (0.1e1 / 0.3e1)
  t94 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t97 = f.my_piecewise3(t91, 0, 0.4e1 / 0.3e1 * t92 * t94)
  t98 = t97 * t30
  t99 = t32 * s2
  t100 = r1 ** 2
  t101 = r1 ** (0.1e1 / 0.3e1)
  t102 = t101 ** 2
  t104 = 0.1e1 / t102 / t100
  t107 = 0.1e1 + 0.8323e-2 * s2 * t104
  t108 = t107 ** (0.1e1 / 0.4e1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t111 = 0.1e1 / t110
  t115 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t99 * t104 * t111
  t120 = f.my_piecewise3(t91, t54, t92 * t90)
  t121 = t120 * t58
  t124 = t5 * t121 * t115 / 0.8e1
  t126 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t98 * t115 - t124)
  t128 = t21 ** 2
  t129 = 0.1e1 / t128
  t130 = t26 ** 2
  t135 = t16 / t22 / t6
  t137 = -0.2e1 * t23 + 0.2e1 * t135
  t138 = f.my_piecewise5(t10, 0, t14, 0, t137)
  t142 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t129 * t130 + 0.4e1 / 0.3e1 * t21 * t138)
  t149 = t5 * t29 * t58 * t49
  t155 = 0.1e1 / t57 / t6
  t159 = t5 * t56 * t155 * t49 / 0.12e2
  t161 = t5 * t59 * t81
  t176 = t72 ** 2
  t179 = t41 ** 2
  t190 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t142 * t30 * t49 - t149 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t81 + t159 - t161 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t63 * (0.12162333333333333333333333333333333333333333333333e-1 * t33 / t36 / t72 * t45 - 0.18634988925000000000000000000000000000000000000000e-3 * t71 / t35 / t72 / t64 * t77 + 0.80421710352550000000000000000000000000000000000001e-6 * t32 * t70 * s0 / t176 / t34 / t44 / t179))
  t191 = t92 ** 2
  t192 = 0.1e1 / t191
  t193 = t94 ** 2
  t197 = f.my_piecewise5(t14, 0, t10, 0, -t137)
  t201 = f.my_piecewise3(t91, 0, 0.4e1 / 0.9e1 * t192 * t193 + 0.4e1 / 0.3e1 * t92 * t197)
  t208 = t5 * t97 * t58 * t115
  t213 = t5 * t120 * t155 * t115 / 0.12e2
  t215 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t201 * t30 * t115 - t208 / 0.4e1 + t213)
  d11 = 0.2e1 * t86 + 0.2e1 * t126 + t6 * (t190 + t215)
  t218 = -t7 - t24
  t219 = f.my_piecewise5(t10, 0, t14, 0, t218)
  t222 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t219)
  t223 = t222 * t30
  t228 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t223 * t49 - t62)
  t230 = f.my_piecewise5(t14, 0, t10, 0, -t218)
  t233 = f.my_piecewise3(t91, 0, 0.4e1 / 0.3e1 * t92 * t230)
  t234 = t233 * t30
  t238 = t120 * t30
  t239 = t100 * r1
  t245 = s2 ** 2
  t246 = t32 * t245
  t247 = t100 ** 2
  t252 = 0.1e1 / t110 / t107
  t256 = -0.33170000000000000000000000000000000000000000000000e-2 * t99 / t102 / t239 * t111 + 0.20705543250000000000000000000000000000000000000000e-4 * t246 / t101 / t247 / t100 * t252
  t261 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t234 * t115 - t124 - 0.3e1 / 0.8e1 * t5 * t238 * t256)
  t265 = 0.2e1 * t135
  t266 = f.my_piecewise5(t10, 0, t14, 0, t265)
  t270 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t129 * t219 * t26 + 0.4e1 / 0.3e1 * t21 * t266)
  t277 = t5 * t222 * t58 * t49
  t285 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t270 * t30 * t49 - t277 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t223 * t81 - t149 / 0.8e1 + t159 - t161 / 0.8e1)
  t289 = f.my_piecewise5(t14, 0, t10, 0, -t265)
  t293 = f.my_piecewise3(t91, 0, 0.4e1 / 0.9e1 * t192 * t230 * t94 + 0.4e1 / 0.3e1 * t92 * t289)
  t300 = t5 * t233 * t58 * t115
  t307 = t5 * t121 * t256
  t310 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t293 * t30 * t115 - t300 / 0.8e1 - t208 / 0.8e1 + t213 - 0.3e1 / 0.8e1 * t5 * t98 * t256 - t307 / 0.8e1)
  d12 = t86 + t126 + t228 + t261 + t6 * (t285 + t310)
  t315 = t219 ** 2
  t319 = 0.2e1 * t23 + 0.2e1 * t135
  t320 = f.my_piecewise5(t10, 0, t14, 0, t319)
  t324 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t129 * t315 + 0.4e1 / 0.3e1 * t21 * t320)
  t331 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t324 * t30 * t49 - t277 / 0.4e1 + t159)
  t332 = t230 ** 2
  t336 = f.my_piecewise5(t14, 0, t10, 0, -t319)
  t340 = f.my_piecewise3(t91, 0, 0.4e1 / 0.9e1 * t192 * t332 + 0.4e1 / 0.3e1 * t92 * t336)
  t363 = t247 ** 2
  t366 = t107 ** 2
  t377 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t340 * t30 * t115 - t300 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t234 * t256 + t213 - t307 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t238 * (0.12162333333333333333333333333333333333333333333333e-1 * t99 / t102 / t247 * t111 - 0.18634988925000000000000000000000000000000000000000e-3 * t246 / t101 / t247 / t239 * t252 + 0.80421710352550000000000000000000000000000000000001e-6 * t32 * t245 * s2 / t363 / t100 / t110 / t366))
  d22 = 0.2e1 * t228 + 0.2e1 * t261 + t6 * (t331 + t377)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = jnp.sqrt(jnp.pi)
  t45 = t44 * s0
  t46 = r0 ** 2
  t47 = r0 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t50 = 0.1e1 / t48 / t46
  t53 = 0.1e1 + 0.8323e-2 * s0 * t50
  t54 = t53 ** (0.1e1 / 0.4e1)
  t55 = t54 ** 2
  t56 = t55 * t54
  t57 = 0.1e1 / t56
  t61 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t45 * t50 * t57
  t67 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t68 = t42 ** 2
  t69 = 0.1e1 / t68
  t70 = t67 * t69
  t74 = t67 * t42
  t75 = t46 * r0
  t81 = s0 ** 2
  t82 = t44 * t81
  t83 = t46 ** 2
  t88 = 0.1e1 / t56 / t53
  t92 = -0.33170000000000000000000000000000000000000000000000e-2 * t45 / t48 / t75 * t57 + 0.20705543250000000000000000000000000000000000000000e-4 * t82 / t47 / t83 / t46 * t88
  t96 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t97 = t96 * f.p.zeta_threshold
  t99 = f.my_piecewise3(t20, t97, t21 * t19)
  t101 = 0.1e1 / t68 / t6
  t102 = t99 * t101
  t106 = t99 * t69
  t110 = t99 * t42
  t123 = t44 * t81 * s0
  t124 = t83 ** 2
  t127 = t53 ** 2
  t129 = 0.1e1 / t56 / t127
  t133 = 0.12162333333333333333333333333333333333333333333333e-1 * t45 / t48 / t83 * t57 - 0.18634988925000000000000000000000000000000000000000e-3 * t82 / t47 / t83 / t75 * t88 + 0.80421710352550000000000000000000000000000000000001e-6 * t123 / t124 / t46 * t129
  t138 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t61 - t5 * t70 * t61 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t74 * t92 + t5 * t102 * t61 / 0.12e2 - t5 * t106 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t110 * t133)
  t140 = r1 <= f.p.dens_threshold
  t141 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t142 = 0.1e1 + t141
  t143 = t142 <= f.p.zeta_threshold
  t144 = t142 ** (0.1e1 / 0.3e1)
  t145 = t144 ** 2
  t146 = 0.1e1 / t145
  t148 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t149 = t148 ** 2
  t153 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t157 = f.my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t146 * t149 + 0.4e1 / 0.3e1 * t144 * t153)
  t160 = r1 ** 2
  t161 = r1 ** (0.1e1 / 0.3e1)
  t162 = t161 ** 2
  t164 = 0.1e1 / t162 / t160
  t168 = (0.1e1 + 0.8323e-2 * s2 * t164) ** (0.1e1 / 0.4e1)
  t169 = t168 ** 2
  t175 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t44 * s2 * t164 / t169 / t168
  t181 = f.my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t148)
  t187 = f.my_piecewise3(t143, t97, t144 * t142)
  t193 = f.my_piecewise3(t140, 0, -0.3e1 / 0.8e1 * t5 * t157 * t42 * t175 - t5 * t181 * t69 * t175 / 0.4e1 + t5 * t187 * t101 * t175 / 0.12e2)
  t203 = t24 ** 2
  t207 = 0.6e1 * t33 - 0.6e1 * t16 / t203
  t208 = f.my_piecewise5(t10, 0, t14, 0, t207)
  t212 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t208)
  t235 = 0.1e1 / t68 / t24
  t246 = t83 * r0
  t262 = t81 ** 2
  t278 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t212 * t42 * t61 - 0.3e1 / 0.8e1 * t5 * t41 * t69 * t61 - 0.9e1 / 0.8e1 * t5 * t43 * t92 + t5 * t67 * t101 * t61 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t70 * t92 - 0.9e1 / 0.8e1 * t5 * t74 * t133 - 0.5e1 / 0.36e2 * t5 * t99 * t235 * t61 + t5 * t102 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t106 * t133 - 0.3e1 / 0.8e1 * t5 * t110 * (-0.56757555555555555555555555555555555555555555555554e-1 * t45 / t48 / t246 * t57 + 0.15690200551666666666666666666666666666666666666667e-2 * t82 / t47 / t124 * t88 - 0.15280124966984500000000000000000000000000000000000e-4 * t123 / t124 / t75 * t129 + 0.49085658986046734333333333333333333333333333333334e-7 * t44 * t262 / t48 / t124 / t246 / t56 / t127 / t53))
  t288 = f.my_piecewise5(t14, 0, t10, 0, -t207)
  t292 = f.my_piecewise3(t143, 0, -0.8e1 / 0.27e2 / t145 / t142 * t149 * t148 + 0.4e1 / 0.3e1 * t146 * t148 * t153 + 0.4e1 / 0.3e1 * t144 * t288)
  t310 = f.my_piecewise3(t140, 0, -0.3e1 / 0.8e1 * t5 * t292 * t42 * t175 - 0.3e1 / 0.8e1 * t5 * t157 * t69 * t175 + t5 * t181 * t101 * t175 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t187 * t235 * t175)
  d111 = 0.3e1 * t138 + 0.3e1 * t193 + t6 * (t278 + t310)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = jnp.sqrt(jnp.pi)
  t57 = t56 * s0
  t58 = r0 ** 2
  t59 = r0 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t62 = 0.1e1 / t60 / t58
  t65 = 0.1e1 + 0.8323e-2 * s0 * t62
  t66 = t65 ** (0.1e1 / 0.4e1)
  t67 = t66 ** 2
  t68 = t67 * t66
  t69 = 0.1e1 / t68
  t73 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t57 * t62 * t69
  t82 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t83 = t54 ** 2
  t84 = 0.1e1 / t83
  t85 = t82 * t84
  t89 = t82 * t54
  t90 = t58 * r0
  t96 = s0 ** 2
  t97 = t56 * t96
  t98 = t58 ** 2
  t99 = t98 * t58
  t103 = 0.1e1 / t68 / t65
  t107 = -0.33170000000000000000000000000000000000000000000000e-2 * t57 / t60 / t90 * t69 + 0.20705543250000000000000000000000000000000000000000e-4 * t97 / t59 / t99 * t103
  t113 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t115 = 0.1e1 / t83 / t6
  t116 = t113 * t115
  t120 = t113 * t84
  t124 = t113 * t54
  t137 = t56 * t96 * s0
  t138 = t98 ** 2
  t141 = t65 ** 2
  t143 = 0.1e1 / t68 / t141
  t147 = 0.12162333333333333333333333333333333333333333333333e-1 * t57 / t60 / t98 * t69 - 0.18634988925000000000000000000000000000000000000000e-3 * t97 / t59 / t98 / t90 * t103 + 0.80421710352550000000000000000000000000000000000001e-6 * t137 / t138 / t58 * t143
  t151 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t152 = t151 * f.p.zeta_threshold
  t154 = f.my_piecewise3(t20, t152, t21 * t19)
  t156 = 0.1e1 / t83 / t25
  t157 = t154 * t156
  t161 = t154 * t115
  t165 = t154 * t84
  t169 = t154 * t54
  t170 = t98 * r0
  t186 = t96 ** 2
  t187 = t56 * t186
  t193 = 0.1e1 / t68 / t141 / t65
  t197 = -0.56757555555555555555555555555555555555555555555554e-1 * t57 / t60 / t170 * t69 + 0.15690200551666666666666666666666666666666666666667e-2 * t97 / t59 / t138 * t103 - 0.15280124966984500000000000000000000000000000000000e-4 * t137 / t138 / t90 * t143 + 0.49085658986046734333333333333333333333333333333334e-7 * t187 / t60 / t138 / t170 * t193
  t202 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t73 - 0.3e1 / 0.8e1 * t5 * t85 * t73 - 0.9e1 / 0.8e1 * t5 * t89 * t107 + t5 * t116 * t73 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t120 * t107 - 0.9e1 / 0.8e1 * t5 * t124 * t147 - 0.5e1 / 0.36e2 * t5 * t157 * t73 + t5 * t161 * t107 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t165 * t147 - 0.3e1 / 0.8e1 * t5 * t169 * t197)
  t204 = r1 <= f.p.dens_threshold
  t205 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t206 = 0.1e1 + t205
  t207 = t206 <= f.p.zeta_threshold
  t208 = t206 ** (0.1e1 / 0.3e1)
  t209 = t208 ** 2
  t211 = 0.1e1 / t209 / t206
  t213 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t214 = t213 ** 2
  t218 = 0.1e1 / t209
  t219 = t218 * t213
  t221 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t225 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t229 = f.my_piecewise3(t207, 0, -0.8e1 / 0.27e2 * t211 * t214 * t213 + 0.4e1 / 0.3e1 * t219 * t221 + 0.4e1 / 0.3e1 * t208 * t225)
  t232 = r1 ** 2
  t233 = r1 ** (0.1e1 / 0.3e1)
  t234 = t233 ** 2
  t236 = 0.1e1 / t234 / t232
  t240 = (0.1e1 + 0.8323e-2 * s2 * t236) ** (0.1e1 / 0.4e1)
  t241 = t240 ** 2
  t247 = 0.1e1 + 0.12438750000000000000000000000000000000000000000000e-2 * t56 * s2 * t236 / t241 / t240
  t256 = f.my_piecewise3(t207, 0, 0.4e1 / 0.9e1 * t218 * t214 + 0.4e1 / 0.3e1 * t208 * t221)
  t263 = f.my_piecewise3(t207, 0, 0.4e1 / 0.3e1 * t208 * t213)
  t269 = f.my_piecewise3(t207, t152, t208 * t206)
  t275 = f.my_piecewise3(t204, 0, -0.3e1 / 0.8e1 * t5 * t229 * t54 * t247 - 0.3e1 / 0.8e1 * t5 * t256 * t84 * t247 + t5 * t263 * t115 * t247 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t269 * t156 * t247)
  t304 = t138 ** 2
  t308 = t141 ** 2
  t332 = t19 ** 2
  t335 = t30 ** 2
  t341 = t41 ** 2
  t350 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t351 = f.my_piecewise5(t10, 0, t14, 0, t350)
  t355 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t332 * t335 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t341 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t351)
  t382 = 0.1e1 / t83 / t36
  t387 = -t5 * t165 * t197 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t169 * (0.32162614814814814814814814814814814814814814814814e0 * t57 / t60 / t99 * t69 - 0.14019953396166666666666666666666666666666666666667e-1 * t97 / t59 / t138 / r0 * t103 + 0.22902315959287294444444444444444444444444444444445e-3 * t137 / t138 / t98 * t143 - 0.16034648602108599882222222222222222222222222222222e-5 * t187 / t60 / t138 / t99 * t193 + 0.40853993974086696985633333333333333333333333333334e-8 * t56 * t186 * s0 / t59 / t304 / r0 / t68 / t308) + t5 * t116 * t107 - 0.3e1 / 0.2e1 * t5 * t120 * t147 - 0.3e1 / 0.2e1 * t5 * t124 * t197 - 0.5e1 / 0.9e1 * t5 * t157 * t107 + t5 * t161 * t147 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t355 * t54 * t73 - 0.3e1 / 0.2e1 * t5 * t55 * t107 - 0.3e1 / 0.2e1 * t5 * t85 * t107 - 0.9e1 / 0.4e1 * t5 * t89 * t147 - t5 * t53 * t84 * t73 / 0.2e1 + t5 * t82 * t115 * t73 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t113 * t156 * t73 + 0.10e2 / 0.27e2 * t5 * t154 * t382 * t73
  t388 = f.my_piecewise3(t1, 0, t387)
  t389 = t206 ** 2
  t392 = t214 ** 2
  t398 = t221 ** 2
  t404 = f.my_piecewise5(t14, 0, t10, 0, -t350)
  t408 = f.my_piecewise3(t207, 0, 0.40e2 / 0.81e2 / t209 / t389 * t392 - 0.16e2 / 0.9e1 * t211 * t214 * t221 + 0.4e1 / 0.3e1 * t218 * t398 + 0.16e2 / 0.9e1 * t219 * t225 + 0.4e1 / 0.3e1 * t208 * t404)
  t430 = f.my_piecewise3(t204, 0, -0.3e1 / 0.8e1 * t5 * t408 * t54 * t247 - t5 * t229 * t84 * t247 / 0.2e1 + t5 * t256 * t115 * t247 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t263 * t156 * t247 + 0.10e2 / 0.27e2 * t5 * t269 * t382 * t247)
  d1111 = 0.4e1 * t202 + 0.4e1 * t275 + t6 * (t388 + t430)

  res = {'v4rho4': d1111}
  return res
