"""Generated from gga_x_q2d.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q2d_cc = 100

  q2d_c1 = 0.5217

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q2d_f2 = lambda s: q2d_cc + s ** 6

  q2d_f1 = lambda s: pbe_f0(s) * (q2d_cc - s ** 4) + q2d_c1 * s ** 3.5 * (1 + s ** 2)

  q2d_f = lambda x: q2d_f1(X2S * x) / q2d_f2(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q2d_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q2d_cc = 100

  q2d_c1 = 0.5217

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q2d_f2 = lambda s: q2d_cc + s ** 6

  q2d_f1 = lambda s: pbe_f0(s) * (q2d_cc - s ** 4) + q2d_c1 * s ** 3.5 * (1 + s ** 2)

  q2d_f = lambda x: q2d_f1(X2S * x) / q2d_f2(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q2d_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q2d_cc = 100

  q2d_c1 = 0.5217

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q2d_f2 = lambda s: q2d_cc + s ** 6

  q2d_f1 = lambda s: pbe_f0(s) * (q2d_cc - s ** 4) + q2d_c1 * s ** 3.5 * (1 + s ** 2)

  q2d_f = lambda x: q2d_f1(X2S * x) / q2d_f2(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q2d_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t42 = 0.8040e0 + 0.5e1 / 0.972e3 * t40
  t45 = 0.18040e1 - 0.64641600e0 / t42
  t46 = t28 ** 2
  t48 = 0.1e1 / t30 / t29
  t49 = t46 * t48
  t50 = s0 ** 2
  t51 = t34 ** 2
  t54 = 0.1e1 / t35 / t51 / r0
  t58 = 0.100e3 - t49 * t50 * t54 / 0.576e3
  t60 = 0.1e1 / t30
  t61 = t46 * t60
  t62 = jnp.sqrt(s0)
  t64 = 0.1e1 / t35 / r0
  t66 = t61 * t62 * t64
  t67 = t66 ** 0.35e1
  t69 = 0.1e1 + t40 / 0.24e2
  t72 = t45 * t58 + 0.87153829697982569833455705667786806889859326862737e-4 * t67 * t69
  t74 = t29 ** 2
  t75 = 0.1e1 / t74
  t76 = t50 * s0
  t78 = t51 ** 2
  t79 = 0.1e1 / t78
  t82 = 0.100e3 + t75 * t76 * t79 / 0.2304e4
  t83 = 0.1e1 / t82
  t84 = t27 * t72 * t83
  t87 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t84)
  t88 = r1 <= f.p.dens_threshold
  t89 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t90 = 0.1e1 + t89
  t91 = t90 <= f.p.zeta_threshold
  t92 = t90 ** (0.1e1 / 0.3e1)
  t94 = f.my_piecewise3(t91, t22, t92 * t90)
  t95 = t5 * t94
  t96 = r1 ** 2
  t97 = r1 ** (0.1e1 / 0.3e1)
  t98 = t97 ** 2
  t100 = 0.1e1 / t98 / t96
  t102 = t33 * s2 * t100
  t104 = 0.8040e0 + 0.5e1 / 0.972e3 * t102
  t107 = 0.18040e1 - 0.64641600e0 / t104
  t108 = s2 ** 2
  t109 = t96 ** 2
  t112 = 0.1e1 / t97 / t109 / r1
  t116 = 0.100e3 - t49 * t108 * t112 / 0.576e3
  t118 = jnp.sqrt(s2)
  t120 = 0.1e1 / t97 / r1
  t122 = t61 * t118 * t120
  t123 = t122 ** 0.35e1
  t125 = 0.1e1 + t102 / 0.24e2
  t128 = t107 * t116 + 0.87153829697982569833455705667786806889859326862737e-4 * t123 * t125
  t130 = t108 * s2
  t132 = t109 ** 2
  t133 = 0.1e1 / t132
  t136 = 0.100e3 + t75 * t130 * t133 / 0.2304e4
  t137 = 0.1e1 / t136
  t138 = t27 * t128 * t137
  t141 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t95 * t138)
  t142 = t6 ** 2
  t144 = t16 / t142
  t145 = t7 - t144
  t146 = f.my_piecewise5(t10, 0, t14, 0, t145)
  t149 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t146)
  t153 = t27 ** 2
  t154 = 0.1e1 / t153
  t158 = t26 * t154 * t72 * t83 / 0.8e1
  t159 = t42 ** 2
  t161 = 0.1e1 / t159 * t28
  t165 = 0.1e1 / t36 / t34 / r0
  t170 = t45 * t46
  t178 = t66 ** 0.25e1
  t180 = t178 * t69 * t46
  t187 = t67 * t28
  t199 = t2 / t3 / t74
  t201 = t199 * t25 * t27
  t202 = t82 ** 2
  t204 = t72 / t202
  t212 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t149 * t84 - t158 - 0.3e1 / 0.8e1 * t26 * t27 * (-0.88671604938271604938271604938271604938271604938272e-2 * t161 * t32 * s0 * t165 * t58 + t170 * t48 * t50 / t35 / t51 / t34 / 0.108e3 - 0.40671787192391865922279329311633843215267685869278e-3 * t180 * t60 * t62 / t35 / t34 - 0.96837588553313966481617450741985340988732585403041e-5 * t187 * t32 * s0 * t165) * t83 - t201 * t204 * t76 / t78 / r0 / 0.768e3)
  t214 = f.my_piecewise5(t14, 0, t10, 0, -t145)
  t217 = f.my_piecewise3(t91, 0, 0.4e1 / 0.3e1 * t92 * t214)
  t224 = t95 * t154 * t128 * t137 / 0.8e1
  t226 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t217 * t138 - t224)
  vrho_0_ = t87 + t141 + t6 * (t212 + t226)
  t229 = -t7 - t144
  t230 = f.my_piecewise5(t10, 0, t14, 0, t229)
  t233 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t230)
  t238 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t233 * t84 - t158)
  t240 = f.my_piecewise5(t14, 0, t10, 0, -t229)
  t243 = f.my_piecewise3(t91, 0, 0.4e1 / 0.3e1 * t92 * t240)
  t247 = t104 ** 2
  t249 = 0.1e1 / t247 * t28
  t253 = 0.1e1 / t98 / t96 / r1
  t258 = t107 * t46
  t266 = t122 ** 0.25e1
  t268 = t266 * t125 * t46
  t275 = t123 * t28
  t286 = t199 * t94 * t27
  t287 = t136 ** 2
  t289 = t128 / t287
  t297 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t5 * t243 * t138 - t224 - 0.3e1 / 0.8e1 * t95 * t27 * (-0.88671604938271604938271604938271604938271604938272e-2 * t249 * t32 * s2 * t253 * t116 + t258 * t48 * t108 / t97 / t109 / t96 / 0.108e3 - 0.40671787192391865922279329311633843215267685869278e-3 * t268 * t60 * t118 / t97 / t96 - 0.96837588553313966481617450741985340988732585403041e-5 * t275 * t32 * s2 * t253) * t137 - t286 * t289 * t130 / t132 / r1 / 0.768e3)
  vrho_1_ = t87 + t141 + t6 * (t238 + t297)
  t300 = t32 * t38
  t325 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * (0.33251851851851851851851851851851851851851851851852e-2 * t161 * t300 * t58 - t170 * t48 * s0 * t54 / 0.288e3 + 0.15251920197146949720854748491862691205725382200979e-3 * t180 * t60 / t62 * t64 + 0.36314095707492737430606544028244502870774719526140e-5 * t187 * t300) * t83 + t201 * t204 * t50 * t79 / 0.2048e4)
  vsigma_0_ = t6 * t325
  vsigma_1_ = 0.0e0
  t326 = t32 * t100
  t351 = f.my_piecewise3(t88, 0, -0.3e1 / 0.8e1 * t95 * t27 * (0.33251851851851851851851851851851851851851851851852e-2 * t249 * t326 * t116 - t258 * t48 * s2 * t112 / 0.288e3 + 0.15251920197146949720854748491862691205725382200979e-3 * t268 * t60 / t118 * t120 + 0.36314095707492737430606544028244502870774719526140e-5 * t275 * t326) * t137 + t286 * t289 * t108 * t133 / 0.2048e4)
  vsigma_2_ = t6 * t351
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q2d_cc = 100

  q2d_c1 = 0.5217

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q2d_f2 = lambda s: q2d_cc + s ** 6

  q2d_f1 = lambda s: pbe_f0(s) * (q2d_cc - s ** 4) + q2d_c1 * s ** 3.5 * (1 + s ** 2)

  q2d_f = lambda x: q2d_f1(X2S * x) / q2d_f2(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q2d_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t19 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t20 * t24 * t28 * t32
  t36 = 0.8040e0 + 0.5e1 / 0.972e3 * t34
  t39 = 0.18040e1 - 0.64641600e0 / t36
  t40 = t20 ** 2
  t42 = 0.1e1 / t22 / t21
  t44 = s0 ** 2
  t45 = t44 * t26
  t46 = t29 ** 2
  t49 = 0.1e1 / t19 / t46 / r0
  t53 = 0.100e3 - t40 * t42 * t45 * t49 / 0.288e3
  t55 = 0.1e1 / t22
  t57 = jnp.sqrt(s0)
  t60 = 0.1e1 / t19 / r0
  t62 = t40 * t55 * t57 * t26 * t60
  t63 = t62 ** 0.35e1
  t65 = 0.1e1 + t34 / 0.24e2
  t68 = t39 * t53 + 0.87153829697982569833455705667786806889859326862737e-4 * t63 * t65
  t70 = t21 ** 2
  t72 = t44 * s0
  t74 = t46 ** 2
  t78 = 0.100e3 + 0.1e1 / t70 * t72 / t74 / 0.576e3
  t79 = 0.1e1 / t78
  t83 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t68 * t79)
  t89 = t36 ** 2
  t92 = 0.1e1 / t89 * t20 * t24
  t93 = t29 * r0
  t95 = 0.1e1 / t30 / t93
  t101 = t39 * t40 * t42
  t108 = t62 ** 0.25e1
  t110 = t108 * t65 * t40
  t118 = t63 * t20
  t131 = t3 / t4 / t70 * t17
  t135 = t78 ** 2
  t136 = 0.1e1 / t135
  t142 = f.my_piecewise3(t2, 0, -t18 / t30 * t68 * t79 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * (-0.88671604938271604938271604938271604938271604938272e-2 * t92 * t28 * t95 * t53 + t101 * t45 / t19 / t46 / t29 / 0.54e2 - 0.40671787192391865922279329311633843215267685869278e-3 * t110 * t55 * t57 * t26 / t19 / t29 - 0.96837588553313966481617450741985340988732585403041e-5 * t118 * t24 * t28 * t95) * t79 - t131 / t30 / t74 * t68 * t136 * t72 / 0.192e3)
  vrho_0_ = 0.2e1 * r0 * t142 + 0.2e1 * t83
  t177 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * (0.33251851851851851851851851851851851851851851851852e-2 * t92 * t27 * t32 * t53 - t101 * s0 * t26 * t49 / 0.144e3 + 0.15251920197146949720854748491862691205725382200979e-3 * t110 * t55 / t57 * t26 * t60 + 0.36314095707492737430606544028244502870774719526140e-5 * t118 * t24 * t27 * t32) * t79 + t131 / t30 / t46 / t93 * t68 * t136 * t44 / 0.512e3)
  vsigma_0_ = 0.2e1 * r0 * t177
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t20 / t31
  t35 = t22 * t26 * t30 * t33
  t37 = 0.8040e0 + 0.5e1 / 0.972e3 * t35
  t40 = 0.18040e1 - 0.64641600e0 / t37
  t41 = t22 ** 2
  t43 = 0.1e1 / t24 / t23
  t45 = s0 ** 2
  t46 = t45 * t28
  t47 = t31 ** 2
  t48 = t47 * r0
  t50 = 0.1e1 / t19 / t48
  t54 = 0.100e3 - t41 * t43 * t46 * t50 / 0.288e3
  t56 = 0.1e1 / t24
  t58 = jnp.sqrt(s0)
  t61 = 0.1e1 / t19 / r0
  t63 = t41 * t56 * t58 * t28 * t61
  t64 = t63 ** 0.35e1
  t66 = 0.1e1 + t35 / 0.24e2
  t69 = t40 * t54 + 0.87153829697982569833455705667786806889859326862737e-4 * t64 * t66
  t71 = t23 ** 2
  t72 = 0.1e1 / t71
  t73 = t45 * s0
  t75 = t47 ** 2
  t76 = 0.1e1 / t75
  t79 = 0.100e3 + t72 * t73 * t76 / 0.576e3
  t80 = 0.1e1 / t79
  t84 = t37 ** 2
  t85 = 0.1e1 / t84
  t87 = t85 * t22 * t26
  t88 = t31 * r0
  t90 = 0.1e1 / t20 / t88
  t95 = t40 * t41
  t96 = t95 * t43
  t97 = t47 * t31
  t99 = 0.1e1 / t19 / t97
  t103 = t63 ** 0.25e1
  t105 = t103 * t66 * t41
  t106 = t56 * t58
  t109 = t28 / t19 / t31
  t113 = t64 * t22
  t114 = t113 * t26
  t118 = -0.88671604938271604938271604938271604938271604938272e-2 * t87 * t30 * t90 * t54 + t96 * t46 * t99 / 0.54e2 - 0.40671787192391865922279329311633843215267685869278e-3 * t105 * t106 * t109 - 0.96837588553313966481617450741985340988732585403041e-5 * t114 * t30 * t90
  t126 = t3 / t4 / t71 * t17
  t128 = 0.1e1 / t20 / t75
  t129 = t128 * t69
  t130 = t79 ** 2
  t131 = 0.1e1 / t130
  t132 = t131 * t73
  t137 = f.my_piecewise3(t2, 0, -t18 * t21 * t69 * t80 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t118 * t80 - t126 * t129 * t132 / 0.192e3)
  t149 = t75 * r0
  t159 = 0.1e1 / t84 / t37 * t41 * t43
  t160 = t47 * t88
  t162 = 0.1e1 / t19 / t160
  t168 = 0.1e1 / t20 / t47
  t173 = t85 * t72
  t182 = t63 ** 0.15e1
  t184 = t182 * t66 * t22
  t191 = t103 / t23
  t192 = t58 * s0
  t215 = t71 ** 2
  t219 = t3 / t4 / t215 * t17
  t220 = t75 ** 2
  t226 = 0.1e1 / t130 / t79
  t227 = t45 ** 2
  t234 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t69 * t80 / 0.12e2 - t18 * t21 * t118 * t80 / 0.4e1 + 0.25e2 / 0.576e3 * t126 / t20 / t149 * t69 * t132 - 0.3e1 / 0.8e1 * t18 * t19 * (-0.48653829870107876509339700926349303121136683093702e-3 * t159 * t46 * t162 * t54 + 0.32512921810699588477366255144032921810699588477366e-1 * t87 * t30 * t168 * t54 - 0.39409602194787379972565157750342935528120713305899e-2 * t173 * t73 / t75 / t31 - 0.19e2 / 0.162e3 * t96 * t46 * t162 + 0.81343574384783731844558658623267686430535371738556e-2 * t184 * t26 * s0 * t29 * t168 + 0.10845809917971164245941154483102358190738049565141e-2 * t191 * t192 / t97 + 0.94900836782247687151985101727145634168957933694982e-3 * t105 * t106 * t28 / t19 / t88 + 0.35507115802881787709926398605394625029201947981115e-4 * t114 * t30 * t168) * t80 - t126 * t128 * t118 * t132 / 0.96e2 - t219 / t20 / t220 / r0 * t69 * t226 * t227 * t45 / 0.6912e4)
  v2rho2_0_ = 0.2e1 * r0 * t234 + 0.4e1 * t137
  t237 = t29 * t33
  t241 = s0 * t28
  t245 = 0.1e1 / t58
  t246 = t56 * t245
  t247 = t28 * t61
  t251 = t26 * t29
  t255 = 0.33251851851851851851851851851851851851851851851852e-2 * t87 * t237 * t54 - t96 * t241 * t50 / 0.144e3 + 0.15251920197146949720854748491862691205725382200979e-3 * t105 * t246 * t247 + 0.36314095707492737430606544028244502870774719526140e-5 * t113 * t251 * t33
  t261 = 0.1e1 / t20 / t160
  t262 = t261 * t69
  t263 = t131 * t45
  t268 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t255 * t80 + t126 * t262 * t263 / 0.512e3)
  t289 = t251 * t90
  t326 = f.my_piecewise3(t2, 0, -t18 * t21 * t255 * t80 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * (0.18245186201290453691002387847380988670426256160138e-3 * t159 * t28 * t99 * t54 * s0 - 0.88671604938271604938271604938271604938271604938272e-2 * t87 * t29 * t90 * t54 + 0.14778600823045267489711934156378600823045267489712e-2 * t173 / t149 * t45 + t96 * t241 * t99 / 0.27e2 - 0.30503840394293899441709496983725382411450764401958e-2 * t184 * t289 - 0.40671787192391865922279329311633843215267685869277e-3 * t191 * t58 / t48 - 0.20335893596195932961139664655816921607633842934639e-3 * t105 * t246 * t109 - 0.96837588553313966481617450741985340988732585403040e-5 * t113 * t289) * t80 - t126 * t128 * t255 * t132 / 0.192e3 - 0.23e2 / 0.1536e4 * t126 * t129 * t263 + t126 * t261 * t118 * t263 / 0.512e3 + t219 / t20 / t220 * t69 * t226 * t227 * s0 / 0.18432e5)
  v2rhosigma_0_ = 0.2e1 * r0 * t326 + 0.2e1 * t268
  t376 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * (-0.68419448254839201341258954427678707514098460600519e-4 * t159 * t28 * t50 * t54 - 0.55419753086419753086419753086419753086419753086420e-3 * t173 * t76 * s0 - t95 * t43 * t28 * t50 / 0.144e3 + 0.11438940147860212290641061368897018404294036650734e-2 * t184 * t26 / s0 * t237 + 0.15251920197146949720854748491862691205725382200979e-3 * t191 / t47 * t245 - 0.76259600985734748604273742459313456028626911004895e-4 * t105 * t56 / t192 * t247) * t80 + t126 * t261 * t255 * t263 / 0.256e3 - t219 / t20 / t75 / t160 * t69 * t226 * t227 / 0.49152e5 + t126 * t262 * t131 * s0 / 0.256e3)
  v2sigma2_0_ = 0.2e1 * r0 * t376
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t20 / t32
  t36 = t23 * t27 * t31 * t34
  t38 = 0.8040e0 + 0.5e1 / 0.972e3 * t36
  t41 = 0.18040e1 - 0.64641600e0 / t38
  t42 = t23 ** 2
  t44 = 0.1e1 / t25 / t24
  t46 = s0 ** 2
  t47 = t46 * t29
  t48 = t32 ** 2
  t49 = t48 * r0
  t55 = 0.100e3 - t42 * t44 * t47 / t19 / t49 / 0.288e3
  t57 = 0.1e1 / t25
  t59 = jnp.sqrt(s0)
  t64 = t42 * t57 * t59 * t29 / t19 / r0
  t65 = t64 ** 0.35e1
  t67 = 0.1e1 + t36 / 0.24e2
  t70 = t41 * t55 + 0.87153829697982569833455705667786806889859326862737e-4 * t65 * t67
  t72 = t24 ** 2
  t73 = 0.1e1 / t72
  t74 = t46 * s0
  t76 = t48 ** 2
  t80 = 0.100e3 + t73 * t74 / t76 / 0.576e3
  t81 = 0.1e1 / t80
  t85 = 0.1e1 / t20
  t86 = t38 ** 2
  t87 = 0.1e1 / t86
  t89 = t87 * t23 * t27
  t90 = t32 * r0
  t92 = 0.1e1 / t20 / t90
  t98 = t41 * t42 * t44
  t99 = t48 * t32
  t105 = t64 ** 0.25e1
  t107 = t105 * t67 * t42
  t108 = t57 * t59
  t116 = t65 * t23 * t27
  t120 = -0.88671604938271604938271604938271604938271604938272e-2 * t89 * t31 * t92 * t55 + t98 * t47 / t19 / t99 / 0.54e2 - 0.40671787192391865922279329311633843215267685869278e-3 * t107 * t108 * t29 / t19 / t32 - 0.96837588553313966481617450741985340988732585403041e-5 * t116 * t31 * t92
  t128 = t3 / t4 / t72 * t17
  t131 = 0.1e1 / t20 / t76 / r0
  t133 = t80 ** 2
  t135 = 0.1e1 / t133 * t74
  t140 = 0.1e1 / t86 / t38
  t142 = t140 * t42 * t44
  t143 = t48 * t90
  t145 = 0.1e1 / t19 / t143
  t151 = 0.1e1 / t20 / t48
  t156 = t87 * t73
  t157 = t76 * t32
  t165 = t64 ** 0.15e1
  t167 = t165 * t67 * t23
  t168 = t27 * s0
  t173 = 0.1e1 / t24
  t174 = t105 * t173
  t175 = t59 * s0
  t189 = -0.48653829870107876509339700926349303121136683093702e-3 * t142 * t47 * t145 * t55 + 0.32512921810699588477366255144032921810699588477366e-1 * t89 * t31 * t151 * t55 - 0.39409602194787379972565157750342935528120713305899e-2 * t156 * t74 / t157 - 0.19e2 / 0.162e3 * t98 * t47 * t145 + 0.81343574384783731844558658623267686430535371738556e-2 * t167 * t168 * t30 * t151 + 0.10845809917971164245941154483102358190738049565141e-2 * t174 * t175 / t99 + 0.94900836782247687151985101727145634168957933694982e-3 * t107 * t108 * t29 / t19 / t90 + 0.35507115802881787709926398605394625029201947981115e-4 * t116 * t31 * t151
  t195 = 0.1e1 / t20 / t76
  t200 = t72 ** 2
  t204 = t3 / t4 / t200 * t17
  t205 = t76 ** 2
  t208 = 0.1e1 / t20 / t205 / r0
  t212 = t46 ** 2
  t214 = 0.1e1 / t133 / t80 * t212 * t46
  t219 = f.my_piecewise3(t2, 0, t18 * t22 * t70 * t81 / 0.12e2 - t18 * t85 * t120 * t81 / 0.4e1 + 0.25e2 / 0.576e3 * t128 * t131 * t70 * t135 - 0.3e1 / 0.8e1 * t18 * t19 * t189 * t81 - t128 * t195 * t120 * t135 / 0.96e2 - t204 * t208 * t70 * t214 / 0.6912e4)
  t250 = t86 ** 2
  t255 = t74 / t76 / t90
  t260 = 0.1e1 / t19 / t76
  t272 = 0.1e1 / t20 / t76 / t49
  t277 = 0.1e1 / t20 / t49
  t291 = t47 * t260
  t294 = t64 ** 0.5e0
  t297 = 0.1e1 / t143
  t328 = -0.24026582651905124202143062185851507714141571898124e-3 / t250 * t73 * t255 * t55 + 0.53519212857118664160273671018984233433250351403072e-2 * t142 * t47 * t260 * t55 - 0.54059810966786529454821889918165892356818536770780e-4 * t140 * t23 / t26 / t72 * t212 * t30 * t272 - 0.15172696844993141289437585733882030178326474622771e0 * t89 * t31 * t277 * t55 + 0.59114403292181069958847736625514403292181069958849e-1 * t156 * t255 - 0.10811962193357305890964377983633178471363707354156e-3 * t140 * t73 * t212 * t272 * t23 * t27 * t30 + 0.209e3 / 0.243e3 * t98 * t291 - 0.19522457852348095642694078069584244743328489217253e0 * t294 * t67 * t173 * t175 * t297 - 0.18076349863285273743235257471837263651230082608568e-2 * t165 * t42 * t44 * t291 - 0.56940502069348612291191061036287380501374760216989e-1 * t167 * t168 * t30 * t277 - 0.36152699726570547486470514943674527302460165217136e-2 * t165 * t173 * t46 * t260 * t42 * t57 * t29 - 0.97612289261740478213470390347921223716642446086268e-2 * t174 * t175 * t297 - 0.31633612260749229050661700575715211389652644564994e-2 * t107 * t108 * t29 / t19 / t48 - 0.16569987374678167597965652682517491680294242391187e-3 * t116 * t31 * t277
  t350 = t133 ** 2
  t352 = t212 ** 2
  t359 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t34 * t70 * t81 + t18 * t22 * t120 * t81 / 0.4e1 - 0.241e3 / 0.576e3 * t128 / t20 / t157 * t70 * t135 - 0.3e1 / 0.8e1 * t18 * t85 * t189 * t81 + 0.25e2 / 0.192e3 * t128 * t131 * t120 * t135 + 0.13e2 / 0.3456e4 * t204 / t20 / t205 / t32 * t70 * t214 - 0.3e1 / 0.8e1 * t18 * t19 * t328 * t81 - t128 * t195 * t189 * t135 / 0.64e2 - t204 * t208 * t120 * t214 / 0.2304e4 - t3 / t4 / t200 / t72 * t17 / t20 / t205 / t157 * t70 / t350 * t352 * s0 / 0.165888e6)
  v3rho3_0_ = 0.2e1 * r0 * t359 + 0.6e1 * t219

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t34 = t24 * t28 * t32 * t23
  t36 = 0.8040e0 + 0.5e1 / 0.972e3 * t34
  t39 = 0.18040e1 - 0.64641600e0 / t36
  t40 = t24 ** 2
  t42 = 0.1e1 / t26 / t25
  t44 = s0 ** 2
  t45 = t44 * t30
  t46 = t19 ** 2
  t47 = t46 * r0
  t49 = 0.1e1 / t20 / t47
  t53 = 0.100e3 - t40 * t42 * t45 * t49 / 0.288e3
  t55 = 0.1e1 / t26
  t57 = jnp.sqrt(s0)
  t62 = t40 * t55 * t57 * t30 / t20 / r0
  t63 = t62 ** 0.35e1
  t65 = 0.1e1 + t34 / 0.24e2
  t68 = t39 * t53 + 0.87153829697982569833455705667786806889859326862737e-4 * t63 * t65
  t70 = t25 ** 2
  t71 = 0.1e1 / t70
  t72 = t44 * s0
  t74 = t46 ** 2
  t75 = 0.1e1 / t74
  t78 = 0.100e3 + t71 * t72 * t75 / 0.576e3
  t79 = 0.1e1 / t78
  t84 = 0.1e1 / t21 / r0
  t85 = t36 ** 2
  t86 = 0.1e1 / t85
  t88 = t86 * t24 * t28
  t89 = t19 * r0
  t91 = 0.1e1 / t21 / t89
  t97 = t39 * t40 * t42
  t98 = t46 * t19
  t104 = t62 ** 0.25e1
  t106 = t104 * t65 * t40
  t107 = t55 * t57
  t115 = t63 * t24 * t28
  t119 = -0.88671604938271604938271604938271604938271604938272e-2 * t88 * t32 * t91 * t53 + t97 * t45 / t20 / t98 / 0.54e2 - 0.40671787192391865922279329311633843215267685869278e-3 * t106 * t107 * t30 / t20 / t19 - 0.96837588553313966481617450741985340988732585403041e-5 * t115 * t32 * t91
  t127 = t3 / t4 / t70 * t17
  t128 = t74 * t19
  t130 = 0.1e1 / t21 / t128
  t132 = t78 ** 2
  t134 = 0.1e1 / t132 * t72
  t138 = 0.1e1 / t21
  t140 = 0.1e1 / t85 / t36
  t142 = t140 * t40 * t42
  t143 = t46 * t89
  t145 = 0.1e1 / t20 / t143
  t151 = 0.1e1 / t21 / t46
  t156 = t86 * t71
  t164 = t62 ** 0.15e1
  t166 = t164 * t65 * t24
  t167 = t28 * s0
  t172 = 0.1e1 / t25
  t173 = t104 * t172
  t174 = t57 * s0
  t188 = -0.48653829870107876509339700926349303121136683093702e-3 * t142 * t45 * t145 * t53 + 0.32512921810699588477366255144032921810699588477366e-1 * t88 * t32 * t151 * t53 - 0.39409602194787379972565157750342935528120713305899e-2 * t156 * t72 / t128 - 0.19e2 / 0.162e3 * t97 * t45 * t145 + 0.81343574384783731844558658623267686430535371738556e-2 * t166 * t167 * t31 * t151 + 0.10845809917971164245941154483102358190738049565141e-2 * t173 * t174 / t98 + 0.94900836782247687151985101727145634168957933694982e-3 * t106 * t107 * t30 / t20 / t89 + 0.35507115802881787709926398605394625029201947981115e-4 * t115 * t32 * t151
  t193 = t74 * r0
  t195 = 0.1e1 / t21 / t193
  t200 = t70 ** 2
  t204 = t3 / t4 / t200 * t17
  t205 = t74 ** 2
  t208 = 0.1e1 / t21 / t205 / t19
  t212 = t44 ** 2
  t214 = 0.1e1 / t132 / t78 * t212 * t44
  t218 = t85 ** 2
  t219 = 0.1e1 / t218
  t220 = t219 * t71
  t221 = t74 * t89
  t223 = t72 / t221
  t228 = 0.1e1 / t20 / t74
  t236 = t140 * t24 / t27 / t70
  t237 = t212 * t31
  t240 = 0.1e1 / t21 / t74 / t47
  t245 = 0.1e1 / t21 / t47
  t253 = t140 * t71 * t212
  t255 = t28 * t31
  t259 = t45 * t228
  t262 = t62 ** 0.5e0
  t263 = t262 * t65
  t264 = t172 * t174
  t265 = 0.1e1 / t143
  t270 = t164 * t40 * t42
  t278 = t164 * t172 * t44
  t280 = t55 * t30
  t296 = -0.24026582651905124202143062185851507714141571898124e-3 * t220 * t223 * t53 + 0.53519212857118664160273671018984233433250351403072e-2 * t142 * t45 * t228 * t53 - 0.54059810966786529454821889918165892356818536770780e-4 * t236 * t237 * t240 - 0.15172696844993141289437585733882030178326474622771e0 * t88 * t32 * t245 * t53 + 0.59114403292181069958847736625514403292181069958849e-1 * t156 * t223 - 0.10811962193357305890964377983633178471363707354156e-3 * t253 * t240 * t24 * t255 + 0.209e3 / 0.243e3 * t97 * t259 - 0.19522457852348095642694078069584244743328489217253e0 * t263 * t264 * t265 - 0.18076349863285273743235257471837263651230082608568e-2 * t270 * t259 - 0.56940502069348612291191061036287380501374760216989e-1 * t166 * t167 * t31 * t245 - 0.36152699726570547486470514943674527302460165217136e-2 * t278 * t228 * t40 * t280 - 0.97612289261740478213470390347921223716642446086268e-2 * t173 * t174 * t265 - 0.31633612260749229050661700575715211389652644564994e-2 * t106 * t107 * t30 / t20 / t46 - 0.16569987374678167597965652682517491680294242391187e-3 * t115 * t32 * t245
  t302 = 0.1e1 / t21 / t74
  t307 = t205 * r0
  t309 = 0.1e1 / t21 / t307
  t318 = t3 / t4 / t200 / t70 * t17
  t321 = 0.1e1 / t21 / t205 / t128
  t323 = t132 ** 2
  t325 = t212 ** 2
  t327 = 0.1e1 / t323 * t325 * s0
  t332 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t23 * t68 * t79 + t18 * t84 * t119 * t79 / 0.4e1 - 0.241e3 / 0.576e3 * t127 * t130 * t68 * t134 - 0.3e1 / 0.8e1 * t18 * t138 * t188 * t79 + 0.25e2 / 0.192e3 * t127 * t195 * t119 * t134 + 0.13e2 / 0.3456e4 * t204 * t208 * t68 * t214 - 0.3e1 / 0.8e1 * t18 * t20 * t296 * t79 - t127 * t302 * t188 * t134 / 0.64e2 - t204 * t309 * t119 * t214 / 0.2304e4 - t318 * t321 * t68 * t327 / 0.165888e6)
  t336 = t72 / t74 / t46
  t342 = 0.1e1 / t21 / t74 / t98
  t351 = t212 * s0
  t354 = 0.1e1 / t20 / t307
  t361 = t262 * t24
  t366 = t57 * t44 * t31
  t371 = 0.1e1 / t21 / t98
  t380 = 0.1e1 / t20 / t193
  t381 = t45 * t380
  t397 = t62 ** (-0.5e0)
  t402 = t380 * t40 * t280
  t437 = 0.52858481834191273244714736808873316971111458175873e-2 * t220 * t336 * t53 + 0.13334753371807343932189399513147586781348572403459e-2 * t236 * t237 * t342 - 0.44493671577602081855820485529354643915076984996527e-5 * t219 * t40 / t26 / t70 / t25 * t351 * t30 * t354 + 0.27331440993287333899771709297417942640659884904154e1 * t263 * t264 * t75 + 0.21691619835942328491882308966204716381476099130282e-1 * t361 / t27 / t25 * t366 * t130 + 0.93896595123176283055138698534265786188334040216726e-3 * t115 * t32 * t371 + 0.30994291620957610220764550219748444951242627748581e-2 * t253 * t342 * t24 * t255 - 0.5225e4 / 0.729e3 * t97 * t381 + 0.65074859507826985475646926898614149144428297390844e-1 * t361 * t28 * t366 * t130 * t172 + 0.27717069790370753072960728123483804265219459999805e-1 * t270 * t381 - 0.13348101473280624556746145658806393174523095498958e-4 * t220 * t351 * t354 * t40 * t42 * t30 + 0.13014971901565397095129385379722829828885659478169e0 * t397 * t65 * t172 * t44 * t402 + 0.38593006958114059441807274702372557895376226369293e0 * t166 * t167 * t31 * t371 + 0.62664679526055615643215559235702513990930953043035e-1 * t278 * t402 + 0.13707898646324665921953403582809924935516145978164e-1 * t106 * t107 * t30 * t49 - 0.13183310097067283512835699416105079678541328887860e-4 / t218 / t36 * t71 * t212 * t342 * t53 * t24 * t255 - 0.52924554936484012336270630229884408617325347498593e-1 * t142 * t45 * t380 * t53 + 0.85978615454961133973479652491998171010516689529036e0 * t88 * t32 * t371 * t53 + 0.81825610381138005811044932155850013461234840608119e-1 * t173 * t174 * t75 - 0.77549339429964944368236549306508154244779759183054e0 * t156 * t336
  t446 = t200 ** 2
  t451 = t205 ** 2
  t519 = -0.3e1 / 0.8e1 * t18 * t20 * t437 * t79 - t318 * t321 * t119 * t327 / 0.41472e5 - t3 / t4 / t446 * t17 / t21 / t451 / t89 * t68 / t323 / t78 * t325 * t212 / 0.2985984e7 - t204 * t309 * t188 * t214 / 0.1152e4 - t127 * t302 * t296 * t134 / 0.48e2 + 0.13e2 / 0.864e3 * t204 * t208 * t119 * t214 + 0.79e2 / 0.248832e6 * t318 / t21 / t205 / t221 * t68 * t327 + 0.25e2 / 0.96e2 * t127 * t195 * t188 * t134 - 0.241e3 / 0.144e3 * t127 * t130 * t119 * t134 - 0.1697e4 / 0.20736e5 * t204 / t21 / t205 / t89 * t68 * t214 + 0.10e2 / 0.27e2 * t18 * t91 * t68 * t79 + 0.11563e5 / 0.2592e4 * t127 / t21 / t221 * t68 * t134 - 0.5e1 / 0.9e1 * t18 * t23 * t119 * t79 + t18 * t84 * t188 * t79 / 0.2e1 - t18 * t138 * t296 * t79 / 0.2e1
  t520 = f.my_piecewise3(t2, 0, t519)
  v4rho4_0_ = 0.2e1 * r0 * t520 + 0.8e1 * t332

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t44 = t37 * s0 / t40 / t38
  t46 = 0.8040e0 + 0.5e1 / 0.972e3 * t44
  t49 = 0.18040e1 - 0.64641600e0 / t46
  t50 = t32 ** 2
  t52 = 0.1e1 / t34 / t33
  t53 = t50 * t52
  t54 = s0 ** 2
  t55 = t38 ** 2
  t62 = 0.100e3 - t53 * t54 / t39 / t55 / r0 / 0.576e3
  t64 = 0.1e1 / t34
  t65 = t50 * t64
  t66 = jnp.sqrt(s0)
  t70 = t65 * t66 / t39 / r0
  t71 = t70 ** 0.35e1
  t73 = 0.1e1 + t44 / 0.24e2
  t76 = t49 * t62 + 0.87153829697982569833455705667786806889859326862737e-4 * t71 * t73
  t78 = t33 ** 2
  t79 = 0.1e1 / t78
  t80 = t54 * s0
  t82 = t55 ** 2
  t86 = 0.100e3 + t79 * t80 / t82 / 0.2304e4
  t87 = 0.1e1 / t86
  t88 = t31 * t76 * t87
  t91 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t92 = t91 * f.p.zeta_threshold
  t94 = f.my_piecewise3(t20, t92, t21 * t19)
  t95 = t5 * t94
  t96 = t31 ** 2
  t97 = 0.1e1 / t96
  t99 = t97 * t76 * t87
  t101 = t95 * t99 / 0.8e1
  t102 = t46 ** 2
  t103 = 0.1e1 / t102
  t105 = t103 * t32 * t36
  t106 = t38 * r0
  t108 = 0.1e1 / t40 / t106
  t113 = t49 * t50
  t114 = t52 * t54
  t115 = t55 * t38
  t121 = t70 ** 0.25e1
  t123 = t121 * t73 * t50
  t124 = t64 * t66
  t130 = t71 * t32
  t131 = t36 * s0
  t135 = -0.88671604938271604938271604938271604938271604938272e-2 * t105 * s0 * t108 * t62 + t113 * t114 / t39 / t115 / 0.108e3 - 0.40671787192391865922279329311633843215267685869278e-3 * t123 * t124 / t39 / t38 - 0.96837588553313966481617450741985340988732585403041e-5 * t130 * t131 * t108
  t137 = t31 * t135 * t87
  t142 = t2 / t3 / t78
  t143 = t94 * t31
  t144 = t142 * t143
  t145 = t86 ** 2
  t146 = 0.1e1 / t145
  t147 = t76 * t146
  t150 = t80 / t82 / r0
  t151 = t147 * t150
  t155 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t88 - t101 - 0.3e1 / 0.8e1 * t95 * t137 - t144 * t151 / 0.768e3)
  t157 = r1 <= f.p.dens_threshold
  t158 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t159 = 0.1e1 + t158
  t160 = t159 <= f.p.zeta_threshold
  t161 = t159 ** (0.1e1 / 0.3e1)
  t163 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t166 = f.my_piecewise3(t160, 0, 0.4e1 / 0.3e1 * t161 * t163)
  t167 = t5 * t166
  t168 = r1 ** 2
  t169 = r1 ** (0.1e1 / 0.3e1)
  t170 = t169 ** 2
  t174 = t37 * s2 / t170 / t168
  t176 = 0.8040e0 + 0.5e1 / 0.972e3 * t174
  t179 = 0.18040e1 - 0.64641600e0 / t176
  t180 = s2 ** 2
  t181 = t168 ** 2
  t188 = 0.100e3 - t53 * t180 / t169 / t181 / r1 / 0.576e3
  t190 = jnp.sqrt(s2)
  t194 = t65 * t190 / t169 / r1
  t195 = t194 ** 0.35e1
  t197 = 0.1e1 + t174 / 0.24e2
  t200 = t179 * t188 + 0.87153829697982569833455705667786806889859326862737e-4 * t195 * t197
  t202 = t180 * s2
  t204 = t181 ** 2
  t208 = 0.100e3 + t79 * t202 / t204 / 0.2304e4
  t209 = 0.1e1 / t208
  t210 = t31 * t200 * t209
  t214 = f.my_piecewise3(t160, t92, t161 * t159)
  t215 = t5 * t214
  t217 = t97 * t200 * t209
  t219 = t215 * t217 / 0.8e1
  t221 = f.my_piecewise3(t157, 0, -0.3e1 / 0.8e1 * t167 * t210 - t219)
  t223 = t21 ** 2
  t224 = 0.1e1 / t223
  t225 = t26 ** 2
  t230 = t16 / t22 / t6
  t232 = -0.2e1 * t23 + 0.2e1 * t230
  t233 = f.my_piecewise5(t10, 0, t14, 0, t232)
  t237 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t224 * t225 + 0.4e1 / 0.3e1 * t21 * t233)
  t241 = t30 * t99
  t250 = 0.1e1 / t96 / t6
  t254 = t95 * t250 * t76 * t87 / 0.12e2
  t257 = t95 * t97 * t135 * t87
  t261 = t142 * t94 * t97 * t151
  t269 = 0.1e1 / t39 / t55 / t106
  t275 = 0.1e1 / t40 / t55
  t283 = t80 / t82 / t38
  t289 = t70 ** 0.15e1
  t292 = t131 * t275
  t295 = 0.1e1 / t33
  t318 = t78 ** 2
  t321 = t2 / t3 / t318
  t326 = t54 ** 2
  t328 = t82 ** 2
  t338 = -0.3e1 / 0.8e1 * t5 * t237 * t88 - t241 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t137 - t142 * t29 * t31 * t151 / 0.384e3 + t254 - t257 / 0.4e1 - t261 / 0.1152e4 - 0.3e1 / 0.8e1 * t95 * t31 * (-0.24326914935053938254669850463174651560568341546851e-3 / t102 / t46 * t50 * t52 * t54 * t269 * t62 + 0.32512921810699588477366255144032921810699588477366e-1 * t105 * s0 * t275 * t62 - 0.98524005486968449931412894375857338820301783264746e-3 * t103 * t79 * t283 - 0.19e2 / 0.324e3 * t113 * t114 * t269 + 0.81343574384783731844558658623267686430535371738556e-2 * t289 * t73 * t32 * t292 + 0.54229049589855821229705772415511790953690247825703e-3 * t121 * t295 * t66 * s0 / t115 + 0.94900836782247687151985101727145634168957933694982e-3 * t123 * t124 / t39 / t106 + 0.35507115802881787709926398605394625029201947981115e-4 * t130 * t292) * t87 - t144 * t135 * t146 * t150 / 0.384e3 - t321 * t143 * t76 / t145 / t86 * t326 * t54 / t328 / t38 / 0.110592e6 + 0.3e1 / 0.256e3 * t144 * t147 * t283
  t339 = f.my_piecewise3(t1, 0, t338)
  t340 = t161 ** 2
  t341 = 0.1e1 / t340
  t342 = t163 ** 2
  t346 = f.my_piecewise5(t14, 0, t10, 0, -t232)
  t350 = f.my_piecewise3(t160, 0, 0.4e1 / 0.9e1 * t341 * t342 + 0.4e1 / 0.3e1 * t161 * t346)
  t354 = t167 * t217
  t359 = t215 * t250 * t200 * t209 / 0.12e2
  t361 = f.my_piecewise3(t157, 0, -0.3e1 / 0.8e1 * t5 * t350 * t210 - t354 / 0.4e1 + t359)
  d11 = 0.2e1 * t155 + 0.2e1 * t221 + t6 * (t339 + t361)
  t364 = -t7 - t24
  t365 = f.my_piecewise5(t10, 0, t14, 0, t364)
  t368 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t365)
  t369 = t5 * t368
  t373 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t369 * t88 - t101)
  t375 = f.my_piecewise5(t14, 0, t10, 0, -t364)
  t378 = f.my_piecewise3(t160, 0, 0.4e1 / 0.3e1 * t161 * t375)
  t379 = t5 * t378
  t382 = t176 ** 2
  t383 = 0.1e1 / t382
  t385 = t383 * t32 * t36
  t386 = t168 * r1
  t388 = 0.1e1 / t170 / t386
  t393 = t179 * t50
  t394 = t52 * t180
  t395 = t181 * t168
  t401 = t194 ** 0.25e1
  t403 = t401 * t197 * t50
  t404 = t64 * t190
  t410 = t195 * t32
  t411 = t36 * s2
  t415 = -0.88671604938271604938271604938271604938271604938272e-2 * t385 * s2 * t388 * t188 + t393 * t394 / t169 / t395 / 0.108e3 - 0.40671787192391865922279329311633843215267685869278e-3 * t403 * t404 / t169 / t168 - 0.96837588553313966481617450741985340988732585403041e-5 * t410 * t411 * t388
  t417 = t31 * t415 * t209
  t420 = t214 * t31
  t421 = t142 * t420
  t422 = t208 ** 2
  t423 = 0.1e1 / t422
  t424 = t200 * t423
  t427 = t202 / t204 / r1
  t428 = t424 * t427
  t432 = f.my_piecewise3(t157, 0, -0.3e1 / 0.8e1 * t379 * t210 - t219 - 0.3e1 / 0.8e1 * t215 * t417 - t421 * t428 / 0.768e3)
  t436 = 0.2e1 * t230
  t437 = f.my_piecewise5(t10, 0, t14, 0, t436)
  t441 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t224 * t365 * t26 + 0.4e1 / 0.3e1 * t21 * t437)
  t445 = t369 * t99
  t457 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t441 * t88 - t445 / 0.8e1 - 0.3e1 / 0.8e1 * t369 * t137 - t142 * t368 * t31 * t151 / 0.768e3 - t241 / 0.8e1 + t254 - t257 / 0.8e1 - t261 / 0.2304e4)
  t461 = f.my_piecewise5(t14, 0, t10, 0, -t436)
  t465 = f.my_piecewise3(t160, 0, 0.4e1 / 0.9e1 * t341 * t375 * t163 + 0.4e1 / 0.3e1 * t161 * t461)
  t469 = t379 * t217
  t476 = t215 * t97 * t415 * t209
  t484 = t142 * t214 * t97 * t428
  t487 = f.my_piecewise3(t157, 0, -0.3e1 / 0.8e1 * t5 * t465 * t210 - t469 / 0.8e1 - t354 / 0.8e1 + t359 - 0.3e1 / 0.8e1 * t167 * t417 - t476 / 0.8e1 - t142 * t166 * t31 * t428 / 0.768e3 - t484 / 0.2304e4)
  d12 = t155 + t221 + t373 + t432 + t6 * (t457 + t487)
  t492 = t365 ** 2
  t496 = 0.2e1 * t23 + 0.2e1 * t230
  t497 = f.my_piecewise5(t10, 0, t14, 0, t496)
  t501 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t224 * t492 + 0.4e1 / 0.3e1 * t21 * t497)
  t507 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t501 * t88 - t445 / 0.4e1 + t254)
  t508 = t375 ** 2
  t512 = f.my_piecewise5(t14, 0, t10, 0, -t496)
  t516 = f.my_piecewise3(t160, 0, 0.4e1 / 0.9e1 * t341 * t508 + 0.4e1 / 0.3e1 * t161 * t512)
  t535 = 0.1e1 / t169 / t181 / t386
  t541 = 0.1e1 / t170 / t181
  t549 = t202 / t204 / t168
  t555 = t194 ** 0.15e1
  t558 = t411 * t541
  t587 = t180 ** 2
  t589 = t204 ** 2
  t599 = -0.3e1 / 0.8e1 * t5 * t516 * t210 - t469 / 0.4e1 - 0.3e1 / 0.4e1 * t379 * t417 - t142 * t378 * t31 * t428 / 0.384e3 + t359 - t476 / 0.4e1 - t484 / 0.1152e4 - 0.3e1 / 0.8e1 * t215 * t31 * (-0.24326914935053938254669850463174651560568341546851e-3 / t382 / t176 * t50 * t52 * t180 * t535 * t188 + 0.32512921810699588477366255144032921810699588477366e-1 * t385 * s2 * t541 * t188 - 0.98524005486968449931412894375857338820301783264746e-3 * t383 * t79 * t549 - 0.19e2 / 0.324e3 * t393 * t394 * t535 + 0.81343574384783731844558658623267686430535371738556e-2 * t555 * t197 * t32 * t558 + 0.54229049589855821229705772415511790953690247825703e-3 * t401 * t295 * t190 * s2 / t395 + 0.94900836782247687151985101727145634168957933694982e-3 * t403 * t404 / t169 / t386 + 0.35507115802881787709926398605394625029201947981115e-4 * t410 * t558) * t209 - t421 * t415 * t423 * t427 / 0.384e3 - t321 * t420 * t200 / t422 / t208 * t587 * t180 / t589 / t168 / 0.110592e6 + 0.3e1 / 0.256e3 * t421 * t424 * t549
  t600 = f.my_piecewise3(t157, 0, t599)
  d22 = 0.2e1 * t373 + 0.2e1 * t432 + t6 * (t507 + t600)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t56 = t49 * s0 / t52 / t50
  t58 = 0.8040e0 + 0.5e1 / 0.972e3 * t56
  t61 = 0.18040e1 - 0.64641600e0 / t58
  t62 = t44 ** 2
  t64 = 0.1e1 / t46 / t45
  t65 = t62 * t64
  t66 = s0 ** 2
  t67 = t50 ** 2
  t68 = t67 * r0
  t74 = 0.100e3 - t65 * t66 / t51 / t68 / 0.576e3
  t76 = 0.1e1 / t46
  t77 = t62 * t76
  t78 = jnp.sqrt(s0)
  t82 = t77 * t78 / t51 / r0
  t83 = t82 ** 0.35e1
  t85 = 0.1e1 + t56 / 0.24e2
  t88 = t61 * t74 + 0.87153829697982569833455705667786806889859326862737e-4 * t83 * t85
  t90 = t45 ** 2
  t91 = 0.1e1 / t90
  t92 = t66 * s0
  t94 = t67 ** 2
  t98 = 0.100e3 + t91 * t92 / t94 / 0.2304e4
  t99 = 0.1e1 / t98
  t100 = t43 * t88 * t99
  t105 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t106 = t5 * t105
  t107 = t43 ** 2
  t108 = 0.1e1 / t107
  t110 = t108 * t88 * t99
  t113 = t58 ** 2
  t114 = 0.1e1 / t113
  t116 = t114 * t44 * t48
  t117 = t50 * r0
  t119 = 0.1e1 / t52 / t117
  t124 = t61 * t62
  t125 = t64 * t66
  t126 = t67 * t50
  t132 = t82 ** 0.25e1
  t134 = t132 * t85 * t62
  t135 = t76 * t78
  t141 = t83 * t44
  t142 = t48 * s0
  t146 = -0.88671604938271604938271604938271604938271604938272e-2 * t116 * s0 * t119 * t74 + t124 * t125 / t51 / t126 / 0.108e3 - 0.40671787192391865922279329311633843215267685869278e-3 * t134 * t135 / t51 / t50 - 0.96837588553313966481617450741985340988732585403041e-5 * t141 * t142 * t119
  t148 = t43 * t146 * t99
  t153 = t2 / t3 / t90
  t154 = t105 * t43
  t155 = t153 * t154
  t156 = t98 ** 2
  t157 = 0.1e1 / t156
  t158 = t88 * t157
  t161 = t92 / t94 / r0
  t162 = t158 * t161
  t165 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t166 = t165 * f.p.zeta_threshold
  t168 = f.my_piecewise3(t20, t166, t21 * t19)
  t169 = t5 * t168
  t171 = 0.1e1 / t107 / t6
  t173 = t171 * t88 * t99
  t177 = t108 * t146 * t99
  t180 = t168 * t108
  t181 = t153 * t180
  t185 = 0.1e1 / t113 / t58
  t187 = t185 * t62 * t64
  t188 = t67 * t117
  t190 = 0.1e1 / t51 / t188
  t196 = 0.1e1 / t52 / t67
  t201 = t114 * t91
  t204 = t92 / t94 / t50
  t210 = t82 ** 0.15e1
  t212 = t210 * t85 * t44
  t213 = t142 * t196
  t216 = 0.1e1 / t45
  t217 = t132 * t216
  t218 = t78 * s0
  t230 = -0.24326914935053938254669850463174651560568341546851e-3 * t187 * t66 * t190 * t74 + 0.32512921810699588477366255144032921810699588477366e-1 * t116 * s0 * t196 * t74 - 0.98524005486968449931412894375857338820301783264746e-3 * t201 * t204 - 0.19e2 / 0.324e3 * t124 * t125 * t190 + 0.81343574384783731844558658623267686430535371738556e-2 * t212 * t213 + 0.54229049589855821229705772415511790953690247825703e-3 * t217 * t218 / t126 + 0.94900836782247687151985101727145634168957933694982e-3 * t134 * t135 / t51 / t117 + 0.35507115802881787709926398605394625029201947981115e-4 * t141 * t213
  t232 = t43 * t230 * t99
  t235 = t168 * t43
  t236 = t153 * t235
  t237 = t146 * t157
  t238 = t237 * t161
  t241 = t90 ** 2
  t244 = t2 / t3 / t241
  t245 = t244 * t235
  t247 = 0.1e1 / t156 / t98
  t248 = t88 * t247
  t249 = t66 ** 2
  t250 = t249 * t66
  t251 = t94 ** 2
  t254 = t250 / t251 / t50
  t255 = t248 * t254
  t258 = t158 * t204
  t261 = -0.3e1 / 0.8e1 * t42 * t100 - t106 * t110 / 0.4e1 - 0.3e1 / 0.4e1 * t106 * t148 - t155 * t162 / 0.384e3 + t169 * t173 / 0.12e2 - t169 * t177 / 0.4e1 - t181 * t162 / 0.1152e4 - 0.3e1 / 0.8e1 * t169 * t232 - t236 * t238 / 0.384e3 - t245 * t255 / 0.110592e6 + 0.3e1 / 0.256e3 * t236 * t258
  t262 = f.my_piecewise3(t1, 0, t261)
  t264 = r1 <= f.p.dens_threshold
  t265 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t266 = 0.1e1 + t265
  t267 = t266 <= f.p.zeta_threshold
  t268 = t266 ** (0.1e1 / 0.3e1)
  t269 = t268 ** 2
  t270 = 0.1e1 / t269
  t272 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t273 = t272 ** 2
  t277 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t281 = f.my_piecewise3(t267, 0, 0.4e1 / 0.9e1 * t270 * t273 + 0.4e1 / 0.3e1 * t268 * t277)
  t282 = t5 * t281
  t283 = r1 ** 2
  t284 = r1 ** (0.1e1 / 0.3e1)
  t285 = t284 ** 2
  t289 = t49 * s2 / t285 / t283
  t295 = s2 ** 2
  t296 = t283 ** 2
  t305 = jnp.sqrt(s2)
  t310 = (t77 * t305 / t284 / r1) ** 0.35e1
  t315 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t289)) * (0.100e3 - t65 * t295 / t284 / t296 / r1 / 0.576e3) + 0.87153829697982569833455705667786806889859326862737e-4 * t310 * (0.1e1 + t289 / 0.24e2)
  t319 = t296 ** 2
  t324 = 0.1e1 / (0.100e3 + t91 * t295 * s2 / t319 / 0.2304e4)
  t325 = t43 * t315 * t324
  t330 = f.my_piecewise3(t267, 0, 0.4e1 / 0.3e1 * t268 * t272)
  t331 = t5 * t330
  t333 = t108 * t315 * t324
  t337 = f.my_piecewise3(t267, t166, t268 * t266)
  t338 = t5 * t337
  t340 = t171 * t315 * t324
  t344 = f.my_piecewise3(t264, 0, -0.3e1 / 0.8e1 * t282 * t325 - t331 * t333 / 0.4e1 + t338 * t340 / 0.12e2)
  t350 = t113 ** 2
  t353 = t94 * t117
  t355 = t92 / t353
  t360 = 0.1e1 / t51 / t94
  t371 = 0.1e1 / t52 / t94 / t68
  t376 = 0.1e1 / t52 / t68
  t389 = t125 * t360
  t392 = t82 ** 0.5e0
  t395 = 0.1e1 / t188
  t402 = t142 * t376
  t421 = -0.60066456629762810505357655464628769285353929745311e-4 / t350 * t91 * t355 * t74 + 0.26759606428559332080136835509492116716625175701536e-2 * t187 * t66 * t360 * t74 - 0.13514952741696632363705472479541473089204634192695e-4 * t185 * t44 / t47 / t90 * t249 * t371 - 0.15172696844993141289437585733882030178326474622771e0 * t116 * s0 * t376 * t74 + 0.14778600823045267489711934156378600823045267489712e-1 * t201 * t355 - 0.27029905483393264727410944959082946178409268385390e-4 * t185 * t91 * t249 * t371 * t44 * t48 + 0.209e3 / 0.486e3 * t124 * t389 - 0.97612289261740478213470390347921223716642446086267e-1 * t392 * t85 * t216 * t218 * t395 - 0.90381749316426368716176287359186318256150413042840e-3 * t210 * t62 * t389 - 0.56940502069348612291191061036287380501374760216989e-1 * t212 * t402 - 0.18076349863285273743235257471837263651230082608567e-2 * t210 * t216 * t66 * t360 * t62 * t76 - 0.48806144630870239106735195173960611858321223043133e-2 * t217 * t218 * t395 - 0.31633612260749229050661700575715211389652644564994e-2 * t134 * t135 / t51 / t67 - 0.16569987374678167597965652682517491680294242391187e-3 * t141 * t402
  t427 = 0.1e1 / t107 / t24
  t444 = t24 ** 2
  t448 = 0.6e1 * t33 - 0.6e1 * t16 / t444
  t449 = f.my_piecewise5(t10, 0, t14, 0, t448)
  t453 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t449)
  t475 = -0.3e1 / 0.8e1 * t169 * t108 * t230 * t99 - 0.3e1 / 0.8e1 * t169 * t43 * t421 * t99 - 0.5e1 / 0.36e2 * t169 * t427 * t88 * t99 - 0.3e1 / 0.8e1 * t42 * t110 + t106 * t173 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t453 * t100 - 0.9e1 / 0.8e1 * t42 * t148 - 0.3e1 / 0.4e1 * t106 * t177 - 0.9e1 / 0.8e1 * t106 * t232 + t169 * t171 * t146 * t99 / 0.4e1 - t236 * t230 * t157 * t161 / 0.256e3 - t245 * t146 * t247 * t254 / 0.36864e5
  t481 = t156 ** 2
  t484 = t249 ** 2
  t530 = -t2 / t3 / t241 / t90 * t235 * t88 / t481 * t484 * s0 / t251 / t353 / 0.10616832e8 - t244 * t154 * t255 / 0.36864e5 + t153 * t168 * t171 * t162 / 0.1152e4 - t181 * t238 / 0.384e3 - t244 * t180 * t255 / 0.110592e6 - t153 * t41 * t43 * t162 / 0.256e3 - t153 * t105 * t108 * t162 / 0.384e3 - t155 * t238 / 0.128e3 + 0.9e1 / 0.256e3 * t155 * t258 + 0.3e1 / 0.256e3 * t181 * t258 + 0.9e1 / 0.256e3 * t236 * t237 * t204 + t245 * t248 * t250 / t251 / t117 / 0.4096e4 - 0.15e2 / 0.128e3 * t236 * t158 * t355
  t532 = f.my_piecewise3(t1, 0, t475 + t530)
  t542 = f.my_piecewise5(t14, 0, t10, 0, -t448)
  t546 = f.my_piecewise3(t267, 0, -0.8e1 / 0.27e2 / t269 / t266 * t273 * t272 + 0.4e1 / 0.3e1 * t270 * t272 * t277 + 0.4e1 / 0.3e1 * t268 * t542)
  t559 = f.my_piecewise3(t264, 0, -0.3e1 / 0.8e1 * t5 * t546 * t325 - 0.3e1 / 0.8e1 * t282 * t333 + t331 * t340 / 0.4e1 - 0.5e1 / 0.36e2 * t338 * t427 * t315 * t324)
  d111 = 0.3e1 * t262 + 0.3e1 * t344 + t6 * (t532 + t559)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** 2
  t4 = t3 ** 2
  t5 = t4 ** 2
  t7 = jnp.pi ** (0.1e1 / 0.3e1)
  t10 = t2 / t7 / t5 / t4
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t15 = 0.2e1 * r0 * t12 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold - 0.1e1
  t19 = 0.2e1 * r1 * t12 <= f.p.zeta_threshold
  t20 = -t16
  t21 = r0 - r1
  t22 = t21 * t12
  t23 = f.my_piecewise5(t15, t16, t19, t20, t22)
  t24 = 0.1e1 + t23
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t27 = t26 * f.p.zeta_threshold
  t28 = t24 ** (0.1e1 / 0.3e1)
  t30 = f.my_piecewise3(t25, t27, t28 * t24)
  t31 = t11 ** (0.1e1 / 0.3e1)
  t32 = t30 * t31
  t33 = t10 * t32
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = t3 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = r0 ** 2
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t45 = t38 * s0 / t41 / t39
  t47 = 0.8040e0 + 0.5e1 / 0.972e3 * t45
  t50 = 0.18040e1 - 0.64641600e0 / t47
  t51 = t34 ** 2
  t53 = 0.1e1 / t35 / t3
  t54 = t51 * t53
  t55 = s0 ** 2
  t56 = t39 ** 2
  t57 = t56 * r0
  t59 = 0.1e1 / t40 / t57
  t63 = 0.100e3 - t54 * t55 * t59 / 0.576e3
  t65 = 0.1e1 / t35
  t66 = t51 * t65
  t67 = jnp.sqrt(s0)
  t71 = t66 * t67 / t40 / r0
  t72 = t71 ** 0.35e1
  t74 = 0.1e1 + t45 / 0.24e2
  t77 = t50 * t63 + 0.87153829697982569833455705667786806889859326862737e-4 * t72 * t74
  t78 = 0.1e1 / t4
  t79 = t55 * s0
  t81 = t56 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.100e3 + t78 * t79 * t82 / 0.2304e4
  t86 = t85 ** 2
  t87 = t86 ** 2
  t88 = 0.1e1 / t87
  t89 = t77 * t88
  t90 = t55 ** 2
  t91 = t90 ** 2
  t92 = t91 * s0
  t93 = t39 * r0
  t94 = t81 * t93
  t95 = t81 ** 2
  t98 = t92 / t95 / t94
  t99 = t89 * t98
  t104 = t2 / t7 / t5
  t105 = t104 * t32
  t107 = 0.1e1 / t86 / t85
  t108 = t77 * t107
  t109 = t90 * t55
  t112 = t109 / t95 / t93
  t113 = t108 * t112
  t118 = t2 / t7 / t4
  t119 = t31 ** 2
  t120 = 0.1e1 / t119
  t121 = t30 * t120
  t122 = t118 * t121
  t123 = 0.1e1 / t86
  t124 = t77 * t123
  t125 = t81 * t39
  t127 = t79 / t125
  t128 = t124 * t127
  t131 = t11 ** 2
  t132 = 0.1e1 / t131
  t134 = -t21 * t132 + t12
  t135 = f.my_piecewise5(t15, 0, t19, 0, t134)
  t138 = f.my_piecewise3(t25, 0, 0.4e1 / 0.3e1 * t28 * t135)
  t139 = t138 * t31
  t140 = t118 * t139
  t141 = t47 ** 2
  t142 = 0.1e1 / t141
  t144 = t142 * t34 * t37
  t146 = 0.1e1 / t41 / t93
  t151 = t50 * t51
  t152 = t53 * t55
  t153 = t56 * t39
  t159 = t71 ** 0.25e1
  t161 = t159 * t74 * t51
  t162 = t65 * t67
  t168 = t72 * t34
  t169 = t37 * s0
  t173 = -0.88671604938271604938271604938271604938271604938272e-2 * t144 * s0 * t146 * t63 + t151 * t152 / t40 / t153 / 0.108e3 - 0.40671787192391865922279329311633843215267685869278e-3 * t161 * t162 / t40 / t39 - 0.96837588553313966481617450741985340988732585403041e-5 * t168 * t169 * t146
  t174 = t173 * t123
  t175 = t81 * r0
  t177 = t79 / t175
  t178 = t174 * t177
  t181 = t118 * t32
  t182 = t174 * t127
  t185 = t104 * t121
  t188 = t109 / t95 / t39
  t189 = t108 * t188
  t192 = t28 ** 2
  t193 = 0.1e1 / t192
  t194 = t135 ** 2
  t197 = t131 * t11
  t198 = 0.1e1 / t197
  t201 = 0.2e1 * t21 * t198 - 0.2e1 * t132
  t202 = f.my_piecewise5(t15, 0, t19, 0, t201)
  t206 = f.my_piecewise3(t25, 0, 0.4e1 / 0.9e1 * t193 * t194 + 0.4e1 / 0.3e1 * t28 * t202)
  t207 = t206 * t31
  t208 = t118 * t207
  t209 = t124 * t177
  t212 = t104 * t139
  t218 = 0.1e1 / t141 / t47
  t220 = t218 * t51 * t53
  t221 = t56 * t93
  t223 = 0.1e1 / t40 / t221
  t229 = 0.1e1 / t41 / t56
  t234 = t142 * t78
  t240 = t71 ** 0.15e1
  t242 = t240 * t74 * t34
  t243 = t169 * t229
  t246 = 0.1e1 / t3
  t247 = t159 * t246
  t248 = t67 * s0
  t260 = -0.24326914935053938254669850463174651560568341546851e-3 * t220 * t55 * t223 * t63 + 0.32512921810699588477366255144032921810699588477366e-1 * t144 * s0 * t229 * t63 - 0.98524005486968449931412894375857338820301783264746e-3 * t234 * t127 - 0.19e2 / 0.324e3 * t151 * t152 * t223 + 0.81343574384783731844558658623267686430535371738556e-2 * t242 * t243 + 0.54229049589855821229705772415511790953690247825703e-3 * t247 * t248 / t153 + 0.94900836782247687151985101727145634168957933694982e-3 * t161 * t162 / t40 / t93 + 0.35507115802881787709926398605394625029201947981115e-4 * t168 * t243
  t261 = t260 * t123
  t262 = t261 * t177
  t265 = t138 * t120
  t266 = t118 * t265
  t270 = 0.1e1 / t119 / t11
  t271 = t30 * t270
  t272 = t118 * t271
  t275 = -t33 * t99 / 0.10616832e8 + t105 * t113 / 0.4096e4 + 0.3e1 / 0.256e3 * t122 * t128 - t140 * t178 / 0.128e3 + 0.9e1 / 0.256e3 * t181 * t182 - t185 * t189 / 0.110592e6 - t208 * t209 / 0.256e3 - t212 * t189 / 0.36864e5 - t122 * t178 / 0.384e3 - t181 * t262 / 0.256e3 - t266 * t209 / 0.384e3 + t272 * t209 / 0.1152e4
  t277 = t79 / t94
  t278 = t124 * t277
  t281 = t173 * t107
  t282 = t281 * t188
  t288 = t2 / t7
  t289 = t288 * t30
  t291 = 0.1e1 / t119 / t131
  t293 = 0.1e1 / t85
  t294 = t291 * t77 * t293
  t297 = t288 * t206
  t299 = t120 * t77 * t293
  t303 = 0.1e1 / t192 / t24
  t307 = t193 * t135
  t310 = t131 ** 2
  t311 = 0.1e1 / t310
  t314 = -0.6e1 * t21 * t311 + 0.6e1 * t198
  t315 = f.my_piecewise5(t15, 0, t19, 0, t314)
  t319 = f.my_piecewise3(t25, 0, -0.8e1 / 0.27e2 * t303 * t194 * t135 + 0.4e1 / 0.3e1 * t307 * t202 + 0.4e1 / 0.3e1 * t28 * t315)
  t320 = t288 * t319
  t322 = t31 * t77 * t293
  t326 = t31 * t173 * t293
  t329 = t288 * t138
  t331 = t120 * t173 * t293
  t335 = t31 * t260 * t293
  t339 = t270 * t173 * t293
  t343 = t120 * t260 * t293
  t346 = t141 ** 2
  t347 = 0.1e1 / t346
  t348 = t347 * t78
  t353 = 0.1e1 / t40 / t81
  t358 = t218 * t34
  t361 = 0.1e1 / t36 / t4 * t90
  t364 = 0.1e1 / t41 / t81 / t57
  t369 = 0.1e1 / t41 / t57
  t377 = t218 * t78 * t90
  t382 = t152 * t353
  t385 = t71 ** 0.5e0
  t386 = t385 * t74
  t387 = t246 * t248
  t388 = 0.1e1 / t221
  t392 = t240 * t51
  t395 = t169 * t369
  t399 = t240 * t246 * t55
  t414 = -0.60066456629762810505357655464628769285353929745311e-4 * t348 * t277 * t63 + 0.26759606428559332080136835509492116716625175701536e-2 * t220 * t55 * t353 * t63 - 0.13514952741696632363705472479541473089204634192695e-4 * t358 * t361 * t364 - 0.15172696844993141289437585733882030178326474622771e0 * t144 * s0 * t369 * t63 + 0.14778600823045267489711934156378600823045267489712e-1 * t234 * t277 - 0.27029905483393264727410944959082946178409268385390e-4 * t377 * t364 * t34 * t37 + 0.209e3 / 0.486e3 * t151 * t382 - 0.97612289261740478213470390347921223716642446086267e-1 * t386 * t387 * t388 - 0.90381749316426368716176287359186318256150413042840e-3 * t392 * t382 - 0.56940502069348612291191061036287380501374760216989e-1 * t242 * t395 - 0.18076349863285273743235257471837263651230082608567e-2 * t399 * t353 * t51 * t65 - 0.48806144630870239106735195173960611858321223043133e-2 * t247 * t248 * t388 - 0.31633612260749229050661700575715211389652644564994e-2 * t161 * t162 / t40 / t56 - 0.16569987374678167597965652682517491680294242391187e-3 * t168 * t395
  t416 = t31 * t414 * t293
  t420 = t270 * t77 * t293
  t423 = -0.15e2 / 0.128e3 * t181 * t278 - t105 * t282 / 0.36864e5 + 0.9e1 / 0.256e3 * t140 * t128 - 0.5e1 / 0.36e2 * t289 * t294 - 0.3e1 / 0.8e1 * t297 * t299 - 0.3e1 / 0.8e1 * t320 * t322 - 0.9e1 / 0.8e1 * t297 * t326 - 0.3e1 / 0.4e1 * t329 * t331 - 0.9e1 / 0.8e1 * t329 * t335 + t289 * t339 / 0.4e1 - 0.3e1 / 0.8e1 * t289 * t343 - 0.3e1 / 0.8e1 * t289 * t416 + t329 * t420 / 0.4e1
  t425 = f.my_piecewise3(t1, 0, t275 + t423)
  t427 = r1 <= f.p.dens_threshold
  t428 = f.my_piecewise5(t19, t16, t15, t20, -t22)
  t429 = 0.1e1 + t428
  t430 = t429 <= f.p.zeta_threshold
  t431 = t429 ** (0.1e1 / 0.3e1)
  t432 = t431 ** 2
  t434 = 0.1e1 / t432 / t429
  t436 = f.my_piecewise5(t19, 0, t15, 0, -t134)
  t437 = t436 ** 2
  t441 = 0.1e1 / t432
  t442 = t441 * t436
  t444 = f.my_piecewise5(t19, 0, t15, 0, -t201)
  t448 = f.my_piecewise5(t19, 0, t15, 0, -t314)
  t452 = f.my_piecewise3(t430, 0, -0.8e1 / 0.27e2 * t434 * t437 * t436 + 0.4e1 / 0.3e1 * t442 * t444 + 0.4e1 / 0.3e1 * t431 * t448)
  t453 = t288 * t452
  t454 = r1 ** 2
  t455 = r1 ** (0.1e1 / 0.3e1)
  t456 = t455 ** 2
  t460 = t38 * s2 / t456 / t454
  t466 = s2 ** 2
  t467 = t454 ** 2
  t476 = jnp.sqrt(s2)
  t481 = (t66 * t476 / t455 / r1) ** 0.35e1
  t486 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t460)) * (0.100e3 - t54 * t466 / t455 / t467 / r1 / 0.576e3) + 0.87153829697982569833455705667786806889859326862737e-4 * t481 * (0.1e1 + t460 / 0.24e2)
  t490 = t467 ** 2
  t495 = 0.1e1 / (0.100e3 + t78 * t466 * s2 / t490 / 0.2304e4)
  t496 = t31 * t486 * t495
  t504 = f.my_piecewise3(t430, 0, 0.4e1 / 0.9e1 * t441 * t437 + 0.4e1 / 0.3e1 * t431 * t444)
  t505 = t288 * t504
  t507 = t120 * t486 * t495
  t512 = f.my_piecewise3(t430, 0, 0.4e1 / 0.3e1 * t431 * t436)
  t513 = t288 * t512
  t515 = t270 * t486 * t495
  t519 = f.my_piecewise3(t430, t27, t431 * t429)
  t520 = t288 * t519
  t522 = t291 * t486 * t495
  t526 = f.my_piecewise3(t427, 0, -0.3e1 / 0.8e1 * t453 * t496 - 0.3e1 / 0.8e1 * t505 * t507 + t513 * t515 / 0.4e1 - 0.5e1 / 0.36e2 * t520 * t522)
  t562 = t81 * t56
  t564 = t79 / t562
  t568 = -t208 * t178 / 0.64e2 - t140 * t262 / 0.64e2 + t272 * t178 / 0.288e3 - 0.15e2 / 0.32e2 * t181 * t174 * t277 + t118 * t138 * t270 * t209 / 0.288e3 - t105 * t260 * t107 * t188 / 0.18432e5 + t104 * t271 * t189 / 0.82944e5 - 0.67e2 / 0.12288e5 * t105 * t108 * t109 / t95 / t56 - 0.5e1 / 0.2592e4 * t118 * t30 * t291 * t209 - t272 * t128 / 0.64e2 - 0.5e1 / 0.32e2 * t122 * t278 + 0.165e3 / 0.128e3 * t181 * t124 * t564
  t610 = -t185 * t282 / 0.27648e5 + t105 * t281 * t112 / 0.1024e4 + 0.3e1 / 0.64e2 * t266 * t128 - t10 * t121 * t99 / 0.7962624e7 + t33 * t89 * t92 / t95 / t562 / 0.196608e6 + t185 * t113 / 0.3072e4 - t266 * t178 / 0.96e2 - t118 * t206 * t120 * t209 / 0.192e3 - t181 * t414 * t123 * t177 / 0.192e3 + 0.9e1 / 0.128e3 * t181 * t261 * t127 - t104 * t265 * t189 / 0.27648e5 - t118 * t319 * t31 * t209 / 0.192e3 - t104 * t207 * t189 / 0.18432e5
  t629 = t5 ** 2
  t638 = t95 ** 2
  t649 = t71 ** (-0.5e0)
  t653 = 0.1e1 / t40 / t175
  t654 = t55 * t653
  t659 = 0.1e1 / t41 / t153
  t660 = t169 * t659
  t676 = 0.1e1 / t41 / t81 / t153
  t696 = t152 * t653
  t702 = t385 * t34
  t704 = t67 * t55
  t706 = 0.1e1 / t41 / t125
  t716 = t90 * s0
  t720 = 0.1e1 / t40 / t95 / r0
  t745 = 0.65074859507826985475646926898614149144428297390844e-1 * t649 * t74 * t246 * t654 * t66 + 0.38593006958114059441807274702372557895376226369293e0 * t242 * t660 + 0.31332339763027807821607779617851256995465476521517e-1 * t399 * t653 * t51 * t65 + 0.13707898646324665921953403582809924935516145978164e-1 * t161 * t162 * t59 - 0.32958275242668208782089248540262699196353322219649e-5 / t346 / t47 * t78 * t90 * t676 * t63 * t38 - 0.26462277468242006168135315114942204308662673749297e-1 * t220 * t654 * t63 + 0.85978615454961133973479652491998171010516689529036e0 * t144 * s0 * t659 * t63 - 0.19387334857491236092059137326627038561194939795762e0 * t234 * t564 + 0.93896595123176283055138698534265786188334040216726e-3 * t168 * t660 + 0.77485729052394025551911375549371112378106569371451e-3 * t377 * t676 * t34 * t37 - 0.5225e4 / 0.1458e4 * t151 * t696 + 0.13665720496643666949885854648708971320329942452077e1 * t386 * t387 * t82 + 0.32537429753913492737823463449307074572214148695421e-1 * t702 * t37 * t704 * t706 * t246 + 0.13858534895185376536480364061741902132609729999902e-1 * t392 * t696 + 0.13214620458547818311178684202218329242777864543968e-2 * t348 * t564 * t63 - 0.16685126841600780695932682073507991468153869373698e-5 * t348 * t716 * t720 * t51 * t53 + 0.40912805190569002905522466077925006730617420304058e-1 * t247 * t248 * t82 + 0.33336883429518359830473498782868966953371431008647e-3 * t358 * t361 * t676 - 0.55617089472002602319775606911693304893846231245658e-6 * t347 * t51 / t35 / t4 / t3 * t716 * t720 + 0.10845809917971164245941154483102358190738049565141e-1 * t702 / t36 / t3 * t704 * t706
  t752 = -t122 * t262 / 0.192e3 - t212 * t282 / 0.9216e4 - t33 * t173 * t88 * t98 / 0.2654208e7 + 0.9e1 / 0.128e3 * t208 * t128 + 0.9e1 / 0.64e2 * t140 * t182 + t212 * t113 / 0.1024e4 - t10 * t139 * t99 / 0.2654208e7 - t2 / t7 / t629 * t32 * t77 / t87 / t85 * t91 * t90 / t638 / t56 / 0.764411904e9 + 0.3e1 / 0.64e2 * t122 * t182 - 0.15e2 / 0.32e2 * t140 * t278 - 0.3e1 / 0.8e1 * t289 * t31 * t745 * t293 - t320 * t299 / 0.2e1
  t756 = t24 ** 2
  t759 = t194 ** 2
  t765 = t202 ** 2
  t774 = -0.24e2 * t311 + 0.24e2 * t21 / t310 / t11
  t775 = f.my_piecewise5(t15, 0, t19, 0, t774)
  t779 = f.my_piecewise3(t25, 0, 0.40e2 / 0.81e2 / t192 / t756 * t759 - 0.16e2 / 0.9e1 * t303 * t194 * t202 + 0.4e1 / 0.3e1 * t193 * t765 + 0.16e2 / 0.9e1 * t307 * t315 + 0.4e1 / 0.3e1 * t28 * t775)
  t802 = 0.1e1 / t119 / t197
  t813 = -0.3e1 / 0.2e1 * t297 * t331 + t329 * t339 - 0.3e1 / 0.8e1 * t288 * t779 * t322 - 0.3e1 / 0.2e1 * t320 * t326 + t289 * t270 * t260 * t293 / 0.2e1 - 0.3e1 / 0.2e1 * t329 * t416 - 0.9e1 / 0.4e1 * t297 * t335 - 0.3e1 / 0.2e1 * t329 * t343 - 0.5e1 / 0.9e1 * t329 * t294 - 0.5e1 / 0.9e1 * t289 * t291 * t173 * t293 + 0.10e2 / 0.27e2 * t289 * t802 * t77 * t293 + t297 * t420 / 0.2e1 - t289 * t120 * t414 * t293 / 0.2e1
  t816 = f.my_piecewise3(t1, 0, t568 + t610 + t752 + t813)
  t817 = t429 ** 2
  t820 = t437 ** 2
  t826 = t444 ** 2
  t832 = f.my_piecewise5(t19, 0, t15, 0, -t774)
  t836 = f.my_piecewise3(t430, 0, 0.40e2 / 0.81e2 / t432 / t817 * t820 - 0.16e2 / 0.9e1 * t434 * t437 * t444 + 0.4e1 / 0.3e1 * t441 * t826 + 0.16e2 / 0.9e1 * t442 * t448 + 0.4e1 / 0.3e1 * t431 * t832)
  t851 = f.my_piecewise3(t427, 0, -0.3e1 / 0.8e1 * t288 * t836 * t496 - t453 * t507 / 0.2e1 + t505 * t515 / 0.2e1 - 0.5e1 / 0.9e1 * t513 * t522 + 0.10e2 / 0.27e2 * t520 * t802 * t486 * t495)
  d1111 = 0.4e1 * t425 + 0.4e1 * t526 + t11 * (t816 + t851)

  res = {'v4rho4': d1111}
  return res
